#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "InitRequest.h"

using namespace sdv;

#define DONT_CARE 0x99
#define GROUP_ID 0x21,0x34,0x56,0x15

using ::testing::Test;

class InitRequestTest : public Test{
public:
    void SetUp(){
        group_id = 0x21345615;
    }

    const static uint8_t TEST_BUFFER[32];
    uint32_t group_id;
};
const uint8_t InitRequestTest::TEST_BUFFER[32] = { 0x11,
        0x04,
        0x80,0x01,  // messageId
        DONT_CARE,DONT_CARE,DONT_CARE,DONT_CARE,    // transactionId
        DONT_CARE,  // reserved
        0x00,       // adaptationLength
        0x00,0x14,  // messageLength
        0x11,0x22,0x33,0x44,0x55,0x66,  // session mac
        0xff,       // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,      // unused session data
        DONT_CARE,DONT_CARE,    // reserved
        GROUP_ID,
        0x00,       // version
        DONT_CARE,  // reserved
        0,0 };      // numDesc

TEST_F(InitRequestTest, OutboundMessageTest) {
	SDVMessage::MessageId msgId = SDVMessage::InitRequest;
	uint8_t buff[512];
	uint8_t test_mac[] = {0x11,0x22,0x33,0x44,0x55,0x66};
	SDVMessage* msg = new InitRequest(test_mac, group_id);

    size_t buffLen = msg->serialize(buff, sizeof(buff));
	ASSERT_EQ(buffLen, sizeof(TEST_BUFFER));

    	// Verify raw message data
	for (int i = 0; i < buffLen; ++i) {
		if (TEST_BUFFER[i] == DONT_CARE) continue;
			ASSERT_EQ(buff[i], TEST_BUFFER[i]);
	}
	delete msg;
}
