#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "ProgramSelectIndication.h"

using namespace sdv;

#define DONT_CARE 0x99

#define MAC 0x88,0x77,0x66,0x55,0x44,0x33

#define SOURCEID_HEX  0x22,0x31,0x52,0x12
#define SOURCEID_INT 0x22315212

#define CURRENT_SOURCEID_HEX 0xaa,0xbb,0xcc,0xdd
#define CURRENT_SOURCEID_INT 0xaabbccdd

#define GROUP_ID_HEX 0x21,0x34,0x56,0x15
#define GROUP_ID_INT 0x21345615

#define TUNER_USE 0x9
#define TUNER_INDEX 0x3

#define LAST_ACTIVITY_HEX 0x12,0x34,0x56,0x78
#define LAST_ACTIIVITY_INT 0x12345678

#define TRANSACTION_ID_HEX 0x11,0x22,0x33,0x44
#define TRANSACTION_ID_INT 0x11223344

#define REASON_CODE_HEX 0x80,0x01
#define REASON_CODE_INT 0x8001

#define FREQ_HEX 0x23,0x43,0xA1,0xB2
#define FREQ_INT 0x2343A1B2

#define PROGNUM_HEX 0x22, 0x13
#define PROGNUM_INT 0x2213

#define MODULATION 0x10


using ::testing::Test;

using namespace sdv;

class ProgramSelectIndicationTest : public Test {

};

static uint8_t TEST_BUFFER_IN[] = {
		0x11,
        0x04,
        0x00,0x03,                      // messageId
        TRANSACTION_ID_HEX,   			// transactionId
        DONT_CARE,                      // reserved
        0x00,                           // adaptationLength
        0x00,0x18,                      // messageLength
        MAC,  							// session mac
        TUNER_INDEX,                    // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,  // unused session data
        REASON_CODE_HEX,
        SOURCEID_HEX,
        0x00,0x0e,						// private data length
        DONT_CARE,						// reserved
        MODULATION,
        FREQ_HEX,
        PROGNUM_HEX,
        DONT_CARE,DONT_CARE,			// reserved
        CURRENT_SOURCEID_HEX};

TEST_F(ProgramSelectIndicationTest, InboundMessageTest) {

	ProgramSelectIndication* msg = new ProgramSelectIndication((unsigned char*)TEST_BUFFER_IN);

    ASSERT_EQ(msg->getMessageId(), SDVMessage::ProgramSelectIndication);
    ASSERT_EQ(msg->getTransactionId(), TRANSACTION_ID_INT);
    ASSERT_EQ(msg->getTunerIndex(), TUNER_INDEX);
    ASSERT_EQ(msg->getSourceId(), SOURCEID_INT);
    ASSERT_EQ(msg->getCurrentSourceId(), CURRENT_SOURCEID_INT);
    ASSERT_EQ(msg->getFrequency(), FREQ_INT);
    ASSERT_EQ(msg->getModulation(), MODULATION);
    ASSERT_EQ(msg->getMpegProgramNumber(), PROGNUM_INT);
    ASSERT_EQ(msg->getReason(), REASON_CODE_INT);

	delete msg;
}
