

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "ProgramSelectRequest.h"

using namespace sdv;

#define DONT_CARE 0x99

#define RETRY_COUNT 0x05

#define SOURCEID_HEX  0x22,0x31,0x52,0x12
#define SOURCEID_INT 573657618

#define GROUP_ID_HEX 0x21,0x34,0x56,0x15
#define GROUP_ID_INT 0x21345615

#define PRIVATE_DATA_LENGTH_HEX 0x00,0x06
#define PRIVATE_DATA_LENGTH_INT 6

#define TUNER_USE 0x9

#define TUNER_INDEX 0x3

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include <stdio.h>

using ::testing::Test;

namespace sdv {

class ProgramSelectRequestTest : public Test{
public:
    const static uint8_t TEST_BUFFER[36];
};

const uint8_t ProgramSelectRequestTest::TEST_BUFFER[36] = { 0x11,
        0x04,
        0x00,0x01,                                  // messageId
        DONT_CARE,DONT_CARE,DONT_CARE,DONT_CARE,    // transactionId
        DONT_CARE,                      // reserved
        0x00,                           // adaptationLength
        0x00,0x18,                      // messageLength
        0x11,0x22,0x33,0x44,0x55,0x66,  // session mac
        TUNER_INDEX,                           // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,  // unused session data
        0x05,                       // Retry Count
        DONT_CARE,                  //Reserved
        SOURCEID_HEX,               // SOURCEID
        PRIVATE_DATA_LENGTH_HEX,    // Private data length
        TUNER_USE,                  // Tuner Use
        DONT_CARE,                  // Reserved
        GROUP_ID_HEX};              // Service Group ID
};

TEST_F(ProgramSelectRequestTest, OutboundMessageTest) {
    SDVMessage::MessageId msgId = SDVMessage::ProgramSelectRequest;
    uint8_t buff[512];
    uint8_t test_mac[] = {0x11,0x22,0x33,0x44,0x55,0x66};
    SDVMessage* msg = new ProgramSelectRequest(test_mac, TUNER_INDEX, TUNER_USE,RETRY_COUNT, SOURCEID_INT, GROUP_ID_INT);

    size_t buffLen = msg->serialize(buff, sizeof(buff));
    ASSERT_EQ(buffLen, sizeof(TEST_BUFFER));

    // Verify raw message data
    for (int i = 0; i < buffLen; ++i) {
        if (TEST_BUFFER[i] == DONT_CARE) continue;
        ASSERT_EQ(buff[i], TEST_BUFFER[i]);
    }
    delete msg;
}
