/**
 * @file ConfigurationParser_mock.cc
 *
 * @date Jun 20, 2014
 * @author Spencer Gilroy (sgilroy@cisco.com)
 **/

#include "ConfigurationParser.h"
#include "gmock/gmock.h"
#include <string>
#include <string.h>

using namespace sdv;
class MockConfigurationParser : public ConfigurationParser {
public:
    MockConfigurationParser(IARMProxyService* iarmProxy, SDVEventQueue* eventQueue, void* userData, MCP_UPDATE_NOTIFY userCallback)
    : ConfigurationParser(iarmProxy, eventQueue,userData, userCallback ) { }

    MOCK_METHOD0(start,void());
    MOCK_METHOD0(stop,void());
    MOCK_METHOD0(getServerIpString, std::string());
    MOCK_METHOD0(getServerIpPort, uint16_t());
    MOCK_METHOD0(getServiceGroupId, uint32_t());
    MOCK_METHOD0(getLastUserActivityReportInterval, uint32_t());
    MOCK_METHOD0(getMiniCarouselReadInterval, uint32_t());
    MOCK_METHOD0(getMessageResponseTimeout, uint32_t());
    MOCK_METHOD0(getMessageRequestMaxRetries, uint32_t());
    MOCK_METHOD0(getMessageRequestRetryInterval, uint32_t());
    MOCK_METHOD0(getBandwidthReclaimUITimeout, uint32_t());
    MOCK_METHOD0(getStbMac, uint8_t*());
};
