/**
 * @file MessageService_mock.cc
 *
 * @date Jun 19, 2014
 * @Author Spencer Gilroy (sgilroy@cisco.com)
 **/

#include "MessageService.h"
#include "gmock/gmock.h"
#include "SDVMessage.h"

#include<pthread.h>

using namespace sdv;
class MockMessageService : public sdv::MessageService {

public:
    MockMessageService(ConfigurationParser * _configParser, SDVEventQueue *  _eventQueue) : MessageService(_configParser, _eventQueue) { }

    MOCK_METHOD0(start, sdv::SDVService::SERVICE_RESULT());
    MOCK_METHOD0(stop,  sdv::SDVService::SERVICE_RESULT());
    MOCK_METHOD4(sendMessage, void(SDVMessage * msg, SDV_MESSAGE_CALLBACK_t callback, void* ptrInst, uint32_t delay));

private:

    SDVMessage* response;
    REPONSE_STATUS_t status;
    void* callbackInstance;
    MessageService::SDV_MESSAGE_CALLBACK_t callbackFunction;

public:
    // Data saved for verifying sent message
    SDVMessage::MessageId sentMsgId;
    int sentMsgTunerIndex;

    void setResponse(REPONSE_STATUS_t responseStatus, sdv::SDVMessage * responseMessage ){
        response = responseMessage;
        status = responseStatus;
    }

    void sendMessageAction(SDVMessage * msg, MessageService::SDV_MESSAGE_CALLBACK_t callback, void* ptrInst, uint32_t delay) {
    	sentMsgId = msg->getMessageId();
    	sentMsgTunerIndex = msg->getTunerIndex();

    	if(callback != NULL){
            callbackInstance = ptrInst;
            callbackFunction = callback;

            pthread_t thread_id;
            int rc = pthread_create(&thread_id, NULL, doCallback, this);
        }
    }


private:
   static void *doCallback(void * in){
       MockMessageService * inst = (MockMessageService*) in;
        inst->callbackFunction(inst->callbackInstance, inst->status, inst->response);
    }
};
