/**
 * @file MessageService_mock.cc
 *
 * @date Jun 19, 2014
 * @Author Jason Bedard(jasbedar@cisco.com)
 **/

#include "SDVEventQueue.h"
#include "gmock/gmock.h"


class MockSDVEventQueue: public sdv::SDVEventQueue {

public:
	MockSDVEventQueue() : sdv::SDVEventQueue() {
		thread_id = 0;
	}

	~MockSDVEventQueue() {
		printf("MockSDVEventQueue.destructor()\n");
		if (thread_id != 0) {
			printf("MockSDVEventQueue.destructor() cancel thread\n");
			pthread_cancel(thread_id);
		}
	}

	MOCK_METHOD0(start, sdv::SDVService::SERVICE_RESULT());
	MOCK_METHOD0(stop, sdv::SDVService::SERVICE_RESULT());
	MOCK_METHOD4(push, TASK_ID_t(void* ptrInstance, SDV_EVENT_CALLBACK_t callback, void * data, uint32_t timeout_ms));

	// Fires event on different thread without time delay
	TASK_ID_t pushAction(void* ptrInstance, SDV_EVENT_CALLBACK_t callback, void * data, uint32_t timeout_ms) {
		callbackInstance = ptrInstance;
		callbackFunction = callback;
		userData = data;
		if (timeout_ms > 0) {
			printf("MockSDVEventQueue.push: msec timeout=%d\n", timeout_ms);
		}
		timeoutNsec = timeout_ms * 1000;

		int rc = pthread_create(&thread_id, NULL, doCallback, this);
	}

private:

	void* userData;
	void* callbackInstance;
	SDVEventQueue::SDV_EVENT_CALLBACK_t callbackFunction;
	uint32_t timeoutNsec;
	pthread_t thread_id;


	static void *doCallback(void * arg) {
		MockSDVEventQueue* inst = (MockSDVEventQueue *)arg;
		if (inst->timeoutNsec > 0) {
			usleep(inst->timeoutNsec);
		}
		printf("MockSDVEventQueue.doCallback: callback=%d\n", inst->callbackInstance);
		inst->callbackFunction(0, inst->callbackInstance, inst->userData);
	}

};
