DESCRIPTION = "Broadcom Linux Kernel"
SECTION = "kernel"
LICENSE = "GPLv2"

DEFAULT_PREFERENCE = "-1"

FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

LIC_FILES_CHKSUM = "file://COPYING;md5=d7810fab7487fb0aad327b76f1be7cd7" 

SRC_URI += "https://${NEXUS_BROADCOM_BASE_SHARED}/linux/4_9-1_19/stblinux-4.9-1.19/2.1/stblinux-4.9-1.19-2.1.tar.bz2 \
            file://cgroups.cfg \
            file://unifying_moca_interface_name.patch \
            file://stblinux-4.9.patch;striplevel=2 \
            file://inet.cfg \
            file://ipsec.cfg \
            file://netfilter.cfg \
            file://overlay.cfg \
            file://boops.patch;striplevel=1 \
            file://stblinux_watchdog_nmi.patch;striplevel=1 \
            file://9996-fs_squashfs_improve_squashfs_error_resistance.patch;striplevel=1 \
	    file://nand_driver_dma_fix.patch;striplevel=2 \
            file://SWLINUX-5609.patch \
            file://SWLINUX-5855.patch \
            file://mmc_legacy_compatibility.patch \
            file://stblinux-4.9.cfg \
            file://nfsdisable.cfg \
            file://disable_cdrom_fs.cfg \
            file://ecryptfs.cfg \
            file://dm_crypt.cfg \
            file://stblinux_disable_pcie_powersave.cfg \
            file://CVE-2020-12352-12351.patch \
            file://cfg80211_HE.patch \
            file://avoid_pcie_shutdown_on_reboot.patch \
            file://reboot_info.patch \
"
# enable zram module
SRC_URI_append_rdkzram += "\
    file://zram.cfg \
"

SRC_URI_append = " \
    file://bluetooth.cfg \
"
#Game Controller support
SRC_URI_append += "\
    file://0001-RDK-37394-upstream-4-10-hid-sony-fixes.patch \
    file://0002-RDK-37394-upstream-4-12-hid-sony-fixes.patch \
    file://0003-RDK-37394-report-DS4-version-info-through-sysfs.patch \
    file://0004-RDK-37394-use-devm_api-to-simplify-sony_leds_init.patch \
    file://0005-RDK-37394-fix-race-condition-between-rumble-and-device-remove.patch \
    file://0006-RDK-37394-fix-memory-corruption-issue-on-cleanup.patch \
    file://0007-RDK-37394-fix-for-broken-buttons-on-DS3-USB-dongles.patch \
    file://0008-RDK-37394-sony-dualsense-PS5-support.patch \
    file://0009-RDK-37394-exclude-PS5-controller-from-hid-generic.patch \
    file://0010-RDK-37394-fix-to-remove-noise-events-ps-controllers.patch \
    file://0011-RDK-37392-fix-for-xbox-mapping.patch \
    file://0012-RDK-37392-fix-for-xbox-pairing-issue.patch \
    file://0013-RDK-37394-fix-for-playstation-mapping.patch \
"

SRC_URI[md5sum] = "0cd23126738b0a0685db9e943f9f6893"
SRC_URI[sha256sum] = "52075bb6cb27dcdc8225fe0636cbe7aa9a5f6d107bf8bc4672456cdfdbe9fa3b"

COMPATIBLE_HOST = "arm.*"

KERNEL_VERSION = "4.9-1.19"
KERNEL_MAJOR_VERSION = "4.9"

LINUX_VERSION ?= "4.9"
LINUX_VERSION_EXTENSION ?= "-brcm"

DEPENDS += "xz-native bc-native lzop-native"

inherit kernel

S = "${WORKDIR}/linux"

do_configure_prepend () {
	# copy desired defconfig so we pick it up for the real kernel_do_configure
	sh ${S}/scripts/kconfig/merge_config.sh -m ${KERNEL_DEFCONFIG} `ls ${WORKDIR}/*.cfg 2>/dev/null`
	mv .config ${WORKDIR}/defconfig
}

KERNEL_CONFIG_COMMAND ?= "oe_runmake oldnoconfig || yes '' | oe_runmake oldconfig"

kernel_do_configure() {
	touch ${B}/.scmversion ${S}/.scmversion
	# Copy defconfig to .config if .config does not exist. This allows
	# recipes to manage the .config themselves in do_configure_prepend().
	if [ -f "${WORKDIR}/defconfig" ] && [ ! -f "${B}/.config" ]; then
		cp "${WORKDIR}/defconfig" "${B}/.config"
	fi
	eval ${KERNEL_CONFIG_COMMAND}
}
# Many scripts want to look in arch/$arch/boot for the bootable
# image. This poses a problem for vmlinux based booting. This
# task arranges to have vmlinux appear in the normalized directory
# location.

do_kernel_link_vmlinux() {
	if [ ! -d "${B}/arch/${ARCH}/boot" ]; then
		mkdir ${B}/arch/${ARCH}/boot
	fi
	cd ${B}/arch/${ARCH}/boot
	ln -sf ../../../vmlinux
}

addtask kernel_link_vmlinux after do_compile before do_install
RDEPENDS_kernel-base = ""
INHIBIT_PACKAGE_STRIP = "1"
