/***************************************************************************
 *     (c)2007-2013 Broadcom Corporation
 *
 *  This program is the proprietary software of Broadcom Corporation and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 *
 ***************************************************************************/
#ifndef __bcmnexus_ir_keycodes_cirnec_H__
#define __bcmnexus_ir_keycodes_cirnec_H__

#include "bcmnexus_ir_keycodes.h"

/*
** IR receiver key code maps.
**
** The "hwEventCode"s  in the following table are the values generated by the "Broadcom" remote
** that is bundled with the BCM935230 reference platform.
**
** The  "DIKS_xxx" constants are for the basic keyboard mapping (defined in "Directfb_keyboard.h").
** The  "DIKI_xxx" constants are for the advanced keyboard mapping.
*/

static const KeyMapElement IrBasicCodeMap [] =
{
    { DIKI_0,       0xad52ff00 },   /* should these be the DIKI_KP_xxx constants? */
    { DIKI_1,       0xe01fff00 },
    { DIKI_2,       0xa15eff00 },
    { DIKI_3,       0xa05fff00 },
    { DIKI_4,       0xe41bff00 },
    { DIKI_5,       0xa55aff00 },
    { DIKI_6,       0xa45bff00 },
    { DIKI_7,       0xe817ff00 },
    { DIKI_8,       0xa956ff00 },
    { DIKI_9,       0xa857ff00 },
    { DIKI_LEFT,    0xf40bff00 },
    { DIKI_RIGHT,   0xb649ff00 },
    { DIKI_DOWN,    0xf30cff00 },
    { DIKI_UP,      0xb14eff00 },
    { DIKI_ENTER,   0xf708ff00 },   /* the select key on the remote */
    { DIKI_ESCAPE,  0xb24dff00 }    /* the clear key on the remote */
};

static const KeyMapElement IrAdvanCodeMap [] =
{
    { DIKS_0,               0xad52ff00 },
    { DIKS_1,               0xe01fff00 },
    { DIKS_2,               0xa15eff00 },
    { DIKS_3,               0xa05fff00 },
    { DIKS_4,               0xe41bff00 },
    { DIKS_5,               0xa55aff00 },
    { DIKS_6,               0xa45bff00 },
    { DIKS_7,               0xe817ff00 },
    { DIKS_8,               0xa956ff00 },
    { DIKS_9,               0xa857ff00 },
    { DIKS_CURSOR_LEFT,     0xf40bff00 },
    { DIKS_CURSOR_RIGHT,    0xb649ff00 },
    { DIKS_CURSOR_DOWN,     0xf30cff00 },
    { DIKS_CURSOR_UP,       0xb14eff00 },
    { DIKS_CHANNEL_UP,      0xf609ff00 },
    { DIKS_CHANNEL_DOWN,    0xf20dff00 },
    { DIKS_SELECT,          0xf708ff00 },
    { DIKS_EXIT,            0xb24dff00 },
    { DIKS_ENTER,           0xec13ff00 },
    { DIKS_PERIOD,          0xac53ff00 },
    { DIKS_MENU,            0xb04fff00 },
    { DIKS_EPG,             0xf10eff00 },
    { DIKS_POWER,           0xf50aff00 },
    { DIKS_INFO,            0xf00fff00 },
    { DIKS_MUTE,            0xfe01ff00 },
    { DIKS_LAST,            0xf906ff00 },
    { DIKS_REWIND,          0xe619ff00 },
    { DIKS_FORWARD,         0xa659ff00 },
    { DIKS_PLAY,            0xe21dff00 },
    { DIKS_RECORD,          0xab54ff00 },
    { DIKS_PAUSE,           0xe31cff00 },
    { DIKS_STOP,            0xa35cff00 },
    { DIKS_PREVIOUS,        0xa758ff00 },
    { DIKS_NEXT,            0xe718ff00 },
    { DIKS_FAVORITES,       0xfd02ff00 }, /* FAV1 */
    { DIKS_CUSTOM3,         0xfc03ff00 }, /* FAV2 */
    { DIKS_CUSTOM4,         0xbd42ff00 }, /* FAV3 */
    { DIKS_CUSTOM5,         0xbc43ff00 }, /* FAV4 */
    { DIKS_VOLUME_UP,       0xb748ff00 },
    { DIKS_VOLUME_DOWN,     0xb34cff00 },
    { DIKS_MODE,            0xb54aff00 }, /* Source */
    { DIKS_TV,              0xb44bff00 }, /* WatchTV */
    { DIKS_SCREEN,          0xe11eff00 }, /* Picture */
    { DIKS_ZOOM,            0xe51aff00 }, /* Aspect */
    { DIKS_TEXT,            0xb847ff00 },
    { DIKS_INTERNET,        0xf807ff00 }, /* Apps */
    { DIKS_AUDIO,           0xbe41ff00 },
    { DIKS_VIDEO,           0xba45ff00 },
    { DIKS_SUBTITLE,        0xbf40ff00 },
    { DIKS_RADIO,           0xfa05ff00 },
    { DIKS_RED,             0xaf50ff00 },
    { DIKS_GREEN,           0xef10ff00 },
    { DIKS_YELLOW,          0xee11ff00 },
    { DIKS_BLUE,            0xae51ff00 },
    { DIKS_PIP,             0xe916ff00 },
    { DIKS_SWAP,            0xed12ff00 },
    { DIKS_FREEZE,          0xbb44ff00 }
};

#endif
