/***************************************************************************
 *    (c)2005-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 ***************************************************************************/

#ifndef __CORE__BCMNEXUS_H__
#define __CORE__BCMNEXUS_H__

#include "bcm_config.h"
#include "dfb_types.h"
#include "directfb_version.h"
#include "core/surface_pool.h"
#include "gfx/convert.h"

#include "platform_init.h"
#include "bcmnexus_sys_defines.h"
#include "nexus_surface.h"
#ifdef NEXUS_HAS_PICTURE_DECODER
#include "nexus_picture_decoder.h"
#endif

/* If updating any of the APIs or making any radical changes please rev the major version number.
   Any functional changes or bug fixes please upadte the minor version number */

#define BCMNEXUS_SYS_MAJOR_VERSION 5
#define BCMNEXUS_SYS_MINOR_VERSION 1

/* Macros to get/set fields in the shared DFBBCMNEXUS structure */
#define SET_DISPLAY_NUM_GFX_LAYERS( BCMNEXUS_PTR, val, id)      (BCMNEXUS_PTR->displays[id].numGfxLayers = val)
#define SET_DISPLAY_GFX_LAYER_ID(   BCMNEXUS_PTR, val, idx, id) (BCMNEXUS_PTR->displays[id].gfxLayerIds[idx] = val)
#define SET_DISPLAY_VID_LAYER_ID(   BCMNEXUS_PTR, val, idx, id) (BCMNEXUS_PTR->displays[id].vidLayerIds[idx] = val)
#define SET_DISPLAY_HND(            BCMNEXUS_PTR, val, id)      (BCMNEXUS_PTR->displays[id].hDisplay = val)
#define SET_DISPLAY_VSYNC_CB(       BCMNEXUS_PTR, val, id)      (BCMNEXUS_PTR->displays[id].vsyncCallback = val)

#define GET_DISPLAY_NUM_GFX_LAYERS( BCMNEXUS_PTR, id)           (BCMNEXUS_PTR->displays[id].numGfxLayers)
#define GET_DISPLAY_GFX_LAYER_ID(   BCMNEXUS_PTR, idx, id)      (BCMNEXUS_PTR->displays[id].gfxLayerIds[idx])
#define GET_DISPLAY_VID_LAYER_ID(   BCMNEXUS_PTR, idx, id)      (BCMNEXUS_PTR->displays[id].vidLayerIds[idx])
#define GET_DISPLAY_HND(            BCMNEXUS_PTR, id)           (BCMNEXUS_PTR->displays[id].hDisplay)
#define GET_DISPLAY_VSYNC_MUTEX(    BCMNEXUS_PTR, id)           (BCMNEXUS_PTR->displays[id].vsyncMutex)
#define GET_DISPLAY_VSYNC_SEM(      BCMNEXUS_PTR, id)           (BCMNEXUS_PTR->displays[id].vsyncSem)
#define GET_DISPLAY_VSYNC_CB(       BCMNEXUS_PTR, id)           (BCMNEXUS_PTR->displays[id].vsyncCallback)

#if NEXUS_HAS_PICTURE_DECODER
#define SET_PICTURE_DECODER_HND(    BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->pictureDecoder = val)
#define GET_PICTURE_DECODER_HND(    BCMNEXUS_PTR)               (BCMNEXUS_PTR->pictureDecoder)
#define SET_PICTURE_DECODER_LOCK(   BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->pictureDecoderLock = val)
#define GET_PICTURE_DECODER_LOCK(   BCMNEXUS_PTR)               (BCMNEXUS_PTR->pictureDecoderLock)
#endif

#define SET_GRAPHICS2Dn_HND(        BCMNEXUS_PTR, val, n)       (BCMNEXUS_PTR->hGfx2Ds[n] = val)
#define SET_GRAPHICS2Dn_SYNC(       BCMNEXUS_PTR, val, n)       (BCMNEXUS_PTR->gfx2DSyncs[n] = val)
#define GET_GRAPHICS2Dn_HND(        BCMNEXUS_PTR, n)            (BCMNEXUS_PTR->hGfx2Ds[n])
#define GET_GRAPHICS2Dn_SYNC(       BCMNEXUS_PTR, n)            (BCMNEXUS_PTR->gfx2DSyncs[n])

#define SET_POOL_HND(               BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->pool = val)
#define GET_POOL_HND(               BCMNEXUS_PTR)               (BCMNEXUS_PTR->pool)

#define SET_GFX3D_POOL_HND(         BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->gfx3dPool = val)
#define GET_GFX3D_POOL_HND(         BCMNEXUS_PTR)               (BCMNEXUS_PTR->gfx3dPool)

#define SET_DISPLAY_HEAP_HND(       BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->displayHeap = val)
#define GET_DISPLAY_HEAP_HND(       BCMNEXUS_PTR)               (BCMNEXUS_PTR->displayHeap)

#define SET_2ND_DISPLAY_HEAP_HND(   BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->secondaryDisplayHeap = val)
#define GET_2ND_DISPLAY_HEAP_HND(   BCMNEXUS_PTR)               (BCMNEXUS_PTR->secondaryDisplayHeap)


#define SET_OFFSCREEN_HEAP_HND(     BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->offscreenHeap = val)
#define GET_OFFSCREEN_HEAP_HND(     BCMNEXUS_PTR)               (BCMNEXUS_PTR->offscreenHeap)

#define SET_PALETTE_HEAP_HND(       BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->paletteHeap = val)
#define GET_PALETTE_HEAP_HND(       BCMNEXUS_PTR)               (BCMNEXUS_PTR->paletteHeap)

#define SET_CALL_HANDLER(           BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->call = val)
#define GET_CALL_HANDLER(           BCMNEXUS_PTR)               (BCMNEXUS_PTR->call)
#define SET_VIDEO_HEAP_HND(         BCMNEXUS_PTR, val)          (BCMNEXUS_PTR->videoHeap = val)
#define GET_VIDEO_HEAP_HND(         BCMNEXUS_PTR)               (BCMNEXUS_PTR->videoHeap)

/*** Definitions ***/
#define PRIMARY_DISPLAY_ID          (DSCID_PRIMARY)
#define SECONDARY_DISPLAY_ID        (PRIMARY_DISPLAY_ID + 1)
#define TERTIARY_DISPLAY_ID         (SECONDARY_DISPLAY_ID + 1)

#define PRIMARY_GFX_LAYER_INDEX     (0)
#define SECONDARY_GFX_LAYER_INDEX   (PRIMARY_GFX_LAYER_INDEX + 1)

#define PRIMARY_VID_LAYER_INDEX     (0)
#define SECONDARY_VID_LAYER_INDEX   (PRIMARY_VID_LAYER_INDEX + 1)

typedef enum {
     BCM_POOL_MEMORY_ALLOCATE,
     BCM_POOL_MEMORY_FREE,
     BCM_POOL_SURFACE_CREATE,
     BCM_POOL_SURFACE_DESTROY,
     BCM_LAYER_SET_GFX_FRAMEBUFFER,
     BCM_LAYER_SET_GFX_SETTINGS,
     BCM_SCREEN_SET_DISPLAY_SETTINGS,
     BCM_SCREEN_ENABLE_DISPLAY_OUTPUT
} eBcmCall;

/* These structures are shared amongst the different processes that interface with DFB */
typedef struct {
    int                        numGfxLayers;
    DFBDisplayLayerID          gfxLayerIds[NUM_GFX_LAYERS_PER_DISPLAY];
    DFBDisplayLayerID          vidLayerIds[NUM_VID_LAYERS_PER_DISPLAY];
    DFB_PlatformNexusHandle    hDisplay;
    DFBDimension               size;
    pthread_mutex_t            vsyncMutex;
    pthread_cond_t             vsyncSem;
    void                     (*vsyncCallback) (void *context, int param);
} BCMNEXUS_Display;

typedef struct  {

        /* Setting the IR or keypad timeout to 0 will result in the driver generating both a KEYPRESS and KEYRELEASED
           event each time a button/key is pressed.  This is no longer the default bahviour.  Instead, when a key is
           pressed only a KEYPRESS event will be generated.  If the key is released, then a KEYRELEASED event will
           be generated after the timeout specified below. This is the default behaviour and mimicks the way
           events are generated for HID devices such as a keyboard or mouse. */
    unsigned int  bcmnexus_ir_timeout;           /* IR KEYRELEASED event generation timeout in ms */
    unsigned int  bcmnexus_key_timeout;          /* KEYPAD KEYRELEASED event generation timeout in ms */

        /* Setup the IR and Keypad repeat filter time (in ms).  Key presses received less than this value will
           be treated as repeats. */
    unsigned int  bcmnexus_ir_repeat_time;       /* IR repeat time in ms */
    unsigned int  bcmnexus_key_repeat_time;      /* KEYPAD repeat time in ms */

    unsigned int  bcmnexus_key_debounce;         /* Specify the KEYPAD debounce count */
    unsigned int  bcmnexus_ir_repeat_skip;       /* Specify the number of initial IR repeats to skip/dismiss */
    unsigned int  bcmnexus_key_repeat_skip;      /* Specify the number of initial KEYPAD repeats to skip/dismiss */
    char         *bcmnexus_ir_protocol;          /* Specify IR protocol */
    char         *bcmnexus_ir_keycodes;          /* Specify IR keycodes module*/

    bool          sw_picture_decode;

    char         *res;                           /* alternative representation
                                                    of screen size */

    /*platforms with no vertical GFD scalers and memory BW limitations, to get 1080p output, FB needs to be customized using ibuffer config option */
    struct {
        int                   width;            /* Intermediate buffer width*/
        int                   height;           /* Intermediate buffer height*/
    } ibuffer;

} BCMNEXUS_Options;

typedef struct  {
    BCMNEXUS_Display           displays[NUM_DISPLAYS+1];/* Handles to primary, secondary displays and video layer display */
    BCMNEXUS_Options           options;                 /* Command line options specific to Broadcom driver */
    NEXUS_Graphics2DHandle     hGfx2D;                  /* Graphics 2D/blitter handle */
    bool                       gfx2DSync;               /* Flag to indicate whether we need to issue checkpoint/sync */
    NEXUS_Graphics2DHandle     hGfx2Ds[2];              /* TWO Graphics 2D/blitter handle */
    bool                       gfx2DSyncs[2];           /* TWO Flag to indicate whether we need to issue checkpoint/sync */
#ifdef NEXUS_HAS_PICTURE_DECODER
    NEXUS_PictureDecoderHandle pictureDecoder;          /* Picture decoder handle*/
    pthread_mutex_t            pictureDecoderLock;      /* Picture decoder global access lock */
#endif
    FusionCall                 call;
    CoreSurfacePool           *pool;                    /* 'virtual' pool, to link NEXUS <> DFB surfaces */
    CoreSurfacePool           *gfx3dPool;               /* 'virtual' pool, to link NEXUS <> DFB surfaces */
    NEXUS_HeapHandle           displayHeap;             /* Index of which Nexus Heap to use for Graphics Surfaces */
    NEXUS_HeapHandle           secondaryDisplayHeap;    /* Index of which Nexus Heap to use for Graphics Surfaces on secondary display*/
    NEXUS_HeapHandle           offscreenHeap;           /* Index of Nexus Heap to use for offscreen Graphics Surfaces */
    NEXUS_HeapHandle           paletteHeap;             /* Index of  Nexus Heap to use for pallettes*/
    NEXUS_HeapHandle           videoHeap;               /* Index of  Nexus Heap to use for video based graphics surfaces*/
    int                        heapSize;                /* Total useable size of the display heap */
} DFBBCMNEXUS;

extern CoreDFB *dfb_bcmnexus_core;                      /* Local for each process that joins DirectFB */

#ifdef __GNUC__
#define UNUSED_ __attribute__ ((unused))
#else
#define UNUSED_
#endif

#define BCM_DFB_USE_SURFACE_SET_STEREO_EYE ((DIRECTFB_MAJOR_VERSION * 1000000 + \
                                             DIRECTFB_MINOR_VERSION * 1000 + \
                                             DIRECTFB_MICRO_VERSION) < 1006000)

#define BCM_DFB_SURFACE_CREATE_WITH_HINT   ((DIRECTFB_MAJOR_VERSION * 1000000 + \
                                             DIRECTFB_MINOR_VERSION * 1000 + \
                                             DIRECTFB_MICRO_VERSION) < 1006000)

#define BCM_DFB_USE_TASK_MANAGER           ((DIRECTFB_MAJOR_VERSION * 1000000 + \
                                             DIRECTFB_MINOR_VERSION * 1000 + \
                                             DIRECTFB_MICRO_VERSION) >= 1007000)

#define BCM_DFB_NATIVE_GFX_SPAN_SUPPORT    ((DIRECTFB_MAJOR_VERSION * 1000000 + \
                                             DIRECTFB_MINOR_VERSION * 1000 + \
                                             DIRECTFB_MICRO_VERSION) >= 1007000)

#define BCM_DFB_USE_BATCH_STRETCH_BLIT     ((DIRECTFB_MAJOR_VERSION * 1000000 + \
                                             DIRECTFB_MINOR_VERSION * 1000 + \
                                             DIRECTFB_MICRO_VERSION) >= 1007000)

#define BCM_DFB_USE_NOTIFY_DISPLAY_THREAD  ((DIRECTFB_MAJOR_VERSION * 1000000 + \
                                             DIRECTFB_MINOR_VERSION * 1000 + \
                                             DIRECTFB_MICRO_VERSION) <  1007000)

#endif
