#
# Broadcom DirectFB Software (URSR-13.2/DirectFB-1.7.0v1.0)
#

require broadcom-directfb-common.inc

SRCREV = "${AUTOREV}"

DEFAULT_PREFERENCE = "-1"

# to find the right trinity-<timestamp>.unified.src.tgz:
APPLIBS_REL_TSTAMP = "20130726"

# DFB major
RV = "1.7-6"

# DirectFB Applibs directory
SRC_URI += "https://${NEXUS_BROADCOM_BASE}/sdk/applibs/DirectFB/applibs_release_DirectFB-1.7.6.src/2.1/applibs_release_DirectFB-1.7.6.src-2.1.tgz"
SRC_URI[md5sum] = "ffde219a3b3d44306f8cc9b86ccca208"
SRC_URI[sha256sum] = "d55bec4a7257efd5b595e2bb7d4b5447f3f2440f2819752a063684b535bbae10"

# Patches
SRC_URI += "file://broadcom_directfb_1.7.6_build.patch;striplevel=0"
SRC_URI += " file://nexus_dfb  \
            file://nexus.974xx  \
            file://rundfb.sh \
            file://broadcom_directfb_1.7.6_rename_libinit_link_nxclient.patch \
           "
SRC_URI += "file://broadcom_directfb_1.7.6_zorder.patch;striplevel=0"
SRC_URI += "file://broadcom_directfb_1.7.6_enumerate_debug.patch;striplevel=0"
SRC_URI += "file://broadcom_directfb_1.7.6_post_untar_patch.modify"
SRC_URI += '${@bb.utils.contains("PREFERRED_PROVIDER_broadcom-refsw", "broadcom-ursr", "file://broadcom_directfb_1.7.6_no_guardbanding.patch;striplevel=0", "",d)}'

# Location for Broadcom SDK patches in source tree form
#D_SDK_PATCH = "sdkpatches"

PROVIDES = "directfb directfb-dev"

RPROVIDES_${PN} = "directfb"

DEPENDS += "libwebp tiff"
#
# Nexus mode
# (TODO::)
export PLATFORM = "${NEXUS_PLATFORM}"
export MODE ?= "proxy"

#
# Uncomment this line below for debug build
#
export B_REFSW_DEBUG = "y"

#
# Uncomment this line below for verbose build
#
export B_REFSW_VERBOSE = "y"

#
# Default C standard
#
export NEXUS_C_STD = "gnu99"

CFLAGS += "-std=gnu99"
do_install_append () {
        sed -i '1s/^/layers-clear\n/' ${D}/etc/directfbrc
        rm ${D}${bindir}/dfb*
        rm ${D}${bindir}/directfb*
        rm ${D}${bindir}/mkdfiff*
        rm ${D}${bindir}/mkdgiff*
        rm ${D}${bindir}/pss
        rm ${D}${bindir}/spacedream
	rm ${D}${sysconfdir}/hotplug.d/dfbhotplug
	rm ${D}${sysconfdir}/hotplug.d/dfb_input_hotplug
        rm -rf ${D}${libdir}/directfb-${RV}/interfaces/IDirectFBImageProvider
        rm -rf ${D}${libdir}/directfb-${RV}/interfaces/IDirectFBVideoProvider
        rm -rf ${D}${libdir}/directfb-${RV}/interfaces/IDirectFBFont/libidirectfbfont_dgiff.so
        rm -rf ${D}${libdir}/directfb-${RV}/interfaces/IWater/libiwater_default.so

}

FILES_${PN}_remove += "${bindir}/dfb* ${bindir}/directfb* ${bindir}/mkdfiff* ${bindir}/mkdgiff* ${bindir}/pss ${bindir}/spacedream ${sysconfdir}/hotplug.d/dfbhotplug ${sysconfdir}/hotplug.d/dfb_input_hotplug ${libdir}/directfb-${RV}/interfaces/IDirectFBImageProvider ${libdir}/directfb-${RV}/interfaces/IDirectFBVideoProvider ${libdir}/directfb-${RV}/interfaces/IDirectFBFont/libidirectfbfont_dgiff.so ${libdir}/directfb-${RV}/interfaces/IWater/libiwater_default.so"

do_install_append () {
	install -Dm 755 nexus.974xx ${D}${bindir}/nexus.974xx
}
