#!/bin/sh

/usr/bin/bt_reset_XG1v4
sleep 8

/usr/bin/hciattach /dev/ttyS1 any
if [ $? -ne 0 ] ; then
    echo "Failed to Change BT ttyS1 "
    exit 1
fi
PID=`pgrep hciattach`

sleep 10
kill $PID
sleep 1
/usr/bin/hciattach /dev/ttyS1 cypress

sleep 1

##make a variable to store the BT address retrieved from a protected flash region that holds address data from the factory
BT_BDADDR_MAC=$(hexdump -C /dev/mtd4 -s 144 -n6 | awk '{printf $2":"$3":"$4":"$5":"$6":"$7}'  | cut -c1-17 )

###set the chip addr
bdaddr -t $BT_BDADDR_MAC

sleep 1

/usr/bin/hciconfig -a hci0 reset
if [ $? -ne 0 ] ; then
    echo "Failed to Activate BT hci0"
    exit 1
fi

sleep 3

/usr/bin/hciconfig -a hci0 down
if [ $? -ne 0 ] ; then
    echo "Failed to reset BT hci0"
    exit 1
fi
sleep 1

echo "Activated BT hci0 ttyS1 cypress"
exit 0
