###############################################################################
#  Copyright (c) 2016 RDK Management, LLC. All rights reserved.
#  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
#
#  This program is the proprietary software of Broadcom and/or its licensors,
#  and may only be used, duplicated, modified or distributed pursuant to the terms and
#  conditions of a separate, written license agreement executed between you and Broadcom
#  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
#  no license (express or implied), right to use, or waiver of any kind with respect to the
#  Software, and Broadcom expressly reserves all rights in and to the Software and all
#  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
#  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
#  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
#
#  Except as expressly set forth in the Authorized License,
#
#  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
#  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
#  and to use this information only in connection with your use of Broadcom integrated circuit products.
#
#  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
#  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
#  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
#  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
#  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
#  USE OR PERFORMANCE OF THE SOFTWARE.
#
#  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
#  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
#  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
#  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
#  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
#  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
#  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
#  ANY LIMITED REMEDY.
###############################################################################

CFLAGS= -g -fPIC -Wno-format -Wunused -DRMF_OSAL_FEATURE_IPV6 -DRMF_OSAL_LITTLE_ENDIAN

ifeq ($(NEXUS_TOP),)
$(error NEXUS_PLATFORM is not defined)
endif

ifeq ($(NEXUS_PLATFORM),)
$(error NEXUS_PLATFORM is not defined)
endif

REFSW_DIR=$(realpath $(NEXUS_TOP)/..)

include $(NEXUS_BIN_DIR)/include/platform_app.inc
CC=mipsel-linux-gcc
CXX=mipsel-linux-g++
AR=mipsel-linux-ar
LD=mipsel-linux-ld
NM=mipsel-linux-nm
RANLIB=mipsel-linux-ranlib
STRIP=mipsel-linux-strip

_NEXUS_CFLAGS:=$(filter-out -std=c89,$(NEXUS_CFLAGS))
_NEXUS_CFLAGS:=$(filter-out -Wstrict-prototypes,$(_NEXUS_CFLAGS))
#CFLAGS += $(_NEXUS_CFLAGS)
CFLAGS += $(_NEXUS_CFLAGS) -std=c++0x
ifeq ($(RDK_USE_NXCLIENT),y)
CFLAGS += -I$(NEXUS_TOP)/nxclient/include -I$(NEXUS_TOP)/lib/ipc -I$(REFSW_DIR)/BSEAV/api/include 
else
CFLAGS += -I$(NEXUS_TOP)/examples/multiprocess -I$(NEXUS_TOP)/examples/multiprocess/stubs -I$(NEXUS_TOP)/lib/ipc -I$(REFSW_DIR)/BSEAV/api/include 
endif

CFLAGS+=-Wl,--unresolved-symbols=ignore-all
SOC_INCLUDES +=-I$(RDK_DIR)/opensource/include #-I$(BCM_TOOLCHAIN)/mipsel-linux-uclibc/sys-root/usr/include

ifeq ($(DISABLE_POD),y)
  TEST_WITH_PODMGR=
endif

ifeq ($(RDK_PLATFORM_VENDOR),pace)
USE_PACE_MFR=1
#undef USE_BRCM_MFR
USE_BRCM_MFR=
endif

ifeq ($(RDK_PLATFORM_VENDOR),arris)
USE_MOT_MFR=1
#undef USE_BRCM_MFR
USE_BRCM_MFR=
endif
ifeq ($(TEST_WITH_PODMGR),1)
SOC_INCLUDES +=-I$(REFSW_DIR)/BSEAV/docsis/Stb/StbDocsisApi/Dsg \
           -I$(REFSW_DIR)/BSEAV/docsis/cm_bsp_v2/bsp_common/common_inc \
           -I$(REFSW_DIR)/BSEAV/docsis/cm_bsp_v2/bsp_common/BoardHal \
           -I$(REFSW_DIR)/BSEAV/docsis/Bfc/OperatingSystem \
           -I$(REFSW_DIR)/rockford/lib/ocap/mpod/include \
           -I$(REFSW_DIR)/rockford/lib/ocap/mpod/src/driver \
           -I$(REFSW_DIR)/BSEAV/docsis/StbHostApps/RswDload


BCM_DSG_LIB_DIR = $(MFR_DSGCCLIB_DIR)

ifeq ($(B_REFSW_ARCH),arm-linux) 
BCM_DSG_LIB_DIR = $(RDK_DIR)/workXG1/Refsw/BSEAV/cable/docsis/estb/arm/StbHostApps/DsgCC/build
SOC_DSG_LIB = $(BCM_DSG_LIB_DIR)/dsgcclib.a $(OPENSSL_DIR)/usr/lib/libcrypto.a 
else
if [ "$BUILD_13_2" = "y" ] ; then
	BCM_DSG_LIB_DIR = $(PLATFORM_SOC_DIR)/docsis/StbHostApps/DsgCC/build
else
	BCM_DSG_LIB_DIR = $(PLATFORM_SOC_DIR)/cable/docsis/estb/StbHostApps/DsgCC/build
fi
SOC_DSG_LIB = $(BCM_DSG_LIB_DIR)/dsgcclib.a $(OPENSSL_DIR)/usr/lib/libcrypto.a 
INTERNAL_LIBS = $(BCM_DSG_LIB_DIR)/dsgcclib.a $(OPENSSL_DIR)/usr/lib/libcrypto.a 
#INTERNAL_LIBS = $(OPENSSL_DIR)/usr/lib/libcrypto.a 
endif

ifdef USE_MOT_MFR
#SOC_MFR_INCLUDE = -I$(PLATFORM_SOC_DIR)/mfrlibs/
SOC_MFR_LIB = -Wl,-rpath,$(PLATFORM_SDK)/lib -L$(RDK_DIR)/mfrlib/bin/release/ -lMCS -lmotorolalib -lpdklib -lrt

curr_dir=$(shell pwd)
ifeq ($(findstring rmfApp,$(curr_dir)),rmfApp)
  SOC_MFR_LIB += -Xlinker --wrap -Xlinker ReportFlashUpdateStatusToEcm -Xlinker --wrap -Xlinker SetSerialConsoleMode -Xlinker --wrap -Xlinker SetupRemoteInterface
endif
ifeq ($(findstring mediastreamer,$(curr_dir)),mediastreamer)
  SOC_MFR_LIB += -Xlinker --wrap -Xlinker ReportFlashUpdateStatusToEcm -Xlinker --wrap -Xlinker SetSerialConsoleMode -Xlinker --wrap -Xlinker SetupRemoteInterface
endif
ifeq ($(findstring runsnmp,$(curr_dir)),runsnmp)
  SOC_MFR_LIB += -Xlinker --wrap -Xlinker ReportFlashUpdateStatusToEcm -Xlinker --wrap -Xlinker SetSerialConsoleMode -Xlinker --wrap -Xlinker SetupRemoteInterface
endif

CRYPTO_LIB = $(OPENSSL_DIR)/usr/lib/libcrypto.a
endif

ifdef USE_SAM_MFR
USE_BRCM_MFR=
endif

ifdef USE_BRCM_MFR
SOC_MFR_INCLUDE = -I$(PLATFORM_SOC_DIR)/mfrlibs/
SOC_MFR_LIB = -Wl,-rpath,$(PLATFORM_SDK)/lib -L$(PLATFORM_SOC_DIR)/mfrlibs/broadcomlib -lbroadcomlib
ifeq ($(RDK_PLATFORM_VENDOR),cisco)
SOC_MFR_LIB = -Wl,-rpath,$(PLATFORM_SDK)/lib -L$(REFSW_DIR)/../svn/sdk/mfrlib/bin/release $(MFR_LIB_NAME)
endif
endif
ifdef USE_PACE_MFR
SOC_MFR_INCLUDE = -I$(REFSW_DIR)/../svn/sdk/mfrlib/include
SOC_MFR_LIB = -Wl,-rpath,$(PLATFORM_SDK)/lib -L$(REFSW_DIR)/../svn/sdk/mfrlib/bin/release -lPaceMfrApi -lrt
endif

ifdef USE_SAM_MFR
SOC_MFR_INCLUDE = -I$(RDK_DIR)/workXG1/svn/sdk/customApp/mfr/include/
SOC_MFR_LIB=-L$(RDK_DIR)/workXG1/svn/sdk/bin/binary_only/manufacturer -lSAMSUNGMfrApi -lSAMcode
endif

SEC_LIB ?= $(OPENSSL_DIR)/usr/lib/libcrypto.a 
endif

OPENSSL_LIB_DIR ?= $(OPENSSL_DIR)/usr/lib

ifeq ($(NEXUS_MODE),proxy)
NEXUS_LIB=nexus
else
NEXUS_LIB=nexus_client
endif
ifeq ($(RDK_USE_NXCLIENT),y)
SOC_SHLIBS= -l$(NEXUS_LIB) -lnxclient
else
SOC_SHLIBS= -l$(NEXUS_LIB) -lbipc
endif

ifdef TEST_WITH_PODMGR
PLATFORM_SHLIBS=$(SOC_MFR_LIB) $(STATIC_INIT_LIB)
#no -lcrypto
OPENSSL_LIBS=-lssl
else
OPENSSL_LIBS=-LDUMMY_DIR
PLATFORM_SHLIBS=-LDUMMY_DIR
endif
# enabling iarmbus only for pace
#ifeq ($(RDK_PLATFORM_VENDOR),pace)
IARM_LIBS=-lIARMBus -ldbus-1 -L$(RDK_DIR)/sdk/fsroot/ramdisk/usr/local/lib
#endif

ifeq ($(RDK_PLATFORM_DEVICE),xg1)
else
RECORDER_SUPPORT=
USE_TRM=
endif

#Enable following flags later
#USE_SYS_RESOURCE_MON=
#These flags are required for othe platform vendors hence commenting- SAM7435-316
#ifeq ($(RDK_PLATFORM_VENDOR),bcm)
#USE_FRONTPANEL=
#USE_GLI=
#endif
#USE_SYS_RESOURCE_MLT=
#USE_SYSRES_MLT=
#IPPV_CLIENT_ENABLED=
#These flags are required for othe platform vendors hence commenting- SAM7435-316
ifeq ($(RDK_PLATFORM_VENDOR),bcm)
ENABLE_AUTODISCOVERY_FOR_VOD=
USE_VODSRC=
endif
ifneq ($(COMCAST_PLATFORM),BCM93385)
USE_TRANSCODEFILTER=
endif

ifdef USE_FRONTPANEL
ifeq ($(RDK_PLATFORM_VENDOR),pace)
USE_FPTEXT=
USE_FPLED=
endif
endif

#unused, set to dummy
M32_FLAG=-O2
SOC_QAM_SHLIBS=-L$(SNMP_DIR)/lib

#use SYSROOT_FLAG for rpath, instead of --sysroot
SYSROOT_FLAG=-Wl,-rpath,$(PLATFORM_SDK)/lib -L$(PLATFORM_SDK)/lib
SOC_PODMGR_FLAGS:=$(CFLAGS) -DUSE_BRCM_SOC -DUSE_BRCM_SOC_IPV6 -DCOMMON_DOWNLOAD_SUPPORT $(SOC_INCLUDES) $(SOC_MFR_INCLUDE) 
ifdef USE_BRCM_MFR
SOC_PODMGR_FLAGS+=-DUSE_BRCM_MFR
endif
ifdef USE_PACE_MFR
SOC_PODMGR_FLAGS+=-DUSE_PACE_MFR
endif
ifdef USE_MOT_MFR
SOC_PODMGR_FLAGS+=-DUSE_MOT_MFR
endif
OPENSOURCE_SRC_DIR=$(RDK_DIR)/opensource

ifeq ($(RDK_PLATFORM_DEVICE),xg1)
CFLAGS+=$(SOC_INCLUDES) -DUSE_SOC_INIT -I$(WORK_DIR)/Refsw/uclinux-rootfs/user/xfsprogs/include
else
CFLAGS+=$(SOC_INCLUDES) -DDISABLE_XFS -DUSE_SOC_INIT 
endif

#Flag to enable single threaded section filtering logic for PAT, PMT
RMF_SF_SINGLE_THREAD_ENABLE=1

ifdef RMF_SF_SINGLE_THREAD_ENABLE
CFLAGS += -DRMF_SF_SINGLE_THREAD_ENABLE
endif

STATIC_INIT_LIB = 
INIT_LIB = 	$(STATIC_INIT_LIB)
BUILD_OS=DUMMY_UNUSED
POD_PLATFORM=DUMMY_UNUSED
PLATFORM_FLAGS=$(SOC_PODMGR_FLAGS)

SOC_THREADANALYZER_FLAGS:= -DUSE_BRCM_SOC

#For qamsource, force to use c++ to compile
ifeq ($(findstring qamsource,$(CURDIR)),qamsource)
CC=$(B_REFSW_ARCH)-c++
endif
ifeq ($(findstring qamtunersrc,$(CURDIR)),qamtunersrc)
CC=$(B_REFSW_ARCH)-c++
endif
ifeq ($(findstring snmp,$(CURDIR)),snmp)
CC=$(B_REFSW_ARCH)-c++
endif

SOC_DVRINC=$(RMF_DIR)/platform/soc/dvrmgr
SOC_DVRSRC=$(SOC_DVRINC)/dvrmanager-soc.cpp

