###############################################################################
#  Copyright (c) 2016 RDK Management, LLC. All rights reserved.
#  Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
#
#  This program is the proprietary software of Broadcom and/or its licensors,
#  and may only be used, duplicated, modified or distributed pursuant to the terms and
#  conditions of a separate, written license agreement executed between you and Broadcom
#  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
#  no license (express or implied), right to use, or waiver of any kind with respect to the
#  Software, and Broadcom expressly reserves all rights in and to the Software and all
#  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
#  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
#  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
#
#  Except as expressly set forth in the Authorized License,
#
#  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
#  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
#  and to use this information only in connection with your use of Broadcom integrated circuit products.
#
#  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
#  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
#  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
#  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
#  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
#  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
#  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
#  USE OR PERFORMANCE OF THE SOFTWARE.
#
#  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
#  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
#  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
#  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
#  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
#  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
#  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
#  ANY LIMITED REMEDY.
###############################################################################

#parent script should be invoked at ../
export RMF_DIR=`${REALPATH} $RDK_DIR/mediaframework`
BUILDS_DIR=$RDK_DIR 

if [ x${WORK_DIR} == x ] ; then                         #
   export WORK_DIR=${RDK_PROJECT_ROOT_PATH}/work${RDK_PLATFORM_DEVICE^^}         #
fi 

source $RDK_DIR/build_scripts/setBCMenv.sh

export PLATFORM_SDK=$BCMAPP
export TOOLCHAINDIR=${BCM_TOOLCHAIN}
export TOOLCHAIN_DIR=$TOOLCHAINDIR
export SOC_CFLAGS="-fPIC -DUSE_UNALIGNED_BUFFER"
#export SOC_SYSROOT=
#export SOC_LD_FLAGS=
export PLATFORM_SOC_DIR=$RDK_DIR/mediaframework/platform/soc
export THIRDPARTY_DIR=$PLATFORM_SOC_DIR/thirdparty
export SNMP_DIR=$RDK_DIR/opensource/target-snmp
export SNMP_SRC_DIR=$THIRDPARTY_DIR/net-snmp-5.4.2
export OPENSSL_DIR=$THIRDPARTY_DIR/openssl
export OPENSSL_SRC_DIR=$THIRDPARTY_DIR/openssl-0.9.8j.patched

export CC=mipsel-linux-gcc
export CXX=mipsel-linux-g++
export AR=mipsel-linux-ar
export LD=mipsel-linux-ld
export NM=mipsel-linux-nm
export RANLIB=mipsel-linux-ranlib
export STRIP=mipsel-linux-strip

export FSROOT=$RDK_DIR/sdk/fsroot/ramdisk

export SDK_DIR=$PLATFORM_SDK


export NETSNMP_LIBS=`${RDK_PROJECT_ROOT_PATH}/opensource/target-snmp/bin/net-snmp-config --netsnmp-agent-libs`
export NETSNMP_LIBS="-L${RDK_PROJECT_ROOT_PATH}/opensource/target-snmp/lib $NETSNMP_LIBS"

export BUILD_OS=DUMMY_UNUSED
export RMF_BUILD_OS=$BUILD_OS
export POD_PLATFORM=DUMMY_UNUSED
#export MFR_NAME=USE_PACE_MFR
NEXUS_CFLAGS=`cat ${NEXUS_BIN_DIR}/include/platform_app.inc | grep NEXUS_CFLAGS | cut -d' ' -f3- | awk -F "-std=c89" '{print $1 $2}'`
NEXUS_LDFLAGS=`cat ${NEXUS_BIN_DIR}/include/platform_app.inc | grep NEXUS_LDFLAGS | cut -d' ' -f3-`
NEXUS_CFLAGS=`eval echo ${NEXUS_CFLAGS}`
NEXUS_LDFLAGS=`eval echo ${NEXUS_LDFLAGS}`
export IARMBUS_CFLAGS=" -DUSE_IARM_BUS "
export TRM_CFLAGS="  "
export DVR_CFLAGS=" -DDVR_USE_STOP "
if [ "x$RDK_PLATFORM_DEVICE" != "xrng150" ]; then
export TRM_CFLAGS=" -DUSE_TRM "
fi

export CFLAGS="-g $NEXUS_CFLAGS $IARMBUS_CFLAGS $DVR_CFLAGS -I$RDK_PROJECT_ROOT_PATH/opensource/include \
-I$REFSW_TOP/uclinux-rootfs/include \
-I$REFSW_TOP/uclinux-rootfs/include/nspr \
-I$REFSW_TOP/uclinux-rootfs/usr/include \
-I$REFSW_TOP/uclinux-rootfs/usr/local/include  \
-I$REFSW_TOP/uclinux-rootfs/usr/local/include/directfb  \
-I$APP_PATH/include \
-I$PREFIX_FOLDER/include/glib-2.0  \
-I$REFSW_TOP/uclinux-rootfs/user/dhcpv6 \
-I$REFSW_TOP/uclinux-rootfs/lib/zlib \
-I$FUSION_TOP/include \
-I$FUSIONKERNEL/linux/include \
-I$WORK_DIR/uclinux-rootfs/user/xfsprogs/include \
-I$REFSW_TOP/uclinux-rootfs/user/e2fsprogs/lib \
-DRMF_STREAMER -DOOBSI_SUPPORT -DGLI -DUSE_BRCM_SOC -DUSE_BRCM_SOC_IPV6 $TRM_CFLAGS \
-DQAMSRC_PMTBUFFER_PROPERTY -DUSE_FRONTPANEL \
-DUSE_SOC_INIT -DUSE_FPTEXT -DUSE_FPLED -DEXTERNAL_MEMORY_POOL_ALLOCATE \
-DENABLE_SNMP \
-I${RDK_PROJECT_ROOT_PATH}/iarmbus/core/include \
-I${RDK_PROJECT_ROOT_PATH}/iarmmgrs/generic/hal/include \
-I${RDK_PROJECT_ROOT_PATH}/iarmmgrs/generic/sysmgr/include \
-I${RDK_PROJECT_ROOT_PATH}/mfrlibs \
-I${RDK_PROJECT_ROOT_PATH}/mediaframework/platform/soc/mfrlibs \
-I${WORK_DIR}/svn/sdk/customApp/mfr/include \
-I${RDK_PROJECT_ROOT_PATH}/devicesettings/ds/include \
-I${RDK_PROJECT_ROOT_PATH}/devicesettings/rpc/include \
-I${RDK_PROJECT_ROOT_PATH}/devicesettings/hal/include \
-I${RDK_FSROOT_PATH}/usr/include \
-I${WORK_DIR}/Refsw/uclinux-rootfs/user/xfsprogs/include \
-I${RDK_PROJECT_ROOT_PATH}/opensource/target-snmp/include -g "

export CXXFLAGS=$CFLAGS


export LDFLAGS="-L. \
-L${PLATFORM_SDK}/lib/uClibc \
-L${RDK_FSROOT_PATH}/lib \
-L${RDK_FSROOT_PATH}/usr/lib \
-L${RDK_FSROOT_PATH}/usr/local/lib \
-L$REFSW_TOP/uclinux-rootfs/usr/lib \
-L$REFSW_TOP/uclinux-rootfs/usr/local/lib \
-L$REFSW_TOP/uclinux-rootfs/lib \
-L$APP_PATH/lib  \
-L${PLATFORM_SDK}/lib/uClibc \
-L$REFSW_TOP/uclinux-rootfs/user/dhcpv6 \
-L${RDK_FSROOT_PATH}/mnt/nfs/bin/target-snmp/lib \
-lrt -lm -ldl -Wl,-rpath,${RDK_FSROOT_PATH}/usr/local/lib"


#export DVRMGR_FLAGS="-DUSE_QAMSRC"

export LD_LIBRARY_PATH="${RDK_FSROOT_PATH}/usr/lib:${RDK_FSROOT_PATH}/usr/local/lib"

export IARMBUS_LIBS="-lIARMBus -ldbus-1 -ldirect"
export DSMGR_LIBS="-lds -ldshalcli"

export DEFAULT_HOST=mipsel-linux

export PKG_CONFIG_PATH="$RDK_PROJECT_ROOT_PATH/opensource/lib/pkgconfig/:$DFB_LIB/pkgconfig:$APPLIBS_TARGET_DIR/usr/local/lib/pkgconfig:"
export OPENSSL_SRC=${RDK_PROJECT_ROOT_PATH}/opensource/openssl
export OPENSSL_CFLAGS="-I${OPENSSL_SRC}/include"
export OPENSSL_LDFLAGS="${OPENSSL_SRC}/libcrypto.a"
export SOC_LIBS="-lsocinit"
if [ "x$RDK_PLATFORM_DEVICE" != "xxi3" ];then
	if [ "x$BUILD_13_2" = "xy" ] ; then
		export MFR_LIBS="-L${RDK_FSROOT_PATH}/lib -L${WORK_DIR}/${MFR_LIB_PATH} ${MFR_LIB_NAME} $NEXUS_LDFLAGS -lnxclient  ${WORK_DIR}/Refsw/BSEAV/docsis/StbHostApps/DsgCC/build/dsgcclib.a $OPENSSL_LDFLAGS $SOC_LIBS"
	else
		export MFR_LIBS="-L${RDK_FSROOT_PATH}/lib -L${WORK_DIR}/${MFR_LIB_PATH} ${MFR_LIB_NAME} $NEXUS_LDFLAGS -lnxclient  ${WORK_DIR}/Refsw/BSEAV/cable/docsis/estb/StbHostApps/DsgCC/build/dsgcclib.a $OPENSSL_LDFLAGS $SOC_LIBS"
	fi
else
export MFR_LIBS=$SOC_LIBS
fi
