/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef __HAL_DIAG_H__
#define __HAL_DIAG_H__

#ifdef __cplusplus
extern "C"
{
#endif


#define MAX_VENDOR_NAME_LEN        128
#define MAX_MODEL_NAME_LEN        128
#define MAX_FIRMWARE_NAME_LEN    64

typedef    enum
{
    HAL_DIAG_API_STATUS_SUCCESS,
    HAL_DIAG_API_STATUS_FAILURE,
    HAL_DIAG_API_STATUS_NOT_SUPPORTED,
    HAL_DIAG_API_STATUS_NULL_PARAMETER,
    HAL_DIAG_API_STATUS_NOT_IMPLEMENTED
}HAL_DIAG_API_STATUS;


typedef enum {

    HOST_MEMORY_TYPE_ROM,
    HOST_MEMORY_TYPE_DRAM,
    HOST_MEMORY_TYPE_SRAM,
    HOST_MEMORY_TYPE_FLASH,
    HOST_MEMORY_TYPE_NVM,
    HOST_MEMORY_TYPE_IHDD_NODRM,
    HOST_MEMORY_TYPE_VIDEO,
    HOST_MEMORY_TYPE_OTHER,
    HOST_MEMORY_TYPE_IHDD_DRM,
    HOST_MEMORY_TYPE_EHDD_NODRM,
    HOST_MEMORY_TYPE_EHDD_DRM,
    HOST_MEMORY_TYPE_OPTICAL_NODRM,
    HOST_MEMORY_TYPE_OPTICAL_DRM,
    HOST_MEMORY_TYPE_MAX

}HOST_MEMORY_TYPE;


typedef struct _sHostMemoryAllocInfo
{
    unsigned char    numMemTypes;
    struct
    {
        HOST_MEMORY_TYPE    memType;
        unsigned long        memSizeKBytes;
    }memoryInfo[HOST_MEMORY_TYPE_MAX];

}sHostMemoryAllocInfo;


#define DIAG_APP_NAME_MAX_LEN    256
#define DIAG_APP_SIGN_MAX_LEN    256
#define DIAG_MAX_NUM_OF_APPS     100
typedef struct sft_ver_rep_s
{
    unsigned short    application_version_number;
    unsigned char application_status_flag;
    unsigned char application_name_length;
    unsigned char application_name_byte[DIAG_APP_NAME_MAX_LEN];
    unsigned char application_sign_length;
    unsigned char application_sign_byte[DIAG_APP_SIGN_MAX_LEN];
}softwareVer_t;

typedef struct softwareVerInfo_s
{
    unsigned char number_of_applications;
    softwareVer_t SoftVer[DIAG_MAX_NUM_OF_APPS];
}softwareVerInfo_t;

//M-MODE firmware_ver_report
typedef struct sFirmwareVerInfo
{
    unsigned char    firmware_version_length;
    unsigned char    firmware_version_byte[MAX_FIRMWARE_NAME_LEN];

    unsigned short    firmware_year;
    unsigned char    firmware_month;
    unsigned char    firmware_day;


}sFirmwareVerInfo_t;

//MAC_address_report

 //ipv6 MAC address will be 16 bytes
#define MAX_MAC_ADDRESS_LEN        16

//Type of device associated with reported MAC address.
typedef enum
{
    MAC_ADDRESS_TYPE_NONE,
    MAC_ADDRESS_TYPE_HOST,
    MAC_ADDRESS_TYPE_1394,
    MAC_ADDRESS_TYPE_RSVD1,
    MAC_ADDRESS_TYPE_DOCSIS,
    MAC_ADDRESS_TYPE_RSVD2,
    //MAC_ADDRESS_TYPE_CABLECARD,
    MAC_ADDRESS_TYPE_MAX
}MAC_ADDRESS_TYPE;

typedef struct _sMacAddrInfo
{
    MAC_ADDRESS_TYPE    macAddrType;
    unsigned char        macAddrLen;
    unsigned char        macAddr[MAX_MAC_ADDRESS_LEN];

}sMacAddrInfo;


typedef struct _sMacAddrReport
{
    unsigned char    numMACAddresses;
    sMacAddrInfo    macAddrInfo[MAC_ADDRESS_TYPE_MAX];

}sMacAddrReport;


//FAT_status_report.
typedef struct sFATInfo
{
    unsigned char    PCR_lock;            //00b - Not Locked, 01b - Locked
    unsigned char    modulation_mode;    //00b - Analog, 01b - QAM64, 10b - QAM256, 11b - other
    unsigned char    carrier_lock_status;//00b - Not Locked, 01b - Locked
    unsigned short    SNR;                //Signal to Noise Ratio in tenths of dB
    unsigned short    signal_level;        //value in tenths of dB
}sFATInfo;

//FDC_status_report. Forward Data Channel report
typedef struct sFDCInfo
{
    unsigned short    FDC_center_freq;
    unsigned char    carrier_lock_status;

}sFDCInfo;

typedef struct sCurrentChannelInfo
{
    unsigned char channel_type;
    unsigned char authorization_flag;
    unsigned char purchasable_flag;
    unsigned char purchased_flag;
    unsigned char preview_flag;
    unsigned char parental_control_flag;
    unsigned short current_channel;
}sCurrentChannelInfo_t;



//1394_port_report
#define MAX_1394_DEVICES    63

typedef struct deviceInfo
{
        unsigned char device_subunit_type;
        unsigned char device_a_d_source_selection_status;
        unsigned long eui_64_hi;
        unsigned long eui_64_lo;

}DeviceInfo_t;

typedef struct sI1394PortInfo{

    unsigned char  loop_status;
    unsigned char  root_status;
    unsigned char  cycle_master_status;
    unsigned char  host_a_d_source_selection_status;
    unsigned char  port_1_connection_status;
    unsigned char  port_2_connection_status;
    unsigned short total_number_of_nodes;
    unsigned char number_of_connected_devices;
    DeviceInfo_t DeviceInfo[MAX_1394_DEVICES];

}sI1394PortInfo;

typedef struct DVIInfo_s
{
    unsigned char connection_status;
    unsigned char host_HDCP_status;
    unsigned char device_HDCP_status;
//video_format
//{
       unsigned short   horizontal_lines;
       unsigned short    vertical_lines;
       unsigned char frame_rate;
       unsigned char    aspect_ratio;
      unsigned char prog_inter_type;

//}
}DVIInfo_t;
//DVI Status Report
//NOT APPLICABLE


//eCM Status Report
typedef struct _s_eCMStatusInfo
{
    unsigned short    downstream_center_freq;
    unsigned short    downstream_power_level;
    unsigned char    downstream_carrier_lock_status;
    unsigned char    channel_s_cdma_status;
    unsigned char    upstream_modulation_type;
    unsigned short    upstream_xmt_center_freq;
    unsigned short    upstream_power_level;
    unsigned char    upstream_symbol_rate;

}s_eCMStatusInfo;


typedef enum
{
    DIAG_AUDIO_FMT_CODE_PCM,
    DIAG_AUDIO_FMT_CODE_MPEG_1,
    DIAG_AUDIO_FMT_CODE_MPEG_2,
    DIAG_AUDIO_FMT_CODE_DTS,
    DIAG_AUDIO_FMT_CODE_AAC,
    DIAG_AUDIO_FMT_CODE_MP3,
    DIAG_AUDIO_FMT_CODE_ATRAC,
    DIAG_AUDIO_FMT_CODE_OTHER
}DIAG_AUDIO_FMT_CODE;

//HDMI Port Status Report
typedef struct _s_HDMIPortStatus
{
    unsigned char    device_type;
    unsigned char    color_space;
    unsigned char    connection_status;
    unsigned char    host_HDCP_status;
    unsigned char    device_HDCP_status;

//    struct
//    {
        unsigned short    horizontal_lines;
        unsigned short    vertical_lines;
        unsigned char    frame_rate;
        unsigned char    aspect_ratio;
        unsigned char    prog_inter_type;
//    }video_format;

//    struct
//    {
        unsigned char    audio_sample_size;
        unsigned char    audio_format;
        unsigned char    audio_sample_freq;
//    }audio_format;

}s_HDMIPortStatus;


//RDC Status Report

typedef struct    sRDCInfo
{
    unsigned short    RDC_center_freq;
    unsigned char    RDC_transmitter_power_level;
    unsigned char    RDC_data_rate;

}sRDCInfo;

#define MAX_NET_ADDRS 10
typedef struct
{
    MAC_ADDRESS_TYPE    net_address_type;
    unsigned char        number_of_bytes_net;
    unsigned char        net_address_byte[MAX_MAC_ADDRESS_LEN];

    unsigned char        number_of_bytes_subnet;
    unsigned char         sub_net_address_byte[MAX_MAC_ADDRESS_LEN];
  }netaddr_t;
//OCHD2 Network Address    -
typedef struct sOCHD2NetAddressInfo
{
    unsigned char number_of_addresses;


    netaddr_t netaddr[MAX_NET_ADDRS];
}sOCHD2NetAddressInfo;
#define MAX_IP_BYTES 32
#define MAX_CLIENTS  32
typedef struct
{
    unsigned char client_mac_address[6];
    unsigned char number_of_bytes_net;
    unsigned char client_IP_address_byte[MAX_IP_BYTES];
    unsigned char client_DRM_status;
}CntClients_t;
typedef struct
{
    unsigned char max_clients;
    unsigned char host_DRM_status;
    unsigned char connected_clients;
    CntClients_t  Client[MAX_CLIENTS];
}HomeNetworkInfo_t;

typedef struct sHostInformation
{
    unsigned char vendor_name_length;
    unsigned char vendor_name_character[MAX_VENDOR_NAME_LEN];
    unsigned char model_name_length;
    unsigned char model_name_character[MAX_MODEL_NAME_LEN];
}sHostInformation;


//DIAG API

HAL_DIAG_API_STATUS    HAL_DIAG_GetHostMemInfo(sHostMemoryAllocInfo    *pHostMemoryAllocInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetSoftwareVerInfo(softwareVerInfo_t    *pSoftwareVerInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetFirmwareVerInfo( sFirmwareVerInfo_t  *pFirmwareVerInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetMACAddressInfo(sMacAddrReport    *pMacAddrReport);

HAL_DIAG_API_STATUS    HAL_DIAG_GetFATInfo(unsigned char ltsid,sFATInfo    *pFATInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetFDCInfo(sFDCInfo    *pFDCInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetCurrentChannelInfo(sCurrentChannelInfo_t    *pCurrentChannelInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetRDCInfo(sRDCInfo    *pRDCInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetI1394PortInfo(sI1394PortInfo    *pII1394PortInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetDviInfo(DVIInfo_t    *pDVIInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GeteCMStatusInfo(s_eCMStatusInfo    *ps_eCMStatusInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetHDMIPortInfo(s_HDMIPortStatus    *pHDMIPortStatus);

HAL_DIAG_API_STATUS    HAL_DIAG_GetOCHD2PortInfo(sOCHD2NetAddressInfo    *pOCHD2NetAddressInfo);

HAL_DIAG_API_STATUS    HAL_DIAG_GetHomeNetworkInformation(HomeNetworkInfo_t    *pHomeNettInformation);

HAL_DIAG_API_STATUS    HAL_DIAG_GetHostInformation(sHostInformation        *pHostInformation);

HAL_DIAG_API_STATUS HAL_DIAG_DumpReservedMemoryInfo();
#ifdef __cplusplus
}
#endif


#endif /*__HAL_DIAG_H__*/
