/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


#ifndef SYS_API_H
#define SYS_API_H

#ifdef __cplusplus
extern "C"
{
#endif

/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/

#include "hal_api.h"
#include "snmp_types.h"

typedef struct {
    DISP_DISPLAY_FORMAT_t    dispOutVideoFormat;
    //DISP_ASPECT_RATIO_t    aspectRatio;
    int                        dispRFOutChannelNum;
}disp_init_params;

typedef struct {
    int    numInbandTuners;
}tuner_init_params;

typedef struct _sHalInitParams
{
    disp_init_params    dispInitParams;
    tuner_init_params   tunerInitParams;

    //Additional members can be added for different modules initialization parameters if any
}sHalInitParams;


typedef enum
{
    SYS_POWER_STATE_ON,
    SYS_POWER_STATE_STANDBY,
    SYS_POWER_STATE_UNKNOWN
}SYS_POWER_STATE;

typedef void (*SYS_POWER_NOTIFY_FUNC_t)(SYS_POWER_STATE sysPowerStatus);
typedef void (*EXT_DEVICE_DETECT_NOTIFY_FUNC_t)(PDT_ExtDeviceType extDeviceType, unsigned char bConnect, char *path);

/***********************************************************************
 * FUNCTION : HAL_SYS_Init
 *
 * PURPOSE : Initializes the HAL library.
 *
 * PARAMETERS :
 *    n/a
 *
 * RETURNS :
 *    HAL_SUCCESS       : On success
 *    Negative returns  : Failure
 *
 * USAGE :
 *    Initialize all hardwares including initialization for structures
 *    in order to make all haldrivers available to a middleware or
 *    an appilication
 ************************************************************************
 */

//INT32 HAL_SYS_Init(void) ;
INT32 HAL_SYS_Init(sHalInitParams *pHalInitParams);
void HAL_SYS_Reboot(const char * pszRequestor, const char * pszReason);

/***********************************************************************
 * FUNCTION : HAL_SYS_Shutdown
 *
 * PURPOSE : Shuts down the HAL library.
 *
 * PARAMETERS :
 *    n/a
 *
 * RETURNS :
 *    HAL_SUCCESS                       : On success
 *    ERROR_HAL_INITIALIZATION_FAILED   : If one or modules failed to
 *                                        shutdown.
 *    ERROR_HAL_NOT_INITIALIZED         : Error if HAL lib was not
 *                                        previously initialized.
 *
 * USAGE :
 *    Used to shutdown and clean up the HAL library.
 *
 ************************************************************************
 */


INT32 HAL_SYS_Shutdown(void);

/***********************************************************************
 * FUNCTION : HAL_SYS_InitStatus
 *
 * PURPOSE : Returns the state of the HAL library
 *
 * PARAMETERS :
 *    n/a
 *
 * RETURNS :
 *    TRUE      : If HAL lib has been intialized successfully
 *    FALSE     : If HAL lib not intialized
 *
 * USAGE :
 *    Called to obtain the status of the HAL library. If FALSE is
 *    returned, the reasons are 1) HAL init was not called or 2) HAL
 *    init was called but one of the modules failed to intialize.
 *
 ************************************************************************
 */

BOOLEAN HAL_SYS_InitStatus (void);

int HAL_SYS_SetPowerState( int sysPowerState);

void HAL_SYS_SetPowerState_Notify(SYS_POWER_NOTIFY_FUNC_t fnNotifyFunc);

/***********************************************************************
 * FUNCTION : HAL_SYS_GetPowerState
 *
 * PURPOSE : Returns the power state the system
 *
 * PARAMETERS :
 *
 *
 * RETURNS :
 *       N/A

 * USAGE :
 *    Called to obtain the Power status of the system.
 *
 ************************************************************************
 */
void HAL_SYS_GetPowerState( SYS_POWER_STATE *pSysPowerState);

/***********************************************************************
 * FUNCTION : HAL_SYS_Version
 *
 * PURPOSE : Fills in the char* with an array of 16 bytes that contains
 *           the hal version number in this format hal_xx_xx_xx.
 *
 * PARAMETERS :
 *    char* pcHalVersion
 *
 * RETURNS :
 *    HAL_SUCCESS or ERROR_HAL_OPERATION_FAILED on error
 *
 * USAGE :
 *    Should be called to get hal version number from MW.
 *
 ************************************************************************
 */
INT32 HAL_SYS_Version (char* pcHalVersion);

/***********************************************************************
 * FUNCTION : HAL_EXTDEV_GetCapabilities
 *
 * PURPOSE :
 *    Exposes the capabilities of the external devices residing in the
 *    system to the middle ware.
 *
 * PARAMETERS :
 *    EXTDEV_CAPABILITIES_t *pstCapabilities (OUT) - Describes the
 *      capabilities of the external devices residing in the system.
 *
 * RETURNS :
 *    HAL_SUCCESS               : On success
 *    ERROR_HAL_NOT_INITIALIZED : Not initialized
 *    ERROR_HAL_NULL_PARAMETER  : NULL pointer detected
 *
 * USAGE :
 *    The middleware first invokes this call before calling any
 *    of the other HAL_EXTDEV_xxxx() functions to get device
 *    capabilities.
 *
 ************************************************************************
 */

INT32 HAL_EXTDEV_GetCapabilities (EXTDEV_CAPABILITIES_t *pstCapabilities);

/***********************************************************************
 * FUNCTION : HAL_EXTDEV_AddSource
 *
 * PURPOSE :
 *    Connects a HAL source device to an external output device.
 *    Currently, only IEEE1394 and POD external devices are capable
 *    of accepting a source device.
 *
 * PARAMETERS :
 *    DEVICE_HANDLE_t hExtDevHandle (IN) - Handle to external
 *      output device.
 *    DEVICE_HANDLE_t hSourceHandle (IN) - Handle of source device
 *      to connect to the external output device.
 *
 * RETURNS :
 *    HAL_SUCCESS                    : On success
 *    ERROR_HAL_DEVICE_NOT_AVAILABLE : No HSX devices available
 *    ERROR_HAL_DEVICE_CONNECTED     : Device already connected to
 *                                   : a source.
 *    ERROR_HAL_OPERATION_FAILED     : Unable to configure the external
 *                                   : device.
 *    ERROR_HAL_NOT_INITIALIZED      : HAL driver lib not initialized
 *    ERROR_HAL_INVALID_HANDLE       : Device handle passed in by
 *                                   : the caller is not a valid handle
 *                                   : for this API
 *
 * USAGE :
 *    The middle ware calls this function to logically connect
 *    two devices together, thus forming a transport stream path
 *    between the source and destination devices.
 *
 ************************************************************************
 */

INT32 HAL_EXTDEV_AddSource (DEVICE_HANDLE_t hExtDevHandle,
                            DEVICE_HANDLE_t hSourceHandle);

/***********************************************************************
 * FUNCTION : HAL_EXTDEV_RemoveSource
 *
 * PURPOSE :
 *    Removes, and disconnects, a HAL source device from an external
 *    output device.  Currently, only IEEE1394 and POD are valid
 *    external output devices.
 *
 * PARAMETERS :
 *    DEVICE_HANDLE_t hExtDevHandle (IN) - Specifies which external
 *      output device to disconnect from.
 *
 * RETURNS :
 *    HAL_SUCCESS                    : On success
 *    ERROR_HAL_NOT_INITIALIZED      : HAL driver lib not initialized
 *    ERROR_HAL_INVALID_HANDLE       : Device handle passed in by
 *                                   : the caller is not a valid handle
 *                                   : for this API
 *    ERROR_HAL_DEVICE_CONNECTED     : Device is not connected to any
 *                                   : HAL source.
 *    ERROR_HAL_DEVICE_NOT_AVAILABLE : No HSX devices available
 *    ERROR_HAL_OPERATION_FAILED     : Unable to configure the external
 *                                   : device.
 *
 * USAGE :
 *    The middle ware calls this function to logically disconnect
 *    a source device from an external output device.
 *
 ************************************************************************
 */

INT32 HAL_EXTDEV_RemoveSource (DEVICE_HANDLE_t hExtDevHandle);


/***********************************************************************
 * FUNCTION : HAL_EXTDEV_SetVideoBBMode
 *
 * PURPOSE :
 *    Configures the analog input selector for either CVBS or YC.
 *
 * PARAMETERS :
 *    DEVICE_HANDLE_t hExtDevHandle (IN) - Specifies which external
 *      video baseband input to configure.
 *
 *    EXTDEV_VIDEOBB_MODE_t eMode (IN) - Specifies the mode
 *
 * RETURNS :
 *    HAL_SUCCESS                    : On success
 *    ERROR_HAL_NOT_INITIALIZED      : HAL driver lib not initialized
 *    ERROR_HAL_INVALID_HANDLE       : Device handle passed in by
 *                                   : the caller is not a valid handle
 *                                   : for this API
 *    ERROR_HAL_OPERATION_FAILED     : Unable to configure the external
 *                                   : device.
 *
 * USAGE :
 *    The middle ware calls this function to configure the analog video
 *    baseband input selector.
 *
 ************************************************************************
 */

INT32 HAL_EXTDEV_SetVideoBBMode (DEVICE_HANDLE_t hExtDevHandle, EXTDEV_VIDEOBB_MODE_t eMode );

/***********************************************************************
 * FUNCTION : HAL_SYS_SetPowerLevel
 *
 * PURPOSE :
 *
 * PARAMETERS :
 *
 * RETURNS :
 *
 * USAGE :
 *
 ************************************************************************
 */

INT32 HAL_SYS_SetPowerLevel (DEVICE_POWER_LEVEL_t enLevel);

void HAL_SYS_SetExtDeviceDetect_Notify(EXT_DEVICE_DETECT_NOTIFY_FUNC_t  fnNotifyFunc);

VL_SNMP_API_RESULT HAL_SYS_SnmpRequest(VL_SNMP_REQUEST eRequest, void * _pvStruct);

void HAL_SYS_GetStbHostMemoryInfo(VL_SNMP_HostMemoryInfo   *pStbHostMemoryInfo);

//Memory need to be allocated for the pStbSystemMemoryReportTable. i.e (*pMemTableSize * sizeof(vlStbSystemMemoryReportTable))
void HAL_SYS_GetStbHostSystemMemoryTable(unsigned int *pMemTableSize, VL_SNMP_SystemMemoryReportEntry *pStbSystemMemoryReportTable);

//End - For SNMP api support

INT32 HAL_SYS_GetStbHostHddInfo(int type, void * _pvData);
#ifdef __cplusplus
}
#endif

#endif //SYS_API_H
