/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




#ifdef USE_CDL

//#define VL_CDL_UNIT_TEST

/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "utilityMacros.h"
#include "rmf_osal_resreg.h"

extern "C" {
#include "EstbCommonDownloadInterface.h"
#include "rProgramStoreCustomerApi.h"
}

//#include "CmAppMain.h"
#include "hal_module.h"
#include "vl_cdl_api.h"
#include "snmp_types.h"
#include "../halmfr/vl_mfr_api.h"
#include "rmf_osal_thread.h"
#include "sys_api.h"


#ifndef LEGACY_NEXUS
#undef VL_VALUE_4_FROM_ARRAY
#define VL_VALUE_4_FROM_ARRAY(ipAddr) 4,ipAddr
#endif

#if 0
#ifdef __cplusplus
extern "C" {
#endif
#include "dhs_defines.h"
#include "dhs_db.h"
#include "dhs_api.h"
#include "vl_dsg_service.h"
#include "dsg_rpc_cm2h.h"
#include "dsg_rpc_h2cm_api.h"
#include "dsg_rpc_cm2h.h"
h2cm_return_code_e  ecm_dsgRcvSwdlDataBlock(int len, char * data);
#ifdef __cplusplus
}
#endif
#endif

#include "rdk_debug.h"
#include "rmf_osal_mem.h"

#define VL_MONOLITH_STORAGE_PATH "vlmonolith.bin"
#define HAL_SUCCESS 0
#define VL_CDL_REPORT_FILE  "/tmp/pre_cdl_report.txt"
#define VL_CDL_DEFERRED_REBOOT_FILE     "/tmp/cdl_deferred_reboot_enabled"
//int HAL_CDL_notify_driver_event(VL_CDL_DRIVER_EVENT_TYPE eEvent, unsigned long nEventData);
VL_SNMP_API_RESULT HAL_SYS_SnmpRequest(VL_SNMP_REQUEST eRequest, void * _pvStruct);

#ifndef LEGACY_NEXUS
typedef void (*VL_BCM_CDL_DOWNLOAD_RESULT_CALLBACK  )(CommonDownloadExtNotificationMsg message);
#else
typedef void (*VL_BCM_CDL_DOWNLOAD_RESULT_CALLBACK  )(CommonDownloadNotificationMsg message);
#endif

typedef int (*VL_BCM_CDL_DOWNLOAD_QUESTION_CALLBACK)(void);
//typedef unsigned int (*VL_BCM_CDL_IS_VALID_IMAGE_HEADER_CALLBACK) (unsigned char * pBuf, int nBytes);
typedef unsigned int (*VL_BCM_CDL_IS_VALID_IMAGE_HEADER_CALLBACK) (void);
typedef int (*VL_BCM_CDL_DOWNLOAD_PROGRESS_CALLBACK)(TftpDownloadTrigger);

static void vlInitDefaultCdlPath(char * pszImageName);

static VL_CDL_TRIGGER_TYPE      vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
static VL_CDL_TRIGGER_TYPE      vlg_eCdl_DRIVER_DownloadStatus  = VL_CDL_TRIGGER_TYPE_NONE;
static int                      vlg_bIsRebooting                = 0;
static VL_CDL_IMAGE_TYPE        vlg_eCurrentDownloadType        = VL_CDL_IMAGE_TYPE_INVALID;
static VL_CDL_IMAGE_SIGN        vlg_eCurrentDownloadSign        = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
static rmf_osal_ThreadId vlg_cdl_download_monitor_threadid = 0;
static int vlg_bMonitorCdlProgress = 0;
static VL_CDL_DOWNLOAD_PROGRESS_NOTIFICATION vlg_downloadProgress;

static char vlg_szUpgradeImageName[VL_MAX_CDL_STR_SIZE];
static char vlg_szUpgradeImagePathName[VL_MAX_CDL_STR_SIZE];
extern int vlg_bDsgTwoWayMode;

static unsigned char * vlg_pPublicKey = NULL;
static int vlg_nPublicKeySize = 0;

static unsigned char * vlg_pCsCvc = NULL;
static int vlg_nCsCvcSize = 0;
static unsigned char * vlg_pMfrCvc = NULL;
static int vlg_nMfrCvcSize = 0;
static rmf_osal_ThreadId vlg_estb_upgrade_handler_threadid = 0;
static int vlg_bEcmSwUpgradeCompleted = FALSE;
static int vlg_bEcmSwUpgradeAborted = FALSE;
void vlDsgSuppressRebootOnEcmReset(int bSuppressed);
extern void HAL_SYS_Reboot(const char * pszRequestor, const char * pszReason);

VL_MFR_UPGRADE_IMAGE_TYPE vlTranslateCdlImageType2MfrImageType(VL_CDL_IMAGE_TYPE eCdlImageType)
{
    return (VL_MFR_UPGRADE_IMAGE_TYPE)(eCdlImageType);
}

VL_CDL_IMAGE_TYPE vlTranslateMfrImageType2CdlImageType(VL_MFR_UPGRADE_IMAGE_TYPE eMfrImageType)
{
    return (VL_CDL_IMAGE_TYPE)(eMfrImageType);
}

void vlCdlPerformLocalUpgrade(VL_CDL_IMAGE * pCdlImage)
{
    // notify that the upgrade has started
     RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_UPGRADE_STARTED\n", __FUNCTION__);
    HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_UPGRADE_STARTED, VL_CDL_IMAGE_TYPE_MONOLITHIC);
    // perform the upgrade
     RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Requesting VL_CDL_MANAGER_EVENT_UPGRADE_TO_IMAGE\n", __FUNCTION__);
    if(VL_CDL_RESULT_SUCCESS ==HAL_CDL_notify_mgr_event(0, VL_CDL_MANAGER_EVENT_UPGRADE_TO_IMAGE, (unsigned long)pCdlImage))
    {
        // notify that the upgrade has completed
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_UPGRADE_COMPLETED\n", __FUNCTION__);
        HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_UPGRADE_COMPLETED, VL_CDL_IMAGE_TYPE_MONOLITHIC);

        //`remove(vlg_szUpgradeImagePathName); // Jan-04-2013: XONE-1831, RDK-1032 : Upgrade completed, so delete downloaded file.

        {// Jan-04-2013: XONE-1831, RDK-1032 : Implementation for Deferred Reboot after CDL completion
            struct stat st;
            memset(&st,0,sizeof(st));
            
            if(0 == stat(VL_CDL_DEFERRED_REBOOT_FILE, &st) && (0 != st.st_ino))
            {
                // Jan-30-2013: XONE-6554: Notifiy CDL completed to eCM.
                //ecm_dsgNotifySwdlCompleted();
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", "vlCdlPerformLocalUpgrade: '%s' exists. Not rebooting now. Reboot after CDL will be managed by XMON.\n", VL_CDL_DEFERRED_REBOOT_FILE);
                return; // Returning here. Reboot after CDL will be managed by XMON.
            }
            else
            {
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", "vlCdlPerformLocalUpgrade: '%s' does not exist. Proceeding with normal CDL reboot...\n", VL_CDL_DEFERRED_REBOOT_FILE);
                // Continuing with reboot below...
            }
        }

        // notify that the device is rebooting
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_REBOOTING_AFTER_UPGRADE\n", __FUNCTION__);
        HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_REBOOTING_AFTER_UPGRADE, VL_CDL_IMAGE_TYPE_MONOLITHIC);
        // reboot the device
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Requesting VL_CDL_MANAGER_EVENT_REBOOT\n", __FUNCTION__);
        HAL_CDL_notify_mgr_event(0, VL_CDL_MANAGER_EVENT_REBOOT, (unsigned long)NULL);
    }
    else
    {
        //remove(vlg_szUpgradeImagePathName);
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_UPGRADE_FAILED\n", __FUNCTION__);
        HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_UPGRADE_FAILED, VL_CDL_IMAGE_TYPE_MONOLITHIC);
    }
}

char * vlCdlGetImagePathName()
{
    return vlg_szUpgradeImagePathName;
}

int vlBcmCdlIsMonolithicImageValidCallback()
{
    VL_CDL_IMAGE cdlImage;
    struct stat st;

#if 0 
    VL_ZERO_MEMORY(cdlImage);
    VL_ZERO_MEMORY(st);
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", "vlBcmCdlIsMonolithicImageValidCallback: Received the callback\n");
    cdlImage.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
    cdlImage.eImageType   = vlg_eCurrentDownloadType;
    cdlImage.eImageSign   = vlg_eCurrentDownloadSign;
        //cdlImage.IsImageValid   = 0;
    strncpy(cdlImage.szSoftwareImageName, vlg_szUpgradeImageName, sizeof(cdlImage.szSoftwareImageName));
    cdlImage.pszImagePathName = vlCdlGetImagePathName();
        // cdlImage.nFileBytes = strlen(cdlImage.pszImagePathName );
        
    HAL_CDL_notify_driver_event(VL_CDL_DRIVER_EVENT_IS_VALID_FULL_IMAGE, (unsigned long)&cdlImage);

        return cdlImage.IsImageValid;
#endif

    return 1;


}

int vlBcmCdlIsValidImageHeaderCallback(unsigned char * pBuf, int nBytes)
{
    RDK_LOG(RDK_LOG_DEBUG, HAL_MODULE_CDL,"%s() : nBytes = %d\n", __FUNCTION__, nBytes);
    //vlMpeosDumpBuffer(MPE_LOG_INFO, "LOG.RDK.CDL", pBuf, nBytes);
    if(NULL != pBuf)
    {
        VL_CDL_QUESTION_IS_VALID_IMAGE_HEADER question;
        memset(&question, 0, sizeof(VL_CDL_QUESTION_IS_VALID_IMAGE_HEADER));
        question.imageHeader.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
        question.imageHeader.eImageType   = vlg_eCurrentDownloadType;
        question.imageHeader.eImageSign   = vlg_eCurrentDownloadSign;
        if(VL_CDL_IMAGE_TYPE_INVALID == vlg_eCurrentDownloadType)
        {
            question.imageHeader.eTriggerType = VL_CDL_TRIGGER_TYPE_ECM_SNMP;
            question.imageHeader.eImageType   = VL_CDL_IMAGE_TYPE_MONOLITHIC;
            question.imageHeader.eImageSign   = VL_CDL_IMAGE_UNSIGNED;
        }

        question.imageHeader.header.nBytes = nBytes;
        question.imageHeader.header.pData  = (unsigned char*)pBuf;
        question.bIsValidImageHeader = 1;
        HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IS_VALID_IMAGE_HEADER, (unsigned long)&question);
        return question.bIsValidImageHeader;
    }

    return 0;
}


void vlCdlStopDownloadMonitorThread()
{
    vlg_bMonitorCdlProgress = 0;
  
	rmf_osal_threadSleep(1500, 0);
    if(0 != vlg_cdl_download_monitor_threadid)
    {
     rmf_osal_threadDestroy(vlg_cdl_download_monitor_threadid);
    }
	 memset(&vlg_downloadProgress, 0, sizeof(vlg_downloadProgress));
}

#ifndef LEGACY_NEXUS
void vlBcmCdlProcessEcmNotification(CommonDownloadExtNotificationMsg message)
#else
void vlBcmCdlProcessEcmNotification(CommonDownloadNotificationMsg message)
#endif
{
    switch(message.eventCode)
    {
        case kMonolithicImageAuthenticationFailed:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_AUTH_FAIL : VL_CDL_IMAGE_TYPE_MONOLITHIC\n", __FUNCTION__);
            HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_AUTH_FAIL, VL_CDL_IMAGE_TYPE_MONOLITHIC); // auth & monolithic only for ecm triggers
            vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
            vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
            vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;

        }
        break;

        case kMonolithicImageAuthenticationSuccessful:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_AUTH_SUCCESS : VL_CDL_IMAGE_TYPE_MONOLITHIC\n", __FUNCTION__);
            HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_AUTH_SUCCESS, VL_CDL_IMAGE_TYPE_MONOLITHIC); // auth & monolithic only for ecm triggers
        }
        break;

        case kMonolithicImageDownloadFailed:
        {
            switch(vlg_eCurrentDownloadType)
            {
                case VL_CDL_IMAGE_TYPE_MONOLITHIC   : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : Image Type = MONOLITHIC \n", __FUNCTION__); break;
                case VL_CDL_IMAGE_TYPE_FIRMWARE     : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : Image Type = FIRMWARE   \n", __FUNCTION__); break;
                case VL_CDL_IMAGE_TYPE_APPLICATION  : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : Image Type = APPLICATION\n", __FUNCTION__); break;
                case VL_CDL_IMAGE_TYPE_DATA         : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : Image Type = DATA       \n", __FUNCTION__); break;
                case VL_CDL_IMAGE_TYPE_INVALID      : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : Image Type = INVALID    \n", __FUNCTION__); break;
                case VL_CDL_IMAGE_TYPE_ECM          : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : Image Type = ECM        \n", __FUNCTION__); break;
            }
            // stop cdl monitor thread
            vlCdlStopDownloadMonitorThread();
            {
                VL_CDL_DOWNLOAD_FAIL_NOTIFICATION failNotification;
                struct stat st;
                char * pszImagePathName = NULL;
                //VL_ZERO_MEMORY(st);
		memset(&st, 0, sizeof(struct stat));
                //VL_ZERO_MEMORY(failNotification);
		memset(&failNotification, 0, sizeof(VL_CDL_DOWNLOAD_FAIL_NOTIFICATION));

                pszImagePathName = vlCdlGetImagePathName();
                if(0 == stat(pszImagePathName, &st))
                {
                    if(0 == st.st_size)
                    {
                        failNotification.eFailReason = VL_CDL_DOWNLOAD_FAIL_REASON_FILE_NOT_FOUND;
                        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Download Fail Reason : FILE_NOT_FOUND\n", __FUNCTION__);
                    }
                    else
                    {
                        failNotification.eFailReason = VL_CDL_DOWNLOAD_FAIL_REASON_TRANSFER_FAILED;
                        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Download Fail Reason : TRANSFER FAILED\n", __FUNCTION__);
                    }
                }
                else
                {
                    failNotification.eFailReason = VL_CDL_DOWNLOAD_FAIL_REASON_FILE_NOT_FOUND;
                    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Download Fail Reason : FILE_NOT_FOUND\n", __FUNCTION__);
                }

                failNotification.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
                failNotification.eImageType   = vlg_eCurrentDownloadType;
                failNotification.eImageSign   = vlg_eCurrentDownloadSign;
                HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED, (unsigned long)&failNotification);
                vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
                vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
                vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
                remove(VL_CDL_DEFERRED_REBOOT_FILE); // Feb-25-2013: RDK-1437 : CDL failed. If there was no reboot then delete deferred reboot flag.
            }
        }
        break;

        case kMonolithicImageDownloadSuccessful:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received kMonolithicImageDownloadSuccessful\n", __FUNCTION__);
            if(VL_CDL_IMAGE_TYPE_INVALID == vlg_eCurrentDownloadType)
            {
                vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_MONOLITHIC;
                vlg_eCurrentDownloadSign = VL_CDL_IMAGE_UNSIGNED;
            }
            // stop cdl monitor thread
            vlCdlStopDownloadMonitorThread();
            {
                VL_CDL_IMAGE cdlImage;
                struct stat st;

                //VL_ZERO_MEMORY(cdlImage);
		memset(&cdlImage, 0, sizeof(VL_CDL_IMAGE));
                //VL_ZERO_MEMORY(st);
		memset(&st, 0, sizeof(struct stat));

                cdlImage.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
                cdlImage.eImageType   = vlg_eCurrentDownloadType;
                cdlImage.eImageSign   = vlg_eCurrentDownloadSign;
                memset(cdlImage.szSoftwareImageName, 0, sizeof(cdlImage.szSoftwareImageName));
                strncpy(cdlImage.szSoftwareImageName, vlg_szUpgradeImageName, sizeof(cdlImage.szSoftwareImageName) - 1);
                cdlImage.pszImagePathName = vlCdlGetImagePathName();

                if(0 == stat(cdlImage.pszImagePathName, &st))
                {
                    cdlImage.nFileBytes = st.st_size;
                }

                switch(cdlImage.eTriggerType)
                {
                    case VL_CDL_TRIGGER_TYPE_ECM_CONFIG_FILE : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger Type = ECM_CONFIG_FILE\n", __FUNCTION__); break;
                    case VL_CDL_TRIGGER_TYPE_ECM_SNMP        : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger Type = SNMP           \n", __FUNCTION__); break;
                    case VL_CDL_TRIGGER_TYPE_STB_CVT         : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger Type = CVT            \n", __FUNCTION__); break;
                    default                                  : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger Type = %d             \n", __FUNCTION__, cdlImage.eTriggerType); break;
                }

                switch(cdlImage.eImageType)
                {
                    case VL_CDL_IMAGE_TYPE_MONOLITHIC   : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = MONOLITHIC \n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_TYPE_FIRMWARE     : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = FIRMWARE   \n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_TYPE_APPLICATION  : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = APPLICATION\n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_TYPE_DATA         : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = DATA       \n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_TYPE_INVALID      : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = INVALID    \n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_TYPE_ECM          : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = ECM        \n", __FUNCTION__); break;
                    default                             : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Type = %d         \n", __FUNCTION__, cdlImage.eImageType); break;
                }

                switch(cdlImage.eImageSign)
                {
                    case VL_CDL_IMAGE_SIGN_NOT_SPECIFIED: RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Sign = NOT SPECIFIED \n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_SIGNED            : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Sign = SIGNED     \n", __FUNCTION__); break;
                    case VL_CDL_IMAGE_UNSIGNED          : RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Sign = UNSIGNED   \n", __FUNCTION__); break;
                }

                RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Name = '%s'\n", __FUNCTION__, cdlImage.szSoftwareImageName);
                RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Path = '%s'\n", __FUNCTION__, cdlImage.pszImagePathName);
                RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Size = %d bytes.\n", __FUNCTION__, cdlImage.nFileBytes);
                RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_DOWNLOAD_COMPLETED\n", __FUNCTION__);
                HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_DOWNLOAD_COMPLETED, (unsigned long)&cdlImage);

                if((VL_CDL_TRIGGER_TYPE_STB_CVT  != vlg_eCdl_DRIVER_DownloadStatus) &&
                   (VL_CDL_IMAGE_TYPE_MONOLITHIC == vlg_eCurrentDownloadType      ) &&
                   (VL_CDL_IMAGE_UNSIGNED        == vlg_eCurrentDownloadSign      ))
                {
                    vlCdlPerformLocalUpgrade(&cdlImage);
                    remove(VL_CDL_DEFERRED_REBOOT_FILE); // Feb-25-2013: RDK-1437 : Upgrade succeeded. If there was no reboot then delete deferred reboot flag.
                }
            }

            vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
            vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
            vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
        }
        break;

        case kEcmImageAuthenticationFailed:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_AUTH_FAIL : VL_CDL_IMAGE_TYPE_ECM\n", __FUNCTION__);
            HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_AUTH_FAIL, VL_CDL_IMAGE_TYPE_ECM);
            vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
            vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
            vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
        }
        break;

        case kEcmImageAuthenticationSuccessful:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_AUTH_SUCCESS : VL_CDL_IMAGE_TYPE_ECM\n", __FUNCTION__);
            HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_AUTH_SUCCESS, VL_CDL_IMAGE_TYPE_ECM);
        }
        break;

        case kEcmImageDownloadFailed:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED : VL_CDL_IMAGE_TYPE_ECM\n", __FUNCTION__);
            HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_FAILED, VL_CDL_IMAGE_TYPE_ECM);
            vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
            vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
            vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
        }
        break;

        case kEcmImageDownloadSuccessful:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_DOWNLOAD_COMPLETED : VL_CDL_IMAGE_TYPE_ECM\n", __FUNCTION__);
            HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_DOWNLOAD_COMPLETED, VL_CDL_IMAGE_TYPE_ECM);
            vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
            vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
            vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
        }
        break;

        case kConfigFileSwDloadTrigger:
        case kSnmpSwDloadTrigger:
        case kCvtSwDloadTrigger:
        {
            RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received SwDloadTrigger(%d), image name %s\n", __FUNCTION__, message.eventCode, (char *)message.pEventValue);
            memset(vlg_szUpgradeImageName, 0, sizeof(vlg_szUpgradeImageName));
            strncpy(vlg_szUpgradeImageName, (char *)message.pEventValue, sizeof(vlg_szUpgradeImageName)-1);
        }
        break;

#if 0
                case kConfigFileTrigger:
                {
                        HAL_CDL_notify_driver_event(VL_CDL_DRIVER_EVENT_ECM_TRIGGER_CONFIGFILE, 0);
                        break;
                }
                case kSnmpTrigger:
                {
                        HAL_CDL_notify_driver_event(VL_CDL_DRIVER_EVENT_ECM_TRIGGER_SNMP, 0);
                        break;
                }
#endif
    }
}

void vlg_cdl_pre_download_report_task(void* arg)
{
    RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", "%s: Invoking 'sh ../bin/scripts/pre_cdl_script_background.sh'...\n", __FUNCTION__);
    system("sh ../bin/scripts/pre_cdl_script_background.sh");
    FILE * fp = fopen(VL_CDL_REPORT_FILE, "r");
    if(NULL != fp)
    {
        char szBuf[VL_MAX_CDL_STR_SIZE+1];
        //VL_ZERO_MEMORY(szBuf);
	memset(szBuf, 0, (VL_MAX_CDL_STR_SIZE+1)*sizeof(char));
        while(NULL != fgets(szBuf, VL_MAX_CDL_STR_SIZE, fp))
        {
            RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", "%s", szBuf);
        }
        fclose(fp);
    }
}

int vlBcmCdlIsSwUpgradePermittedNowCallback(void)
{
    VL_CDL_RESULT ret = VL_CDL_RESULT_SUCCESS;
    VL_CDL_QUESTION_IS_DOWNLOAD_PERMITTED question;
    //VL_ZERO_MEMORY(question);
    memset(&question, 0, sizeof(VL_CDL_QUESTION_IS_DOWNLOAD_PERMITTED));
    if(VL_CDL_TRIGGER_TYPE_STB_CVT == vlg_eCdl_MANAGER_DownloadStatus)
    {
        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Manager is servicing CVT, refusing permission to download.\n", __FUNCTION__);
        return 0;
    }
    question.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
    question.eImageType   = vlg_eCurrentDownloadType;
    question.eImageSign   = vlg_eCurrentDownloadSign;
    if(VL_CDL_IMAGE_TYPE_INVALID == vlg_eCurrentDownloadType)
    {
        question.eTriggerType = VL_CDL_TRIGGER_TYPE_ECM_SNMP;
        question.eImageType   = VL_CDL_IMAGE_TYPE_MONOLITHIC;
        question.eImageSign   = VL_CDL_IMAGE_UNSIGNED;
    }
    question.bIsDownloadPermitted = 1;
    if(0 != strcmp(kDefaultSymLinkToNewMonolith, vlg_szUpgradeImageName))
    {
        strncpy(question.szSoftwareImageName, vlg_szUpgradeImageName, sizeof(question.szSoftwareImageName));
        question.szSoftwareImageName[sizeof(question.szSoftwareImageName)-1] = '\0';
    }
    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_IS_DOWNLOAD_PERMITTED\n", __FUNCTION__);
    ret = (VL_CDL_RESULT)HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IS_DOWNLOAD_PERMITTED, (unsigned long)(&question));

    switch(ret)
    {
        case VL_CDL_RESULT_SUCCESS:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Answer to question is 'Download is %s'.\n", __FUNCTION__, (question.bIsDownloadPermitted?"Permitted":"Not Permitted"));
            if(question.bIsDownloadPermitted)
            {
                rmf_osal_ThreadId threadid;
                RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", "%s: Invoking 'sh ../bin/scripts/pre_cdl_script_foreground.sh'...\n", __FUNCTION__);
                system("sh ../bin/scripts/pre_cdl_script_foreground.sh");
                //cThreadCreateSimple("vlg_cdl_pre_download_report_task", vlg_cdl_pre_download_report_task, (long)NULL);
	        rmf_osal_threadCreate(vlg_cdl_pre_download_report_task, NULL , RMF_OSAL_THREAD_PRIOR_DFLT, RMF_OSAL_THREAD_STACK_SIZE,& threadid, "vlg_cdl_pre_download_report_task");
            }
            return question.bIsDownloadPermitted;
        }
        break;

        case VL_CDL_RESULT_NOT_IMPLEMENTED:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : No answer from manager, giving permission to download.\n", __FUNCTION__);
            return 1;
        }
        break;

        default:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Manager gave odd reply, refusing permission to download.\n", __FUNCTION__);
            vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
            return 0;
        }
        break;
    }

#if 0 /*CID - 18680 dead code. fn will return in switch case*/
    // return not permitted
    vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
    return 0;
#endif
}

void vlg_cdl_download_monitor_task(void *arg)
{
    int DownloadInit = 0;
    struct stat st;
    memset(&st, 0, sizeof(st));

     memset(&vlg_downloadProgress, 0, sizeof(vlg_downloadProgress));

    
    arg = arg;
    vlg_downloadProgress.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
    vlg_downloadProgress.eImageType   = vlg_eCurrentDownloadType;
    vlg_downloadProgress.eImageSign   = vlg_eCurrentDownloadSign;
    char * pszImagePathName = vlCdlGetImagePathName();
    
    while(vlg_bMonitorCdlProgress)
    {
        if(NULL != pszImagePathName)
        {
            if(0 == stat(pszImagePathName, &st))
            {
               if(DownloadInit == 0)
               {
                   DownloadInit = 1;
                   vlg_downloadProgress.nBytesDownloaded = 0;
               }
               else
               {
                   vlg_downloadProgress.nBytesDownloaded = st.st_size;
               }
                
          }

        }
        // MAY-24-2012: Patch for XONE-1873: Do not notify a progress of 0 bytes.
        if(0 != vlg_downloadProgress.nBytesDownloaded)
        {
		RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Downloaded Size = %d bytes.\n", __FUNCTION__, vlg_downloadProgress.nBytesDownloaded);
		HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_IMAGE_DOWNLOAD_PROGRESS, (unsigned long)&vlg_downloadProgress);
        }
        rmf_osal_threadSleep(1000,0);
    }
    
    vlg_cdl_download_monitor_threadid = 0;
}

int vlBcmCdlSwUpgradeProgressCallback(TftpDownloadTrigger eBcmTrigger)
{
    VL_CDL_TRIGGER_TYPE eVlTrigger = VL_CDL_TRIGGER_TYPE_ECM_CONFIG_FILE;
    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received vlBcmCdlSwUpgradeProgressCallback\n", __FUNCTION__);
    switch(eBcmTrigger)
    {
        case kTftpDownloadTriggerEcmCfgFile:
        {
            eVlTrigger = VL_CDL_TRIGGER_TYPE_ECM_CONFIG_FILE;
        }
        break;

        case kTftpDownloadTriggerSnmp      :
        {
            eVlTrigger = VL_CDL_TRIGGER_TYPE_ECM_SNMP;
        }
        break;

        case kTftpDownloadTriggerCvt       :
        {
            eVlTrigger = VL_CDL_TRIGGER_TYPE_STB_CVT;
        }
        break;
    }

    if(VL_CDL_TRIGGER_TYPE_NONE == vlg_eCdl_DRIVER_DownloadStatus)
    {
        vlg_eCdl_DRIVER_DownloadStatus = eVlTrigger;
    }
    switch(vlg_eCdl_DRIVER_DownloadStatus)
    {
        case VL_CDL_TRIGGER_TYPE_ECM_CONFIG_FILE:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger type is ECM_CONFIG_FILE\n", __FUNCTION__);
        }
        break;

        case VL_CDL_TRIGGER_TYPE_ECM_SNMP      :
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger type is SNMP\n", __FUNCTION__);
        }
        break;

        case VL_CDL_TRIGGER_TYPE_STB_CVT       :
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger type is CVT\n", __FUNCTION__);
        }
        break;

        default:
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Trigger Type = %d             \n", __FUNCTION__, vlg_eCdl_DRIVER_DownloadStatus);
        }
        break;
    }

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_DOWNLOAD_STARTED\n", __FUNCTION__);
    HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_DOWNLOAD_STARTED, eVlTrigger);

    vlg_bMonitorCdlProgress = 1;
    //vlg_cdl_download_monitor_threadid = cThreadCreateSimple("vlg_cdl_download_monitor_task", vlg_cdl_download_monitor_task, (long)NULL);
    rmf_osal_threadCreate(vlg_cdl_download_monitor_task, NULL , RMF_OSAL_THREAD_PRIOR_DFLT, RMF_OSAL_THREAD_STACK_SIZE,&vlg_cdl_download_monitor_threadid, "vlg_cdl_download_monitor_task");

    return 0;
}

/*
void vlCdlEnableSSDL()
{
    unsigned long dlt1 = 10000; // 10 seconds
    unsigned long dlt2 = 10000; // 10 seconds
    unsigned long dlt3 = 600000; // 10 minutes
    dhs_dbSetSWDLFormatType(SWDL_DOCSIS_ENCRYPTED);
    dhs_dbSetSWDLTimerByIndex(1, dlt1);
    dhs_dbSetSWDLTimerByIndex(2, dlt2);
    dhs_dbSetSWDLTimerByIndex(3, dlt3);
    
    if(NULL != vlg_pPublicKey)
    {
        if(ecm_dsgInstallEcmPublicKey(vlg_nPublicKeySize, (char*) vlg_pPublicKey) == OK)
        {
             RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: Install public key success.\n", __FUNCTION__);
        }
        else
        {
             RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: Install public key fail.\n", __FUNCTION__);
        }
    }
    if(NULL != vlg_pCsCvc)
    {
        dhs_dbSetSWDLCVCType(SWDL_CVT_CS_CVC);
        if(ecm_dsgCheckCvcValidity(SWDL_CVT_CS_CVC, vlg_nCsCvcSize, (char*) vlg_pCsCvc) == OK)
        {
           RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: check SWDL_CVT_CS_CVC success.\n", __FUNCTION__);
        }
        else
        {
            RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: check SWDL_CVT_CS_CVC fail.\n", __FUNCTION__);
        }
    }
    if(NULL != vlg_pMfrCvc)
    {
        dhs_dbSetSWDLCVCType(SWDL_CVT_MFG_CVC);
        if(ecm_dsgCheckCvcValidity(SWDL_CVT_MFG_CVC, vlg_nMfrCvcSize,(char*) vlg_pMfrCvc) == OK)
        {
             RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: check SWDL_CVT_MFG_CVC success.\n", __FUNCTION__);
        }
        else
        {
             RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: check SWDL_CVT_MFG_CVC fail.\n", __FUNCTION__);
        }
    }
    if(ecm_dsgConfigureSwdlParams(1) == OK)
    {
	    dhs_dbSetDocsisSsdlEnable(1);
    }
    else
    {
		 RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: configure swdl docsis SSDL fail.\n", __FUNCTION__);
    }
}
*/
void vl_cdl_fp_service(void * arg)
{
	rmf_osal_threadSleep(80000, 0);
#ifdef VL_CDL_UNIT_TEST
    int ret = 0;
    //unsigned char tftpIpAddress[] = {10, 100, 11, 31};
    unsigned char tftpIpAddress[] = {172, 20, 0, 1};
    //unsigned char tftpIpAddress[] = {10,50,1,11};
    unsigned char * imagePathName = (unsigned char*)("vlocap.ocappkcs7");
    RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : vl_cdl_fp_test\n", __FUNCTION__);
    arg = arg;
    {
        VL_CDL_DOWNLOAD_PARAMS downloadParams;
		 memset(&downloadParams, 0, sizeof(downloadParams));
        downloadParams.eImageType = VL_CDL_IMAGE_TYPE_APPLICATION;
        downloadParams.eImageSign = VL_CDL_IMAGE_UNSIGNED;
        //downloadParams.pszImageName = "pace_signed_packed_apr_29_2010.bin";//"P6_eval_100201_CDL_ecm.img";
        downloadParams.pszImageName = "7FUNA672.img";
        memcpy(downloadParams.tftpIpAddress, tftpIpAddress, sizeof(tftpIpAddress));
        HAL_CDL_notify_mgr_event(0, VL_CDL_MANAGER_EVENT_START_DOWNLOAD, (unsigned long)&downloadParams);
    }
    
#endif // VL_CDL_UNIT_TEST
}

void vl_cdl_start_service()
{
    rmf_osal_ThreadId threadid = 0;
    void * arg = NULL;
    // Feb-04-2009: Moved to vl_dsg_service.c //pthread_create(&threadid, NULL, vl_cdl_fp_service, arg);
   
	rmf_osal_threadCreate(vl_cdl_fp_service, arg , RMF_OSAL_THREAD_PRIOR_DFLT, RMF_OSAL_THREAD_STACK_SIZE,& threadid, "vl_cdl_fp_service");
}

void vlBcmCdlInit()
{
    //LOGDEBUG(HAL_MODULE_CDL,"%s() : Calling CommonDownloadSetEcmNotificationCallback()\n", __FUNCTION__);
    CommonDownloadSetEcmNotificationCallback        ((VL_BCM_CDL_DOWNLOAD_RESULT_CALLBACK   )(vlBcmCdlProcessEcmNotification            ));

    //LOGDEBUG(HAL_MODULE_CDL,"%s() : Calling EstbSwUpgrade_IsUpgradePermittedNowSetCallback()\n", __FUNCTION__);
    EstbSwUpgrade_IsUpgradePermittedNowSetCallback  ((VL_BCM_CDL_DOWNLOAD_QUESTION_CALLBACK )(vlBcmCdlIsSwUpgradePermittedNowCallback   ));
   // EstbSwUpgrade_IsMonolithicImageHeaderValidSetCallback((VL_BCM_CDL_IS_VALID_IMAGE_HEADER_CALLBACK)(vlBcmCdlIsValidImageHeaderCallback));
    EstbSwUpgrade_IsMonolithicImageValidSetCallback((VL_BCM_CDL_IS_VALID_IMAGE_HEADER_CALLBACK)(vlBcmCdlIsMonolithicImageValidCallback));
    //LOGDEBUG(HAL_MODULE_CDL,"%s() : Calling EstbSwUpgrade_InProgressSetCallback()\n", __FUNCTION__);
    EstbSwUpgrade_InProgressSetCallback             ((VL_BCM_CDL_DOWNLOAD_PROGRESS_CALLBACK )(vlBcmCdlSwUpgradeProgressCallback         ));

    //LOGDEBUG(HAL_MODULE_CDL,"%s() : Calling vl_cdl_start_service()\n", __FUNCTION__);
    vl_cdl_start_service();

    memset(vlg_szUpgradeImageName, 0, sizeof(vlg_szUpgradeImageName));
    strncpy(vlg_szUpgradeImageName, kDefaultSymLinkToNewMonolith, sizeof(vlg_szUpgradeImageName) - 1);
    memset(vlg_szUpgradeImagePathName, 0, sizeof(vlg_szUpgradeImagePathName));
    strncpy(vlg_szUpgradeImagePathName, kDefaultSymLinkToNewMonolith, sizeof(vlg_szUpgradeImagePathName) - 1);
}

int vlCdlGetDownloadStatusByImageName(VL_CDL_DOWNLOAD_STATUS_QUESTION * pStruct)
{
#ifdef USE_MFR
    VL_MFR_SOFTWARE_IMAGE_NAME previousName, currentName, nextName;

    //VL_ZERO_MEMORY(previousName); 
    memset(&previousName, 0, sizeof(VL_MFR_SOFTWARE_IMAGE_NAME));
    //VL_ZERO_MEMORY(currentName); 
    memset(&currentName, 0, sizeof(VL_MFR_SOFTWARE_IMAGE_NAME));
    //VL_ZERO_MEMORY(nextName);
    memset(&nextName, 0, sizeof(VL_MFR_SOFTWARE_IMAGE_NAME));
    // check if system is in idle state
    if(VL_MFR_API_RESULT_SUCCESS == HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_UPGRADE_IMAGE_NAME     , &nextName))
    {
        if(0 == strlen(nextName.szSoftwareImageName))
        {
            pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_IDLE;
        }
    }
    else
    {
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UNKNOWN;
        return VL_CDL_RESULT_SUCCESS;
    }
    if(VL_MFR_API_RESULT_SUCCESS == HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_CURRENT_BOOT_IMAGE_NAME    , &currentName))
    {
        if(0 == strlen(currentName.szSoftwareImageName))
        {
            pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UNKNOWN;
            return VL_CDL_RESULT_SUCCESS;
        }
    }
    else
    {
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UNKNOWN;
        return VL_CDL_RESULT_SUCCESS;
    }
    if(VL_MFR_API_RESULT_SUCCESS == HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_PREVIOUS_BOOT_IMAGE_NAME   , &previousName))
    {
        if(0 == strlen(previousName.szSoftwareImageName))
        {
            pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UNKNOWN;
            return VL_CDL_RESULT_SUCCESS;
        }
    }
    else
    {
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UNKNOWN;
        return VL_CDL_RESULT_SUCCESS;
    }
                // check if system is upgrading
    if((0 != strcmp(previousName.szSoftwareImageName, currentName.szSoftwareImageName)) &&
       (0 != strcmp(currentName.szSoftwareImageName , nextName.szSoftwareImageName   )))
    {
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UPGRADING;
    }

                // check if upgrade failed
    if((0 == strcmp(previousName.szSoftwareImageName, currentName.szSoftwareImageName)) &&
       (0 != strcmp(currentName.szSoftwareImageName , nextName.szSoftwareImageName   )))
    {
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_BOOTUP_AFTER_FAILED_UPGRADE;
    }

                // check if upgrade succeeded
    if((0 != strcmp(previousName.szSoftwareImageName, currentName.szSoftwareImageName)) &&
       (0 == strcmp(currentName.szSoftwareImageName , nextName.szSoftwareImageName   )))
    {
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_BOOTUP_AFTER_SUCCESSFUL_UPGRADE;
    }
#endif // USE_MFR
    return VL_CDL_RESULT_SUCCESS;
}

void vlCdlStartCdlService()
{
    //vlCdlEnableSSDL();
    vl_cdl_start_service();
}

void vlInitDefaultCdlPath(char * pszImageName)
{
    memset(vlg_szUpgradeImagePathName, 0, sizeof(vlg_szUpgradeImagePathName));
    memset(vlg_szUpgradeImageName, 0, sizeof(vlg_szUpgradeImageName));

    if(NULL != pszImageName)
    {
        strncpy(vlg_szUpgradeImageName, pszImageName, sizeof(vlg_szUpgradeImageName) -1);
    }
    if(strlen(vlg_szUpgradeImageName) > 0)
    {
        char *root_path = getenv ("PFC_ROOT");
        char *image_name = vlg_szUpgradeImageName;
        VL_MFR_CONFIG_PATH ConfigPath;
		memset(&ConfigPath, 0, sizeof(ConfigPath));
        
        ConfigPath.eConfigType = VL_MFR_CONFIG_TYPE_COMMON_DOWNLOAD;
        HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_CONFIG_PATH, &ConfigPath);
        if(strlen(ConfigPath.szConfigPath) > 0) root_path = ConfigPath.szConfigPath;
        
        if(NULL != root_path)
        {
            snprintf(vlg_szUpgradeImagePathName, sizeof(vlg_szUpgradeImagePathName), "%s", root_path);
            if(strlen(vlg_szUpgradeImagePathName)>0)
            {
                if(('/' != vlg_szUpgradeImagePathName[strlen(vlg_szUpgradeImagePathName)-1]) &&
                    (NULL != image_name) &&
                    ('/' != image_name[0]))
                {
                   strcat(vlg_szUpgradeImagePathName, "/");
                }
            }
        }
        strcat(vlg_szUpgradeImagePathName, vlg_szUpgradeImageName);
    }
}

void  vlg_estb_upgrade_handler(void * arg)
{
     RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : vlg_estb_upgrade_handler\n", __FUNCTION__);
    if(VL_CDL_IMAGE_TYPE_INVALID == vlg_eCurrentDownloadType)
    {
        vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_MONOLITHIC;
        vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGNED;
    }
    // stop cdl monitor thread
    vlCdlStopDownloadMonitorThread();
    {
        VL_CDL_IMAGE cdlImage;
        struct stat st;
        
		memset(&cdlImage, 0, sizeof(cdlImage));
	   
		memset(&st, 0, sizeof(st));
        
        cdlImage.eTriggerType = vlg_eCdl_DRIVER_DownloadStatus;
        cdlImage.eImageType   = vlg_eCurrentDownloadType;
        cdlImage.eImageSign   = vlg_eCurrentDownloadSign;
        strcpy(cdlImage.szSoftwareImageName, vlg_szUpgradeImageName);
        cdlImage.pszImagePathName = vlCdlGetImagePathName();
        
        if(0 == stat(cdlImage.pszImagePathName, &st))
        {
            cdlImage.nFileBytes = st.st_size;
        }
        
        switch(cdlImage.eTriggerType)
        {
            case VL_CDL_TRIGGER_TYPE_ECM_CONFIG_FILE :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Trigger Type = ECM_CONFIG_FILE\n", __FUNCTION__); break;
            case VL_CDL_TRIGGER_TYPE_ECM_SNMP        :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Trigger Type = SNMP           \n", __FUNCTION__); break;
            case VL_CDL_TRIGGER_TYPE_STB_CVT         :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Trigger Type = CVT            \n", __FUNCTION__); break;
            default                                  :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Trigger Type = %d             \n", __FUNCTION__, cdlImage.eTriggerType); break;
        }
        
        switch(cdlImage.eImageType)
        {
            case VL_CDL_IMAGE_TYPE_MONOLITHIC   :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = MONOLITHIC \n", __FUNCTION__); break;
            case VL_CDL_IMAGE_TYPE_FIRMWARE     :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = FIRMWARE   \n", __FUNCTION__); break;
            case VL_CDL_IMAGE_TYPE_APPLICATION  :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = APPLICATION\n", __FUNCTION__); break;
            case VL_CDL_IMAGE_TYPE_DATA         :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = DATA       \n", __FUNCTION__); break;
            case VL_CDL_IMAGE_TYPE_INVALID      :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = INVALID    \n", __FUNCTION__); break;
            case VL_CDL_IMAGE_TYPE_ECM          :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = ECM        \n", __FUNCTION__); break;
            default                             :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Type = %d         \n", __FUNCTION__, cdlImage.eImageType); break;
        }
        
        switch(cdlImage.eImageSign)
        {
            case VL_CDL_IMAGE_SIGN_NOT_SPECIFIED:  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Sign = NOT SPECIFIED \n", __FUNCTION__); break;
            case VL_CDL_IMAGE_SIGNED            :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Sign = SIGNED     \n", __FUNCTION__); break;
            case VL_CDL_IMAGE_UNSIGNED          :  RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Sign = UNSIGNED   \n", __FUNCTION__); break;
        }
        
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Name = '%s'\n", __FUNCTION__, cdlImage.szSoftwareImageName);
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Path = '%s'\n", __FUNCTION__, cdlImage.pszImagePathName);
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image Size = %d bytes.\n", __FUNCTION__, cdlImage.nFileBytes);
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Posting VL_CDL_DRIVER_EVENT_DOWNLOAD_COMPLETED\n", __FUNCTION__);
        HAL_CDL_notify_driver_event((VL_CDL_DRIVER_EVENT_TYPE)VL_CDL_DRIVER_EVENT_DOWNLOAD_COMPLETED, (unsigned long)&cdlImage);
        
        if((VL_CDL_TRIGGER_TYPE_STB_CVT  != vlg_eCdl_DRIVER_DownloadStatus) &&
           (VL_CDL_IMAGE_TYPE_MONOLITHIC == vlg_eCurrentDownloadType      ) &&
           (VL_CDL_IMAGE_SIGNED          == vlg_eCurrentDownloadSign      ))
        {
            vlCdlPerformLocalUpgrade(&cdlImage);
        }
    }
    
    vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
    vlg_eCurrentDownloadType = VL_CDL_IMAGE_TYPE_INVALID;
    vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGN_NOT_SPECIFIED;
    
    vlInitDefaultCdlPath((char *)VL_MONOLITH_STORAGE_PATH);
    
    vlg_estb_upgrade_handler_threadid = 0;
}

int HAL_CDL_notify_mgr_event( VL_CDL_DEVICE_HANDLE_t hCDLHandle, VL_CDL_MANAGER_EVENT_TYPE eEvent, unsigned long nEventData)
{
    unsigned char cvcType = 0;
    CommonDownloadResponseMsg bcmCdlResp = {0, 0};

    hCDLHandle = 0;
    if(hCDLHandle)
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : handle = 0x%08X \n", __FUNCTION__, (unsigned int)hCDLHandle);
    }

    if(VL_CDL_DRIVER_EVENT & eEvent)
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_DRIVER_EVENT 0x%08X instead of VL_CDL_MANAGER_EVENT\n", __FUNCTION__, eEvent);
        return VL_CDL_RESULT_INVALID_PARAM;
    }

    switch(eEvent)
    {
    case VL_CDL_MANAGER_EVENT_DOWNLOAD_STARTED:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_DOWNLOAD_STARTED\n", __FUNCTION__);
        vlg_eCdl_MANAGER_DownloadStatus = (VL_CDL_TRIGGER_TYPE)(nEventData);
        //ecm_dsgStartSwdl();
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_DOWNLOAD_COMPLETED:
    {
        unsigned long dtl3 = 500;
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_DOWNLOAD_COMPLETED\n", __FUNCTION__);
        vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
        //ecm_dsgFinishSwdl(&dtl3);
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_DOWNLOAD_FAILED:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_DOWNLOAD_FAILED\n", __FUNCTION__);
        vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;
        //ecm_dsgAbortSwdl(SWDL_COMMUNICATION_ERRORS);
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_IMAGE_AUTH_FAIL:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_IMAGE_AUTH_FAIL\n", __FUNCTION__);
        vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;

        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_IMAGE_AUTH_SUCCESS:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_IMAGE_AUTH_SUCCESS\n", __FUNCTION__);
        vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;

        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_SET_PUBLIC_KEY:
    {
         return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_SET_CV_CERTIFICATE:
    {
        VL_CDL_GET_STRUCT(VL_CDL_CV_CERTIFICATE, pStruct, nEventData);
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_SET_CV_CERTIFICATE\n", __FUNCTION__);

        switch(pStruct->eCvcType)
        {
        case VL_CDL_CVC_TYPE_MANUFACTURER: cvcType = kManufCvc   ; break;
        case VL_CDL_CVC_TYPE_CO_SIGNER   : cvcType = kCosignerCvc; break;
        default: return VL_CDL_RESULT_INVALID_PARAM;
        }

        CommonDownloadProcessCvc(
            pStruct->cvCertificate.pData,
            pStruct->cvCertificate.nBytes,
            cvcType,
            &bcmCdlResp);

        if(bcmCdlResp.returnCode)
        {
            return VL_CDL_RESULT_SUCCESS;
        }
        else
        {
            return VL_CDL_RESULT_ECM_FAILURE;
        }
    }
    break;

    case VL_CDL_MANAGER_EVENT_START_DOWNLOAD:
    {
        VL_CDL_GET_STRUCT(VL_CDL_DOWNLOAD_PARAMS, pStruct, nEventData);
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_START_DOWNLOAD\n", __FUNCTION__);

        switch(pStruct->eImageType)
        {
            case VL_CDL_IMAGE_TYPE_ECM:
            {
                switch(pStruct->eImageSign)
                {
                    case VL_CDL_IMAGE_UNSIGNED:
                    {
#ifdef LEGACY_NEXUS
                        UpgradeUnsignedEcmImage(
                                (unsigned char*)pStruct->pszImageName, 1+strlen(pStruct->pszImageName),
                                 VL_VALUE_4_FROM_ARRAY(pStruct->tftpIpAddress),
                                         &bcmCdlResp
                                         );
#endif
                    }
                    break;

                    case VL_CDL_IMAGE_SIGNED:


                    default:
                    {
#ifdef LEGACY_NEXUS
                      AuthenticateAndUpgradeEcmImage(
                                (unsigned char*)pStruct->pszImageName, 1+strlen(pStruct->pszImageName),
                                 VL_VALUE_4_FROM_ARRAY(pStruct->tftpIpAddress),
                                         &bcmCdlResp);
#endif
                    }
                    break;

                }
            }
            break;

            case VL_CDL_IMAGE_TYPE_MONOLITHIC:
            case VL_CDL_IMAGE_TYPE_FIRMWARE:
            case VL_CDL_IMAGE_TYPE_APPLICATION:
            case VL_CDL_IMAGE_TYPE_DATA:
            default:
            {
                vlg_eCdl_DRIVER_DownloadStatus = VL_CDL_TRIGGER_TYPE_STB_CVT;
                vlg_eCurrentDownloadType = pStruct->eImageType;
                vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGNED; // image downloaded with headers (result is signed image)
                memset(vlg_szUpgradeImageName, 0, sizeof(vlg_szUpgradeImageName));
                strncpy(vlg_szUpgradeImageName, pStruct->pszImageName, sizeof(vlg_szUpgradeImageName) - 1);
                truncate(kDefaultSymLinkToNewMonolith, 0);

                switch(pStruct->eImageSign)
                {
                    case VL_CDL_IMAGE_SIGNED:

                    {
                       RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", " >>>>>>>>>>>>>>>>>>..... Called VL_CDL_IMAGE_SIGNED <<<<<<<<<<<<<<<<<<<<<<<<< \n");
                        vlg_eCurrentDownloadSign = VL_CDL_IMAGE_SIGNED; // image downloaded with headers (result is signed image)

                        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Image Name    = '%s'\n", __FUNCTION__, vlg_szUpgradeImageName);
                        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : TFTP  Address = %d.%d.%d.%d\n", __FUNCTION__,
                                    pStruct->tftpIpAddress[0],
                                    pStruct->tftpIpAddress[1],
                                    pStruct->tftpIpAddress[2],
                                    pStruct->tftpIpAddress[3]);

                        UpgradeUnsignedMonolithicImage(
                                (unsigned char*)pStruct->pszImageName, 1+strlen(pStruct->pszImageName),
                                 VL_VALUE_4_FROM_ARRAY(pStruct->tftpIpAddress),
                                         &bcmCdlResp);
                    }
                    break;
                     /*coverity[unterminated_case]     CID-17285*/
                     case VL_CDL_IMAGE_UNSIGNED:
                       RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", " >>>>>>>>>>>>>>>>>>..... Called VL_CDL_IMAGE_UNSIGNED @@ 1<<<<<<<<<<<<<<<<<<<<<<<<< \n");
                       /*coverity[fallthrough]         CID-17285*/
                    default:
                    {
                       RDK_LOG(RDK_LOG_INFO, "LOG.RDK.CDL", " >>>>>>>>>>>>>>>>>>..... in default Called VL_CDL_IMAGE_UNSIGNED <<<<<<<<<<<<<<<<<<<<<<<<< \n");
                        vlg_eCurrentDownloadSign = VL_CDL_IMAGE_UNSIGNED; // headers removed during download (result is un-signed image)
                        AuthenticateAndUpgradeMonolithicImage(
                            (unsigned char*)pStruct->pszImageName, 1+strlen(pStruct->pszImageName),
                            VL_VALUE_4_FROM_ARRAY(pStruct->tftpIpAddress),
                            &bcmCdlResp);
                    }
                    break;
                }
            }
            break;
        }

        if(bcmCdlResp.returnCode)
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : VL_CDL_MANAGER_EVENT_START_DOWNLOAD returning SUCCESS\n", __FUNCTION__);
            return VL_CDL_RESULT_SUCCESS;
        }
        else
        {
            RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : VL_CDL_MANAGER_EVENT_START_DOWNLOAD returning VL_CDL_RESULT_ECM_FAILURE\n", __FUNCTION__);
            return VL_CDL_RESULT_ECM_FAILURE;
        }
    }
    break;

    case VL_CDL_MANAGER_EVENT_VALIDATE_CV_TABLE:
    {
        VL_CDL_GET_STRUCT(VL_CDL_CV_TABLE, pStruct, nEventData);
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_VALIDATE_CV_TABLE\n", __FUNCTION__);

        AuthenticateCvtFile(pStruct->cvTable.pData,
        pStruct->cvTable.nBytes,
        &bcmCdlResp);

        if(bcmCdlResp.returnCode)
        {
            return VL_CDL_RESULT_SUCCESS;
        }
        else
        {
            return VL_CDL_RESULT_ECM_FAILURE;
        }
    }
    break;

    case VL_CDL_MANAGER_EVENT_VALIDATE_IMAGE_SIGNATURE:
    {
        VL_CDL_GET_STRUCT(VL_CDL_IMAGE_SIGNATURE, pStruct, nEventData);
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_VALIDATE_IMAGE_SIGNATURE\n", __FUNCTION__);

        AuthenticateMonolithicImageDigitalSignature(
            pStruct->imageSignature.pData,
            pStruct->imageSignature.nBytes,
            &bcmCdlResp);

        if(bcmCdlResp.returnCode)
        {
            return VL_CDL_RESULT_SUCCESS;
        }
        else
        {
            return VL_CDL_RESULT_ECM_FAILURE;
        }
    }
    break;


    case VL_CDL_MANAGER_EVENT_VALIDATE_IMAGE_CONTENT:
    {
        VL_CDL_GET_STRUCT(VL_CDL_IMAGE, pStruct, nEventData);
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_VALIDATE_IMAGE_CONTENT\n", __FUNCTION__);

        if(VL_CDL_IMAGE_TYPE_MONOLITHIC != pStruct->eImageType) return VL_CDL_RESULT_INVALID_IMAGE_TYPE;
        if(VL_CDL_IMAGE_SIGNED          != pStruct->eImageSign) return VL_CDL_RESULT_INVALID_IMAGE_SIGN;

#ifdef LEGACY_NEXUS
        AuthenticateMonolithicImageSignedContent(
            (unsigned char*)(pStruct->pszImagePathName),
            1+strlen(pStruct->pszImagePathName),
            0,
            &bcmCdlResp);
#endif

        if(bcmCdlResp.returnCode)
        {
            return VL_CDL_RESULT_SUCCESS;
        }
        else
        {
            return VL_CDL_RESULT_ECM_FAILURE;
        }

    }
    break;

    case VL_CDL_MANAGER_EVENT_UPGRADE_TO_IMAGE:
    {
        VL_CDL_GET_STRUCT(VL_CDL_IMAGE, pStruct, nEventData);
#ifdef USE_MFR
        VL_MFR_SOFTWARE_IMAGE_NAME imageName;
        VL_MFR_UPGRADE_IMAGE upgradeImage;

        //VL_ZERO_MEMORY(imageName);
        memset(&imageName, 0, sizeof(VL_MFR_SOFTWARE_IMAGE_NAME));
        //VL_ZERO_MEMORY(upgradeImage);
        memset(&upgradeImage, 0, sizeof(VL_MFR_UPGRADE_IMAGE));
#endif
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_UPGRADE_TO_IMAGE\n", __FUNCTION__);
#ifdef USE_MFR
        if(0 == strlen(pStruct->szSoftwareImageName)) return VL_CDL_RESULT_INCOMPLETE_PARAM;

        upgradeImage.eImageType = vlTranslateCdlImageType2MfrImageType(pStruct->eImageType);
        upgradeImage.pszUpgradeImagePathName = pStruct->pszImagePathName;
        if(VL_MFR_API_RESULT_SUCCESS ==HAL_MFR_set_mfr_data(0, VL_STACK_2_MFR_EVENT_SET_UPGRADE_TO_IMAGE, &upgradeImage))
        {
            RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : VL_STACK_2_MFR_EVENT_SET_UPGRADE_TO_IMAGE returned SUCCESS.\n", __FUNCTION__);
            RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Image name is '%s'.\n", __FUNCTION__, pStruct->szSoftwareImageName);
            if(0 != strcmp(kDefaultSymLinkToNewMonolith, pStruct->szSoftwareImageName))
            {
                memset(imageName.szSoftwareImageName, 0, sizeof(imageName.szSoftwareImageName));
                strncpy(imageName.szSoftwareImageName, pStruct->szSoftwareImageName, sizeof(imageName.szSoftwareImageName)-1);
                imageName.eImageType = vlTranslateCdlImageType2MfrImageType(pStruct->eImageType);
                RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Writing image name '%s' using VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME.\n", __FUNCTION__, imageName.szSoftwareImageName);
                HAL_MFR_set_mfr_data(0, VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME, &imageName);
            }
            else
            {
                RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Not writing '%s' as it is hard-coded link name.\n", __FUNCTION__, pStruct->szSoftwareImageName);
            }
            return VL_CDL_RESULT_SUCCESS;
        }
        else
        {
            RDK_LOG(RDK_LOG_ERROR,HAL_MODULE_CDL,"%s() : VL_STACK_2_MFR_EVENT_SET_UPGRADE_TO_IMAGE returned FAILURE.\n", __FUNCTION__);
            return VL_CDL_RESULT_UPGRADE_FAILED;
        }
#endif
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    // Begin patch: MOT7425-4198
    case VL_CDL_MANAGER_EVENT_SAVE_UPGRADE_IMAGE_NAME:
    {
        VL_CDL_GET_STRUCT(VL_CDL_SOFTWARE_IMAGE_NAME, pStruct, nEventData);
#ifdef USE_MFR
        VL_MFR_SOFTWARE_IMAGE_NAME imageName;
        memset(&imageName, 0, sizeof(imageName));
#endif
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_SAVE_UPGRADE_IMAGE_NAME\n", __FUNCTION__);
#ifdef USE_MFR
        if(0 == strlen(pStruct->szSoftwareImageName)) return VL_CDL_RESULT_INCOMPLETE_PARAM;
    
        // Sep-13-2013: BPV-4875 : Writing of upgrade image name moved here to ensure it will be called only if the flashing was successful.
        memset(imageName.szSoftwareImageName, 0, sizeof(imageName.szSoftwareImageName));
        strncpy(imageName.szSoftwareImageName, pStruct->szSoftwareImageName, sizeof(imageName.szSoftwareImageName)-1);
        imageName.eImageType = vlTranslateCdlImageType2MfrImageType(pStruct->eImageType);
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s: Writing image name '%s' using VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME.\n", __FUNCTION__, imageName.szSoftwareImageName);
        HAL_MFR_set_mfr_data(0, VL_STACK_2_MFR_EVENT_SET_UPGRADE_IMAGE_NAME, &imageName);
#endif
        return VL_CDL_RESULT_SUCCESS;
    }
    break;
    // End patch: MOT7425-4198

    case VL_CDL_MANAGER_EVENT_get_PREVIOUS_IMAGE_NAME:
    {
        VL_CDL_GET_STRUCT(VL_CDL_SOFTWARE_IMAGE_NAME, pStruct, nEventData);
        VL_MFR_SOFTWARE_IMAGE_NAME imageName;
		memset(&imageName, 0, sizeof(imageName));

        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
		memset((void*)pStruct, 0, sizeof(*pStruct));
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_get_PREVIOUS_IMAGE_NAME\n", __FUNCTION__);

        imageName.eImageType = vlTranslateCdlImageType2MfrImageType(pStruct->eImageType);
        HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_PREVIOUS_BOOT_IMAGE_NAME, &imageName);
       memset(pStruct->szSoftwareImageName, 0, sizeof(pStruct->szSoftwareImageName));
       strncpy(pStruct->szSoftwareImageName, imageName.szSoftwareImageName, sizeof(pStruct->szSoftwareImageName)-1);
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_get_CURRENT_BOOT_IMAGE_NAME:
    {
        VL_CDL_GET_STRUCT(VL_CDL_SOFTWARE_IMAGE_NAME, pStruct, nEventData);

        VL_MFR_SOFTWARE_IMAGE_NAME imageName;
		memset(&imageName, 0, sizeof(imageName));

        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
		memset((void*)pStruct, 0, sizeof(*pStruct));
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_get_CURRENT_BOOT_IMAGE_NAME\n", __FUNCTION__);
            
        imageName.eImageType = vlTranslateCdlImageType2MfrImageType(pStruct->eImageType);
        HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_CURRENT_BOOT_IMAGE_NAME, &imageName);
        memset(pStruct->szSoftwareImageName, 0, sizeof(pStruct->szSoftwareImageName));
        strncpy(pStruct->szSoftwareImageName, imageName.szSoftwareImageName, sizeof(pStruct->szSoftwareImageName) - 1);
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_get_UPGRADE_IMAGE_NAME:
    {
        VL_CDL_GET_STRUCT(VL_CDL_SOFTWARE_IMAGE_NAME, pStruct, nEventData);

        VL_MFR_SOFTWARE_IMAGE_NAME imageName;
		memset(&imageName, 0, sizeof(imageName));

        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
		memset((void*)pStruct, 0, sizeof(*pStruct));
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_get_UPGRADE_IMAGE_NAME\n", __FUNCTION__);

        imageName.eImageType = vlTranslateCdlImageType2MfrImageType(pStruct->eImageType);
        HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_UPGRADE_IMAGE_NAME, &imageName);
        memset(pStruct->szSoftwareImageName, 0, sizeof(pStruct->szSoftwareImageName));
        strncpy(pStruct->szSoftwareImageName, imageName.szSoftwareImageName, sizeof(pStruct->szSoftwareImageName) - 1);
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_REBOOT:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_REBOOT\n", __FUNCTION__);

        vlg_bIsRebooting = 1;
        //remove(vlg_szUpgradeImagePathName);
        // XONE-3545: Added new API to handle reboot
        //replaced with HAL_SYS_Reboot()//cSleep(5000);
        //replaced with HAL_SYS_Reboot()//system("sync");
        //replaced with HAL_SYS_Reboot()//cSleep(5000);
        //todo abdu: commented
        //vlMpeosLogRebootEvent(__FUNCTION__, "VL_CDL_MANAGER_EVENT_REBOOT");
        rmf_osal_LogRebootEvent(__FUNCTION__, "VL_CDL_MANAGER_EVENT_REBOOT");
                       
        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL, ">>>>>>>>>>>>> Before  VL_STACK_2_MFR_EVENT_SET_REBOOT_WITH_UPGRADED_IMAGE\n");

        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL, " >>>>>>>>>>>  After VL_STACK_2_MFR_EVENT_SET_REBOOT_WITH_UPGRADED_IMAGE \n");

        //HAL_SYS_SnmpRequest(VL_SNMP_REQUEST_SET_SYS_UNINITIALIZE, NULL);

        RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL, " >>>>>>>>>> rebooting .. >>>>>>> \n");
		rmf_osal_threadSleep(5000, 0);

        //replaced with HAL_SYS_Reboot()//system("/sbin/reboot -f  &");
        // XONE-3545: Added new API to handle reboot
        HAL_SYS_Reboot(__FUNCTION__, "VL_CDL_MANAGER_EVENT_REBOOT");
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_SET_UPGRADE_FAILED:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_SET_UPGRADE_FAILED\n", __FUNCTION__);

        vlg_bIsRebooting = 0;
        vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;

        HAL_MFR_set_mfr_data(0, VL_STACK_2_MFR_EVENT_SET_UPGRADE_FAILED, NULL);

        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_SET_UPGRADE_SUCCEEDED:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_SET_UPGRADE_SUCCEEDED\n", __FUNCTION__);

        vlg_bIsRebooting = 0;
        vlg_eCdl_MANAGER_DownloadStatus = VL_CDL_TRIGGER_TYPE_NONE;

        HAL_MFR_set_mfr_data(0, VL_STACK_2_MFR_EVENT_SET_UPGRADE_SUCCEEDED, NULL);
        return VL_CDL_RESULT_SUCCESS;
    }
    break;

    case VL_CDL_MANAGER_EVENT_get_UPGRADE_STATUS:
    {
        VL_CDL_GET_STRUCT(VL_CDL_DOWNLOAD_STATUS_QUESTION, pStruct, nEventData);
        if(NULL == pStruct) return VL_CDL_RESULT_NULL_PARAM;
		memset((void*)pStruct, 0, sizeof(*pStruct));
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received VL_CDL_MANAGER_EVENT_get_UPGRADE_STATUS\n", __FUNCTION__);
        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_IDLE;

        // check if reboot request has been issued
        if(vlg_bIsRebooting)
        {
            pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_REBOOTING;
        }

        // check manager download status
        switch(vlg_eCdl_MANAGER_DownloadStatus)
        {
        case VL_CDL_TRIGGER_TYPE_STB_CVT:
        {
            pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_MANAGER_DOWNLOADING;
        }
        break;

        default:
        {

        }
        break;
        }

        // check driver download status
        switch(vlg_eCdl_DRIVER_DownloadStatus)
        {
        case VL_CDL_TRIGGER_TYPE_ECM_CONFIG_FILE:
        case VL_CDL_TRIGGER_TYPE_ECM_SNMP:
        case VL_CDL_TRIGGER_TYPE_STB_CVT:
        {
            pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_ECM_DOWNLOADING;
        }
        break;

        default:
        {

        }
        break;
        }

        // get status from manufacturer
        {
            VL_MFR_UPGRADE_STATUS_QUESTION cdlStatusQuestion;
            VL_ZERO_STRUCT(cdlStatusQuestion);
            if(VL_MFR_API_RESULT_SUCCESS == HAL_MFR_get_mfr_data(0, VL_STACK_2_MFR_EVENT_get_UPGRADE_STATUS, &cdlStatusQuestion))
            {
                switch(cdlStatusQuestion.eUpgradeStatus)
                {
                    case VL_MFR_UPGRADE_STATUS_BOOTED_WITH_UPGRADED_IMAGE:
                    {
                        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_BOOTUP_AFTER_SUCCESSFUL_UPGRADE;
                    }
                    break;
                    
                    case VL_MFR_UPGRADE_STATUS_BOOTED_WITH_REVERTED_IMAGE:
                    {
                        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_BOOTUP_AFTER_FAILED_UPGRADE;
                    }
                    break;
                    
                    case VL_MFR_UPGRADE_STATUS_NONE:
                    case VL_MFR_UPGRADE_STATUS_IDLE:
                    default:
                    {
                        pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_IDLE;
                    }
                    break;
                }
            }
            else
            {
                // Failed to figure out status
                 RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : VL_STACK_2_MFR_EVENT_get_UPGRADE_STATUS returned failure, Unable to determine upgrade status\n", __FUNCTION__);
                pStruct->eDownloadStatus = VL_CDL_DOWNLOAD_STATUS_UNKNOWN;
                return VL_CDL_RESULT_SUCCESS;
            }
        }

        return VL_CDL_RESULT_SUCCESS;
    }
    break;
    
    case VL_CDL_MANAGER_EVENT_get_DOWNLOAD_PROGRESS:
    {
        VL_CDL_GET_STRUCT(VL_CDL_DOWNLOAD_PROGRESS_NOTIFICATION, pStruct, nEventData);
        if(NULL != pStruct)
        {
            *pStruct = vlg_downloadProgress;
        }
    }
    break;

    default:
    {
         RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s() : Received event %d\n", __FUNCTION__,eEvent);
    }
    break;
    }

    return VL_CDL_RESULT_NOT_IMPLEMENTED;
}

#endif // USE_CDL
