/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/
#ifndef __FB_NVRAM_API__
#define __FB_NVRAM_API__

#include "mfr_types.h"

#if defined(USE_PACE_MFR)
#include "pace_mfr_api.h"
#include "pace_mfr_nvram_api.h"
#if defined(XONE_STB)
#include "pace_DFAST2_prod_gfe_ext_v3.2.h"
#include "pace_DFAST2_prod_header_v3.2.h"
#endif

#elif defined(USE_VIVID_MFR)
#include "vivid_sample_mfr_api.h"

#elif defined(USE_INTEL_MFR)
#include "intel_sample_mfr_api.h"

#elif defined(USE_THOMSON_MFR)
#include "thomson_sample_mfr_api.h"
#else
#include "vl_sample_mfr_api.h"
#endif

#define VL_MFR_ENCRYPTOR
#define VL_MFR_DECRYPTOR
#define NEW_MFR_INTERFACE

#include "vl_mfr_writer.c"

#define vlBYTE unsigned char 
#define G9_UDMA_VLCERT_FILENAME "/mnt/nfs/fb/vlcert.bin"

//HAL_DTCP extern "C" void idl_gpio_line_config();

static int vlDecryptMfrData(VL_NVRAM_DATA *pSrerialData,VL_NVRAM_DATA *pNVRamData,VL_NVRAM_DATA *pOutputData)
{
//    int i = 0;
//    if(i)
//    {
//        idl_gpio_line_config(); // hack for a run-time link error
//    }
    return -1;
}

static int HAL_MFR_read_secure_nvram ( int hMFRHandle, VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
    int result = -1;
#if defined(USE_PACE_MFR)
        result = pace_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_read_secure_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_read_secure_nvram(eType, pNvRamData);
#else
        result = vl_mfr_read_secure_nvram(eType, pNvRamData);
#endif
    return result;
}

static int HAL_MFR_write_secure_nvram ( int hMFRHandle, VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
    int result = -1;
#if defined(USE_PACE_MFR)
        result = pace_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_write_secure_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_write_secure_nvram(eType, pNvRamData);
#else
        result = vl_mfr_write_secure_nvram(eType, pNvRamData);
#endif
    return result;
}

static int HAL_MFR_read_normal_nvram ( int hMFRHandle, VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
	int result = -1;
#if defined(USE_PACE_MFR)
        result = pace_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_read_normal_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_read_normal_nvram(eType, pNvRamData);
#else
        result = vl_mfr_read_normal_nvram(eType, pNvRamData);
#endif
	return result;
}

static int HAL_MFR_write_normal_nvram ( int hMFRHandle, VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData)
{
	int result = -1;
#if defined(USE_PACE_MFR)
        result = pace_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_INTEL_MFR)
        result = intel_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_THOMSON_MFR)
        result = thomson_mfr_write_normal_nvram(eType, pNvRamData);
#elif defined(USE_VIVID_MFR)
        result = vivid_mfr_write_normal_nvram(eType, pNvRamData);
#else
        result = vl_mfr_write_normal_nvram(eType, pNvRamData);
#endif
	return result;
}

static int vlGetMfrData(int type, VL_NVRAM_DATA *pNVRamData, int secureType)
{
    int iRet;
    pNVRamData->pData = NULL;
    pNVRamData->nActualBytes = 0;

    if(!secureType)
        iRet = HAL_MFR_read_normal_nvram(0, (VL_NORMAL_NVRAM_DATA_TYPE)type, pNVRamData);
    else
        iRet = HAL_MFR_read_secure_nvram(0, (VL_SECURE_NVRAM_DATA_TYPE)type, pNVRamData);

    if(VL_MFR_API_RESULT_SUCCESS != iRet)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "vlGetMfrData: HAL_MFR_read_XXX_nvram returned Error:%d..for enum type:%d .\n",iRet,type);
        return -1;
    }
    else if(pNVRamData->pData == NULL || pNVRamData->nActualBytes == 0 )
    {
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "vlGetMfrData: HAL_MFR_read_XXX_nvram returned pData:0x%p and nActualBytes:%ld for enum type:%d .\n",
              //pNVRamData->pData,pNVRamData->nActualBytes,type);
        return -1;
    }

    if(secureType)
    {
        if(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER != type)
        {
            VL_NVRAM_DATA NVSerialNum,nvDecryptedData;
            if(vlGetMfrData(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER, &NVSerialNum,1))
                return -1;

            if(vlDecryptMfrData(&NVSerialNum,pNVRamData,&nvDecryptedData))
                    return -1;
            if(NULL != NVSerialNum.pData) free(NVSerialNum.pData);
            if(NULL != nvDecryptedData.pData)
            {
                // replace with decrypted data
                pNVRamData->pData        = nvDecryptedData.pData;
                pNVRamData->nActualBytes = nvDecryptedData.nActualBytes;
            }
            else
            {
                return -1;
            }
            // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "vlGetMfrData: NVRam Data Read  Success for enum type:%d NumOfBytes:%ld\n",type,pNVRamData->nActualBytes);
        }
    }
    return 0;

}

static int vlWriteMfrData(int type, VL_NVRAM_DATA *pNVRamData,int secureType)
{
    int iRet;

    VL_NVRAM_DATA NVSerialNum,nvEncryptedData;

    if(vlGetMfrData(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER, &NVSerialNum,1))
        return -1;

    if(pNVRamData->pData == NULL || pNVRamData->nActualBytes == 0 )
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "vlWriteMfrData: Input Data Error!!!  returning  pData:%p and nActualBytes:%lu for enum type:%ud .\n", pNVRamData->pData, pNVRamData->nActualBytes, type);
        return -1;
    }
    if(secureType)
    {
        // encrypt the data first
//        iRet = vl_mfr_encrypt(&NVSerialNum, pNVRamData, &nvEncryptedData);
        // do not free as the data is owned by the caller // if(NULL != pNVRamData->pData) free(pNVRamData->pData);
        if(NULL != NVSerialNum.pData) free(NVSerialNum.pData);

        // write to nvram
        iRet = HAL_MFR_write_secure_nvram(0,(VL_SECURE_NVRAM_DATA_TYPE)type,&nvEncryptedData);
        if(VL_MFR_API_RESULT_SUCCESS != iRet)
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "vlWriteMfrData: CHALMfr_write_nvram returned Error:%d..for enum type:%d .\n",iRet,type);
            return -1;
        }
        if(NULL != nvEncryptedData.pData) free(nvEncryptedData.pData);
    }
    else
    {
        iRet = HAL_MFR_write_normal_nvram(0,(VL_NORMAL_NVRAM_DATA_TYPE)type,pNVRamData);
        if(VL_MFR_API_RESULT_SUCCESS != iRet)
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "vlWriteMfrData: CHALMfr_write_nvram returned Error:%d..for enum type:%d .\n",iRet,type);
            return -1;
        }
        //free(pNVRamData);
    }

    // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "vlWriteMfrData: NVRam Data write Success for enum type:%d NumOfBytes:%d\n",type,pNVRamData->nActualBytes);
    return 0;

}

static int vlDecryptNVRAMData(VL_NVRAM_DATA *pSrerialData,VL_NVRAM_DATA *pNVRamData,VL_NVRAM_DATA *pOutputData)
{
    int iRet;
    pOutputData->pData = NULL;
    pOutputData->nActualBytes = 0;

    iRet = vl_mfr_decrypt(pSrerialData,pNVRamData,pOutputData);
    if(VL_MFR_API_RESULT_SUCCESS != iRet)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_POD,"vlCPDecryptNVRAMData: vl_mfr_decrypt returned Error:%d\n",iRet);
        free(pNVRamData->pData);
        return -1;
    }
    else if(pOutputData->pData == NULL || pOutputData->nActualBytes == 0 )
    {
         //RMF_LOG(RMF_LOG_INFO, RMF_MOD_POD,"vlCPDecryptNVRAMData: CHALMfr_read_nvram returned pData:0x%X and nActualBytes:%d\n",
               //pOutputData->pData,pOutputData->nActualBytes);
        free(pNVRamData->pData);
        return -1;
    }

     //RMF_LOG(RMF_LOG_INFO, RMF_MOD_POD,"vlCPDecryptNVRAMData: Decrypt Data Success NumOfBytes:%d\n",pOutputData->nActualBytes);
    free(pNVRamData->pData);
    return 0;
}

static void vlGetDTCPKeyStatus(vlBYTE *keyStatus, vlBYTE *keyType)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data;
        vlGetMfrData((int)VL_NORMAL_NVRAM_DATA_IEEE1394_DTCP_KEY_TYPE,&data,(int)0);
        if(data.nActualBytes)
        {
            *keyType = data.pData[0];
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "NEW_MFR_INTERFACE : keyType = %02x\n",*keyType);
            free(data.pData);
        }
        else
        {
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Failed to get VL_NORMAL_NVRAM_DATA_IEEE1394_DTCP_KEY_TYPE\n");
            *keyType = 0;
            //    return -1;
        }

        vlGetMfrData((int)VL_NORMAL_NVRAM_DATA_IEEE1394_DTCP_KEY_STATUS,&data,(int)0);
        if(data.nActualBytes)
        {
            *keyStatus = data.pData[0];
            // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "NEW_MFR_INTERFACE : keyStatus = %02x\n",*keyStatus);
            free(data.pData);
        }
        else
        {
            // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "GetStoredDTLAKeyBuf: Failed to get DTCP keys\n");
            *keyStatus = 0;
            return;// -1;
        }
        return;// 0;

    }
#endif /*NEW_MFR_INTERFACE*/
}

#if 0
static void FirebusApp_GetVlCertificateInfo(VL_SNMP_CERTIFICATE_INFO * pCertInfo)
{
    VL_NVRAM_DATA data;
    VL_CERT_DETAILS details;
//    int retVal;
    strncpy((char *)pCertInfo->szDispString,"VIVIDLOGIC Certificate Info",sizeof("VIVIDLOGIC Certificate Info"));
#ifdef NEW_MFR_INTERFACE
    VL_NVRAM_DATA encrypted_data, serial_num;
//             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: vlGetMfrData 1 size=%d\n", size);
    vlGetMfrData(VL_SECURE_NVRAM_DATA_VL_CERT_KEYS,&encrypted_data,1); //Get DTCP keys
    vlGetMfrData(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER,&serial_num,1); //Get DTCP keys
    vlDecryptNVRAMData(&serial_num,&encrypted_data,&data);

    if((unsigned int)VL_CERT_LEN != data.nActualBytes)
    {
	 //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "ERROR: size doesnt match .. size = %d and data.nActualBytes = %ld\n",VL_CERT_LEN,data.nActualBytes);
    }

    //vlGetMfrData((int)VL_SECURE_NVRAM_DATA_VL_CERT_KEYS,&data,(int)1);

    if(data.nActualBytes)
    {
        pCertInfo->bCertAvailable = 1;
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "VIVIDLOGIC certificate availbale size=%d\n", data.nActualBytes);
        if(VLNW_VerifyCertificate(data.pData,&details))
        {
            pCertInfo->bCertValid = 1;
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "VL_CERTIFICATE is valid\n");

            strncpy((char*)pCertInfo->szMfrName,(char*)details.mfrName,128);
            strncpy((char*)pCertInfo->szModelName,(char*)details.modelName,128);
            memcpy(&pCertInfo->acVendorId[0],&details.vendorId[0],3);
            memcpy(&pCertInfo->acDeviceId[0],&details.deviceId[0],5);
            memcpy(&pCertInfo->acGUIDorMACADDR[0],&details.vendorId[0],3);
            memcpy(&pCertInfo->acGUIDorMACADDR[3],&details.deviceId[0],5);
            memcpy(&pCertInfo->acModelId[0],&details.modelId[0],4);


        }
        else
        {
            pCertInfo->bCertValid = 0;
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "VL_CERTIFICATE is INVALID\n");
        }
        free(data.pData);
    }
    else
    {
        pCertInfo->bCertAvailable = 0;
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "VIVIDLOGIC certificate is NOT availbale\n");
    }
#endif /*NEW_MFR_INTERFACE*/
}

static void FirebusApp_GetDtcpCertificateInfo(VL_SNMP_CERTIFICATE_INFO * pCertInfo)
{
    VL_NVRAM_DATA data;
    vlBYTE keyStatus,keyType;
//    int retVal;

    strncpy((char *)pCertInfo->szDispString,"DTCP Certificate Info",sizeof("DTCP Certificate Info"));

    vlGetDTCPKeyStatus(&keyStatus,&keyType);
    if(keyStatus == 1)
        strncpy((char*)pCertInfo->szKeyInfoString,"Keys are BOUND",sizeof("Keys are BOUND"));
    else
        strncpy((char*)pCertInfo->szKeyInfoString,"Keys are not BOUND",sizeof("Keys are not BOUND"));

#ifdef NEW_MFR_INTERFACE
    vlGetMfrData((int)VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_CERT_KEYS,&data,(int)1);

    if(data.nActualBytes)
    {
        int i;
        pCertInfo->bCertAvailable = 1;
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "DTCP certificate is present\n");
        for(i=0; i<5; i++)
            if(data.pData[3+i])
                break;
        if(i<5)
        {
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Its DTCP Production Keys\n");
            pCertInfo->bIsProduction = 1;
        }
        else
        {
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Its Fax Keys(Sample Keys)\n");
            pCertInfo->bIsProduction = 0;
        }

        if(NWM_SUCCESS == VLNW_VerifyDtcpCert(data.pData,VLDTCP_FULL_CERT_SIZE))
        {
            pCertInfo->bCertValid = 1;
            // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Verification of DTCP Cert succeeded\n");
        }
        else
        {
            // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Verification of DTCP Cert failed\n");
            pCertInfo->bCertValid = 0;
        }
    }
    else
    {
        pCertInfo->bCertAvailable = 0;
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "DTCP certificate is NOT availbale\n");
    }
#endif //NEW_MFR_INTERFACE
}
#endif //if 0

static void FBConfig_StoreDTLAKeyBuf(unsigned char *pDTLAKey,int size)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data;
        int iRet;
        data.pData = pDTLAKey;
        data.nActualBytes = size;
        data.nBytes = size;
        iRet = vlWriteMfrData(VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_CERT_KEYS,&data,1);
        if(VL_MFR_API_RESULT_SUCCESS != iRet)
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_StoreDTLAKeyBuf: Failed to write DTLA keys:%d .\n",iRet);
                //return -1;
        }
    }
#else

	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_StoreDTLAKeyBuf(Filesystem): writing %d bytes\n",size);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    FILE *fp;
    int numBytes;
    //unsigned char keyBuffer[DTLA_KEY_SIZE];
    //unsigned long numBytes;

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "StoreDTLAKeyBuf: BEGIN\n");
    fp = fopen(G9_UDMA_DTCP_KEY_FILENAME, "wb");
    if(fp == NULL)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreDTLAKeyBuf: Could not open file %s\n", G9_UDMA_DTCP_KEY_FILENAME);
        return;
    }

    numBytes = fwrite(pDTLAKey,  size,1, fp);
    if(numBytes != 1)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreDTLAKeyBuf: Failed to write data to file %s:numBytes=%d\n", G9_UDMA_DTCP_KEY_FILENAME,numBytes);
        return;
    }

    fclose(fp);
#endif /*VL_USE_KEYS_IN_FILE_SYSTEM*/

#ifdef VL_USE_KEYS_IN_NVRAM
    NVRAM_Write((vlUINT32)pDTLAKey, NV_1394_DTCPKEY, size, 0);
#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        int i;
        memcpy(g_vlDtcpKeyBuff,pDTLAKey,size);

         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\nstatic unsigned char vlDtcpKeys[] = {\n");
        for (i=0; i<size;i=i+4)
        {
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "    0x%02X,0x%02X,0x%02X,0x%02X,\n",pDTLAKey[i],pDTLAKey[i+1],pDTLAKey[i+2],pDTLAKey[i+3]);
            //rmf_osal_threadSleep(100, 0);  
        }

         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n};\n");
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\nSize = %d", size);
    }
#endif

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\nStoreDTLAKeyBuf: SUCCESSFULLY STORED DTLA KEY BUFFER\n");
#endif /*NEW_MFR_INTERFACE*/
}

static void FBConfig_StoreVLCert(unsigned char *pVLCert,int size)
{
	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_StoreVLCert(Filesystem): writing %d bytes\n",size);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM

    FILE *fp;
    int numBytes;

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "StoreVLCert: BEGIN\n");
    fp = fopen(G9_UDMA_VLCERT_FILENAME, "wb");
    if(fp == NULL)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreVLCert: Could not open file %s\n", G9_UDMA_VLCERT_FILENAME);
        return;
    }

    numBytes = fwrite(pVLCert,  size,1, fp);
    if(numBytes != 1)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreVLCert: Failed to write data to file %s:numBytes=%d\n", G9_UDMA_VLCERT_FILENAME,numBytes);
        fclose(fp);
        return;
    }

    fclose(fp);
#endif

#ifdef VL_USE_KEYS_IN_NVRAM

    unsigned char signature[4] = {0xC1,0xAA,0xAA,0xAA};

    //Using first 4 bytes to store a signature
    //If this signature is present, then we assume the NVRAM has been programmed..
    NVRAM_Write((vlUINT32)signature, NV_1394_VLKEY, 4, 0);

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Writing VL Cert to NVRAM\n");
	NVRAM_Write((vlUINT32)pVLCert, NV_1394_VLKEY + 4, size, 0);

#endif
#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        int i;
        unsigned char signature[4] = {0xC1,0xAA,0xAA,0xAA};

        //Using first 4 bytes to store a signature
        //If this signature is present, then we assume the NVRAM has been programmed..
        for (i=0; i<4;i++)
        {
            g_vlCertBuff[i] = signature[i];
        }

        for (i=0; i<size;i++)
        {
            g_vlCertBuff[4+i] = pVLCert[i];
        }
    }
#endif

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\nStoreVLCert: SUCCESSFULLY STORED VLCERT\n");
}

static void FBConfig_StoreSeed(unsigned char *pSeed,int size)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data;
        int iRet;
        data.pData = pSeed;
        data.nActualBytes = size;
        data.nBytes = size;
        iRet = vlWriteMfrData(VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_SEED,&data,1);
        if(VL_MFR_API_RESULT_SUCCESS != iRet)
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_StoreDTLAKeyBuf: Failed to write DTLA keys:%d .\n",iRet);
                //return -1;
        }
    }

#else
	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_StoreSeed(Filesystem): writing %d bytes\n",size);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    FILE *fp;
    int numBytes;

    fp = fopen(G9_UDMA_SEED_FILENAME, "wb");
    if(fp == NULL)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreSeed: Could not open file %s\n", G9_UDMA_SEED_FILENAME);
        return;
    }

    numBytes = fwrite(pSeed,  size,1, fp);
    if(numBytes != 1)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreSeed: Failed to write data to file %s:numBytes=%d\n", G9_UDMA_SEED_FILENAME,numBytes);
        return;
    }

    fclose(fp);
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Writing SEED to NVRAM\n");

    NVRAM_Write((vlUINT32)pSeed, NV_1394_SEED, size, 0);
#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        int i;
        vlDTCPKeyFormat3_t *vlDTCPKeys = (vlDTCPKeyFormat3_t*)g_vlDtcpKeyBuff;
        for (i=0; i<size;i++)
        {
            vlDTCPKeys->RandSeed[i] = pSeed[i];
        }

         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\nSeed size = %d", size);
    }
#endif
#endif /*NEW_MFR_INTERFACE*/
}

static void FBConfig_StoreSRM(unsigned char *pSRM,int size)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data;
        int iRet;
        data.pData = pSRM;
        data.nActualBytes = size;
        data.nBytes = size;
        iRet = vlWriteMfrData(VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_SRM,&data,1);
        if(VL_MFR_API_RESULT_SUCCESS != iRet)
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_StoreDTLAKeyBuf: Failed to write DTLA keys:%d .\n",iRet);
                //return -1;
        }
    }
#else

	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_StoreSRM(Filesystem): writing %d bytes\n",size);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    FILE *fp;
    int numBytes;

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "StoreSRM: BEGIN\n");
    fp = fopen(G9_UDMA_SRM_FILENAME, "wb");
    if(fp == NULL)
    {
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "StoreSRM: Could not open file %s\n", G9_UDMA_SRM_FILENAME);
        return;
    }

    numBytes = fwrite(pSRM,  size,1, fp);
    if(numBytes != 1)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "StoreSRM: Failed to write data to file %s:numBytes=%d\n", G9_UDMA_SRM_FILENAME,numBytes);
        return;
    }

    fclose(fp);
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Writing SRM to NVRAM\n");

    NVRAM_Write((vlUINT32)pSRM, NV_1394_SRM, size, 0);

#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        memcpy(g_vlSrmBuff,pSRM,size);
    }
#endif
#endif /*NEW_MFR_INTERFACE*/
     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\nStoreSRM: SUCCESSFULLY STORED SRM\n");
}

static int FBConfig_GetStoredSRM(unsigned char *pSRM,int size)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data, encrypted_data, serial_num;
//             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: vlGetMfrData 1 size=%d\n", size);
        vlGetMfrData(VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_SRM,&encrypted_data,1); //Get DTCP keys
        vlGetMfrData(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER,&serial_num,1); //Get DTCP keys
        vlDecryptNVRAMData(&serial_num,&encrypted_data,&data);

        if(data.nActualBytes)
        {
            memcpy(pSRM,&data.pData[0], data.nActualBytes);
            free(data.pData);
            //return data.nActualBytes;
        }
        else
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_GetStoredSRM: Failed to get SRM keys\n");
            return 0;
        }
    }

#else

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_GetStoredSRM(Filesystem): reading %d bytes\n",size);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    {
    FILE *fp;
    int numBytes;

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "GetStoredSRM: BEGIN\n");
    fp = fopen(G9_UDMA_SRM_FILENAME, "rb");
    if(fp == NULL)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredSRM: Could not open file %s\n", G9_UDMA_SRM_FILENAME);
        return 0;
    }

    numBytes = fread(pSRM,  size,1, fp);
    if(numBytes != 1)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredSRM: Failed to read data from file %s:numBytes=%d\n", G9_UDMA_SRM_FILENAME,numBytes);
        return 0;
    }

    fclose(fp);
    }
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
    NVRAM_Read(NV_1394_SRM, (vlUINT32)pSRM, size, 0);

#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        memcpy(pSRM,g_vlSrmBuff,size);
    }
#endif

#endif //NEW_MFR_INTERFACE
    return size;
}

static int FBConfig_GetStoredDTLAKeyBuf(unsigned char *pDTLAKey,int size)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data, encrypted_data, serial_num;
        //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: vlGetMfrData 1 size=%d\n", size);
        vlGetMfrData(VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_CERT_KEYS,&encrypted_data,1); //Get DTCP keys
	//cVLPrintBytes("dtlaPublicKey:",(unsigned char *)encrypted_data.pData,encrypted_data.nActualBytes);
        vlGetMfrData(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER,&serial_num,1); //Get DTCP keys
	//cVLPrintBytes("serialnum",(unsigned char *)serial_num.pData,serial_num.nActualBytes);
        vlDecryptNVRAMData(&serial_num,&encrypted_data,&data);
	//cVLPrintBytes("decrypted dtlaPublicKey:",(unsigned char *)data.pData,1024);
        //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: vlGetMfrData 2\n"); 
        if(data.nActualBytes)
        {
           //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: data.nActualBytes=%d\n",data.nActualBytes); 
           memcpy(pDTLAKey,&data.pData[0], data.nActualBytes);
            free(data.pData);
        }
        else
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: Failed to get DTCP keys\n");
            return 0;
        }
    }

#else
    {
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_GetStoredDTLAKeyBuf(Filesystem): reading %d bytes\n",size);

#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    FILE *fp;
    int numBytes;

         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "GetStoredDTLAKeyBuf: BEGIN\n");
    fp = fopen(G9_UDMA_DTCP_KEY_FILENAME, "rb");
    if(fp == NULL)
    {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: Could not open file %s\n", G9_UDMA_DTCP_KEY_FILENAME);
        return 0;
    }

    numBytes = fread(pDTLAKey,  size,1, fp);
    if(numBytes != 1)
    {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: Failed to read data from file %s:numBytes=%d\n", G9_UDMA_DTCP_KEY_FILENAME,numBytes);
        return 0;
    }

    fclose(fp);
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Reading DTLA Keys from NVRAM\n");
    //NVRAM_Read(NV_1394_DTCPKEY, (vlUINT32)pDTLAKey, size, 0);
	/*
    {
		int ix;
             //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Retrieved DTLA Key:\n");

		for (ix = 0; ix < size; ix++)
		{
			if (0 == (ix%4))
			{
                     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, " ");
			}
			if (0 == (ix%16))
			{
                     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n");
			}
                 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "%02X",pDTLAKey[ix]);
		}
	}
	*/

#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        memcpy(pDTLAKey,g_vlDtcpKeyBuff,size);
    }
#endif
    }
#endif /*NEW_MFR_INTERFACE*/
    return size;
}

static int FBConfig_GetStoredVLCert(unsigned char *pVLCert,int size)
{
#ifdef NEW_MFR_INTERFACE
//#if 0
    {
       //// VL_NVRAM_DATA data;
        // //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Reading certificate from NVRAM: BEGIN\n");
//              //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_GetStoredVLCert: vlGetMfrData 1 size=%d\n", size);
       ////vlGetMfrData(VL_SECURE_NVRAM_DATA_VL_CERT_KEYS,&data,1); //Get Model name
//             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "ERROR: size = %d and data.nActualBytes = %ld\n",size,data.nActualBytes);
        VL_NVRAM_DATA data, encrypted_data, serial_num;
//             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredDTLAKeyBuf: vlGetMfrData 1 size=%d\n", size);
        vlGetMfrData(VL_SECURE_NVRAM_DATA_VL_CERT_KEYS,&encrypted_data,1); //Get DTCP keys
        vlGetMfrData(VL_SECURE_NVRAM_DATA_SERIAL_NUMBER,&serial_num,1); //Get DTCP keys
        vlDecryptNVRAMData(&serial_num,&encrypted_data,&data);

        if((unsigned int)size != data.nActualBytes)
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "ERROR: size doesnt match .. size = %d and data.nActualBytes = %ld\n",size,data.nActualBytes);
        }
        if(data.nActualBytes)
        {
            memcpy(pVLCert, &data.pData[0], data.nActualBytes);
//             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "Reading certificate from NVRAM: SUCCESS\n");
            free(data.pData);
            return size;
        }
        else
        {
            return 0;
        }
    }
#else
    {
	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_GetStoredVLCert(Filesystem): reading %d bytes\n",size);


#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    {
    FILE *fp;
    int numBytes = 0;

         //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "GetStoredVLCert: BEGIN\n");
    fp = fopen(G9_UDMA_VLCERT_FILENAME, "rb");
    if(fp == NULL)
    {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredVLCert: Could not open file %s:numBytes=%d\n", G9_UDMA_VLCERT_FILENAME,numBytes);
        return 0;
    }

    numBytes = fread(pVLCert,  size,1,fp);
    if(numBytes != 1)
    {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "GetStoredVLCert: Failed to read data from file %s:numBytes=%d\n", G9_UDMA_VLCERT_FILENAME,numBytes);
        return 0;
    }

    fclose(fp);
    }
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
    {
    unsigned char dummyHdr[4];
    unsigned char tempSignature[4] = {0xC1,0xAA,0xAA,0xAA};

    NVRAM_Read(NV_1394_VLKEY, (vlUINT32)dummyHdr, 4, 0);

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "FBConfig_GetStoredVLCert : 0x%02x%02x%02x%02x\n", dummyHdr[0],dummyHdr[1], dummyHdr[2], dummyHdr[3]);
    //If a valid signature is present in the first 4 bytes, then we assume the
    //NVRAM has been programmed..
    if(memcmp(dummyHdr, tempSignature, 4) != 0)
    {
        //return 0;
		 //RMF_LOG(RMF_LOG_WARN, RMF_MOD_NET, "\n WARNING!  VL_SIGNATURE did NOT match.  Proceeding for now..\n");
	//remove this once signature matching ok..
		NVRAM_Read(NV_1394_VLKEY + 4, (vlUINT32)pVLCert, size, 0);
	}
    else
    {
        NVRAM_Read(NV_1394_VLKEY + 4, (vlUINT32)pVLCert, size, 0);
    }

}
#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
{

    unsigned char dummyHdr[4];
    unsigned char tempSignature[4] = {0xC1,0xAA,0xAA,0xAA};

    memcpy(dummyHdr,g_vlCertBuff, 4);

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "FBConfig_GetStoredVLCert : 0x%02x%02x%02x%02x\n", dummyHdr[0],dummyHdr[1], dummyHdr[2], dummyHdr[3]);
    //If a valid signature is present in the first 4 bytes, then we assume the
    //NVRAM has been programmed..
    if(memcmp(dummyHdr, tempSignature, 4) != 0)
    {
        return 0;
    }
    else
    {
        memcpy(pVLCert,&g_vlCertBuff[4],size);
    }
}
#endif
    }
#endif /*NEW_MFR_INTERFACE*/
    return size;
}


static int FBConfig_GetStoreSeed(unsigned char *pSeed,int size)
{
#ifdef NEW_MFR_INTERFACE
    {
        VL_NVRAM_DATA data;
        vlGetMfrData(VL_SECURE_NVRAM_DATA_IEEE1394_DTCP_SEED,&data,1); //Get DTCP keys
        if(data.nActualBytes)
        {
            memcpy(pSeed,&data.pData[0], data.nActualBytes);
            free(data.pData);
        }
        else
        {
             //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_GetStoreSeed: Failed to get DTCP seed\n");
            return 0;
        }
    }

#else

	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n Within FBConfig_GetStoreSeed(Filesystem): reading %d bytes\n",size);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
    {
    FILE *fp;
    int numBytes;

     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "FBConfig_GetStoreSeed: BEGIN\n");
    fp = fopen(G9_UDMA_SEED_FILENAME, "rb");
    if(fp == NULL)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_GetStoreSeed: Could not open file %s\n", G9_UDMA_SEED_FILENAME);
        return 0;
    }

    numBytes = fread(pSeed,  size,1, fp);
    if(numBytes != 1)
    {
         //RMF_LOG(RMF_LOG_ERROR, RMF_MOD_NET, "FBConfig_GetStoreSeed: Failed to read data from file %s:numBytes=%d\n", G9_UDMA_SEED_FILENAME,numBytes);
        return 0;
    }
/*
     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n OK, Seed from filesystem:");
    {
		int ix;
		for (ix = 0; ix < size; ix++)
		{
			if (0 == ix%4)
			{
				 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n");
			}
			 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, " %02X",pSeed[ix]);
		}
	}
*/
    fclose(fp);
    }
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
     //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "Reading SEED from NVRAM\n");
    NVRAM_Read(NV_1394_SEED, (vlUINT32)pSeed, size, 0);

#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        int i;
        vlDTCPKeyFormat3_t *vlDTCPKeys = (vlDTCPKeyFormat3_t*)g_vlDtcpKeyBuff;
        for (i=0; i<size;i++)
        {
            pSeed[i] = vlDTCPKeys->RandSeed[i];
        }
    }
#endif
#endif /*NEW_MFR_INTERFACE*/
    return size;

}

char vlg_FBConfig_tempKeyBuf[2046];

static void FBConfig_PrintStoredData(int type)
{
	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET, "\n type %d:\n", type);
#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
//No need as we can FTP the corresponding files from /udma.. using wsftp
#endif

#ifdef VL_USE_KEYS_IN_NVRAM

    NVRAM_Read(NV_1394_VLKEY, (vlUINT32)vlg_FBConfig_tempKeyBuf, 128, 0);
    cVLPrintBytes("VLCERT:",vlg_FBConfig_tempKeyBuf,128);

    NVRAM_Read(NV_1394_DTCPKEY, (vlUINT32)vlg_FBConfig_tempKeyBuf, 648, 0);
    cVLPrintBytes("DTCP KEY:",vlg_FBConfig_tempKeyBuf,648);
#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        cVLPrintBytes("VLCERT:",g_vlCertBuff,128);
        cVLPrintBytes("DTCP KEY:",g_vlDtcpKeyBuff,648);
        cVLPrintBytes("SRM:",g_vlSrmBuff,100);
    }
#endif

}

static void FBConfig_ClearStoredData(int type)
{
	 //RMF_LOG(RMF_LOG_DEBUG, RMF_MOD_NET,"\n type %d:\n", type);

#ifdef VL_USE_KEYS_IN_FILE_SYSTEM
//No need as we can just delete the corresponding files from /udma.. using wsftp
#endif

#ifdef VL_USE_KEYS_IN_NVRAM
    unsigned char empty[4] = {0x00,0x00,0x00,0x00};
    //just clear the dummy signature
    NVRAM_Write((vlUINT32)empty, NV_1394_VLKEY, 4, 0);
#endif

#ifdef VL_USE_KEYS_IN_BIN_IMAGE
    {
        //just clear the dummy signature
        memset(g_vlCertBuff,0,4);
    }
#endif

    return;
}

#endif __FB_NVRAM_API__
