/******************************************************************************
 *    (c)2010-2013 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or its licensors,
 * and may only be used, duplicated, modified or distributed pursuant to the terms and
 * conditions of a separate, written license agreement executed between you and Broadcom
 * (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 * no license (express or implied), right to use, or waiver of any kind with respect to the
 * Software, and Broadcom expressly reserves all rights in and to the Software and all
 * intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 * HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 * NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 * secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 * and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 * OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 * LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 * OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 * USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 * LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 * EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 * USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 * ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 * LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 * ANY LIMITED REMEDY.
 *
 *****************************************************************************/

#include <direct/LockWQ.h>

#include <core/Debug.h>
#include <core/Renderer.h>
#include <core/Task.h>
#include <core/Util.h>

extern "C" {
#include "bcm_config.h"

#include <directfb.h>

#include <direct/debug.h>
#include <direct/messages.h>

#include <core/surface_allocation.h>
#include <core/surface_pool.h>
#include <core/system.h>

#include <gfx/convert.h>

#include "bcmnexus_gfx.h"
#include "bcmnexus_pool.h"

}

#if BCM_DFB_USE_TASK_MANAGER


#include "M2MC_Core.h"
#include "M2MC_Engine.h"
#include "M2MC_Task.h"


D_DEBUG_DOMAIN( M2MC_Task,         "M2MC/Task",         "M2MC Task" );

/*********************************************************************************************************************/

namespace Broadcom {


M2MCTask::M2MCTask( M2MCEngine *engine, unsigned int tile_number )
     :
     SurfaceTask( CSAID_GPU ),
     engine( engine ),
     tile_number( tile_number )
{
     D_DEBUG_AT( M2MC_Task, "M2MCTask::%s( %p, tile %u )\n", __FUNCTION__, (void*)this, tile_number );

     D_FLAGS_SET( flags, DirectFB::TASK_FLAG_NEED_SLAVE_PUSH );

     memset( &Bdriver, 0, sizeof(Bdriver) );
     memset( &Bdevice, 0, sizeof(Bdevice) );

     memset( &Bdevice.packetHWStates, 0x77, sizeof(Bdevice.packetHWStates) );

     Bdevice.packetHWStates.packetDstNone = false;
     Bdevice.packetHWStates.packetSrcNone = false;

     Bdriver.packetSettings.packetBufSize = ~0;

     Bdevice.mode = BCMNEXUS_GFX_2D;

     NEXUS_Graphics2D_GetDefaultFillSettings(&Bdriver.fillSettings);
     NEXUS_Graphics2D_GetDefaultPorterDuffFillSettings(&Bdriver.PorterDuffFillSettings);
     NEXUS_Graphics2D_GetDefaultBlitSettings(&Bdriver.blitSettings);
     Bdriver.blitSettings.conversionMatrix.shift = 8;

     Bdriver.pBrcmDfb                    = engine->pBrcmDfb;

     Bdriver.intermediateSurfaceSize     = engine->intermediateSurfaceSize;
     Bdriver.intermediateSurfaceAddr     = engine->intermediateSurfaceAddr;
     Bdriver.intermediateSurfaceSettings = engine->intermediateSurfaceSettings;
}

DFBResult
M2MCTask::Setup()
{
     D_DEBUG_AT( M2MC_Task, "M2MCTask::%s( %p )\n", __FUNCTION__, (void*)this );

     D_MAGIC_ASSERT( this, Task );

     DFB_TASK_CHECK_STATE( this, DirectFB::TASK_FLUSHED, return DFB_BUG );

     DFB_TASK_LOG( "M2MCTask::Setup()" );

     const std::vector<DirectFB::SurfaceAllocationAccess> &accesses = master ? ((DirectFB::SurfaceTask*) master)->accesses : this->accesses;

     D_ASSERT( accesses.size() > 0 );
     D_ASSERT( accesses[0].flags & CSAF_WRITE );
     D_MAGIC_ASSERT( accesses[0].allocation, CoreSurfaceAllocation );

     D_ASSERT( qid == 0 );
     qid = ((u64) accesses[0].allocation->object.id << 32) | tile_number;

     return SurfaceTask::Setup();
}

DFBResult
M2MCTask::Push()
{
     D_DEBUG_AT( M2MC_Task, "M2MCTask::%s( %p )\n", __FUNCTION__, (void*)this );

     D_MAGIC_ASSERT( this, Task );

     DFB_TASK_CHECK_STATE( this, DirectFB::TASK_RUNNING, return DFB_BUG );

     DFB_TASK_LOG( "M2MCTask::Push()" );

     if (master) {
          D_MAGIC_ASSERT( master, Task );
          D_ASSERT( ((M2MCTask*) master)->qid != 0 );

          D_ASSERT( qid == 0 );
          qid = ((u64) ((SurfaceTask*) master)->accesses[0].allocation->object.id << 32) | tile_number;
     }

     engine->threads.Push( this );

     return DFB_OK;
}

void
M2MCTask::Finalise()
{
     D_DEBUG_AT( M2MC_Task, "M2MCTask::%s( %p )\n", __FUNCTION__, (void*)this );

     D_MAGIC_ASSERT( this, Task );

     DFB_TASK_CHECK_STATE( this, DirectFB::TASK_FINISH, return );

     DFB_TASK_LOG( "M2MCTask::Finalise()" );

     engine->threads.Finalise( this );

     SurfaceTask::Finalise();
}

DFBResult
M2MCTask::Run()
{
     D_DEBUG_AT( M2MC_Task, "M2MCTask::%s( %p )\n", __FUNCTION__, (void*)this );

     if (buffer.GetLength() == 0) {
          Done();

          return DFB_OK;
     }

     D_DEBUG_AT( M2MC_Task, "  -> task length %d\n", buffer.GetLength() );

     D_ASSERT( hwid < engine->caps.cores );
     D_ASSERT( hwid < engine->cores.size() );

     M2MCCore *core = engine->cores[hwid];

     D_ASSERT( core != NULL );

     return core->Run( this );
}


}

#endif /* BCM_DFB_USE_TASK_MANAGER */

