/***************************************************************************
 *     (c)2007-2013 Broadcom Corporation
 *
 *  This program is the proprietary software of Broadcom Corporation and/or its licensors,
 *  and may only be used, duplicated, modified or distributed pursuant to the terms and
 *  conditions of a separate, written license agreement executed between you and Broadcom
 *  (an "Authorized License").  Except as set forth in an Authorized License, Broadcom grants
 *  no license (express or implied), right to use, or waiver of any kind with respect to the
 *  Software, and Broadcom expressly reserves all rights in and to the Software and all
 *  intellectual property rights therein.  IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU
 *  HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY
 *  NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE SOFTWARE.
 *
 *  Except as expressly set forth in the Authorized License,
 *
 *  1.     This program, including its structure, sequence and organization, constitutes the valuable trade
 *  secrets of Broadcom, and you shall use all reasonable efforts to protect the confidentiality thereof,
 *  and to use this information only in connection with your use of Broadcom integrated circuit products.
 *
 *  2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 *  AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
 *  WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 *  THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL IMPLIED WARRANTIES
 *  OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
 *  LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
 *  OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
 *  USE OR PERFORMANCE OF THE SOFTWARE.
 *
 *  3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
 *  LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
 *  EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
 *  USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
 *  THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
 *  ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
 *  LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
 *  ANY LIMITED REMEDY.
 *
 ***************************************************************************/

#ifndef __bcmnexus_gfx_H__
#define __bcmnexus_gfx_H__

#include "bcmnexus.h"
#include "bcmnexus_utils.h"

#include "bcmnexus_gfx_platforms.h"

/* If updating any of the APIs or making any radical changes please rev the major version number.
   Any functional changes or bug fixes please update the minor version number */
#define BCMNEXUS_GFX_MAJOR_VERSION 5
#define BCMNEXUS_GFX_MINOR_VERSION 0

typedef enum {
     BCMNEXUS_GFX_IDLE,
     BCMNEXUS_GFX_2D
} bcmnexus_gfxMode;

typedef enum {
     m_None             = 0x0000,
     m_Source           = 0x0001,
     m_Destination      = 0x0002,
     m_Output           = 0x0004,
     m_SrcColorKey      = 0x0008,
     m_DstColorKey      = 0x0010,
     m_BlendEq          = 0x0020,
     m_Filter           = 0x0040,
     m_Matrix           = 0x0080,
     m_ColorMatrix      = 0x0100,
     m_AlphaPremult     = 0x0200,
     m_Mirror           = 0x0400,
     m_Rop              = 0x0800,
     m_All              = 0x0FFF

} BcmnexusStateBits;

#ifndef BCMNEXUS_GFX_PACKET_BUFFER

#define BCMNEXUS_VALIDATE(b)
#define BCMNEXUS_INVALIDATE(b)
#define BCMNEXUS_IS_VALID(b)      (false)
#define BCMNEXUS_ARE_VALID(b)     (false)

#else

#define BCMNEXUS_VALIDATE(b)      (pBdev->stateValidFlags |= (b))
#define BCMNEXUS_INVALIDATE(b)    (pBdev->stateValidFlags &= ~(b))
#define BCMNEXUS_IS_VALID(b)      (pBdev->stateValidFlags & (b))
#define BCMNEXUS_ARE_VALID(b)     (!((pBdev->stateValidFlags & (b)) ^ (b)))

typedef struct bcmnexus_gfxPacketHWStates_tag
{
    // Source Feeder
    BM2MC_PACKET_Plane                      packetSrcPlane;
    uint32_t                                packetSrcColor;
    bool                                    packetSrcNone;

    // Destination Feeder
    BM2MC_PACKET_Plane                      packetDstPlane;
    uint32_t                                packetDstColor;
    bool                                    packetDstNone;

    // Output Feeder
    BM2MC_PACKET_Plane                      packetOutPlane;

    // Blend Equation
    BM2MC_PACKET_Blend                      packetColorBlendOp;
    BM2MC_PACKET_Blend                      packetAlphaBlendOp;
    uint32_t                                packetBlendColor;

    // ROP
    uint32_t                                packetRop;

    // Source Color Key
    uint32_t                                packetSrcColorkey;
    int                                     packetSrcColorkeyEnable;

    // Destination Color Key
    uint32_t                                packetDstColorkey;
    int                                     packetDstColorkeyEnable;

    // Filter
    NEXUS_Graphics2DFilterCoeffs            packetHorzFilter;
    NEXUS_Graphics2DFilterCoeffs            packetVertFilter;
    BM2MC_PACKET_Rectangle                  packetFilterSrcRect;
    BM2MC_PACKET_Rectangle                  packetFilterOutRect;
    BM2MC_PACKET_FilterCoeffs               packetFilterHorzCoeffs;
    BM2MC_PACKET_FilterCoeffs               packetFilterVertCoeffs;
    int                                     packetFilterEnable;

    // Color Matrix
    NEXUS_Graphics2DColorMatrix             packetColorMatrix;
    int                                     packetColorMatrixEnable;

    // Alpha Premultiply
    int                                     packetAlphaPremultiply;

    // Mirror
    int                                     packetMirrorSrcHorz;
    int                                     packetMirrorSrcVert;
    int                                     packetMirrorDstHorz;
    int                                     packetMirrorDstVert;
    int                                     packetMirrorOutHorz;
    int                                     packetMirrorOutVert;

    // FixedScale
    int32_t                                 packetHorPhase;
    int32_t                                 packetVerPhase;
    uint32_t                                packetHorStep;
    uint32_t                                packetVerStep;

    // Dither
    bool                                    packetDither;
    bool                                    packetChromaFilter;

} bcmnexus_gfxPacketHWStates;

typedef struct bcmnexus_gfxPacketSettings_tag
{
    void *                                  packetBufStartPtr;
    void *                                  packetBufDumpPtr;
    void *                                  packetBufNextPtr;
    void *                                  packetBufLastExecPtr;
    size_t                                  packetBufSize;

    NEXUS_Graphics2DHandle                  hGfx2D;

    uint32_t                                packetConstantColor;
    NEXUS_Graphics2DFilterCoeffs            packetHorzFilter;
    NEXUS_Graphics2DFilterCoeffs            packetVertFilter;
    BM2MC_PACKET_Rectangle                  packetSrcRect;
    BM2MC_PACKET_Rectangle                  packetOutRect;
    BM2MC_PACKET_Rectangle                  packetDstRect;

    BM2MC_PACKET_Plane                      packetSrcPlane;
    BM2MC_PACKET_Plane                      packetDstPlane;
    BM2MC_PACKET_Plane                      packetOutPlane;

    int32_t                                 packetHorPhase;
    int32_t                                 packetVerPhase;
    uint32_t                                packetHorStep;
    uint32_t                                packetVerStep;

    bool                                    packetSetRGBYUVColorMatrix;

}bcmnexus_gfxPacketSettings;
#endif

typedef struct
{
    pthread_mutex_t                         syncLock;
    pthread_cond_t                          syncCond;
#ifdef BCMNEXUS_GFX_PACKET_BUFFER
    pthread_cond_t                          packetSpaceAvailCond;
    pthread_mutex_t                         packetSpaceAvailLock;
    bcmnexus_gfxPacketHWStates              packetHWStates;
    DFBSurfaceDrawingFlags                  drawingflags;
    DFBSurfaceBlittingFlags                 blittingflags;
    DFBAccelerationMask                     accel;
    DFBSurfaceRenderOptions                 renderOptions;
    BcmnexusStateBits                       stateValidFlags;
#endif
    bcmnexus_gfxMode                        mode;
    unsigned int                            count;
} bcmnexus_gfxDeviceData;

typedef struct
{
    NEXUS_Graphics2DHandle                  hGfx2D;
    DFBBCMNEXUS                            *pBrcmDfb;               /* pointer to brcm system data structure - needed for surf cache */
    bool                                    blitDest;               /* set to true when "destination" block in M2MC is enabled */
    bool                                    blitFast;               /* set to true when we need to do a fast blit */
    bool                                    odd_shift_enable;       /* set to true if checking for odd alignment in x or w is required */
    NEXUS_Pixel                             sourcePixelFormat;      /* Source surface Nexus pixel format */
    NEXUS_Graphics2DBlitSettings            blitSettings;
    NEXUS_Graphics2DFillSettings            fillSettings;
    NEXUS_Graphics2DPorterDuffFillSettings  PorterDuffFillSettings;
#ifdef BCMNEXUS_GFX_PACKET_BUFFER
    bcmnexus_gfxPacketSettings              packetSettings;
#endif
    size_t                                  intermediateSurfaceSize;
    void                                   *intermediateSurfaceAddr;
    unsigned int                            intermediateSurfaceVirtAddr;
    NEXUS_SurfaceCreateSettings             intermediateSurfaceSettings;
    NEXUS_SurfaceHandle                     hIntermediateSurface;   /* required when alpha blending AND colour blending */
    s32                                     matrix[9];
    bool                                    matrix_affine;
    bool                                    matrix_enabled;
    bool                                    matrix_scales;
    bool                                    matrix_flips_x;
    bool                                    matrix_flips_y;
    DFBRegion                               dst_clip;

    unsigned int                            graphics2d_index;
} bcmnexus_gfxDriverData;

#define NEXUS_PIXEL_FORMAT_ALPHA_NONE(f)    \
(                                           \
    ((f) == NEXUS_PixelFormat_eR5_G6_B5) || \
    ((f) == NEXUS_PixelFormat_eR8_G8_B8)    \
)

#ifdef BCMNEXUS_GFX_PACKET_BUFFER
#define bcmnexus_gfx_SUPPORTED_DRAWINGFLAGS \
               (DSDRAW_BLEND | DSDRAW_DST_COLORKEY | DSDRAW_XOR |DSDRAW_SRC_PREMULTIPLY)
#else
#define bcmnexus_gfx_SUPPORTED_DRAWINGFLAGS \
               (DSDRAW_BLEND | DSDRAW_SRC_PREMULTIPLY)
#endif

#if BCM_DFB_NATIVE_GFX_SPAN_SUPPORT
#define bcmnexus_gfx_SUPPORTED_DRAWINGFUNCTIONS \
               (DFXL_FILLRECTANGLE | DFXL_DRAWRECTANGLE | DFXL_FILLTRAPEZOID | DFXL_FILLSPAN)
#else
#define bcmnexus_gfx_SUPPORTED_DRAWINGFUNCTIONS \
               (DFXL_FILLRECTANGLE | DFXL_DRAWRECTANGLE | DFXL_FILLTRAPEZOID)
#endif

/* M2MC graphics support */
#define bcmnexus_gfx_SUPPORTED_BLITTINGFLAGS  \
              ( DSBLIT_BLEND_ALPHACHANNEL   | \
                DSBLIT_BLEND_COLORALPHA     | \
                DSBLIT_COLORIZE             | \
                DSBLIT_SRC_PREMULTIPLY      | \
                DSBLIT_SRC_COLORKEY         | \
                DSBLIT_DST_COLORKEY         | \
                DSBLIT_SRC_PREMULTCOLOR     | \
                DSBLIT_XOR                  | \
                DSBLIT_ROTATE180            | \
                DSBLIT_FLIP_HORIZONTAL      | \
                DSBLIT_FLIP_VERTICAL )

#define bcmnexus_gfx_SUPPORTED_BLITTINGFUNCTIONS \
              ( DFXL_BLIT                   |    \
                DFXL_BLIT2                  |    \
                DFXL_STRETCHBLIT )

#define BCMNEXUS_GFX_STRIP_WIDTH_MAX 128
#define BCMNEXUS_GFX_SCALE_DOWN_MAX_X 15
#define BCMNEXUS_GFX_SCALE_DOWN_MAX_Y 7

/* Define Graphics 2D flush counts and increments */
#if defined(BCMNEXUS_GFX_PACKET_BUFFER)
#define BCMNEXUS_GRAPHICS2D_FLUSH_COUNT     4000
#define BCMNEXUS_GRAPHICS2D_DRAW_RECT_INC   1
#else
#define BCMNEXUS_GRAPHICS2D_FLUSH_COUNT     400
#define BCMNEXUS_GRAPHICS2D_DRAW_RECT_INC   4
#endif

#define BCMNEXUS_GRAPHICS2D_FILL_RECT_INC   1
#define BCMNEXUS_GRAPHICS2D_FILL_TRAP_INC   1
#define BCMNEXUS_GRAPHICS2D_BLIT_INC        1

/* Define Graphics 3D flush counts and increments */
#define BCMNEXUS_GRAPHICS3D_FLUSH_COUNT     400
#define BCMNEXUS_GRAPHICS3D_DRAW_RECT_INC   4
#define BCMNEXUS_GRAPHICS3D_DRAW_LINE_INC   1
#define BCMNEXUS_GRAPHICS3D_FILL_RECT_INC   4
#define BCMNEXUS_GRAPHICS3D_FILL_TRAP_INC   6
#define BCMNEXUS_GRAPHICS3D_FILL_TRI_INC    3
#define BCMNEXUS_GRAPHICS3D_TEXT_TRI_INC    3
#define BCMNEXUS_GRAPHICS3D_BLIT_INC        6

#define ARGB_MASK   0xFFFFFFFF
#define RGB_MASK    0x00FFFFFF
#define ROP_XOR     0x66
#define ROP_SOURCE  0xCC

/* Color conversion coefficient matrix helpers */
#define MAKE_CSC_C(c, s)      ((int32_t)((c) * (1 << (s))))

#define MAKE_CSC_MATRIX(s, p0c0, p0c1, p0c2, p0a, p0off,            \
                           p1c0, p1c1, p1c2, p1a, p1off,            \
                           p2c0, p2c1, p2c2, p2a, p2off,            \
                           ac0,  ac1,  ac2,  aa,  aoff)             \
{                                                                   \
    s,                                                              \
    {                                                               \
        MAKE_CSC_C(p0c0, s),                                        \
        MAKE_CSC_C(p0c1, s),                                        \
        MAKE_CSC_C(p0c2, s),                                        \
        MAKE_CSC_C(p0a, s),                                         \
        MAKE_CSC_C(p0off, s),                                       \
        MAKE_CSC_C(p1c0, s),                                        \
        MAKE_CSC_C(p1c1, s),                                        \
        MAKE_CSC_C(p1c2, s),                                        \
        MAKE_CSC_C(p1a, s),                                         \
        MAKE_CSC_C(p1off, s),                                       \
        MAKE_CSC_C(p2c0, s),                                        \
        MAKE_CSC_C(p2c1, s),                                        \
        MAKE_CSC_C(p2c2, s),                                        \
        MAKE_CSC_C(p2a, s),                                         \
        MAKE_CSC_C(p2off, s),                                       \
        MAKE_CSC_C(ac0, s),                                         \
        MAKE_CSC_C(ac1, s),                                         \
        MAKE_CSC_C(ac2, s),                                         \
        MAKE_CSC_C(aa, s),                                          \
        MAKE_CSC_C(aoff, s)                                         \
    }                                                               \
}

#if BCM_DFB_USE_TASK_MANAGER
void notify_m2mc(void);
void register_m2mc(void);

extern const GraphicsDeviceFuncs *bcmnexus_GraphicsFuncs;
#endif

void bcmnexus_gfxDumpCommands( u32 *p, size_t off, size_t len );

#endif
