/**
* @file InitRequest.h
*
*/

#ifndef INITREQUEST_H_
#define INITREQUEST_H_

#include "SDVMessage.h"

namespace sdv {

/**
 * @class InitRequest
 * @brief CCMIS InitRequest class definition.
 *
 * @details Defines CCMIS InitRequest outbound message.
 */
class InitRequest : public SDVMessage {
public:

	/**
	 * @constructor
	 * @brief Constructor to create an InitRequest SDV message using the specified parameters.
	 *
	 * @param [in] macAddress - local mac address of our DOCSIS interface
	 * @param [in] serviceGroupId - the service group the client sending messaage is in
	 */
	InitRequest(uint8_t* macAddress, uint32_t serviceGroupId);

	/**
	 * @fn serialize
	 * @brief Serialize this message into the specified empty buffer.
	 * The serialized data will be ready for UDP transmission to the SDV Server.
	 *
	 * @param [out] emptyBuff - empty buffer to store serialized message
	 * @param [in] maxBuffLength - maximum length of empty buffer in bytes
	 * @return length of serialized message in bytes
	 */
	size_t serialize(uint8_t* emptyBuff, size_t buffLength);


private:

	static const uint16_t PAYLOAD_LENGTH = 0x000A;			//!< length in bytes of payload for this message
	static const uint8_t INIT_REQUEST_TUNER_INDEX = 0xff;	//!< tuner index not used for this message
	static const uint8_t CLIENT_VERSION = 0x00;				//!< version of this SDV client

	/**
	 * @struct ccmis_init_request
	 * @brief Data structure of CCMIS InitRequest that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_init_request {
		struct ccmis_header header;
		uint16_t reserved1;
		uint32_t service_group_id;
		uint8_t version;
		uint8_t reverved2;
		uint16_t num_desc;
	} CCMIS_INIT_REQUEST;
#pragma pack(pop)

	uint32_t service_group_id;
};

}

#endif /* INITREQUEST_H_ */
