#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "EventIndication.h"

using namespace sdv;

#define DONT_CARE 0x99

#define MAC 0x88,0x77,0x66,0x55,0x44,0x33

#define SOURCEID_HEX  0x22,0x31,0x52,0x12
#define SOURCEID_INT 0x22315212

#define GROUP_ID_HEX 0x21,0x34,0x56,0x15
#define GROUP_ID_INT 0x21345615

#define TUNER_USE 0x9
#define TUNER_INDEX 0x3

#define LAST_ACTIVITY_HEX 0x12,0x34,0x56,0x78
#define LAST_ACTIIVITY_INT 0x12345678

#define TRANSACTION_ID_HEX 0x11,0x22,0x33,0x44
#define TRANSACTION_ID_INT 0x11223344

#define ATTRIBUTE_LENGTH 2

#define ATTRIBUTE_OUT_TAG 0x01
#define ATTRIBUTE_OUT_DATA TUNER_USE,DONT_CARE

#define ATTRIBUTE_IN_TAG 0x00
#define ATTRIBUTE_IN_DATA 0x00,0x00

using ::testing::Test;

using namespace sdv;

class EventIndicationTest : public Test {

};

// Expected output buffer after serialization
static uint8_t EXPECTED_BUFF_OUT[] = {
		0x11,
        0x04,
        0x80,0x05,                      // messageId
        DONT_CARE,DONT_CARE,DONT_CARE,DONT_CARE, // transactionId
        DONT_CARE,                      // reserved
        0x00,                           // adaptationLength
        0x00,0x18,                      // messageLength
        MAC,  							// session mac
        TUNER_INDEX,                    // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,  // unused session data
        DONT_CARE,DONT_CARE,		// reserved
        0x00,0x0a,    				// Private data length
        DONT_CARE,DONT_CARE,		// reserved
        SOURCEID_HEX,
        ATTRIBUTE_OUT_TAG,
        ATTRIBUTE_LENGTH,
        ATTRIBUTE_OUT_DATA };

static uint8_t TEST_BUFFER_IN[] = {
		0x11,
        0x04,
        0x80,0x05,                      // messageId
        TRANSACTION_ID_HEX,   			// transactionId
        DONT_CARE,                      // reserved
        0x00,                           // adaptationLength
        0x00,0x18,                      // messageLength
        MAC,  							// session mac
        TUNER_INDEX,                    // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,  // unused session data
        DONT_CARE,DONT_CARE,		// reserved
        0x00,0x0a,    				// Private data length
        DONT_CARE,DONT_CARE,		// reserved
        SOURCEID_HEX,
        ATTRIBUTE_IN_TAG,
        ATTRIBUTE_LENGTH,
        ATTRIBUTE_IN_DATA };

TEST_F(EventIndicationTest, OutboundMessageTest) {
    SDVMessage::MessageId msgId = SDVMessage::EventIndication;
    uint8_t buff[512];
    uint8_t test_mac[] = {MAC};

    SDVMessage* msg = new EventIndication(test_mac, TUNER_INDEX, SOURCEID_INT, TUNER_USE);

    size_t buffLen = msg->serialize(buff, sizeof(buff));
    ASSERT_EQ(buffLen, sizeof(EXPECTED_BUFF_OUT));

    // Verify raw message data
    for (int i = 0; i < buffLen; ++i) {
        if (EXPECTED_BUFF_OUT[i] == DONT_CARE) continue;
        ASSERT_EQ(EXPECTED_BUFF_OUT[i], buff[i]);
    }
    delete msg;
}

TEST_F(EventIndicationTest, InboundMessageTest) {

	EventIndication* msg = new EventIndication((unsigned char*)TEST_BUFFER_IN);

    ASSERT_EQ(msg->getMessageId(), SDVMessage::EventIndication);
    ASSERT_EQ(msg->getTransactionId(), TRANSACTION_ID_INT);
    ASSERT_EQ(msg->getTunerIndex(), TUNER_INDEX);
    ASSERT_EQ(msg->getAttributeType(), EventIndication::DISPLAY_BARKER);

	delete msg;
}
