#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "InitConfirm.h"

using namespace sdv;

#define DONT_CARE 0x99

using ::testing::Test;

class InitConfirmTest : public Test{
public:
    const static uint8_t TEST_BUFFER[32];
};

const uint8_t InitConfirmTest::TEST_BUFFER[32] = { 0x11,
        0x04,
        0x80,0x02,  // messageId
        DONT_CARE,DONT_CARE,DONT_CARE,DONT_CARE,    // transactionId
        DONT_CARE,  // reserved
        0x00,       // adaptationLength
        0x00,0xC,  // messageLength
        0x11,0x22,0x33,0x44,0x55,0x66,  // session mac
        0xff,       // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,      // unused session data
        0x80,0x01 };      // numDesc

TEST_F(InitConfirmTest, InBoundMessageTest) {

    InitConfirm* msg = new InitConfirm((unsigned char*)TEST_BUFFER);
	ASSERT_EQ(msg->getMessageId(), SDVMessage::InitConfirm);
	ASSERT_EQ(msg->getResponseCode(), InitConfirm::RspInvalidSG);

	delete msg;
}
