#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "QueryRequest.h"

using namespace sdv;

#define DONT_CARE 0x99
#define TUNER_ID 0x8

#define TRANSACTION_ID_HEX 0x11,0x22,0x33,0x44
#define TRANSACTION_ID_INT 0x11223344

using ::testing::Test;



class QueryRequestTest : public Test {

public:

};

static uint8_t TEST_BUFFER[] = {
		0x11,
        0x04,
        0x80,0x03,  // messageId
        TRANSACTION_ID_HEX,
        DONT_CARE,  					// reserved
        0x00,       					// adaptationLength
        0x00,0x0C,  					// messageLength
        0x11,0x22,0x33,0x44,0x55,0x66,  // session mac
        TUNER_ID,       				// testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,  // unused session data
        DONT_CARE, DONT_CARE};


TEST_F(QueryRequestTest, InboundMessageTest) {

    QueryRequest* msg = new QueryRequest((unsigned char*)TEST_BUFFER);
    ASSERT_EQ(msg->getMessageId(), SDVMessage::QueryRequest);
    ASSERT_EQ(msg->getTransactionId(), TRANSACTION_ID_INT);
    ASSERT_EQ(msg->getTunerIndex(), TUNER_ID);
    delete msg;
}
