#include "SDVSessionHandler.h"
#include "gmock/gmock.h"
#include "SDVMessage.h"

#include <pthread.h>

using namespace sdv;


class MockSDVSessionHandler : public SDVSessionHandler {

public:

    MockSDVSessionHandler() : SDVSessionHandler(NULL, NULL, NULL, NULL, NULL) {
    	printf("new MockSDVSessionHandler\n");
    	testSession = NULL;
    };

    MOCK_METHOD2(getOpenSession, int(uint32_t tunerId, SDV_SESSION* session));
    MOCK_METHOD1(getAnyOpenSession, int(SDV_SESSION* session));


    void presetSession(SDV_SESSION* session) {
        testSession = session;
    }

    int getAnyOpenSessionAction(SDV_SESSION *session) {
    	if (testSession != NULL) {
			*session = *testSession;
			return 0;
    	}
    	else {
    		return -1;
    	}
    }

    int getOpenSessionAction(uint32_t tunerId, SDV_SESSION *session) {
    	if (testSession != NULL && tunerId == testSession->tunerId) {
			*session = *testSession;
			return 0;
    	}
    	else {
    		return -1;
    	}
    }

    // SDVSessionHandler(IARMProxyService *iarmProxy, MessageService *messageService, SDVEventQueue *queue, ConfigurationParser * config, SDVChannelMap * sdvChannelMap);
    // void SDVSessionHandler::forceTune(SDV_SESSION* session)
    // void SDVSessionHandler::forceTuneAllSessions()

private:

    SDV_SESSION* testSession;
};
