#
# ============================================================================
# COMCAST C O N F I D E N T I A L AND PROPRIETARY
# ============================================================================
# This file and its contents are the intellectual property of Comcast.  It may
# not be used, copied, distributed or otherwise  disclosed in whole or in part
# without the express written permission of Comcast.
# ============================================================================
# Copyright (c) 2014 Comcast. All rights reserved.
# ============================================================================
#
SUMMARY = "SDV Agenet component"
SECTION = "console/utils"

LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=d41d8cd98f00b204e9800998ecf8427e"

DEPENDS += "trm-common rdk-logger iarmbus"
inherit autotools systemd pkgconfig syslog-ng-config-gen
SYSLOG-NG_FILTER_hybrid = "ocapri"
SYSLOG-NG_SERVICE_ocapri_append_hybrid = "sdvagent.service"
#The log rate and destination are mentioned at runsnmp-emu_git.bb, to avoid duplication of variables set we have commented the below variables.
#SYSLOG-NG_DESTINATION_ocapri_hybrid = "ocapri_log.txt"
#SYSLOG-NG_LOGRATE_ocapri_hybrid = "very-high"

PV = "${RDK_RELEASE}+git${SRCPV}"
SRCREV_sdvagent = "${AUTOREV}"
SRC_URI = "${RDK_GENERIC_ROOT_GIT}/sdvagent/generic;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH};name=sdvagent"

S = "${WORKDIR}/git"

EXTRA_OECONF += "--enable-yocto"
export RDK_PROJECT_ROOT_PATH = "${STAGING_DIR_TARGET}"
export RDK_FSROOT_PATH = "${STAGING_DIR_TARGET}"

do_install () {
        install -d ${D}${bindir} ${D}${systemd_unitdir}/system ${D}${includedir}
        install -m 0755 ${B}/src/sdvAgent ${D}${bindir}
        install -m 0644 ${S}/conf/sdvagent.service ${D}${systemd_unitdir}/system
        install -m 0644 ${S}/src/sdv_iarm.h ${D}${includedir}
}

FILES_${PN}_append_hybrid = " ${bindir}/sdvAgent"
SYSTEMD_SERVICE_${PN}_append_hybrid = " sdvagent.service"
FILES_${PN}_append_hybrid += "${systemd_unitdir}/system/sdvagent.service"
