#!/bin/sh

function usage()
{
    echo "Usage: `basename $0` [--directfb] [--eglfs] [--qtwebengine] [-h|--help]"
    echo "    -h    --help                  : this help"
    echo "          --directfb              : build DirectFB QPA plaform, requires DirectFB 1.7"
    echo "          --eglfs                 : build EGLFS QPA plaform, requires libegl1-mesa-dev libgles2-mesa-dev"
    echo "          --qtwebengine           : build QtWebEngine module"
    echo "          --no-gui                : build GUI-less version"
}

if ! GETOPT=$(getopt -n "$0" -o h -l directfb,eglfs,qtwebengine,no-gui -- "$@")
then
    usage
    exit 1
fi

eval set -- "$GETOPT"

export BUILD_CONFIG=""

while true; do
  case "$1" in
      -h | --help ) usage; exit 0 ;;
      --directfb )
          export BUILD_CONFIG=$BUILD_CONFIG:directfb
          ;;
      --eglfs ) 
          export BUILD_CONFIG=$BUILD_CONFIG:eglfs
          ;;
      --qtwebengine )
          export BUILD_CONFIG=$BUILD_CONFIG:qtwebengine
          ;;
      --no-gui )
          export BUILD_CONFIG=$BUILD_CONFIG:no-gui
          ;;
      -- ) shift; break;;
      * ) break;;
  esac
  shift
done

CURR_DIR=$(dirname $(readlink -f "$0"))

export QT_SRC_ROOT=${CURR_DIR}/source
export QT_RDK_PLATFORM_DIR=${QT_SRC_ROOT}/default_platform
export COMBINED_ROOT=/

if [[ -n ${DFB_ROOT} ]] && [[ -d ${DFB_ROOT}/lib/pkgconfig ]]
then
    export PKG_CONFIG_PATH=${DFB_ROOT}/lib/pkgconfig/:$PKG_CONFIG_PATH
fi

source ${CURR_DIR}/setenv.sh

export QT_BUILD_NUM_CPUS=$(($(grep -c ^processor /proc/cpuinfo) + 1))

make
