#!/bin/sh

export PERSISTENT_PATH=/opt
export SCRIPT_DIR=$(readlink -f $0 | xargs dirname)

if [ `uname -m` == "mips" ]; then
    export GST_STAGE=/usr
    export PPROF_PATH=/usr
    export QT_QPA_PLATFORM=eglfs
    export QT_QPA_EGLFS_DISABLE_BACKINGSTORE_FLUSH=1
    export QT_QPA_EGLFS_HIDECURSOR=1
else
    export GST_STAGE=/opt/gstreamer/stage
    export PPROF_PATH=/opt/gperftools/bin
    export RR_PATH=/opt/rr/bin/usr/local
    export HEAP_CHECK_DUMP_DIRECTORY=${SCRIPT_DIR}
    export GST_PLUGIN_SCANNER=${GST_STAGE}/libexec/gstreamer-1.0/gst-plugin-scanner
    export GST_PLUGIN_SYSTEM_PATH_1_0=${GST_STAGE}/lib/gstreamer-1.0
    export GST_PLUGIN_PATH_1_0=${GST_STAGE}/lib/gstreamer-1.0
    export GST_REGISTRY_1_0=${PERSISTENT_PATH}/.gst_registry_1_0
    export PATH=${RR_PATH}/bin:${GST_STAGE}/bin:${PPROF_PATH}/bin:${SCRIPT_DIR}:${PATH}
    export LD_LIBRARY_PATH=${RR_PATH}/lib:${GST_STAGE}/lib/:${PPROF_PATH}/lib/:${LD_LIBRARY_PATH}
    export PKG_CONFIG_PATH=${GST_STAGE}/lib/pkgconfig/:${PPROF_PATH}/lib/pkgconfig/:${PKG_CONFIG_PATH}
fi

export XDG_CONFIG_HOME=$PERSISTENT_PATH/.config
export XDG_DATA_HOME=$PERSISTENT_PATH/QT/home
export XDG_CACHE_HOME=$PERSISTENT_PATH/QT/cache
mkdir -p $XDG_CACHE_HOME
mkdir -p $XDG_DATA_HOME

export GST_DEBUG_NO_COLOR=1
export FONTCONFIG_PATH=/etc/fonts
export SSL_CERT_FILE=/etc/ssl/certs/ca-certificates.crt
