/*
 * Copyright (C) 2007-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2008 Matt Lilek. All rights reserved.
 * Copyright (C) 2008-2009 Anthony Ricaud <rik@webkit.org>
 * Copyright (C) 2009-2010 Joseph Pecoraro. All rights reserved.
 * Copyright (C) 2009-2011 Google Inc. All rights reserved.
 * Copyright (C) 2009 280 North Inc. All Rights Reserved.
 * Copyright (C) 2010 Nikita Vasilyev. All rights reserved.
 * Copyright (C) 2011 Brian Grinstead All rights reserved.
 * Copyright (C) 2013 Matt Holden <jftholden@yahoo.com>
 * Copyright (C) 2013 Samsung Electronics. All rights reserved.
 * Copyright (C) 2013 Seokju Kwon (seokju.kwon@gmail.com)
 * Copyright (C) 2013 Adobe Systems Inc. All rights reserved.
 * Copyright (C) 2013-2015 University of Washington. All rights reserved.
 * Copyright (C) 2014-2015 Saam Barati <saambarati1@gmail.com>
 * Copyright (C) 2014 Antoine Quint
 * Copyright (C) 2015 Tobias Reiss <tobi+webkit@basecode.de>
 * Copyright (C) 2015-2016 Devin Rousso <dcrousso+webkit@gmail.com>. All rights reserved.
 * Copyright (C) 2017 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

var WebInspector={};WebInspector.Platform={name:InspectorFrontendHost.platform(),isNightlyBuild:!1,version:{base:0,release:0,name:""}},function(){var u=/ AppleWebKit\/([^ ]+)/.exec(navigator.userAgent);u&&-1!==u[1].indexOf("+")&&10>document.styleSheets.length&&(WebInspector.Platform.isNightlyBuild=!0);var _=/ Mac OS X (\d+)_(\d+)/.exec(navigator.appVersion);if(_&&"10"===_[1])switch(WebInspector.Platform.version.base=10,WebInspector.Platform.version.release=parseInt(_[2]),_[2]){case"12":WebInspector.Platform.version.name="sierra";break;case"11":WebInspector.Platform.version.name="el-capitan";break;case"10":WebInspector.Platform.version.name="yosemite";break;default:WebInspector.Platform.version.name="unknown-mac";}}();class LinkedList{constructor(){this.head=new LinkedListNode,this.head.next=this.head.prev=this.head,this.length=0}clear(){this.head.next=this.head.prev=this.head,this.length=0}get last(){return this.head.prev}push(u){let _=new LinkedListNode(u),S=this.last,C=this.head;return S.next=_,_.next=C,C.prev=_,_.prev=S,this.length++,_}remove(u){return!!u&&(u.prev.next=u.next,u.next.prev=u.prev,this.length--,!0)}forEach(u){let _=this.head;for(let S=0,C=this.length;S<C;S++){_=_.next;let f=u(_.value,S);if(!1===f)return}}toArray(){let u=this.head,_=this.length,S=Array(_);for(;_--;)u=u.prev,S[_]=u.value;return S}toJSON(){return this.toArray()}}class LinkedListNode{constructor(u){this.value=u,this.prev=null,this.next=null}}class ListMultimap{constructor(){this._insertionOrderedEntries=new LinkedList,this._keyMap=new Map}get size(){return this._insertionOrderedEntries.length}add(u,_){let S=this._keyMap.get(u);S||(S=new Map,this._keyMap.set(u,S));let C=S.get(_);return C||(C=this._insertionOrderedEntries.push([u,_]),S.set(_,C)),this}delete(u,_){let S=this._keyMap.get(u);if(!S)return!1;let C=S.get(_);return!!C&&(S.delete(_),this._insertionOrderedEntries.remove(C),!0)}deleteAll(u){let _=this._keyMap.get(u);if(!_)return!1;let S=this._insertionOrderedEntries,C=!1;return _.forEach(function(f){S.remove(f),C=!0}),this._keyMap.delete(u),C}has(u,_){let S=this._keyMap.get(u);return!!S&&S.has(_)}clear(){this._keyMap=new Map,this._insertionOrderedEntries=new LinkedList}forEach(u){this._insertionOrderedEntries.forEach(u)}toArray(){return this._insertionOrderedEntries.toArray()}toJSON(){return this.toArray()}}WebInspector.Object=class{constructor(){this._listeners=null}static addEventListener(_,S,C){if(C=C||null,!_)return null;if(!S)return null;this._listeners||(this._listeners=new Map);let f=this._listeners.get(_);return f||(f=new ListMultimap,this._listeners.set(_,f)),f.add(C,S),S}static singleFireEventListener(_,S,C){let f=function(){this.removeEventListener(_,f,null),S.apply(C,arguments)}.bind(this);return this.addEventListener(_,f,null),f}static removeEventListener(_,S,C){if(_=_||null,S=S||null,C=C||null,!!this._listeners){if(C&&!_)return void this._listeners.forEach(function(E){let I=E.toArray();for(let R=0,N=I.length,L;R<N;++R)L=I[R][0],L===C&&E.deleteAll(L)});let f=this._listeners.get(_);if(f&&0!==f.size){f.delete(C,S)}}}static awaitEvent(_){let S=new WebInspector.WrappedPromise;return this.singleFireEventListener(_,C=>S.resolve(C)),S.promise}static hasEventListeners(_){if(!this._listeners)return!1;let S=this._listeners.get(_);return S&&0<S.size}static retainedObjectsWithPrototype(_){let S=new Set;return this._listeners&&this._listeners.forEach(function(C){C.forEach(function(T){let E=T[0];E instanceof _&&S.add(E)})}),S}addEventListener(){return WebInspector.Object.addEventListener.apply(this,arguments)}singleFireEventListener(){return WebInspector.Object.singleFireEventListener.apply(this,arguments)}removeEventListener(){return WebInspector.Object.removeEventListener.apply(this,arguments)}awaitEvent(){return WebInspector.Object.awaitEvent.apply(this,arguments)}hasEventListeners(){return WebInspector.Object.hasEventListeners.apply(this,arguments)}retainedObjectsWithPrototype(){return WebInspector.Object.retainedObjectsWithPrototype.apply(this,arguments)}dispatchEventToListeners(_,S){function C(E){if(E&&!f._stoppedPropagation){let I=E._listeners;if(I&&E.hasOwnProperty("_listeners")){let R=I.get(_);if(R){let N=R.toArray();for(let L=0,D=N.length;L<D;++L){let[M,P]=N[L];if(P.call(M,f),f._stoppedPropagation)break}}}}}let f=new WebInspector.Event(this,_,S);C(this),f._stoppedPropagation=!1;for(let T=this.constructor;T&&(C(T),!!T.prototype.__proto__);)T=T.prototype.__proto__.constructor;return f.defaultPrevented}},WebInspector.Event=class{constructor(_,S,C){this.target=_,this.type=S,this.data=C,this.defaultPrevented=!1,this._stoppedPropagation=!1}stopPropagation(){this._stoppedPropagation=!0}preventDefault(){this.defaultPrevented=!0}},WebInspector.notifications=new WebInspector.Object,WebInspector.Notification={GlobalModifierKeysDidChange:"global-modifiers-did-change",PageArchiveStarted:"page-archive-started",PageArchiveEnded:"page-archive-ended",ExtraDomainsActivated:"extra-domains-activated",TabTypesChanged:"tab-types-changed",DebugUIEnabledDidChange:"debug-ui-enabled-did-change",VisibilityStateDidChange:"visibility-state-did-change"},WebInspector.roleSelectorForNode=function(u){var _="",S=u.computedRole();return S&&(_=":role("+S+")"),_},WebInspector.linkifyAccessibilityNodeReference=function(u){if(!u)return null;var _=WebInspector.linkifyNodeReference(u),S=_.title,C=S.indexOf(".");-1<C&&(S=S.substring(0,C));var f=WebInspector.roleSelectorForNode(u);return _.textContent=S+f,_.title+=f,_},WebInspector.linkifyNodeReference=function(u,_={}){let S=u.displayName;isNaN(_.maxLength)||(S=S.truncate(_.maxLength));let C=document.createElement("span");return C.append(S),WebInspector.linkifyNodeReferenceElement(u,C,Object.shallowMerge(_,{displayName:S}))},WebInspector.linkifyNodeReferenceElement=function(u,_,S={}){_.setAttribute("role","link"),_.title=S.displayName||u.displayName;let C=u.nodeType();return(C!==Node.DOCUMENT_NODE||u.parentNode)&&C!==Node.TEXT_NODE&&_.classList.add("node-link"),_.addEventListener("click",WebInspector.domTreeManager.inspectElement.bind(WebInspector.domTreeManager,u.id)),_.addEventListener("mouseover",WebInspector.domTreeManager.highlightDOMNode.bind(WebInspector.domTreeManager,u.id,"all")),_.addEventListener("mouseout",WebInspector.domTreeManager.hideDOMNodeHighlight.bind(WebInspector.domTreeManager)),_.addEventListener("contextmenu",f=>{let T=WebInspector.ContextMenu.createFromEvent(f);WebInspector.appendContextMenuItemsForDOMNode(T,u,S)}),_};function createSVGElement(u){return document.createElementNS("http://www.w3.org/2000/svg",u)}WebInspector.cssPath=function(u){if(u.nodeType()!==Node.ELEMENT_NODE)return"";let _="";u.isPseudoElement()&&(_="::"+u.pseudoType(),u=u.parentNode);let S=[];for(;u;){let C=WebInspector.cssPathComponent(u);if(!C)break;if(S.push(C),C.done)break;u=u.parentNode}return S.reverse(),S.map(C=>C.value).join(" > ")+_},WebInspector.cssPathComponent=function(u){function _(D){let M=D.getAttribute("class");return M?M.trim().split(/\s+/):[]}if(u.nodeType()!==Node.ELEMENT_NODE)return null;let S=u.nodeNameInCorrectCase(),C=u.nodeName().toLowerCase();if("body"===C||"head"===C||"html"===C)return{value:S,done:!0};let f=u.getAttribute("id");if(f)return{value:u.escapedIdSelector,done:!0};if(!u.parentNode||u.parentNode.nodeType()===Node.DOCUMENT_NODE)return{value:S,done:!0};let T=-1,E=!0,I=new Set(_(u)),R=u.parentNode.children,N=0;for(let D of R)if(D.nodeType()===Node.ELEMENT_NODE){if(N++,D===u){T=N;continue}if(D.nodeNameInCorrectCase()===S&&(E=!1),I.size){let O=_(D);for(let F of O)I.delete(F)}}let L=S;return"input"===C&&u.getAttribute("type")&&!I.size&&(L+=`[type="${u.getAttribute("type")}"]`),E||(I.size?L+=u.escapedClassSelector:L+=`:nth-child(${T})`),{value:L,done:!1}},WebInspector.xpath=function(u){if(u.nodeType()===Node.DOCUMENT_NODE)return"/";let _=[];for(;u;){let C=WebInspector.xpathComponent(u);if(!C)break;if(_.push(C),C.done)break;u=u.parentNode}_.reverse();let S=_.length&&_[0].done?"":"/";return S+_.map(C=>C.value).join("/")},WebInspector.xpathComponent=function(u){let _=WebInspector.xpathIndex(u);if(-1===_)return null;let S;switch(u.nodeType()){case Node.DOCUMENT_NODE:return{value:"",done:!0};case Node.ELEMENT_NODE:var C=u.getAttribute("id");if(C)return{value:`//*[@id="${C}"]`,done:!0};S=u.localName();break;case Node.ATTRIBUTE_NODE:S=`@${u.nodeName()}`;break;case Node.TEXT_NODE:case Node.CDATA_SECTION_NODE:S="text()";break;case Node.COMMENT_NODE:S="comment()";break;case Node.PROCESSING_INSTRUCTION_NODE:S="processing-instruction()";break;default:S="";}return 0<_&&(S+=`[${_}]`),{value:S,done:!1}},WebInspector.xpathIndex=function(u){function _(E,I){if(E===I)return!0;let R=E.nodeType(),N=I.nodeType();return R===Node.ELEMENT_NODE&&N===Node.ELEMENT_NODE?E.localName()===I.localName():R===Node.CDATA_SECTION_NODE?R===Node.TEXT_NODE:N===Node.CDATA_SECTION_NODE?N===Node.TEXT_NODE:R===N}if(!u.parentNode)return 0;let S=u.parentNode.children;if(1>=S.length)return 0;let C=!0,f=-1,T=1;for(let E of S)if(_(u,E)){if(u===E){if(f=T,!C)return f;}else if(C=!1,-1!=f)return f;T++}return C?0:f},WebInspector.EventListener=class{constructor(_,S){this._thisObject=_,this._emitter=null,this._callback=null,this._fireOnce=S}connect(_,S,C,f){var T=_&&(_ instanceof WebInspector.Object||_ instanceof Node||"function"==typeof _.addEventListener);if(T&&S&&C){if(this._emitter=_,this._type=S,this._usesCapture=!!f,_ instanceof Node&&(C=C.bind(this._thisObject)),this._fireOnce){var E=this;this._callback=function(){E.disconnect(),C.apply(this,arguments)}}else this._callback=C;this._emitter instanceof Node?this._emitter.addEventListener(this._type,this._callback,this._usesCapture):this._emitter.addEventListener(this._type,this._callback,this._thisObject)}}disconnect(){this._emitter&&this._callback&&(this._emitter instanceof Node?this._emitter.removeEventListener(this._type,this._callback,this._usesCapture):this._emitter.removeEventListener(this._type,this._callback,this._thisObject),this._fireOnce&&delete this._thisObject,delete this._emitter,delete this._type,delete this._callback)}},WebInspector.EventListenerSet=class{constructor(_,S){this.name=S,this._defaultThisObject=_,this._listeners=[],this._installed=!1}register(_,S,C,f,T){var E=_&&(_ instanceof WebInspector.Object||_ instanceof Node||"function"==typeof _.addEventListener);E&&S&&C&&this._listeners.push({listener:new WebInspector.EventListener(f||this._defaultThisObject),emitter:_,type:S,callback:C,usesCapture:T})}unregister(){this._installed&&this.uninstall(),this._listeners=[]}install(){if(!this._installed){this._installed=!0;for(var _ of this._listeners)_.listener.connect(_.emitter,_.type,_.callback,_.usesCapture)}}uninstall(_){if(this._installed){this._installed=!1;for(var S of this._listeners)S.listener.disconnect();_&&(this._listeners=[])}}};function useSVGSymbol(u,_,S){const C="http://www.w3.org/2000/svg";let T=document.createElementNS(C,"svg");T.style.width="100%",T.style.height="100%",u.includes("#")||(u+="#root");let E=document.createElementNS(C,"use");E.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",u),T.appendChild(E);let I=document.createElement("div");return I.appendChild(T),_&&(I.className=_),S&&(I.title=S),I}(function(){if(!WebInspector.dontLocalizeUserInterface){let u=InspectorFrontendHost.localizedStringsURL();u&&document.write("<script src=\""+u+"\"></script>")}})(),WebInspector.unlocalizedString=function(u){return u},WebInspector.UIString=function(u){return WebInspector.dontLocalizeUserInterface?u:window.localizedStrings&&u in window.localizedStrings?window.localizedStrings[u]:(window.localizedStrings||console.error(`Attempted to load localized string "${u}" before localizedStrings was initialized.`),this._missingLocalizedStrings||(this._missingLocalizedStrings={}),u in this._missingLocalizedStrings||(console.error("Localized string \""+u+"\" was not found."),this._missingLocalizedStrings[u]=!0),"LOCALIZED STRING NOT FOUND")},WebInspector.fileExtensionForURL=function(u){var _=parseURL(u).lastPathComponent;if(!_)return"";var S=_.indexOf(".");return-1===S?"":_.substr(S+1)},WebInspector.mimeTypeForFileExtension=function(u){return{html:"text/html",xhtml:"application/xhtml+xml",xml:"text/xml",js:"text/javascript",json:"application/json",clj:"text/x-clojure",coffee:"text/x-coffeescript",ls:"text/x-livescript",ts:"text/typescript",css:"text/css",less:"text/x-less",sass:"text/x-sass",scss:"text/x-scss",bmp:"image/bmp",gif:"image/gif",jpeg:"image/jpeg",jpg:"image/jpeg",pdf:"application/pdf",png:"image/png",tif:"image/tiff",tiff:"image/tiff",svg:"image/svg+xml",txt:"text/plain",xsl:"text/xsl"}[u]||null},WebInspector.fileExtensionForMIMEType=function(u){let S={"text/html":"html","application/xhtml+xml":"xhtml","text/xml":"xml","text/javascript":"js","application/json":"json","text/x-clojure":"clj","text/x-coffeescript":"coffee","text/x-livescript":"ls","text/typescript":"ts","text/css":"css","text/x-less":"less","text/x-sass":"sass","text/x-scss":"scss","image/bmp":"bmp","image/gif":"gif","image/jpeg":"jpg","application/pdf":"pdf","image/png":"png","image/tiff":"tiff","image/svg+xml":"svg","text/plain":"txt","text/xsl":"xsl"}[u];return S?`.${S}`:null},WebInspector.rangeForNextCSSNameOrValue=function(u,_=0){let S=0,C=0,f=u.indexOf(":");_<f?(S=0,C=f):(S=f+1,C=u.length);let T=u.substring(S,C);return S+=T.match(/^\s*/)[0].length,C-=T.match(/[\s\;]*$/)[0].length,{from:S,to:C}};function removeURLFragment(u){var _=u.indexOf("#");return 0<=_?u.substring(0,_):u}function relativePath(u,_){for(var S=u.split("/"),C=_.replace(/\/$/,"").split("/"),f=[],T=1;T<S.length&&T<C.length&&!(S[T]!==C[T]);++T);for(var E=T;E<C.length;++E)f.push("..");for(var E=T;E<S.length;++E)f.push(S[E]);return f.join("/")}function parseSecurityOrigin(u){u=u?u.trim():"";var _=u.match(/^([^:]+):\/\/([^\/:]*)(?::([\d]+))?$/i);if(!_)return{scheme:null,host:null,port:null};var S=_[1].toLowerCase(),C=_[2].toLowerCase(),f=+_[3]||null;return{scheme:S,host:C,port:f}}function parseDataURL(u){if(!u.startsWith("data:"))return null;let _=u.match(/^data:([^;,]*)?(?:;charset=([^;,]*?))?(;base64)?,(.*)$/);if(!_)return null;let C=_[1]||"text/plain",f=_[2]||"US-ASCII",T=!!_[3],E=decodeURIComponent(_[4]);return{scheme:"data",mimeType:C,charset:f,base64:T,data:E}}function parseURL(u){if(u=u?u.trim():"",u.startsWith("data:"))return{scheme:"data",host:null,port:null,path:null,queryString:null,fragment:null,lastPathComponent:null};var _=u.match(/^([^\/:]+):\/\/([^\/#:]*)(?::([\d]+))?(?:(\/[^#]*)?(?:#(.*))?)?$/i);if(!_)return{scheme:null,host:null,port:null,path:null,queryString:null,fragment:null,lastPathComponent:null};var S=_[1].toLowerCase(),C=_[2].toLowerCase(),f=+_[3]||null,T=_[4]||null,E=_[5]||null,I=T,R=null;if(T){var N=T.indexOf("?");-1!==N&&(I=T.substring(0,N),R=T.substring(N+1)),I=resolveDotsInPath(I)}var L=null;if(I&&"/"!==I){var D="/"===I[I.length-1]?1:0,M=I.lastIndexOf("/",I.length-1-D);-1!==M&&(L=I.substring(M+1,I.length-D))}return{scheme:S,host:C,port:f,path:I,queryString:R,fragment:E,lastPathComponent:L}}function absoluteURL(u,_){if(u=u?u.trim():"",u.startsWith("data:")||u.startsWith("javascript:")||u.startsWith("mailto:"))return u;if(parseURL(u).scheme)return u;if(!u)return _||null;var S=parseURL(_);if(!S.scheme)return null;if("/"===u[0]&&"/"===u[1])return S.scheme+":"+u;S.path||(S.path="/");var C=S.scheme+"://"+S.host+(S.port?":"+S.port:"");if("?"===u[0])return C+S.path+u;if("/"===u[0])return C+resolveDotsInPath(u);if("#"===u[0]){let T=S.queryString?"?"+S.queryString:"";return C+S.path+T+u}var f=S.path.substring(0,S.path.lastIndexOf("/"))+"/";return C+resolveDotsInPath(f+u)}function parseLocationQueryParameters(u){return parseQueryString(window.location.search.substring(1),u)}function parseQueryString(u,_){function S(I){try{return decodeURIComponent(I.replace(/\+/g," "))}catch(R){return I}}if(!u)return _?[]:{};for(var C=_?[]:{},f=u.split("&"),T=0,E;T<f.length;++T)E=f[T].split("=").map(S),_?C.push({name:E[0],value:E[1]}):C[E[0]]=E[1];return C}WebInspector.displayNameForURL=function(u,_){if(u.startsWith("data:"))return WebInspector.truncateURL(u);_||(_=parseURL(u));var S;try{S=decodeURIComponent(_.lastPathComponent||"")}catch(C){S=_.lastPathComponent}return S||WebInspector.displayNameForHost(_.host)||u},WebInspector.truncateURL=function(u,_=!1,S=6){if(!u.startsWith("data:"))return u;const C=u.indexOf(",")+1;let f=u.slice(0,C);_&&(f+="\n");const T=u.slice(C);if(T.length<S)return f+T;const E=T.slice(0,Math.ceil(S/2)),I="\u2026",R=_?`\n${I}\n`:I,N=T.slice(-Math.floor(S/2));return f+E+R+N},WebInspector.displayNameForHost=function(u){return u};var emDash="\u2014",enDash="\u2013",figureDash="\u2012",ellipsis="\u2026",zeroWidthSpace="\u200B";Object.defineProperty(Object,"shallowCopy",{value:function(u){for(var _={},S=Object.keys(u),C=0;C<S.length;++C)_[S[C]]=u[S[C]];return _}}),Object.defineProperty(Object,"shallowEqual",{value:function(u,_){if(!(u instanceof Object)||!(_ instanceof Object))return!1;if(u===_)return!0;if(Array.isArray(u)&&Array.isArray(_))return Array.shallowEqual(u,_);if(u.constructor!==_.constructor)return!1;var S=Object.keys(u),C=Object.keys(_);if(S.length!==C.length)return!1;for(var f=0;f<S.length;++f){if(!(S[f]in _))return!1;if(u[S[f]]!==_[S[f]])return!1}return!0}}),Object.defineProperty(Object,"shallowMerge",{value(u,_){let S=Object.shallowCopy(u),C=Object.keys(_);for(let f=0;f<C.length;++f)S[C[f]]=_[C[f]];return S}}),Object.defineProperty(Object.prototype,"valueForCaseInsensitiveKey",{value:function(u){if(this.hasOwnProperty(u))return this[u];var _=u.toLowerCase();for(var S in this)if(S.toLowerCase()===_)return this[S]}}),Object.defineProperty(Map,"fromObject",{value:function(u){let _=new Map;for(let S in u)_.set(S,u[S]);return _}}),Object.defineProperty(Map.prototype,"take",{value:function(u){var _=this.get(u);return this.delete(u),_}}),Object.defineProperty(Node.prototype,"enclosingNodeOrSelfWithClass",{value:function(u){for(var _=this;_&&_!==this.ownerDocument;_=_.parentNode)if(_.nodeType===Node.ELEMENT_NODE&&_.classList.contains(u))return _;return null}}),Object.defineProperty(Node.prototype,"enclosingNodeOrSelfWithNodeNameInArray",{value:function(u){for(var _=u.map(function(f){return f.toLowerCase()}),S=this;S&&S!==this.ownerDocument;S=S.parentNode)for(var C=0;C<u.length;++C)if(S.nodeName.toLowerCase()===_[C])return S;return null}}),Object.defineProperty(Node.prototype,"enclosingNodeOrSelfWithNodeName",{value:function(u){return this.enclosingNodeOrSelfWithNodeNameInArray([u])}}),Object.defineProperty(Node.prototype,"isAncestor",{value:function(u){if(!u)return!1;for(var _=u.parentNode;_;){if(this===_)return!0;_=_.parentNode}return!1}}),Object.defineProperty(Node.prototype,"isDescendant",{value:function(u){return!!u&&u.isAncestor(this)}}),Object.defineProperty(Node.prototype,"isSelfOrAncestor",{value:function(u){return!!u&&(u===this||this.isAncestor(u))}}),Object.defineProperty(Node.prototype,"isSelfOrDescendant",{value:function(u){return!!u&&(u===this||this.isDescendant(u))}}),Object.defineProperty(Node.prototype,"traverseNextNode",{value:function(u){var _=this.firstChild;if(_)return _;if(u&&this===u)return null;if(_=this.nextSibling,_)return _;for(_=this;_&&!_.nextSibling&&(!u||!_.parentNode||_.parentNode!==u);)_=_.parentNode;return _?_.nextSibling:null}}),Object.defineProperty(Node.prototype,"traversePreviousNode",{value:function(u){if(u&&this===u)return null;for(var _=this.previousSibling;_&&_.lastChild;)_=_.lastChild;return _?_:this.parentNode}}),Object.defineProperty(Node.prototype,"rangeOfWord",{value:function(u,_,S,C){var T=0,I=0,f,E;if(S||(S=this),!C||"backward"===C||"both"===C){for(var R=this;R;){if(R===S){f||(f=S);break}if(R.nodeType===Node.TEXT_NODE)for(var N=R===this?u-1:R.nodeValue.length-1,L=N;0<=L;--L)if(-1!==_.indexOf(R.nodeValue[L])){f=R,T=L+1;break}if(f)break;R=R.traversePreviousNode(S)}f||(f=S,T=0)}else f=this,T=u;if(!C||"forward"===C||"both"===C){for(R=this;R;){if(R===S){E||(E=S);break}if(R.nodeType===Node.TEXT_NODE)for(var N=R===this?u:0,L=N;L<R.nodeValue.length;++L)if(-1!==_.indexOf(R.nodeValue[L])){E=R,I=L;break}if(E)break;R=R.traverseNextNode(S)}E||(E=S,I=S.nodeType===Node.TEXT_NODE?S.nodeValue.length:S.childNodes.length)}else E=this,I=u;var D=this.ownerDocument.createRange();return D.setStart(f,T),D.setEnd(E,I),D}}),Object.defineProperty(Element.prototype,"realOffsetWidth",{get:function(){return this.getBoundingClientRect().width}}),Object.defineProperty(Element.prototype,"realOffsetHeight",{get:function(){return this.getBoundingClientRect().height}}),Object.defineProperty(Element.prototype,"totalOffsetLeft",{get:function(){return this.getBoundingClientRect().left}}),Object.defineProperty(Element.prototype,"totalOffsetRight",{get:function(){return this.getBoundingClientRect().right}}),Object.defineProperty(Element.prototype,"totalOffsetTop",{get:function(){return this.getBoundingClientRect().top}}),Object.defineProperty(Element.prototype,"removeChildren",{value:function(){this.firstChild&&(this.textContent="")}}),Object.defineProperty(Element.prototype,"isInsertionCaretInside",{value:function(){var u=window.getSelection();if(!u.rangeCount||!u.isCollapsed)return!1;var _=u.getRangeAt(0);return _.startContainer===this||_.startContainer.isDescendant(this)}}),Object.defineProperty(Element.prototype,"removeMatchingStyleClasses",{value:function(u){var _=new RegExp("(^|\\s+)"+u+"($|\\s+)");_.test(this.className)&&(this.className=this.className.replace(_," "))}}),Object.defineProperty(Element.prototype,"createChild",{value:function(u,_){var S=this.ownerDocument.createElement(u);return _&&(S.className=_),this.appendChild(S),S}}),Object.defineProperty(Element.prototype,"isScrolledToBottom",{value:function(){return this.scrollTop+this.clientHeight===this.scrollHeight}}),Object.defineProperty(Element.prototype,"recalculateStyles",{value:function(){this.ownerDocument.defaultView.getComputedStyle(this)}}),Object.defineProperty(DocumentFragment.prototype,"createChild",{value:Element.prototype.createChild}),Object.defineProperty(Array,"shallowEqual",{value:function(u,_){if(!Array.isArray(u)||!Array.isArray(_))return!1;if(u===_)return!0;let S=u.length;if(S!==_.length)return!1;for(let C=0;C<S;++C)if(u[C]!==_[C]&&!Object.shallowEqual(u[C],_[C]))return!1;return!0}}),Object.defineProperty(Array.prototype,"lastValue",{get:function(){return this.length?this[this.length-1]:void 0}}),Object.defineProperty(Array.prototype,"remove",{value:function(u,_){for(var S=this.length-1;0<=S;--S)if(this[S]===u&&(this.splice(S,1),_))return}}),Object.defineProperty(Array.prototype,"toggleIncludes",{value:function(u,_){let S=this.includes(u);S===!!_||(S?this.remove(u):this.push(u))}}),Object.defineProperty(Array.prototype,"insertAtIndex",{value:function(u,_){this.splice(_,0,u)}}),Object.defineProperty(Array.prototype,"keySet",{value:function(){let u=Object.create(null);for(var _=0;_<this.length;++_)u[this[_]]=!0;return u}}),Object.defineProperty(Array.prototype,"partition",{value:function(u){let _=[],S=[];for(let C=0,f;C<this.length;++C)f=this[C],u(f)?_.push(f):S.push(f);return[_,S]}}),Object.defineProperty(String.prototype,"isLowerCase",{value:function(){return this+""===this.toLowerCase()}}),Object.defineProperty(String.prototype,"isUpperCase",{value:function(){return this+""===this.toUpperCase()}}),Object.defineProperty(String.prototype,"trimMiddle",{value:function(u){if(this.length<=u)return this;var _=u>>1,S=u-_-1;return this.substr(0,_)+ellipsis+this.substr(this.length-S,S)}}),Object.defineProperty(String.prototype,"trimEnd",{value:function(u){return this.length<=u?this:this.substr(0,u-1)+ellipsis}}),Object.defineProperty(String.prototype,"truncate",{value:function(u){"use strict";if(this.length<=u)return this;let _=this.slice(0,u),S=_.search(/\s\S*$/);return S>Math.floor(u/2)&&(_=_.slice(0,S-1)),_+ellipsis}}),Object.defineProperty(String.prototype,"collapseWhitespace",{value:function(){return this.replace(/[\s\xA0]+/g," ")}}),Object.defineProperty(String.prototype,"removeWhitespace",{value:function(){return this.replace(/[\s\xA0]+/g,"")}}),Object.defineProperty(String.prototype,"escapeCharacters",{value:function(u){for(var _=!1,S=0;S<u.length;++S)if(-1!==this.indexOf(u.charAt(S))){_=!0;break}if(!_)return this;for(var C="",S=0;S<this.length;++S)-1!==u.indexOf(this.charAt(S))&&(C+="\\"),C+=this.charAt(S);return C}}),Object.defineProperty(String.prototype,"escapeForRegExp",{value:function(){return this.escapeCharacters("^[]{}()\\.$*+?|")}}),Object.defineProperty(String.prototype,"capitalize",{value:function(){return this.charAt(0).toUpperCase()+this.slice(1)}}),Object.defineProperty(String.prototype,"extendedLocaleCompare",{value(u){return this.localeCompare(u,void 0,{numeric:!0})}}),Object.defineProperty(String,"tokenizeFormatString",{value:function(u){function _(R){C.push({type:"string",value:R})}function S(R,N,L){C.push({type:"specifier",specifier:R,precision:N,substitutionIndex:L})}for(var C=[],f=0,T=0,E=u.indexOf("%",T);-1!==E;E=u.indexOf("%",T)){if(_(u.substring(T,E)),T=E+1,"%"===u[T]){_("%"),++T;continue}if(!isNaN(u[T])){for(var I=parseInt(u.substring(T),10);!isNaN(u[T]);)++T;0<I&&"$"===u[T]&&(f=I-1,++T)}const R=6;let N=R;if("."===u[T])for(++T,N=parseInt(u.substring(T),10),isNaN(N)&&(N=R);!isNaN(u[T]);)++T;S(u[T],N,f),++f,++T}return _(u.substring(T)),C}}),Object.defineProperty(String.prototype,"hash",{get:function(){for(var _=2654435769,S=null,C=0,f;C<this.length;++C){if(f=this[C].charCodeAt(0),null==S){S=f;continue}_+=S,_=_<<16^(f<<11^_),_+=_>>11,S=null}return null!==S&&(_+=S,_^=_<<11,_+=_>>17),_^=_<<3,_+=_>>5,_^=_<<2,_+=_>>15,_^=_<<10,(4294967295+_+1).toString(36)}}),Object.defineProperty(String,"standardFormatters",{value:{d:function(u){return parseInt(u).toLocaleString()},f:function(u,_){let S=parseFloat(u);if(isNaN(S))return NaN;let C={minimumFractionDigits:_.precision,maximumFractionDigits:_.precision,useGrouping:!1};return S.toLocaleString(void 0,C)},s:function(u){return u}}}),Object.defineProperty(String,"format",{value:function(u,_,S,C,f){function T(){return"String.format(\""+u+"\", \""+Array.from(_).join("\", \"")+"\")"}function E(O){console.warn(T()+": "+O)}function I(O){console.error(T()+": "+O)}if(!u||!_||!_.length)return{formattedResult:f(C,u),unusedSubstitutions:_};for(var R=C,N=String.tokenizeFormatString(u),L={},D=0,M;D<N.length;++D){if(M=N[D],"string"===M.type){R=f(R,M.value);continue}if("specifier"!==M.type){I("Unknown token type \""+M.type+"\" found.");continue}if(M.substitutionIndex>=_.length){I("not enough substitution arguments. Had "+_.length+" but needed "+(M.substitutionIndex+1)+", so substitution was skipped."),R=f(R,"%"+(-1<M.precision?M.precision:"")+M.specifier);continue}if(L[M.substitutionIndex]=!0,!(M.specifier in S)){E("unsupported format character \u201C"+M.specifier+"\u201D. Treating as a string."),R=f(R,_[M.substitutionIndex]);continue}R=f(R,S[M.specifier](_[M.substitutionIndex],M))}for(var P=[],D=0;D<_.length;++D)D in L||P.push(_[D]);return{formattedResult:R,unusedSubstitutions:P}}}),Object.defineProperty(String.prototype,"format",{value:function(){return String.format(this,arguments,String.standardFormatters,"",function(u,_){return u+_}).formattedResult}}),Object.defineProperty(String.prototype,"insertWordBreakCharacters",{value:function(){return this.replace(/([\/;:\)\]\}&?])/g,"$1\u200B")}}),Object.defineProperty(String.prototype,"removeWordBreakCharacters",{value:function(){return this.replace(/\u200b/g,"")}}),Object.defineProperty(String.prototype,"getMatchingIndexes",{value:function(u){for(var _=[],S=this.indexOf(u);0<=S;)_.push(S),S=this.indexOf(u,S+1);return _}}),Object.defineProperty(String.prototype,"levenshteinDistance",{value:function(u){for(var _=this.length,S=u.length,C=Array(_+1),f=0;f<=_;++f)C[f]=Array(S+1),C[f][0]=f;for(var T=0;T<=S;++T)C[0][T]=T;for(var T=1;T<=S;++T)for(var f=1;f<=_;++f)if(this[f-1]===u[T-1])C[f][T]=C[f-1][T-1];else{var E=C[f-1][T]+1,I=C[f][T-1]+1,R=C[f-1][T-1]+1;C[f][T]=Math.min(E,I,R)}return C[_][S]}}),Object.defineProperty(String.prototype,"toCamelCase",{value:function(){return this.toLowerCase().replace(/[^\w]+(\w)/g,(u,_)=>_.toUpperCase())}}),Object.defineProperty(String.prototype,"hasMatchingEscapedQuotes",{value:function(){return /^\"(?:[^\"\\]|\\.)*\"$/.test(this)||/^\'(?:[^\'\\]|\\.)*\'$/.test(this)}}),Object.defineProperty(Math,"roundTo",{value:function(u,_){return Math.round(u/_)*_}}),Object.defineProperty(Number,"constrain",{value:function(u,_,S){return S<_?_:(u<_?u=_:u>S&&(u=S),u)}}),Object.defineProperty(Number,"percentageString",{value:function(u,_=1){return u.toLocaleString(void 0,{minimumFractionDigits:_,style:"percent"})}}),Object.defineProperty(Number,"secondsToMillisecondsString",{value:function(u,_){let S=1e3*u;return _?WebInspector.UIString("%.2fms").format(S):WebInspector.UIString("%.1fms").format(S)}}),Object.defineProperty(Number,"secondsToString",{value:function(u,_){let S=1e3*u;if(!S)return WebInspector.UIString("%.0fms").format(0);if(10>Math.abs(S))return _?WebInspector.UIString("%.3fms").format(S):WebInspector.UIString("%.2fms").format(S);if(100>Math.abs(S))return _?WebInspector.UIString("%.2fms").format(S):WebInspector.UIString("%.1fms").format(S);if(1e3>Math.abs(S))return _?WebInspector.UIString("%.1fms").format(S):WebInspector.UIString("%.0fms").format(S);if(_||60>Math.abs(u))return WebInspector.UIString("%.2fs").format(u);let C=u/60;if(60>Math.abs(C))return WebInspector.UIString("%.1fmin").format(C);let f=C/60;if(24>Math.abs(f))return WebInspector.UIString("%.1fhrs").format(f);return WebInspector.UIString("%.1f days").format(f/24)}}),Object.defineProperty(Number,"bytesToString",{value:function(u,_){if(void 0===_&&(_=!0),1024>Math.abs(u))return WebInspector.UIString("%.0f B").format(u);let S=u/1024;if(1024>Math.abs(S))return _||10>Math.abs(S)?WebInspector.UIString("%.2f KB").format(S):WebInspector.UIString("%.1f KB").format(S);let C=S/1024;if(1024>Math.abs(C))return _||10>Math.abs(C)?WebInspector.UIString("%.2f MB").format(C):WebInspector.UIString("%.1f MB").format(C);let f=C/1024;return _||10>Math.abs(f)?WebInspector.UIString("%.2f GB").format(f):WebInspector.UIString("%.1f GB").format(f)}}),Object.defineProperty(Number,"abbreviate",{value:function(u){return 1e3>u?u.toLocaleString():1e6>u?WebInspector.UIString("%.1fK").format(Math.round(u/100)/10):1e9>u?WebInspector.UIString("%.1fM").format(Math.round(u/1e5)/10):WebInspector.UIString("%.1fB").format(Math.round(u/1e8)/10)}}),Object.defineProperty(Number.prototype,"maxDecimals",{value(u){let _=10**u;return Math.round(this*_)/_}}),Object.defineProperty(Uint32Array,"isLittleEndian",{value:function(){if("_isLittleEndian"in this)return this._isLittleEndian;var u=new ArrayBuffer(4),_=new Uint32Array(u),S=new Uint8Array(u);return _[0]=168496141,this._isLittleEndian=13===S[0]&&12===S[1]&&11===S[2]&&10===S[3],this._isLittleEndian}});function isEmptyObject(u){for(var _ in u)return!1;return!0}function isEnterKey(u){return 229!==u.keyCode&&"Enter"===u.keyIdentifier}function resolveDotsInPath(u){if(!u)return u;if(-1===u.indexOf("./"))return u;for(var _=[],S=u.split("/"),C=0,f;C<S.length;++C)if(f=S[C],"."!==f){if(".."===f){if(1===_.length)continue;_.pop();continue}_.push(f)}return _.join("/")}function parseMIMEType(u){if(!u)return{type:u,boundary:null,encoding:null};for(var _=u.split(/\s*;\s*/),S=_[0],C=null,f=null,T=1,E;T<_.length;++T)E=_[T].split(/\s*=\s*/),2===E.length&&("boundary"===E[0].toLowerCase()?C=E[1]:"charset"===E[0].toLowerCase()&&(f=E[1].replace("^\"|\"$","")));return{type:S,boundary:C||null,encoding:f||null}}function simpleGlobStringToRegExp(u,_){if(!u)return null;var S=u.escapeCharacters("^[]{}()\\.$+?|");S=S.replace(/\\\\\*/g,"\\*");var C=/(^|[^\\])\*+/g;return C.test(u)&&(S=S.replace(C,"$1.*"),S="\\b"+S+"\\b"),new RegExp(S,_)}Object.defineProperty(Array.prototype,"lowerBound",{value:function(u,_){_=_||function(E,I){return E-I};for(var C=0,f=this.length,T;C<f;)T=C+f>>1,0<_(u,this[T])?C=T+1:f=T;return f}}),Object.defineProperty(Array.prototype,"upperBound",{value:function(u,_){_=_||function(E,I){return E-I};for(var C=0,f=this.length,T;C<f;)T=C+f>>1,0<=_(u,this[T])?C=T+1:f=T;return f}}),Object.defineProperty(Array.prototype,"binaryIndexOf",{value:function(u,_){var S=this.lowerBound(u,_);return S<this.length&&0===_(u,this[S])?S:-1}}),function(){const u=Symbol("debounce-timeout"),_=Symbol("debounce-soon-proxy");Object.defineProperty(Object.prototype,"soon",{get:function(){return this[_]||(this[_]=this.debounce(0)),this[_]}}),Object.defineProperty(Object.prototype,"debounce",{value:function(f){return new Proxy(this,{get(T,E){return(...R)=>{let N=T[E];N[u]&&clearTimeout(N[u]);N[u]=setTimeout(()=>{N[u]=void 0,N.apply(T,R)},f)}}})}}),Object.defineProperty(Function.prototype,"cancelDebounce",{value:function(){this[u]&&(clearTimeout(this[u]),this[u]=void 0)}});const S=Symbol("peform-on-animation-frame"),C=Symbol("perform-on-animation-frame-proxy");Object.defineProperty(Object.prototype,"onNextFrame",{get:function(){return this[C]||(this[C]=new Proxy(this,{get(f,T){return(...I)=>{let R=f[T];if(!R[S]){R[S]=requestAnimationFrame(()=>{R[S]=void 0,R.apply(f,I)})}}}})),this[C]}})}();function appendWebInspectorSourceURL(u){return u.includes("//# sourceURL")?u:"\n//# sourceURL=__WebInspectorInternal__\n"+u}function appendWebInspectorConsoleEvaluationSourceURL(u){return u.includes("//# sourceURL")?u:"\n//# sourceURL=__WebInspectorConsoleEvaluation__\n"+u}function isWebInspectorInternalScript(u){return"__WebInspectorInternal__"===u}function isWebInspectorConsoleEvaluationScript(u){return"__WebInspectorConsoleEvaluation__"===u}function isWebKitInjectedScript(u){return u&&u.startsWith("__InjectedScript_")&&u.endsWith(".js")}function isWebKitInternalScript(u){return!isWebInspectorConsoleEvaluationScript(u)&&(!!isWebKitInjectedScript(u)||u&&u.startsWith("__Web")&&u.endsWith("__"))}function isFunctionStringNativeCode(u){return u.endsWith("{\n    [native code]\n}")}function isTextLikelyMinified(u){let C=0,f=Math.min(5e3,u.length);for(let E=0,I;E<f;E++)I=u[E]," "===I?C++:"\t"===I?C+=4:"\n"===I&&(C+=8);let T=C/f;return T<0.2}function doubleQuotedString(u){return"\""+u.replace(/\\/g,"\\\\").replace(/"/g,"\\\"")+"\""}function insertionIndexForObjectInListSortedByFunction(u,_,S,C){return C?_.upperBound(u,S):_.lowerBound(u,S)}function insertObjectIntoSortedArray(u,_,S){_.splice(insertionIndexForObjectInListSortedByFunction(u,_,S),0,u)}function decodeBase64ToBlob(u,_){_=_||"";const S=1024;for(var C=atob(u),f=C.length,T=Math.ceil(f/S),E=Array(T),I=0;I<T;++I){for(var R=I*S,N=Math.min(R+S,f),L=Array(N-R),D=R,M=0;D<N;++M,++D)L[M]=C[D].charCodeAt(0);E[I]=new Uint8Array(L)}return new Blob(E,{type:_})}function timestamp(){return window.performance?performance.now():Date.now()}window.handlePromiseException||(window.handlePromiseException=function(_){console.error("Uncaught exception in Promise",_)}),WebInspector.Setting=class extends WebInspector.Object{constructor(_,S){super(),this._name=_;let C=InspectorFrontendHost?InspectorFrontendHost.inspectionLevel():1,f=1<C?"-"+C:"";this._localStorageKey=`com.apple.WebInspector${f}.${_}`,this._defaultValue=S}get name(){return this._name}get value(){if("_value"in this)return this._value;if(this._value=JSON.parse(JSON.stringify(this._defaultValue)),!window.InspectorTest&&window.localStorage&&this._localStorageKey in window.localStorage)try{this._value=JSON.parse(window.localStorage[this._localStorageKey])}catch(_){delete window.localStorage[this._localStorageKey]}return this._value}set value(_){if(this._value!==_){if(this._value=_,!window.InspectorTest&&window.localStorage)try{Object.shallowEqual(this._value,this._defaultValue)?delete window.localStorage[this._localStorageKey]:window.localStorage[this._localStorageKey]=JSON.stringify(this._value)}catch(S){console.error("Error saving setting with name: "+this._name)}this.dispatchEventToListeners(WebInspector.Setting.Event.Changed,this._value,{name:this._name})}}reset(){this.value=JSON.parse(JSON.stringify(this._defaultValue))}},WebInspector.Setting.Event={Changed:"setting-changed"},WebInspector.settings={autoLogProtocolMessages:new WebInspector.Setting("auto-collect-protocol-messages",!1),autoLogTimeStats:new WebInspector.Setting("auto-collect-time-stats",!1),enableUncaughtExceptionReporter:new WebInspector.Setting("enable-uncaught-exception-reporter",!0),enableLineWrapping:new WebInspector.Setting("enable-line-wrapping",!1),indentUnit:new WebInspector.Setting("indent-unit",4),tabSize:new WebInspector.Setting("tab-size",4),indentWithTabs:new WebInspector.Setting("indent-with-tabs",!1),showWhitespaceCharacters:new WebInspector.Setting("show-whitespace-characters",!1),showInvalidCharacters:new WebInspector.Setting("show-invalid-characters",!1),clearLogOnNavigate:new WebInspector.Setting("clear-log-on-navigate",!0),clearNetworkOnNavigate:new WebInspector.Setting("clear-network-on-navigate",!0),zoomFactor:new WebInspector.Setting("zoom-factor",1),layoutDirection:new WebInspector.Setting("layout-direction-override","system"),stylesShowInlineWarnings:new WebInspector.Setting("styles-show-inline-warning",!0),stylesInsertNewline:new WebInspector.Setting("styles-insert-newline",!0),stylesSelectOnFirstClick:new WebInspector.Setting("styles-select-on-first-click",!0),showScopeChainOnPause:new WebInspector.Setting("show-scope-chain-sidebar",!0),showImageGrid:new WebInspector.Setting("show-image-grid",!1),experimentalShowCanvasContextsInResources:new WebInspector.Setting("experimental-show-canvas-contexts-in-resources",!1)},WebInspector.YieldableTask=class extends WebInspector.Object{constructor(_,S,C={}){super();let{workInterval:f,idleInterval:T}=C;this._workInterval=f||10,this._idleInterval=T||0,this._delegate=_,this._items=S,this._idleTimeoutIdentifier=void 0,this._processing=!1,this._processing=!1,this._cancelled=!1}get processing(){return this._processing}get cancelled(){return this._cancelled}get idleInterval(){return this._idleInterval}get workInterval(){return this._workInterval}start(){this._processing||this._cancelled||(this._processing=!0,this._pendingItemsIterator=function*(){let S=Date.now(),C=[];for(let f of this._items){if(this._cancelled)break;if(this._delegate.yieldableTaskWillProcessItem(this,f),C.push(f),this._cancelled)break;let T=Date.now()-S;if(T>this._workInterval){let E=C.slice();C=[],this._willYield(E,T),yield,S=Date.now()}}C.length&&this._willYield(C,Date.now()-S)}.call(this),this._processPendingItems())}cancel(){this._processing&&(this._cancelled=!0)}_processPendingItems(){return this._cancelled?void 0:this._pendingItemsIterator.next().done?void this._didFinish():void(this._idleTimeoutIdentifier=setTimeout(()=>{this._processPendingItems()},this._idleInterval))}_willYield(_,S){"function"==typeof this._delegate.yieldableTaskDidYield&&this._delegate.yieldableTaskDidYield(this,_,S)}_didFinish(){this._processing=!1,this._pendingItemsIterator=null,this._idleTimeoutIdentifier&&(clearTimeout(this._idleTimeoutIdentifier),this._idleTimeoutIdentifier=void 0),"function"==typeof this._delegate.yieldableTaskDidFinish&&this._delegate.yieldableTaskDidFinish(this)}},WebInspector.ProtocolTracer=class extends WebInspector.Object{logStarted(){}logFrontendException(){}logProtocolError(){}logFrontendRequest(){}logWillHandleResponse(){}logDidHandleResponse(S=null){}logWillHandleEvent(){}logDidHandleEvent(S=null){}logFinished(){}},WebInspector.LoggingProtocolTracer=class extends WebInspector.ProtocolTracer{constructor(){super(),this._dumpMessagesToConsole=!1,this._dumpTimingDataToConsole=!1,this._logToConsole=window.InspectorTest?InspectorFrontendHost.unbufferedLog.bind(InspectorFrontendHost):console.log.bind(console)}set dumpMessagesToConsole(_){this._dumpMessagesToConsole=!!_}get dumpMessagesToConsole(){return this._dumpMessagesToConsole}set dumpTimingDataToConsole(_){this._dumpTimingDataToConsole=!!_}get dumpTimingDataToConsole(){return this._dumpTimingDataToConsole}logFrontendException(_,S){this._processEntry({type:"exception",message:_,exception:S})}logProtocolError(_,S){this._processEntry({type:"error",message:_,error:S})}logFrontendRequest(_){this._processEntry({type:"request",message:_})}logWillHandleResponse(_){this._processEntry({type:"response",message:_})}logDidHandleResponse(_,S=null){let C={type:"response",message:_};S&&(C.timings=Object.shallowCopy(S)),this._processEntry(C)}logWillHandleEvent(_){this._processEntry({type:"event",message:_})}logDidHandleEvent(_,S=null){let C={type:"event",message:_};S&&(C.timings=Object.shallowCopy(S)),this._processEntry(C)}_processEntry(_){this._dumpTimingDataToConsole&&_.timings?_.timings.rtt&&_.timings.dispatch?this._logToConsole(`time-stats: Handling: ${_.timings.dispatch||NaN}ms; RTT: ${_.timings.rtt}ms`):_.timings.dispatch&&this._logToConsole(`time-stats: Handling: ${_.timings.dispatch||NaN}ms`):this._dumpMessagesToConsole&&!_.timings&&(this._logToConsole(`${_.type}: ${JSON.stringify(_.message)}`),_.exception&&(this._logToConsole(_.exception),_.exception.stack&&this._logToConsole(_.exception.stack)))}},InspectorBackendClass=class{constructor(){this._agents={},this._customTracer=null,this._defaultTracer=new WebInspector.LoggingProtocolTracer,this._activeTracers=[this._defaultTracer],this._workerSupportedDomains=[],WebInspector.settings.autoLogProtocolMessages.addEventListener(WebInspector.Setting.Event.Changed,this._startOrStopAutomaticTracing,this),WebInspector.settings.autoLogTimeStats.addEventListener(WebInspector.Setting.Event.Changed,this._startOrStopAutomaticTracing,this),this._startOrStopAutomaticTracing(),this.currentDispatchState={event:null,request:null,response:null}}get workerSupportedDomains(){return this._workerSupportedDomains}set dumpInspectorProtocolMessages(_){WebInspector.settings.autoLogProtocolMessages.value=_,this._defaultTracer.dumpMessagesToConsole=_}get dumpInspectorProtocolMessages(){return WebInspector.settings.autoLogProtocolMessages.value}set dumpInspectorTimeStats(_){WebInspector.settings.autoLogTimeStats.value=_,this.dumpInspectorProtocolMessages||(this.dumpInspectorProtocolMessages=!0),this._defaultTracer.dumpTimingDataToConsole=_}get dumpInspectorTimeStats(){return WebInspector.settings.autoLogTimeStats.value}set customTracer(_){(_||this._customTracer)&&_!==this._customTracer&&_!==this._defaultTracer&&(this._customTracer&&this._customTracer.logFinished(),this._customTracer=_,this._activeTracers=[this._defaultTracer],this._customTracer&&(this._customTracer.logStarted(),this._activeTracers.push(this._customTracer)))}get activeTracers(){return this._activeTracers}registerCommand(_,S,C){var[f,T]=_.split("."),E=this._agentForDomain(f);E.addCommand(InspectorBackend.Command.create(E,_,S,C))}registerEnum(_,S){var[C,f]=_.split("."),T=this._agentForDomain(C);T.addEnum(f,S)}registerEvent(_,S){var[C,f]=_.split("."),T=this._agentForDomain(C);T.addEvent(new InspectorBackend.Event(f,S))}registerDomainDispatcher(_,S){var C=this._agentForDomain(_);C.dispatcher=S}dispatch(_){InspectorBackend.mainConnection.dispatch(_)}runAfterPendingDispatches(_){InspectorBackend.mainConnection.runAfterPendingDispatches(_)}activateDomain(_,S){if(!S||InspectorFrontendHost.debuggableType()===S){var C=this._agents[_];return C.activate(),C}return null}workerSupportedDomain(_){this._workerSupportedDomains.push(_)}_startOrStopAutomaticTracing(){this._defaultTracer.dumpMessagesToConsole=this.dumpInspectorProtocolMessages,this._defaultTracer.dumpTimingDataToConsole=this.dumpTimingDataToConsole}_agentForDomain(_){if(this._agents[_])return this._agents[_];var S=new InspectorBackend.Agent(_);return this._agents[_]=S,S}},InspectorBackend=new InspectorBackendClass,InspectorBackend.Agent=class{constructor(_){this._domainName=_,this._connection=InspectorBackend.mainConnection,this._dispatcher=null,this._active=!1,this._events={}}get domainName(){return this._domainName}get active(){return this._active}get connection(){return this._connection}set connection(_){this._connection=_}get dispatcher(){return this._dispatcher}set dispatcher(_){this._dispatcher=_}addEnum(_,S){this[_]=S}addCommand(_){this[_.commandName]=_}addEvent(_){this._events[_.eventName]=_}getEvent(_){return this._events[_]}hasEvent(_){return _ in this._events}hasEventParameter(_,S){let C=this._events[_];return C&&C.parameterNames.includes(S)}activate(){this._active=!0,window[this._domainName+"Agent"]=this}dispatchEvent(_,S){return _ in this._dispatcher?(this._dispatcher[_].apply(this._dispatcher,S),!0):(console.error("Protocol Error: Attempted to dispatch an unimplemented method '"+this._domainName+"."+_+"'"),!1)}},InspectorBackend.Command=function(u,_,S,C){"use strict";this._agent=u,this._instance=this;let[f,T]=_.split(".");this._qualifiedName=_,this._commandName=T,this._callSignature=S||[],this._replySignature=C||[]},InspectorBackend.Command.create=function(u,_,S,C){"use strict";function f(){return T._invokeWithArguments.call(T,this,Array.from(arguments))}let T=new InspectorBackend.Command(u,_,S,C);return f._instance=T,Object.setPrototypeOf(f,InspectorBackend.Command.prototype),f},InspectorBackend.Command.prototype={__proto__:Function.prototype,get qualifiedName(){return this._instance._qualifiedName},get commandName(){return this._instance._commandName},get callSignature(){return this._instance._callSignature},get replySignature(){return this._instance._replySignature},invoke(u,_,S){"use strict";return S=S||this._instance._agent,"function"==typeof _?void S._connection._sendCommandToBackendWithCallback(this._instance,u,_):S._connection._sendCommandToBackendExpectingPromise(this._instance,u)},supports(u){"use strict";return this._instance.callSignature.some(_=>_.name===u)},_invokeWithArguments(u,_){"use strict";function S(E){return console.error(`Protocol Error: ${E}`),f?void setTimeout(f.bind(null,E),0):Promise.reject(new Error(E))}let C=this._instance,f="function"==typeof _.lastValue?_.pop():null,T={};for(let E of C.callSignature){let I=E.name,R=E.type,N=E.optional;if(!_.length&&!N)return S(`Invalid number of arguments for command '${C.qualifiedName}'.`);let L=_.shift();if(!(N&&L===void 0)){if(typeof L!==R)return S(`Invalid type of argument '${I}' for command '${C.qualifiedName}' call. It must be '${R}' but it is '${typeof L}'.`);T[I]=L}}return f||1!==_.length||void 0===_[0]?f?void u._connection._sendCommandToBackendWithCallback(C,T,f):u._connection._sendCommandToBackendExpectingPromise(C,T):S(`Protocol Error: Optional callback argument for command '${C.qualifiedName}' call must be a function but its type is '${typeof _[0]}'.`)}},InspectorBackend.Event=class{constructor(_,S){this.eventName=_,this.parameterNames=S}},InspectorBackend.Connection=class{constructor(){this._lastSequenceId=1,this._pendingResponses=new Map,this._agents={},this._deferredScripts=[],this._target=null}get target(){return this._target}set target(_){for(let S in this._target=_,this._agents){let C=this._agents[S].dispatcher;C&&(C.target=_)}}dispatch(_){let S="string"==typeof _?JSON.parse(_):_;"id"in S?this._dispatchResponse(S):this._dispatchEvent(S)}runAfterPendingDispatches(_){this._pendingResponses.size?this._deferredScripts.push(_):_.call(this)}sendMessageToBackend(){throw new Error("Should be implemented by a InspectorBackend.Connection subclass")}_dispatchResponse(_){_.error&&-32000!==_.error.code&&console.error("Request with id = "+_.id+" failed. "+JSON.stringify(_.error));let S=_.id,C=this._pendingResponses.take(S)||{},{request:f,command:T,callback:E,promise:I}=C,R=timestamp();for(let D of InspectorBackend.activeTracers)D.logWillHandleResponse(_);InspectorBackend.currentDispatchState.request=f,InspectorBackend.currentDispatchState.response=_,"function"==typeof E?this._dispatchResponseToCallback(T,f,_,E):"object"==typeof I?this._dispatchResponseToPromise(T,_,I):console.error("Received a command response without a corresponding callback or promise.",_,T),InspectorBackend.currentDispatchState.request=null,InspectorBackend.currentDispatchState.response=null;let N=(timestamp()-R).toFixed(3),L=(R-C.sendRequestTimestamp).toFixed(3);for(let D of InspectorBackend.activeTracers)D.logDidHandleResponse(_,{rtt:L,dispatch:N});this._deferredScripts.length&&!this._pendingResponses.size&&this._flushPendingScripts()}_dispatchResponseToCallback(_,S,C,f){let T=[C.error?C.error.message:null];if(C.result)for(let E of _.replySignature)T.push(C.result[E]);try{f.apply(null,T)}catch(E){WebInspector.reportInternalError(E,{cause:`An uncaught exception was thrown while dispatching response callback for command ${_.qualifiedName}.`})}}_dispatchResponseToPromise(_,S,C){let{resolve:f,reject:T}=C;S.error?T(new Error(S.error.message)):f(S.result)}_dispatchEvent(_){let S=_.method,[C,f]=S.split(".");if(!(C in this._agents))return void console.error("Protocol Error: Attempted to dispatch method '"+f+"' for non-existing domain '"+C+"'");let T=this._agents[C];if(!T.active)return void console.error("Protocol Error: Attempted to dispatch method for domain '"+C+"' which exists but is not active.");let E=T.getEvent(f);if(!E)return void console.error("Protocol Error: Attempted to dispatch an unspecified method '"+S+"'");let I=[];_.params&&(I=E.parameterNames.map(L=>_.params[L]));let R=timestamp();for(let L of InspectorBackend.activeTracers)L.logWillHandleEvent(_);InspectorBackend.currentDispatchState.event=_;try{T.dispatchEvent(f,I)}catch(L){for(let D of InspectorBackend.activeTracers)D.logFrontendException(_,L);WebInspector.reportInternalError(L,{cause:`An uncaught exception was thrown while handling event: ${S}`})}InspectorBackend.currentDispatchState.event=null;let N=(timestamp()-R).toFixed(3);for(let L of InspectorBackend.activeTracers)L.logDidHandleEvent(_,{dispatch:N})}_sendCommandToBackendWithCallback(_,S,C){let f=this._lastSequenceId++,T={id:f,method:_.qualifiedName};isEmptyObject(S)||(T.params=S);let E={command:_,request:T,callback:C};InspectorBackend.activeTracer&&(E.sendRequestTimestamp=timestamp()),this._pendingResponses.set(f,E),this._sendMessageToBackend(T)}_sendCommandToBackendExpectingPromise(_,S){let C=this._lastSequenceId++,f={id:C,method:_.qualifiedName};isEmptyObject(S)||(f.params=S);let T={command:_,request:f};InspectorBackend.activeTracer&&(T.sendRequestTimestamp=timestamp());let E=new Promise(function(I,R){T.promise={resolve:I,reject:R}});return this._pendingResponses.set(C,T),this._sendMessageToBackend(f),E}_sendMessageToBackend(_){for(let S of InspectorBackend.activeTracers)S.logFrontendRequest(_);this.sendMessageToBackend(JSON.stringify(_))}_flushPendingScripts(){let _=this._deferredScripts;this._deferredScripts=[];for(let S of _)S.call(this)}},InspectorBackend.MainConnection=class extends InspectorBackend.Connection{constructor(){super(),this._agents=InspectorBackend._agents}sendMessageToBackend(_){InspectorFrontendHost.sendMessageToBackend(_)}},InspectorBackend.WorkerConnection=class extends InspectorBackend.Connection{constructor(_){super(),this._workerId=_;const S=InspectorBackend.workerSupportedDomains;for(let C of S){let f=InspectorBackend._agents[C],T=Object.create(InspectorBackend._agents[C]);T.connection=this,T.dispatcher=new f.dispatcher.constructor,this._agents[C]=T}}sendMessageToBackend(_){WorkerAgent.sendMessageToWorker(this._workerId,_)}},InspectorBackend.mainConnection=new InspectorBackend.MainConnection,InspectorFrontendAPI={_loaded:!1,_pendingCommands:[],savedURL:function(){},appendedToURL:function(){},isTimelineProfilingEnabled:function(){return WebInspector.timelineManager.isCapturing()},setTimelineProfilingEnabled:function(u){WebInspector.timelineManager.isCapturing()===u||(u?WebInspector.timelineManager.startCapturing():WebInspector.timelineManager.stopCapturing())},setElementSelectionEnabled:function(u){WebInspector.domTreeManager.inspectModeEnabled=u},setDockingUnavailable:function(u){WebInspector.updateDockingAvailability(!u)},setDockSide:function(u){WebInspector.updateDockedState(u)},setIsVisible:function(u){WebInspector.updateVisibilityState(u)},showConsole:function(){WebInspector.showConsoleTab(),WebInspector.quickConsole.prompt.focus(),"complete"!==document.readyState&&document.addEventListener("readystatechange",this),"visible"!==document.visibilityState&&document.addEventListener("visibilitychange",this)},handleEvent:function(){"complete"===document.readyState&&"visible"===document.visibilityState&&(WebInspector.quickConsole.prompt.focus(),document.removeEventListener("readystatechange",this),document.removeEventListener("visibilitychange",this))},showResources:function(){WebInspector.showResourcesTab()},showTimelines:function(){WebInspector.showTimelineTab()},showMainResourceForFrame:function(u){WebInspector.showSourceCodeForFrame(u,{ignoreNetworkTab:!0,ignoreSearchTab:!0})},contextMenuItemSelected:function(u){try{WebInspector.ContextMenu.contextMenuItemSelected(u)}catch(_){console.error("Uncaught exception in inspector page under contextMenuItemSelected",_)}},contextMenuCleared:function(){WebInspector.ContextMenu.contextMenuCleared()},dispatchMessageAsync:function(u){WebInspector.dispatchMessageFromBackend(u)},dispatchMessage:function(u){InspectorBackend.dispatch(u)},dispatch:function(u){if(!InspectorFrontendAPI._loaded)return InspectorFrontendAPI._pendingCommands.push(u),null;var _=u.shift();return InspectorFrontendAPI[_]?InspectorFrontendAPI[_].apply(InspectorFrontendAPI,u):null},loadCompleted:function(){InspectorFrontendAPI._loaded=!0;for(var u=0;u<InspectorFrontendAPI._pendingCommands.length;++u)InspectorFrontendAPI.dispatch(InspectorFrontendAPI._pendingCommands[u]);delete InspectorFrontendAPI._pendingCommands}},function(){let u=InspectorFrontendHost.backendCommandsURL()||"Protocol/InspectorBackendCommands.js";document.write("<script src=\""+u+"\"></script>")}(),WebInspector._messagesToDispatch=[],WebInspector.dispatchNextQueuedMessageFromBackend=function(){const u=WebInspector._messagesToDispatch.length,_=timestamp();let C=0;for(;C<WebInspector._messagesToDispatch.length&&!(timestamp()-_>10);++C)InspectorBackend.dispatch(WebInspector._messagesToDispatch[C]);if(C===WebInspector._messagesToDispatch.length?(WebInspector._messagesToDispatch=[],WebInspector._dispatchTimeout=null):(WebInspector._messagesToDispatch=WebInspector._messagesToDispatch.slice(C),WebInspector._dispatchTimeout=setTimeout(WebInspector.dispatchNextQueuedMessageFromBackend,0)),InspectorBackend.dumpInspectorTimeStats){let f=(timestamp()-_).toFixed(3),T=u-WebInspector._messagesToDispatch.length,E=WebInspector._messagesToDispatch.length;console.log(`time-stats: --- RunLoop duration: ${f}ms; dispatched: ${T}; remaining: ${E}`)}},WebInspector.dispatchMessageFromBackend=function(u){this._messagesToDispatch.push(u);window.__uncaughtExceptions&&window.__uncaughtExceptions.length||this._dispatchTimeout||(this._dispatchTimeout=setTimeout(this.dispatchNextQueuedMessageFromBackend,0))},WebInspector.RemoteObject=class{constructor(_,S,C,f,T,E,I,R,N,L){this._target=_||WebInspector.mainTarget,this._type=C,this._subtype=f,S?(this._objectId=S,this._description=E||"",this._hasChildren="symbol"!==C,this._size=I,this._classPrototype=R,this._preview=L,"class"===f&&(this._functionDescription=this._description,this._description="class "+N)):(this._description=E||T+"",this._hasChildren=!1,this._value=T)}static createFakeRemoteObject(){return new WebInspector.RemoteObject(void 0,WebInspector.RemoteObject.FakeRemoteObjectId,"object")}static fromPrimitiveValue(_){return new WebInspector.RemoteObject(void 0,void 0,typeof _,void 0,_,void 0,void 0,void 0,void 0)}static fromPayload(_,S){if("array"===_.subtype){var C=_.description.match(/\[(\d+)\]$/);C&&(_.size=parseInt(C[1]),_.description=_.description.replace(/\[\d+\]$/,""))}return _.classPrototype&&(_.classPrototype=WebInspector.RemoteObject.fromPayload(_.classPrototype,S)),_.preview&&(!_.preview.type&&(_.preview.type=_.type,_.preview.subtype=_.subtype,_.preview.description=_.description,_.preview.size=_.size),_.preview=WebInspector.ObjectPreview.fromPayload(_.preview)),new WebInspector.RemoteObject(S,_.objectId,_.type,_.subtype,_.value,_.description,_.size,_.classPrototype,_.className,_.preview)}static createCallArgument(_){return _ instanceof WebInspector.RemoteObject?_.objectId?{objectId:_.objectId}:{value:_.value}:{value:_}}static resolveNode(_,S,C){DOMAgent.resolveNode(_.id,S,function(f,T){C&&(f||!T?C(null):C(WebInspector.RemoteObject.fromPayload(T,WebInspector.mainTarget)))})}static resolveWebSocket(_,S,C){NetworkAgent.resolveWebSocket(_.requestIdentifier,S,(f,T)=>{f||!T?C(null):C(WebInspector.RemoteObject.fromPayload(T,_.target))})}static resolveCanvasContext(_,S,C){CanvasAgent.resolveCanvasContext(_.identifier,S,(f,T)=>{f||!T?C(null):C(WebInspector.RemoteObject.fromPayload(T,WebInspector.mainTarget))})}static type(_){if(null===_)return"null";var S=typeof _;return"object"!=S&&"function"!=S?S:_.type}get target(){return this._target}get objectId(){return this._objectId}get type(){return this._type}get subtype(){return this._subtype}get description(){return this._description}get functionDescription(){return this._functionDescription||this._description}get hasChildren(){return this._hasChildren}get value(){return this._value}get size(){return this._size||0}get classPrototype(){return this._classPrototype}get preview(){return this._preview}hasSize(){return this.isArray()||this.isCollectionType()}hasValue(){return"_value"in this}canLoadPreview(){return!this._failedToLoadPreview&&!("object"!==this._type)&&(!this._objectId||this._isSymbol()||this._isFakeObject()?!1:!0)}updatePreview(_){return this.canLoadPreview()?RuntimeAgent.getPreview?void this._target.RuntimeAgent.getPreview(this._objectId,(S,C)=>{return S?(this._failedToLoadPreview=!0,void _(null)):void(this._preview=WebInspector.ObjectPreview.fromPayload(C),_(this._preview))}):(this._failedToLoadPreview=!0,void _(null)):void _(null)}getOwnPropertyDescriptors(_){this._getPropertyDescriptors(!0,_)}getAllPropertyDescriptors(_){this._getPropertyDescriptors(!1,_)}getDisplayablePropertyDescriptors(_){return!this._objectId||this._isSymbol()||this._isFakeObject()?void _([]):RuntimeAgent.getDisplayableProperties?void this._target.RuntimeAgent.getDisplayableProperties(this._objectId,!0,this._getPropertyDescriptorsResolver.bind(this,_)):void this._target.RuntimeAgent.getProperties(this._objectId,function(S,C){var f=[];if(C)for(var T of C)if(T.isOwn||"__proto__"===T.name)f.push(T);else if(T.value&&T.name!==T.name.toUpperCase()){var E=T.value.type;E&&"function"!==E&&"constructor"!==T.name&&f.push(T)}this._getPropertyDescriptorsResolver(_,S,f)}.bind(this))}deprecatedGetOwnProperties(_){this._deprecatedGetProperties(!0,_)}deprecatedGetAllProperties(_){this._deprecatedGetProperties(!1,_)}deprecatedGetDisplayableProperties(_){return!this._objectId||this._isSymbol()||this._isFakeObject()?void _([]):RuntimeAgent.getDisplayableProperties?void this._target.RuntimeAgent.getDisplayableProperties(this._objectId,this._deprecatedGetPropertiesResolver.bind(this,_)):void this._target.RuntimeAgent.getProperties(this._objectId,function(S,C){var f=[];if(C)for(var T of C)if(T.isOwn||T.get||"__proto__"===T.name)f.push(T);else if(T.value&&T.name!==T.name.toUpperCase()){var E=T.value.type;E&&"function"!==E&&"constructor"!==T.name&&f.push(T)}this._deprecatedGetPropertiesResolver(_,S,f)}.bind(this))}setPropertyValue(_,S,C){function T(E,I,R){return E||R?void C(E||I.description):void C()}return!this._objectId||this._isSymbol()||this._isFakeObject()?void C("Can't set a property of non-object."):void this._target.RuntimeAgent.evaluate.invoke({expression:appendWebInspectorSourceURL(S),doNotPauseOnExceptionsAndMuteConsole:!0},function(E,I,R){return E||R?void C(E||I.description):void(delete I.description,this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(function(L,D){this[L]=D}.toString()),[{value:_},I],!0,void 0,T.bind(this)),I._objectId&&this._target.RuntimeAgent.releaseObject(I._objectId))}.bind(this),this._target.RuntimeAgent)}isUndefined(){return"undefined"===this._type}isNode(){return"node"===this._subtype}isArray(){return"array"===this._subtype}isClass(){return"class"===this._subtype}isCollectionType(){return"map"===this._subtype||"set"===this._subtype||"weakmap"===this._subtype||"weakset"===this._subtype}isWeakCollection(){return"weakmap"===this._subtype||"weakset"===this._subtype}getCollectionEntries(_,S,C){_="number"==typeof _?_:0,S="number"==typeof S?S:100;let f=this.isWeakCollection()?this._weakCollectionObjectGroup():"";this._target.RuntimeAgent.getCollectionEntries(this._objectId,f,_,S,(T,E)=>{E=E.map(I=>WebInspector.CollectionEntry.fromPayload(I,this._target)),C(E)})}releaseWeakCollectionEntries(){this._target.RuntimeAgent.releaseObjectGroup(this._weakCollectionObjectGroup())}pushNodeToFrontend(_){this._objectId?WebInspector.domTreeManager.pushNodeToFrontend(this._objectId,_):_(0)}getProperty(_,S){this.callFunction(function(f){return this[f]},[_],!0,S)}callFunction(_,S,C,f){S&&(S=S.map(WebInspector.RemoteObject.createCallArgument)),this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(_.toString()),S,!0,void 0,!!C,function(E,I,R){I=I?WebInspector.RemoteObject.fromPayload(I,this._target):null,f&&"function"==typeof f&&f(E,I,R)}.bind(this))}callFunctionJSON(_,S,C){this._target.RuntimeAgent.callFunctionOn(this._objectId,appendWebInspectorSourceURL(_.toString()),S,!0,!0,function(T,E,I){C(T||I?null:E.value)})}invokeGetter(_,S){this.callFunction(function(f){return f?f.call(this):void 0},[_],!0,S)}getOwnPropertyDescriptor(_,S){this.callFunction(function(T){return this[T]},[_],!1,function(T,E,I){if(T||I||!(E instanceof WebInspector.RemoteObject))return void S(null);var N=new WebInspector.PropertyDescriptor({name:_,value:E,writable:!0,configurable:!0,enumerable:!1},null,!0,!1,!1,!1);S(N)}.bind(this))}release(){this._objectId&&!this._isFakeObject()&&this._target.RuntimeAgent.releaseObject(this._objectId)}arrayLength(){if("array"!==this._subtype)return 0;var _=this._description.match(/\[([0-9]+)\]/);return _?parseInt(_[1],10):0}asCallArgument(){return WebInspector.RemoteObject.createCallArgument(this)}findFunctionSourceCodeLocation(){var _=new WebInspector.WrappedPromise;return this._isFunction()&&this._objectId?(this._target.DebuggerAgent.getFunctionDetails(this._objectId,(S,C)=>{if(S)return void _.reject(S);var f=C.location,T=WebInspector.debuggerManager.scriptForIdentifier(f.scriptId,this._target);if(!T||!WebInspector.isDebugUIEnabled()&&isWebKitInternalScript(T.sourceURL))return void _.resolve(WebInspector.RemoteObject.SourceCodeLocationPromise.NoSourceFound);var E=T.createSourceCodeLocation(f.lineNumber,f.columnNumber||0);_.resolve(E)}),_.promise):(_.resolve(WebInspector.RemoteObject.SourceCodeLocationPromise.MissingObjectId),_.promise)}_isFakeObject(){return this._objectId===WebInspector.RemoteObject.FakeRemoteObjectId}_isSymbol(){return"symbol"===this._type}_isFunction(){return"function"===this._type}_weakCollectionObjectGroup(){return JSON.stringify(this._objectId)+"-"+this._subtype}_getPropertyDescriptors(_,S){return!this._objectId||this._isSymbol()||this._isFakeObject()?void S([]):void this._target.RuntimeAgent.getProperties(this._objectId,_,!0,this._getPropertyDescriptorsResolver.bind(this,S))}getOwnPropertyDescriptorsAsObject(_){this.getOwnPropertyDescriptors(function(S){var C={},f={};for(var T of S){var E=T.isInternalProperty?f:C;E[T.name]=T}_(C,f)})}_getPropertyDescriptorsResolver(_,S,C,f){if(S)return void _(null);let T=C.map(E=>{return WebInspector.PropertyDescriptor.fromPayload(E,!1,this._target)});f&&(T=T.concat(f.map(E=>{return WebInspector.PropertyDescriptor.fromPayload(E,!0,this._target)}))),_(T)}_deprecatedGetProperties(_,S){return!this._objectId||this._isSymbol()||this._isFakeObject()?void S([]):void this._target.RuntimeAgent.getProperties(this._objectId,_,this._deprecatedGetPropertiesResolver.bind(this,S))}_deprecatedGetPropertiesResolver(_,S,C,f){if(S)return void _(null);f&&(C=C.concat(f.map(function(R){return R.writable=!1,R.configurable=!1,R.enumerable=!1,R.isOwn=!0,R})));for(var T=[],E=0,I;C&&E<C.length;++E)I=C[E],I.get||I.set?(I.get&&T.push(new WebInspector.DeprecatedRemoteObjectProperty("get "+I.name,WebInspector.RemoteObject.fromPayload(I.get,this._target),I)),I.set&&T.push(new WebInspector.DeprecatedRemoteObjectProperty("set "+I.name,WebInspector.RemoteObject.fromPayload(I.set,this._target),I))):T.push(new WebInspector.DeprecatedRemoteObjectProperty(I.name,WebInspector.RemoteObject.fromPayload(I.value,this._target),I));_(T)}},WebInspector.RemoteObject.FakeRemoteObjectId="fake-remote-object",WebInspector.RemoteObject.SourceCodeLocationPromise={NoSourceFound:"remote-object-source-code-location-promise-no-source-found",MissingObjectId:"remote-object-source-code-location-promise-missing-object-id"},WebInspector.DeprecatedRemoteObjectProperty=class{constructor(_,S,C){this.name=_,this.value=S,this.enumerable=!C||!!C.enumerable,this.writable=!C||!!C.writable,C&&C.wasThrown&&(this.wasThrown=!0)}fromPrimitiveValue(_,S){return new WebInspector.DeprecatedRemoteObjectProperty(_,WebInspector.RemoteObject.fromPrimitiveValue(S))}},WebInspector.Target=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._identifier=_,this._name=S,this._type=C,this._connection=f,this._executionContext=null,this._mainResource=null,this._resourceCollection=new WebInspector.ResourceCollection,this._extraScriptCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Script),this._connection.target=this}get RuntimeAgent(){return this._connection._agents.Runtime}get ConsoleAgent(){return this._connection._agents.Console}get DebuggerAgent(){return this._connection._agents.Debugger}get HeapAgent(){return this._connection._agents.Heap}get identifier(){return this._identifier}get name(){return this._name}get type(){return this._type}get connection(){return this._connection}get executionContext(){return this._executionContext}get resourceCollection(){return this._resourceCollection}get extraScriptCollection(){return this._extraScriptCollection}get mainResource(){return this._mainResource}set mainResource(_){this._mainResource=_}addResource(_){this._resourceCollection.add(_),this.dispatchEventToListeners(WebInspector.Target.Event.ResourceAdded,{resource:_})}adoptResource(_){_._target=this,this.addResource(_)}addScript(_){this._extraScriptCollection.add(_),this.dispatchEventToListeners(WebInspector.Target.Event.ScriptAdded,{script:_})}},WebInspector.Target.Type={Main:Symbol("main"),Worker:Symbol("worker")},WebInspector.Target.Event={ResourceAdded:"target-resource-added",ScriptAdded:"target-script-added"},WebInspector.MainTarget=class extends WebInspector.Target{constructor(){super("main","",WebInspector.Target.Type.Main,InspectorBackend.mainConnection);let S=WebInspector.debuggableType===WebInspector.DebuggableType.Web?WebInspector.UIString("Main Frame"):this.displayName;this._executionContext=new WebInspector.ExecutionContext(this,WebInspector.RuntimeManager.TopLevelContextExecutionIdentifier,S,!0,null)}get displayName(){switch(WebInspector.debuggableType){case WebInspector.DebuggableType.Web:return WebInspector.UIString("Page");case WebInspector.DebuggableType.JavaScript:return WebInspector.UIString("JavaScript Context");default:return console.error("Unexpected debuggable type: ",WebInspector.debuggableType),WebInspector.UIString("Main");}}get mainResource(){let _=WebInspector.frameResourceManager.mainFrame;return _?_.mainResource:null}},WebInspector.WorkerTarget=class extends WebInspector.Target{constructor(_,S,C){super(_,S,WebInspector.Target.Type.Worker,C),WebInspector.frameResourceManager.adoptOrphanedResourcesForTarget(this),this.RuntimeAgent&&(this._executionContext=new WebInspector.ExecutionContext(this,WebInspector.RuntimeManager.TopLevelContextExecutionIdentifier,this.displayName,!1,null),this.RuntimeAgent.enable(),WebInspector.showJavaScriptTypeInformationSetting&&WebInspector.showJavaScriptTypeInformationSetting.value&&this.RuntimeAgent.enableTypeProfiler(),WebInspector.enableControlFlowProfilerSetting&&WebInspector.enableControlFlowProfilerSetting.value&&this.RuntimeAgent.enableControlFlowProfiler()),this.DebuggerAgent&&WebInspector.debuggerManager.initializeTarget(this),this.ConsoleAgent&&this.ConsoleAgent.enable(),this.HeapAgent&&this.HeapAgent.enable()}get displayName(){return WebInspector.displayNameForURL(this._name)}},WebInspector.ApplicationCacheObserver=class{applicationCacheStatusUpdated(_,S,C){WebInspector.applicationCacheManager.applicationCacheStatusUpdated(_,S,C)}networkStateUpdated(_){WebInspector.applicationCacheManager.networkStateUpdated(_)}},WebInspector.CSSObserver=class{mediaQueryResultChanged(){WebInspector.cssStyleManager.mediaQueryResultChanged()}styleSheetChanged(_){WebInspector.cssStyleManager.styleSheetChanged(_)}styleSheetAdded(_){WebInspector.cssStyleManager.styleSheetAdded(_)}styleSheetRemoved(_){WebInspector.cssStyleManager.styleSheetRemoved(_)}namedFlowCreated(_){WebInspector.domTreeManager.namedFlowCreated(_)}namedFlowRemoved(_,S){WebInspector.domTreeManager.namedFlowRemoved(_,S)}regionLayoutUpdated(_){this.regionOversetChanged(_)}regionOversetChanged(_){WebInspector.domTreeManager.regionOversetChanged(_)}registeredNamedFlowContentElement(_,S,C,f){WebInspector.domTreeManager.registeredNamedFlowContentElement(_,S,C,f)}unregisteredNamedFlowContentElement(_,S,C){WebInspector.domTreeManager.unregisteredNamedFlowContentElement(_,S,C)}},WebInspector.CanvasObserver=class{canvasAdded(_){WebInspector.canvasManager.canvasAdded(_)}canvasRemoved(_){WebInspector.canvasManager.canvasRemoved(_)}canvasMemoryChanged(_,S){WebInspector.canvasManager.canvasMemoryChanged(_,S)}cssCanvasClientNodesChanged(_){WebInspector.canvasManager.cssCanvasClientNodesChanged(_)}},WebInspector.ConsoleObserver=class{messageAdded(_){"console-api"===_.source&&"clear"===_.type||("assert"===_.type&&!_.text&&(_.text=WebInspector.UIString("Assertion")),WebInspector.logManager.messageWasAdded(this.target,_.source,_.level,_.text,_.type,_.url,_.line,_.column||0,_.repeatCount,_.parameters,_.stackTrace,_.networkRequestId))}messageRepeatCountUpdated(_){WebInspector.logManager.messageRepeatCountUpdated(_)}messagesCleared(){WebInspector.logManager.messagesCleared()}heapSnapshot(_,S,C){let f=WebInspector.HeapSnapshotWorkerProxy.singleton();f.createSnapshot(S,C||null,({objectId:T,snapshot:E})=>{let I=WebInspector.HeapSnapshotProxy.deserialize(T,E);WebInspector.timelineManager.heapSnapshotAdded(_,I)})}},WebInspector.DOMObserver=class{documentUpdated(){WebInspector.domTreeManager._documentUpdated()}setChildNodes(_,S){WebInspector.domTreeManager._setChildNodes(_,S)}attributeModified(_,S,C){WebInspector.domTreeManager._attributeModified(_,S,C)}attributeRemoved(_,S){WebInspector.domTreeManager._attributeRemoved(_,S)}inlineStyleInvalidated(_){WebInspector.domTreeManager._inlineStyleInvalidated(_)}characterDataModified(_,S){WebInspector.domTreeManager._characterDataModified(_,S)}childNodeCountUpdated(_,S){WebInspector.domTreeManager._childNodeCountUpdated(_,S)}childNodeInserted(_,S,C){WebInspector.domTreeManager._childNodeInserted(_,S,C)}childNodeRemoved(_,S){WebInspector.domTreeManager._childNodeRemoved(_,S)}shadowRootPushed(_,S){WebInspector.domTreeManager._childNodeInserted(_,0,S)}shadowRootPopped(_,S){WebInspector.domTreeManager._childNodeRemoved(_,S)}customElementStateChanged(_,S){WebInspector.domTreeManager._customElementStateChanged(_,S)}pseudoElementAdded(_,S){WebInspector.domTreeManager._pseudoElementAdded(_,S)}pseudoElementRemoved(_,S){WebInspector.domTreeManager._pseudoElementRemoved(_,S)}},WebInspector.DOMStorageObserver=class{domStorageItemsCleared(_){WebInspector.storageManager.itemsCleared(_)}domStorageItemRemoved(_,S){WebInspector.storageManager.itemRemoved(_,S)}domStorageItemAdded(_,S,C){WebInspector.storageManager.itemAdded(_,S,C)}domStorageItemUpdated(_,S,C,f){WebInspector.storageManager.itemUpdated(_,S,C,f)}},WebInspector.DatabaseObserver=class{addDatabase(_){WebInspector.storageManager.databaseWasAdded(_.id,_.domain,_.name,_.version)}},WebInspector.DebuggerObserver=class{constructor(){this._legacyScriptParsed=DebuggerAgent.hasEventParameter("scriptParsed","hasSourceURL")}globalObjectCleared(){WebInspector.debuggerManager.reset()}scriptParsed(_,S,C,f,T,E,I,R,N,L){if(this._legacyScriptParsed){let D=arguments[7],M=arguments[8],P=M?S:void 0;return void WebInspector.debuggerManager.scriptDidParse(this.target,_,S,C,f,T,E,L,I,P,D)}WebInspector.debuggerManager.scriptDidParse(this.target,_,S,C,f,T,E,L,I,R,N)}scriptFailedToParse(){}breakpointResolved(_,S){WebInspector.debuggerManager.breakpointResolved(this.target,_,S)}paused(_,S,C,f){WebInspector.debuggerManager.debuggerDidPause(this.target,_,S,C,f)}resumed(){WebInspector.debuggerManager.debuggerDidResume(this.target)}playBreakpointActionSound(_){WebInspector.debuggerManager.playBreakpointActionSound(_)}didSampleProbe(_){WebInspector.probeManager.didSampleProbe(this.target,_)}},WebInspector.HeapObserver=class{garbageCollected(_){WebInspector.heapManager.garbageCollected(this.target,_)}trackingStart(_,S){let C=WebInspector.HeapSnapshotWorkerProxy.singleton();C.createSnapshot(S,({objectId:f,snapshot:T})=>{let E=WebInspector.HeapSnapshotProxy.deserialize(f,T);WebInspector.timelineManager.heapTrackingStarted(_,E)})}trackingComplete(_,S){let C=WebInspector.HeapSnapshotWorkerProxy.singleton();C.createSnapshot(S,({objectId:f,snapshot:T})=>{let E=WebInspector.HeapSnapshotProxy.deserialize(f,T);WebInspector.timelineManager.heapTrackingCompleted(_,E)})}},WebInspector.InspectorObserver=class{evaluateForTestInFrontend(_){InspectorFrontendHost.isUnderTest()&&InspectorBackend.runAfterPendingDispatches(function(){window.eval(_)})}inspect(_,S){var C=WebInspector.RemoteObject.fromPayload(_,WebInspector.mainTarget);return"node"===C.subtype?void WebInspector.domTreeManager.inspectNodeObject(C):void(S.databaseId?WebInspector.storageManager.inspectDatabase(S.databaseId):S.domStorageId&&WebInspector.storageManager.inspectDOMStorage(S.domStorageId),C.release())}activateExtraDomains(_){WebInspector.activateExtraDomains(_)}},WebInspector.LayerTreeObserver=class{layerTreeDidChange(){WebInspector.layerTreeManager.supported&&WebInspector.layerTreeManager.layerTreeDidChange()}},WebInspector.MemoryObserver=class{memoryPressure(_,S){WebInspector.memoryManager.memoryPressure(_,S)}trackingStart(_){WebInspector.timelineManager.memoryTrackingStart(_)}trackingUpdate(_){WebInspector.timelineManager.memoryTrackingUpdate(_)}trackingComplete(){WebInspector.timelineManager.memoryTrackingComplete()}},WebInspector.NetworkObserver=class{requestWillBeSent(_,S,C,f,T,E,I,R,N,L){WebInspector.frameResourceManager.resourceRequestWillBeSent(_,S,C,T,N,R,E,I,L)}requestServedFromCache(_){WebInspector.frameResourceManager.markResourceRequestAsServedFromMemoryCache(_)}responseReceived(_,S,C,f,T,E){WebInspector.frameResourceManager.resourceRequestDidReceiveResponse(_,S,C,T,E,f)}dataReceived(_,S,C,f){WebInspector.frameResourceManager.resourceRequestDidReceiveData(_,C,f,S)}loadingFinished(_,S,C,f){WebInspector.frameResourceManager.resourceRequestDidFinishLoading(_,S,C,f)}loadingFailed(_,S,C,f){WebInspector.frameResourceManager.resourceRequestDidFailLoading(_,f,S,C)}requestServedFromMemoryCache(_,S,C,f,T,E,I){WebInspector.frameResourceManager.resourceRequestWasServedFromMemoryCache(_,S,C,I,T,E)}webSocketCreated(_,S){WebInspector.frameResourceManager.webSocketCreated(_,S)}webSocketWillSendHandshakeRequest(_,S,C,f){WebInspector.frameResourceManager.webSocketWillSendHandshakeRequest(_,S,C,f)}webSocketHandshakeResponseReceived(_,S,C){WebInspector.frameResourceManager.webSocketHandshakeResponseReceived(_,S,C)}webSocketClosed(_,S){WebInspector.frameResourceManager.webSocketClosed(_,S)}webSocketFrameReceived(_,S,C){WebInspector.frameResourceManager.webSocketFrameReceived(_,S,C)}webSocketFrameSent(_,S,C){WebInspector.frameResourceManager.webSocketFrameSent(_,S,C)}webSocketFrameError(){}},WebInspector.PageObserver=class{domContentEventFired(_){WebInspector.timelineManager.pageDOMContentLoadedEventFired(_)}loadEventFired(_){WebInspector.timelineManager.pageLoadEventFired(_)}frameNavigated(_,S){WebInspector.frameResourceManager.frameDidNavigate(_,S)}frameDetached(_){WebInspector.frameResourceManager.frameDidDetach(_)}frameStartedLoading(){}frameStoppedLoading(){}frameScheduledNavigation(){}frameClearedScheduledNavigation(){}javascriptDialogOpening(){}javascriptDialogClosed(){}scriptsEnabled(){}},WebInspector.RuntimeObserver=class{executionContextCreated(_){WebInspector.frameResourceManager.executionContextCreated(_)}},WebInspector.ScriptProfilerObserver=class{trackingStart(_){WebInspector.timelineManager.scriptProfilerTrackingStarted(_)}trackingUpdate(_){WebInspector.timelineManager.scriptProfilerTrackingUpdated(_)}trackingComplete(_){WebInspector.timelineManager.scriptProfilerTrackingCompleted(_)}programmaticCaptureStarted(){WebInspector.timelineManager.scriptProfilerProgrammaticCaptureStarted()}programmaticCaptureStopped(){WebInspector.timelineManager.scriptProfilerProgrammaticCaptureStopped()}},WebInspector.TimelineObserver=class{eventRecorded(_){WebInspector.timelineManager.eventRecorded(_)}recordingStarted(_){WebInspector.timelineManager.capturingStarted(_)}recordingStopped(_){WebInspector.timelineManager.capturingStopped(_)}autoCaptureStarted(){WebInspector.timelineManager.autoCaptureStarted()}programmaticCaptureStarted(){WebInspector.timelineManager.programmaticCaptureStarted()}programmaticCaptureStopped(){WebInspector.timelineManager.programmaticCaptureStopped()}},WebInspector.WorkerObserver=class{workerCreated(_,S){WebInspector.workerManager.workerCreated(_,S)}workerTerminated(_){WebInspector.workerManager.workerTerminated(_)}dispatchMessageFromWorker(_,S){WebInspector.workerManager.dispatchMessageFromWorker(_,S)}},WebInspector.BreakpointAction=class extends WebInspector.Object{constructor(_,S,C){super(),this._breakpoint=_,"string"==typeof S?(this._type=S,this._data=C||null):"object"==typeof S?(this._type=S.type,this._data=S.data||null):console.error("Unexpected type passed to WebInspector.BreakpointAction"),this._id=WebInspector.debuggerManager.nextBreakpointActionIdentifier()}get breakpoint(){return this._breakpoint}get id(){return this._id}get type(){return this._type}get data(){return this._data}set data(_){this._data===_||(this._data=_,this._breakpoint.breakpointActionDidChange(this))}get info(){var _={type:this._type,id:this._id};return this._data&&(_.data=this._data),_}},WebInspector.BreakpointAction.Type={Log:"log",Evaluate:"evaluate",Sound:"sound",Probe:"probe"},WebInspector.ConsoleMessage=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I,R,N,L,D,M){super(),this._target=_,this._source=S,this._level=C,this._messageText=f,this._type=T||WebInspector.ConsoleMessage.MessageType.Log,this._url=E||null,this._line=I||0,this._column=R||0,this._sourceCodeLocation=void 0,this._repeatCount=N||0,this._parameters=L,D=D||[],this._stackTrace=WebInspector.StackTrace.fromPayload(this._target,{callFrames:D}),this._request=M}get target(){return this._target}get source(){return this._source}get level(){return this._level}get messageText(){return this._messageText}get type(){return this._type}get url(){return this._url}get line(){return this._line}get column(){return this._column}get repeatCount(){return this._repeatCount}get parameters(){return this._parameters}get stackTrace(){return this._stackTrace}get request(){return this._request}get sourceCodeLocation(){if(void 0!==this._sourceCodeLocation)return this._sourceCodeLocation;let _=this._stackTrace.callFrames[0];if(_&&_.sourceCodeLocation)return this._sourceCodeLocation=_.sourceCodeLocation,this._sourceCodeLocation;if(this._url&&"undefined"!==this._url){let S=WebInspector.frameResourceManager.resourceForURL(this._url);if(S){let C=0<this._line?this._line-1:0,f=0<this._column?this._column-1:0;return this._sourceCodeLocation=new WebInspector.SourceCodeLocation(S,C,f),this._sourceCodeLocation}}return this._sourceCodeLocation=null,this._sourceCodeLocation}},WebInspector.ConsoleMessage.MessageSource={HTML:"html",XML:"xml",JS:"javascript",Network:"network",ConsoleAPI:"console-api",Storage:"storage",Appcache:"appcache",Rendering:"rendering",CSS:"css",Security:"security",Other:"other"},WebInspector.ConsoleMessage.MessageType={Log:"log",Dir:"dir",DirXML:"dirxml",Table:"table",Trace:"trace",StartGroup:"startGroup",StartGroupCollapsed:"startGroupCollapsed",EndGroup:"endGroup",Assert:"assert",Timing:"timing",Profile:"profile",ProfileEnd:"profileEnd",Result:"result"},WebInspector.ConsoleMessage.MessageLevel={Log:"log",Info:"info",Warning:"warning",Error:"error",Debug:"debug"},WebInspector.Instrument=class extends WebInspector.Object{static createForTimelineType(_){return _===WebInspector.TimelineRecord.Type.Network?new WebInspector.NetworkInstrument:_===WebInspector.TimelineRecord.Type.Layout?new WebInspector.LayoutInstrument:_===WebInspector.TimelineRecord.Type.Script?new WebInspector.ScriptInstrument:_===WebInspector.TimelineRecord.Type.RenderingFrame?new WebInspector.FPSInstrument:_===WebInspector.TimelineRecord.Type.Memory?new WebInspector.MemoryInstrument:_===WebInspector.TimelineRecord.Type.HeapAllocations?new WebInspector.HeapAllocationsInstrument:(console.error("Unknown TimelineRecord.Type: "+_),null)}static startLegacyTimelineAgent(_){if(!WebInspector.Instrument._legacyTimelineAgentStarted&&(WebInspector.Instrument._legacyTimelineAgentStarted=!0,!_)){let S=TimelineAgent.start();TimelineAgent.hasEvent("recordingStarted")||S.then(function(){WebInspector.timelineManager.capturingStarted()})}}static stopLegacyTimelineAgent(_){WebInspector.Instrument._legacyTimelineAgentStarted&&(WebInspector.Instrument._legacyTimelineAgentStarted=!1,_||TimelineAgent.stop())}get timelineRecordType(){return null}startInstrumentation(_){WebInspector.Instrument.startLegacyTimelineAgent(_)}stopInstrumentation(_){WebInspector.Instrument.stopLegacyTimelineAgent(_)}},WebInspector.Instrument._legacyTimelineAgentStarted=!1,WebInspector.SourceCode=class extends WebInspector.Object{constructor(){super(),this._originalRevision=new WebInspector.SourceCodeRevision(this,null,!1),this._currentRevision=this._originalRevision,this._sourceMaps=null,this._formatterSourceMap=null,this._requestContentPromise=null}get displayName(){return console.error("Needs to be implemented by a subclass."),""}get originalRevision(){return this._originalRevision}get currentRevision(){return this._currentRevision}set currentRevision(_){_ instanceof WebInspector.SourceCodeRevision&&_.sourceCode===this&&(this._currentRevision=_,this.dispatchEventToListeners(WebInspector.SourceCode.Event.ContentDidChange))}get content(){return this._currentRevision.content}get url(){}get contentIdentifier(){return this.url}get sourceMaps(){return this._sourceMaps||[]}addSourceMap(_){this._sourceMaps||(this._sourceMaps=[]),this._sourceMaps.push(_),this.dispatchEventToListeners(WebInspector.SourceCode.Event.SourceMapAdded)}get formatterSourceMap(){return this._formatterSourceMap}set formatterSourceMap(_){this._formatterSourceMap=_,this.dispatchEventToListeners(WebInspector.SourceCode.Event.FormatterDidChange)}requestContent(){return this._requestContentPromise=this._requestContentPromise||this.requestContentFromBackend().then(this._processContent.bind(this)),this._requestContentPromise}createSourceCodeLocation(_,S){return new WebInspector.SourceCodeLocation(this,_,S)}createLazySourceCodeLocation(_,S){return new WebInspector.LazySourceCodeLocation(this,_,S)}createSourceCodeTextRange(_){return new WebInspector.SourceCodeTextRange(this,_)}revisionContentDidChange(_){this._ignoreRevisionContentDidChangeEvent||_!==this._currentRevision||(this.handleCurrentRevisionContentChange(),this.dispatchEventToListeners(WebInspector.SourceCode.Event.ContentDidChange))}handleCurrentRevisionContentChange(){}get revisionForRequestedContent(){return this._originalRevision}markContentAsStale(){this._requestContentPromise=null,this._contentReceived=!1}requestContentFromBackend(){return console.error("Needs to be implemented by a subclass."),Promise.reject(new Error("Needs to be implemented by a subclass."))}get mimeType(){console.error("Needs to be implemented by a subclass.")}_processContent(_){var S=_.content||_.body||_.text||_.scriptSource,C=_.error;_.base64Encoded&&(S=decodeBase64ToBlob(S,this.mimeType));var f=this.revisionForRequestedContent;return this._ignoreRevisionContentDidChangeEvent=!0,f.content=S||null,this._ignoreRevisionContentDidChangeEvent=!1,Promise.resolve({error:C,sourceCode:this,content:S})}},WebInspector.SourceCode.Event={ContentDidChange:"source-code-content-did-change",SourceMapAdded:"source-code-source-map-added",FormatterDidChange:"source-code-formatter-did-change",LoadingDidFinish:"source-code-loading-did-finish",LoadingDidFail:"source-code-loading-did-fail"},WebInspector.SourceCodeLocation=class extends WebInspector.Object{constructor(_,S,C){super(),this._sourceCode=_||null,this._lineNumber=S,this._columnNumber=C,this._resolveFormattedLocation(),this._sourceCode&&(this._sourceCode.addEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this),this._sourceCode.addEventListener(WebInspector.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this)),this._resetMappedLocation()}isEqual(_){return!!_&&this._sourceCode===_._sourceCode&&this._lineNumber===_._lineNumber&&this._columnNumber===_._columnNumber}get sourceCode(){return this._sourceCode}set sourceCode(_){this.setSourceCode(_)}get lineNumber(){return this._lineNumber}get columnNumber(){return this._columnNumber}position(){return new WebInspector.SourceCodePosition(this.lineNumber,this.columnNumber)}get formattedLineNumber(){return this._formattedLineNumber}get formattedColumnNumber(){return this._formattedColumnNumber}formattedPosition(){return new WebInspector.SourceCodePosition(this.formattedLineNumber,this.formattedColumnNumber)}get displaySourceCode(){return this.resolveMappedLocation(),this._mappedResource||this._sourceCode}get displayLineNumber(){return this.resolveMappedLocation(),isNaN(this._mappedLineNumber)?this._formattedLineNumber:this._mappedLineNumber}get displayColumnNumber(){return this.resolveMappedLocation(),isNaN(this._mappedColumnNumber)?this._formattedColumnNumber:this._mappedColumnNumber}displayPosition(){return new WebInspector.SourceCodePosition(this.displayLineNumber,this.displayColumnNumber)}originalLocationString(_,S,C){return this._locationString(this.sourceCode,this.lineNumber,this.columnNumber,_,S,C)}formattedLocationString(_,S,C){return this._locationString(this.sourceCode,this.formattedLineNumber,this.formattedColumn,_,S,C)}displayLocationString(_,S,C){return this._locationString(this.displaySourceCode,this.displayLineNumber,this.displayColumnNumber,_,S,C)}tooltipString(){if(!this.hasDifferentDisplayLocation())return this.originalLocationString(WebInspector.SourceCodeLocation.ColumnStyle.Shown,WebInspector.SourceCodeLocation.NameStyle.Full);var _=WebInspector.UIString("Located at %s").format(this.displayLocationString(WebInspector.SourceCodeLocation.ColumnStyle.Shown,WebInspector.SourceCodeLocation.NameStyle.Full));return _+="\n"+WebInspector.UIString("Originally %s").format(this.originalLocationString(WebInspector.SourceCodeLocation.ColumnStyle.Shown,WebInspector.SourceCodeLocation.NameStyle.Full)),_}hasMappedLocation(){return this.resolveMappedLocation(),null!==this._mappedResource}hasFormattedLocation(){return this._formattedLineNumber!==this._lineNumber||this._formattedColumnNumber!==this._columnNumber}hasDifferentDisplayLocation(){return this.hasMappedLocation()||this.hasFormattedLocation()}update(_,S,C){if((_!==this._sourceCode||S!==this._lineNumber||C!==this._columnNumber)&&!(this._mappedResource&&_===this._mappedResource&&S===this._mappedLineNumber&&C===this._mappedColumnNumber)){var f=_.createSourceCodeLocation(S,C);this._makeChangeAndDispatchChangeEventIfNeeded(function(){this._lineNumber=f._lineNumber,this._columnNumber=f._columnNumber,f._mappedLocationIsResolved&&(this._mappedLocationIsResolved=!0,this._mappedResource=f._mappedResource,this._mappedLineNumber=f._mappedLineNumber,this._mappedColumnNumber=f._mappedColumnNumber)})}}populateLiveDisplayLocationTooltip(_,S){S=S||"",_.title=S+this.tooltipString(),this.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,function(){this.sourceCode&&(_.title=S+this.tooltipString())},this)}populateLiveDisplayLocationString(_,S,C,f,T){function E(L,D){(D||R!==L)&&(R=L,L?this.hasDifferentDisplayLocation()&&(_[S]=this.originalLocationString(C,f,T),_.classList.remove(WebInspector.SourceCodeLocation.DisplayLocationClassName)):(_[S]=this.displayLocationString(C,f,T),_.classList.toggle(WebInspector.SourceCodeLocation.DisplayLocationClassName,this.hasDifferentDisplayLocation())))}var R;E.call(this,!1),this.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,function(){this.sourceCode&&E.call(this,R,!0)},this);var N=function(L){E.call(this,L.metaKey&&!L.altKey&&!L.shiftKey)}.bind(this);_.addEventListener("mouseover",N),_.addEventListener("mousemove",N),_.addEventListener("mouseout",()=>{E.call(this,!1)})}setSourceCode(_){_===this._sourceCode||this._makeChangeAndDispatchChangeEventIfNeeded(function(){this._sourceCode&&(this._sourceCode.removeEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this),this._sourceCode.removeEventListener(WebInspector.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this)),this._sourceCode=_,this._sourceCode&&(this._sourceCode.addEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this._sourceCodeSourceMapAdded,this),this._sourceCode.addEventListener(WebInspector.SourceCode.Event.FormatterDidChange,this._sourceCodeFormatterDidChange,this))})}resolveMappedLocation(){if(!this._mappedLocationIsResolved&&(this._mappedLocationIsResolved=!0,!!this._sourceCode)){var _=this._sourceCode.sourceMaps;if(_.length)for(var S=0;S<_.length;++S){var C=_[S],f=C.findEntry(this._lineNumber,this._columnNumber);if(f&&2!==f.length){var T=f[2],E=C.resourceForURL(T);return E?(this._mappedResource=E,this._mappedLineNumber=f[3],void(this._mappedColumnNumber=f[4])):void 0}}}}_locationString(_,S,C,f,T,E){if(!_)return"";f=f||WebInspector.SourceCodeLocation.ColumnStyle.OnlyIfLarge,T=T||WebInspector.SourceCodeLocation.NameStyle.Short,E=E||"";let I=S+1;switch(f===WebInspector.SourceCodeLocation.ColumnStyle.Shown&&0<C?I+=":"+(C+1):f===WebInspector.SourceCodeLocation.ColumnStyle.OnlyIfLarge&&C>WebInspector.SourceCodeLocation.LargeColumnNumber?I+=":"+(C+1):f===WebInspector.SourceCodeLocation.ColumnStyle.Hidden&&(I=""),T){case WebInspector.SourceCodeLocation.NameStyle.None:return E+I;case WebInspector.SourceCodeLocation.NameStyle.Short:case WebInspector.SourceCodeLocation.NameStyle.Full:var R=_.displayURL,N=T===WebInspector.SourceCodeLocation.NameStyle.Full&&R?R:_.displayName;if(f===WebInspector.SourceCodeLocation.ColumnStyle.Hidden)return E+N;var L=R?":"+I:WebInspector.UIString(" (line %s)").format(I);return E+N+L;default:return console.error("Unknown nameStyle: "+T),E+I;}}_resetMappedLocation(){this._mappedLocationIsResolved=!1,this._mappedResource=null,this._mappedLineNumber=NaN,this._mappedColumnNumber=NaN}_setMappedLocation(_,S,C){this._mappedLocationIsResolved=!0,this._mappedResource=_,this._mappedLineNumber=S,this._mappedColumnNumber=C}_resolveFormattedLocation(){if(this._sourceCode&&this._sourceCode.formatterSourceMap){var _=this._sourceCode.formatterSourceMap.originalToFormatted(this._lineNumber,this._columnNumber);this._formattedLineNumber=_.lineNumber,this._formattedColumnNumber=_.columnNumber}else this._formattedLineNumber=this._lineNumber,this._formattedColumnNumber=this._columnNumber}_makeChangeAndDispatchChangeEventIfNeeded(_){var S=this._sourceCode,C=this._lineNumber,f=this._columnNumber,T=this._formattedLineNumber,E=this._formattedColumnNumber,I=this.displaySourceCode,R=this.displayLineNumber,N=this.displayColumnNumber;this._resetMappedLocation(),_&&_.call(this),this.resolveMappedLocation(),this._resolveFormattedLocation();var L=!1,D=this.displaySourceCode;I===D?D&&(R!==this.displayLineNumber||N!==this.displayColumnNumber)&&(L=!0):L=!0;var M=!1;if(L?M=!0:S===this._sourceCode?this._sourceCode&&(C!==this._lineNumber||f!==this._columnNumber)?M=!0:this._sourceCode&&(T!==this._formattedLineNumber||E!==this._formattedColumnNumber)&&(M=!0):M=!0,L||M){var P={oldSourceCode:S,oldLineNumber:C,oldColumnNumber:f,oldFormattedLineNumber:T,oldFormattedColumnNumber:E,oldDisplaySourceCode:I,oldDisplayLineNumber:R,oldDisplayColumnNumber:N};L&&this.dispatchEventToListeners(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,P),M&&this.dispatchEventToListeners(WebInspector.SourceCodeLocation.Event.LocationChanged,P)}}_sourceCodeSourceMapAdded(){this._makeChangeAndDispatchChangeEventIfNeeded(null)}_sourceCodeFormatterDidChange(){this._makeChangeAndDispatchChangeEventIfNeeded(null)}},WebInspector.SourceCodeLocation.DisplayLocationClassName="display-location",WebInspector.SourceCodeLocation.LargeColumnNumber=80,WebInspector.SourceCodeLocation.NameStyle={None:"none",Short:"short",Full:"full"},WebInspector.SourceCodeLocation.ColumnStyle={Hidden:"hidden",OnlyIfLarge:"only-if-large",Shown:"shown"},WebInspector.SourceCodeLocation.Event={LocationChanged:"source-code-location-location-changed",DisplayLocationChanged:"source-code-location-display-location-changed"},WebInspector.Timeline=class extends WebInspector.Object{constructor(_){super(),this._type=_,this.reset(!0)}static create(_){return _===WebInspector.TimelineRecord.Type.Network?new WebInspector.NetworkTimeline(_):_===WebInspector.TimelineRecord.Type.Memory?new WebInspector.MemoryTimeline(_):new WebInspector.Timeline(_)}get type(){return this._type}get startTime(){return this._startTime}get endTime(){return this._endTime}get records(){return this._records}reset(_){this._records=[],this._startTime=NaN,this._endTime=NaN,_||(this.dispatchEventToListeners(WebInspector.Timeline.Event.TimesUpdated),this.dispatchEventToListeners(WebInspector.Timeline.Event.Reset))}addRecord(_){_.updatesDynamically&&_.addEventListener(WebInspector.TimelineRecord.Event.Updated,this._recordUpdated,this),this._tryInsertingRecordInSortedOrder(_),this._updateTimesIfNeeded(_),this.dispatchEventToListeners(WebInspector.Timeline.Event.RecordAdded,{record:_})}saveIdentityToCookie(_){_[WebInspector.Timeline.TimelineTypeCookieKey]=this._type}refresh(){this.dispatchEventToListeners(WebInspector.Timeline.Event.Refreshed)}recordsInTimeRange(_,S,C){let f=this._records.lowerBound(_,(E,I)=>E-I.timestamp),T=this._records.upperBound(S,(E,I)=>E-I.timestamp);return C&&0<f&&f--,this._records.slice(f,T)}_updateTimesIfNeeded(_){var S=!1;(isNaN(this._startTime)||_.startTime<this._startTime)&&(this._startTime=_.startTime,S=!0),(isNaN(this._endTime)||this._endTime<_.endTime)&&(this._endTime=_.endTime,S=!0),S&&this.dispatchEventToListeners(WebInspector.Timeline.Event.TimesUpdated)}_recordUpdated(_){this._updateTimesIfNeeded(_.target)}_tryInsertingRecordInSortedOrder(_){let S=this._records.lastValue;if(!S||S.startTime<_.startTime||_.updatesDynamically)return void this._records.push(_);let C=this._records.length-2,f=Math.max(this._records.length-20,0);for(let T=C;T>=f;--T)if(this._records[T].startTime<_.startTime)return void this._records.insertAtIndex(_,T+1);this._records.push(_)}},WebInspector.Timeline.Event={Reset:"timeline-reset",RecordAdded:"timeline-record-added",TimesUpdated:"timeline-times-updated",Refreshed:"timeline-refreshed"},WebInspector.Timeline.TimelineTypeCookieKey="timeline-type",WebInspector.TimelineRange=class extends WebInspector.Object{constructor(_,S){super(),this._startValue=_,this._endValue=S}get startValue(){return this._startValue}set startValue(_){this._startValue=_}get endValue(){return this._endValue}set endValue(_){this._endValue=_}},WebInspector.TimelineRecord=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),_ in WebInspector.TimelineRecord.Type&&(_=WebInspector.TimelineRecord.Type[_]),this._type=_,this._startTime=S||NaN,this._endTime=C||NaN,this._callFrames=f||null,this._sourceCodeLocation=T||null,this._children=[]}get type(){return this._type}get startTime(){return this._startTime}get activeStartTime(){return this._startTime}get endTime(){return this._endTime}get duration(){return this.endTime-this.startTime}get inactiveDuration(){return this.activeStartTime-this.startTime}get activeDuration(){return this.endTime-this.activeStartTime}get updatesDynamically(){return!1}get usesActiveStartTime(){return!1}get callFrames(){return this._callFrames}get initiatorCallFrame(){if(!this._callFrames||!this._callFrames.length)return null;for(var _=0;_<this._callFrames.length;++_)if(!this._callFrames[_].nativeCode)return this._callFrames[_];return null}get sourceCodeLocation(){return this._sourceCodeLocation}get parent(){return this._parent}set parent(_){this._parent===_||(this._parent=_)}get children(){return this._children}saveIdentityToCookie(_){_[WebInspector.TimelineRecord.SourceCodeURLCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url?this._sourceCodeLocation.sourceCode.url.hash:null:null,_[WebInspector.TimelineRecord.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null,_[WebInspector.TimelineRecord.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null,_[WebInspector.TimelineRecord.TypeCookieKey]=this._type||null}},WebInspector.TimelineRecord.Event={Updated:"timeline-record-updated"},WebInspector.TimelineRecord.Type={Network:"timeline-record-type-network",Layout:"timeline-record-type-layout",Script:"timeline-record-type-script",RenderingFrame:"timeline-record-type-rendering-frame",Memory:"timeline-record-type-memory",HeapAllocations:"timeline-record-type-heap-allocations"},WebInspector.TimelineRecord.TypeIdentifier="timeline-record",WebInspector.TimelineRecord.SourceCodeURLCookieKey="timeline-record-source-code-url",WebInspector.TimelineRecord.SourceCodeLocationLineCookieKey="timeline-record-source-code-location-line",WebInspector.TimelineRecord.SourceCodeLocationColumnCookieKey="timeline-record-source-code-location-column",WebInspector.TimelineRecord.TypeCookieKey="timeline-record-type",WebInspector.AnalyzerMessage=class extends WebInspector.Object{constructor(_,S,C){super(),this._sourceCodeLocation=_,this._text=S,this._ruleIdentifier=C}get sourceCodeLocation(){return this._sourceCodeLocation}get sourceCode(){return this._sourceCodeLocation.sourceCode}get text(){return this._text}get ruleIdentifier(){return this._ruleIdentifier}},WebInspector.ApplicationCacheFrame=class extends WebInspector.Object{constructor(_,S,C){super(),this._frame=_,this._manifest=S,this._status=C}get frame(){return this._frame}get manifest(){return this._manifest}get status(){return this._status}set status(_){this._status=_}saveIdentityToCookie(_){_[WebInspector.ApplicationCacheFrame.FrameURLCookieKey]=this.frame.url,_[WebInspector.ApplicationCacheFrame.ManifestURLCookieKey]=this.manifest.manifestURL}},WebInspector.ApplicationCacheFrame.TypeIdentifier="application-cache-frame",WebInspector.ApplicationCacheFrame.FrameURLCookieKey="application-cache-frame-url",WebInspector.ApplicationCacheFrame.ManifestURLCookieKey="application-cache-frame-manifest-url",WebInspector.ApplicationCacheManifest=class extends WebInspector.Object{constructor(_){super(),this._manifestURL=_}get manifestURL(){return this._manifestURL}},WebInspector.BackForwardEntry=class extends WebInspector.Object{constructor(_,S){super(),this._contentView=_,this._tombstone=!1,this._cookie=S||{},this._scrollPositions=[],_.saveToCookie(this._cookie)}makeCopy(_){let S=new WebInspector.BackForwardEntry(this._contentView,_||this.cookie);return S._tombstone=this._tombstone,S._scrollPositions=this._scrollPositions.slice(),S}get contentView(){return this._contentView}get cookie(){return Object.shallowCopy(this._cookie)}get tombstone(){return this._tombstone}set tombstone(_){this._tombstone=_}prepareToShow(_){this._restoreFromCookie(),this.contentView.visible=!0,_&&this.contentView.shown(),this.contentView.needsLayout()}prepareToHide(){this.contentView.visible=!1,this.contentView.hidden(),this._saveScrollPositions()}isEqual(_){return!!_&&this._contentView===_._contentView&&Object.shallowEqual(this._cookie,_._cookie)}_restoreFromCookie(){this._restoreScrollPositions(),this.contentView.restoreFromCookie(this.cookie)}_restoreScrollPositions(){if(this._scrollPositions.length)for(var _=this.contentView.scrollableElements||[],S=0;S<_.length;++S){var C=this._scrollPositions[S],f=_[S];f&&(f.scrollTop=C.isScrolledToBottom?f.scrollHeight:C.scrollTop,f.scrollLeft=C.isScrolledToBottom?0:C.scrollLeft)}}_saveScrollPositions(){for(var _=this.contentView.scrollableElements||[],S=[],C=0,f;C<_.length;++C)if(f=_[C],f){let V={scrollTop:f.scrollTop,scrollLeft:f.scrollLeft};this.contentView.shouldKeepElementsScrolledToBottom&&(V.isScrolledToBottom=f.isScrolledToBottom()),S.push(V)}this._scrollPositions=S}},WebInspector.Branch=class extends WebInspector.Object{constructor(_,S,C){super(),this._displayName=_,this._revisions=S instanceof Array?S.slice():[],this._locked=C||!1}get displayName(){return this._displayName}set displayName(_){_&&(this._displayName=_)}get revisions(){return this._revisions}get locked(){return this._locked}revisionForRepresentedObject(_,S){for(var C=0,f;C<this._revisions.length;++C)if(f=this._revisions[C],f instanceof WebInspector.SourceCodeRevision&&f.sourceCode===_)return f;if(S)return null;if(_ instanceof WebInspector.SourceCode){var f=_.originalRevision.copy();return _.currentRevision=f,this.addRevision(f),f}return null}addRevision(_){this._locked||this._revisions.includes(_)||this._revisions.push(_)}removeRevision(_){this._locked||this._revisions.remove(_)}reset(){this._locked||(this._revisions=[])}fork(_){var S=this._revisions.map(function(C){return C.copy()});return new WebInspector.Branch(_,S)}apply(){for(var _=0;_<this._revisions.length;++_)this._revisions[_].apply()}revert(){for(var _=this._revisions.length-1;0<=_;--_)this._revisions[_].revert()}lock(){this._locked=!0}unlock(){this._locked=!1}},WebInspector.Breakpoint=class extends WebInspector.Object{constructor(_,S,C){if(super(),_ instanceof WebInspector.SourceCodeLocation)var f=_.sourceCode,T=f?f.contentIdentifier:null,E=f instanceof WebInspector.Script?f.id:null,I=f instanceof WebInspector.Script?f.target:null,R=_;else if(_&&"object"==typeof _){for(var T=_.contentIdentifier||_.url,N=_.lineNumber||0,L=_.columnNumber||0,R=new WebInspector.SourceCodeLocation(null,N,L),D=_.ignoreCount||0,M=_.autoContinue||!1,P=_.actions||[],O=0;O<P.length;++O)P[O]=new WebInspector.BreakpointAction(this,P[O]);S=_.disabled,C=_.condition}else console.error("Unexpected type passed to WebInspector.Breakpoint",_);this._id=null,this._contentIdentifier=T||null,this._scriptIdentifier=E||null,this._target=I||null,this._disabled=S||!1,this._condition=C||"",this._ignoreCount=D||0,this._autoContinue=M||!1,this._actions=P||[],this._resolved=!1,this._sourceCodeLocation=R,this._sourceCodeLocation.addEventListener(WebInspector.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationLocationChanged,this),this._sourceCodeLocation.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,this._sourceCodeLocationDisplayLocationChanged,this)}get identifier(){return this._id}set identifier(_){this._id=_||null}get contentIdentifier(){return this._contentIdentifier}get scriptIdentifier(){return this._scriptIdentifier}get target(){return this._target}get sourceCodeLocation(){return this._sourceCodeLocation}get resolved(){return this._resolved}set resolved(_){this._resolved===_||(this._resolved=_||!1,this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ResolvedStateDidChange))}get disabled(){return this._disabled}set disabled(_){this._disabled===_||(this._disabled=_||!1,this.dispatchEventToListeners(WebInspector.Breakpoint.Event.DisabledStateDidChange))}get condition(){return this._condition}set condition(_){this._condition===_||(this._condition=_,this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ConditionDidChange))}get ignoreCount(){return this._ignoreCount}set ignoreCount(_){0>_||this._ignoreCount===_||(this._ignoreCount=_,this.dispatchEventToListeners(WebInspector.Breakpoint.Event.IgnoreCountDidChange))}get autoContinue(){return this._autoContinue}set autoContinue(_){this._autoContinue===_||(this._autoContinue=_,this.dispatchEventToListeners(WebInspector.Breakpoint.Event.AutoContinueDidChange))}get actions(){return this._actions}get options(){return{condition:this._condition,ignoreCount:this._ignoreCount,actions:this._serializableActions(),autoContinue:this._autoContinue}}get info(){return{contentIdentifier:this._contentIdentifier,lineNumber:this._sourceCodeLocation.lineNumber,columnNumber:this._sourceCodeLocation.columnNumber,disabled:this._disabled,condition:this._condition,ignoreCount:this._ignoreCount,actions:this._serializableActions(),autoContinue:this._autoContinue}}get probeActions(){return this._actions.filter(function(_){return _.type===WebInspector.BreakpointAction.Type.Probe})}cycleToNextMode(){return this.disabled?(this.autoContinue=!1,void(this.disabled=!1)):this.autoContinue?void(this.disabled=!0):this.actions.length?void(this.autoContinue=!0):void(this.disabled=!0)}createAction(_,S,C){var f=new WebInspector.BreakpointAction(this,_,C||null);if(!S)this._actions.push(f);else{var T=this._actions.indexOf(S);-1===T?this._actions.push(f):this._actions.splice(T+1,0,f)}return this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange),f}recreateAction(_,S){var C=new WebInspector.BreakpointAction(this,_,null),f=this._actions.indexOf(S);return-1===f?null:(this._actions[f]=C,this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange),C)}removeAction(_){var S=this._actions.indexOf(_);-1===S||(this._actions.splice(S,1),!this._actions.length&&(this.autoContinue=!1),this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange))}clearActions(_){this._actions=_?this._actions.filter(function(S){return S.type!==_}):[],this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange)}saveIdentityToCookie(_){_[WebInspector.Breakpoint.ContentIdentifierCookieKey]=this.contentIdentifier,_[WebInspector.Breakpoint.LineNumberCookieKey]=this.sourceCodeLocation.lineNumber,_[WebInspector.Breakpoint.ColumnNumberCookieKey]=this.sourceCodeLocation.columnNumber}breakpointActionDidChange(_){var S=this._actions.indexOf(_);-1===S||this.dispatchEventToListeners(WebInspector.Breakpoint.Event.ActionsDidChange)}_serializableActions(){for(var _=[],S=0;S<this._actions.length;++S)_.push(this._actions[S].info);return _}_sourceCodeLocationLocationChanged(_){this.dispatchEventToListeners(WebInspector.Breakpoint.Event.LocationDidChange,_.data)}_sourceCodeLocationDisplayLocationChanged(_){this.dispatchEventToListeners(WebInspector.Breakpoint.Event.DisplayLocationDidChange,_.data)}},WebInspector.Breakpoint.DefaultBreakpointActionType=WebInspector.BreakpointAction.Type.Log,WebInspector.Breakpoint.TypeIdentifier="breakpoint",WebInspector.Breakpoint.ContentIdentifierCookieKey="breakpoint-content-identifier",WebInspector.Breakpoint.LineNumberCookieKey="breakpoint-line-number",WebInspector.Breakpoint.ColumnNumberCookieKey="breakpoint-column-number",WebInspector.Breakpoint.Event={DisabledStateDidChange:"breakpoint-disabled-state-did-change",ResolvedStateDidChange:"breakpoint-resolved-state-did-change",ConditionDidChange:"breakpoint-condition-did-change",IgnoreCountDidChange:"breakpoint-ignore-count-did-change",ActionsDidChange:"breakpoint-actions-did-change",AutoContinueDidChange:"breakpoint-auto-continue-did-change",LocationDidChange:"breakpoint-location-did-change",DisplayLocationDidChange:"breakpoint-display-location-did-change"},WebInspector.CallingContextTree=class extends WebInspector.Object{constructor(_){super(),this._type=_||WebInspector.CallingContextTree.Type.TopDown,this.reset()}get type(){return this._type}get totalNumberOfSamples(){return this._totalNumberOfSamples}reset(){this._root=new WebInspector.CallingContextTreeNode(-1,-1,-1,"<root>",null),this._totalNumberOfSamples=0}totalDurationInTimeRange(_,S){return this._root.filteredTimestampsAndDuration(_,S).duration}updateTreeWithStackTrace({timestamp:_,stackFrames:S},C){this._totalNumberOfSamples++;let f=this._root;switch(f.addTimestampAndExpressionLocation(_,C,null),this._type){case WebInspector.CallingContextTree.Type.TopDown:for(let T=S.length,E;T--;)E=S[T],f=f.findOrMakeChild(E),f.addTimestampAndExpressionLocation(_,C,E.expressionLocation||null,0===T);break;case WebInspector.CallingContextTree.Type.BottomUp:for(let T=0,E;T<S.length;++T)E=S[T],f=f.findOrMakeChild(E),f.addTimestampAndExpressionLocation(_,C,E.expressionLocation||null,0===T);break;case WebInspector.CallingContextTree.Type.TopFunctionsTopDown:for(let T=S.length;T--;){f=this._root;for(let E=T+1,I;E--;)I=S[E],f=f.findOrMakeChild(I),f.addTimestampAndExpressionLocation(_,C,I.expressionLocation||null,0===E)}break;case WebInspector.CallingContextTree.Type.TopFunctionsBottomUp:for(let T=0;T<S.length;T++){f=this._root;for(let E=T,I;E<S.length;E++)I=S[E],f=f.findOrMakeChild(I),f.addTimestampAndExpressionLocation(_,C,I.expressionLocation||null,0===E)}break;default:}}toCPUProfilePayload(_,S){let C={},f=[],T=this._root.filteredTimestampsAndDuration(_,S).timestamps.length;return this._root.forEachChild(E=>{E.hasStackTraceInTimeRange(_,S)&&f.push(E.toCPUProfileNode(T,_,S))}),C.rootNodes=f,C}forEachChild(_){this._root.forEachChild(_)}forEachNode(_){this._root.forEachNode(_)}static __test_makeTreeFromProtocolMessageObject(_){let S=new WebInspector.CallingContextTree,C=_.params.samples.stackTraces;for(let f=0;f<C.length;f++)S.updateTreeWithStackTrace(C[f]);return S}__test_matchesStackTrace(_){let S=this.__test_buildLeafLinkedLists();outer:for(let C of S){for(let f of _){for(let T of Object.getOwnPropertyNames(f))if(f[T]!==C[T])continue outer;C=C.parent}return!0}return!1}__test_buildLeafLinkedLists(){let _=[];return this._root.__test_buildLeafLinkedLists(null,_),_}},WebInspector.CallingContextTree.Type={TopDown:Symbol("TopDown"),BottomUp:Symbol("BottomUp"),TopFunctionsTopDown:Symbol("TopFunctionsTopDown"),TopFunctionsBottomUp:Symbol("TopFunctionsBottomUp")},WebInspector.CallingContextTreeNode=class extends WebInspector.Object{constructor(_,S,C,f,T,E){super(),this._children={},this._sourceID=_,this._line=S,this._column=C,this._name=f,this._url=T,this._uid=WebInspector.CallingContextTreeNode.__uid++,this._timestamps=[],this._durations=[],this._leafTimestamps=[],this._leafDurations=[],this._expressionLocations={},this._hash=E||WebInspector.CallingContextTreeNode._hash(this)}static _hash(_){return _.name+":"+_.sourceID+":"+_.line+":"+_.column}get sourceID(){return this._sourceID}get line(){return this._line}get column(){return this._column}get name(){return this._name}get uid(){return this._uid}get url(){return this._url}get hash(){return this._hash}hasChildrenInTimeRange(_,S){for(let C of Object.getOwnPropertyNames(this._children)){let f=this._children[C];if(f.hasStackTraceInTimeRange(_,S))return!0}return!1}hasStackTraceInTimeRange(_,S){if(_>S)return!1;let C=this._timestamps,f=C.length;if(!f)return!1;let T=C.lowerBound(_);if(T===f)return!1;let E=C[T]<=S;return E}filteredTimestampsAndDuration(_,S){let C=this._timestamps.lowerBound(_),f=this._timestamps.upperBound(S),T=0;for(let E=C;E<f;++E)T+=this._durations[E];return{timestamps:this._timestamps.slice(C,f),duration:T}}filteredLeafTimestampsAndDuration(_,S){let C=this._leafTimestamps.lowerBound(_),f=this._leafTimestamps.upperBound(S),T=0;for(let E=C;E<f;++E)T+=this._leafDurations[E];return{leafTimestamps:this._leafTimestamps.slice(C,f),leafDuration:T}}hasChildren(){return!isEmptyObject(this._children)}findOrMakeChild(_){let S=WebInspector.CallingContextTreeNode._hash(_),C=this._children[S];return C?C:(C=new WebInspector.CallingContextTreeNode(_.sourceID,_.line,_.column,_.name,_.url,S),this._children[S]=C,C)}addTimestampAndExpressionLocation(_,S,C,f){if(this._timestamps.push(_),this._durations.push(S),f&&(this._leafTimestamps.push(_),this._leafDurations.push(S)),!!C){let{line:T,column:E}=C,I=T+":"+E,R=this._expressionLocations[I];R||(R=[],this._expressionLocations[I]=R),R.push(_)}}forEachChild(_){for(let S of Object.getOwnPropertyNames(this._children))_(this._children[S])}forEachNode(_){_(this),this.forEachChild(function(S){S.forEachNode(_)})}equals(_){return this._hash===_.hash}toCPUProfileNode(_,S,C){let f=[];this.forEachChild(N=>{N.hasStackTraceInTimeRange(S,C)&&f.push(N.toCPUProfileNode(_,S,C))});let T={id:this._uid,functionName:this._name,url:this._url,lineNumber:this._line,columnNumber:this._column,children:f},E=[],I=Number.MAX_VALUE,R=Number.MIN_VALUE;for(let N=0,L;N<this._timestamps.length;N++)L=this._timestamps[N],S<=L&&L<=C&&(E.push(L),I=Math.min(I,L),R=Math.max(R,L));return T.callInfo={callCount:E.length,startTime:I,endTime:R,totalTime:E.length/_*(C-S)},T}__test_buildLeafLinkedLists(_,S){let C={name:this._name,url:this._url,parent:_};this.hasChildren()?this.forEachChild(f=>{f.__test_buildLeafLinkedLists(C,S)}):S.push(C)}},WebInspector.CallingContextTreeNode.__uid=0,WebInspector.CSSCompletions=class{constructor(_,S){if(this._values=[],this._longhands={},this._shorthands={},_.length&&"string"==typeof _[0])this._values=this._values.concat(_);else for(var C of _){var f=C.name;this._values.push(f);var T=C.longhands;if(T){this._longhands[f]=T;for(var E=0;E<T.length;++E){var I=T[E],R=this._shorthands[I];R||(R=[],this._shorthands[I]=R),R.push(f)}}}this._values.sort(),this._acceptEmptyPrefix=S}static requestCSSCompletions(){WebInspector.CSSCompletions.cssNameCompletions||window.CSSAgent&&(CSSAgent.getSupportedCSSProperties(function(C,f){function T(F){return F.replace(/^-[^-]+-/,"").replace(/\(\)$/,"").toLowerCase()}function E(F){var V=T(F);R[V]=!0,N[V]=!0}function I(F){var V=CodeMirror.resolveMode(F);V.propertyKeywords=R,V.valueKeywords=N,V.colorKeywords=L,CodeMirror.defineMIME(F,V)}if(!C&&(WebInspector.CSSCompletions.cssNameCompletions=new WebInspector.CSSCompletions(f,!1),WebInspector.CSSKeywordCompletions.addCustomCompletions(f),!!window.CodeMirror)){var R={},N={inherit:!0,initial:!0,unset:!0,revert:!0,"var":!0},L={};for(var D of f)E(D.name);for(var M in WebInspector.CSSKeywordCompletions._propertyKeywordMap)for(var P=WebInspector.CSSKeywordCompletions._propertyKeywordMap[M],O=0;O<P.length;++O)isNaN(+P[O])&&(N[T(P[O])]=!0);WebInspector.CSSKeywordCompletions._colors.forEach(function(F){L[T(F)]=!0}),I("text/css"),I("text/x-scss")}}),CSSAgent.getSupportedSystemFontFamilyNames&&CSSAgent.getSupportedSystemFontFamilyNames(function(C,f){C||(WebInspector.CSSKeywordCompletions.addPropertyCompletionValues("font-family",f),WebInspector.CSSKeywordCompletions.addPropertyCompletionValues("font",f))}))}get values(){return this._values}startsWith(_){var S=this._firstIndexOfPrefix(_);if(-1===S)return[];for(var C=[];S<this._values.length&&this._values[S].startsWith(_);)C.push(this._values[S++]);return C}_firstIndexOfPrefix(_){if(!this._values.length)return-1;if(!_)return this._acceptEmptyPrefix?0:-1;var S=this._values.length-1,C=0,f;do{var T=S+C>>1;if(this._values[T].startsWith(_)){f=T;break}this._values[T]<_?C=T+1:S=T-1}while(C<=S);if(f===void 0)return-1;for(;f&&this._values[f-1].startsWith(_);)f--;return f}keySet(){return this._keySet||(this._keySet=this._values.keySet()),this._keySet}next(_,S){return this._closest(_,S,1)}previous(_,S){return this._closest(_,S,-1)}_closest(_,S,C){if(!_)return"";var f=this._values.indexOf(_);if(-1===f)return"";if(!S)return f=(f+this._values.length+C)%this._values.length,this._values[f];var T=this.startsWith(S),E=T.indexOf(_);return E=(E+T.length+C)%T.length,T[E]}isShorthandPropertyName(_){return _ in this._longhands}shorthandsForLonghand(_){return this._shorthands[_]||[]}isValidPropertyName(_){return this._values.includes(_)}propertyRequiresWebkitPrefix(_){return this._values.includes("-webkit-"+_)&&!this._values.includes(_)}getClosestPropertyName(_){var S=[{distance:Infinity,name:null}];for(var C of this._values){var f=_.levenshteinDistance(C);f<S[0].distance?S=[{distance:f,name:C}]:f===S[0].distance&&S.push({distance:f,name:C})}return!!(3>S.length)&&S[0].name}},WebInspector.CSSCompletions.cssNameCompletions=null,WebInspector.CSSKeywordCompletions={},WebInspector.CSSKeywordCompletions.forProperty=function(u){let _=["initial","unset","revert","var()"],S="-"!==u.charAt(0);return u in WebInspector.CSSKeywordCompletions._propertyKeywordMap?_=_.concat(WebInspector.CSSKeywordCompletions._propertyKeywordMap[u]):S&&"-webkit-"+u in WebInspector.CSSKeywordCompletions._propertyKeywordMap&&(_=_.concat(WebInspector.CSSKeywordCompletions._propertyKeywordMap["-webkit-"+u])),u in WebInspector.CSSKeywordCompletions._colorAwareProperties?_=_.concat(WebInspector.CSSKeywordCompletions._colors):S&&"-webkit-"+u in WebInspector.CSSKeywordCompletions._colorAwareProperties?_=_.concat(WebInspector.CSSKeywordCompletions._colors):u.endsWith("color")&&(_=_.concat(WebInspector.CSSKeywordCompletions._colors)),u in WebInspector.CSSKeywordCompletions.InheritedProperties?_.push("inherit"):S&&"-webkit-"+u in WebInspector.CSSKeywordCompletions.InheritedProperties&&_.push("inherit"),_.includes(WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder)&&WebInspector.CSSCompletions.cssNameCompletions&&(_.remove(WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder),_=_.concat(WebInspector.CSSCompletions.cssNameCompletions.values)),new WebInspector.CSSCompletions(_,!0)},WebInspector.CSSKeywordCompletions.forFunction=function(u){let _=["var()"];return"var"===u?_=[]:"env"==u?_=_.concat(["safe-area-inset-top","safe-area-inset-right","safe-area-inset-bottom","safe-area-inset-left"]):"image-set"===u?_.push("url()"):"repeat"===u?_=_.concat(["auto","auto-fill","auto-fit","min-content","max-content"]):u.endsWith("gradient")&&(_=_.concat(["to","left","right","top","bottom"]),_=_.concat(WebInspector.CSSKeywordCompletions._colors)),new WebInspector.CSSCompletions(_,!0)},WebInspector.CSSKeywordCompletions.addCustomCompletions=function(u){for(var _ of u)_.values&&WebInspector.CSSKeywordCompletions.addPropertyCompletionValues(_.name,_.values)},WebInspector.CSSKeywordCompletions.addPropertyCompletionValues=function(u,_){var S=WebInspector.CSSKeywordCompletions._propertyKeywordMap[u];if(!S)return void(WebInspector.CSSKeywordCompletions._propertyKeywordMap[u]=_);var C=new Set;for(var f of S)C.add(f);for(var f of _)C.add(f);WebInspector.CSSKeywordCompletions._propertyKeywordMap[u]=[...C.values()]},WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder="__all-properties__",WebInspector.CSSKeywordCompletions.InheritedProperties=["azimuth","border-collapse","border-spacing","caption-side","clip-rule","color","color-interpolation","color-interpolation-filters","color-rendering","cursor","direction","elevation","empty-cells","fill","fill-opacity","fill-rule","font","font-family","font-size","font-style","font-variant","font-variant-numeric","font-weight","font-optical-sizing","glyph-orientation-horizontal","glyph-orientation-vertical","hanging-punctuation","image-rendering","kerning","letter-spacing","line-height","list-style","list-style-image","list-style-position","list-style-type","marker","marker-end","marker-mid","marker-start","orphans","pitch","pitch-range","pointer-events","quotes","resize","richness","shape-rendering","speak","speak-header","speak-numeral","speak-punctuation","speech-rate","stress","stroke","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","tab-size","text-align","text-anchor","text-decoration","text-indent","text-rendering","text-shadow","text-transform","visibility","voice-family","volume","white-space","widows","word-break","word-spacing","word-wrap","writing-mode","-webkit-aspect-ratio","-webkit-border-horizontal-spacing","-webkit-border-vertical-spacing","-webkit-box-direction","-webkit-color-correction","font-feature-settings","-webkit-font-kerning","-webkit-font-smoothing","-webkit-font-variant-ligatures","-webkit-hyphenate-character","-webkit-hyphenate-limit-after","-webkit-hyphenate-limit-before","-webkit-hyphenate-limit-lines","-webkit-hyphens","-webkit-line-align","-webkit-line-box-contain","-webkit-line-break","-webkit-line-grid","-webkit-line-snap","-webkit-locale","-webkit-nbsp-mode","-webkit-print-color-adjust","-webkit-rtl-ordering","-webkit-text-combine","-webkit-text-decorations-in-effect","-webkit-text-emphasis","-webkit-text-emphasis-color","-webkit-text-emphasis-position","-webkit-text-emphasis-style","-webkit-text-fill-color","-webkit-text-orientation","-webkit-text-security","-webkit-text-size-adjust","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-text-stroke-width","-webkit-user-modify","-webkit-user-select","-webkit-writing-mode","-webkit-cursor-visibility","image-orientation","image-resolution","overflow-wrap","-webkit-text-align-last","-webkit-text-justify","-webkit-ruby-position","-webkit-text-decoration-line","font-synthesis","-webkit-overflow-scrolling","-webkit-touch-callout","-webkit-tap-highlight-color"].keySet(),WebInspector.CSSKeywordCompletions._colors=["aqua","black","blue","fuchsia","gray","green","lime","maroon","navy","olive","orange","purple","red","silver","teal","white","yellow","transparent","currentcolor","grey","aliceblue","antiquewhite","aquamarine","azure","beige","bisque","blanchedalmond","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkgrey","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkslategrey","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dimgrey","dodgerblue","firebrick","floralwhite","forestgreen","gainsboro","ghostwhite","gold","goldenrod","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightgrey","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightslategrey","lightsteelblue","lightyellow","limegreen","linen","magenta","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","oldlace","olivedrab","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","rebeccapurple","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","skyblue","slateblue","slategray","slategrey","snow","springgreen","steelblue","tan","thistle","tomato","turquoise","violet","wheat","whitesmoke","yellowgreen","rgb()","rgba()","hsl()","hsla()"],WebInspector.CSSKeywordCompletions._colorAwareProperties=["background","background-color","background-image","border","border-color","border-top","border-right","border-bottom","border-left","border-top-color","border-right-color","border-bottom-color","border-left-color","box-shadow","color","fill","outline","outline-color","stroke","text-line-through","text-line-through-color","text-overline","text-overline-color","text-shadow","text-underline","text-underline-color","-webkit-box-shadow","-webkit-column-rule","-webkit-column-rule-color","-webkit-text-emphasis","-webkit-text-emphasis-color","-webkit-text-fill-color","-webkit-text-stroke","-webkit-text-stroke-color","-webkit-text-decoration-color","-webkit-tap-highlight-color"].keySet(),WebInspector.CSSKeywordCompletions._propertyKeywordMap={"table-layout":["auto","fixed"],visibility:["hidden","visible","collapse"],"text-underline":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],content:["list-item","close-quote","no-close-quote","no-open-quote","open-quote","attr()","counter()","counters()","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"list-style-image":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],clear:["none","left","right","both"],"fill-rule":["nonzero","evenodd"],"stroke-linecap":["butt","round","square"],"stroke-linejoin":["round","miter","bevel"],"baseline-shift":["baseline","sub","super"],"border-bottom-width":["medium","thick","thin","calc()"],"margin-top-collapse":["collapse","separate","discard"],"-webkit-box-orient":["horizontal","vertical","inline-axis","block-axis"],"font-stretch":["normal","wider","narrower","ultra-condensed","extra-condensed","condensed","semi-condensed","semi-expanded","expanded","extra-expanded","ultra-expanded"],"font-optical-sizing":["auto","none"],"-webkit-color-correction":["default","srgb"],"border-left-width":["medium","thick","thin","calc()"],"-webkit-writing-mode":["lr","rl","tb","lr-tb","rl-tb","tb-rl","horizontal-tb","vertical-rl","vertical-lr","horizontal-bt"],"text-line-through-mode":["continuous","skip-white-space"],"text-overline-mode":["continuous","skip-white-space"],"text-underline-mode":["continuous","skip-white-space"],"text-line-through-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"text-overline-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"text-underline-style":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave"],"border-collapse":["collapse","separate"],"border-top-width":["medium","thick","thin","calc()"],"outline-color":["invert","-webkit-focus-ring-color"],"outline-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double","auto"],cursor:["auto","default","none","context-menu","help","pointer","progress","wait","cell","crosshair","text","vertical-text","alias","copy","move","no-drop","not-allowed","grab","grabbing","e-resize","n-resize","ne-resize","nw-resize","s-resize","se-resize","sw-resize","w-resize","ew-resize","ns-resize","nesw-resize","nwse-resize","col-resize","row-resize","all-scroll","zoom-in","zoom-out","-webkit-grab","-webkit-grabbing","-webkit-zoom-in","-webkit-zoom-out","url()","image-set()"],"border-width":["medium","thick","thin","calc()"],size:["a3","a4","a5","b4","b5","landscape","ledger","legal","letter","portrait"],background:["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()","repeat","repeat-x","repeat-y","no-repeat","space","round","scroll","fixed","local","auto","contain","cover","top","right","left","bottom","center","border-box","padding-box","content-box"],"background-image":["none","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"background-size":["auto","contain","cover"],"background-attachment":["scroll","fixed","local"],"background-repeat":["repeat","repeat-x","repeat-y","no-repeat","space","round"],"background-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","hue","saturation","color","luminosity"],"background-position":["top","right","left","bottom","center"],"background-origin":["border-box","padding-box","content-box"],"background-clip":["border-box","padding-box","content-box"],direction:["ltr","rtl"],"enable-background":["accumulate","new"],float:["none","left","right"],"hanging-punctuation":["none","first","last","allow-end","force-end"],"overflow-x":["hidden","auto","visible","overlay","scroll","marquee"],"overflow-y":["hidden","auto","visible","overlay","scroll","marquee","-webkit-paged-x","-webkit-paged-y"],overflow:["hidden","auto","visible","overlay","scroll","marquee","-webkit-paged-x","-webkit-paged-y"],"margin-bottom-collapse":["collapse","separate","discard"],"-webkit-box-reflect":["none","left","right","above","below"],"text-rendering":["auto","optimizeSpeed","optimizeLegibility","geometricPrecision"],"text-align":["-webkit-auto","left","right","center","justify","-webkit-left","-webkit-right","-webkit-center","-webkit-match-parent","start","end"],"list-style-position":["outside","inside"],"margin-bottom":["auto"],"color-interpolation":["linearrgb"],"word-wrap":["normal","break-word"],"font-weight":["normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900"],"font-synthesis":["none","weight","style"],"margin-before-collapse":["collapse","separate","discard"],"text-overline-width":["normal","medium","auto","thick","thin","calc()"],"text-transform":["none","capitalize","uppercase","lowercase"],"border-right-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"border-left-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font-style":["italic","oblique","normal"],speak:["none","normal","spell-out","digits","literal-punctuation","no-punctuation"],"text-line-through":["none","dotted","dashed","solid","double","dot-dash","dot-dot-dash","wave","continuous","skip-white-space"],"color-rendering":["auto","optimizeSpeed","optimizeQuality"],"list-style-type":["none","disc","circle","square","decimal","decimal-leading-zero","arabic-indic","binary","bengali","cambodian","khmer","devanagari","gujarati","gurmukhi","kannada","lower-hexadecimal","lao","malayalam","mongolian","myanmar","octal","oriya","persian","urdu","telugu","tibetan","thai","upper-hexadecimal","lower-roman","upper-roman","lower-greek","lower-alpha","lower-latin","upper-alpha","upper-latin","afar","ethiopic-halehame-aa-et","ethiopic-halehame-aa-er","amharic","ethiopic-halehame-am-et","amharic-abegede","ethiopic-abegede-am-et","cjk-earthly-branch","cjk-heavenly-stem","ethiopic","ethiopic-halehame-gez","ethiopic-abegede","ethiopic-abegede-gez","hangul-consonant","hangul","lower-norwegian","oromo","ethiopic-halehame-om-et","sidama","ethiopic-halehame-sid-et","somali","ethiopic-halehame-so-et","tigre","ethiopic-halehame-tig","tigrinya-er","ethiopic-halehame-ti-er","tigrinya-er-abegede","ethiopic-abegede-ti-er","tigrinya-et","ethiopic-halehame-ti-et","tigrinya-et-abegede","ethiopic-abegede-ti-et","upper-greek","upper-norwegian","asterisks","footnotes","hebrew","armenian","lower-armenian","upper-armenian","georgian","cjk-ideographic","hiragana","katakana","hiragana-iroha","katakana-iroha"],"-webkit-text-combine":["none","horizontal"],outline:["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],font:["caption","icon","menu","message-box","small-caption","-webkit-mini-control","-webkit-small-control","-webkit-control","status-bar","italic","oblique","small-caps","normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900","xx-small","x-small","small","medium","large","x-large","xx-large","-webkit-xxx-large","smaller","larger","serif","sans-serif","cursive","fantasy","monospace","-webkit-body","-webkit-pictograph","-apple-system","-apple-system-headline","-apple-system-body","-apple-system-subheadline","-apple-system-footnote","-apple-system-caption1","-apple-system-caption2","-apple-system-short-headline","-apple-system-short-body","-apple-system-short-subheadline","-apple-system-short-footnote","-apple-system-short-caption1","-apple-system-tall-body","-apple-system-title0","-apple-system-title1","-apple-system-title2","-apple-system-title3","-apple-system-title4","system-ui"],"dominant-baseline":["middle","auto","central","text-before-edge","text-after-edge","ideographic","alphabetic","hanging","mathematical","use-script","no-change","reset-size"],display:["none","inline","block","list-item","compact","inline-block","table","inline-table","table-row-group","table-header-group","table-footer-group","table-row","table-column-group","table-column","table-cell","table-caption","-webkit-box","-webkit-inline-box","-wap-marquee","flex","inline-flex","grid","inline-grid"],"image-rendering":["auto","optimizeSpeed","optimizeQuality","-webkit-crisp-edges","-webkit-optimize-contrast","crisp-edges","pixelated"],"alignment-baseline":["baseline","middle","auto","before-edge","after-edge","central","text-before-edge","text-after-edge","ideographic","alphabetic","hanging","mathematical"],"outline-width":["medium","thick","thin","calc()"],"text-line-through-width":["normal","medium","auto","thick","thin"],"box-align":["baseline","center","stretch","start","end"],"box-shadow":["none"],"text-shadow":["none"],"-webkit-box-shadow":["none"],"border-right-width":["medium","thick","thin"],"border-top-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"line-height":["normal"],"counter-increment":["none"],"counter-reset":["none"],"text-overflow":["clip","ellipsis"],"-webkit-box-direction":["normal","reverse"],"margin-after-collapse":["collapse","separate","discard"],"break-after":["left","right","recto","verso","auto","avoid","page","column","region","avoid-page","avoid-column","avoid-region"],"break-before":["left","right","recto","verso","auto","avoid","page","column","region","avoid-page","avoid-column","avoid-region"],"break-inside":["auto","avoid","avoid-page","avoid-column","avoid-region"],"page-break-after":["left","right","auto","always","avoid"],"page-break-before":["left","right","auto","always","avoid"],"page-break-inside":["auto","avoid"],"-webkit-column-break-after":["left","right","auto","always","avoid"],"-webkit-column-break-before":["left","right","auto","always","avoid"],"-webkit-column-break-inside":["auto","avoid"],"-webkit-hyphens":["none","auto","manual"],"border-image":["repeat","stretch","url()","linear-gradient()","radial-gradient()","repeating-linear-gradient()","repeating-radial-gradient()","-webkit-canvas()","cross-fade()","image-set()"],"border-image-repeat":["repeat","stretch","space","round"],"-webkit-mask-box-image-repeat":["repeat","stretch","space","round"],position:["absolute","fixed","relative","static","-webkit-sticky"],"font-family":["serif","sans-serif","cursive","fantasy","monospace","-webkit-body","-webkit-pictograph","-apple-system","-apple-system-headline","-apple-system-body","-apple-system-subheadline","-apple-system-footnote","-apple-system-caption1","-apple-system-caption2","-apple-system-short-headline","-apple-system-short-body","-apple-system-short-subheadline","-apple-system-short-footnote","-apple-system-short-caption1","-apple-system-tall-body","-apple-system-title0","-apple-system-title1","-apple-system-title2","-apple-system-title3","-apple-system-title4","system-ui"],"text-overflow-mode":["clip","ellipsis"],"border-bottom-style":["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"unicode-bidi":["normal","bidi-override","embed","plaintext","isolate","isolate-override"],"clip-rule":["nonzero","evenodd"],"margin-left":["auto"],"margin-top":["auto"],zoom:["normal","document","reset"],"z-index":["auto"],width:["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],height:["intrinsic","min-intrinsic","calc()"],"max-width":["none","intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"min-width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"max-height":["none","intrinsic","min-intrinsic","calc()"],"min-height":["intrinsic","min-intrinsic","calc()"],"-webkit-logical-width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"-webkit-logical-height":["intrinsic","min-intrinsic","calc()"],"-webkit-max-logical-width":["none","intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"-webkit-min-logical-width":["intrinsic","min-intrinsic","-webkit-min-content","-webkit-max-content","-webkit-fill-available","-webkit-fit-content","calc()"],"-webkit-max-logical-height":["none","intrinsic","min-intrinsic","calc()"],"-webkit-min-logical-height":["intrinsic","min-intrinsic","calc()"],"empty-cells":["hide","show"],"pointer-events":["none","all","auto","visible","visiblepainted","visiblefill","visiblestroke","painted","fill","stroke"],"letter-spacing":["normal","calc()"],"word-spacing":["normal","calc()"],"-webkit-font-kerning":["auto","normal","none"],"-webkit-font-smoothing":["none","auto","antialiased","subpixel-antialiased"],border:["none","hidden","inset","groove","ridge","outset","dotted","dashed","solid","double"],"font-size":["xx-small","x-small","small","medium","large","x-large","xx-large","-webkit-xxx-large","smaller","larger"],"font-variant":["small-caps","normal"],"font-variant-numeric":["normal","ordinal","slashed-zero","lining-nums","oldstyle-nums","proportional-nums","tabular-nums","diagonal-fractions","stacked-fractions"],"vertical-align":["baseline","middle","sub","super","text-top","text-bottom","top","bottom","-webkit-baseline-middle"],"white-space":["normal","nowrap","pre","pre-line","pre-wrap"],"word-break":["normal","break-all","break-word"],"text-underline-width":["normal","medium","auto","thick","thin","calc()"],"text-indent":["-webkit-each-line","-webkit-hanging"],"-webkit-box-lines":["single","multiple"],clip:["auto","rect()"],"clip-path":["none","url()","circle()","ellipse()","inset()","polygon()","margin-box","border-box","padding-box","content-box"],"shape-outside":["none","url()","circle()","ellipse()","inset()","polygon()","margin-box","border-box","padding-box","content-box"],orphans:["auto"],widows:["auto"],margin:["auto"],page:["auto"],perspective:["none"],"perspective-origin":["none","left","right","bottom","top","center"],"-webkit-marquee-increment":["small","large","medium"],"-webkit-marquee-direction":["left","right","auto","reverse","forwards","backwards","ahead","up","down"],"-webkit-marquee-style":["none","scroll","slide","alternate"],"-webkit-marquee-repetition":["infinite"],"-webkit-marquee-speed":["normal","slow","fast"],"margin-right":["auto"],"marquee-speed":["normal","slow","fast"],"-webkit-text-emphasis":["circle","filled","open","dot","double-circle","triangle","sesame"],"-webkit-text-emphasis-style":["circle","filled","open","dot","double-circle","triangle","sesame"],"-webkit-text-emphasis-position":["over","under","left","right"],transform:["none","scale()","scaleX()","scaleY()","scale3d()","rotate()","rotateX()","rotateY()","rotateZ()","rotate3d()","skew()","skewX()","skewY()","translate()","translateX()","translateY()","translateZ()","translate3d()","matrix()","matrix3d()","perspective()"],"transform-style":["flat","preserve-3d"],"-webkit-cursor-visibility":["auto","auto-hide"],"text-decoration":["none","underline","overline","line-through","blink"],"-webkit-text-decorations-in-effect":["none","underline","overline","line-through","blink"],"-webkit-text-decoration-line":["none","underline","overline","line-through","blink"],"-webkit-text-decoration-style":["solid","double","dotted","dashed","wavy"],"-webkit-text-decoration-skip":["auto","none","objects","ink"],"-webkit-text-underline-position":["auto","alphabetic","under"],"image-resolution":["from-image","snap"],"-webkit-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","plus-darker","plus-lighter","hue","saturation","color","luminosity"],"mix-blend-mode":["normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","plus-darker","plus-lighter","hue","saturation","color","luminosity"],mix:["auto","normal","multiply","screen","overlay","darken","lighten","color-dodge","color-burn","hard-light","soft-light","difference","exclusion","plus-darker","plus-lighter","hue","saturation","color","luminosity","clear","copy","destination","source-over","destination-over","source-in","destination-in","source-out","destination-out","source-atop","destination-atop","xor"],geometry:["detached","attached","grid()"],"overflow-wrap":["normal","break-word"],transition:["none","ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()","all",WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder],"transition-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()"],"transition-property":["all","none",WebInspector.CSSKeywordCompletions.AllPropertyNamesPlaceholder],"-webkit-column-progression":["normal","reverse"],"-webkit-box-decoration-break":["slice","clone"],"align-content":["auto","baseline","last-baseline","space-between","space-around","space-evenly","stretch","center","start","end","flex-start","flex-end","left","right","true","safe"],"justify-content":["auto","baseline","last-baseline","space-between","space-around","space-evenly","stretch","center","start","end","flex-start","flex-end","left","right","true","safe"],"align-items":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"align-self":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"justify-items":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"justify-self":["auto","stretch","baseline","last-baseline","center","start","end","self-start","self-end","flex-start","flex-end","left","right","true","safe"],"flex-direction":["row","row-reverse","column","column-reverse"],"flex-wrap":["nowrap","wrap","wrap-reverse"],"flex-flow":["row","row-reverse","column","column-reverse","nowrap","wrap","wrap-reverse"],flex:["none"],"flex-basis":["auto"],grid:["none"],"grid-area":["auto"],"grid-auto-columns":["auto","-webkit-max-content","-webkit-min-content","minmax()"],"grid-auto-flow":["row","column","dense"],"grid-auto-rows":["auto","-webkit-max-content","-webkit-min-content","minmax()"],"grid-column":["auto"],"grid-column-start":["auto"],"grid-column-end":["auto"],"grid-row":["auto"],"grid-row-start":["auto"],"grid-row-end":["auto"],"grid-template":["none"],"grid-template-areas":["none"],"grid-template-columns":["none","auto","-webkit-max-content","-webkit-min-content","minmax()","repeat()"],"grid-template-rows":["none","auto","-webkit-max-content","-webkit-min-content","minmax()","repeat()"],"-webkit-ruby-position":["after","before","inter-character"],"-webkit-text-align-last":["auto","start","end","left","right","center","justify"],"-webkit-text-justify":["auto","none","inter-word","inter-ideograph","inter-cluster","distribute","kashida"],"max-zoom":["auto"],"min-zoom":["auto"],orientation:["auto","portait","landscape"],"scroll-snap-align":["none","start","center","end"],"scroll-snap-type":["none","mandatory","proximity","x","y","inline","block","both"],"user-zoom":["zoom","fixed"],"-webkit-app-region":["drag","no-drag"],"-webkit-line-break":["auto","loose","normal","strict","after-white-space"],"-webkit-background-composite":["clear","copy","source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","xor","plus-darker","plus-lighter"],"-webkit-mask-composite":["clear","copy","source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","xor","plus-darker","plus-lighter"],"-webkit-animation-direction":["normal","alternate","reverse","alternate-reverse"],"-webkit-animation-fill-mode":["none","forwards","backwards","both"],"-webkit-animation-iteration-count":["infinite"],"-webkit-animation-play-state":["paused","running"],"-webkit-animation-timing-function":["ease","linear","ease-in","ease-out","ease-in-out","step-start","step-end","steps()","cubic-bezier()","spring()"],"-webkit-column-span":["all","none","calc()"],"-webkit-region-break-after":["auto","always","avoid","left","right"],"-webkit-region-break-before":["auto","always","avoid","left","right"],"-webkit-region-break-inside":["auto","avoid"],"-webkit-region-overflow":["auto","break"],"-webkit-backface-visibility":["visible","hidden"],resize:["none","both","horizontal","vertical","auto"],"caption-side":["top","bottom","left","right"],"box-sizing":["border-box","content-box"],"-webkit-alt":["attr()"],"-webkit-border-fit":["border","lines"],"-webkit-line-align":["none","edges"],"-webkit-line-snap":["none","baseline","contain"],"-webkit-nbsp-mode":["normal","space"],"-webkit-print-color-adjust":["exact","economy"],"-webkit-rtl-ordering":["logical","visual"],"-webkit-text-security":["disc","circle","square","none"],"-webkit-user-drag":["auto","none","element"],"-webkit-user-modify":["read-only","read-write","read-write-plaintext-only"],"-webkit-user-select":["auto","none","text","all"],"-webkit-text-stroke-width":["medium","thick","thin","calc()"],"-webkit-border-start-width":["medium","thick","thin","calc()"],"-webkit-border-end-width":["medium","thick","thin","calc()"],"-webkit-border-before-width":["medium","thick","thin","calc()"],"-webkit-border-after-width":["medium","thick","thin","calc()"],"-webkit-column-rule-width":["medium","thick","thin","calc()"],"-webkit-aspect-ratio":["auto","from-dimensions","from-intrinsic","/"],filter:["none","grayscale()","sepia()","saturate()","hue-rotate()","invert()","opacity()","brightness()","contrast()","blur()","drop-shadow()","custom()"],"-webkit-backdrop-filter":["none","grayscale()","sepia()","saturate()","hue-rotate()","invert()","opacity()","brightness()","contrast()","blur()","drop-shadow()","custom()"],"-webkit-column-count":["auto","calc()"],"-webkit-column-gap":["normal","calc()"],"-webkit-column-axis":["horizontal","vertical","auto"],"-webkit-column-width":["auto","calc()"],"-webkit-column-fill":["auto","balance"],"-webkit-hyphenate-character":["none"],"-webkit-hyphenate-limit-after":["auto"],"-webkit-hyphenate-limit-before":["auto"],"-webkit-hyphenate-limit-lines":["no-limit"],"-webkit-line-grid":["none"],"-webkit-locale":["auto"],"-webkit-text-orientation":["sideways","sideways-right","vertical-right","upright"],"-webkit-line-box-contain":["block","inline","font","glyphs","replaced","inline-box","none"],"font-feature-settings":["normal"],"-webkit-font-variant-ligatures":["normal","common-ligatures","no-common-ligatures","discretionary-ligatures","no-discretionary-ligatures","historical-ligatures","no-historical-ligatures"],"-webkit-animation-trigger":["auto","container-scroll()"],"-webkit-text-size-adjust":["none","auto"],"-webkit-touch-callout":["default","none"],"-webkit-overflow-scrolling":["auto","touch"]},WebInspector.CSSMedia=class extends WebInspector.Object{constructor(_,S,C){super(),this._type=_||null,this._text=S||"",this._sourceCodeLocation=C||null}get type(){return this._type}get text(){return this._text}get sourceCodeLocation(){return this._sourceCodeLocation}},WebInspector.CSSMedia.Type={MediaRule:"css-media-type-media-rule",ImportRule:"css-media-type-import-rule",LinkedStyleSheet:"css-media-type-linked-stylesheet",InlineStyleSheet:"css-media-type-inline-stylesheet"},WebInspector.CSSProperty=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I,R,N,L,D){super(),this._ownerStyle=null,this._index=_,this.update(S,C,f,T,E,I,R,N,L,D,!0)}static isInheritedPropertyName(_){return!!(_ in WebInspector.CSSKeywordCompletions.InheritedProperties)||_.startsWith("--")}get ownerStyle(){return this._ownerStyle}set ownerStyle(_){this._ownerStyle=_||null}get index(){return this._index}set index(_){this._index=_}update(_,S,C,f,T,E,I,R,N,L,D){_=_||"",S=S||"",C=C||"",f=f||"",T=T||!1,E=E||!1,I=I||!1,R=R||!1,N=N||!1;var M=!1;D||(M=this._name!==S||this._value!==C||this._priority!==f||this._enabled!==T||this._implicit!==I||this._anonymous!==R||this._valid!==N),D?this._overridden=E:this.overridden=E,this._text=_,this._name=S,this._value=C,this._priority=f,this._enabled=T,this._implicit=I,this._anonymous=R,this._inherited=WebInspector.CSSProperty.isInheritedPropertyName(S),this._valid=N,this._variable=S.startsWith("--"),this._styleSheetTextRange=L||null,this._relatedShorthandProperty=null,this._relatedLonghandProperties=[],delete this._styleDeclarationTextRange,delete this._canonicalName,delete this._hasOtherVendorNameOrKeyword,M&&this.dispatchEventToListeners(WebInspector.CSSProperty.Event.Changed)}get synthesizedText(){var _=this.name;if(!_)return"";var S=this.priority;return _+": "+this.value.trim()+(S?" !"+S:"")+";"}get text(){return this._text||this.synthesizedText}get name(){return this._name}get canonicalName(){return this._canonicalName?this._canonicalName:(this._canonicalName=WebInspector.cssStyleManager.canonicalNameForPropertyName(this.name),this._canonicalName)}get value(){return this._value}get important(){return"important"===this.priority}get priority(){return this._priority}get enabled(){return this._enabled&&this._ownerStyle&&(!isNaN(this._index)||this._ownerStyle.type===WebInspector.CSSStyleDeclaration.Type.Computed)}get overridden(){return this._overridden}set overridden(_){function S(){delete this._overriddenStatusChangedTimeout,this._overridden===C||this.dispatchEventToListeners(WebInspector.CSSProperty.Event.OverriddenStatusChanged)}if(_=_||!1,this._overridden!==_){var C=this._overridden;this._overridden=_,this._overriddenStatusChangedTimeout||(this._overriddenStatusChangedTimeout=setTimeout(S.bind(this),0))}}get implicit(){return this._implicit}set implicit(_){this._implicit=_}get anonymous(){return this._anonymous}get inherited(){return this._inherited}get valid(){return this._valid}get variable(){return this._variable}get styleSheetTextRange(){return this._styleSheetTextRange}get styleDeclarationTextRange(){if("_styleDeclarationTextRange"in this)return this._styleDeclarationTextRange;if(!this._ownerStyle||!this._styleSheetTextRange)return null;var _=this._ownerStyle.styleSheetTextRange;if(!_)return null;var S=this._styleSheetTextRange.startLine-_.startLine,C=this._styleSheetTextRange.endLine-_.startLine,f=this._styleSheetTextRange.startColumn;S||(f-=_.startColumn);var T=this._styleSheetTextRange.endColumn;return C||(T-=_.startColumn),this._styleDeclarationTextRange=new WebInspector.TextRange(S,f,C,T),this._styleDeclarationTextRange}get relatedShorthandProperty(){return this._relatedShorthandProperty}set relatedShorthandProperty(_){this._relatedShorthandProperty=_||null}get relatedLonghandProperties(){return this._relatedLonghandProperties}addRelatedLonghandProperty(_){this._relatedLonghandProperties.push(_)}clearRelatedLonghandProperties(){this._relatedLonghandProperties=[]}hasOtherVendorNameOrKeyword(){return"_hasOtherVendorNameOrKeyword"in this?this._hasOtherVendorNameOrKeyword:(this._hasOtherVendorNameOrKeyword=WebInspector.cssStyleManager.propertyNameHasOtherVendorPrefix(this.name)||WebInspector.cssStyleManager.propertyValueHasOtherVendorKeyword(this.value),this._hasOtherVendorNameOrKeyword)}},WebInspector.CSSProperty.Event={Changed:"css-property-changed",OverriddenStatusChanged:"css-property-overridden-status-changed"},WebInspector.CSSRule=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I,R,N,L){super(),this._nodeStyles=_,this._ownerStyleSheet=S||null,this._id=C||null,this._type=f||null,this.update(T,E,I,R,N,L,!0)}get id(){return this._id}get ownerStyleSheet(){return this._ownerStyleSheet}get editable(){return!!this._id&&(this._type===WebInspector.CSSStyleSheet.Type.Author||this._type===WebInspector.CSSStyleSheet.Type.Inspector)}update(_,S,C,f,T,E,I){_=_||null,S=S||"",C=C||[],f=f||[],T=T||null,E=E||[];var R=!1;I||(R=this._selectorText!==S||!Array.shallowEqual(this._selectors,C)||!Array.shallowEqual(this._matchedSelectorIndices,f)||this._style!==T||!!this._sourceCodeLocation!=!!_||this._mediaList.length!==E.length),this._style&&(this._style.ownerRule=null),this._sourceCodeLocation=_,this._selectorText=S,this._selectors=C,this._matchedSelectorIndices=f,this._mostSpecificSelector=null,this._style=T,this._mediaList=E,this._matchedSelectors=null,this._matchedSelectorText=null,this._style&&(this._style.ownerRule=this),R&&this.dispatchEventToListeners(WebInspector.CSSRule.Event.Changed)}get type(){return this._type}get sourceCodeLocation(){return this._sourceCodeLocation}get selectorText(){return this._selectorText}set selectorText(_){return this.editable?this._selectorText===_?void this._selectorResolved(!0):void this._nodeStyles.changeRuleSelector(this,_).then(this._selectorResolved.bind(this),this._selectorRejected.bind(this)):void 0}get selectors(){return this._selectors}get matchedSelectorIndices(){return this._matchedSelectorIndices}get matchedSelectors(){return this._matchedSelectors?this._matchedSelectors:(this._matchedSelectors=this._selectors.filter(function(_,S){return this._matchedSelectorIndices.includes(S)},this),this._matchedSelectors)}get matchedSelectorText(){return"_matchedSelectorText"in this?this._matchedSelectorText:(this._matchedSelectorText=this.matchedSelectors.map(function(_){return _.text}).join(", "),this._matchedSelectorText)}hasMatchedPseudoElementSelector(){return this.nodeStyles&&this.nodeStyles.node&&this.nodeStyles.node.isPseudoElement()||this.matchedSelectors.some(_=>_.isPseudoElementSelector())}get style(){return this._style}get mediaList(){return this._mediaList}get mediaText(){if(!this._mediaList.length)return"";let _="";for(let S of this._mediaList)_+=S.text;return _}isEqualTo(_){return!!_&&Object.shallowEqual(this._id,_.id)}get mostSpecificSelector(){return this._mostSpecificSelector||(this._mostSpecificSelector=this._determineMostSpecificSelector()),this._mostSpecificSelector}selectorIsGreater(_){var S=this.mostSpecificSelector;return!!S&&S.isGreaterThan(_)}get nodeStyles(){return this._nodeStyles}_determineMostSpecificSelector(){if(!this._selectors||!this._selectors.length)return null;var _=this.matchedSelectors;_.length||(_=this._selectors);var S=_[0];for(var C of _)C.isGreaterThan(S)&&(S=C);return S}_selectorRejected(_){this.dispatchEventToListeners(WebInspector.CSSRule.Event.SelectorChanged,{valid:!_})}_selectorResolved(_){this.dispatchEventToListeners(WebInspector.CSSRule.Event.SelectorChanged,{valid:!!_})}},WebInspector.CSSRule.Event={Changed:"css-rule-changed",SelectorChanged:"css-rule-invalid-selector"},WebInspector.CSSSelector=class extends WebInspector.Object{constructor(_,S,C){super(),this._text=_,this._specificity=S||null,this._dynamic=C||!1}get text(){return this._text}get specificity(){return this._specificity}get dynamic(){return this._dynamic}isGreaterThan(_){if(!_||!_.specificity)return!0;for(var S=0;S<this._specificity.length;++S)if(this._specificity[S]!==_.specificity[S])return this._specificity[S]>_.specificity[S];return!1}isPseudoElementSelector(){return WebInspector.CSSStyleManager.PseudoElementNames.some(_=>this._text.includes(`:${_}`))}},WebInspector.CSSStyleDeclaration=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I,R,N){super(),this._nodeStyles=_,this._ownerRule=null,this._ownerStyleSheet=S||null,this._id=C||null,this._type=f||null,this._node=T||null,this._inherited=E||!1,this._pendingProperties=[],this._propertyNameMap={},this._initialText=I,this._hasModifiedInitialText=!1,this.update(I,R,N,!0)}get id(){return this._id}get ownerStyleSheet(){return this._ownerStyleSheet}get type(){return this._type}get inherited(){return this._inherited}get node(){return this._node}get editable(){return!!this._id&&(this._type===WebInspector.CSSStyleDeclaration.Type.Rule?this._ownerRule&&this._ownerRule.editable:!(this._type!==WebInspector.CSSStyleDeclaration.Type.Inline)&&!this._node.isInUserAgentShadowTree())}update(_,S,C,f){function T(){this.dispatchEventToListeners(WebInspector.CSSStyleDeclaration.Event.PropertiesChanged,{addedProperties:P,removedProperties:D})}_=_||"",S=S||[];var E=this._properties||[],I=this._text;this._text=_,this._properties=S,this._styleSheetTextRange=C,this._propertyNameMap={},delete this._visibleProperties;for(var R=this.editable,N=0,L;N<this._properties.length;++N)L=this._properties[N],L.ownerStyle=this,R?this._pendingProperties.remove(L):this._propertyNameMap[L.name]=L;for(var D=[],N=0,M;N<E.length;++N)M=E[N],this._properties.includes(M)||(M.index=NaN,D.push(M),R&&this._pendingProperties.push(M));if(!f){for(var P=[],N=0;N<this._properties.length;++N)E.includes(this._properties[N])||P.push(this._properties[N]);I&&this._text&&I===this._text&&!P.length&&!D.length||setTimeout(T.bind(this),0)}}get ownerRule(){return this._ownerRule}set ownerRule(_){this._ownerRule=_||null}get text(){return this._text}set text(_){if(this._text!==_){let S=WebInspector.CSSStyleDeclarationTextEditor.PrefixWhitespace+_.trim();if(this._text!==S){(S===WebInspector.CSSStyleDeclarationTextEditor.PrefixWhitespace||this._type===WebInspector.CSSStyleDeclaration.Type.Inline)&&(_=S);let C=_!==this._initialText;C!==this._hasModifiedInitialText&&(this._hasModifiedInitialText=C,this.dispatchEventToListeners(WebInspector.CSSStyleDeclaration.Event.InitialTextModified)),this._nodeStyles.changeStyleText(this,_)}}}resetText(){this.text=this._initialText}get modified(){return this._hasModifiedInitialText}get properties(){return this._properties}get visibleProperties(){return this._visibleProperties?this._visibleProperties:(this._visibleProperties=this._properties.filter(function(_){return!!_.styleDeclarationTextRange}),this._visibleProperties)}get pendingProperties(){return this._pendingProperties}get styleSheetTextRange(){return this._styleSheetTextRange}get mediaList(){return this._ownerRule?this._ownerRule.mediaList:[]}get selectorText(){return this._ownerRule?this._ownerRule.selectorText:this._node.appropriateSelectorFor(!0)}propertyForName(_,S){function C(E){for(var I=0,R;I<E.length;++I)R=E[I],R.canonicalName!==_&&R.name!==_||f&&!f.overridden&&R.overridden||(f=R)}if(!_)return null;if(!this.editable)return this._propertyNameMap[_]||null;var f=null;if(C(this._properties),f)return f;if(S||!this.editable)return null;if(C(this._pendingProperties,!0),f)return f;var T=new WebInspector.CSSProperty(NaN,null,_);return T.ownerStyle=this,this._pendingProperties.push(T),T}generateCSSRuleString(){let _=WebInspector.indentString(),S="",C=this.mediaList,f=C.length;for(let T=f-1;0<=T;--T)S+=_.repeat(f-T-1)+"@media "+C[T].text+" {\n";S+=_.repeat(f)+this.selectorText+" {\n";for(let T of this._properties)T.anonymous||(S+=_.repeat(f+1)+T.text.trim(),S.endsWith(";")||(S+=";"),S+="\n");for(let T=f;0<T;--T)S+=_.repeat(T)+"}\n";return S+="}",S}isInspectorRule(){return this._ownerRule&&this._ownerRule.type===WebInspector.CSSStyleSheet.Type.Inspector}hasProperties(){return!!this._properties.length}get nodeStyles(){return this._nodeStyles}},WebInspector.CSSStyleDeclaration.Event={PropertiesChanged:"css-style-declaration-properties-changed",InitialTextModified:"css-style-declaration-initial-text-modified"},WebInspector.CSSStyleDeclaration.Type={Rule:"css-style-declaration-type-rule",Inline:"css-style-declaration-type-inline",Attribute:"css-style-declaration-type-attribute",Computed:"css-style-declaration-type-computed"},WebInspector.CSSStyleSheet=class extends WebInspector.SourceCode{constructor(_){super(),this._id=_||null,this._url=null,this._parentFrame=null,this._origin=null,this._startLineNumber=0,this._startColumnNumber=0,this._inlineStyleAttribute=!1,this._inlineStyleTag=!1,this._hasInfo=!1}static resetUniqueDisplayNameNumbers(){WebInspector.CSSStyleSheet._nextUniqueDisplayNameNumber=1}get id(){return this._id}get parentFrame(){return this._parentFrame}get origin(){return this._origin}get url(){return this._url}get urlComponents(){return this._urlComponents||(this._urlComponents=parseURL(this._url)),this._urlComponents}get mimeType(){return"text/css"}get displayName(){return this._url?WebInspector.displayNameForURL(this._url,this.urlComponents):(this._uniqueDisplayNameNumber||(this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++),WebInspector.UIString("Anonymous StyleSheet %d").format(this._uniqueDisplayNameNumber))}get startLineNumber(){return this._startLineNumber}get startColumnNumber(){return this._startColumnNumber}hasInfo(){return this._hasInfo}isInspectorStyleSheet(){return this._origin===WebInspector.CSSStyleSheet.Type.Inspector}isInlineStyleTag(){return this._inlineStyleTag}isInlineStyleAttributeStyleSheet(){return this._inlineStyleAttribute}markAsInlineStyleAttributeStyleSheet(){this._inlineStyleAttribute=!0}offsetSourceCodeLocation(_){if(!_)return null;if(!this._hasInfo)return _;let S=_.sourceCode,C=this._startLineNumber+_.lineNumber,f=this._startColumnNumber+_.columnNumber;return S.createSourceCodeLocation(C,f)}updateInfo(_,S,C,f,T,E){this._hasInfo=!0,this._url=_||null,this._urlComponents=void 0,this._parentFrame=S||null,this._origin=C,this._inlineStyleTag=f,this._startLineNumber=T,this._startColumnNumber=E}get revisionForRequestedContent(){return this.currentRevision}handleCurrentRevisionContentChange(){this._id&&(this._ignoreNextContentDidChangeNotification=!0,CSSAgent.setStyleSheetText(this._id,this.currentRevision.content,function(S){S||(DOMAgent.markUndoableState(),this.dispatchEventToListeners(WebInspector.CSSStyleSheet.Event.ContentDidChange))}.bind(this)))}requestContentFromBackend(){return this._id?CSSAgent.getStyleSheetText(this._id):Promise.reject(new Error("There is no identifier to request content with."))}noteContentDidChange(){return this._ignoreNextContentDidChangeNotification?(this._ignoreNextContentDidChangeNotification=!1,!1):(this.markContentAsStale(),this.dispatchEventToListeners(WebInspector.CSSStyleSheet.Event.ContentDidChange),!0)}},WebInspector.CSSStyleSheet._nextUniqueDisplayNameNumber=1,WebInspector.CSSStyleSheet.Event={ContentDidChange:"stylesheet-content-did-change"},WebInspector.CSSStyleSheet.Type={Author:"css-stylesheet-type-author",User:"css-stylesheet-type-user",UserAgent:"css-stylesheet-type-user-agent",Inspector:"css-stylesheet-type-inspector"},WebInspector.CallFrame=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I,R,N){super(),this._isConsoleEvaluation=C&&isWebInspectorConsoleEvaluationScript(C.sourceCode.sourceURL),this._isConsoleEvaluation&&(f=WebInspector.UIString("Console Evaluation"),R=!0),this._target=_,this._id=S||null,this._sourceCodeLocation=C||null,this._functionName=f||"",this._thisObject=T||null,this._scopeChain=E||[],this._nativeCode=I||!1,this._programCode=R||!1,this._isTailDeleted=N||!1}get target(){return this._target}get id(){return this._id}get sourceCodeLocation(){return this._sourceCodeLocation}get functionName(){return this._functionName}get nativeCode(){return this._nativeCode}get programCode(){return this._programCode}get thisObject(){return this._thisObject}get scopeChain(){return this._scopeChain}get isTailDeleted(){return this._isTailDeleted}get isConsoleEvaluation(){return this._isConsoleEvaluation}saveIdentityToCookie(){}collectScopeChainVariableNames(_){function S(E){for(var I=0;E&&I<E.length;++I)C[E[I].name]=!0;--f||_(C)}for(var C={this:!0,__proto__:null},f=this._scopeChain.length,T=0;T<this._scopeChain.length;++T)this._scopeChain[T].objects[0].deprecatedGetAllProperties(S)}mergedScopeChain(){function _(R){return!!R.hash&&!(R.type!==WebInspector.ScopeChainNode.Type.Closure)&&R.hash!==T&&(T=R.hash,R.__baseClosureScope=!0,!0)}function S(R,N,L){return R&&N&&R.hash&&N.hash&&!(R.type!==WebInspector.ScopeChainNode.Type.Closure)&&!(N.type!==WebInspector.ScopeChainNode.Type.Closure)&&!(R.hash!==N.hash)&&(L&&R.hash===L.hash?!1:!0)}let C=[],f=this._scopeChain.slice(),T=null,E=null,I=null;for(let R=f.length-1,N;0<=R;--R)if(N=f[R],_(N),S(N,E,I)){let L=WebInspector.ScopeChainNode.Type.Closure,D=E.objects.concat(N.objects),M=new WebInspector.ScopeChainNode(L,D,N.name,N.location);M.__baseClosureScope=!0,C.pop(),C.push(M),I=M,E=null}else C.push(N),I=null,E=N;C=C.reverse();for(let R of C)if(R.type===WebInspector.ScopeChainNode.Type.Closure){R.name===this._functionName&&R.convertToLocalScope();break}return C}static functionNameFromPayload(_){let S=_.functionName;return"global code"===S?WebInspector.UIString("Global Code"):"eval code"===S?WebInspector.UIString("Eval Code"):"module code"===S?WebInspector.UIString("Module Code"):S}static programCodeFromPayload(_){return _.functionName.endsWith(" code")}static fromDebuggerPayload(_,S,C,f){let T=S.callFrameId,E=WebInspector.RemoteObject.fromPayload(S.this,_),I=WebInspector.CallFrame.functionNameFromPayload(S),N=WebInspector.CallFrame.programCodeFromPayload(S),L=S.isTailDeleted;return new WebInspector.CallFrame(_,T,f,I,E,C,!1,N,L)}static fromPayload(_,S){let{url:C,scriptId:f}=S,T=!1,E=null,I=WebInspector.CallFrame.functionNameFromPayload(S),R=WebInspector.CallFrame.programCodeFromPayload(S);if("[native code]"===C)T=!0,C=null;else if(C||f){let P=null;if(f&&(P=WebInspector.debuggerManager.scriptForIdentifier(f,_),P&&P.resource&&(P=P.resource)),P||(P=WebInspector.frameResourceManager.resourceForURL(C)),P||(P=WebInspector.debuggerManager.scriptsForURL(C,_)[0]),P){let O=S.lineNumber-1;E=P.createLazySourceCodeLocation(O,S.columnNumber)}else T=!0,C=null}return new WebInspector.CallFrame(_,null,E,I,null,null,T,R,!1)}},WebInspector.Canvas=class extends WebInspector.Object{constructor(_,S,C,{domNode:f,cssCanvasName:T,contextAttributes:E,memoryCost:I}={}){super(),this._identifier=_,this._contextType=S,this._frame=C,this._domNode=f||null,this._cssCanvasName=T||"",this._contextAttributes=E||{},this._memoryCost=I||NaN,this._cssCanvasClientNodes=null}static fromPayload(_){let S=null;switch(_.contextType){case CanvasAgent.ContextType.Canvas2D:S=WebInspector.Canvas.ContextType.Canvas2D;break;case CanvasAgent.ContextType.WebGL:S=WebInspector.Canvas.ContextType.WebGL;break;case CanvasAgent.ContextType.WebGL2:S=WebInspector.Canvas.ContextType.WebGL2;break;case CanvasAgent.ContextType.WebGPU:S=WebInspector.Canvas.ContextType.WebGPU;break;default:console.error("Invalid canvas context type",_.contextType);}let C=WebInspector.frameResourceManager.frameForIdentifier(_.frameId);return new WebInspector.Canvas(_.canvasId,S,C,{domNode:_.nodeId?WebInspector.domTreeManager.nodeForId(_.nodeId):null,cssCanvasName:_.cssCanvasName,contextAttributes:_.contextAttributes,memoryCost:_.memoryCost})}static displayNameForContextType(_){switch(_){case WebInspector.Canvas.ContextType.Canvas2D:return WebInspector.UIString("2D");case WebInspector.Canvas.ContextType.WebGL:return WebInspector.unlocalizedString("WebGL");case WebInspector.Canvas.ContextType.WebGL2:return WebInspector.unlocalizedString("WebGL2");case WebInspector.Canvas.ContextType.WebGPU:return WebInspector.unlocalizedString("WebGPU");default:console.error("Invalid canvas context type",_);}}static resetUniqueDisplayNameNumbers(){WebInspector.Canvas._nextUniqueDisplayNameNumber=1}get identifier(){return this._identifier}get contextType(){return this._contextType}get frame(){return this._frame}get cssCanvasName(){return this._cssCanvasName}get contextAttributes(){return this._contextAttributes}get memoryCost(){return this._memoryCost}set memoryCost(_){_===this._memoryCost||(this._memoryCost=_,this.dispatchEventToListeners(WebInspector.Canvas.Event.MemoryChanged))}get displayName(){if(this._cssCanvasName)return WebInspector.UIString("CSS canvas \u201C%s\u201D").format(this._cssCanvasName);if(this._domNode){let _=this._domNode.escapedIdSelector;if(_)return WebInspector.UIString("Canvas %s").format(_)}return this._uniqueDisplayNameNumber||(this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++),WebInspector.UIString("Canvas %d").format(this._uniqueDisplayNameNumber)}requestNode(_){return this._domNode?void _(this._domNode):void(WebInspector.domTreeManager.ensureDocument(),CanvasAgent.requestNode(this._identifier,(S,C)=>{return S?void _(null):void(this._domNode=WebInspector.domTreeManager.nodeForId(C),_(this._domNode))}))}requestContent(_){CanvasAgent.requestContent(this._identifier,(S,C)=>{return S?void _(null):void _(C)})}requestCSSCanvasClientNodes(_){return this._cssCanvasName?this._cssCanvasClientNodes?void _(this._cssCanvasClientNodes):void(WebInspector.domTreeManager.ensureDocument(),CanvasAgent.requestCSSCanvasClientNodes(this._identifier,(S,C)=>{return S?void _([]):void(C=Array.isArray(C)?C:[],this._cssCanvasClientNodes=C.map(f=>WebInspector.domTreeManager.nodeForId(f)),_(this._cssCanvasClientNodes))})):void _([])}saveIdentityToCookie(_){_[WebInspector.Canvas.FrameURLCookieKey]=this._frame.url.hash,this._cssCanvasName?_[WebInspector.Canvas.CSSCanvasNameCookieKey]=this._cssCanvasName:this._domNode&&(_[WebInspector.Canvas.NodePathCookieKey]=this._domNode.path)}cssCanvasClientNodesChanged(){this._cssCanvasName&&(this._cssCanvasClientNodes=null,this.dispatchEventToListeners(WebInspector.Canvas.Event.CSSCanvasClientNodesChanged))}},WebInspector.Canvas._nextUniqueDisplayNameNumber=1,WebInspector.Canvas.FrameURLCookieKey="canvas-frame-url",WebInspector.Canvas.CSSCanvasNameCookieKey="canvas-css-canvas-name",WebInspector.Canvas.ContextType={Canvas2D:"canvas-2d",WebGL:"webgl",WebGL2:"webgl2",WebGPU:"webgpu"},WebInspector.Canvas.ResourceSidebarType="resource-type-canvas",WebInspector.Canvas.Event={MemoryChanged:"canvas-memory-changed",CSSCanvasClientNodesChanged:"canvas-css-canvas-client-nodes-changed"},WebInspector.Collection=class extends WebInspector.Object{constructor(_){super(),this._items=new Set,this._typeVerifier=_||WebInspector.Collection.TypeVerifier.Any}get items(){return this._items}get typeVerifier(){return this._typeVerifier}add(_){let S=this._typeVerifier(_);S&&(this._items.add(_),this.itemAdded(_),this.dispatchEventToListeners(WebInspector.Collection.Event.ItemAdded,{item:_}))}remove(_){this._items.delete(_);this.itemRemoved(_),this.dispatchEventToListeners(WebInspector.Collection.Event.ItemRemoved,{item:_})}clear(){let _=new Set(this._items);this._items.clear(),this.itemsCleared(_);for(let S of _)this.dispatchEventToListeners(WebInspector.Collection.Event.ItemRemoved,{item:S})}toArray(){return Array.from(this._items)}toJSON(){return this.toArray()}itemAdded(){}itemRemoved(){}itemsCleared(){}},WebInspector.Collection.Event={ItemAdded:"collection-item-added",ItemRemoved:"collection-item-removed"},WebInspector.Collection.TypeVerifier={Any:()=>!0,ContentFlow:u=>u instanceof WebInspector.ContentFlow,Frame:u=>u instanceof WebInspector.Frame,Resource:u=>u instanceof WebInspector.Resource,Script:u=>u instanceof WebInspector.Script,CSSStyleSheet:u=>u instanceof WebInspector.CSSStyleSheet,Canvas:u=>u instanceof WebInspector.Canvas},WebInspector.CollectionEntry=class extends WebInspector.Object{constructor(_,S){super(),this._key=_,this._value=S}static fromPayload(_,S){return _.key&&(_.key=WebInspector.RemoteObject.fromPayload(_.key,S)),_.value&&(_.value=WebInspector.RemoteObject.fromPayload(_.value,S)),new WebInspector.CollectionEntry(_.key,_.value)}get key(){return this._key}get value(){return this._value}},WebInspector.CollectionEntryPreview=class extends WebInspector.Object{constructor(_,S){super(),this._key=_,this._value=S}static fromPayload(_){return _.key&&(_.key=WebInspector.ObjectPreview.fromPayload(_.key)),_.value&&(_.value=WebInspector.ObjectPreview.fromPayload(_.value)),new WebInspector.CollectionEntryPreview(_.key,_.value)}get keyPreview(){return this._key}get valuePreview(){return this._value}},WebInspector.Color=class{constructor(_,S){this.format=_,_===WebInspector.Color.Format.HSL||_===WebInspector.Color.Format.HSLA?this._hsla=S:this._rgba=S,this.valid=!S.some(isNaN)}static fromString(_){let S=_.toLowerCase().replace(/%|\s+/g,"");if(["transparent","rgba(0,0,0,0)","hsla(0,0,0,0)"].includes(S)){let I=new WebInspector.Color(WebInspector.Color.Format.Keyword,[0,0,0,0]);return I.keyword="transparent",I.original=_,I}let f=/^(?:#([0-9a-f]{3,8})|rgb\(([^)]+)\)|(\w+)|hsl\(([^)]+)\))$/i,T=_.match(f);if(T){if(T[1]){let I=T[1].toUpperCase(),R=I.length;return 3===R?new WebInspector.Color(WebInspector.Color.Format.ShortHEX,[parseInt(I.charAt(0)+I.charAt(0),16),parseInt(I.charAt(1)+I.charAt(1),16),parseInt(I.charAt(2)+I.charAt(2),16),1]):6===R?new WebInspector.Color(WebInspector.Color.Format.HEX,[parseInt(I.substring(0,2),16),parseInt(I.substring(2,4),16),parseInt(I.substring(4,6),16),1]):4===R?new WebInspector.Color(WebInspector.Color.Format.ShortHEXAlpha,[parseInt(I.charAt(0)+I.charAt(0),16),parseInt(I.charAt(1)+I.charAt(1),16),parseInt(I.charAt(2)+I.charAt(2),16),parseInt(I.charAt(3)+I.charAt(3),16)/255]):8===R?new WebInspector.Color(WebInspector.Color.Format.HEXAlpha,[parseInt(I.substring(0,2),16),parseInt(I.substring(2,4),16),parseInt(I.substring(4,6),16),parseInt(I.substring(6,8),16)/255]):null}if(T[2]){let I=T[2].split(/\s*,\s*/);return 3===I.length?new WebInspector.Color(WebInspector.Color.Format.RGB,[parseInt(I[0]),parseInt(I[1]),parseInt(I[2]),1]):null}if(T[3]){let I=T[3].toLowerCase();if(!WebInspector.Color.Keywords.hasOwnProperty(I))return null;let R=new WebInspector.Color(WebInspector.Color.Format.Keyword,WebInspector.Color.Keywords[I].concat(1));return R.keyword=I,R.original=_,R}if(T[4]){let I=T[4].replace(/%/g,"").split(/\s*,\s*/);return 3===I.length?new WebInspector.Color(WebInspector.Color.Format.HSL,[parseInt(I[0]),parseInt(I[1]),parseInt(I[2]),1]):null}}let E=/^(?:rgba\(([^)]+)\)|hsla\(([^)]+)\))$/i;if(T=_.match(E),T){if(T[1]){let I=T[1].split(/\s*,\s*/);return 4===I.length?new WebInspector.Color(WebInspector.Color.Format.RGBA,[parseInt(I[0]),parseInt(I[1]),parseInt(I[2]),Number.constrain(parseFloat(I[3]),0,1)]):null}if(T[2]){let I=T[2].replace(/%/g,"").split(/\s*,\s*/);return 4===I.length?new WebInspector.Color(WebInspector.Color.Format.HSLA,[parseInt(I[0]),parseInt(I[1]),parseInt(I[2]),Number.constrain(parseFloat(I[3]),0,1)]):null}}return null}static rgb2hsv(_,S,C){_/=255,S/=255,C/=255;let f=Math.min(Math.min(_,S),C),T=Math.max(Math.max(_,S),C),E=T-f,I,R;return 0==E?I=0:T===_?I=60*((S-C)/E)%360:T===S?I=60*((C-_)/E)+120:T===C&&(I=60*((_-S)/E)+240),0>I&&(I+=360),R=0===T?0:1-f/T,[I,R,T]}static hsv2rgb(_,S,C){if(0===S)return[C,C,C];_/=60;let f=Math.floor(_),T=[C*(1-S),C*(1-S*(_-f)),C*(1-S*(1-(_-f)))],E;switch(f){case 0:E=[C,T[2],T[0]];break;case 1:E=[T[1],C,T[0]];break;case 2:E=[T[0],C,T[2]];break;case 3:E=[T[0],T[1],C];break;case 4:E=[T[2],T[0],C];break;default:E=[C,T[0],T[1]];}return E}nextFormat(_){return _=_||this.format,_===WebInspector.Color.Format.Original||_===WebInspector.Color.Format.HEX||_===WebInspector.Color.Format.HEXAlpha?this.simple?WebInspector.Color.Format.RGB:WebInspector.Color.Format.RGBA:_===WebInspector.Color.Format.RGB||_===WebInspector.Color.Format.RGBA?this.simple?WebInspector.Color.Format.HSL:WebInspector.Color.Format.HSLA:_===WebInspector.Color.Format.HSL||_===WebInspector.Color.Format.HSLA?this.isKeyword()?WebInspector.Color.Format.Keyword:this.simple?this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEX:WebInspector.Color.Format.HEX:this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEXAlpha:WebInspector.Color.Format.HEXAlpha:_===WebInspector.Color.Format.ShortHEX?WebInspector.Color.Format.HEX:_===WebInspector.Color.Format.ShortHEXAlpha?WebInspector.Color.Format.HEXAlpha:_===WebInspector.Color.Format.Keyword?this.simple?this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEX:WebInspector.Color.Format.HEX:this.canBeSerializedAsShortHEX()?WebInspector.Color.Format.ShortHEXAlpha:WebInspector.Color.Format.HEXAlpha:(console.error("Unknown color format."),null)}get alpha(){return this._rgba?this._rgba[3]:this._hsla[3]}get simple(){return 1===this.alpha}get rgb(){let _=this.rgba.slice();return _.pop(),_}get hsl(){let _=this.hsla.slice();return _.pop(),_}get rgba(){return this._rgba||(this._rgba=this._hslaToRGBA(this._hsla)),this._rgba}get hsla(){return this._hsla||(this._hsla=this._rgbaToHSLA(this.rgba)),this._hsla}copy(){switch(this.format){case WebInspector.Color.Format.RGB:case WebInspector.Color.Format.HEX:case WebInspector.Color.Format.ShortHEX:case WebInspector.Color.Format.HEXAlpha:case WebInspector.Color.Format.ShortHEXAlpha:case WebInspector.Color.Format.Keyword:case WebInspector.Color.Format.RGBA:return new WebInspector.Color(this.format,this.rgba);case WebInspector.Color.Format.HSL:case WebInspector.Color.Format.HSLA:return new WebInspector.Color(this.format,this.hsla);}}toString(_){switch(_||(_=this.format),_){case WebInspector.Color.Format.Original:return this._toOriginalString();case WebInspector.Color.Format.RGB:return this._toRGBString();case WebInspector.Color.Format.RGBA:return this._toRGBAString();case WebInspector.Color.Format.HSL:return this._toHSLString();case WebInspector.Color.Format.HSLA:return this._toHSLAString();case WebInspector.Color.Format.HEX:return this._toHEXString();case WebInspector.Color.Format.ShortHEX:return this._toShortHEXString();case WebInspector.Color.Format.HEXAlpha:return this._toHEXAlphaString();case WebInspector.Color.Format.ShortHEXAlpha:return this._toShortHEXAlphaString();case WebInspector.Color.Format.Keyword:return this._toKeywordString();}throw"invalid color format"}isKeyword(){if(this.keyword)return!0;if(!this.simple)return Array.shallowEqual(this._rgba,[0,0,0,0])||Array.shallowEqual(this._hsla,[0,0,0,0]);let _=this._rgba&&this._rgba.slice(0,3)||this._hslToRGB(this._hsla);return Object.keys(WebInspector.Color.Keywords).some(S=>Array.shallowEqual(WebInspector.Color.Keywords[S],_))}canBeSerializedAsShortHEX(){let _=this.rgba||this._hslaToRGBA(this._hsla),S=this._componentToHexValue(_[0]);if(S[0]!==S[1])return!1;let C=this._componentToHexValue(_[1]);if(C[0]!==C[1])return!1;let f=this._componentToHexValue(_[2]);if(f[0]!==f[1])return!1;if(!this.simple){let T=this._componentToHexValue(Math.round(255*_[3]));if(T[0]!==T[1])return!1}return!0}_toOriginalString(){return this.original||this._toKeywordString()}_toKeywordString(){if(this.keyword)return this.keyword;let _=this.rgba;if(!this.simple)return 0===_[0]&&0===_[1]&&0===_[2]&&0===_[3]?"transparent":this._toRGBAString();let S=WebInspector.Color.Keywords;for(let C in S)if(S.hasOwnProperty(C)){let U=S[C];if(U[0]===_[0]&&U[1]===_[1]&&U[2]===_[2])return C}return this._toRGBString()}_toShortHEXString(){if(!this.simple)return this._toRGBAString();let _=this.rgba,S=this._componentToHexValue(_[0]),C=this._componentToHexValue(_[1]),f=this._componentToHexValue(_[2]);return S[0]===S[1]&&C[0]===C[1]&&f[0]===f[1]?"#"+S[0]+C[0]+f[0]:"#"+S+C+f}_toHEXString(){if(!this.simple)return this._toRGBAString();let _=this.rgba,S=this._componentToHexValue(_[0]),C=this._componentToHexValue(_[1]),f=this._componentToHexValue(_[2]);return"#"+S+C+f}_toShortHEXAlphaString(){let _=this.rgba,S=this._componentToHexValue(_[0]),C=this._componentToHexValue(_[1]),f=this._componentToHexValue(_[2]),T=this._componentToHexValue(Math.round(255*_[3]));return S[0]===S[1]&&C[0]===C[1]&&f[0]===f[1]&&T[0]===T[1]?"#"+S[0]+C[0]+f[0]+T[0]:"#"+S+C+f+T}_toHEXAlphaString(){let _=this.rgba,S=this._componentToHexValue(_[0]),C=this._componentToHexValue(_[1]),f=this._componentToHexValue(_[2]),T=this._componentToHexValue(Math.round(255*_[3]));return"#"+S+C+f+T}_toRGBString(){if(!this.simple)return this._toRGBAString();let _=this.rgba.slice(0,-1);return _=_.map(S=>S.maxDecimals(2)),"rgb("+_.join(", ")+")"}_toRGBAString(){let _=this.rgba;return _=_.map(S=>S.maxDecimals(2)),"rgba("+_.join(", ")+")"}_toHSLString(){if(!this.simple)return this._toHSLAString();let _=this.hsla;return _=_.map(S=>S.maxDecimals(2)),"hsl("+_[0]+", "+_[1]+"%, "+_[2]+"%)"}_toHSLAString(){let _=this.hsla;return _=_.map(S=>S.maxDecimals(2)),"hsla("+_[0]+", "+_[1]+"%, "+_[2]+"%, "+_[3]+")"}_componentToNumber(_){return Number.constrain(_,0,255)}_componentToHexValue(_){let S=this._componentToNumber(_).toString(16);return 1===S.length&&(S="0"+S),S}_rgbToHSL(_){let S=this._componentToNumber(_[0])/255,C=this._componentToNumber(_[1])/255,f=this._componentToNumber(_[2])/255,T=Math.max(S,C,f),E=Math.min(S,C,f),I=T-E,R=T+E,D=0.5*R,N,L;return N=E===T?0:S===T?(60*(C-f)/I+360)%360:C===T?60*(f-S)/I+120:60*(S-C)/I+240,L=0==D?0:1==D?1:0.5>=D?I/R:I/(2-R),[Math.round(N),Math.round(100*L),Math.round(100*D)]}_hslToRGB(_){let S=parseFloat(_[0])/360,C=parseFloat(_[1])/100,f=parseFloat(_[2])/100;S*=6;let T=[f+=C*=.5>f?f:1-f,f-2*(S%1*C),f-=C*=2,f,f+S%1*C,f+C];return[Math.round(255*T[~~S%6]),Math.round(255*T[(16|S)%6]),Math.round(255*T[(8|S)%6])]}_rgbaToHSLA(_){let S=this._rgbToHSL(_);return S.push(_[3]),S}_hslaToRGBA(_){let S=this._hslToRGB(_);return S.push(_[3]),S}},WebInspector.Color.Format={Original:"color-format-original",Keyword:"color-format-keyword",HEX:"color-format-hex",ShortHEX:"color-format-short-hex",HEXAlpha:"color-format-hex-alpha",ShortHEXAlpha:"color-format-short-hex-alpha",RGB:"color-format-rgb",RGBA:"color-format-rgba",HSL:"color-format-hsl",HSLA:"color-format-hsla"},WebInspector.Color.Keywords={aliceblue:[240,248,255],antiquewhite:[250,235,215],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[237,164,61],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},WebInspector.ConsoleCommandResultMessage=class extends WebInspector.ConsoleMessage{constructor(_,S,C,f,T=!0){let E=WebInspector.ConsoleMessage.MessageSource.JS,I=C?WebInspector.ConsoleMessage.MessageLevel.Error:WebInspector.ConsoleMessage.MessageLevel.Log,R=WebInspector.ConsoleMessage.MessageType.Result;super(_,E,I,"",R,void 0,void 0,void 0,0,[S],void 0,void 0),this._savedResultIndex=f,this._shouldRevealConsole=T,this._savedResultIndex&&this._savedResultIndex>WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex&&(WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex=this._savedResultIndex)}static clearMaximumSavedResultIndex(){WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex=0}get savedResultIndex(){return this._savedResultIndex}get shouldRevealConsole(){return this._shouldRevealConsole}},WebInspector.ConsoleCommandResultMessage.maximumSavedResultIndex=0,WebInspector.ContentFlow=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._documentNodeIdentifier=_,this._name=S,this._overset=C,this._contentNodes=f}get id(){return this._documentNodeIdentifier+":"+this._name}get documentNodeIdentifier(){return this._documentNodeIdentifier}get name(){return this._name}get overset(){return this._overset}set overset(_){this._overset===_||(this._overset=_,this.dispatchEventToListeners(WebInspector.ContentFlow.Event.FlowOversetWasChanged))}get contentNodes(){return this._contentNodes}insertContentNodeBefore(_,S){var C=this._contentNodes.indexOf(S);this._contentNodes.splice(C,0,_),this.dispatchEventToListeners(WebInspector.ContentFlow.Event.ContentNodeWasAdded,{node:_,before:S})}appendContentNode(_){this._contentNodes.push(_),this.dispatchEventToListeners(WebInspector.ContentFlow.Event.ContentNodeWasAdded,{node:_})}removeContentNode(_){var S=this._contentNodes.indexOf(_);this._contentNodes.splice(S,1),this.dispatchEventToListeners(WebInspector.ContentFlow.Event.ContentNodeWasRemoved,{node:_})}},WebInspector.ContentFlow.Event={OversetWasChanged:"content-flow-overset-was-changed",ContentNodeWasAdded:"content-flow-content-node-was-added",ContentNodeWasRemoved:"content-flow-content-node-was-removed"},WebInspector.CookieStorageObject=class{constructor(_){this._host=_}static cookieMatchesResourceURL(_,S){var C=parseURL(S);return C&&WebInspector.CookieStorageObject.cookieDomainMatchesResourceDomain(_.domain,C.host)&&C.path.startsWith(_.path)&&(!_.port||C.port===_.port)&&(!_.secure||"https"===C.scheme)}static cookieDomainMatchesResourceDomain(_,S){return"."===_.charAt(0)?!!S.match(new RegExp("^(?:[^\\.]+\\.)*"+_.substring(1).escapeForRegExp()+"$"),"i"):S===_}get host(){return this._host}saveIdentityToCookie(_){_[WebInspector.CookieStorageObject.CookieHostCookieKey]=this.host}},WebInspector.CookieStorageObject.TypeIdentifier="cookie-storage",WebInspector.CookieStorageObject.CookieHostCookieKey="cookie-storage-host",WebInspector.DOMBreakpoint=class extends WebInspector.Object{constructor(_,S,C){super(),_ instanceof WebInspector.DOMNode?(this._domNodeIdentifier=_.id,this._path=_.path(),this._url=WebInspector.frameResourceManager.mainFrame.url):_&&"object"==typeof _&&(this._domNodeIdentifier=null,this._path=_.path,this._url=_.url),this._type=S,this._disabled=C||!1}get type(){return this._type}get url(){return this._url}get path(){return this._path}get disabled(){return this._disabled}set disabled(_){this._disabled===_||(this._disabled=_,this.dispatchEventToListeners(WebInspector.DOMBreakpoint.Event.DisabledStateDidChange))}get domNodeIdentifier(){return this._domNodeIdentifier}set domNodeIdentifier(_){if(this._domNodeIdentifier!==_){let S={};_||(S.oldNodeIdentifier=this._domNodeIdentifier),this._domNodeIdentifier=_,this.dispatchEventToListeners(WebInspector.DOMBreakpoint.Event.ResolvedStateDidChange,S)}}get serializableInfo(){let _={url:this._url,path:this._path,type:this._type};return this._disabled&&(_.disabled=!0),_}saveIdentityToCookie(_){_[WebInspector.DOMBreakpoint.DocumentURLCookieKey]=this.url,_[WebInspector.DOMBreakpoint.NodePathCookieKey]=this.path,_[WebInspector.DOMBreakpoint.TypeCookieKey]=this.type}},WebInspector.DOMBreakpoint.DocumentURLCookieKey="dom-breakpoint-document-url",WebInspector.DOMBreakpoint.NodePathCookieKey="dom-breakpoint-node-path",WebInspector.DOMBreakpoint.TypeCookieKey="dom-breakpoint-type",WebInspector.DOMBreakpoint.Type={SubtreeModified:"subtree-modified",AttributeModified:"attribute-modified",NodeRemoved:"node-removed"},WebInspector.DOMBreakpoint.Event={DisabledStateDidChange:"dom-breakpoint-disabled-state-did-change",ResolvedStateDidChange:"dom-breakpoint-resolved-state-did-change"},WebInspector.DOMNode=class extends WebInspector.Object{constructor(_,S,C,f){if(super(),this._domTreeManager=_,this._isInShadowTree=C,this.id=f.nodeId,this._domTreeManager._idToDOMNode[this.id]=this,this._nodeType=f.nodeType,this._nodeName=f.nodeName,this._localName=f.localName,this._nodeValue=f.nodeValue,this._pseudoType=f.pseudoType,this._shadowRootType=f.shadowRootType,this._computedRole=f.role,this._contentSecurityPolicyHash=f.contentSecurityPolicyHash,this.ownerDocument=this._nodeType===Node.DOCUMENT_NODE?this:S,this._attributes=[],this._attributesMap=new Map,f.attributes&&this._setAttributesPayload(f.attributes),this._childNodeCount=f.childNodeCount,this._children=null,this._filteredChildren=null,this._filteredChildrenNeedsUpdating=!0,this._nextSibling=null,this._previousSibling=null,this.parentNode=null,this._enabledPseudoClasses=[],this._shadowRoots=[],f.shadowRoots)for(var T=0;T<f.shadowRoots.length;++T){var E=f.shadowRoots[T],I=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,!0,E);I.parentNode=this,this._shadowRoots.push(I)}if(f.children?this._setChildrenPayload(f.children):this._shadowRoots.length&&!this._childNodeCount&&(this._children=this._shadowRoots.slice()),this._customElementState=this._nodeType===Node.ELEMENT_NODE?f.customElementState||WebInspector.DOMNode.CustomElementState.Builtin:null,f.templateContent&&(this._templateContent=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,!1,f.templateContent),this._templateContent.parentNode=this),this._pseudoElements=new Map,f.pseudoElements)for(var T=0,I;T<f.pseudoElements.length;++T)I=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,this._isInShadowTree,f.pseudoElements[T]),I.parentNode=this,this._pseudoElements.set(I.pseudoType(),I);f.contentDocument&&(this._contentDocument=new WebInspector.DOMNode(this._domTreeManager,null,!1,f.contentDocument),this._children=[this._contentDocument],this._renumber()),f.frameId&&(this._frameIdentifier=f.frameId),this._nodeType===Node.ELEMENT_NODE?(this.ownerDocument&&!this.ownerDocument.documentElement&&"HTML"===this._nodeName&&(this.ownerDocument.documentElement=this),this.ownerDocument&&!this.ownerDocument.body&&"BODY"===this._nodeName&&(this.ownerDocument.body=this),f.documentURL&&(this.documentURL=f.documentURL)):this._nodeType===Node.DOCUMENT_TYPE_NODE?(this.publicId=f.publicId,this.systemId=f.systemId):this._nodeType===Node.DOCUMENT_NODE?(this.documentURL=f.documentURL,this.xmlVersion=f.xmlVersion):this._nodeType===Node.ATTRIBUTE_NODE&&(this.name=f.name,this.value=f.value)}get frameIdentifier(){return this._frameIdentifier||this.ownerDocument.frameIdentifier}get frame(){return this._frame||(this._frame=WebInspector.frameResourceManager.frameForIdentifier(this.frameIdentifier)),this._frame}get children(){return this._children?WebInspector.showShadowDOMSetting.value?this._children:(this._filteredChildrenNeedsUpdating&&(this._filteredChildrenNeedsUpdating=!1,this._filteredChildren=this._children.filter(function(_){return!_._isInShadowTree})),this._filteredChildren):null}get firstChild(){var _=this.children;return _&&0<_.length?_[0]:null}get lastChild(){var _=this.children;return _&&0<_.length?_.lastValue:null}get nextSibling(){if(WebInspector.showShadowDOMSetting.value)return this._nextSibling;for(var _=this._nextSibling;_;){if(!_._isInShadowTree)return _;_=_._nextSibling}return null}get previousSibling(){if(WebInspector.showShadowDOMSetting.value)return this._previousSibling;for(var _=this._previousSibling;_;){if(!_._isInShadowTree)return _;_=_._previousSibling}return null}get childNodeCount(){var _=this.children;return _?_.length:WebInspector.showShadowDOMSetting.value?this._childNodeCount+this._shadowRoots.length:this._childNodeCount}set childNodeCount(_){this._childNodeCount=_}computedRole(){return this._computedRole}contentSecurityPolicyHash(){return this._contentSecurityPolicyHash}hasAttributes(){return 0<this._attributes.length}hasChildNodes(){return 0<this.childNodeCount}hasShadowRoots(){return!!this._shadowRoots.length}isInShadowTree(){return this._isInShadowTree}isInUserAgentShadowTree(){return this._isInShadowTree&&this.ancestorShadowRoot().isUserAgentShadowRoot()}isCustomElement(){return this._customElementState===WebInspector.DOMNode.CustomElementState.Custom}customElementState(){return this._customElementState}isShadowRoot(){return!!this._shadowRootType}isUserAgentShadowRoot(){return this._shadowRootType===WebInspector.DOMNode.ShadowRootType.UserAgent}ancestorShadowRoot(){if(!this._isInShadowTree)return null;let _=this;for(;_&&!_.isShadowRoot();)_=_.parentNode;return _}ancestorShadowHost(){let _=this.ancestorShadowRoot();return _?_.parentNode:null}isPseudoElement(){return this._pseudoType!==void 0}nodeType(){return this._nodeType}nodeName(){return this._nodeName}nodeNameInCorrectCase(){return this.isXMLNode()?this.nodeName():this.nodeName().toLowerCase()}setNodeName(_,S){DOMAgent.setNodeName(this.id,_,this._makeUndoableCallback(S))}localName(){return this._localName}templateContent(){return this._templateContent||null}pseudoType(){return this._pseudoType}hasPseudoElements(){return 0<this._pseudoElements.size}pseudoElements(){return this._pseudoElements}beforePseudoElement(){return this._pseudoElements.get(WebInspector.DOMNode.PseudoElementType.Before)||null}afterPseudoElement(){return this._pseudoElements.get(WebInspector.DOMNode.PseudoElementType.After)||null}shadowRoots(){return this._shadowRoots}shadowRootType(){return this._shadowRootType}nodeValue(){return this._nodeValue}setNodeValue(_,S){DOMAgent.setNodeValue(this.id,_,this._makeUndoableCallback(S))}getAttribute(_){let S=this._attributesMap.get(_);return S?S.value:void 0}setAttribute(_,S,C){DOMAgent.setAttributesAsText(this.id,S,_,this._makeUndoableCallback(C))}setAttributeValue(_,S,C){DOMAgent.setAttributeValue(this.id,_,S,this._makeUndoableCallback(C))}attributes(){return this._attributes}removeAttribute(_,S){DOMAgent.removeAttribute(this.id,_,function(f){if(!f){this._attributesMap.delete(_);for(var E=0;E<this._attributes.length;++E)if(this._attributes[E].name===_){this._attributes.splice(E,1);break}}this._makeUndoableCallback(S)(f)}.bind(this))}toggleClass(_,S){return _&&_.length?this.isPseudoElement()?void this.parentNode.toggleClass(_,S):void(this.nodeType()!==Node.ELEMENT_NODE||WebInspector.RemoteObject.resolveNode(this,"",function(f){f&&(f.callFunction(function(E,I){this.classList.toggle(E,I)},[_,S]),f.release())})):void 0}getChildNodes(_){return this.children?void(_&&_(this.children)):void DOMAgent.requestChildNodes(this.id,function(C){!C&&_&&_(this.children)}.bind(this))}getSubtree(_,S){DOMAgent.requestChildNodes(this.id,_,function(f){S&&S(f?null:this.children)}.bind(this))}getOuterHTML(_){DOMAgent.getOuterHTML(this.id,_)}setOuterHTML(_,S){DOMAgent.setOuterHTML(this.id,_,this._makeUndoableCallback(S))}removeNode(_){DOMAgent.removeNode(this.id,this._makeUndoableCallback(_))}copyNode(){DOMAgent.getOuterHTML(this.id,function(S,C){S||InspectorFrontendHost.copyText(C)})}getEventListeners(_){DOMAgent.getEventListenersForNode(this.id,_)}accessibilityProperties(_){DOMAgent.getAccessibilityPropertiesForNode(this.id,function(C,f){!C&&_&&f&&_({activeDescendantNodeId:f.activeDescendantNodeId,busy:f.busy,checked:f.checked,childNodeIds:f.childNodeIds,controlledNodeIds:f.controlledNodeIds,current:f.current,disabled:f.disabled,exists:f.exists,expanded:f.expanded,flowedNodeIds:f.flowedNodeIds,focused:f.focused,ignored:f.ignored,ignoredByDefault:f.ignoredByDefault,invalid:f.invalid,isPopupButton:f.isPopUpButton,headingLevel:f.headingLevel,hierarchyLevel:f.hierarchyLevel,hidden:f.hidden,label:f.label,liveRegionAtomic:f.liveRegionAtomic,liveRegionRelevant:f.liveRegionRelevant,liveRegionStatus:f.liveRegionStatus,mouseEventNodeId:f.mouseEventNodeId,nodeId:f.nodeId,ownedNodeIds:f.ownedNodeIds,parentNodeId:f.parentNodeId,pressed:f.pressed,readonly:f.readonly,required:f.required,role:f.role,selected:f.selected,selectedChildNodeIds:f.selectedChildNodeIds})}.bind(this))}path(){for(var _=[],S=this;S&&"index"in S&&S._nodeName.length;)_.push([S.index,S._nodeName]),S=S.parentNode;return _.reverse(),_.join(",")}get escapedIdSelector(){let _=this.getAttribute("id");return _?(_=_.trim(),!_.length)?"":(_=CSS.escape(_),/[\s'"]/.test(_)?`[id=\"${_}\"]`:`#${_}`):""}get escapedClassSelector(){let _=this.getAttribute("class");if(!_)return"";if(_=_.trim(),!_.length)return"";let S=new Set;return _.split(/\s+/).reduce((C,f)=>{return!f.length||S.has(f)?C:(S.add(f),`${C}.${CSS.escape(f)}`)},"")}get displayName(){return this.nodeNameInCorrectCase()+this.escapedIdSelector+this.escapedClassSelector}appropriateSelectorFor(_){if(this.isPseudoElement())return this.parentNode.appropriateSelectorFor()+"::"+this._pseudoType;let S=this.localName()||this.nodeName().toLowerCase(),C=this.escapedIdSelector;if(C.length)return _?C:S+C;let f=this.escapedClassSelector;return f.length?_?f:S+f:"input"===S&&this.getAttribute("type")?S+"[type=\""+this.getAttribute("type")+"\"]":S}isAncestor(_){if(!_)return!1;for(var S=_.parentNode;S;){if(this===S)return!0;S=S.parentNode}return!1}isDescendant(_){return null!==_&&_.isAncestor(this)}get ownerSVGElement(){return"svg"===this._nodeName?this:this.parentNode?this.parentNode.ownerSVGElement:null}isSVGElement(){return!!this.ownerSVGElement}_setAttributesPayload(_){this._attributes=[],this._attributesMap=new Map;for(var S=0;S<_.length;S+=2)this._addAttribute(_[S],_[S+1])}_insertChild(_,S){var C=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,this._isInShadowTree,S);return _?this._children.splice(this._children.indexOf(_)+1,0,C):this._children?this._children.unshift(C):this._children=this._shadowRoots.concat([C]),this._renumber(),C}_removeChild(_){_.isPseudoElement()?(this._pseudoElements.delete(_.pseudoType()),_.parentNode=null):(this._children.splice(this._children.indexOf(_),1),_.parentNode=null,this._renumber())}_setChildrenPayload(_){if(!this._contentDocument){this._children=this._shadowRoots.slice();for(var S=0,C;S<_.length;++S)C=new WebInspector.DOMNode(this._domTreeManager,this.ownerDocument,this._isInShadowTree,_[S]),this._children.push(C);this._renumber()}}_renumber(){this._filteredChildrenNeedsUpdating=!0;var _=this._children.length;if(0!==_)for(var S=0,C;S<_;++S)C=this._children[S],C.index=S,C._nextSibling=S+1<_?this._children[S+1]:null,C._previousSibling=0<=S-1?this._children[S-1]:null,C.parentNode=this}_addAttribute(_,S){let C={name:_,value:S,_node:this};this._attributesMap.set(_,C),this._attributes.push(C)}_setAttribute(_,S){let C=this._attributesMap.get(_);C?C.value=S:this._addAttribute(_,S)}_removeAttribute(_){let S=this._attributesMap.get(_);S&&(this._attributes.remove(S),this._attributesMap.delete(_))}moveTo(_,S,C){DOMAgent.moveTo(this.id,_.id,S?S.id:void 0,this._makeUndoableCallback(C))}isXMLNode(){return!!this.ownerDocument&&!!this.ownerDocument.xmlVersion}get enabledPseudoClasses(){return this._enabledPseudoClasses}setPseudoClassEnabled(_,S){var f=this._enabledPseudoClasses;if(S){if(f.includes(_))return;f.push(_)}else{if(!f.includes(_))return;f.remove(_)}CSSAgent.forcePseudoState(this.id,f,function(T){T||this.dispatchEventToListeners(WebInspector.DOMNode.Event.EnabledPseudoClassesChanged)}.bind(this))}_makeUndoableCallback(_){return function(S){S||DOMAgent.markUndoableState(),_&&_.apply(null,arguments)}}},WebInspector.DOMNode.Event={EnabledPseudoClassesChanged:"dom-node-enabled-pseudo-classes-did-change",AttributeModified:"dom-node-attribute-modified",AttributeRemoved:"dom-node-attribute-removed"},WebInspector.DOMNode.PseudoElementType={Before:"before",After:"after"},WebInspector.DOMNode.ShadowRootType={UserAgent:"user-agent",Closed:"closed",Open:"open"},WebInspector.DOMNode.CustomElementState={Builtin:"builtin",Custom:"custom",Waiting:"waiting",Failed:"failed"},WebInspector.DOMNodeStyles=class extends WebInspector.Object{constructor(_){super(),this._node=_||null,this._rulesMap={},this._styleDeclarationsMap={},this._matchedRules=[],this._inheritedRules=[],this._pseudoElements={},this._inlineStyle=null,this._attributesStyle=null,this._computedStyle=null,this._orderedStyles=[],this._propertyNameToEffectivePropertyMap={},this._pendingRefreshTask=null,this.refresh()}get node(){return this._node}get needsRefresh(){return this._pendingRefreshTask||this._needsRefresh}refreshIfNeeded(){this._needsRefresh&&this.refresh()}refresh(){function _(N,L){return(...D)=>{try{N.apply(this,D)}catch(M){console.error(M),L.resolve()}}}function S(N,L,D){for(var M=[],P={},O=N.length-1,F;0<=O;--O)F=this._parseRulePayload(N[O].rule,N[O].matchingSelectors,L,D,P),F&&M.push(F);return M}if(this._pendingRefreshTask)return this._pendingRefreshTask;this._needsRefresh=!1;let E=new WebInspector.WrappedPromise,I=new WebInspector.WrappedPromise,R=new WebInspector.WrappedPromise;return WebInspector.cssStyleManager.fetchStyleSheetsIfNeeded(),CSSAgent.getMatchedStylesForNode.invoke({nodeId:this._node.id,includePseudo:!0,includeInherited:!0},_.call(this,function(N,L,D,M){L=L||[],D=D||[],M=M||[],this._previousRulesMap=this._rulesMap,this._previousStyleDeclarationsMap=this._styleDeclarationsMap,this._rulesMap={},this._styleDeclarationsMap={},this._matchedRules=S.call(this,L,this._node),this._pseudoElements={};for(var P of D){var O=S.call(this,P.matches,this._node);this._pseudoElements[P.pseudoId]={matchedRules:O}}this._inheritedRules=[];for(var F=0,V=this._node.parentNode;V&&F<M.length;){var U=M[F],G={node:V};G.inlineStyle=U.inlineStyle?this._parseStyleDeclarationPayload(U.inlineStyle,V,!0,WebInspector.CSSStyleDeclaration.Type.Inline):null,G.matchedRules=U.matchedCSSRules?S.call(this,U.matchedCSSRules,V,!0):[],(G.inlineStyle||G.matchedRules.length)&&this._inheritedRules.push(G),V=V.parentNode,++F}E.resolve()},E)),CSSAgent.getInlineStylesForNode.invoke({nodeId:this._node.id},_.call(this,function(N,L,D){this._inlineStyle=L?this._parseStyleDeclarationPayload(L,this._node,!1,WebInspector.CSSStyleDeclaration.Type.Inline):null,this._attributesStyle=D?this._parseStyleDeclarationPayload(D,this._node,!1,WebInspector.CSSStyleDeclaration.Type.Attribute):null,this._updateStyleCascade(),I.resolve()},I)),CSSAgent.getComputedStyleForNode.invoke({nodeId:this._node.id},_.call(this,function(N,L){for(var D=[],M=0;L&&M<L.length;++M){var P=L[M],O=WebInspector.cssStyleManager.canonicalNameForPropertyName(P.name);P.implicit=!this._propertyNameToEffectivePropertyMap[O];var F=this._parseStylePropertyPayload(P,NaN,this._computedStyle);F.implicit||(F.implicit=!this._isPropertyFoundInMatchingRules(F.name)),D.push(F)}this._computedStyle?this._computedStyle.update(null,D):this._computedStyle=new WebInspector.CSSStyleDeclaration(this,null,null,WebInspector.CSSStyleDeclaration.Type.Computed,this._node,!1,null,D);let V=!1;for(let H in this._styleDeclarationsMap){if(H in this._previousStyleDeclarationsMap){if(Array.shallowEqual(this._styleDeclarationsMap[H],this._previousStyleDeclarationsMap[H]))continue;let W=!1;for(let z of this._styleDeclarationsMap[H])if(this._previousStyleDeclarationsMap[H].includes(z)){W=!0;break}if(W)continue}if(!this._includeUserAgentRulesOnNextRefresh){let W=this._styleDeclarationsMap[H][0];if(W&&W.ownerRule&&W.ownerRule.type===WebInspector.CSSStyleSheet.Type.UserAgent)continue}V=!0;break}if(!V)for(var U in this._previousStyleDeclarationsMap)if(!(U in this._styleDeclarationsMap)){if(!this._includeUserAgentRulesOnNextRefresh){var G=this._previousStyleDeclarationsMap[U][0];if(G&&G.ownerRule&&G.ownerRule.type===WebInspector.CSSStyleSheet.Type.UserAgent)continue}V=!0;break}delete this._includeUserAgentRulesOnNextRefresh,delete this._previousRulesMap,delete this._previousStyleDeclarationsMap,this.dispatchEventToListeners(WebInspector.DOMNodeStyles.Event.Refreshed,{significantChange:V}),R.resolve()},R)),this._pendingRefreshTask=Promise.all([E.promise,I.promise,R.promise]).then(()=>{this._pendingRefreshTask=null}),this._pendingRefreshTask}addRule(_,S,C){function f(){DOMAgent.markUndoableState(),this.refresh()}function T(R){R||f.call(this)}function E(R,N){return R?void 0:S&&S.length?void CSSAgent.setStyleText(N.style.styleId,S,T.bind(this)):void f.call(this)}function I(R){R&&CSSAgent.addRule(R.id,_,E.bind(this))}return _=_||this._node.appropriateSelectorFor(!0),CSSAgent.createStyleSheet?void(C?I.call(this,WebInspector.cssStyleManager.styleSheetForIdentifier(C)):WebInspector.cssStyleManager.preferredInspectorStyleSheetForFrame(this._node.frame,I.bind(this))):void CSSAgent.addRule.invoke({contextNodeId:this._node.id,selector:_},E.bind(this))}rulesForSelector(_){function S(f){return!f.mediaList.length&&f.selectorText===_}_=_||this._node.appropriateSelectorFor(!0);let C=this._matchedRules.filter(S);for(let f in this._pseudoElements)C=C.concat(this._pseudoElements[f].matchedRules.filter(S));return C}get matchedRules(){return this._matchedRules}get inheritedRules(){return this._inheritedRules}get inlineStyle(){return this._inlineStyle}get attributesStyle(){return this._attributesStyle}get pseudoElements(){return this._pseudoElements}get computedStyle(){return this._computedStyle}get orderedStyles(){return this._orderedStyles}effectivePropertyForName(_){let S=this._propertyNameToEffectivePropertyMap[_];if(S)return S;let C=WebInspector.cssStyleManager.canonicalNameForPropertyName(_);return this._propertyNameToEffectivePropertyMap[C]||null}mediaQueryResultDidChange(){this._markAsNeedsRefresh()}pseudoClassesDidChange(){this._includeUserAgentRulesOnNextRefresh=!0,this._markAsNeedsRefresh()}attributeDidChange(){this._markAsNeedsRefresh()}changeRule(_,S,C){function f(){DOMAgent.markUndoableState(),this.refresh()}function T(R){R||f.call(this)}function E(R){return C&&C.length?void CSSAgent.setStyleText(R,C,T.bind(this)):void f.call(this)}_&&(S=S||"",this._needsRefresh=!0,this._ignoreNextContentDidChangeForStyleSheet=_.ownerStyleSheet,CSSAgent.setRuleSelector(_.id,S,function(R,N){R||E.call(this,N.style.styleId)}.bind(this)))}changeRuleSelector(_,S){S=S||"";let f=new WebInspector.WrappedPromise;return this._needsRefresh=!0,this._ignoreNextContentDidChangeForStyleSheet=_.ownerStyleSheet,CSSAgent.setRuleSelector(_.id,S,function(T,E){return T?void f.reject(T):void(DOMAgent.markUndoableState(),this.refresh().then(()=>{f.resolve(E)}))}.bind(this)),f.promise}changeStyleText(_,S){_.ownerStyleSheet&&_.styleSheetTextRange&&(S=S||"",CSSAgent.setStyleText(_.id,S,function(f){f||this.refresh()}.bind(this)))}_createSourceCodeLocation(_,S,C){if(!_)return null;var f;if(this._node.ownerDocument){var T=WebInspector.frameResourceManager.resourceForURL(this._node.ownerDocument.documentURL);if(T){var E=T.parentFrame;f=E.resourceForURL(_)}}return f||(f=WebInspector.frameResourceManager.resourceForURL(_)),f?f.createSourceCodeLocation(S||0,C||0):null}_parseSourceRangePayload(_){return _?new WebInspector.TextRange(_.startLine,_.startColumn,_.endLine,_.endColumn):null}_parseStylePropertyPayload(_,S,C){var T=_.text||"",E=_.name,I=(_.value||"").replace(/\s*!important\s*$/,""),R=_.priority||"",N=!0,L=!1,D=_.implicit||!1,M=!1,P=!("parsedOk"in _)||_.parsedOk;switch(_.status||"style"){case"active":N=!0;break;case"inactive":L=!0,N=!0;break;case"disabled":N=!1;break;case"style":M=!0;}var O=this._parseSourceRangePayload(_.range);if(C){var F=isNaN(S)?C.propertyForName(E,!0):C.properties[S];if(F&&F.name===E&&(F.index===S||isNaN(F.index)&&isNaN(S)))return F.update(T,E,I,R,N,L,D,M,P,O),F;for(var V=C.pendingProperties,U=0,G;U<V.length;++U)if(G=V[U],G.name===E&&isNaN(G.index))return G.index=S,G.update(T,E,I,R,N,L,D,M,P,O),G}return new WebInspector.CSSProperty(S,T,E,I,R,N,L,D,M,P,O)}_parseStyleDeclarationPayload(_,S,C,f,T,E){if(!_)return null;T=T||null,C=C||!1;var I=_.styleId,R=I?I.styleSheetId+":"+I.ordinal:null;f===WebInspector.CSSStyleDeclaration.Type.Attribute&&(R=S.id+":attribute");var N=T?T.style:null,L=[],D=this._previousStyleDeclarationsMap||this._styleDeclarationsMap;if(R&&R in D){if(L=D[R],E&&L.length){for(var M=0,N;M<L.length;++M)N=L[M],this._parseStyleDeclarationPayload(_,N.node,N.inherited,N.type,N.ownerRule);return null}if(!N){var P=L.filter(function(q){return!q.ownerRule&&q.node===S&&q.inherited===C});N=P[0]||null}}D!==this._styleDeclarationsMap&&(L=R&&R in this._styleDeclarationsMap?this._styleDeclarationsMap[R]:[],N&&!L.includes(N)&&(L.push(N),this._styleDeclarationsMap[R]=L));for(var O={},M=0,F;_.shorthandEntries&&M<_.shorthandEntries.length;++M)F=_.shorthandEntries[M],O[F.name]=F.value;for(var V=_.cssText,U=0,G=[],M=0,H;_.cssProperties&&M<_.cssProperties.length;++M){H=_.cssProperties[M],C&&WebInspector.CSSProperty.isInheritedPropertyName(H.name)&&++U;var W=this._parseStylePropertyPayload(H,M,N,V);G.push(W)}var z=this._parseSourceRangePayload(_.range);if(N)return N.update(V,G,z),N;var K=I?WebInspector.cssStyleManager.styleSheetForIdentifier(I.styleSheetId):null;return(K&&(f===WebInspector.CSSStyleDeclaration.Type.Inline&&K.markAsInlineStyleAttributeStyleSheet(),K.addEventListener(WebInspector.CSSStyleSheet.Event.ContentDidChange,this._styleSheetContentDidChange,this)),C&&!U)?null:(N=new WebInspector.CSSStyleDeclaration(this,K,I,f,S,C,V,G,z),R&&(L.push(N),this._styleDeclarationsMap[R]=L),N)}_parseSelectorListPayload(_){var S=_.selectors;return S.length?"string"==typeof S[0]?S.map(function(C){return new WebInspector.CSSSelector(C)}):S.map(function(C){return new WebInspector.CSSSelector(C.text,C.specificity,C.dynamic)}):[]}_parseRulePayload(_,S,C,f,T){if(!_)return null;var E=_.ruleId||_.style.styleId,I=E?E.styleSheetId+":"+E.ordinal+":"+(f?"I":"N")+":"+C.id:null,R=0;I&&(I in T?R=++T[I]:T[I]=R,I+=":"+R);var N=null,L=this._previousRulesMap||this._rulesMap;I&&I in L&&(N=L[I],L!==this._rulesMap&&(this._rulesMap[I]=N));var D=this._parseStyleDeclarationPayload(_.style,C,f,WebInspector.CSSStyleDeclaration.Type.Rule,N);if(!D)return null;var M=E?WebInspector.cssStyleManager.styleSheetForIdentifier(E.styleSheetId):null,P=_.selectorList.text,O=this._parseSelectorListPayload(_.selectorList),F=WebInspector.CSSStyleManager.protocolStyleSheetOriginToEnum(_.origin),V=null,U=_.selectorList.range;V=U?this._createSourceCodeLocation(_.sourceURL,U.startLine,U.startColumn):this._createSourceCodeLocation(_.sourceURL,_.sourceLine),M&&(!V&&M.isInspectorStyleSheet()&&(V=M.createSourceCodeLocation(U.startLine,U.startColumn)),V=M.offsetSourceCodeLocation(V));for(var G=[],H=0;_.media&&H<_.media.length;++H){var W=_.media[H],z=WebInspector.CSSStyleManager.protocolMediaSourceToEnum(W.source),K=W.text,q=this._createSourceCodeLocation(W.sourceURL,W.sourceLine);M&&(q=M.offsetSourceCodeLocation(q)),G.push(new WebInspector.CSSMedia(z,K,q))}return N?(N.update(V,P,O,S,D,G),N):(M&&M.addEventListener(WebInspector.CSSStyleSheet.Event.ContentDidChange,this._styleSheetContentDidChange,this),N=new WebInspector.CSSRule(this,M,E,F,V,P,O,S,D,G),I&&(this._rulesMap[I]=N),N)}_markAsNeedsRefresh(){this._needsRefresh=!0,this.dispatchEventToListeners(WebInspector.DOMNodeStyles.Event.NeedsRefresh)}_styleSheetContentDidChange(_){var S=_.target;return S?S===this._ignoreNextContentDidChangeForStyleSheet?void delete this._ignoreNextContentDidChangeForStyleSheet:void this._markAsNeedsRefresh():void 0}_updateStyleCascade(){for(var _=this._collectStylesInCascadeOrder(this._matchedRules,this._inlineStyle,this._attributesStyle),S=0;S<this._inheritedRules.length;++S){var C=this._inheritedRules[S],f=this._collectStylesInCascadeOrder(C.matchedRules,C.inlineStyle,null);_=_.concat(f)}for(var T in this._orderedStyles=_,this._propertyNameToEffectivePropertyMap={},this._markOverriddenProperties(_,this._propertyNameToEffectivePropertyMap),this._associateRelatedProperties(_,this._propertyNameToEffectivePropertyMap),this._pseudoElements){var E=this._pseudoElements[T];E.orderedStyles=this._collectStylesInCascadeOrder(E.matchedRules,null,null),this._markOverriddenProperties(E.orderedStyles),this._associateRelatedProperties(E.orderedStyles)}}_collectStylesInCascadeOrder(_,S,C){var f=[];S&&f.push(S);for(var T=[],E=0,I;E<_.length;++E)switch(I=_[E],I.type){case WebInspector.CSSStyleSheet.Type.Inspector:case WebInspector.CSSStyleSheet.Type.Author:f.push(I.style);break;case WebInspector.CSSStyleSheet.Type.User:case WebInspector.CSSStyleSheet.Type.UserAgent:T.push(I.style);}return C&&f.push(C),f=f.concat(T),f}_markOverriddenProperties(_,S){S=S||{};for(var C=0;C<_.length;++C)for(var f=_[C],T=f.properties,E=0,I;E<T.length;++E){if(I=T[E],!I.enabled||!I.valid){I.overridden=!1;continue}if(f.inherited&&!I.inherited){I.overridden=!1;continue}var R=I.canonicalName;if(R in S){var N=S[R];if(N.ownerStyle===I.ownerStyle){if(N.important&&!I.important){I.overridden=!0;continue}}else if(N.important||!I.important||N.ownerStyle.node!==I.ownerStyle.node){I.overridden=!0;continue}I.anonymous||(N.overridden=!0)}I.overridden=!1,S[R]=I}}_associateRelatedProperties(_,S){for(var C=0;C<_.length;++C){for(var f=_[C].properties,T={},E=0,I;E<f.length;++E)if(I=f[E],I.valid&&WebInspector.CSSCompletions.cssNameCompletions.isShorthandPropertyName(I.name)){if(T[I.canonicalName]&&!T[I.canonicalName].overridden)continue;T[I.canonicalName]=I}for(var E=0,I;E<f.length;++E)if(I=f[E],I.valid){var R=null;if(!isEmptyObject(T))for(var N=WebInspector.CSSCompletions.cssNameCompletions.shorthandsForLonghand(I.canonicalName),L=0;L<N.length;++L)if(N[L]in T){R=T[N[L]];break}if(!R||R.overridden!==I.overridden){I.relatedShorthandProperty=null,I.clearRelatedLonghandProperties();continue}R.addRelatedLonghandProperty(I),I.relatedShorthandProperty=R,S&&S[R.canonicalName]===R&&(S[I.canonicalName]=I)}}}_isPropertyFoundInMatchingRules(_){return this._orderedStyles.some(S=>{return S.properties.some(C=>C.name===_)})}},WebInspector.DOMNodeStyles.Event={NeedsRefresh:"dom-node-styles-needs-refresh",Refreshed:"dom-node-styles-refreshed"},WebInspector.DOMSearchMatchObject=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._resource=_,this._domNode=S,this._title=C,this._searchTerm=f,this._sourceCodeTextRange=_.createSourceCodeTextRange(T)}static titleForDOMNode(_){switch(_.nodeType()){case Node.ELEMENT_NODE:var S="<"+_.nodeNameInCorrectCase();for(var C of _.attributes())S+=" "+C.name,C.value.length&&(S+="=\""+C.value+"\"");return S+">";case Node.TEXT_NODE:return"\""+_.nodeValue()+"\"";case Node.COMMENT_NODE:return"<!--"+_.nodeValue()+"-->";case Node.DOCUMENT_TYPE_NODE:var S="<!DOCTYPE "+_.nodeName();return _.publicId?(S+=" PUBLIC \""+_.publicId+"\"",_.systemId&&(S+=" \""+_.systemId+"\"")):_.systemId&&(S+=" SYSTEM \""+_.systemId+"\""),S+">";case Node.CDATA_SECTION_NODE:return"<![CDATA["+_+"]]>";case Node.PROCESSING_INSTRUCTION_NODE:var f=_.nodeValue(),T=f.length?" "+f:"",S="<?"+_.nodeNameInCorrectCase()+T+"?>";return S;default:return console.error("Unknown DOM node type: ",_.nodeType()),_.nodeNameInCorrectCase();}}get resource(){return this._resource}get domNode(){return this._domNode}get title(){return this._title}get className(){return this._className||(this._className=this._generateClassName()),this._className}get searchTerm(){return this._searchTerm}get sourceCodeTextRange(){return this._sourceCodeTextRange}saveIdentityToCookie(_){_[WebInspector.DOMSearchMatchObject.URLCookieKey]=this._resource.url.hash,_[WebInspector.DOMSearchMatchObject.TitleKey]=this._title;var S=this._sourceCodeTextRange.textRange;_[WebInspector.DOMSearchMatchObject.TextRangeKey]=[S.startLine,S.startColumn,S.endLine,S.endColumn].join()}_generateClassName(){switch(this._domNode.nodeType()){case Node.ELEMENT_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchElementIconStyleClassName;case Node.TEXT_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchTextNodeIconStyleClassName;case Node.COMMENT_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchCommentIconStyleClassName;case Node.DOCUMENT_TYPE_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName;case Node.CDATA_SECTION_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchCharacterDataIconStyleClassName;case Node.PROCESSING_INSTRUCTION_NODE:return WebInspector.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName;default:return console.error("Unknown DOM node type: ",this._domNode.nodeType()),WebInspector.DOMSearchMatchObject.DOMMatchNodeIconStyleClassName;}}},WebInspector.DOMSearchMatchObject.DOMMatchElementIconStyleClassName="dom-match-element-icon",WebInspector.DOMSearchMatchObject.DOMMatchTextNodeIconStyleClassName="dom-match-text-node-icon",WebInspector.DOMSearchMatchObject.DOMMatchCommentIconStyleClassName="dom-match-comment-icon",WebInspector.DOMSearchMatchObject.DOMMatchDocumentTypeIconStyleClassName="dom-match-document-type-icon",WebInspector.DOMSearchMatchObject.DOMMatchCharacterDataIconStyleClassName="dom-match-character-data-icon",WebInspector.DOMSearchMatchObject.DOMMatchNodeIconStyleClassName="dom-match-node-icon",WebInspector.DOMSearchMatchObject.TypeIdentifier="dom-search-match-object",WebInspector.DOMSearchMatchObject.URLCookieKey="resource-url",WebInspector.DOMSearchMatchObject.TitleKey="title",WebInspector.DOMSearchMatchObject.TextRangeKey="text-range",WebInspector.DOMStorageObject=class extends WebInspector.Object{constructor(_,S,C){super(),this._id=_,this._host=S,this._isLocalStorage=C,this._entries=new Map}get id(){return this._id}get host(){return this._host}get entries(){return this._entries}saveIdentityToCookie(_){_[WebInspector.DOMStorageObject.HostCookieKey]=this.host,_[WebInspector.DOMStorageObject.LocalStorageCookieKey]=this.isLocalStorage()}isLocalStorage(){return this._isLocalStorage}getEntries(_){DOMStorageAgent.getDOMStorageItems(this._id,function(C,f){if(!C){for(let[T,E]of f)T&&E&&this._entries.set(T,E);_(C,f)}}.bind(this))}removeItem(_){DOMStorageAgent.removeDOMStorageItem(this._id,_)}setItem(_,S){DOMStorageAgent.setDOMStorageItem(this._id,_,S)}itemsCleared(){this._entries.clear(),this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemsCleared)}itemRemoved(_){this._entries.delete(_),this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemRemoved,{key:_})}itemAdded(_,S){this._entries.set(_,S),this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemAdded,{key:_,value:S})}itemUpdated(_,S,C){this._entries.set(_,C),this.dispatchEventToListeners(WebInspector.DOMStorageObject.Event.ItemUpdated,{key:_,oldValue:S,value:C})}},WebInspector.DOMStorageObject.TypeIdentifier="dom-storage",WebInspector.DOMStorageObject.HostCookieKey="dom-storage-object-host",WebInspector.DOMStorageObject.LocalStorageCookieKey="dom-storage-object-local-storage",WebInspector.DOMStorageObject.Event={ItemsCleared:"dom-storage-object-items-cleared",ItemAdded:"dom-storage-object-item-added",ItemRemoved:"dom-storage-object-item-removed",ItemUpdated:"dom-storage-object-updated"},WebInspector.DOMTree=class extends WebInspector.Object{constructor(_){super(),this._frame=_,this._rootDOMNode=null,this._requestIdentifier=0,this._contentFlowCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.ContentFlow),this._frame.addEventListener(WebInspector.Frame.Event.PageExecutionContextChanged,this._framePageExecutionContextChanged,this),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.DocumentUpdated,this._documentUpdated,this),this._frame.isMainFrame()||(WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.NodeRemoved,this._nodeRemoved,this),this._frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._frameMainResourceDidChange,this)),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.ContentFlowListWasUpdated,this._contentFlowListWasUpdated,this),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.ContentFlowWasAdded,this._contentFlowWasAdded,this),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.ContentFlowWasRemoved,this._contentFlowWasRemoved,this)}get frame(){return this._frame}get contentFlowCollection(){return this._contentFlowCollection}disconnect(){WebInspector.domTreeManager.removeEventListener(null,null,this),this._frame.removeEventListener(null,null,this)}invalidate(){this._rootDOMNode=null,this._pendingRootDOMNodeRequests=null;this._invalidateTimeoutIdentifier||(this._invalidateTimeoutIdentifier=setTimeout(function(){this._invalidateTimeoutIdentifier=void 0,this.dispatchEventToListeners(WebInspector.DOMTree.Event.RootDOMNodeInvalidated)}.bind(this),0))}requestRootDOMNode(_){return"function"==typeof _?this._rootDOMNode?void _(this._rootDOMNode):this._frame.isMainFrame()||this._frame.pageExecutionContext?this._pendingRootDOMNodeRequests?void this._pendingRootDOMNodeRequests.push(_):void(this._pendingRootDOMNodeRequests=[_],this._requestRootDOMNode()):(this._rootDOMNodeRequestWaitingForExecutionContext=!0,this._pendingRootDOMNodeRequests||(this._pendingRootDOMNodeRequests=[]),void this._pendingRootDOMNodeRequests.push(_)):void 0}requestContentFlowList(){this.requestRootDOMNode(function(_){WebInspector.domTreeManager.getNamedFlowCollection(_.id)})}_requestRootDOMNode(){function _(I,R){if(this._pendingRootDOMNodeRequests&&T===this._requestIdentifier){if(I)return console.error(JSON.stringify(I)),this._rootDOMNode=null,void f.call(this);var N=WebInspector.RemoteObject.fromPayload(R);N.pushNodeToFrontend(S.bind(this,N))}}function S(I,R){if(I.release(),this._pendingRootDOMNodeRequests&&T===this._requestIdentifier)return R?(this._rootDOMNode=WebInspector.domTreeManager.nodeForId(R),this._rootDOMNode?void this._rootDOMNode.getChildNodes(f.bind(this)):void f.call(this)):(this._rootDOMNode=null,void f.call(this))}function f(){if(this._pendingRootDOMNodeRequests&&T===this._requestIdentifier){for(var I=0;I<this._pendingRootDOMNodeRequests.length;++I)this._pendingRootDOMNodeRequests[I](this._rootDOMNode);this._pendingRootDOMNodeRequests=null}}var T=++this._requestIdentifier;if(this._frame.isMainFrame())WebInspector.domTreeManager.requestDocument(function(I){this._rootDOMNode=I,f.call(this)}.bind(this));else{var E=this._frame.pageExecutionContext.id;RuntimeAgent.evaluate.invoke({expression:appendWebInspectorSourceURL("document"),objectGroup:"",includeCommandLineAPI:!1,doNotPauseOnExceptionsAndMuteConsole:!0,contextId:E,returnByValue:!1,generatePreview:!1},_.bind(this))}}_nodeRemoved(_){_.data.node!==this._rootDOMNode||this.invalidate()}_documentUpdated(){this.invalidate()}_frameMainResourceDidChange(){this.invalidate()}_framePageExecutionContextChanged(){this._rootDOMNodeRequestWaitingForExecutionContext&&(this._rootDOMNodeRequestWaitingForExecutionContext=!1,this._requestRootDOMNode())}_isContentFlowInCurrentDocument(_){return this._rootDOMNode&&this._rootDOMNode.id===_.documentNodeIdentifier}_contentFlowListWasUpdated(_){if(this._rootDOMNode&&this._rootDOMNode.id===_.data.documentNodeIdentifier){let S=new Set(this._contentFlowCollection.items),C=new Set;for(let f of _.data.flows)this._contentFlowCollection.items.has(f)?S.delete(f):(this._contentFlowCollection.add(f),C.add(f));for(let f of S)this._contentFlowCollection.remove(f);for(let f of S)this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasRemoved,{flow:f});for(let f of C)this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasAdded,{flow:f})}}_contentFlowWasAdded(_){let S=_.data.flow;this._isContentFlowInCurrentDocument(S)&&(this._contentFlowCollection.add(S),this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasAdded,{flow:S}))}_contentFlowWasRemoved(_){let S=_.data.flow;this._isContentFlowInCurrentDocument(S)&&(this._contentFlowCollection.remove(S),this.dispatchEventToListeners(WebInspector.DOMTree.Event.ContentFlowWasRemoved,{flow:S}))}},WebInspector.DOMTree.Event={RootDOMNodeInvalidated:"dom-tree-root-dom-node-invalidated",ContentFlowWasAdded:"dom-tree-content-flow-was-added",ContentFlowWasRemoved:"dom-tree-content-flow-was-removed"},WebInspector.DatabaseObject=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._id=_,this._host=S?S:WebInspector.UIString("Local File"),this._name=C,this._version=f}get id(){return this._id}get host(){return this._host}get name(){return this._name}get version(){return this._version}saveIdentityToCookie(_){_[WebInspector.DatabaseObject.HostCookieKey]=this.host,_[WebInspector.DatabaseObject.NameCookieKey]=this.name}getTableNames(_){DatabaseAgent.getDatabaseTableNames(this._id,function(C,f){C||_(f.sort())})}executeSQL(_,S,C){DatabaseAgent.executeSQL(this._id,_,function(T,E,I,R){if(T)return void C(WebInspector.UIString("An unexpected error occurred."));if(R){switch(R.code){case SQLException.VERSION_ERR:C(WebInspector.UIString("Database no longer has expected version."));break;case SQLException.TOO_LARGE_ERR:C(WebInspector.UIString("Data returned from the database is too large."));break;default:C(WebInspector.UIString("An unexpected error occurred."));}return}S(E,I)})}},WebInspector.DatabaseObject.TypeIdentifier="database",WebInspector.DatabaseObject.HostCookieKey="database-object-host",WebInspector.DatabaseObject.NameCookieKey="database-object-name",WebInspector.DatabaseTableObject=class extends WebInspector.Object{constructor(_,S){super(),this._name=_,this._database=S}get name(){return this._name}get database(){return this._database}saveIdentityToCookie(_){_[WebInspector.DatabaseTableObject.NameCookieKey]=this.name}},WebInspector.DatabaseTableObject.TypeIdentifier="database-table",WebInspector.DatabaseTableObject.NameCookieKey="database-table-object-name",WebInspector.DebuggerDashboard=class extends WebInspector.Object{},WebInspector.DebuggerData=class extends WebInspector.Object{constructor(_){super(),this._target=_,this._paused=!1,this._pausing=!1,this._pauseReason=null,this._pauseData=null,this._callFrames=[],this._asyncStackTrace=null,this._scriptIdMap=new Map,this._scriptContentIdentifierMap=new Map,this._makePausingAfterNextResume=!1}get target(){return this._target}get paused(){return this._paused}get pausing(){return this._pausing}get pauseReason(){return this._pauseReason}get pauseData(){return this._pauseData}get callFrames(){return this._callFrames}get asyncStackTrace(){return this._asyncStackTrace}get scripts(){return Array.from(this._scriptIdMap.values())}scriptForIdentifier(_){return this._scriptIdMap.get(_)}scriptsForURL(_){return this._scriptContentIdentifierMap.get(_)||[]}reset(){this._scriptIdMap.clear()}addScript(_){if(this._scriptIdMap.set(_.id,_),_.contentIdentifier){let S=this._scriptContentIdentifierMap.get(_.contentIdentifier);S||(S=[],this._scriptContentIdentifierMap.set(_.contentIdentifier,S)),S.push(_)}}pauseIfNeeded(){return this._paused||this._pausing?Promise.resolve():(this._pausing=!0,this._target.DebuggerAgent.pause())}resumeIfNeeded(){return this._paused||this._pausing?(this._pausing=!1,this._target.DebuggerAgent.resume()):Promise.resolve()}continueUntilNextRunLoop(){return!this._paused||this._pausing?Promise.resolve():(this._makePausingAfterNextResume=!0,this._target.DebuggerAgent.continueUntilNextRunLoop())}updateForPause(_,S,C,f){this._paused=!0,this._pausing=!1,this._pauseReason=S,this._pauseData=C,this._callFrames=_,this._asyncStackTrace=f,this._makePausingAfterNextResume=!1}updateForResume(){this._paused=!1,this._pausing=!1,this._pauseReason=null,this._pauseData=null,this._callFrames=[],this._asyncStackTrace=null,this._makePausingAfterNextResume&&(this._makePausingAfterNextResume=!1,this._pausing=!0)}},WebInspector.DefaultDashboard=class extends WebInspector.Object{constructor(){super(),this._waitingForFirstMainResourceToStartTrackingSize=!0,WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this),WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStopped,this._capturingStopped,this),WebInspector.Frame.addEventListener(WebInspector.Frame.Event.ResourceWasAdded,this._resourceWasAdded,this),WebInspector.Target.addEventListener(WebInspector.Target.Event.ResourceAdded,this._resourceWasAdded,this),WebInspector.frameResourceManager.addEventListener(WebInspector.FrameResourceManager.Event.FrameWasAdded,this._frameWasAdded,this);var _=WebInspector.logManager;_.addEventListener(WebInspector.LogManager.Event.Cleared,this._consoleWasCleared,this),_.addEventListener(WebInspector.LogManager.Event.MessageAdded,this._consoleMessageAdded,this),_.addEventListener(WebInspector.LogManager.Event.PreviousMessageRepeatCountUpdated,this._consoleMessageWasRepeated,this),this._resourcesCount=0,this._resourcesSize=0,this._time=0,this._logs=0,this._errors=0,this._issues=0}get resourcesCount(){return this._resourcesCount}set resourcesCount(_){this._resourcesCount=_,this._dataDidChange()}get resourcesSize(){return this._resourcesSize}set resourcesSize(_){this._resourcesSize=_,this._dataDidChange()}get time(){return this._time}set time(_){this._time=_,this._dataDidChange()}get logs(){return this._logs}set logs(_){this._logs=_,this._dataDidChange()}get errors(){return this._errors}set errors(_){this._errors=_,this._dataDidChange()}get issues(){return this._issues}set issues(_){this._issues=_,this._dataDidChange()}_dataDidChange(){this.dispatchEventToListeners(WebInspector.DefaultDashboard.Event.DataDidChange)}_mainResourceDidChange(_){_.target.isMainFrame()&&(this._time=0,this._resourcesCount=1,this._resourcesSize=WebInspector.frameResourceManager.mainFrame.mainResource.size||0,this._waitingForFirstMainResourceToStartTrackingSize&&(this._waitingForFirstMainResourceToStartTrackingSize=!1,WebInspector.Resource.addEventListener(WebInspector.Resource.Event.SizeDidChange,this._resourceSizeDidChange,this)),this._dataDidChange(),this._startUpdatingTime())}_capturingStopped(){this._stopUpdatingTime()}_resourceWasAdded(){++this.resourcesCount}_frameWasAdded(){++this.resourcesCount}_resourceSizeDidChange(_){"data"===_.target.urlComponents.scheme||(this.resourcesSize+=_.target.size-_.data.previousSize)}_startUpdatingTime(){this._stopUpdatingTime(),this.time=0,this._timelineBaseTime=Date.now(),this._timeIntervalDelay=50,this._timeIntervalIdentifier=setInterval(this._updateTime.bind(this),this._timeIntervalDelay)}_stopUpdatingTime(){this._timeIntervalIdentifier&&(clearInterval(this._timeIntervalIdentifier),this._timeIntervalIdentifier=void 0)}_updateTime(){var _=Date.now()-this._timelineBaseTime,S=this._timeIntervalDelay;1e3<=_?S=100:6e4<=_?S=1e3:3.6e6<=_&&(S=1e4),S!==this._timeIntervalDelay&&(this._timeIntervalDelay=S,clearInterval(this._timeIntervalIdentifier),this._timeIntervalIdentifier=setInterval(this._updateTime.bind(this),this._timeIntervalDelay));var C=WebInspector.frameResourceManager.mainFrame,f=C.mainResource.firstTimestamp,T=C.loadEventTimestamp;return isNaN(f)||isNaN(T)?void(this.time=_/1e3):void(this.time=T-f,this._stopUpdatingTime())}_consoleMessageAdded(_){var S=_.data.message;this._lastConsoleMessageType=S.level,this._incrementConsoleMessageType(S.level,S.repeatCount)}_consoleMessageWasRepeated(){this._incrementConsoleMessageType(this._lastConsoleMessageType,1)}_incrementConsoleMessageType(_,S){_===WebInspector.ConsoleMessage.MessageLevel.Log||_===WebInspector.ConsoleMessage.MessageLevel.Info||_===WebInspector.ConsoleMessage.MessageLevel.Debug?this.logs+=S:_===WebInspector.ConsoleMessage.MessageLevel.Warning?this.issues+=S:_===WebInspector.ConsoleMessage.MessageLevel.Error?this.errors+=S:void 0}_consoleWasCleared(){this._logs=0,this._issues=0,this._errors=0,this._dataDidChange()}},WebInspector.DefaultDashboard.Event={DataDidChange:"default-dashboard-data-did-change"},WebInspector.ExecutionContext=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._target=_,this._id=S,this._name=C,this._isPageContext=f||!1,this._frame=T||null}get target(){return this._target}get id(){return this._id}get name(){return this._name}get isPageContext(){return this._isPageContext}get frame(){return this._frame}},WebInspector.ExecutionContextList=class extends WebInspector.Object{constructor(){super(),this._contexts=[],this._pageExecutionContext=null}get pageExecutionContext(){return this._pageExecutionContext}get contexts(){return this._contexts}add(_){return _.isPageContext&&this._pageExecutionContext?!1:(this._contexts.push(_),!!_.isPageContext&&(this._pageExecutionContext=_,!0))}clear(){this._contexts=[],this._pageExecutionContext=null}},WebInspector.FPSInstrument=class extends WebInspector.Instrument{constructor(){super()}static supported(){return window.TimelineAgent&&TimelineAgent.EventType.RenderingFrame}get timelineRecordType(){return WebInspector.TimelineRecord.Type.RenderingFrame}},WebInspector.Frame=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._id=_,this._name=null,this._securityOrigin=null,this._resourceCollection=new WebInspector.ResourceCollection,this._provisionalResourceCollection=new WebInspector.ResourceCollection,this._extraScriptCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Script),this._canvasCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Canvas),this._childFrameCollection=new WebInspector.Collection(WebInspector.Collection.TypeVerifier.Frame),this._childFrameIdentifierMap=new Map,this._parentFrame=null,this._isMainFrame=!1,this._domContentReadyEventTimestamp=NaN,this._loadEventTimestamp=NaN,this._executionContextList=new WebInspector.ExecutionContextList,this.initialize(S,C,f,T)}get resourceCollection(){return this._resourceCollection}get extraScriptCollection(){return this._extraScriptCollection}get canvasCollection(){return this._canvasCollection}get childFrameCollection(){return this._childFrameCollection}initialize(_,S,C,f){var T=this._name,E=this._securityOrigin,I=this._mainResource;this._name=_||null,this._securityOrigin=S||null,this._loaderIdentifier=C||null,this._mainResource=f,this._mainResource._parentFrame=this,I&&this._mainResource!==I&&this._disassociateWithResource(I),this.removeAllResources(),this.removeAllChildFrames(),this.clearExecutionContexts(),this.clearProvisionalLoad(),this._mainResource!==I&&this._dispatchMainResourceDidChangeEvent(I),this._securityOrigin!==E&&this.dispatchEventToListeners(WebInspector.Frame.Event.SecurityOriginDidChange,{oldSecurityOrigin:E}),this._name!==T&&this.dispatchEventToListeners(WebInspector.Frame.Event.NameDidChange,{oldName:T})}startProvisionalLoad(_){this._provisionalMainResource=_,this._provisionalMainResource._parentFrame=this,this._provisionalLoaderIdentifier=_.loaderIdentifier,this._provisionalResourceCollection.clear(),this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalLoadStarted)}commitProvisionalLoad(_){if(this._provisionalLoaderIdentifier){var S=this._securityOrigin,C=this._mainResource;this._securityOrigin=_||null,this._loaderIdentifier=this._provisionalLoaderIdentifier,this._mainResource=this._provisionalMainResource,this._domContentReadyEventTimestamp=NaN,this._loadEventTimestamp=NaN,C&&this._mainResource!==C&&this._disassociateWithResource(C),this.removeAllResources(),this._resourceCollection=this._provisionalResourceCollection,this._provisionalResourceCollection=new WebInspector.ResourceCollection,this._extraScriptCollection.clear(),this._canvasCollection.clear(),this.clearExecutionContexts(!0),this.clearProvisionalLoad(!0),this.removeAllChildFrames(),this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalLoadCommitted),this._mainResource!==C&&this._dispatchMainResourceDidChangeEvent(C),this._securityOrigin!==S&&this.dispatchEventToListeners(WebInspector.Frame.Event.SecurityOriginDidChange,{oldSecurityOrigin:S})}}clearProvisionalLoad(_){this._provisionalLoaderIdentifier&&(this._provisionalLoaderIdentifier=null,this._provisionalMainResource=null,this._provisionalResourceCollection.clear(),!_&&this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalLoadCleared))}get id(){return this._id}get loaderIdentifier(){return this._loaderIdentifier}get provisionalLoaderIdentifier(){return this._provisionalLoaderIdentifier}get name(){return this._name}get securityOrigin(){return this._securityOrigin}get url(){return this._mainResource._url}get domTree(){return this._domTree||(this._domTree=new WebInspector.DOMTree(this)),this._domTree}get pageExecutionContext(){return this._executionContextList.pageExecutionContext}get executionContextList(){return this._executionContextList}clearExecutionContexts(_){if(this._executionContextList.contexts.length){let S=this._executionContextList.contexts.slice();this._executionContextList.clear(),this.dispatchEventToListeners(WebInspector.Frame.Event.ExecutionContextsCleared,{committingProvisionalLoad:!!_,contexts:S})}}addExecutionContext(_){var S=this._executionContextList.add(_);S&&this.dispatchEventToListeners(WebInspector.Frame.Event.PageExecutionContextChanged)}get mainResource(){return this._mainResource}get provisionalMainResource(){return this._provisionalMainResource}get parentFrame(){return this._parentFrame}get domContentReadyEventTimestamp(){return this._domContentReadyEventTimestamp}get loadEventTimestamp(){return this._loadEventTimestamp}isMainFrame(){return this._isMainFrame}markAsMainFrame(){this._isMainFrame=!0}unmarkAsMainFrame(){this._isMainFrame=!1}markDOMContentReadyEvent(_){this._domContentReadyEventTimestamp=_||NaN}markLoadEvent(_){this._loadEventTimestamp=_||NaN}isDetached(){for(var _=this;_;){if(_.isMainFrame())return!1;_=_.parentFrame}return!0}childFrameForIdentifier(_){return this._childFrameIdentifierMap.get(_)||null}addChildFrame(_){_ instanceof WebInspector.Frame&&_._parentFrame!==this&&(_._parentFrame&&_._parentFrame.removeChildFrame(_),this._childFrameCollection.add(_),this._childFrameIdentifierMap.set(_._id,_),_._parentFrame=this,this.dispatchEventToListeners(WebInspector.Frame.Event.ChildFrameWasAdded,{childFrame:_}))}removeChildFrame(_){let S=_;S instanceof WebInspector.Frame&&(S=_._id);let C=this.childFrameForIdentifier(S);C instanceof WebInspector.Frame&&(this._childFrameCollection.remove(C),this._childFrameIdentifierMap.delete(C._id),C._detachFromParentFrame(),this.dispatchEventToListeners(WebInspector.Frame.Event.ChildFrameWasRemoved,{childFrame:C}))}removeAllChildFrames(){this._detachFromParentFrame();for(let _ of this._childFrameCollection.items)_.removeAllChildFrames();this._childFrameCollection.clear(),this._childFrameIdentifierMap.clear(),this.dispatchEventToListeners(WebInspector.Frame.Event.AllChildFramesRemoved)}resourceForURL(_,S){var C=this._resourceCollection.resourceForURL(_);if(C)return C;for(let f of this._childFrameCollection.items)if(C=f.mainResource,C.url===_)return C;if(!S)return null;for(let f of this._childFrameCollection.items)if(C=f.resourceForURL(_,!0),C)return C;return null}resourceCollectionForType(_){return this._resourceCollection.resourceCollectionForType(_)}addResource(_){_ instanceof WebInspector.Resource&&_.parentFrame!==this&&(_.parentFrame&&_.parentFrame.remove(_),this._associateWithResource(_),this._isProvisionalResource(_)?(this._provisionalResourceCollection.add(_),this.dispatchEventToListeners(WebInspector.Frame.Event.ProvisionalResourceWasAdded,{resource:_})):(this._resourceCollection.add(_),this.dispatchEventToListeners(WebInspector.Frame.Event.ResourceWasAdded,{resource:_})))}removeResource(_){this._resourceCollection.remove(_),this._disassociateWithResource(_),this.dispatchEventToListeners(WebInspector.Frame.Event.ResourceWasRemoved,{resource:_})}removeAllResources(){let _=this._resourceCollection.items;if(_.size){for(let S of _)this._disassociateWithResource(S);this._resourceCollection.clear(),this.dispatchEventToListeners(WebInspector.Frame.Event.AllResourcesRemoved)}}addExtraScript(_){this._extraScriptCollection.add(_),this.dispatchEventToListeners(WebInspector.Frame.Event.ExtraScriptAdded,{script:_})}saveIdentityToCookie(_){_[WebInspector.Frame.MainResourceURLCookieKey]=this.mainResource.url.hash,_[WebInspector.Frame.IsMainFrameCookieKey]=this._isMainFrame}_detachFromParentFrame(){this._domTree&&(this._domTree.disconnect(),this._domTree=null),this._parentFrame=null}_isProvisionalResource(_){return _.loaderIdentifier&&this._provisionalLoaderIdentifier&&_.loaderIdentifier===this._provisionalLoaderIdentifier}_associateWithResource(_){_._parentFrame||(_._parentFrame=this)}_disassociateWithResource(_){_.parentFrame!==this||(_._parentFrame=null)}_dispatchMainResourceDidChangeEvent(_){this.dispatchEventToListeners(WebInspector.Frame.Event.MainResourceDidChange,{oldMainResource:_})}},WebInspector.Frame.Event={NameDidChange:"frame-name-did-change",SecurityOriginDidChange:"frame-security-origin-did-change",MainResourceDidChange:"frame-main-resource-did-change",ProvisionalLoadStarted:"frame-provisional-load-started",ProvisionalLoadCommitted:"frame-provisional-load-committed",ProvisionalLoadCleared:"frame-provisional-load-cleared",ProvisionalResourceWasAdded:"frame-provisional-resource-was-added",ResourceWasAdded:"frame-resource-was-added",ResourceWasRemoved:"frame-resource-was-removed",AllResourcesRemoved:"frame-all-resources-removed",ExtraScriptAdded:"frame-extra-script-added",ChildFrameWasAdded:"frame-child-frame-was-added",ChildFrameWasRemoved:"frame-child-frame-was-removed",AllChildFramesRemoved:"frame-all-child-frames-removed",PageExecutionContextChanged:"frame-page-execution-context-changed",ExecutionContextsCleared:"frame-execution-contexts-cleared"},WebInspector.Frame.TypeIdentifier="Frame",WebInspector.Frame.MainResourceURLCookieKey="frame-main-resource-url",WebInspector.Frame.IsMainFrameCookieKey="frame-is-main-frame",WebInspector.GarbageCollection=class extends WebInspector.Object{constructor(_,S,C){super(),this._type=_,this._startTime=S,this._endTime=C}static fromPayload(_){let S=WebInspector.GarbageCollection.Type.Full;return _.type===HeapAgent.GarbageCollectionType.Partial&&(S=WebInspector.GarbageCollection.Type.Partial),new WebInspector.GarbageCollection(S,_.startTime,_.endTime)}get type(){return this._type}get startTime(){return this._startTime}get endTime(){return this._endTime}get duration(){return this._endTime-this._startTime}},WebInspector.GarbageCollection.Type={Partial:Symbol("Partial"),Full:Symbol("Full")},WebInspector.Point=class{constructor(_,S){this.x=_||0,this.y=S||0}static fromEvent(_){return new WebInspector.Point(_.pageX,_.pageY)}static fromEventInElement(_,S){var C=window.webkitConvertPointFromPageToNode(S,new WebKitPoint(_.pageX,_.pageY));return new WebInspector.Point(C.x,C.y)}toString(){return"WebInspector.Point["+this.x+","+this.y+"]"}copy(){return new WebInspector.Point(this.x,this.y)}equals(_){return this.x===_.x&&this.y===_.y}distance(_){var S=_.x-this.x,C=_.y-this.y;return Math.sqrt(S*S,C*C)}},WebInspector.Size=class{constructor(_,S){this.width=_||0,this.height=S||0}toString(){return"WebInspector.Size["+this.width+","+this.height+"]"}copy(){return new WebInspector.Size(this.width,this.height)}equals(_){return this.width===_.width&&this.height===_.height}},WebInspector.Size.ZERO_SIZE=new WebInspector.Size(0,0),WebInspector.Rect=class{constructor(_,S,C,f){this.origin=new WebInspector.Point(_||0,S||0),this.size=new WebInspector.Size(C||0,f||0)}static rectFromClientRect(_){return new WebInspector.Rect(_.left,_.top,_.width,_.height)}static unionOfRects(_){for(var S=_[0],C=1;C<_.length;++C)S=S.unionWithRect(_[C]);return S}toString(){return"WebInspector.Rect["+[this.origin.x,this.origin.y,this.size.width,this.size.height].join(", ")+"]"}copy(){return new WebInspector.Rect(this.origin.x,this.origin.y,this.size.width,this.size.height)}equals(_){return this.origin.equals(_.origin)&&this.size.equals(_.size)}inset(_){return new WebInspector.Rect(this.origin.x+_.left,this.origin.y+_.top,this.size.width-_.left-_.right,this.size.height-_.top-_.bottom)}pad(_){return new WebInspector.Rect(this.origin.x-_,this.origin.y-_,this.size.width+2*_,this.size.height+2*_)}minX(){return this.origin.x}minY(){return this.origin.y}midX(){return this.origin.x+this.size.width/2}midY(){return this.origin.y+this.size.height/2}maxX(){return this.origin.x+this.size.width}maxY(){return this.origin.y+this.size.height}intersectionWithRect(_){var S=Math.max(this.minX(),_.minX()),C=Math.min(this.maxX(),_.maxX());if(S>C)return WebInspector.Rect.ZERO_RECT;var f=new WebInspector.Rect;f.origin.x=S,f.size.width=C-S;var T=Math.max(this.minY(),_.minY()),E=Math.min(this.maxY(),_.maxY());return T>E?WebInspector.Rect.ZERO_RECT:(f.origin.y=T,f.size.height=E-T,f)}unionWithRect(_){var S=Math.min(this.minX(),_.minX()),C=Math.min(this.minY(),_.minY()),f=Math.max(this.maxX(),_.maxX())-S,T=Math.max(this.maxY(),_.maxY())-C;return new WebInspector.Rect(S,C,f,T)}round(){return new WebInspector.Rect(Math.floor(this.origin.x),Math.floor(this.origin.y),Math.ceil(this.size.width),Math.ceil(this.size.height))}},WebInspector.Rect.ZERO_RECT=new WebInspector.Rect(0,0,0,0),WebInspector.EdgeInsets=class{constructor(_,S,C,f){1===arguments.length?(this.top=_,this.right=_,this.bottom=_,this.left=_):4===arguments.length&&(this.top=_,this.right=S,this.bottom=C,this.left=f)}equals(_){return this.top===_.top&&this.right===_.right&&this.bottom===_.bottom&&this.left===_.left}copy(){return new WebInspector.EdgeInsets(this.top,this.right,this.bottom,this.left)}},WebInspector.RectEdge={MIN_X:0,MIN_Y:1,MAX_X:2,MAX_Y:3},WebInspector.Quad=class{constructor(_){this.points=[new WebInspector.Point(_[0],_[1]),new WebInspector.Point(_[2],_[3]),new WebInspector.Point(_[4],_[5]),new WebInspector.Point(_[6],_[7])],this.width=Math.round(Math.sqrt(Math.pow(_[0]-_[2],2)+Math.pow(_[1]-_[3],2))),this.height=Math.round(Math.sqrt(Math.pow(_[0]-_[6],2)+Math.pow(_[1]-_[7],2)))}toProtocol(){return[this.points[0].x,this.points[0].y,this.points[1].x,this.points[1].y,this.points[2].x,this.points[2].y,this.points[3].x,this.points[3].y]}},WebInspector.Polygon=class{constructor(_){this.points=_}bounds(){var _=Number.MAX_VALUE,S=Number.MAX_VALUE,C=-Number.MAX_VALUE,f=-Number.MAX_VALUE;for(var T of this.points)_=Math.min(_,T.x),C=Math.max(C,T.x),S=Math.min(S,T.y),f=Math.max(f,T.y);return new WebInspector.Rect(_,S,C-_,f-S)}},WebInspector.CubicBezier=class{constructor(_,S,C,f){this._inPoint=new WebInspector.Point(_,S),this._outPoint=new WebInspector.Point(C,f),this._curveInfo={x:{c:3*_},y:{c:3*S}},this._curveInfo.x.b=3*(C-_)-this._curveInfo.x.c,this._curveInfo.x.a=1-this._curveInfo.x.c-this._curveInfo.x.b,this._curveInfo.y.b=3*(f-S)-this._curveInfo.y.c,this._curveInfo.y.a=1-this._curveInfo.y.c-this._curveInfo.y.b}static fromCoordinates(_){return!_||4>_.length?null:(_=_.map(Number),_.includes(NaN)?null:new WebInspector.CubicBezier(_[0],_[1],_[2],_[3]))}static fromString(_){if(!_||!_.length)return null;var S=_.toLowerCase().replace(/\s/g,"");if(!S.length)return null;if(Object.keys(WebInspector.CubicBezier.keywordValues).includes(S))return WebInspector.CubicBezier.fromCoordinates(WebInspector.CubicBezier.keywordValues[S]);var C=S.match(/^cubic-bezier\(([-\d.]+),([-\d.]+),([-\d.]+),([-\d.]+)\)$/);return C?(C.splice(0,1),WebInspector.CubicBezier.fromCoordinates(C)):null}get inPoint(){return this._inPoint}get outPoint(){return this._outPoint}copy(){return new WebInspector.CubicBezier(this._inPoint.x,this._inPoint.y,this._outPoint.x,this._outPoint.y)}toString(){var _=[this._inPoint.x,this._inPoint.y,this._outPoint.x,this._outPoint.y];for(var S in WebInspector.CubicBezier.keywordValues)if(Array.shallowEqual(WebInspector.CubicBezier.keywordValues[S],_))return S;return"cubic-bezier("+_.join(", ")+")"}solve(_,S){return this._sampleCurveY(this._solveCurveX(_,S))}_sampleCurveX(_){return((this._curveInfo.x.a*_+this._curveInfo.x.b)*_+this._curveInfo.x.c)*_}_sampleCurveY(_){return((this._curveInfo.y.a*_+this._curveInfo.y.b)*_+this._curveInfo.y.c)*_}_sampleCurveDerivativeX(_){return(3*this._curveInfo.x.a*_+2*this._curveInfo.x.b)*_+this._curveInfo.x.c}_solveCurveX(_,S){var C,f,T,E,I,R;for(T=_,R=0;8>R;R++){if(E=this._sampleCurveX(T)-_,Math.abs(E)<S)return T;if(I=this._sampleCurveDerivativeX(T),1e-6>Math.abs(I))break;T-=E/I}if(C=0,f=1,T=_,T<C)return C;if(T>f)return f;for(;C<f;){if(E=this._sampleCurveX(T),Math.abs(E-_)<S)return T;_>E?C=T:f=T,T=0.5*(f-C)+C}return T}},WebInspector.CubicBezier.keywordValues={ease:[0.25,0.1,0.25,1],"ease-in":[0.42,0,1,1],"ease-out":[0,0,0.58,1],"ease-in-out":[0.42,0,0.58,1],linear:[0,0,1,1]},WebInspector.Spring=class{constructor(_,S,C,f){this.mass=Math.max(1,_),this.stiffness=Math.max(1,S),this.damping=Math.max(0,C),this.initialVelocity=f}static fromValues(_){return!_||4>_.length?null:(_=_.map(Number),_.includes(NaN)?null:new WebInspector.Spring(..._))}static fromString(_){if(!_||!_.length)return null;let S=_.toLowerCase().trim();if(!S.length)return null;let C=S.match(/^spring\(([\d.]+)\s+([\d.]+)\s+([\d.]+)\s+([-\d.]+)\)$/);return C?WebInspector.Spring.fromValues(C.slice(1)):null}copy(){return new WebInspector.Spring(this.mass,this.stiffness,this.damping,this.initialVelocity)}toString(){return`spring(${this.mass} ${this.stiffness} ${this.damping} ${this.initialVelocity})`}solve(_){let S=Math.sqrt(this.stiffness/this.mass),C=this.damping/(2*Math.sqrt(this.stiffness*this.mass)),f=0,T=1,E=-this.initialVelocity+S;return 1>C&&(f=S*Math.sqrt(1-C*C),T=1,E=(C*S+-this.initialVelocity)/f),_=1>C?Math.exp(-_*C*S)*(T*Math.cos(f*_)+E*Math.sin(f*_)):(T+E*_)*Math.exp(-_*S),1-_}calculateDuration(_){_=_||1e-4;let S=0,C=0,f=Number.POSITIVE_INFINITY;for(;C>=_||f>=_;)C=Math.abs(1-this.solve(S)),f<_&&C>=_?f=Number.POSITIVE_INFINITY:C<f&&(f=C),S+=0.1;return S}},WebInspector.Gradient=class{constructor(_,S){this.type=_,this.stops=S}static fromString(_){var C=_.indexOf("("),f=_.substring(0,C),S;if(-1!==f.indexOf(WebInspector.Gradient.Types.Linear))S=WebInspector.Gradient.Types.Linear;else if(-1!==f.indexOf(WebInspector.Gradient.Types.Radial))S=WebInspector.Gradient.Types.Radial;else return null;for(var T=[],E=[],I="",R=0,N=C+1,L=null;L=_[N];){"("===L&&R++,")"===L&&R--;var D=","===L,M=/\s/.test(L);if(0==R&&(M?(""!=I&&E.push(I),I=""):D&&(E.push(I),T.push(E),E=[],I="")),-1==R){E.push(I),T.push(E);break}!(0<R)&&(D||M)||(I+=L),N++}if(-1!=R)return null;var P;return P=S===WebInspector.Gradient.Types.Linear?WebInspector.LinearGradient.fromComponents(T):WebInspector.RadialGradient.fromComponents(T),P&&(P.repeats=f.startsWith("repeating")),P}static stopsWithComponents(_){var S=_.map(function(E){for(;E.length;){var I=WebInspector.Color.fromString(E.shift());if(I){var R={color:I};return E.length&&"%"===E[0].substr(-1)&&(R.offset=parseFloat(E.shift())/100),R}}});if(!S.length)return null;for(var C=0,f=S.length,T;C<f;++C){if(T=S[C],!T)return null;T.offset||(T.offset=C/(f-1))}return S}stringFromStops(_){var S=_.length-1;return _.map(function(C,f){var T=C.color;return C.offset!==f/S&&(T+=" "+Math.round(1e4*C.offset)/100+"%"),T}).join(", ")}copy(){}toString(){}},WebInspector.Gradient.Types={Linear:"linear-gradient",Radial:"radial-gradient"},WebInspector.LinearGradient=class extends WebInspector.Gradient{constructor(_,S){super(WebInspector.Gradient.Types.Linear,S),this._angle=_}static fromComponents(_){let S={value:180,units:WebInspector.LinearGradient.AngleUnits.DEG};if(1===_[0].length&&!WebInspector.Color.fromString(_[0][0])){let f=_[0][0].match(/([-\d\.]+)(\w+)/);if(!f||!Object.values(WebInspector.LinearGradient.AngleUnits).includes(f[2]))return null;S.value=parseFloat(f[1]),S.units=f[2],_.shift()}else if("to"===_[0][0]){switch(_[0].shift(),_[0].sort().join(" ")){case"top":S.value=0;break;case"right top":S.value=45;break;case"right":S.value=90;break;case"bottom right":S.value=135;break;case"bottom":S.value=180;break;case"bottom left":S.value=225;break;case"left":S.value=270;break;case"left top":S.value=315;break;default:return null;}_.shift()}else if(1!==_[0].length&&!WebInspector.Color.fromString(_[0][0]))return null;var C=WebInspector.Gradient.stopsWithComponents(_);return C?new WebInspector.LinearGradient(S,C):null}set angleValue(_){this._angle.value=_}get angleValue(){return this._angle.value.maxDecimals(2)}set angleUnits(_){_===this._angle.units||(this._angle.value=this._angleValueForUnits(_),this._angle.units=_)}get angleUnits(){return this._angle.units}copy(){return new WebInspector.LinearGradient(this._angle,this.stops.concat())}toString(){let _="",S=this._angleValueForUnits(WebInspector.LinearGradient.AngleUnits.DEG);return 0===S?_+="to top":45===S?_+="to top right":90===S?_+="to right":135===S?_+="to bottom right":225===S?_+="to bottom left":270===S?_+="to left":315===S?_+="to top left":180!==S&&(_+=this.angleValue+this.angleUnits),""!=_&&(_+=", "),_+=this.stringFromStops(this.stops),(this.repeats?"repeating-":"")+this.type+"("+_+")"}_angleValueForUnits(_){if(_===this._angle.units)return this._angle.value;let S=0;switch(this._angle.units){case WebInspector.LinearGradient.AngleUnits.DEG:S=this._angle.value;break;case WebInspector.LinearGradient.AngleUnits.RAD:S=180*this._angle.value/Math.PI;break;case WebInspector.LinearGradient.AngleUnits.GRAD:S=360*(this._angle.value/400);break;case WebInspector.LinearGradient.AngleUnits.TURN:S=360*this._angle.value;break;default:return WebInspector.reportInternalError(`Unknown angle units "${this._angle.units}"`),0;}let C=0;return _===WebInspector.LinearGradient.AngleUnits.DEG?C=S:_===WebInspector.LinearGradient.AngleUnits.RAD?C=S*Math.PI/180:_===WebInspector.LinearGradient.AngleUnits.GRAD?C=400*(S/360):_===WebInspector.LinearGradient.AngleUnits.TURN?C=S/360:void 0,C}},WebInspector.LinearGradient.AngleUnits={DEG:"deg",RAD:"rad",GRAD:"grad",TURN:"turn"},WebInspector.RadialGradient=class extends WebInspector.Gradient{constructor(_,S){super(WebInspector.Gradient.Types.Radial,S),this.sizing=_}static fromComponents(_){var S=WebInspector.Color.fromString(_[0].join(" "))?"":_.shift().join(" "),C=WebInspector.Gradient.stopsWithComponents(_);return C?new WebInspector.RadialGradient(S,C):null}copy(){return new WebInspector.RadialGradient(this.sizing,this.stops.concat())}toString(){var _=this.sizing;return""!==_&&(_+=", "),_+=this.stringFromStops(this.stops),(this.repeats?"repeating-":"")+this.type+"("+_+")"}},WebInspector.HeapAllocationsInstrument=class extends WebInspector.Instrument{constructor(){super(),this._snapshotIntervalIdentifier=void 0}static supported(){return window.HeapAgent}get timelineRecordType(){return WebInspector.TimelineRecord.Type.HeapAllocations}startInstrumentation(_){_||HeapAgent.startTracking();this._snapshotIntervalIdentifier=setInterval(this._takeHeapSnapshot.bind(this),1e4)}stopInstrumentation(_){_||HeapAgent.stopTracking(),window.clearInterval(this._snapshotIntervalIdentifier),this._snapshotIntervalIdentifier=void 0}_takeHeapSnapshot(){HeapAgent.snapshot(function(_,S,C){let f=WebInspector.HeapSnapshotWorkerProxy.singleton();f.createSnapshot(C,({objectId:T,snapshot:E})=>{let I=WebInspector.HeapSnapshotProxy.deserialize(T,E);WebInspector.timelineManager.heapSnapshotAdded(S,I)})})}},WebInspector.HeapAllocationsTimelineRecord=class extends WebInspector.TimelineRecord{constructor(_,S){super(WebInspector.TimelineRecord.Type.HeapAllocations,_,_),this._timestamp=_,this._heapSnapshot=S}get timestamp(){return this._timestamp}get heapSnapshot(){return this._heapSnapshot}},WebInspector.HeapSnapshotRootPath=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._node=_||null,this._parent=C||null,this._pathComponent="string"==typeof S?S:null,this._isGlobalScope=f||!1,this._parent&&this._parent.isEmpty()&&(this._parent=null)}static emptyPath(){return new WebInspector.HeapSnapshotRootPath(null)}static pathComponentForIndividualEdge(_){switch(_.type){case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Internal:return null;case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Index:return"["+_.data+"]";case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Property:case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Variable:return WebInspector.HeapSnapshotRootPath.canPropertyNameBeDotAccess(_.data)?_.data:"["+doubleQuotedString(_.data)+"]";}}static canPropertyNameBeDotAccess(_){return /^(?![0-9])\w+$/.test(_)}get node(){return this._node}get parent(){return this._parent}get pathComponent(){return this._pathComponent}get rootNode(){return this._parent?this._parent.rootNode:this._node}get fullPath(){let _=[];for(let S=this;S&&S.pathComponent;S=S.parent)_.push(S.pathComponent);return _.reverse(),_.join("")}isRoot(){return!this._parent}isEmpty(){return!this._node}isGlobalScope(){return this._isGlobalScope}isPathComponentImpossible(){return this._pathComponent&&this._pathComponent.startsWith("@")}isFullPathImpossible(){return!!this.isEmpty()||!!this.isPathComponentImpossible()||!!this._parent&&this._parent.isFullPathImpossible()}appendInternal(_){return new WebInspector.HeapSnapshotRootPath(_,WebInspector.HeapSnapshotRootPath.SpecialPathComponent.InternalPropertyName,this)}appendArrayIndex(_,S){return new WebInspector.HeapSnapshotRootPath(_,"["+S+"]",this)}appendPropertyName(_,S){let C=WebInspector.HeapSnapshotRootPath.canPropertyNameBeDotAccess(S)?"."+S:"["+doubleQuotedString(S)+"]";return new WebInspector.HeapSnapshotRootPath(_,C,this)}appendVariableName(_,S){return this._isGlobalScope?this.appendPropertyName(_,S):new WebInspector.HeapSnapshotRootPath(_,S,this)}appendGlobalScopeName(_,S){return new WebInspector.HeapSnapshotRootPath(_,S,this,!0)}appendEdge(_){switch(_.type){case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Internal:return this.appendInternal(_.to);case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Index:return this.appendArrayIndex(_.to,_.data);case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Property:return this.appendPropertyName(_.to,_.data);case WebInspector.HeapSnapshotEdgeProxy.EdgeType.Variable:return this.appendVariableName(_.to,_.data);}console.error("Unexpected edge type",_.type)}},WebInspector.HeapSnapshotRootPath.SpecialPathComponent={InternalPropertyName:"@internal"},WebInspector.IndexedDatabase=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._name=_,this._securityOrigin=S,this._host=parseSecurityOrigin(S).host,this._version=C,this._objectStores=f||[];for(var T of this._objectStores)T.establishRelationship(this)}get name(){return this._name}get securityOrigin(){return this._securityOrigin}get host(){return this._host}get version(){return this._version}get objectStores(){return this._objectStores}saveIdentityToCookie(_){_[WebInspector.IndexedDatabase.NameCookieKey]=this._name,_[WebInspector.IndexedDatabase.HostCookieKey]=this._host}},WebInspector.IndexedDatabase.TypeIdentifier="indexed-database",WebInspector.IndexedDatabase.NameCookieKey="indexed-database-name",WebInspector.IndexedDatabase.HostCookieKey="indexed-database-host",WebInspector.IndexedDatabaseObjectStore=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._name=_,this._keyPath=S,this._autoIncrement=C||!1,this._indexes=f||[],this._parentDatabase=null;for(var T of this._indexes)T.establishRelationship(this)}get name(){return this._name}get keyPath(){return this._keyPath}get autoIncrement(){return this._autoIncrement}get parentDatabase(){return this._parentDatabase}get indexes(){return this._indexes}saveIdentityToCookie(_){_[WebInspector.IndexedDatabaseObjectStore.NameCookieKey]=this._name,_[WebInspector.IndexedDatabaseObjectStore.KeyPathCookieKey]=this._keyPath}establishRelationship(_){this._parentDatabase=_||null}},WebInspector.IndexedDatabaseObjectStore.TypeIdentifier="indexed-database-object-store",WebInspector.IndexedDatabaseObjectStore.NameCookieKey="indexed-database-object-store-name",WebInspector.IndexedDatabaseObjectStore.KeyPathCookieKey="indexed-database-object-store-key-path",WebInspector.IndexedDatabaseObjectStoreIndex=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._name=_,this._keyPath=S,this._unique=C||!1,this._multiEntry=f||!1,this._parentObjectStore=null}get name(){return this._name}get keyPath(){return this._keyPath}get unique(){return this._unique}get multiEntry(){return this._multiEntry}get parentObjectStore(){return this._parentObjectStore}saveIdentityToCookie(_){_[WebInspector.IndexedDatabaseObjectStoreIndex.NameCookieKey]=this._name,_[WebInspector.IndexedDatabaseObjectStoreIndex.KeyPathCookieKey]=this._keyPath}establishRelationship(_){this._parentObjectStore=_||null}},WebInspector.IndexedDatabaseObjectStoreIndex.TypeIdentifier="indexed-database-object-store-index",WebInspector.IndexedDatabaseObjectStoreIndex.NameCookieKey="indexed-database-object-store-index-name",WebInspector.IndexedDatabaseObjectStoreIndex.KeyPathCookieKey="indexed-database-object-store-index-key-path",WebInspector.IssueMessage=class extends WebInspector.Object{constructor(_){switch(super(),this._consoleMessage=_,this._text=this._issueText(),this._consoleMessage.source){case"javascript":var S=/^([^:]+): (?:DOM Exception \d+: )?/,C=S.exec(this._text);C&&C[1]in WebInspector.IssueMessage.Type._prefixTypeMap?(this._type=WebInspector.IssueMessage.Type._prefixTypeMap[C[1]],this._text=this._text.substring(C[0].length)):this._type=WebInspector.IssueMessage.Type.OtherIssue;break;case"css":case"xml":this._type=WebInspector.IssueMessage.Type.PageIssue;break;case"network":this._type=WebInspector.IssueMessage.Type.NetworkIssue;break;case"security":this._type=WebInspector.IssueMessage.Type.SecurityIssue;break;case"console-api":case"storage":case"appcache":case"rendering":case"other":this._type=WebInspector.IssueMessage.Type.OtherIssue;break;default:console.error("Unknown issue source:",this._consoleMessage.source),this._type=WebInspector.IssueMessage.Type.OtherIssue;}this._sourceCodeLocation=_.sourceCodeLocation,this._sourceCodeLocation&&this._sourceCodeLocation.addEventListener(WebInspector.SourceCodeLocation.Event.DisplayLocationChanged,this._sourceCodeLocationDisplayLocationChanged,this)}static displayName(_){return _===WebInspector.IssueMessage.Type.SemanticIssue?WebInspector.UIString("Semantic Issue"):_===WebInspector.IssueMessage.Type.RangeIssue?WebInspector.UIString("Range Issue"):_===WebInspector.IssueMessage.Type.ReferenceIssue?WebInspector.UIString("Reference Issue"):_===WebInspector.IssueMessage.Type.TypeIssue?WebInspector.UIString("Type Issue"):_===WebInspector.IssueMessage.Type.PageIssue?WebInspector.UIString("Page Issue"):_===WebInspector.IssueMessage.Type.NetworkIssue?WebInspector.UIString("Network Issue"):_===WebInspector.IssueMessage.Type.SecurityIssue?WebInspector.UIString("Security Issue"):_===WebInspector.IssueMessage.Type.OtherIssue?WebInspector.UIString("Other Issue"):(console.error("Unknown issue message type:",_),WebInspector.UIString("Other Issue"))}get text(){return this._text}get type(){return this._type}get level(){return this._consoleMessage.level}get source(){return this._consoleMessage.source}get url(){return this._consoleMessage.url}get sourceCodeLocation(){return this._sourceCodeLocation}saveIdentityToCookie(_){_[WebInspector.IssueMessage.URLCookieKey]=this.url,_[WebInspector.IssueMessage.LineNumberCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:0,_[WebInspector.IssueMessage.ColumnNumberCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:0}_issueText(){function _(I){return I.description}let C=this._consoleMessage.parameters;if(!C)return this._consoleMessage.messageText;if("string"!==WebInspector.RemoteObject.type(C[0]))return this._consoleMessage.messageText;let T=String.format(C[0].description,C.slice(1),{o:_,s:_,f:_,i:_,d:_},"",function(I,R){return I+=R,I}),E=T.formattedResult;for(let I=0;I<T.unusedSubstitutions.length;++I)E+=" "+T.unusedSubstitutions[I].description;return E}_sourceCodeLocationDisplayLocationChanged(_){this.dispatchEventToListeners(WebInspector.IssueMessage.Event.DisplayLocationDidChange,_.data)}},WebInspector.IssueMessage.Level={Error:"error",Warning:"warning"},WebInspector.IssueMessage.Type={SemanticIssue:"issue-message-type-semantic-issue",RangeIssue:"issue-message-type-range-issue",ReferenceIssue:"issue-message-type-reference-issue",TypeIssue:"issue-message-type-type-issue",PageIssue:"issue-message-type-page-issue",NetworkIssue:"issue-message-type-network-issue",SecurityIssue:"issue-message-type-security-issue",OtherIssue:"issue-message-type-other-issue"},WebInspector.IssueMessage.TypeIdentifier="issue-message",WebInspector.IssueMessage.URLCookieKey="issue-message-url",WebInspector.IssueMessage.LineNumberCookieKey="issue-message-line-number",WebInspector.IssueMessage.ColumnNumberCookieKey="issue-message-column-number",WebInspector.IssueMessage.Event={LocationDidChange:"issue-message-location-did-change",DisplayLocationDidChange:"issue-message-display-location-did-change"},WebInspector.IssueMessage.Type._prefixTypeMap={SyntaxError:WebInspector.IssueMessage.Type.SemanticIssue,URIError:WebInspector.IssueMessage.Type.SemanticIssue,EvalError:WebInspector.IssueMessage.Type.SemanticIssue,INVALID_CHARACTER_ERR:WebInspector.IssueMessage.Type.SemanticIssue,SYNTAX_ERR:WebInspector.IssueMessage.Type.SemanticIssue,RangeError:WebInspector.IssueMessage.Type.RangeIssue,INDEX_SIZE_ERR:WebInspector.IssueMessage.Type.RangeIssue,DOMSTRING_SIZE_ERR:WebInspector.IssueMessage.Type.RangeIssue,ReferenceError:WebInspector.IssueMessage.Type.ReferenceIssue,HIERARCHY_REQUEST_ERR:WebInspector.IssueMessage.Type.ReferenceIssue,INVALID_STATE_ERR:WebInspector.IssueMessage.Type.ReferenceIssue,NOT_FOUND_ERR:WebInspector.IssueMessage.Type.ReferenceIssue,WRONG_DOCUMENT_ERR:WebInspector.IssueMessage.Type.ReferenceIssue,TypeError:WebInspector.IssueMessage.Type.TypeIssue,INVALID_NODE_TYPE_ERR:WebInspector.IssueMessage.Type.TypeIssue,TYPE_MISMATCH_ERR:WebInspector.IssueMessage.Type.TypeIssue,SECURITY_ERR:WebInspector.IssueMessage.Type.SecurityIssue,NETWORK_ERR:WebInspector.IssueMessage.Type.NetworkIssue,ABORT_ERR:WebInspector.IssueMessage.Type.OtherIssue,DATA_CLONE_ERR:WebInspector.IssueMessage.Type.OtherIssue,INUSE_ATTRIBUTE_ERR:WebInspector.IssueMessage.Type.OtherIssue,INVALID_ACCESS_ERR:WebInspector.IssueMessage.Type.OtherIssue,INVALID_MODIFICATION_ERR:WebInspector.IssueMessage.Type.OtherIssue,NAMESPACE_ERR:WebInspector.IssueMessage.Type.OtherIssue,NOT_SUPPORTED_ERR:WebInspector.IssueMessage.Type.OtherIssue,NO_DATA_ALLOWED_ERR:WebInspector.IssueMessage.Type.OtherIssue,NO_MODIFICATION_ALLOWED_ERR:WebInspector.IssueMessage.Type.OtherIssue,QUOTA_EXCEEDED_ERR:WebInspector.IssueMessage.Type.OtherIssue,TIMEOUT_ERR:WebInspector.IssueMessage.Type.OtherIssue,URL_MISMATCH_ERR:WebInspector.IssueMessage.Type.OtherIssue,VALIDATION_ERR:WebInspector.IssueMessage.Type.OtherIssue},WebInspector.KeyboardShortcut=class extends WebInspector.Object{constructor(_,S,C,f){if(super(),"string"==typeof S&&(S=S[0].toUpperCase(),S=new WebInspector.Key(S.charCodeAt(0),S)),C&&!f&&(f=document),this._modifiers=_||WebInspector.KeyboardShortcut.Modifier.None,this._key=S,this._targetElement=f,this._callback=C,this._disabled=!1,this._implicitlyPreventsDefault=!0,f){var T=f._keyboardShortcuts;T||(T=f._keyboardShortcuts=[]),T.push(this),WebInspector.KeyboardShortcut._registeredKeyDownListener||(WebInspector.KeyboardShortcut._registeredKeyDownListener=!0,window.addEventListener("keydown",WebInspector.KeyboardShortcut._handleKeyDown))}}static _handleKeyDown(_){if(!_.defaultPrevented)for(var S=_.target;S;S=S.parentNode)if(S._keyboardShortcuts)for(var C=0,f;C<S._keyboardShortcuts.length;++C)if(f=S._keyboardShortcuts[C],f.matchesEvent(_)&&f.callback)return f.callback(_,f),void(f.implicitlyPreventsDefault&&_.preventDefault())}get modifiers(){return this._modifiers}get key(){return this._key}get displayName(){var _="";return this._modifiers&WebInspector.KeyboardShortcut.Modifier.Control&&(_+="\u2303"),this._modifiers&WebInspector.KeyboardShortcut.Modifier.Option&&(_+="mac"===WebInspector.Platform.name?"\u2325":"\u2387"),this._modifiers&WebInspector.KeyboardShortcut.Modifier.Shift&&(_+="\u21E7"),this._modifiers&WebInspector.KeyboardShortcut.Modifier.Command&&(_+="\u2318"),_+=this._key.toString(),_}get callback(){return this._callback}set callback(_){this._callback=_||null}get disabled(){return this._disabled}set disabled(_){this._disabled=_||!1}get implicitlyPreventsDefault(){return this._implicitlyPreventsDefault}set implicitlyPreventsDefault(_){this._implicitlyPreventsDefault=_}unbind(){if(this._disabled=!0,!!this._targetElement){var _=this._targetElement._keyboardShortcuts;_&&_.remove(this)}}matchesEvent(_){if(this._disabled)return!1;if(this._key.keyCode!==_.keyCode)return!1;var S=WebInspector.KeyboardShortcut.Modifier.None;return _.shiftKey&&(S|=WebInspector.KeyboardShortcut.Modifier.Shift),_.ctrlKey&&(S|=WebInspector.KeyboardShortcut.Modifier.Control),_.altKey&&(S|=WebInspector.KeyboardShortcut.Modifier.Option),_.metaKey&&(S|=WebInspector.KeyboardShortcut.Modifier.Command),this._modifiers===S}},WebInspector.Key=class{constructor(_,S){this._keyCode=_,this._displayName=S}get keyCode(){return this._keyCode}get displayName(){return this._displayName}toString(){return this._displayName}},WebInspector.KeyboardShortcut.Modifier={None:0,Shift:1,Control:2,Option:4,Command:8,get CommandOrControl(){return"mac"===WebInspector.Platform.name?this.Command:this.Control}},WebInspector.KeyboardShortcut.Key={Backspace:new WebInspector.Key(8,"\u232B"),Tab:new WebInspector.Key(9,"\u21E5"),Enter:new WebInspector.Key(13,"\u21A9"),Escape:new WebInspector.Key(27,"\u238B"),Space:new WebInspector.Key(32,"Space"),PageUp:new WebInspector.Key(33,"\u21DE"),PageDown:new WebInspector.Key(34,"\u21DF"),End:new WebInspector.Key(35,"\u2198"),Home:new WebInspector.Key(36,"\u2196"),Left:new WebInspector.Key(37,"\u2190"),Up:new WebInspector.Key(38,"\u2191"),Right:new WebInspector.Key(39,"\u2192"),Down:new WebInspector.Key(40,"\u2193"),Delete:new WebInspector.Key(46,"\u2326"),Zero:new WebInspector.Key(48,"0"),F1:new WebInspector.Key(112,"F1"),F2:new WebInspector.Key(113,"F2"),F3:new WebInspector.Key(114,"F3"),F4:new WebInspector.Key(115,"F4"),F5:new WebInspector.Key(116,"F5"),F6:new WebInspector.Key(117,"F6"),F7:new WebInspector.Key(118,"F7"),F8:new WebInspector.Key(119,"F8"),F9:new WebInspector.Key(120,"F9"),F10:new WebInspector.Key(121,"F10"),F11:new WebInspector.Key(122,"F11"),F12:new WebInspector.Key(123,"F12"),Semicolon:new WebInspector.Key(186,";"),Plus:new WebInspector.Key(187,"+"),Comma:new WebInspector.Key(188,","),Minus:new WebInspector.Key(189,"-"),Period:new WebInspector.Key(190,"."),Slash:new WebInspector.Key(191,"/"),Apostrophe:new WebInspector.Key(192,"`"),LeftCurlyBrace:new WebInspector.Key(219,"{"),Backslash:new WebInspector.Key(220,"\\"),RightCurlyBrace:new WebInspector.Key(221,"}"),SingleQuote:new WebInspector.Key(222,"'")},WebInspector.LayoutInstrument=class extends WebInspector.Instrument{get timelineRecordType(){return WebInspector.TimelineRecord.Type.Layout}},WebInspector.LayoutTimelineRecord=class extends WebInspector.TimelineRecord{constructor(_,S,C,f,T,E){super(WebInspector.TimelineRecord.Type.Layout,S,C,f,T),_ in WebInspector.LayoutTimelineRecord.EventType&&(_=WebInspector.LayoutTimelineRecord.EventType[_]),this._eventType=_,this._quad=E||null}static displayNameForEventType(_){return _===WebInspector.LayoutTimelineRecord.EventType.InvalidateStyles?WebInspector.UIString("Styles Invalidated"):_===WebInspector.LayoutTimelineRecord.EventType.RecalculateStyles?WebInspector.UIString("Styles Recalculated"):_===WebInspector.LayoutTimelineRecord.EventType.InvalidateLayout?WebInspector.UIString("Layout Invalidated"):_===WebInspector.LayoutTimelineRecord.EventType.ForcedLayout?WebInspector.UIString("Forced Layout"):_===WebInspector.LayoutTimelineRecord.EventType.Layout?WebInspector.UIString("Layout"):_===WebInspector.LayoutTimelineRecord.EventType.Paint?WebInspector.UIString("Paint"):_===WebInspector.LayoutTimelineRecord.EventType.Composite?WebInspector.UIString("Composite"):void 0}get eventType(){return this._eventType}get width(){return this._quad?this._quad.width:NaN}get height(){return this._quad?this._quad.height:NaN}get area(){return this.width*this.height}get quad(){return this._quad}saveIdentityToCookie(_){super.saveIdentityToCookie(_),_[WebInspector.LayoutTimelineRecord.EventTypeCookieKey]=this._eventType}},WebInspector.LayoutTimelineRecord.EventType={InvalidateStyles:"layout-timeline-record-invalidate-styles",RecalculateStyles:"layout-timeline-record-recalculate-styles",InvalidateLayout:"layout-timeline-record-invalidate-layout",ForcedLayout:"layout-timeline-record-forced-layout",Layout:"layout-timeline-record-layout",Paint:"layout-timeline-record-paint",Composite:"layout-timeline-record-composite"},WebInspector.LayoutTimelineRecord.TypeIdentifier="layout-timeline-record",WebInspector.LayoutTimelineRecord.EventTypeCookieKey="layout-timeline-record-event-type",WebInspector.LazySourceCodeLocation=class extends WebInspector.SourceCodeLocation{constructor(_,S,C){super(null,S,C),this._initialized=!1,this._lazySourceCode=_}isEqual(_){return!!_&&this._lazySourceCode===_._sourceCode&&this._lineNumber===_._lineNumber&&this._columnNumber===_._columnNumber}get sourceCode(){return this._lazySourceCode}set sourceCode(_){this.setSourceCode(_)}get formattedLineNumber(){return this._lazyInitialization(),this._formattedLineNumber}get formattedColumnNumber(){return this._lazyInitialization(),this._formattedColumnNumber}formattedPosition(){return this._lazyInitialization(),new WebInspector.SourceCodePosition(this._formattedLineNumber,this._formattedColumnNumber)}hasFormattedLocation(){return this._lazyInitialization(),super.hasFormattedLocation()}hasDifferentDisplayLocation(){return this._lazyInitialization(),super.hasDifferentDisplayLocation()}resolveMappedLocation(){this._lazyInitialization(),super.resolveMappedLocation()}_lazyInitialization(){this._initialized||(this._initialized=!0,this.sourceCode=this._lazySourceCode)}},WebInspector.LineWidget=class extends WebInspector.Object{constructor(_,S){super(),this._codeMirrorLineWidget=_,this._widgetElement=S}get codeMirrorLineWidget(){return this._codeMirrorLineWidget}get widgetElement(){return this._widgetElement}clear(){this._codeMirrorLineWidget.clear()}update(){this._codeMirrorLineWidget.update&&this._codeMirrorLineWidget.update()}},WebInspector.LogObject=class extends WebInspector.Object{constructor(){super(),this._startDate=new Date}get startDate(){return this._startDate}},WebInspector.MemoryCategory=class extends WebInspector.Object{constructor(_,S){super(),this.type=_,this.size=S}},WebInspector.MemoryCategory.Type={JavaScript:"javascript",Images:"images",Layers:"layers",Page:"page"},WebInspector.MemoryInstrument=class extends WebInspector.Instrument{constructor(){super()}static supported(){return window.MemoryAgent}get timelineRecordType(){return WebInspector.TimelineRecord.Type.Memory}startInstrumentation(_){_||MemoryAgent.startTracking()}stopInstrumentation(_){_||MemoryAgent.stopTracking()}},WebInspector.MemoryPressureEvent=class extends WebInspector.Object{constructor(_,S){super(),this._timestamp=_,this._severity=S}static fromPayload(_,S){let C;switch(S){case MemoryAgent.MemoryPressureSeverity.Critical:C=WebInspector.MemoryPressureEvent.Severity.Critical;break;case MemoryAgent.MemoryPressureSeverity.NonCritical:C=WebInspector.MemoryPressureEvent.Severity.NonCritical;break;default:console.error("Unexpected memory pressure severity",S),C=WebInspector.MemoryPressureEvent.Severity.NonCritical;}return new WebInspector.MemoryPressureEvent(_,C)}get timestamp(){return this._timestamp}get severity(){return this._severity}},WebInspector.MemoryPressureEvent.Severity={Critical:Symbol("Critical"),NonCritical:Symbol("NonCritical")},WebInspector.MemoryTimeline=class extends WebInspector.Timeline{get memoryPressureEvents(){return this._pressureEvents}addMemoryPressureEvent(_){this._pressureEvents.push(_),this.dispatchEventToListeners(WebInspector.MemoryTimeline.Event.MemoryPressureEventAdded,{memoryPressureEvent:_})}reset(_){super.reset(_),this._pressureEvents=[]}},WebInspector.MemoryTimeline.Event={MemoryPressureEventAdded:"memory-timeline-memory-pressure-event-added"},WebInspector.MemoryTimelineRecord=class extends WebInspector.TimelineRecord{constructor(_,S){super(WebInspector.TimelineRecord.Type.Memory,_,_),this._timestamp=_,this._categories=WebInspector.MemoryTimelineRecord.memoryCategoriesFromProtocol(S),this._totalSize=0;for(let{size:C}of S)this._totalSize+=C}static memoryCategoriesFromProtocol(_){let S=0,C=0,f=0,T=0;for(let{type:E,size:I}of _)switch(E){case MemoryAgent.CategoryDataType.Javascript:case MemoryAgent.CategoryDataType.JIT:S+=I;break;case MemoryAgent.CategoryDataType.Images:C+=I;break;case MemoryAgent.CategoryDataType.Layers:f+=I;break;case MemoryAgent.CategoryDataType.Page:case MemoryAgent.CategoryDataType.Other:T+=I;break;default:console.warn("Unhandled Memory.CategoryDataType: "+E);}return[{type:WebInspector.MemoryCategory.Type.JavaScript,size:S},{type:WebInspector.MemoryCategory.Type.Images,size:C},{type:WebInspector.MemoryCategory.Type.Layers,size:f},{type:WebInspector.MemoryCategory.Type.Page,size:T}]}get timestamp(){return this._timestamp}get categories(){return this._categories}get totalSize(){return this._totalSize}},WebInspector.NativeConstructorFunctionParameters={Object:{assign:"target, ...sources",create:"prototype, [propertiesObject]",defineProperties:"object, properties",defineProperty:"object, propertyName, descriptor",freeze:"object",getOwnPropertyDescriptor:"object, propertyName",getOwnPropertyNames:"object",getOwnPropertySymbols:"object",getPrototypeOf:"object",is:"value1, value2",isExtensible:"object",isFrozen:"object",isSealed:"object",keys:"object",preventExtensions:"object",seal:"object",setPrototypeOf:"object, prototype",__proto__:null},Array:{from:"arrayLike, [mapFunction], [thisArg]",isArray:"object",of:"[...values]",__proto__:null},ArrayBuffer:{isView:"object",transfer:"oldBuffer, [newByteLength=length]",__proto__:null},Number:{isFinite:"value",isInteger:"value",isNaN:"value",isSafeInteger:"value",parseFloat:"string",parseInt:"string, [radix]",__proto__:null},Math:{abs:"x",acos:"x",acosh:"x",asin:"x",asinh:"x",atan2:"y, x",atan:"x",atanh:"x",cbrt:"x",ceil:"x",clz32:"x",cos:"x",cosh:"x",exp:"x",expm1:"x",floor:"x",fround:"x",hypot:"[...x]",imul:"x",log:"x",log1p:"x",log2:"x",log10:"x",max:"[...x]",min:"[...x]",pow:"x, y",round:"x",sign:"x",sin:"x",sinh:"x",sqrt:"x",tan:"x",tanh:"x",trunc:"x",__proto__:null},JSON:{parse:"text, [reviver]",stringify:"value, [replacer], [space]",__proto__:null},Date:{parse:"dateString",UTC:"year, [month], [day], [hour], [minute], [second], [ms]",__proto__:null},Promise:{all:"iterable",race:"iterable",reject:"reason",resolve:"value",__proto__:null},Reflect:{apply:"target, thisArgument, argumentsList",construct:"target, argumentsList, [newTarget=target]",defineProperty:"target, propertyKey, attributes",deleteProperty:"target, propertyKey",get:"target, propertyKey, [receiver]",getOwnPropertyDescriptor:"target, propertyKey",getPrototypeOf:"target",has:"target, propertyKey",isExtensible:"target",ownKeys:"target",preventExtensions:"target",set:"target, propertyKey, value, [receiver]",setPrototypeOf:"target, prototype",__proto__:null},String:{fromCharCode:"...codeUnits",fromCodePoint:"...codePoints",raw:"template, ...substitutions",__proto__:null},Symbol:{for:"key",keyFor:"symbol",__proto__:null},Console:{assert:"condition, [message], [...values]",count:"[label]",debug:"message, [...values]",dir:"object",dirxml:"object",error:"message, [...values]",group:"[name]",groupCollapsed:"[name]",groupEnd:"[name]",info:"message, [...values]",log:"message, [...values]",profile:"name",profileEnd:"name",table:"data, [columns]",takeHeapSnapshot:"[label]",time:"name = \"default\"",timeEnd:"name = \"default\"",timeStamp:"[label]",trace:"message, [...values]",warn:"message, [...values]",__proto__:null},IDBKeyRangeConstructor:{bound:"lower, upper, [lowerOpen], [upperOpen]",lowerBound:"lower, [open]",only:"value",upperBound:"upper, [open]",__proto__:null},MediaSourceConstructor:{isTypeSupported:"type",__proto__:null},MediaStreamTrackConstructor:{getSources:"callback",__proto__:null},NotificationConstructor:{requestPermission:"[callback]",__proto__:null},URLConstructor:{createObjectURL:"blob",revokeObjectURL:"url",__proto__:null},WebKitMediaKeysConstructor:{isTypeSupported:"keySystem, [type]",__proto__:null}},WebInspector.NativePrototypeFunctionParameters={Object:{__defineGetter__:"propertyName, getterFunction",__defineSetter__:"propertyName, setterFunction",__lookupGetter__:"propertyName",__lookupSetter__:"propertyName",hasOwnProperty:"propertyName",isPrototypeOf:"property",propertyIsEnumerable:"propertyName",__proto__:null},Array:{concat:"value, ...",copyWithin:"targetIndex, startIndex, [endIndex=length]",every:"callback, [thisArg]",fill:"value, [startIndex=0], [endIndex=length]",filter:"callback, [thisArg]",find:"callback, [thisArg]",findIndex:"callback, [thisArg]",forEach:"callback, [thisArg]",includes:"searchValue, [startIndex=0]",indexOf:"searchValue, [startIndex=0]",join:"[separator=\",\"]",lastIndexOf:"searchValue, [startIndex=length]",map:"callback, [thisArg]",push:"value, ...",reduce:"callback, [initialValue]",reduceRight:"callback, [initialValue]",slice:"[startIndex=0], [endIndex=length]",some:"callback, [thisArg]",sort:"[compareFunction]",splice:"startIndex, [deleteCount=0], ...itemsToAdd",__proto__:null},ArrayBuffer:{slice:"startIndex, [endIndex=byteLength]",__proto__:null},DataView:{setInt8:"byteOffset, value",setInt16:"byteOffset, value, [littleEndian=false]",setInt23:"byteOffset, value, [littleEndian=false]",setUint8:"byteOffset, value",setUint16:"byteOffset, value, [littleEndian=false]",setUint32:"byteOffset, value, [littleEndian=false]",setFloat32:"byteOffset, value, [littleEndian=false]",setFloat64:"byteOffset, value, [littleEndian=false]",getInt8:"byteOffset",getInt16:"byteOffset, [littleEndian=false]",getInt23:"byteOffset, [littleEndian=false]",getUint8:"byteOffset",getUint16:"byteOffset, [littleEndian=false]",getUint32:"byteOffset, [littleEndian=false]",getFloat32:"byteOffset, [littleEndian=false]",getFloat64:"byteOffset, [littleEndian=false]",__proto__:null},Date:{setDate:"day",setFullYear:"year, [month=getMonth()], [day=getDate()]",setHours:"hours, [minutes=getMinutes()], [seconds=getSeconds()], [ms=getMilliseconds()]",setMilliseconds:"ms",setMinutes:"minutes, [seconds=getSeconds()], [ms=getMilliseconds()]",setMonth:"month, [day=getDate()]",setSeconds:"seconds, [ms=getMilliseconds()]",setTime:"time",setUTCDate:"day",setUTCFullYear:"year, [month=getUTCMonth()], [day=getUTCDate()]",setUTCHours:"hours, [minutes=getUTCMinutes()], [seconds=getUTCSeconds()], [ms=getUTCMilliseconds()]",setUTCMilliseconds:"ms",setUTCMinutes:"minutes, [seconds=getUTCSeconds()], [ms=getUTCMilliseconds()]",setUTCMonth:"month, [day=getUTCDate()]",setUTCSeconds:"seconds, [ms=getUTCMilliseconds()]",setUTCTime:"time",setYear:"year",__proto__:null},Function:{apply:"thisObject, [argumentsArray]",bind:"thisObject, ...arguments",call:"thisObject, ...arguments",__proto__:null},Map:{delete:"key",forEach:"callback, [thisArg]",get:"key",has:"key",set:"key, value",__proto__:null},Number:{toExponential:"[digits]",toFixed:"[digits]",toPrecision:"[significantDigits]",toString:"[radix=10]",__proto__:null},RegExp:{compile:"pattern, flags",exec:"string",test:"string",__proto__:null},Set:{delete:"value",forEach:"callback, [thisArg]",has:"value",add:"value",__proto__:null},String:{charAt:"index",charCodeAt:"index",codePoints:"index",concat:"string, ...",includes:"searchValue, [startIndex=0]",indexOf:"searchValue, [startIndex=0]",lastIndexOf:"searchValue, [startIndex=length]",localeCompare:"string",match:"regex",repeat:"count",replace:"regex|string, replaceString|replaceHandler, [flags]",search:"regex",slice:"startIndex, [endIndex=length]",split:"[separator], [limit]",substr:"startIndex, [numberOfCharacters]",substring:"startIndex, [endIndex=length]",__proto__:null},WeakMap:{delete:"key",get:"key",has:"key",set:"key, value",__proto__:null},WeakSet:{delete:"value",has:"value",add:"value",__proto__:null},Promise:{catch:"rejectionHandler",then:"resolvedHandler, rejectionHandler",__proto__:null},Generator:{next:"value",return:"value",throw:"exception",__proto__:null},Element:{closest:"selectors",getAttribute:"attributeName",getAttributeNS:"namespace, attributeName",getAttributeNode:"attributeName",getAttributeNodeNS:"namespace, attributeName",hasAttribute:"attributeName",hasAttributeNS:"namespace, attributeName",matches:"selector",removeAttribute:"attributeName",removeAttributeNS:"namespace, attributeName",removeAttributeNode:"attributeName",scrollIntoView:"[alignWithTop]",scrollIntoViewIfNeeded:"[centerIfNeeded]",setAttribute:"name, value",setAttributeNS:"namespace, name, value",setAttributeNode:"attributeNode",setAttributeNodeNS:"namespace, attributeNode",webkitMatchesSelector:"selectors",__proto__:null},Node:{appendChild:"child",cloneNode:"[deep]",compareDocumentPosition:"[node]",contains:"[node]",insertBefore:"insertElement, referenceElement",isDefaultNamespace:"[namespace]",isEqualNode:"[node]",lookupNamespaceURI:"prefix",removeChild:"node",replaceChild:"newChild, oldChild",__proto__:null},Window:{alert:"[message]",atob:"encodedData",btoa:"stringToEncode",cancelAnimationFrame:"id",clearInterval:"intervalId",clearTimeout:"timeoutId",confirm:"[message]",find:"string, [caseSensitive], [backwards], [wrapAround]",getComputedStyle:"[element], [pseudoElement]",getMatchedCSSRules:"[element], [pseudoElement]",matchMedia:"mediaQueryString",moveBy:"[deltaX], [deltaY]",moveTo:"[screenX], [screenY]",open:"url, windowName, [featuresString]",openDatabase:"name, version, displayName, estimatedSize, [creationCallback]",postMessage:"message, targetOrigin, [...transferables]",prompt:"[message], [value]",requestAnimationFrame:"callback",resizeBy:"[deltaX], [deltaY]",resizeTo:"[width], [height]",scrollBy:"[deltaX], [deltaY]",scrollTo:"[x], [y]",setInterval:"func, [delay], [...params]",setTimeout:"func, [delay], [...params]",showModalDialog:"url, [arguments], [options]",__proto__:null},Document:{adoptNode:"[node]",caretRangeFromPoint:"[x], [y]",createAttribute:"attributeName",createAttributeNS:"namespace, qualifiedName",createCDATASection:"data",createComment:"data",createElement:"tagName",createElementNS:"namespace, qualifiedName",createEntityReference:"name",createEvent:"type",createExpression:"xpath, resolver",createNSResolver:"node",createNodeIterator:"root, whatToShow, filter",createProcessingInstruction:"target, data",createTextNode:"data",createTreeWalker:"root, whatToShow, filter, entityReferenceExpansion",elementFromPoint:"x, y",evaluate:"xpath, contextNode, namespaceResolver, resultType, result",execCommand:"command, userInterface, value",getCSSCanvasContext:"contextId, name, width, height",getElementById:"id",getElementsByName:"name",getOverrideStyle:"[element], [pseudoElement]",importNode:"node, deep",queryCommandEnabled:"command",queryCommandIndeterm:"command",queryCommandState:"command",queryCommandSupported:"command",queryCommandValue:"command",__proto__:null},ANGLEInstancedArrays:{drawArraysInstancedANGLE:"mode, first, count, primcount",drawElementsInstancedANGLE:"mode, count, type, offset, primcount",vertexAttribDivisorANGLE:"index, divisor",__proto__:null},AnalyserNode:{getByteFrequencyData:"array",getByteTimeDomainData:"array",getFloatFrequencyData:"array",__proto__:null},AudioBuffer:{getChannelData:"channelIndex",__proto__:null},AudioBufferCallback:{handleEvent:"audioBuffer",__proto__:null},AudioBufferSourceNode:{noteGrainOn:"when, grainOffset, grainDuration",noteOff:"when",noteOn:"when",start:"[when], [grainOffset], [grainDuration]",stop:"[when]",__proto__:null},AudioListener:{setOrientation:"x, y, z, xUp, yUp, zUp",setPosition:"x, y, z",setVelocity:"x, y, z",__proto__:null},AudioNode:{connect:"destination, [output], [input]",disconnect:"[output]",__proto__:null},AudioParam:{cancelScheduledValues:"startTime",exponentialRampToValueAtTime:"value, time",linearRampToValueAtTime:"value, time",setTargetAtTime:"target, time, timeConstant",setTargetValueAtTime:"targetValue, time, timeConstant",setValueAtTime:"value, time",setValueCurveAtTime:"values, time, duration",__proto__:null},AudioTrackList:{getTrackById:"id",item:"index",__proto__:null},BiquadFilterNode:{getFrequencyResponse:"frequencyHz, magResponse, phaseResponse",__proto__:null},Blob:{slice:"[start], [end], [contentType]",__proto__:null},CSS:{supports:"property, value",__proto__:null},CSSKeyframesRule:{appendRule:"[rule]",deleteRule:"[key]",findRule:"[key]",insertRule:"[rule]",__proto__:null},CSSMediaRule:{deleteRule:"[index]",insertRule:"[rule], [index]",__proto__:null},CSSPrimitiveValue:{getFloatValue:"[unitType]",setFloatValue:"[unitType], [floatValue]",setStringValue:"[stringType], [stringValue]",__proto__:null},CSSRuleList:{item:"[index]",__proto__:null},CSSStyleDeclaration:{getPropertyCSSValue:"[propertyName]",getPropertyPriority:"[propertyName]",getPropertyShorthand:"[propertyName]",getPropertyValue:"[propertyName]",isPropertyImplicit:"[propertyName]",item:"[index]",removeProperty:"[propertyName]",setProperty:"[propertyName], [value], [priority]",__proto__:null},CSSStyleSheet:{addRule:"[selector], [style], [index]",deleteRule:"[index]",insertRule:"[rule], [index]",removeRule:"[index]",__proto__:null},CSSSupportsRule:{deleteRule:"[index]",insertRule:"[rule], [index]",__proto__:null},CSSValueList:{item:"[index]",__proto__:null},CanvasGradient:{addColorStop:"[offset], [color]",__proto__:null},CanvasRenderingContext2D:{arc:"x, y, radius, startAngle, endAngle, [anticlockwise]",arcTo:"x1, y1, x2, y2, radius",bezierCurveTo:"cp1x, cp1y, cp2x, cp2y, x, y",clearRect:"x, y, width, height",clip:"path, [winding]",createImageData:"imagedata",createLinearGradient:"x0, y0, x1, y1",createPattern:"canvas, repetitionType",createRadialGradient:"x0, y0, r0, x1, y1, r1",drawFocusIfNeeded:"element",drawImage:"image, x, y",drawImageFromRect:"image, [sx], [sy], [sw], [sh], [dx], [dy], [dw], [dh], [compositeOperation]",ellipse:"x, y, radiusX, radiusY, rotation, startAngle, endAngle, [anticlockwise]",fill:"path, [winding]",fillRect:"x, y, width, height",fillText:"text, x, y, [maxWidth]",getImageData:"sx, sy, sw, sh",isPointInPath:"path, x, y, [winding]",isPointInStroke:"path, x, y",lineTo:"x, y",measureText:"text",moveTo:"x, y",putImageData:"imagedata, dx, dy",quadraticCurveTo:"cpx, cpy, x, y",rect:"x, y, width, height",rotate:"angle",scale:"sx, sy",setAlpha:"[alpha]",setCompositeOperation:"[compositeOperation]",setFillColor:"color, [alpha]",setLineCap:"[cap]",setLineDash:"dash",setLineJoin:"[join]",setLineWidth:"[width]",setMiterLimit:"[limit]",setShadow:"width, height, blur, [color], [alpha]",setStrokeColor:"color, [alpha]",setTransform:"m11, m12, m21, m22, dx, dy",stroke:"path",strokeRect:"x, y, width, height",strokeText:"text, x, y, [maxWidth]",transform:"m11, m12, m21, m22, dx, dy",translate:"tx, ty",webkitGetImageDataHD:"sx, sy, sw, sh",webkitPutImageDataHD:"imagedata, dx, dy",__proto__:null},CharacterData:{appendData:"[data]",deleteData:"[offset], [length]",insertData:"[offset], [data]",replaceData:"[offset], [length], [data]",substringData:"[offset], [length]",__proto__:null},CommandLineAPIHost:{copyText:"text",databaseId:"database",getEventListeners:"node",inspect:"objectId, hints",storageId:"storage",__proto__:null},CompositionEvent:{initCompositionEvent:"[typeArg], [canBubbleArg], [cancelableArg], [viewArg], [dataArg]",__proto__:null},Crypto:{getRandomValues:"array",__proto__:null},CustomElementRegistry:{define:"name, constructor",get:"name",whenDefined:"name",__proto__:null},CustomEvent:{initCustomEvent:"type, [bubbles], [cancelable], [detail]",__proto__:null},DOMApplicationCache:{__proto__:null},DOMImplementation:{createCSSStyleSheet:"[title], [media]",createDocument:"[namespaceURI], [qualifiedName], [doctype]",createDocumentType:"[qualifiedName], [publicId], [systemId]",createHTMLDocument:"[title]",hasFeature:"[feature], [version]",__proto__:null},DOMParser:{parseFromString:"[str], [contentType]",__proto__:null},DOMStringList:{contains:"[string]",item:"[index]",__proto__:null},DOMTokenList:{add:"tokens...",contains:"token",item:"index",remove:"tokens...",toggle:"token, [force]",__proto__:null},DataTransfer:{clearData:"[type]",getData:"type",setData:"type, data",setDragImage:"image, x, y",__proto__:null},DataTransferItem:{getAsString:"[callback]",__proto__:null},DataTransferItemList:{add:"file",item:"[index]",__proto__:null},Database:{changeVersion:"oldVersion, newVersion, [callback], [errorCallback], [successCallback]",readTransaction:"callback, [errorCallback], [successCallback]",transaction:"callback, [errorCallback], [successCallback]",__proto__:null},DatabaseCallback:{handleEvent:"database",__proto__:null},DedicatedWorkerGlobalScope:{postMessage:"message, [messagePorts]",__proto__:null},DeviceMotionEvent:{initDeviceMotionEvent:"[type], [bubbles], [cancelable], [acceleration], [accelerationIncludingGravity], [rotationRate], [interval]",__proto__:null},DeviceOrientationEvent:{initDeviceOrientationEvent:"[type], [bubbles], [cancelable], [alpha], [beta], [gamma], [absolute]",__proto__:null},DocumentFragment:{getElementById:"id",querySelector:"selectors",querySelectorAll:"selectors",__proto__:null},Event:{initEvent:"type, [bubbles], [cancelable]",__proto__:null},FileList:{item:"index",__proto__:null},FileReader:{readAsArrayBuffer:"blob",readAsBinaryString:"blob",readAsDataURL:"blob",readAsText:"blob, [encoding]",__proto__:null},FileReaderSync:{readAsArrayBuffer:"blob",readAsBinaryString:"blob",readAsDataURL:"blob",readAsText:"blob, [encoding]",__proto__:null},FontFaceSet:{add:"font",check:"font, [text=\" \"]",delete:"font",load:"font, [text=\" \"]",__proto__:null},FormData:{append:"[name], [value], [filename]",__proto__:null},Geolocation:{clearWatch:"watchID",getCurrentPosition:"successCallback, [errorCallback], [options]",watchPosition:"successCallback, [errorCallback], [options]",__proto__:null},HTMLAllCollection:{item:"[index]",namedItem:"name",tags:"name",__proto__:null},HTMLButtonElement:{setCustomValidity:"error",__proto__:null},HTMLCanvasElement:{getContext:"contextId",toDataURL:"[type]",__proto__:null},HTMLCollection:{item:"[index]",namedItem:"[name]",__proto__:null},HTMLDocument:{write:"[html]",writeln:"[html]",__proto__:null},HTMLElement:{insertAdjacentElement:"[position], [element]",insertAdjacentHTML:"[position], [html]",insertAdjacentText:"[position], [text]",__proto__:null},HTMLFieldSetElement:{setCustomValidity:"error",__proto__:null},HTMLFormControlsCollection:{namedItem:"[name]",__proto__:null},HTMLInputElement:{setCustomValidity:"error",setRangeText:"replacement",setSelectionRange:"start, end, [direction]",stepDown:"[n]",stepUp:"[n]",__proto__:null},HTMLKeygenElement:{setCustomValidity:"error",__proto__:null},HTMLMediaElement:{addTextTrack:"kind, [label], [language]",canPlayType:"[type], [keySystem]",fastSeek:"time",webkitAddKey:"keySystem, key, [initData], [sessionId]",webkitCancelKeyRequest:"keySystem, [sessionId]",webkitGenerateKeyRequest:"keySystem, [initData]",webkitSetMediaKeys:"mediaKeys",__proto__:null},HTMLObjectElement:{setCustomValidity:"error",__proto__:null},HTMLOptionsCollection:{add:"element, [before]",namedItem:"[name]",remove:"[index]",__proto__:null},HTMLOutputElement:{setCustomValidity:"error",__proto__:null},HTMLSelectElement:{add:"element, [before]",item:"index",namedItem:"[name]",setCustomValidity:"error",__proto__:null},HTMLSlotElement:{assignedNodes:"[options]",__proto__:null},HTMLTableElement:{deleteRow:"index",insertRow:"[index]",__proto__:null},HTMLTableRowElement:{deleteCell:"index",insertCell:"[index]",__proto__:null},HTMLTableSectionElement:{deleteRow:"index",insertRow:"[index]",__proto__:null},HTMLTextAreaElement:{setCustomValidity:"error",setRangeText:"replacement",setSelectionRange:"[start], [end], [direction]",__proto__:null},HTMLVideoElement:{webkitSetPresentationMode:"mode",webkitSupportsPresentationMode:"mode",__proto__:null},HashChangeEvent:{initHashChangeEvent:"[type], [canBubble], [cancelable], [oldURL], [newURL]",__proto__:null},History:{go:"[distance]",pushState:"data, title, [url]",replaceState:"data, title, [url]",__proto__:null},IDBCursor:{advance:"count",continue:"[key]",update:"value",__proto__:null},IDBDatabase:{createObjectStore:"name, [options]",deleteObjectStore:"name",transaction:"storeName, [mode]",__proto__:null},IDBFactory:{cmp:"first, second",deleteDatabase:"name",open:"name, [version]",__proto__:null},IDBIndex:{count:"[range]",get:"key",getKey:"key",openCursor:"[range], [direction]",openKeyCursor:"[range], [direction]",__proto__:null},IDBObjectStore:{add:"value, [key]",count:"[range]",createIndex:"name, keyPath, [options]",delete:"keyRange",deleteIndex:"name",get:"key",index:"name",openCursor:"[range], [direction]",put:"value, [key]",__proto__:null},IDBTransaction:{objectStore:"name",__proto__:null},KeyboardEvent:{initKeyboardEvent:"[type], [canBubble], [cancelable], [view], [keyIdentifier], [location], [ctrlKey], [altKey], [shiftKey], [metaKey], [altGraphKey]",__proto__:null},Location:{assign:"[url]",reload:"[force=false]",replace:"[url]",__proto__:null},MediaController:{__proto__:null},MediaControlsHost:{displayNameForTrack:"track",mediaUIImageData:"partID",setSelectedTextTrack:"track",sortedTrackListForMenu:"trackList",__proto__:null},MediaList:{appendMedium:"[newMedium]",deleteMedium:"[oldMedium]",item:"[index]",__proto__:null},MediaQueryList:{addListener:"[listener]",removeListener:"[listener]",__proto__:null},MediaQueryListListener:{queryChanged:"[list]",__proto__:null},MediaSource:{addSourceBuffer:"type",endOfStream:"[error]",removeSourceBuffer:"buffer",__proto__:null},MediaStreamTrack:{applyConstraints:"constraints",__proto__:null},MediaStreamTrackSourcesCallback:{handleEvent:"sources",__proto__:null},MessageEvent:{initMessageEvent:"type, [bubbles], [cancelable], [data], [origin], [lastEventId], [source], [messagePorts]",__proto__:null},MessagePort:{__proto__:null},MimeTypeArray:{item:"[index]",namedItem:"[name]",__proto__:null},MouseEvent:{initMouseEvent:"[type], [canBubble], [cancelable], [view], [detail], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey], [button], [relatedTarget]",__proto__:null},MutationEvent:{initMutationEvent:"[type], [canBubble], [cancelable], [relatedNode], [prevValue], [newValue], [attrName], [attrChange]",__proto__:null},MutationObserver:{observe:"target, options",__proto__:null},NamedNodeMap:{getNamedItem:"[name]",getNamedItemNS:"[namespaceURI], [localName]",item:"[index]",removeNamedItem:"[name]",removeNamedItemNS:"[namespaceURI], [localName]",setNamedItem:"[node]",setNamedItemNS:"[node]",__proto__:null},Navigator:{getUserMedia:"options, successCallback, errorCallback",__proto__:null},NavigatorUserMediaErrorCallback:{handleEvent:"error",__proto__:null},NavigatorUserMediaSuccessCallback:{handleEvent:"stream",__proto__:null},NodeFilter:{acceptNode:"[n]",__proto__:null},NodeList:{item:"index",__proto__:null},Notification:{__proto__:null},NotificationCenter:{createNotification:"iconUrl, title, body",requestPermission:"[callback]",__proto__:null},NotificationPermissionCallback:{handleEvent:"permission",__proto__:null},OESVertexArrayObject:{bindVertexArrayOES:"[arrayObject]",deleteVertexArrayOES:"[arrayObject]",isVertexArrayOES:"[arrayObject]",__proto__:null},OscillatorNode:{noteOff:"when",noteOn:"when",setPeriodicWave:"wave",start:"[when]",stop:"[when]",__proto__:null},Path2D:{addPath:"path, [transform]",arc:"[x], [y], [radius], [startAngle], [endAngle], [anticlockwise]",arcTo:"[x1], [y1], [x2], [y2], [radius]",bezierCurveTo:"[cp1x], [cp1y], [cp2x], [cp2y], [x], [y]",ellipse:"x, y, radiusX, radiusY, rotation, startAngle, endAngle, [anticlockwise]",lineTo:"[x], [y]",moveTo:"[x], [y]",quadraticCurveTo:"[cpx], [cpy], [x], [y]",rect:"[x], [y], [width], [height]",__proto__:null},Performance:{clearMarks:"[name]",clearMeasures:"name",getEntriesByName:"name, [type]",getEntriesByType:"type",mark:"name",measure:"name, [startMark], [endMark]",__proto__:null},PerformanceObserver:{observe:"options",__proto__:null},PerformanceObserverEntryList:{getEntriesByName:"name, [type]",getEntriesByType:"type",__proto__:null},Plugin:{item:"[index]",namedItem:"[name]",__proto__:null},PluginArray:{item:"[index]",namedItem:"[name]",refresh:"[reload]",__proto__:null},PositionCallback:{handleEvent:"position",__proto__:null},PositionErrorCallback:{handleEvent:"error",__proto__:null},QuickTimePluginReplacement:{postEvent:"eventName",__proto__:null},RTCDTMFSender:{insertDTMF:"tones, [duration], [interToneGap]",__proto__:null},RTCDataChannel:{send:"data",__proto__:null},RTCPeerConnectionErrorCallback:{handleEvent:"error",__proto__:null},RTCSessionDescriptionCallback:{handleEvent:"sdp",__proto__:null},RTCStatsCallback:{handleEvent:"response",__proto__:null},RTCStatsReport:{stat:"name",__proto__:null},RTCStatsResponse:{namedItem:"[name]",__proto__:null},Range:{collapse:"[toStart]",compareBoundaryPoints:"[how], [sourceRange]",compareNode:"[refNode]",comparePoint:"[refNode], [offset]",createContextualFragment:"[html]",expand:"[unit]",insertNode:"[newNode]",intersectsNode:"[refNode]",isPointInRange:"[refNode], [offset]",selectNode:"[refNode]",selectNodeContents:"[refNode]",setEnd:"[refNode], [offset]",setEndAfter:"[refNode]",setEndBefore:"[refNode]",setStart:"[refNode], [offset]",setStartAfter:"[refNode]",setStartBefore:"[refNode]",surroundContents:"[newParent]",__proto__:null},ReadableStream:{cancel:"reason",pipeThrough:"dest, options",pipeTo:"streams, options",__proto__:null},WritableStream:{abort:"reason",close:"",write:"chunk",__proto__:null},RequestAnimationFrameCallback:{handleEvent:"highResTime",__proto__:null},SQLResultSetRowList:{item:"index",__proto__:null},SQLStatementCallback:{handleEvent:"transaction, resultSet",__proto__:null},SQLStatementErrorCallback:{handleEvent:"transaction, error",__proto__:null},SQLTransaction:{executeSql:"sqlStatement, arguments, [callback], [errorCallback]",__proto__:null},SQLTransactionCallback:{handleEvent:"transaction",__proto__:null},SQLTransactionErrorCallback:{handleEvent:"error",__proto__:null},SVGAngle:{convertToSpecifiedUnits:"unitType",newValueSpecifiedUnits:"unitType, valueInSpecifiedUnits",__proto__:null},SVGAnimationElement:{beginElementAt:"[offset]",endElementAt:"[offset]",hasExtension:"[extension]",__proto__:null},SVGColor:{setColor:"colorType, rgbColor, iccColor",setRGBColor:"rgbColor",setRGBColorICCColor:"rgbColor, iccColor",__proto__:null},SVGCursorElement:{hasExtension:"[extension]",__proto__:null},SVGDocument:{createEvent:"[eventType]",__proto__:null},SVGElement:{getPresentationAttribute:"[name]",__proto__:null},SVGFEDropShadowElement:{setStdDeviation:"[stdDeviationX], [stdDeviationY]",__proto__:null},SVGFEGaussianBlurElement:{setStdDeviation:"[stdDeviationX], [stdDeviationY]",__proto__:null},SVGFEMorphologyElement:{setRadius:"[radiusX], [radiusY]",__proto__:null},SVGFilterElement:{setFilterRes:"[filterResX], [filterResY]",__proto__:null},SVGGraphicsElement:{getTransformToElement:"[element]",hasExtension:"[extension]",__proto__:null},SVGLength:{convertToSpecifiedUnits:"unitType",newValueSpecifiedUnits:"unitType, valueInSpecifiedUnits",__proto__:null},SVGLengthList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null},SVGMarkerElement:{setOrientToAngle:"[angle]",__proto__:null},SVGMaskElement:{hasExtension:"[extension]",__proto__:null},SVGMatrix:{multiply:"secondMatrix",rotate:"angle",rotateFromVector:"x, y",scale:"scaleFactor",scaleNonUniform:"scaleFactorX, scaleFactorY",skewX:"angle",skewY:"angle",translate:"x, y",__proto__:null},SVGNumberList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null},SVGPaint:{setPaint:"paintType, uri, rgbColor, iccColor",setUri:"uri",__proto__:null},SVGPathElement:{createSVGPathSegArcAbs:"[x], [y], [r1], [r2], [angle], [largeArcFlag], [sweepFlag]",createSVGPathSegArcRel:"[x], [y], [r1], [r2], [angle], [largeArcFlag], [sweepFlag]",createSVGPathSegCurvetoCubicAbs:"[x], [y], [x1], [y1], [x2], [y2]",createSVGPathSegCurvetoCubicRel:"[x], [y], [x1], [y1], [x2], [y2]",createSVGPathSegCurvetoCubicSmoothAbs:"[x], [y], [x2], [y2]",createSVGPathSegCurvetoCubicSmoothRel:"[x], [y], [x2], [y2]",createSVGPathSegCurvetoQuadraticAbs:"[x], [y], [x1], [y1]",createSVGPathSegCurvetoQuadraticRel:"[x], [y], [x1], [y1]",createSVGPathSegCurvetoQuadraticSmoothAbs:"[x], [y]",createSVGPathSegCurvetoQuadraticSmoothRel:"[x], [y]",createSVGPathSegLinetoAbs:"[x], [y]",createSVGPathSegLinetoHorizontalAbs:"[x]",createSVGPathSegLinetoHorizontalRel:"[x]",createSVGPathSegLinetoRel:"[x], [y]",createSVGPathSegLinetoVerticalAbs:"[y]",createSVGPathSegLinetoVerticalRel:"[y]",createSVGPathSegMovetoAbs:"[x], [y]",createSVGPathSegMovetoRel:"[x], [y]",getPathSegAtLength:"[distance]",getPointAtLength:"[distance]",__proto__:null},SVGPathSegList:{appendItem:"newItem",getItem:"index",initialize:"newItem",insertItemBefore:"newItem, index",removeItem:"index",replaceItem:"newItem, index",__proto__:null},SVGPatternElement:{hasExtension:"[extension]",__proto__:null},SVGPoint:{matrixTransform:"matrix",__proto__:null},SVGPointList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null},SVGSVGElement:{checkEnclosure:"[element], [rect]",checkIntersection:"[element], [rect]",createSVGTransformFromMatrix:"[matrix]",getElementById:"[elementId]",getEnclosureList:"[rect], [referenceElement]",getIntersectionList:"[rect], [referenceElement]",setCurrentTime:"[seconds]",suspendRedraw:"[maxWaitMilliseconds]",unsuspendRedraw:"[suspendHandleId]",__proto__:null},SVGStringList:{appendItem:"item",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null},SVGTextContentElement:{getCharNumAtPosition:"[point]",getEndPositionOfChar:"[offset]",getExtentOfChar:"[offset]",getRotationOfChar:"[offset]",getStartPositionOfChar:"[offset]",getSubStringLength:"[offset], [length]",selectSubString:"[offset], [length]",__proto__:null},SVGTransform:{setMatrix:"matrix",setRotate:"angle, cx, cy",setScale:"sx, sy",setSkewX:"angle",setSkewY:"angle",setTranslate:"tx, ty",__proto__:null},SVGTransformList:{appendItem:"item",createSVGTransformFromMatrix:"matrix",getItem:"index",initialize:"item",insertItemBefore:"item, index",removeItem:"index",replaceItem:"item, index",__proto__:null},SecurityPolicy:{allowsConnectionTo:"url",allowsFontFrom:"url",allowsFormAction:"url",allowsFrameFrom:"url",allowsImageFrom:"url",allowsMediaFrom:"url",allowsObjectFrom:"url",allowsPluginType:"type",allowsScriptFrom:"url",allowsStyleFrom:"url",__proto__:null},Selection:{addRange:"[range]",collapse:"[node], [index]",containsNode:"[node], [allowPartial]",extend:"[node], [offset]",getRangeAt:"[index]",modify:"[alter], [direction], [granularity]",selectAllChildren:"[node]",setBaseAndExtent:"[baseNode], [baseOffset], [extentNode], [extentOffset]",setPosition:"[node], [offset]",__proto__:null},SourceBuffer:{appendBuffer:"data",remove:"start, end",__proto__:null},SourceBufferList:{item:"index",__proto__:null},SpeechSynthesis:{speak:"utterance",__proto__:null},SpeechSynthesisUtterance:{__proto__:null},Storage:{getItem:"key",key:"index",removeItem:"key",setItem:"key, data",__proto__:null},StorageErrorCallback:{handleEvent:"error",__proto__:null},StorageEvent:{initStorageEvent:"[typeArg], [canBubbleArg], [cancelableArg], [keyArg], [oldValueArg], [newValueArg], [urlArg], [storageAreaArg]",__proto__:null},StorageInfo:{queryUsageAndQuota:"storageType, [usageCallback], [errorCallback]",requestQuota:"storageType, newQuotaInBytes, [quotaCallback], [errorCallback]",__proto__:null},StorageQuota:{queryUsageAndQuota:"usageCallback, [errorCallback]",requestQuota:"newQuotaInBytes, [quotaCallback], [errorCallback]",__proto__:null},StorageQuotaCallback:{handleEvent:"grantedQuotaInBytes",__proto__:null},StorageUsageCallback:{handleEvent:"currentUsageInBytes, currentQuotaInBytes",__proto__:null},StringCallback:{handleEvent:"data",__proto__:null},StyleMedia:{matchMedium:"[mediaquery]",__proto__:null},StyleSheetList:{item:"[index]",__proto__:null},Text:{replaceWholeText:"[content]",splitText:"offset",__proto__:null},TextEvent:{initTextEvent:"[typeArg], [canBubbleArg], [cancelableArg], [viewArg], [dataArg]",__proto__:null},TextTrack:{addCue:"cue",addRegion:"region",removeCue:"cue",removeRegion:"region",__proto__:null},TextTrackCue:{__proto__:null},TextTrackCueList:{getCueById:"id",item:"index",__proto__:null},TextTrackList:{getTrackById:"id",item:"index",__proto__:null},TimeRanges:{end:"index",start:"index",__proto__:null},TouchEvent:{initTouchEvent:"[touches], [targetTouches], [changedTouches], [type], [view], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey]",__proto__:null},TouchList:{item:"index",__proto__:null},UIEvent:{initUIEvent:"[type], [canBubble], [cancelable], [view], [detail]",__proto__:null},UserMessageHandler:{postMessage:"message",__proto__:null},VTTRegionList:{getRegionById:"id",item:"index",__proto__:null},VideoTrackList:{getTrackById:"id",item:"index",__proto__:null},WebGL2RenderingContext:{beginQuery:"target, query",beginTransformFeedback:"primitiveMode",bindBufferBase:"target, index, buffer",bindBufferRange:"target, index, buffer, offset, size",bindSampler:"unit, sampler",bindTransformFeedback:"target, id",bindVertexArray:"vertexArray",blitFramebuffer:"srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter",clearBufferfi:"buffer, drawbuffer, depth, stencil",clearBufferfv:"buffer, drawbuffer, value",clearBufferiv:"buffer, drawbuffer, value",clearBufferuiv:"buffer, drawbuffer, value",clientWaitSync:"sync, flags, timeout",compressedTexImage3D:"target, level, internalformat, width, height, depth, border, imageSize, data",compressedTexSubImage3D:"target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data",copyBufferSubData:"readTarget, writeTarget, readOffset, writeOffset, size",copyTexSubImage3D:"target, level, xoffset, yoffset, zoffset, x, y, width, height",deleteQuery:"query",deleteSampler:"sampler",deleteSync:"sync",deleteTransformFeedback:"id",deleteVertexArray:"vertexArray",drawArraysInstanced:"mode, first, count, instanceCount",drawBuffers:"buffers",drawElementsInstanced:"mode, count, type, offset, instanceCount",drawRangeElements:"mode, start, end, count, type, offset",endQuery:"target",fenceSync:"condition, flags",framebufferTextureLayer:"target, attachment, texture, level, layer",getActiveUniformBlockName:"program, uniformBlockIndex",getActiveUniformBlockParameter:"program, uniformBlockIndex, pname",getActiveUniforms:"program, uniformIndices, pname",getBufferSubData:"target, offset, returnedData",getFragDataLocation:"program, name",getIndexedParameter:"target, index",getInternalformatParameter:"target, internalformat, pname",getQuery:"target, pname",getQueryParameter:"query, pname",getSamplerParameter:"sampler, pname",getSyncParameter:"sync, pname",getTransformFeedbackVarying:"program, index",getUniformBlockIndex:"program, uniformBlockName",getUniformIndices:"program, uniformNames",invalidateFramebuffer:"target, attachments",invalidateSubFramebuffer:"target, attachments, x, y, width, height",isQuery:"query",isSampler:"sampler",isSync:"sync",isTransformFeedback:"id",isVertexArray:"vertexArray",readBuffer:"src",renderbufferStorageMultisample:"target, samples, internalformat, width, height",samplerParameterf:"sampler, pname, param",samplerParameteri:"sampler, pname, param",texImage3D:"target, level, internalformat, width, height, depth, border, format, type, pixels",texStorage2D:"target, levels, internalformat, width, height",texStorage3D:"target, levels, internalformat, width, height, depth",texSubImage3D:"target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels",transformFeedbackVaryings:"program, varyings, bufferMode",uniform1ui:"location, v0",uniform1uiv:"location, value",uniform2ui:"location, v0, v1",uniform2uiv:"location, value",uniform3ui:"location, v0, v1, v2",uniform3uiv:"location, value",uniform4ui:"location, v0, v1, v2, v3",uniform4uiv:"location, value",uniformBlockBinding:"program, uniformBlockIndex, uniformBlockBinding",uniformMatrix2x3fv:"location, transpose, value",uniformMatrix2x4fv:"location, transpose, value",uniformMatrix3x2fv:"location, transpose, value",uniformMatrix3x4fv:"location, transpose, value",uniformMatrix4x2fv:"location, transpose, value",uniformMatrix4x3fv:"location, transpose, value",vertexAttribDivisor:"index, divisor",vertexAttribI4i:"index, x, y, z, w",vertexAttribI4iv:"index, v",vertexAttribI4ui:"index, x, y, z, w",vertexAttribI4uiv:"index, v",vertexAttribIPointer:"index, size, type, stride, offset",waitSync:"sync, flags, timeout",__proto__:null},WebGLDebugShaders:{getTranslatedShaderSource:"shader",__proto__:null},WebGLDrawBuffers:{drawBuffersWEBGL:"buffers",__proto__:null},WebGLRenderingContextBase:{activeTexture:"texture",attachShader:"program, shader",bindAttribLocation:"program, index, name",bindBuffer:"target, buffer",bindFramebuffer:"target, framebuffer",bindRenderbuffer:"target, renderbuffer",bindTexture:"target, texture",blendColor:"red, green, blue, alpha",blendEquation:"mode",blendEquationSeparate:"modeRGB, modeAlpha",blendFunc:"sfactor, dfactor",blendFuncSeparate:"srcRGB, dstRGB, srcAlpha, dstAlpha",bufferData:"target, data, usage",bufferSubData:"target, offset, data",checkFramebufferStatus:"target",clear:"mask",clearColor:"red, green, blue, alpha",clearDepth:"depth",clearStencil:"s",colorMask:"red, green, blue, alpha",compileShader:"shader",compressedTexImage2D:"target, level, internalformat, width, height, border, data",compressedTexSubImage2D:"target, level, xoffset, yoffset, width, height, format, data",copyTexImage2D:"target, level, internalformat, x, y, width, height, border",copyTexSubImage2D:"target, level, xoffset, yoffset, x, y, width, height",createShader:"type",cullFace:"mode",deleteBuffer:"buffer",deleteFramebuffer:"framebuffer",deleteProgram:"program",deleteRenderbuffer:"renderbuffer",deleteShader:"shader",deleteTexture:"texture",depthFunc:"func",depthMask:"flag",depthRange:"zNear, zFar",detachShader:"program, shader",disable:"cap",disableVertexAttribArray:"index",drawArrays:"mode, first, count",drawElements:"mode, count, type, offset",enable:"cap",enableVertexAttribArray:"index",framebufferRenderbuffer:"target, attachment, renderbuffertarget, renderbuffer",framebufferTexture2D:"target, attachment, textarget, texture, level",frontFace:"mode",generateMipmap:"target",getActiveAttrib:"program, index",getActiveUniform:"program, index",getAttachedShaders:"program",getAttribLocation:"program, name",getBufferParameter:"target, pname",getExtension:"name",getFramebufferAttachmentParameter:"target, attachment, pname",getParameter:"pname",getProgramInfoLog:"program",getProgramParameter:"program, pname",getRenderbufferParameter:"target, pname",getShaderInfoLog:"shader",getShaderParameter:"shader, pname",getShaderPrecisionFormat:"shadertype, precisiontype",getShaderSource:"shader",getTexParameter:"target, pname",getUniform:"program, location",getUniformLocation:"program, name",getVertexAttrib:"index, pname",getVertexAttribOffset:"index, pname",hint:"target, mode",isBuffer:"buffer",isEnabled:"cap",isFramebuffer:"framebuffer",isProgram:"program",isRenderbuffer:"renderbuffer",isShader:"shader",isTexture:"texture",lineWidth:"width",linkProgram:"program",pixelStorei:"pname, param",polygonOffset:"factor, units",readPixels:"x, y, width, height, format, type, pixels",renderbufferStorage:"target, internalformat, width, height",sampleCoverage:"value, invert",scissor:"x, y, width, height",shaderSource:"shader, string",stencilFunc:"func, ref, mask",stencilFuncSeparate:"face, func, ref, mask",stencilMask:"mask",stencilMaskSeparate:"face, mask",stencilOp:"fail, zfail, zpass",stencilOpSeparate:"face, fail, zfail, zpass",texImage2D:"target, level, internalformat, width, height, border, format, type, pixels",texParameterf:"target, pname, param",texParameteri:"target, pname, param",texSubImage2D:"target, level, xoffset, yoffset, width, height, format, type, pixels",uniform1f:"location, x",uniform1fv:"location, v",uniform1i:"location, x",uniform1iv:"location, v",uniform2f:"location, x, y",uniform2fv:"location, v",uniform2i:"location, x, y",uniform2iv:"location, v",uniform3f:"location, x, y, z",uniform3fv:"location, v",uniform3i:"location, x, y, z",uniform3iv:"location, v",uniform4f:"location, x, y, z, w",uniform4fv:"location, v",uniform4i:"location, x, y, z, w",uniform4iv:"location, v",uniformMatrix2fv:"location, transpose, array",uniformMatrix3fv:"location, transpose, array",uniformMatrix4fv:"location, transpose, array",useProgram:"program",validateProgram:"program",vertexAttrib1f:"indx, x",vertexAttrib1fv:"indx, values",vertexAttrib2f:"indx, x, y",vertexAttrib2fv:"indx, values",vertexAttrib3f:"indx, x, y, z",vertexAttrib3fv:"indx, values",vertexAttrib4f:"indx, x, y, z, w",vertexAttrib4fv:"indx, values",vertexAttribPointer:"indx, size, type, normalized, stride, offset",viewport:"x, y, width, height",__proto__:null},WebKitCSSMatrix:{multiply:"[secondMatrix]",rotate:"[rotX], [rotY], [rotZ]",rotateAxisAngle:"[x], [y], [z], [angle]",scale:"[scaleX], [scaleY], [scaleZ]",setMatrixValue:"[string]",skewX:"[angle]",skewY:"[angle]",translate:"[x], [y], [z]",__proto__:null},WebKitMediaKeySession:{update:"key",__proto__:null},WebKitMediaKeys:{createSession:"[type], [initData]",__proto__:null},WebKitNamedFlow:{getRegionsByContent:"contentNode",__proto__:null},WebKitNamedFlowCollection:{item:"index",namedItem:"name",__proto__:null},WebKitSubtleCrypto:{decrypt:"algorithm, key, data",digest:"algorithm, data",encrypt:"algorithm, key, data",exportKey:"format, key",generateKey:"algorithm, [extractable], [keyUsages]",importKey:"format, keyData, algorithm, [extractable], [keyUsages]",sign:"algorithm, key, data",unwrapKey:"format, wrappedKey, unwrappingKey, unwrapAlgorithm, unwrappedKeyAlgorithm, [extractable], [keyUsages]",verify:"algorithm, key, signature, data",wrapKey:"format, key, wrappingKey, wrapAlgorithm",__proto__:null},WebSocket:{close:"[code], [reason]",send:"data",__proto__:null},WheelEvent:{initWebKitWheelEvent:"[wheelDeltaX], [wheelDeltaY], [view], [screenX], [screenY], [clientX], [clientY], [ctrlKey], [altKey], [shiftKey], [metaKey]",__proto__:null},Worker:{postMessage:"message, [messagePorts]",__proto__:null},WorkerGlobalScope:{clearInterval:"[handle]",clearTimeout:"[handle]",setInterval:"handler, [timeout]",setTimeout:"handler, [timeout]",__proto__:null},XMLHttpRequest:{getResponseHeader:"header",open:"method, url, [async], [user], [password]",overrideMimeType:"override",setRequestHeader:"header, value",__proto__:null},XMLHttpRequestUpload:{__proto__:null},XMLSerializer:{serializeToString:"[node]",__proto__:null},XPathEvaluator:{createExpression:"[expression], [resolver]",createNSResolver:"[nodeResolver]",evaluate:"[expression], [contextNode], [resolver], [type], [inResult]",__proto__:null},XPathExpression:{evaluate:"[contextNode], [type], [inResult]",__proto__:null},XPathNSResolver:{lookupNamespaceURI:"[prefix]",__proto__:null},XPathResult:{snapshotItem:"[index]",__proto__:null},XSLTProcessor:{getParameter:"namespaceURI, localName",importStylesheet:"[stylesheet]",removeParameter:"namespaceURI, localName",setParameter:"namespaceURI, localName, value",transformToDocument:"[source]",transformToFragment:"[source], [docVal]",__proto__:null},webkitAudioContext:{createBuffer:"numberOfChannels, numberOfFrames, sampleRate",createChannelMerger:"[numberOfInputs]",createChannelSplitter:"[numberOfOutputs]",createDelay:"[maxDelayTime]",createDelayNode:"[maxDelayTime]",createJavaScriptNode:"bufferSize, [numberOfInputChannels], [numberOfOutputChannels]",createMediaElementSource:"mediaElement",createPeriodicWave:"real, imag",createScriptProcessor:"bufferSize, [numberOfInputChannels], [numberOfOutputChannels]",decodeAudioData:"audioData, successCallback, [errorCallback]",__proto__:null},webkitAudioPannerNode:{setOrientation:"x, y, z",setPosition:"x, y, z",setVelocity:"x, y, z",__proto__:null},webkitMediaStream:{addTrack:"track",getTrackById:"trackId",removeTrack:"track",__proto__:null},webkitRTCPeerConnection:{addIceCandidate:"candidate, successCallback, failureCallback",addStream:"stream",createAnswer:"successCallback, failureCallback, [answerOptions]",createDTMFSender:"track",createDataChannel:"label, [options]",createOffer:"successCallback, failureCallback, [offerOptions]",getStats:"successCallback, failureCallback, [selector]",getStreamById:"streamId",removeStream:"stream",setLocalDescription:"description, successCallback, failureCallback",setRemoteDescription:"description, successCallback, failureCallback",updateIce:"configuration",__proto__:null},EventTarget:{addEventListener:"type, listener, [useCapture=false]",removeEventListener:"type, listener, [useCapture=false]",dispatchEvent:"event",__proto__:null}},function(){var u=WebInspector.NativePrototypeFunctionParameters.EventTarget,_=["Node","Window","AudioNode","AudioTrackList","DOMApplicationCache","FileReader","MediaController","MediaStreamTrack","MessagePort","Notification","RTCDTMFSender","SpeechSynthesisUtterance","TextTrack","TextTrackCue","TextTrackList","VideoTrackList","WebKitMediaKeySession","WebKitNamedFlow","WebSocket","WorkerGlobalScope","XMLHttpRequest","webkitMediaStream","webkitRTCPeerConnection"];for(var S of _)Object.assign(WebInspector.NativePrototypeFunctionParameters[S],u);var C={getElementsByClassName:"classNames",getElementsByTagName:"tagName",getElementsByTagNameNS:"namespace, localName",querySelector:"selectors",querySelectorAll:"selectors"};Object.assign(WebInspector.NativePrototypeFunctionParameters.Element,C),Object.assign(WebInspector.NativePrototypeFunctionParameters.Document,C);var f={after:"[node|string]...",before:"[node|string]...",replaceWith:"[node|string]..."};Object.assign(WebInspector.NativePrototypeFunctionParameters.Element,f),Object.assign(WebInspector.NativePrototypeFunctionParameters.CharacterData,f);var T={append:"[node|string]...",prepend:"[node|string]..."};Object.assign(WebInspector.NativePrototypeFunctionParameters.Element,T),Object.assign(WebInspector.NativePrototypeFunctionParameters.Document,T),Object.assign(WebInspector.NativePrototypeFunctionParameters.DocumentFragment,T),WebInspector.NativePrototypeFunctionParameters.Console=WebInspector.NativeConstructorFunctionParameters.Console}(),WebInspector.NetworkInstrument=class extends WebInspector.Instrument{get timelineRecordType(){return WebInspector.TimelineRecord.Type.Network}startInstrumentation(){}stopInstrumentation(){}},WebInspector.NetworkTimeline=class extends WebInspector.Timeline{recordForResource(_){return this._resourceRecordMap.get(_)||null}reset(_){this._resourceRecordMap=new Map,super.reset(_)}addRecord(_){this._resourceRecordMap.has(_.resource)||(this._resourceRecordMap.set(_.resource,_),super.addRecord(_))}},WebInspector.ObjectPreview=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I,R){super(),this._type=_,this._subtype=S,this._description=C||"",this._lossless=f,this._overflow=T||!1,this._size=R,this._properties=E||null,this._entries=I||null}static fromPayload(_){if(_.properties&&(_.properties=_.properties.map(WebInspector.PropertyPreview.fromPayload)),_.entries&&(_.entries=_.entries.map(WebInspector.CollectionEntryPreview.fromPayload)),"array"===_.subtype){var S=_.description.match(/\[(\d+)\]$/);S&&(_.size=parseInt(S[1]),_.description=_.description.replace(/\[\d+\]$/,""))}return new WebInspector.ObjectPreview(_.type,_.subtype,_.description,_.lossless,_.overflow,_.properties,_.entries,_.size)}get type(){return this._type}get subtype(){return this._subtype}get description(){return this._description}get lossless(){return this._lossless}get overflow(){return this._overflow}get propertyPreviews(){return this._properties}get collectionEntryPreviews(){return this._entries}get size(){return this._size}hasSize(){return this._size!==void 0&&("array"===this._subtype||"set"===this._subtype||"map"===this._subtype||"weakmap"===this._subtype||"weakset"===this._subtype)}},WebInspector.ProbeSample=class extends WebInspector.Object{constructor(_,S,C,f){super(),this.sampleId=_,this.batchId=S,this.timestamp=C,this.object=f}},WebInspector.Probe=class extends WebInspector.Object{constructor(_,S,C){super(),this._id=_,this._breakpoint=S,this._expression=C,this._samples=[]}get id(){return this._id}get breakpoint(){return this._breakpoint}get expression(){return this._expression}set expression(_){if(this._expression!==_){var S={oldValue:this._expression,newValue:_};this._expression=_,this.clearSamples(),this.dispatchEventToListeners(WebInspector.Probe.Event.ExpressionChanged,S)}}get samples(){return this._samples.slice()}clearSamples(){this._samples=[],this.dispatchEventToListeners(WebInspector.Probe.Event.SamplesCleared)}addSample(_){this._samples.push(_),this.dispatchEventToListeners(WebInspector.Probe.Event.SampleAdded,_)}},WebInspector.Probe.Event={ExpressionChanged:"probe-object-expression-changed",SampleAdded:"probe-object-sample-added",SamplesCleared:"probe-object-samples-cleared"},WebInspector.ProbeSet=class extends WebInspector.Object{constructor(_){super(),this._breakpoint=_,this._probes=[],this._probesByIdentifier=new Map,this._createDataTable(),WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceChanged,this),WebInspector.Probe.addEventListener(WebInspector.Probe.Event.SampleAdded,this._sampleCollected,this),WebInspector.Breakpoint.addEventListener(WebInspector.Breakpoint.Event.ResolvedStateDidChange,this._breakpointResolvedStateDidChange,this)}get breakpoint(){return this._breakpoint}get probes(){return this._probes.slice()}get dataTable(){return this._dataTable}clear(){this._breakpoint.clearActions(WebInspector.BreakpointAction.Type.Probe)}clearSamples(){for(var _ of this._probes)_.clearSamples();var S=this._dataTable;this._createDataTable(),this.dispatchEventToListeners(WebInspector.ProbeSet.Event.SamplesCleared,{oldTable:S})}createProbe(_){this.breakpoint.createAction(WebInspector.BreakpointAction.Type.Probe,null,_)}addProbe(_){this._probes.push(_),this._probesByIdentifier.set(_.id,_),this.dataTable.addProbe(_),this.dispatchEventToListeners(WebInspector.ProbeSet.Event.ProbeAdded,_)}removeProbe(_){this._probes.splice(this._probes.indexOf(_),1),this._probesByIdentifier.delete(_.id),this.dataTable.removeProbe(_),this.dispatchEventToListeners(WebInspector.ProbeSet.Event.ProbeRemoved,_)}willRemove(){WebInspector.Frame.removeEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceChanged,this),WebInspector.Probe.removeEventListener(WebInspector.Probe.Event.SampleAdded,this._sampleCollected,this),WebInspector.Breakpoint.removeEventListener(WebInspector.Breakpoint.Event.ResolvedStateDidChange,this._breakpointResolvedStateDidChange,this)}_mainResourceChanged(){this.dataTable.mainResourceChanged()}_createDataTable(){this.dataTable&&this.dataTable.willRemove(),this._dataTable=new WebInspector.ProbeSetDataTable(this)}_sampleCollected(_){var S=_.data,C=_.target;this._probesByIdentifier.has(C.id)&&(this.dataTable.addSampleForProbe(C,S),this.dispatchEventToListeners(WebInspector.ProbeSet.Event.SampleAdded,{probe:C,sample:S}))}_breakpointResolvedStateDidChange(){this.dispatchEventToListeners(WebInspector.ProbeSet.Event.ResolvedStateDidChange)}},WebInspector.ProbeSet.Event={ProbeAdded:"probe-set-probe-added",ProbeRemoved:"probe-set-probe-removed",ResolvedStateDidChange:"probe-set-resolved-state-did-change",SampleAdded:"probe-set-sample-added",SamplesCleared:"probe-set-samples-cleared"},WebInspector.ProbeSetDataFrame=class extends WebInspector.Object{constructor(_){super(),this._count=0,this._index=_,this._separator=!1}static compare(_,S){return _.index-S.index}get key(){return this._index+""}get count(){return this._count}get index(){return this._index}get isSeparator(){return this._separator}set isSeparator(_){this._separator=!!_}addSampleForProbe(_,S){this[_.id]=S,this._count++}missingKeys(_){return _.probes.filter(function(S){return!this.hasOwnProperty(S.id)},this)}isComplete(_){return!this.missingKeys(_).length}fillMissingValues(_){for(var S of this.missingKeys(_))this[S]=WebInspector.ProbeSetDataFrame.MissingValue}},WebInspector.ProbeSetDataFrame.MissingValue="?",WebInspector.ProbeSetDataTable=class extends WebInspector.Object{constructor(_){super(),this._probeSet=_,this._frames=[],this._previousBatchIdentifier=WebInspector.ProbeSetDataTable.SentinelValue}get frames(){return this._frames.slice()}get separators(){return this._frames.filter(function(_){return _.isSeparator})}willRemove(){this.dispatchEventToListeners(WebInspector.ProbeSetDataTable.Event.WillRemove),this._frames=[],delete this._probeSet}mainResourceChanged(){this.addSeparator()}addSampleForProbe(_,S){S.batchId!==this._previousBatchIdentifier&&(this._openFrame&&(this._openFrame.fillMissingValues(this._probeSet),this.addFrame(this._openFrame)),this._openFrame=this.createFrame(),this._previousBatchIdentifier=S.batchId),this._openFrame.addSampleForProbe(_,S),this._openFrame.count===this._probeSet.probes.length&&(this.addFrame(this._openFrame),this._openFrame=null)}addProbe(_){for(var S of this.frames)S[_.id]||(S[_.id]=WebInspector.ProbeSetDataTable.UnknownValue)}removeProbe(_){for(var S of this.frames)delete S[_.id]}createFrame(){return new WebInspector.ProbeSetDataFrame(this._frames.length)}addFrame(_){this._frames.push(_),this.dispatchEventToListeners(WebInspector.ProbeSetDataTable.Event.FrameInserted,_)}addSeparator(){if(this._frames.length){var _=this._frames.lastValue;_.isSeparator||(_.isSeparator=!0,this.dispatchEventToListeners(WebInspector.ProbeSetDataTable.Event.SeparatorInserted,_))}}},WebInspector.ProbeSetDataTable.Event={FrameInserted:"probe-set-data-table-frame-inserted",SeparatorInserted:"probe-set-data-table-separator-inserted",WillRemove:"probe-set-data-table-will-remove"},WebInspector.ProbeSetDataTable.SentinelValue=-1,WebInspector.ProbeSetDataTable.UnknownValue="?",WebInspector.Profile=class extends WebInspector.Object{constructor(_){super(),_=_||[],this._topDownRootNodes=_}get topDownRootNodes(){return this._topDownRootNodes}get bottomUpRootNodes(){return[]}},WebInspector.ProfileNode=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I){super(),I=I||[],this._id=_,this._type=S||WebInspector.ProfileNode.Type.Function,this._functionName=C||null,this._sourceCodeLocation=f||null,this._calls=E||null,this._callInfo=T||null,this._childNodes=I,this._parentNode=null,this._previousSibling=null,this._nextSibling=null,this._computedTotalTimes=!1,this._callInfo&&(this._startTime=this._callInfo.startTime,this._endTime=this._callInfo.endTime,this._totalTime=this._callInfo.totalTime,this._callCount=this._callInfo.callCount);for(var R=0;R<this._childNodes.length;++R)this._childNodes[R].establishRelationships(this,this._childNodes[R-1],this._childNodes[R+1]);if(this._calls)for(var R=0;R<this._calls.length;++R)this._calls[R].establishRelationships(this,this._calls[R-1],this._calls[R+1])}get id(){return this._id}get type(){return this._type}get functionName(){return this._functionName}get sourceCodeLocation(){return this._sourceCodeLocation}get startTime(){return void 0===this._startTime&&(this._startTime=Math.max(0,this._calls[0].startTime)),this._startTime}get endTime(){return void 0===this._endTime&&(this._endTime=Math.min(this._calls.lastValue.endTime,Infinity)),this._endTime}get selfTime(){return this._computeTotalTimesIfNeeded(),this._selfTime}get totalTime(){return this._computeTotalTimesIfNeeded(),this._totalTime}get callInfo(){return this._callInfo}get calls(){return this._calls}get previousSibling(){return this._previousSibling}get nextSibling(){return this._nextSibling}get parentNode(){return this._parentNode}get childNodes(){return this._childNodes}computeCallInfoForTimeRange(_,S){function C(P,O){return _>O.endTime||S<O.startTime?P:(E&&++I,P+Math.min(O.endTime,S)-Math.max(_,O.startTime))}if(this._callInfo){if(this._selfTime===void 0){var f=0;for(var T of this._childNodes)f+=T.totalTime;this._selfTime=this._totalTime-f,1e-4>this._selfTime&&(this._selfTime=0)}return{callCount:this._callCount,startTime:this._startTime,endTime:this._endTime,selfTime:this._selfTime,totalTime:this._totalTime,averageTime:this._selfTime/this._callCount}}var E=!0,I=0,R=Math.max(_,this._calls[0].startTime),N=Math.min(this._calls.lastValue.endTime,S),L=this._calls.reduce(C,0);E=!1;var f=0;for(var T of this._childNodes)f+=T.calls.reduce(C,0);var D=L-f,M=D/I;return{startTime:R,endTime:N,totalTime:L,selfTime:D,callCount:I,averageTime:M}}traverseNextProfileNode(_){var S=this._childNodes[0];if(S)return S;if(this===_)return null;if(S=this._nextSibling,S)return S;for(S=this;S&&!S.nextSibling&&S.parentNode!==_;)S=S.parentNode;return S?S.nextSibling:null}saveIdentityToCookie(_){_[WebInspector.ProfileNode.TypeCookieKey]=this._type||null,_[WebInspector.ProfileNode.FunctionNameCookieKey]=this._functionName||null,_[WebInspector.ProfileNode.SourceCodeURLCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url?this._sourceCodeLocation.sourceCode.url.hash:null:null,_[WebInspector.ProfileNode.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null,_[WebInspector.ProfileNode.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null}establishRelationships(_,S,C){this._parentNode=_||null,this._previousSibling=S||null,this._nextSibling=C||null}_computeTotalTimesIfNeeded(){if(!this._computedTotalTimes){this._computedTotalTimes=!0;var _=this.computeCallInfoForTimeRange(0,Infinity);this._startTime=_.startTime,this._endTime=_.endTime,this._selfTime=_.selfTime,this._totalTime=_.totalTime}}},WebInspector.ProfileNode.Type={Function:"profile-node-type-function",Program:"profile-node-type-program"},WebInspector.ProfileNode.TypeIdentifier="profile-node",WebInspector.ProfileNode.TypeCookieKey="profile-node-type",WebInspector.ProfileNode.FunctionNameCookieKey="profile-node-function-name",WebInspector.ProfileNode.SourceCodeURLCookieKey="profile-node-source-code-url",WebInspector.ProfileNode.SourceCodeLocationLineCookieKey="profile-node-source-code-location-line",WebInspector.ProfileNode.SourceCodeLocationColumnCookieKey="profile-node-source-code-location-column",WebInspector.ProfileNodeCall=class extends WebInspector.Object{constructor(_,S){super(),this._startTime=_,this._totalTime=S||0,this._parentNode=null,this._previousSibling=null,this._nextSibling=null}get startTime(){return this._startTime}get totalTime(){return this._totalTime}get endTime(){return this._startTime+this._totalTime}establishRelationships(_,S,C){this._parentNode=_||null,this._previousSibling=S||null,this._nextSibling=C||null}},WebInspector.PropertyDescriptor=class extends WebInspector.Object{constructor(_,S,C,f,T,E){super(),this._name=_.name,this._value=_.value,this._hasValue="value"in _,this._get=_.get,this._set=_.set,this._symbol=S,this._writable=_.writable||!1,this._configurable=_.configurable||!1,this._enumerable=_.enumerable||!1,this._own=C||!1,this._wasThrown=f||!1,this._nativeGetterValue=T||!1,this._internal=E||!1}static fromPayload(_,S,C){return _.value&&(_.value=WebInspector.RemoteObject.fromPayload(_.value,C)),_.get&&(_.get=WebInspector.RemoteObject.fromPayload(_.get,C)),_.set&&(_.set=WebInspector.RemoteObject.fromPayload(_.set,C)),_.symbol&&(_.symbol=WebInspector.RemoteObject.fromPayload(_.symbol,C)),S&&(_.writable=_.configurable=_.enumerable=!1,_.isOwn=!0),new WebInspector.PropertyDescriptor(_,_.symbol,_.isOwn,_.wasThrown,_.nativeGetter,S)}get name(){return this._name}get value(){return this._value}get get(){return this._get}get set(){return this._set}get writable(){return this._writable}get configurable(){return this._configurable}get enumerable(){return this._enumerable}get symbol(){return this._symbol}get isOwnProperty(){return this._own}get wasThrown(){return this._wasThrown}get nativeGetter(){return this._nativeGetterValue}get isInternalProperty(){return this._internal}hasValue(){return this._hasValue}hasGetter(){return this._get&&"function"===this._get.type}hasSetter(){return this._set&&"function"===this._set.type}isIndexProperty(){return!isNaN(+this._name)}isSymbolProperty(){return!!this._symbol}},WebInspector.PropertyPath=class extends WebInspector.Object{constructor(_,S,C,f){if(super(),C&&!C.object)throw new Error("Attempted to append to a PropertyPath with null object.");this._object=_,this._pathComponent="string"==typeof S?S:null,this._parent=C||null,this._isPrototype=f||!1}static emptyPropertyPathForScope(_){return new WebInspector.PropertyPath(_,WebInspector.PropertyPath.SpecialPathComponent.EmptyPathComponentForScope)}get object(){return this._object}get parent(){return this._parent}get isPrototype(){return this._isPrototype}get pathComponent(){return this._pathComponent}get rootObject(){return this._parent?this._parent.rootObject:this._object}get lastNonPrototypeObject(){if(!this._parent)return this._object;for(var _=this._parent;_&&!!_.isPrototype;){if(!_.parent)break;_=_.parent}return _.object}get fullPath(){for(var _=[],S=this;S&&S.pathComponent;S=S.parent)_.push(S.pathComponent);return _.reverse(),_.join("")}get reducedPath(){for(var _=[],S=this;S&&S.isPrototype;S=S.parent)_.push(S.pathComponent);for(;S&&S.pathComponent;S=S.parent)S.isPrototype||_.push(S.pathComponent);return _.reverse(),_.join("")}displayPath(_){return _===WebInspector.PropertyPath.Type.Value?this.reducedPath:this.fullPath}isRoot(){return!this._parent}isScope(){return this._pathComponent===WebInspector.PropertyPath.SpecialPathComponent.EmptyPathComponentForScope}isPathComponentImpossible(){return this._pathComponent&&this._pathComponent.startsWith("@")}isFullPathImpossible(){return!!this.isPathComponentImpossible()||!!this._parent&&this._parent.isFullPathImpossible()}appendPropertyName(_,S){var C="__proto__"===S;if(this.isScope())return new WebInspector.PropertyPath(_,S,this,C);var f=this._canPropertyNameBeDotAccess(S)?"."+S:"["+doubleQuotedString(S)+"]";return new WebInspector.PropertyPath(_,f,this,C)}appendPropertySymbol(_,S){var C=WebInspector.PropertyPath.SpecialPathComponent.SymbolPropertyName+(S.length?"("+S+")":"");return new WebInspector.PropertyPath(_,C,this)}appendInternalPropertyName(_,S){var C=WebInspector.PropertyPath.SpecialPathComponent.InternalPropertyName+"["+S+"]";return new WebInspector.PropertyPath(_,C,this)}appendGetterPropertyName(_,S){var C=".__lookupGetter__("+doubleQuotedString(S)+")";return new WebInspector.PropertyPath(_,C,this)}appendSetterPropertyName(_,S){var C=".__lookupSetter__("+doubleQuotedString(S)+")";return new WebInspector.PropertyPath(_,C,this)}appendArrayIndex(_,S){return new WebInspector.PropertyPath(_,"["+S+"]",this)}appendMapKey(_){var S=WebInspector.PropertyPath.SpecialPathComponent.MapKey;return new WebInspector.PropertyPath(_,S,this)}appendMapValue(_,S){if(S&&S.hasValue()){if("string"===S.type){var C=".get("+doubleQuotedString(S.description)+")";return new WebInspector.PropertyPath(_,C,this)}var C=".get("+S.description+")";return new WebInspector.PropertyPath(_,C,this)}var C=WebInspector.PropertyPath.SpecialPathComponent.MapValue;return new WebInspector.PropertyPath(_,C,this)}appendSetIndex(_){var S=WebInspector.PropertyPath.SpecialPathComponent.SetIndex;return new WebInspector.PropertyPath(_,S,this)}appendSymbolProperty(_){var S=WebInspector.PropertyPath.SpecialPathComponent.SymbolPropertyName;return new WebInspector.PropertyPath(_,S,this)}appendPropertyDescriptor(_,S,C){return S.isInternalProperty?this.appendInternalPropertyName(_,S.name):S.symbol?this.appendSymbolProperty(_):C===WebInspector.PropertyPath.Type.Getter?this.appendGetterPropertyName(_,S.name):C===WebInspector.PropertyPath.Type.Setter?this.appendSetterPropertyName(_,S.name):"array"!==this._object.subtype||isNaN(parseInt(S.name))?this.appendPropertyName(_,S.name):this.appendArrayIndex(_,S.name)}_canPropertyNameBeDotAccess(_){return /^(?![0-9])\w+$/.test(_)}},WebInspector.PropertyPath.SpecialPathComponent={InternalPropertyName:"@internal",SymbolPropertyName:"@symbol",MapKey:"@mapkey",MapValue:"@mapvalue",SetIndex:"@setindex",EmptyPathComponentForScope:""},WebInspector.PropertyPath.Type={Value:"value",Getter:"getter",Setter:"setter"},WebInspector.PropertyPreview=class extends WebInspector.Object{constructor(_,S,C,f,T,E){super(),this._name=_,this._type=S,this._subtype=C,this._value=f,this._valuePreview=T,this._internal=E}static fromPayload(_){return _.valuePreview&&(_.valuePreview=WebInspector.ObjectPreview.fromPayload(_.valuePreview)),new WebInspector.PropertyPreview(_.name,_.type,_.subtype,_.value,_.valuePreview,_.internal)}get name(){return this._name}get type(){return this._type}get subtype(){return this._subtype}get value(){return this._value}get valuePreview(){return this._valuePreview}get internal(){return this._internal}},WebInspector.RenderingFrameTimelineRecord=class extends WebInspector.TimelineRecord{constructor(_,S){super(WebInspector.TimelineRecord.Type.RenderingFrame,_,S),this._durationByTaskType=new Map,this._frameIndex=-1}static resetFrameIndex(){WebInspector.RenderingFrameTimelineRecord._nextFrameIndex=0}static displayNameForTaskType(_){return _===WebInspector.RenderingFrameTimelineRecord.TaskType.Script?WebInspector.UIString("Script"):_===WebInspector.RenderingFrameTimelineRecord.TaskType.Layout?WebInspector.UIString("Layout"):_===WebInspector.RenderingFrameTimelineRecord.TaskType.Paint?WebInspector.UIString("Paint"):_===WebInspector.RenderingFrameTimelineRecord.TaskType.Other?WebInspector.UIString("Other"):void 0}static taskTypeForTimelineRecord(_){switch(_.type){case WebInspector.TimelineRecord.Type.Script:return WebInspector.RenderingFrameTimelineRecord.TaskType.Script;case WebInspector.TimelineRecord.Type.Layout:return _.eventType===WebInspector.LayoutTimelineRecord.EventType.Paint||_.eventType===WebInspector.LayoutTimelineRecord.EventType.Composite?WebInspector.RenderingFrameTimelineRecord.TaskType.Paint:WebInspector.RenderingFrameTimelineRecord.TaskType.Layout;default:return console.error("Unsupported timeline record type: "+_.type),null;}}get frameIndex(){return this._frameIndex}get frameNumber(){return this._frameIndex+1}setupFrameIndex(){0<=this._frameIndex||(this._frameIndex=WebInspector.RenderingFrameTimelineRecord._nextFrameIndex++)}durationForTask(_){if(this._durationByTaskType.has(_))return this._durationByTaskType.get(_);var S;return _===WebInspector.RenderingFrameTimelineRecord.TaskType.Other?S=this._calculateDurationRemainder():(S=this.children.reduce(function(C,f){if(_!==WebInspector.RenderingFrameTimelineRecord.taskTypeForTimelineRecord(f))return C;var T=f.duration;return f.usesActiveStartTime&&(T-=f.inactiveDuration),C+T},0),_===WebInspector.RenderingFrameTimelineRecord.TaskType.Script&&(S-=this.children.reduce(function(C,f){return f.type===WebInspector.TimelineRecord.Type.Layout&&(f.sourceCodeLocation||f.callFrames)?C+f.duration:C},0))),this._durationByTaskType.set(_,S),S}_calculateDurationRemainder(){return Object.keys(WebInspector.RenderingFrameTimelineRecord.TaskType).reduce((_,S)=>{let C=WebInspector.RenderingFrameTimelineRecord.TaskType[S];return C===WebInspector.RenderingFrameTimelineRecord.TaskType.Other?_:_-this.durationForTask(C)},this.duration)}},WebInspector.RenderingFrameTimelineRecord.TaskType={Script:"rendering-frame-timeline-record-script",Layout:"rendering-frame-timeline-record-layout",Paint:"rendering-frame-timeline-record-paint",Other:"rendering-frame-timeline-record-other"},WebInspector.RenderingFrameTimelineRecord.TypeIdentifier="rendering-frame-timeline-record",WebInspector.RenderingFrameTimelineRecord._nextFrameIndex=0,WebInspector.Resource=class extends WebInspector.SourceCode{constructor(_,S,C,f,T,E,I,R,N,L,D,M){super(),C in WebInspector.Resource.Type&&(C=WebInspector.Resource.Type[C]),this._url=_,this._urlComponents=null,this._mimeType=S,this._mimeTypeComponents=null,this._type=C||WebInspector.Resource.typeFromMIMEType(S),this._loaderIdentifier=f||null,this._requestIdentifier=E||null,this._requestMethod=I||null,this._requestData=N||null,this._requestHeaders=R||{},this._responseHeaders={},this._parentFrame=null,this._initiatorSourceCodeLocation=D||null,this._initiatedResources=[],this._originalRequestWillBeSentTimestamp=M||null,this._requestSentTimestamp=L||NaN,this._responseReceivedTimestamp=NaN,this._lastRedirectReceivedTimestamp=NaN,this._lastDataReceivedTimestamp=NaN,this._finishedOrFailedTimestamp=NaN,this._finishThenRequestContentPromise=null,this._statusCode=NaN,this._statusText=null,this._cached=!1,this._canceled=!1,this._failed=!1,this._failureReasonText=null,this._receivedNetworkLoadMetrics=!1,this._responseSource=WebInspector.Resource.ResponseSource.Unknown,this._timingData=new WebInspector.ResourceTimingData(this),this._protocol=null,this._priority=WebInspector.Resource.NetworkPriority.Unknown,this._remoteAddress=null,this._connectionIdentifier=null,this._target=T?WebInspector.targetManager.targetForIdentifier(T):WebInspector.mainTarget,this._requestHeadersTransferSize=NaN,this._requestBodyTransferSize=NaN,this._responseHeadersTransferSize=NaN,this._responseBodyTransferSize=NaN,this._responseBodySize=NaN,this._cachedResponseBodySize=NaN,this._estimatedSize=NaN,this._estimatedTransferSize=NaN,this._estimatedResponseHeadersSize=NaN,this._initiatorSourceCodeLocation&&this._initiatorSourceCodeLocation.sourceCode instanceof WebInspector.Resource&&this._initiatorSourceCodeLocation.sourceCode.addInitiatedResource(this)}static typeFromMIMEType(_){return _?(_=parseMIMEType(_).type,_ in WebInspector.Resource._mimeTypeMap?WebInspector.Resource._mimeTypeMap[_]:_.startsWith("image/")?WebInspector.Resource.Type.Image:_.startsWith("font/")?WebInspector.Resource.Type.Font:WebInspector.Resource.Type.Other):WebInspector.Resource.Type.Other}static displayNameForType(_,S){return _===WebInspector.Resource.Type.Document?S?WebInspector.UIString("Documents"):WebInspector.UIString("Document"):_===WebInspector.Resource.Type.Stylesheet?S?WebInspector.UIString("Stylesheets"):WebInspector.UIString("Stylesheet"):_===WebInspector.Resource.Type.Image?S?WebInspector.UIString("Images"):WebInspector.UIString("Image"):_===WebInspector.Resource.Type.Font?S?WebInspector.UIString("Fonts"):WebInspector.UIString("Font"):_===WebInspector.Resource.Type.Script?S?WebInspector.UIString("Scripts"):WebInspector.UIString("Script"):_===WebInspector.Resource.Type.XHR?S?WebInspector.UIString("XHRs"):WebInspector.UIString("XHR"):_===WebInspector.Resource.Type.Fetch?S?WebInspector.UIString("Fetches"):WebInspector.UIString("Fetch"):_===WebInspector.Resource.Type.WebSocket?S?WebInspector.UIString("Sockets"):WebInspector.UIString("Socket"):_===WebInspector.Resource.Type.Other?WebInspector.UIString("Other"):(console.error("Unknown resource type",_),null)}static displayNameForProtocol(_){return"h2"===_?"HTTP/2":"http/1.0"===_?"HTTP/1.0":"http/1.1"===_?"HTTP/1.1":"spdy/2"===_?"SPDY/2":"spdy/3"===_?"SPDY/3":"spdy/3.1"===_?"SPDY/3.1":null}static comparePriority(_,S){const C={[WebInspector.Resource.NetworkPriority.Unknown]:0,[WebInspector.Resource.NetworkPriority.Low]:1,[WebInspector.Resource.NetworkPriority.Medium]:2,[WebInspector.Resource.NetworkPriority.High]:3};let f=C[_]||0,T=C[S]||0;return f-T}static displayNameForPriority(_){return _===WebInspector.Resource.NetworkPriority.Low?WebInspector.UIString("Low"):_===WebInspector.Resource.NetworkPriority.Medium?WebInspector.UIString("Medium"):_===WebInspector.Resource.NetworkPriority.High?WebInspector.UIString("High"):null}static responseSourceFromPayload(_){if(!_)return WebInspector.Resource.ResponseSource.Unknown;return _===NetworkAgent.ResponseSource.Unknown?WebInspector.Resource.ResponseSource.Unknown:_===NetworkAgent.ResponseSource.Network?WebInspector.Resource.ResponseSource.Network:_===NetworkAgent.ResponseSource.MemoryCache?WebInspector.Resource.ResponseSource.MemoryCache:_===NetworkAgent.ResponseSource.DiskCache?WebInspector.Resource.ResponseSource.DiskCache:(console.error("Unknown response source type",_),WebInspector.Resource.ResponseSource.Unknown)}static networkPriorityFromPayload(_){return _===NetworkAgent.MetricsPriority.Low?WebInspector.Resource.NetworkPriority.Low:_===NetworkAgent.MetricsPriority.Medium?WebInspector.Resource.NetworkPriority.Medium:_===NetworkAgent.MetricsPriority.High?WebInspector.Resource.NetworkPriority.High:(console.error("Unknown metrics priority",_),WebInspector.Resource.NetworkPriority.Unknown)}static connectionIdentifierFromPayload(_){WebInspector.Resource.connectionIdentifierMap||(WebInspector.Resource.connectionIdentifierMap=new Map,WebInspector.Resource.nextConnectionIdentifier=1);let S=WebInspector.Resource.connectionIdentifierMap.get(_);return S?S:(S=WebInspector.Resource.nextConnectionIdentifier++,WebInspector.Resource.connectionIdentifierMap.set(_,S),S)}get target(){return this._target}get type(){return this._type}get loaderIdentifier(){return this._loaderIdentifier}get requestIdentifier(){return this._requestIdentifier}get requestMethod(){return this._requestMethod}get requestData(){return this._requestData}get statusCode(){return this._statusCode}get statusText(){return this._statusText}get responseSource(){return this._responseSource}get timingData(){return this._timingData}get protocol(){return this._protocol}get priority(){return this._priority}get remoteAddress(){return this._remoteAddress}get connectionIdentifier(){return this._connectionIdentifier}get url(){return this._url}get urlComponents(){return this._urlComponents||(this._urlComponents=parseURL(this._url)),this._urlComponents}get displayName(){return WebInspector.displayNameForURL(this._url,this.urlComponents)}get displayURL(){return WebInspector.truncateURL(this._url,!0,64)}get initiatorSourceCodeLocation(){return this._initiatorSourceCodeLocation}get initiatedResources(){return this._initiatedResources}get originalRequestWillBeSentTimestamp(){return this._originalRequestWillBeSentTimestamp}get mimeType(){return this._mimeType}get mimeTypeComponents(){return this._mimeTypeComponents||(this._mimeTypeComponents=parseMIMEType(this._mimeType)),this._mimeTypeComponents}get syntheticMIMEType(){if(this._type===WebInspector.Resource.typeFromMIMEType(this._mimeType))return this._mimeType;switch(this._type){case WebInspector.Resource.Type.Stylesheet:return"text/css";case WebInspector.Resource.Type.Script:return"text/javascript";}return this._mimeType}createObjectURL(){let _=this.content;return _?_ instanceof Blob?URL.createObjectURL(_):null:this._url}isMainResource(){return!!this._parentFrame&&this._parentFrame.mainResource===this}addInitiatedResource(_){_ instanceof WebInspector.Resource&&(this._initiatedResources.push(_),this.dispatchEventToListeners(WebInspector.Resource.Event.InitiatedResourcesDidChange))}get parentFrame(){return this._parentFrame}get finished(){return this._finished}get failed(){return this._failed}get canceled(){return this._canceled}get failureReasonText(){return this._failureReasonText}get requestDataContentType(){return this._requestHeaders.valueForCaseInsensitiveKey("Content-Type")||null}get requestHeaders(){return this._requestHeaders}get responseHeaders(){return this._responseHeaders}get requestSentTimestamp(){return this._requestSentTimestamp}get lastRedirectReceivedTimestamp(){return this._lastRedirectReceivedTimestamp}get responseReceivedTimestamp(){return this._responseReceivedTimestamp}get lastDataReceivedTimestamp(){return this._lastDataReceivedTimestamp}get finishedOrFailedTimestamp(){return this._finishedOrFailedTimestamp}get firstTimestamp(){return this.timingData.startTime||this.lastRedirectReceivedTimestamp||this.responseReceivedTimestamp||this.lastDataReceivedTimestamp||this.finishedOrFailedTimestamp}get lastTimestamp(){return this.timingData.responseEnd||this.lastDataReceivedTimestamp||this.responseReceivedTimestamp||this.lastRedirectReceivedTimestamp||this.requestSentTimestamp}get duration(){return this.timingData.responseEnd-this.timingData.requestStart}get latency(){return this.timingData.responseStart-this.timingData.requestStart}get receiveDuration(){return this.timingData.responseEnd-this.timingData.responseStart}get cached(){return this._cached}get requestHeadersTransferSize(){return this._requestHeadersTransferSize}get requestBodyTransferSize(){return this._requestBodyTransferSize}get responseHeadersTransferSize(){return this._responseHeadersTransferSize}get responseBodyTransferSize(){return this._responseBodyTransferSize}get cachedResponseBodySize(){return this._cachedResponseBodySize}get size(){return isNaN(this._cachedResponseBodySize)?isNaN(this._responseBodySize)||0===this._responseBodySize?this._estimatedSize:this._responseBodySize:this._cachedResponseBodySize}get networkEncodedSize(){return this._responseBodyTransferSize}get networkDecodedSize(){return this._responseBodySize}get networkTotalTransferSize(){return this._responseHeadersTransferSize+this._responseBodyTransferSize}get estimatedNetworkEncodedSize(){let _=this.networkEncodedSize;if(!isNaN(_))return _;if(this._cached)return 0;if("mac"===WebInspector.Platform.name){let S=+this._responseHeaders.valueForCaseInsensitiveKey("Content-Length");if(!isNaN(S))return S}return isNaN(this._estimatedTransferSize)?+(this._responseHeaders.valueForCaseInsensitiveKey("Content-Length")||this._estimatedSize):this._estimatedTransferSize}get estimatedTotalTransferSize(){let _=this.networkTotalTransferSize;return isNaN(_)?304===this.statusCode?this._estimatedResponseHeadersSize:this._cached?0:this._estimatedResponseHeadersSize+this.estimatedNetworkEncodedSize:_}get compressed(){let _=this._responseHeaders.valueForCaseInsensitiveKey("Content-Encoding");return!!(_&&/\b(?:gzip|deflate)\b/.test(_))}get scripts(){return this._scripts||[]}scriptForLocation(_){if(_.sourceCode!==this)return null;for(var S=_.lineNumber,C=_.columnNumber,f=0,T;f<this._scripts.length;++f)if(T=this._scripts[f],T.range.startLine<=S&&T.range.endLine>=S){if(T.range.startLine===S&&C<T.range.startColumn)continue;if(T.range.endLine===S&&C>T.range.endColumn)continue;return T}return null}updateForRedirectResponse(_,S,C){var f=this._url;this._url=_,this._requestHeaders=S||{},this._lastRedirectReceivedTimestamp=C||NaN,f!==_&&(this._urlComponents=null,this.dispatchEventToListeners(WebInspector.Resource.Event.URLDidChange,{oldURL:f})),this.dispatchEventToListeners(WebInspector.Resource.Event.RequestHeadersDidChange),this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange)}hasResponse(){return!isNaN(this._statusCode)}updateForResponse(_,S,C,f,T,E,I,R,N){let L=this._url,D=this._mimeType,M=this._type;C in WebInspector.Resource.Type&&(C=WebInspector.Resource.Type[C]),this._url=_,this._mimeType=S,this._type=C||WebInspector.Resource.typeFromMIMEType(S),this._statusCode=T,this._statusText=E,this._responseHeaders=f||{},this._responseReceivedTimestamp=I||NaN,this._timingData=WebInspector.ResourceTimingData.fromPayload(R,this),N&&(this._responseSource=WebInspector.Resource.responseSourceFromPayload(N));for(let F in this._estimatedResponseHeadersSize=(this._statusCode+"").length+this._statusText.length+12,this._responseHeaders)this._estimatedResponseHeadersSize+=F.length+this._responseHeaders[F].length+4;this._cached||304!==T&&this._responseSource!==WebInspector.Resource.ResponseSource.MemoryCache&&this._responseSource!==WebInspector.Resource.ResponseSource.DiskCache||this.markAsCached(),L!==_&&(this._urlComponents=null,this.dispatchEventToListeners(WebInspector.Resource.Event.URLDidChange,{oldURL:L})),D!==S&&(this._mimeTypeComponents=null,this.dispatchEventToListeners(WebInspector.Resource.Event.MIMETypeDidChange,{oldMIMEType:D})),M!==C&&this.dispatchEventToListeners(WebInspector.Resource.Event.TypeDidChange,{oldType:M}),(304===T||this._responseHeaders.valueForCaseInsensitiveKey("Content-Length"))&&this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange),this.dispatchEventToListeners(WebInspector.Resource.Event.ResponseReceived),this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange)}updateWithMetrics(_){this._receivedNetworkLoadMetrics=!0,_.protocol&&(this._protocol=_.protocol),_.priority&&(this._priority=WebInspector.Resource.networkPriorityFromPayload(_.priority)),_.remoteAddress&&(this._remoteAddress=_.remoteAddress),_.connectionIdentifier&&(this._connectionIdentifier=WebInspector.Resource.connectionIdentifierFromPayload(_.connectionIdentifier)),_.requestHeaders&&(this._requestHeaders=_.requestHeaders,this.dispatchEventToListeners(WebInspector.Resource.Event.RequestHeadersDidChange)),"requestHeaderBytesSent"in _&&(this._requestHeadersTransferSize=_.requestHeaderBytesSent,this._requestBodyTransferSize=_.requestBodyBytesSent,this._responseHeadersTransferSize=_.responseHeaderBytesReceived,this._responseBodyTransferSize=_.responseBodyBytesReceived,this._responseBodySize=_.responseBodyDecodedSize,this.dispatchEventToListeners(WebInspector.Resource.Event.SizeDidChange,{previousSize:this._estimatedSize}),this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange))}setCachedResponseBodySize(_){this._cachedResponseBodySize=_}requestContentFromBackend(){return this._requestIdentifier?NetworkAgent.getResponseBody(this._requestIdentifier):this._parentFrame?PageAgent.getResourceContent(this._parentFrame.id,this._url):Promise.reject(new Error("Content request failed."))}increaseSize(_,S){isNaN(this._estimatedSize)&&(this._estimatedSize=0);let C=this._estimatedSize;this._estimatedSize+=_,this._lastDataReceivedTimestamp=S||NaN,this.dispatchEventToListeners(WebInspector.Resource.Event.SizeDidChange,{previousSize:C}),isNaN(this._estimatedTransferSize)&&304!==this._statusCode&&!this._responseHeaders.valueForCaseInsensitiveKey("Content-Length")&&this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange)}increaseTransferSize(_){isNaN(this._estimatedTransferSize)&&(this._estimatedTransferSize=0),this._estimatedTransferSize+=_,this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange)}markAsCached(){this._cached=!0,this.dispatchEventToListeners(WebInspector.Resource.Event.CacheStatusDidChange),304!==this._statusCode&&this.dispatchEventToListeners(WebInspector.Resource.Event.TransferSizeDidChange)}markAsFinished(_){this._finished=!0,this._finishedOrFailedTimestamp=_||NaN,this._timingData.markResponseEndTime(_||NaN),this._finishThenRequestContentPromise&&(this._finishThenRequestContentPromise=null),this.dispatchEventToListeners(WebInspector.Resource.Event.LoadingDidFinish),this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange)}markAsFailed(_,S,C){this._failed=!0,this._canceled=_,this._finishedOrFailedTimestamp=S||NaN,this._failureReasonText||(this._failureReasonText=C||null),this.dispatchEventToListeners(WebInspector.Resource.Event.LoadingDidFail),this.dispatchEventToListeners(WebInspector.Resource.Event.TimestampsDidChange)}revertMarkAsFinished(){this._finished=!1,this._finishedOrFailedTimestamp=NaN}legacyMarkServedFromMemoryCache(){this._responseSource=WebInspector.Resource.ResponseSource.MemoryCache,this.markAsCached()}legacyMarkServedFromDiskCache(){this._responseSource=WebInspector.Resource.ResponseSource.DiskCache,this.markAsCached()}hadLoadingError(){return this._failed||this._canceled||400<=this._statusCode}getImageSize(_){function C(){this._imageSize=null,_(this._imageSize)}if(this.type!==WebInspector.Resource.Type.Image)throw"Resource is not an image.";if(void 0!==this._imageSize)return void _(this._imageSize);var f=null,T=new Image;T.addEventListener("load",function(){URL.revokeObjectURL(f),this._imageSize={width:T.width,height:T.height},_(this._imageSize)}.bind(this),!1),this.requestContent().then(E=>{f=T.src=E.sourceCode.createObjectURL(),f||C.call(this)},C.bind(this))}requestContent(){return this._finished?super.requestContent():this._failed?Promise.resolve({error:WebInspector.UIString("An error occurred trying to load the resource.")}):(this._finishThenRequestContentPromise||(this._finishThenRequestContentPromise=new Promise((_,S)=>{this.addEventListener(WebInspector.Resource.Event.LoadingDidFinish,_),this.addEventListener(WebInspector.Resource.Event.LoadingDidFail,S)}).then(WebInspector.SourceCode.prototype.requestContent.bind(this))),this._finishThenRequestContentPromise)}associateWithScript(_){if(this._scripts||(this._scripts=[]),this._scripts.push(_),this._type===WebInspector.Resource.Type.Other||this._type===WebInspector.Resource.Type.XHR){let S=this._type;this._type=WebInspector.Resource.Type.Script,this.dispatchEventToListeners(WebInspector.Resource.Event.TypeDidChange,{oldType:S})}}saveIdentityToCookie(_){_[WebInspector.Resource.URLCookieKey]=this.url.hash,_[WebInspector.Resource.MainResourceCookieKey]=this.isMainResource()}generateCURLCommand(){function _(f){return /[^\x20-\x7E]|'/.test(f)?"$'"+f.replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/!/g,"\\041").replace(/[^\x20-\x7E]/g,function(E){let I=E.charCodeAt(0),R=I.toString(16);return 256>I?"\\x"+R.padStart(2,"0"):"\\u"+R.padStart(4,"0")})+"'":`'${f}'`}let S=["curl "+_(this.url).replace(/[[{}\]]/g,"\\$&"),`-X${this.requestMethod}`];for(let f in this.requestHeaders)S.push("-H "+_(`${f}: ${this.requestHeaders[f]}`));this.requestDataContentType&&"GET"!==this.requestMethod&&this.requestData&&(this.requestDataContentType.match(/^application\/x-www-form-urlencoded\s*(;.*)?$/i)?S.push("--data "+_(this.requestData)):S.push("--data-binary "+_(this.requestData)));let C=S.join(" \\\n");return InspectorFrontendHost.copyText(C),C}},WebInspector.Resource.TypeIdentifier="resource",WebInspector.Resource.URLCookieKey="resource-url",WebInspector.Resource.MainResourceCookieKey="resource-is-main-resource",WebInspector.Resource.Event={URLDidChange:"resource-url-did-change",MIMETypeDidChange:"resource-mime-type-did-change",TypeDidChange:"resource-type-did-change",RequestHeadersDidChange:"resource-request-headers-did-change",ResponseReceived:"resource-response-received",LoadingDidFinish:"resource-loading-did-finish",LoadingDidFail:"resource-loading-did-fail",TimestampsDidChange:"resource-timestamps-did-change",SizeDidChange:"resource-size-did-change",TransferSizeDidChange:"resource-transfer-size-did-change",CacheStatusDidChange:"resource-cached-did-change",InitiatedResourcesDidChange:"resource-initiated-resources-did-change"},WebInspector.Resource.Type={Document:"resource-type-document",Stylesheet:"resource-type-stylesheet",Image:"resource-type-image",Font:"resource-type-font",Script:"resource-type-script",XHR:"resource-type-xhr",Fetch:"resource-type-fetch",WebSocket:"resource-type-websocket",Other:"resource-type-other"},WebInspector.Resource.ResponseSource={Unknown:Symbol("unknown"),Network:Symbol("network"),MemoryCache:Symbol("memory-cache"),DiskCache:Symbol("disk-cache")},WebInspector.Resource.NetworkPriority={Unknown:Symbol("unknown"),Low:Symbol("low"),Medium:Symbol("medium"),High:Symbol("high")},WebInspector.Resource._mimeTypeMap={"text/html":WebInspector.Resource.Type.Document,"text/xml":WebInspector.Resource.Type.Document,"text/plain":WebInspector.Resource.Type.Document,"application/xhtml+xml":WebInspector.Resource.Type.Document,"image/svg+xml":WebInspector.Resource.Type.Document,"text/css":WebInspector.Resource.Type.Stylesheet,"text/xsl":WebInspector.Resource.Type.Stylesheet,"text/x-less":WebInspector.Resource.Type.Stylesheet,"text/x-sass":WebInspector.Resource.Type.Stylesheet,"text/x-scss":WebInspector.Resource.Type.Stylesheet,"application/pdf":WebInspector.Resource.Type.Image,"application/x-font-type1":WebInspector.Resource.Type.Font,"application/x-font-ttf":WebInspector.Resource.Type.Font,"application/x-font-woff":WebInspector.Resource.Type.Font,"application/x-truetype-font":WebInspector.Resource.Type.Font,"text/javascript":WebInspector.Resource.Type.Script,"text/ecmascript":WebInspector.Resource.Type.Script,"application/javascript":WebInspector.Resource.Type.Script,"application/ecmascript":WebInspector.Resource.Type.Script,"application/x-javascript":WebInspector.Resource.Type.Script,"application/json":WebInspector.Resource.Type.Script,"application/x-json":WebInspector.Resource.Type.Script,"text/x-javascript":WebInspector.Resource.Type.Script,"text/x-json":WebInspector.Resource.Type.Script,"text/javascript1.1":WebInspector.Resource.Type.Script,"text/javascript1.2":WebInspector.Resource.Type.Script,"text/javascript1.3":WebInspector.Resource.Type.Script,"text/jscript":WebInspector.Resource.Type.Script,"text/livescript":WebInspector.Resource.Type.Script,"text/x-livescript":WebInspector.Resource.Type.Script,"text/typescript":WebInspector.Resource.Type.Script,"text/x-clojure":WebInspector.Resource.Type.Script,"text/x-coffeescript":WebInspector.Resource.Type.Script},WebInspector.ResourceCollection=class extends WebInspector.Collection{constructor(_){super(WebInspector.ResourceCollection.verifierForType(_)),this._resourceType=_||null,this._resourceURLMap=new Map,this._resourcesTypeMap=new Map}static verifierForType(_){return _===WebInspector.Resource.Type.Document?WebInspector.ResourceCollection.TypeVerifier.Document:_===WebInspector.Resource.Type.Stylesheet?WebInspector.ResourceCollection.TypeVerifier.Stylesheet:_===WebInspector.Resource.Type.Image?WebInspector.ResourceCollection.TypeVerifier.Image:_===WebInspector.Resource.Type.Font?WebInspector.ResourceCollection.TypeVerifier.Font:_===WebInspector.Resource.Type.Script?WebInspector.ResourceCollection.TypeVerifier.Script:_===WebInspector.Resource.Type.XHR?WebInspector.ResourceCollection.TypeVerifier.XHR:_===WebInspector.Resource.Type.Fetch?WebInspector.ResourceCollection.TypeVerifier.Fetch:_===WebInspector.Resource.Type.WebSocket?WebInspector.ResourceCollection.TypeVerifier.WebSocket:_===WebInspector.Resource.Type.Other?WebInspector.ResourceCollection.TypeVerifier.Other:WebInspector.Collection.TypeVerifier.Resource}resourceForURL(_){return this._resourceURLMap.get(_)||null}resourceCollectionForType(_){if(this._resourceType)return this;let S=this._resourcesTypeMap.get(_);return S||(S=new WebInspector.ResourceCollection(_),this._resourcesTypeMap.set(_,S)),S}clear(){super.clear(),this._resourceURLMap.clear(),this._resourceType||this._resourcesTypeMap.clear()}itemAdded(_){this._associateWithResource(_)}itemRemoved(_){this._disassociateWithResource(_)}itemsCleared(_){for(let C of _)this._disassociateWithResource(C,!0)}_associateWithResource(_){if(this._resourceURLMap.set(_.url,_),!this._resourceType){let S=this.resourceCollectionForType(_.type);S.add(_)}_.addEventListener(WebInspector.Resource.Event.URLDidChange,this._resourceURLDidChange,this),_.addEventListener(WebInspector.Resource.Event.TypeDidChange,this._resourceTypeDidChange,this)}_disassociateWithResource(_,S){if(_.removeEventListener(WebInspector.Resource.Event.URLDidChange,this._resourceURLDidChange,this),_.removeEventListener(WebInspector.Resource.Event.TypeDidChange,this._resourceTypeDidChange,this),!S){if(!this._resourceType){let C=this.resourceCollectionForType(_.type);C.remove(_)}this._resourceURLMap.delete(_.url)}}_resourceURLDidChange(_){let S=_.target;if(S instanceof WebInspector.Resource){let C=_.data.oldURL;C&&(this._resourceURLMap.set(S.url,S),this._resourceURLMap.delete(C))}}_resourceTypeDidChange(_){let S=_.target;if(S instanceof WebInspector.Resource){if(this._resourceType)return void this.remove(S);let C=this.resourceCollectionForType(S.type);C.add(S)}}},WebInspector.ResourceCollection.TypeVerifier={Document:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Document,Stylesheet:u=>{return!!WebInspector.Collection.TypeVerifier.CSSStyleSheet(u)||WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Stylesheet},Image:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Image,Font:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Font,Script:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Script,XHR:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.XHR,Fetch:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Fetch,WebSocket:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.WebSocket,Other:u=>WebInspector.Collection.TypeVerifier.Resource(u)&&u.type===WebInspector.Resource.Type.Other},WebInspector.ResourceQueryMatch=class extends WebInspector.Object{constructor(_,S,C){super(),this._type=_,this._index=S,this._queryIndex=C,this._rank=void 0}get type(){return this._type}get index(){return this._index}get queryIndex(){return this._queryIndex}},WebInspector.ResourceQueryMatch.Type={Normal:Symbol("normal"),Special:Symbol("special")},WebInspector.ResourceQueryResult=class extends WebInspector.Object{constructor(_,S,C){super(),this._resource=_,this._matches=S,this._cookie=C||null}get resource(){return this._resource}get cookie(){return this._cookie}get rank(){return void 0===this._rank&&this._calculateRank(),this._rank}get matchingTextRanges(){return this._matchingTextRanges||(this._matchingTextRanges=this._createMatchingTextRanges()),this._matchingTextRanges}_calculateRank(){function _(I){return I.type===WebInspector.ResourceQueryMatch.Type.Special?5:1}this._rank=0;let T=null,E=null;for(let I of this._matches){this._rank+=10*_(I);let R=T&&T.index===I.index-1;R?(!E&&(E=T),this._rank+=5*_(E)*(I.index-E.index)):E&&(E=null),T=I,R||(this._rank-=I.index*_(I))}}_createMatchingTextRanges(){if(!this._matches.length)return[];let _=[],S=this._matches[0].index,C=S;for(let f=1,T;f<this._matches.length;++f){if(T=this._matches[f],T.index===C+1){C++;continue}_.push(new WebInspector.TextRange(0,S,0,C+1)),S=T.index,C=S}return _.push(new WebInspector.TextRange(0,S,0,C+1)),_}__test_createMatchesMask(){let _=this._resource.displayName,S=-1,C="";for(let f of this._matches){let T=" ".repeat(f.index-S-1);C+=T,C+=_[f.index],S=f.index}return C}},WebInspector.ResourceTimelineRecord=class extends WebInspector.TimelineRecord{constructor(_){super(WebInspector.TimelineRecord.Type.Network),this._resource=_,this._resource.addEventListener(WebInspector.Resource.Event.TimestampsDidChange,this._dispatchUpdatedEvent,this)}get resource(){return this._resource}get updatesDynamically(){return!0}get usesActiveStartTime(){return!0}get startTime(){return this._resource.timingData.startTime}get activeStartTime(){return this._resource.timingData.responseStart}get endTime(){return this._resource.timingData.responseEnd}_dispatchUpdatedEvent(){this.dispatchEventToListeners(WebInspector.TimelineRecord.Event.Updated)}},WebInspector.ResourceTimingData=class extends WebInspector.Object{constructor(_,S){super(),S=S||{},this._resource=_,this._startTime=S.startTime||NaN,this._domainLookupStart=S.domainLookupStart||NaN,this._domainLookupEnd=S.domainLookupEnd||NaN,this._connectStart=S.connectStart||NaN,this._connectEnd=S.connectEnd||NaN,this._secureConnectionStart=S.secureConnectionStart||NaN,this._requestStart=S.requestStart||NaN,this._responseStart=S.responseStart||NaN,this._responseEnd=S.responseEnd||NaN,this._domainLookupStart>=this._domainLookupEnd&&(this._domainLookupStart=this._domainLookupEnd=NaN),this._connectStart>=this._connectEnd&&(this._connectStart=this._connectEnd=NaN)}static fromPayload(_,S){function C(T){return 0<T?_.startTime+T/1e3:NaN}_=_||{},("number"==typeof _.requestTime||"number"==typeof _.navigationStart)&&(_={});let f={startTime:_.startTime,domainLookupStart:C(_.domainLookupStart),domainLookupEnd:C(_.domainLookupEnd),connectStart:C(_.connectStart),connectEnd:C(_.connectEnd),secureConnectionStart:C(_.secureConnectionStart),requestStart:C(_.requestStart),responseStart:C(_.responseStart),responseEnd:C(_.responseEnd)};return isNaN(f.connectStart)&&!isNaN(f.secureConnectionStart)&&(f.connectStart=f.secureConnectionStart),new WebInspector.ResourceTimingData(S,f)}get startTime(){return this._startTime||this._resource.requestSentTimestamp}get domainLookupStart(){return this._domainLookupStart}get domainLookupEnd(){return this._domainLookupEnd}get connectStart(){return this._connectStart}get connectEnd(){return this._connectEnd}get secureConnectionStart(){return this._secureConnectionStart}get requestStart(){return this._requestStart||this._startTime||this._resource.requestSentTimestamp}get responseStart(){return this._responseStart||this._startTime||this._resource.responseReceivedTimestamp}get responseEnd(){return this._responseEnd||this._resource.finishedOrFailedTimestamp}markResponseEndTime(_){this._responseEnd=_}},WebInspector.Revision=class extends WebInspector.Object{apply(){console.error("Needs to be implemented by a subclass.")}revert(){console.error("Needs to be implemented by a subclass.")}copy(){return this}},WebInspector.ScopeChainNode=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),_ in WebInspector.ScopeChainNode.Type&&(_=WebInspector.ScopeChainNode.Type[_]),this._type=_||null,this._objects=S||[],this._name=C||"",this._location=f||null,this._empty=T||!1}get type(){return this._type}get objects(){return this._objects}get name(){return this._name}get location(){return this._location}get empty(){return this._empty}get hash(){return this._hash?this._hash:(this._hash=this._name,this._location&&(this._hash+=`:${this._location.scriptId}:${this._location.lineNumber}:${this._location.columnNumber}`),this._hash)}convertToLocalScope(){this._type=WebInspector.ScopeChainNode.Type.Local}},WebInspector.ScopeChainNode.Type={Local:"scope-chain-type-local",Global:"scope-chain-type-global",GlobalLexicalEnvironment:"scope-chain-type-global-lexical-environment",With:"scope-chain-type-with",Closure:"scope-chain-type-closure",Catch:"scope-chain-type-catch",FunctionName:"scope-chain-type-function-name",Block:"scope-chain-type-block"},WebInspector.Script=class extends WebInspector.SourceCode{constructor(_,S,C,f,T,E,I,R){if(super(),this._target=_,this._id=S||null,this._range=C||null,this._url=f||null,this._sourceType=T||WebInspector.Script.SourceType.Program,this._sourceURL=I||null,this._sourceMappingURL=R||null,this._injected=E||!1,this._dynamicallyAddedScriptElement=!1,this._scriptSyntaxTree=null,this._resource=this._resolveResource(),this._resource&&this._resource.type===WebInspector.Resource.Type.Document&&!this._range.startLine&&!this._range.startColumn){let N=this._resource;this._resource=null,this._dynamicallyAddedScriptElement=!0,N.parentFrame.addExtraScript(this),this._dynamicallyAddedScriptElementNumber=N.parentFrame.extraScriptCollection.items.size}else this._resource&&this._resource.associateWithScript(this);isWebInspectorConsoleEvaluationScript(this._sourceURL)&&(this._uniqueDisplayNameNumber=this.constructor._nextUniqueConsoleDisplayNameNumber++),this._sourceMappingURL&&WebInspector.sourceMapManager.downloadSourceMap(this._sourceMappingURL,this._url,this)}static resetUniqueDisplayNameNumbers(){WebInspector.Script._nextUniqueDisplayNameNumber=1,WebInspector.Script._nextUniqueConsoleDisplayNameNumber=1}get target(){return this._target}get id(){return this._id}get range(){return this._range}get url(){return this._url}get sourceType(){return this._sourceType}get sourceURL(){return this._sourceURL}get sourceMappingURL(){return this._sourceMappingURL}get injected(){return this._injected}get contentIdentifier(){return this._url?this._url:this._sourceURL?isWebInspectorConsoleEvaluationScript(this._sourceURL)?null:isWebInspectorInternalScript(this._sourceURL)?null:this._sourceURL:null}get urlComponents(){return this._urlComponents||(this._urlComponents=parseURL(this._url)),this._urlComponents}get mimeType(){return this._resource.mimeType}get displayName(){return this._url&&!this._dynamicallyAddedScriptElement?WebInspector.displayNameForURL(this._url,this.urlComponents):isWebInspectorConsoleEvaluationScript(this._sourceURL)?WebInspector.UIString("Console Evaluation %d").format(this._uniqueDisplayNameNumber):this._sourceURL?(this._sourceURLComponents||(this._sourceURLComponents=parseURL(this._sourceURL)),WebInspector.displayNameForURL(this._sourceURL,this._sourceURLComponents)):this._dynamicallyAddedScriptElement?WebInspector.UIString("Script Element %d").format(this._dynamicallyAddedScriptElementNumber):(this._uniqueDisplayNameNumber||(this._uniqueDisplayNameNumber=this.constructor._nextUniqueDisplayNameNumber++),WebInspector.UIString("Anonymous Script %d").format(this._uniqueDisplayNameNumber))}get displayURL(){const _=!0,S=64;return this._url?WebInspector.truncateURL(this._url,_,S):this._sourceURL?WebInspector.truncateURL(this._sourceURL,_,S):null}get dynamicallyAddedScriptElement(){return this._dynamicallyAddedScriptElement}get anonymous(){return!this._resource&&!this._url&&!this._sourceURL}get resource(){return this._resource}get scriptSyntaxTree(){return this._scriptSyntaxTree}isMainResource(){return this._target.mainResource===this}requestContentFromBackend(){return this._id?this._target.DebuggerAgent.getScriptSource(this._id):Promise.reject(new Error("There is no identifier to request content with."))}saveIdentityToCookie(_){_[WebInspector.Script.URLCookieKey]=this.url,_[WebInspector.Script.DisplayNameCookieKey]=this.displayName}requestScriptSyntaxTree(_){if(this._scriptSyntaxTree)return void setTimeout(()=>{_(this._scriptSyntaxTree)},0);var S=f=>{this._makeSyntaxTree(f),_(this._scriptSyntaxTree)},C=this.content;return!C&&this._resource&&this._resource.type===WebInspector.Resource.Type.Script&&this._resource.finished&&(C=this._resource.content),C?void setTimeout(S,0,C):void this.requestContent().then(function(f){S(f.sourceCode.content)}).catch(function(){S(null)})}_resolveResource(){if(!this._url)return null;let _=WebInspector.frameResourceManager;this._target!==WebInspector.mainTarget&&(_=this._target.resourceCollection);try{let S=_.resourceForURL(this._url);if(S)return S;let C=decodeURI(this._url);if(C!==this._url&&(S=_.resourceForURL(C),S))return S;let f=removeURLFragment(this._url);if(f!==this._url&&(S=_.resourceForURL(f),S))return S;let T=removeURLFragment(C);if(T!==C&&(S=_.resourceForURL(T),S))return S}catch(S){}return null}_makeSyntaxTree(_){this._scriptSyntaxTree||!_||(this._scriptSyntaxTree=new WebInspector.ScriptSyntaxTree(_,this))}},WebInspector.Script.SourceType={Program:"script-source-type-program",Module:"script-source-type-module"},WebInspector.Script.TypeIdentifier="script",WebInspector.Script.URLCookieKey="script-url",WebInspector.Script.DisplayNameCookieKey="script-display-name",WebInspector.Script._nextUniqueDisplayNameNumber=1,WebInspector.Script._nextUniqueConsoleDisplayNameNumber=1,WebInspector.ScriptInstrument=class extends WebInspector.Instrument{get timelineRecordType(){return WebInspector.TimelineRecord.Type.Script}startInstrumentation(_){if(!window.ScriptProfilerAgent)return void super.startInstrumentation();_||ScriptProfilerAgent.startTracking(!0)}stopInstrumentation(_){return window.ScriptProfilerAgent?void(!_&&ScriptProfilerAgent.stopTracking()):void super.stopInstrumentation()}},WebInspector.ScriptSyntaxTree=class extends WebInspector.Object{constructor(_,S){super(),this._script=S;try{let C=this._script.sourceType===WebInspector.Script.SourceType.Module?"module":"script",f=esprima.parse(_,{range:!0,sourceType:C});this._syntaxTree=this._createInternalSyntaxTree(f),this._parsedSuccessfully=!0}catch(C){this._parsedSuccessfully=!1,this._syntaxTree=null,console.error("Couldn't parse JavaScript File: "+S.url,C)}}get parsedSuccessfully(){return this._parsedSuccessfully}forEachNode(_){this._parsedSuccessfully&&this._recurse(this._syntaxTree,_,this._defaultParserState())}filter(_,S){if(!this._parsedSuccessfully)return[];var f=[];return this._recurse(S,function(T,E){_(T)?f.push(T):E.skipChildNodes=!0},this._defaultParserState()),f}containersOfOffset(_){if(!this._parsedSuccessfully)return[];let S=[];const C=0,f=1;return this.forEachNode((T,E)=>{T.range[f]<_&&(E.skipChildNodes=!0),T.range[C]>_&&(E.shouldStopEarly=!0),T.range[C]<=_&&T.range[f]>=_&&S.push(T)}),S}filterByRange(_,S){if(!this._parsedSuccessfully)return[];var f=[],T=0;return this.forEachNode(function(I,R){I.range[1]<_&&(R.skipChildNodes=!0),_<=I.range[T]&&I.range[T]<=S&&f.push(I),I.range[T]>S&&(R.shouldStopEarly=!0)}),f}containsNonEmptyReturnStatement(_){if(!this._parsedSuccessfully)return!1;if(void 0!==_.attachments._hasNonEmptyReturnStatement)return _.attachments._hasNonEmptyReturnStatement;var C=this.filter(function(I){return I.type!==WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression&&I.type!==WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration&&I.type!==WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression},_),f=!1,T=WebInspector.ScriptSyntaxTree.NodeType.ReturnStatement;for(var E of C)if(E.type===T&&E.argument){f=!0;break}return _.attachments._hasNonEmptyReturnStatement=f,f}static functionReturnDivot(_){return DOMAgent.hasEvent("pseudoElementAdded")?_.typeProfilingReturnDivot:_.body.range[0]}updateTypes(_,S){function C(L,D){if(!L){for(var M=0;M<D.length;M++){var P=T[M],O=WebInspector.TypeDescription.fromPayload(D[M]);f[M].typeInformationDescriptor===WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.FunctionReturn?P.attachments.returnTypes=O:P.attachments.types=O}S(T)}}if(this._parsedSuccessfully){var f=[],T=[],E=this._script.id;for(var I of _)switch(I.type){case WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration:case WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression:case WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression:for(var R of I.params)for(var N of this._gatherIdentifiersInDeclaration(R))f.push({typeInformationDescriptor:WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.NormalExpression,sourceID:E,divot:N.range[0]}),T.push(N);f.push({typeInformationDescriptor:WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.FunctionReturn,sourceID:E,divot:WebInspector.ScriptSyntaxTree.functionReturnDivot(I)}),T.push(I);break;case WebInspector.ScriptSyntaxTree.NodeType.VariableDeclarator:for(var N of this._gatherIdentifiersInDeclaration(I.id))f.push({typeInformationDescriptor:WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor.NormalExpression,sourceID:E,divot:N.range[0]}),T.push(N);}this._script.target.RuntimeAgent.getRuntimeTypesForVariablesAtOffsets(f,C)}}_gatherIdentifiersInDeclaration(_){function S(C){switch(C.type){case WebInspector.ScriptSyntaxTree.NodeType.Identifier:return[C];case WebInspector.ScriptSyntaxTree.NodeType.Property:return S(C.value);case WebInspector.ScriptSyntaxTree.NodeType.ObjectPattern:var f=[];for(var T of C.properties)for(var E of S(T))f.push(E);return f;case WebInspector.ScriptSyntaxTree.NodeType.ArrayPattern:var f=[];for(var I of C.elements)for(var E of S(I))f.push(E);return f;case WebInspector.ScriptSyntaxTree.NodeType.AssignmentPattern:return S(C.left);case WebInspector.ScriptSyntaxTree.NodeType.RestElement:case WebInspector.ScriptSyntaxTree.NodeType.RestProperty:return S(C.argument);default:return[];}}return S(_)}_defaultParserState(){return{shouldStopEarly:!1,skipChildNodes:!1}}_recurse(_,S,C){if(_&&!(C.shouldStopEarly||C.skipChildNodes)){switch(S(_,C),_.type){case WebInspector.ScriptSyntaxTree.NodeType.AssignmentExpression:this._recurse(_.left,S,C),this._recurse(_.right,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ArrayExpression:case WebInspector.ScriptSyntaxTree.NodeType.ArrayPattern:this._recurseArray(_.elements,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.AssignmentPattern:this._recurse(_.left,S,C),this._recurse(_.right,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.AwaitExpression:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.BlockStatement:this._recurseArray(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.BinaryExpression:this._recurse(_.left,S,C),this._recurse(_.right,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.BreakStatement:this._recurse(_.label,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.CatchClause:this._recurse(_.param,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.CallExpression:this._recurse(_.callee,S,C),this._recurseArray(_.arguments,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ClassBody:this._recurseArray(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ClassDeclaration:case WebInspector.ScriptSyntaxTree.NodeType.ClassExpression:this._recurse(_.id,S,C),this._recurse(_.superClass,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ContinueStatement:this._recurse(_.label,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.DoWhileStatement:this._recurse(_.body,S,C),this._recurse(_.test,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ExpressionStatement:this._recurse(_.expression,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ForStatement:this._recurse(_.init,S,C),this._recurse(_.test,S,C),this._recurse(_.update,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ForInStatement:case WebInspector.ScriptSyntaxTree.NodeType.ForOfStatement:this._recurse(_.left,S,C),this._recurse(_.right,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration:case WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression:case WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression:this._recurse(_.id,S,C),this._recurseArray(_.params,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.IfStatement:this._recurse(_.test,S,C),this._recurse(_.consequent,S,C),this._recurse(_.alternate,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.LabeledStatement:this._recurse(_.label,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.LogicalExpression:this._recurse(_.left,S,C),this._recurse(_.right,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.MemberExpression:this._recurse(_.object,S,C),this._recurse(_.property,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.MethodDefinition:this._recurse(_.key,S,C),this._recurse(_.value,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.NewExpression:this._recurse(_.callee,S,C),this._recurseArray(_.arguments,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ObjectExpression:case WebInspector.ScriptSyntaxTree.NodeType.ObjectPattern:this._recurseArray(_.properties,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.Program:this._recurseArray(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.Property:this._recurse(_.key,S,C),this._recurse(_.value,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.RestElement:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.RestProperty:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ReturnStatement:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.SequenceExpression:this._recurseArray(_.expressions,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.SpreadElement:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.SpreadProperty:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.SwitchStatement:this._recurse(_.discriminant,S,C),this._recurseArray(_.cases,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.SwitchCase:this._recurse(_.test,S,C),this._recurseArray(_.consequent,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ConditionalExpression:this._recurse(_.test,S,C),this._recurse(_.consequent,S,C),this._recurse(_.alternate,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.TaggedTemplateExpression:this._recurse(_.tag,S,C),this._recurse(_.quasi,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.TemplateLiteral:this._recurseArray(_.quasis,S,C),this._recurseArray(_.expressions,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ThrowStatement:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.TryStatement:this._recurse(_.block,S,C),this._recurse(_.handler,S,C),this._recurse(_.finalizer,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.UnaryExpression:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.UpdateExpression:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.VariableDeclaration:this._recurseArray(_.declarations,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.VariableDeclarator:this._recurse(_.id,S,C),this._recurse(_.init,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.WhileStatement:this._recurse(_.test,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.WithStatement:this._recurse(_.object,S,C),this._recurse(_.body,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.YieldExpression:this._recurse(_.argument,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportAllDeclaration:this._recurse(_.source,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportNamedDeclaration:this._recurse(_.declaration,S,C),this._recurseArray(_.specifiers,S,C),this._recurse(_.source,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportDefaultDeclaration:this._recurse(_.declaration,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ExportSpecifier:this._recurse(_.local,S,C),this._recurse(_.exported,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportDeclaration:this._recurseArray(_.specifiers,S,C),this._recurse(_.source,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportDefaultSpecifier:this._recurse(_.local,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportNamespaceSpecifier:this._recurse(_.local,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.ImportSpecifier:this._recurse(_.imported,S,C),this._recurse(_.local,S,C);break;case WebInspector.ScriptSyntaxTree.NodeType.DebuggerStatement:case WebInspector.ScriptSyntaxTree.NodeType.EmptyStatement:case WebInspector.ScriptSyntaxTree.NodeType.Identifier:case WebInspector.ScriptSyntaxTree.NodeType.Import:case WebInspector.ScriptSyntaxTree.NodeType.Literal:case WebInspector.ScriptSyntaxTree.NodeType.MetaProperty:case WebInspector.ScriptSyntaxTree.NodeType.Super:case WebInspector.ScriptSyntaxTree.NodeType.ThisExpression:case WebInspector.ScriptSyntaxTree.NodeType.TemplateElement:}C.skipChildNodes=!1}}_recurseArray(_,S,C){for(var f of _)this._recurse(f,S,C)}_createInternalSyntaxTree(_){if(!_)return null;var S=null;switch(_.type){case"ArrayExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.ArrayExpression,elements:_.elements.map(this._createInternalSyntaxTree,this)};break;case"ArrayPattern":S={type:WebInspector.ScriptSyntaxTree.NodeType.ArrayPattern,elements:_.elements.map(this._createInternalSyntaxTree,this)};break;case"ArrowFunctionExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.ArrowFunctionExpression,id:this._createInternalSyntaxTree(_.id),params:_.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(_.body),generator:_.generator,expression:_.expression,async:_.async,typeProfilingReturnDivot:_.range[0]};break;case"AssignmentExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.AssignmentExpression,operator:_.operator,left:this._createInternalSyntaxTree(_.left),right:this._createInternalSyntaxTree(_.right)};break;case"AssignmentPattern":S={type:WebInspector.ScriptSyntaxTree.NodeType.AssignmentPattern,left:this._createInternalSyntaxTree(_.left),right:this._createInternalSyntaxTree(_.right)};break;case"AwaitExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.AwaitExpression,argument:this._createInternalSyntaxTree(_.argument)};break;case"BlockStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.BlockStatement,body:_.body.map(this._createInternalSyntaxTree,this)};break;case"BinaryExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.BinaryExpression,operator:_.operator,left:this._createInternalSyntaxTree(_.left),right:this._createInternalSyntaxTree(_.right)};break;case"BreakStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.BreakStatement,label:this._createInternalSyntaxTree(_.label)};break;case"CallExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.CallExpression,callee:this._createInternalSyntaxTree(_.callee),arguments:_.arguments.map(this._createInternalSyntaxTree,this)};break;case"CatchClause":S={type:WebInspector.ScriptSyntaxTree.NodeType.CatchClause,param:this._createInternalSyntaxTree(_.param),body:this._createInternalSyntaxTree(_.body)};break;case"ClassBody":S={type:WebInspector.ScriptSyntaxTree.NodeType.ClassBody,body:_.body.map(this._createInternalSyntaxTree,this)};break;case"ClassDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.ClassDeclaration,id:this._createInternalSyntaxTree(_.id),superClass:this._createInternalSyntaxTree(_.superClass),body:this._createInternalSyntaxTree(_.body)};break;case"ClassExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.ClassExpression,id:this._createInternalSyntaxTree(_.id),superClass:this._createInternalSyntaxTree(_.superClass),body:this._createInternalSyntaxTree(_.body)};break;case"ConditionalExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.ConditionalExpression,test:this._createInternalSyntaxTree(_.test),consequent:this._createInternalSyntaxTree(_.consequent),alternate:this._createInternalSyntaxTree(_.alternate)};break;case"ContinueStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ContinueStatement,label:this._createInternalSyntaxTree(_.label)};break;case"DoWhileStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.DoWhileStatement,body:this._createInternalSyntaxTree(_.body),test:this._createInternalSyntaxTree(_.test)};break;case"DebuggerStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.DebuggerStatement};break;case"EmptyStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.EmptyStatement};break;case"ExpressionStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ExpressionStatement,expression:this._createInternalSyntaxTree(_.expression)};break;case"ForStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ForStatement,init:this._createInternalSyntaxTree(_.init),test:this._createInternalSyntaxTree(_.test),update:this._createInternalSyntaxTree(_.update),body:this._createInternalSyntaxTree(_.body)};break;case"ForInStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ForInStatement,left:this._createInternalSyntaxTree(_.left),right:this._createInternalSyntaxTree(_.right),body:this._createInternalSyntaxTree(_.body)};break;case"ForOfStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ForOfStatement,left:this._createInternalSyntaxTree(_.left),right:this._createInternalSyntaxTree(_.right),body:this._createInternalSyntaxTree(_.body)};break;case"FunctionDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.FunctionDeclaration,id:this._createInternalSyntaxTree(_.id),params:_.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(_.body),generator:_.generator,async:_.async,typeProfilingReturnDivot:_.range[0]};break;case"FunctionExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.FunctionExpression,id:this._createInternalSyntaxTree(_.id),params:_.params.map(this._createInternalSyntaxTree,this),body:this._createInternalSyntaxTree(_.body),generator:_.generator,async:_.async,typeProfilingReturnDivot:_.range[0]};break;case"Identifier":S={type:WebInspector.ScriptSyntaxTree.NodeType.Identifier,name:_.name};break;case"IfStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.IfStatement,test:this._createInternalSyntaxTree(_.test),consequent:this._createInternalSyntaxTree(_.consequent),alternate:this._createInternalSyntaxTree(_.alternate)};break;case"Literal":S={type:WebInspector.ScriptSyntaxTree.NodeType.Literal,value:_.value,raw:_.raw};break;case"LabeledStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.LabeledStatement,label:this._createInternalSyntaxTree(_.label),body:this._createInternalSyntaxTree(_.body)};break;case"LogicalExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.LogicalExpression,left:this._createInternalSyntaxTree(_.left),right:this._createInternalSyntaxTree(_.right),operator:_.operator};break;case"MemberExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.MemberExpression,object:this._createInternalSyntaxTree(_.object),property:this._createInternalSyntaxTree(_.property),computed:_.computed};break;case"MetaProperty":S={type:WebInspector.ScriptSyntaxTree.NodeType.MetaProperty,meta:this._createInternalSyntaxTree(_.meta),property:this._createInternalSyntaxTree(_.property)};break;case"MethodDefinition":S={type:WebInspector.ScriptSyntaxTree.NodeType.MethodDefinition,key:this._createInternalSyntaxTree(_.key),value:this._createInternalSyntaxTree(_.value),computed:_.computed,kind:_.kind,static:_.static},S.value.typeProfilingReturnDivot=_.range[0];break;case"NewExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.NewExpression,callee:this._createInternalSyntaxTree(_.callee),arguments:_.arguments.map(this._createInternalSyntaxTree,this)};break;case"ObjectExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.ObjectExpression,properties:_.properties.map(this._createInternalSyntaxTree,this)};break;case"ObjectPattern":S={type:WebInspector.ScriptSyntaxTree.NodeType.ObjectPattern,properties:_.properties.map(this._createInternalSyntaxTree,this)};break;case"Program":S={type:WebInspector.ScriptSyntaxTree.NodeType.Program,sourceType:_.sourceType,body:_.body.map(this._createInternalSyntaxTree,this)};break;case"Property":S={type:WebInspector.ScriptSyntaxTree.NodeType.Property,key:this._createInternalSyntaxTree(_.key),value:this._createInternalSyntaxTree(_.value),kind:_.kind,method:_.method,computed:_.computed},("get"===S.kind||"set"===S.kind||S.method)&&(S.value.typeProfilingReturnDivot=_.range[0]);break;case"RestElement":S={type:WebInspector.ScriptSyntaxTree.NodeType.RestElement,argument:this._createInternalSyntaxTree(_.argument)};break;case"RestProperty":S={type:WebInspector.ScriptSyntaxTree.NodeType.RestProperty,argument:this._createInternalSyntaxTree(_.argument)};break;case"ReturnStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ReturnStatement,argument:this._createInternalSyntaxTree(_.argument)};break;case"SequenceExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.SequenceExpression,expressions:_.expressions.map(this._createInternalSyntaxTree,this)};break;case"SpreadElement":S={type:WebInspector.ScriptSyntaxTree.NodeType.SpreadElement,argument:this._createInternalSyntaxTree(_.argument)};break;case"SpreadProperty":S={type:WebInspector.ScriptSyntaxTree.NodeType.SpreadProperty,argument:this._createInternalSyntaxTree(_.argument)};break;case"Super":S={type:WebInspector.ScriptSyntaxTree.NodeType.Super};break;case"SwitchStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.SwitchStatement,discriminant:this._createInternalSyntaxTree(_.discriminant),cases:_.cases.map(this._createInternalSyntaxTree,this)};break;case"SwitchCase":S={type:WebInspector.ScriptSyntaxTree.NodeType.SwitchCase,test:this._createInternalSyntaxTree(_.test),consequent:_.consequent.map(this._createInternalSyntaxTree,this)};break;case"TaggedTemplateExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.TaggedTemplateExpression,tag:this._createInternalSyntaxTree(_.tag),quasi:this._createInternalSyntaxTree(_.quasi)};break;case"TemplateElement":S={type:WebInspector.ScriptSyntaxTree.NodeType.TemplateElement,value:_.value,tail:_.tail};break;case"TemplateLiteral":S={type:WebInspector.ScriptSyntaxTree.NodeType.TemplateLiteral,quasis:_.quasis.map(this._createInternalSyntaxTree,this),expressions:_.expressions.map(this._createInternalSyntaxTree,this)};break;case"ThisExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.ThisExpression};break;case"ThrowStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.ThrowStatement,argument:this._createInternalSyntaxTree(_.argument)};break;case"TryStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.TryStatement,block:this._createInternalSyntaxTree(_.block),handler:this._createInternalSyntaxTree(_.handler),finalizer:this._createInternalSyntaxTree(_.finalizer)};break;case"UnaryExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.UnaryExpression,operator:_.operator,argument:this._createInternalSyntaxTree(_.argument)};break;case"UpdateExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.UpdateExpression,operator:_.operator,prefix:_.prefix,argument:this._createInternalSyntaxTree(_.argument)};break;case"VariableDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.VariableDeclaration,declarations:_.declarations.map(this._createInternalSyntaxTree,this),kind:_.kind};break;case"VariableDeclarator":S={type:WebInspector.ScriptSyntaxTree.NodeType.VariableDeclarator,id:this._createInternalSyntaxTree(_.id),init:this._createInternalSyntaxTree(_.init)};break;case"WhileStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.WhileStatement,test:this._createInternalSyntaxTree(_.test),body:this._createInternalSyntaxTree(_.body)};break;case"WithStatement":S={type:WebInspector.ScriptSyntaxTree.NodeType.WithStatement,object:this._createInternalSyntaxTree(_.object),body:this._createInternalSyntaxTree(_.body)};break;case"YieldExpression":S={type:WebInspector.ScriptSyntaxTree.NodeType.YieldExpression,argument:this._createInternalSyntaxTree(_.argument),delegate:_.delegate};break;case"ExportAllDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.ExportAllDeclaration,source:this._createInternalSyntaxTree(_.source)};break;case"ExportNamedDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.ExportNamedDeclaration,declaration:this._createInternalSyntaxTree(_.declaration),specifiers:_.specifiers.map(this._createInternalSyntaxTree,this),source:this._createInternalSyntaxTree(_.source)};break;case"ExportDefaultDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.ExportDefaultDeclaration,declaration:this._createInternalSyntaxTree(_.declaration)};break;case"ExportSpecifier":S={type:WebInspector.ScriptSyntaxTree.NodeType.ExportSpecifier,local:this._createInternalSyntaxTree(_.local),exported:this._createInternalSyntaxTree(_.exported)};break;case"Import":S={type:WebInspector.ScriptSyntaxTree.NodeType.Import};break;case"ImportDeclaration":S={type:WebInspector.ScriptSyntaxTree.NodeType.ImportDeclaration,specifiers:_.specifiers.map(this._createInternalSyntaxTree,this),source:this._createInternalSyntaxTree(_.source)};break;case"ImportDefaultSpecifier":S={type:WebInspector.ScriptSyntaxTree.NodeType.ImportDefaultSpecifier,local:this._createInternalSyntaxTree(_.local)};break;case"ImportNamespaceSpecifier":S={type:WebInspector.ScriptSyntaxTree.NodeType.ImportNamespaceSpecifier,local:this._createInternalSyntaxTree(_.local)};break;case"ImportSpecifier":S={type:WebInspector.ScriptSyntaxTree.NodeType.ImportSpecifier,imported:this._createInternalSyntaxTree(_.imported),local:this._createInternalSyntaxTree(_.local)};break;default:return console.error("Unsupported Syntax Tree Node: "+_.type,_),null;}return S.range=_.range,S.attachments={},S}},WebInspector.ScriptSyntaxTree.TypeProfilerSearchDescriptor={NormalExpression:1,FunctionReturn:2},WebInspector.ScriptSyntaxTree.NodeType={ArrayExpression:Symbol("array-expression"),ArrayPattern:Symbol("array-pattern"),ArrowFunctionExpression:Symbol("arrow-function-expression"),AssignmentExpression:Symbol("assignment-expression"),AssignmentPattern:Symbol("assignment-pattern"),AwaitExpression:Symbol("await-expression"),BinaryExpression:Symbol("binary-expression"),BlockStatement:Symbol("block-statement"),BreakStatement:Symbol("break-statement"),CallExpression:Symbol("call-expression"),CatchClause:Symbol("catch-clause"),ClassBody:Symbol("class-body"),ClassDeclaration:Symbol("class-declaration"),ClassExpression:Symbol("class-expression"),ConditionalExpression:Symbol("conditional-expression"),ContinueStatement:Symbol("continue-statement"),DebuggerStatement:Symbol("debugger-statement"),DoWhileStatement:Symbol("do-while-statement"),EmptyStatement:Symbol("empty-statement"),ExportAllDeclaration:Symbol("export-all-declaration"),ExportDefaultDeclaration:Symbol("export-default-declaration"),ExportNamedDeclaration:Symbol("export-named-declaration"),ExportSpecifier:Symbol("export-specifier"),ExpressionStatement:Symbol("expression-statement"),ForInStatement:Symbol("for-in-statement"),ForOfStatement:Symbol("for-of-statement"),ForStatement:Symbol("for-statement"),FunctionDeclaration:Symbol("function-declaration"),FunctionExpression:Symbol("function-expression"),Identifier:Symbol("identifier"),IfStatement:Symbol("if-statement"),Import:Symbol("import"),ImportDeclaration:Symbol("import-declaration"),ImportDefaultSpecifier:Symbol("import-default-specifier"),ImportNamespaceSpecifier:Symbol("import-namespace-specifier"),ImportSpecifier:Symbol("import-specifier"),LabeledStatement:Symbol("labeled-statement"),Literal:Symbol("literal"),LogicalExpression:Symbol("logical-expression"),MemberExpression:Symbol("member-expression"),MetaProperty:Symbol("meta-property"),MethodDefinition:Symbol("method-definition"),NewExpression:Symbol("new-expression"),ObjectExpression:Symbol("object-expression"),ObjectPattern:Symbol("object-pattern"),Program:Symbol("program"),Property:Symbol("property"),RestElement:Symbol("rest-element"),RestProperty:Symbol("rest-property"),ReturnStatement:Symbol("return-statement"),SequenceExpression:Symbol("sequence-expression"),SpreadElement:Symbol("spread-element"),SpreadProperty:Symbol("spread-property"),Super:Symbol("super"),SwitchCase:Symbol("switch-case"),SwitchStatement:Symbol("switch-statement"),TaggedTemplateExpression:Symbol("tagged-template-expression"),TemplateElement:Symbol("template-element"),TemplateLiteral:Symbol("template-literal"),ThisExpression:Symbol("this-expression"),ThrowStatement:Symbol("throw-statement"),TryStatement:Symbol("try-statement"),UnaryExpression:Symbol("unary-expression"),UpdateExpression:Symbol("update-expression"),VariableDeclaration:Symbol("variable-declaration"),VariableDeclarator:Symbol("variable-declarator"),WhileStatement:Symbol("while-statement"),WithStatement:Symbol("with-statement"),YieldExpression:Symbol("yield-expression")},WebInspector.ScriptTimelineRecord=class extends WebInspector.TimelineRecord{constructor(_,S,C,f,T,E,I){super(WebInspector.TimelineRecord.Type.Script,S,C,f,T),_ in WebInspector.ScriptTimelineRecord.EventType&&(_=WebInspector.ScriptTimelineRecord.EventType[_]),this._eventType=_,this._details=E||"",this._profilePayload=I||null,this._profile=null,this._callCountOrSamples=window.ScriptProfilerAgent?0:NaN}get eventType(){return this._eventType}get details(){return this._details}get profile(){return this._initializeProfileFromPayload(),this._profile}get callCountOrSamples(){return this._callCountOrSamples}isGarbageCollection(){return this._eventType===WebInspector.ScriptTimelineRecord.EventType.GarbageCollected}saveIdentityToCookie(_){super.saveIdentityToCookie(_),_[WebInspector.ScriptTimelineRecord.EventTypeCookieKey]=this._eventType,_[WebInspector.ScriptTimelineRecord.DetailsCookieKey]=this._details}get profilePayload(){return this._profilePayload}set profilePayload(_){this._profilePayload=_}_initializeProfileFromPayload(_){function S(R){if(R.url){var N=WebInspector.frameResourceManager.resourceForURL(R.url);N||(N=WebInspector.debuggerManager.scriptsForURL(R.url,WebInspector.assumingMainTarget())[0]);var L=R.lineNumber-1,D=N?N.createLazySourceCodeLocation(L,R.columnNumber):null}var M="(program)"===R.functionName,P="(anonymous function)"===R.functionName,O=M?WebInspector.ProfileNode.Type.Program:WebInspector.ProfileNode.Type.Function,F=M||P||"(unknown)"===R.functionName?null:R.functionName,V=null;return"calls"in R&&(V=R.calls.map(C)),new WebInspector.ProfileNode(R.id,O,F,D,R.callInfo,V,R.children)}function C(R){var N=WebInspector.timelineManager.computeElapsedTime(R.startTime);return new WebInspector.ProfileNodeCall(N,R.totalTime)}if(!this._profile&&this._profilePayload){var _=this._profilePayload;this._profilePayload=void 0;for(var f=_.rootNodes,T=[{parent:{children:f},index:0,root:!0}],E;T.length;)if(E=T.lastValue,E.index<E.parent.children.length){var I=E.parent.children[E.index];I.children&&I.children.length&&T.push({parent:I,index:0}),++E.index}else E.root?f=f.map(S):E.parent.children=E.parent.children.map(S),T.pop();if(window.ScriptProfilerAgent)for(let R=0;R<f.length;R++)this._callCountOrSamples+=f[R].callInfo.callCount;this._profile=new WebInspector.Profile(f)}}},WebInspector.ScriptTimelineRecord.EventType={ScriptEvaluated:"script-timeline-record-script-evaluated",APIScriptEvaluated:"script-timeline-record-api-script-evaluated",MicrotaskDispatched:"script-timeline-record-microtask-dispatched",EventDispatched:"script-timeline-record-event-dispatched",ProbeSampleRecorded:"script-timeline-record-probe-sample-recorded",TimerFired:"script-timeline-record-timer-fired",TimerInstalled:"script-timeline-record-timer-installed",TimerRemoved:"script-timeline-record-timer-removed",AnimationFrameFired:"script-timeline-record-animation-frame-fired",AnimationFrameRequested:"script-timeline-record-animation-frame-requested",AnimationFrameCanceled:"script-timeline-record-animation-frame-canceled",ConsoleProfileRecorded:"script-timeline-record-console-profile-recorded",GarbageCollected:"script-timeline-record-garbage-collected"},WebInspector.ScriptTimelineRecord.EventType.displayName=function(u,_,S){if(_&&!WebInspector.ScriptTimelineRecord._eventDisplayNames){var C=new Map;C.set("DOMActivate","DOM Activate"),C.set("DOMCharacterDataModified","DOM Character Data Modified"),C.set("DOMContentLoaded","DOM Content Loaded"),C.set("DOMFocusIn","DOM Focus In"),C.set("DOMFocusOut","DOM Focus Out"),C.set("DOMNodeInserted","DOM Node Inserted"),C.set("DOMNodeInsertedIntoDocument","DOM Node Inserted Into Document"),C.set("DOMNodeRemoved","DOM Node Removed"),C.set("DOMNodeRemovedFromDocument","DOM Node Removed From Document"),C.set("DOMSubtreeModified","DOM Sub-Tree Modified"),C.set("addsourcebuffer","Add Source Buffer"),C.set("addstream","Add Stream"),C.set("addtrack","Add Track"),C.set("animationend","Animation End"),C.set("animationiteration","Animation Iteration"),C.set("animationstart","Animation Start"),C.set("audioend","Audio End"),C.set("audioprocess","Audio Process"),C.set("audiostart","Audio Start"),C.set("beforecopy","Before Copy"),C.set("beforecut","Before Cut"),C.set("beforeload","Before Load"),C.set("beforepaste","Before Paste"),C.set("beforeunload","Before Unload"),C.set("canplay","Can Play"),C.set("canplaythrough","Can Play Through"),C.set("chargingchange","Charging Change"),C.set("chargingtimechange","Charging Time Change"),C.set("compositionend","Composition End"),C.set("compositionstart","Composition Start"),C.set("compositionupdate","Composition Update"),C.set("contextmenu","Context Menu"),C.set("cuechange","Cue Change"),C.set("datachannel","Data Channel"),C.set("dblclick","Double Click"),C.set("devicemotion","Device Motion"),C.set("deviceorientation","Device Orientation"),C.set("dischargingtimechange","Discharging Time Change"),C.set("dragend","Drag End"),C.set("dragenter","Drag Enter"),C.set("dragleave","Drag Leave"),C.set("dragover","Drag Over"),C.set("dragstart","Drag Start"),C.set("durationchange","Duration Change"),C.set("focusin","Focus In"),C.set("focusout","Focus Out"),C.set("gesturechange","Gesture Change"),C.set("gestureend","Gesture End"),C.set("gesturescrollend","Gesture Scroll End"),C.set("gesturescrollstart","Gesture Scroll Start"),C.set("gesturescrollupdate","Gesture Scroll Update"),C.set("gesturestart","Gesture Start"),C.set("gesturetap","Gesture Tap"),C.set("gesturetapdown","Gesture Tap Down"),C.set("hashchange","Hash Change"),C.set("icecandidate","ICE Candidate"),C.set("iceconnectionstatechange","ICE Connection State Change"),C.set("keydown","Key Down"),C.set("keypress","Key Press"),C.set("keyup","Key Up"),C.set("levelchange","Level Change"),C.set("loadeddata","Loaded Data"),C.set("loadedmetadata","Loaded Metadata"),C.set("loadend","Load End"),C.set("loadingdone","Loading Done"),C.set("loadstart","Load Start"),C.set("mousedown","Mouse Down"),C.set("mouseenter","Mouse Enter"),C.set("mouseleave","Mouse Leave"),C.set("mousemove","Mouse Move"),C.set("mouseout","Mouse Out"),C.set("mouseover","Mouse Over"),C.set("mouseup","Mouse Up"),C.set("mousewheel","Mouse Wheel"),C.set("negotiationneeded","Negotiation Needed"),C.set("nomatch","No Match"),C.set("noupdate","No Update"),C.set("orientationchange","Orientation Change"),C.set("overflowchanged","Overflow Changed"),C.set("pagehide","Page Hide"),C.set("pageshow","Page Show"),C.set("popstate","Pop State"),C.set("ratechange","Rate Change"),C.set("readystatechange","Ready State Change"),C.set("removesourcebuffer","Remove Source Buffer"),C.set("removestream","Remove Stream"),C.set("removetrack","Remove Track"),C.set("resize","Resize"),C.set("securitypolicyviolation","Security Policy Violation"),C.set("selectionchange","Selection Change"),C.set("selectstart","Select Start"),C.set("signalingstatechange","Signaling State Change"),C.set("soundend","Sound End"),C.set("soundstart","Sound Start"),C.set("sourceclose","Source Close"),C.set("sourceended","Source Ended"),C.set("sourceopen","Source Open"),C.set("speechend","Speech End"),C.set("speechstart","Speech Start"),C.set("textInput","Text Input"),C.set("timeupdate","Time Update"),C.set("tonechange","Tone Change"),C.set("touchcancel","Touch Cancel"),C.set("touchend","Touch End"),C.set("touchmove","Touch Move"),C.set("touchstart","Touch Start"),C.set("transitionend","Transition End"),C.set("updateend","Update End"),C.set("updateready","Update Ready"),C.set("updatestart","Update Start"),C.set("upgradeneeded","Upgrade Needed"),C.set("versionchange","Version Change"),C.set("visibilitychange","Visibility Change"),C.set("volumechange","Volume Change"),C.set("webglcontextcreationerror","WebGL Context Creation Error"),C.set("webglcontextlost","WebGL Context Lost"),C.set("webglcontextrestored","WebGL Context Restored"),C.set("webkitAnimationEnd","Animation End"),C.set("webkitAnimationIteration","Animation Iteration"),C.set("webkitAnimationStart","Animation Start"),C.set("webkitBeforeTextInserted","Before Text Inserted"),C.set("webkitEditableContentChanged","Editable Content Changed"),C.set("webkitTransitionEnd","Transition End"),C.set("webkitaddsourcebuffer","Add Source Buffer"),C.set("webkitbeginfullscreen","Begin Full Screen"),C.set("webkitcurrentplaybacktargetiswirelesschanged","Current Playback Target Is Wireless Changed"),C.set("webkitdeviceproximity","Device Proximity"),C.set("webkitendfullscreen","End Full Screen"),C.set("webkitfullscreenchange","Full Screen Change"),C.set("webkitfullscreenerror","Full Screen Error"),C.set("webkitkeyadded","Key Added"),C.set("webkitkeyerror","Key Error"),C.set("webkitkeymessage","Key Message"),C.set("webkitneedkey","Need Key"),C.set("webkitnetworkinfochange","Network Info Change"),C.set("webkitplaybacktargetavailabilitychanged","Playback Target Availability Changed"),C.set("webkitpointerlockchange","Pointer Lock Change"),C.set("webkitpointerlockerror","Pointer Lock Error"),C.set("webkitregionlayoutupdate","Region Layout Update"),C.set("webkitregionoversetchange","Region Overset Change"),C.set("webkitremovesourcebuffer","Remove Source Buffer"),C.set("webkitresourcetimingbufferfull","Resource Timing Buffer Full"),C.set("webkitsourceclose","Source Close"),C.set("webkitsourceended","Source Ended"),C.set("webkitsourceopen","Source Open"),C.set("webkitspeechchange","Speech Change"),C.set("writeend","Write End"),C.set("writestart","Write Start"),WebInspector.ScriptTimelineRecord._eventDisplayNames=C}switch(u){case WebInspector.ScriptTimelineRecord.EventType.ScriptEvaluated:case WebInspector.ScriptTimelineRecord.EventType.APIScriptEvaluated:return WebInspector.UIString("Script Evaluated");case WebInspector.ScriptTimelineRecord.EventType.MicrotaskDispatched:return WebInspector.UIString("Microtask Dispatched");case WebInspector.ScriptTimelineRecord.EventType.EventDispatched:if(_&&(_ instanceof String||"string"==typeof _)){var f=WebInspector.ScriptTimelineRecord._eventDisplayNames.get(_)||_.capitalize();return WebInspector.UIString("%s Event Dispatched").format(f)}return WebInspector.UIString("Event Dispatched");case WebInspector.ScriptTimelineRecord.EventType.ProbeSampleRecorded:return WebInspector.UIString("Probe Sample Recorded");case WebInspector.ScriptTimelineRecord.EventType.ConsoleProfileRecorded:return _&&(_ instanceof String||"string"==typeof _)?WebInspector.UIString("\u201C%s\u201D Profile Recorded").format(_):WebInspector.UIString("Console Profile Recorded");case WebInspector.ScriptTimelineRecord.EventType.GarbageCollected:if(_&&_ instanceof WebInspector.GarbageCollection&&S)switch(_.type){case WebInspector.GarbageCollection.Type.Partial:return WebInspector.UIString("Partial Garbage Collection");case WebInspector.GarbageCollection.Type.Full:return WebInspector.UIString("Full Garbage Collection");}return WebInspector.UIString("Garbage Collection");case WebInspector.ScriptTimelineRecord.EventType.TimerFired:return _&&S?WebInspector.UIString("Timer %d Fired").format(_):WebInspector.UIString("Timer Fired");case WebInspector.ScriptTimelineRecord.EventType.TimerInstalled:return _&&S?WebInspector.UIString("Timer %d Installed").format(_.timerId):WebInspector.UIString("Timer Installed");case WebInspector.ScriptTimelineRecord.EventType.TimerRemoved:return _&&S?WebInspector.UIString("Timer %d Removed").format(_):WebInspector.UIString("Timer Removed");case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameFired:return _&&S?WebInspector.UIString("Animation Frame %d Fired").format(_):WebInspector.UIString("Animation Frame Fired");case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameRequested:return _&&S?WebInspector.UIString("Animation Frame %d Requested").format(_):WebInspector.UIString("Animation Frame Requested");case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameCanceled:return _&&S?WebInspector.UIString("Animation Frame %d Canceled").format(_):WebInspector.UIString("Animation Frame Canceled");}},WebInspector.ScriptTimelineRecord.TypeIdentifier="script-timeline-record",WebInspector.ScriptTimelineRecord.EventTypeCookieKey="script-timeline-record-event-type",WebInspector.ScriptTimelineRecord.DetailsCookieKey="script-timeline-record-details",WebInspector.SourceCodePosition=class extends WebInspector.Object{constructor(_,S){super(),this._lineNumber=_||0,this._columnNumber=S||0}get lineNumber(){return this._lineNumber}get columnNumber(){return this._columnNumber}},WebInspector.SourceCodeRevision=class extends WebInspector.Revision{constructor(_,S){super(),this._sourceCode=_,this._content=S||""}get sourceCode(){return this._sourceCode}get content(){return this._content}set content(_){_=_||"";this._content===_||(this._content=_,this._sourceCode.revisionContentDidChange(this))}apply(){this._sourceCode.currentRevision=this}revert(){this._sourceCode.currentRevision=this._sourceCode.originalRevision}copy(){return new WebInspector.SourceCodeRevision(this._sourceCode,this._content)}},WebInspector.SourceCodeSearchMatchObject=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._sourceCode=_,this._lineText=S,this._searchTerm=C,this._sourceCodeTextRange=_.createSourceCodeTextRange(f)}get sourceCode(){return this._sourceCode}get title(){return this._lineText}get searchTerm(){return this._searchTerm}get sourceCodeTextRange(){return this._sourceCodeTextRange}get className(){return"source-code-match"}saveIdentityToCookie(_){this._sourceCode.url&&(_[WebInspector.SourceCodeSearchMatchObject.URLCookieKey]=this._sourceCode.url.hash);var S=this._sourceCodeTextRange.textRange;_[WebInspector.SourceCodeSearchMatchObject.TextRangeKey]=[S.startLine,S.startColumn,S.endLine,S.endColumn].join()}},WebInspector.SourceCodeSearchMatchObject.TypeIdentifier="source-code-search-match-object",WebInspector.SourceCodeSearchMatchObject.URLCookieKey="source-code-url",WebInspector.SourceCodeSearchMatchObject.TextRangeKey="text-range",WebInspector.SourceCodeTextRange=class extends WebInspector.Object{constructor(_){if(super(),this._sourceCode=_,2===arguments.length){var S=arguments[1];this._startLocation=_.createSourceCodeLocation(S.startLine,S.startColumn),this._endLocation=_.createSourceCodeLocation(S.endLine,S.endColumn)}else this._startLocation=arguments[1],this._endLocation=arguments[2];this._startLocation.addEventListener(WebInspector.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationChanged,this),this._endLocation.addEventListener(WebInspector.SourceCodeLocation.Event.LocationChanged,this._sourceCodeLocationChanged,this)}get sourceCode(){return this._sourceCode}get textRange(){var _=this._startLocation.lineNumber,S=this._startLocation.columnNumber,C=this._endLocation.lineNumber,f=this._endLocation.columnNumber;return new WebInspector.TextRange(_,S,C,f)}get formattedTextRange(){var _=this._startLocation.formattedLineNumber,S=this._startLocation.formattedColumnNumber,C=this._endLocation.formattedLineNumber,f=this._endLocation.formattedColumnNumber;return new WebInspector.TextRange(_,S,C,f)}get displaySourceCode(){return this._startAndEndLocationsInSameMappedResource()?this._startLocation.displaySourceCode:this._sourceCode}get displayTextRange(){if(!this._startAndEndLocationsInSameMappedResource())return this.formattedTextRange;var _=this._startLocation.displayLineNumber,S=this._startLocation.displayColumnNumber,C=this._endLocation.displayLineNumber,f=this._endLocation.displayColumnNumber;return new WebInspector.TextRange(_,S,C,f)}get synthesizedTextValue(){return this._sourceCode.url+":"+(this._startLocation.lineNumber+1)}_startAndEndLocationsInSameMappedResource(){return this._startLocation.hasMappedLocation()&&this._endLocation.hasMappedLocation()&&this._startLocation.displaySourceCode===this._endLocation.displaySourceCode}_sourceCodeLocationChanged(){this.dispatchEventToListeners(WebInspector.SourceCodeLocation.Event.RangeChanged)}},WebInspector.SourceCodeTextRange.Event={RangeChanged:"source-code-text-range-range-changed"},WebInspector.SourceCodeTimeline=class extends WebInspector.Timeline{constructor(_,S,C,f){super(),this._sourceCode=_,this._sourceCodeLocation=S||null,this._recordType=C,this._recordEventType=f||null}get sourceCode(){return this._sourceCode}get sourceCodeLocation(){return this._sourceCodeLocation}get recordType(){return this._recordType}get recordEventType(){return this._recordEventType}saveIdentityToCookie(_){_[WebInspector.SourceCodeTimeline.SourceCodeURLCookieKey]=this._sourceCode.url?this._sourceCode.url.hash:null,_[WebInspector.SourceCodeTimeline.SourceCodeLocationLineCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.lineNumber:null,_[WebInspector.SourceCodeTimeline.SourceCodeLocationColumnCookieKey]=this._sourceCodeLocation?this._sourceCodeLocation.columnNumber:null,_[WebInspector.SourceCodeTimeline.RecordTypeCookieKey]=this._recordType||null,_[WebInspector.SourceCodeTimeline.RecordEventTypeCookieKey]=this._recordEventType||null}},WebInspector.SourceCodeTimeline.TypeIdentifier="source-code-timeline",WebInspector.SourceCodeTimeline.SourceCodeURLCookieKey="source-code-timeline-source-code-url",WebInspector.SourceCodeTimeline.SourceCodeLocationLineCookieKey="source-code-timeline-source-code-location-line",WebInspector.SourceCodeTimeline.SourceCodeLocationColumnCookieKey="source-code-timeline-source-code-location-column",WebInspector.SourceCodeTimeline.SourceCodeURLCookieKey="source-code-timeline-source-code-url",WebInspector.SourceCodeTimeline.RecordTypeCookieKey="source-code-timeline-record-type",WebInspector.SourceCodeTimeline.RecordEventTypeCookieKey="source-code-timeline-record-event-type",WebInspector.SourceMap=class extends WebInspector.Object{constructor(_,S,C){if(super(),!WebInspector.SourceMap._base64Map){var f="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";WebInspector.SourceMap._base64Map={};for(var T=0;T<f.length;++T)WebInspector.SourceMap._base64Map[f.charAt(T)]=T}this._originalSourceCode=C||null,this._sourceMapResources={},this._sourceMapResourcesList=[],this._sourceMappingURL=_,this._reverseMappingsBySourceURL={},this._mappings=[],this._sources={},this._sourceRoot=null,this._sourceContentByURL={},this._parseMappingPayload(S)}get originalSourceCode(){return this._originalSourceCode}get sourceMappingBasePathURLComponents(){if(this._sourceMappingURLBasePathComponents)return this._sourceMappingURLBasePathComponents;if(this._sourceRoot){var _=absoluteURL(this._sourceRoot,this._sourceMappingURL);if(_){var S=parseURL(_);return /\/$/.test(S.path)||(S.path+="/"),this._sourceMappingURLBasePathComponents=S,this._sourceMappingURLBasePathComponents}}var S=parseURL(this._sourceMappingURL);return S.path||(S.path=this._sourceMappingURL||""),S.path=S.path.substr(0,S.path.lastIndexOf(S.lastPathComponent)),S.lastPathComponent=null,this._sourceMappingURLBasePathComponents=S,this._sourceMappingURLBasePathComponents}get resources(){return this._sourceMapResourcesList}addResource(_){this._sourceMapResources[_.url]=_,this._sourceMapResourcesList.push(_)}resourceForURL(_){return this._sourceMapResources[_]}sources(){return Object.keys(this._sources)}sourceContent(_){return this._sourceContentByURL[_]}_parseMappingPayload(_){_.sections?this._parseSections(_.sections):this._parseMap(_,0,0)}_parseSections(_){for(var S=0,C;S<_.length;++S)C=_[S],this._parseMap(C.map,C.offset.line,C.offset.column)}findEntry(_,S){for(var C=0,f=this._mappings.length;1<f;){var T=f>>1,E=C+T,I=this._mappings[E];_<I[0]||_===I[0]&&S<I[1]?f=T:(C=E,f-=T)}var R=this._mappings[C];return!C&&R&&(_<R[0]||_===R[0]&&S<R[1])?null:R}findEntryReversed(_,S){for(var C=this._reverseMappingsBySourceURL[_],f;S<C.length;++S)if(f=C[S],f)return f;return this._mappings[0]}_parseMap(_,S,C){for(var f=0,T=0,E=0,I=0,R=[],N={},L=0;L<_.sources.length;++L){var D=_.sources[L],M=D;_.sourceRoot&&"/"!==M.charAt(0)&&(M=_.sourceRoot.replace(/\/+$/,"")+"/"+M);var P=absoluteURL(M,this._sourceMappingURL)||M;N[D]=P,R.push(P),this._sources[P]=!0,_.sourcesContent&&_.sourcesContent[L]&&(this._sourceContentByURL[P]=_.sourcesContent[L])}this._sourceRoot=_.sourceRoot||null;for(var O=new WebInspector.SourceMap.StringCharIterator(_.mappings),F=R[f];;){if(","===O.peek())O.next();else{for(;";"===O.peek();)S+=1,C=0,O.next();if(!O.hasNext())break}if(C+=this._decodeVLQ(O),this._isSeparator(O.peek())){this._mappings.push([S,C]);continue}var V=this._decodeVLQ(O);V&&(f+=V,F=R[f]),T+=this._decodeVLQ(O),E+=this._decodeVLQ(O),this._isSeparator(O.peek())||(I+=this._decodeVLQ(O)),this._mappings.push([S,C,F,T,E])}for(var L=0;L<this._mappings.length;++L){var U=this._mappings[L],P=U[2];if(P){this._reverseMappingsBySourceURL[P]||(this._reverseMappingsBySourceURL[P]=[]);var G=this._reverseMappingsBySourceURL[P],H=U[3];G[H]||(G[H]=[U[0],U[1]])}}}_isSeparator(_){return","===_||";"===_}_decodeVLQ(_){var S=0,C=0;do{var f=WebInspector.SourceMap._base64Map[_.next()];S+=(f&WebInspector.SourceMap.VLQ_BASE_MASK)<<C,C+=WebInspector.SourceMap.VLQ_BASE_SHIFT}while(f&WebInspector.SourceMap.VLQ_CONTINUATION_MASK);var T=1&S;return S>>=1,T?-S:S}},WebInspector.SourceMap.VLQ_BASE_SHIFT=5,WebInspector.SourceMap.VLQ_BASE_MASK=31,WebInspector.SourceMap.VLQ_CONTINUATION_MASK=32,WebInspector.SourceMap.StringCharIterator=class{constructor(_){this._string=_,this._position=0}next(){return this._string.charAt(this._position++)}peek(){return this._string.charAt(this._position)}hasNext(){return this._position<this._string.length}},WebInspector.SourceMapResource=class extends WebInspector.Resource{constructor(_,S){super(_,null),this._sourceMap=S;var C=this._sourceMap.originalSourceCode instanceof WebInspector.Resource?this._sourceMap.originalSourceCode.syntheticMIMEType:null,f=WebInspector.fileExtensionForURL(_),T=WebInspector.mimeTypeForFileExtension(f,!0);this._mimeType=T||C||"text/javascript",this._type=WebInspector.Resource.typeFromMIMEType(this._mimeType),this.markAsFinished()}get sourceMap(){return this._sourceMap}get sourceMapDisplaySubpath(){var _=this._sourceMap.sourceMappingBasePathURLComponents,S=this.urlComponents;return S.path||(S.path=this.url),S.scheme!==_.scheme||S.host!==_.host?S.host+(S.port?":"+S.port:"")+S.path:S.path.startsWith(_.path)?S.path.substring(_.path.length,S.length):relativePath(S.path,_.path)}requestContentFromBackend(){function S(I,R,N,L){return this.markAsFailed(),Promise.resolve({error:WebInspector.UIString("An error occurred trying to load the resource."),content:R,mimeType:N,statusCode:L})}function C(I){return console.error(I||"There was an unknown error calling NetworkAgent.loadResource."),this.markAsFailed(),Promise.resolve({error:WebInspector.UIString("An error occurred trying to load the resource.")})}function f(I){var{error:R,content:N,mimeType:L,statusCode:D}=I;return 400<=D||R?S(R,N,L,D):(this.markAsFinished(),Promise.resolve({content:N,mimeType:L,base64encoded:!1,statusCode:D}))}this.revertMarkAsFinished();var T=this._sourceMap.sourceContent(this.url);if(T)return f.call(this,{content:T,mimeType:this.mimeType,statusCode:200});if(!window.NetworkAgent||!NetworkAgent.loadResource)return C.call(this);var E=null;return this._sourceMap.originalSourceCode instanceof WebInspector.Resource&&this._sourceMap.originalSourceCode.parentFrame&&(E=this._sourceMap.originalSourceCode.parentFrame.id),E||(E=WebInspector.frameResourceManager.mainFrame.id),NetworkAgent.loadResource(E,this.url).then(f.bind(this)).catch(C.bind(this))}createSourceCodeLocation(_,S){var C=this._sourceMap.findEntryReversed(this.url,_),f=C[0],T=C[1],E=this._sourceMap.originalSourceCode;E instanceof WebInspector.Script&&(0===f&&(T+=E.range.startColumn),f+=E.range.startLine);var I=E.createSourceCodeLocation(f,T);return I._setMappedLocation(this,_,S),I}createSourceCodeTextRange(_){var S=this.createSourceCodeLocation(_.startLine,_.startColumn),C=this.createSourceCodeLocation(_.endLine,_.endColumn);return new WebInspector.SourceCodeTextRange(this._sourceMap.originalSourceCode,S,C)}},WebInspector.StackTrace=class extends WebInspector.Object{constructor(_,S,C,f){super(),this._callFrames=_,this._topCallFrameIsBoundary=S||!1,this._truncated=C||!1,this._parentStackTrace=f||null}static fromPayload(_,S){let C=null,f=null;for(;S;){let T=S.callFrames.map(I=>WebInspector.CallFrame.fromPayload(_,I)),E=new WebInspector.StackTrace(T,S.topCallFrameIsBoundary,S.truncated);C||(C=E),f&&(f._parentStackTrace=E),f=E,S=S.parentStackTrace}return C}static fromString(_,S){let C=WebInspector.StackTrace._parseStackTrace(S);return WebInspector.StackTrace.fromPayload(_,{callFrames:C})}static isLikelyStackTrace(_){const S="http://a.bc/:9:1".length;if(_.length<2*S.length)return!1;if(_.length>5e3)return!1;if(/^[^a-z$_]/i.test(_[0]))return!1;const E=`(.{1,${500}}:\\d+:\\d+|eval code|.{1,${120}}@\\[native code\\])`,I=/^(.{1,500}:\d+:\d+|eval code|.{1,120}@\[native code\])(\n(.{1,500}:\d+:\d+|eval code|.{1,120}@\[native code\]))*$/g;return I.test(_)}static _parseStackTrace(_){var S=_.split(/\n/g),C=[];for(var f of S){var T="",I=0,R=0,N=f.indexOf("@");-1===N?f.includes("/")?({url:R,lineNumber:I,columnNumber:R}=WebInspector.StackTrace._parseLocation(f)):T=f:(T=f.slice(0,N),({url:R,lineNumber:I,columnNumber:R}=WebInspector.StackTrace._parseLocation(f.slice(N+1)))),C.push({functionName:T,url:"",lineNumber:I,columnNumber:R})}return C}static _parseLocation(_){var S={url:"",lineNumber:0,columnNumber:0},C=/(.+?)(?::(\d+)(?::(\d+))?)?$/,f=_.match(C);return f?(S.url=f[1],f[2]&&(S.lineNumber=parseInt(f[2])),f[3]&&(S.columnNumber=parseInt(f[3])),S):S}get callFrames(){return this._callFrames}get firstNonNativeCallFrame(){for(let _ of this._callFrames)if(!_.nativeCode)return _;return null}get firstNonNativeNonAnonymousCallFrame(){for(let _ of this._callFrames)if(!_.nativeCode){if(_.sourceCodeLocation){let G=_.sourceCodeLocation.sourceCode;if(G instanceof WebInspector.Script&&G.anonymous)continue}return _}return null}get topCallFrameIsBoundary(){return this._topCallFrameIsBoundary}get truncated(){return this._truncated}get parentStackTrace(){return this._parentStackTrace}},WebInspector.StructureDescription=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._fields=_||null,this._optionalFields=S||null,this._constructorName=C||"",this._prototypeStructure=f||null,this._imprecise=T||!1}static fromPayload(_){return _.prototypeStructure&&(_.prototypeStructure=WebInspector.StructureDescription.fromPayload(_.prototypeStructure)),new WebInspector.StructureDescription(_.fields,_.optionalFields,_.constructorName,_.prototypeStructure,_.imprecise)}get fields(){return this._fields}get optionalFields(){return this._optionalFields}get constructorName(){return this._constructorName}get prototypeStructure(){return this._prototypeStructure}get imprecise(){return this._imprecise}},WebInspector.TextMarker=class extends WebInspector.Object{constructor(_,S){super(),this._codeMirrorTextMarker=_,_.__webInspectorTextMarker=this,this._type=S||WebInspector.TextMarker.Type.Plain}static textMarkerForCodeMirrorTextMarker(_){return _.__webInspectorTextMarker||new WebInspector.TextMarker(_)}get codeMirrorTextMarker(){return this._codeMirrorTextMarker}get type(){return this._type}get range(){var _=this._codeMirrorTextMarker.find();return _?new WebInspector.TextRange(_.from.line,_.from.ch,_.to.line,_.to.ch):null}get rects(){var _=this._codeMirrorTextMarker.find();return _?this._codeMirrorTextMarker.doc.cm.rectsForRange({start:_.from,end:_.to}):WebInspector.Rect.ZERO_RECT}clear(){this._codeMirrorTextMarker.clear()}},WebInspector.TextMarker.Type={Color:"text-marker-type-color",Gradient:"text-marker-type-gradient",Plain:"text-marker-type-plain",CubicBezier:"text-marker-type-cubic-bezier",Spring:"text-marker-type-spring",Variable:"text-marker-type-variable"},WebInspector.TextRange=class extends WebInspector.Object{constructor(_,S,C,f){super(),4===arguments.length?(this._startLine="number"==typeof _?_:NaN,this._startColumn="number"==typeof S?S:NaN,this._endLine="number"==typeof C?C:NaN,this._endColumn="number"==typeof f?f:NaN,this._startOffset=NaN,this._endOffset=NaN):2===arguments.length&&(this._startOffset="number"==typeof _?_:NaN,this._endOffset="number"==typeof S?S:NaN,this._startLine=NaN,this._startColumn=NaN,this._endLine=NaN,this._endColumn=NaN)}get startLine(){return this._startLine}get startColumn(){return this._startColumn}get endLine(){return this._endLine}get endColumn(){return this._endColumn}get startOffset(){return this._startOffset}get endOffset(){return this._endOffset}startPosition(){return new WebInspector.SourceCodePosition(this._startLine,this._startColumn)}endPosition(){return new WebInspector.SourceCodePosition(this._endLine,this._endColumn)}resolveOffsets(_){if("string"==typeof _&&!(isNaN(this._startLine)||isNaN(this._startColumn)||isNaN(this._endLine)||isNaN(this._endColumn))){for(var S=0,C=0;C<this._startLine;++C)S=_.indexOf("\n",S)+1;this._startOffset=S+this._startColumn;for(var C=this._startLine;C<this._endLine;++C)S=_.indexOf("\n",S)+1;this._endOffset=S+this._endColumn}}contains(_,S){return _<this._startLine||_>this._endLine?!1:_===this._startLine&&S<this._startColumn?!1:_===this._endLine&&S>this._endColumn?!1:!0}},WebInspector.TimelineMarker=class extends WebInspector.Object{constructor(_,S,C){super(),this._time=_||0,this._type=S,this._details=C||null}get time(){return this._time}set time(_){_=_||0;this._time===_||(this._time=_,this.dispatchEventToListeners(WebInspector.TimelineMarker.Event.TimeChanged))}get type(){return this._type}get details(){return this._details}},WebInspector.TimelineMarker.Event={TimeChanged:"timeline-marker-time-changed"},WebInspector.TimelineMarker.Type={CurrentTime:"current-time",LoadEvent:"load-event",DOMContentEvent:"dom-content-event",TimeStamp:"timestamp"},WebInspector.TimelineRecording=class extends WebInspector.Object{constructor(_,S,C){super(),this._identifier=_,this._timelines=new Map,this._displayName=S,this._capturing=!1,this._readonly=!1,this._instruments=C||[],this._topDownCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.TopDown),this._bottomUpCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.BottomUp),this._topFunctionsTopDownCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.TopFunctionsTopDown),this._topFunctionsBottomUpCallingContextTree=new WebInspector.CallingContextTree(WebInspector.CallingContextTree.Type.TopFunctionsBottomUp);for(let f of WebInspector.TimelineManager.availableTimelineTypes()){let T=WebInspector.Timeline.create(f);this._timelines.set(f,T),T.addEventListener(WebInspector.Timeline.Event.TimesUpdated,this._timelineTimesUpdated,this)}this._legacyFirstRecordedTimestamp=NaN,this.reset(!0)}static sourceCodeTimelinesSupported(){return WebInspector.debuggableType===WebInspector.DebuggableType.Web}get displayName(){return this._displayName}get identifier(){return this._identifier}get timelines(){return this._timelines}get instruments(){return this._instruments}get readonly(){return this._readonly}get startTime(){return this._startTime}get endTime(){return this._endTime}get topDownCallingContextTree(){return this._topDownCallingContextTree}get bottomUpCallingContextTree(){return this._bottomUpCallingContextTree}get topFunctionsTopDownCallingContextTree(){return this._topFunctionsTopDownCallingContextTree}get topFunctionsBottomUpCallingContextTree(){return this._topFunctionsBottomUpCallingContextTree}start(_){this._capturing=!0;for(let S of this._instruments)S.startInstrumentation(_)}stop(_){this._capturing=!1;for(let S of this._instruments)S.stopInstrumentation(_)}saveIdentityToCookie(){}isEmpty(){for(var _ of this._timelines.values())if(_.records.length)return!1;return!0}unloaded(){this._readonly=!0,this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.Unloaded)}reset(_){this._sourceCodeTimelinesMap=new Map,this._eventMarkers=[],this._startTime=NaN,this._endTime=NaN,this._discontinuities=[],this._topDownCallingContextTree.reset(),this._bottomUpCallingContextTree.reset(),this._topFunctionsTopDownCallingContextTree.reset(),this._topFunctionsBottomUpCallingContextTree.reset();for(var S of this._timelines.values())S.reset(_);WebInspector.RenderingFrameTimelineRecord.resetFrameIndex(),_||(this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.Reset),this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.TimesUpdated))}sourceCodeTimelinesForSourceCode(_){var S=this._sourceCodeTimelinesMap.get(_);return S?[...S.values()]:[]}timelineForInstrument(_){return this._timelines.get(_.timelineRecordType)}instrumentForTimeline(_){return this._instruments.find(S=>S.timelineRecordType===_.type)}timelineForRecordType(_){return this._timelines.get(_)}addInstrument(_){this._instruments.push(_),this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.InstrumentAdded,{instrument:_})}removeInstrument(_){this._instruments.remove(_),this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.InstrumentRemoved,{instrument:_})}addEventMarker(_){this._capturing&&(this._eventMarkers.push(_),this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.MarkerAdded,{marker:_}))}addRecord(_){var S=this._timelines.get(_.type);if(S&&(S.addRecord(_),_.type!==WebInspector.TimelineRecord.Type.Network&&_.type!==WebInspector.TimelineRecord.Type.RenderingFrame&&_.type!==WebInspector.TimelineRecord.Type.Memory&&_.type!==WebInspector.TimelineRecord.Type.HeapAllocations)&&WebInspector.TimelineRecording.sourceCodeTimelinesSupported()){var C=WebInspector.frameResourceManager.mainFrame.provisionalMainResource||WebInspector.frameResourceManager.mainFrame.mainResource,f=_.sourceCodeLocation?_.sourceCodeLocation.sourceCode:C,T=this._sourceCodeTimelinesMap.get(f);T||(T=new Map,this._sourceCodeTimelinesMap.set(f,T));var E=!1,I=this._keyForRecord(_),R=T.get(I);R||(R=new WebInspector.SourceCodeTimeline(f,_.sourceCodeLocation,_.type,_.eventType),T.set(I,R),E=!0),R.addRecord(_),E&&this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.SourceCodeTimelineAdded,{sourceCodeTimeline:R})}}addMemoryPressureEvent(_){let S=this._timelines.get(WebInspector.TimelineRecord.Type.Memory);S&&S.addMemoryPressureEvent(_)}addDiscontinuity(_,S){this._discontinuities.push({startTime:_,endTime:S})}discontinuitiesInTimeRange(_,S){return this._discontinuities.filter(C=>C.startTime<S&&C.endTime>_)}addScriptInstrumentForProgrammaticCapture(){for(let S of this._instruments)if(S instanceof WebInspector.ScriptInstrument)return;this.addInstrument(new WebInspector.ScriptInstrument);let _=this._instruments.map(S=>S.timelineRecordType);WebInspector.timelineManager.enabledTimelineTypes=_}computeElapsedTime(_){return!_||isNaN(_)?NaN:(void 0===WebInspector.TimelineRecording.isLegacy&&(WebInspector.TimelineRecording.isLegacy=_>WebInspector.TimelineRecording.TimestampThresholdForLegacyRecordConversion),!WebInspector.TimelineRecording.isLegacy)?_:(_<WebInspector.TimelineRecording.TimestampThresholdForLegacyAssumedMilliseconds&&(_*=1e3),isNaN(this._legacyFirstRecordedTimestamp)&&(this._legacyFirstRecordedTimestamp=_),(_-this._legacyFirstRecordedTimestamp)/1e3)}setLegacyBaseTimestamp(_){_<WebInspector.TimelineRecording.TimestampThresholdForLegacyAssumedMilliseconds&&(_*=1e3),this._legacyFirstRecordedTimestamp=_}initializeTimeBoundsIfNecessary(_){isNaN(this._startTime)&&(this._startTime=_,this._endTime=_,this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.TimesUpdated))}_keyForRecord(_){var S=_.type;return(_ instanceof WebInspector.ScriptTimelineRecord||_ instanceof WebInspector.LayoutTimelineRecord)&&(S+=":"+_.eventType),_ instanceof WebInspector.ScriptTimelineRecord&&_.eventType===WebInspector.ScriptTimelineRecord.EventType.EventDispatched&&(S+=":"+_.details),_.sourceCodeLocation&&(S+=":"+_.sourceCodeLocation.lineNumber+":"+_.sourceCodeLocation.columnNumber),S}_timelineTimesUpdated(_){var S=_.target,C=!1;(isNaN(this._startTime)||S.startTime<this._startTime)&&(this._startTime=S.startTime,C=!0),(isNaN(this._endTime)||this._endTime<S.endTime)&&(this._endTime=S.endTime,C=!0),C&&this.dispatchEventToListeners(WebInspector.TimelineRecording.Event.TimesUpdated)}},WebInspector.TimelineRecording.Event={Reset:"timeline-recording-reset",Unloaded:"timeline-recording-unloaded",SourceCodeTimelineAdded:"timeline-recording-source-code-timeline-added",InstrumentAdded:"timeline-recording-instrument-added",InstrumentRemoved:"timeline-recording-instrument-removed",TimesUpdated:"timeline-recording-times-updated",MarkerAdded:"timeline-recording-marker-added"},WebInspector.TimelineRecording.isLegacy=void 0,WebInspector.TimelineRecording.TimestampThresholdForLegacyRecordConversion=1e7,WebInspector.TimelineRecording.TimestampThresholdForLegacyAssumedMilliseconds=1.4200992e12,WebInspector.TypeDescription=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._leastCommonAncestor=_||null,this._typeSet=S||null,this._structures=C||null,this._valid=f||!1,this._truncated=T||!1}static fromPayload(_){var S;_.typeSet&&(S=WebInspector.TypeSet.fromPayload(_.typeSet));var C;return _.structures&&(C=_.structures.map(WebInspector.StructureDescription.fromPayload)),new WebInspector.TypeDescription(_.leastCommonAncestor,S,C,_.isValid,_.isTruncated)}get leastCommonAncestor(){return this._leastCommonAncestor}get typeSet(){return this._typeSet}get structures(){return this._structures}get valid(){return this._valid}get truncated(){return this._truncated}},WebInspector.TypeSet=class extends WebInspector.Object{constructor(_){super();var S=0;_.isFunction&&(S|=WebInspector.TypeSet.TypeBit.Function),_.isUndefined&&(S|=WebInspector.TypeSet.TypeBit.Undefined),_.isNull&&(S|=WebInspector.TypeSet.TypeBit.Null),_.isBoolean&&(S|=WebInspector.TypeSet.TypeBit.Boolean),_.isInteger&&(S|=WebInspector.TypeSet.TypeBit.Integer),_.isNumber&&(S|=WebInspector.TypeSet.TypeBit.Number),_.isString&&(S|=WebInspector.TypeSet.TypeBit.String),_.isObject&&(S|=WebInspector.TypeSet.TypeBit.Object),_.isSymbol&&(S|=WebInspector.TypeSet.TypeBit.Symbol),this._typeSet=_,this._bitString=S,this._primitiveTypeNames=null}static fromPayload(_){return new WebInspector.TypeSet(_)}isContainedIn(_){return this._bitString&&(this._bitString&_)===this._bitString}get primitiveTypeNames(){if(this._primitiveTypeNames)return this._primitiveTypeNames;this._primitiveTypeNames=[];var _=this._typeSet;return _.isUndefined&&this._primitiveTypeNames.push("Undefined"),_.isNull&&this._primitiveTypeNames.push("Null"),_.isBoolean&&this._primitiveTypeNames.push("Boolean"),_.isString&&this._primitiveTypeNames.push("String"),_.isSymbol&&this._primitiveTypeNames.push("Symbol"),_.isNumber?this._primitiveTypeNames.push("Number"):_.isInteger&&this._primitiveTypeNames.push("Integer"),this._primitiveTypeNames}},WebInspector.TypeSet.TypeBit={Function:1,Undefined:2,Null:4,Boolean:8,Integer:16,Number:32,String:64,Object:128,Symbol:256},WebInspector.TypeSet.NullOrUndefinedTypeBits=WebInspector.TypeSet.TypeBit.Null|WebInspector.TypeSet.TypeBit.Undefined,WebInspector.WebSocketResource=class extends WebInspector.Resource{constructor(_,S,C,f,T,E,I,R,N,L){const D=WebInspector.Resource.Type.WebSocket;super(_,null,D,S,C,f,"GET",T,E,N,L),this._timestamp=I,this._walltime=R,this._readyState=WebInspector.WebSocketResource.ReadyState.Connecting,this._frames=[]}get frames(){return this._frames}get walltime(){return this._walltime}get readyState(){return this._readyState}set readyState(_){if(_!==this._readyState){let S=this._readyState;this._readyState=_,this.dispatchEventToListeners(WebInspector.WebSocketResource.Event.ReadyStateChanged,{previousState:S,state:_})}}addFrame(_,S,C,f,T,E){let I=f===WebInspector.WebSocketResource.OpCodes.BinaryFrame?null:_;let R={data:I,isOutgoing:C,opcode:f,walltime:this._walltimeForWebSocketTimestamp(T)};this._frames.push(R),S===void 0&&(S=new TextEncoder("utf-8").encode(_).length),this.increaseSize(S,E),this.dispatchEventToListeners(WebInspector.WebSocketResource.Event.FrameAdded,R)}_walltimeForWebSocketTimestamp(_){return this._walltime+(_-this._timestamp)}},WebInspector.WebSocketResource.Event={FrameAdded:Symbol("web-socket-frame-added"),ReadyStateChanged:Symbol("web-socket-resource-ready-state-changed")},WebInspector.WebSocketResource.ReadyState={Closed:Symbol("closed"),Connecting:Symbol("connecting"),Open:Symbol("open")},WebInspector.WebSocketResource.OpCodes={ContinuationFrame:0,TextFrame:1,BinaryFrame:2,ConnectionCloseFrame:8,PingFrame:9,PongFrame:10},WebInspector.WrappedPromise=class{constructor(_){this._settled=!1,this._promise=new Promise((S,C)=>{if(this._resolveCallback=S,this._rejectCallback=C,_&&"function"==typeof _)return _(this.resolve.bind(this),this.reject.bind(this))})}get settled(){return this._settled}get promise(){return this._promise}resolve(_){if(this._settled)throw new Error("Promise is already settled, cannot call resolve().");this._settled=!0,this._resolveCallback(_)}reject(_){if(this._settled)throw new Error("Promise is already settled, cannot call reject().");this._settled=!0,this._rejectCallback(_)}},WebInspector.XHRBreakpoint=class extends WebInspector.Object{constructor(_,S,C){super(),this._type=_||WebInspector.XHRBreakpoint.Type.Text,this._url=S||"",this._disabled=C||!1}get type(){return this._type}get url(){return this._url}get disabled(){return this._disabled}set disabled(_){this._disabled===_||(this._disabled=_,this.dispatchEventToListeners(WebInspector.XHRBreakpoint.Event.DisabledStateDidChange))}get serializableInfo(){let _={type:this._type,url:this._url};return this._disabled&&(_.disabled=!0),_}saveIdentityToCookie(_){_[WebInspector.XHRBreakpoint.URLCookieKey]=this._url}},WebInspector.XHRBreakpoint.URLCookieKey="xhr-breakpoint-url",WebInspector.XHRBreakpoint.Event={DisabledStateDidChange:"xhr-breakpoint-disabled-state-did-change",ResolvedStateDidChange:"xhr-breakpoint-resolved-state-did-change"},WebInspector.XHRBreakpoint.Type={Text:"text",RegularExpression:"regex"},WebInspector.FormatterWorkerProxy=class u extends WebInspector.Object{constructor(){super(),this._formatterWorker=new Worker("Workers/Formatter/FormatterWorker.js"),this._formatterWorker.addEventListener("message",this._handleMessage.bind(this)),this._nextCallId=1,this._callbacks=new Map}static singleton(){return u.instance||(u.instance=new u),u.instance}formatJavaScript(){this.performAction("formatJavaScript",...arguments)}performAction(_){let S=this._nextCallId++,C=arguments[arguments.length-1],f=Array.prototype.slice.call(arguments,1,arguments.length-1);this._callbacks.set(S,C),this._postMessage({callId:S,actionName:_,actionArguments:f})}_postMessage(){this._formatterWorker.postMessage(...arguments)}_handleMessage(_){let S=_.data;if(S.callId){let C=this._callbacks.get(S.callId);return this._callbacks.delete(S.callId),void C(S.result)}console.error("Unexpected FormatterWorker message",S)}},WebInspector.HeapSnapshotDiffProxy=class extends WebInspector.Object{constructor(_,S,C,f,T,E){super(),this._proxyObjectId=_,this._snapshot1=S,this._snapshot2=C,this._totalSize=f,this._totalObjectCount=T,this._categories=Map.fromObject(E)}static deserialize(_,S){let{snapshot1:C,snapshot2:f,totalSize:T,totalObjectCount:E,categories:I}=S,R=WebInspector.HeapSnapshotProxy.deserialize(_,C),N=WebInspector.HeapSnapshotProxy.deserialize(_,f);return new WebInspector.HeapSnapshotDiffProxy(_,R,N,T,E,I)}get snapshot1(){return this._snapshot1}get snapshot2(){return this._snapshot2}get totalSize(){return this._totalSize}get totalObjectCount(){return this._totalObjectCount}get categories(){return this._categories}get invalid(){return this._snapshot1.invalid||this._snapshot2.invalid}updateForCollectionEvent(_){_.data.affectedSnapshots.includes(this._snapshot2._identifier)&&this.update(()=>{this.dispatchEventToListeners(WebInspector.HeapSnapshotProxy.Event.CollectedNodes,_.data)})}allocationBucketCounts(_,S){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"allocationBucketCounts",_,S)}instancesWithClassName(_,S){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"instancesWithClassName",_,C=>{S(C.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)))})}update(_){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"update",({liveSize:S,categories:C})=>{this._categories=Map.fromObject(C),_()})}nodeWithIdentifier(_,S){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"nodeWithIdentifier",_,C=>{S(WebInspector.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,C))})}},WebInspector.HeapSnapshotEdgeProxy=class{constructor(_,S,C,f,T){this._proxyObjectId=_,this.fromIdentifier=S,this.toIdentifier=C,this.type=f,this.data=T,this.from=null,this.to=null}isPrivateSymbol(){return!WebInspector.isDebugUIEnabled()&&"string"==typeof this.data&&this.data.startsWith("PrivateSymbol")}static deserialize(_,S){let{from:C,to:f,type:T,data:E}=S;return new WebInspector.HeapSnapshotEdgeProxy(_,C,f,T,E)}},WebInspector.HeapSnapshotEdgeProxy.EdgeType={Internal:"Internal",Property:"Property",Index:"Index",Variable:"Variable"},WebInspector.HeapSnapshotNodeProxy=class{constructor(_,S,C,f,T,E,I,R,N,L){this._proxyObjectId=_,this.id=S,this.className=C,this.size=f,this.retainedSize=T,this.internal=E,this.gcRoot=I,this.dead=R,this.dominatorNodeIdentifier=N,this.hasChildren=L}static deserialize(_,S){let{id:C,className:f,size:T,retainedSize:E,internal:I,gcRoot:R,dead:N,dominatorNodeIdentifier:L,hasChildren:D}=S;return new WebInspector.HeapSnapshotNodeProxy(_,C,f,T,E,I,R,N,L,D)}shortestGCRootPath(_){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"shortestGCRootPath",this.id,S=>{let C=!1,f=S.map(T=>{return C=!C,C?WebInspector.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,T):WebInspector.HeapSnapshotEdgeProxy.deserialize(this._proxyObjectId,T)});for(let T=1,E;T<f.length;T+=2)E=f[T],E.from=f[T-1],E.to=f[T+1];_(f)})}dominatedNodes(_){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"dominatedNodes",this.id,S=>{_(S.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)))})}retainedNodes(_){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"retainedNodes",this.id,({retainedNodes:S,edges:C})=>{let f=S.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)),T=C.map(WebInspector.HeapSnapshotEdgeProxy.deserialize.bind(null,this._proxyObjectId));_(f,T)})}retainers(_){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"retainers",this.id,({retainers:S,edges:C})=>{let f=S.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)),T=C.map(WebInspector.HeapSnapshotEdgeProxy.deserialize.bind(null,this._proxyObjectId));_(f,T)})}},WebInspector.HeapSnapshotProxy=class extends WebInspector.Object{constructor(_,S,C,f,T,E,I){super(),this._proxyObjectId=_,this._identifier=S,this._title=C,this._totalSize=f,this._totalObjectCount=T,this._liveSize=E,this._categories=Map.fromObject(I),WebInspector.HeapSnapshotProxy.ValidSnapshotProxies||(WebInspector.HeapSnapshotProxy.ValidSnapshotProxies=[]),WebInspector.HeapSnapshotProxy.ValidSnapshotProxies.push(this)}static deserialize(_,S){let{identifier:C,title:f,totalSize:T,totalObjectCount:E,liveSize:I,categories:R}=S;return new WebInspector.HeapSnapshotProxy(_,C,f,T,E,I,R)}static invalidateSnapshotProxies(){if(WebInspector.HeapSnapshotProxy.ValidSnapshotProxies){for(let _ of WebInspector.HeapSnapshotProxy.ValidSnapshotProxies)_._invalidate();WebInspector.HeapSnapshotProxy.ValidSnapshotProxies=null}}get proxyObjectId(){return this._proxyObjectId}get identifier(){return this._identifier}get title(){return this._title}get totalSize(){return this._totalSize}get totalObjectCount(){return this._totalObjectCount}get liveSize(){return this._liveSize}get categories(){return this._categories}get invalid(){return 0===this._proxyObjectId}updateForCollectionEvent(_){_.data.affectedSnapshots.includes(this._identifier)&&this.update(()=>{this.dispatchEventToListeners(WebInspector.HeapSnapshotProxy.Event.CollectedNodes,_.data)})}allocationBucketCounts(_,S){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"allocationBucketCounts",_,S)}instancesWithClassName(_,S){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"instancesWithClassName",_,C=>{S(C.map(WebInspector.HeapSnapshotNodeProxy.deserialize.bind(null,this._proxyObjectId)))})}update(_){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"update",({liveSize:S,categories:C})=>{this._liveSize=S,this._categories=Map.fromObject(C),_()})}nodeWithIdentifier(_,S){WebInspector.HeapSnapshotWorkerProxy.singleton().callMethod(this._proxyObjectId,"nodeWithIdentifier",_,C=>{S(WebInspector.HeapSnapshotNodeProxy.deserialize(this._proxyObjectId,C))})}_invalidate(){this._proxyObjectId=0,this._liveSize=0,this.dispatchEventToListeners(WebInspector.HeapSnapshotProxy.Event.Invalidated)}},WebInspector.HeapSnapshotProxy.Event={CollectedNodes:"heap-snapshot-proxy-collected-nodes",Invalidated:"heap-snapshot-proxy-invalidated"},WebInspector.HeapSnapshotWorkerProxy=class u extends WebInspector.Object{constructor(){super(),this._heapSnapshotWorker=new Worker("Workers/HeapSnapshot/HeapSnapshotWorker.js"),this._heapSnapshotWorker.addEventListener("message",this._handleMessage.bind(this)),this._nextCallId=1,this._callbacks=new Map,WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this)}static singleton(){return u.instance||(u.instance=new u),u.instance}clearSnapshots(_){this.performAction("clearSnapshots",_)}createSnapshot(){this.performAction("createSnapshot",...arguments)}createSnapshotDiff(){this.performAction("createSnapshotDiff",...arguments)}performAction(_){let S=this._nextCallId++,C=arguments[arguments.length-1],f=Array.prototype.slice.call(arguments,1,arguments.length-1);this._callbacks.set(S,C),this._postMessage({callId:S,actionName:_,actionArguments:f})}callMethod(_,S){let C=this._nextCallId++,f=arguments[arguments.length-1],T=Array.prototype.slice.call(arguments,2,arguments.length-1);this._callbacks.set(C,f),this._postMessage({callId:C,objectId:_,methodName:S,methodArguments:T})}_mainResourceDidChange(_){_.target.isMainFrame()&&this.clearSnapshots(()=>{WebInspector.HeapSnapshotProxy.invalidateSnapshotProxies()})}_postMessage(){this._heapSnapshotWorker.postMessage(...arguments)}_handleMessage(_){let S=_.data;if(S.error)return void this._callbacks.delete(S.callId);if(S.eventName)return void this.dispatchEventToListeners(S.eventName,S.eventData);if(S.callId){let C=this._callbacks.get(S.callId);return this._callbacks.delete(S.callId),void C(S.result)}console.error("Unexpected HeapSnapshotWorker message",S)}},WebInspector.View=class extends WebInspector.Object{constructor(_){super(),this._element=_||document.createElement("div"),this._element.__view=this,this._parentView=null,this._subviews=[],this._dirty=!1,this._dirtyDescendantsCount=0,this._needsLayoutWhenAttachedToRoot=!1,this._isAttachedToRoot=!1,this._layoutReason=null,this._didInitialLayout=!1}static rootView(){return WebInspector.View._rootView||(WebInspector.View._rootView=new WebInspector.View(document.body)),WebInspector.View._rootView}get element(){return this._element}get layoutPending(){return this._dirty}get parentView(){return this._parentView}get subviews(){return this._subviews}isDescendantOf(_){for(let S=this._parentView;S;){if(S===_)return!0;S=S.parentView}return!1}addSubview(_){this.insertSubviewBefore(_,null)}insertSubviewBefore(_,S){if(!this._subviews.includes(_)){const C=S?this._subviews.indexOf(S):this._subviews.length;-1===C||(this._subviews.insertAtIndex(_,C),!_.element.parentNode&&this._element.insertBefore(_.element,S?S.element:null),_.didMoveToParent(this))}}removeSubview(_){this._subviews.includes(_)&&(this._subviews.remove(_,!0),this._element.removeChild(_.element),_.didMoveToParent(null))}replaceSubview(_,S){this.insertSubviewBefore(S,_),this.removeSubview(_)}updateLayout(_){this.cancelLayout(),this._setLayoutReason(_),this._layoutSubtree()}updateLayoutIfNeeded(_){!this._dirty&&this._didInitialLayout||this.updateLayout(_)}needsLayout(_){this._setLayoutReason(_);this._dirty||WebInspector.View._scheduleLayoutForView(this)}cancelLayout(){WebInspector.View._cancelScheduledLayoutForView(this)}get layoutReason(){return this._layoutReason}didMoveToWindow(_){this._isAttachedToRoot=_,this._isAttachedToRoot&&this._needsLayoutWhenAttachedToRoot&&(WebInspector.View._scheduleLayoutForView(this),this._needsLayoutWhenAttachedToRoot=!1);for(let S of this._subviews)S.didMoveToWindow(_)}didMoveToParent(_){this._parentView=_;let S=this.isDescendantOf(WebInspector.View._rootView);if(this.didMoveToWindow(S),!!this._parentView){let C=this._dirtyDescendantsCount;this._dirty&&C++;for(let f=this._parentView;f;)f._dirtyDescendantsCount+=C,f=f.parentView}}initialLayout(){}layout(){}sizeDidChange(){}_layoutSubtree(){this._dirty=!1,this._dirtyDescendantsCount=0,this._didInitialLayout||(this.initialLayout(),this._didInitialLayout=!0),this._layoutReason===WebInspector.View.LayoutReason.Resize&&this.sizeDidChange(),this.layout();for(let _ of this._subviews)_._setLayoutReason(this._layoutReason),_._layoutSubtree();this._layoutReason=null}_setLayoutReason(_){this._layoutReason===WebInspector.View.LayoutReason.Resize||(this._layoutReason=_||WebInspector.View.LayoutReason.Dirty)}static _scheduleLayoutForView(_){_._dirty=!0;for(let S=_.parentView;S;)S._dirtyDescendantsCount++,S=S.parentView;return _._isAttachedToRoot?void(WebInspector.View._scheduledLayoutUpdateIdentifier||(WebInspector.View._scheduledLayoutUpdateIdentifier=requestAnimationFrame(WebInspector.View._visitViewTreeForLayout))):void(_._needsLayoutWhenAttachedToRoot=!0)}static _cancelScheduledLayoutForView(_){let S=_._dirtyDescendantsCount;_.layoutPending&&S++;for(let C=_.parentView;C;)C._dirtyDescendantsCount=Math.max(0,C._dirtyDescendantsCount-S),C=C.parentView;if(WebInspector.View._scheduledLayoutUpdateIdentifier){let f=WebInspector.View._rootView;!f||f._dirtyDescendantsCount||(cancelAnimationFrame(WebInspector.View._scheduledLayoutUpdateIdentifier),WebInspector.View._scheduledLayoutUpdateIdentifier=void 0)}}static _visitViewTreeForLayout(){WebInspector.View._scheduledLayoutUpdateIdentifier=void 0;for(let _=[WebInspector.View._rootView],S;_.length;)S=_.shift(),S.layoutPending?S._layoutSubtree():S._dirtyDescendantsCount&&(_=_.concat(S.subviews),S._dirtyDescendantsCount=0)}},WebInspector.View.LayoutReason={Dirty:Symbol("layout-reason-dirty"),Resize:Symbol("layout-reason-resize")},WebInspector.View._rootView=null,WebInspector.View._scheduledLayoutUpdateIdentifier=void 0,WebInspector.ConsoleCommandView=class extends WebInspector.Object{constructor(_,S){super(),this._commandText=_,this._className=S||""}render(){this._element=document.createElement("div"),this._element.classList.add("console-user-command"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Input: ")),this._className&&this._element.classList.add(this._className),this._formattedCommandElement=this._element.appendChild(document.createElement("span")),this._formattedCommandElement.classList.add("console-message-text"),this._formattedCommandElement.textContent=this._commandText,this._element.__commandView=this}get element(){return this._element}get commandText(){return this._commandText}toClipboardString(_){return(_?"":"> ")+this._commandText.removeWordBreakCharacters()}},WebInspector.ConsoleMessageView=class extends WebInspector.Object{constructor(_){super(),this._message=_,this._expandable=!1,this._repeatCount=_._repeatCount||0,this._extraParameters=_.parameters}render(){switch(this._element=document.createElement("div"),this._element.classList.add("console-message"),this._element.__message=this._message,this._element.__messageView=this,this._message.type===WebInspector.ConsoleMessage.MessageType.Result?(this._element.classList.add("console-user-command-result"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Output: "))):(this._message.type===WebInspector.ConsoleMessage.MessageType.StartGroup||this._message.type===WebInspector.ConsoleMessage.MessageType.StartGroupCollapsed)&&this._element.classList.add("console-group-title"),this._message.level){case WebInspector.ConsoleMessage.MessageLevel.Log:this._element.classList.add("console-log-level"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Log: "));break;case WebInspector.ConsoleMessage.MessageLevel.Info:this._element.classList.add("console-info-level"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Info: "));break;case WebInspector.ConsoleMessage.MessageLevel.Debug:this._element.classList.add("console-debug-level"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Debug: "));break;case WebInspector.ConsoleMessage.MessageLevel.Warning:this._element.classList.add("console-warning-level"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Warning: "));break;case WebInspector.ConsoleMessage.MessageLevel.Error:this._element.classList.add("console-error-level"),this._element.setAttribute("data-labelprefix",WebInspector.UIString("Error: "));}this._appendLocationLink(),this._messageTextElement=this._element.appendChild(document.createElement("span")),this._messageTextElement.classList.add("console-top-level-message"),this._messageTextElement.classList.add("console-message-text"),this._appendMessageTextAndArguments(this._messageTextElement),this._appendSavedResultIndex(),this._appendExtraParameters(),this._appendStackTrace(),this._renderRepeatCount()}get element(){return this._element}get message(){return this._message}get repeatCount(){return this._repeatCount}set repeatCount(_){this._repeatCount===_||(this._repeatCount=_,this._element&&this._renderRepeatCount())}_renderRepeatCount(){let _=this._repeatCount;return 1>=_?void(this._repeatCountElement&&(this._repeatCountElement.remove(),this._repeatCountElement=null)):void(!this._repeatCountElement&&(this._repeatCountElement=document.createElement("span"),this._repeatCountElement.classList.add("repeat-count"),this._element.insertBefore(this._repeatCountElement,this._element.firstChild)),this._repeatCountElement.textContent=Number.abbreviate(_))}get expandable(){return!!this._expandable||!!this._objectTree}expand(){this._expandable&&this._element.classList.add("expanded"),this._objectTree&&this._message.type!==WebInspector.ConsoleMessage.MessageType.Trace&&(!this._extraParameters||1>=this._extraParameters.length)&&this._objectTree.expand()}collapse(){this._expandable&&this._element.classList.remove("expanded"),this._objectTree&&(!this._extraParameters||1>=this._extraParameters.length)&&this._objectTree.collapse()}toggle(){this._element.classList.contains("expanded")?this.collapse():this.expand()}toClipboardString(_){let S=this._messageTextElement.innerText.removeWordBreakCharacters();this._message.savedResultIndex&&(S=S.replace(/\s*=\s*(\$\d+)$/,""));let C=this._shouldShowStackTrace();if(!C){let f=1<this.repeatCount?"x"+this.repeatCount:"",T="";if(this._message.url){let E=[WebInspector.displayNameForURL(this._message.url),"line "+this._message.line];f&&E.push(f),T=" ("+E.join(", ")+")"}else f&&(T=" ("+f+")");if(T){let E=S.split("\n");E[0]+=T,S=E.join("\n")}}return this._extraElementsList&&(S+="\n"+this._extraElementsList.innerText.removeWordBreakCharacters().trim()),C&&this._message.stackTrace.callFrames.forEach(function(f){S+="\n\t"+(f.functionName||WebInspector.UIString("(anonymous function)")),f.sourceCodeLocation&&(S+=" ("+f.sourceCodeLocation.originalLocationString()+")")}),!_||this._enforcesClipboardPrefixString()?this._clipboardPrefixString()+S:S}_appendMessageTextAndArguments(_){if(this._message.source===WebInspector.ConsoleMessage.MessageSource.ConsoleAPI){switch(this._message.type){case WebInspector.ConsoleMessage.MessageType.Trace:var S=[WebInspector.UIString("Trace")];if(this._message.parameters)if("string"===this._message.parameters[0].type){var C=WebInspector.UIString("Trace: %s").format(this._message.parameters[0].description);S=[C].concat(this._message.parameters.slice(1))}else S=S.concat(this._message.parameters);this._appendFormattedArguments(_,S);break;case WebInspector.ConsoleMessage.MessageType.Assert:var S=[WebInspector.UIString("Assertion Failed")];if(this._message.parameters)if("string"===this._message.parameters[0].type){var C=WebInspector.UIString("Assertion Failed: %s").format(this._message.parameters[0].description);S=[C].concat(this._message.parameters.slice(1))}else S=S.concat(this._message.parameters);this._appendFormattedArguments(_,S);break;case WebInspector.ConsoleMessage.MessageType.Dir:var f=this._message.parameters?this._message.parameters[0]:void 0;this._appendFormattedArguments(_,["%O",f]);break;case WebInspector.ConsoleMessage.MessageType.Table:var S=this._message.parameters;_.appendChild(this._formatParameterAsTable(S)),this._extraParameters=null;break;case WebInspector.ConsoleMessage.MessageType.StartGroup:case WebInspector.ConsoleMessage.MessageType.StartGroupCollapsed:var S=this._message.parameters||[this._message.messageText||WebInspector.UIString("Group")];this._formatWithSubstitutionString(S,_),this._extraParameters=null;break;default:var S=this._message.parameters||[this._message.messageText];this._appendFormattedArguments(_,S);}return}var S=this._message.parameters||[this._message.messageText];this._appendFormattedArguments(_,S)}_appendSavedResultIndex(){if(this._message.savedResultIndex){var S=document.createElement("span");S.classList.add("console-saved-variable"),S.textContent=" = $"+this._message.savedResultIndex,this._objectTree?this._objectTree.appendTitleSuffix(S):this._messageTextElement.appendChild(S)}}_appendLocationLink(){if(this._message.source===WebInspector.ConsoleMessage.MessageSource.Network){if(this._message.url){var _=WebInspector.linkifyURLAsNode(this._message.url,this._message.url,"console-message-url");_.classList.add("console-message-location"),this._element.appendChild(_)}return}var S=this._message.stackTrace.firstNonNativeNonAnonymousCallFrame,C;if(S?C=S:this._message.url&&!this._shouldHideURL(this._message.url)&&(C=WebInspector.CallFrame.fromPayload(this._message.target,{functionName:"",url:this._message.url,lineNumber:this._message.line,columnNumber:this._message.column})),C&&(!C.isConsoleEvaluation||WebInspector.isDebugUIEnabled())){const E=!!C.functionName;var f=new WebInspector.CallFrameView(C,E);return f.classList.add("console-message-location"),void this._element.appendChild(f)}if(this._message.parameters&&1===this._message.parameters.length){var T=this._createRemoteObjectIfNeeded(this._message.parameters[0]);T.findFunctionSourceCodeLocation().then(function(E){if(E!==WebInspector.RemoteObject.SourceCodeLocationPromise.NoSourceFound&&E!==WebInspector.RemoteObject.SourceCodeLocationPromise.MissingObjectId){var I=this._linkifyLocation(E.sourceCode.url,E.lineNumber,E.columnNumber);I.classList.add("console-message-location"),this._element.hasChildNodes()?this._element.insertBefore(I,this._element.firstChild):this._element.appendChild(I)}}.bind(this))}}_appendExtraParameters(){if(this._extraParameters&&this._extraParameters.length){this._makeExpandable(),1<this._extraParameters.length&&this.expand(),this._extraElementsList=this._element.appendChild(document.createElement("ol")),this._extraElementsList.classList.add("console-message-extra-parameters-container");for(var _ of this._extraParameters){var S=this._extraElementsList.appendChild(document.createElement("li"));const C="object"===_.type&&"null"!==_.subtype&&"regexp"!==_.subtype&&"node"!==_.subtype&&"error"!==_.subtype;S.classList.add("console-message-extra-parameter"),S.appendChild(this._formatParameter(_,C))}}}_appendStackTrace(){if(this._shouldShowStackTrace()){this._makeExpandable(),this._message.type===WebInspector.ConsoleMessage.MessageType.Trace&&this.expand(),this._stackTraceElement=this._element.appendChild(document.createElement("div")),this._stackTraceElement.classList.add("console-message-text","console-message-stack-trace-container");var _=new WebInspector.StackTraceView(this._message.stackTrace).element;this._stackTraceElement.appendChild(_)}}_createRemoteObjectIfNeeded(_){return _ instanceof WebInspector.RemoteObject?_:"object"==typeof _?WebInspector.RemoteObject.fromPayload(_,this._message.target):WebInspector.RemoteObject.fromPrimitiveValue(_)}_appendFormattedArguments(_,S){if(S.length){for(var C=0;C<S.length;++C)S[C]=this._createRemoteObjectIfNeeded(S[C]);var f=_.appendChild(document.createElement("span")),T="string"===WebInspector.RemoteObject.type(S[0])&&this._message.type!==WebInspector.ConsoleMessage.MessageType.Result;if(1===S.length&&!T)return this._extraParameters=null,void f.appendChild(this._formatParameter(S[0],!1));if(T&&this._isStackTrace(S[0])&&(T=!1),T){var E=this._formatWithSubstitutionString(S,f);S=E.unusedSubstitutions,this._extraParameters=S}else{var I=WebInspector.UIString("No message");f.append(I)}if(S.length){let M=document.createElement("span");if(1===S.length&&!this._isStackTrace(S[0])){let P=S[0];f.append(M),M.classList.add("console-message-preview-divider"),M.textContent=" \u2013 ";var R=f.appendChild(document.createElement("span"));R.classList.add("console-message-preview");var N=WebInspector.FormattedValue.createObjectPreviewOrFormattedValueForRemoteObject(P,WebInspector.ObjectPreviewView.Mode.Brief),L=N instanceof WebInspector.ObjectPreviewView;L&&N.setOriginatingObjectInfo(P,null);var D=L?N.element:N;R.appendChild(D),(L&&N.lossless||!L&&this._shouldConsiderObjectLossless(P))&&(this._extraParameters=null,M.classList.add("inline-lossless"),R.classList.add("inline-lossless"))}else f.append(" ",M),M.classList.add("console-message-enclosed"),M.textContent="("+S.length+")"}}}_isStackTrace(_){return!("string"!==WebInspector.RemoteObject.type(_))&&WebInspector.StackTrace.isLikelyStackTrace(_.description)}_shouldConsiderObjectLossless(_){if("string"===_.type){const S=_.description,C=WebInspector.FormattedValue.MAX_PREVIEW_STRING_LENGTH,f=S.length>C||S.slice(0,C).includes("\n");return!f}return"object"!==_.type||"null"===_.subtype||"regexp"===_.subtype}_formatParameter(_,S){var C=S?"object":_ instanceof WebInspector.RemoteObject?_.subtype||_.type:typeof _;var f={object:this._formatParameterAsObject,error:this._formatParameterAsError,map:this._formatParameterAsObject,set:this._formatParameterAsObject,weakmap:this._formatParameterAsObject,weakset:this._formatParameterAsObject,iterator:this._formatParameterAsObject,"class":this._formatParameterAsObject,proxy:this._formatParameterAsObject,array:this._formatParameterAsArray,node:this._formatParameterAsNode,string:this._formatParameterAsString},T=f[C]||this._formatParameterAsValue;const E=document.createDocumentFragment();return T.call(this,_,E,S),E}_formatParameterAsValue(_,S){S.appendChild(WebInspector.FormattedValue.createElementForRemoteObject(_))}_formatParameterAsString(_,S){if(this._isStackTrace(_)){let C=WebInspector.StackTrace.fromString(this._message.target,_.description);if(C.callFrames.length){let f=new WebInspector.StackTraceView(C);return void S.appendChild(f.element)}}S.appendChild(WebInspector.FormattedValue.createLinkifiedElementString(_.description))}_formatParameterAsNode(_,S){S.appendChild(WebInspector.FormattedValue.createElementForNode(_))}_formatParameterAsObject(_,S,C){this._objectTree=new WebInspector.ObjectTreeView(_,null,this._rootPropertyPathForObject(_),C),S.appendChild(this._objectTree.element)}_formatParameterAsError(_,S){this._objectTree=new WebInspector.ErrorObjectView(_),S.appendChild(this._objectTree.element)}_formatParameterAsArray(_,S){this._objectTree=new WebInspector.ObjectTreeView(_,WebInspector.ObjectTreeView.Mode.Properties,this._rootPropertyPathForObject(_)),S.appendChild(this._objectTree.element)}_rootPropertyPathForObject(_){return this._message.savedResultIndex?new WebInspector.PropertyPath(_,"$"+this._message.savedResultIndex):null}_formatWithSubstitutionString(_,S){function C(M,P){return this._formatParameter(P,M)}function E(M){let P="number"==typeof M.value?M.value:M.description;return String.standardFormatters.d(P)}function R(M){for(var P of["background","border","color","font","line","margin","padding","text"])if(M.startsWith(P)||M.startsWith("-webkit-"+P))return!0;return!1}var L=null,D={};return D.o=C.bind(this,!1),D.s=function(M){return M.description},D.f=function(M,P){let O="number"==typeof M.value?M.value:M.description;return String.standardFormatters.f(O,P)},D.i=E,D.d=E,D.c=function(M){L={};var P=document.createElement("span");P.setAttribute("style",M.description);for(var O=0,F;O<P.style.length;O++)F=P.style[O],R(F)&&(L[F]=P.style[F])},D.O=C.bind(this,!0),String.format(_[0].description,_.slice(1),D,S,function(M,P){if(P instanceof Node)M.appendChild(P);else if(void 0!==P){var O=WebInspector.linkifyStringAsFragment(P.toString());if(L){var F=document.createElement("span");for(var V in L)F.style[V]=L[V];F.appendChild(O),O=F}M.appendChild(O)}return M})}_shouldShowStackTrace(){return!!this._message.stackTrace.callFrames.length&&(this._message.source===WebInspector.ConsoleMessage.MessageSource.Network||this._message.level===WebInspector.ConsoleMessage.MessageLevel.Error||this._message.type===WebInspector.ConsoleMessage.MessageType.Trace)}_shouldHideURL(_){return"undefined"===_||"[native code]"===_}_linkifyLocation(_,S,C){return WebInspector.linkifyLocation(_,new WebInspector.SourceCodePosition(S,C),{className:"console-message-url",ignoreNetworkTab:!0,ignoreSearchTab:!0})}_userProvidedColumnNames(_){if(!_)return null;if("string"===_.type||"number"===_.type)return[_.value+""];if("object"!==_.type||"array"!==_.subtype||!_.preview||!_.preview.propertyPreviews)return null;var S=[];for(var C of _.preview.propertyPreviews)("string"===C.type||"number"===C.type)&&S.push(C.value+"");return S.length?S:null}_formatParameterAsTable(_){var S=document.createElement("span"),C=_[0];if(!C||!C.preview)return S;var f=[],T=[],E=[],I=C.preview,R=!1,N=this._userProvidedColumnNames(_[1]);if(N&&(R=!0,T=N),I.propertyPreviews)for(var L=0;L<I.propertyPreviews.length;++L){var D=I.propertyPreviews[L],M=D.valuePreview;if(M&&M.propertyPreviews){for(var P={},F=0;F<M.propertyPreviews.length;++F){var V=M.propertyPreviews[F],U=T.includes(V.name);if(!U){if(R||T.length===15)continue;U=!0,T.push(V.name)}P[V.name]=WebInspector.FormattedValue.createElementForPropertyPreview(V)}f.push([D.name,P])}}if(f.length){T.unshift(WebInspector.UIString("(Index)"));for(var L=0;L<f.length;++L){var G=f[L][0],P=f[L][1];E.push(G);for(var F=1,H;F<T.length;++F)H=T[F],H in P?E.push(P[H]):E.push(emDash)}}if(!E.length&&I.propertyPreviews)for(var L=0,D;L<I.propertyPreviews.length;++L)D=I.propertyPreviews[L],"value"in D&&(!T.length&&(T.push(WebInspector.UIString("Index")),T.push(WebInspector.UIString("Value"))),E.push(D.name),E.push(WebInspector.FormattedValue.createElementForPropertyPreview(D)));if(!E.length)return S;var W=WebInspector.DataGrid.createSortableDataGrid(T,E);return W.inline=!0,W.variableHeightRows=!0,S.appendChild(W.element),W.updateLayoutIfNeeded(),S}_levelString(){switch(this._message.level){case WebInspector.ConsoleMessage.MessageLevel.Log:return"Log";case WebInspector.ConsoleMessage.MessageLevel.Info:return"Info";case WebInspector.ConsoleMessage.MessageLevel.Warning:return"Warning";case WebInspector.ConsoleMessage.MessageLevel.Debug:return"Debug";case WebInspector.ConsoleMessage.MessageLevel.Error:return"Error";}}_enforcesClipboardPrefixString(){return this._message.type!==WebInspector.ConsoleMessage.MessageType.Result}_clipboardPrefixString(){return this._message.type===WebInspector.ConsoleMessage.MessageType.Result?"< ":"["+this._levelString()+"] "}_makeExpandable(){this._expandable||(this._expandable=!0,this._element.classList.add("expandable"),this._boundClickHandler=this.toggle.bind(this),this._messageTextElement.addEventListener("click",this._boundClickHandler))}},WebInspector.ContentBrowser=class extends WebInspector.View{constructor(_,S,C,f){if(super(_),this.element.classList.add("content-browser"),this._navigationBar=new WebInspector.NavigationBar,this.addSubview(this._navigationBar),this._contentViewContainer=new WebInspector.ContentViewContainer,this._contentViewContainer.addEventListener(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange,this._currentContentViewDidChange,this),this.addSubview(this._contentViewContainer),!C){let T=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL,E=()=>{this.goBack()},I=()=>{this.goForward()},R=T?WebInspector.KeyboardShortcut.Key.Right:WebInspector.KeyboardShortcut.Key.Left,N=T?WebInspector.KeyboardShortcut.Key.Left:WebInspector.KeyboardShortcut.Key.Right;this._backKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Control,R,E,this.element),this._forwardKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Control,N,I,this.element);let L="Images/BackForwardArrows.svg#left-arrow-mask",D="Images/BackForwardArrows.svg#right-arrow-mask",M=T?D:L,P=T?L:D;this._backNavigationItem=new WebInspector.ButtonNavigationItem("back",WebInspector.UIString("Back (%s)").format(this._backKeyboardShortcut.displayName),M,8,13),this._backNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,E),this._backNavigationItem.enabled=!1,this._navigationBar.addNavigationItem(this._backNavigationItem),this._forwardNavigationItem=new WebInspector.ButtonNavigationItem("forward",WebInspector.UIString("Forward (%s)").format(this._forwardKeyboardShortcut.displayName),P,8,13),this._forwardNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,I),this._forwardNavigationItem.enabled=!1,this._navigationBar.addNavigationItem(this._forwardNavigationItem),this._navigationBar.addNavigationItem(new WebInspector.DividerNavigationItem)}f||(this._findBanner=new WebInspector.FindBanner(this),this._findBanner.addEventListener(WebInspector.FindBanner.Event.DidShow,this._findBannerDidShow,this),this._findBanner.addEventListener(WebInspector.FindBanner.Event.DidHide,this._findBannerDidHide,this)),this._hierarchicalPathNavigationItem=new WebInspector.HierarchicalPathNavigationItem,this._hierarchicalPathNavigationItem.addEventListener(WebInspector.HierarchicalPathNavigationItem.Event.PathComponentWasSelected,this._hierarchicalPathComponentWasSelected,this),this._navigationBar.addNavigationItem(this._hierarchicalPathNavigationItem),this._contentViewSelectionPathNavigationItem=new WebInspector.HierarchicalPathNavigationItem,this._dividingFlexibleSpaceNavigationItem=new WebInspector.FlexibleSpaceNavigationItem,this._navigationBar.addNavigationItem(this._dividingFlexibleSpaceNavigationItem),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.SelectionPathComponentsDidChange,this._contentViewSelectionPathComponentDidChange,this),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.SupplementalRepresentedObjectsDidChange,this._contentViewSupplementalRepresentedObjectsDidChange,this),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange,this._contentViewNumberOfSearchResultsDidChange,this),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.NavigationItemsDidChange,this._contentViewNavigationItemsDidChange,this),this._delegate=S||null,this._currentContentViewNavigationItems=[]}get navigationBar(){return this._navigationBar}get contentViewContainer(){return this._contentViewContainer}get delegate(){return this._delegate}set delegate(_){this._delegate=_||null}get currentContentView(){return this._contentViewContainer.currentContentView}get currentRepresentedObjects(){var _=[],S=this._hierarchicalPathNavigationItem.lastComponent;S&&S.representedObject&&_.push(S.representedObject),S=this._contentViewSelectionPathNavigationItem.lastComponent,S&&S.representedObject&&_.push(S.representedObject);var C=this.currentContentView;if(C){var f=C.supplementalRepresentedObjects;f&&f.length&&(_=_.concat(f))}return _}showContentViewForRepresentedObject(_,S,C){var f=this.contentViewForRepresentedObject(_,!1,C);return this._contentViewContainer.showContentView(f,S)}showContentView(_,S){return this._contentViewContainer.showContentView(_,S)}contentViewForRepresentedObject(_,S,C){return this._contentViewContainer.contentViewForRepresentedObject(_,S,C)}updateHierarchicalPathForCurrentContentView(){var _=this.currentContentView;this._updateHierarchicalPathNavigationItem(_?_.representedObject:null)}canGoBack(){var _=this.currentContentView;return _&&_.canGoBack()||this._contentViewContainer.canGoBack()}canGoForward(){var _=this.currentContentView;return _&&_.canGoForward()||this._contentViewContainer.canGoForward()}goBack(){var _=this.currentContentView;return _&&_.canGoBack()?(_.goBack(),void this._updateBackForwardButtons()):void this._contentViewContainer.goBack()}goForward(){var _=this.currentContentView;return _&&_.canGoForward()?(_.goForward(),void this._updateBackForwardButtons()):void this._contentViewContainer.goForward()}showFindBanner(){if(this._findBanner){var _=this.currentContentView;return _&&_.supportsSearch?_.supportsCustomFindBanner?void _.showCustomFindBanner():void this._findBanner.show():void 0}}findBannerPerformSearch(_,S){var C=this.currentContentView;C&&C.supportsSearch&&C.performSearch(S)}findBannerSearchCleared(){var S=this.currentContentView;S&&S.supportsSearch&&S.searchCleared()}findBannerSearchQueryForSelection(){var S=this.currentContentView;return S&&S.supportsSearch?S.searchQueryWithSelection():null}findBannerRevealPreviousResult(_){var S=this.currentContentView;S&&S.supportsSearch&&S.revealPreviousSearchResult(!_.showing)}findBannerRevealNextResult(_){var S=this.currentContentView;S&&S.supportsSearch&&S.revealNextSearchResult(!_.showing)}shown(){this._contentViewContainer.shown(),this._findBanner&&this._findBanner.enableKeyboardShortcuts()}hidden(){this._contentViewContainer.hidden(),this._findBanner&&this._findBanner.disableKeyboardShortcuts()}_findBannerDidShow(){var S=this.currentContentView;S&&S.supportsSearch&&(S.automaticallyRevealFirstSearchResult=!0,""!==this._findBanner.searchQuery&&S.performSearch(this._findBanner.searchQuery))}_findBannerDidHide(){var S=this.currentContentView;S&&S.supportsSearch&&(S.automaticallyRevealFirstSearchResult=!1,S.searchCleared())}_contentViewNumberOfSearchResultsDidChange(_){this._findBanner&&_.target===this.currentContentView&&(this._findBanner.numberOfResults=this.currentContentView.numberOfSearchResults)}_updateHierarchicalPathNavigationItem(_){if(this.delegate&&"function"==typeof this.delegate.contentBrowserTreeElementForRepresentedObject){for(var S=_?this.delegate.contentBrowserTreeElementForRepresentedObject(this,_):null,C=[],f;S&&!S.root;)f=new WebInspector.GeneralTreeElementPathComponent(S),C.unshift(f),S=S.parent;this._hierarchicalPathNavigationItem.components=C}}_updateContentViewSelectionPathNavigationItem(_){var S=_?_.selectionPathComponents||[]:[];if(this._contentViewSelectionPathNavigationItem.components=S,!S.length)return this._hierarchicalPathNavigationItem.alwaysShowLastPathComponentSeparator=!1,void this._navigationBar.removeNavigationItem(this._contentViewSelectionPathNavigationItem);if(!this._navigationBar.navigationItems.includes(this._contentViewSelectionPathNavigationItem)){var C=this._navigationBar.navigationItems.indexOf(this._hierarchicalPathNavigationItem);this._navigationBar.insertNavigationItem(this._contentViewSelectionPathNavigationItem,C+1),this._hierarchicalPathNavigationItem.alwaysShowLastPathComponentSeparator=!0}}_updateBackForwardButtons(){this._backNavigationItem&&this._forwardNavigationItem&&(this._backNavigationItem.enabled=this.canGoBack(),this._forwardNavigationItem.enabled=this.canGoForward())}_updateContentViewNavigationItems(_){let S=this.currentContentView;if(!S)return this._removeAllNavigationItems(),void(this._currentContentViewNavigationItems=[]);if(S.parentContainer===this._contentViewContainer){if(!_){let E=this._currentContentViewNavigationItems.filter(R=>!(R instanceof WebInspector.DividerNavigationItem)),I=Array.shallowEqual(E,S.navigationItems);if(I)return}this._removeAllNavigationItems();let C=this.navigationBar,f=C.navigationItems.indexOf(this._dividingFlexibleSpaceNavigationItem)+1,T=[];S.navigationItems.forEach(function(E,I){if(0!==I||E instanceof WebInspector.ButtonNavigationItem){let R=new WebInspector.DividerNavigationItem;C.insertNavigationItem(R,f++),T.push(R)}C.insertNavigationItem(E,f++),T.push(E)}),this._currentContentViewNavigationItems=T}}_removeAllNavigationItems(){for(let _ of this._currentContentViewNavigationItems)_.parentNavigationBar&&_.parentNavigationBar.removeNavigationItem(_)}_updateFindBanner(_){return this._findBanner?_?void(this._findBanner.targetElement=_.element,this._findBanner.numberOfResults=_.hasPerformedSearch?_.numberOfSearchResults:null,_.supportsSearch&&this._findBanner.searchQuery&&(_.automaticallyRevealFirstSearchResult=this._findBanner.showing,_.performSearch(this._findBanner.searchQuery))):(this._findBanner.targetElement=null,void(this._findBanner.numberOfResults=null)):void 0}_dispatchCurrentRepresentedObjectsDidChangeEvent(){this._dispatchCurrentRepresentedObjectsDidChangeEvent.cancelDebounce(),this.dispatchEventToListeners(WebInspector.ContentBrowser.Event.CurrentRepresentedObjectsDidChange)}_contentViewSelectionPathComponentDidChange(_){_.target!==this.currentContentView||(this._updateContentViewSelectionPathNavigationItem(_.target),this._updateBackForwardButtons(),this._updateContentViewNavigationItems(),this._navigationBar.needsLayout(),this.soon._dispatchCurrentRepresentedObjectsDidChangeEvent())}_contentViewSupplementalRepresentedObjectsDidChange(_){_.target!==this.currentContentView||this.soon._dispatchCurrentRepresentedObjectsDidChangeEvent()}_currentContentViewDidChange(){var S=this.currentContentView;this._updateHierarchicalPathNavigationItem(S?S.representedObject:null),this._updateContentViewSelectionPathNavigationItem(S),this._updateBackForwardButtons(),this._updateContentViewNavigationItems(),this._updateFindBanner(S),this._navigationBar.needsLayout(),this.dispatchEventToListeners(WebInspector.ContentBrowser.Event.CurrentContentViewDidChange),this._dispatchCurrentRepresentedObjectsDidChangeEvent()}_contentViewNavigationItemsDidChange(_){if(_.target===this.currentContentView){this._updateContentViewNavigationItems(!0),this._navigationBar.needsLayout()}}_hierarchicalPathComponentWasSelected(_){for(var S=_.data.pathComponent.generalTreeElement,C=S;S&&!WebInspector.ContentView.isViewable(S.representedObject);)S=S.traverseNextTreeElement(!1,C,!1);S&&S.revealAndSelect()}},WebInspector.ContentBrowser.Event={CurrentRepresentedObjectsDidChange:"content-browser-current-represented-objects-did-change",CurrentContentViewDidChange:"content-browser-current-content-view-did-change"},WebInspector.ContentView=class extends WebInspector.View{constructor(_){super(),this._representedObject=_,this.element.classList.add("content-view"),this._parentContainer=null}static createFromRepresentedObject(_,S){if(_ instanceof WebInspector.Frame)return new WebInspector.ResourceClusterContentView(_.mainResource,S);if(_ instanceof WebInspector.Resource)return new WebInspector.ResourceClusterContentView(_,S);if(_ instanceof WebInspector.Script)return new WebInspector.ScriptContentView(_,S);if(_ instanceof WebInspector.CSSStyleSheet)return new WebInspector.TextResourceContentView(_,S);if(_ instanceof WebInspector.Canvas)return new WebInspector.CanvasContentView(_,S);if(_ instanceof WebInspector.TimelineRecording)return new WebInspector.TimelineRecordingContentView(_,S);if(_ instanceof WebInspector.Timeline){var C=_.type;if(C===WebInspector.TimelineRecord.Type.Network)return new WebInspector.NetworkTimelineView(_,S);if(C===WebInspector.TimelineRecord.Type.Layout)return new WebInspector.LayoutTimelineView(_,S);if(C===WebInspector.TimelineRecord.Type.Script)return new WebInspector.ScriptClusterTimelineView(_,S);if(C===WebInspector.TimelineRecord.Type.RenderingFrame)return new WebInspector.RenderingFrameTimelineView(_,S);if(C===WebInspector.TimelineRecord.Type.Memory)return new WebInspector.MemoryTimelineView(_,S);if(C===WebInspector.TimelineRecord.Type.HeapAllocations)return new WebInspector.HeapAllocationsTimelineView(_,S)}if((_ instanceof WebInspector.Breakpoint||_ instanceof WebInspector.IssueMessage)&&_.sourceCodeLocation)return WebInspector.ContentView.createFromRepresentedObject(_.sourceCodeLocation.displaySourceCode,S);if(_ instanceof WebInspector.DOMStorageObject)return new WebInspector.DOMStorageContentView(_,S);if(_ instanceof WebInspector.CookieStorageObject)return new WebInspector.CookieStorageContentView(_,S);if(_ instanceof WebInspector.DatabaseTableObject)return new WebInspector.DatabaseTableContentView(_,S);if(_ instanceof WebInspector.DatabaseObject)return new WebInspector.DatabaseContentView(_,S);if(_ instanceof WebInspector.IndexedDatabase)return new WebInspector.IndexedDatabaseContentView(_,S);if(_ instanceof WebInspector.IndexedDatabaseObjectStore)return new WebInspector.IndexedDatabaseObjectStoreContentView(_,S);if(_ instanceof WebInspector.IndexedDatabaseObjectStoreIndex)return new WebInspector.IndexedDatabaseObjectStoreContentView(_,S);if(_ instanceof WebInspector.ApplicationCacheFrame)return new WebInspector.ApplicationCacheFrameContentView(_,S);if(_ instanceof WebInspector.DOMTree)return new WebInspector.FrameDOMTreeContentView(_,S);if(_ instanceof WebInspector.DOMSearchMatchObject){var f=new WebInspector.FrameDOMTreeContentView(WebInspector.frameResourceManager.mainFrame.domTree,S);return f.restoreFromCookie({nodeToSelect:_.domNode}),f}if(_ instanceof WebInspector.DOMNode&&_.frame){let I=WebInspector.ContentView.createFromRepresentedObject(_.frame,S);return I.restoreFromCookie({nodeToSelect:_}),I}if(_ instanceof WebInspector.SourceCodeSearchMatchObject){var f;_.sourceCode instanceof WebInspector.Resource?f=new WebInspector.ResourceClusterContentView(_.sourceCode,S):_.sourceCode instanceof WebInspector.Script?f=new WebInspector.ScriptContentView(_.sourceCode,S):console.error("Unknown SourceCode",_.sourceCode);var T=_.sourceCodeTextRange.formattedTextRange,E=T.startPosition();return f.restoreFromCookie({lineNumber:E.lineNumber,columnNumber:E.columnNumber}),f}if(_ instanceof WebInspector.LogObject)return new WebInspector.LogContentView(_,S);if(_ instanceof WebInspector.ContentFlow)return new WebInspector.ContentFlowDOMTreeContentView(_,S);if(_ instanceof WebInspector.CallingContextTree)return new WebInspector.ProfileView(_,S);if(_ instanceof WebInspector.HeapSnapshotProxy||_ instanceof WebInspector.HeapSnapshotDiffProxy)return new WebInspector.HeapSnapshotClusterContentView(_,S);if(_ instanceof WebInspector.Collection)return new WebInspector.CollectionContentView(_,S);if("string"==typeof _||_ instanceof String)return new WebInspector.TextContentView(_,S);throw new Error("Can't make a ContentView for an unknown representedObject of type: "+_.constructor.name)}static contentViewForRepresentedObject(_,S,C){let f=WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(_);if(!f)return null;let T=f[WebInspector.ContentView.ContentViewForRepresentedObjectSymbol];if(T)return T;if(S)return null;let E=WebInspector.ContentView.createFromRepresentedObject(_,C);return E?(E.representedObject[WebInspector.ContentView.ContentViewForRepresentedObjectSymbol]=E,E):null}static closedContentViewForRepresentedObject(_){let S=WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(_);S[WebInspector.ContentView.ContentViewForRepresentedObjectSymbol]=null}static resolvedRepresentedObjectForRepresentedObject(_){return _ instanceof WebInspector.Frame?_.mainResource:(_ instanceof WebInspector.Breakpoint||_ instanceof WebInspector.IssueMessage)&&_.sourceCodeLocation?_.sourceCodeLocation.displaySourceCode:_ instanceof WebInspector.DOMBreakpoint&&_.domNode?WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(_.domNode):_ instanceof WebInspector.DOMNode&&_.frame?WebInspector.ContentView.resolvedRepresentedObjectForRepresentedObject(_.frame):_ instanceof WebInspector.DOMSearchMatchObject?WebInspector.frameResourceManager.mainFrame.domTree:_ instanceof WebInspector.SourceCodeSearchMatchObject?_.sourceCode:_}static isViewable(_){return!!(_ instanceof WebInspector.Frame)||!!(_ instanceof WebInspector.Resource)||!!(_ instanceof WebInspector.Script)||!!(_ instanceof WebInspector.CSSStyleSheet)||!!(_ instanceof WebInspector.Canvas)||!!(_ instanceof WebInspector.TimelineRecording)||!!(_ instanceof WebInspector.Timeline)||(_ instanceof WebInspector.Breakpoint||_ instanceof WebInspector.IssueMessage?_.sourceCodeLocation:!!(_ instanceof WebInspector.DOMStorageObject)||!!(_ instanceof WebInspector.CookieStorageObject)||!!(_ instanceof WebInspector.DatabaseTableObject)||!!(_ instanceof WebInspector.DatabaseObject)||!!(_ instanceof WebInspector.IndexedDatabase)||!!(_ instanceof WebInspector.IndexedDatabaseObjectStore)||!!(_ instanceof WebInspector.IndexedDatabaseObjectStoreIndex)||!!(_ instanceof WebInspector.ApplicationCacheFrame)||!!(_ instanceof WebInspector.DOMTree)||!!(_ instanceof WebInspector.DOMSearchMatchObject)||!!(_ instanceof WebInspector.SourceCodeSearchMatchObject)||!!(_ instanceof WebInspector.LogObject)||!!(_ instanceof WebInspector.ContentFlow)||!!(_ instanceof WebInspector.CallingContextTree)||_ instanceof WebInspector.HeapSnapshotProxy||_ instanceof WebInspector.HeapSnapshotDiffProxy||!!(_ instanceof WebInspector.Collection)||"string"==typeof _||_ instanceof String)}get representedObject(){return this._representedObject}get navigationItems(){return[]}get parentContainer(){return this._parentContainer}get visible(){return this._visible}set visible(_){this._visible=_}get scrollableElements(){return[]}get shouldKeepElementsScrolledToBottom(){return!1}get selectionPathComponents(){return[]}get supplementalRepresentedObjects(){return[]}get supportsSplitContentBrowser(){return WebInspector.dockedConfigurationSupportsSplitContentBrowser()}shown(){}hidden(){}closed(){}saveToCookie(){}restoreFromCookie(){}canGoBack(){return!1}canGoForward(){return!1}goBack(){}goForward(){}get supportsSearch(){return!1}get supportsCustomFindBanner(){return!1}showCustomFindBanner(){}get numberOfSearchResults(){return null}get hasPerformedSearch(){return!1}set automaticallyRevealFirstSearchResult(_){}performSearch(){}searchCleared(){}searchQueryWithSelection(){return null}revealPreviousSearchResult(){}revealNextSearchResult(){}},WebInspector.ContentView.Event={SelectionPathComponentsDidChange:"content-view-selection-path-components-did-change",SupplementalRepresentedObjectsDidChange:"content-view-supplemental-represented-objects-did-change",NumberOfSearchResultsDidChange:"content-view-number-of-search-results-did-change",NavigationItemsDidChange:"content-view-navigation-items-did-change"},WebInspector.ContentView.ContentViewForRepresentedObjectSymbol=Symbol("content-view-for-represented-object"),WebInspector.DataGrid=class extends WebInspector.View{constructor(_,S,C,f){if(super(),this.columns=new Map,this.orderedColumns=[],this._settingsIdentifier=null,this._sortColumnIdentifier=null,this._sortColumnIdentifierSetting=null,this._sortOrder=WebInspector.DataGrid.SortOrder.Indeterminate,this._sortOrderSetting=null,this._columnVisibilitySetting=null,this._columnChooserEnabled=!1,this._headerVisible=!0,this._rows=[],this.children=[],this.selectedNode=null,this.expandNodesWhenArrowing=!1,this.root=!0,this.hasChildren=!1,this.expanded=!0,this.revealed=!0,this.selected=!1,this.dataGrid=this,this.indentWidth=15,this.rowHeight=20,this.resizers=[],this._columnWidthsInitialized=!1,this._scrollbarWidth=0,this._cachedScrollTop=NaN,this._cachedScrollableOffsetHeight=NaN,this._previousRevealedRowCount=NaN,this._topDataTableMarginHeight=NaN,this._bottomDataTableMarginHeight=NaN,this._filterText="",this._filterDelegate=null,this._filterDidModifyNodeWhileProcessingItems=!1,this.element.className="data-grid",this.element.tabIndex=0,this.element.addEventListener("keydown",this._keyDown.bind(this),!1),this.element.copyHandler=this,this._headerWrapperElement=document.createElement("div"),this._headerWrapperElement.classList.add("header-wrapper"),this._headerTableElement=document.createElement("table"),this._headerTableElement.className="header",this._headerWrapperElement.appendChild(this._headerTableElement),this._headerTableColumnGroupElement=this._headerTableElement.createChild("colgroup"),this._headerTableBodyElement=this._headerTableElement.createChild("tbody"),this._headerTableRowElement=this._headerTableBodyElement.createChild("tr"),this._headerTableRowElement.addEventListener("contextmenu",this._contextMenuInHeader.bind(this),!0),this._headerTableCellElements=new Map,this._scrollContainerElement=document.createElement("div"),this._scrollContainerElement.className="data-container",this._scrollListener=()=>this._noteScrollPositionChanged(),this._updateScrollListeners(),this._topDataTableMarginElement=this._scrollContainerElement.createChild("div"),this._dataTableElement=this._scrollContainerElement.createChild("table","data"),this._bottomDataTableMarginElement=this._scrollContainerElement.createChild("div"),this._dataTableElement.addEventListener("mousedown",this._mouseDownInDataTable.bind(this)),this._dataTableElement.addEventListener("click",this._clickInDataTable.bind(this)),this._dataTableElement.addEventListener("contextmenu",this._contextMenuInDataTable.bind(this),!0),S&&(this._dataTableElement.addEventListener("dblclick",this._ondblclick.bind(this),!1),this._editCallback=S),C&&(this._deleteCallback=C),this._dataTableColumnGroupElement=this._headerTableColumnGroupElement.cloneNode(!0),this._dataTableElement.appendChild(this._dataTableColumnGroupElement),this.dataTableBodyElement=this._dataTableElement.createChild("tbody"),this._fillerRowElement=this.dataTableBodyElement.createChild("tr","filler"),this.element.appendChild(this._headerWrapperElement),this.element.appendChild(this._scrollContainerElement),f)for(var T of f)this.insertColumn(T,_[T]);else for(var T in _)this.insertColumn(T,_[T]);this._updateScrollbarPadding(),this._copyTextDelimiter="\t"}_updateScrollbarPadding(){if(!this._inline){let _=this._scrollContainerElement.offsetWidth-this._scrollContainerElement.scrollWidth;this._scrollbarWidth===_||(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?this._headerWrapperElement.style.setProperty("padding-left",`${_}px`):this._headerWrapperElement.style.setProperty("padding-right",`${_}px`),this._scrollbarWidth=_)}}static createSortableDataGrid(_,S){var f=_.length;if(!f)return null;var T={};for(var E of _)T[E]={width:E.length,title:E,sortable:!0};for(var I=new WebInspector.DataGrid(T,void 0,void 0,_),R=0,N;R<S.length/f;++R){N={};for(var L=0;L<_.length;++L)N[_[L]]=S[f*R+L];var D=new WebInspector.DataGridNode(N,!1);I.appendChild(D)}return I.addEventListener(WebInspector.DataGrid.Event.SortChanged,function(){var P=I.sortColumnIdentifier,O=!0;for(var F of I.children){var V=I.textForDataGridNodeColumn(F,P);isNaN(+V)&&(O=!1)}I.sortNodes(function(U,G){var H=I.textForDataGridNodeColumn(U,P),W=I.textForDataGridNodeColumn(G,P),z;if(O){var K=parseFloat(H),q=parseFloat(W);z=K<q?-1:K>q?1:0}else z=H<W?-1:H>W?1:0;return z})},this),I.sortOrder=WebInspector.DataGrid.SortOrder.Ascending,I.sortColumnIdentifier=_[0],I}get headerVisible(){return this._headerVisible}set headerVisible(_){_===this._headerVisible||(this._headerVisible=_,this.element.classList.toggle("no-header",!this._headerVisible))}get columnChooserEnabled(){return this._columnChooserEnabled}set columnChooserEnabled(_){this._columnChooserEnabled=_}get refreshCallback(){return this._refreshCallback}set refreshCallback(_){this._refreshCallback=_}get sortOrder(){return this._sortOrder}set sortOrder(_){if(_&&_!==this._sortOrder&&(this._sortOrder=_,this._sortOrderSetting&&(this._sortOrderSetting.value=this._sortOrder),!!this._sortColumnIdentifier)){var S=this._headerTableCellElements.get(this._sortColumnIdentifier);S.classList.toggle(WebInspector.DataGrid.SortColumnAscendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Ascending),S.classList.toggle(WebInspector.DataGrid.SortColumnDescendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Descending),this.dispatchEventToListeners(WebInspector.DataGrid.Event.SortChanged)}}get sortColumnIdentifier(){return this._sortColumnIdentifier}set sortColumnIdentifier(_){if(this._sortColumnIdentifier!==_){let S=this._sortColumnIdentifier;this._sortColumnIdentifier=_,this._updateSortedColumn(S)}}get inline(){return this._inline}set inline(_){this._inline===_||(this._inline=_||!1,this._element.classList.toggle("inline",this._inline),this._updateScrollListeners())}get variableHeightRows(){return this._variableHeightRows}set variableHeightRows(_){this._variableHeightRows===_||(this._variableHeightRows=_||!1,this._element.classList.toggle("variable-height-rows",this._variableHeightRows),this._updateScrollListeners())}get filterText(){return this._filterText}set filterText(_){this._filterText===_||(this._filterText=_,this.filterDidChange())}get filterDelegate(){return this._filterDelegate}set filterDelegate(_){this._filterDelegate=_,this.filterDidChange()}filterDidChange(){this._scheduledFilterUpdateIdentifier||(this._applyFilterToNodesTask&&(this._applyFilterToNodesTask.cancel(),this._applyFilterToNodesTask=null),this._scheduledFilterUpdateIdentifier=requestAnimationFrame(this._updateFilter.bind(this)))}hasFilters(){return this._textFilterRegex||this._hasFilterDelegate()}matchNodeAgainstCustomFilters(_){return!this._hasFilterDelegate()||this._filterDelegate.dataGridMatchNodeAgainstCustomFilters(_)}createSettings(_){if(this._settingsIdentifier!==_&&(this._settingsIdentifier=_,this._sortColumnIdentifierSetting=new WebInspector.Setting(this._settingsIdentifier+"-sort",this._sortColumnIdentifier),this._sortOrderSetting=new WebInspector.Setting(this._settingsIdentifier+"-sort-order",this._sortOrder),this._columnVisibilitySetting=new WebInspector.Setting(this._settingsIdentifier+"-column-visibility",{}),!!this.columns)){this._sortColumnIdentifierSetting.value&&(this.sortColumnIdentifier=this._sortColumnIdentifierSetting.value,this.sortOrder=this._sortOrderSetting.value);let S=this._columnVisibilitySetting.value;for(let C in S){let f=S[C];this.setColumnVisible(C,f)}}}_updateScrollListeners(){this._inline||this._variableHeightRows?(this._scrollContainerElement.removeEventListener("scroll",this._scrollListener),this._scrollContainerElement.removeEventListener("mousewheel",this._scrollListener)):(this._scrollContainerElement.addEventListener("scroll",this._scrollListener),this._scrollContainerElement.addEventListener("mousewheel",this._scrollListener))}_applyFiltersToNodeAndDispatchEvent(_){const S=_.hidden;return this._applyFiltersToNode(_),S!==_.hidden&&this.dispatchEventToListeners(WebInspector.DataGrid.Event.NodeWasFiltered,{node:_}),S!==_.hidden}_applyFiltersToNode(_){if(!this.hasFilters())return _.hidden=!1,void(_.expanded&&_[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]&&(_[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]=!1,_.collapse()));let f=_.filterableData||[],T={expandNode:!1},E=this._textFilterRegex;return function(){return f.length&&E?!!f.some(I=>E.test(I))&&(T.expandNode=!0,!0):!0}()&&this.matchNodeAgainstCustomFilters(_)?(function(){_.hidden=!1;for(let I=_.parent;I&&!I.root;)I.hidden=!1,T.expandNode&&!I.expanded&&(I[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]=!0,I.expand()),I=I.parent}(),void(!T.expandNode&&_.expanded&&_[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]&&(_[WebInspector.DataGrid.WasExpandedDuringFilteringSymbol]=!1,_.collapse()))):void(_.hidden=!0)}_updateSortedColumn(_){if(this._sortColumnIdentifierSetting&&(this._sortColumnIdentifierSetting.value=this._sortColumnIdentifier),_){let S=this._headerTableCellElements.get(_);S.classList.remove(WebInspector.DataGrid.SortColumnAscendingStyleClassName),S.classList.remove(WebInspector.DataGrid.SortColumnDescendingStyleClassName)}if(this._sortColumnIdentifier){let S=this._headerTableCellElements.get(this._sortColumnIdentifier);S.classList.toggle(WebInspector.DataGrid.SortColumnAscendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Ascending),S.classList.toggle(WebInspector.DataGrid.SortColumnDescendingStyleClassName,this._sortOrder===WebInspector.DataGrid.SortOrder.Descending)}this.dispatchEventToListeners(WebInspector.DataGrid.Event.SortChanged)}_hasFilterDelegate(){return this._filterDelegate&&"function"==typeof this._filterDelegate.dataGridMatchNodeAgainstCustomFilters}_ondblclick(_){this._editing||this._editingNode||this._startEditing(_.target)}_startEditingNodeAtColumnIndex(_,S){this._editing=!0,this._editingNode=_,this._editingNode.select();var C=this._editingNode._element.children[S];WebInspector.startEditing(C,this._startEditingConfig(C)),window.getSelection().setBaseAndExtent(C,0,C,1)}_startEditing(_){var S=_.enclosingNodeOrSelfWithNodeName("td");if(S){if(this._editingNode=this.dataGridNodeFromNode(_),!this._editingNode){if(!this.placeholderNode)return;this._editingNode=this.placeholderNode}return this._editingNode.isPlaceholderNode?this._startEditingNodeAtColumnIndex(this._editingNode,0):void(this._editing=!0,WebInspector.startEditing(S,this._startEditingConfig(S)),window.getSelection().setBaseAndExtent(S,0,S,1))}}_startEditingConfig(_){return new WebInspector.EditingConfig(this._editingCommitted.bind(this),this._editingCancelled.bind(this),_.textContent)}_editingCommitted(_,S,C,f,T){function E(){if("forward"===T){if(N<this.orderedColumns.length-1)return{shouldSort:!1,editingNode:D,columnIndex:N+1};var O=D.traverseNextNode(!0,null,!0);return{shouldSort:!0,editingNode:O||D,columnIndex:0}}if("backward"===T){if(0<N)return{shouldSort:!1,editingNode:D,columnIndex:N-1};var F=D.traversePreviousNode(!0,null,!0);return{shouldSort:!0,editingNode:F||D,columnIndex:this.orderedColumns.length-1}}return{shouldSort:!0}}var R=_.__columnIdentifier,N=this.orderedColumns.indexOf(R),L=this._editingNode.data[R]||"",D=this._editingNode;this._editingCancelled(_),D.data[R]=S.trim(),this._editCallback(D,R,L,S,T);var M=L.trim()!==S.trim();(function(P){var O=E.call(this,P);O.shouldSort&&this._sortAfterEditingCallback&&(this._sortAfterEditingCallback(),this._sortAfterEditingCallback=null),O.editingNode&&this._startEditingNodeAtColumnIndex(O.editingNode,O.columnIndex)}).call(this,M)}_editingCancelled(){this._editingNode.refresh(),this._editing=!1,this._editingNode=null}autoSizeColumns(_,S,C){_&&(_=Math.min(_,Math.floor(100/this.orderedColumns.length)));var f={};for(var[T,E]of this.columns)f[T]=(E.title||"").length;var I=C?this._enumerateChildren(this,[],C+1):this.children;for(var R of I)for(var T of this.columns.keys()){var N=this.textForDataGridNodeColumn(R,T);N.length>f[T]&&(f[T]=N.length)}var L=0;for(var T of this.columns.keys())L+=f[T];var D=0;for(var T of this.columns.keys()){var M=Math.round(100*f[T]/L);_&&M<_?(D+=_-M,M=_):S&&M>S&&(D-=M-S,M=S),f[T]=M}for(;_&&0<D;)for(var T of this.columns.keys())if(f[T]>_&&(--f[T],--D,!D))break;for(;S&&0>D;)for(var T of this.columns.keys())if(f[T]<S&&(++f[T],++D,!D))break;for(var[T,E]of this.columns)E.element.style.width=f[T]+"%",E.bodyElement.style.width=f[T]+"%";this._columnWidthsInitialized=!1,this.needsLayout()}insertColumn(_,S,C){void 0===C&&(C=this.orderedColumns.length),C=Number.constrain(C,0,this.orderedColumns.length);var f=new WebInspector.EventListenerSet(this,"DataGrid column DOM listeners"),T=Object.shallowCopy(S);T.listeners=f,T.ordinal=C,T.columnIdentifier=_,this.orderedColumns.splice(C,0,_);for(var[E,I]of this.columns){var R=I.ordinal;R>=C&&(I.ordinal=R+1)}this.columns.set(_,T),T.disclosure&&(this.disclosureColumnIdentifier=_);var N=document.createElement("col");T.width&&(N.style.width=T.width),T.element=N;var L=this._headerTableColumnGroupElement.children[C];this._headerTableColumnGroupElement.insertBefore(N,L);var D=document.createElement("th");D.className=_+"-column",D.columnIdentifier=_,T.aligned&&D.classList.add(T.aligned),this._headerTableCellElements.set(_,D);var L=this._headerTableRowElement.children[C];if(this._headerTableRowElement.insertBefore(D,L),T.headerView){let F=T.headerView;D.appendChild(F.element),this.addSubview(F)}else{let F=D.createChild("div");T.titleDOMFragment?F.appendChild(T.titleDOMFragment):F.textContent=T.title||""}if(T.sortable&&(f.register(D,"click",this._headerCellClicked),D.classList.add(WebInspector.DataGrid.SortableColumnStyleClassName)),T.group&&D.classList.add("column-group-"+T.group),T.tooltip&&(D.title=T.tooltip),T.collapsesGroup){D.createChild("div","divider");var M=D.createChild("div","collapser-button");M.title=this._collapserButtonCollapseColumnsToolTip(),f.register(M,"mouseover",this._mouseoverColumnCollapser),f.register(M,"mouseout",this._mouseoutColumnCollapser),f.register(M,"click",this._clickInColumnCollapser),D.collapsesGroup=T.collapsesGroup,D.classList.add("collapser")}this._headerTableColumnGroupElement.span=this.orderedColumns.length;var P=N.cloneNode(),L=this._dataTableColumnGroupElement.children[C];this._dataTableColumnGroupElement.insertBefore(P,L),T.bodyElement=P;var O=document.createElement("td");O.className=_+"-column",O.__columnIdentifier=_,T.group&&O.classList.add("column-group-"+T.group);var L=this._fillerRowElement.children[C];this._fillerRowElement.insertBefore(O,L),f.install(),this.setColumnVisible(_,!T.hidden)}removeColumn(_){var S=this.columns.get(_);this.columns.delete(_),this.orderedColumns.splice(this.orderedColumns.indexOf(_),1);var C=S.ordinal;for(var[f,T]of this.columns){var E=T.ordinal;E>C&&(T.ordinal=E-1)}S.listeners.uninstall(!0),S.disclosure&&(this.disclosureColumnIdentifier=void 0),this.sortColumnIdentifier===_&&(this.sortColumnIdentifier=null),this._headerTableCellElements.delete(_),this._headerTableRowElement.children[C].remove(),this._headerTableColumnGroupElement.children[C].remove(),this._dataTableColumnGroupElement.children[C].remove(),this._fillerRowElement.children[C].remove(),this._headerTableColumnGroupElement.span=this.orderedColumns.length;for(var I of this.children)I.refresh()}_enumerateChildren(_,S,C){if(_.root||S.push(_),!!C){for(var f=0;f<_.children.length;++f)this._enumerateChildren(_.children[f],S,C-1);return S}}layout(){if(!this._columnWidthsInitialized&&this.element.offsetWidth){let _=this._headerTableColumnGroupElement.children,S=this._dataTableElement.offsetWidth,C=_.length,f=this._headerTableBodyElement.rows[0].cells,T=[];for(let E=0,I;E<C;++E)if(I=f[E],this._isColumnVisible(I.columnIdentifier)){let R=I.offsetWidth;T.push(100*(R/S)+"%")}else T.push(0);for(let E=0,I;E<C;E++)I=T[E],this._headerTableColumnGroupElement.children[E].style.width=I,this._dataTableColumnGroupElement.children[E].style.width=I;this._columnWidthsInitialized=!0,this._updateHeaderAndScrollbar()}this._updateVisibleRows()}sizeDidChange(){this._updateHeaderAndScrollbar()}_updateHeaderAndScrollbar(){this._positionResizerElements(),this._positionHeaderViews(),this._updateScrollbarPadding(),this._cachedScrollTop=NaN,this._cachedScrollableOffsetHeight=NaN}columnWidthsMap(){var _={};for(var[S,C]of this.columns){var f=this._headerTableColumnGroupElement.children[C.ordinal].style.width;_[S]=parseFloat(f)}return _}applyColumnWidthsMap(_){for(var[S,C]of this.columns){var f=(_[S]||0)+"%",T=C.ordinal;this._headerTableColumnGroupElement.children[T].style.width=f,this._dataTableColumnGroupElement.children[T].style.width=f}this.needsLayout()}_isColumnVisible(_){return!this.columns.get(_).hidden}setColumnVisible(_,S){let C=this.columns.get(_);if(C&&S!==!C.hidden){if(C.element.style.width=S?C.width:0,C.hidden=!S,this._columnVisibilitySetting&&this._columnVisibilitySetting.value[_]!==S){let f=Object.shallowCopy(this._columnVisibilitySetting.value);f[_]=S,this._columnVisibilitySetting.value=f}this._columnWidthsInitialized=!1,this.updateLayout()}}get scrollContainer(){return this._scrollContainerElement}isScrolledToLastRow(){return this._scrollContainerElement.isScrolledToBottom()}scrollToLastRow(){this._scrollContainerElement.scrollTop=this._scrollContainerElement.scrollHeight-this._scrollContainerElement.offsetHeight}_positionResizerElements(){let _=0;for(var S=null,C=this.orderedColumns.length-1,f=this._headerTableBodyElement.rows[0].cells,T=[],E=0;E<C;++E)_+=f[E].getBoundingClientRect().width,T.push(_);for(var E=0,I;E<C;++E)I=this.resizers[E],I||(I=this.resizers[E]=new WebInspector.Resizer(WebInspector.Resizer.RuleOrientation.Vertical,this),this.element.appendChild(I.element)),_=T[E],this._isColumnVisible(this.orderedColumns[E])?(I.element.style.removeProperty("display"),I.element.style.setProperty(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?"right":"left",`${_}px`),I[WebInspector.DataGrid.PreviousColumnOrdinalSymbol]=E,S&&(S[WebInspector.DataGrid.NextColumnOrdinalSymbol]=E),S=I):(I.element.style.setProperty("display","none"),I[WebInspector.DataGrid.PreviousColumnOrdinalSymbol]=0,I[WebInspector.DataGrid.NextColumnOrdinalSymbol]=0);S&&(S[WebInspector.DataGrid.NextColumnOrdinalSymbol]=this.orderedColumns.length-1)}_positionHeaderViews(){let _=0,S=[],C=[],f=[];for(let T of this.orderedColumns){let E=this.columns.get(T);if(E){let H=this._headerTableCellElements.get(T).offsetWidth,W=E.headerView;W&&(S.push(W),C.push(_),f.push(H)),_+=H}}for(let T=0,E;T<S.length;++T)E=S[T],E.element.style.setProperty(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?"right":"left",`${C[T]}px`),E.element.style.width=f[T]+"px",E.updateLayout(WebInspector.View.LayoutReason.Resize)}_noteRowsChanged(){this._previousRevealedRowCount=NaN,this.needsLayout()}_noteRowRemoved(_){return this._inline||this._variableHeightRows?void(_.element&&_.element.parentNode&&_.element.parentNode.removeChild(_.element)):void this._noteRowsChanged()}_noteScrollPositionChanged(){this._cachedScrollTop=NaN,this.needsLayout()}_updateVisibleRows(){if(this._inline||this._variableHeightRows){let U=this.dataTableBodyElement.lastChild;for(let G=this._rows.length-1,H;0<=G;--G)H=this._rows[G].element,H.nextSibling!==U&&this.dataTableBodyElement.insertBefore(H,U),U=H;return}let _=this.rowHeight,S=5*_,C=3*S;isNaN(this._cachedScrollTop)&&(this._cachedScrollTop=this._scrollContainerElement.scrollTop),isNaN(this._cachedScrollableOffsetHeight)&&(this._cachedScrollableOffsetHeight=this._scrollContainerElement.offsetHeight);let f=this._cachedScrollTop,T=this._cachedScrollableOffsetHeight,E=Math.ceil((T+2*C)/_),I=this._topDataTableMarginHeight,R=this._bottomDataTableMarginHeight;if(!((!I||f>I+S)&&(!R||f+T<I+E*_-S)&&!isNaN(this._previousRevealedRowCount))){let M=this._rows.filter(U=>U.revealed&&!U.hidden);this._previousRevealedRowCount=M.length;let P=Math.max(0,Math.floor((f-C)/_)),O=Math.max(0,this._previousRevealedRowCount-P-E),F=P*_,V=O*_;this._topDataTableMarginHeight!==F&&(this._topDataTableMarginHeight=F,this._topDataTableMarginElement.style.height=F+"px"),this._bottomDataTableMarginElement!==V&&(this._bottomDataTableMarginHeight=V,this._bottomDataTableMarginElement.style.height=V+"px"),this._dataTableElement.classList.toggle("odd-first-zebra-stripe",!!(P%2)),this.dataTableBodyElement.removeChildren();for(let U=P,G;U<P+E;++U)G=M[U],G&&this.dataTableBodyElement.appendChild(G.element);this.dataTableBodyElement.appendChild(this._fillerRowElement)}}addPlaceholderNode(){this.placeholderNode&&this.placeholderNode.makeNormal();var _={};for(var S of this.columns.keys())_[S]="";this.placeholderNode=new WebInspector.PlaceholderDataGridNode(_),this.appendChild(this.placeholderNode)}appendChild(_){this.insertChild(_,this.children.length)}insertChild(_,S){if(_&&_.parent!==this){_.parent&&_.parent.removeChild(_),this.children.splice(S,0,_),this.hasChildren=!0,_.parent=this,_.dataGrid=this.dataGrid,_._recalculateSiblings(S),delete _._depth,delete _._revealed,delete _._attached,delete _._leftPadding,_._shouldRefreshChildren=!0;for(var C=_.children[0];C;)C.dataGrid=this.dataGrid,delete C._depth,delete C._revealed,delete C._attached,delete C._leftPadding,C._shouldRefreshChildren=!0,C=C.traverseNextNode(!1,_,!0);this.expanded&&_._attach(),this.dataGrid.hasFilters()&&this.dataGrid._applyFiltersToNodeAndDispatchEvent(_)}}removeChild(_){_&&_.parent===this&&(_.deselect(),_._detach(),this.children.remove(_,!0),_.previousSibling&&(_.previousSibling.nextSibling=_.nextSibling),_.nextSibling&&(_.nextSibling.previousSibling=_.previousSibling),_.dataGrid=null,_.parent=null,_.nextSibling=null,_.previousSibling=null,0>=this.children.length&&(this.hasChildren=!1))}removeChildren(){for(var _=0,S;_<this.children.length;++_)S=this.children[_],S.deselect(),S._detach(),S.dataGrid=null,S.parent=null,S.nextSibling=null,S.previousSibling=null;this.children=[],this.hasChildren=!1}removeChildrenRecursive(){for(var _=this.children,S=this.children[0];S;)S.children.length&&(_=_.concat(S.children)),S=S.traverseNextNode(!1,this,!0);for(var C=0;C<_.length;++C)S=_[C],S.deselect(),S._detach(),S.children=[],S.dataGrid=null,S.parent=null,S.nextSibling=null,S.previousSibling=null;this.children=[]}findNode(_,S,C,f){for(let T=this._rows[0];T&&!T.root;){if(!T.isPlaceholderNode&&!(S&&T.hidden)&&_(T))return T;T=T.traverseNextNode(S,C,f)}return null}sortNodes(_){this._sortNodesRequestId||(this._sortNodesRequestId=window.requestAnimationFrame(this._sortNodesCallback.bind(this,_)))}sortNodesImmediately(_){this._sortNodesCallback(_)}_sortNodesCallback(_){if(this._sortNodesRequestId=void 0,this._editing)return void(this._sortAfterEditingCallback=this.sortNodes.bind(this,_));this._rows.sort(function(f,T){if(f.isPlaceholderNode)return 1;if(T.isPlaceholderNode)return-1;var E=this.sortOrder===WebInspector.DataGrid.SortOrder.Ascending?1:-1;return E*_(f,T)}.bind(this)),this._noteRowsChanged();let C=null;for(let f of this._rows)f.previousSibling=C,C&&(C.nextSibling=f),C=f;C&&(C.nextSibling=null),this.parentView||this.updateLayoutIfNeeded()}_toggledSortOrder(){return this._sortOrder===WebInspector.DataGrid.SortOrder.Descending?WebInspector.DataGrid.SortOrder.Ascending:WebInspector.DataGrid.SortOrder.Descending}_selectSortColumnAndSetOrder(_,S){this.sortColumnIdentifier=_,this.sortOrder=S}_keyDown(_){if(!(!this.selectedNode||_.shiftKey||_.metaKey||_.ctrlKey||this._editing)){let S=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;var C=!1,f;if("Up"===_.keyIdentifier&&!_.altKey){for(f=this.selectedNode.traversePreviousNode(!0);f&&!f.selectable;)f=f.traversePreviousNode(!0);C=!!f}else if("Down"===_.keyIdentifier&&!_.altKey){for(f=this.selectedNode.traverseNextNode(!0);f&&!f.selectable;)f=f.traverseNextNode(!0);C=!!f}else!S&&"Left"===_.keyIdentifier||S&&"Right"===_.keyIdentifier?this.selectedNode.expanded?(_.altKey?this.selectedNode.collapseRecursively():this.selectedNode.collapse(),C=!0):this.selectedNode.parent&&!this.selectedNode.parent.root&&(C=!0,this.selectedNode.parent.selectable?(f=this.selectedNode.parent,C=!!f):this.selectedNode.parent&&this.selectedNode.parent.collapse()):!S&&"Right"===_.keyIdentifier||S&&"Left"===_.keyIdentifier?this.selectedNode.revealed?this.selectedNode.hasChildren&&(C=!0,this.selectedNode.expanded?(f=this.selectedNode.children[0],C=!!f):_.altKey?this.selectedNode.expandRecursively():this.selectedNode.expand()):(this.selectedNode.reveal(),C=!0):8===_.keyCode||46===_.keyCode?this._deleteCallback&&(C=!0,this._deleteCallback(this.selectedNode)):isEnterKey(_)&&this._editCallback&&(C=!0,this._startEditing(this.selectedNode._element.children[0]));f&&(f.reveal(),f.select()),C&&(_.preventDefault(),_.stopPropagation())}}closed(){}expand(){}collapse(){}reveal(){}revealAndSelect(){}dataGridNodeFromNode(_){var S=_.enclosingNodeOrSelfWithNodeName("tr");return S&&S._dataGridNode}dataGridNodeFromPoint(_,S){var C=this._dataTableElement.ownerDocument.elementFromPoint(_,S),f=C.enclosingNodeOrSelfWithNodeName("tr");return f&&f._dataGridNode}_headerCellClicked(_){let S=_.target.enclosingNodeOrSelfWithNodeName("th");if(S&&S.columnIdentifier&&S.classList.contains(WebInspector.DataGrid.SortableColumnStyleClassName)){let C=this._sortColumnIdentifier===S.columnIdentifier?this._toggledSortOrder():this.sortOrder;this._selectSortColumnAndSetOrder(S.columnIdentifier,C)}}_mouseoverColumnCollapser(_){var S=_.target.enclosingNodeOrSelfWithNodeName("th");S&&S.collapsesGroup&&S.classList.add("mouse-over-collapser")}_mouseoutColumnCollapser(_){var S=_.target.enclosingNodeOrSelfWithNodeName("th");S&&S.collapsesGroup&&S.classList.remove("mouse-over-collapser")}_clickInColumnCollapser(_){var S=_.target.enclosingNodeOrSelfWithNodeName("th");S&&S.collapsesGroup&&(this._collapseColumnGroupWithCell(S),_.stopPropagation(),_.preventDefault())}collapseColumnGroup(_){var S=null;for(var[C,f]of this.columns)if(f.collapsesGroup===_){S=C;break}if(S){var T=this._headerTableCellElements.get(S);this._collapseColumnGroupWithCell(T)}}_collapseColumnGroupWithCell(_){var S=_.classList.toggle("collapsed");this.willToggleColumnGroup(_.collapsesGroup,S);for(var[C,f]of this.columns)f.group===_.collapsesGroup&&this.setColumnVisible(C,!S);var T=_.querySelector(".collapser-button");T&&(T.title=S?this._collapserButtonExpandColumnsToolTip():this._collapserButtonCollapseColumnsToolTip()),this.didToggleColumnGroup(_.collapsesGroup,S)}_collapserButtonCollapseColumnsToolTip(){return WebInspector.UIString("Collapse columns")}_collapserButtonExpandColumnsToolTip(){return WebInspector.UIString("Expand columns")}willToggleColumnGroup(){}didToggleColumnGroup(){}headerTableHeader(_){return this._headerTableCellElements.get(_)}_mouseDownInDataTable(_){var S=this.dataGridNodeFromNode(_.target);S&&S.selectable&&!S.isEventWithinDisclosureTriangle(_)&&(_.metaKey?S.selected?S.deselect():S.select():S.select())}_contextMenuInHeader(_){let S=WebInspector.ContextMenu.createFromEvent(_);this._hasCopyableData()&&S.appendItem(WebInspector.UIString("Copy Table"),this._copyTable.bind(this));let C=_.target.enclosingNodeOrSelfWithNodeName("th");if(C){let f=C.columnIdentifier,T=this.columns.get(f);if(T&&(T.sortable&&(S.appendSeparator(),(this.sortColumnIdentifier!==f||this.sortOrder!==WebInspector.DataGrid.SortOrder.Ascending)&&S.appendItem(WebInspector.UIString("Sort Ascending"),()=>{this._selectSortColumnAndSetOrder(f,WebInspector.DataGrid.SortOrder.Ascending)}),(this.sortColumnIdentifier!==f||this.sortOrder!==WebInspector.DataGrid.SortOrder.Descending)&&S.appendItem(WebInspector.UIString("Sort Descending"),()=>{this._selectSortColumnAndSetOrder(f,WebInspector.DataGrid.SortOrder.Descending)})),this._columnChooserEnabled)){let E=!1;for(let[I,R]of this.columns)R.locked||(E||(S.appendSeparator(),E=!0),S.appendCheckboxItem(R.title,()=>{this.setColumnVisible(I,!!R.hidden)},!R.hidden))}}}_contextMenuInDataTable(_){let S=WebInspector.ContextMenu.createFromEvent(_),C=this.dataGridNodeFromNode(_.target);if(C&&C.appendContextMenuItems(S),this.dataGrid._refreshCallback&&(!C||C!==this.placeholderNode)&&S.appendItem(WebInspector.UIString("Refresh"),this._refreshCallback.bind(this)),C){if(C.selectable&&C.copyable&&!C.isEventWithinDisclosureTriangle(_)){if(S.appendItem(WebInspector.UIString("Copy Row"),this._copyRow.bind(this,_.target)),S.appendItem(WebInspector.UIString("Copy Table"),this._copyTable.bind(this)),this.dataGrid._editCallback)if(C===this.placeholderNode)S.appendItem(WebInspector.UIString("Add New"),this._startEditing.bind(this,_.target));else{let f=_.target.enclosingNodeOrSelfWithNodeName("td"),T=f.__columnIdentifier,E=this.dataGrid.columns.get(T).title;S.appendItem(WebInspector.UIString("Edit \u201C%s\u201D").format(E),this._startEditing.bind(this,_.target))}this.dataGrid._deleteCallback&&C!==this.placeholderNode&&S.appendItem(WebInspector.UIString("Delete"),this._deleteCallback.bind(this,C))}(C.children.some(f=>f.hasChildren)||C.hasChildren&&!C.children.length)&&(S.appendSeparator(),S.appendItem(WebInspector.UIString("Expand All"),C.expandRecursively.bind(C)),S.appendItem(WebInspector.UIString("Collapse All"),C.collapseRecursively.bind(C)))}}_clickInDataTable(_){var S=this.dataGridNodeFromNode(_.target);S&&S.hasChildren&&S.isEventWithinDisclosureTriangle(_)&&(S.expanded?_.altKey?S.collapseRecursively():S.collapse():_.altKey?S.expandRecursively():S.expand())}textForDataGridNodeColumn(_,S){var C=_.data[S];return(C instanceof Node?C.textContent:C)||""}set copyTextDelimiter(_){this._copyTextDelimiter=_}_copyTextForDataGridNode(_){let S=_.dataGrid.orderedColumns.map(C=>this.textForDataGridNodeColumn(_,C));return S.join(this._copyTextDelimiter)}_copyTextForDataGridHeaders(){let _=this.orderedColumns.map(S=>this.headerTableHeader(S).textContent);return _.join(this._copyTextDelimiter)}handleBeforeCopyEvent(_){this.selectedNode&&window.getSelection().isCollapsed&&_.preventDefault()}handleCopyEvent(_){if(this.selectedNode&&window.getSelection().isCollapsed){var S=this._copyTextForDataGridNode(this.selectedNode);_.clipboardData.setData("text/plain",S),_.stopPropagation(),_.preventDefault()}}_copyRow(_){var S=this.dataGridNodeFromNode(_);if(S){var C=this._copyTextForDataGridNode(S);InspectorFrontendHost.copyText(C)}}_copyTable(){let _=[this._copyTextForDataGridHeaders()];for(let S of this.children)S.copyable&&_.push(this._copyTextForDataGridNode(S));InspectorFrontendHost.copyText(_.join("\n"))}_hasCopyableData(){let _=this.children[0];return _&&_.selectable&&_.copyable}get resizeMethod(){return this._resizeMethod?this._resizeMethod:WebInspector.DataGrid.ResizeMethod.Nearest}set resizeMethod(_){this._resizeMethod=_}resizerDragStarted(_){return!_[WebInspector.DataGrid.NextColumnOrdinalSymbol]||void(this._currentResizer=_)}resizerDragging(_,S){if(_===this._currentResizer){let C=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;C&&(S*=-1);let f=0;f+=C?this.element.totalOffsetRight-_.initialPosition-S:_.initialPosition-this.element.totalOffsetLeft-S;var T=_[WebInspector.DataGrid.PreviousColumnOrdinalSymbol],E=_[WebInspector.DataGrid.NextColumnOrdinalSymbol],I=this._headerTableBodyElement.rows[0].cells;let R=0;for(let H=0;H<T;++H)R+=I[H].offsetWidth;this.resizeMethod===WebInspector.DataGrid.ResizeMethod.Last?E=this.resizers.length:this.resizeMethod===WebInspector.DataGrid.ResizeMethod.First&&(R+=I[T].offsetWidth-I[0].offsetWidth,T=0);let N=R+I[T].offsetWidth+I[E].offsetWidth,L=R+WebInspector.DataGrid.ColumnResizePadding,D=N-WebInspector.DataGrid.ColumnResizePadding;f=Number.constrain(f,L,D),_.element.style.setProperty(C?"right":"left",`${f-this.CenterResizerOverBorderAdjustment}px`);let M=100*((f-R)/this._dataTableElement.offsetWidth)+"%";this._headerTableColumnGroupElement.children[T].style.width=M,this._dataTableColumnGroupElement.children[T].style.width=M;let P=100*((N-f)/this._dataTableElement.offsetWidth)+"%";this._headerTableColumnGroupElement.children[E].style.width=P,this._dataTableColumnGroupElement.children[E].style.width=P,this._positionResizerElements(),this._positionHeaderViews();for(let V=this.orderedColumns[T],U=this.orderedColumns[E],G=this.children[0];G;)G.didResizeColumn(V),G.didResizeColumn(U),G=G.traverseNextNode(!0,this,!0);event.preventDefault()}}resizerDragEnded(_){_!==this._currentResizer||(this._currentResizer=null)}_updateFilter(){function*_(){for(let C=!this.hasFilters(),f=this._rows[0];f&&!f.root;)yield f,f=f.traverseNextNode(!1,null,C)}if(this._scheduledFilterUpdateIdentifier&&(cancelAnimationFrame(this._scheduledFilterUpdateIdentifier),this._scheduledFilterUpdateIdentifier=void 0),!!this._rows.length){this._textFilterRegex=simpleGlobStringToRegExp(this._filterText,"i"),this._applyFilterToNodesTask&&this._applyFilterToNodesTask.processing&&this._applyFilterToNodesTask.cancel();let S=_.call(this);this._applyFilterToNodesTask=new WebInspector.YieldableTask(this,S,{workInterval:100}),this._filterDidModifyNodeWhileProcessingItems=!1,this._applyFilterToNodesTask.start()}}yieldableTaskWillProcessItem(_,S){let C=this._applyFiltersToNodeAndDispatchEvent(S);C&&(this._filterDidModifyNodeWhileProcessingItems=!0)}yieldableTaskDidYield(){this._filterDidModifyNodeWhileProcessingItems&&(this._filterDidModifyNodeWhileProcessingItems=!1,this.dispatchEventToListeners(WebInspector.DataGrid.Event.FilterDidChange))}yieldableTaskDidFinish(){this._applyFilterToNodesTask=null}},WebInspector.DataGrid.Event={SortChanged:"datagrid-sort-changed",SelectedNodeChanged:"datagrid-selected-node-changed",ExpandedNode:"datagrid-expanded-node",CollapsedNode:"datagrid-collapsed-node",FilterDidChange:"datagrid-filter-did-change",NodeWasFiltered:"datagrid-node-was-filtered"},WebInspector.DataGrid.ResizeMethod={Nearest:"nearest",First:"first",Last:"last"},WebInspector.DataGrid.SortOrder={Indeterminate:"data-grid-sort-order-indeterminate",Ascending:"data-grid-sort-order-ascending",Descending:"data-grid-sort-order-descending"},WebInspector.DataGrid.PreviousColumnOrdinalSymbol=Symbol("previous-column-ordinal"),WebInspector.DataGrid.NextColumnOrdinalSymbol=Symbol("next-column-ordinal"),WebInspector.DataGrid.WasExpandedDuringFilteringSymbol=Symbol("was-expanded-during-filtering"),WebInspector.DataGrid.ColumnResizePadding=10,WebInspector.DataGrid.CenterResizerOverBorderAdjustment=3,WebInspector.DataGrid.SortColumnAscendingStyleClassName="sort-ascending",WebInspector.DataGrid.SortColumnDescendingStyleClassName="sort-descending",WebInspector.DataGrid.SortableColumnStyleClassName="sortable",WebInspector.DataGridNode=class extends WebInspector.Object{constructor(_,S){super(),this._expanded=!1,this._hidden=!1,this._selected=!1,this._copyable=!0,this._shouldRefreshChildren=!0,this._data=_||{},this.hasChildren=S||!1,this.children=[],this.dataGrid=null,this.parent=null,this.previousSibling=null,this.nextSibling=null,this.disclosureToggleWidth=10}get hidden(){return this._hidden}set hidden(_){_=!!_;this._hidden===_||(this._hidden=_,this._element&&this._element.classList.toggle("hidden",this._hidden),this.dataGrid&&this.dataGrid._noteRowsChanged())}get selectable(){return this._element&&!this._hidden}get copyable(){return this._copyable}set copyable(_){this._copyable=_}get element(){return this._element?this._element:this.dataGrid?(this._element=document.createElement("tr"),this._element._dataGridNode=this,this.hasChildren&&this._element.classList.add("parent"),this.expanded&&this._element.classList.add("expanded"),this.selected&&this._element.classList.add("selected"),this.revealed&&this._element.classList.add("revealed"),this._hidden&&this._element.classList.add("hidden"),this.createCells(),this._element):null}createCells(){for(var _ of this.dataGrid.orderedColumns)this._element.appendChild(this.createCell(_))}refreshIfNeeded(){this._needsRefresh&&(this._needsRefresh=!1,this.refresh())}needsRefresh(){this._needsRefresh=!0;!this._revealed||this._scheduledRefreshIdentifier||(this._scheduledRefreshIdentifier=requestAnimationFrame(this.refresh.bind(this)))}get data(){return this._data}set data(_){_=_||{};Object.shallowEqual(this._data,_)||(this._data=_,this.needsRefresh())}get filterableData(){if(this._cachedFilterableData)return this._cachedFilterableData;this._cachedFilterableData=[];for(let _ of this.dataGrid.columns.values())if(!_.hidden){let W=this.filterableDataForColumn(_.columnIdentifier);W&&(!(W instanceof Array)&&(W=[W]),W.length&&(this._cachedFilterableData=this._cachedFilterableData.concat(W)))}return this._cachedFilterableData}get revealed(){if("_revealed"in this)return this._revealed;for(var _=this.parent;_&&!_.root;){if(!_.expanded)return this._revealed=!1,!1;_=_.parent}return this._revealed=!0,!0}set hasChildren(_){this._hasChildren!==_&&(this._hasChildren=_,this._element&&(this._hasChildren?(this._element.classList.add("parent"),this.expanded&&this._element.classList.add("expanded")):this._element.classList.remove("parent","expanded")))}get hasChildren(){return this._hasChildren}set revealed(_){if(this._revealed!==_){this._revealed=_,this._element&&(this._revealed?this._element.classList.add("revealed"):this._element.classList.remove("revealed")),this.refreshIfNeeded();for(var S=0;S<this.children.length;++S)this.children[S].revealed=_&&this.expanded}}get depth(){return"_depth"in this?this._depth:(this._depth=this.parent&&!this.parent.root?this.parent.depth+1:0,this._depth)}get indentPadding(){return"number"==typeof this._indentPadding?this._indentPadding:(this._indentPadding=this.depth*this.dataGrid.indentWidth,this._indentPadding)}get shouldRefreshChildren(){return this._shouldRefreshChildren}set shouldRefreshChildren(_){this._shouldRefreshChildren=_,_&&this.expanded&&this.expand()}get selected(){return this._selected}set selected(_){_?this.select():this.deselect()}get expanded(){return this._expanded}set expanded(_){_?this.expand():this.collapse()}hasAncestor(_){if(!_)return!1;for(let S=this.parent;S;){if(_===S)return!0;S=S.parent}return!1}refresh(){this._element&&this.dataGrid&&(this._scheduledRefreshIdentifier&&(cancelAnimationFrame(this._scheduledRefreshIdentifier),this._scheduledRefreshIdentifier=void 0),this._cachedFilterableData=null,this._needsRefresh=!1,this._element.removeChildren(),this.createCells())}refreshRecursively(){this.refresh(),this.forEachChildInSubtree(_=>_.refresh())}updateLayout(){}createCell(_){var S=document.createElement("td");S.className=_+"-column",S.__columnIdentifier=_;var C=S.createChild("div","cell-content"),f=this.createCellContent(_,S);C.append(f);let T=this.dataGrid.columns.get(_);if(T&&(T.aligned&&S.classList.add(T.aligned),T.group&&S.classList.add("column-group-"+T.group),T.icon)){let E=document.createElement("div");E.classList.add("icon"),C.insertBefore(E,C.firstChild)}return _===this.dataGrid.disclosureColumnIdentifier&&(S.classList.add("disclosure"),this.indentPadding&&(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?S.style.setProperty("padding-right",`${this.indentPadding}px`):S.style.setProperty("padding-left",`${this.indentPadding}px`))),S}createCellContent(_){if(!(_ in this.data))return zeroWidthSpace;let S=this.data[_];return"number"==typeof S?S.maxDecimals(2).toLocaleString():S}elementWithColumnIdentifier(_){if(!this.dataGrid)return null;let S=this.dataGrid.orderedColumns.indexOf(_);return-1===S?null:this.element.children[S]}appendChild(){return WebInspector.DataGrid.prototype.appendChild.apply(this,arguments)}insertChild(){return WebInspector.DataGrid.prototype.insertChild.apply(this,arguments)}removeChild(){return WebInspector.DataGrid.prototype.removeChild.apply(this,arguments)}removeChildren(){return WebInspector.DataGrid.prototype.removeChildren.apply(this,arguments)}removeChildrenRecursive(){return WebInspector.DataGrid.prototype.removeChildrenRecursive.apply(this,arguments)}_recalculateSiblings(_){if(this.parent){var S=0<_?this.parent.children[_-1]:null;S?(S.nextSibling=this,this.previousSibling=S):this.previousSibling=null;var C=this.parent.children[_+1];C?(C.previousSibling=this,this.nextSibling=C):this.nextSibling=null}}collapse(){this._element&&this._element.classList.remove("expanded"),this._expanded=!1;for(var _=0;_<this.children.length;++_)this.children[_].revealed=!1;this.dispatchEventToListeners("collapsed"),this.dataGrid&&(this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.CollapsedNode,{dataGridNode:this}),this.dataGrid._noteRowsChanged())}collapseRecursively(){for(var _=this;_;)_.expanded&&_.collapse(),_=_.traverseNextNode(!1,this,!0)}expand(){if(this.hasChildren&&!this.expanded){if(this.revealed&&!this._shouldRefreshChildren)for(var _=0;_<this.children.length;++_)this.children[_].revealed=!0;if(this._shouldRefreshChildren){for(var _=0;_<this.children.length;++_)this.children[_]._detach();if(this.dispatchEventToListeners("populate"),this._attached)for(var _=0,S;_<this.children.length;++_)S=this.children[_],this.revealed&&(S.revealed=!0),S._attach();this._shouldRefreshChildren=!1}this._element&&this._element.classList.add("expanded"),this._expanded=!0,this.dispatchEventToListeners("expanded"),this.dataGrid&&(this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.ExpandedNode,{dataGridNode:this}),this.dataGrid._noteRowsChanged())}}expandRecursively(){for(var _=this;_;)_.expand(),_=_.traverseNextNode(!1,this)}forEachImmediateChild(_){for(let S of this.children)_(S)}forEachChildInSubtree(_){for(let S=this.traverseNextNode(!1,this,!0);S;)_(S),S=S.traverseNextNode(!1,this,!0)}isInSubtreeOfNode(_){for(let S=_;S;){if(S===this)return!0;S=S.traverseNextNode(!1,_,!0)}return!1}reveal(){for(var _=this.parent;_&&!_.root;)_.expanded||_.expand(),_=_.parent;this.element.scrollIntoViewIfNeeded(!1),this.dispatchEventToListeners("revealed")}select(_){if(this.dataGrid&&this.selectable&&!this.selected){let S=this.dataGrid.selectedNode;S&&S.deselect(!0),this._selected=!0,this.dataGrid.selectedNode=this,this._element&&this._element.classList.add("selected"),_||this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.SelectedNodeChanged,{oldSelectedNode:S})}}revealAndSelect(){this.reveal(),this.select()}deselect(_){this.dataGrid&&this.dataGrid.selectedNode===this&&this.selected&&(this._selected=!1,this.dataGrid.selectedNode=null,this._element&&this._element.classList.remove("selected"),!_&&this.dataGrid.dispatchEventToListeners(WebInspector.DataGrid.Event.SelectedNodeChanged,{oldSelectedNode:this}))}traverseNextNode(_,S,C,f){!C&&this.hasChildren&&this.dispatchEventToListeners("populate"),f&&(f.depthChange=0);var T=!_||this.revealed?this.children[0]:null;if(T&&(!_||this.expanded))return f&&(f.depthChange=1),T;if(this===S)return null;if(T=!_||this.revealed?this.nextSibling:null,T)return T;for(T=this;T&&!T.root&&(!_||T.revealed?!T.nextSibling:!0)&&T.parent!==S;)f&&(f.depthChange-=1),T=T.parent;return T?!_||T.revealed?T.nextSibling:null:null}traversePreviousNode(_,S){var C=!_||this.revealed?this.previousSibling:null;for(!S&&C&&C.hasChildren&&C.dispatchEventToListeners("populate");C&&(!_||C.revealed&&C.expanded?C.children.lastValue:null);)!S&&C.hasChildren&&C.dispatchEventToListeners("populate"),C=!_||C.revealed&&C.expanded?C.children.lastValue:null;return C?C:!this.parent||this.parent.root?null:this.parent}isEventWithinDisclosureTriangle(_){if(!this.hasChildren)return!1;let S=_.target.enclosingNodeOrSelfWithNodeName("td");if(!S||!S.classList.contains("disclosure"))return!1;let C=window.getComputedStyle(S),f=0;return f+=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?S.totalOffsetRight-C.getPropertyCSSValue("padding-right").getFloatValue(CSSPrimitiveValue.CSS_PX)-this.disclosureToggleWidth:S.totalOffsetLeft+C.getPropertyCSSValue("padding-left").getFloatValue(CSSPrimitiveValue.CSS_PX),_.pageX>=f&&_.pageX<=f+this.disclosureToggleWidth}_attach(){if(this.dataGrid&&!this._attached){this._attached=!0;let _=-1;if(!this.isPlaceholderNode){var S=this.traversePreviousNode(!0,!0);_=this.dataGrid._rows.indexOf(S),-1==_?_=0:_++}if(-1===_?this.dataGrid._rows.push(this):this.dataGrid._rows.insertAtIndex(this,_),this.dataGrid._noteRowsChanged(),this.expanded)for(var C=0;C<this.children.length;++C)this.children[C]._attach()}}_detach(){if(this._attached){this._attached=!1,this.dataGrid._rows.remove(this,!0),this.dataGrid._noteRowRemoved(this);for(var _=0;_<this.children.length;++_)this.children[_]._detach()}}savePosition(){this._savedPosition||!this.parent||(this._savedPosition={parent:this.parent,index:this.parent.children.indexOf(this)})}restorePosition(){this._savedPosition&&(this.parent!==this._savedPosition.parent&&this._savedPosition.parent.insertChild(this,this._savedPosition.index),this._savedPosition=null)}appendContextMenuItems(){return null}filterableDataForColumn(_){let S=this.data[_];return"string"==typeof S?S:null}didResizeColumn(){}},WebInspector.PlaceholderDataGridNode=class extends WebInspector.DataGridNode{constructor(_){super(_,!1),this.isPlaceholderNode=!0}makeNormal(){this.isPlaceholderNode=!1}},WebInspector.DetailsSectionRow=class extends WebInspector.Object{constructor(_){super(),this._element=document.createElement("div"),this._element.className="row",this._emptyMessage=_||""}get element(){return this._element}get emptyMessage(){return this._emptyMessage}set emptyMessage(_){this._emptyMessage=_||"",this._element.childNodes.length||this.showEmptyMessage()}showEmptyMessage(){this.element.classList.add(WebInspector.DetailsSectionRow.EmptyStyleClassName),this._emptyMessage instanceof Node?(this.element.removeChildren(),this.element.appendChild(this._emptyMessage)):this.element.textContent=this._emptyMessage}hideEmptyMessage(){this.element.classList.remove(WebInspector.DetailsSectionRow.EmptyStyleClassName),this.element.removeChildren()}},WebInspector.DetailsSectionRow.EmptyStyleClassName="empty",WebInspector.Dialog=class extends WebInspector.View{constructor(_){super(),this._delegate=_,this._dismissing=!1,this._representedObject=null,this._cookie=null,this._visible=!1}get visible(){return this._visible}get delegate(){return this._delegate}get representedObject(){return this._representedObject}get cookie(){return this._cookie}present(_){_.appendChild(this.element),this._visible=!0,this.didPresentDialog()}dismiss(_,S){if(!this._dismissing){let C=this.element.parentNode;C&&(this._dismissing=!0,this._representedObject=_||null,this._cookie=S||null,this._visible=!1,this.element.remove(),this._delegate&&"function"==typeof this._delegate.dialogWasDismissed&&this._delegate.dialogWasDismissed(this),this._dismissing=!1,this.didDismissDialog())}}didDismissDialog(){}didPresetDialog(){}representedObjectIsValid(_){return this.delegate&&"function"==typeof this.delegate.isDialogRepresentedObjectValid?this.delegate.isDialogRepresentedObjectValid(this,_):!0}},WebInspector.HierarchicalPathComponent=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._representedObject=C||null,this._element=document.createElement("div"),this._element.className="hierarchical-path-component",Array.isArray(S)||(S=[S]),this._element.classList.add(...S),f?this._element.classList.add("text-only"):(this._iconElement=document.createElement("img"),this._iconElement.className="icon",this._element.appendChild(this._iconElement)),this._titleElement=document.createElement("div"),this._titleElement.className="title",this._titleElement.setAttribute("dir","auto"),this._element.appendChild(this._titleElement),this._titleContentElement=document.createElement("div"),this._titleContentElement.className="content",this._titleElement.appendChild(this._titleContentElement),this._separatorElement=document.createElement("div"),this._separatorElement.className="separator",this._element.appendChild(this._separatorElement),this._selectElement=document.createElement("select"),this._selectElement.setAttribute("dir","auto"),this._selectElement.addEventListener("mouseover",this._selectElementMouseOver.bind(this)),this._selectElement.addEventListener("mouseout",this._selectElementMouseOut.bind(this)),this._selectElement.addEventListener("mousedown",this._selectElementMouseDown.bind(this)),this._selectElement.addEventListener("mouseup",this._selectElementMouseUp.bind(this)),this._selectElement.addEventListener("change",this._selectElementSelectionChanged.bind(this)),this._element.appendChild(this._selectElement),this._previousSibling=null,this._nextSibling=null,this._truncatedDisplayNameLength=0,this._collapsed=!1,this._hidden=!1,this._selectorArrows=!1,this.displayName=_,this.selectorArrows=T}get selectedPathComponent(){let _=this._selectElement[this._selectElement.selectedIndex];return _||1!==this._selectElement.options.length||(_=this._selectElement.options[0]),_&&_._pathComponent||null}get element(){return this._element}get representedObject(){return this._representedObject}get displayName(){return this._displayName}set displayName(_){_===this._displayName||(this._displayName=_,this._updateElementTitleAndText())}get truncatedDisplayNameLength(){return this._truncatedDisplayNameLength}set truncatedDisplayNameLength(_){_=_||0;_===this._truncatedDisplayNameLength||(this._truncatedDisplayNameLength=_,this._updateElementTitleAndText())}get minimumWidth(){return this._collapsed?WebInspector.HierarchicalPathComponent.MinimumWidthCollapsed:this._selectorArrows?WebInspector.HierarchicalPathComponent.MinimumWidth+WebInspector.HierarchicalPathComponent.SelectorArrowsWidth:WebInspector.HierarchicalPathComponent.MinimumWidth}get forcedWidth(){let _=this._element.style.getProperty("width");return"string"==typeof _?parseInt(_):null}set forcedWidth(_){if("number"==typeof _){let S=WebInspector.HierarchicalPathComponent.MinimumWidthForOneCharacterTruncatedTitle;this.selectorArrows&&(S+=WebInspector.HierarchicalPathComponent.SelectorArrowsWidth),_<S&&(_=0),this._element.style.setProperty("width",Math.max(1,_)+"px")}else this._element.style.removeProperty("width")}get hidden(){return this._hidden}set hidden(_){this._hidden===_||(this._hidden=_,this._element.classList.toggle("hidden",this._hidden))}get collapsed(){return this._collapsed}set collapsed(_){this._collapsed===_||(this._collapsed=_,this._element.classList.toggle("collapsed",this._collapsed))}get selectorArrows(){return this._selectorArrows}set selectorArrows(_){this._selectorArrows===_||(this._selectorArrows=_,this._selectorArrows?(this._selectorArrowsElement=document.createElement("img"),this._selectorArrowsElement.className="selector-arrows",this._element.insertBefore(this._selectorArrowsElement,this._separatorElement)):this._selectorArrowsElement&&(this._selectorArrowsElement.remove(),this._selectorArrowsElement=null),this._element.classList.toggle("show-selector-arrows",!!this._selectorArrows))}get previousSibling(){return this._previousSibling}set previousSibling(_){this._previousSibling=_||null}get nextSibling(){return this._nextSibling}set nextSibling(_){this._nextSibling=_||null}_updateElementTitleAndText(){let _=this._displayName;this._truncatedDisplayNameLength&&_.length>this._truncatedDisplayNameLength&&(_=_.substring(0,this._truncatedDisplayNameLength)+ellipsis),this._element.title=this._displayName,this._titleContentElement.textContent=_}_updateSelectElement(){function _(f){let T=document.createElement("option"),E=130;return T.textContent=f.displayName.length<=E?f.displayName:f.displayName.substring(0,E)+ellipsis,T._pathComponent=f,T}this._selectElement.removeChildren();let S=0,C=this.previousSibling;for(;C;)this._selectElement.insertBefore(_(C),this._selectElement.firstChild),C=C.previousSibling,++S;for(this._selectElement.appendChild(_(this)),C=this.nextSibling;C;)this._selectElement.appendChild(_(C)),C=C.nextSibling;this._selectElement.selectedIndex=1===this._selectElement.options.length?-1:S}_selectElementMouseOver(){"function"==typeof this.mouseOver&&this.mouseOver()}_selectElementMouseOut(){"function"==typeof this.mouseOut&&this.mouseOut()}_selectElementMouseDown(){this._updateSelectElement()}_selectElementMouseUp(){this.dispatchEventToListeners(WebInspector.HierarchicalPathComponent.Event.Clicked,{pathComponent:this.selectedPathComponent})}_selectElementSelectionChanged(){this.dispatchEventToListeners(WebInspector.HierarchicalPathComponent.Event.SiblingWasSelected,{pathComponent:this.selectedPathComponent})}},WebInspector.HierarchicalPathComponent.MinimumWidth=32,WebInspector.HierarchicalPathComponent.MinimumWidthCollapsed=24,WebInspector.HierarchicalPathComponent.MinimumWidthForOneCharacterTruncatedTitle=54,WebInspector.HierarchicalPathComponent.SelectorArrowsWidth=12,WebInspector.HierarchicalPathComponent.Event={SiblingWasSelected:"hierarchical-path-component-sibling-was-selected",Clicked:"hierarchical-path-component-clicked"},WebInspector.NavigationItem=class extends WebInspector.Object{constructor(_,S,C){super(),this._identifier=_||null,this._element=document.createElement("div"),this._hidden=!1,this._parentNavigationBar=null,S&&this._element.setAttribute("role",S),C&&this._element.setAttribute("aria-label",C),this._element.classList.add(...this._classNames),this._element.navigationItem=this}get identifier(){return this._identifier}get element(){return this._element}get minimumWidth(){return this._element.realOffsetWidth}get parentNavigationBar(){return this._parentNavigationBar}updateLayout(){}get hidden(){return this._hidden}set hidden(_){this._hidden===_||(this._hidden=_,this._element.classList.toggle("hidden",_),this._parentNavigationBar&&this._parentNavigationBar.needsLayout())}get _classNames(){var _=["item"];return this._identifier&&_.push(this._identifier),this.additionalClassNames instanceof Array&&(_=_.concat(this.additionalClassNames)),_}},WebInspector.Popover=class extends WebInspector.Object{constructor(_){super(),this.delegate=_,this._edge=null,this._frame=new WebInspector.Rect,this._content=null,this._targetFrame=new WebInspector.Rect,this._anchorPoint=new WebInspector.Point,this._preferredEdges=null,this._resizeHandler=null,this._contentNeedsUpdate=!1,this._dismissing=!1,this._element=document.createElement("div"),this._element.className="popover",this._element.addEventListener("transitionend",this,!0),this._container=this._element.appendChild(document.createElement("div")),this._container.className="container"}get element(){return this._element}get frame(){return this._frame}get visible(){return this._element.parentNode===document.body&&!this._element.classList.contains(WebInspector.Popover.FadeOutClassName)}set frame(_){this._element.style.left=_.minX()+"px",this._element.style.top=_.minY()+"px",this._element.style.width=_.size.width+"px",this._element.style.height=_.size.height+"px",this._element.style.backgroundSize=_.size.width+"px "+_.size.height+"px",this._frame=_}set content(_){_===this._content||(this._content=_,this._contentNeedsUpdate=!0,this.visible&&this._update(!0))}set windowResizeHandler(_){this._resizeHandler=_}update(_=!0){if(this.visible){var S=document.activeElement;this._contentNeedsUpdate=!0,this._update(_),S&&S.focus()}}present(_,S){this._targetFrame=_,this._preferredEdges=S;this._content&&(this._addListenersIfNeeded(),this._update())}presentNewContentWithFrame(_,S,C){this._content=_,this._contentNeedsUpdate=!0,this._targetFrame=S,this._preferredEdges=C,this._addListenersIfNeeded();var f=this.visible;this._update(f)}dismiss(){this._dismissing||this._element.parentNode!==document.body||(this._dismissing=!0,this._isListeningForPopoverEvents=!1,window.removeEventListener("mousedown",this,!0),window.removeEventListener("scroll",this,!0),window.removeEventListener("resize",this,!0),window.removeEventListener("keypress",this,!0),WebInspector.quickConsole.keyboardShortcutDisabled=!1,this._element.classList.add(WebInspector.Popover.FadeOutClassName),this.delegate&&"function"==typeof this.delegate.willDismissPopover&&this.delegate.willDismissPopover(this))}handleEvent(_){switch(_.type){case"mousedown":case"scroll":this._element.contains(_.target)||_.target.enclosingNodeOrSelfWithClass(WebInspector.Popover.IgnoreAutoDismissClassName)||_[WebInspector.Popover.EventPreventDismissSymbol]||this.dismiss();break;case"resize":this._resizeHandler&&this._resizeHandler();break;case"keypress":_.keyCode===WebInspector.KeyboardShortcut.Key.Escape.keyCode&&this.dismiss();break;case"transitionend":if(_.target===this._element){document.body.removeChild(this._element),this._element.classList.remove(WebInspector.Popover.FadeOutClassName),this._container.textContent="",this.delegate&&"function"==typeof this.delegate.didDismissPopover&&this.delegate.didDismissPopover(this),this._dismissing=!1;break}}}_update(_){function S(W){return W.width*W.height}if(_)var C=this._edge;var f=this._targetFrame,T=this._preferredEdges;if(this._element.parentNode===document.body?this._element.classList.remove(WebInspector.Popover.FadeOutClassName):document.body.appendChild(this._element),this._dismissing=!1,this._contentNeedsUpdate){this._element.style.removeProperty("left"),this._element.style.removeProperty("top"),this._element.style.removeProperty("width"),this._element.style.removeProperty("height"),null!==this._edge&&this._element.classList.remove(this._cssClassNameForEdge()),this._container.replaceWith(this._content);var E=this._element.getBoundingClientRect();this._preferredSize=new WebInspector.Size(Math.ceil(E.width),Math.ceil(E.height))}var I="mac"===WebInspector.Platform.name&&10<=WebInspector.Platform.version.release?22:0,R=new WebInspector.Rect(0,I,window.innerWidth,window.innerHeight-I);R=R.inset(WebInspector.Popover.ShadowEdgeInsets);var N=Array(T.length);for(var L in WebInspector.RectEdge){var D=WebInspector.RectEdge[L],M={edge:D,metrics:this._bestMetricsForEdge(this._preferredSize,f,R,D)},P=T.indexOf(D);-1===P?N.push(M):N[P]=M}for(var O=N[0].edge,F=N[0].metrics,V=1,U;V<N.length;V++)U=N[V].metrics,S(U.contentSize)>S(F.contentSize)&&(O=N[V].edge,F=U);var H=F.frame.round(),G;this._edge=O,H===WebInspector.Rect.ZERO_RECT?this.dismiss():(O===WebInspector.RectEdge.MIN_X?G=new WebInspector.Point(H.size.width-WebInspector.Popover.ShadowPadding,f.midY()-H.minY()):O===WebInspector.RectEdge.MAX_X?G=new WebInspector.Point(WebInspector.Popover.ShadowPadding,f.midY()-H.minY()):O===WebInspector.RectEdge.MIN_Y?G=new WebInspector.Point(f.midX()-H.minX(),H.size.height-WebInspector.Popover.ShadowPadding):O===WebInspector.RectEdge.MAX_Y?G=new WebInspector.Point(f.midX()-H.minX(),WebInspector.Popover.ShadowPadding):void 0,this._element.classList.add(this._cssClassNameForEdge()),_&&this._edge===C?this._animateFrame(H,G):(this.frame=H,this._setAnchorPoint(G),this._drawBackground()),this._preferredSize.width<WebInspector.Popover.MinWidth||this._preferredSize.height<WebInspector.Popover.MinHeight?this._container.classList.add("center"):this._container.classList.remove("center")),this._contentNeedsUpdate&&(this._container.textContent="",this._content.replaceWith(this._container),this._container.appendChild(this._content)),this._contentNeedsUpdate=!1}_cssClassNameForEdge(){switch(this._edge){case WebInspector.RectEdge.MIN_X:return"arrow-right";case WebInspector.RectEdge.MAX_X:return"arrow-left";case WebInspector.RectEdge.MIN_Y:return"arrow-down";case WebInspector.RectEdge.MAX_Y:return"arrow-up";}return console.error("Unknown edge."),"arrow-up"}_setAnchorPoint(_){_.x=Math.floor(_.x),_.y=Math.floor(_.y),this._anchorPoint=_}_animateFrame(_,S){function C(D,M,P){return D+(M-D)*P}function f(){var D=R.solve(Math.min((Date.now()-T)/E,1),1/(200*E));this.frame=new WebInspector.Rect(C(N.minX(),_.minX(),D),C(N.minY(),_.minY(),D),C(N.size.width,_.size.width,D),C(N.size.height,_.size.height,D)).round(),this._setAnchorPoint(new WebInspector.Point(C(L.x,S.x,D),C(L.y,S.y,D))),this._drawBackground(),1>D&&requestAnimationFrame(f.bind(this))}var T=Date.now(),E=350,R=new WebInspector.CubicBezier(0.25,0.1,0.25,1),N=this._frame.copy(),L=this._anchorPoint.copy();f.call(this)}_drawBackground(){var _=window.devicePixelRatio,S=this._frame.size.width,C=this._frame.size.height,f=S*_,T=C*_,E=document.createElement("canvas");E.width=f,E.height=T;var I=E.getContext("2d");I.scale(_,_);var R,N=WebInspector.Popover.AnchorSize.height;switch(this._edge){case WebInspector.RectEdge.MIN_X:R=new WebInspector.Rect(0,0,S-N,C);break;case WebInspector.RectEdge.MAX_X:R=new WebInspector.Rect(N,0,S-N,C);break;case WebInspector.RectEdge.MIN_Y:R=new WebInspector.Rect(0,0,S,C-N);break;case WebInspector.RectEdge.MAX_Y:R=new WebInspector.Rect(0,N,S,C-N);}R=R.inset(WebInspector.Popover.ShadowEdgeInsets),I.fillStyle="black",this._drawFrame(I,R,this._edge,this._anchorPoint),I.clip();var L=I.createLinearGradient(0,0,0,C);L.addColorStop(0,"rgba(255, 255, 255, 0.95)"),L.addColorStop(1,"rgba(235, 235, 235, 0.95)"),I.fillStyle=L,I.fillRect(0,0,S,C),I.strokeStyle="rgba(0, 0, 0, 0.25)",I.lineWidth=2,this._drawFrame(I,R,this._edge,this._anchorPoint),I.stroke();let D=document.getCSSCanvasContext("2d","popover",f,T);D.clearRect(0,0,f,T),D.shadowOffsetX=1,D.shadowOffsetY=1,D.shadowBlur=5,D.shadowColor="rgba(0, 0, 0, 0.5)",D.drawImage(E,0,0,f,T)}_bestMetricsForEdge(_,S,C,f){var I=_.width+2*WebInspector.Popover.ShadowPadding+2*WebInspector.Popover.ContentPadding,R=_.height+2*WebInspector.Popover.ShadowPadding+2*WebInspector.Popover.ContentPadding,N=WebInspector.Popover.AnchorSize.height,T,E;f===WebInspector.RectEdge.MIN_X?(I+=N,T=S.origin.x-I+WebInspector.Popover.ShadowPadding,E=S.origin.y-(R-S.size.height)/2):f===WebInspector.RectEdge.MAX_X?(I+=N,T=S.origin.x+S.size.width-WebInspector.Popover.ShadowPadding,E=S.origin.y-(R-S.size.height)/2):f===WebInspector.RectEdge.MIN_Y?(R+=N,T=S.origin.x-(I-S.size.width)/2,E=S.origin.y-R+WebInspector.Popover.ShadowPadding):f===WebInspector.RectEdge.MAX_Y?(R+=N,T=S.origin.x-(I-S.size.width)/2,E=S.origin.y+S.size.height-WebInspector.Popover.ShadowPadding):void 0,f===WebInspector.RectEdge.MIN_X||f===WebInspector.RectEdge.MAX_X?(E<C.minY()&&(E=C.minY()),E+R>C.maxY()&&(E=C.maxY()-R)):(T<C.minX()&&(T=C.minX()),T+I>C.maxX()&&(T=C.maxX()-I));var L=new WebInspector.Rect(T,E,I,R),D=L.intersectionWithRect(C);return I=D.size.width-2*WebInspector.Popover.ShadowPadding,R=D.size.height-2*WebInspector.Popover.ShadowPadding,(f===WebInspector.RectEdge.MIN_X||f===WebInspector.RectEdge.MAX_X?I-=N:f===WebInspector.RectEdge.MIN_Y||f===WebInspector.RectEdge.MAX_Y?R-=N:void 0,{frame:D,contentSize:new WebInspector.Size(I,R)})}_drawFrame(_,S,C){let f=WebInspector.Popover.CornerRadius,T=0.5*WebInspector.Popover.AnchorSize.width,E=this._anchorPoint,I=f+T;C===WebInspector.RectEdge.MIN_Y||C===WebInspector.RectEdge.MAX_Y?E.x=Number.constrain(E.x,S.minX()+I,S.maxX()-I):E.y=Number.constrain(E.y,S.minY()+I,S.maxY()-I),_.beginPath();C===WebInspector.RectEdge.MIN_X?(_.moveTo(S.maxX(),S.minY()+f),_.lineTo(S.maxX(),E.y-T),_.lineTo(E.x,E.y),_.lineTo(S.maxX(),E.y+T),_.arcTo(S.maxX(),S.maxY(),S.minX(),S.maxY(),f),_.arcTo(S.minX(),S.maxY(),S.minX(),S.minY(),f),_.arcTo(S.minX(),S.minY(),S.maxX(),S.minY(),f),_.arcTo(S.maxX(),S.minY(),S.maxX(),S.maxY(),f)):C===WebInspector.RectEdge.MAX_X?(_.moveTo(S.minX(),S.maxY()-f),_.lineTo(S.minX(),E.y+T),_.lineTo(E.x,E.y),_.lineTo(S.minX(),E.y-T),_.arcTo(S.minX(),S.minY(),S.maxX(),S.minY(),f),_.arcTo(S.maxX(),S.minY(),S.maxX(),S.maxY(),f),_.arcTo(S.maxX(),S.maxY(),S.minX(),S.maxY(),f),_.arcTo(S.minX(),S.maxY(),S.minX(),S.minY(),f)):C===WebInspector.RectEdge.MIN_Y?(_.moveTo(S.maxX()-f,S.maxY()),_.lineTo(E.x+T,S.maxY()),_.lineTo(E.x,E.y),_.lineTo(E.x-T,S.maxY()),_.arcTo(S.minX(),S.maxY(),S.minX(),S.minY(),f),_.arcTo(S.minX(),S.minY(),S.maxX(),S.minY(),f),_.arcTo(S.maxX(),S.minY(),S.maxX(),S.maxY(),f),_.arcTo(S.maxX(),S.maxY(),S.minX(),S.maxY(),f)):C===WebInspector.RectEdge.MAX_Y?(_.moveTo(S.minX()+f,S.minY()),_.lineTo(E.x-T,S.minY()),_.lineTo(E.x,E.y),_.lineTo(E.x+T,S.minY()),_.arcTo(S.maxX(),S.minY(),S.maxX(),S.maxY(),f),_.arcTo(S.maxX(),S.maxY(),S.minX(),S.maxY(),f),_.arcTo(S.minX(),S.maxY(),S.minX(),S.minY(),f),_.arcTo(S.minX(),S.minY(),S.maxX(),S.minY(),f)):void 0;_.closePath()}_addListenersIfNeeded(){this._isListeningForPopoverEvents||(this._isListeningForPopoverEvents=!0,window.addEventListener("mousedown",this,!0),window.addEventListener("scroll",this,!0),window.addEventListener("resize",this,!0),window.addEventListener("keypress",this,!0),WebInspector.quickConsole.keyboardShortcutDisabled=!0)}},WebInspector.Popover.FadeOutClassName="fade-out",WebInspector.Popover.CornerRadius=5,WebInspector.Popover.MinWidth=40,WebInspector.Popover.MinHeight=40,WebInspector.Popover.ShadowPadding=5,WebInspector.Popover.ContentPadding=5,WebInspector.Popover.AnchorSize=new WebInspector.Size(22,11),WebInspector.Popover.ShadowEdgeInsets=new WebInspector.EdgeInsets(WebInspector.Popover.ShadowPadding),WebInspector.Popover.IgnoreAutoDismissClassName="popover-ignore-auto-dismiss",WebInspector.Popover.EventPreventDismissSymbol=Symbol("popover-event-prevent-dismiss"),WebInspector.SidebarPanel=class extends WebInspector.View{constructor(_,S){super(),this._identifier=_,this._displayName=S,this._selected=!1,this._savedScrollPosition=0,this.element.classList.add("panel",_),this.element.setAttribute("role","group"),this.element.setAttribute("aria-label",S),this._contentView=new WebInspector.View,this._contentView.element.classList.add("content"),this.addSubview(this._contentView)}get identifier(){return this._identifier}get contentView(){return this._contentView}get displayName(){return this._displayName}get visible(){return this.selected&&this.parentSidebar&&!this.parentSidebar.collapsed}get selected(){return this._selected}set selected(_){_===this._selected||(this._selected=_||!1,this.element.classList.toggle("selected",this._selected))}get parentSidebar(){return this.parentView}get minimumWidth(){return 0}show(){this.parentSidebar&&(this.parentSidebar.collapsed=!1,this.parentSidebar.selectedSidebarPanel=this)}hide(){this.parentSidebar&&(this.parentSidebar.collapsed=!0,this.parentSidebar.selectedSidebarPanel=null)}added(){}removed(){}shown(){this._contentView.element.scrollTop=this._savedScrollPosition,this.updateLayoutIfNeeded()}hidden(){this._savedScrollPosition=this._contentView.element.scrollTop}visibilityDidChange(){}},WebInspector.StyleDetailsPanel=class extends WebInspector.View{constructor(_,S,C,f){super(),this._delegate=_||null,this.element.classList.add(S,"offset-sections"),this._navigationInfo={identifier:C,label:f},this._nodeStyles=null,this._visible=!1}get navigationInfo(){return this._navigationInfo}get nodeStyles(){return this._nodeStyles}shown(){this._visible||(this._visible=!0,this._refreshNodeStyles(),this.updateLayoutIfNeeded())}hidden(){this._visible=!1,this.cancelLayout()}markAsNeedsRefresh(_){if(_){if(!this._nodeStyles||this._nodeStyles.node!==_){if(this._nodeStyles&&(this._nodeStyles.removeEventListener(WebInspector.DOMNodeStyles.Event.Refreshed,this.nodeStylesRefreshed,this),this._nodeStyles.removeEventListener(WebInspector.DOMNodeStyles.Event.NeedsRefresh,this._nodeStylesNeedsRefreshed,this)),this._nodeStyles=WebInspector.cssStyleManager.stylesForNode(_),!this._nodeStyles)return;this._nodeStyles.addEventListener(WebInspector.DOMNodeStyles.Event.Refreshed,this.nodeStylesRefreshed,this),this._nodeStyles.addEventListener(WebInspector.DOMNodeStyles.Event.NeedsRefresh,this._nodeStylesNeedsRefreshed,this),this._forceSignificantChange=!0}this._visible&&this._refreshNodeStyles()}}refresh(){this.dispatchEventToListeners(WebInspector.StyleDetailsPanel.Event.Refreshed)}nodeStylesRefreshed(_){this._visible&&this._refreshPreservingScrollPosition(_.data.significantChange)}get _initialScrollOffset(){return WebInspector.cssStyleManager.canForcePseudoClasses()?this.nodeStyles.node.enabledPseudoClasses.length?0:WebInspector.CSSStyleDetailsSidebarPanel.NoForcedPseudoClassesScrollOffset:0}_refreshNodeStyles(){this._nodeStyles&&this._nodeStyles.refresh()}_refreshPreservingScrollPosition(_){_=this._forceSignificantChange||_||!1;var S=this._initialScrollOffset;this.element.parentNode&&this._previousRefreshNodeIdentifier===this._nodeStyles.node.id&&(S=this.element.parentNode.scrollTop),this.refresh(_),this._previousRefreshNodeIdentifier=this._nodeStyles.node.id,this.element.parentNode&&(this.element.parentNode.scrollTop=S),this._forceSignificantChange=!1}_nodeStylesNeedsRefreshed(){this._visible&&this._refreshNodeStyles()}},WebInspector.StyleDetailsPanel.Event={Refreshed:"style-details-panel-refreshed"},WebInspector.TabBar=class extends WebInspector.View{constructor(_,S){if(super(_),this.element.classList.add("tab-bar"),this.element.setAttribute("role","tablist"),this.element.addEventListener("mousedown",this._handleMouseDown.bind(this)),this.element.addEventListener("click",this._handleClick.bind(this)),this.element.addEventListener("mouseleave",this._handleMouseLeave.bind(this)),this.element.createChild("div","top-border"),this._tabBarItems=[],S)for(let C in S)this.addTabBarItem(C);this.addTabBarItem(WebInspector.settingsTabContentView.tabBarItem,{suppressAnimations:!0}),this._newTabTabBarItem=new WebInspector.PinnedTabBarItem("Images/NewTabPlus.svg",WebInspector.UIString("Create a new tab")),this._newTabTabBarItem.element.addEventListener("mouseenter",this._handleNewTabMouseEnter.bind(this)),this._newTabTabBarItem.element.addEventListener("click",this._handleNewTabClick.bind(this)),this.addTabBarItem(this._newTabTabBarItem,{suppressAnimations:!0})}get newTabTabBarItem(){return this._newTabTabBarItem}updateNewTabTabBarItemState(){let _=!WebInspector.isNewTabWithTypeAllowed(WebInspector.NewTabContentView.Type);this._newTabTabBarItem.disabled=_}addTabBarItem(_,S={}){return this.insertTabBarItem(_,this._tabBarItems.length,S)}insertTabBarItem(_,S,C={}){function f(){this.element.classList.add("animating"),this.element.classList.add("inserting-tab"),this._applyTabBarItemSizesAndPositions(N),this.element.addEventListener("webkitTransitionEnd",L)}function T(){this.element.classList.remove("static-layout"),this.element.classList.remove("animating"),this.element.classList.remove("inserting-tab"),_.element.classList.remove("being-inserted"),this._clearTabBarItemSizesAndPositions(),this.element.removeEventListener("webkitTransitionEnd",L)}if(!(_ instanceof WebInspector.TabBarItem))return null;if(_.parentTabBar===this)return null;if(this._tabAnimatedClosedSinceMouseEnter)return this._finishExpandingTabsAfterClose().then(()=>{this.insertTabBarItem(_,S,C)}),null;_.parentTabBar&&_.parentTabBar.removeTabBarItem(_),_.parentTabBar=this,S=Number.constrain(S,0,this.normalTabCount),this.element.classList.contains("animating")&&(requestAnimationFrame(T.bind(this)),C.suppressAnimations=!0);var E;C.suppressAnimations||(E=this._recordTabBarItemSizesAndPositions()),this._tabBarItems.splice(S,0,_);var I=this._tabBarItems[S+1];let R=I?I.element:this._tabBarItems.lastValue.element;if(this.element.isAncestor(R)?this.element.insertBefore(_.element,R):this.element.appendChild(_.element),this.element.classList.toggle("single-tab",!this._hasMoreThanOneNormalTab()),_.element.style.left=null,_.element.style.width=null,!C.suppressAnimations){var N=this._recordTabBarItemSizesAndPositions();this.updateLayout();let D=this._tabBarItemsFromLeftToRight(),M=D[D.indexOf(_)-1]||null,P=M?E.get(M):null;P?E.set(_,{left:P.left+P.width,width:0}):E.set(_,{left:0,width:0}),this.element.classList.add("static-layout"),_.element.classList.add("being-inserted"),this._applyTabBarItemSizesAndPositions(E);var L=T.bind(this);requestAnimationFrame(f.bind(this))}else this.needsLayout();return _ instanceof WebInspector.PinnedTabBarItem||this.updateNewTabTabBarItemState(),this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemAdded,{tabBarItem:_}),_}removeTabBarItem(_,S={}){function C(){this.element.classList.add("animating"),this.element.classList.add("closing-tab");let O=0;if(WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL){O=this.element.getBoundingClientRect().width;for(let V of this._tabBarItemsFromLeftToRight())O-=V.element.getBoundingClientRect().width}let F=0;for(let V of this._tabBarItemsFromLeftToRight()){let U=R.get(V);V instanceof WebInspector.PinnedTabBarItem?F=U.left+U.width:(V.element.style.left=O+F+"px",F+=U.width,M=V)}this._selectedTabBarItem&&(this._selectedTabBarItem.element.style.width=parseFloat(this._selectedTabBarItem.element.style.width)+1+"px"),M!==this._selectedTabBarItem&&(M.element.style.width=parseFloat(M.element.style.width)+1+"px"),this.element.addEventListener("webkitTransitionEnd",P)}function f(){this._selectedTabBarItem&&this._selectedTabBarItem!==M&&(this._selectedTabBarItem.element.style.width=parseFloat(this._selectedTabBarItem.element.style.width)-1+"px"),this.element.classList.remove("animating"),this.element.classList.remove("closing-tab"),this.updateLayout(),this.element.removeEventListener("webkitTransitionEnd",P)}let T=this._findTabBarItem(_);if(!T||T instanceof WebInspector.PinnedTabBarItem)return null;if(T.parentTabBar=null,this._selectedTabBarItem===T){var E=this._tabBarItems.indexOf(T),I=this._tabBarItems[E+1];(!I||I instanceof WebInspector.PinnedTabBarItem)&&(I=this._tabBarItems[E-1]),this.selectedTabBarItem=I}this.element.classList.contains("animating")&&(requestAnimationFrame(f.bind(this)),S.suppressAnimations=!0);var R;S.suppressAnimations||(R=this._recordTabBarItemSizesAndPositions());let N=this._tabBarItems.indexOf(T)===this.normalTabCount-1;this._tabBarItems.remove(T),T.element.remove();var L=this._hasMoreThanOneNormalTab();this.element.classList.toggle("single-tab",!L);const D=!T.isDefaultTab&&!this.normalTabCount;if(D&&(S.suppressAnimations=!0),!L||N||!S.suppressExpansion)return S.suppressAnimations?this.needsLayout():(this._tabAnimatedClosedSinceMouseEnter=!0,this._finishExpandingTabsAfterClose(R)),this.updateNewTabTabBarItemState(),this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemRemoved,{tabBarItem:T}),D&&this._openDefaultTab(),T;var M;if(!S.suppressAnimations){this.element.classList.add("static-layout"),this._tabAnimatedClosedSinceMouseEnter=!0,this._applyTabBarItemSizesAndPositions(R);var P=f.bind(this);requestAnimationFrame(C.bind(this))}else this.needsLayout();return this.updateNewTabTabBarItemState(),this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemRemoved,{tabBarItem:T}),D&&this._openDefaultTab(),T}selectPreviousTab(){if(!(1>=this._tabBarItems.length)){var _=this._tabBarItems.indexOf(this._selectedTabBarItem),S=_;do if(0===S?S=this._tabBarItems.length-1:S--,!(this._tabBarItems[S]instanceof WebInspector.PinnedTabBarItem))break;while(S!==_);S===_||(this.selectedTabBarItem=this._tabBarItems[S])}}selectNextTab(){if(!(1>=this._tabBarItems.length)){var _=this._tabBarItems.indexOf(this._selectedTabBarItem),S=_;do if(S===this._tabBarItems.length-1?S=0:S++,!(this._tabBarItems[S]instanceof WebInspector.PinnedTabBarItem))break;while(S!==_);S===_||(this.selectedTabBarItem=this._tabBarItems[S])}}get selectedTabBarItem(){return this._selectedTabBarItem}set selectedTabBarItem(_){let S=this._findTabBarItem(_);S===this._newTabTabBarItem&&(S=this._tabBarItems[this.normalTabCount-1]);this._selectedTabBarItem===S||(this._selectedTabBarItem&&(this._selectedTabBarItem.selected=!1),this._selectedTabBarItem=S||null,this._selectedTabBarItem&&(this._selectedTabBarItem.selected=!0),this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemSelected))}get tabBarItems(){return this._tabBarItems}get normalTabCount(){return this._tabBarItems.filter(_=>!(_ instanceof WebInspector.PinnedTabBarItem)).length}layout(){if(!this.element.classList.contains("static-layout")){this.element.classList.remove("hide-titles"),this.element.classList.remove("collapsed");let _=null;for(let S of this._tabBarItems)if(!(S instanceof WebInspector.PinnedTabBarItem)){_=S;break}_&&(120<=_.element.offsetWidth||(this.element.classList.add("collapsed"),75<=_.element.offsetWidth||this.element.classList.add("hide-titles")))}}_tabBarItemsFromLeftToRight(){return WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.LTR?this._tabBarItems:this._tabBarItems.slice().reverse()}_findTabBarItem(_){return"number"==typeof _?this._tabBarItems[_]||null:_ instanceof WebInspector.TabBarItem&&this._tabBarItems.includes(_)?_:null}_hasMoreThanOneNormalTab(){let _=0;for(let S of this._tabBarItems)if(!(S instanceof WebInspector.PinnedTabBarItem)&&(++_,2<=_))return!0;return!1}_openDefaultTab(){this.dispatchEventToListeners(WebInspector.TabBar.Event.OpenDefaultTab)}_recordTabBarItemSizesAndPositions(){var _=new Map;const S=this.element.getBoundingClientRect();for(var C of this._tabBarItems){var f=C.element.getBoundingClientRect();_.set(C,{left:f.left-S.left,width:f.width})}return _}_applyTabBarItemSizesAndPositions(_,S){for(var[C,f]of _)S&&C===S||(C.element.style.left=f.left+"px",C.element.style.width=f.width+"px")}_clearTabBarItemSizesAndPositions(_){for(var S of this._tabBarItems)_&&S===_||(S.element.style.left=null,S.element.style.width=null)}_finishExpandingTabsAfterClose(_){return new Promise(function(S){this._tabAnimatedClosedSinceMouseEnter=!1,_||(_=this._recordTabBarItemSizesAndPositions()),this.element.classList.remove("static-layout"),this._clearTabBarItemSizesAndPositions();var E=this._recordTabBarItemSizesAndPositions();this._applyTabBarItemSizesAndPositions(_),this.element.classList.add("static-layout");var I=function(){this.element.classList.remove("static-layout"),this.element.classList.remove("animating"),this.element.classList.remove("expanding-tabs"),this._clearTabBarItemSizesAndPositions(),this.updateLayout(),this.element.removeEventListener("webkitTransitionEnd",I),S()}.bind(this);requestAnimationFrame(function(){this.element.classList.add("static-layout"),this.element.classList.add("animating"),this.element.classList.add("expanding-tabs"),this._applyTabBarItemSizesAndPositions(E),this.element.addEventListener("webkitTransitionEnd",I)}.bind(this))}.bind(this))}_handleMouseDown(_){if(!(0!==_.button||_.ctrlKey)){let S=_.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.StyleClassName);if(S){let C=S[WebInspector.TabBarItem.ElementReferenceSymbol];if(C&&!C.disabled&&C!==this._newTabTabBarItem){let f=_.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.CloseButtonStyleClassName);if(!f&&(this.selectedTabBarItem=C,!(C instanceof WebInspector.PinnedTabBarItem)&&this._hasMoreThanOneNormalTab())){this._firstNormalTabItemIndex=0;for(let T=0;T<this._tabBarItems.length;++T)if(!(this._tabBarItems[T]instanceof WebInspector.PinnedTabBarItem)){this._firstNormalTabItemIndex=T;break}this._mouseIsDown=!0,this._mouseMovedEventListener=this._handleMouseMoved.bind(this),this._mouseUpEventListener=this._handleMouseUp.bind(this),document.addEventListener("mousemove",this._mouseMovedEventListener,!0),document.addEventListener("mouseup",this._mouseUpEventListener,!0),_.preventDefault(),_.stopPropagation()}}}}}_handleClick(_){var S=_.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.StyleClassName);if(S){var C=S[WebInspector.TabBarItem.ElementReferenceSymbol];if(C&&!C.disabled){const f=1===_.button;var T=_.target.enclosingNodeOrSelfWithClass(WebInspector.TabBarItem.CloseButtonStyleClassName);if(T||f){if(C.isDefaultTab&&this.element.classList.contains("single-tab"))return;if(!_.altKey)return void this.removeTabBarItem(C,{suppressExpansion:!0});for(let E=this._tabBarItems.length-1,I;0<=E;--E)I=this._tabBarItems[E],I===C||I instanceof WebInspector.PinnedTabBarItem||this.removeTabBarItem(I)}}}}_handleMouseMoved(_){if(this._mouseIsDown&&this._selectedTabBarItem){_.preventDefault(),_.stopPropagation(),this.element.classList.contains("static-layout")||(this._applyTabBarItemSizesAndPositions(this._recordTabBarItemSizesAndPositions()),this.element.classList.add("static-layout"),this.element.classList.add("dragging-tab")),void 0===this._mouseOffset&&(this._mouseOffset=_.pageX-this._selectedTabBarItem.element.totalOffsetLeft);var S=_.pageX-this.element.totalOffsetLeft,C=S-this._mouseOffset;this._selectedTabBarItem.element.style.left=C+"px";var f=C+this._selectedTabBarItem.element.realOffsetWidth/2,T=this._tabBarItems.indexOf(this._selectedTabBarItem),E=T;for(let D of this._tabBarItems)if(D!==this._selectedTabBarItem){var I=D.element.getBoundingClientRect();if(!(f<I.left||f>I.right)){E=this._tabBarItems.indexOf(D);break}}if(E=Number.constrain(E,this._firstNormalTabItemIndex,this.normalTabCount-1),T!==E){this._tabBarItems.splice(T,1),this._tabBarItems.splice(E,0,this._selectedTabBarItem);let R=this._tabBarItems[E+1],N=R?R.element:this._newTabTabBarItem.element;this.element.insertBefore(this._selectedTabBarItem.element,N);let L=0;for(let D of this._tabBarItemsFromLeftToRight())D!==this._selectedTabBarItem&&D!==this._newTabTabBarItem&&parseFloat(D.element.style.left)!==L&&(D.element.style.left=L+"px"),L+=parseFloat(D.element.style.width)}}}_handleMouseUp(_){if(this._mouseIsDown){if(this.element.classList.remove("dragging-tab"),!this._tabAnimatedClosedSinceMouseEnter)this.element.classList.remove("static-layout"),this._clearTabBarItemSizesAndPositions();else{let S=0;for(let C of this._tabBarItemsFromLeftToRight())C===this._selectedTabBarItem&&(C.element.style.left=S+"px"),S+=parseFloat(C.element.style.width)}this._mouseIsDown=!1,this._mouseOffset=void 0,document.removeEventListener("mousemove",this._mouseMovedEventListener,!0),document.removeEventListener("mouseup",this._mouseUpEventListener,!0),this._mouseMovedEventListener=null,this._mouseUpEventListener=null,_.preventDefault(),_.stopPropagation(),this.dispatchEventToListeners(WebInspector.TabBar.Event.TabBarItemsReordered)}}_handleMouseLeave(_){if(!this._mouseIsDown&&this._tabAnimatedClosedSinceMouseEnter&&this.element.classList.contains("static-layout")&&!this.element.classList.contains("animating")){const S=this.element.getBoundingClientRect(),C=this._newTabTabBarItem.element.getBoundingClientRect();_.pageY>S.top&&_.pageY<S.bottom&&_.pageX>S.left&&_.pageX<(C?C.right:S.right)||this._finishExpandingTabsAfterClose()}}_handleNewTabClick(){WebInspector.showNewTabTab()}_handleNewTabMouseEnter(){this._tabAnimatedClosedSinceMouseEnter&&this.element.classList.contains("static-layout")&&!this.element.classList.contains("animating")&&this._finishExpandingTabsAfterClose()}},WebInspector.TabBar.Event={TabBarItemSelected:"tab-bar-tab-bar-item-selected",TabBarItemAdded:"tab-bar-tab-bar-item-added",TabBarItemRemoved:"tab-bar-tab-bar-item-removed",TabBarItemsReordered:"tab-bar-tab-bar-items-reordered",OpenDefaultTab:"tab-bar-open-default-tab"},WebInspector.TabBarItem=class extends WebInspector.Object{constructor(_,S,C){super(),this._parentTabBar=null,this._element=document.createElement("div"),this._element.classList.add(WebInspector.TabBarItem.StyleClassName),this._element.setAttribute("role","tab"),this._element.tabIndex=0,this._element[WebInspector.TabBarItem.ElementReferenceSymbol]=this,this._element.createChild("div","flex-space"),this._iconElement=document.createElement("img"),this._iconElement.classList.add("icon"),this._element.appendChild(this._iconElement),this._element.createChild("div","flex-space"),this.title=S,this.image=_,this.representedObject=C}get element(){return this._element}get representedObject(){return this._representedObject}set representedObject(_){this._representedObject=_||null}get parentTabBar(){return this._parentTabBar}set parentTabBar(_){this._parentTabBar=_||null}get selected(){return this._element.classList.contains("selected")}set selected(_){this._element.classList.toggle("selected",_),_?this._element.setAttribute("aria-selected","true"):this._element.removeAttribute("aria-selected")}get disabled(){return this._element.classList.contains("disabled")}set disabled(_){this._element.classList.toggle("disabled",_)}get isDefaultTab(){return this._element.classList.contains("default-tab")}set isDefaultTab(_){this._element.classList.toggle("default-tab",_)}get image(){return this._iconElement.src}set image(_){this._iconElement.src=_||""}get title(){return this._element.title||""}set title(_){this._element.title=_||""}},WebInspector.TabBarItem.StyleClassName="item",WebInspector.TabBarItem.CloseButtonStyleClassName="close",WebInspector.TabBarItem.ElementReferenceSymbol=Symbol("tab-bar-item"),WebInspector.TabBrowser=class extends WebInspector.View{constructor(_,S,C,f){super(_),this.element.classList.add("tab-browser"),this._tabBar=S,this._navigationSidebar=C||null,this._detailsSidebar=f||null,this._navigationSidebar&&(this._navigationSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._sidebarCollapsedStateDidChange,this),this._navigationSidebar.addEventListener(WebInspector.Sidebar.Event.WidthDidChange,this._sidebarWidthDidChange,this)),this._detailsSidebar&&(this._detailsSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._sidebarCollapsedStateDidChange,this),this._detailsSidebar.addEventListener(WebInspector.Sidebar.Event.SidebarPanelSelected,this._sidebarPanelSelected,this),this._detailsSidebar.addEventListener(WebInspector.Sidebar.Event.WidthDidChange,this._sidebarWidthDidChange,this)),this._contentViewContainer=new WebInspector.ContentViewContainer,this.addSubview(this._contentViewContainer);let T=()=>{this._showNextTab()},E=()=>{this._showPreviousTab()},I=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL,R=I?WebInspector.KeyboardShortcut.Key.LeftCurlyBrace:WebInspector.KeyboardShortcut.Key.RightCurlyBrace,N=I?WebInspector.KeyboardShortcut.Key.RightCurlyBrace:WebInspector.KeyboardShortcut.Key.LeftCurlyBrace;this._showNextTabKeyboardShortcut1=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,R,T),this._showPreviousTabKeyboardShortcut1=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,N,E);let L=I?WebInspector.KeyboardShortcut.Modifier.Shift:0,D=I?0:WebInspector.KeyboardShortcut.Modifier.Shift;this._showNextTabKeyboardShortcut2=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.Control|L,WebInspector.KeyboardShortcut.Key.Tab,T),this._showPreviousTabKeyboardShortcut2=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.Control|D,WebInspector.KeyboardShortcut.Key.Tab,E);let M=I?WebInspector.KeyboardShortcut.Key.Right:WebInspector.KeyboardShortcut.Key.Left,P=I?WebInspector.KeyboardShortcut.Key.Left:WebInspector.KeyboardShortcut.Key.Right;this._previousTabKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,M,this._showPreviousTabCheckingForEditableField.bind(this)),this._previousTabKeyboardShortcut.implicitlyPreventsDefault=!1,this._nextTabKeyboardShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,P,this._showNextTabCheckingForEditableField.bind(this)),this._nextTabKeyboardShortcut.implicitlyPreventsDefault=!1,this._tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemSelected,this._tabBarItemSelected,this),this._tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemAdded,this._tabBarItemAdded,this),this._tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemRemoved,this._tabBarItemRemoved,this),this._tabBar.newTabTabBarItem.addEventListener(WebInspector.PinnedTabBarItem.Event.ContextMenu,this._handleNewTabContextMenu,this),this._recentTabContentViews=[],this._closedTabClasses=new Set}get tabBar(){return this._tabBar}get navigationSidebar(){return this._navigationSidebar}get detailsSidebar(){return this._detailsSidebar}get selectedTabContentView(){return this._contentViewContainer.currentContentView}bestTabContentViewForClass(_){for(var S of this._recentTabContentViews)if(S instanceof _)return S;return null}bestTabContentViewForRepresentedObject(_,S={}){for(var C of this._recentTabContentViews)if(!(S.ignoreSearchTab&&C instanceof WebInspector.SearchTabContentView)&&!(S.ignoreNetworkTab&&C instanceof WebInspector.NetworkTabContentView)&&C.canShowRepresentedObject(_))return C;return null}addTabForContentView(_,S={}){if(!(_ instanceof WebInspector.TabContentView))return!1;let C=_.tabBarItem;return!!(C instanceof WebInspector.TabBarItem)&&(!(C.representedObject!==_&&(C.representedObject=_),_.parentTabBrowser=this,C.parentTabBar!==this._tabBar)||(this._recentTabContentViews.length&&this.selectedTabContentView?this._recentTabContentViews.splice(1,0,_):this._recentTabContentViews.push(_),"number"==typeof S.insertionIndex?this._tabBar.insertTabBarItem(C,S.insertionIndex,S):this._tabBar.addTabBarItem(C,S),!0))}showTabForContentView(_,S={}){return!!this.addTabForContentView(_,S)&&(S.suppressSelection||(this._tabBar.selectedTabBarItem=_.tabBarItem),this.needsLayout(),!0)}closeTabForContentView(_,S={}){return!!(_ instanceof WebInspector.TabContentView)&&!!(_.tabBarItem instanceof WebInspector.TabBarItem)&&!(_.tabBarItem.parentTabBar!==this._tabBar)&&(this._tabBar.removeTabBarItem(_.tabBarItem,S),!0)}layout(){if(this.layoutReason===WebInspector.View.LayoutReason.Resize)for(let _ of this._recentTabContentViews)_[WebInspector.TabBrowser.NeedsResizeLayoutSymbol]=_!==this.selectedTabContentView}_tabBarItemSelected(){let S=this._tabBar.selectedTabBarItem?this._tabBar.selectedTabBarItem.representedObject:null;if(S){let C=S instanceof WebInspector.SettingsTabContentView;C||(this._recentTabContentViews.remove(S),this._recentTabContentViews.unshift(S)),this._contentViewContainer.showContentView(S)}else this._contentViewContainer.closeAllContentViews();this._showNavigationSidebarPanelForTabContentView(S),this._showDetailsSidebarPanelsForTabContentView(S),S&&S[WebInspector.TabBrowser.NeedsResizeLayoutSymbol]&&(S[WebInspector.TabBrowser.NeedsResizeLayoutSymbol]=!1,S.updateLayout(WebInspector.View.LayoutReason.Resize)),this.dispatchEventToListeners(WebInspector.TabBrowser.Event.SelectedTabContentViewDidChange)}_tabBarItemAdded(_){let S=_.data.tabBarItem.representedObject;S&&this._closedTabClasses.delete(S.constructor)}_tabBarItemRemoved(_){let S=_.data.tabBarItem.representedObject;S&&(this._recentTabContentViews.remove(S),!S.constructor.isEphemeral()&&this._closedTabClasses.add(S.constructor),this._contentViewContainer.closeContentView(S),S.parentTabBrowser=null)}_handleNewTabContextMenu(_){let S=Array.from(this._closedTabClasses).reverse(),C=Array.from(WebInspector.knownTabClasses()),f=S.concat(C.filter(E=>{return!S.includes(E)&&!E.isEphemeral()&&WebInspector.isNewTabWithTypeAllowed(E.Type)}));if(f.length){let T=_.data.contextMenu;T.appendItem(WebInspector.UIString("Recently Closed Tabs"),null,!0);for(let E of f)T.appendItem(E.tabInfo().title,()=>{WebInspector.createNewTabWithType(E.Type,{shouldShowNewTab:!0})})}}_sidebarPanelSelected(){if(!this._ignoreSidebarEvents){var S=this.selectedTabContentView;if(S&&!S.managesDetailsSidebarPanels){var C=this._detailsSidebar.selectedSidebarPanel;S.detailsSidebarSelectedPanelSetting.value=C?C.identifier:null}}}_sidebarCollapsedStateDidChange(_){if(!this._ignoreSidebarEvents){var S=this.selectedTabContentView;S&&(_.target===this._navigationSidebar?S.navigationSidebarCollapsedSetting.value=this._navigationSidebar.collapsed:_.target===this._detailsSidebar&&!S.managesDetailsSidebarPanels&&(S.detailsSidebarCollapsedSetting.value=this._detailsSidebar.collapsed))}}_sidebarWidthDidChange(_){if(!this._ignoreSidebarEvents&&_.data){let S=this.selectedTabContentView;if(S)switch(_.target){case this._navigationSidebar:S.navigationSidebarWidthSetting.value=_.data.newWidth;break;case this._detailsSidebar:S.detailsSidebarWidthSetting.value=_.data.newWidth;}}}_showNavigationSidebarPanelForTabContentView(_){if(this._navigationSidebar){if(this._ignoreSidebarEvents=!0,this._navigationSidebar.removeSidebarPanel(0),!_)return void(this._ignoreSidebarEvents=!1);_.navigationSidebarWidthSetting.value&&(this._navigationSidebar.width=_.navigationSidebarWidthSetting.value);var S=_.navigationSidebarPanel;return S?void(this._navigationSidebar.addSidebarPanel(S),this._navigationSidebar.selectedSidebarPanel=S,this._navigationSidebar.collapsed=_.navigationSidebarCollapsedSetting.value,this._ignoreSidebarEvents=!1):(this._navigationSidebar.collapsed=!0,void(this._ignoreSidebarEvents=!1))}}_showDetailsSidebarPanelsForTabContentView(_){if(this._detailsSidebar){this._ignoreSidebarEvents=!0;for(var S=this._detailsSidebar.sidebarPanels.length-1;0<=S;--S)this._detailsSidebar.removeSidebarPanel(S);if(!_)return void(this._ignoreSidebarEvents=!1);if(_.detailsSidebarWidthSetting.value&&(this._detailsSidebar.width=_.detailsSidebarWidthSetting.value),_.managesDetailsSidebarPanels)return _.showDetailsSidebarPanels(),void(this._ignoreSidebarEvents=!1);var C=_.detailsSidebarPanels;if(!C)return this._detailsSidebar.collapsed=!0,void(this._ignoreSidebarEvents=!1);for(var f of C)this._detailsSidebar.addSidebarPanel(f);this._detailsSidebar.selectedSidebarPanel=_.detailsSidebarSelectedPanelSetting.value||C[0],this._detailsSidebar.collapsed=_.detailsSidebarCollapsedSetting.value||!C.length,this._ignoreSidebarEvents=!1}}_showPreviousTab(){this._tabBar.selectPreviousTab()}_showNextTab(){this._tabBar.selectNextTab()}_showNextTabCheckingForEditableField(_){WebInspector.isEventTargetAnEditableField(_)||(this._showNextTab(_),_.preventDefault())}_showPreviousTabCheckingForEditableField(_){WebInspector.isEventTargetAnEditableField(_)||(this._showPreviousTab(_),_.preventDefault())}},WebInspector.TabBrowser.NeedsResizeLayoutSymbol=Symbol("needs-resize-layout"),WebInspector.TabBrowser.Event={SelectedTabContentViewDidChange:"tab-browser-selected-tab-content-view-did-change"},WebInspector.TextEditor=class extends WebInspector.View{constructor(_,S,C){super(_),this.element.classList.add("text-editor",WebInspector.SyntaxHighlightedStyleClassName),this._codeMirror=WebInspector.CodeMirrorEditor.create(this.element,{readOnly:!0,indentWithTabs:WebInspector.settings.indentWithTabs.value,indentUnit:WebInspector.settings.indentUnit.value,tabSize:WebInspector.settings.tabSize.value,lineNumbers:!0,lineWrapping:WebInspector.settings.enableLineWrapping.value,matchBrackets:!0,autoCloseBrackets:!0,showWhitespaceCharacters:WebInspector.settings.showWhitespaceCharacters.value,styleSelectedText:!0}),WebInspector.settings.indentWithTabs.addEventListener(WebInspector.Setting.Event.Changed,()=>{this._codeMirror.setOption("indentWithTabs",WebInspector.settings.indentWithTabs.value)}),WebInspector.settings.indentUnit.addEventListener(WebInspector.Setting.Event.Changed,()=>{this._codeMirror.setOption("indentUnit",WebInspector.settings.indentUnit.value)}),WebInspector.settings.tabSize.addEventListener(WebInspector.Setting.Event.Changed,()=>{this._codeMirror.setOption("tabSize",WebInspector.settings.tabSize.value)}),WebInspector.settings.enableLineWrapping.addEventListener(WebInspector.Setting.Event.Changed,()=>{this._codeMirror.setOption("lineWrapping",WebInspector.settings.enableLineWrapping.value)}),WebInspector.settings.showWhitespaceCharacters.addEventListener(WebInspector.Setting.Event.Changed,()=>{this._codeMirror.setOption("showWhitespaceCharacters",WebInspector.settings.showWhitespaceCharacters.value)}),this._codeMirror.on("change",this._contentChanged.bind(this)),this._codeMirror.on("gutterClick",this._gutterMouseDown.bind(this)),this._codeMirror.on("gutterContextMenu",this._gutterContextMenu.bind(this)),this._codeMirror.getScrollerElement().addEventListener("click",this._openClickedLinks.bind(this),!0),this._completionController=new WebInspector.CodeMirrorCompletionController(this._codeMirror,this),this._tokenTrackingController=new WebInspector.CodeMirrorTokenTrackingController(this._codeMirror,this),this._initialStringNotSet=!0,this.mimeType=S,this._breakpoints={},this._executionLineNumber=NaN,this._executionColumnNumber=NaN,this._executionLineHandle=null,this._executionMultilineHandles=[],this._executionRangeHighlightMarker=null,this._searchQuery=null,this._searchResults=[],this._currentSearchResultIndex=-1,this._ignoreCodeMirrorContentDidChangeEvent=0,this._formatted=!1,this._formattingPromise=null,this._formatterSourceMap=null,this._deferReveal=!1,this._delegate=C||null}get visible(){return this._visible}get string(){return this._codeMirror.getValue()}set string(_){this._ignoreCodeMirrorContentDidChangeEvent++,this._codeMirror.operation(function(){for(var C in this._initialStringNotSet&&this._codeMirror.removeLineClass(0,"wrap"),this._codeMirror.getValue()===_?this.layout():this._codeMirror.setValue(_),this._initialStringNotSet&&(this._codeMirror.clearHistory(),this._codeMirror.markClean(),this._initialStringNotSet=!1),this._updateExecutionLine(),this._updateExecutionRangeHighlight(),this._breakpoints)this._setBreakpointStylesOnLine(C);this._revealPendingPositionIfPossible()}.bind(this)),this._ignoreCodeMirrorContentDidChangeEvent--}get readOnly(){return this._codeMirror.getOption("readOnly")||!1}set readOnly(_){this._codeMirror.setOption("readOnly",_)}get formatted(){return this._formatted}get hasModified(){let _=this._codeMirror.historySize().undo;return this._formatted&&_--,0<_}updateFormattedState(_){return this._format(_).catch(handlePromiseException)}hasFormatter(){let _=this._codeMirror.getMode().name;return"javascript"===_||"css"===_}canBeFormatted(){return this.hasFormatter()}canShowTypeAnnotations(){return!1}canShowCoverageHints(){return!1}get selectedTextRange(){var _=this._codeMirror.getCursor(!0),S=this._codeMirror.getCursor(!1);return this._textRangeFromCodeMirrorPosition(_,S)}set selectedTextRange(_){var S=this._codeMirrorPositionFromTextRange(_);this._codeMirror.setSelection(S.start,S.end)}get mimeType(){return this._mimeType}set mimeType(_){_=parseMIMEType(_).type,this._mimeType=_,this._codeMirror.setOption("mode",{name:_,globalVars:!0})}get executionLineNumber(){return this._executionLineNumber}get executionColumnNumber(){return this._executionColumnNumber}get formatterSourceMap(){return this._formatterSourceMap}get tokenTrackingController(){return this._tokenTrackingController}get delegate(){return this._delegate}set delegate(_){this._delegate=_||null}get numberOfSearchResults(){return this._searchResults.length}get currentSearchQuery(){return this._searchQuery}set automaticallyRevealFirstSearchResult(_){this._automaticallyRevealFirstSearchResult=_,this._automaticallyRevealFirstSearchResult&&0<this._searchResults.length&&-1===this._currentSearchResultIndex&&this._revealFirstSearchResultAfterCursor()}set deferReveal(_){this._deferReveal=_}performSearch(_){function S(){I&&(clearTimeout(I),I=null),this.dispatchEventToListeners(WebInspector.TextEditor.Event.NumberOfSearchResultsDidChange)}function C(){if(this._searchQuery===_){for(var R=[],N=!1,L=0,D;L<WebInspector.TextEditor.NumberOfFindsPerSearchBatch&&(N=T.findNext());++L)D=this._textRangeFromCodeMirrorPosition(T.from(),T.to()),R.push(D);this.addSearchResults(R),I||(I=setTimeout(S.bind(this),500)),N?setTimeout(E,50):S.call(this)}}if(this._searchQuery!==_&&(this.searchCleared(),this._searchQuery=_,"function"!=typeof this.customPerformSearch||this.formatted||!this.customPerformSearch(_))){var f=new RegExp(_.escapeForRegExp(),"gi"),T=this._codeMirror.getSearchCursor(f,{line:0,ch:0},!1),E=C.bind(this),I=null;E()}}setExecutionLineAndColumn(_,S){!this._executionLineHandle&&isNaN(_)||(this._executionLineNumber=_,this._executionColumnNumber=S,!this._initialStringNotSet&&(this._updateExecutionLine(),this._updateExecutionRangeHighlight()),this.dispatchEventToListeners(WebInspector.TextEditor.Event.ExecutionLineNumberDidChange))}addSearchResults(_){_&&_.length&&this._codeMirror.operation(function(){for(var C=0;C<_.length;++C){var f=this._codeMirrorPositionFromTextRange(_[C]),T=this._codeMirror.markText(f.start,f.end,{className:WebInspector.TextEditor.SearchResultStyleClassName});this._searchResults.push(T)}this._automaticallyRevealFirstSearchResult&&-1===this._currentSearchResultIndex&&this._revealFirstSearchResultAfterCursor()}.bind(this))}searchCleared(){this._codeMirror.operation(function(){for(var S=0;S<this._searchResults.length;++S)this._searchResults[S].clear()}.bind(this)),this._searchQuery=null,this._searchResults=[],this._currentSearchResultIndex=-1}searchQueryWithSelection(){return this._codeMirror.somethingSelected()?this._codeMirror.getSelection():null}revealPreviousSearchResult(_){return this._searchResults.length?-1===this._currentSearchResultIndex||this._cursorDoesNotMatchLastRevealedSearchResult()?void this._revealFirstSearchResultBeforeCursor(_):void(0<this._currentSearchResultIndex?--this._currentSearchResultIndex:this._currentSearchResultIndex=this._searchResults.length-1,this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],_,-1)):void 0}revealNextSearchResult(_){return this._searchResults.length?-1===this._currentSearchResultIndex||this._cursorDoesNotMatchLastRevealedSearchResult()?void this._revealFirstSearchResultAfterCursor(_):void(this._currentSearchResultIndex+1<this._searchResults.length?++this._currentSearchResultIndex:this._currentSearchResultIndex=0,this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],_,1)):void 0}line(_){return this._codeMirror.getLine(_)}getTextInRange(_,S){return this._codeMirror.getRange(_,S)}addStyleToTextRange(_,S,C){return S.ch+=1,this._codeMirror.getDoc().markText(_,S,{className:C,inclusiveLeft:!0,inclusiveRight:!0})}revealPosition(_,S,C,f){function T(){this._codeMirror.removeLineClass(R,"wrap",WebInspector.TextEditor.HighlightedStyleClassName)}function E(){var N=this._codeMirrorPositionFromTextRange(S);this._isPositionVisible(N.start)||this._scrollIntoViewCentered(N.start),this.selectedTextRange=S,f||WebInspector.debuggerManager.paused&&I===this._executionLineNumber||(this._codeMirror.addLineClass(R,"wrap",WebInspector.TextEditor.HighlightedStyleClassName),setTimeout(T.bind(this),WebInspector.TextEditor.HighlightAnimationDuration))}if(_ instanceof WebInspector.SourceCodePosition){if(!this._visible||this._initialStringNotSet||this._deferReveal)return this._positionToReveal=_,this._textRangeToSelect=S,void(this._forceUnformatted=C);if(delete this._positionToReveal,delete this._textRangeToSelect,delete this._forceUnformatted,this._formatted&&C)return void this.updateFormattedState(!1).then(()=>{setTimeout(this.revealPosition.bind(this),0,_,S)});let I=Number.constrain(_.lineNumber,0,this._codeMirror.lineCount()-1),R=this._codeMirror.getLineHandle(I);if(!S){let N=Number.constrain(_.columnNumber,0,this._codeMirror.getLine(I).length-1);S=new WebInspector.TextRange(I,N,I,N)}this._codeMirror.operation(E.bind(this))}}shown(){this._visible=!0,this._codeMirror.refresh(),this._revealPendingPositionIfPossible()}hidden(){this._visible=!1}close(){WebInspector.settings.indentWithTabs.removeEventListener(null,null,this),WebInspector.settings.indentUnit.removeEventListener(null,null,this),WebInspector.settings.tabSize.removeEventListener(null,null,this),WebInspector.settings.enableLineWrapping.removeEventListener(null,null,this),WebInspector.settings.showWhitespaceCharacters.removeEventListener(null,null,this)}setBreakpointInfoForLineAndColumn(_,S,C){this._ignoreSetBreakpointInfoCalls||(C?this._addBreakpointToLineAndColumnWithInfo(_,S,C):this._removeBreakpointFromLineAndColumn(_,S))}updateBreakpointLineAndColumn(_,S,C,f){if(this._breakpoints[_]&&this._breakpoints[_][S]){var T=this._breakpoints[_][S];this._removeBreakpointFromLineAndColumn(_,S),this._addBreakpointToLineAndColumnWithInfo(C,f,T)}}addStyleClassToLine(_,S){var C=this._codeMirror.getLineHandle(_);return C?this._codeMirror.addLineClass(C,"wrap",S):null}removeStyleClassFromLine(_,S){var C=this._codeMirror.getLineHandle(_);return C?this._codeMirror.removeLineClass(C,"wrap",S):null}toggleStyleClassForLine(_,S){var C=this._codeMirror.getLineHandle(_);return!!C&&this._codeMirror.toggleLineClass(C,"wrap",S)}createWidgetForLine(_){var S=this._codeMirror.getLineHandle(_);if(!S)return null;var C=document.createElement("div"),f=this._codeMirror.addLineWidget(S,C,{coverGutter:!1,noHScroll:!0});return new WebInspector.LineWidget(f,C)}get lineCount(){return this._codeMirror.lineCount()}focus(){this._codeMirror.focus()}contentDidChange(){}rectsForRange(_){return this._codeMirror.rectsForRange(_)}get markers(){return this._codeMirror.getAllMarks().map(WebInspector.TextMarker.textMarkerForCodeMirrorTextMarker)}markersAtPosition(_){return this._codeMirror.findMarksAt(_).map(WebInspector.TextMarker.textMarkerForCodeMirrorTextMarker)}createColorMarkers(_){return createCodeMirrorColorTextMarkers(this._codeMirror,_)}createGradientMarkers(_){return createCodeMirrorGradientTextMarkers(this._codeMirror,_)}createCubicBezierMarkers(_){return createCodeMirrorCubicBezierTextMarkers(this._codeMirror,_)}createSpringMarkers(_){return createCodeMirrorSpringTextMarkers(this._codeMirror,_)}editingControllerForMarker(_){switch(_.type){case WebInspector.TextMarker.Type.Color:return new WebInspector.CodeMirrorColorEditingController(this._codeMirror,_);case WebInspector.TextMarker.Type.Gradient:return new WebInspector.CodeMirrorGradientEditingController(this._codeMirror,_);case WebInspector.TextMarker.Type.CubicBezier:return new WebInspector.CodeMirrorBezierEditingController(this._codeMirror,_);case WebInspector.TextMarker.Type.Spring:return new WebInspector.CodeMirrorSpringEditingController(this._codeMirror,_);default:return new WebInspector.CodeMirrorEditingController(this._codeMirror,_);}}visibleRangeOffsets(){var _=null,S=null,C=this._codeMirror.getViewport();return this._formatterSourceMap?(_=this._formatterSourceMap.formattedToOriginalOffset(Math.max(C.from-1,0),0),S=this._formatterSourceMap.formattedToOriginalOffset(C.to-1,0)):(_=this._codeMirror.getDoc().indexFromPos({line:C.from,ch:0}),S=this._codeMirror.getDoc().indexFromPos({line:C.to,ch:0})),{startOffset:_,endOffset:S}}originalOffsetToCurrentPosition(_){var S=null;if(this._formatterSourceMap){var C=this._formatterSourceMap.originalPositionToFormatted(_);S={line:C.lineNumber,ch:C.columnNumber}}else S=this._codeMirror.getDoc().posFromIndex(_);return S}currentOffsetToCurrentPosition(_){return this._codeMirror.getDoc().posFromIndex(_)}currentPositionToOriginalOffset(_){let S=null;return S=this._formatterSourceMap?this._formatterSourceMap.formattedToOriginalOffset(_.line,_.ch):this._codeMirror.getDoc().indexFromPos(_),S}currentPositionToOriginalPosition(_){if(!this._formatterSourceMap)return _;let S=this._formatterSourceMap.formattedToOriginal(_.line,_.ch);return{line:S.lineNumber,ch:S.columnNumber}}currentPositionToCurrentOffset(_){return this._codeMirror.getDoc().indexFromPos(_)}setInlineWidget(_,S){return this._codeMirror.setUniqueBookmark(_,{widget:S})}addScrollHandler(_){this._codeMirror.on("scroll",_)}removeScrollHandler(_){this._codeMirror.off("scroll",_)}layout(){this._visible&&this._codeMirror.refresh()}_format(_){return this._formatted===_?Promise.resolve(this._formatted):_&&!this.canBeFormatted()?Promise.resolve(this._formatted):this._formattingPromise?this._formattingPromise:(this._ignoreCodeMirrorContentDidChangeEvent++,this._formattingPromise=this.prettyPrint(_).then(()=>{this._ignoreCodeMirrorContentDidChangeEvent--,this._formattingPromise=null;let S=this._formatted;return this._formatted=!!this._formatterSourceMap,this._formatted!==S&&this.dispatchEventToListeners(WebInspector.TextEditor.Event.FormattingDidChange),this._formatted}),this._formattingPromise)}prettyPrint(_){return new Promise(S=>{let f={selectionAnchor:this._codeMirror.getCursor("anchor"),selectionHead:this._codeMirror.getCursor("head")};_?this._canUseFormatterWorker()?this._startWorkerPrettyPrint(f,S):this._startCodeMirrorPrettyPrint(f,S):this._undoFormatting(f,S)})}_canUseFormatterWorker(){return"javascript"===this._codeMirror.getMode().name}_startWorkerPrettyPrint(_,S){let C=this._codeMirror.getValue(),f=WebInspector.indentString();let E=this._delegate?this._delegate.textEditorScriptSourceType(this):WebInspector.Script.SourceType.Program;const I=E===WebInspector.Script.SourceType.Module;let R=WebInspector.FormatterWorkerProxy.singleton();R.formatJavaScript(C,I,f,!0,({formattedText:N,sourceMapData:L})=>{return null===N?void S():void this._finishPrettyPrint(_,N,L,S)})}_startCodeMirrorPrettyPrint(_,S){let C=WebInspector.indentString(),T={line:this._codeMirror.lineCount()-1},E=new FormatterContentBuilder(C),I=new WebInspector.Formatter(this._codeMirror,E);I.format({line:0,ch:0},T);let R=E.formattedContent,N=E.sourceMapData;this._finishPrettyPrint(_,R,N,S)}_finishPrettyPrint(_,S,C,f){this._codeMirror.operation(()=>{this._formatterSourceMap=WebInspector.FormatterSourceMap.fromSourceMapData(C),this._codeMirror.setValue(S),this._updateAfterFormatting(!0,_)}),f()}_undoFormatting(_,S){this._codeMirror.operation(()=>{this._codeMirror.undo(),this._updateAfterFormatting(!1,_)}),S()}_updateAfterFormatting(_,S){let C=S.selectionAnchor,f=S.selectionHead,I=null,T,E;if(_){if(this._positionToReveal){let L=this._formatterSourceMap.originalToFormatted(this._positionToReveal.lineNumber,this._positionToReveal.columnNumber);this._positionToReveal=new WebInspector.SourceCodePosition(L.lineNumber,L.columnNumber)}if(this._textRangeToSelect){let L=this._formatterSourceMap.originalToFormatted(this._textRangeToSelect.startLine,this._textRangeToSelect.startColumn),D=this._formatterSourceMap.originalToFormatted(this._textRangeToSelect.endLine,this._textRangeToSelect.endColumn);this._textRangeToSelect=new WebInspector.TextRange(L.lineNumber,L.columnNumber,D.lineNumber,D.columnNumber)}isNaN(this._executionLineNumber)||(I=this._formatterSourceMap.originalToFormatted(this._executionLineNumber,this._executionColumnNumber));let R=this._formatterSourceMap.originalToFormatted(C.line,C.ch),N=this._formatterSourceMap.originalToFormatted(f.line,f.ch);T={line:R.lineNumber,ch:R.columnNumber},E={line:N.lineNumber,ch:N.columnNumber}}else{if(this._positionToReveal){let L=this._formatterSourceMap.formattedToOriginal(this._positionToReveal.lineNumber,this._positionToReveal.columnNumber);this._positionToReveal=new WebInspector.SourceCodePosition(L.lineNumber,L.columnNumber)}if(this._textRangeToSelect){let L=this._formatterSourceMap.formattedToOriginal(this._textRangeToSelect.startLine,this._textRangeToSelect.startColumn),D=this._formatterSourceMap.formattedToOriginal(this._textRangeToSelect.endLine,this._textRangeToSelect.endColumn);this._textRangeToSelect=new WebInspector.TextRange(L.lineNumber,L.columnNumber,D.lineNumber,D.columnNumber)}isNaN(this._executionLineNumber)||(I=this._formatterSourceMap.formattedToOriginal(this._executionLineNumber,this._executionColumnNumber));let R=this._formatterSourceMap.formattedToOriginal(C.line,C.ch),N=this._formatterSourceMap.formattedToOriginal(f.line,f.ch);T={line:R.lineNumber,ch:R.columnNumber},E={line:N.lineNumber,ch:N.columnNumber},this._formatterSourceMap=null}if(this._scrollIntoViewCentered(T),this._codeMirror.setSelection(T,E),I&&(this._executionLineHandle=null,this._executionMultilineHandles=[],this.setExecutionLineAndColumn(I.lineNumber,I.columnNumber)),this.currentSearchQuery){let R=this.currentSearchQuery;this.searchCleared(),setTimeout(()=>{this.performSearch(R)},0)}this._delegate&&"function"==typeof this._delegate.textEditorUpdatedFormatting&&this._delegate.textEditorUpdatedFormatting(this)}hasEdits(){return!this._codeMirror.isClean()}_contentChanged(_,S){if(!(0<this._ignoreCodeMirrorContentDidChangeEvent)){for(var C=[],f=[];S;)C.push(new WebInspector.TextRange(S.from.line,S.from.ch,S.to.line,S.to.ch)),f.push(new WebInspector.TextRange(S.from.line,S.from.ch,S.from.line+S.text.length-1,1===S.text.length?S.from.ch+S.text[0].length:S.text.lastValue.length)),S=S.next;this.contentDidChange(C,f),this._formatted&&(this._formatterSourceMap=null,this._formatted=!1,this._delegate&&"function"==typeof this._delegate.textEditorUpdatedFormatting&&this._delegate.textEditorUpdatedFormatting(this),this.dispatchEventToListeners(WebInspector.TextEditor.Event.FormattingDidChange)),this.dispatchEventToListeners(WebInspector.TextEditor.Event.ContentDidChange)}}_textRangeFromCodeMirrorPosition(_,S){return new WebInspector.TextRange(_.line,_.ch,S.line,S.ch)}_codeMirrorPositionFromTextRange(_){var S={line:_.startLine,ch:_.startColumn},C={line:_.endLine,ch:_.endColumn};return{start:S,end:C}}_revealPendingPositionIfPossible(){this._positionToReveal&&this._visible&&this.revealPosition(this._positionToReveal,this._textRangeToSelect,this._forceUnformatted)}_revealSearchResult(_,S,C){var T=_.find();if(!T)return void this._revalidateSearchResults(C);this._isPositionVisible(T.from)||this._scrollIntoViewCentered(T.from),this.selectedTextRange=this._textRangeFromCodeMirrorPosition(T.from,T.to),this._automaticallyRevealFirstSearchResult=!1,S&&this._codeMirror.focus(),this._bouncyHighlightElement&&this._bouncyHighlightElement.remove(),this._bouncyHighlightElement=document.createElement("div"),this._bouncyHighlightElement.className=WebInspector.TextEditor.BouncyHighlightStyleClassName;var E=this._codeMirror.getSelection(),I=this._codeMirror.cursorCoords(!0,"page");let R=this.element.getBoundingClientRect();I.top-=R.top,I.left-=R.left,this._bouncyHighlightElement.textContent=E,this._bouncyHighlightElement.style.top=I.top+"px",this._bouncyHighlightElement.style.left=I.left+"px",this.element.appendChild(this._bouncyHighlightElement);let N=()=>{this._bouncyHighlightElement&&this._bouncyHighlightElement.remove()};this.addScrollHandler(N),this._bouncyHighlightElement.addEventListener("animationend",function(){this._bouncyHighlightElement&&(this._bouncyHighlightElement.remove(),delete this._bouncyHighlightElement,this.removeScrollHandler(N))}.bind(this))}_binarySearchInsertionIndexInSearchResults(_,S){for(var C=this._searchResults,f=0,T=C.length-1;f<=T;){var E=f+T>>1,I=S(_,C[E]);if(null===I)return null;if(0<I)f=E+1;else if(0>I)T=E-1;else return E}return f-1}_revealFirstSearchResultBeforeCursor(_){var S=this._codeMirror.getCursor("start");if(0===S.line&&0===S.ch)return this._currentSearchResultIndex=this._searchResults.length-1,void this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],_,-1);var C=this._binarySearchInsertionIndexInSearchResults(S,function(f,T){var E=T.find();return E?WebInspector.compareCodeMirrorPositions(f,E.from):null});return null===C?void this._revalidateSearchResults(-1):void(this._currentSearchResultIndex=C,this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],_))}_revealFirstSearchResultAfterCursor(_){var S=this._codeMirror.getCursor("start");if(0===S.line&&0===S.ch)return this._currentSearchResultIndex=0,void this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],_,1);var C=this._binarySearchInsertionIndexInSearchResults(S,function(f,T){var E=T.find();return E?WebInspector.compareCodeMirrorPositions(f,E.from):null});return null===C?void this._revalidateSearchResults(1):void(C+1<this._searchResults.length?++C:C=0,this._currentSearchResultIndex=C,this._revealSearchResult(this._searchResults[this._currentSearchResultIndex],_))}_cursorDoesNotMatchLastRevealedSearchResult(){var _=this._searchResults[this._currentSearchResultIndex].find();if(!_)return!0;var S=this._codeMirror.getCursor("start"),C=_.from;return 0!==WebInspector.compareCodeMirrorPositions(S,C)}_revalidateSearchResults(_){this._currentSearchResultIndex=-1;for(var S=[],C=0;C<this._searchResults.length;++C)this._searchResults[C].find()&&S.push(this._searchResults[C]);this._searchResults=S,this.dispatchEventToListeners(WebInspector.TextEditor.Event.NumberOfSearchResultsDidChange),this._searchResults.length&&(0<_?this._revealFirstSearchResultAfterCursor():this._revealFirstSearchResultBeforeCursor())}_clearMultilineExecutionLineHighlights(){if(this._executionMultilineHandles.length){for(let _ of this._executionMultilineHandles)this._codeMirror.removeLineClass(_,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName);this._executionMultilineHandles=[]}}_updateExecutionLine(){this._codeMirror.operation(()=>{this._executionLineHandle&&(this._codeMirror.removeLineClass(this._executionLineHandle,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName),this._codeMirror.removeLineClass(this._executionLineHandle,"wrap","primary")),this._clearMultilineExecutionLineHighlights(),this._executionLineHandle=isNaN(this._executionLineNumber)?null:this._codeMirror.getLineHandle(this._executionLineNumber),this._executionLineHandle&&(this._codeMirror.addLineClass(this._executionLineHandle,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName),this._codeMirror.addLineClass(this._executionLineHandle,"wrap","primary"),this._codeMirror.removeLineClass(this._executionLineHandle,"wrap",WebInspector.TextEditor.HighlightedStyleClassName))})}_updateExecutionRangeHighlight(){if(this._executionRangeHighlightMarker&&(this._executionRangeHighlightMarker.clear(),this._executionRangeHighlightMarker=null),!isNaN(this._executionLineNumber)){let _={line:this._executionLineNumber,ch:this._executionColumnNumber},S=this.currentPositionToOriginalOffset(_),C=this.currentPositionToOriginalPosition(_),f=new WebInspector.SourceCodePosition(C.line,C.ch),T=this._codeMirror.getRange(_,{line:this._executionLineNumber,ch:this._executionColumnNumber+1});this._delegate.textEditorExecutionHighlightRange(S,f,T,E=>{let I,R;E?(I=this.originalOffsetToCurrentPosition(E[0]),R=this.originalOffsetToCurrentPosition(E[1])):(I={line:this._executionLineNumber,ch:this._executionColumnNumber},R={line:this._executionLineNumber}),this._executionRangeHighlightMarker&&(this._executionRangeHighlightMarker.clear(),this._executionRangeHighlightMarker=null);let N=this._codeMirror.getRange(I,R),L=N.match(/\s+$/);if(L&&(R.ch=Math.max(0,R.ch-L[0].length)),this._clearMultilineExecutionLineHighlights(),I.line!==R.line)for(let D=I.line,M;D<R.line;++D)M=this._codeMirror.getLineHandle(D),this._codeMirror.addLineClass(M,"wrap",WebInspector.TextEditor.ExecutionLineStyleClassName),this._executionMultilineHandles.push(M);this._executionRangeHighlightMarker=this._codeMirror.markText(I,R,{className:"execution-range-highlight"})})}}_setBreakpointStylesOnLine(_){function S(){var L=this._codeMirror.getLineHandle(_);L&&(this._codeMirror.addLineClass(L,"wrap",WebInspector.TextEditor.HasBreakpointStyleClassName),T?this._codeMirror.addLineClass(L,"wrap",WebInspector.TextEditor.BreakpointResolvedStyleClassName):this._codeMirror.removeLineClass(L,"wrap",WebInspector.TextEditor.BreakpointResolvedStyleClassName),f?this._codeMirror.addLineClass(L,"wrap",WebInspector.TextEditor.BreakpointDisabledStyleClassName):this._codeMirror.removeLineClass(L,"wrap",WebInspector.TextEditor.BreakpointDisabledStyleClassName),E?this._codeMirror.addLineClass(L,"wrap",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName):this._codeMirror.removeLineClass(L,"wrap",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName),I?this._codeMirror.addLineClass(L,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName):this._codeMirror.removeLineClass(L,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName))}var C=this._breakpoints[_];if(C){var f=!0,T=!0,E=!0,I=1<Object.keys(C).length;for(var R in C){var N=C[R];N.disabled||(f=!1),N.resolved||(T=!1),N.autoContinue||(E=!1)}T=T&&WebInspector.debuggerManager.breakpointsEnabled,this._codeMirror.operation(S.bind(this))}}_addBreakpointToLineAndColumnWithInfo(_,S,C){this._breakpoints[_]||(this._breakpoints[_]={}),this._breakpoints[_][S]=C,this._setBreakpointStylesOnLine(_)}_removeBreakpointFromLineAndColumn(_,S){return delete this._breakpoints[_][S],isEmptyObject(this._breakpoints[_])?void(delete this._breakpoints[_],this._codeMirror.operation(function(){var f=this._codeMirror.getLineHandle(_);f&&(this._codeMirror.removeLineClass(f,"wrap",WebInspector.TextEditor.HasBreakpointStyleClassName),this._codeMirror.removeLineClass(f,"wrap",WebInspector.TextEditor.BreakpointResolvedStyleClassName),this._codeMirror.removeLineClass(f,"wrap",WebInspector.TextEditor.BreakpointDisabledStyleClassName),this._codeMirror.removeLineClass(f,"wrap",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName),this._codeMirror.removeLineClass(f,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName))}.bind(this))):void this._setBreakpointStylesOnLine(_)}_allColumnBreakpointInfoForLine(_){return this._breakpoints[_]}_setColumnBreakpointInfoForLine(_,S){this._breakpoints[_]=S,this._setBreakpointStylesOnLine(_)}_gutterMouseDown(_,S,C,f){if(!(0!==f.button||f.ctrlKey)){if(!this._codeMirror.hasLineClass(S,"wrap",WebInspector.TextEditor.HasBreakpointStyleClassName)){if(this._delegate&&"function"==typeof this._delegate.textEditorBreakpointAdded){var T=this._delegate.textEditorBreakpointAdded(this,S,0);if(T){var E=T.breakpointInfo;E&&this._addBreakpointToLineAndColumnWithInfo(T.lineNumber,T.columnNumber,E)}}return}if(!this._codeMirror.hasLineClass(S,"wrap",WebInspector.TextEditor.MultipleBreakpointsStyleClassName)){var I=Object.keys(this._breakpoints[S])[0];this._draggingBreakpointInfo=this._breakpoints[S][I],this._lineNumberWithMousedDownBreakpoint=S,this._lineNumberWithDraggedBreakpoint=S,this._columnNumberWithMousedDownBreakpoint=I,this._columnNumberWithDraggedBreakpoint=I,this._documentMouseMovedEventListener=this._documentMouseMoved.bind(this),this._documentMouseUpEventListener=this._documentMouseUp.bind(this),document.addEventListener("mousemove",this._documentMouseMovedEventListener,!0),document.addEventListener("mouseup",this._documentMouseUpEventListener,!0)}}}_gutterContextMenu(_,S,C,f){if(this._delegate&&"function"==typeof this._delegate.textEditorGutterContextMenu){var T=[];for(var E in this._breakpoints[S])T.push({lineNumber:S,columnNumber:E});this._delegate.textEditorGutterContextMenu(this,S,0,T,f)}}_documentMouseMoved(_){if("_lineNumberWithMousedDownBreakpoint"in this){_.preventDefault();var C=this._codeMirror.coordsChar({left:_.pageX,top:_.pageY}),f=this._codeMirror.getGutterElement().getBoundingClientRect(),S;if(((_.pageX<f.left||_.pageX>f.right||_.pageY<f.top||_.pageY>f.bottom)&&(C=null),C&&"line"in C&&(S=C.line),S!==this._lineNumberWithDraggedBreakpoint)&&(this._mouseDragged=!0,"_lineNumberWithDraggedBreakpoint"in this&&(this._previousColumnBreakpointInfo?this._setColumnBreakpointInfoForLine(this._lineNumberWithDraggedBreakpoint,this._previousColumnBreakpointInfo):this._removeBreakpointFromLineAndColumn(this._lineNumberWithDraggedBreakpoint,this._columnNumberWithDraggedBreakpoint),delete this._previousColumnBreakpointInfo,delete this._lineNumberWithDraggedBreakpoint,delete this._columnNumberWithDraggedBreakpoint),void 0!=S)){var T={},E=S===this._lineNumberWithMousedDownBreakpoint?this._columnNumberWithDraggedBreakpoint:0;T[E]=this._draggingBreakpointInfo,this._previousColumnBreakpointInfo=this._allColumnBreakpointInfoForLine(S),this._setColumnBreakpointInfoForLine(S,T),this._lineNumberWithDraggedBreakpoint=S,this._columnNumberWithDraggedBreakpoint=E}}}_documentMouseUp(_){if("_lineNumberWithMousedDownBreakpoint"in this){_.preventDefault(),document.removeEventListener("mousemove",this._documentMouseMovedEventListener,!0),document.removeEventListener("mouseup",this._documentMouseUpEventListener,!0);var S=this._delegate&&"function"==typeof this._delegate.textEditorBreakpointClicked,C=this._delegate&&"function"==typeof this._delegate.textEditorBreakpointRemoved,f=this._delegate&&"function"==typeof this._delegate.textEditorBreakpointMoved;if(!this._mouseDragged)this._lineNumberWithMousedDownBreakpoint in this._breakpoints&&this._columnNumberWithMousedDownBreakpoint in this._breakpoints[this._lineNumberWithMousedDownBreakpoint]&&S&&this._delegate.textEditorBreakpointClicked(this,this._lineNumberWithMousedDownBreakpoint,this._columnNumberWithMousedDownBreakpoint);else if(!("_lineNumberWithDraggedBreakpoint"in this))C&&(this._ignoreSetBreakpointInfoCalls=!0,this._delegate.textEditorBreakpointRemoved(this,this._lineNumberWithMousedDownBreakpoint,this._columnNumberWithMousedDownBreakpoint),delete this._ignoreSetBreakpointInfoCalls);else if(this._lineNumberWithMousedDownBreakpoint!==this._lineNumberWithDraggedBreakpoint){if(this._previousColumnBreakpointInfo&&C){for(var T in this._ignoreSetBreakpointInfoCalls=!0,this._previousColumnBreakpointInfo)this._delegate.textEditorBreakpointRemoved(this,this._lineNumberWithDraggedBreakpoint,T);delete this._ignoreSetBreakpointInfoCalls}f&&(this._ignoreSetBreakpointInfoCalls=!0,this._delegate.textEditorBreakpointMoved(this,this._lineNumberWithMousedDownBreakpoint,this._columnNumberWithMousedDownBreakpoint,this._lineNumberWithDraggedBreakpoint,this._columnNumberWithDraggedBreakpoint),delete this._ignoreSetBreakpointInfoCalls)}delete this._documentMouseMovedEventListener,delete this._documentMouseUpEventListener,delete this._lineNumberWithMousedDownBreakpoint,delete this._lineNumberWithDraggedBreakpoint,delete this._columnNumberWithMousedDownBreakpoint,delete this._columnNumberWithDraggedBreakpoint,delete this._previousColumnBreakpointInfo,delete this._mouseDragged}}_openClickedLinks(_){var S=this._codeMirror.coordsChar({left:_.pageX,top:_.pageY}),C=this._codeMirror.getTokenAt(S);if(C&&C.type&&C.string&&/\blink\b/.test(C.type)){var f=C.string,T="";this._delegate&&"function"==typeof this._delegate.textEditorBaseURL&&(T=this._delegate.textEditorBaseURL(this)),WebInspector.openURL(absoluteURL(f,T)),_.preventDefault(),_.stopPropagation()}}_isPositionVisible(_){var S=this._codeMirror.getScrollInfo(),C=S.top,f=C+S.clientHeight,T=this._codeMirror.charCoords(_,"local");return T.top>=C&&T.bottom<=f}_scrollIntoViewCentered(_){var S=this._codeMirror.getScrollInfo(),C=Math.ceil(this._codeMirror.defaultTextHeight()),f=Math.floor((S.clientHeight-C)/2);this._codeMirror.scrollIntoView(_,f)}},WebInspector.TextEditor.HighlightedStyleClassName="highlighted",WebInspector.TextEditor.SearchResultStyleClassName="search-result",WebInspector.TextEditor.HasBreakpointStyleClassName="has-breakpoint",WebInspector.TextEditor.BreakpointResolvedStyleClassName="breakpoint-resolved",WebInspector.TextEditor.BreakpointAutoContinueStyleClassName="breakpoint-auto-continue",WebInspector.TextEditor.BreakpointDisabledStyleClassName="breakpoint-disabled",WebInspector.TextEditor.MultipleBreakpointsStyleClassName="multiple-breakpoints",WebInspector.TextEditor.ExecutionLineStyleClassName="execution-line",WebInspector.TextEditor.BouncyHighlightStyleClassName="bouncy-highlight",WebInspector.TextEditor.NumberOfFindsPerSearchBatch=10,WebInspector.TextEditor.HighlightAnimationDuration=2e3,WebInspector.TextEditor.Event={ExecutionLineNumberDidChange:"text-editor-execution-line-number-did-change",NumberOfSearchResultsDidChange:"text-editor-number-of-search-results-did-change",ContentDidChange:"text-editor-content-did-change",FormattingDidChange:"text-editor-formatting-did-change"},WebInspector.TimelineOverviewGraph=class extends WebInspector.View{constructor(_){super(),this.element.classList.add("timeline-overview-graph"),this._zeroTime=0,this._startTime=0,this._endTime=5,this._currentTime=0,this._timelineOverview=_,this._selectedRecord=null,this._selectedRecordChanged=!1,this._scheduledSelectedRecordLayoutUpdateIdentifier=void 0,this._selected=!1,this._visible=!0}static createForTimeline(_,S){var C=_.type;if(C===WebInspector.TimelineRecord.Type.Network)return new WebInspector.NetworkTimelineOverviewGraph(_,S);if(C===WebInspector.TimelineRecord.Type.Layout)return new WebInspector.LayoutTimelineOverviewGraph(_,S);if(C===WebInspector.TimelineRecord.Type.Script)return new WebInspector.ScriptTimelineOverviewGraph(_,S);if(C===WebInspector.TimelineRecord.Type.RenderingFrame)return new WebInspector.RenderingFrameTimelineOverviewGraph(_,S);if(C===WebInspector.TimelineRecord.Type.Memory)return new WebInspector.MemoryTimelineOverviewGraph(_,S);if(C===WebInspector.TimelineRecord.Type.HeapAllocations)return new WebInspector.HeapAllocationsTimelineOverviewGraph(_,S);throw new Error("Can't make a graph for an unknown timeline.")}get zeroTime(){return this._zeroTime}set zeroTime(_){_=_||0;this._zeroTime===_||(this._zeroTime=_,this.needsLayout())}get startTime(){return this._startTime}set startTime(_){_=_||0;this._startTime===_||(this._startTime=_,this.needsLayout())}get endTime(){return this._endTime}set endTime(_){_=_||0;this._endTime===_||(this._endTime=_,this.needsLayout())}get currentTime(){return this._currentTime}set currentTime(_){if(_=_||0,this._currentTime!==_){let S=this._currentTime;this._currentTime=_,(this._startTime<=S&&S<=this._endTime||this._startTime<=this._currentTime&&this._currentTime<=this._endTime)&&this.needsLayout()}}get timelineOverview(){return this._timelineOverview}get secondsPerPixel(){return this._timelineOverview.secondsPerPixel}get visible(){return this._visible}get selectedRecord(){return this._selectedRecord}set selectedRecord(_){this._selectedRecord===_||(this._selectedRecord=_,this._selectedRecordChanged=!0,this._needsSelectedRecordLayout())}get height(){return 36}get selected(){return this._selected}set selected(_){this._selected===_||(this._selected=_,this.element.classList.toggle("selected",this._selected))}shown(){this._visible||(this._visible=!0,this.element.classList.toggle("hidden",!this._visible),this.updateLayout())}hidden(){this._visible&&(this._visible=!1,this.element.classList.toggle("hidden",!this._visible))}reset(){}recordWasFiltered(){}needsLayout(){this._visible&&super.needsLayout()}updateSelectedRecord(){}_needsSelectedRecordLayout(){this.layoutPending||this._scheduledSelectedRecordLayoutUpdateIdentifier||(this._scheduledSelectedRecordLayoutUpdateIdentifier=requestAnimationFrame(()=>{this._scheduledSelectedRecordLayoutUpdateIdentifier=void 0,this.updateSelectedRecord(),this.dispatchEventToListeners(WebInspector.TimelineOverviewGraph.Event.RecordSelected,{record:this.selectedRecord})}))}},WebInspector.TimelineOverviewGraph.Event={RecordSelected:"timeline-overview-graph-record-selected"},WebInspector.TimelineView=class extends WebInspector.ContentView{constructor(_){super(_),this.element.classList.add("timeline-view"),this._zeroTime=0,this._startTime=0,this._endTime=5,this._currentTime=0}get scrollableElements(){return this._timelineDataGrid?[this._timelineDataGrid.scrollContainer]:[]}get showsLiveRecordingData(){return!0}get showsFilterBar(){return!0}get navigationItems(){return this._scopeBar?[this._scopeBar]:[]}get selectionPathComponents(){return null}get zeroTime(){return this._zeroTime}set zeroTime(_){_=_||0;this._zeroTime===_||(this._zeroTime=_,this._timesDidChange())}get startTime(){return this._startTime}set startTime(_){_=_||0;this._startTime===_||(this._startTime=_,this._timesDidChange(),this._scheduleFilterDidChange())}get endTime(){return this._endTime}set endTime(_){_=_||0;this._endTime===_||(this._endTime=_,this._timesDidChange(),this._scheduleFilterDidChange())}get currentTime(){return this._currentTime}set currentTime(_){function S(f){const T=0.05;return this._startTime-T<=f&&f<=this._endTime+T}if(_=_||0,this._currentTime!==_){let C=this._currentTime;this._currentTime=_,(S.call(this,C)||S.call(this,this._currentTime))&&this._timesDidChange()}}get filterStartTime(){return this.startTime}get filterEndTime(){return this.endTime}setupDataGrid(_){this._timelineDataGrid&&(this._timelineDataGrid.filterDelegate=null,this._timelineDataGrid.removeEventListener(WebInspector.DataGrid.Event.SelectedNodeChanged,this._timelineDataGridSelectedNodeChanged,this),this._timelineDataGrid.removeEventListener(WebInspector.DataGrid.Event.NodeWasFiltered,this._timelineDataGridNodeWasFiltered,this),this._timelineDataGrid.removeEventListener(WebInspector.DataGrid.Event.FilterDidChange,this.filterDidChange,this)),this._timelineDataGrid=_,this._timelineDataGrid.filterDelegate=this,this._timelineDataGrid.addEventListener(WebInspector.DataGrid.Event.SelectedNodeChanged,this._timelineDataGridSelectedNodeChanged,this),this._timelineDataGrid.addEventListener(WebInspector.DataGrid.Event.NodeWasFiltered,this._timelineDataGridNodeWasFiltered,this),this._timelineDataGrid.addEventListener(WebInspector.DataGrid.Event.FilterDidChange,this.filterDidChange,this)}selectRecord(_){if(this._timelineDataGrid){let S=this._timelineDataGrid.selectedNode;if(!_)return void(S&&S.deselect());let C=this._timelineDataGrid.findNode(f=>f.record===_);!C||C.selected||S&&S.hasAncestor(C)||C.revealAndSelect()}}reset(){}updateFilter(_){this._timelineDataGrid&&(this._timelineDataGrid.filterText=_?_.text:"")}matchDataGridNodeAgainstCustomFilters(){return!0}needsLayout(){this.visible&&super.needsLayout()}dataGridMatchNodeAgainstCustomFilters(_){function S(E,I){return E=E||T,I=I||T,C<=I&&E<=f}if(!this.matchDataGridNodeAgainstCustomFilters(_))return!1;let C=this.filterStartTime,f=this.filterEndTime,T=this.currentTime;if(_ instanceof WebInspector.ResourceTimelineDataGridNode){let E=_.resource;return S(E.requestSentTimestamp,E.finishedOrFailedTimestamp)}if(_ instanceof WebInspector.SourceCodeTimelineTimelineDataGridNode){let E=_.sourceCodeTimeline;if(!S(E.startTime,E.endTime))return!1;for(let I of E.records)if(S(I.startTime,I.endTime))return!0;return!1}if(_ instanceof WebInspector.ProfileNodeDataGridNode){let E=_.profileNode;return!!S(E.startTime,E.endTime)}if(_ instanceof WebInspector.TimelineDataGridNode){let E=_.record;return S(E.startTime,E.endTime)}return _ instanceof WebInspector.ProfileDataGridNode?_.callingContextTreeNode.hasStackTraceInTimeRange(C,f):(console.error("Unknown DataGridNode, can't filter by time."),!0)}userSelectedRecordFromOverview(){}filterDidChange(){}_timelineDataGridSelectedNodeChanged(){this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange)}_timelineDataGridNodeWasFiltered(_){let S=_.data.node;S instanceof WebInspector.TimelineDataGridNode&&this.dispatchEventToListeners(WebInspector.TimelineView.Event.RecordWasFiltered,{record:S.record,filtered:S.hidden})}_timesDidChange(){(!WebInspector.timelineManager.isCapturing()||this.showsLiveRecordingData)&&this.needsLayout()}_scheduleFilterDidChange(){!this._timelineDataGrid||this._updateFilterTimeout||(this._updateFilterTimeout=setTimeout(()=>{this._updateFilterTimeout=void 0,this._timelineDataGrid.filterDidChange()},0))}},WebInspector.TimelineView.Event={RecordWasFiltered:"record-was-filtered"},WebInspector.TreeElement=class extends WebInspector.Object{constructor(_,S,C){super(),this._title=_,this.representedObject=S||{},this.representedObject.__treeElementIdentifier?this.identifier=this.representedObject.__treeElementIdentifier:(this.identifier=WebInspector.TreeOutline._knownTreeElementNextIdentifier++,this.representedObject.__treeElementIdentifier=this.identifier),this._hidden=!1,this._selectable=!0,this.expanded=!1,this.selected=!1,this.hasChildren=C,this.children=[],this.treeOutline=null,this.parent=null,this.previousSibling=null,this.nextSibling=null,this._listItemNode=null}appendChild(){return WebInspector.TreeOutline.prototype.appendChild.apply(this,arguments)}insertChild(){return WebInspector.TreeOutline.prototype.insertChild.apply(this,arguments)}removeChild(){return WebInspector.TreeOutline.prototype.removeChild.apply(this,arguments)}removeChildAtIndex(){return WebInspector.TreeOutline.prototype.removeChildAtIndex.apply(this,arguments)}removeChildren(){return WebInspector.TreeOutline.prototype.removeChildren.apply(this,arguments)}removeChildrenRecursive(){return WebInspector.TreeOutline.prototype.removeChildrenRecursive.apply(this,arguments)}selfOrDescendant(){return WebInspector.TreeOutline.prototype.selfOrDescendant.apply(this,arguments)}get arrowToggleWidth(){return 10}get selectable(){return!this._hidden&&this._selectable}set selectable(_){this._selectable=_}get listItemElement(){return this._listItemNode}get title(){return this._title}set title(_){this._title=_,this._setListItemNodeContent(),this.didChange()}get titleHTML(){return this._titleHTML}set titleHTML(_){this._titleHTML=_,this._setListItemNodeContent(),this.didChange()}get tooltip(){return this._tooltip}set tooltip(_){this._tooltip=_,this._listItemNode&&(this._listItemNode.title=_?_:"")}get hasChildren(){return this._hasChildren}set hasChildren(_){this._hasChildren!==_&&(this._hasChildren=_,this._listItemNode&&(_?this._listItemNode.classList.add("parent"):(this._listItemNode.classList.remove("parent"),this.collapse()),this.didChange()))}get hidden(){return this._hidden}set hidden(_){this._hidden===_||(this._hidden=_,this._listItemNode&&(this._listItemNode.hidden=this._hidden),this._childrenListNode&&(this._childrenListNode.hidden=this._hidden),this.treeOutline&&this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementVisibilityDidChange,{element:this}))}get shouldRefreshChildren(){return this._shouldRefreshChildren}set shouldRefreshChildren(_){this._shouldRefreshChildren=_,_&&this.expanded&&this.expand()}_fireDidChange(){this.treeOutline&&this.treeOutline._treeElementDidChange(this)}didChange(){this.treeOutline&&this.onNextFrame._fireDidChange()}_setListItemNodeContent(){this._listItemNode&&(this._titleHTML||this._title?"string"==typeof this._titleHTML?this._listItemNode.innerHTML=this._titleHTML:"string"==typeof this._title?this._listItemNode.textContent=this._title:(this._listItemNode.removeChildren(),this._title.parentNode&&this._title.parentNode.removeChild(this._title),this._listItemNode.appendChild(this._title)):this._listItemNode.removeChildren())}_attach(){(!this._listItemNode||this.parent._shouldRefreshChildren)&&(this._listItemNode&&this._listItemNode.parentNode&&this._listItemNode.parentNode.removeChild(this._listItemNode),this._listItemNode=this.treeOutline._childrenListNode.ownerDocument.createElement("li"),this._listItemNode.treeElement=this,this._setListItemNodeContent(),this._listItemNode.title=this._tooltip?this._tooltip:"",this._listItemNode.hidden=this.hidden,this.hasChildren&&this._listItemNode.classList.add("parent"),this.expanded&&this._listItemNode.classList.add("expanded"),this.selected&&this._listItemNode.classList.add("selected"),this._listItemNode.addEventListener("mousedown",WebInspector.TreeElement.treeElementMouseDown),this._listItemNode.addEventListener("click",WebInspector.TreeElement.treeElementToggled),this._listItemNode.addEventListener("dblclick",WebInspector.TreeElement.treeElementDoubleClicked),this.onattach&&this.onattach(this));var _=null;this.nextSibling&&this.nextSibling._listItemNode&&this.nextSibling._listItemNode.parentNode===this.parent._childrenListNode&&(_=this.nextSibling._listItemNode),this.parent._childrenListNode.insertBefore(this._listItemNode,_),this._childrenListNode&&this.parent._childrenListNode.insertBefore(this._childrenListNode,this._listItemNode.nextSibling),this.selected&&this.select(),this.expanded&&this.expand()}_detach(){this.ondetach&&this.ondetach(this),this._listItemNode&&this._listItemNode.parentNode&&this._listItemNode.parentNode.removeChild(this._listItemNode),this._childrenListNode&&this._childrenListNode.parentNode&&this._childrenListNode.parentNode.removeChild(this._childrenListNode)}static treeElementMouseDown(_){var S=_.currentTarget;return S&&S.treeElement&&S.treeElement.selectable?S.treeElement.isEventWithinDisclosureTriangle(_)?void _.preventDefault():void S.treeElement.selectOnMouseDown(_):void 0}static treeElementToggled(_){var S=_.currentTarget;if(S&&S.treeElement){var C=S.treeElement.toggleOnClick&&!S.treeElement.selectable,f=S.treeElement.isEventWithinDisclosureTriangle(_);(C||f)&&(S.treeElement.expanded?_.altKey?S.treeElement.collapseRecursively():S.treeElement.collapse():_.altKey?S.treeElement.expandRecursively():S.treeElement.expand(),_.stopPropagation())}}static treeElementDoubleClicked(_){var S=_.currentTarget;!S||!S.treeElement||S.treeElement.isEventWithinDisclosureTriangle(_)||S.treeElement.dispatchEventToListeners(WebInspector.TreeElement.Event.DoubleClick)||(S.treeElement.ondblclick?S.treeElement.ondblclick.call(S.treeElement,_):S.treeElement.hasChildren&&!S.treeElement.expanded&&S.treeElement.expand())}collapse(){this._listItemNode&&this._listItemNode.classList.remove("expanded"),this._childrenListNode&&this._childrenListNode.classList.remove("expanded"),this.expanded=!1,this.treeOutline&&(this.treeOutline._treeElementsExpandedState[this.identifier]=!1),this.oncollapse&&this.oncollapse(this),this.treeOutline&&this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementDisclosureDidChanged,{element:this})}collapseRecursively(){for(var _=this;_;)_.expanded&&_.collapse(),_=_.traverseNextTreeElement(!1,this,!0)}expand(){if(!(this.expanded&&!this._shouldRefreshChildren&&this._childrenListNode)&&(this.expanded=!0,this.treeOutline&&(this.treeOutline._treeElementsExpandedState[this.identifier]=!0),!!this.hasChildren)){if(this.treeOutline&&(!this._childrenListNode||this._shouldRefreshChildren)){this._childrenListNode&&this._childrenListNode.parentNode&&this._childrenListNode.parentNode.removeChild(this._childrenListNode),this._childrenListNode=this.treeOutline._childrenListNode.ownerDocument.createElement("ol"),this._childrenListNode.parentTreeElement=this,this._childrenListNode.classList.add("children"),this._childrenListNode.hidden=this.hidden,this.onpopulate(),this.expanded=!0;for(var _=0;_<this.children.length;++_)this.children[_]._attach();this._shouldRefreshChildren=!1}this._listItemNode&&(this._listItemNode.classList.add("expanded"),this._childrenListNode&&this._childrenListNode.parentNode!==this._listItemNode.parentNode&&this.parent._childrenListNode.insertBefore(this._childrenListNode,this._listItemNode.nextSibling)),this._childrenListNode&&this._childrenListNode.classList.add("expanded"),this.onexpand&&this.onexpand(this),this.treeOutline&&this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementDisclosureDidChanged,{element:this})}}expandRecursively(_){var S=this,C={},f=0;for(void 0===_&&(_=3);S;)f<_&&S.expand(),S=S.traverseNextTreeElement(!1,this,f>=_,C),f+=C.depthChange}hasAncestor(_){if(!_)return!1;for(var S=this.parent;S;){if(_===S)return!0;S=S.parent}return!1}reveal(){for(var _=this.parent;_&&!_.root;)_.expanded||_.expand(),_=_.parent;this.onreveal&&this.onreveal(this)}revealed(_){if(!_&&this.hidden)return!1;for(var S=this.parent;S&&!S.root;){if(!S.expanded)return!1;if(!_&&S.hidden)return!1;S=S.parent}return!0}selectOnMouseDown(){this.select(!1,!0)}select(_,S,C,f){if(this.treeOutline&&this.selectable&&(!this.selected||this.treeOutline.allowsRepeatSelection)){_||this.treeOutline._childrenListNode.focus();let T=this.treeOutline;if(T){T.processingSelectionChange=!0,C||(f=!0);let E=T.selectedTreeElement;this.selected||(T.selectedTreeElement&&T.selectedTreeElement.deselect(f),this.selected=!0,T.selectedTreeElement=this,this._listItemNode&&this._listItemNode.classList.add("selected")),C||(this.onselect&&this.onselect(this,S),T.dispatchEventToListeners(WebInspector.TreeOutline.Event.SelectionDidChange,{selectedElement:this,deselectedElement:E,selectedByUser:S})),T.processingSelectionChange=!1;let I=WebInspector.TreeOutlineGroup.groupForTreeOutline(T);I&&I.didSelectTreeElement(this)}}}revealAndSelect(_,S,C,f){this.reveal(),this.select(_,S,C,f)}deselect(_){return this.treeOutline&&this.treeOutline.selectedTreeElement===this&&this.selected&&(this.selected=!1,this.treeOutline.selectedTreeElement=null,this._listItemNode&&this._listItemNode.classList.remove("selected"),_||(this.ondeselect&&this.ondeselect(this),this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.SelectionDidChange,{deselectedElement:this})),!0)}onpopulate(){}traverseNextTreeElement(_,S,C,f){function T(R){return _&&!R.revealed(!0)}var E=0,I=this;C||I.onpopulate();do if(I.hasChildren&&I.children[0]&&(!_||I.expanded))I=I.children[0],E+=1;else{for(;I&&!I.nextSibling&&I.parent&&!I.parent.root&&I.parent!==S;)I=I.parent,E-=1;I&&(I=I.nextSibling)}while(I&&T(I));return f&&(f.depthChange=E),I}traversePreviousTreeElement(_,S){function C(T){return _&&!T.revealed(!0)}var f=this;do if(f.previousSibling)for(f=f.previousSibling;f&&f.hasChildren&&f.expanded&&!C(f);)S||f.onpopulate(),f=f.children.lastValue;else f=f.parent&&f.parent.root?null:f.parent;while(f&&C(f));return f}isEventWithinDisclosureTriangle(_){if(!document.contains(this._listItemNode))return!1;let S=window.getComputedStyle(this._listItemNode),C=0;return C+=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?this._listItemNode.totalOffsetRight-S.getPropertyCSSValue("padding-right").getFloatValue(CSSPrimitiveValue.CSS_PX)-this.arrowToggleWidth:this._listItemNode.totalOffsetLeft+S.getPropertyCSSValue("padding-left").getFloatValue(CSSPrimitiveValue.CSS_PX),_.pageX>=C&&_.pageX<=C+this.arrowToggleWidth&&this.hasChildren}populateContextMenu(_){(this.children.some(C=>C.hasChildren)||this.hasChildren&&!this.children.length)&&(_.appendSeparator(),_.appendItem(WebInspector.UIString("Expand All"),this.expandRecursively.bind(this)),_.appendItem(WebInspector.UIString("Collapse All"),this.collapseRecursively.bind(this)))}},WebInspector.TreeElement.Event={DoubleClick:"tree-element-double-click"},WebInspector.TreeOutline=class extends WebInspector.Object{constructor(_){super(),this.element=_||document.createElement("ol"),this.element.classList.add(WebInspector.TreeOutline.ElementStyleClassName),this.element.addEventListener("contextmenu",this._handleContextmenu.bind(this)),this.children=[],this.selectedTreeElement=null,this._childrenListNode=this.element,this._childrenListNode.removeChildren(),this._knownTreeElements=[],this._treeElementsExpandedState=[],this.allowsRepeatSelection=!1,this.root=!0,this.hasChildren=!1,this.expanded=!0,this.selected=!1,this.treeOutline=this,this._hidden=!1,this._compact=!1,this._large=!1,this._disclosureButtons=!0,this._customIndent=!1,this._childrenListNode.tabIndex=0,this._childrenListNode.addEventListener("keydown",this._treeKeyDown.bind(this),!0),WebInspector.TreeOutline._generateStyleRulesIfNeeded()}get hidden(){return this._hidden}set hidden(_){this._hidden===_||(this._hidden=_,this.element.hidden=this._hidden)}get compact(){return this._compact}set compact(_){this._compact===_||(this._compact=_,this._compact&&(this.large=!1),this.element.classList.toggle("compact",this._compact))}get large(){return this._large}set large(_){this._large===_||(this._large=_,this._large&&(this.compact=!1),this.element.classList.toggle("large",this._large))}get disclosureButtons(){return this._disclosureButtons}set disclosureButtons(_){this._disclosureButtons===_||(this._disclosureButtons=_,this.element.classList.toggle("hide-disclosure-buttons",!this._disclosureButtons))}get customIndent(){return this._customIndent}set customIndent(_){this._customIndent===_||(this._customIndent=_,this.element.classList.toggle(WebInspector.TreeOutline.CustomIndentStyleClassName,this._customIndent))}appendChild(_){if(_){var S=this.children[this.children.length-1];S?(S.nextSibling=_,_.previousSibling=S):(_.previousSibling=null,_.nextSibling=null);var C=!this.children.length;this.children.push(_),this.hasChildren=!0,_.parent=this,_.treeOutline=this.treeOutline,_.treeOutline._rememberTreeElement(_);for(var f=_.children[0];f;)f.treeOutline=this.treeOutline,f.treeOutline._rememberTreeElement(f),f=f.traverseNextTreeElement(!1,_,!0);_.hasChildren&&void 0!==_.treeOutline._treeElementsExpandedState[_.identifier]&&(_.expanded=_.treeOutline._treeElementsExpandedState[_.identifier]),this._childrenListNode&&_._attach(),this.treeOutline&&this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementAdded,{element:_}),C&&this.expanded&&this.expand()}}insertChild(_,S){if(_){var C=0<S?this.children[S-1]:null;C?(C.nextSibling=_,_.previousSibling=C):_.previousSibling=null;var f=this.children[S];f?(f.previousSibling=_,_.nextSibling=f):_.nextSibling=null;var T=!this.children.length;this.children.splice(S,0,_),this.hasChildren=!0,_.parent=this,_.treeOutline=this.treeOutline,_.treeOutline._rememberTreeElement(_);for(var E=_.children[0];E;)E.treeOutline=this.treeOutline,E.treeOutline._rememberTreeElement(E),E=E.traverseNextTreeElement(!1,_,!0);_.hasChildren&&void 0!==_.treeOutline._treeElementsExpandedState[_.identifier]&&(_.expanded=_.treeOutline._treeElementsExpandedState[_.identifier]),this._childrenListNode&&_._attach(),this.treeOutline&&this.treeOutline.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementAdded,{element:_}),T&&this.expanded&&this.expand()}}removeChildAtIndex(_,S,C){if(!(0>_||_>=this.children.length)){let f=this.children[_];this.children.splice(_,1);let T=f.parent;f.deselect(S)&&(f.previousSibling&&!C?f.previousSibling.select(!0,!1):f.nextSibling&&!C?f.nextSibling.select(!0,!1):!C&&T.select(!0,!1)),f.previousSibling&&(f.previousSibling.nextSibling=f.nextSibling),f.nextSibling&&(f.nextSibling.previousSibling=f.previousSibling);let E=f.treeOutline;E&&(E._forgetTreeElement(f),E._forgetChildrenRecursive(f)),f._detach(),f.treeOutline=null,f.parent=null,f.nextSibling=null,f.previousSibling=null,E&&E.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementRemoved,{element:f})}}removeChild(_,S,C){if(_){var f=this.children.indexOf(_);-1===f||(this.removeChildAtIndex(f,S,C),!this.children.length&&(this._listItemNode&&this._listItemNode.classList.remove("parent"),this.hasChildren=!1))}}removeChildren(_){for(let S of this.children){S.deselect(_);let C=S.treeOutline;C&&(C._forgetTreeElement(S),C._forgetChildrenRecursive(S)),S._detach(),S.treeOutline=null,S.parent=null,S.nextSibling=null,S.previousSibling=null,C&&C.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementRemoved,{element:S})}this.children=[]}removeChildrenRecursive(_){let S=this.children,C=this.children[0];for(;C;)C.children.length&&(S=S.concat(C.children)),C=C.traverseNextTreeElement(!1,this,!0);for(let f of S){f.deselect(_);let T=f.treeOutline;T&&T._forgetTreeElement(f),f._detach(),f.children=[],f.treeOutline=null,f.parent=null,f.nextSibling=null,f.previousSibling=null,T&&T.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementRemoved,{element:f})}this.children=[]}reattachIfIndexChanged(_,S){if(this.children[S]!==_){let C=_.selected;_.parent===this&&this.removeChild(_),this.insertChild(_,S),C&&_.select()}}_rememberTreeElement(_){this._knownTreeElements[_.identifier]||(this._knownTreeElements[_.identifier]=[]);var S=this._knownTreeElements[_.identifier];-1!==S.indexOf(_)||S.push(_)}_forgetTreeElement(_){this.selectedTreeElement===_&&(_.deselect(!0),this.selectedTreeElement=null),this._knownTreeElements[_.identifier]&&this._knownTreeElements[_.identifier].remove(_,!0)}_forgetChildrenRecursive(_){for(var S=_.children[0];S;)this._forgetTreeElement(S),S=S.traverseNextTreeElement(!1,_,!0)}getCachedTreeElement(_){if(!_)return null;if(_.__treeElementIdentifier){var S=this._knownTreeElements[_.__treeElementIdentifier];if(S)for(var C=0;C<S.length;++C)if(S[C].representedObject===_)return S[C]}return null}selfOrDescendant(_){for(let S=[this],C;S.length;){if(C=S.shift(),_(C))return C;S=S.concat(C.children)}return!1}findTreeElement(_,S,C){if(!_)return null;var f=this.getCachedTreeElement(_);if(f)return f;for(var E=!1,I=0,T;I<this.children.length;++I)if(T=this.children[I],T.representedObject===_||S&&S(T.representedObject,_)){E=!0;break}if(!E)return null;for(var R=[],N=_;N&&(R.unshift(N),N!==T.representedObject);)N=C(N);for(var I=0;I<R.length;++I)R[I]!==_&&(T=this.findTreeElement(R[I],S,C),T&&T.onpopulate());return this.getCachedTreeElement(_)}_treeElementDidChange(_){_.treeOutline!==this||this.dispatchEventToListeners(WebInspector.TreeOutline.Event.ElementDidChange,{element:_})}treeElementFromNode(_){var S=_.enclosingNodeOrSelfWithNodeNameInArray(["ol","li"]);return S?S.parentTreeElement||S.treeElement:null}treeElementFromPoint(_,S){var C=this._childrenListNode.ownerDocument.elementFromPoint(_,S);return C?this.treeElementFromNode(C):null}_treeKeyDown(_){if(_.target===this._childrenListNode&&!(!this.selectedTreeElement||_.shiftKey||_.metaKey||_.ctrlKey)){let S=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL;var C=!1,f;if("Up"===_.keyIdentifier&&!_.altKey){for(f=this.selectedTreeElement.traversePreviousTreeElement(!0);f&&!f.selectable;)f=f.traversePreviousTreeElement(!0);C=!!f}else if("Down"===_.keyIdentifier&&!_.altKey){for(f=this.selectedTreeElement.traverseNextTreeElement(!0);f&&!f.selectable;)f=f.traverseNextTreeElement(!0);C=!!f}else if(!S&&"Left"===_.keyIdentifier||S&&"Right"===_.keyIdentifier){if(this.selectedTreeElement.expanded)_.altKey?this.selectedTreeElement.collapseRecursively():this.selectedTreeElement.collapse(),C=!0;else if(this.selectedTreeElement.parent&&!this.selectedTreeElement.parent.root)if(C=!0,this.selectedTreeElement.parent.selectable){for(f=this.selectedTreeElement.parent;f&&!f.selectable;)f=f.parent;C=!!f}else this.selectedTreeElement.parent&&this.selectedTreeElement.parent.collapse();}else if((S||"Right"!==_.keyIdentifier)&&(!S||"Left"!==_.keyIdentifier))8===_.keyCode||46===_.keyCode?(this.selectedTreeElement.ondelete&&(C=this.selectedTreeElement.ondelete()),!C&&this.treeOutline.ondelete&&(C=this.treeOutline.ondelete(this.selectedTreeElement))):isEnterKey(_)?(this.selectedTreeElement.onenter&&(C=this.selectedTreeElement.onenter()),!C&&this.treeOutline.onenter&&(C=this.treeOutline.onenter(this.selectedTreeElement))):"U+0020"===_.keyIdentifier&&(this.selectedTreeElement.onspace&&(C=this.selectedTreeElement.onspace()),!C&&this.treeOutline.onspace&&(C=this.treeOutline.onspace(this.selectedTreeElement)));else if(!this.selectedTreeElement.revealed())this.selectedTreeElement.reveal(),C=!0;else if(this.selectedTreeElement.hasChildren)if(C=!0,this.selectedTreeElement.expanded){for(f=this.selectedTreeElement.children[0];f&&!f.selectable;)f=f.nextSibling;C=!!f}else _.altKey?this.selectedTreeElement.expandRecursively():this.selectedTreeElement.expand();f&&(f.reveal(),f.select(!1,!0)),C&&(_.preventDefault(),_.stopPropagation())}}expand(){}collapse(){}revealed(){return!0}reveal(){}select(){}revealAndSelect(){}get selectedTreeElementIndex(){if(this.hasChildren&&this.selectedTreeElement){for(var _=0;_<this.children.length;++_)if(this.children[_]===this.selectedTreeElement)return _;return!1}}treeElementFromEvent(_){let S=this.element.parentElement,C=S.totalOffsetLeft+S.offsetWidth-36,f=_.pageY,T=this.treeElementFromPoint(C,f),E=this.treeElementFromPoint(C,f-2),I=null;return I=T===E?T:this.treeElementFromPoint(C,f+2),I}populateContextMenu(_,S,C){C.populateContextMenu(_,S)}static _generateStyleRulesIfNeeded(){if(!WebInspector.TreeOutline._styleElement){WebInspector.TreeOutline._styleElement=document.createElement("style");let _=32,f="",T="";for(let E=1;E<=_;++E)T+=E===_?" .children":" > .children",f+=`.${WebInspector.TreeOutline.ElementStyleClassName}:not(.${WebInspector.TreeOutline.CustomIndentStyleClassName})${T} > .item { `,f+=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?"padding-right: ":"padding-left: ",f+=5+10*E+"px; }\n";WebInspector.TreeOutline._styleElement.textContent=f,document.head.appendChild(WebInspector.TreeOutline._styleElement)}}_handleContextmenu(_){let S=this.treeElementFromEvent(_);if(S){let C=WebInspector.ContextMenu.createFromEvent(_);this.populateContextMenu(C,_,S)}}},WebInspector.TreeOutline._styleElement=null,WebInspector.TreeOutline.ElementStyleClassName="tree-outline",WebInspector.TreeOutline.CustomIndentStyleClassName="custom-indent",WebInspector.TreeOutline.Event={ElementAdded:Symbol("element-added"),ElementDidChange:Symbol("element-did-change"),ElementRemoved:Symbol("element-removed"),ElementDisclosureDidChanged:Symbol("element-disclosure-did-change"),ElementVisibilityDidChange:Symbol("element-visbility-did-change"),SelectionDidChange:Symbol("selection-did-change")},WebInspector.TreeOutline._knownTreeElementNextIdentifier=1,WebInspector.TreeOutlineGroup=class extends WebInspector.Collection{constructor(){super(_=>_ instanceof WebInspector.TreeOutline)}static groupForTreeOutline(_){return _[WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol]||null}get selectedTreeElement(){for(let _ of this.items)if(_.selectedTreeElement)return _.selectedTreeElement;return null}itemAdded(_){_[WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol]=this,_.selectedTreeElement&&this._removeConflictingTreeSelections(_.selectedTreeElement)}itemRemoved(_){_[WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol]=null}didSelectTreeElement(_){_&&this._removeConflictingTreeSelections(_)}_removeConflictingTreeSelections(_){let S=_.treeOutline;for(let C of this.items)S!==C&&C.selectedTreeElement&&C.selectedTreeElement.deselect()}},WebInspector.TreeOutlineGroup.GroupForTreeOutlineSymbol=Symbol("group-for-tree-outline"),WebInspector.ButtonNavigationItem=class extends WebInspector.NavigationItem{constructor(_,S,C,f,T,E,I){super(_),this.toolTip=S,this._element.addEventListener("click",this._mouseClicked.bind(this)),this._element.setAttribute("role",E||"button"),I&&this._element.setAttribute("aria-label",I),this._imageWidth=f||16,this._imageHeight=T||16,C?this.image=C:this.label=S}get toolTip(){return this._element.title}set toolTip(_){_&&(this._element.title=_)}get label(){return this._element.textContent}set label(_){this._element.classList.add(WebInspector.ButtonNavigationItem.TextOnlyClassName),this._element.textContent=_||"",this.parentNavigationBar&&this.parentNavigationBar.needsLayout()}get image(){return this._image}set image(_){return _?void(this._element.removeChildren(),this._element.classList.remove(WebInspector.ButtonNavigationItem.TextOnlyClassName),this._image=_,this._glyphElement=useSVGSymbol(this._image,"glyph"),this._glyphElement.style.width=this._imageWidth+"px",this._glyphElement.style.height=this._imageHeight+"px",this._element.appendChild(this._glyphElement)):void this._element.removeChildren()}get enabled(){return!this._element.classList.contains(WebInspector.ButtonNavigationItem.DisabledStyleClassName)}set enabled(_){_?this._element.classList.remove(WebInspector.ButtonNavigationItem.DisabledStyleClassName):this._element.classList.add(WebInspector.ButtonNavigationItem.DisabledStyleClassName)}get additionalClassNames(){return["button"]}_mouseClicked(){this.enabled&&this.dispatchEventToListeners(WebInspector.ButtonNavigationItem.Event.Clicked)}},WebInspector.ButtonNavigationItem.DisabledStyleClassName="disabled",WebInspector.ButtonNavigationItem.TextOnlyClassName="text-only",WebInspector.ButtonNavigationItem.Event={Clicked:"button-navigation-item-clicked"},WebInspector.DatabaseUserQueryViewBase=class extends WebInspector.View{constructor(_){super(),this.element.className="database-user-query";let S=document.createElement("span");S.className="database-query-text",S.textContent=_,this.element.appendChild(S),this._resultElement=document.createElement("div"),this._resultElement.className="database-query-result",this.element.appendChild(this._resultElement)}get resultElement(){return this._resultElement}},WebInspector.DatabaseUserQueryErrorView=class extends WebInspector.DatabaseUserQueryViewBase{constructor(_,S){super(_),this.resultElement.classList.add("error"),this.resultElement.textContent=S}},WebInspector.DatabaseUserQuerySuccessView=class extends WebInspector.DatabaseUserQueryViewBase{constructor(_,S,C){super(_),this._dataGrid=WebInspector.DataGrid.createSortableDataGrid(S,C),this._dataGrid?(this._dataGrid.inline=!0,this.resultElement.appendChild(this._dataGrid.element),this._dataGrid.updateLayoutIfNeeded()):(this.resultElement.classList.add("no-results"),this.resultElement.textContent=WebInspector.UIString("Query returned no results."))}get dataGrid(){return this._dataGrid}layout(){this._dataGrid&&this._dataGrid.updateLayout()}},WebInspector.DOMTreeContentView=class extends WebInspector.ContentView{constructor(_){super(_),this._compositingBordersButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("layer-borders",WebInspector.UIString("Show compositing borders"),WebInspector.UIString("Hide compositing borders"),"Images/LayerBorders.svg",13,13),this._compositingBordersButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._toggleCompositingBorders,this),this._compositingBordersButtonNavigationItem.enabled=!!PageAgent.getCompositingBordersVisible,WebInspector.showPaintRectsSetting.addEventListener(WebInspector.Setting.Event.Changed,this._showPaintRectsSettingChanged,this),this._paintFlashingButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("paint-flashing",WebInspector.UIString("Enable paint flashing"),WebInspector.UIString("Disable paint flashing"),"Images/PaintFlashing.svg",16,16),this._paintFlashingButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._togglePaintFlashing,this),this._paintFlashingButtonNavigationItem.enabled=!!PageAgent.setShowPaintRects,this._paintFlashingButtonNavigationItem.activated=PageAgent.setShowPaintRects&&WebInspector.showPaintRectsSetting.value,WebInspector.showShadowDOMSetting.addEventListener(WebInspector.Setting.Event.Changed,this._showShadowDOMSettingChanged,this),this._showsShadowDOMButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("shows-shadow-DOM",WebInspector.UIString("Show shadow DOM nodes"),WebInspector.UIString("Hide shadow DOM nodes"),"Images/ShadowDOM.svg",13,13),this._showsShadowDOMButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._toggleShowsShadowDOMSetting,this),this._showShadowDOMSettingChanged(),WebInspector.showPrintStylesSetting.addEventListener(WebInspector.Setting.Event.Changed,this._showPrintStylesSettingChanged,this),this._showPrintStylesButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("print-styles",WebInspector.UIString("Force Print Media Styles"),WebInspector.UIString("Use Default Media Styles"),"Images/Printer.svg",16,16),this._showPrintStylesButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._togglePrintStylesSetting,this),this._showPrintStylesSettingChanged(),this.element.classList.add("dom-tree"),this.element.addEventListener("click",this._mouseWasClicked.bind(this),!1),this._domTreeOutline=new WebInspector.DOMTreeOutline(!0,!0,!0),this._domTreeOutline.addEventListener(WebInspector.TreeOutline.Event.ElementAdded,this._domTreeElementAdded,this),this._domTreeOutline.addEventListener(WebInspector.DOMTreeOutline.Event.SelectedNodeChanged,this._selectedNodeDidChange,this),this._domTreeOutline.wireToDomAgent(),this._domTreeOutline.editable=!0,this.element.appendChild(this._domTreeOutline.element),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.AttributeModified,this._domNodeChanged,this),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.AttributeRemoved,this._domNodeChanged,this),WebInspector.domTreeManager.addEventListener(WebInspector.DOMTreeManager.Event.CharacterDataModified,this._domNodeChanged,this),this._lastSelectedNodePathSetting=new WebInspector.Setting("last-selected-node-path",null),this._numberOfSearchResults=null,this._breakpointGutterEnabled=!1,this._pendingBreakpointNodeIdentifiers=new Set,WebInspector.domDebuggerManager.supported&&(WebInspector.debuggerManager.addEventListener(WebInspector.DebuggerManager.Event.BreakpointsEnabledDidChange,this._breakpointsEnabledDidChange,this),WebInspector.domDebuggerManager.addEventListener(WebInspector.DOMDebuggerManager.Event.DOMBreakpointAdded,this._domBreakpointAddedOrRemoved,this),WebInspector.domDebuggerManager.addEventListener(WebInspector.DOMDebuggerManager.Event.DOMBreakpointRemoved,this._domBreakpointAddedOrRemoved,this),WebInspector.DOMBreakpoint.addEventListener(WebInspector.DOMBreakpoint.Event.DisabledStateDidChange,this._domBreakpointDisabledStateDidChange,this),WebInspector.DOMBreakpoint.addEventListener(WebInspector.DOMBreakpoint.Event.ResolvedStateDidChange,this._domBreakpointResolvedStateDidChange,this),this._breakpointsEnabledDidChange())}get navigationItems(){return[this._showPrintStylesButtonNavigationItem,this._showsShadowDOMButtonNavigationItem,this._compositingBordersButtonNavigationItem,this._paintFlashingButtonNavigationItem]}get domTreeOutline(){return this._domTreeOutline}get scrollableElements(){return[this.element]}get breakpointGutterEnabled(){return this._breakpointGutterEnabled}set breakpointGutterEnabled(_){this._breakpointGutterEnabled===_||(this._breakpointGutterEnabled=_,this.element.classList.toggle("show-gutter",this._breakpointGutterEnabled))}shown(){super.shown(),this._domTreeOutline.setVisible(!0,WebInspector.isConsoleFocused()),this._updateCompositingBordersButtonToMatchPageSettings();this._domTreeOutline.rootDOMNode&&this._restoreBreakpointsAfterUpdate()}hidden(){super.hidden(),WebInspector.domTreeManager.hideDOMNodeHighlight(),this._domTreeOutline.setVisible(!1)}closed(){super.closed(),WebInspector.showPaintRectsSetting.removeEventListener(null,null,this),WebInspector.showShadowDOMSetting.removeEventListener(null,null,this),WebInspector.debuggerManager.removeEventListener(null,null,this),WebInspector.domTreeManager.removeEventListener(null,null,this),WebInspector.domDebuggerManager.removeEventListener(null,null,this),WebInspector.DOMBreakpoint.removeEventListener(null,null,this),this._domTreeOutline.close(),this._pendingBreakpointNodeIdentifiers.clear()}get selectionPathComponents(){for(var _=this._domTreeOutline.selectedTreeElement,S=[];_&&!_.root;){if(_.isCloseTag()){_=_.parent;continue}var C=new WebInspector.DOMTreeElementPathComponent(_,_.representedObject);C.addEventListener(WebInspector.HierarchicalPathComponent.Event.Clicked,this._pathComponentSelected,this),S.unshift(C),_=_.parent}return S}restoreFromCookie(_){_&&_.nodeToSelect&&(this.selectAndRevealDOMNode(_.nodeToSelect),_.nodeToSelect=void 0)}selectAndRevealDOMNode(_,S){this._domTreeOutline.selectDOMNode(_,!S)}handleCopyEvent(_){var S=this._domTreeOutline.selectedDOMNode();S&&(_.clipboardData.clearData(),_.preventDefault(),S.copyNode())}get supportsSave(){return WebInspector.canArchiveMainFrame()}get saveData(){return{customSaveHandler:function(){WebInspector.archiveMainFrame()}}}get supportsSearch(){return!0}get numberOfSearchResults(){return this._numberOfSearchResults}get hasPerformedSearch(){return null!==this._numberOfSearchResults}set automaticallyRevealFirstSearchResult(_){this._automaticallyRevealFirstSearchResult=_,this._automaticallyRevealFirstSearchResult&&0<this._numberOfSearchResults&&-1===this._currentSearchResultIndex&&this.revealNextSearchResult()}performSearch(_){function S(f,T,E){f||(this._searchIdentifier=T,this._numberOfSearchResults=E,this.dispatchEventToListeners(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange),this._showSearchHighlights(),this._automaticallyRevealFirstSearchResult&&this.revealNextSearchResult())}this._searchQuery===_||(this._searchIdentifier&&(DOMAgent.discardSearchResults(this._searchIdentifier),this._hideSearchHighlights()),this._searchQuery=_,this._searchIdentifier=null,this._numberOfSearchResults=null,this._currentSearchResultIndex=-1,this.getSearchContextNodes(function(f){DOMAgent.performSearch(_,f,S.bind(this))}.bind(this)))}getSearchContextNodes(_){_(void 0)}searchCleared(){this._searchIdentifier&&(DOMAgent.discardSearchResults(this._searchIdentifier),this._hideSearchHighlights()),this._searchQuery=null,this._searchIdentifier=null,this._numberOfSearchResults=null,this._currentSearchResultIndex=-1}revealPreviousSearchResult(_){this._numberOfSearchResults&&(0<this._currentSearchResultIndex?--this._currentSearchResultIndex:this._currentSearchResultIndex=this._numberOfSearchResults-1,this._revealSearchResult(this._currentSearchResultIndex,_))}revealNextSearchResult(_){this._numberOfSearchResults&&(this._currentSearchResultIndex+1<this._numberOfSearchResults?++this._currentSearchResultIndex:this._currentSearchResultIndex=0,this._revealSearchResult(this._currentSearchResultIndex,_))}layout(){this._domTreeOutline.updateSelection()}_revealSearchResult(_,S){var f=this._searchIdentifier;DOMAgent.getSearchResults(this._searchIdentifier,_,_+1,function(T,E){if(!T&&this._searchIdentifier===f){var I=WebInspector.domTreeManager.nodeForId(E[0]);if(I){this._domTreeOutline.selectDOMNode(I,S);var R=this._domTreeOutline.selectedTreeElement;R&&R.emphasizeSearchHighlight()}}}.bind(this))}_restoreSelectedNodeAfterUpdate(_,S){function C(T){var E=T;E||(E=S);E&&(this._dontSetLastSelectedNodePath=!0,this.selectAndRevealDOMNode(E,WebInspector.isConsoleFocused()),this._dontSetLastSelectedNodePath=!1,!T&&this._domTreeOutline.selectedTreeElement&&this._domTreeOutline.selectedTreeElement.expand())}WebInspector.domTreeManager.restoreSelectedNodeIsAllowed&&(_&&this._lastSelectedNodePathSetting.value&&this._lastSelectedNodePathSetting.value.path&&this._lastSelectedNodePathSetting.value.url===_.hash?WebInspector.domTreeManager.pushNodeByPathToFrontend(this._lastSelectedNodePathSetting.value.path,function(T){WebInspector.domTreeManager.restoreSelectedNodeIsAllowed&&C.call(this,WebInspector.domTreeManager.nodeForId(T))}.bind(this)):C.call(this))}_domTreeElementAdded(_){if(this._pendingBreakpointNodeIdentifiers.size){let S=_.data.element,C=S.representedObject;C instanceof WebInspector.DOMNode&&this._pendingBreakpointNodeIdentifiers.delete(C.id)&&this._updateBreakpointStatus(C.id)}}_selectedNodeDidChange(){var S=this._domTreeOutline.selectedDOMNode();S&&!this._dontSetLastSelectedNodePath&&(this._lastSelectedNodePathSetting.value={url:WebInspector.frameResourceManager.mainFrame.url.hash,path:S.path()}),S&&ConsoleAgent.addInspectedNode(S.id),this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange)}_pathComponentSelected(_){_.data.pathComponent&&this._domTreeOutline.selectDOMNode(_.data.pathComponent.domTreeElement.representedObject,!0)}_domNodeChanged(_){var S=this._domTreeOutline.selectedDOMNode();S!==_.data.node||this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange)}_mouseWasClicked(_){var C=_.target.enclosingNodeOrSelfWithNodeName("a");C&&C.href&&(_.preventDefault(),_.stopPropagation(),!WebInspector.isBeingEdited(C))&&(this._followLinkTimeoutIdentifier&&(clearTimeout(this._followLinkTimeoutIdentifier),delete this._followLinkTimeoutIdentifier),1<_.detail||(this._followLinkTimeoutIdentifier=setTimeout(function(){const f={alwaysOpenExternally:!!_&&_.metaKey,lineNumber:C.lineNumber,ignoreNetworkTab:!0,ignoreSearchTab:!0};WebInspector.openURL(C.href,this._frame,f)}.bind(this),333)))}_toggleCompositingBorders(){var S=!this._compositingBordersButtonNavigationItem.activated;this._compositingBordersButtonNavigationItem.activated=S,PageAgent.setCompositingBordersVisible(S)}_togglePaintFlashing(){WebInspector.showPaintRectsSetting.value=!WebInspector.showPaintRectsSetting.value}_updateCompositingBordersButtonToMatchPageSettings(){var _=this._compositingBordersButtonNavigationItem;PageAgent.getCompositingBordersVisible(function(S,C){_.activated=!S&&C,_.enabled="unsupported"!==S})}_showPaintRectsSettingChanged(){this._paintFlashingButtonNavigationItem.activated=WebInspector.showPaintRectsSetting.value,PageAgent.setShowPaintRects(this._paintFlashingButtonNavigationItem.activated)}_showShadowDOMSettingChanged(){this._showsShadowDOMButtonNavigationItem.activated=WebInspector.showShadowDOMSetting.value}_toggleShowsShadowDOMSetting(){WebInspector.showShadowDOMSetting.value=!WebInspector.showShadowDOMSetting.value}_showPrintStylesSettingChanged(){this._showPrintStylesButtonNavigationItem.activated=WebInspector.showPrintStylesSetting.value}_togglePrintStylesSetting(){WebInspector.showPrintStylesSetting.value=!WebInspector.showPrintStylesSetting.value;let S=WebInspector.showPrintStylesSetting.value?"print":"";PageAgent.setEmulatedMedia(S),WebInspector.cssStyleManager.mediaTypeChanged()}_showSearchHighlights(){this._searchResultNodes=[];var _=this._searchIdentifier;DOMAgent.getSearchResults(this._searchIdentifier,0,this._numberOfSearchResults,function(S,C){if(!S&&this._searchIdentifier===_)for(var f=0,T;f<C.length;++f)if(T=WebInspector.domTreeManager.nodeForId(C[f]),T){this._searchResultNodes.push(T);var E=this._domTreeOutline.findTreeElement(T);E&&E.highlightSearchResults(this._searchQuery)}}.bind(this))}_hideSearchHighlights(){if(this._searchResultNodes){for(var _ of this._searchResultNodes){var S=this._domTreeOutline.findTreeElement(_);S&&S.hideSearchHighlights()}delete this._searchResultNodes}}_domBreakpointAddedOrRemoved(_){let S=_.data.breakpoint;this._updateBreakpointStatus(S.domNodeIdentifier)}_domBreakpointDisabledStateDidChange(_){let S=_.target;this._updateBreakpointStatus(S.domNodeIdentifier)}_domBreakpointResolvedStateDidChange(_){let S=_.target,C=S.domNodeIdentifier||_.data.oldNodeIdentifier;this._updateBreakpointStatus(C)}_updateBreakpointStatus(_){let S=WebInspector.domTreeManager.nodeForId(_);if(S){let C=this._domTreeOutline.findTreeElement(S);if(!C)return void this._pendingBreakpointNodeIdentifiers.add(_);let f=WebInspector.domDebuggerManager.domBreakpointsForNode(S);if(!f.length)return void(C.breakpointStatus=WebInspector.DOMTreeElement.BreakpointStatus.None);this.breakpointGutterEnabled=!0;let T=f.some(E=>E.disabled);C.breakpointStatus=T?WebInspector.DOMTreeElement.BreakpointStatus.DisabledBreakpoint:WebInspector.DOMTreeElement.BreakpointStatus.Breakpoint}}_restoreBreakpointsAfterUpdate(){this._pendingBreakpointNodeIdentifiers.clear(),this.breakpointGutterEnabled=!1;let _=new Set;for(let S of WebInspector.domDebuggerManager.domBreakpoints)_.has(S.domNodeIdentifier)||this._updateBreakpointStatus(S.domNodeIdentifier)}_breakpointsEnabledDidChange(){this._domTreeOutline.element.classList.toggle("breakpoints-disabled",!WebInspector.debuggerManager.breakpointsEnabled)}},WebInspector.DetailsSidebarPanel=class extends WebInspector.SidebarPanel{constructor(_,S,C){super(_,S),this.element.classList.add("details"),C||(this._navigationItem=new WebInspector.RadioButtonNavigationItem(_,S))}get navigationItem(){return this._navigationItem}inspect(){return!1}},WebInspector.GeneralTabBarItem=class extends WebInspector.TabBarItem{constructor(_,S,C){super(_,S,C);let f=document.createElement("div");f.classList.add(WebInspector.TabBarItem.CloseButtonStyleClassName),f.title=WebInspector.UIString("Click to close this tab; Option-click to close all tabs except this one"),this.element.insertBefore(f,this.element.firstChild),this.element.addEventListener("contextmenu",this._handleContextMenuEvent.bind(this))}set title(_){if(_){this._titleElement=document.createElement("span"),this._titleElement.classList.add("title");let S=document.createElement("span");S.classList.add("content"),S.textContent=_,this._titleElement.appendChild(S),this.element.insertBefore(this._titleElement,this.element.lastChild)}else this._titleElement&&this._titleElement.remove(),this._titleElement=null;super.title=_}_handleContextMenuEvent(_){if(this._parentTabBar){let f=this._parentTabBar.tabBarItems.some(E=>E!==this&&!(E instanceof WebInspector.PinnedTabBarItem)),T=WebInspector.ContextMenu.createFromEvent(_);T.appendItem(WebInspector.UIString("Close Tab"),()=>{this._parentTabBar.removeTabBarItem(this)},this.isDefaultTab),T.appendItem(WebInspector.UIString("Close Other Tabs"),()=>{let E=this._parentTabBar.tabBarItems;for(let I=E.length-1,R;0<=I;--I)R=E[I],R===this||R instanceof WebInspector.PinnedTabBarItem||this._parentTabBar.removeTabBarItem(R)},!f)}}},WebInspector.GeneralTreeElement=class extends WebInspector.TreeElement{constructor(_,S,C,f,T){super("",f,T),this.classNames=_,this._tooltipHandledSeparately=!1,this._mainTitle=S||"",this._subtitle=C||"",this._status=""}get element(){return this._listItemNode}get iconElement(){return this._createElementsIfNeeded(),this._iconElement}get titlesElement(){return this._createElementsIfNeeded(),this._titlesElement}get mainTitleElement(){return this._createElementsIfNeeded(),this._mainTitleElement}get subtitleElement(){return this._createElementsIfNeeded(),this._createSubtitleElementIfNeeded(),this._subtitleElement}get classNames(){return this._classNames}set classNames(_){_=_||[],"string"==typeof _&&(_=[_]);Array.shallowEqual(this._classNames,_)||(this._listItemNode&&this._classNames&&this._listItemNode.classList.remove(...this._classNames),this._classNames=_,this._listItemNode&&this._listItemNode.classList.add(...this._classNames))}addClassName(_){this._classNames.includes(_)||(this._classNames.push(_),this._listItemNode&&this._listItemNode.classList.add(_))}removeClassName(_){this._classNames.includes(_)&&(this._classNames.remove(_),this._listItemNode&&this._listItemNode.classList.remove(_))}get mainTitle(){return this._mainTitle}set mainTitle(_){_=_||"";this._mainTitle===_||(this._mainTitle=_,this._updateTitleElements(),this.didChange(),this.dispatchEventToListeners(WebInspector.GeneralTreeElement.Event.MainTitleDidChange))}get subtitle(){return this._subtitle}set subtitle(_){_=_||"";this._subtitle===_||(this._subtitle=_,this._updateTitleElements(),this.didChange())}get status(){return this._status}set status(_){_=_||"";this._status===_||(!this._statusElement&&(this._statusElement=document.createElement("div"),this._statusElement.className=WebInspector.GeneralTreeElement.StatusElementStyleClassName),this._status=_,this._updateStatusElement())}get filterableData(){return{text:[this.mainTitle,this.subtitle]}}get tooltipHandledSeparately(){return this._tooltipHandledSeparately}set tooltipHandledSeparately(_){this._tooltipHandledSeparately=!!_}isEventWithinDisclosureTriangle(_){return _.target===this._disclosureButton}onattach(){this._createElementsIfNeeded(),this._updateTitleElements(),this._listItemNode.classList.add("item"),this._classNames&&this._listItemNode.classList.add(...this._classNames),this._listItemNode.appendChild(this._disclosureButton),this._listItemNode.appendChild(this._iconElement),this._statusElement&&this._listItemNode.appendChild(this._statusElement),this._listItemNode.appendChild(this._titlesElement)}ondetach(){}onreveal(){this._listItemNode&&this._listItemNode.scrollIntoViewIfNeeded(!1)}callFirstAncestorFunction(_,S){for(var C=this.parent;C;){if("function"==typeof C[_]){C[_].apply(C,S);break}C=C.parent}}_createElementsIfNeeded(){this._createdElements||(this._disclosureButton=document.createElement("button"),this._disclosureButton.className=WebInspector.GeneralTreeElement.DisclosureButtonStyleClassName,this._disclosureButton.tabIndex=-1,this._iconElement=document.createElement("img"),this._iconElement.className=WebInspector.GeneralTreeElement.IconElementStyleClassName,this._titlesElement=document.createElement("div"),this._titlesElement.className=WebInspector.GeneralTreeElement.TitlesElementStyleClassName,this._mainTitleElement=document.createElement("span"),this._mainTitleElement.className=WebInspector.GeneralTreeElement.MainTitleElementStyleClassName,this._titlesElement.appendChild(this._mainTitleElement),this._createdElements=!0)}_createSubtitleElementIfNeeded(){this._subtitleElement||(this._subtitleElement=document.createElement("span"),this._subtitleElement.className=WebInspector.GeneralTreeElement.SubtitleElementStyleClassName,this._titlesElement.appendChild(this._subtitleElement))}_updateTitleElements(){this._createdElements&&("string"==typeof this._mainTitle?this._mainTitleElement.textContent!==this._mainTitle&&(this._mainTitleElement.textContent=this._mainTitle):this._mainTitle instanceof Node&&(this._mainTitleElement.removeChildren(),this._mainTitleElement.appendChild(this._mainTitle)),"string"==typeof this._subtitle&&this._subtitle?(this._createSubtitleElementIfNeeded(),this._subtitleElement.textContent!==this._subtitle&&(this._subtitleElement.textContent=this._subtitle),this._titlesElement.classList.remove(WebInspector.GeneralTreeElement.NoSubtitleStyleClassName)):this._subtitle instanceof Node?(this._createSubtitleElementIfNeeded(),this._subtitleElement.removeChildren(),this._subtitleElement.appendChild(this._subtitle)):(this._subtitleElement&&(this._subtitleElement.textContent=""),this._titlesElement.classList.add(WebInspector.GeneralTreeElement.NoSubtitleStyleClassName)),!this.tooltip&&!this._tooltipHandledSeparately&&this._updateTitleTooltip())}_updateTitleTooltip(){if(this._listItemNode){let _=this._mainTitleElement.textContent,S=this._subtitleElement?this._subtitleElement.textContent:"",C=this.treeOutline&&this.treeOutline.large;this._listItemNode.title=_&&S?_+(C?"\n":" \u2014 ")+S:_?_:S}}_updateStatusElement(){this._statusElement&&(!this._statusElement.parentNode&&this._listItemNode&&this._listItemNode.insertBefore(this._statusElement,this._titlesElement),this._status instanceof Node?(this._statusElement.removeChildren(),this._statusElement.appendChild(this._status)):this._statusElement.textContent=this._status)}},WebInspector.GeneralTreeElement.DisclosureButtonStyleClassName="disclosure-button",WebInspector.GeneralTreeElement.IconElementStyleClassName="icon",WebInspector.GeneralTreeElement.StatusElementStyleClassName="status",WebInspector.GeneralTreeElement.TitlesElementStyleClassName="titles",WebInspector.GeneralTreeElement.MainTitleElementStyleClassName="title",WebInspector.GeneralTreeElement.SubtitleElementStyleClassName="subtitle",WebInspector.GeneralTreeElement.NoSubtitleStyleClassName="no-subtitle",WebInspector.GeneralTreeElement.Event={MainTitleDidChange:"general-tree-element-main-title-did-change"},WebInspector.NavigationSidebarPanel=class extends WebInspector.SidebarPanel{constructor(_,S,C){super(_,S),this.element.classList.add("navigation"),this.contentView.element.addEventListener("scroll",this.soon._updateContentOverflowShadowVisibility),this._contentTreeOutlineGroup=new WebInspector.TreeOutlineGroup,this._contentTreeOutline=this.createContentTreeOutline(),this._filterBar=new WebInspector.FilterBar,this._filterBar.addEventListener(WebInspector.FilterBar.Event.FilterDidChange,this._filterDidChange,this),this.element.appendChild(this._filterBar.element),this._bottomOverflowShadowElement=document.createElement("div"),this._bottomOverflowShadowElement.className=WebInspector.NavigationSidebarPanel.OverflowShadowElementStyleClassName,this.element.appendChild(this._bottomOverflowShadowElement),this._boundUpdateContentOverflowShadowVisibility=this.soon._updateContentOverflowShadowVisibility,window.addEventListener("resize",this._boundUpdateContentOverflowShadowVisibility),this._filtersSetting=new WebInspector.Setting(_+"-navigation-sidebar-filters",{}),this._filterBar.filters=this._filtersSetting.value,this._emptyContentPlaceholderElements=new Map,this._emptyFilterResults=new Map,this._shouldAutoPruneStaleTopLevelResourceTreeElements=C||!1,this._shouldAutoPruneStaleTopLevelResourceTreeElements&&(WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._checkForStaleResources,this),WebInspector.Frame.addEventListener(WebInspector.Frame.Event.ChildFrameWasRemoved,this._checkForStaleResources,this),WebInspector.Frame.addEventListener(WebInspector.Frame.Event.ResourceWasRemoved,this._checkForStaleResources,this)),this._pendingViewStateCookie=null,this._restoringState=!1}closed(){window.removeEventListener("resize",this._boundUpdateContentOverflowShadowVisibility),WebInspector.Frame.removeEventListener(null,null,this)}get contentBrowser(){return this._contentBrowser}set contentBrowser(_){this._contentBrowser=_||null}get contentTreeOutline(){return this._contentTreeOutline}get contentTreeOutlines(){return this._contentTreeOutlineGroup.items}get currentRepresentedObject(){return this._contentBrowser?this._contentBrowser.currentRepresentedObjects[0]||null:null}get filterBar(){return this._filterBar}get restoringState(){return this._restoringState}cancelRestoringState(){this._finalAttemptToRestoreViewStateTimeout&&(clearTimeout(this._finalAttemptToRestoreViewStateTimeout),this._finalAttemptToRestoreViewStateTimeout=void 0)}createContentTreeOutline(_){let S=new WebInspector.TreeOutline;return S.allowsRepeatSelection=!0,S.element.classList.add(WebInspector.NavigationSidebarPanel.ContentTreeOutlineElementStyleClassName),this._contentTreeOutlineGroup.add(S),this.contentView.element.appendChild(S.element),_||(S.addEventListener(WebInspector.TreeOutline.Event.ElementAdded,this._treeElementAddedOrChanged,this),S.addEventListener(WebInspector.TreeOutline.Event.ElementDidChange,this._treeElementAddedOrChanged,this),S.addEventListener(WebInspector.TreeOutline.Event.ElementDisclosureDidChanged,this._treeElementDisclosureDidChange,this)),S[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]=_,S}suppressFilteringOnTreeElements(_){for(let S of _)S[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]=!0;this._updateFilter()}treeElementForRepresentedObject(_){let S=null;for(let C of this.contentTreeOutlines)if(S=C.getCachedTreeElement(_),S)break;return S}showDefaultContentView(){}showDefaultContentViewForTreeElement(_){if(!_||!_.representedObject)return!1;if(!this.selected){let C=this.contentBrowser.contentViewForRepresentedObject(_.representedObject);if(C&&C.parentContainer&&C.parentContainer!==this.contentBrowser.contentViewContainer)return!1;let f=WebInspector.tabBrowser.selectedTabContentView;if(f&&f.contentBrowser!==this.contentBrowser)return!1}let S=this.contentBrowser.showContentViewForRepresentedObject(_.representedObject);return!!S&&(_.revealAndSelect(!0,!1,!0,!0),!0)}saveStateToCookie(_){if(this._contentBrowser){let S=this.currentRepresentedObject;if(S)return _[WebInspector.TypeIdentifierCookieKey]=S.constructor.TypeIdentifier,S.saveIdentityToCookie?void S.saveIdentityToCookie(_):void console.error("NavigationSidebarPanel representedObject is missing a saveIdentityToCookie implementation.",S)}}restoreStateFromCookie(_,S){this._pendingViewStateCookie=_,this._restoringState=!0,this._checkOutlinesForPendingViewStateCookie(),this._finalAttemptToRestoreViewStateTimeout&&clearTimeout(this._finalAttemptToRestoreViewStateTimeout);0===S||(this._finalAttemptToRestoreViewStateTimeout=setTimeout(function(){this._finalAttemptToRestoreViewStateTimeout=void 0,this._checkOutlinesForPendingViewStateCookie(!0),this._pendingViewStateCookie=null,this._restoringState=!1}.bind(this),S))}showEmptyContentPlaceholder(_,S){S=S||this._contentTreeOutline;let C=this._createEmptyContentPlaceholderIfNeeded(S);if(!(C.parentNode&&C.children[0].textContent===_)){C.children[0].textContent=_;let f=S.element.parentNode;f.appendChild(C),this._updateContentOverflowShadowVisibility()}}hideEmptyContentPlaceholder(_){_=_||this._contentTreeOutline;let S=this._emptyContentPlaceholderElements.get(_);S&&S.parentNode&&(S.remove(),this._updateContentOverflowShadowVisibility())}updateEmptyContentPlaceholder(_,S){S=S||this._contentTreeOutline,S.children.length?!this._emptyFilterResults.get(S)&&this.hideEmptyContentPlaceholder(S):this.showEmptyContentPlaceholder(_,S)}updateFilter(){this._updateFilter()}shouldFilterPopulate(){return this.hasCustomFilters()}hasCustomFilters(){return!1}matchTreeElementAgainstCustomFilters(){return!0}matchTreeElementAgainstFilterFunctions(_){if(!this._filterFunctions||!this._filterFunctions.length)return!0;for(var S of this._filterFunctions)if(S(_))return!0;return!1}applyFiltersToTreeElement(_){if(!this._filterBar.hasActiveFilters()&&!this.hasCustomFilters())return _.hidden=!1,void(_.expanded&&_[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]&&(_[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]=!1,_.collapse()));var f=_.filterableData||{},T={expandTreeElement:!1},E=this._textFilterRegex;let I=_[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol];return I||function(R){if(!R||!E)return!0;for(var N of R)if(N&&E.test(N))return T.expandTreeElement=!0,!0;return!1}(f.text)&&this.matchTreeElementAgainstFilterFunctions(_,T)&&this.matchTreeElementAgainstCustomFilters(_,T)?(function(){_.hidden=!1;for(var R=_.parent;R&&!R.root;)R.hidden=!1,T.expandTreeElement&&!R.expanded&&(R.__wasExpandedDuringFiltering=!0,R.expand()),R=R.parent}(),void(!T.expandTreeElement&&_.expanded&&_[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]&&(_[WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol]=!1,_.collapse()))):void(_.hidden=!0)}shown(){super.shown(),this._updateContentOverflowShadowVisibility()}pruneStaleResourceTreeElements(){this._checkForStaleResourcesTimeoutIdentifier&&(clearTimeout(this._checkForStaleResourcesTimeoutIdentifier),this._checkForStaleResourcesTimeoutIdentifier=void 0);for(let f of this.contentTreeOutlines)for(var _=f.children.length-1,S;0<=_;--_)if(S=f.children[_],S instanceof WebInspector.ResourceTreeElement){var C=S.resource;(!C.parentFrame||C.parentFrame.isDetached())&&f.removeChildAtIndex(_,!0,!0)}}treeElementAddedOrChanged(){}_updateContentOverflowShadowVisibility(){if(this.visible){this._updateContentOverflowShadowVisibility.cancelDebounce();let _=this.contentView.element.scrollHeight,S=this.contentView.element.offsetHeight;if(_<S)return this._topOverflowShadowElement&&(this._topOverflowShadowElement.style.opacity=0),void(this._bottomOverflowShadowElement.style.opacity=0);let C=1,f=this.contentView.element.scrollTop,T=Math.min(f,C),E=Math.max(0,S+f-(_-C));this._topOverflowShadowElement&&(this._topOverflowShadowElement.style.opacity=(T/C).toFixed(1)),this._bottomOverflowShadowElement.style.opacity=(1-E/C).toFixed(1)}}_checkForEmptyFilterResults(){function _(S){if(S.children.length){let C=!1,f=!1,T=S.children[0];for(;T;){let E=T[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol];if(!E&&(C=!0,!T.hidden)){f=!0;break}T=T.nextSibling}return f||!C?(this.hideEmptyContentPlaceholder(S),void this._emptyFilterResults.set(S,!1)):void(this.showEmptyContentPlaceholder(WebInspector.UIString("No Filter Results"),S),this._emptyFilterResults.set(S,!0))}}for(let S of this.contentTreeOutlines)S[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]||_.call(this,S)}_filterDidChange(){this._updateFilter()}_updateFilter(){let _;for(let f of this.contentTreeOutlines)if(!(f.hidden||f[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol])&&(_=f.selectedTreeElement,_))break;let S=this._filterBar.filters;this._textFilterRegex=simpleGlobStringToRegExp(S.text,"i"),this._filtersSetting.value=S,this._filterFunctions=S.functions;let C=!this._filterBar.hasActiveFilters()&&!this.shouldFilterPopulate();for(let f of this.contentTreeOutlines)if(!(f.hidden||f[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]))for(let z=f.children[0];z&&!z.root;){if(!z[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]){const K=z.hidden;this.applyFiltersToTreeElement(z),K!==z.hidden&&this._treeElementWasFiltered(z)}z=z.traverseNextTreeElement(!1,null,C)}this._checkForEmptyFilterResults(),this._updateContentOverflowShadowVisibility()}_treeElementAddedOrChanged(_){var S=!this._filterBar.hasActiveFilters()&&!this.shouldFilterPopulate();let C=_.data.element,f=C;for(;f&&!f.root;){if(!f[WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol]){const T=f.hidden;this.applyFiltersToTreeElement(f),T!==f.hidden&&this._treeElementWasFiltered(f)}f=f.traverseNextTreeElement(!1,C,S)}this._checkForEmptyFilterResults(),this.visible&&this.soon._updateContentOverflowShadowVisibility(),this.selected&&this._checkElementsForPendingViewStateCookie([C]),this.treeElementAddedOrChanged(C)}_treeElementDisclosureDidChange(){this.soon._updateContentOverflowShadowVisibility()}_checkForStaleResourcesIfNeeded(){this._checkForStaleResourcesTimeoutIdentifier&&this._shouldAutoPruneStaleTopLevelResourceTreeElements&&this.pruneStaleResourceTreeElements()}_checkForStaleResources(){this._checkForStaleResourcesTimeoutIdentifier||(this._checkForStaleResourcesTimeoutIdentifier=setTimeout(this.pruneStaleResourceTreeElements.bind(this)))}_isTreeElementWithoutRepresentedObject(_){return _ instanceof WebInspector.FolderTreeElement||_ instanceof WebInspector.DatabaseHostTreeElement||_ instanceof WebInspector.IndexedDatabaseHostTreeElement||_ instanceof WebInspector.ApplicationCacheManifestTreeElement||_ instanceof WebInspector.ThreadTreeElement||_ instanceof WebInspector.IdleTreeElement||_ instanceof WebInspector.DOMBreakpointTreeElement||_ instanceof WebInspector.XHRBreakpointTreeElement||_ instanceof WebInspector.CSSStyleSheetTreeElement||"string"==typeof _.representedObject||_.representedObject instanceof String}_checkOutlinesForPendingViewStateCookie(_){if(this._pendingViewStateCookie){this._checkForStaleResourcesIfNeeded();var S=[];return this.contentTreeOutlines.forEach(function(C){for(var f=C.hasChildren?C.children[0]:null;f;)S.push(f),f=f.traverseNextTreeElement(!1,null,!1)}),this._checkElementsForPendingViewStateCookie(S,_)}}_checkElementsForPendingViewStateCookie(_,S){function C(E){if(this._isTreeElementWithoutRepresentedObject(E))return!1;var I=E.representedObject;if(!I)return!1;var R=f[WebInspector.TypeIdentifierCookieKey];if(R!==I.constructor.TypeIdentifier)return!1;if(S)return!0;var N={};I.saveIdentityToCookie&&I.saveIdentityToCookie(N);var L=Object.keys(N);return L.length&&L.every(D=>N[D]===f[D])}if(this._pendingViewStateCookie){var f=this._pendingViewStateCookie,T=null;if(_.some(E=>{return!!C.call(this,E)&&(T=E,!0)}),T){let E=this.showDefaultContentViewForTreeElement(T);if(!E)return;this._pendingViewStateCookie=null,setTimeout(()=>{this._restoringState=!1},0),this._finalAttemptToRestoreViewStateTimeout&&(clearTimeout(this._finalAttemptToRestoreViewStateTimeout),this._finalAttemptToRestoreViewStateTimeout=void 0)}}}_createEmptyContentPlaceholderIfNeeded(_){let S=this._emptyContentPlaceholderElements.get(_);if(S)return S;S=document.createElement("div"),S.classList.add(WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderElementStyleClassName),this._emptyContentPlaceholderElements.set(_,S);let C=document.createElement("div");return C.className=WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderMessageElementStyleClassName,S.appendChild(C),S}_treeElementWasFiltered(_){if(!(_.selected||_.hidden)){let S=this.currentRepresentedObject;if(S&&_.representedObject===S){_.revealAndSelect(!0,!1,!0,!0)}}}},WebInspector.NavigationSidebarPanel.SuppressFilteringSymbol=Symbol("suppress-filtering"),WebInspector.NavigationSidebarPanel.WasExpandedDuringFilteringSymbol=Symbol("was-expanded-during-filtering"),WebInspector.NavigationSidebarPanel.OverflowShadowElementStyleClassName="overflow-shadow",WebInspector.NavigationSidebarPanel.ContentTreeOutlineElementStyleClassName="navigation-sidebar-panel-content-tree-outline",WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderElementStyleClassName="empty-content-placeholder",WebInspector.NavigationSidebarPanel.EmptyContentPlaceholderMessageElementStyleClassName="message",WebInspector.PinnedTabBarItem=class extends WebInspector.TabBarItem{constructor(_,S,C){super(_,S,C),this.element.classList.add("pinned"),this.element.addEventListener("contextmenu",this._handleContextMenuEvent.bind(this))}_handleContextMenuEvent(_){_.preventDefault();let S=WebInspector.ContextMenu.createFromEvent(_);this.dispatchEventToListeners(WebInspector.PinnedTabBarItem.Event.ContextMenu,{contextMenu:S})}},WebInspector.PinnedTabBarItem.Event={ContextMenu:"pinned-tab-bar-item-context-menu"},WebInspector.ResourceContentView=class extends WebInspector.ContentView{constructor(_,S){if(super(_),this._resource=_,this.element.classList.add(S,"resource"),this._spinnerTimeout=setTimeout(()=>{let T=new WebInspector.IndeterminateProgressSpinner;this.element.appendChild(T.element),this._spinnerTimeout=void 0},100),this.element.addEventListener("click",this._mouseWasClicked.bind(this),!1),_.requestContent().then(this._contentAvailable.bind(this)).catch(this.showGenericErrorMessage.bind(this)),!this.managesOwnIssues){WebInspector.issueManager.addEventListener(WebInspector.IssueManager.Event.IssueWasAdded,this._issueWasAdded,this);for(var C=WebInspector.issueManager.issuesForSourceCode(_),f=0;f<C.length;++f)this.addIssue(C[f])}}get resource(){return this._resource}get supportsSave(){return this._resource.finished}get saveData(){return{url:this._resource.url,content:this._resource.content}}contentAvailable(){}showGenericErrorMessage(){this._contentError(WebInspector.UIString("An error occurred trying to load the resource."))}addIssue(_){this.element.removeChildren(),this.element.appendChild(WebInspector.createMessageTextView(_.text,_.level===WebInspector.IssueMessage.Level.Error))}closed(){super.closed(),this.managesOwnIssues||WebInspector.issueManager.removeEventListener(null,null,this)}removeLoadingIndicator(){this._spinnerTimeout&&(clearTimeout(this._spinnerTimeout),this._spinnerTimeout=void 0),this.element.removeChildren()}_contentAvailable(_){return _.error?void this._contentError(_.error):void this.contentAvailable(_.sourceCode.content,_.base64Encoded)}_contentError(_){this._hasContent()||(this.removeLoadingIndicator(),this.element.appendChild(WebInspector.createMessageTextView(_,!0)),this.dispatchEventToListeners(WebInspector.ResourceContentView.Event.ContentError))}_hasContent(){return this.element.hasChildNodes()&&!this.element.querySelector(".indeterminate-progress-spinner")}_issueWasAdded(_){var S=_.data.issue;WebInspector.IssueManager.issueMatchSourceCode(S,this.resource)&&this.addIssue(S)}_mouseWasClicked(_){WebInspector.handlePossibleLinkClick(_,this.resource.parentFrame)}},WebInspector.ResourceContentView.Event={ContentError:"resource-content-view-content-error"},WebInspector.TabContentView=class extends WebInspector.ContentView{constructor(_,S,C,f,T){super(null),this.element.classList.add("tab"),"string"==typeof S&&(S=[S]),this.element.classList.add(...S),this._identifier=_,this._tabBarItem=C,this._navigationSidebarPanelConstructor=f||null,this._detailsSidebarPanelConstructors=T||[];const E=300;this._navigationSidebarCollapsedSetting=new WebInspector.Setting(_+"-navigation-sidebar-collapsed",!1),this._navigationSidebarWidthSetting=new WebInspector.Setting(_+"-navigation-sidebar-width",E),this._detailsSidebarCollapsedSetting=new WebInspector.Setting(_+"-details-sidebar-collapsed",!0),this._detailsSidebarSelectedPanelSetting=new WebInspector.Setting(_+"-details-sidebar-selected-panel",null),this._detailsSidebarWidthSetting=new WebInspector.Setting(_+"-details-sidebar-width",E),this._cookieSetting=new WebInspector.Setting(_+"-tab-cookie",{})}static isTabAllowed(){return!0}static isEphemeral(){return!1}static shouldSaveTab(){return!0}get type(){return null}get parentTabBrowser(){return this._parentTabBrowser}set parentTabBrowser(_){this._parentTabBrowser=_||null}get identifier(){return this._identifier}get tabBarItem(){return this._tabBarItem}get managesDetailsSidebarPanels(){return!1}showDetailsSidebarPanels(){}showRepresentedObject(){}canShowRepresentedObject(){return!1}shown(){super.shown(),this._shouldRestoreStateWhenShown&&this.restoreStateFromCookie(WebInspector.StateRestorationType.Delayed)}restoreStateFromCookie(_){if(!this.visible)return void(this._shouldRestoreStateWhenShown=!0);this._shouldRestoreStateWhenShown=!1;var S=0;_===WebInspector.StateRestorationType.Load?S=1e3:_===WebInspector.StateRestorationType.Navigation&&(S=2e3);let C=this._cookieSetting.value||{};this.navigationSidebarPanel&&this.navigationSidebarPanel.restoreStateFromCookie(C,S),this.restoreFromCookie(C)}saveStateToCookie(_){this._shouldRestoreStateWhenShown||(_=_||{},this.navigationSidebarPanel&&this.navigationSidebarPanel.saveStateToCookie(_),this.saveToCookie(_),this._cookieSetting.value=_)}get navigationSidebarPanel(){return this._navigationSidebarPanelConstructor?WebInspector.instanceForClass(this._navigationSidebarPanelConstructor):null}get navigationSidebarCollapsedSetting(){return this._navigationSidebarCollapsedSetting}get navigationSidebarWidthSetting(){return this._navigationSidebarWidthSetting}get detailsSidebarPanels(){return this._detailsSidebarPanels||(this._detailsSidebarPanels=this._detailsSidebarPanelConstructors.map(_=>WebInspector.instanceForClass(_))),this._detailsSidebarPanels}get detailsSidebarCollapsedSetting(){return this._detailsSidebarCollapsedSetting}get detailsSidebarSelectedPanelSetting(){return this._detailsSidebarSelectedPanelSetting}get detailsSidebarWidthSetting(){return this._detailsSidebarWidthSetting}},WebInspector.TimelineDataGrid=class extends WebInspector.DataGrid{constructor(_,S,C,f,T){super(_,f,T),S&&(this._treeOutlineDataGridSynchronizer=new WebInspector.TreeOutlineDataGridSynchronizer(S,this,C)),this.element.classList.add("timeline"),this._sortDelegate=null,this._scopeBarColumns=[];for(var[E,I]of this.columns){var R=I.scopeBar;R&&(this._scopeBarColumns.push(E),R.columnIdentifier=E,R.addEventListener(WebInspector.ScopeBar.Event.SelectionChanged,this._scopeBarSelectedItemsDidChange,this))}return 1<this._scopeBarColumns.length?void console.error("Creating a TimelineDataGrid with more than one filterable column is not yet supported."):void(this.addEventListener(WebInspector.DataGrid.Event.SelectedNodeChanged,this._dataGridSelectedNodeChanged,this),this.addEventListener(WebInspector.DataGrid.Event.SortChanged,this._sort,this),this.columnChooserEnabled=!0)}static createColumnScopeBar(_,S){_+="-timeline-data-grid-";var C=[];for(var[f,T]of S){var E=_+f,I=new WebInspector.ScopeBarItem(E,T);I.value=f,C.push(I)}var R=new WebInspector.ScopeBarItem(_+"type-all",WebInspector.UIString("All"));return C.unshift(R),new WebInspector.ScopeBar(_+"scope-bar",C,R,!0)}get sortDelegate(){return this._sortDelegate}set sortDelegate(_){_=_||null;this._sortDelegate===_||(this._sortDelegate=_,this.sortOrder!==WebInspector.DataGrid.SortOrder.Indeterminate&&this.dispatchEventToListeners(WebInspector.DataGrid.Event.SortChanged))}reset(){this._treeOutlineDataGridSynchronizer||this.removeChildren(),this._hidePopover()}shown(){this._treeOutlineDataGridSynchronizer&&this._treeOutlineDataGridSynchronizer.synchronize()}hidden(){this._hidePopover()}treeElementForDataGridNode(_){return this._treeOutlineDataGridSynchronizer?this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(_):null}dataGridNodeForTreeElement(_){return this._treeOutlineDataGridSynchronizer?this._treeOutlineDataGridSynchronizer.dataGridNodeForTreeElement(_):null}callFramePopoverAnchorElement(){return null}addRowInSortOrder(_,S,C){let f,T=S;if(_){if(!this._treeOutlineDataGridSynchronizer)return;this._treeOutlineDataGridSynchronizer.associate(_,S);let E=C||this._treeOutlineDataGridSynchronizer.treeOutline;f=E.root?this:this._treeOutlineDataGridSynchronizer.dataGridNodeForTreeElement(E),C=E,T=_}else C=C||this,f=C;if(this.sortColumnIdentifier){let E=insertionIndexForObjectInListSortedByFunction(S,f.children,this._sortComparator.bind(this));C.insertChild(T,E)}else C.appendChild(T)}shouldIgnoreSelectionEvent(){return this._ignoreSelectionEvent||!1}dataGridNodeNeedsRefresh(_){this._dirtyDataGridNodes||(this._dirtyDataGridNodes=new Set),this._dirtyDataGridNodes.add(_);this._scheduledDataGridNodeRefreshIdentifier||(this._scheduledDataGridNodeRefreshIdentifier=requestAnimationFrame(this._refreshDirtyDataGridNodes.bind(this)))}hasCustomFilters(){return!0}matchNodeAgainstCustomFilters(_){if(!super.matchNodeAgainstCustomFilters(_))return!1;for(let S of this._scopeBarColumns){let C=this.columns.get(S).scopeBar;if(C&&!C.defaultItem.selected){let q=_.data[S];if(!C.selectedItems.some(X=>X.value===q))return!1}}return!0}_refreshDirtyDataGridNodes(){if(this._scheduledDataGridNodeRefreshIdentifier&&(cancelAnimationFrame(this._scheduledDataGridNodeRefreshIdentifier),this._scheduledDataGridNodeRefreshIdentifier=void 0),!!this._dirtyDataGridNodes){let _=this.selectedNode,S=this._sortComparator.bind(this);this._treeOutlineDataGridSynchronizer&&(this._treeOutlineDataGridSynchronizer.enabled=!1);for(let C of this._dirtyDataGridNodes)if(C.refresh(),this.sortColumnIdentifier){C===_&&(this._ignoreSelectionEvent=!0),C.parent===this&&this.removeChild(C);let Y=insertionIndexForObjectInListSortedByFunction(C,this.children,S);if(this.insertChild(C,Y),C===_&&(_.revealAndSelect(),this._ignoreSelectionEvent=!1),this._treeOutlineDataGridSynchronizer){let Q=this._treeOutlineDataGridSynchronizer.treeOutline,J=this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(C);Q.reattachIfIndexChanged(J,Y),C.element.classList.toggle("hidden",J.hidden)}}this._treeOutlineDataGridSynchronizer&&(this._treeOutlineDataGridSynchronizer.enabled=!0),this._dirtyDataGridNodes=null}}_sort(){if(this.children.length){let _=this.sortColumnIdentifier;if(_){let S=this.selectedNode;this._ignoreSelectionEvent=!0;let C;this._treeOutlineDataGridSynchronizer&&(this._treeOutlineDataGridSynchronizer.enabled=!1,C=this._treeOutlineDataGridSynchronizer.treeOutline,C.selectedTreeElement&&C.selectedTreeElement.deselect(!0));let f=[this],T=this.children[0];for(;T;)T.children.length&&f.push(T),T=T.traverseNextNode(!1,null,!0);for(let E of f){let I=E.children.slice();E.removeChildren();let R;this._treeOutlineDataGridSynchronizer&&(R=E===this?C:this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(E),R.removeChildren()),I.sort(this._sortComparator.bind(this));for(let N of I){if(this._treeOutlineDataGridSynchronizer){let L=this._treeOutlineDataGridSynchronizer.treeElementForDataGridNode(N);R&&R.appendChild(L),N.element.classList.toggle("hidden",L.hidden)}E.appendChild(N)}}this._treeOutlineDataGridSynchronizer&&(this._treeOutlineDataGridSynchronizer.enabled=!0),S&&S.revealAndSelect(),this._ignoreSelectionEvent=!1}}}_sortComparator(_,S){var C=this.sortColumnIdentifier;if(!C)return 0;var f=this.sortOrder===WebInspector.DataGrid.SortOrder.Ascending?1:-1;if(this._sortDelegate&&"function"==typeof this._sortDelegate.dataGridSortComparator){let I=this._sortDelegate.dataGridSortComparator(C,f,_,S);if("number"==typeof I)return I}var T=_.data[C],E=S.data[C];return"number"==typeof T&&"number"==typeof E?isNaN(T)&&isNaN(E)?0:isNaN(T)?-f:isNaN(E)?f:(T-E)*f:"string"==typeof T&&"string"==typeof E?T.extendedLocaleCompare(E)*f:((T instanceof WebInspector.CallFrame||E instanceof WebInspector.CallFrame)&&(T=T&&T.functionName?T.functionName:T&&T.sourceCodeLocation?T.sourceCodeLocation.sourceCode:"",E=E&&E.functionName?E.functionName:E&&E.sourceCodeLocation?E.sourceCodeLocation.sourceCode:""),(T instanceof WebInspector.SourceCode||E instanceof WebInspector.SourceCode)&&(T=T?T.displayName||"":"",E=E?E.displayName||"":""),(T instanceof WebInspector.SourceCodeLocation||E instanceof WebInspector.SourceCodeLocation)&&(T=T?T.displayLocationString()||"":"",E=E?E.displayLocationString()||"":""),(T<E?-1:T>E?1:0)*f)}_scopeBarSelectedItemsDidChange(){this.filterDidChange()}_dataGridSelectedNodeChanged(){if(!this.selectedNode)return void this._hidePopover();var S=this.selectedNode.record;return S&&S.callFrames&&S.callFrames.length?void this._showPopoverForSelectedNodeSoon():void this._hidePopover()}_showPopoverForSelectedNodeSoon(){this._showPopoverTimeout||(this._showPopoverTimeout=setTimeout(()=>{this._popover||(this._popover=new WebInspector.Popover,this._popover.windowResizeHandler=()=>{this._updatePopoverForSelectedNode(!1)}),this._updatePopoverForSelectedNode(!0),this._showPopoverTimeout=void 0},WebInspector.TimelineDataGrid.DelayedPopoverShowTimeout))}_hidePopover(){this._showPopoverTimeout&&(clearTimeout(this._showPopoverTimeout),this._showPopoverTimeout=void 0),this._popover&&this._popover.dismiss(),this._hidePopoverContentClearTimeout&&clearTimeout(this._hidePopoverContentClearTimeout),this._hidePopoverContentClearTimeout=setTimeout(()=>{this._popoverCallStackTreeOutline&&this._popoverCallStackTreeOutline.removeChildren()},WebInspector.TimelineDataGrid.DelayedPopoverHideContentClearTimeout)}_updatePopoverForSelectedNode(_){if(this._popover&&this.selectedNode){let S=this.callFramePopoverAnchorElement();if(S){let C=WebInspector.Rect.rectFromClientRect(S.getBoundingClientRect());if(C.size.width||C.size.height){this._hidePopoverContentClearTimeout&&(clearTimeout(this._hidePopoverContentClearTimeout),this._hidePopoverContentClearTimeout=void 0);let f=C.pad(2),T=[WebInspector.RectEdge.MAX_Y,WebInspector.RectEdge.MIN_Y,WebInspector.RectEdge.MAX_X];_?this._popover.presentNewContentWithFrame(this._createPopoverContent(),f,T):this._popover.present(f,T)}}}}_createPopoverContent(){this._popoverCallStackTreeOutline?this._popoverCallStackTreeOutline.removeChildren():(this._popoverCallStackTreeOutline=new WebInspector.TreeOutline,this._popoverCallStackTreeOutline.disclosureButtons=!1,this._popoverCallStackTreeOutline.element.classList.add("timeline-data-grid"),this._popoverCallStackTreeOutline.addEventListener(WebInspector.TreeOutline.Event.SelectionDidChange,this._popoverCallStackTreeSelectionDidChange,this));for(var _=this.selectedNode.record.callFrames,S=0,C;S<_.length;++S)C=new WebInspector.CallFrameTreeElement(_[S]),this._popoverCallStackTreeOutline.appendChild(C);var f=document.createElement("div");return f.className="timeline-data-grid-popover",f.appendChild(this._popoverCallStackTreeOutline.element),f}_popoverCallStackTreeSelectionDidChange(_){let S=_.data.selectedElement;if(S){this._popover.dismiss();var C=S.callFrame;C.sourceCodeLocation&&WebInspector.showSourceCodeLocation(C.sourceCodeLocation,{ignoreNetworkTab:!0,ignoreSearchTab:!0})}}},WebInspector.TimelineDataGrid.HasNonDefaultFilterStyleClassName="has-non-default-filter",WebInspector.TimelineDataGrid.DelayedPopoverShowTimeout=250,WebInspector.TimelineDataGrid.DelayedPopoverHideContentClearTimeout=500,WebInspector.TimelineDataGridNode=class extends WebInspector.DataGridNode{constructor(_,S,C){super({},C),this.copyable=!1,this._includesGraph=_||!1,this._graphDataSource=S||null,S&&(this._graphContainerElement=document.createElement("div"),this._timelineRecordBars=[])}get record(){return this.records&&this.records.length?this.records[0]:null}get records(){return[]}get graphDataSource(){return this._graphDataSource}get data(){if(!this._graphDataSource)return{};var _=this.records||[];return{graph:_.length?_[0].startTime:0}}collapse(){super.collapse();this._graphDataSource&&this.revealed&&this.refreshGraph()}expand(){if(super.expand(),this._graphDataSource&&this.revealed){this.refreshGraph();for(var _=this.children[0];_;)_ instanceof WebInspector.TimelineDataGridNode&&_.refreshGraph(),_=_.traverseNextNode(!0,this)}}createCellContent(_,S){if("graph"===_&&this._graphDataSource)return this.needsGraphRefresh(),this._graphContainerElement;var C=this.data[_];if(!C)return emDash;const f={useGoToArrowButton:!0,ignoreNetworkTab:!0,ignoreSearchTab:!0};if(C instanceof WebInspector.SourceCodeLocation){C.sourceCode instanceof WebInspector.Resource?(S.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName),S.classList.add(C.sourceCode.type)):C.sourceCode instanceof WebInspector.Script?C.sourceCode.url?(S.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName),S.classList.add(WebInspector.Resource.Type.Script)):S.classList.add(WebInspector.ScriptTreeElement.AnonymousScriptIconStyleClassName):console.error("Unknown SourceCode subclass."),C.populateLiveDisplayLocationTooltip(S);var T=document.createDocumentFragment();T.appendChild(WebInspector.createSourceCodeLocationLink(C,f));var E=document.createElement("span");return C.populateLiveDisplayLocationString(E,"textContent"),T.appendChild(E),T}if(C instanceof WebInspector.CallFrame){var I=C,R=!1,N=I.functionName;N||(N=WebInspector.UIString("(anonymous function)"),R=!0),S.classList.add(WebInspector.CallFrameView.FunctionIconStyleClassName);var T=document.createDocumentFragment();if(I.sourceCodeLocation&&I.sourceCodeLocation.sourceCode){if(I.sourceCodeLocation.populateLiveDisplayLocationTooltip(S),T.appendChild(WebInspector.createSourceCodeLocationLink(I.sourceCodeLocation,f)),R){I.sourceCodeLocation.sourceCode instanceof WebInspector.Resource?(S.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName),S.classList.add(I.sourceCodeLocation.sourceCode.type)):I.sourceCodeLocation.sourceCode instanceof WebInspector.Script?I.sourceCodeLocation.sourceCode.url?(S.classList.add(WebInspector.ResourceTreeElement.ResourceIconStyleClassName),S.classList.add(WebInspector.Resource.Type.Script)):S.classList.add(WebInspector.ScriptTreeElement.AnonymousScriptIconStyleClassName):console.error("Unknown SourceCode subclass.");var E=document.createElement("span");I.sourceCodeLocation.populateLiveDisplayLocationString(E,"textContent"),T.appendChild(E)}else{S.classList.add(WebInspector.CallFrameView.FunctionIconStyleClassName),T.append(N);var L=document.createElement("span");L.classList.add("subtitle"),I.sourceCodeLocation.populateLiveDisplayLocationString(L,"textContent"),T.appendChild(L)}return T}var D=document.createElement("div");return D.classList.add("icon"),T.append(D,N),T}return super.createCellContent(_,S)}refresh(){this._graphDataSource&&this._includesGraph&&this.needsGraphRefresh(),super.refresh()}refreshGraph(){function _(N,L){var D=this._timelineRecordBars[f];D?(D.renderMode=L,D.records=N):D=this._timelineRecordBars[f]=new WebInspector.TimelineRecordBar(N,L),D.refresh(this._graphDataSource),D.element.parentNode||(this._graphContainerElement.appendChild(D.element),this.didAddRecordBar(D)),++f}function S(N,L){for(var D of N){var M=L.get(D.type);M||(M=[],L.set(D.type,M)),M.push(D)}}if(this._graphDataSource&&(this._scheduledGraphRefreshIdentifier&&(cancelAnimationFrame(this._scheduledGraphRefreshIdentifier),this._scheduledGraphRefreshIdentifier=void 0),!!this.revealed)){let C=this._graphDataSource.secondsPerPixel;if(!isNaN(C)){var f=0,T=_.bind(this);if(this.expanded)WebInspector.TimelineRecordBar.createCombinedBars(this.records,C,this._graphDataSource,T);else{var E=new Map;S(this.records,E);for(var I=this.children[0];I;)I instanceof WebInspector.TimelineDataGridNode&&S(I.records,E),I=I.traverseNextNode(!1,this);for(var R of E.values())WebInspector.TimelineRecordBar.createCombinedBars(R,C,this._graphDataSource,T)}for(;f<this._timelineRecordBars.length;++f)this._timelineRecordBars[f].element.remove(),this.didRemoveRecordBar(this._timelineRecordBars[f]),this._timelineRecordBars[f].records=null}}}needsGraphRefresh(){if(!this.revealed){for(var _=this;_&&!_.root;){if(_.revealed&&_ instanceof WebInspector.TimelineDataGridNode)return void _.needsGraphRefresh();_=_.parent}return}!this._graphDataSource||this._scheduledGraphRefreshIdentifier||(this._scheduledGraphRefreshIdentifier=requestAnimationFrame(this.refreshGraph.bind(this)))}displayName(){return WebInspector.TimelineTabContentView.displayNameForRecord(this.record,!0)}iconClassNames(){return[WebInspector.TimelineTabContentView.iconClassNameForRecord(this.record)]}createGoToArrowButton(_,S){let f=WebInspector.createGoToArrowButton();f.addEventListener("click",function(E){this.hidden||!this.revealed||(E.stopPropagation(),S(this,_.__columnIdentifier))}.bind(this));let T=_.firstChild;T.appendChild(f)}isRecordVisible(_){return!!this._graphDataSource&&!isNaN(_.startTime)&&!(_.endTime<this.graphDataSource.startTime)&&(_.startTime>this.graphDataSource.currentTime||_.startTime>this.graphDataSource.endTime?!1:!0)}filterableDataForColumn(_){let S=this.data[_];return S instanceof WebInspector.SourceCodeLocation?S.displayLocationString():S instanceof WebInspector.CallFrame?[S.functionName,S.sourceCodeLocation.displayLocationString()]:super.filterableDataForColumn(_)}didAddRecordBar(){}didRemoveRecordBar(){}didResizeColumn(_){"graph"!==_||this.needsGraphRefresh()}},WebInspector.ContentBrowserTabContentView=class extends WebInspector.TabContentView{constructor(_,S,C,f,T,E){"string"==typeof S&&(S=[S]),S.push("content-browser");var I=new WebInspector.ContentBrowser(null,null,E);if(super(_,S,C,f,T),this._contentBrowser=I,this._contentBrowser.delegate=this,this._lastSelectedDetailsSidebarPanelSetting=new WebInspector.Setting(_+"-last-selected-details-sidebar-panel",null),this._contentBrowser.addEventListener(WebInspector.ContentBrowser.Event.CurrentRepresentedObjectsDidChange,this.showDetailsSidebarPanels,this),this._contentBrowser.addEventListener(WebInspector.ContentBrowser.Event.CurrentContentViewDidChange,this._contentBrowserCurrentContentViewDidChange,this),this._contentBrowser.updateHierarchicalPathForCurrentContentView(),f){let R=WebInspector.UIString("Show the navigation sidebar (%s)").format(WebInspector.navigationSidebarKeyboardShortcut.displayName),N=WebInspector.UIString("Hide the navigation sidebar (%s)").format(WebInspector.navigationSidebarKeyboardShortcut.displayName),L=WebInspector.resolvedLayoutDirection()==WebInspector.LayoutDirection.RTL?"Images/ToggleRightSidebar.svg":"Images/ToggleLeftSidebar.svg";this._showNavigationSidebarItem=new WebInspector.ActivateButtonNavigationItem("toggle-navigation-sidebar",R,N,L,16,16),this._showNavigationSidebarItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,WebInspector.toggleNavigationSidebar,WebInspector),this._showNavigationSidebarItem.activated=!WebInspector.navigationSidebar.collapsed,this._contentBrowser.navigationBar.insertNavigationItem(this._showNavigationSidebarItem,0),this._contentBrowser.navigationBar.insertNavigationItem(new WebInspector.DividerNavigationItem,1),WebInspector.navigationSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._navigationSidebarCollapsedStateDidChange,this)}if(T&&T.length){let R=WebInspector.UIString("Show the details sidebar (%s)").format(WebInspector.detailsSidebarKeyboardShortcut.displayName),N=WebInspector.UIString("Hide the details sidebar (%s)").format(WebInspector.detailsSidebarKeyboardShortcut.displayName),L=WebInspector.resolvedLayoutDirection()==WebInspector.LayoutDirection.RTL?"Images/ToggleLeftSidebar.svg":"Images/ToggleRightSidebar.svg";this._showDetailsSidebarItem=new WebInspector.ActivateButtonNavigationItem("toggle-details-sidebar",R,N,L,16,16),this._showDetailsSidebarItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,WebInspector.toggleDetailsSidebar,WebInspector),this._showDetailsSidebarItem.activated=!WebInspector.detailsSidebar.collapsed,this._showDetailsSidebarItem.enabled=!1,this._contentBrowser.navigationBar.addNavigationItem(new WebInspector.DividerNavigationItem),this._contentBrowser.navigationBar.addNavigationItem(this._showDetailsSidebarItem),WebInspector.detailsSidebar.addEventListener(WebInspector.Sidebar.Event.CollapsedStateDidChange,this._detailsSidebarCollapsedStateDidChange,this),WebInspector.detailsSidebar.addEventListener(WebInspector.Sidebar.Event.SidebarPanelSelected,this._detailsSidebarPanelSelected,this)}this.addSubview(this._contentBrowser)}get contentBrowser(){return this._contentBrowser}shown(){this.navigationSidebarPanel&&!this.navigationSidebarPanel.contentBrowser&&(this.navigationSidebarPanel.contentBrowser=this._contentBrowser),super.shown(),this._contentBrowser.shown(),this.navigationSidebarPanel&&!this._contentBrowser.currentContentView&&this.navigationSidebarPanel.showDefaultContentView()}hidden(){super.hidden(),this._contentBrowser.hidden()}closed(){super.closed(),WebInspector.navigationSidebar.removeEventListener(null,null,this),WebInspector.detailsSidebar.removeEventListener(null,null,this),this.navigationSidebarPanel&&"function"==typeof this.navigationSidebarPanel.closed&&this.navigationSidebarPanel.closed(),this._contentBrowser.contentViewContainer.closeAllContentViews()}get managesDetailsSidebarPanels(){return!0}showDetailsSidebarPanels(){if(this.visible){var _=this._contentBrowser.currentRepresentedObjects,S=WebInspector.detailsSidebar.sidebarPanels,C=!S.length;this._ignoreDetailsSidebarPanelSelectedEvent=!0,this._ignoreDetailsSidebarPanelCollapsedEvent=!0;let f=0;for(var T=0,E;T<this.detailsSidebarPanels.length;++T)if(E=this.detailsSidebarPanels[T],E.inspect(_)){if(S.includes(E))continue;let I=T-f;WebInspector.detailsSidebar.insertSidebarPanel(E,I),this._lastSelectedDetailsSidebarPanelSetting.value===E.identifier&&(WebInspector.detailsSidebar.selectedSidebarPanel=E)}else WebInspector.detailsSidebar.removeSidebarPanel(E),f++;!WebInspector.detailsSidebar.selectedSidebarPanel&&S.length&&(WebInspector.detailsSidebar.selectedSidebarPanel=S[0]),WebInspector.detailsSidebar.sidebarPanels.length?C&&(WebInspector.detailsSidebar.collapsed=this.detailsSidebarCollapsedSetting.value):WebInspector.detailsSidebar.collapsed=!0,this._ignoreDetailsSidebarPanelCollapsedEvent=!1,this._ignoreDetailsSidebarPanelSelectedEvent=!1,this.detailsSidebarPanels.length&&(this._showDetailsSidebarItem.enabled=WebInspector.detailsSidebar.sidebarPanels.length)}}showRepresentedObject(_,S){this.navigationSidebarPanel&&this.navigationSidebarPanel.cancelRestoringState(),this.contentBrowser.showContentViewForRepresentedObject(_,S)}contentBrowserTreeElementForRepresentedObject(_,S){return this.treeElementForRepresentedObject(S)}treeElementForRepresentedObject(_){return this.navigationSidebarPanel?this.navigationSidebarPanel.treeElementForRepresentedObject(_):null}_navigationSidebarCollapsedStateDidChange(){this._showNavigationSidebarItem.activated=!WebInspector.navigationSidebar.collapsed}_detailsSidebarCollapsedStateDidChange(){this.visible&&(this._showDetailsSidebarItem.activated=!WebInspector.detailsSidebar.collapsed,this._showDetailsSidebarItem.enabled=WebInspector.detailsSidebar.sidebarPanels.length,this._ignoreDetailsSidebarPanelCollapsedEvent||(this.detailsSidebarCollapsedSetting.value=WebInspector.detailsSidebar.collapsed))}_detailsSidebarPanelSelected(){this.visible&&(this._showDetailsSidebarItem.activated=!WebInspector.detailsSidebar.collapsed,this._showDetailsSidebarItem.enabled=WebInspector.detailsSidebar.sidebarPanels.length,!WebInspector.detailsSidebar.selectedSidebarPanel||this._ignoreDetailsSidebarPanelSelectedEvent||(this._lastSelectedDetailsSidebarPanelSetting.value=WebInspector.detailsSidebar.selectedSidebarPanel.identifier))}_contentBrowserCurrentContentViewDidChange(){let S=this._contentBrowser.currentContentView;S&&this._revealAndSelectRepresentedObject(S.representedObject)}_revealAndSelectRepresentedObject(_){if(this.navigationSidebarPanel)for(let C of this.navigationSidebarPanel.contentTreeOutlines)if(C.processingSelectionChange)return;let S=this.treeElementForRepresentedObject(_);S?S.revealAndSelect(!0,!1,!0,!0):this.navigationSidebarPanel&&this.navigationSidebarPanel.contentTreeOutline.selectedTreeElement&&this.navigationSidebarPanel.contentTreeOutline.selectedTreeElement.deselect(!0)}},WebInspector.DOMDetailsSidebarPanel=class extends WebInspector.DetailsSidebarPanel{constructor(_,S,C){super(_,S,C),this.element.addEventListener("click",this._mouseWasClicked.bind(this),!0),this._domNode=null}inspect(_){_ instanceof Array||(_=[_]);for(var S=null,C=0;C<_.length;++C)if(_[C]instanceof WebInspector.DOMNode){S=_[C];break}return S&&!this.supportsDOMNode(S)&&(S=null),this.domNode=S,!!this._domNode}get domNode(){return this._domNode}set domNode(_){_===this._domNode||(this._domNode&&this.removeEventListeners(),this._domNode=_,this._domNode&&this.addEventListeners(),this.needsLayout())}supportsDOMNode(){return!0}addEventListeners(){}removeEventListeners(){}_mouseWasClicked(_){if(this._domNode&&this._domNode.ownerDocument){var S=WebInspector.frameResourceManager.resourceForURL(this._domNode.ownerDocument.documentURL);if(S)var C=S.parentFrame}WebInspector.handlePossibleLinkClick(_,C,{ignoreNetworkTab:!0,ignoreSearchTab:!0})}},WebInspector.FolderTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S){const C=[WebInspector.FolderTreeElement.FolderIconStyleClassName];super(C,_,null,S,!0)}},WebInspector.FolderTreeElement.FolderIconStyleClassName="folder-icon",WebInspector.FolderizedTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S,C,f,T){super(_,S,C,f,T),this.shouldRefreshChildren=!0,this._folderExpandedSettingMap=new Map,this._folderSettingsKey="",this._folderTypeMap=new Map,this._folderizeSettingsMap=new Map,this._groupedIntoFolders=!1,this._clearNewChildQueue()}get groupedIntoFolders(){return this._groupedIntoFolders}set folderSettingsKey(_){this._folderSettingsKey=_}registerFolderizeSettings(_,S,C,f){this._folderizeSettingsMap.set(_,{type:_,displayName:S,topLevel:null===S,representedObject:C,treeElementConstructor:f})}removeChildren(){super.removeChildren(),this._clearNewChildQueue();for(var _ of this._folderTypeMap.values())_.removeChildren();this._folderExpandedSettingMap.clear(),this._folderTypeMap.clear(),this._groupedIntoFolders=!1}addChildForRepresentedObject(_){var S=this._settingsForRepresentedObject(_);if(!S)return void console.error("No settings for represented object",_);if(!this.treeOutline)return void(this.shouldRefreshChildren=!0);var C=this.treeOutline.getCachedTreeElement(_);C||(C=new S.treeElementConstructor(_)),this._addTreeElement(C)}addRepresentedObjectToNewChildQueue(_){this._newChildQueue.push(_),this._newChildQueueTimeoutIdentifier||(this._newChildQueueTimeoutIdentifier=setTimeout(this._populateFromNewChildQueue.bind(this),WebInspector.FolderizedTreeElement.NewChildQueueUpdateInterval))}removeChildForRepresentedObject(_){if(this._removeRepresentedObjectFromNewChildQueue(_),this.updateParentStatus(),!this.treeOutline)return void(this.shouldRefreshChildren=!0);var S=this.treeOutline.getCachedTreeElement(_);S&&S.parent&&this._removeTreeElement(S)}compareChildTreeElements(_,S){return this._compareTreeElementsByMainTitle(_,S)}updateParentStatus(){let _=!1;for(let S of this._folderizeSettingsMap.values())if(S.representedObject.items.size){_=!0;break}this.hasChildren=_,this.hasChildren||this.removeChildren()}prepareToPopulate(){return!this._groupedIntoFolders&&this._shouldGroupIntoFolders()&&(this._groupedIntoFolders=!0,!0)}_clearNewChildQueue(){this._newChildQueue=[],this._newChildQueueTimeoutIdentifier&&(clearTimeout(this._newChildQueueTimeoutIdentifier),this._newChildQueueTimeoutIdentifier=null)}_populateFromNewChildQueue(){if(!this.children.length)return this.updateParentStatus(),void(this.shouldRefreshChildren=!0);if(this.prepareToPopulate())return this._clearNewChildQueue(),void(this.shouldRefreshChildren=!0);for(var _=0;_<this._newChildQueue.length;++_)this.addChildForRepresentedObject(this._newChildQueue[_]);this._clearNewChildQueue()}_removeRepresentedObjectFromNewChildQueue(_){this._newChildQueue.remove(_)}_addTreeElement(_){if(_){var S=_.selected;this._removeTreeElement(_,!0,!0);var C=this._parentTreeElementForRepresentedObject(_.representedObject);C===this||C.parent||this._insertFolderTreeElement(C),this._insertChildTreeElement(C,_),S&&_.revealAndSelect(!0,!1,!0,!0)}}_compareTreeElementsByMainTitle(_,S){let C=_ instanceof WebInspector.FolderTreeElement,f=S instanceof WebInspector.FolderTreeElement;return C&&!f?-1:f&&!C?1:_.mainTitle.extendedLocaleCompare(S.mainTitle)}_insertFolderTreeElement(_){this.insertChild(_,insertionIndexForObjectInListSortedByFunction(_,this.children,this._compareTreeElementsByMainTitle))}_insertChildTreeElement(_,S){_.insertChild(S,insertionIndexForObjectInListSortedByFunction(S,_.children,this.compareChildTreeElements.bind(this)))}_removeTreeElement(_,S,C){var f=_.parent;f&&(f.removeChild(_,S,C),f!==this&&f instanceof WebInspector.FolderTreeElement&&(f.children.length||f.parent.removeChild(f)))}_parentTreeElementForRepresentedObject(_){if(!this._groupedIntoFolders)return this;var C=this._settingsForRepresentedObject(_);if(!C)return console.error("Unknown representedObject",_),this;if(C.topLevel)return this;var f=this._folderTypeMap.get(C.type);return f?f:(f=function(T){let E=new WebInspector.FolderTreeElement(T.displayName,T.representedObject),I=new WebInspector.Setting(T.type+"-folder-expanded-"+this._folderSettingsKey,!1);return this._folderExpandedSettingMap.set(E,I),I.value&&E.expand(),E.onexpand=this._folderTreeElementExpandedStateChange.bind(this),E.oncollapse=this._folderTreeElementExpandedStateChange.bind(this),E}.call(this,C),this._folderTypeMap.set(C.type,f),f)}_folderTreeElementExpandedStateChange(_){let S=this._folderExpandedSettingMap.get(_);S&&(S.value=_.expanded)}_settingsForRepresentedObject(_){for(let S of this._folderizeSettingsMap.values())if(S.representedObject.typeVerifier(_))return S;return null}_shouldGroupIntoFolders(){function _(E){return!!E&&(!!f||(E>=WebInspector.FolderizedTreeElement.LargeChildCountThreshold?S||C||(f=!0,!1):E>=WebInspector.FolderizedTreeElement.MediumChildCountThreshold?++C>=WebInspector.FolderizedTreeElement.NumberOfMediumCategoriesThreshold:(++S,!1)))}if(this._groupedIntoFolders)return!0;var S=0,C=0,f=!1;for(var T of this._folderizeSettingsMap.values())if(_(T.representedObject.items.size))return!0;return!1}},WebInspector.FolderizedTreeElement.MediumChildCountThreshold=5,WebInspector.FolderizedTreeElement.LargeChildCountThreshold=15,WebInspector.FolderizedTreeElement.NumberOfMediumCategoriesThreshold=2,WebInspector.FolderizedTreeElement.NewChildQueueUpdateInterval=500,WebInspector.NetworkTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.NetworkTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];super(_||"network","network",f,WebInspector.NetworkSidebarPanel,T)}static tabInfo(){return{image:"Images/Network.svg",title:WebInspector.UIString("Network")}}static isTabAllowed(){return!!window.NetworkAgent&&!!window.PageAgent}get type(){return WebInspector.NetworkTabContentView.Type}canShowRepresentedObject(_){return!!(_ instanceof WebInspector.Resource)&&!!this.navigationSidebarPanel.contentTreeOutline.getCachedTreeElement(_)}get supportsSplitContentBrowser(){return!1}},WebInspector.NetworkTabContentView.Type="network",WebInspector.NewTabContentView=class extends WebInspector.TabContentView{constructor(_){let{image:S,title:C}=WebInspector.NewTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C);f.isDefaultTab=!0,super(_||"new-tab","new-tab",f),WebInspector.notifications.addEventListener(WebInspector.Notification.TabTypesChanged,this._updateShownTabs.bind(this)),this._tabElementsByTabClass=new Map,this._updateShownTabs()}static tabInfo(){return{image:"Images/NewTab.svg",title:WebInspector.UIString("New Tab")}}static isEphemeral(){return!0}static shouldSaveTab(){return!1}get type(){return WebInspector.NewTabContentView.Type}shown(){WebInspector.tabBrowser.tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemAdded,this._updateTabItems,this),WebInspector.tabBrowser.tabBar.addEventListener(WebInspector.TabBar.Event.TabBarItemRemoved,this._updateTabItems,this),this._updateTabItems()}hidden(){WebInspector.tabBrowser.tabBar.removeEventListener(null,null,this)}get supportsSplitContentBrowser(){return!1}layout(){this._tabElementsByTabClass.clear(),this.element.removeChildren();for(let _ of this._shownTabClasses){let S=document.createElement("div");S.classList.add("tab-item"),S.addEventListener("click",this._createNewTabWithType.bind(this,_.Type)),S[WebInspector.NewTabContentView.TypeSymbol]=_.Type;let C=S.appendChild(document.createElement("div"));C.classList.add("box");let f=_.tabInfo(),T=C.appendChild(document.createElement("img"));T.src=f.image;let E=S.appendChild(document.createElement("label"));E.textContent=f.title,this.element.appendChild(S),this._tabElementsByTabClass.set(_,S)}this._updateTabItems()}_createNewTabWithType(_){if(WebInspector.isNewTabWithTypeAllowed(_)){const C=1<this._allowableTabTypes().length,f={referencedView:this,shouldReplaceTab:!C||!WebInspector.modifierKeys.metaKey,shouldShowNewTab:!WebInspector.modifierKeys.metaKey};WebInspector.createNewTabWithType(_,f)}}_updateShownTabs(){let _=Array.from(WebInspector.knownTabClasses()),S=_.filter(C=>C.isTabAllowed()&&!C.isEphemeral());S.sort((C,f)=>C.tabInfo().title.extendedLocaleCompare(f.tabInfo().title));Array.shallowEqual(this._shownTabClasses,S)||(this._shownTabClasses=S,this.needsLayout())}_allowableTabTypes(){let _=this._shownTabClasses.map(S=>S.Type);return _.filter(S=>WebInspector.isNewTabWithTypeAllowed(S))}_updateTabItems(){for(let[_,S]of this._tabElementsByTabClass.entries()){let C=WebInspector.isNewTabWithTypeAllowed(_.Type);S.classList.toggle(WebInspector.NewTabContentView.DisabledStyleClassName,!C)}}},WebInspector.NewTabContentView.Type="new-tab",WebInspector.NewTabContentView.TypeSymbol=Symbol("type"),WebInspector.NewTabContentView.TabItemStyleClassName="tab-item",WebInspector.NewTabContentView.DisabledStyleClassName="disabled",WebInspector.ObjectTreeBaseTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S,C){super(null,null,null,_,!1),this._property=C,this._propertyPath=S,this.toggleOnClick=!0,this.selectable=!1,this.tooltipHandledSeparately=!0}get property(){return this._property}get propertyPath(){return this._propertyPath}resolvedValue(){return this._getterValue?this._getterValue:this._property.hasValue()?this._property.value:null}resolvedValuePropertyPath(){return this._getterValue?this._propertyPath.appendPropertyDescriptor(this._getterValue,this._property,WebInspector.PropertyPath.Type.Value):this._property.hasValue()?this._propertyPath.appendPropertyDescriptor(this._property.value,this._property,WebInspector.PropertyPath.Type.Value):null}thisPropertyPath(){return this._propertyPath.appendPropertyDescriptor(null,this._property,this.propertyPathType())}hadError(){return this._property.wasThrown||this._getterHadError}propertyPathType(){return this._getterValue||this._property.hasValue()?WebInspector.PropertyPath.Type.Value:this._property.hasGetter()?WebInspector.PropertyPath.Type.Getter:this._property.hasSetter()?WebInspector.PropertyPath.Type.Setter:WebInspector.PropertyPath.Type.Value}propertyPathString(_){return _.isFullPathImpossible()?WebInspector.UIString("Unable to determine path to property from root"):_.displayPath(this.propertyPathType())}createGetterElement(_){var S=document.createElement("img");return(S.className="getter",!_)?(S.classList.add("disabled"),S.title=WebInspector.UIString("Getter"),S):(S.title=WebInspector.UIString("Invoke getter"),S.addEventListener("click",C=>{C.stopPropagation();var f=this._propertyPath.lastNonPrototypeObject,T=this._property.get;f.invokeGetter(T,(E,I,R)=>{this._getterHadError=!!(E||R),this._getterValue=I,this.invokedGetter&&"function"==typeof this.invokedGetter&&this.invokedGetter()})}),S)}createSetterElement(_){var S=document.createElement("img");return S.className="setter",S.title=WebInspector.UIString("Setter"),_||S.classList.add("disabled"),S}populateContextMenu(_,S){if(!S.__addedObjectPreviewContextMenuItems&&!S.__addedObjectTreeContextMenuItems){S.__addedObjectTreeContextMenuItems=!0,"function"==typeof this.treeOutline.objectTreeElementAddContextMenuItems&&(this.treeOutline.objectTreeElementAddContextMenuItems(this,_),!_.isEmpty()&&_.appendSeparator());let C=this.resolvedValue();if(C){this._property&&this._property.symbol&&_.appendItem(WebInspector.UIString("Log Symbol"),this._logSymbolProperty.bind(this)),_.appendItem(WebInspector.UIString("Log Value"),this._logValue.bind(this));let f=this.resolvedValuePropertyPath();f&&!f.isFullPathImpossible()&&_.appendItem(WebInspector.UIString("Copy Path to Property"),()=>{InspectorFrontendHost.copyText(f.displayPath(WebInspector.PropertyPath.Type.Value))}),_.appendSeparator(),this._appendMenusItemsForObject(_,C),super.populateContextMenu(_,S)}}}_logSymbolProperty(){var _=this._property.symbol;if(_){var S=WebInspector.UIString("Selected Symbol");WebInspector.consoleLogViewController.appendImmediateExecutionWithResult(S,_,!0)}}_logValue(_){var S=_||this.resolvedValue();if(S){var C=this.resolvedValuePropertyPath(),f=C.isFullPathImpossible(),T=f?WebInspector.UIString("Selected Value"):C.displayPath(this.propertyPathType());f||WebInspector.quickConsole.prompt.pushHistoryItem(T),WebInspector.consoleLogViewController.appendImmediateExecutionWithResult(T,S,f)}}_appendMenusItemsForObject(_,S){return"function"===S.type?void(isFunctionStringNativeCode(S.description)||_.appendItem(WebInspector.UIString("Jump to Definition"),function(){S.target.DebuggerAgent.getFunctionDetails(S.objectId,function(C,f){if(!C){let T=f.location,E=WebInspector.debuggerManager.scriptForIdentifier(T.scriptId,S.target);if(E){let I=E.createSourceCodeLocation(T.lineNumber,T.columnNumber||0);WebInspector.showSourceCodeLocation(I,{ignoreNetworkTab:!0,ignoreSearchTab:!0})}}})})):"node"===S.subtype?(_.appendItem(WebInspector.UIString("Copy as HTML"),function(){S.pushNodeToFrontend(function(C){WebInspector.domTreeManager.nodeForId(C).copyNode()})}),_.appendItem(WebInspector.UIString("Scroll Into View"),function(){S.callFunction(function(){this.scrollIntoViewIfNeeded(!0)},void 0,!1,function(){})}),_.appendSeparator(),void _.appendItem(WebInspector.UIString("Reveal in DOM Tree"),function(){S.pushNodeToFrontend(function(C){WebInspector.domTreeManager.inspectElement(C)})})):void 0}},WebInspector.SourceCodeTreeElement=class extends WebInspector.FolderizedTreeElement{constructor(_,S,C,f,T,E){super(S,C,f,T||_,E),this._updateSourceCode(_)}updateSourceMapResources(){this.treeOutline&&this.treeOutline.includeSourceMapResourceChildren&&(this.hasChildren=!!this._sourceCode.sourceMaps.length,this.shouldRefreshChildren=this.hasChildren,!this.hasChildren&&this.removeChildren())}onattach(){super.onattach(),this.updateSourceMapResources()}onpopulate(){function _(D,M){for(var P=[],O=M;O!==D;O=O.parent)P.push(O.mainTitle);P.push(D.mainTitle);var F=P.reverse().join("/"),V=new WebInspector.FolderTreeElement(F),U=D.parent.children.indexOf(D);D.parent.insertChild(V,U),D.parent.removeChild(D);var G=M.children;M.removeChildren();for(var H=0;H<G.length;++H)V.appendChild(G[H])}function S(D,M){if(!(D instanceof WebInspector.FolderTreeElement))return void(M&&M!==D.parent&&_(M,D.parent));M&&1!==D.children.length&&(_(M,D),M=null),M||1!==D.children.length||(M=D);for(var P=0;P<D.children.length;++P)S(D.children[P],M)}if(this.treeOutline&&this.treeOutline.includeSourceMapResourceChildren&&this.hasChildren&&this.shouldRefreshChildren){this.shouldRefreshChildren=!1,this.removeChildren();for(var C=this._sourceCode.sourceMaps,f=0,T;f<C.length;++f){T=C[f];for(var E=0;E<T.resources.length;++E){var I=T.resources[E],R=I.sourceMapDisplaySubpath,N=this.createFoldersAsNeededForSubpath(R),L=new WebInspector.SourceMapResourceTreeElement(I);N.insertChild(L,insertionIndexForObjectInListSortedByFunction(L,N.children,WebInspector.ResourceTreeElement.compareFolderAndResourceTreeElements))}}for(var f=0;f<this.children.length;++f)S(this.children[f],null)}}createFoldersAsNeededForSubpath(_){if(!_)return this;var S=_.split("/");if(1===S.length)return this;this._subpathFolderTreeElementMap||(this._subpathFolderTreeElementMap={});for(var C="",f=this,T=0,E;T<S.length-1;++T){E=S[T],C+=(T?"/":"")+E;var I=this._subpathFolderTreeElementMap[C];if(I){f=I;continue}var R=new WebInspector.FolderTreeElement(E);R.__path=C,this._subpathFolderTreeElementMap[C]=R;var N=insertionIndexForObjectInListSortedByFunction(R,f.children,WebInspector.ResourceTreeElement.compareFolderAndResourceTreeElements);f.insertChild(R,N),f=R}return f}descendantResourceTreeElementTypeDidChange(_){let C=_.parent,f=C.expanded,T=_.selected;C.removeChild(_,!0,!0),C.insertChild(_,insertionIndexForObjectInListSortedByFunction(_,C.children,WebInspector.ResourceTreeElement.compareFolderAndResourceTreeElements)),f&&C.expand(),T&&_.revealAndSelect(!0,!1,!0,!0)}_updateSourceCode(_){this._sourceCode===_||(this._sourceCode&&this._sourceCode.removeEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this.updateSourceMapResources,this),this._sourceCode=_,this._sourceCode.addEventListener(WebInspector.SourceCode.Event.SourceMapAdded,this.updateSourceMapResources,this),this.updateSourceMapResources())}},WebInspector.StorageTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S,C){super(_,S,null,C,!1),this.flattened=!1}get flattened(){return this._flattened}set flattened(_){if(this._flattened!==_)return this._flattened=_,this._flattened?void(this.mainTitle=this.categoryName,this.subtitle=this.name,this._updateChildrenTitles()):(this.mainTitle=this.name,this.subtitle=this.secondaryName,void this._updateChildrenTitles())}_updateChildrenTitles(){for(var _=0;_<this.children.length;++_)"function"==typeof this.children[_].updateTitles&&this.children[_].updateTitles()}},WebInspector.TimelineDataGridNodePathComponent=class extends WebInspector.HierarchicalPathComponent{constructor(_,S){super(_.displayName(),_.iconClassNames(),S||_.record),this._timelineDataGridNode=_}get timelineDataGridNode(){return this._timelineDataGridNode}get previousSibling(){let _=this._timelineDataGridNode.previousSibling;for(;_&&_.hidden;)_=_.previousSibling;return _?new WebInspector.TimelineDataGridNodePathComponent(_):null}get nextSibling(){let _=this._timelineDataGridNode.nextSibling;for(;_&&_.hidden;)_=_.nextSibling;return _?new WebInspector.TimelineDataGridNodePathComponent(_):null}},WebInspector.TimelineOverview=class extends WebInspector.View{constructor(_,S){if(super(),this._timelinesViewModeSettings=this._createViewModeSettings(WebInspector.TimelineOverview.ViewMode.Timelines,WebInspector.TimelineOverview.MinimumDurationPerPixel,WebInspector.TimelineOverview.MaximumDurationPerPixel,0.01,0,15),this._instrumentTypes=WebInspector.TimelineManager.availableTimelineTypes(),WebInspector.FPSInstrument.supported()){let f=1/WebInspector.TimelineRecordFrame.MaximumWidthPixels,T=1/WebInspector.TimelineRecordFrame.MinimumWidthPixels;this._renderingFramesViewModeSettings=this._createViewModeSettings(WebInspector.TimelineOverview.ViewMode.RenderingFrames,f,T,f,0,100)}this._recording=_,this._recording.addEventListener(WebInspector.TimelineRecording.Event.InstrumentAdded,this._instrumentAdded,this),this._recording.addEventListener(WebInspector.TimelineRecording.Event.InstrumentRemoved,this._instrumentRemoved,this),this._recording.addEventListener(WebInspector.TimelineRecording.Event.MarkerAdded,this._markerAdded,this),this._recording.addEventListener(WebInspector.TimelineRecording.Event.Reset,this._recordingReset,this),this._delegate=S,this.element.classList.add("timeline-overview"),this._updateWheelAndGestureHandlers(),this._graphsContainerView=new WebInspector.View,this._graphsContainerView.element.classList.add("graphs-container"),this.addSubview(this._graphsContainerView),this._overviewGraphsByTypeMap=new Map,this._editInstrumentsButton=new WebInspector.ActivateButtonNavigationItem("toggle-edit-instruments",WebInspector.UIString("Edit configuration"),WebInspector.UIString("Save configuration")),this._editInstrumentsButton.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._toggleEditingInstruments,this),this._editingInstruments=!1,this._updateEditInstrumentsButton();let C=new WebInspector.NavigationBar;C.element.classList.add("timelines"),C.addNavigationItem(new WebInspector.FlexibleSpaceNavigationItem),C.addNavigationItem(this._editInstrumentsButton),this.addSubview(C),this._timelinesTreeOutline=new WebInspector.TreeOutline,this._timelinesTreeOutline.element.classList.add("timelines"),this._timelinesTreeOutline.disclosureButtons=!1,this._timelinesTreeOutline.large=!0,this._timelinesTreeOutline.addEventListener(WebInspector.TreeOutline.Event.SelectionDidChange,this._timelinesTreeSelectionDidChange,this),this.element.appendChild(this._timelinesTreeOutline.element),this._treeElementsByTypeMap=new Map,this._timelineRuler=new WebInspector.TimelineRuler,this._timelineRuler.allowsClippedLabels=!0,this._timelineRuler.allowsTimeRangeSelection=!0,this._timelineRuler.element.addEventListener("mousedown",this._timelineRulerMouseDown.bind(this)),this._timelineRuler.element.addEventListener("click",this._timelineRulerMouseClicked.bind(this)),this._timelineRuler.addEventListener(WebInspector.TimelineRuler.Event.TimeRangeSelectionChanged,this._timeRangeSelectionChanged,this),this.addSubview(this._timelineRuler),this._currentTimeMarker=new WebInspector.TimelineMarker(0,WebInspector.TimelineMarker.Type.CurrentTime),this._timelineRuler.addMarker(this._currentTimeMarker),this._scrollContainerElement=document.createElement("div"),this._scrollContainerElement.classList.add("scroll-container"),this._scrollContainerElement.addEventListener("scroll",this._handleScrollEvent.bind(this)),this.element.appendChild(this._scrollContainerElement),this._scrollWidthSizer=document.createElement("div"),this._scrollWidthSizer.classList.add("scroll-width-sizer"),this._scrollContainerElement.appendChild(this._scrollWidthSizer),this._startTime=0,this._currentTime=0,this._revealCurrentTime=!1,this._endTime=0,this._pixelAlignDuration=!1,this._mouseWheelDelta=0,this._cachedScrollContainerWidth=NaN,this._timelineRulerSelectionChanged=!1,this._viewMode=WebInspector.TimelineOverview.ViewMode.Timelines,this._selectedTimeline=null;for(let f of this._recording.instruments)this._instrumentAdded(f);WebInspector.timelineManager.isCapturingPageReload()||this._resetSelection(),this._viewModeDidChange(),WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStarted,this._capturingStarted,this),WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStopped,this._capturingStopped,this)}get selectedTimeline(){return this._selectedTimeline}set selectedTimeline(_){if(!this._editingInstruments&&this._selectedTimeline!==_)if(this._selectedTimeline=_,this._selectedTimeline){let S=this._treeElementsByTypeMap.get(this._selectedTimeline.type);S.select(!0,!1)}else this._timelinesTreeOutline.selectedTreeElement&&this._timelinesTreeOutline.selectedTreeElement.deselect()}get editingInstruments(){return this._editingInstruments}get viewMode(){return this._viewMode}set viewMode(_){this._editingInstruments||this._viewMode===_||(this._viewMode=_,this._viewModeDidChange())}get startTime(){return this._startTime}set startTime(_){if(_=_||0,this._startTime!==_){if(this._viewMode!==WebInspector.TimelineOverview.ViewMode.RenderingFrames){let S=this.selectionStartTime-this._startTime;this.selectionStartTime=S+_}this._startTime=_,this.needsLayout()}}get currentTime(){return this._currentTime}set currentTime(_){_=_||0;this._currentTime===_||(this._currentTime=_,this._revealCurrentTime=!0,this.needsLayout())}get secondsPerPixel(){return this._currentSettings.durationPerPixelSetting.value}set secondsPerPixel(_){_=Math.min(this._currentSettings.maximumDurationPerPixel,Math.max(this._currentSettings.minimumDurationPerPixel,_));this.secondsPerPixel===_||this._pixelAlignDuration&&(_=1/Math.round(1/_),this.secondsPerPixel===_)||(this._currentSettings.durationPerPixelSetting.value=_,this.needsLayout())}get pixelAlignDuration(){return this._pixelAlignDuration}set pixelAlignDuration(_){this._pixelAlignDuration===_||(this._mouseWheelDelta=0,this._pixelAlignDuration=_,this._pixelAlignDuration&&(this.secondsPerPixel=1/Math.round(1/this.secondsPerPixel)))}get endTime(){return this._endTime}set endTime(_){_=_||0;this._endTime===_||(this._endTime=_,this.needsLayout())}get scrollStartTime(){return this._currentSettings.scrollStartTime}set scrollStartTime(_){_=_||0;this.scrollStartTime===_||(this._currentSettings.scrollStartTime=_,this.needsLayout())}get scrollContainerWidth(){return this._cachedScrollContainerWidth}get visibleDuration(){return isNaN(this._cachedScrollContainerWidth)&&(this._cachedScrollContainerWidth=this._scrollContainerElement.offsetWidth,!this._cachedScrollContainerWidth&&(this._cachedScrollContainerWidth=NaN)),this._cachedScrollContainerWidth*this.secondsPerPixel}get selectionStartTime(){return this._timelineRuler.selectionStartTime}set selectionStartTime(_){if(_=_||0,this._timelineRuler.selectionStartTime!==_){let S=this.selectionDuration;this._timelineRuler.selectionStartTime=_,this._timelineRuler.selectionEndTime=_+S}}get selectionDuration(){return this._timelineRuler.selectionEndTime-this._timelineRuler.selectionStartTime}set selectionDuration(_){_=Math.max(this._timelineRuler.minimumSelectionDuration,_),this._timelineRuler.selectionEndTime=this._timelineRuler.selectionStartTime+_}get height(){let _=0;for(let S of this._overviewGraphsByTypeMap.values())S.visible&&(_+=S.height);return _}get visible(){return this._visible}shown(){this._visible=!0;for(let[_,S]of this._overviewGraphsByTypeMap)this._canShowTimelineType(_)&&S.shown();this.updateLayout(WebInspector.View.LayoutReason.Resize)}hidden(){this._visible=!1;for(let _ of this._overviewGraphsByTypeMap.values())_.hidden()}reset(){for(let _ of this._overviewGraphsByTypeMap.values())_.reset();this._mouseWheelDelta=0,this._resetSelection()}revealMarker(_){this.scrollStartTime=_.time-this.visibleDuration/2}recordWasFiltered(_,S,C){let f=this._overviewGraphsByTypeMap.get(_.type);f&&f.recordWasFiltered(S,C)}selectRecord(_,S){let C=this._overviewGraphsByTypeMap.get(_.type);C&&(C.selectedRecord=S)}userSelectedRecord(_){this._delegate&&this._delegate.timelineOverviewUserSelectedRecord&&this._delegate.timelineOverviewUserSelectedRecord(this,_)}updateLayoutIfNeeded(_){if(this.layoutPending)return void super.updateLayoutIfNeeded(_);this._timelineRuler.updateLayoutIfNeeded(_);for(let S of this._overviewGraphsByTypeMap.values())S.visible&&S.updateLayoutIfNeeded(_)}discontinuitiesInTimeRange(_,S){return this._recording.discontinuitiesInTimeRange(_,S)}get timelineRuler(){return this._timelineRuler}layout(){let _=this._startTime,S=this._endTime,C=this._currentTime;if(this._viewMode===WebInspector.TimelineOverview.ViewMode.RenderingFrames){let R=this._recording.timelines.get(WebInspector.TimelineRecord.Type.RenderingFrame);_=0,S=R.records.length,C=S}let f=S-_,T=Math.ceil(f/this.secondsPerPixel);this._updateElementWidth(this._scrollWidthSizer,T),this._currentTimeMarker.time=C,this._revealCurrentTime&&(this.revealMarker(this._currentTimeMarker),this._revealCurrentTime=!1);const E=this.visibleDuration;let I=Math.min(this.scrollStartTime,S-E);if(I=Math.max(_,I),this._timelineRuler.zeroTime=_,this._timelineRuler.startTime=I,this._timelineRuler.secondsPerPixel=this.secondsPerPixel,!this._dontUpdateScrollLeft){this._ignoreNextScrollEvent=!0;let R=Math.ceil((I-_)/this.secondsPerPixel);R&&(this._scrollContainerElement.scrollLeft=R)}for(let R of this._overviewGraphsByTypeMap.values())R.visible&&(R.zeroTime=_,R.startTime=I,R.currentTime=C,R.endTime=I+E)}sizeDidChange(){this._cachedScrollContainerWidth=NaN}_updateElementWidth(_,S){var C=parseInt(_.style.width);C!==S&&(_.style.width=S+"px")}_handleScrollEvent(){if(this._ignoreNextScrollEvent)return void(this._ignoreNextScrollEvent=!1);this._dontUpdateScrollLeft=!0;let S=this._scrollContainerElement.scrollLeft;this.scrollStartTime=WebInspector.resolvedLayoutDirection()===WebInspector.LayoutDirection.RTL?this._startTime-S*this.secondsPerPixel:this._startTime+S*this.secondsPerPixel,this.updateLayoutIfNeeded(),this._dontUpdateScrollLeft=!1}_handleWheelEvent(_){if(!_.__cloned&&!this._handlingGesture){if(Math.abs(_.deltaX)>=0.5*Math.abs(_.deltaY)){let I=new _.constructor(_.type,_);return I.__cloned=!0,void this._scrollContainerElement.dispatchEvent(I)}let S=_.pageX-this._graphsContainerView.element.totalOffsetLeft,C=this._currentSettings.scrollStartTime+S*this.secondsPerPixel,f=_.webkitDirectionInvertedFromDevice?1:-1,T=_.deltaY*(this.secondsPerPixel/WebInspector.TimelineOverview.ScrollDeltaDenominator)*f;this._pixelAlignDuration&&(0>T&&0<=this._mouseWheelDelta||0<=T&&0>this._mouseWheelDelta)&&(this._mouseWheelDelta=0);let E=this.secondsPerPixel;this._mouseWheelDelta+=T,this.secondsPerPixel+=this._mouseWheelDelta,this._mouseWheelDelta=this.secondsPerPixel===this._currentSettings.minimumDurationPerPixel&&0>T||this.secondsPerPixel===this._currentSettings.maximumDurationPerPixel&&0<=T?0:E+this._mouseWheelDelta-this.secondsPerPixel,this.scrollStartTime=C-S*this.secondsPerPixel,_.preventDefault(),_.stopPropagation()}}_handleGestureStart(_){if(!this._handlingGesture){let S=_.pageX-this._graphsContainerView.element.totalOffsetLeft,C=this._currentSettings.scrollStartTime+S*this.secondsPerPixel;this._handlingGesture=!0,this._gestureStartStartTime=C,this._gestureStartDurationPerPixel=this.secondsPerPixel,_.preventDefault(),_.stopPropagation()}}_handleGestureChange(_){let S=Math.max(1/5,_.scale),C=_.pageX-this._graphsContainerView.element.totalOffsetLeft,f=this._gestureStartDurationPerPixel/S;this.secondsPerPixel=f,this.scrollStartTime=this._gestureStartStartTime-C*this.secondsPerPixel,_.preventDefault(),_.stopPropagation()}_handleGestureEnd(){this._handlingGesture=!1,this._gestureStartStartTime=NaN,this._gestureStartDurationPerPixel=NaN}_instrumentAdded(_){let S=_ instanceof WebInspector.Instrument?_:_.data.instrument,C=this._recording.timelineForInstrument(S),f=new WebInspector.TimelineTreeElement(C),T=insertionIndexForObjectInListSortedByFunction(f,this._timelinesTreeOutline.children,this._compareTimelineTreeElements.bind(this));this._timelinesTreeOutline.insertChild(f,T),this._treeElementsByTypeMap.set(C.type,f);let E=WebInspector.TimelineOverviewGraph.createForTimeline(C,this);E.addEventListener(WebInspector.TimelineOverviewGraph.Event.RecordSelected,this._recordSelected,this),this._overviewGraphsByTypeMap.set(C.type,E),this._graphsContainerView.insertSubviewBefore(E,this._graphsContainerView.subviews[T]),f.element.style.height=E.height+"px",this._canShowTimelineType(C.type)||(E.hidden(),f.hidden=!0)}_instrumentRemoved(_){let S=_.data.instrument,C=this._recording.timelineForInstrument(S),f=this._overviewGraphsByTypeMap.get(C.type),T=this._treeElementsByTypeMap.get(C.type);this._timelinesTreeOutline.removeChild(T,!1,!0),f.removeEventListener(WebInspector.TimelineOverviewGraph.Event.RecordSelected,this._recordSelected,this),this._graphsContainerView.removeSubview(f),this._overviewGraphsByTypeMap.delete(C.type),this._treeElementsByTypeMap.delete(C.type)}_markerAdded(_){this._timelineRuler.addMarker(_.data.marker)}_timelineRulerMouseDown(){this._timelineRulerSelectionChanged=!1}_timelineRulerMouseClicked(_){if(!this._timelineRulerSelectionChanged)for(let S of this._overviewGraphsByTypeMap.values()){let C=S.element.getBoundingClientRect();if(_.pageX>=C.left&&_.pageX<=C.right&&_.pageY>=C.top&&_.pageY<=C.bottom){let Z=new _.constructor(_.type,_);return void S.element.dispatchEvent(Z)}}}_timeRangeSelectionChanged(){this._timelineRulerSelectionChanged=!0;let S=this._viewMode===WebInspector.TimelineOverview.ViewMode.Timelines?this._startTime:0;this._currentSettings.selectionStartValueSetting.value=this.selectionStartTime-S,this._currentSettings.selectionDurationSetting.value=this.selectionDuration,this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.TimeRangeSelectionChanged)}_recordSelected(_){for(let[S,C]of this._overviewGraphsByTypeMap)if(C===_.target){let $=this._recording.timelines.get(S);return void this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.RecordSelected,{timeline:$,record:_.data.record})}}_resetSelection(){function _(S){S.durationPerPixelSetting.reset(),S.selectionStartValueSetting.reset(),S.selectionDurationSetting.reset()}_(this._timelinesViewModeSettings),this._renderingFramesViewModeSettings&&_(this._renderingFramesViewModeSettings),this.secondsPerPixel=this._currentSettings.durationPerPixelSetting.value,this.selectionStartTime=this._currentSettings.selectionStartValueSetting.value,this.selectionDuration=this._currentSettings.selectionDurationSetting.value}_recordingReset(){this._timelineRuler.clearMarkers(),this._timelineRuler.addMarker(this._currentTimeMarker)}_canShowTimelineType(_){let S=WebInspector.TimelineOverview.ViewMode.Timelines;return _===WebInspector.TimelineRecord.Type.RenderingFrame&&(S=WebInspector.TimelineOverview.ViewMode.RenderingFrames),S===this._viewMode}_viewModeDidChange(){let _=0,S=this._viewMode===WebInspector.TimelineOverview.ViewMode.RenderingFrames;S?(this._timelineRuler.minimumSelectionDuration=1,this._timelineRuler.snapInterval=1,this._timelineRuler.formatLabelCallback=C=>C.maxDecimals(0).toLocaleString()):(this._timelineRuler.minimumSelectionDuration=0.01,this._timelineRuler.snapInterval=NaN,this._timelineRuler.formatLabelCallback=null,_=this._startTime),this.pixelAlignDuration=S,this.selectionStartTime=this._currentSettings.selectionStartValueSetting.value+_,this.selectionDuration=this._currentSettings.selectionDurationSetting.value;for(let[C,f]of this._overviewGraphsByTypeMap){let T=this._treeElementsByTypeMap.get(C);T.hidden=!this._canShowTimelineType(C),T.hidden?f.hidden():f.shown()}this.element.classList.toggle("frames",S),this.updateLayout(WebInspector.View.LayoutReason.Resize)}_createViewModeSettings(_,S,C,f,T,E){f=Math.min(C,Math.max(S,f));let I=new WebInspector.Setting(_+"-duration-per-pixel",f),R=new WebInspector.Setting(_+"-selection-start-value",T),N=new WebInspector.Setting(_+"-selection-duration",E);return{scrollStartTime:0,minimumDurationPerPixel:S,maximumDurationPerPixel:C,durationPerPixelSetting:I,selectionStartValueSetting:R,selectionDurationSetting:N}}get _currentSettings(){return this._viewMode===WebInspector.TimelineOverview.ViewMode.Timelines?this._timelinesViewModeSettings:this._renderingFramesViewModeSettings}_timelinesTreeSelectionDidChange(_){function S(E,I){let R=this._overviewGraphsByTypeMap.get(E.type);R.selected=I}let C=_.data.selectedElement,f=_.data.deselectedElement,T=null;C&&(T=C.representedObject,S.call(this,T,!0)),f&&S.call(this,f.representedObject,!1),this._selectedTimeline=T,this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.TimelineSelected)}_toggleEditingInstruments(){this._editingInstruments?this._stopEditingInstruments():this._startEditingInstruments()}_editingInstrumentsDidChange(){this.element.classList.toggle(WebInspector.TimelineOverview.EditInstrumentsStyleClassName,this._editingInstruments),this._timelineRuler.enabled=!this._editingInstruments,this._updateWheelAndGestureHandlers(),this._updateEditInstrumentsButton(),this.dispatchEventToListeners(WebInspector.TimelineOverview.Event.EditingInstrumentsDidChange)}_updateEditInstrumentsButton(){let _=this._editingInstruments?WebInspector.UIString("Done"):WebInspector.UIString("Edit");this._editInstrumentsButton.label=_,this._editInstrumentsButton.activated=this._editingInstruments,this._editInstrumentsButton.enabled=!WebInspector.timelineManager.isCapturing()}_updateWheelAndGestureHandlers(){this._editingInstruments?(this.element.removeEventListener("wheel",this._handleWheelEventListener),this.element.removeEventListener("gesturestart",this._handleGestureStartEventListener),this.element.removeEventListener("gesturechange",this._handleGestureChangeEventListener),this.element.removeEventListener("gestureend",this._handleGestureEndEventListener),this._handleWheelEventListener=null,this._handleGestureStartEventListener=null,this._handleGestureChangeEventListener=null,this._handleGestureEndEventListener=null):(this._handleWheelEventListener=this._handleWheelEvent.bind(this),this._handleGestureStartEventListener=this._handleGestureStart.bind(this),this._handleGestureChangeEventListener=this._handleGestureChange.bind(this),this._handleGestureEndEventListener=this._handleGestureEnd.bind(this),this.element.addEventListener("wheel",this._handleWheelEventListener),this.element.addEventListener("gesturestart",this._handleGestureStartEventListener),this.element.addEventListener("gesturechange",this._handleGestureChangeEventListener),this.element.addEventListener("gestureend",this._handleGestureEndEventListener))}_startEditingInstruments(){if(!this._editingInstruments){this._editingInstruments=!0;for(let _ of this._instrumentTypes){let S=this._treeElementsByTypeMap.get(_);if(!S){let C=this._recording.timelines.get(_);S=new WebInspector.TimelineTreeElement(C,!0);let T=insertionIndexForObjectInListSortedByFunction(S,this._timelinesTreeOutline.children,this._compareTimelineTreeElements.bind(this));this._timelinesTreeOutline.insertChild(S,T);let E=new WebInspector.View;E.element.classList.add("timeline-overview-graph"),S[WebInspector.TimelineOverview.PlaceholderOverviewGraph]=E,this._graphsContainerView.insertSubviewBefore(E,this._graphsContainerView.subviews[T])}S.editing=!0,S.addEventListener(WebInspector.TimelineTreeElement.Event.EnabledDidChange,this._timelineTreeElementEnabledDidChange,this)}this._editingInstrumentsDidChange()}}_stopEditingInstruments(){if(this._editingInstruments){this._editingInstruments=!1;let _=this._recording.instruments;for(let f of this._treeElementsByTypeMap.values()){if(f.status.checked){f.editing=!1,f.removeEventListener(WebInspector.TimelineTreeElement.Event.EnabledDidChange,this._timelineTreeElementEnabledDidChange,this);continue}let T=_.find(E=>E.timelineRecordType===f.representedObject.type);this._recording.removeInstrument(T)}let S=this._timelinesTreeOutline.children.filter(f=>f.placeholder);for(let f of S){this._timelinesTreeOutline.removeChild(f);let T=f[WebInspector.TimelineOverview.PlaceholderOverviewGraph];if(this._graphsContainerView.removeSubview(T),f.status.checked){let E=WebInspector.Instrument.createForTimelineType(f.representedObject.type);this._recording.addInstrument(E)}}let C=_.map(f=>f.timelineRecordType);WebInspector.timelineManager.enabledTimelineTypes=C,this._editingInstrumentsDidChange()}}_capturingStarted(){this._editInstrumentsButton.enabled=!1,this._stopEditingInstruments()}_capturingStopped(){this._editInstrumentsButton.enabled=!0}_compareTimelineTreeElements(_,S){let C=_.representedObject.type,f=S.representedObject.type;if(C===WebInspector.TimelineRecord.Type.RenderingFrame)return 1;if(f===WebInspector.TimelineRecord.Type.RenderingFrame)return-1;if(_.placeholder!==S.placeholder)return _.placeholder?1:-1;let T=this._instrumentTypes.indexOf(C),E=this._instrumentTypes.indexOf(f);return T-E}_timelineTreeElementEnabledDidChange(){let S=this._timelinesTreeOutline.children.some(C=>{let f=C.representedObject.type;return this._canShowTimelineType(f)&&C.status.checked});this._editInstrumentsButton.enabled=S}},WebInspector.TimelineOverview.PlaceholderOverviewGraph=Symbol("placeholder-overview-graph"),WebInspector.TimelineOverview.ScrollDeltaDenominator=500,WebInspector.TimelineOverview.EditInstrumentsStyleClassName="edit-instruments",WebInspector.TimelineOverview.MinimumDurationPerPixel=1e-4,WebInspector.TimelineOverview.MaximumDurationPerPixel=60,WebInspector.TimelineOverview.ViewMode={Timelines:"timeline-overview-view-mode-timelines",RenderingFrames:"timeline-overview-view-mode-rendering-frames"},WebInspector.TimelineOverview.Event={EditingInstrumentsDidChange:"editing-instruments-did-change",RecordSelected:"timeline-overview-record-selected",TimelineSelected:"timeline-overview-timeline-selected",TimeRangeSelectionChanged:"timeline-overview-time-range-selection-changed"},WebInspector.TimelineRecordTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S,C,f,T){f=f||_.sourceCodeLocation||null;let E=null;if(C&&_.type===WebInspector.TimelineRecord.Type.Script&&_.eventType===WebInspector.ScriptTimelineRecord.EventType.TimerInstalled){let L=Number.secondsToString(_.details.timeout/1e3);E=document.createElement("span"),E.classList.add("alternate-subtitle"),E.textContent=_.details.repeating?WebInspector.UIString("%s interval").format(L):WebInspector.UIString("%s delay").format(L)}let I=null;f&&(I=document.createElement("span"),S===WebInspector.SourceCodeLocation.NameStyle.None?f.populateLiveDisplayLocationString(I,"textContent",null,WebInspector.SourceCodeLocation.NameStyle.None,WebInspector.UIString("line ")):f.populateLiveDisplayLocationString(I,"textContent",null,S));let R=WebInspector.TimelineTabContentView.iconClassNameForRecord(_),N=WebInspector.TimelineTabContentView.displayNameForRecord(_);super([R],N,I,T||_,!1),this._record=_,this._sourceCodeLocation=f,this._sourceCodeLocation&&(this.tooltipHandledSeparately=!0),E&&this.titlesElement.appendChild(E)}get record(){return this._record}get filterableData(){var _=this._sourceCodeLocation?this._sourceCodeLocation.sourceCode.url:"";return{text:[this.mainTitle,_||"",this._record.details||""]}}get sourceCodeLocation(){return this._sourceCodeLocation}onattach(){if(super.onattach(),!!this.tooltipHandledSeparately){var _=this.mainTitle+"\n";this._sourceCodeLocation.populateLiveDisplayLocationTooltip(this.element,_)}}},WebInspector.TimelineRecordTreeElement.StyleRecordIconStyleClass="style-record",WebInspector.TimelineRecordTreeElement.LayoutRecordIconStyleClass="layout-record",WebInspector.TimelineRecordTreeElement.PaintRecordIconStyleClass="paint-record",WebInspector.TimelineRecordTreeElement.CompositeRecordIconStyleClass="composite-record",WebInspector.TimelineRecordTreeElement.RenderingFrameRecordIconStyleClass="rendering-frame-record",WebInspector.TimelineRecordTreeElement.APIRecordIconStyleClass="api-record",WebInspector.TimelineRecordTreeElement.EvaluatedRecordIconStyleClass="evaluated-record",WebInspector.TimelineRecordTreeElement.EventRecordIconStyleClass="event-record",WebInspector.TimelineRecordTreeElement.TimerRecordIconStyleClass="timer-record",WebInspector.TimelineRecordTreeElement.AnimationRecordIconStyleClass="animation-record",WebInspector.TimelineRecordTreeElement.ProbeRecordIconStyleClass="probe-record",WebInspector.TimelineRecordTreeElement.ConsoleProfileIconStyleClass="console-profile-record",WebInspector.TimelineRecordTreeElement.GarbageCollectionIconStyleClass="garbage-collection-profile-record",WebInspector.TimelineTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S){let C=WebInspector.TimelineTabContentView.displayNameForTimelineType(_.type),f=WebInspector.TimelineTabContentView.iconClassNameForTimelineType(_.type),T=WebInspector.TimelineTabContentView.genericClassNameForTimelineType(_.type);super([f,T],C,"",_),this._placeholder=S||!1,this.editing=this._placeholder}get placeholder(){return this._placeholder}get editing(){return this._editing}set editing(_){this._editing===_||(this._editing=_,this.selectable=!this._editing,this._updateStatusButton())}onattach(){super.onattach(),this.listItemElement.addEventListener("click",this._clickHandler.bind(this))}_showCloseButton(){let _=WebInspector.UIString("Close %s timeline view").format(this.mainTitle),S=new WebInspector.TreeElementStatusButton(useSVGSymbol("Images/CloseLarge.svg","close-button",_));S.addEventListener(WebInspector.TreeElementStatusButton.Event.Clicked,()=>{this.deselect()}),this.status=S.element}_showCheckbox(){let _=document.createElement("input");_.type="checkbox",_.checked=!this._placeholder;new WebInspector.TreeElementStatusButton(_);_.addEventListener("change",()=>{this._dispatchEnabledDidChangeEvent()}),this.status=_}_updateStatusButton(){this._editing?this._showCheckbox():this._showCloseButton()}_clickHandler(){this._editing&&(this.status.checked=!this.status.checked,this._dispatchEnabledDidChangeEvent())}_dispatchEnabledDidChangeEvent(){this.dispatchEventToListeners(WebInspector.TimelineTreeElement.Event.EnabledDidChange)}},WebInspector.TimelineTreeElement.Event={EnabledDidChange:"timeline-tree-element-enabled-did-change"},WebInspector.ConsoleTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.ConsoleTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C);super(_||"console","console",f,null,null,!0)}static tabInfo(){return{image:"Images/Console.svg",title:WebInspector.UIString("Console")}}get type(){return WebInspector.ConsoleTabContentView.Type}shown(){super.shown(),WebInspector.consoleContentView.prompt.focus();this.contentBrowser.currentContentView===WebInspector.consoleContentView||(WebInspector.consoleContentView.parentContainer&&WebInspector.consoleContentView.parentContainer.closeContentView(WebInspector.consoleContentView),this.contentBrowser.showContentView(WebInspector.consoleContentView))}showRepresentedObject(){}canShowRepresentedObject(_){return _ instanceof WebInspector.LogObject}get supportsSplitContentBrowser(){return!1}},WebInspector.ConsoleTabContentView.Type="console",WebInspector.DebuggerTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.DebuggerTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.ScopeChainDetailsSidebarPanel,WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];super(_||"debugger","debugger",f,WebInspector.DebuggerSidebarPanel,T)}static tabInfo(){return{image:"Images/Debugger.svg",title:WebInspector.UIString("Debugger")}}get type(){return WebInspector.DebuggerTabContentView.Type}get supportsSplitContentBrowser(){return!0}canShowRepresentedObject(_){return!!(_ instanceof WebInspector.Script)||!!(_ instanceof WebInspector.Resource)&&(_.type===WebInspector.Resource.Type.Document||_.type===WebInspector.Resource.Type.Script)}showDetailsSidebarPanels(){if(super.showDetailsSidebarPanels(),!!this._showScopeChainDetailsSidebarPanel){let _=WebInspector.instanceForClass(WebInspector.ScopeChainDetailsSidebarPanel);_.parentSidebar&&(_.show(),this._showScopeChainDetailsSidebarPanel=!1)}}showScopeChainDetailsSidebarPanel(){this._showScopeChainDetailsSidebarPanel=!0}revealAndSelectBreakpoint(_){var S=this.navigationSidebarPanel.treeElementForRepresentedObject(_);S&&S.revealAndSelect()}},WebInspector.DebuggerTabContentView.Type="debugger",WebInspector.ElementsTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.ElementsTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.DOMNodeDetailsSidebarPanel,WebInspector.CSSStyleDetailsSidebarPanel];window.LayerTreeAgent&&T.push(WebInspector.LayerTreeDetailsSidebarPanel),super(_||"elements","elements",f,null,T,!0),WebInspector.frameResourceManager.addEventListener(WebInspector.FrameResourceManager.Event.MainFrameDidChange,this._mainFrameDidChange,this),WebInspector.Frame.addEventListener(WebInspector.Frame.Event.MainResourceDidChange,this._mainResourceDidChange,this)}static tabInfo(){return{image:"Images/Elements.svg",title:WebInspector.UIString("Elements")}}static isTabAllowed(){return!!window.DOMAgent}get type(){return WebInspector.ElementsTabContentView.Type}get supportsSplitContentBrowser(){return!0}canShowRepresentedObject(_){return _ instanceof WebInspector.DOMTree}showRepresentedObject(_,S){if(this.contentBrowser.currentContentView||this._showDOMTreeContentView(),S&&S.nodeToSelect){let C=this.contentBrowser.currentContentView;C.selectAndRevealDOMNode(S.nodeToSelect),S.nodeToSelect=void 0}}shown(){super.shown(),this.contentBrowser.currentContentView||this._showDOMTreeContentView()}closed(){super.closed(),WebInspector.frameResourceManager.removeEventListener(null,null,this),WebInspector.Frame.removeEventListener(null,null,this)}_showDOMTreeContentView(){this.contentBrowser.contentViewContainer.closeAllContentViews();var _=WebInspector.frameResourceManager.mainFrame;_&&this.contentBrowser.showContentViewForRepresentedObject(_.domTree)}_mainFrameDidChange(){this._showDOMTreeContentView()}_mainResourceDidChange(_){_.target.isMainFrame()&&this._showDOMTreeContentView()}},WebInspector.ElementsTabContentView.Type="elements",WebInspector.ResourceTreeElement=class extends WebInspector.SourceCodeTreeElement{constructor(_,S){super(_,["resource",WebInspector.ResourceTreeElement.ResourceIconStyleClassName,_.type],"","",S||_,!1),this._updateResource(_)}static compareResourceTreeElements(_,S){var C=_.resource.type.extendedLocaleCompare(S.resource.type);return 0===C?_.resource.type===WebInspector.Resource.Type.XHR||_.resource.type===WebInspector.Resource.Type.Fetch||_.resource.type===WebInspector.Resource.Type.WebSocket?_.resource.firstTimestamp-S.resource.firstTimestamp||0:(C=_.subtitle.extendedLocaleCompare(S.subtitle),0===C?_.mainTitle.extendedLocaleCompare(S.mainTitle):C):C}static compareFolderAndResourceTreeElements(_,S){var C=_ instanceof WebInspector.FolderTreeElement,f=S instanceof WebInspector.FolderTreeElement;return C&&!f?-1:!C&&f?1:C&&f?_.mainTitle.extendedLocaleCompare(S.mainTitle):WebInspector.ResourceTreeElement.compareResourceTreeElements(_,S)}get resource(){return this._resource}get filterableData(){let _=this._resource.urlComponents;return{text:[_.lastPathComponent,_.path,this._resource.url]}}ondblclick(){this._resource.type===WebInspector.Resource.Type.WebSocket||InspectorFrontendHost.openInNewTab(this._resource.url)}_updateResource(_){this._resource&&(this._resource.removeEventListener(WebInspector.Resource.Event.URLDidChange,this._urlDidChange,this),this._resource.removeEventListener(WebInspector.Resource.Event.TypeDidChange,this._typeDidChange,this),this._resource.removeEventListener(WebInspector.Resource.Event.LoadingDidFinish,this._updateStatus,this),this._resource.removeEventListener(WebInspector.Resource.Event.LoadingDidFail,this._updateStatus,this)),this._updateSourceCode(_),this._resource=_,_.addEventListener(WebInspector.Resource.Event.URLDidChange,this._urlDidChange,this),_.addEventListener(WebInspector.Resource.Event.TypeDidChange,this._typeDidChange,this),_.addEventListener(WebInspector.Resource.Event.LoadingDidFinish,this._updateStatus,this),_.addEventListener(WebInspector.Resource.Event.LoadingDidFail,this._updateStatus,this),this._updateTitles(),this._updateStatus(),this._updateToolTip()}_updateTitles(){var _=this._resource.parentFrame,S=this._resource.target,C=this._resource.isMainResource(),f=S.mainResource?S.mainResource.urlComponents.host:null;C&&_?f=_.parentFrame?_.parentFrame.mainResource.urlComponents.host:null:_&&(f=_.mainResource.urlComponents.host);var T=this._resource.urlComponents,E=this.mainTitle;this.mainTitle=WebInspector.displayNameForURL(this._resource.url,T);var I=f!==T.host||_&&_.isMainFrame()&&C?WebInspector.displayNameForHost(T.host):null;this.subtitle=this.mainTitle===I?null:I,E!==this.mainTitle&&this.callFirstAncestorFunction("descendantResourceTreeElementMainTitleDidChange",[this,E])}populateContextMenu(_,S){WebInspector.appendContextMenuItemsForSourceCode(_,this._resource),super.populateContextMenu(_,S)}_updateStatus(){if(this._resource.hadLoadingError()?this.addClassName(WebInspector.ResourceTreeElement.FailedStyleClassName):this.removeClassName(WebInspector.ResourceTreeElement.FailedStyleClassName),this._resource.finished||this._resource.failed)this.status&&this.status[WebInspector.ResourceTreeElement.SpinnerSymbol]&&(this.status="");else{let _=new WebInspector.IndeterminateProgressSpinner;this.status=_.element,this.status[WebInspector.ResourceTreeElement.SpinnerSymbol]=!0}}_updateToolTip(){this.tooltip=this._resource.displayURL}_urlDidChange(){this._updateTitles(),this._updateToolTip()}_typeDidChange(_){this.removeClassName(_.data.oldType),this.addClassName(this._resource.type),this.callFirstAncestorFunction("descendantResourceTreeElementTypeDidChange",[this,_.data.oldType])}},WebInspector.ResourceTreeElement.ResourceIconStyleClassName="resource-icon",WebInspector.ResourceTreeElement.FailedStyleClassName="failed",WebInspector.ResourceTreeElement.SpinnerSymbol=Symbol("spinner"),WebInspector.ResourcesTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.ResourcesTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];window.CanvasAgent&&WebInspector.settings.experimentalShowCanvasContextsInResources.value&&T.push(WebInspector.CanvasDetailsSidebarPanel),T=T.concat([WebInspector.DOMNodeDetailsSidebarPanel,WebInspector.CSSStyleDetailsSidebarPanel]),window.LayerTreeAgent&&T.push(WebInspector.LayerTreeDetailsSidebarPanel),super(_||"resources","resources",f,WebInspector.ResourceSidebarPanel,T)}static tabInfo(){return{image:"Images/Resources.svg",title:WebInspector.UIString("Resources")}}get type(){return WebInspector.ResourcesTabContentView.Type}get supportsSplitContentBrowser(){return!0}canShowRepresentedObject(_){return _ instanceof WebInspector.Frame||_ instanceof WebInspector.Resource||_ instanceof WebInspector.Script||_ instanceof WebInspector.CSSStyleSheet||_ instanceof WebInspector.ContentFlow||_ instanceof WebInspector.Canvas||_ instanceof WebInspector.Collection}},WebInspector.ResourcesTabContentView.Type="resources",WebInspector.SearchTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.SearchTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel,WebInspector.DOMNodeDetailsSidebarPanel,WebInspector.CSSStyleDetailsSidebarPanel];window.LayerTreeAgent&&T.push(WebInspector.LayerTreeDetailsSidebarPanel),super(_||"search","search",f,WebInspector.SearchSidebarPanel,T),this._forcePerformSearch=!1}static tabInfo(){return{image:"Images/SearchResults.svg",title:WebInspector.UIString("Search")}}static isEphemeral(){return!0}get type(){return WebInspector.SearchTabContentView.Type}shown(){super.shown(),setTimeout(this.focusSearchField.bind(this))}canShowRepresentedObject(_){return(_ instanceof WebInspector.Resource||_ instanceof WebInspector.Script||_ instanceof WebInspector.DOMTree)&&!!this.navigationSidebarPanel.contentTreeOutline.getCachedTreeElement(_)}focusSearchField(){this.navigationSidebarPanel.focusSearchField(this._forcePerformSearch),this._forcePerformSearch=!1}performSearch(_){this.navigationSidebarPanel.performSearch(_),this._forcePerformSearch=!1}handleCopyEvent(_){let S=this.navigationSidebarPanel.contentTreeOutline.selectedTreeElement;S&&(_.clipboardData.setData("text/plain",S.synthesizedTextValue),_.stopPropagation(),_.preventDefault())}initialLayout(){super.initialLayout(),this._forcePerformSearch=!0}},WebInspector.SearchTabContentView.Type="search",WebInspector.SettingsTabContentView=class extends WebInspector.TabContentView{constructor(_){let S=new WebInspector.PinnedTabBarItem("Images/Gear.svg",WebInspector.UIString("Open Settings"));super(_||"settings","settings",S),S.representedObject=this,this._selectedSettingsView=null,this._settingsViews=[]}static tabInfo(){return{image:"Images/Gear.svg",title:WebInspector.UIString("Settings")}}static isEphemeral(){return!0}static shouldSaveTab(){return!1}get type(){return WebInspector.SettingsTabContentView.Type}get selectedSettingsView(){return this._selectedSettingsView}set selectedSettingsView(_){if(this._selectedSettingsView!==_){this._selectedSettingsView?this.replaceSubview(this._selectedSettingsView,_):this.addSubview(_),this._selectedSettingsView=_,this._selectedSettingsView.updateLayout();let S=this._navigationBar.findNavigationItem(_.identifier);console.assert(S,"Missing navigation item for settings view.",_),S&&(this._navigationBar.selectedNavigationItem=S)}}addSettingsView(_){this._settingsViews.includes(_)||(this._settingsViews.push(_),this._navigationBar.addNavigationItem(new WebInspector.RadioButtonNavigationItem(_.identifier,_.displayName)),this._updateNavigationBarVisibility())}setSettingsViewVisible(_,S){let C=this._navigationBar.findNavigationItem(_.identifier);if(C&&C.hidden!==!S){if(C.hidden=!S,_.element.classList.toggle("hidden",!S),this._updateNavigationBarVisibility(),!this.selectedSettingsView)return void(S&&(this.selectedSettingsView=_));if(this.selectedSettingsView===_){let f=this._settingsViews.indexOf(_);if(console.assert(-1!==f,"SettingsView not found.",_),-1!==f){for(let T=f,I;0<=--T;)if(I=this._navigationBar.navigationItems[T],I&&!I.hidden)return void(this.selectedSettingsView=this._settingsViews[T]);for(let E=f,I;++E<this._settingsViews.length;)if(I=this._navigationBar.navigationItems[E],I&&!I.hidden)return void(this.selectedSettingsView=this._settingsViews[E])}}}}initialLayout(){this._navigationBar=new WebInspector.NavigationBar,this._navigationBar.addEventListener(WebInspector.NavigationBar.Event.NavigationItemSelected,this._navigationItemSelected,this),this.addSubview(this._navigationBar),this._createGeneralSettingsView(),WebInspector.notifications.addEventListener(WebInspector.Notification.DebugUIEnabledDidChange,this._updateDebugSettingsViewVisibility,this),this._updateDebugSettingsViewVisibility(),this.selectedSettingsView=this._settingsViews[0]}_createGeneralSettingsView(){let _=new WebInspector.SettingsView("general",WebInspector.UIString("General"));const S=[WebInspector.UIString("Tabs"),WebInspector.UIString("Spaces")];let C=_.addGroupWithCustomSetting(WebInspector.UIString("Prefer indent using:"),WebInspector.SettingEditor.Type.Select,{values:S});C.value=S[WebInspector.settings.indentWithTabs.value?0:1],C.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{WebInspector.settings.indentWithTabs.value=C.value===S[0]});const f=WebInspector.UIString("spaces"),T={min:1};_.addSetting(WebInspector.UIString("Tab width:"),WebInspector.settings.tabSize,f,T),_.addSetting(WebInspector.UIString("Indent width:"),WebInspector.settings.indentUnit,f,T),_.addSetting(WebInspector.UIString("Line wrapping:"),WebInspector.settings.enableLineWrapping,WebInspector.UIString("Wrap lines to editor width"));let E=_.addGroup(WebInspector.UIString("Show:"));E.addSetting(WebInspector.settings.showWhitespaceCharacters,WebInspector.UIString("Whitespace characters")),E.addSetting(WebInspector.settings.showInvalidCharacters,WebInspector.UIString("Invalid characters")),_.addSeparator();let I=_.addGroup(WebInspector.UIString("Styles Editing:"));I.addSetting(WebInspector.settings.stylesShowInlineWarnings,WebInspector.UIString("Show inline warnings")),I.addSetting(WebInspector.settings.stylesInsertNewline,WebInspector.UIString("Automatically insert newline")),I.addSetting(WebInspector.settings.stylesSelectOnFirstClick,WebInspector.UIString("Select text on first click")),_.addSeparator(),_.addSetting(WebInspector.UIString("Network:"),WebInspector.settings.clearNetworkOnNavigate,WebInspector.UIString("Clear when page navigates")),_.addSeparator(),_.addSetting(WebInspector.UIString("Console:"),WebInspector.settings.clearLogOnNavigate,WebInspector.UIString("Clear when page navigates")),_.addSeparator(),_.addSetting(WebInspector.UIString("Debugger:"),WebInspector.settings.showScopeChainOnPause,WebInspector.UIString("Show Scope Chain on pause")),_.addSeparator();const N=[0.6,0.8,1,1.2,1.4,1.6,1.8,2,2.2,2.4].map(D=>[D,Number.percentageString(D,0)]);let L=_.addGroupWithCustomSetting(WebInspector.UIString("Zoom:"),WebInspector.SettingEditor.Type.Select,{values:N});L.value=WebInspector.getZoomFactor(),L.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{WebInspector.setZoomFactor(L.value)}),WebInspector.settings.zoomFactor.addEventListener(WebInspector.Setting.Event.Changed,()=>{L.value=WebInspector.getZoomFactor().maxDecimals(2)}),this.addSettingsView(_)}_createDebugSettingsView(){if(!this._debugSettingsView){this._debugSettingsView=new WebInspector.SettingsView("debug",WebInspector.unlocalizedString("Debug"));let _=this._debugSettingsView.addGroup(WebInspector.unlocalizedString("Protocol Logging:")),S=_.addSetting(WebInspector.settings.autoLogProtocolMessages,WebInspector.unlocalizedString("Messages"));WebInspector.settings.autoLogProtocolMessages.addEventListener(WebInspector.Setting.Event.Changed,()=>{S.value=InspectorBackend.dumpInspectorProtocolMessages}),_.addSetting(WebInspector.settings.autoLogTimeStats,WebInspector.unlocalizedString("Time Stats")),this._debugSettingsView.addSeparator(),this._debugSettingsView.addSetting(WebInspector.unlocalizedString("Uncaught Exception Reporter:"),WebInspector.settings.enableUncaughtExceptionReporter,WebInspector.unlocalizedString("Enabled")),this._debugSettingsView.addSeparator();const C=[[WebInspector.LayoutDirection.System,WebInspector.unlocalizedString("System Default")],[WebInspector.LayoutDirection.LTR,WebInspector.unlocalizedString("Left to Right (LTR)")],[WebInspector.LayoutDirection.RTL,WebInspector.unlocalizedString("Right to Left (RTL)")]];let f=this._debugSettingsView.addGroupWithCustomSetting(WebInspector.unlocalizedString("Layout Direction:"),WebInspector.SettingEditor.Type.Select,{values:C});f.value=WebInspector.settings.layoutDirection.value,f.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{WebInspector.setLayoutDirection(f.value)}),window.CanvasAgent&&(this._debugSettingsView.addSeparator(),this._debugSettingsView.addSetting(WebInspector.UIString("Canvas:"),WebInspector.settings.experimentalShowCanvasContextsInResources,WebInspector.UIString("Show Contexts in Resources Tab"))),this.addSettingsView(this._debugSettingsView)}}_updateNavigationBarVisibility(){let _=0;for(let S of this._navigationBar.navigationItems)if(!S.hidden&&1<++_)return void this._navigationBar.element.classList.remove("invisible");this._navigationBar.element.classList.add("invisible")}_navigationItemSelected(_){let S=_.target.selectedNavigationItem;if(S){let C=this._settingsViews.find(f=>f.identifier===S.identifier);C&&(this.selectedSettingsView=C)}}_updateDebugSettingsViewVisibility(){WebInspector.isDebugUIEnabled()&&this._createDebugSettingsView();this._debugSettingsView&&(this.setSettingsViewVisible(this._debugSettingsView,WebInspector.isDebugUIEnabled()),this.needsLayout())}},WebInspector.SettingsTabContentView.Type="settings",WebInspector.StorageTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.StorageTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.ApplicationCacheDetailsSidebarPanel,WebInspector.IndexedDatabaseDetailsSidebarPanel];super(_||"storage","storage",f,WebInspector.StorageSidebarPanel,T)}static tabInfo(){return{image:"Images/Storage.svg",title:WebInspector.UIString("Storage")}}static isTabAllowed(){return!!window.DOMStorageAgent||!!window.DatabaseAgent||!!window.IndexedDBAgent}get type(){return WebInspector.StorageTabContentView.Type}get supportsSplitContentBrowser(){return!0}canShowRepresentedObject(_){return _ instanceof WebInspector.DOMStorageObject||_ instanceof WebInspector.CookieStorageObject||_ instanceof WebInspector.DatabaseTableObject||_ instanceof WebInspector.DatabaseObject||_ instanceof WebInspector.ApplicationCacheFrame||_ instanceof WebInspector.IndexedDatabaseObjectStore||_ instanceof WebInspector.IndexedDatabase||_ instanceof WebInspector.IndexedDatabaseObjectStoreIndex}},WebInspector.StorageTabContentView.Type="storage",WebInspector.TimelineTabContentView=class extends WebInspector.ContentBrowserTabContentView{constructor(_){let{image:S,title:C}=WebInspector.TimelineTabContentView.tabInfo(),f=new WebInspector.GeneralTabBarItem(S,C),T=[WebInspector.ResourceDetailsSidebarPanel,WebInspector.ProbeDetailsSidebarPanel];super(_||"timeline","timeline",f,null,T),this._recordingTreeElementMap=new Map,this._recordingsTreeOutline=new WebInspector.TreeOutline,this._recordingsTreeOutline.addEventListener(WebInspector.TreeOutline.Event.SelectionDidChange,this._recordingsTreeSelectionDidChange,this),this._toggleRecordingShortcut=new WebInspector.KeyboardShortcut(null,WebInspector.KeyboardShortcut.Key.Space,this._toggleRecordingOnSpacebar.bind(this)),this._toggleRecordingShortcut.implicitlyPreventsDefault=!1,this._toggleRecordingShortcut.disabled=!0,this._toggleNewRecordingShortcut=new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.Shift,WebInspector.KeyboardShortcut.Key.Space,this._toggleNewRecordingOnSpacebar.bind(this)),this._toggleNewRecordingShortcut.implicitlyPreventsDefault=!1,this._toggleNewRecordingShortcut.disabled=!0;let E=WebInspector.UIString("Start recording (%s)\nCreate new recording (%s)").format(this._toggleRecordingShortcut.displayName,this._toggleNewRecordingShortcut.displayName),I=WebInspector.UIString("Stop recording (%s)").format(this._toggleRecordingShortcut.displayName);if(this._recordButton=new WebInspector.ToggleButtonNavigationItem("record-start-stop",E,I,"Images/Record.svg","Images/Stop.svg",13,13),this._recordButton.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._recordButtonClicked,this),this.contentBrowser.navigationBar.insertNavigationItem(this._recordButton,0),WebInspector.FPSInstrument.supported()){let N=new WebInspector.RadioButtonNavigationItem(WebInspector.TimelineOverview.ViewMode.Timelines,WebInspector.UIString("Events")),L=new WebInspector.RadioButtonNavigationItem(WebInspector.TimelineOverview.ViewMode.RenderingFrames,WebInspector.UIString("Frames"));this.contentBrowser.navigationBar.insertNavigationItem(N,1),this.contentBrowser.navigationBar.insertNavigationItem(L,2),this.contentBrowser.navigationBar.addEventListener(WebInspector.NavigationBar.Event.NavigationItemSelected,this._viewModeSelected,this)}WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.RecordingCreated,this._recordingCreated,this),WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.RecordingLoaded,this._recordingLoaded,this),WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStarted,this._capturingStartedOrStopped,this),WebInspector.timelineManager.addEventListener(WebInspector.TimelineManager.Event.CapturingStopped,this._capturingStartedOrStopped,this),WebInspector.notifications.addEventListener(WebInspector.Notification.VisibilityStateDidChange,this._inspectorVisibilityChanged,this),this._displayedRecording=null,this._displayedContentView=null,this._viewMode=null,this._previousSelectedTimelineType=null;this._changeViewMode(WebInspector.TimelineOverview.ViewMode.Timelines,!1);for(let N of WebInspector.timelineManager.recordings)this._addRecording(N);this._recordingCountChanged(),this.contentBrowser.updateHierarchicalPathForCurrentContentView()}static tabInfo(){return{image:"Images/Timeline.svg",title:WebInspector.UIString("Timelines")}}static isTabAllowed(){return!!window.TimelineAgent||!!window.ScriptProfilerAgent}static displayNameForTimelineType(_){switch(_){case WebInspector.TimelineRecord.Type.Network:return WebInspector.UIString("Network Requests");case WebInspector.TimelineRecord.Type.Layout:return WebInspector.UIString("Layout & Rendering");case WebInspector.TimelineRecord.Type.Script:return WebInspector.UIString("JavaScript & Events");case WebInspector.TimelineRecord.Type.RenderingFrame:return WebInspector.UIString("Rendering Frames");case WebInspector.TimelineRecord.Type.Memory:return WebInspector.UIString("Memory");case WebInspector.TimelineRecord.Type.HeapAllocations:return WebInspector.UIString("JavaScript Allocations");default:console.error("Unknown Timeline type:",_);}return null}static iconClassNameForTimelineType(_){switch(_){case WebInspector.TimelineRecord.Type.Network:return"network-icon";case WebInspector.TimelineRecord.Type.Layout:return"layout-icon";case WebInspector.TimelineRecord.Type.Memory:return"memory-icon";case WebInspector.TimelineRecord.Type.HeapAllocations:return"heap-allocations-icon";case WebInspector.TimelineRecord.Type.Script:return"script-icon";case WebInspector.TimelineRecord.Type.RenderingFrame:return"rendering-frame-icon";default:console.error("Unknown Timeline type:",_);}return null}static genericClassNameForTimelineType(_){switch(_){case WebInspector.TimelineRecord.Type.Network:return"network";case WebInspector.TimelineRecord.Type.Layout:return"colors";case WebInspector.TimelineRecord.Type.Memory:return"memory";case WebInspector.TimelineRecord.Type.HeapAllocations:return"heap-allocations";case WebInspector.TimelineRecord.Type.Script:return"script";case WebInspector.TimelineRecord.Type.RenderingFrame:return"rendering-frame";default:console.error("Unknown Timeline type:",_);}return null}static iconClassNameForRecord(_){switch(_.type){case WebInspector.TimelineRecord.Type.Layout:switch(_.eventType){case WebInspector.LayoutTimelineRecord.EventType.InvalidateStyles:case WebInspector.LayoutTimelineRecord.EventType.RecalculateStyles:return WebInspector.TimelineRecordTreeElement.StyleRecordIconStyleClass;case WebInspector.LayoutTimelineRecord.EventType.InvalidateLayout:case WebInspector.LayoutTimelineRecord.EventType.ForcedLayout:case WebInspector.LayoutTimelineRecord.EventType.Layout:return WebInspector.TimelineRecordTreeElement.LayoutRecordIconStyleClass;case WebInspector.LayoutTimelineRecord.EventType.Paint:return WebInspector.TimelineRecordTreeElement.PaintRecordIconStyleClass;case WebInspector.LayoutTimelineRecord.EventType.Composite:return WebInspector.TimelineRecordTreeElement.CompositeRecordIconStyleClass;default:console.error("Unknown LayoutTimelineRecord eventType: "+_.eventType,_);}break;case WebInspector.TimelineRecord.Type.Script:switch(_.eventType){case WebInspector.ScriptTimelineRecord.EventType.APIScriptEvaluated:return WebInspector.TimelineRecordTreeElement.APIRecordIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.ScriptEvaluated:return WebInspector.TimelineRecordTreeElement.EvaluatedRecordIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.MicrotaskDispatched:case WebInspector.ScriptTimelineRecord.EventType.EventDispatched:return WebInspector.TimelineRecordTreeElement.EventRecordIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.ProbeSampleRecorded:return WebInspector.TimelineRecordTreeElement.ProbeRecordIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.ConsoleProfileRecorded:return WebInspector.TimelineRecordTreeElement.ConsoleProfileIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.GarbageCollected:return WebInspector.TimelineRecordTreeElement.GarbageCollectionIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.TimerInstalled:return WebInspector.TimelineRecordTreeElement.TimerRecordIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.TimerFired:case WebInspector.ScriptTimelineRecord.EventType.TimerRemoved:return WebInspector.TimelineRecordTreeElement.TimerRecordIconStyleClass;case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameFired:case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameRequested:case WebInspector.ScriptTimelineRecord.EventType.AnimationFrameCanceled:return WebInspector.TimelineRecordTreeElement.AnimationRecordIconStyleClass;default:console.error("Unknown ScriptTimelineRecord eventType: "+_.eventType,_);}break;case WebInspector.TimelineRecord.Type.RenderingFrame:return WebInspector.TimelineRecordTreeElement.RenderingFrameRecordIconStyleClass;case WebInspector.TimelineRecord.Type.HeapAllocations:return"heap-snapshot-record";case WebInspector.TimelineRecord.Type.Memory:default:console.error("Unknown TimelineRecord type: "+_.type,_);}return null}static displayNameForRecord(_,S){switch(_.type){case WebInspector.TimelineRecord.Type.Network:return WebInspector.displayNameForURL(_.resource.url,_.resource.urlComponents);case WebInspector.TimelineRecord.Type.Layout:return WebInspector.LayoutTimelineRecord.displayNameForEventType(_.eventType);case WebInspector.TimelineRecord.Type.Script:return WebInspector.ScriptTimelineRecord.EventType.displayName(_.eventType,_.details,S);case WebInspector.TimelineRecord.Type.RenderingFrame:return WebInspector.UIString("Frame %d").format(_.frameNumber);case WebInspector.TimelineRecord.Type.HeapAllocations:return _.heapSnapshot.title?WebInspector.UIString("Snapshot %d \u2014 %s").format(_.heapSnapshot.identifier,_.heapSnapshot.title):WebInspector.UIString("Snapshot %d").format(_.heapSnapshot.identifier);case WebInspector.TimelineRecord.Type.Memory:default:console.error("Unknown TimelineRecord type: "+_.type,_);}return null}get type(){return WebInspector.TimelineTabContentView.Type}shown(){super.shown(),this._toggleRecordingShortcut.disabled=!1,this._toggleNewRecordingShortcut.disabled=!1,WebInspector.visible&&(WebInspector.timelineManager.autoCaptureOnPageLoad=!0)}hidden(){super.hidden(),this._toggleRecordingShortcut.disabled=!0,this._toggleNewRecordingShortcut.disabled=!0,WebInspector.timelineManager.autoCaptureOnPageLoad=!1}closed(){super.closed(),WebInspector.FPSInstrument.supported()&&this.contentBrowser.navigationBar.removeEventListener(null,null,this),WebInspector.timelineManager.removeEventListener(null,null,this),WebInspector.notifications.removeEventListener(null,null,this)}canShowRepresentedObject(_){return _ instanceof WebInspector.TimelineRecording}restoreFromCookie(_){if(this._restoredShowingTimelineRecordingContentView=_[WebInspector.TimelineTabContentView.ShowingTimelineRecordingContentViewCookieKey],!this._restoredShowingTimelineRecordingContentView)return void(this.contentBrowser.currentContentView||(!this._displayedRecording&&WebInspector.timelineManager.activeRecording&&this._recordingLoaded(),this._showTimelineViewForType(WebInspector.TimelineTabContentView.OverviewTimelineIdentifierCookieValue)));let S=_[WebInspector.TimelineTabContentView.SelectedTimelineViewIdentifierCookieKey];S!==WebInspector.TimelineRecord.Type.RenderingFrame||WebInspector.FPSInstrument.supported()||(S=null),this._showTimelineViewForType(S),super.restoreFromCookie(_)}saveToCookie(_){if(_[WebInspector.TimelineTabContentView.ShowingTimelineRecordingContentViewCookieKey]=this.contentBrowser.currentContentView instanceof WebInspector.TimelineRecordingContentView,this._viewMode===WebInspector.TimelineOverview.ViewMode.RenderingFrames)_[WebInspector.TimelineTabContentView.SelectedTimelineViewIdentifierCookieKey]=WebInspector.TimelineRecord.Type.RenderingFrame;else{let S=this._getTimelineForCurrentContentView();_[WebInspector.TimelineTabContentView.SelectedTimelineViewIdentifierCookieKey]=S?S.type:WebInspector.TimelineTabContentView.OverviewTimelineIdentifierCookieValue}super.saveToCookie(_)}treeElementForRepresentedObject(_){return this._recordingTreeElementMap?_ instanceof WebInspector.TimelineRecording?this._recordingTreeElementMap.get(_):null:null}_capturingStartedOrStopped(){let S=WebInspector.timelineManager.isCapturing();this._recordButton.toggled=S}_inspectorVisibilityChanged(){WebInspector.timelineManager.autoCaptureOnPageLoad=!!this.visible&&!!WebInspector.visible}_toggleRecordingOnSpacebar(_){WebInspector.isEventTargetAnEditableField(_)||(this._toggleRecording(),_.preventDefault())}_toggleNewRecordingOnSpacebar(_){WebInspector.isEventTargetAnEditableField(_)||(this._toggleRecording(!0),_.preventDefault())}_toggleRecording(_){let S=WebInspector.timelineManager.isCapturing();this._recordButton.toggled=S,S?WebInspector.timelineManager.stopCapturing():(WebInspector.timelineManager.startCapturing(_),this._recordingLoaded())}_recordButtonClicked(){let S=!!window.event&&window.event.shiftKey;this._recordButton.toggled=!WebInspector.timelineManager.isCapturing(),this._toggleRecording(S)}_recordingsTreeSelectionDidChange(_){let S=_.data.selectedElement;S&&this._recordingSelected(S.representedObject)}_recordingCreated(_){this._addRecording(_.data.recording),this._recordingCountChanged()}_addRecording(_){let S=new WebInspector.GeneralTreeElement(WebInspector.TimelineTabContentView.StopwatchIconStyleClass,_.displayName,null,_);this._recordingTreeElementMap.set(_,S),this._recordingsTreeOutline.appendChild(S)}_recordingCountChanged(){let _=null;for(let S of this._recordingTreeElementMap.values())_&&(_.nextSibling=S,S.previousSibling=_),_=S}_recordingSelected(_){this._displayedRecording=_;let S={};this.saveToCookie(S),this._displayedContentView&&this._displayedContentView.removeEventListener(WebInspector.ContentView.Event.NavigationItemsDidChange,this._displayedContentViewNavigationItemsDidChange,this);let C=!0;if(this._displayedContentView=this.contentBrowser.contentViewForRepresentedObject(this._displayedRecording,C),this._displayedContentView){this._displayedContentView.addEventListener(WebInspector.ContentView.Event.NavigationItemsDidChange,this._displayedContentViewNavigationItemsDidChange,this);let f=this._displayedContentView.currentTimelineView,T=f&&f.representedObject instanceof WebInspector.Timeline?f.representedObject.type:null;return void this._showTimelineViewForType(T)}C=!1,this._displayedContentView=this.contentBrowser.contentViewForRepresentedObject(this._displayedRecording,C),this._displayedContentView&&this._displayedContentView.addEventListener(WebInspector.ContentView.Event.NavigationItemsDidChange,this._displayedContentViewNavigationItemsDidChange,this),this.restoreFromCookie(S)}_recordingLoaded(){this._recordingSelected(WebInspector.timelineManager.activeRecording)}_viewModeSelected(_){let S=_.target.selectedNavigationItem;if(S){this._changeViewMode(S.identifier,!0)}}_changeViewMode(_,S){if(this._viewMode!==_){let C=this.contentBrowser.navigationBar.findNavigationItem(_);if(C&&(this._viewMode=_,this.contentBrowser.navigationBar.selectedNavigationItem=C,!!S)){let f=this._previousSelectedTimelineType;if(this._viewMode===WebInspector.TimelineOverview.ViewMode.RenderingFrames){let T=this._getTimelineForCurrentContentView();this._previousSelectedTimelineType=T?T.type:null,f=WebInspector.TimelineRecord.Type.RenderingFrame}this._showTimelineViewForType(f)}}}_showTimelineViewForType(_){let S=_?this._displayedRecording.timelines.get(_):null;S?this._displayedContentView.showTimelineViewForTimeline(S):this._displayedContentView.showOverviewTimelineView(),this.contentBrowser.currentContentView!==this._displayedContentView&&this.contentBrowser.showContentView(this._displayedContentView)}_displayedContentViewNavigationItemsDidChange(){let S=this._getTimelineForCurrentContentView(),C=WebInspector.TimelineOverview.ViewMode.Timelines;S&&S.type===WebInspector.TimelineRecord.Type.RenderingFrame&&(C=WebInspector.TimelineOverview.ViewMode.RenderingFrames);this._changeViewMode(C,!1)}_getTimelineForCurrentContentView(){let _=this.contentBrowser.currentContentView;if(!(_ instanceof WebInspector.TimelineRecordingContentView))return null;let S=_.currentTimelineView;return S&&S.representedObject instanceof WebInspector.Timeline?S.representedObject:null}},WebInspector.TimelineTabContentView.Type="timeline",WebInspector.TimelineTabContentView.ShowingTimelineRecordingContentViewCookieKey="timeline-sidebar-panel-showing-timeline-recording-content-view",WebInspector.TimelineTabContentView.SelectedTimelineViewIdentifierCookieKey="timeline-sidebar-panel-selected-timeline-view-identifier",WebInspector.TimelineTabContentView.OverviewTimelineIdentifierCookieValue="overview",WebInspector.TimelineTabContentView.StopwatchIconStyleClass="stopwatch-icon",WebInspector.DetailsSection=class extends WebInspector.Object{constructor(_,S,C,f,T){super(),this._element=document.createElement("div"),this._element.classList.add(_,"details-section"),this._headerElement=document.createElement("div"),this._headerElement.addEventListener("click",this._headerElementClicked.bind(this)),this._headerElement.className="header",this._element.appendChild(this._headerElement),f instanceof HTMLElement&&(this._optionsElement=f,this._optionsElement.classList.add("options"),this._optionsElement.addEventListener("mousedown",this._optionsElementMouseDown.bind(this)),this._optionsElement.addEventListener("mouseup",this._optionsElementMouseUp.bind(this)),this._headerElement.appendChild(this._optionsElement)),this._titleElement=document.createElement("span"),this._headerElement.appendChild(this._titleElement),this._contentElement=document.createElement("div"),this._contentElement.className="content",this._element.appendChild(this._contentElement),this._identifier=_,this.title=S,this.groups=C||[new WebInspector.DetailsSectionGroup],this._collapsedSetting=new WebInspector.Setting(_+"-details-section-collapsed",!!T),this.collapsed=this._collapsedSetting.value,this._expandedByUser=!1}get element(){return this._element}get identifier(){return this._identifier}get title(){return this._titleElement.textContent}set title(_){this._titleElement.textContent=_}get titleElement(){return this._titleElement}set titleElement(_){this._headerElement.replaceChild(_,this._titleElement),this._titleElement=_}get collapsed(){return this._element.classList.contains(WebInspector.DetailsSection.CollapsedStyleClassName)}set collapsed(_){_?this._element.classList.add(WebInspector.DetailsSection.CollapsedStyleClassName):this._element.classList.remove(WebInspector.DetailsSection.CollapsedStyleClassName),this._collapsedSetting.value=_||!1,this.dispatchEventToListeners(WebInspector.DetailsSection.Event.CollapsedStateChanged,{collapsed:this._collapsedSetting.value})}get groups(){return this._groups}set groups(_){this._contentElement.removeChildren(),this._groups=_||[];for(var S=0;S<this._groups.length;++S)this._contentElement.appendChild(this._groups[S].element)}get expandedByUser(){return this._expandedByUser}_headerElementClicked(_){if(!_.target.isSelfOrDescendant(this._optionsElement)){var S=this.collapsed;this.collapsed=!S,this._expandedByUser=S,this._element.scrollIntoViewIfNeeded(!1)}}_optionsElementMouseDown(){this._headerElement.classList.add(WebInspector.DetailsSection.MouseOverOptionsElementStyleClassName)}_optionsElementMouseUp(){this._headerElement.classList.remove(WebInspector.DetailsSection.MouseOverOptionsElementStyleClassName)}},WebInspector.DetailsSection.CollapsedStyleClassName="collapsed",WebInspector.DetailsSection.MouseOverOptionsElementStyleClassName="mouse-over-options-element",WebInspector.DetailsSection.Event={CollapsedStateChanged:"details-section-collapsed-state-changed"},WebInspector.DetailsSectionDataGridRow=class extends WebInspector.DetailsSectionRow{constructor(_,S){super(S),this.element.classList.add("data-grid"),this.dataGrid=_}get dataGrid(){return this._dataGrid}set dataGrid(_){this._dataGrid===_||(this._dataGrid=_||null,_?(_.inline=!0,_.variableHeightRows=!0,this.hideEmptyMessage(),this.element.appendChild(_.element),_.updateLayoutIfNeeded()):this.showEmptyMessage())}sizeDidChange(){this._dataGrid&&this._dataGrid.sizeDidChange()}},WebInspector.DetailsSectionGroup=class extends WebInspector.Object{constructor(_){super(),this._element=document.createElement("div"),this._element.className="group",this.rows=_||[]}get element(){return this._element}get rows(){return this._rows}set rows(_){this._element.removeChildren(),this._rows=_||[];for(var S=0;S<this._rows.length;++S)this._element.appendChild(this._rows[S].element)}},WebInspector.DetailsSectionSimpleRow=class extends WebInspector.DetailsSectionRow{constructor(_,S){super(),this.element.classList.add("simple"),this._labelElement=document.createElement("div"),this._labelElement.className="label",this.element.appendChild(this._labelElement),this._valueElement=document.createElement("div"),this._valueElement.className="value",this.element.appendChild(this._valueElement);this._valueElement.addEventListener("click",function(f){if(f.stopPropagation(),!(3>f.detail)){var T=window.getSelection();if(T){var E=T.getRangeAt(0);if(E&&E.startContainer!==E.endContainer){var I=document.createRange();I.selectNodeContents(f.currentTarget),T.removeAllRanges(),T.addRange(I)}}}}),this.label=_,this.value=S}get label(){return this._labelElement.textContent}set label(_){this._labelElement.textContent=_}get value(){return this._value}set value(_){this._value=_||"",this._value?(this.element.classList.remove(WebInspector.DetailsSectionSimpleRow.EmptyStyleClassName),/[\s\u200b]/.test(this._value)?this.element.classList.remove(WebInspector.DetailsSectionSimpleRow.DataStyleClassName):this.element.classList.add(WebInspector.DetailsSectionSimpleRow.DataStyleClassName)):(this.element.classList.add(WebInspector.DetailsSectionSimpleRow.EmptyStyleClassName),this.element.classList.remove(WebInspector.DetailsSectionSimpleRow.DataStyleClassName)),_ instanceof Node?(this._valueElement.removeChildren(),this._valueElement.appendChild(this._value)):this._valueElement.textContent=this._value}get tooltip(){return this._valueElement.title}set tooltip(_){this._valueElement.title=_}},WebInspector.DetailsSectionSimpleRow.DataStyleClassName="data",WebInspector.DetailsSectionSimpleRow.EmptyStyleClassName="empty",WebInspector.DetailsSectionTextRow=class extends WebInspector.DetailsSectionRow{constructor(_){super(),this.element.classList.add("text"),this.element.textContent=_}get text(){return this.element.textContent}set text(_){this.element.textContent=_}},WebInspector.SettingEditor=class extends WebInspector.Object{constructor(_,S,C){if(super(),this._type=_,this._label=S,this._value=null,this._editorElement=this._createEditorElement(C),this._element=document.createElement("div"),this._element.classList.add("editor"),this._element.append(this._editorElement),this._label){this._editorElement.id="setting-editor-"+WebInspector.SettingEditor._nextEditorIdentifier++;let f=document.createElement("label");f.setAttribute("for",this._editorElement.id),f.textContent=S,this._element.append(f)}}static createForSetting(_,S,C){let f;if("boolean"==typeof _.value?f=WebInspector.SettingEditor.Type.Checkbox:"number"==typeof _.value&&(f=WebInspector.SettingEditor.Type.Numeric),!f)return null;let T=new WebInspector.SettingEditor(f,S,C);return T.value=_.value,T.addEventListener(WebInspector.SettingEditor.Event.ValueDidChange,()=>{_.value=T.value}),T}get element(){return this._element}get type(){return this._type}get label(){return this._label}get value(){return this._value}set value(_){if(this._value!==_){let S=this._value;this._value=_,this._type==WebInspector.SettingEditor.Type.Checkbox?this._editorElement.checked=!!this._value:this._editorElement.value=this._value,this.dispatchEventToListeners(WebInspector.SettingEditor.Event.ValueDidChange,{oldValue:S})}}_createEditorElement(_){let S;switch(this._type){case WebInspector.SettingEditor.Type.Checkbox:S=document.createElement("input"),S.type="checkbox",S.addEventListener("change",f=>{this.value=f.target.checked});break;case WebInspector.SettingEditor.Type.Numeric:S=document.createElement("input"),S.type="number",_.min!==void 0&&(S.min=_.min),_.max!==void 0&&(S.max=_.max),S.addEventListener("change",f=>{let T=this._value,E=parseInt(f.target.value);this.value=isNaN(E)?T:E});break;case WebInspector.SettingEditor.Type.Select:S=document.createElement("select");var C=[];C=Array.isArray(_.values[0])?_.values:_.values.map(f=>[f,f]);for(let[f,T]of C){let E=S.appendChild(document.createElement("option"));E.value=f,E.textContent=T}S.addEventListener("change",f=>{this.value=f.target.value});break;default:console.error("Unknown editor type: "+this._type);}return S}},WebInspector.SettingEditor._nextEditorIdentifier=1,WebInspector.SettingEditor.Type={Checkbox:"setting-editor-type-checkbox",Numeric:"setting-editor-type-numeric",Select:"setting-editor-type-select"},WebInspector.SettingEditor.Event={ValueDidChange:"value-did-change"},WebInspector.SettingsGroup=class extends WebInspector.Object{constructor(_){super(),this._element=document.createElement("div"),this._element.classList.add("container");let S=this._element.appendChild(document.createElement("div"));S.classList.add("title"),S.textContent=_,this._editorGroupElement=this._element.appendChild(document.createElement("div")),this._editorGroupElement.classList.add("editor-group")}get element(){return this._element}addSetting(_,S,C){let f=WebInspector.SettingEditor.createForSetting(_,S,C);return f?(this._editorGroupElement.append(f.element),f):null}addCustomSetting(_,S){let C=new WebInspector.SettingEditor(_,S.label,S);return C?(this._editorGroupElement.append(C.element),C):null}},WebInspector.SettingsView=class extends WebInspector.View{constructor(_,S){super(),this._identifier=_,this._displayName=S,this.element.classList.add("settings-view",_)}get identifier(){return this._identifier}get displayName(){return this._displayName}addSetting(_,S,C,f){let T=this.addGroup(_);return T.addSetting(S,C,f)}addGroupWithCustomSetting(_,S,C){let f=this.addGroup(_);return f.addCustomSetting(S,C)}addGroup(_){let S=new WebInspector.SettingsGroup(_);return this.element.append(S.element),S}addSeparator(){if(!(this.element.lastChild&&this.element.lastChild.classList.contains("separator"))){let _=this.element.appendChild(document.createElement("div"));_.classList.add("separator")}}},WebInspector.SettingsView.EditorType={Checkbox:"settings-view-editor-type-checkbox",Numeric:"settings-view-editor-type-numeric",Select:"settings-view-editor-type-select"},WebInspector.ActivateButtonNavigationItem=class extends WebInspector.ButtonNavigationItem{constructor(_,S,C,f,T,E,I){super(_,S,f,T,E,I),this._defaultToolTip=S,this._activatedToolTip=C||S,this._role=I}get defaultToolTip(){return this._defaultToolTip}get activatedToolTip(){return this._activatedToolTip}get activated(){return this.element.classList.contains(WebInspector.ActivateButtonNavigationItem.ActivatedStyleClassName)}set activated(_){this.element.classList.toggle(WebInspector.ActivateButtonNavigationItem.ActivatedStyleClassName,_),_?(this.toolTip=this._activatedToolTip,"tab"===this._role&&this.element.setAttribute("aria-selected","true")):(this.toolTip=this._defaultToolTip,"tab"===this._role&&this.element.removeAttribute("aria-selected"))}get additionalClassNames(){return["activate","button"]}},WebInspector.ActivateButtonNavigationItem.ActivatedStyleClassName="activated",WebInspector.ActivateButtonToolbarItem=class extends WebInspector.ActivateButtonNavigationItem{constructor(_,S,C,f,T,E){super(_,S,C,T,16,16,E),"string"==typeof f&&(this._labelElement=document.createElement("div"),this._labelElement.className=WebInspector.ButtonToolbarItem.LabelStyleClassName,this._element.appendChild(this._labelElement),this.label=f)}get label(){return this._labelElement.textContent}set label(_){_&&this._labelElement&&(this._labelElement.textContent=_)}},WebInspector.ApplicationCacheDetailsSidebarPanel=class extends WebInspector.DetailsSidebarPanel{constructor(){super("application-cache-details",WebInspector.UIString("Storage")),this.element.classList.add("application-cache"),this._applicationCacheFrame=null}inspect(_){_ instanceof Array||(_=[_]);for(var S=null,C=0;C<_.length;++C)if(_[C]instanceof WebInspector.ApplicationCacheFrame){S=_[C];break}return this.applicationCacheFrame=S,!!this.applicationCacheFrame}get applicationCacheFrame(){return this._applicationCacheFrame}set applicationCacheFrame(_){this._applicationCacheFrame===_||(this._applicationCacheFrame=_,this.needsLayout())}initialLayout(){super.initialLayout(),this._locationManifestURLRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Manifest URL")),this._locationFrameURLRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Frame URL"));let _=new WebInspector.DetailsSectionGroup([this._locationManifestURLRow,this._locationFrameURLRow]),S=new WebInspector.DetailsSection("application-cache-location",WebInspector.UIString("Location"),[_]);this._onlineRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Online")),this._statusRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Status"));let C=new WebInspector.DetailsSectionGroup([this._onlineRow,this._statusRow]),f=new WebInspector.DetailsSection("application-cache-status",WebInspector.UIString("Status"),[C]);this.contentView.element.appendChild(S.element),this.contentView.element.appendChild(f.element),WebInspector.applicationCacheManager.addEventListener(WebInspector.ApplicationCacheManager.Event.NetworkStateUpdated,this._networkStateUpdated,this),WebInspector.applicationCacheManager.addEventListener(WebInspector.ApplicationCacheManager.Event.FrameManifestStatusChanged,this._frameManifestStatusChanged,this)}layout(){super.layout();this.applicationCacheFrame&&(this._locationFrameURLRow.value=this.applicationCacheFrame.frame.url,this._locationManifestURLRow.value=this.applicationCacheFrame.manifest.manifestURL,this._refreshOnlineRow(),this._refreshStatusRow())}_networkStateUpdated(){this.applicationCacheFrame&&this._refreshOnlineRow()}_frameManifestStatusChanged(_){this.applicationCacheFrame&&_.data.frameManifest===this.applicationCacheFrame&&this._refreshStatusRow()}_refreshOnlineRow(){this._onlineRow.value=WebInspector.applicationCacheManager.online?WebInspector.UIString("Yes"):WebInspector.UIString("No")}_refreshStatusRow(){this._statusRow.value=WebInspector.ApplicationCacheDetailsSidebarPanel.Status[this.applicationCacheFrame.status]}},WebInspector.ApplicationCacheDetailsSidebarPanel.Status={0:"Uncached",1:"Idle",2:"Checking",3:"Downloading",4:"UpdateReady",5:"Obsolete"},WebInspector.ApplicationCacheFrameContentView=class extends WebInspector.ContentView{constructor(_){super(_),this.element.classList.add("application-cache-frame"),this._frame=_.frame,this._emptyView=WebInspector.createMessageTextView(WebInspector.UIString("No Application Cache information available"),!1),this._emptyView.classList.add("hidden"),this.element.appendChild(this._emptyView),this._markDirty();var S=_.status;this.updateStatus(S),WebInspector.applicationCacheManager.addEventListener(WebInspector.ApplicationCacheManager.Event.FrameManifestStatusChanged,this._updateStatus,this)}shown(){super.shown(),this._maybeUpdate()}closed(){WebInspector.applicationCacheManager.removeEventListener(null,null,this),super.closed()}saveToCookie(_){_.type=WebInspector.ContentViewCookieType.ApplicationCache,_.frame=this.representedObject.frame.url,_.manifest=this.representedObject.manifest.manifestURL}get scrollableElements(){return this._dataGrid?[this._dataGrid.scrollContainer]:[]}_maybeUpdate(){this.visible&&this._viewDirty&&(this._update(),this._viewDirty=!1)}_markDirty(){this._viewDirty=!0}_updateStatus(_){var S=_.data.frameManifest;S!==this.representedObject||this.updateStatus(S.status)}updateStatus(_){var S=this._status;this._status=_,this.visible&&this._status===WebInspector.ApplicationCacheManager.Status.Idle&&(S===WebInspector.ApplicationCacheManager.Status.UpdateReady||!this._resources)&&this._markDirty(),this._maybeUpdate()}_update(){WebInspector.applicationCacheManager.requestApplicationCache(this._frame,this._updateCallback.bind(this))}_updateCallback(_){return _&&_.manifestURL?void(this._manifest=_.manifestURL,this._creationTime=_.creationTime,this._updateTime=_.updateTime,this._size=_.size,this._resources=_.resources,!this._dataGrid&&this._createDataGrid(),this._populateDataGrid(),this._dataGrid.autoSizeColumns(20,80),this._dataGrid.element.classList.remove("hidden"),this._emptyView.classList.add("hidden")):(delete this._manifest,delete this._creationTime,delete this._updateTime,delete this._size,delete this._resources,this._emptyView.classList.remove("hidden"),void(this._dataGrid&&this._dataGrid.element.classList.add("hidden")))}_createDataGrid(){var _={url:{},type:{},size:{}};_.url.title=WebInspector.UIString("Resource"),_.url.sortable=!0,_.type.title=WebInspector.UIString("Type"),_.type.sortable=!0,_.size.title=WebInspector.UIString("Size"),_.size.aligned="right",_.size.sortable=!0,this._dataGrid=new WebInspector.DataGrid(_),this._dataGrid.addEventListener(WebInspector.DataGrid.Event.SortChanged,this._sortDataGrid,this),this._dataGrid.sortColumnIdentifier="url",this._dataGrid.sortOrder=WebInspector.DataGrid.SortOrder.Ascending,this._dataGrid.createSettings("application-cache-frame-content-view"),this.addSubview(this._dataGrid),this._dataGrid.updateLayout()}_sortDataGrid(){function _(f,T,E){return T.data[f]-E.data[f]}function S(f,T,E){return(T.data[f]+"").extendedLocaleCompare(E.data[f]+"")}var C;switch(this._dataGrid.sortColumnIdentifier){case"type":C=S.bind(this,"type");break;case"size":C=_.bind(this,"size");break;case"url":default:C=S.bind(this,"url");}this._dataGrid.sortNodes(C)}_populateDataGrid(){this._dataGrid.removeChildren();for(var _ of this._resources){var S={url:_.url,type:_.type,size:Number.bytesToString(_.size)},C=new WebInspector.DataGridNode(S);this._dataGrid.appendChild(C)}}_deleteButtonClicked(){this._dataGrid&&this._dataGrid.selectedNode&&this._deleteCallback(this._dataGrid.selectedNode)}_deleteCallback(){}},WebInspector.ApplicationCacheFrameTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_){super("application-cache-frame","","",_,!1),this.updateTitles()}updateTitles(){var _=this.representedObject.frame.url,S=parseURL(_);this.mainTitle=WebInspector.displayNameForURL(_,S);for(var C=WebInspector.displayNameForHost(S.host),f=null,T=this.parent;T&&!T.root;){if(T instanceof WebInspector.ApplicationCacheManifestTreeElement){f=T;break}T=T.parent}var E=C===this._mainTitle||f&&f.subtitle===C;this.subtitle=E?null:C}},WebInspector.ApplicationCacheManifestTreeElement=class extends WebInspector.StorageTreeElement{constructor(_){super("application-cache-manifest","",_),this.hasChildren=!0,this.expanded=!0}get name(){return this._name||this._generateTitles(),this._name}get secondaryName(){return this._secondaryName||this._generateTitles(),this._secondaryName}get categoryName(){return WebInspector.UIString("Application Cache")}_generateTitles(){var _=parseURL(this.representedObject.manifestURL);this._name=WebInspector.displayNameForURL(this.representedObject.manifestURL,_);var S=WebInspector.displayNameForHost(_.host);this._secondaryName=this._name===S?null:S}},WebInspector.BezierEditor=class extends WebInspector.Object{constructor(){function _(I,R){I+=this._controlHandleRadius,R+=this._controlHandleRadius;let N=T.appendChild(createSVGElement("line"));N.classList.add("control-line"),N.setAttribute("x1",I),N.setAttribute("y1",R),N.setAttribute("x2",I),N.setAttribute("y2",R);let L=T.appendChild(createSVGElement("circle"));return L.classList.add("control-handle"),{point:null,line:N,handle:L}}function S(I,{min:R,max:N}={}){let L="_bezier"+I+"Input";this[L]=this._numberInputContainer.createChild("input"),this[L].type="number",this[L].step=0.01,isNaN(R)||(this[L].min=R),isNaN(N)||(this[L].max=N),this[L].addEventListener("input",this.debounce(250)._handleNumberInputInput),this[L].addEventListener("keydown",this._handleNumberInputKeydown.bind(this))}super(),this._element=document.createElement("div"),this._element.classList.add("bezier-editor");var C=184,f=200;this._padding=25,this._controlHandleRadius=7,this._bezierWidth=C-2*this._controlHandleRadius,this._bezierHeight=f-2*this._controlHandleRadius-2*this._padding,this._bezierPreviewContainer=this._element.createChild("div","bezier-preview"),this._bezierPreviewContainer.title=WebInspector.UIString("Restart animation"),this._bezierPreviewContainer.addEventListener("mousedown",this._resetPreviewAnimation.bind(this)),this._bezierPreview=this._bezierPreviewContainer.createChild("div"),this._bezierPreviewTiming=this._element.createChild("div","bezier-preview-timing"),this._bezierContainer=this._element.appendChild(createSVGElement("svg")),this._bezierContainer.setAttribute("width",C),this._bezierContainer.setAttribute("height",f),this._bezierContainer.classList.add("bezier-container");let T=this._bezierContainer.appendChild(createSVGElement("g"));T.setAttribute("transform","translate(0, "+this._padding+")");let E=T.appendChild(createSVGElement("line"));E.classList.add("linear-curve"),E.setAttribute("x1",this._controlHandleRadius),E.setAttribute("y1",this._bezierHeight+this._controlHandleRadius),E.setAttribute("x2",this._bezierWidth+this._controlHandleRadius),E.setAttribute("y2",this._controlHandleRadius),this._bezierCurve=T.appendChild(createSVGElement("path")),this._bezierCurve.classList.add("bezier-curve"),this._inControl=_.call(this,0,this._bezierHeight),this._outControl=_.call(this,this._bezierWidth,0),this._numberInputContainer=this._element.createChild("div","number-input-container"),S.call(this,"InX",{min:0,max:1}),S.call(this,"InY"),S.call(this,"OutX",{min:0,max:1}),S.call(this,"OutY"),this._selectedControl=null,this._mouseDownPosition=null,this._bezierContainer.addEventListener("mousedown",this),WebInspector.addWindowKeydownListener(this)}get element(){return this._element}set bezier(_){if(_){var S=_ instanceof WebInspector.CubicBezier;S&&(this._bezier=_,this._updateBezierPreview())}}get bezier(){return this._bezier}removeListeners(){WebInspector.removeWindowKeydownListener(this)}handleEvent(_){switch(_.type){case"mousedown":this._handleMousedown(_);break;case"mousemove":this._handleMousemove(_);break;case"mouseup":this._handleMouseup(_);}}handleKeydownEvent(_){if(!this._selectedControl||!this._element.parentNode)return!1;let S=0,C=0;switch(_.keyCode){case WebInspector.KeyboardShortcut.Key.Up.keyCode:C=-1;break;case WebInspector.KeyboardShortcut.Key.Right.keyCode:S=1;break;case WebInspector.KeyboardShortcut.Key.Down.keyCode:C=1;break;case WebInspector.KeyboardShortcut.Key.Left.keyCode:S=-1;break;default:return!1;}return _.shiftKey&&(S*=10,C*=10),C*=this._bezierWidth/100,S*=this._bezierHeight/100,this._selectedControl.point.x=Number.constrain(this._selectedControl.point.x+S,0,this._bezierWidth),this._selectedControl.point.y+=C,this._updateControl(this._selectedControl),this._updateValue(),!0}_handleMousedown(_){0!==_.button||(window.addEventListener("mousemove",this,!0),window.addEventListener("mouseup",this,!0),this._bezierPreviewContainer.classList.remove("animate"),this._bezierPreviewTiming.classList.remove("animate"),this._updateControlPointsForMouseEvent(_,!0))}_handleMousemove(_){this._updateControlPointsForMouseEvent(_)}_handleMouseup(){this._selectedControl.handle.classList.remove("selected"),this._mouseDownPosition=null,this._triggerPreviewAnimation(),window.removeEventListener("mousemove",this,!0),window.removeEventListener("mouseup",this,!0)}_updateControlPointsForMouseEvent(_,S){var C=WebInspector.Point.fromEventInElement(_,this._bezierContainer);C.x=Number.constrain(C.x-this._controlHandleRadius,0,this._bezierWidth),C.y-=this._controlHandleRadius+this._padding,S&&(this._mouseDownPosition=C,this._selectedControl=this._inControl.point.distance(C)<this._outControl.point.distance(C)?this._inControl:this._outControl),_.shiftKey&&this._mouseDownPosition&&(Math.abs(this._mouseDownPosition.x-C.x)>Math.abs(this._mouseDownPosition.y-C.y)?C.y=this._mouseDownPosition.y:C.x=this._mouseDownPosition.x),this._selectedControl.point=C,this._selectedControl.handle.classList.add("selected"),this._updateValue()}_updateValue(){function _(E){return Math.round(100*E)/100}var S=_(this._inControl.point.x/this._bezierWidth),C=_(1-this._inControl.point.y/this._bezierHeight),f=_(this._outControl.point.x/this._bezierWidth),T=_(1-this._outControl.point.y/this._bezierHeight);this._bezier=new WebInspector.CubicBezier(S,C,f,T),this._updateBezier(),this.dispatchEventToListeners(WebInspector.BezierEditor.Event.BezierChanged,{bezier:this._bezier})}_updateBezier(){var _=this._controlHandleRadius,S=this._inControl.point.x+_,C=this._inControl.point.y+_,f=this._outControl.point.x+_,T=this._outControl.point.y+_,E=`M ${_} ${this._bezierHeight+_} C ${S} ${C} ${f} ${T} ${this._bezierWidth+_} ${_}`;this._bezierCurve.setAttribute("d",E),this._updateControl(this._inControl),this._updateControl(this._outControl),this._bezierInXInput.value=this._bezier.inPoint.x,this._bezierInYInput.value=this._bezier.inPoint.y,this._bezierOutXInput.value=this._bezier.outPoint.x,this._bezierOutYInput.value=this._bezier.outPoint.y}_updateControl(_){_.handle.setAttribute("cx",_.point.x+this._controlHandleRadius),_.handle.setAttribute("cy",_.point.y+this._controlHandleRadius),_.line.setAttribute("x2",_.point.x+this._controlHandleRadius),_.line.setAttribute("y2",_.point.y+this._controlHandleRadius)}_updateBezierPreview(){this._inControl.point=new WebInspector.Point(this._bezier.inPoint.x*this._bezierWidth,(1-this._bezier.inPoint.y)*this._bezierHeight),this._outControl.point=new WebInspector.Point(this._bezier.outPoint.x*this._bezierWidth,(1-this._bezier.outPoint.y)*this._bezierHeight),this._updateBezier(),this._triggerPreviewAnimation()}_triggerPreviewAnimation(){this._bezierPreview.style.animationTimingFunction=this._bezier.toString(),this._bezierPreviewContainer.classList.add("animate"),this._bezierPreviewTiming.classList.add("animate")}_resetPreviewAnimation(){var _=this._bezierPreview.parentNode;_.removeChild(this._bezierPreview),_.appendChild(this._bezierPreview),this._element.removeChild(this._bezierPreviewTiming),this._element.appendChild(this._bezierPreviewTiming)}_handleNumberInputInput(_){this._changeBezierForInput(_.target,_.target.value)}_handleNumberInputKeydown(_){let S=0;"Up"===_.keyIdentifier?S=0.01:"Down"===_.keyIdentifier&&(S=-0.01);S&&(_.shiftKey&&(S*=10),_.preventDefault(),this._changeBezierForInput(_.target,parseFloat(_.target.value)+S))}_changeBezierForInput(_,S){switch(S=Math.round(100*S)/100,_){case this._bezierInXInput:this._bezier.inPoint.x=Number.constrain(S,0,1);break;case this._bezierInYInput:this._bezier.inPoint.y=S;break;case this._bezierOutXInput:this._bezier.outPoint.x=Number.constrain(S,0,1);break;case this._bezierOutYInput:this._bezier.outPoint.y=S;break;default:return;}this._updateBezierPreview(),this.dispatchEventToListeners(WebInspector.BezierEditor.Event.BezierChanged,{bezier:this._bezier})}},WebInspector.BezierEditor.Event={BezierChanged:"bezier-editor-bezier-changed"},WebInspector.BoxModelDetailsSectionRow=class extends WebInspector.DetailsSectionRow{constructor(){super(WebInspector.UIString("No Box Model Information")),this.element.classList.add("box-model"),this._nodeStyles=null}get nodeStyles(){return this._nodeStyles}set nodeStyles(_){this._nodeStyles&&this._nodeStyles.computedStyle&&this._nodeStyles.computedStyle.removeEventListener(WebInspector.CSSStyleDeclaration.Event.PropertiesChanged,this._refresh,this),this._nodeStyles=_,this._nodeStyles&&this._nodeStyles.computedStyle&&this._nodeStyles.computedStyle.addEventListener(WebInspector.CSSStyleDeclaration.Event.PropertiesChanged,this._refresh,this),this._refresh()}_refresh(){return this._ignoreNextRefresh?void(this._ignoreNextRefresh=!1):void this._updateMetrics()}_getPropertyValueAsPx(_,S){return+(_.propertyForName(S).value.replace(/px$/,"")||0)}_getBox(_,S){var C=this._getComponentSuffix(S),f=this._getPropertyValueAsPx(_,S+"-left"+C),T=this._getPropertyValueAsPx(_,S+"-top"+C),E=this._getPropertyValueAsPx(_,S+"-right"+C),I=this._getPropertyValueAsPx(_,S+"-bottom"+C);return{left:f,top:T,right:E,bottom:I}}_getComponentSuffix(_){return"border"===_?"-width":""}_highlightDOMNode(_,S,C){C.stopPropagation();var f=_?this.nodeStyles.node.id:0;if(f){if(this._highlightMode===S)return;this._highlightMode=S,WebInspector.domTreeManager.highlightDOMNode(f,S)}else this._highlightMode=null,WebInspector.domTreeManager.hideDOMNodeHighlight();for(var T=0,E;this._boxElements&&T<this._boxElements.length;++T)E=this._boxElements[T],f&&("all"===S||E._name===S)?E.classList.add("active"):E.classList.remove("active");this.element.classList.toggle("hovered",_)}_updateMetrics(){function _(M,P,O,F){let V=parseFloat(P),U=!isNaN(V)&&0!=V%1;isNaN(V)&&(P=figureDash);let G=document.createElement(M);return G.textContent=U?"~"+Math.round(100*V)/100:P,U&&(G.title=P),G.addEventListener("dblclick",this._startEditing.bind(this,G,O,F,T),!1),G}function S(M,P){let O=this._getComponentSuffix(M),F=("position"===M?"":M+"-")+P+O,V=T.propertyForName(F).value;V=""===V||"position"!==M&&"0px"===V||"position"===M&&"auto"===V?"":V.replace(/px$/,"");let U=_.call(this,"div",V,M,F);return U.className=P,U}function C(M){let P=T.propertyForName(M).value.replace(/px$/,"");if("border-box"===T.propertyForName("box-sizing").value){let O=this._getBox(T,"border"),F=this._getBox(T,"padding"),[V,U]="width"===M?["left","right"]:["top","bottom"];P=P-O[V]-O[U]-F[V]-F[U]}return _.call(this,"span",P,M,M)}var f=document.createElement("div"),T=this._nodeStyles.computedStyle,E={"table-cell":!0,"table-column":!0,"table-column-group":!0,"table-footer-group":!0,"table-header-group":!0,"table-row":!0,"table-row-group":!0},I={"table-column":!0,"table-column-group":!0,"table-footer-group":!0,"table-header-group":!0,"table-row":!0,"table-row-group":!0},R={"static":!0};if(this._boxElements=[],!T.hasProperties())return void this.showEmptyMessage();var N=null;for(let M of["content","padding","border","margin","position"])if(!("margin"===M&&E[T.propertyForName("display").value])&&!("padding"===M&&I[T.propertyForName("display").value])&&!("position"===M&&R[T.propertyForName("position").value])){var L=document.createElement("div");if(L.className=M,L._name=M,L.addEventListener("mouseover",this._highlightDOMNode.bind(this,!0,"position"===M?"all":M),!1),this._boxElements.push(L),"content"===M){let ae=C.call(this,"width"),ie=C.call(this,"height");L.append(ae," \xD7 ",ie)}else{var D=document.createElement("div");D.className="label",D.textContent=M,L.appendChild(D),L.appendChild(S.call(this,M,"top")),L.appendChild(document.createElement("br")),L.appendChild(S.call(this,M,"left")),N&&L.appendChild(N),L.appendChild(S.call(this,M,"right")),L.appendChild(document.createElement("br")),L.appendChild(S.call(this,M,"bottom"))}N=L}f.appendChild(N),f.addEventListener("mouseover",this._highlightDOMNode.bind(this,!1,""),!1),this.hideEmptyMessage(),this.element.appendChild(f)}_startEditing(_,S,C){if(!WebInspector.isBeingEdited(_)){_.title&&(_.textContent=_.title);var T={box:S,styleProperty:C},E=this._handleKeyDown.bind(this,T,C);T.keyDownHandler=E,_.addEventListener("keydown",E,!1),this._isEditingMetrics=!0;var I=new WebInspector.EditingConfig(this._editingCommitted.bind(this),this._editingCancelled.bind(this),T);WebInspector.startEditing(_,I),window.getSelection().setBaseAndExtent(_,0,_,1)}}_alteredFloatNumber(_,S){var C="Up"===S.keyIdentifier||"Down"===S.keyIdentifier,f=1;S.shiftKey&&!C?f=100:S.shiftKey||!C?f=10:S.altKey&&(f=0.1),("Down"===S.keyIdentifier||"PageDown"===S.keyIdentifier)&&(f*=-1);var T=+(_+f).toFixed(6);return(T+"").match(WebInspector.EditingSupport.NumberRegex)?T:null}_handleKeyDown(_,S,C){if(/^(?:Page)?(?:Up|Down)$/.test(C.keyIdentifier)){var f=C.currentTarget,T=window.getSelection();if(T.rangeCount){var E=T.getRangeAt(0);if(E.commonAncestorContainer.isSelfOrDescendant(f)){var I=f.textContent,R=E.startContainer.rangeOfWord(E.startOffset,WebInspector.EditingSupport.StyleValueDelimiters,f),N=R.toString(),L=WebInspector.EditingSupport.NumberRegex.exec(N),D;if(L&&L.length){var M=L[1],P=L[3],O=this._alteredFloatNumber(parseFloat(L[2]),C);if(null===O)return;"margin"!==S&&0>O&&(O=0),D=M+O+P}if(D){var F=document.createTextNode(D);R.deleteContents(),R.insertNode(F);var V=document.createRange();V.setStart(F,0),V.setEnd(F,D.length),T.removeAllRanges(),T.addRange(V),C.handled=!0,C.preventDefault(),this._ignoreNextRefresh=!0,this._applyUserInput(f,D,I,_,!1)}}}}}_editingEnded(_,S){_.removeEventListener("keydown",S.keyDownHandler,!1),this._isEditingMetrics=!1}_editingCancelled(_,S){this._editingEnded(_,S),this._refresh()}_applyUserInput(_,S,C,f,T){if(T&&S===C)return void this._editingCancelled(_,f);"position"===f.box||S&&S!==figureDash?"position"===f.box&&(!S||S===figureDash)&&(S="auto"):S="0px",S=S.toLowerCase(),/^-?(?:\d+(?:\.\d+)?|\.\d+)$/.test(S)&&(S+="px");var I=f.styleProperty,R=this._nodeStyles.computedStyle;if("border-box"===R.propertyForName("box-sizing").value&&("width"===I||"height"===I)){if(!S.match(/px$/))return void console.error("For elements with box-sizing: border-box, only absolute content area dimensions can be applied");var N=this._getBox(R,"border"),L=this._getBox(R,"padding"),D=+S.replace(/px$/,"");if(isNaN(D))return;D+="width"===I?N.left+N.right+L.left+L.right:N.top+N.bottom+L.top+L.bottom,S=D+"px"}WebInspector.RemoteObject.resolveNode(this._nodeStyles.node,"",function(M){M&&(M.callFunction(function(F,V){this.style.setProperty(F,V,"important")},[I,S],!1,function(){this._nodeStyles.refresh()}.bind(this)),M.release())}.bind(this))}_editingCommitted(_,S,C,f){this._editingEnded(_,f),this._applyUserInput(_,S,C,f,!0)}},WebInspector.BreakpointActionView=class extends WebInspector.Object{constructor(_,S,C){super(),this._action=_,this._delegate=S,this._element=document.createElement("div"),this._element.className="breakpoint-action-block";var f=this._element.appendChild(document.createElement("div"));f.className="breakpoint-action-block-header";var T=f.appendChild(document.createElement("select"));for(var E in T.addEventListener("change",this._pickerChanged.bind(this)),WebInspector.BreakpointAction.Type){var I=WebInspector.BreakpointAction.Type[E],R=document.createElement("option");R.textContent=WebInspector.BreakpointActionView.displayStringForType(I),R.selected=this._action.type===I,R.value=I,T.add(R)}let N=f.appendChild(document.createElement("div"));N.classList.add("breakpoint-action-button-container");let L=N.appendChild(document.createElement("button"));L.className="breakpoint-action-append-button",L.addEventListener("click",this._appendActionButtonClicked.bind(this)),L.title=WebInspector.UIString("Add new breakpoint action after this action");let D=N.appendChild(document.createElement("button"));D.className="breakpoint-action-remove-button",D.addEventListener("click",this._removeAction.bind(this)),D.title=WebInspector.UIString("Remove this breakpoint action"),this._bodyElement=this._element.appendChild(document.createElement("div")),this._bodyElement.className="breakpoint-action-block-body",this._updateBody(C)}static displayStringForType(_){return _===WebInspector.BreakpointAction.Type.Log?WebInspector.UIString("Log Message"):_===WebInspector.BreakpointAction.Type.Evaluate?WebInspector.UIString("Evaluate JavaScript"):_===WebInspector.BreakpointAction.Type.Sound?WebInspector.UIString("Play Sound"):_===WebInspector.BreakpointAction.Type.Probe?WebInspector.UIString("Probe Expression"):""}get action(){return this._action}get element(){return this._element}_pickerChanged(_){var S=_.target.value;this._action=this._action.breakpoint.recreateAction(S,this._action),this._updateBody(),this._delegate.breakpointActionViewResized(this)}_appendActionButtonClicked(){var S=this._action.breakpoint.createAction(this._action.type,this._action);this._delegate.breakpointActionViewAppendActionView(this,S)}_removeAction(){this._action.breakpoint.removeAction(this._action),this._delegate.breakpointActionViewRemoveActionView(this)}_updateBody(_){switch(this._bodyElement.removeChildren(),this._action.type){case WebInspector.BreakpointAction.Type.Log:this._bodyElement.hidden=!1;var S=this._bodyElement.appendChild(document.createElement("input"));S.placeholder=WebInspector.UIString("Message"),S.addEventListener("change",this._logInputChanged.bind(this)),S.value=this._action.data||"",S.spellcheck=!1,_||setTimeout(function(){S.focus()},0);var C=this._bodyElement.appendChild(document.createElement("div"));C.classList.add("description"),C.setAttribute("dir","ltr"),C.textContent=WebInspector.UIString("${expr} = expression");break;case WebInspector.BreakpointAction.Type.Evaluate:case WebInspector.BreakpointAction.Type.Probe:this._bodyElement.hidden=!1;var f=this._bodyElement.appendChild(document.createElement("div"));f.classList.add("breakpoint-action-eval-editor"),f.classList.add(WebInspector.SyntaxHighlightedStyleClassName),this._codeMirror=WebInspector.CodeMirrorEditor.create(f,{lineWrapping:!0,mode:"text/javascript",indentWithTabs:!0,indentUnit:4,matchBrackets:!0,value:this._action.data||""}),this._codeMirror.on("viewportChange",this._codeMirrorViewportChanged.bind(this)),this._codeMirror.on("blur",this._codeMirrorBlurred.bind(this)),this._codeMirrorViewport={from:null,to:null};var T=new WebInspector.CodeMirrorCompletionController(this._codeMirror);T.addExtendedCompletionProvider("javascript",WebInspector.javaScriptRuntimeCompletionProvider),setTimeout(()=>{this._codeMirror.refresh(),_||this._codeMirror.focus()},0);break;case WebInspector.BreakpointAction.Type.Sound:this._bodyElement.hidden=!0;break;default:this._bodyElement.hidden=!0;}}_logInputChanged(_){this._action.data=_.target.value}_codeMirrorBlurred(){this._action.data=(this._codeMirror.getValue()||"").trim()}_codeMirrorViewportChanged(_,S,C){this._codeMirrorViewport.from===S&&this._codeMirrorViewport.to===C||(this._codeMirrorViewport.from=S,this._codeMirrorViewport.to=C,this._delegate.breakpointActionViewResized(this))}},WebInspector.BreakpointTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S,C){S||(S=WebInspector.BreakpointTreeElement.GenericLineIconStyleClassName),super(["breakpoint",S],C,null,_,!1),this._breakpoint=_,this._probeSet=null,this._listenerSet=new WebInspector.EventListenerSet(this,"BreakpointTreeElement listeners"),C||this._listenerSet.register(_,WebInspector.Breakpoint.Event.LocationDidChange,this._breakpointLocationDidChange),this._listenerSet.register(_,WebInspector.Breakpoint.Event.DisabledStateDidChange,this._updateStatus),this._listenerSet.register(_,WebInspector.Breakpoint.Event.AutoContinueDidChange,this._updateStatus),this._listenerSet.register(_,WebInspector.Breakpoint.Event.ResolvedStateDidChange,this._updateStatus),this._listenerSet.register(WebInspector.debuggerManager,WebInspector.DebuggerManager.Event.BreakpointsEnabledDidChange,this._updateStatus),this._listenerSet.register(WebInspector.probeManager,WebInspector.ProbeManager.Event.ProbeSetAdded,this._probeSetAdded),this._listenerSet.register(WebInspector.probeManager,WebInspector.ProbeManager.Event.ProbeSetRemoved,this._probeSetRemoved),this._statusImageElement=document.createElement("img"),this._statusImageElement.className=WebInspector.BreakpointTreeElement.StatusImageElementStyleClassName,this._listenerSet.register(this._statusImageElement,"mousedown",this._statusImageElementMouseDown),this._listenerSet.register(this._statusImageElement,"click",this._statusImageElementClicked),C||this._updateTitles(),this._updateStatus(),this.status=this._statusImageElement,this._iconAnimationLayerElement=document.createElement("span"),this.iconElement.appendChild(this._iconAnimationLayerElement)}get breakpoint(){return this._breakpoint}get filterableData(){return{text:[this.breakpoint.contentIdentifier]}}ondelete(){return!!WebInspector.debuggerManager.isBreakpointRemovable(this._breakpoint)&&(this.__deletedViaDeleteKeyboardShortcut=!0,WebInspector.debuggerManager.removeBreakpoint(this._breakpoint),!0)}onenter(){return this._breakpoint.cycleToNextMode(),!0}onspace(){return this._breakpoint.cycleToNextMode(),!0}onattach(){super.onattach(),this._listenerSet.install();for(var _ of WebInspector.probeManager.probeSets)_.breakpoint===this._breakpoint&&this._addProbeSet(_)}ondetach(){super.ondetach(),this._listenerSet.uninstall(),this._probeSet&&this._removeProbeSet(this._probeSet)}populateContextMenu(_,S){WebInspector.breakpointPopoverController.appendContextMenuItems(_,this._breakpoint,this._statusImageElement),super.populateContextMenu(_,S)}removeStatusImage(){this._statusImageElement.remove(),this._statusImageElement=null}_updateTitles(){var _=this._breakpoint.sourceCodeLocation,S=_.displayLineNumber,C=_.displayColumnNumber;this.mainTitle=0<C?WebInspector.UIString("Line %d:%d").format(S+1,C+1):WebInspector.UIString("Line %d").format(S+1),_.hasMappedLocation()&&(this.subtitle=_.formattedLocationString(),_.hasFormattedLocation()?this.subtitleElement.classList.add(WebInspector.BreakpointTreeElement.FormattedLocationStyleClassName):this.subtitleElement.classList.remove(WebInspector.BreakpointTreeElement.FormattedLocationStyleClassName),this.tooltip=this.mainTitle+" \u2014 "+WebInspector.UIString("originally %s").format(_.originalLocationString()))}_updateStatus(){this._statusImageElement&&(this._breakpoint.disabled?this._statusImageElement.classList.add(WebInspector.BreakpointTreeElement.StatusImageDisabledStyleClassName):this._statusImageElement.classList.remove(WebInspector.BreakpointTreeElement.StatusImageDisabledStyleClassName),this._breakpoint.autoContinue?this._statusImageElement.classList.add(WebInspector.BreakpointTreeElement.StatusImageAutoContinueStyleClassName):this._statusImageElement.classList.remove(WebInspector.BreakpointTreeElement.StatusImageAutoContinueStyleClassName),this._breakpoint.resolved&&WebInspector.debuggerManager.breakpointsEnabled?this._statusImageElement.classList.add(WebInspector.BreakpointTreeElement.StatusImageResolvedStyleClassName):this._statusImageElement.classList.remove(WebInspector.BreakpointTreeElement.StatusImageResolvedStyleClassName))}_addProbeSet(_){this._probeSet=_,_.addEventListener(WebInspector.ProbeSet.Event.SamplesCleared,this._samplesCleared,this),_.dataTable.addEventListener(WebInspector.ProbeSetDataTable.Event.FrameInserted,this._dataUpdated,this)}_removeProbeSet(_){_.removeEventListener(WebInspector.ProbeSet.Event.SamplesCleared,this._samplesCleared,this),_.dataTable.removeEventListener(WebInspector.ProbeSetDataTable.Event.FrameInserted,this._dataUpdated,this),this._probeSet=null}_probeSetAdded(_){var S=_.data.probeSet;S.breakpoint===this._breakpoint&&this._addProbeSet(S)}_probeSetRemoved(_){var S=_.data.probeSet;S.breakpoint===this._breakpoint&&this._removeProbeSet(S)}_samplesCleared(_){var S=_.data.oldTable;S.removeEventListener(WebInspector.ProbeSetDataTable.Event.FrameInserted,this._dataUpdated,this),this._probeSet.dataTable.addEventListener(WebInspector.ProbeSetDataTable.Event.FrameInserted,this._dataUpdated,this)}_dataUpdated(){return this.element.classList.contains(WebInspector.BreakpointTreeElement.ProbeDataUpdatedStyleClassName)?(clearTimeout(this._removeIconAnimationTimeoutIdentifier),this.element.classList.remove(WebInspector.BreakpointTreeElement.ProbeDataUpdatedStyleClassName),void window.requestAnimationFrame(this._dataUpdated.bind(this))):void(this.element.classList.add(WebInspector.BreakpointTreeElement.ProbeDataUpdatedStyleClassName),this._removeIconAnimationTimeoutIdentifier=setTimeout(()=>{this.element.classList.remove(WebInspector.BreakpointTreeElement.ProbeDataUpdatedStyleClassName)},WebInspector.BreakpointTreeElement.ProbeDataUpdatedAnimationDuration))}_breakpointLocationDidChange(_){_.data.oldDisplaySourceCode===this._breakpoint.displaySourceCode||this._updateTitles()}_statusImageElementMouseDown(_){_.stopPropagation()}_statusImageElementClicked(){this._breakpoint.cycleToNextMode()}},WebInspector.BreakpointTreeElement.GenericLineIconStyleClassName="breakpoint-generic-line-icon",WebInspector.BreakpointTreeElement.StatusImageElementStyleClassName="status-image",WebInspector.BreakpointTreeElement.StatusImageResolvedStyleClassName="resolved",WebInspector.BreakpointTreeElement.StatusImageAutoContinueStyleClassName="auto-continue",WebInspector.BreakpointTreeElement.StatusImageDisabledStyleClassName="disabled",WebInspector.BreakpointTreeElement.FormattedLocationStyleClassName="formatted-location",WebInspector.BreakpointTreeElement.ProbeDataUpdatedStyleClassName="data-updated",WebInspector.BreakpointTreeElement.ProbeDataUpdatedAnimationDuration=400,WebInspector.ButtonToolbarItem=class extends WebInspector.ButtonNavigationItem{constructor(_,S,C,f,T){super(_,S,f,16,16,T),"string"==typeof C&&(this._labelElement=document.createElement("div"),this._labelElement.className=WebInspector.ButtonToolbarItem.LabelStyleClassName,this._element.appendChild(this._labelElement),this.label=C)}get label(){return this._labelElement.textContent}set label(_){_&&this._labelElement&&(this._labelElement.textContent=_)}},WebInspector.ButtonToolbarItem.LabelStyleClassName="label",WebInspector.CSSStyleDeclarationSection=class extends WebInspector.Object{constructor(_,S){if(super(),this._delegate=_||null,this._style=S||null,this._selectorElements=[],this._ruleDisabled=!1,this._hasInvalidSelector=!1,this._element=document.createElement("div"),this._element.classList.add("style-declaration-section"),new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl,"S",this._save.bind(this),this._element),new WebInspector.KeyboardShortcut(WebInspector.KeyboardShortcut.Modifier.CommandOrControl|WebInspector.KeyboardShortcut.Modifier.Shift,"S",this._save.bind(this),this._element),this._headerElement=document.createElement("div"),this._headerElement.classList.add("header"),!S.editable){let f=this._headerElement.createChild("img","locked-icon"),T;T=S.ownerRule&&S.ownerRule.type===WebInspector.CSSStyleSheet.Type.UserAgent?WebInspector.UIString("User Agent Stylesheet"):WebInspector.UIString("Style rule"),f.title=WebInspector.UIString("%s cannot be modified").format(T)}this._iconElement=this._headerElement.createChild("img","icon"),this.selectorEditable&&(this._selectorInput=this._headerElement.createChild("textarea"),this._selectorInput.spellcheck=!1,this._selectorInput.dir="ltr",this._selectorInput.tabIndex=-1,this._selectorInput.addEventListener("mouseover",this._handleMouseOver.bind(this)),this._selectorInput.addEventListener("mousemove",this._handleMouseMove.bind(this)),this._selectorInput.addEventListener("mouseout",this._handleMouseOut.bind(this)),this._selectorInput.addEventListener("keydown",this._handleKeyDown.bind(this)),this._selectorInput.addEventListener("keypress",this._handleKeyPress.bind(this)),this._selectorInput.addEventListener("input",this._handleInput.bind(this)),this._selectorInput.addEventListener("paste",this._handleSelectorPaste.bind(this)),this._selectorInput.addEventListener("blur",this._handleBlur.bind(this))),this._selectorElement=this._headerElement.createChild("span","selector"),this.selectorEditable||(this._selectorElement.addEventListener("mouseover",this._handleMouseOver.bind(this)),this._selectorElement.addEventListener("mouseout",this._handleMouseOut.bind(this))),this._originElement=this._headerElement.createChild("span","origin"),this._propertiesElement=document.createElement("div"),this._propertiesElement.classList.add("properties"),this._editorActive=!1,this._propertiesTextEditor=new WebInspector.CSSStyleDeclarationTextEditor(this,S),this._propertiesTextEditor.addEventListener(WebInspector.CSSStyleDeclarationTextEditor.Event.ContentChanged,this._editorContentChanged.bind(this)),this._propertiesTextEditor.addEventListener(WebInspector.CSSStyleDeclarationTextEditor.Event.Blurred,this._editorBlurred.bind(this)),this._propertiesElement.appendChild(this._propertiesTextEditor.element),this._element.appendChild(this._headerElement),this._element.appendChild(this._propertiesElement);let C=null;switch(S.type){case WebInspector.CSSStyleDeclaration.Type.Rule:S.inherited?C=WebInspector.CSSStyleDeclarationSection.InheritedStyleRuleIconStyleClassName:S.ownerRule.type===WebInspector.CSSStyleSheet.Type.Author?C=WebInspector.CSSStyleDeclarationSection.AuthorStyleRuleIconStyleClassName:S.ownerRule.type===WebInspector.CSSStyleSheet.Type.User?C=WebInspector.CSSStyleDeclarationSection.UserStyleRuleIconStyleClassName:S.ownerRule.type===WebInspector.CSSStyleSheet.Type.UserAgent?C=WebInspector.CSSStyleDeclarationSection.UserAgentStyleRuleIconStyleClassName:S.ownerRule.type===WebInspector.CSSStyleSheet.Type.Inspector&&(C=WebInspector.CSSStyleDeclarationSection.InspectorStyleRuleIconStyleClassName);break;case WebInspector.CSSStyleDeclaration.Type.Inline:case WebInspector.CSSStyleDeclaration.Type.Attribute:C=S.inherited?WebInspector.CSSStyleDeclarationSection.InheritedElementStyleRuleIconStyleClassName:WebInspector.DOMTreeElementPathComponent.DOMElementIconStyleClassName;}S.editable&&(this._iconElement.classList.add("toggle-able"),this._iconElement.title=WebInspector.UIString("Comment All Properties"),this._iconElement.addEventListener("click",this._handleIconElementClicked.bind(this))),this._element.classList.add(C),S.editable?S.ownerRule?this._style.ownerRule.addEventListener(WebInspector.CSSRule.Event.SelectorChanged,this._updateSelectorIcon.bind(this)):this._element.classList.add(WebInspector.CSSStyleDeclarationSection.SelectorLockedStyleClassName):this._element.classList.add(WebInspector.CSSStyleDeclarationSection.LockedStyleClassName),this.refresh(),this._headerElement.addEventListener("contextmenu",this._handleContextMenuEvent.bind(this))}get element(){return this._element}get style(){return this._style}get lastInGroup(){return this._element.classList.contains(WebInspector.CSSStyleDeclarationSection.LastInGroupStyleClassName)}set lastInGroup(_){_?this._element.classList.add(WebInspector.CSSStyleDeclarationSection.LastInGroupStyleClassName):this._element.classList.remove(WebInspector.CSSStyleDeclarationSection.LastInGroupStyleClassName)}get focused(){return this._propertiesTextEditor.focused}focus(){this._propertiesTextEditor.focus()}refresh(){function _(C,f){let T=document.createElement("span");T.textContent=C.text,f&&T.classList.add(WebInspector.CSSStyleDeclarationSection.MatchedSelectorElementStyleClassName);let E=C.specificity;if(E){let I=WebInspector.UIString("Specificity: (%d, %d, %d)").format(E[0],E[1],E[2]);C.dynamic&&(I+="\n",I+=this._style.inherited?WebInspector.UIString("Dynamically calculated for the parent element"):WebInspector.UIString("Dynamically calculated for the selected element")),T.title=I}else if(C.dynamic){let I=WebInspector.UIString("Specificity: No value for selected element");I+="\n",I+=WebInspector.UIString("Dynamically calculated for the selected element and did not match"),T.title=I}this._selectorElement.appendChild(T),this._selectorElements.push(T)}function S(C){let f=document.createElement("span");f.textContent=C,f.classList.add(WebInspector.CSSStyleDeclarationSection.MatchedSelectorElementStyleClassName),this._selectorElement.appendChild(f)}switch(this._selectorElement.removeChildren(),this._originElement.removeChildren(),this._selectorElements=[],this._originElement.append(` ${emDash} `),this._style.type){case WebInspector.CSSStyleDeclaration.Type.Rule:let C=this._style.ownerRule.selectors,f=this._style.ownerRule.matchedSelectorIndices,T=!f.length;if(C.length){let E=!1;for(let I=0;I<C.length;++I)_.call(this,C[I],T||f.includes(I)),I<C.length-1&&this._selectorElement.append(", "),f.includes(I)&&C[I].isPseudoElementSelector()&&(E=!0);this._element.classList.toggle(WebInspector.CSSStyleDeclarationSection.PseudoElementSelectorStyleClassName,E)}else S.call(this,this._style.ownerRule.selectorText);if(this._style.ownerRule.sourceCodeLocation){let E={dontFloat:!0,ignoreNetworkTab:!0,ignoreSearchTab:!0};this._style.ownerStyleSheet.isInspectorStyleSheet()&&(E.nameStyle=WebInspector.SourceCodeLocation.NameStyle.None,E.prefix=WebInspector.UIString("Inspector Style Sheet")+":");let I=WebInspector.createSourceCodeLocationLink(this._style.ownerRule.sourceCodeLocation,E);this._originElement.appendChild(I)}else{let E;switch(this._style.ownerRule.type){case WebInspector.CSSStyleSheet.Type.Author:E=WebInspector.UIString("Author Stylesheet");break;case WebInspector.CSSStyleSheet.Type.User:E=WebInspector.UIString("User Stylesheet");break;case WebInspector.CSSStyleSheet.Type.UserAgent:E=WebInspector.UIString("User Agent Stylesheet");break;case WebInspector.CSSStyleSheet.Type.Inspector:E=WebInspector.UIString("Web Inspector");}E&&this._originElement.append(E)}break;case WebInspector.CSSStyleDeclaration.Type.Inline:S.call(this,this._style.node.displayName),this._originElement.append(WebInspector.UIString("Style Attribute"));break;case WebInspector.CSSStyleDeclaration.Type.Attribute:S.call(this,this._style.node.displayName),this._originElement.append(WebInspector.UIString("HTML Attributes"));}this._updateSelectorIcon(),this._selectorInput&&(this._selectorInput.value=this._selectorElement.textContent)}refreshEditor(){this._propertiesTextEditor.refresh()}highlightProperty(_){return!!this._propertiesTextEditor.highlightProperty(_)&&(this._element.scrollIntoView(),!0)}findMatchingPropertiesAndSelectors(_){this._element.classList.remove(WebInspector.CSSStyleDetailsSidebarPanel.NoFilterMatchInSectionClassName,WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchingSectionHasLabelClassName);var S=!1;for(var C of this._selectorElements)C.classList.remove(WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchSectionClassName),_&&C.textContent.includes(_)&&(C.classList.add(WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchSectionClassName),S=!0);if(!_)return this._propertiesTextEditor.resetFilteredProperties(),!1;var f=this._propertiesTextEditor.findMatchingProperties(_);return f||S||(this._element.classList.add(WebInspector.CSSStyleDetailsSidebarPanel.NoFilterMatchInSectionClassName),!1)}updateLayout(){this._propertiesTextEditor.updateLayout()}clearSelection(){this._propertiesTextEditor.clearSelection()}cssStyleDeclarationTextEditorFocused(){"function"==typeof this._delegate.cssStyleDeclarationSectionEditorFocused&&this._delegate.cssStyleDeclarationSectionEditorFocused(this)}cssStyleDeclarationTextEditorSwitchRule(_){this._delegate&&(_&&"function"==typeof this._delegate.cssStyleDeclarationSectionEditorPreviousRule?this._delegate.cssStyleDeclarationSectionEditorPreviousRule(this):!_&&"function"==typeof this._delegate.cssStyleDeclarationSectionEditorNextRule&&this._delegate.cssStyleDeclarationSectionEditorNextRule(this))}focusRuleSelector(_){if(!this.selectorEditable&&!this.locked)return void this.focus();if(this.locked)return void this.cssStyleDeclarationTextEditorSwitchRule(_);let S=window.getSelection();if(S.removeAllRanges(),this._element.scrollIntoViewIfNeeded(),this._selectorInput)this._selectorInput.focus(),this._selectorInput.selectionStart=0,this._selectorInput.selectionEnd=this._selectorInput.value.length;else{let C=document.createRange();C.selectNodeContents(this._selectorElement),S.addRange(C)}}selectLastProperty(){this._propertiesTextEditor.selectLastProperty()}get selectorEditable(){return!this.locked&&this._style.ownerRule}get locked(){return!this._style.editable}get editorActive(){return this._editorActive}get _currentSelectorText(){let _=this.selectorEditable?this._selectorInput.value:this._selectorElement.textContent;if(!_||!_.length){if(!this._style.ownerRule)return"";_=this._style.ownerRule.selectorText}return _.trim()}_handleSelectorPaste(_){function S(E){let I=/[\{\}]/;if(!I.test(E))return[];let R=E.match(/([^{]+){([\s\S]*)}/);return R?I.test(R[2])?S(R[2]):R:[]}if(this._style.type!==WebInspector.CSSStyleDeclaration.Type.Inline&&this._style.ownerRule&&_&&_.clipboardData){let C=_.clipboardData.getData("text/plain");if(C){let[f,T]=S(C);f&&T&&(this._style.nodeStyles.changeRule(this._style.ownerRule,f.trim(),T),_.preventDefault())}}}_handleContextMenuEvent(_){if(!window.getSelection().toString().length){let S=WebInspector.ContextMenu.createFromEvent(_);if((S.appendItem(WebInspector.UIString("Copy Rule"),()=>{InspectorFrontendHost.copyText(this._style.generateCSSRuleString())}),!this._style.inherited)&&(S.appendItem(WebInspector.UIString("Duplicate Selector"),()=>{if(this._delegate&&"function"==typeof this._delegate.focusEmptySectionWithStyle){let C=this._style.nodeStyles.rulesForSelector(this._currentSelectorText);for(let f of C)if(this._delegate.focusEmptySectionWithStyle(f.style))return}this._style.nodeStyles.addRule(this._currentSelectorText)}),!WebInspector.CSSStyleManager.PseudoElementNames.some(C=>this._style.selectorText.includes(":"+C)))){if(WebInspector.CSSStyleManager.ForceablePseudoClasses.every(C=>!this._style.selectorText.includes(":"+C))){S.appendSeparator();for(let C of WebInspector.CSSStyleManager.ForceablePseudoClasses)if("visited"!==C||"A"===this._style.node.nodeName()){let oe=":"+C;S.appendItem(WebInspector.UIString("Add %s Rule").format(oe),()=>{this._style.node.setPseudoClassEnabled(C,!0);let se;se=this._style.ownerRule?this._style.ownerRule.selectors.map(de=>de.text+oe).join(", "):this._currentSelectorText+oe,this._style.nodeStyles.addRule(se)})}}S.appendSeparator();for(let C of WebInspector.CSSStyleManager.PseudoElementNames){let f="::"+C;let E=null;if(this._delegate&&"function"==typeof this._delegate.sectionForStyle){let R=this._style.nodeStyles.rulesForSelector(this._currentSelectorText+f);R.length&&(E=this._delegate.sectionForStyle(R[0].style))}let I=E?WebInspector.UIString("Focus %s Rule"):WebInspector.UIString("Create %s Rule");S.appendItem(I.format(f),()=>{if(E)return void E.focus();let R;R=this._style.ownerRule?this._style.ownerRule.selectors.map(N=>N.text+f).join(", "):this._currentSelectorText+f,this._style.nodeStyles.addRule(R,"content: \"\";")})}}}}_handleIconElementClicked(){return this._hasInvalidSelector?void this.refresh():void(this._ruleDisabled=this._ruleDisabled?!this._propertiesTextEditor.uncommentAllProperties():this._propertiesTextEditor.commentAllProperties(),this._iconElement.title=this._ruleDisabled?WebInspector.UIString("Uncomment All Properties"):WebInspector.UIString("Comment All Properties"),this._element.classList.toggle("rule-disabled",this._ruleDisabled))}_highlightNodesWithSelector(){return this._style.ownerRule?void WebInspector.domTreeManager.highlightSelector(this._currentSelectorText,this._style.node.ownerDocument.frameIdentifier):void WebInspector.domTreeManager.highlightDOMNode(this._style.node.id)}_hideDOMNodeHighlight(){WebInspector.domTreeManager.hideDOMNodeHighlight()}_handleMouseOver(){this._highlightNodesWithSelector()}_handleMouseMove(_){if(!this._hasInvalidSelector){for(let S of this._selectorElements){let{top:C,right:f,bottom:T,left:E}=S.getBoundingClientRect();if(_.clientX>=E&&_.clientX<=f&&_.clientY>=C&&_.clientY<=T)return void(this._selectorInput.title=S.title)}this._selectorInput.title=""}}_handleMouseOut(){this._hideDOMNodeHighlight()}_save(_){if(_.preventDefault(),_.stopPropagation(),this._style.type!==WebInspector.CSSStyleDeclaration.Type.Rule)return void InspectorFrontendHost.beep();let S=this._style.ownerRule.sourceCodeLocation.sourceCode;if(S.type!==WebInspector.Resource.Type.Stylesheet)return void InspectorFrontendHost.beep();var C;if("data"===S.urlComponents.scheme){let T=WebInspector.frameResourceManager.mainFrame.mainResource,E=T.url.slice(0,-T.urlComponents.lastPathComponent.length);C=E+"base64.css"}else C=S.url;const f=_.shiftKey;WebInspector.saveDataToFile({url:C,content:S.content},f)}_handleKeyDown(_){return _.keyCode===WebInspector.KeyboardShortcut.Key.Enter.keyCode?(_.preventDefault(),void this.focus()):_.keyCode===WebInspector.KeyboardShortcut.Key.Tab.keyCode?_.shiftKey&&this._delegate&&"function"==typeof this._delegate.cssStyleDeclarationSectionEditorPreviousRule?(_.preventDefault(),void this._delegate.cssStyleDeclarationSectionEditorPreviousRule(this,!0)):_.metaKey?void 0:(_.preventDefault(),this.focus(),void this._propertiesTextEditor.selectFirstProperty()):void this._highlightNodesWithSelector()}_handleKeyPress(_){_.altGraphKey||_.altKey||_.ctrlKey||_.metaKey||this._selectorElement.append(String.fromCharCode(_.keyCode))}_handleInput(){this._selectorElement.textContent=this._selectorInput.value,this._highlightNodesWithSelector()}_handleBlur(_){this._hideDOMNodeHighlight();let S=this._currentSelectorText.trim();return S?void(_.relatedTarget&&_.relatedTarget.isDescendant(this.element)&&(this._editorActive=!0,this.focus()),this._style.ownerRule.selectorText=S):void this.refresh()}_updateSelectorIcon(_){if(this._style.ownerRule&&this._style.editable)return this._hasInvalidSelector=_&&_.data&&!_.data.valid,this._element.classList.toggle("invalid-selector",!!this._hasInvalidSelector),this._hasInvalidSelector?(this._iconElement.title=WebInspector.UIString("The selector \u201C%s\u201D is invalid.\nClick to revert to the previous selector.").format(this._selectorElement.textContent.trim()),void(this._selectorInput.title=WebInspector.UIString("Using previous selector \u201C%s\u201D").format(this._style.ownerRule.selectorText))):void(this._iconElement.title=this._ruleDisabled?WebInspector.UIString("Uncomment All Properties"):WebInspector.UIString("Comment All Properties"),this._selectorInput.title="")}_editorContentChanged(){this._editorActive=!0}_editorBlurred(){this._editorActive=!1,this.dispatchEventToListeners(WebInspector.CSSStyleDeclarationSection.Event.Blurred)}},WebInspector.CSSStyleDeclarationSection.Event={Blurred:"css-style-declaration-sections-blurred"},WebInspector.CSSStyleDeclarationSection.LockedStyleClassName="locked",WebInspector.CSSStyleDeclarationSection.SelectorLockedStyleClassName="selector-locked",WebInspector.CSSStyleDeclarationSection.LastInGroupStyleClassName="last-in-group",WebInspector.CSSStyleDeclarationSection.MatchedSelectorElementStyleClassName="matched",WebInspector.CSSStyleDeclarationSection.PseudoElementSelectorStyleClassName="pseudo-element-selector",WebInspector.CSSStyleDeclarationSection.AuthorStyleRuleIconStyleClassName="author-style-rule-icon",WebInspector.CSSStyleDeclarationSection.UserStyleRuleIconStyleClassName="user-style-rule-icon",WebInspector.CSSStyleDeclarationSection.UserAgentStyleRuleIconStyleClassName="user-agent-style-rule-icon",WebInspector.CSSStyleDeclarationSection.InspectorStyleRuleIconStyleClassName="inspector-style-rule-icon",WebInspector.CSSStyleDeclarationSection.InheritedStyleRuleIconStyleClassName="inherited-style-rule-icon",WebInspector.CSSStyleDeclarationSection.InheritedElementStyleRuleIconStyleClassName="inherited-element-style-rule-icon",WebInspector.CSSStyleDeclarationTextEditor=class extends WebInspector.View{constructor(_,S){super(),this.element.classList.add(WebInspector.CSSStyleDeclarationTextEditor.StyleClassName),this.element.classList.add(WebInspector.SyntaxHighlightedStyleClassName),this.element.addEventListener("mousedown",this._handleMouseDown.bind(this),!0),this.element.addEventListener("mouseup",this._handleMouseUp.bind(this)),this._mouseDownCursorPosition=null,this._propertyVisibilityMode=WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.ShowAll,this._showsImplicitProperties=!0,this._alwaysShowPropertyNames={},this._filterResultPropertyNames=null,this._sortProperties=!1,this._hasActiveInlineSwatchEditor=!1,this._linePrefixWhitespace="",this._delegate=_||null,this._codeMirror=WebInspector.CodeMirrorEditor.create(this.element,{readOnly:!0,lineWrapping:!0,mode:"css-rule",electricChars:!1,indentWithTabs:!1,indentUnit:4,smartIndent:!1,matchBrackets:!0,autoCloseBrackets:!0}),this._codeMirror.addKeyMap({Enter:this._handleEnterKey.bind(this),"Shift-Enter":this._insertNewlineAfterCurrentLine.bind(this),"Shift-Tab":this._handleShiftTabKey.bind(this),Tab:this._handleTabKey.bind(this)}),this._completionController=new WebInspector.CodeMirrorCompletionController(this._codeMirror,this),this._tokenTrackingController=new WebInspector.CodeMirrorTokenTrackingController(this._codeMirror,this),this._completionController.noEndingSemicolon=!0,this._jumpToSymbolTrackingModeEnabled=!1,this._tokenTrackingController.classNameForHighlightedRange=WebInspector.CodeMirrorTokenTrackingController.JumpToSymbolHighlightStyleClassName,this._tokenTrackingController.mouseOverDelayDuration=0,this._tokenTrackingController.mouseOutReleaseDelayDuration=0,this._tokenTrackingController.mode=WebInspector.CodeMirrorTokenTrackingController.Mode.NonSymbolTokens,this._codeMirror.on("change",this._contentChanged.bind(this)),this._codeMirror.on("blur",this._editorBlured.bind(this)),this._codeMirror.on("beforeChange",this._handleBeforeChange.bind(this)),"function"==typeof this._delegate.cssStyleDeclarationTextEditorFocused&&this._codeMirror.on("focus",this._editorFocused.bind(this)),this.style=S,this._shownProperties=[],WebInspector.settings.stylesShowInlineWarnings.addEventListener(WebInspector.Setting.Event.Changed,this.refresh,this)}get delegate(){return this._delegate}set delegate(_){this._delegate=_||null}get style(){return this._style}set style(_){this._style===_||(this._style&&(this._style.removeEventListener(WebInspector.CSSStyleDeclaration.Event.PropertiesChanged,this._propertiesChanged,this),WebInspector.notifications.removeEventListener(WebInspector.Notification.GlobalModifierKeysDidChange,this._updateJumpToSymbolTrackingMode,this)),this._style=_||null,this._style&&(this._style.addEventListener(WebInspector.CSSStyleDeclaration.Event.PropertiesChanged,this._propertiesChanged,this),WebInspector.notifications.addEventListener(WebInspector.Notification.GlobalModifierKeysDidChange,this._updateJumpToSymbolTrackingMode,this)),this._updateJumpToSymbolTrackingMode(),this._resetContent())}get shownProperties(){return this._shownProperties}get focused(){return this._codeMirror.getWrapperElement().classList.contains("CodeMirror-focused")}get alwaysShowPropertyNames(){return Object.keys(this._alwaysShowPropertyNames)}set alwaysShowPropertyNames(_){this._alwaysShowPropertyNames=(_||[]).keySet(),this._resetContent()}get propertyVisibilityMode(){return this._propertyVisibilityMode}set propertyVisibilityMode(_){this._propertyVisibilityMode===_||(this._propertyVisibilityMode=_,this._resetContent())}get showsImplicitProperties(){return this._showsImplicitProperties}set showsImplicitProperties(_){this._showsImplicitProperties===_||(this._showsImplicitProperties=_,this._resetContent())}get sortProperties(){return this._sortProperties}set sortProperties(_){this._sortProperties===_||(this._sortProperties=_,this._resetContent())}focus(){this._codeMirror.focus()}refresh(){this._resetContent()}highlightProperty(_){function S(E){return E.enabled&&!E.overridden&&(E.canonicalName===_.canonicalName||C(E))}function C(E){var I=E.relatedLonghandProperties;if(!I.length)return!1;for(var R of I)if(S(R))return!0;return!1}for(var f of this.style.properties)if(S(f)){var T=f.__propertyTextMarker.find();return this._codeMirror.setSelection(T.from,T.to),this.focus(),!0}return!1}clearSelection(){this._codeMirror.setCursor({line:0,ch:0})}findMatchingProperties(_){if(!_)return this.resetFilteredProperties(),!1;var S=this._style.visibleProperties.length?this._style.visibleProperties:this._style.properties,C=[];for(var f of S)C.push(f.text.includes(_));if(!C.includes(!0))return this.resetFilteredProperties(),!1;for(var T=0,f;T<C.length;++T)f=S[T],f.__filterResultClassName=C[T]?WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchSectionClassName:WebInspector.CSSStyleDetailsSidebarPanel.NoFilterMatchInPropertyClassName,this._updateTextMarkerForPropertyIfNeeded(f);return!0}resetFilteredProperties(){var _=this._style.visibleProperties.length?this._style.visibleProperties:this._style.properties;for(var S of _)S.__filterResultClassName&&(S.__filterResultClassName=null,this._updateTextMarkerForPropertyIfNeeded(S))}removeNonMatchingProperties(_){if(this._filterResultPropertyNames=null,!_)return this._resetContent(),!1;var S=[];for(var C of this._style.properties){var f=C.text.getMatchingIndexes(_);f.length&&(S.push(C.name),C.__filterResultClassName=WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchSectionClassName,C.__filterResultNeedlePosition={start:f,length:_.length})}return this._filterResultPropertyNames=S.length?S.keySet():{},this._resetContent(),0<S.length}uncommentAllProperties(){function _(S){if(!S.length)return!1;for(var C of S)C._commentRange&&(this._uncommentRange(C._commentRange),C._commentRange=null);return!0}return _.call(this,this._style.pendingProperties)||_.call(this,this._style.properties)}commentAllProperties(){if(!this._style.hasProperties())return!1;for(var _ of this._style.properties)_.__propertyTextMarker&&this._commentProperty(_);return!0}selectFirstProperty(){var _=this._codeMirror.getLine(0),S=_.trimRight();_&&S.trimLeft().length||this.clearSelection();var C=_.indexOf(":"),f={line:0,ch:0};this._codeMirror.setSelection(f,{line:0,ch:0>C||this._textAtCursorIsComment(this._codeMirror,f)?S.length:C})}selectLastProperty(){var _=this._codeMirror.lineCount()-1,S=this._codeMirror.getLine(_),C=S.trimRight(),f,T;if(this._textAtCursorIsComment(this._codeMirror,{line:_,ch:_.length}))f=0,T=_.length;else{var E=/(?::\s*)/.exec(S);f=E?E.index+E[0].length:0,T=C.length-C.endsWith(";")}this._codeMirror.setSelection({line:_,ch:f},{line:_,ch:T})}completionControllerCompletionsHidden(){var S=this._style.text,C=this._formattedContent();S===C?this._propertiesChanged():this._commitChanges()}completionControllerCompletionsNeeded(_,S,C){let I=this._style.nodeStyles.computedStyle.properties,R=I.filter(L=>L.variable&&L.name.startsWith(S)),N=R.map(L=>L.name);_.updateCompletions(C.concat(N))}layout(){this._codeMirror.refresh()}_textAtCursorIsComment(_,S){var C=_.getTokenTypeAt(S);return C&&C.includes("comment")}_highlightNextNameOrValue(_,S,C){let f=this._rangeForNextNameOrValue(_,S,C);_.setSelection(f.from,f.to)}_rangeForNextNameOrValue(_,S,C){let f=0,T=0;if(this._textAtCursorIsComment(_,S))T=C.length;else{let E=WebInspector.rangeForNextCSSNameOrValue(C,S.ch);f=E.from,T=E.to}return{from:{line:S.line,ch:f},to:{line:S.line,ch:T}}}_handleMouseDown(_){if(!this._codeMirror.options.readOnly){let S=this._codeMirror.coordsChar({left:_.x,top:_.y}),C=this._codeMirror.getLine(S.line);C.trim().length&&(this._mouseDownCursorPosition=S,this._mouseDownCursorPosition.previousRange={from:this._codeMirror.getCursor("from"),to:this._codeMirror.getCursor("to")})}}_handleMouseUp(_){if(!this._codeMirror.options.readOnly&&this._mouseDownCursorPosition){let S=this._codeMirror.coordsChar({left:_.x,top:_.y}),C=!1;for(let f of this._codeMirror.findMarksAt(S))if("bookmark"===f.type&&f.replacedWith===_.target){let le=f.find();if(le.line===S.line&&1>=Math.abs(le.ch-S.ch)){C=!0;break}}if(!C&&this._mouseDownCursorPosition.line===S.line&&this._mouseDownCursorPosition.ch===S.ch){let f=this._codeMirror.getLine(S.line);if(S.ch===f.trimRight().length){let T=this._codeMirror.getLine(S.line+1);if(WebInspector.settings.stylesInsertNewline.value&&S.line<this._codeMirror.lineCount()-1&&(!T||!T.trim().length))this._codeMirror.setCursor({line:S.line+1,ch:0});else{let E=this._codeMirror.getLine(S.line),I=WebInspector.settings.stylesInsertNewline.value?"\n":"";E.trimRight().endsWith(";")||this._textAtCursorIsComment(this._codeMirror,S)||(I=";"+I),this._codeMirror.replaceRange(I,S)}}else if(WebInspector.settings.stylesSelectOnFirstClick.value&&this._mouseDownCursorPosition.previousRange){let T=this._rangeForNextNameOrValue(this._codeMirror,S,f),E=this._mouseDownCursorPosition.previousRange.from.line!==S.line||this._mouseDownCursorPosition.previousRange.to.line!==S.line,I=S.ch>=this._mouseDownCursorPosition.previousRange.from.ch&&S.ch<=this._mouseDownCursorPosition.previousRange.to.ch,R=this._mouseDownCursorPosition.previousRange.from.ch>=T.from.ch&&this._mouseDownCursorPosition.previousRange.to.ch<=T.to.ch;this._codeMirror.hasFocus()&&!E&&(I||R)||this._codeMirror.setSelection(T.from,T.to)}}this._mouseDownCursorPosition=null}}_handleBeforeChange(_,S){if("+delete"!==S.origin||this._completionController.isShowingCompletions())return CodeMirror.Pass;if(!S.to.line&&!S.to.ch){if(1===_.lineCount())return CodeMirror.Pass;var C=_.getLine(S.to.line);return C&&C.trim().length?CodeMirror.Pass:void _.execCommand("deleteLine")}var f=_.findMarksAt(S.to);if(!f.length)return CodeMirror.Pass;for(var T of f)T.clear()}_handleEnterKey(_){var S=_.getCursor(),C=_.getLine(S.line),f=C.trimRight(),T=f.endsWith(";");if(!f.trimLeft().length)return CodeMirror.Pass;if(T&&S.ch===f.length-1&&++S.ch,S.ch===f.length){var E="\n";return T||this._textAtCursorIsComment(this._codeMirror,S)||(E=";"+E),void this._codeMirror.replaceRange(E,S)}return CodeMirror.Pass}_insertNewlineAfterCurrentLine(_){var S=_.getCursor(),C=_.getLine(S.line),f=C.trimRight();if(S.ch=f.length,S.ch){var T="\n";return f.endsWith(";")||this._textAtCursorIsComment(this._codeMirror,S)||(T=";"+T),void this._codeMirror.replaceRange(T,S)}return CodeMirror.Pass}_handleShiftTabKey(_){function S(){return this._delegate&&"function"==typeof this._delegate.cssStyleDeclarationTextEditorSwitchRule?void this._delegate.cssStyleDeclarationTextEditorSwitchRule(!0):CodeMirror.Pass}let C=_.getCursor(),f=_.getLine(C.line),T=_.getLine(C.line-1);if(!f&&!T&&!C.line)return S.call(this);let E=T?T.trimRight():"",I=0,R=f.length,N=this._textAtCursorIsComment(_,C);if(C.ch===f.indexOf(":")||0>f.indexOf(":")||N){if(T){if(--C.line,R=E.length,!this._textAtCursorIsComment(_,C)){let L=/(?::\s*)/.exec(T);I=L?L.index+L[0].length:0,E.includes(";")&&(R=E.lastIndexOf(";"))}return void _.setSelection({line:C.line,ch:I},{line:C.line,ch:R})}return C.line?void _.setCursor(C.line-1,0):S.call(this)}if(!N){let L=/(?:[^:;\s]\s*)+/.exec(f);I=L.index,R=I+L[0].length}_.setSelection({line:C.line,ch:I},{line:C.line,ch:R})}_handleTabKey(_){let C=_.getCursor(),f=_.getLine(C.line),T=f.trimRight(),E=C.line===_.lineCount()-1,I=_.getLine(C.line+1),R=I?I.trimRight():"";if(!T.trimLeft().length)return E?function(){return this._delegate&&"function"==typeof this._delegate.cssStyleDeclarationTextEditorSwitchRule?void this._delegate.cssStyleDeclarationTextEditorSwitchRule():CodeMirror.Pass}.call(this):R.trimLeft().length?(++C.line,void this._highlightNextNameOrValue(_,C,I)):void _.setCursor(C.line+1,0);if(T.endsWith(":"))return _.setCursor(C.line,f.length),void this._completionController._completeAtCurrentPosition(!0);let N=T.endsWith(";"),L=f.includes(";")&&C.ch>=f.lastIndexOf(";");return C.ch>=f.trimRight().length-N||L?void this._completionController.completeAtCurrentPositionIfNeeded().then(function(D){if(D===WebInspector.CodeMirrorCompletionController.UpdatePromise.NoCompletionsFound){let M="";return N||L||this._textAtCursorIsComment(_,C)||(M+=";"),E&&(M+="\n"),M.length&&_.replaceRange(M,{line:C.line,ch:T.length}),I?void this._highlightNextNameOrValue(_,{line:C.line+1,ch:0},I):void _.setCursor(C.line+1,0)}}.bind(this)):void this._highlightNextNameOrValue(_,C,f)}_clearRemoveEditingLineClassesTimeout(){this._removeEditingLineClassesTimeout&&(clearTimeout(this._removeEditingLineClassesTimeout),delete this._removeEditingLineClassesTimeout)}_removeEditingLineClasses(){this._clearRemoveEditingLineClassesTimeout(),this._codeMirror.operation(function(){for(var S=this._codeMirror.lineCount(),C=0;C<S;++C)this._codeMirror.removeLineClass(C,"wrap",WebInspector.CSSStyleDeclarationTextEditor.EditingLineStyleClassName)}.bind(this))}_removeEditingLineClassesSoon(){this._removeEditingLineClassesTimeout||(this._removeEditingLineClassesTimeout=setTimeout(this._removeEditingLineClasses.bind(this),WebInspector.CSSStyleDeclarationTextEditor.RemoveEditingLineClassesDelay))}_formattedContent(){for(var _=WebInspector.CSSStyleDeclarationTextEditor.PrefixWhitespace,S=this._codeMirror.lineCount(),C=0,f;C<S;++C)f=this._codeMirror.getLine(C),_+=this._linePrefixWhitespace+f,C!==S-1&&(_+="\n");return _+=WebInspector.CSSStyleDeclarationTextEditor.SuffixWhitespace,_.replace(/\s*\n\s*\n(\s*)/g,"\n$1")}_commitChanges(){this._commitChangesTimeout&&(clearTimeout(this._commitChangesTimeout),delete this._commitChangesTimeout),this._style.text=this._formattedContent()}_editorBlured(){this._completionController.isHandlingClickEvent()||(this._resetContent(),this.dispatchEventToListeners(WebInspector.CSSStyleDeclarationTextEditor.Event.Blurred))}_editorFocused(){"function"==typeof this._delegate.cssStyleDeclarationTextEditorFocused&&this._delegate.cssStyleDeclarationTextEditorFocused()}_contentChanged(_,S){if(this._style&&this._style.editable&&!this._ignoreCodeMirrorContentDidChangeEvent){this._markLinesWithCheckboxPlaceholder(),this._clearRemoveEditingLineClassesTimeout(),this._codeMirror.addLineClass(S.from.line,"wrap",WebInspector.CSSStyleDeclarationTextEditor.EditingLineStyleClassName),this._completionController.isCompletionChange(S)&&this._createInlineSwatches(!1,S.from.line);var C=S.origin&&"+"===S.origin.charAt(0)?WebInspector.CSSStyleDeclarationTextEditor.CommitCoalesceDelay:0;this._commitChangesTimeout&&clearTimeout(this._commitChangesTimeout),this._commitChangesTimeout=setTimeout(this._commitChanges.bind(this),C),this.dispatchEventToListeners(WebInspector.CSSStyleDeclarationTextEditor.Event.ContentChanged)}}_updateTextMarkers(_){function S(){this._clearTextMarkers(!0),this._iterateOverProperties(!0,function(C){var f=C.styleDeclarationTextRange;if(f){var T={line:f.startLine,ch:f.startColumn},E={line:f.endLine,ch:f.endColumn};T.line--,E.line--,T.ch-=this._linePrefixWhitespace.length,E.ch-=this._linePrefixWhitespace.length,this._createTextMarkerForPropertyIfNeeded(T,E,C)}}),this._codeMirror.getOption("readOnly")||this._codeMirror.eachLine(C=>{this._createCommentedCheckboxMarker(C)}),this._createInlineSwatches(!0),this._markLinesWithCheckboxPlaceholder()}_?S.call(this):this._codeMirror.operation(S.bind(this))}_createCommentedCheckboxMarker(_){var S=_.lineNo();if(S||!isNaN(S)){let C=/\/\*\s*[-\w]+\s*\:\s*(?:(?:\".*\"|url\(.+\)|[^;])\s*)+;?\s*\*\//g;var f=C.exec(_.text);if(f)for(;f;){var T=document.createElement("input");T.type="checkbox",T.checked=!1,T.addEventListener("change",this._propertyCommentCheckboxChanged.bind(this));var E={line:S,ch:f.index},I={line:S,ch:f.index+f[0].length},R=this._codeMirror.setUniqueBookmark(E,T);R.__propertyCheckbox=!0;var N=this._codeMirror.markText(E,I);T.__commentTextMarker=N,f=C.exec(_.text)}}}_createInlineSwatches(_,S){function C(T,E){T.addEventListener(WebInspector.InlineSwatch.Event.ValueChanged,this._inlineSwatchValueChanged,this),T.addEventListener(WebInspector.InlineSwatch.Event.Activated,this._inlineSwatchActivated,this),T.addEventListener(WebInspector.InlineSwatch.Event.Deactivated,this._inlineSwatchDeactivated,this);let N=E.codeMirrorTextMarker,L=N.find();this._codeMirror.setUniqueBookmark(L.from,T.element),T.__textMarker=N,T.__textMarkerRange=L}function f(){let T="number"==typeof S?new WebInspector.TextRange(S,0,S+1,0):null;createCodeMirrorColorTextMarkers(this._codeMirror,T,(E,I,R)=>{let N=new WebInspector.InlineSwatch(WebInspector.InlineSwatch.Type.Color,I,this._codeMirror.getOption("readOnly"));C.call(this,N,E,I,R)}),createCodeMirrorGradientTextMarkers(this._codeMirror,T,(E,I,R)=>{let N=new WebInspector.InlineSwatch(WebInspector.InlineSwatch.Type.Gradient,I,this._codeMirror.getOption("readOnly"));C.call(this,N,E,I,R)}),createCodeMirrorCubicBezierTextMarkers(this._codeMirror,T,(E,I,R)=>{let N=new WebInspector.InlineSwatch(WebInspector.InlineSwatch.Type.Bezier,I,this._codeMirror.getOption("readOnly"));C.call(this,N,E,I,R)}),createCodeMirrorSpringTextMarkers(this._codeMirror,T,(E,I,R)=>{let N=new WebInspector.InlineSwatch(WebInspector.InlineSwatch.Type.Spring,I,this._codeMirror.getOption("readOnly"));C.call(this,N,E,I,R)}),createCodeMirrorVariableTextMarkers(this._codeMirror,T,(E,I,R)=>{let L=this._style.nodeStyles.computedStyle.propertyForName(R,!0);if(!L){let P={line:E.range.startLine,ch:E.range.startColumn},O={line:E.range.endLine,ch:E.range.endColumn};if(this._codeMirror.markText(P,O,{className:"invalid"}),WebInspector.settings.stylesShowInlineWarnings.value){let F=document.createElement("button");F.classList.add("invalid-warning-marker","clickable"),F.title=WebInspector.UIString("The variable \u201C%s\u201D does not exist.\nClick to delete and open autocomplete.").format(R),F.addEventListener("click",()=>{this._codeMirror.replaceRange("",P,O),this._codeMirror.setCursor(P),this._completionController.completeAtCurrentPositionIfNeeded(!0)}),this._codeMirror.setBookmark(P,F)}return}let D=L.value.trim(),M=new WebInspector.InlineSwatch(WebInspector.InlineSwatch.Type.Variable,D,this._codeMirror.getOption("readOnly"));C.call(this,M,E,L,D)})}_?f.call(this):this._codeMirror.operation(f.bind(this))}_updateTextMarkerForPropertyIfNeeded(_){var S=_.__propertyTextMarker;if(S){var C=S.find();C&&this._createTextMarkerForPropertyIfNeeded(C.from,C.to,_)}}_createTextMarkerForPropertyIfNeeded(_,S,C){function T(z){var K=document.createElement("button");K.className="invalid-warning-marker",K.title=z.title,"string"==typeof z.correction&&(K.classList.add("clickable"),K.addEventListener("click",function(){this._codeMirror.replaceRange(z.correction,_,S),z.autocomplete&&(this._codeMirror.setCursor(S),this.focus(),this._completionController._completeAtCurrentPosition(!0))}.bind(this))),this._codeMirror.setBookmark(z.position,K)}function E(z){var K=0;for(var q of this._style.properties)q.name===z&&++K;return K}if(!this._codeMirror.getOption("readOnly")){var I=document.createElement("input");I.type="checkbox",I.checked=!0,I.addEventListener("change",this._propertyCheckboxChanged.bind(this)),I.__cssProperty=C;var R=this._codeMirror.setUniqueBookmark(_,I);R.__propertyCheckbox=!0}else if(this._delegate.cssStyleDeclarationTextEditorShouldAddPropertyGoToArrows&&!C.implicit&&"function"==typeof this._delegate.cssStyleDeclarationTextEditorShowProperty){let z=WebInspector.createGoToArrowButton();z.title=WebInspector.UIString("Option-click to show source");let K=this._delegate;z.addEventListener("click",function(q){K.cssStyleDeclarationTextEditorShowProperty(C,q.altKey)}),this._codeMirror.setUniqueBookmark(S,z)}var N=!1;WebInspector.CSSCompletions.cssNameCompletions&&(N=WebInspector.CSSCompletions.cssNameCompletions.isValidPropertyName(C.name));var L=["css-style-declaration-property"];C.overridden&&L.push("overridden"),C.implicit&&L.push("implicit"),this._style.inherited&&!C.inherited&&L.push("not-inherited"),!C.valid&&C.hasOtherVendorNameOrKeyword()?L.push("other-vendor"):!C.valid&&(!N||function(z){var K=!1;for(var q of this._style.properties)if(q===z)K=!0;else if(q.name===z.name&&K)return!0;return!1}.call(this,C))&&L.push("invalid"),C.enabled||L.push("disabled"),C.__filterResultClassName&&!C.__filterResultNeedlePosition&&L.push(C.__filterResultClassName);var D=L.join(" ");if(C.__propertyTextMarker&&C.__propertyTextMarker.doc.cm===this._codeMirror&&C.__propertyTextMarker.find()){if(C.__propertyTextMarker.className===D)return;C.__propertyTextMarker.clear()}var M=this._codeMirror.markText(_,S,{className:D});if(M.__cssProperty=C,C.__propertyTextMarker=M,C.addEventListener(WebInspector.CSSProperty.Event.OverriddenStatusChanged,this._propertyOverriddenStatusChanged,this),this._removeCheckboxPlaceholder(_.line),C.__filterResultClassName&&C.__filterResultNeedlePosition)for(var P of C.__filterResultNeedlePosition.start){var O={line:_.line,ch:P},F={line:S.line,ch:O.ch+C.__filterResultNeedlePosition.length};this._codeMirror.markText(O,F,{className:C.__filterResultClassName})}if(!(this._codeMirror.getOption("readOnly")||C.hasOtherVendorNameOrKeyword()||C.text.trim().endsWith(":")||!WebInspector.settings.stylesShowInlineWarnings.value)){var V=C.name.startsWith("-webkit-")&&WebInspector.CSSCompletions.cssNameCompletions.isValidPropertyName(C.canonicalName),U=E.call(this,C.name),G;if(V&&!E.call(this,C.canonicalName)?T.call(this,{position:_,title:WebInspector.UIString("The \u201Cwebkit\u201D prefix is not necessary.\nClick to insert a duplicate without the prefix."),correction:C.text+"\n"+C.text.replace("-webkit-",""),autocomplete:!1}):1<U&&(G={position:_,title:WebInspector.UIString("Duplicate property \u201C%s\u201D.\nClick to delete this property.").format(C.name),correction:"",autocomplete:!1}),C.valid)return void(G&&T.call(this,G));if(N){let z={line:_.line,ch:_.ch+C.name.length+2},K={line:S.line,ch:z.ch+C.value.length};if(this._codeMirror.markText(z,K,{className:"invalid"}),/^(?:\d+)$/.test(C.value))G={position:_,title:WebInspector.UIString("The value \u201C%s\u201D needs units.\nClick to add \u201Cpx\u201D to the value.").format(C.value),correction:C.name+": "+C.value+"px;",autocomplete:!1};else{var H=C.value.length?WebInspector.UIString("The value \u201C%s\u201D is not supported for this property.\nClick to delete and open autocomplete.").format(C.value):WebInspector.UIString("This property needs a value.\nClick to open autocomplete.");G={position:_,title:H,correction:C.name+": ",autocomplete:!0}}}else if(!E.call(this,"-webkit-"+C.name)&&WebInspector.CSSCompletions.cssNameCompletions.propertyRequiresWebkitPrefix(C.name))G={position:_,title:WebInspector.UIString("The \u201Cwebkit\u201D prefix is needed for this property.\nClick to insert a duplicate with the prefix."),correction:"-webkit-"+C.text+"\n"+C.text,autocomplete:!1};else if(!V&&!WebInspector.CSSCompletions.cssNameCompletions.isValidPropertyName("-webkit-"+C.name)){var W=WebInspector.CSSCompletions.cssNameCompletions.getClosestPropertyName(C.name);G=W?{position:_,title:WebInspector.UIString("Did you mean \u201C%s\u201D?\nClick to replace.").format(W),correction:C.text.replace(C.name,W),autocomplete:!0}:C.name.startsWith("-webkit-")&&(W=WebInspector.CSSCompletions.cssNameCompletions.getClosestPropertyName(C.canonicalName))?{position:_,title:WebInspector.UIString("Did you mean \u201C%s\u201D?\nClick to replace.").format("-webkit-"+W),correction:C.text.replace(C.canonicalName,W),autocomplete:!0}:{position:_,title:WebInspector.UIString("Unsupported property \u201C%s\u201D").format(C.name),correction:!1,autocomplete:!1}}G&&T.call(this,G)}}_clearTextMarkers(_,S){function C(){for(var f=this._codeMirror.getAllMarks(),T=0,E;T<f.length;++T){if(E=f[T],!S&&E.__checkboxPlaceholder){var I=E.find();if(I&&!I.ch)continue}E.__cssProperty&&(E.__cssProperty.removeEventListener(null,null,this),delete E.__cssProperty.__propertyTextMarker,delete E.__cssProperty),E.clear()}}_?C.call(this):this._codeMirror.operation(C.bind(this))}_iterateOverProperties(_,S){let C=_?this._style.visibleProperties:this._style.properties,f=E=>E;this._filterResultPropertyNames?f=E=>{return(E.variable||this._propertyVisibilityMode!==WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.HideNonVariables)&&(E.variable&&this._propertyVisibilityMode===WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.HideVariables?!1:E.implicit&&!this._showsImplicitProperties?!1:!!(E.name in this._filterResultPropertyNames))}:!_&&(f=E=>{switch(this._propertyVisibilityMode){case WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.HideNonVariables:if(!E.variable)return!1;break;case WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.HideVariables:if(E.variable)return!1;break;case WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.ShowAll:break;default:console.error("Invalid property visibility mode");}return!E.implicit||this._showsImplicitProperties||E.canonicalName in this._alwaysShowPropertyNames}),C=C.filter(f),this._sortProperties&&C.sort((E,I)=>E.name.extendedLocaleCompare(I.name)),this._shownProperties=C;for(var T=0;T<C.length&&!S.call(this,C[T],T===C.length-1);++T);}_propertyCheckboxChanged(_){var S=_.target.__cssProperty;S&&this._commentProperty(S)}_commentProperty(_){function S(){this._codeMirror.replaceRange("/* "+T+" */",f.from,f.to),this._createInlineSwatches(!0,f.from.line)}var C=_.__propertyTextMarker;if(C){var f=C.find();if(f){_._commentRange=f,_._commentRange.to.ch+=6;var T=this._codeMirror.getRange(f.from,f.to);this._codeMirror.operation(S.bind(this))}}}_propertyCommentCheckboxChanged(_){var S=_.target.__commentTextMarker;if(S){var C=S.find();C&&this._uncommentRange(C)}}_uncommentRange(_){var C=this._codeMirror.getRange(_.from,_.to);C=C.replace(/^\/\*\s*/,"").replace(/\s*\*\/$/,""),C.length&&";"!==C.charAt(C.length-1)&&(C+=";"),this._codeMirror.operation(function(){this._codeMirror.addLineClass(_.from.line,"wrap",WebInspector.CSSStyleDeclarationTextEditor.EditingLineStyleClassName),this._codeMirror.replaceRange(C,_.from,_.to),this._createInlineSwatches(!0,_.from.line)}.bind(this))}_inlineSwatchValueChanged(_){function S(){E=T.find();E&&(T.clear(),this._codeMirror.replaceRange(f,E.from,E.to),E.to.ch=E.from.ch+f.length,T=this._codeMirror.markText(E.from,E.to),C.__textMarker=T)}let C=_&&_.target;if(C){let f=_.data&&_.data.value&&_.data.value.toString();if(f){let T=C.__textMarker,E=C.__textMarkerRange;E&&this._codeMirror.operation(S.bind(this))}}}_inlineSwatchActivated(){this._hasActiveInlineSwatchEditor=!0}_inlineSwatchDeactivated(){this._hasActiveInlineSwatchEditor=!1}_propertyOverriddenStatusChanged(_){this._updateTextMarkerForPropertyIfNeeded(_.target)}_propertiesChanged(){return this._completionController.isShowingCompletions()||this._hasActiveInlineSwatchEditor?void 0:this._ignoreNextPropertiesChanged?void(this._ignoreNextPropertiesChanged=!1):this.focused||this._style.text&&this._style.text===this._formattedContent()?void(this._removeEditingLineClassesSoon(),this._updateTextMarkers()):void this._resetContent()}_markLinesWithCheckboxPlaceholder(){if(!this._codeMirror.getOption("readOnly")){for(var _={},S={},C=this._codeMirror.getAllMarks(),f=0,T;f<C.length;++f)if(T=C[f],T.__propertyCheckbox){var E=T.find();E&&(_[E.line]=!0)}else if(T.__checkboxPlaceholder){var E=T.find();E&&(S[E.line]=!0)}for(var I=this._codeMirror.lineCount(),f=0;f<I;++f)if(!(f in _||f in S)){var E={line:f,ch:0},R=document.createElement("div");R.className=WebInspector.CSSStyleDeclarationTextEditor.CheckboxPlaceholderElementStyleClassName;var N=this._codeMirror.setUniqueBookmark(E,R);N.__checkboxPlaceholder=!0}}}_removeCheckboxPlaceholder(_){for(var S=this._codeMirror.findMarksAt({line:_,ch:0}),C=0,f;C<S.length;++C)if(f=S[C],f.__checkboxPlaceholder)return void f.clear()}_formattedContentFromEditor(){let _=WebInspector.indentString(),S=new FormatterContentBuilder(_),C=new WebInspector.Formatter(this._codeMirror,S),T={line:this._codeMirror.lineCount()-1};return C.format({line:0,ch:0},T),S.formattedContent.trim()}_resetContent(){this._commitChangesTimeout&&(clearTimeout(this._commitChangesTimeout),this._commitChangesTimeout=null),this._removeEditingLineClasses();const S=!this._style||!this._style.editable||!this._style.styleSheetTextRange;return this._codeMirror.setOption("readOnly",S),S?(this.element.classList.add(WebInspector.CSSStyleDeclarationTextEditor.ReadOnlyStyleClassName),this._codeMirror.setOption("placeholder",WebInspector.UIString("No Properties"))):(this.element.classList.remove(WebInspector.CSSStyleDeclarationTextEditor.ReadOnlyStyleClassName),this._codeMirror.setOption("placeholder",WebInspector.UIString("No Properties \u2014 Click to Edit"))),this._style?void(this._clearTextMarkers(!1,!0),this._ignoreCodeMirrorContentDidChangeEvent=!0,this._codeMirror.operation(function(){let C=this._codeMirror.getOption("readOnly"),f=this._style.text,T=f.trim();if(!T&&!C)return void this._markLinesWithCheckboxPlaceholder();if(C){this._codeMirror.setValue("");let D=0;return void this._iterateOverProperties(!1,function(M){let P={line:D,ch:0},O={line:D};this._codeMirror.replaceRange((D?"\n":"")+M.synthesizedText,P),this._createTextMarkerForPropertyIfNeeded(P,O,M),D++})}let E=this._codeMirror.getCursor("anchor"),I=this._codeMirror.getCursor("head"),R=/\s+/g;this._linePrefixWhitespace=WebInspector.indentString();let N=f.match(/^\s*/);if(N&&T.includes("\n")){let D=N[0].match(/[^\S\n]+$/);D&&(this._linePrefixWhitespace=D[0])}this._codeMirror.setValue(T),this._codeMirror.setValue(this._formattedContentFromEditor());let L=new Map;this._iterateOverProperties(!1,function(D){D.__refreshedAfterBlur=!1;let M=D.text.replace(R,""),P=L.get(M)||[];P.push(D),L.set(M,P)}),this._codeMirror.eachLine(function(D){let M=D.lineNo(),P=D.text.replace(R,""),O=L.get(P);if(!O)return void this._createCommentedCheckboxMarker(D);for(let F of O)if(!F.__refreshedAfterBlur){this._createTextMarkerForPropertyIfNeeded({line:M,ch:0},{line:M},F),F.__refreshedAfterBlur=!0;break}}.bind(this)),this._createInlineSwatches(!0),this._codeMirror.setSelection(E,I),this._codeMirror.clearHistory(),this._codeMirror.markClean(),this._markLinesWithCheckboxPlaceholder()}.bind(this)),this._ignoreCodeMirrorContentDidChangeEvent=!1):(this._ignoreCodeMirrorContentDidChangeEvent=!0,this._clearTextMarkers(!1,!0),this._codeMirror.setValue(""),this._codeMirror.clearHistory(),this._codeMirror.markClean(),void(this._ignoreCodeMirrorContentDidChangeEvent=!1))}_updateJumpToSymbolTrackingMode(){var _=this._jumpToSymbolTrackingModeEnabled;this._jumpToSymbolTrackingModeEnabled=!!this._style&&WebInspector.modifierKeys.altKey&&!WebInspector.modifierKeys.metaKey&&!WebInspector.modifierKeys.shiftKey,_!==this._jumpToSymbolTrackingModeEnabled&&(this._jumpToSymbolTrackingModeEnabled?(this._tokenTrackingController.highlightLastHoveredRange(),this._tokenTrackingController.enabled=!0):(this._tokenTrackingController.removeHighlightedRange(),this._tokenTrackingController.enabled=!1))}tokenTrackingControllerHighlightedRangeWasClicked(_){function S(R,N){return R&&N&&(WebInspector.showSourceCodeLocation(R.createSourceCodeLocation(N.startLine,N.startColumn),E),!0)}let C=_.candidate;if(C){let f=null;this._style.ownerRule&&(f=this._style.ownerRule.sourceCodeLocation);let T=C.hoveredToken;if(T&&/\blink\b/.test(T.type)){let R=T.string,N=f?f.sourceCode.url:this._style.node.ownerDocument.documentURL;return void WebInspector.openURL(absoluteURL(R,N),null,{ignoreNetworkTab:!0,ignoreSearchTab:!0})}if(this._style.ownerRule&&this._style.ownerRule.sourceCodeLocation&&f){if(T&&/\bvariable-2\b/.test(T.type)){let R=this._style.nodeStyles.effectivePropertyForName(T.string);if(R&&S(R.ownerStyle.ownerRule.sourceCodeLocation.sourceCode,R.styleSheetTextRange))return}let I=this._codeMirror.findMarksAt(C.hoveredTokenRange.start);for(let R of I){let N=R.__cssProperty;if(N&&S(f.sourceCode,N.styleSheetTextRange))return}}}}tokenTrackingControllerNewHighlightCandidate(_,S){(this._style.ownerRule&&this._style.ownerRule.sourceCodeLocation||S.hoveredToken&&/\blink\b/.test(S.hoveredToken.type))&&this._tokenTrackingController.highlightRange(S.hoveredTokenRange)}},WebInspector.CSSStyleDeclarationTextEditor.Event={ContentChanged:"css-style-declaration-text-editor-content-changed",Blurred:"css-style-declaration-text-editor-blurred"},WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode={ShowAll:Symbol("variable-visibility-show-all"),HideVariables:Symbol("variable-visibility-hide-variables"),HideNonVariables:Symbol("variable-visibility-hide-non-variables")},WebInspector.CSSStyleDeclarationTextEditor.PrefixWhitespace="\n",WebInspector.CSSStyleDeclarationTextEditor.SuffixWhitespace="\n",WebInspector.CSSStyleDeclarationTextEditor.StyleClassName="css-style-text-editor",WebInspector.CSSStyleDeclarationTextEditor.ReadOnlyStyleClassName="read-only",WebInspector.CSSStyleDeclarationTextEditor.CheckboxPlaceholderElementStyleClassName="checkbox-placeholder",WebInspector.CSSStyleDeclarationTextEditor.EditingLineStyleClassName="editing-line",WebInspector.CSSStyleDeclarationTextEditor.CommitCoalesceDelay=250,WebInspector.CSSStyleDeclarationTextEditor.RemoveEditingLineClassesDelay=2e3,WebInspector.CSSStyleDetailsSidebarPanel=class extends WebInspector.DOMDetailsSidebarPanel{constructor(){super("css-style",WebInspector.UIString("Styles"),!0),this._selectedPanel=null,this._computedStyleDetailsPanel=new WebInspector.ComputedStyleDetailsPanel(this),this._rulesStyleDetailsPanel=new WebInspector.RulesStyleDetailsPanel(this),this._visualStyleDetailsPanel=new WebInspector.VisualStyleDetailsPanel(this),this._panels=[this._computedStyleDetailsPanel,this._rulesStyleDetailsPanel,this._visualStyleDetailsPanel],this._panelNavigationInfo=[this._computedStyleDetailsPanel.navigationInfo,this._rulesStyleDetailsPanel.navigationInfo,this._visualStyleDetailsPanel.navigationInfo],this._lastSelectedPanelSetting=new WebInspector.Setting("last-selected-style-details-panel",this._rulesStyleDetailsPanel.navigationInfo.identifier),this._classListContainerToggledSetting=new WebInspector.Setting("class-list-container-toggled",!1),this._initiallySelectedPanel=this._panelMatchingIdentifier(this._lastSelectedPanelSetting.value)||this._rulesStyleDetailsPanel,this._navigationItem=new WebInspector.ScopeRadioButtonNavigationItem(this.identifier,this.displayName,this._panelNavigationInfo,this._initiallySelectedPanel.navigationInfo),this._navigationItem.addEventListener(WebInspector.ScopeRadioButtonNavigationItem.Event.SelectedItemChanged,this._handleSelectedItemChanged,this),this._forcedPseudoClassCheckboxes={}}supportsDOMNode(_){return _.nodeType()===Node.ELEMENT_NODE}visibilityDidChange(){return super.visibilityDidChange(),this._selectedPanel?this.visible?void(this._updateNoForcedPseudoClassesScrollOffset(),this._selectedPanel.shown(),this._selectedPanel.markAsNeedsRefresh(this.domNode)):void this._selectedPanel.hidden():void 0}computedStyleDetailsPanelShowProperty(_){this._rulesStyleDetailsPanel.scrollToSectionAndHighlightProperty(_),this._switchPanels(this._rulesStyleDetailsPanel),this._navigationItem.selectedItemIdentifier=this._lastSelectedPanelSetting.value}layout(){let _=this.domNode;if(_){this.contentView.element.scrollTop=this._initialScrollOffset;for(let S of this._panels)S.element._savedScrollTop=void 0,S.markAsNeedsRefresh(_);this._updatePseudoClassCheckboxes(),this._classListContainer.hidden||this._populateClassToggles()}}addEventListeners(){let _=this.domNode.isPseudoElement()?this.domNode.parentNode:this.domNode;_&&(_.addEventListener(WebInspector.DOMNode.Event.EnabledPseudoClassesChanged,this._updatePseudoClassCheckboxes,this),_.addEventListener(WebInspector.DOMNode.Event.AttributeModified,this._handleNodeAttributeModified,this),_.addEventListener(WebInspector.DOMNode.Event.AttributeRemoved,this._handleNodeAttributeRemoved,this))}removeEventListeners(){let _=this.domNode.isPseudoElement()?this.domNode.parentNode:this.domNode;_&&_.removeEventListener(null,null,this)}initialLayout(){if(WebInspector.cssStyleManager.canForcePseudoClasses()){this._forcedPseudoClassContainer=document.createElement("div"),this._forcedPseudoClassContainer.className="pseudo-classes";let C=null;WebInspector.CSSStyleManager.ForceablePseudoClasses.forEach(function(f){let T=f.capitalize(),E=document.createElement("label"),I=document.createElement("input");I.addEventListener("change",this._forcedPseudoClassCheckboxChanged.bind(this,f)),I.type="checkbox",this._forcedPseudoClassCheckboxes[f]=I,E.appendChild(I),E.append(T),C&&2!==C.children.length||(C=document.createElement("div"),C.className="group",this._forcedPseudoClassContainer.appendChild(C)),C.appendChild(E)},this),this.contentView.element.appendChild(this._forcedPseudoClassContainer)}this._computedStyleDetailsPanel.addEventListener(WebInspector.StyleDetailsPanel.Event.Refreshed,this._filterDidChange,this),this._rulesStyleDetailsPanel.addEventListener(WebInspector.StyleDetailsPanel.Event.Refreshed,this._filterDidChange,this),this._switchPanels(this._initiallySelectedPanel),this._initiallySelectedPanel=null;let _=this.element.createChild("div","options-container"),S=_.createChild("img","new-rule");S.title=WebInspector.UIString("Add new rule"),S.addEventListener("click",this._newRuleButtonClicked.bind(this)),S.addEventListener("contextmenu",this._newRuleButtonContextMenu.bind(this)),this._filterBar=new WebInspector.FilterBar,this._filterBar.placeholder=WebInspector.UIString("Filter Styles"),this._filterBar.addEventListener(WebInspector.FilterBar.Event.FilterDidChange,this._filterDidChange,this),_.appendChild(this._filterBar.element),this._classToggleButton=_.createChild("button","toggle-class-toggle"),this._classToggleButton.textContent=WebInspector.UIString("Classes"),this._classToggleButton.title=WebInspector.UIString("Toggle Classes"),this._classToggleButton.addEventListener("click",this._classToggleButtonClicked.bind(this)),this._classListContainer=this.element.createChild("div","class-list-container"),this._classListContainer.hidden=!0,this._addClassContainer=this._classListContainer.createChild("div","new-class"),this._addClassContainer.title=WebInspector.UIString("Add a Class"),this._addClassContainer.addEventListener("click",this._addClassContainerClicked.bind(this)),this._addClassInput=this._addClassContainer.createChild("input","class-name-input"),this._addClassInput.setAttribute("placeholder",WebInspector.UIString("Enter Class Name")),this._addClassInput.addEventListener("keypress",this._addClassInputKeyPressed.bind(this)),this._addClassInput.addEventListener("blur",this._addClassInputBlur.bind(this)),WebInspector.cssStyleManager.addEventListener(WebInspector.CSSStyleManager.Event.StyleSheetAdded,this._styleSheetAddedOrRemoved,this),WebInspector.cssStyleManager.addEventListener(WebInspector.CSSStyleManager.Event.StyleSheetRemoved,this._styleSheetAddedOrRemoved,this),this._classListContainerToggledSetting.value&&this._classToggleButtonClicked()}sizeDidChange(){super.sizeDidChange(),this._updateNoForcedPseudoClassesScrollOffset(),this._selectedPanel&&this._selectedPanel.sizeDidChange()}get _initialScrollOffset(){return WebInspector.cssStyleManager.canForcePseudoClasses()?this.domNode&&this.domNode.enabledPseudoClasses.length?0:WebInspector.CSSStyleDetailsSidebarPanel.NoForcedPseudoClassesScrollOffset:0}_updateNoForcedPseudoClassesScrollOffset(){this._forcedPseudoClassContainer&&(WebInspector.CSSStyleDetailsSidebarPanel.NoForcedPseudoClassesScrollOffset=this._forcedPseudoClassContainer.offsetHeight)}_panelMatchingIdentifier(_){let S=null;for(let C of this._panels)if(C.navigationInfo.identifier===_){S=C;break}return S}_handleSelectedItemChanged(){let _=this._navigationItem.selectedItemIdentifier,S=this._panelMatchingIdentifier(_);this._switchPanels(S)}_switchPanels(_){if(this._selectedPanel&&(this._selectedPanel.hidden(),this._selectedPanel.element._savedScrollTop=this.contentView.element.scrollTop,this.contentView.removeSubview(this._selectedPanel)),this._selectedPanel=_,!!this._selectedPanel){this.contentView.addSubview(this._selectedPanel),this.contentView.element.scrollTop="number"==typeof this._selectedPanel.element._savedScrollTop?this._selectedPanel.element._savedScrollTop:this._initialScrollOffset;let S="function"==typeof this._selectedPanel.filterDidChange;this.contentView.element.classList.toggle("has-filter-bar",S),this._filterBar&&this.contentView.element.classList.toggle(WebInspector.CSSStyleDetailsSidebarPanel.FilterInProgressClassName,S&&this._filterBar.hasActiveFilters()),this.contentView.element.classList.toggle("supports-new-rule","function"==typeof this._selectedPanel.newRuleButtonClicked),this._selectedPanel.shown(),this._lastSelectedPanelSetting.value=_.navigationInfo.identifier}}_forcedPseudoClassCheckboxChanged(_,S){if(this.domNode){let C=this.domNode.isPseudoElement()?this.domNode.parentNode:this.domNode;C.setPseudoClassEnabled(_,S.target.checked)}}_updatePseudoClassCheckboxes(){if(this.domNode){let _=this.domNode.isPseudoElement()?this.domNode.parentNode:this.domNode,S=_.enabledPseudoClasses;for(let C in this._forcedPseudoClassCheckboxes){let f=this._forcedPseudoClassCheckboxes[C];f.checked=S.includes(C)}}}_handleNodeAttributeModified(_){_&&_.data&&"class"===_.data.name&&this._populateClassToggles()}_handleNodeAttributeRemoved(_){_&&_.data&&"class"===_.data.name&&this._populateClassToggles()}_newRuleButtonClicked(){this._selectedPanel&&"function"==typeof this._selectedPanel.newRuleButtonClicked&&this._selectedPanel.newRuleButtonClicked()}_newRuleButtonContextMenu(_){this._selectedPanel&&"function"==typeof this._selectedPanel.newRuleButtonContextMenu&&this._selectedPanel.newRuleButtonContextMenu(_)}_classToggleButtonClicked(){this._classToggleButton.classList.toggle("selected"),this._classListContainer.hidden=!this._classListContainer.hidden,this._classListContainerToggledSetting.value=!this._classListContainer.hidden;this._classListContainer.hidden||this._populateClassToggles()}_addClassContainerClicked(){this._addClassContainer.classList.add("active"),this._addClassInput.focus()}_addClassInputKeyPressed(_){_.keyCode!==WebInspector.KeyboardShortcut.Key.Enter.keyCode||this._addClassInput.blur()}_addClassInputBlur(){this.domNode.toggleClass(this._addClassInput.value,!0),this._addClassContainer.classList.remove("active"),this._addClassInput.value=null}_populateClassToggles(){for(;1<this._classListContainer.children.length;)this._classListContainer.children[1].remove();let _=this.domNode.getAttribute("class"),S=this.domNode[WebInspector.CSSStyleDetailsSidebarPanel.ToggledClassesSymbol];if(S||(S=this.domNode[WebInspector.CSSStyleDetailsSidebarPanel.ToggledClassesSymbol]=new Map),_&&_.length)for(let C of _.split(/\s+/))S.set(C,!0);for(let[C,f]of S)(f&&!_.includes(C)||!f&&_.includes(C))&&(f=!f,S.set(C,f)),this._createToggleForClassName(C)}_createToggleForClassName(_){if(_&&_.length){let S=this.domNode[WebInspector.CSSStyleDetailsSidebarPanel.ToggledClassesSymbol];if(S){S.has(_)||S.set(_,!0);let C=S.get(_),f=document.createElement("div");f.classList.add("class-toggle");let T=f.createChild("input");T.type="checkbox",T.checked=C;let E=f.createChild("span");E.textContent=_,E.draggable=!0,E.addEventListener("dragstart",R=>{R.dataTransfer.setData(WebInspector.CSSStyleDetailsSidebarPanel.ToggledClassesDragType,_),R.dataTransfer.effectAllowed="copy"});let I=()=>{this.domNode.toggleClass(_,T.checked),S.set(_,T.checked)};T.addEventListener("click",I),E.addEventListener("click",()=>{T.checked=!T.checked,I()}),this._classListContainer.appendChild(f)}}}_filterDidChange(){this.contentView.element.classList.toggle(WebInspector.CSSStyleDetailsSidebarPanel.FilterInProgressClassName,this._filterBar.hasActiveFilters()),this._selectedPanel.filterDidChange(this._filterBar)}_styleSheetAddedOrRemoved(){this.needsLayout()}},WebInspector.CSSStyleDetailsSidebarPanel.NoForcedPseudoClassesScrollOffset=30,WebInspector.CSSStyleDetailsSidebarPanel.FilterInProgressClassName="filter-in-progress",WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchingSectionHasLabelClassName="filter-section-has-label",WebInspector.CSSStyleDetailsSidebarPanel.FilterMatchSectionClassName="filter-matching",WebInspector.CSSStyleDetailsSidebarPanel.NoFilterMatchInSectionClassName="filter-section-non-matching",WebInspector.CSSStyleDetailsSidebarPanel.NoFilterMatchInPropertyClassName="filter-property-non-matching",WebInspector.CSSStyleDetailsSidebarPanel.ToggledClassesSymbol=Symbol("css-style-details-sidebar-panel-toggled-classes-symbol"),WebInspector.CSSStyleDetailsSidebarPanel.ToggledClassesDragType="text/classname",WebInspector.CSSStyleSheetTreeElement=class extends WebInspector.SourceCodeTreeElement{constructor(_){const C=WebInspector.UIString("Inspector Style Sheet");super(_,["stylesheet","stylesheet-icon"],C,null,_,!1)}},WebInspector.CallFrameTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_,S){let C=WebInspector.CallFrameView.iconClassNameForCallFrame(_),f=_.functionName||WebInspector.UIString("(anonymous function)");if(super(["call-frame",C],f,null,_,!1),this._callFrame=_,this._isActiveCallFrame=!1,S&&(this.addClassName("async-boundary"),this.selectable=!1),this._callFrame.nativeCode||!this._callFrame.sourceCodeLocation)return void(this.subtitle="");let T=this._callFrame.sourceCodeLocation.displaySourceCode.url;T&&(this.subtitle=document.createElement("span"),this._callFrame.sourceCodeLocation.populateLiveDisplayLocationString(this.subtitle,"textContent"),this.tooltipHandledSeparately=!0)}get callFrame(){return this._callFrame}get isActiveCallFrame(){return this._isActiveCallFrame}set isActiveCallFrame(_){this._isActiveCallFrame===_||(this._isActiveCallFrame=_,this._updateStatus())}onattach(){if(super.onattach(),this.tooltipHandledSeparately){let _="";this._callFrame.isTailDeleted&&(_=" "+WebInspector.UIString("(Tail Call)"));let S=this.mainTitle+_+"\n";this._callFrame.sourceCodeLocation.populateLiveDisplayLocationTooltip(this.element,S)}this._updateStatus()}_updateStatus(){return this.element?this._isActiveCallFrame?void(!this._statusImageElement&&(this._statusImageElement=useSVGSymbol("Images/ActiveCallFrame.svg","status-image")),this.status=this._statusImageElement):void(this.status=null):void 0}},WebInspector.CallFrameView=class extends WebInspector.Object{constructor(_,S){var C=document.createElement("div");C.classList.add("call-frame",WebInspector.CallFrameView.iconClassNameForCallFrame(_));var f=document.createElement("span");f.classList.add("subtitle");var T=_.sourceCodeLocation;if(T){WebInspector.linkifyElement(C,T);var E=document.createElement("a");if(E.classList.add("source-link"),E.href=T.sourceCode.url,S){var I=document.createElement("span");I.classList.add("separator"),I.textContent=" \u2014 ",f.append(I)}f.append(E),T.populateLiveDisplayLocationTooltip(E),T.populateLiveDisplayLocationString(E,"textContent")}var R=document.createElement("span");if(R.classList.add("title"),S){var N=document.createElement("img");N.classList.add("icon"),R.append(N,_.functionName||WebInspector.UIString("(anonymous function)"))}return C.append(R,f),C}static iconClassNameForCallFrame(_){return _.isTailDeleted?WebInspector.CallFrameView.TailDeletedIcon:_.programCode?WebInspector.CallFrameView.ProgramIconStyleClassName:_.functionName&&_.functionName.startsWith("on")&&5<=_.functionName.length?WebInspector.CallFrameView.EventListenerIconStyleClassName:_.nativeCode?WebInspector.CallFrameView.NativeIconStyleClassName:WebInspector.CallFrameView.FunctionIconStyleClassName}},WebInspector.CallFrameView.ProgramIconStyleClassName="program-icon",WebInspector.CallFrameView.FunctionIconStyleClassName="function-icon",WebInspector.CallFrameView.EventListenerIconStyleClassName="event-listener-icon",WebInspector.CallFrameView.NativeIconStyleClassName="native-icon",WebInspector.CallFrameView.TailDeletedIcon="tail-deleted",WebInspector.CanvasContentView=class extends WebInspector.ContentView{constructor(_){super(_),this.element.classList.add("canvas"),this._previewContainerElement=null,this._previewImageElement=null,this._errorElement=null,this._refreshButtonNavigationItem=new WebInspector.ButtonNavigationItem("canvas-refresh",WebInspector.UIString("Refresh"),"Images/ReloadFull.svg",13,13),this._refreshButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._showPreview,this),this._showGridButtonNavigationItem=new WebInspector.ActivateButtonNavigationItem("show-grid",WebInspector.UIString("Show Grid"),WebInspector.UIString("Hide Grid"),"Images/NavigationItemCheckers.svg",13,13),this._showGridButtonNavigationItem.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,this._showGridButtonClicked,this),this._showGridButtonNavigationItem.activated=!!WebInspector.settings.showImageGrid.value}get navigationItems(){return[this._refreshButtonNavigationItem,this._showGridButtonNavigationItem]}shown(){super.shown(),this._showPreview(),WebInspector.settings.showImageGrid.addEventListener(WebInspector.Setting.Event.Changed,this._updateImageGrid,this)}hidden(){WebInspector.settings.showImageGrid.removeEventListener(WebInspector.Setting.Event.Changed,this._updateImageGrid,this),super.hidden()}_showPreview(){let _=()=>{if(this._previewContainerElement&&this._previewContainerElement.remove(),!this._errorElement){this._errorElement=WebInspector.createMessageTextView(WebInspector.UIString("No Preview Available"),!0)}this.element.appendChild(this._errorElement)};this._previewContainerElement||(this._previewContainerElement=this.element.appendChild(document.createElement("div")),this._previewContainerElement.classList.add("preview")),this.representedObject.requestContent(S=>{return S?void(this._errorElement&&this._errorElement.remove(),!this._previewImageElement&&(this._previewImageElement=document.createElement("img"),this._previewImageElement.addEventListener("error",_)),this._previewImageElement.src=S,this._previewContainerElement.appendChild(this._previewImageElement),this._updateImageGrid()):void _()})}_updateImageGrid(){if(this._previewImageElement){let _=WebInspector.settings.showImageGrid.value;this._showGridButtonNavigationItem.activated=_,this._previewImageElement.classList.toggle("show-grid",_)}}_showGridButtonClicked(){WebInspector.settings.showImageGrid.value=!this._showGridButtonNavigationItem.activated,this._updateImageGrid()}},WebInspector.CanvasDetailsSidebarPanel=class extends WebInspector.DetailsSidebarPanel{constructor(){super("canvas",WebInspector.UIString("Canvas")),this.element.classList.add("canvas"),this._canvas=null,this._node=null}inspect(_){return _ instanceof Array||(_=[_]),this.canvas=_.find(S=>S instanceof WebInspector.Canvas),!!this._canvas}get canvas(){return this._canvas}set canvas(_){_===this._canvas||(this._node&&(this._node.removeEventListener(WebInspector.DOMNode.Event.AttributeModified,this._refreshSourceSection,this),this._node.removeEventListener(WebInspector.DOMNode.Event.AttributeRemoved,this._refreshSourceSection,this),this._node=null),this._canvas&&(this._canvas.removeEventListener(WebInspector.Canvas.Event.MemoryChanged,this._canvasMemoryChanged,this),this._canvas.removeEventListener(WebInspector.Canvas.Event.CSSCanvasClientNodesChanged,this._refreshCSSCanvasSection,this)),this._canvas=_||null,this._canvas&&(this._canvas.addEventListener(WebInspector.Canvas.Event.MemoryChanged,this._canvasMemoryChanged,this),this._canvas.addEventListener(WebInspector.Canvas.Event.CSSCanvasClientNodesChanged,this._refreshCSSCanvasSection,this)),this.needsLayout())}initialLayout(){super.initialLayout(),this._nameRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Name")),this._typeRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Type")),this._memoryRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Memory")),this._memoryRow.tooltip=WebInspector.UIString("Memory usage of this canvas");let _=new WebInspector.DetailsSection("canvas-details",WebInspector.UIString("Identity"));_.groups=[new WebInspector.DetailsSectionGroup([this._nameRow,this._typeRow,this._memoryRow])],this.contentView.element.appendChild(_.element),this._nodeRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Node")),this._cssCanvasRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("CSS Canvas")),this._widthRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Width")),this._heightRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Height")),this._datachedRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Detached"));let S=new WebInspector.DetailsSection("canvas-source",WebInspector.UIString("Source"));S.groups=[new WebInspector.DetailsSectionGroup([this._nodeRow,this._cssCanvasRow,this._widthRow,this._heightRow,this._datachedRow])],this.contentView.element.appendChild(S.element),this._attributesDataGridRow=new WebInspector.DetailsSectionDataGridRow(null,WebInspector.UIString("No Attributes"));let C=new WebInspector.DetailsSection("canvas-attributes",WebInspector.UIString("Attributes"));C.groups=[new WebInspector.DetailsSectionGroup([this._attributesDataGridRow])],this.contentView.element.appendChild(C.element),this._cssCanvasClientsRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Nodes")),this._cssCanvasSection=new WebInspector.DetailsSection("canvas-css",WebInspector.UIString("CSS")),this._cssCanvasSection.groups=[new WebInspector.DetailsSectionGroup([this._cssCanvasClientsRow])],this._cssCanvasSection.element.hidden=!0,this.contentView.element.appendChild(this._cssCanvasSection.element)}layout(){super.layout();this._canvas&&(this._refreshIdentitySection(),this._refreshSourceSection(),this._refreshAttributesSection(),this._refreshCSSCanvasSection())}sizeDidChange(){super.sizeDidChange(),this._attributesDataGridRow.sizeDidChange()}_refreshIdentitySection(){this._canvas&&(this._nameRow.value=this._canvas.displayName,this._typeRow.value=WebInspector.Canvas.displayNameForContextType(this._canvas.contextType),this._formatMemoryRow())}_refreshSourceSection(){this._canvas&&(this._nodeRow.value=this._canvas.cssCanvasName?null:emDash,this._cssCanvasRow.value=this._canvas.cssCanvasName||null,this._widthRow.value=emDash,this._heightRow.value=emDash,this._datachedRow.value=null,this._canvas.requestNode(_=>{if(_){_!==this._node&&(this._node&&(this._node.removeEventListener(WebInspector.DOMNode.Event.AttributeModified,this._refreshSourceSection,this),this._node.removeEventListener(WebInspector.DOMNode.Event.AttributeRemoved,this._refreshSourceSection,this),this._node=null),this._node=_,this._node.addEventListener(WebInspector.DOMNode.Event.AttributeModified,this._refreshSourceSection,this),this._node.addEventListener(WebInspector.DOMNode.Event.AttributeRemoved,this._refreshSourceSection,this)),this._canvas.cssCanvasName||(this._nodeRow.value=WebInspector.linkifyNodeReference(this._node));let S=(T,E)=>{let I=+this._node.getAttribute(E);return!Number.isInteger(I)||0>I?!1:(T.value=I,!0)},C=S(this._widthRow,"width"),f=S(this._heightRow,"height");C&&f||WebInspector.RemoteObject.resolveNode(_,"",T=>{function E(I,R){T.getProperty(R,(N,L)=>{N||"number"!==L.type||(I.value=`${L.value}px`)})}T&&(E(this._widthRow,"width"),E(this._heightRow,"height"),T.release())}),this._canvas.cssCanvasName||this._node.parentNode||(this._datachedRow.value=WebInspector.UIString("Yes"))}}))}_refreshAttributesSection(){if(this._canvas){if(isEmptyObject(this._canvas.contextAttributes))return void(this._attributesDataGridRow.dataGrid=null);let _=this._attributesDataGridRow.dataGrid;for(let S in _||(_=this._attributesDataGridRow.dataGrid=new WebInspector.DataGrid({name:{title:WebInspector.UIString("Name")},value:{title:WebInspector.UIString("Value"),width:"30%"}})),_.removeChildren(),this._canvas.contextAttributes){let C={name:S,value:this._canvas.contextAttributes[S]},f=new WebInspector.DataGridNode(C);_.appendChild(f)}_.updateLayoutIfNeeded()}}_refreshCSSCanvasSection(){return this._canvas?this._canvas.cssCanvasName?void(this._cssCanvasClientsRow.value=emDash,this._cssCanvasSection.element.hidden=!1,this._canvas.requestCSSCanvasClientNodes(_=>{if(_.length){let S=document.createDocumentFragment();for(let C of _)S.appendChild(WebInspector.linkifyNodeReference(C));this._cssCanvasClientsRow.value=S}})):void(this._cssCanvasSection.element.hidden=!0):void 0}_formatMemoryRow(){return!this._canvas.memoryCost||isNaN(this._canvas.memoryCost)?void(this._memoryRow.value=emDash):void(this._memoryRow.value=Number.bytesToString(this._canvas.memoryCost))}_canvasMemoryChanged(){this._formatMemoryRow()}},WebInspector.CanvasTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_){super(["canvas",_.contextType],_.displayName,null,_)}onattach(){super.onattach(),this.element.addEventListener("mouseover",this._handleMouseOver.bind(this)),this.element.addEventListener("mouseout",this._handleMouseOut.bind(this))}populateContextMenu(_,S){super.populateContextMenu(_,S),_.appendItem(WebInspector.UIString("Log Canvas Context"),()=>{WebInspector.RemoteObject.resolveCanvasContext(this.representedObject,WebInspector.RuntimeManager.ConsoleObjectGroup,C=>{if(C){const f=WebInspector.UIString("Selected Canvas Context");WebInspector.consoleLogViewController.appendImmediateExecutionWithResult(f,C,!0)}})}),_.appendSeparator()}_handleMouseOver(){this.representedObject.cssCanvasName?this.representedObject.requestCSSCanvasClientNodes(S=>{WebInspector.domTreeManager.highlightDOMNodeList(S.map(C=>C.id),"all")}):this.representedObject.requestNode(S=>{S&&S.ownerDocument&&WebInspector.domTreeManager.highlightDOMNode(S.id,"all")})}_handleMouseOut(){WebInspector.domTreeManager.hideDOMNodeHighlight()}},WebInspector.ChartDetailsSectionRow=class extends WebInspector.DetailsSectionRow{constructor(_,S,C){super(WebInspector.UIString("No Chart Available")),C=C||0,this.element.classList.add("chart"),this._titleElement=document.createElement("div"),this._titleElement.className="title",this.element.appendChild(this._titleElement);let T=document.createElement("div");T.className="chart-content",this.element.appendChild(T),this._chartElement=createSVGElement("svg"),T.appendChild(this._chartElement),this._legendElement=document.createElement("div"),this._legendElement.className="legend",T.appendChild(this._legendElement),this._delegate=_,this._items=new Map,this._title="",this._chartSize=S,this._radius=this._chartSize/2-1,this._innerRadius=C?Math.floor(this._radius*C):0,this._total=0,this._svgFiltersElement=document.createElement("svg"),this._svgFiltersElement.classList.add("defs-only"),this.element.append(this._svgFiltersElement),this._checkboxStyleElement=document.createElement("style"),this._checkboxStyleElement.id="checkbox-styles",document.getElementsByTagName("head")[0].append(this._checkboxStyleElement),this._emptyChartPath=createSVGElement("path"),this._emptyChartPath.setAttribute("d",function(E,I,R){const N=0,L=1.9999*Math.PI;let D=E+Math.cos(N)*I,M=E+Math.sin(N)*I,P=E+Math.cos(L)*I,O=E+Math.sin(L)*I,F=E+Math.cos(L)*R,V=E+Math.sin(L)*R,U=E+Math.cos(N)*R,G=E+Math.sin(N)*R;return["M",D,M,"A",I,I,0,1,1,P,O,"Z","M",F,V,"A",R,R,0,1,0,U,G,"Z"].join(" ")}(this._chartSize/2,this._radius,this._innerRadius)),this._emptyChartPath.classList.add("empty-chart"),this._chartElement.appendChild(this._emptyChartPath)}get chartSize(){return this._chartSize}set title(_){this._title===_||(this._title=_,this._titleElement.textContent=_)}get total(){return this._total}addItem(_,S,C,f,T,E){this._items.has(_)||0>C||(this._items.set(_,{label:S,value:C,color:f,checkbox:T,checked:E}),this._total+=C,this._needsLayout())}setItemValue(_,S){let C=this._items.get(_);!C||0>S||C.value===S||(this._total+=S-C.value,C.value=S,this._needsLayout())}clearItems(){for(let _ of this._items.values()){let S=_[WebInspector.ChartDetailsSectionRow.ChartSegmentPathSymbol];S&&S.remove()}this._total=0,this._items.clear(),this._needsLayout()}_addCheckboxColorFilter(_,S,C,f){function T(D,M){let P=createSVGElement(D);return P.setAttribute("type","gamma"),P.setAttribute("exponent",M),P}for(let D=0;D<this._svgFiltersElement.childNodes.length;++D)if(this._svgFiltersElement.childNodes[D].id===_)return;S/=255,f/=255,C/=255;let E=createSVGElement("filter");E.id=_,E.setAttribute("color-interpolation-filters","sRGB");let I=[1-S,0,0,0,S,1-C,0,0,0,C,1-f,0,0,0,f,0,0,0,1,0],R=createSVGElement("feColorMatrix");R.setAttribute("type","matrix"),R.setAttribute("values",I.join(" "));let N=createSVGElement("feComponentTransfer");N.append(T("feFuncR",1.4),T("feFuncG",1.4),T("feFuncB",1.4)),E.append(R,N),this._svgFiltersElement.append(E);let L=this._checkboxStyleElement.sheet;L.insertRule(".details-section > .content > .group > .row.chart > .chart-content > .legend > .legend-item > label > input[type=checkbox]."+_+" { filter: grayscale(1) url(#"+_+") }",0)}_updateLegend(){function _(S){return this._delegate&&"function"==typeof this._delegate.formatChartValue?this._delegate.formatChartValue(S.value):S.value}if(!this._items.size)return void this._legendElement.removeChildren();for(let[S,C]of this._items){if(C[WebInspector.ChartDetailsSectionRow.LegendItemValueElementSymbol]){let R=C[WebInspector.ChartDetailsSectionRow.LegendItemValueElementSymbol];R.textContent=_.call(this,C);continue}let f=document.createElement("label"),T;if(C.checkbox){let R=S.toLowerCase(),N=C.color.substring(4,C.color.length-1).replace(/ /g,"").split(",");N[0]===N[1]&&N[1]===N[2]&&(N[0]=N[1]=N[2]=Math.min(160,N[0])),T=document.createElement("input"),T.type="checkbox",T.classList.add(R),T.checked=C.checked,T[WebInspector.ChartDetailsSectionRow.DataItemIdSymbol]=S,T.addEventListener("change",this._legendItemCheckboxValueChanged.bind(this)),this._addCheckboxColorFilter(R,N[0],N[1],N[2])}else T=document.createElement("div"),T.classList.add("color-key"),T.style.backgroundColor=C.color;f.append(T,C.label);let E=document.createElement("div");E.classList.add("value"),E.textContent=_.call(this,C),C[WebInspector.ChartDetailsSectionRow.LegendItemValueElementSymbol]=E;let I=document.createElement("div");I.classList.add("legend-item"),I.append(f,E),this._legendElement.append(I)}}_legendItemCheckboxValueChanged(_){let S=_.target,C=S[WebInspector.ChartDetailsSectionRow.DataItemIdSymbol];this.dispatchEventToListeners(WebInspector.ChartDetailsSectionRow.Event.LegendItemChecked,{id:C,checked:S.checked})}_needsLayout(){this._scheduledLayoutUpdateIdentifier||(this._scheduledLayoutUpdateIdentifier=requestAnimationFrame(this._updateLayout.bind(this)))}_updateLayout(){function _(I,R,N,L,D){const M=(N-R)%(2*Math.PI)>Math.PI?1:0;let P=I+Math.cos(R)*L,O=I+Math.sin(R)*L,F=I+Math.cos(N)*L,V=I+Math.sin(N)*L,U=I+Math.cos(N)*D,G=I+Math.sin(N)*D,H=I+Math.cos(R)*D,W=I+Math.sin(R)*D;return["M",P,O,"A",L,L,0,M,1,F,V,"L",U,G,"A",D,D,0,M,0,H,W,"Z"].join(" ")}this._scheduledLayoutUpdateIdentifier&&(cancelAnimationFrame(this._scheduledLayoutUpdateIdentifier),this._scheduledLayoutUpdateIdentifier=void 0),this._updateLegend(),this._chartElement.setAttribute("width",this._chartSize),this._chartElement.setAttribute("height",this._chartSize),this._chartElement.setAttribute("viewbox","0 0 "+this._chartSize+" "+this._chartSize);const S=0.015*this._total;let C=[];for(let I of this._items.values())I.displayValue=I.value?Math.max(S,I.value):0,I.displayValue&&C.push(I);if(1<C.length){C.sort(function(N,L){return N.value-L.value});let I=C.length,R=0;for(let N of C){if(N.value<S){R+=S-N.value,I--;continue}if(!R||!I)break;const L=R/I;N.displayValue-L>=S&&(N.displayValue-=L,R-=L),I--}}const f=this._chartSize/2;let T=-Math.PI/2,E=0;for(let[I,R]of this._items){let N=R[WebInspector.ChartDetailsSectionRow.ChartSegmentPathSymbol];if(N||(N=createSVGElement("path"),N.classList.add("chart-segment"),N.setAttribute("fill",R.color),this._chartElement.appendChild(N),R[WebInspector.ChartDetailsSectionRow.ChartSegmentPathSymbol]=N),!R.value){N.classList.add("hidden");continue}const L=2*(R.displayValue/this._total*Math.PI);E=T+L,N.setAttribute("d",_(f,T,E,this._radius,this._innerRadius)),N.classList.remove("hidden"),T=E}}},WebInspector.ChartDetailsSectionRow.DataItemIdSymbol=Symbol("chart-details-section-row-data-item-id"),WebInspector.ChartDetailsSectionRow.ChartSegmentPathSymbol=Symbol("chart-details-section-row-chart-segment-path"),WebInspector.ChartDetailsSectionRow.LegendItemValueElementSymbol=Symbol("chart-details-section-row-legend-item-value-element"),WebInspector.ChartDetailsSectionRow.Event={LegendItemChecked:"chart-details-section-row-legend-item-checked"},WebInspector.CircleChart=class{constructor({size:_,innerRadiusRatio:S}){this._data=[],this._size=_,this._radius=_/2-1,this._innerRadius=S?Math.floor(this._radius*S):0,this._element=document.createElement("div"),this._element.classList.add("circle-chart"),this._chartElement=this._element.appendChild(createSVGElement("svg")),this._chartElement.setAttribute("width",_),this._chartElement.setAttribute("height",_),this._chartElement.setAttribute("viewbox",`0 0 ${_} ${_}`),this._pathElements=[],this._values=[],this._total=0;let C=this._chartElement.appendChild(createSVGElement("path"));C.setAttribute("d",this._createCompleteCirclePathData(this.size/2,this._radius,this._innerRadius)),C.classList.add("background")}get element(){return this._element}get points(){return this._points}get size(){return this._size}get centerElement(){return this._centerElement||(this._centerElement=this._element.appendChild(document.createElement("div")),this._centerElement.classList.add("center"),this._centerElement.style.width=this._centerElement.style.height=this._radius+"px",this._centerElement.style.top=this._centerElement.style.left=this._radius-this._innerRadius+"px"),this._centerElement}get segments(){return this._segments}set segments(_){for(let S of this._pathElements)S.remove();this._pathElements=[];for(let S of _){let C=this._chartElement.appendChild(createSVGElement("path"));C.classList.add("segment",S),this._pathElements.push(C)}}get values(){return this._values}set values(_){this._values=_,this._total=0;for(let S of _)this._total+=S}clear(){this.values=Array(this._values.length).fill(0)}needsLayout(){this._scheduledLayoutUpdateIdentifier||(this._scheduledLayoutUpdateIdentifier=requestAnimationFrame(this.updateLayout.bind(this)))}updateLayout(){if(this._scheduledLayoutUpdateIdentifier&&(cancelAnimationFrame(this._scheduledLayoutUpdateIdentifier),this._scheduledLayoutUpdateIdentifier=void 0),!!this._values.length){const _=this._size/2;let S=-Math.PI/2,C=0;for(let f=0;f<this._values.length;++f){let T=this._values[f],E=this._pathElements[f];if(0===T)E.removeAttribute("d");else if(T===this._total)E.setAttribute("d",this._createCompleteCirclePathData(_,this._radius,this._innerRadius));else{let I=2*(T/this._total*Math.PI);C=S+I,E.setAttribute("d",this._createSegmentPathData(_,S,C,this._radius,this._innerRadius)),S=C}}}}_createCompleteCirclePathData(_,S,C){const f=0,T=1.9999*Math.PI;let E=_+Math.cos(f)*S,I=_+Math.sin(f)*S,R=_+Math.cos(T)*S,N=_+Math.sin(T)*S,L=_+Math.cos(T)*C,D=_+Math.sin(T)*C,M=_+Math.cos(f)*C,P=_+Math.sin(f)*C;return["M",E,I,"A",S,S,0,1,1,R,N,"Z","M",L,D,"A",C,C,0,1,0,M,P,"Z"].join(" ")}_createSegmentPathData(_,S,C,f,T){const E=(C-S)%(2*Math.PI)>Math.PI?1:0;let I=_+Math.cos(S)*f,R=_+Math.sin(S)*f,N=_+Math.cos(C)*f,L=_+Math.sin(C)*f,D=_+Math.cos(C)*T,M=_+Math.sin(C)*T,P=_+Math.cos(S)*T,O=_+Math.sin(S)*T;return["M",I,R,"A",f,f,0,E,1,N,L,"L",D,M,"A",T,T,0,E,0,P,O,"Z"].join(" ")}},WebInspector.ClusterContentView=class extends WebInspector.ContentView{constructor(_){super(_),this.element.classList.add("cluster"),this._contentViewContainer=new WebInspector.ContentViewContainer,this._contentViewContainer.addEventListener(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange,this._currentContentViewDidChange,this),this.addSubview(this._contentViewContainer),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.SelectionPathComponentsDidChange,this._contentViewSelectionPathComponentDidChange,this),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.SupplementalRepresentedObjectsDidChange,this._contentViewSupplementalRepresentedObjectsDidChange,this),WebInspector.ContentView.addEventListener(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange,this._contentViewNumberOfSearchResultsDidChange,this)}get navigationItems(){var _=this._contentViewContainer.currentContentView;return _?_.navigationItems:[]}get contentViewContainer(){return this._contentViewContainer}get supportsSplitContentBrowser(){return this._contentViewContainer.currentContentView?this._contentViewContainer.currentContentView.supportsSplitContentBrowser:super.supportsSplitContentBrowser}shown(){super.shown(),this._contentViewContainer.shown()}hidden(){super.hidden(),this._contentViewContainer.hidden()}closed(){super.closed(),this._contentViewContainer.closeAllContentViews(),WebInspector.ContentView.removeEventListener(null,null,this)}canGoBack(){return this._contentViewContainer.canGoBack()}canGoForward(){return this._contentViewContainer.canGoForward()}goBack(){this._contentViewContainer.goBack()}goForward(){this._contentViewContainer.goForward()}get scrollableElements(){return this._contentViewContainer.currentContentView?this._contentViewContainer.currentContentView.scrollableElements:[]}get selectionPathComponents(){return this._contentViewContainer.currentContentView?this._contentViewContainer.currentContentView.selectionPathComponents:[]}get supplementalRepresentedObjects(){return this._contentViewContainer.currentContentView?this._contentViewContainer.currentContentView.supplementalRepresentedObjects:[]}get handleCopyEvent(){var _=this._contentViewContainer.currentContentView;return _&&"function"==typeof _.handleCopyEvent?_.handleCopyEvent.bind(_):null}get supportsSave(){var _=this._contentViewContainer.currentContentView;return _&&_.supportsSave}get saveData(){var _=this._contentViewContainer.currentContentView;return _&&_.saveData||null}get supportsSearch(){return!0}get numberOfSearchResults(){var _=this._contentViewContainer.currentContentView;return _&&_.supportsSearch?_.numberOfSearchResults:null}get hasPerformedSearch(){var _=this._contentViewContainer.currentContentView;return _&&_.supportsSearch&&_.hasPerformedSearch}set automaticallyRevealFirstSearchResult(_){var S=this._contentViewContainer.currentContentView;S&&S.supportsSearch&&(S.automaticallyRevealFirstSearchResult=_)}performSearch(_){this._searchQuery=_;var S=this._contentViewContainer.currentContentView;S&&S.supportsSearch&&S.performSearch(_)}searchCleared(){this._searchQuery=null;var _=this._contentViewContainer.currentContentView;_&&_.supportsSearch&&_.searchCleared()}searchQueryWithSelection(){var _=this._contentViewContainer.currentContentView;return _&&_.supportsSearch?_.searchQueryWithSelection():null}revealPreviousSearchResult(_){var S=this._contentViewContainer.currentContentView;S&&S.supportsSearch&&S.revealPreviousSearchResult(_)}revealNextSearchResult(_){var S=this._contentViewContainer.currentContentView;S&&S.supportsSearch&&S.revealNextSearchResult(_)}_currentContentViewDidChange(){var S=this._contentViewContainer.currentContentView;S&&S.supportsSearch&&(this._searchQuery?S.performSearch(this._searchQuery):S.searchCleared()),this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange),this.dispatchEventToListeners(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange),this.dispatchEventToListeners(WebInspector.ContentView.Event.NavigationItemsDidChange)}_contentViewSelectionPathComponentDidChange(_){_.target!==this._contentViewContainer.currentContentView||this.dispatchEventToListeners(WebInspector.ContentView.Event.SelectionPathComponentsDidChange)}_contentViewSupplementalRepresentedObjectsDidChange(_){_.target!==this._contentViewContainer.currentContentView||this.dispatchEventToListeners(WebInspector.ContentView.Event.SupplementalRepresentedObjectsDidChange)}_contentViewNumberOfSearchResultsDidChange(_){_.target!==this._contentViewContainer.currentContentView||this.dispatchEventToListeners(WebInspector.ContentView.Event.NumberOfSearchResultsDidChange)}},function(){function u(U,G){return G._linkQuoteCharacter?U.eatWhile(new RegExp("[^"+G._linkQuoteCharacter+"]")):U.eatWhile(/[^\s\u00a0=<>\"\']/),U.eol()||(G._linkTokenize=_),"link"}function _(U,G){G._linkQuoteCharacter&&U.eat(G._linkQuoteCharacter);var H=G._linkBaseStyle;return delete G._linkTokenize,delete G._linkQuoteCharacter,delete G._linkBaseStyle,delete G._srcSetTokenizeState,H}function S(U,G){return("link"===G._srcSetTokenizeState?G._linkQuoteCharacter?U.eatWhile(new RegExp("[^\\s,"+G._linkQuoteCharacter+"]")):U.eatWhile(/[^\s,\u00a0=<>\"\']/):(U.eatSpace(),G._linkQuoteCharacter?U.eatWhile(new RegExp("[^,"+G._linkQuoteCharacter+"]")):U.eatWhile(/[^\s\u00a0=<>\"\']/),U.eatWhile(/[\s,]/)),(U.eol()||!G._linkQuoteCharacter||U.peek()===G._linkQuoteCharacter)&&(G._linkTokenize=_),"link"===G._srcSetTokenizeState)?(G._srcSetTokenizeState="descriptor","link"):(G._srcSetTokenizeState="link",G._linkBaseStyle)}function f(U,G){if(G._unquotedURLString&&U.eatSpace())return null;for(var H=null,W=!1,z=!1,K=U.pos,q=G._urlQuoteCharacter;null!=(H=U.next());){if(H===q&&!W){z=!0;break}W=!W&&"\\"===H,/[\s\u00a0]/.test(H)||(K=U.pos)}return G._unquotedURLString&&(U.pos=K),z&&(!G._unquotedURLString&&U.backUp(1),this._urlTokenize=T),"link"}function T(U,G){G._unquotedURLString||U.eat(G._urlQuoteCharacter);var H=G._urlBaseStyle;return delete G._urlTokenize,delete G._urlQuoteCharacter,delete G._urlBaseStyle,H}function E(U,G){var H=/#(?:[0-9a-fA-F]{8}|[0-9a-fA-F]{6}|[0-9a-fA-F]{3,4})\b/g;if(G._urlTokenize){var W=G._urlTokenize(U,G);return W&&W+" m-"+(this.alternateName||this.name)}var z=U.pos,W=this._token(U,G);if(W)if("atom"===W)"url"===U.current()?G._expectLink=!0:H.test(U.current())&&(W+=" hex-color");else if(G._expectLink&&(delete G._expectLink,"string"===W)){G._urlTokenize=f,G._urlBaseStyle=W;var K=U.current()[0];G._urlQuoteCharacter="'"===K||"\""===K?K:")",G._unquotedURLString=")"===G._urlQuoteCharacter,U.pos=z,G._unquotedURLString||U.eat(G._urlQuoteCharacter)}return W&&W+" m-"+(this.alternateName||this.name)}function N(U,G){G.preventDefault(),setTimeout(function(){if(U.getWrapperElement().classList.contains("CodeMirror-focused")){var W=U.getScrollerElement().getElementsByClassName("CodeMirror-cursor")[0];W&&W.scrollIntoViewIfNeeded(!1)}},0)}function L(U,G){function H(q){var X=G.getTokenAt(q);return X&&X.type&&/\bnumber\b/.test(X.type)?X:null}var W=G.getCursor("head"),z=H(W);if(z||(W.ch+=1,z=H(W)),!z)return CodeMirror.Pass;var K=G.alterNumberInRange(U,{ch:z.start,line:W.line},{ch:z.end,line:W.line},!0);if(!K)return CodeMirror.Pass}CodeMirror.extendMode("css",{token:E}),CodeMirror.extendMode("xml",{token:function(U,G){if(G._linkTokenize){var H=G._linkTokenize(U,G);return H&&H+" m-"+this.name}var W=U.pos,H=this._token(U,G);if("attribute"===H){var z=U.current().toLowerCase();"src"===z||/\bhref\b/.test(z)?G._expectLink=!0:"srcset"===z?G._expectSrcSet=!0:(delete G._expectLink,delete G._expectSrcSet)}else if(G._expectLink&&"string"===H){var K=U.current();if("\"\""!==K&&"''"!==K){delete G._expectLink,G._linkTokenize=u,G._linkBaseStyle=H;var q=K[0];G._linkQuoteCharacter="'"===q||"\""===q?q:null,U.pos=W,G._linkQuoteCharacter&&U.eat(G._linkQuoteCharacter)}}else if(G._expectSrcSet&&"string"===H){var K=U.current();if("\"\""!==K&&"''"!==K){delete G._expectSrcSet,G._srcSetTokenizeState="link",G._linkTokenize=S,G._linkBaseStyle=H;var q=K[0];G._linkQuoteCharacter="'"===q||"\""===q?q:null,U.pos=W,G._linkQuoteCharacter&&U.eat(G._linkQuoteCharacter)}}else H&&(delete G._expectLink,delete G._expectSrcSet);return H&&H+" m-"+this.name}}),CodeMirror.extendMode("javascript",{token:function(U,G){var H=this._token(U,G);return H&&H+" m-"+(this.alternateName||this.name)}}),CodeMirror.defineMode("css-rule",CodeMirror.modes.css),CodeMirror.extendMode("css-rule",{token:E,startState:function(U){var G=this._startState(U);return G.state="block",G.context.type="block",G},alternateName:"css"}),CodeMirror.defineInitHook(function(U){U.on("scrollCursorIntoView",N)});CodeMirror.defineOption("showWhitespaceCharacters",!1,function(U,G,H){return!G||H&&H!==CodeMirror.Init?void U.removeOverlay("whitespace"):void U.addOverlay({name:"whitespace",token(W){if(" "===W.peek()){let z=0;for(;z<16&&" "===W.peek();)++z,W.next();return`whitespace whitespace-${z}`}for(;!W.eol()&&" "!==W.peek();)W.next();return null}})}),CodeMirror.defineExtension("hasLineClass",function(U,G,H){var W="text"===G?"textClass":"background"===G?"bgClass":"wrapClass",z=this.lineInfo(U);if(!z)return!1;if(!z[W])return!1;if(z[W]===H)return!0;var K=z[W].indexOf(H);if(-1===K)return!1;var q=" "+z[W]+" ";return-1!==q.indexOf(" "+H+" ",K)}),CodeMirror.defineExtension("setUniqueBookmark",function(U,G){for(var H=this.findMarksAt(U),W=0;W<H.length;++W)if(H[W].__uniqueBookmark){H[W].clear();break}var z=this.setBookmark(U,G);return z.__uniqueBookmark=!0,z}),CodeMirror.defineExtension("toggleLineClass",function(U,G,H){return this.hasLineClass(U,G,H)?(this.removeLineClass(U,G,H),!1):(this.addLineClass(U,G,H),!0)}),CodeMirror.defineExtension("alterNumberInRange",function(U,G,H,W){if(G.line!==H.line)return!1;if(W)var z=this.getCursor("start"),K=this.getCursor("end");for(var q=this.getLine(G.line),X=!1,Y=NaN,Q=NaN,J=G.ch,Z;0<=J;--J){if(Z=q.charAt(J),"."===Z){if(X)break;X=!0}else if("-"!==Z&&"+"!==Z&&isNaN(parseInt(Z))){if(J===G.ch){Q=J;continue}break}Y=J}if(isNaN(Q))for(var J=G.ch+1,Z;J<q.length;++J){if(Z=q.charAt(J),"."===Z){if(X){Q=J;break}X=!0}else if(isNaN(parseInt(Z))){Q=J;break}Q=J+1}if(isNaN(Y)||isNaN(Q))return!1;var $=parseFloat(q.substring(Y,Q)),ee=+($+U).toFixed(6),te=ee.toString(),ne={line:G.line,ch:Y},re={line:G.line,ch:Q};if(this.replaceRange(te,ne,re),W){var ae=re.ch-ne.ch,ie=te.length;let oe=ie-ae;z===K?z.ch+=oe:(z.ch>ne.ch&&(z.ch+=oe),K.ch>ne.ch&&(K.ch+=oe)),this.setSelection(z,K)}return!0}),CodeMirror.defineExtension("rectsForRange",function(U){for(var G=[],H=U.start.line;H<=U.end.line;++H){var W=this.getLine(H),z=H===U.start.line?U.start.ch:W.length-W.trimLeft().length,K=H===U.end.line?U.end.ch:W.length,q=this.cursorCoords({ch:z,line:H}),X=this.cursorCoords({ch:K,line:H});if(q.bottom!==X.bottom){for(var Y=-Number.MAX_VALUE,Q=z,J;Q<=K;++Q)if(J=this.cursorCoords({ch:Q,line:H}),J.bottom>Y){if(Q>z){var Z=Math.ceil(this.cursorCoords({ch:Q-1,line:H}).right);G.push(new WebInspector.Rect($,ee,Z-$,Y-ee))}var $=Math.floor(J.left),ee=Math.floor(J.top);Y=Math.ceil(J.bottom)}Z=Math.ceil(J.right),G.push(new WebInspector.Rect($,ee,Z-$,Y-ee))}else{var $=Math.floor(q.left),ee=Math.floor(q.top),Z=Math.ceil(X.right),Y=Math.ceil(X.bottom);G.push(new WebInspector.Rect($,ee,Z-$,Y-ee))}}return G});let M="mac"===WebInspector.Platform.name;CodeMirror.keyMap["default"]={"Alt-Up":L.bind(null,1),"Ctrl-Alt-Up":L.bind(null,0.1),"Shift-Alt-Up":L.bind(null,10),"Alt-PageUp":L.bind(null,10),"Shift-Alt-PageUp":L.bind(null,100),"Alt-Down":L.bind(null,-1),"Ctrl-Alt-Down":L.bind(null,-0.1),"Shift-Alt-Down":L.bind(null,-10),"Alt-PageDown":L.bind(null,-10),"Shift-Alt-PageDown":L.bind(null,-100),"Cmd-/":"toggleComment","Cmd-D":"selectNextOccurrence","Shift-Tab":"indentLess",fallthrough:M?"macDefault":"pcDefault"};["text/xml","text/xsl"].forEach(function(U){CodeMirror.defineMIME(U,"xml")});["application/xhtml+xml","image/svg+xml"].forEach(function(U){CodeMirror.defineMIME(U,"htmlmixed")});["text/ecmascript","application/javascript","application/ecmascript","application/x-javascript","text/x-javascript","text/javascript1.1","text/javascript1.2","text/javascript1.3","text/jscript","text/livescript"].forEach(function(U){CodeMirror.defineMIME(U,"javascript")});["application/x-json","text/x-json","application/vnd.api+json"].forEach(function(U){CodeMirror.defineMIME(U,{name:"javascript",json:!0})})}(),WebInspector.compareCodeMirrorPositions=function(u,_){var S=u.line-_.line;if(0!=S)return S;var C="ch"in u?u.ch:Number.MAX_VALUE,f="ch"in _?_.ch:Number.MAX_VALUE;return C-f},WebInspector.walkTokens=function(u,_,S,C){let f=CodeMirror.copyState(_,u.getTokenAt(S).state);f.localState&&(f=f.localState);let T=u.lineCount(),E=!1;for(let I=S.line;!E&&I<T;++I){let R=u.getLine(I),N=new CodeMirror.StringStream(R);for(I===S.line&&(N.start=N.pos=S.ch);!N.eol();){let L=_.token(N,f);if(!C(L,N.current())){E=!0;break}N.start=N.pos}}E||C(null)},WebInspector.CodeMirrorEditor=class{static create(_,S){void 0===S.lineSeparator&&(S.lineSeparator="\n"),_.setAttribute("dir","ltr");let C=new CodeMirror(_,S);return"mac"===WebInspector.Platform.name&&C.addKeyMap({Home:()=>{C.scrollIntoView({line:0,ch:0})},End:()=>{C.scrollIntoView({line:C.lineCount()-1,ch:null})}}),new WebInspector.CodeMirrorTextKillController(C),C}},CodeMirror.extendMode("javascript",{shouldHaveSpaceBeforeToken:function(u,_,S,C,f,T){return S?!!T||(/\boperator\b/.test(S)?(u||"+"!==f&&"-"!==f&&"~"!==f||")"===_||"]"===_)&&"!"!==f&&0<="+-/*%&&||!===+=-=>=<=?".indexOf(f):!!/\bkeyword\b/.test(S)&&("else"===f||"catch"===f||"finally"===f?"}"===_:"while"===f&&"}"===_&&"do"===C._jsPrettyPrint.lastContentBeforeBlock)):"("===f?u&&/\bkeyword\b/.test(u)&&"function"!==_&&"typeof"!==_&&"instanceof"!==_:":"===f&&("stat"===C.lexical.type||")"===C.lexical.type||"]"===C.lexical.type)},shouldHaveSpaceAfterLastToken:function(u,_,S,C,f){return u&&/\bkeyword\b/.test(u)?"else"===_||"catch"===_||("return"===_?";"!==f:"throw"===_||"try"===_||"finally"===_||"do"===_):u&&/\bcomment\b/.test(u)||(")"===_?"{"===f:";"===_?")"===C.lexical.type:"!"!==_&&("+"!==_&&"-"!==_&&"~"!==_||C._jsPrettyPrint.unaryOperatorHadLeadingExpr)&&0<=",+-/*%&&||:!===+=-=>=<=?".indexOf(_))},newlinesAfterToken:function(u,_,S,C,f,T){return S?T?1:0:","===f?"}"===C.lexical.type?1:0:";"===f?")"===C.lexical.type?0:1:":"===f&&"}"===C.lexical.type&&C.lexical.prev&&"form"===C.lexical.prev.type?1:1===f.length&&0<="{}".indexOf(f)?1:0},removeLastWhitespace:function(){return!1},removeLastNewline:function(u,_,S,C,f,T,E){return S?T?E||";"!==_?!1:!0:!!/\bkeyword\b/.test(S)&&("else"===f||"catch"===f||"finally"===f?"}"===_:"while"===f&&"}"===_&&"do"===C._jsPrettyPrint.lastContentBeforeBlock):"}"===f?"{"===_:";"===f?0<="};".indexOf(_):":"===f?"}"===_&&("stat"===C.lexical.type||")"===C.lexical.type||"]"===C.lexical.type):!!(0<=",().".indexOf(f))&&"}"===_},indentAfterToken:function(u,_,S,C,f){return!("{"!==f)||("case"===f||"default"===f)&&"}"===C.lexical.type&&C.lexical.prev&&"form"===C.lexical.prev.type},newlineBeforeToken:function(u,_,S,C,f){return!!C._jsPrettyPrint.shouldIndent||"}"===f&&"{"!==_},indentBeforeToken:function(u,_,S,C){return!!C._jsPrettyPrint.shouldIndent},dedentsBeforeToken:function(u,_,S,C,f){var E=0;return C._jsPrettyPrint.shouldDedent&&(E+=C._jsPrettyPrint.dedentSize),S||"}"!==f?S&&/\bkeyword\b/.test(S)&&("case"===f||"default"===f)&&(E+=1):E+=1,E},modifyStateForTokenPre:function(u,_,S,C,f,T){if(C._jsPrettyPrint||(C._jsPrettyPrint={indentCount:0,shouldIndent:!1,shouldDedent:!1,dedentSize:0,lastIfIndentCount:0,openBraceStartMarkers:[],openBraceTrackingCount:-1,unaryOperatorHadLeadingExpr:!1,lastContentBeforeBlock:void 0}),!T&&C.lexical.prev&&"form"===C.lexical.prev.type&&!C.lexical.prev._jsPrettyPrintMarker&&(")"===_||"else"===_||"do"===_)&&")"!==C.lexical.type){if("{"===f){var E={indentCount:C._jsPrettyPrint.indentCount,openBraceTrackingCount:C._jsPrettyPrint.openBraceTrackingCount,lastContentBeforeBlock:_};C._jsPrettyPrint.openBraceStartMarkers.push(E),C._jsPrettyPrint.openBraceTrackingCount=1}else"}"!==C.lexical.type&&("else"==_&&"if"==f||(C._jsPrettyPrint.indentCount++,C._jsPrettyPrint.shouldIndent=!0),C.lexical.prev._jsPrettyPrintMarker=!0,C._jsPrettyPrint.enteringIf&&(C._jsPrettyPrint.lastIfIndentCount=C._jsPrettyPrint.indentCount-1));}else if(T||("{"===f?C._jsPrettyPrint.openBraceTrackingCount++:"}"==f&&C._jsPrettyPrint.openBraceTrackingCount--),";"===f);else if("else"===f)"}"!=_&&(C._jsPrettyPrint.shouldDedent=!0,C._jsPrettyPrint.dedentSize=C._jsPrettyPrint.indentCount-C._jsPrettyPrint.lastIfIndentCount,C._jsPrettyPrint.lastIfIndentCount=0);else if("}"===f&&!C._jsPrettyPrint.openBraceTrackingCount&&C._jsPrettyPrint.openBraceStartMarkers.length){var E=C._jsPrettyPrint.openBraceStartMarkers.pop();C._jsPrettyPrint.shouldDedent=!0,C._jsPrettyPrint.dedentSize=C._jsPrettyPrint.indentCount-E.indentCount,C._jsPrettyPrint.openBraceTrackingCount=E.openBraceTrackingCount,C._jsPrettyPrint.lastContentBeforeBlock=E.lastContentBeforeBlock}else{for(var I=!0,R=C.lexical.prev;R;){if(R._jsPrettyPrintMarker){I=!1;break}R=R.prev}I&&(C._jsPrettyPrint.shouldDedent=!0,C._jsPrettyPrint.dedentSize=C._jsPrettyPrint.indentCount)}S&&"form"===C.lexical.type&&C.lexical.prev&&"form"!==C.lexical.prev&&/\bkeyword\b/.test(S)&&(C._jsPrettyPrint.enteringIf="if"===f)},modifyStateForTokenPost:function(u,_,S,C,f){C._jsPrettyPrint.shouldIndent&&(C._jsPrettyPrint.shouldIndent=!1),C._jsPrettyPrint.shouldDedent&&(C._jsPrettyPrint.indentCount-=C._jsPrettyPrint.dedentSize,C._jsPrettyPrint.dedentSize=0,C._jsPrettyPrint.shouldDedent=!1),C._jsPrettyPrint.unaryOperatorHadLeadingExpr=("+"===f||"-"===f||"~"===f)&&(")"===_||"]"===_||/\b(?:variable|number)\b/.test(u))}}),CodeMirror.extendMode("css",{shouldHaveSpaceBeforeToken:function(u,_,S,C,f,T){return S?!!T||!!/\bkeyword\b/.test(S)&&"!"===f.charAt(0):"{"===f||0<=">+~-*/".indexOf(f)},shouldHaveSpaceAfterLastToken:function(u,_,S,C,f){return u?!!/\bcomment\b/.test(u)||!!/\bkeyword\b/.test(u)&&("media"===C.state||"atBlock_parens"===C.state&&")"!==f):","===_||(":"===_?"prop"===C.state:")"===_&&")"!==f&&","!==f?!!/\bnumber\b/.test(S)||"prop"===C.state||"media"===C.state||"atBlock_parens"===C.state:0<=">+~-*/".indexOf(_))},newlinesAfterToken:function(u,_,S,C,f,T){return S?T?1:0:";"===f?1:","===f?("top"===C.state||"media"===C.state)&&60<C._cssPrettyPrint.lineLength?(C._cssPrettyPrint.lineLength=0,1):0:"{"===f?1:"}"===f?2:0},removeLastWhitespace:function(){return!1},removeLastNewline:function(u,_,S,C,f,T,E){return T?E||";"!==_?!1:!0:"}"===f&&("{"===_||"}"===_)},indentAfterToken:function(u,_,S,C,f){return"{"===f},newlineBeforeToken:function(u,_,S,C,f){return"}"===f&&"{"!==_&&"}"!==_},indentBeforeToken:function(){return!1},dedentsBeforeToken:function(u,_,S,C,f){return"}"===f?1:0},modifyStateForTokenPost:function(u,_,S,C,f,T){C._cssPrettyPrint||(C._cssPrettyPrint={lineLength:0}),T||"top"!==C.state&&"media"!==C.state&&"pseudo"!==C.state?C._cssPrettyPrint.lineLength=0:C._cssPrettyPrint.lineLength+=f.length}}),CodeMirror.extendMode("css-rule",{shouldHaveSpaceBeforeToken:function(u,_,S){if(":"===_&&!u)return!0;var E=/\b(?:keyword|atom|number)\b/;return E.test(u)&&E.test(S)},shouldHaveSpaceAfterLastToken:function(u,_){return","===_&&!u},newlinesAfterToken:function(){return 0},removeLastWhitespace:function(u,_,S,C,f,T){return!!T||(u?S?!!/\bcomment\b/.test(u):";"===f||":"===f:";"===_)},removeLastNewline:function(){return!0},indentAfterToken:function(){return!1},newlineBeforeToken:function(u,_,S,C,f,T){return!!T||("block"===C.state?/\bmeta\b/.test(S):!!/\bcomment\b/.test(u)||(/\bproperty\b/.test(S)?!/\bmeta\b/.test(u):"maybeprop"===C.state&&/\bvariable-2\b/.test(S)))},indentBeforeToken:function(){return!1},dedentsBeforeToken:function(){return 0}}),CodeMirror.defineMode("regex",function(){function u(C,f){let T=f.currentContext();if(void 0===T.negatedCharacterSet&&(T.negatedCharacterSet=C.eat("^"),T.negatedCharacterSet))return"regex-character-set-negate";for(;C.peek();){if(C.eat("\\"))return _(C);if(C.eat("]"))return f.tokenize=S,f.popContext();C.next()}return"error"}function _(C){return C.match(/[bBdDwWsStrnvf0]/)?"regex-special":C.eat("x")?C.match(/[0-9a-fA-F]{2}/)?"regex-escape":"error":C.eat("u")?C.match(/[0-9a-fA-F]{4}/)?"regex-escape-2":"error":C.eat("c")?C.match(/[A-Z]/)?"regex-escape-3":"error":C.match(/[1-9]/)?"regex-backreference":C.next()?"regex-literal":"error"}function S(C,f){let T=C.next();if("\\"===T)return _(C);if("("===T){let I;return C.match(/\?[=!]/)?I="regex-lookahead":(C.match(/\?:/),I="regex-group"),f.pushContext(C,I,")")}let E=f.currentContext();if(E&&E.type===T)return f.popContext();if(/[*+?]/.test(T))return"regex-quantifier";if("{"===T){if(C.match(/\d+}/))return"regex-quantifier";let I=C.match(/(\d+),(\d+)?}/);if(!I)return"error";let R=parseInt(I[1]),N=parseInt(I[2]);return R>N?"error":"regex-quantifier"}return"["===T?(f.tokenize=u,f.pushContext(C,"regex-character-set")):/[.^$|]/.test(T)?"regex-special":null}return{startState:function(){let C=[];return{currentContext:function(){return C.length?C[C.length-1]:null},pushContext:function(f,T,E){return C.push({data:T,type:E}),T},popContext:function(){return C.pop().data},tokenize:S}},token:function(C,f){return f.tokenize(C,f)}}}),CodeMirror.defineMIME("text/x-regex","regex");function createCodeMirrorTextMarkers(u,_,S,C,f,T){for(var E=[],I=f instanceof WebInspector.TextRange?f.startLine:0,R=f instanceof WebInspector.TextRange?f.endLine+1:C.lineCount(),N=I;N<R;++N)for(var L=C.getLine(N),D=_.exec(L);D;){if("function"==typeof S&&!S(L,D)){D=_.exec(L);continue}for(var M={line:N,ch:D.index},P={line:N,ch:D.index+D[0].length},O=!1,F=C.findMarksAt(P),V=0;V<F.length;++V)if(WebInspector.TextMarker.textMarkerForCodeMirrorTextMarker(F[V]).type===WebInspector.TextMarker.Type[u]){O=!0;break}if(O){D=_.exec(L);continue}var U=C.getTokenTypeAt(M);if(U&&!U.includes("keyword")){D=_.exec(L);continue}let H=D[1],W=WebInspector[u]?WebInspector[u].fromString(H):null;if(WebInspector[u]&&!W){D=_.exec(L);continue}var G=C.markText(M,P);G=new WebInspector.TextMarker(G,WebInspector.TextMarker.Type[u]),E.push(G),"function"==typeof T&&T(G,W,H),D=_.exec(L)}return E}function createCodeMirrorColorTextMarkers(u,_,S){let f=/((?:rgb|hsl)a?\([^)]+\)|#[0-9a-fA-F]{8}|#[0-9a-fA-F]{6}|#[0-9a-fA-F]{3,4}|\b\w+\b(?![-.]))/g;return createCodeMirrorTextMarkers("Color",f,function(T,E){if(!T||!T.length)return!1;let I=0,R=E.index,N=null;for(;(N=T[R])&&("("===N&&++I,")"===N&&--I,!(0<I))&&!(--R,0>R););return!/(repeating-)?(linear|radial)-gradient$/.test(T.substring(0,R))&&!(0<E.index&&/[-.\"\']/.test(T[E.index-1]))},u,_,S)}function createCodeMirrorGradientTextMarkers(u,_,S){for(var C=[],f=_ instanceof WebInspector.TextRange?_.startLine:0,T=_ instanceof WebInspector.TextRange?_.endLine+1:u.lineCount(),E=/(repeating-)?(linear|radial)-gradient\s*\(\s*/g,I=f;I<T;++I)for(var R=u.getLine(I),N=E.exec(R);N;){for(var L=I,D=N.index,M=N.index+N[0].length,P=0,O=null;O=R[M];){if("("===O&&P++,")"===O&&P--,-1==P){M++;break}if(M++,M>=R.length&&(I++,M=0,R=u.getLine(I),!R))break}if(-1!=P){N=E.exec(R);continue}var F={line:L,ch:D},V={line:I,ch:M},U=u.getRange(F,V),G=WebInspector.Gradient.fromString(U);if(!G){N=E.exec(R);continue}var H=new WebInspector.TextMarker(u.markText(F,V),WebInspector.TextMarker.Type.Gradient);C.push(H),"function"==typeof S&&S(H,G,U),N=E.exec(R)}return C}function createCodeMirrorCubicBezierTextMarkers(u,_,S){var C=/(cubic-bezier\([^)]+\)|\b\w+\b(?:-\b\w+\b){0,2})/g;return createCodeMirrorTextMarkers("CubicBezier",C,null,u,_,S)}function createCodeMirrorSpringTextMarkers(u,_,S){const C=/(spring\([^)]+\))/g;return createCodeMirrorTextMarkers("Spring",C,null,u,_,S)}function createCodeMirrorVariableTextMarkers(u,_,S){const C=/var\((--[\w-]+)\)/g;return createCodeMirrorTextMarkers("Variable",C,null,u,_,S)}WebInspector.CollectionContentView=class extends WebInspector.ContentView{constructor(_){super(_),this.representedObject.addEventListener(WebInspector.Collection.Event.ItemAdded,this._handleItemAdded,this),this.representedObject.addEventListener(WebInspector.Collection.Event.ItemRemoved,this._handleItemRemoved,this),this._contentViewMap=new WeakMap,this._handleClickMap=new WeakMap,this._contentViewConstructor=null;let S="";switch(this.representedObject.typeVerifier){case WebInspector.Collection.TypeVerifier.Frame:S=WebInspector.UIString("Frames");break;case WebInspector.Collection.TypeVerifier.ContentFlow:S=WebInspector.UIString("Flows");break;case WebInspector.Collection.TypeVerifier.Script:S=WebInspector.UIString("Extra Scripts");break;case WebInspector.Collection.TypeVerifier.Resource:S=WebInspector.UIString("Resource");break;case WebInspector.ResourceCollection.TypeVerifier.Document:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Document,!0);break;case WebInspector.ResourceCollection.TypeVerifier.Stylesheet:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Stylesheet,!0);break;case WebInspector.ResourceCollection.TypeVerifier.Image:this._contentViewConstructor=WebInspector.ImageResourceContentView,S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Image,!0);break;case WebInspector.ResourceCollection.TypeVerifier.Font:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Font,!0);break;case WebInspector.ResourceCollection.TypeVerifier.Script:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Script,!0);break;case WebInspector.ResourceCollection.TypeVerifier.XHR:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.XHR,!0);break;case WebInspector.ResourceCollection.TypeVerifier.Fetch:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Fetch,!0);break;case WebInspector.ResourceCollection.TypeVerifier.WebSocket:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.WebSocket,!0);break;case WebInspector.ResourceCollection.TypeVerifier.Other:S=WebInspector.Resource.displayNameForType(WebInspector.Resource.Type.Other,!0);}this._contentPlaceholder=new WebInspector.TitleView(S),this.element.classList.add("collection")}initialLayout(){let _=this.representedObject.items;if(this._contentViewConstructor&&_.size)for(let S of _)this._addContentViewForItem(S);else this.addSubview(this._contentPlaceholder)}_addContentViewForItem(_){if(this._contentViewConstructor){this._contentPlaceholder.parentView&&this.removeSubview(this._contentPlaceholder);let S=new this._contentViewConstructor(_);S.addEventListener(WebInspector.ResourceContentView.Event.ContentError,this._handleContentError,this);let C=f=>{0!==f.button||f.ctrlKey||WebInspector.showRepresentedObject(_)};this._handleClickMap.set(_,C),S.element.addEventListener("click",C),S.element.title=WebInspector.displayNameForURL(_.url,_.urlComponents),this.addSubview(S),this._contentViewMap.set(_,S)}}_removeContentViewForItem(_){if(this._contentViewConstructor){let S=this._contentViewMap.get(_);if(S){this.removeSubview(S),this._contentViewMap.delete(_),S.removeEventListener(null,null,this);let C=this._handleClickMap.get(_);C&&(S.element.removeEventListener("click",C),this._handleClickMap.delete(_)),this.representedObject.resources.length||this.addSubview(this._contentPlaceholder)}}}_handleItemAdded(_){let S=_.data.item;S&&this._addContentViewForItem(S)}_handleItemRemoved(_){let S=_.data.item;S&&this._removeContentViewForItem(S)}_handleContentError(_){_&&_.target&&this._removeContentViewForItem(_.target.representedObject)}},WebInspector.ColorPicker=class extends WebInspector.Object{constructor(){function _(C,{min:T=0,max:E=100,step:I=1,units:f}={}){let R=S.createChild("div");R.append(C);let N=R.createChild("input");return N.type="number",N.min=T,N.max=E,N.step=I,N.addEventListener("input",this._handleColorInputInput.bind(this)),f&&f.length&&R.append(f),{containerElement:R,numberInputElement:N}}super(),this._colorWheel=new WebInspector.ColorWheel,this._colorWheel.delegate=this,this._colorWheel.dimension=200,this._brightnessSlider=new WebInspector.Slider,this._brightnessSlider.delegate=this,this._brightnessSlider.element.classList.add("brightness"),this._opacitySlider=new WebInspector.Slider,this._opacitySlider.delegate=this,this._opacitySlider.element.classList.add("opacity");let S=document.createElement("div");S.classList.add("color-inputs"),this._colorInputs=new Map([["R",_.call(this,"R",{max:255})],["G",_.call(this,"G",{max:255})],["B",_.call(this,"B",{max:255})],["H",_.call(this,"H",{max:360})],["S",_.call(this,"S",{units:"%"})],["L",_.call(this,"L",{units:"%"})],["A",_.call(this,"A"),{max:1,step:0.01}]]),this._element=document.createElement("div"),this._element.classList.add("color-picker"),this._element.appendChild(this._colorWheel.element),this._element.appendChild(this._brightnessSlider.element),this._element.appendChild(this._opacitySlider.element),this._element.appendChild(S),this._opacity=0,this._opacityPattern="url(Images/Checkers.svg)",this._color=WebInspector.Color.fromString("white"),this._dontUpdateColor=!1,this._enableColorComponentInputs=!0}get element(){return this._element}set brightness(_){_===this._brightness||(this._colorWheel.brightness=_,this._updateColor(),this._updateSliders(this._colorWheel.rawColor,this._colorWheel.tintedColor))}set opacity(_){_===this._opacity||(this._opacity=_,this._updateColor())}get colorWheel(){return this._colorWheel}get color(){return this._color}set color(_){this._dontUpdateColor=!0;let S=!this._color||this._color.format!==_.format;this._color=_,this._colorWheel.tintedColor=this._color,this._brightnessSlider.value=this._colorWheel.brightness,this._opacitySlider.value=this._color.alpha,this._updateSliders(this._colorWheel.rawColor,this._color),this._showColorComponentInputs(),S&&this._handleFormatChange(),this._dontUpdateColor=!1}set enableColorComponentInputs(_){this._enableColorComponentInputs=_,this._showColorComponentInputs()}colorWheelColorDidChange(){this._updateColor(),this._updateSliders(this._colorWheel.rawColor,this._colorWheel.tintedColor)}sliderValueDidChange(_,S){_===this._opacitySlider?this.opacity=S:_===this._brightnessSlider&&(this.brightness=S)}_updateColor(){if(!this._dontUpdateColor){let _=Math.round(100*this._opacity)/100,S=this._color.format,C=null;S===WebInspector.Color.Format.HSL||S===WebInspector.Color.Format.HSLA?(C=this._colorWheel.tintedColor.hsl.concat(_),1!=_&&(S=WebInspector.Color.Format.HSLA)):(C=this._colorWheel.tintedColor.rgb.concat(_),1!=_&&S===WebInspector.Color.Format.RGB&&(S=WebInspector.Color.Format.RGBA));let f=this._color.format===S;this._color=new WebInspector.Color(S,C),this._showColorComponentInputs(),this.dispatchEventToListeners(WebInspector.ColorPicker.Event.ColorChanged,{color:this._color}),f&&this._handleFormatChange()}}_updateSliders(_){var C=this._colorWheel.tintedColor.rgb,f=new WebInspector.Color(WebInspector.Color.Format.RGBA,C.concat(1)).toString(),T=new WebInspector.Color(WebInspector.Color.Format.RGBA,C.concat(0)).toString();this._opacitySlider.element.style.backgroundImage="linear-gradient(90deg, "+T+", "+f+"), "+this._opacityPattern,this._brightnessSlider.element.style.backgroundImage="linear-gradient(90deg, black, "+_+")"}_handleFormatChange(){this._element.classList.toggle("hide-inputs",this._color.format!==WebInspector.Color.Format.Keyword&&this._color.format!==WebInspector.Color.Format.RGB&&this._color.format!==WebInspector.Color.Format.RGBA&&this._color.format!==WebInspector.Color.Format.HEX&&this._color.format!==WebInspector.Color.Format.ShortHEX&&this._color.format!==WebInspector.Color.Format.HEXAlpha&&this._color.format!==WebInspector.Color.Format.ShortHEXAlpha&&this._color.format!==WebInspector.Color.Format.HSL&&this._color.format!==WebInspector.Color.Format.HSLA),this.dispatchEventToListeners(WebInspector.ColorPicker.Event.FormatChanged)}_showColorComponentInputs(){function _(R,N){let{containerElement:L,numberInputElement:D}=this._colorInputs.get(R);D.value=N,L.hidden=!1}for(let{containerElement:R}of this._colorInputs.values())R.hidden=!0;if(this._enableColorComponentInputs){switch(this._color.format){case WebInspector.Color.Format.RGB:case WebInspector.Color.Format.RGBA:case WebInspector.Color.Format.HEX:case WebInspector.Color.Format.ShortHEX:case WebInspector.Color.Format.HEXAlpha:case WebInspector.Color.Format.ShortHEXAlpha:case WebInspector.Color.Format.Keyword:var[S,C,f]=this._color.rgb;_.call(this,"R",S),_.call(this,"G",C),_.call(this,"B",f);break;case WebInspector.Color.Format.HSL:case WebInspector.Color.Format.HSLA:var[T,E,I]=this._color.hsl;_.call(this,"H",T),_.call(this,"S",E),_.call(this,"L",I);break;default:return;}(this._color.format===WebInspector.Color.Format.Keyword&&1!==this._color.alpha||this._color.format===WebInspector.Color.Format.RGBA||this._color.format===WebInspector.Color.Format.HSLA||this._color.format===WebInspector.Color.Format.HEXAlpha||this._color.format===WebInspector.Color.Format.ShortHEXAlpha)&&_.call(this,"A",this._color.alpha)}}_handleColorInputInput(){if(!this._enableColorComponentInputs)return void WebInspector.reportInternalError("Input event fired for disabled color component input");let S=this._colorInputs.get("R").numberInputElement.value,C=this._colorInputs.get("G").numberInputElement.value,f=this._colorInputs.get("B").numberInputElement.value,T=this._colorInputs.get("H").numberInputElement.value,E=this._colorInputs.get("S").numberInputElement.value,I=this._colorInputs.get("L").numberInputElement.value,R=this._colorInputs.get("A").numberInputElement.value,N="",L=this._color.format;switch(L){case WebInspector.Color.Format.RGB:case WebInspector.Color.Format.HEX:case WebInspector.Color.Format.ShortHEX:case WebInspector.Color.Format.Keyword:N=`rgb(${S}, ${C}, ${f})`;break;case WebInspector.Color.Format.RGBA:case WebInspector.Color.Format.HEXAlpha:case WebInspector.Color.Format.ShortHEXAlpha:N=`rgba(${S}, ${C}, ${f}, ${R})`;break;case WebInspector.Color.Format.HSL:N=`hsl(${T}, ${E}%, ${I}%)`;break;case WebInspector.Color.Format.HSLA:N=`hsla(${T}, ${E}%, ${I}%, ${R})`;break;default:return void WebInspector.reportInternalError(`Input event fired for invalid color format "${this._color.format}"`);}this.color=WebInspector.Color.fromString(N),this._color.format=L,this.dispatchEventToListeners(WebInspector.ColorPicker.Event.ColorChanged,{color:this._color})}},WebInspector.ColorPicker.Event={ColorChanged:"css-color-picker-color-changed",FormatChanged:"css-color-picker-format-changed"},WebInspector.ColorWheel=class extends WebInspector.Object{constructor(){super(),this._rawCanvas=document.createElement("canvas"),this._tintedCanvas=document.createElement("canvas"),this._finalCanvas=document.createElement("canvas"),this._crosshair=document.createElement("div"),this._crosshair.className="crosshair",this._element=document.createElement("div"),this._element.className="color-wheel",this._element.appendChild(this._finalCanvas),this._element.appendChild(this._crosshair),this._finalCanvas.addEventListener("mousedown",this)}set dimension(_){this._element.style.width=this.element.style.height=`${_}px`,this._finalCanvas.width=this._tintedCanvas.width=this._rawCanvas.width=_*window.devicePixelRatio,this._finalCanvas.height=this._tintedCanvas.height=this._rawCanvas.height=_*window.devicePixelRatio,this._finalCanvas.style.width=this._finalCanvas.style.height=_+"px",this._dimension=_,this._radius=_/2-2,this._setCrosshairPosition(new WebInspector.Point(_/2,_/2)),this._drawRawCanvas(),this._draw()}get element(){return this._element}get brightness(){return this._brightness}set brightness(_){this._brightness=_,this._draw()}get tintedColor(){return this._crosshairPosition?this._colorAtPointWithBrightness(this._crosshairPosition.x*window.devicePixelRatio,this._crosshairPosition.y*window.devicePixelRatio,this._brightness):new WebInspector.Color(WebInspector.Color.Format.RGBA,[0,0,0,0])}set tintedColor(_){var S=this._tintedColorToPointAndBrightness(_);this._setCrosshairPosition(S.point),this.brightness=S.brightness}get rawColor(){return this._crosshairPosition?this._colorAtPointWithBrightness(this._crosshairPosition.x*window.devicePixelRatio,this._crosshairPosition.y*window.devicePixelRatio,1):new WebInspector.Color(WebInspector.Color.Format.RGBA,[0,0,0,0])}handleEvent(_){switch(_.type){case"mousedown":this._handleMousedown(_);break;case"mousemove":this._handleMousemove(_);break;case"mouseup":this._handleMouseup(_);}}_handleMousedown(_){window.addEventListener("mousemove",this,!0),window.addEventListener("mouseup",this,!0),this._updateColorForMouseEvent(_)}_handleMousemove(_){this._updateColorForMouseEvent(_)}_handleMouseup(){window.removeEventListener("mousemove",this,!0),window.removeEventListener("mouseup",this,!0)}_pointInCircleForEvent(_){function C(N,L){return Math.atan2(L.y-N.y,L.x-N.x)}function f(N,L,D){return new WebInspector.Point(N.x+L*Math.cos(D),N.y+L*Math.sin(D))}var T=this._dimension,E=window.webkitConvertPointFromPageToNode(this._finalCanvas,new WebKitPoint(_.pageX,_.pageY)),I=new WebInspector.Point(T/2,T/2);if(function(N,L){return Math.sqrt(Math.pow(N.x-L.x,2)+Math.pow(N.y-L.y,2))}(E,I)>this._radius){var R=C(I,E);E=f(I,this._radius,R)}return E}_updateColorForMouseEvent(_){var S=this._pointInCircleForEvent(_);this._setCrosshairPosition(S),this.delegate&&"function"==typeof this.delegate.colorWheelColorDidChange&&this.delegate.colorWheelColorDidChange(this)}_setCrosshairPosition(_){this._crosshairPosition=_,this._crosshair.style.webkitTransform="translate("+Math.round(_.x)+"px, "+Math.round(_.y)+"px)"}_tintedColorToPointAndBrightness(_){var S=_.rgb,C=WebInspector.Color.rgb2hsv(S[0],S[1],S[2]),f=Math.cos(C[0]*Math.PI/180),T=Math.sin(C[0]*Math.PI/180),E=this._dimension/2,I=E+E*f*C[1],R=E-E*T*C[1];return{point:new WebInspector.Point(I,R),brightness:C[2]}}_drawRawCanvas(){var _=this._rawCanvas.getContext("2d"),S=this._dimension*window.devicePixelRatio;_.fillStyle="white",_.fillRect(0,0,S,S);for(var C=_.getImageData(0,0,S,S),f=C.data,T=0;T<S;++T)for(var E=0,I;E<S;++E)if(I=this._colorAtPointWithBrightness(E,T,1),I){var R=4*(T*S+E);f[R]=I.rgb[0],f[R+1]=I.rgb[1],f[R+2]=I.rgb[2]}_.putImageData(C,0,0)}_colorAtPointWithBrightness(_,S,C){var f=this._dimension/2*window.devicePixelRatio,T=_-f,E=S-f,I=Math.sqrt(T*T+E*E);if(1e-3<I-f)return new WebInspector.Color(WebInspector.Color.Format.RGBA,[0,0,0,0]);var R=180*Math.atan2(S-f,f-_)/Math.PI;R=(R+180)%360;var L=Math.max(0,I)/f,D=WebInspector.Color.hsv2rgb(R,L,C);return new WebInspector.Color(WebInspector.Color.Format.RGBA,[Math.round(255*D[0]),Math.round(255*D[1]),Math.round(255*D[2]),1])}_drawTintedCanvas(){var _=this._tintedCanvas.getContext("2d"),S=this._dimension*window.devicePixelRatio;_.save(),_.drawImage(this._rawCanvas,0,0,S,S),1!==this._brightness&&(_.globalAlpha=1-this._brightness,_.fillStyle="black",_.fillRect(0,0,S,S)),_.restore()}_draw(){this._drawTintedCanvas();var _=this._finalCanvas.getContext("2d"),S=this._dimension*window.devicePixelRatio,C=this._radius*window.devicePixelRatio;_.save(),_.clearRect(0,0,S,S),_.beginPath(),_.arc(S/2,S/2,C+1,0,2*Math.PI,!0),_.closePath(),_.clip(),_.drawImage(this._tintedCanvas,0,0,S,S),_.restore()}},WebInspector.CompletionSuggestionsView=class extends WebInspector.Object{constructor(_){super(),this._delegate=_||null,this._selectedIndex=NaN,this._element=document.createElement("div"),this._element.classList.add("completion-suggestions",WebInspector.Popover.IgnoreAutoDismissClassName),this._containerElement=document.createElement("div"),this._containerElement.classList.add("completion-suggestions-container"),this._containerElement.addEventListener("mousedown",this._mouseDown.bind(this)),this._containerElement.addEventListener("mouseup",this._mouseUp.bind(this)),this._containerElement.addEventListener("click",this._itemClicked.bind(this)),this._element.appendChild(this._containerElement)}get delegate(){return this._delegate}get visible(){return!!this._element.parentNode}get selectedIndex(){return this._selectedIndex}set selectedIndex(_){var S=this._selectedItemElement;S&&S.classList.remove(WebInspector.CompletionSuggestionsView.SelectedItemStyleClassName),this._selectedIndex=_,S=this._selectedItemElement;S&&(S.classList.add(WebInspector.CompletionSuggestionsView.SelectedItemStyleClassName),S.scrollIntoViewIfNeeded(!1))}selectNext(){var _=this._containerElement.children.length;isNaN(this._selectedIndex)||this._selectedIndex===_-1?this.selectedIndex=0:++this.selectedIndex;var S=this._selectedItemElement;S&&this._delegate&&"function"==typeof this._delegate.completionSuggestionsSelectedCompletion&&this._delegate.completionSuggestionsSelectedCompletion(this,S.textContent)}selectPrevious(){isNaN(this._selectedIndex)||0===this._selectedIndex?this.selectedIndex=this._containerElement.children.length-1:--this.selectedIndex;var _=this._selectedItemElement;_&&this._delegate&&"function"==typeof this._delegate.completionSuggestionsSelectedCompletion&&this._delegate.completionSuggestionsSelectedCompletion(this,_.textContent)}isHandlingClickEvent(){return this._mouseIsDown}show(_){this._containerElement.style.position="absolute",document.body.appendChild(this._containerElement);var S=this._containerElement.offsetWidth,C=this._containerElement.offsetHeight;this._containerElement.removeAttribute("style"),this._element.appendChild(this._containerElement);var f=10,T=22,I=_.origin.x,R=_.origin.y+_.size.height,N=window.innerWidth-_.origin.x-f,L=Math.min(S,N-T)+T;L<S+T&&(N=window.innerWidth-f,L=Math.min(S,N-T)+T,I=document.body.offsetWidth-L);var M=_.origin.y,P=window.innerHeight-_.origin.y-_.size.height,O=Math.min(160,Math.max(P,M)-f),F=Math.min(C,O);0>P-F&&(R=M-F),this._element.style.left=I+"px",this._element.style.top=R+"px",this._element.style.width=L+"px",this._element.style.height=F+"px",document.body.appendChild(this._element)}hide(){this._element.remove()}update(_,S){this._containerElement.removeChildren(),"number"==typeof S&&(this._selectedIndex=S);for(var C=0,f;C<_.length;++C)f=document.createElement("div"),f.className=WebInspector.CompletionSuggestionsView.ItemElementStyleClassName,f.textContent=_[C],C===this._selectedIndex&&f.classList.add(WebInspector.CompletionSuggestionsView.SelectedItemStyleClassName),this._containerElement.appendChild(f),this._delegate&&"function"==typeof this._delegate.completionSuggestionsViewCustomizeCompletionElement&&this._delegate.completionSuggestionsViewCustomizeCompletionElement(this,f,_[C])}get _selectedItemElement(){if(isNaN(this._selectedIndex))return null;var _=this._containerElement.children[this._selectedIndex]||null;return _}_mouseDown(_){0!==_.button||(this._mouseIsDown=!0)}_mouseUp(_){0!==_.button||(this._mouseIsDown=!1)}_itemClicked(_){if(0===_.button){var S=_.target.enclosingNodeOrSelfWithClass(WebInspector.CompletionSuggestionsView.ItemElementStyleClassName);!S||this._delegate&&"function"==typeof this._delegate.completionSuggestionsClickedCompletion&&this._delegate.completionSuggestionsClickedCompletion(this,S.textContent)}}},WebInspector.CompletionSuggestionsView.ItemElementStyleClassName="item",WebInspector.CompletionSuggestionsView.SelectedItemStyleClassName="selected",WebInspector.ComputedStyleDetailsPanel=class extends WebInspector.StyleDetailsPanel{constructor(_){super(_,WebInspector.ComputedStyleDetailsPanel.StyleClassName,"computed",WebInspector.UIString("Styles \u2014 Computed")),this._computedStyleShowAllSetting=new WebInspector.Setting("computed-style-show-all",!1),this.cssStyleDeclarationTextEditorShouldAddPropertyGoToArrows=!0}get regionFlow(){return this._regionFlow}set regionFlow(_){this._regionFlow=_,this._regionFlowNameLabelValue.textContent=_?_.name:"",this._regionFlowNameRow.value=_?this._regionFlowFragment:null,this._updateFlowNamesSectionVisibility()}get contentFlow(){return this._contentFlow}set contentFlow(_){this._contentFlow=_,this._contentFlowNameLabelValue.textContent=_?_.name:"",this._contentFlowNameRow.value=_?this._contentFlowFragment:null,this._updateFlowNamesSectionVisibility()}get containerRegions(){return this._containerRegions}set containerRegions(_){if(this._containerRegions=_,!_||!_.length)return void this._containerRegionsFlowSection.element.classList.add("hidden");this._containerRegionsDataGrid.removeChildren();for(var S of _)this._containerRegionsDataGrid.appendChild(new WebInspector.DOMTreeDataGridNode(S));this._containerRegionsFlowSection.element.classList.remove("hidden"),this._containerRegionsDataGrid.updateLayoutIfNeeded()}cssStyleDeclarationTextEditorShowProperty(_,S){function C(){"function"==typeof this._delegate.computedStyleDetailsPanelShowProperty&&this._delegate.computedStyleDetailsPanelShowProperty(_)}if(!S)return void C.call(this);let f=this._nodeStyles.effectivePropertyForName(_.name);if(!f||!f.styleSheetTextRange){if(!f.relatedShorthandProperty)return void C.call(this);f=f.relatedShorthandProperty}let T=f.ownerStyle.ownerRule;if(!T)return void C.call(this);let E=T.sourceCodeLocation.sourceCode,{startLine:I,startColumn:R}=f.styleSheetTextRange;WebInspector.showSourceCodeLocation(E.createSourceCodeLocation(I,R),{ignoreNetworkTab:!0,ignoreSearchTab:!0})}refresh(_){return _?void(this._propertiesTextEditor.style=this.nodeStyles.computedStyle,this._variablesTextEditor.style=this.nodeStyles.computedStyle,this._refreshFlowDetails(this.nodeStyles.node),this._boxModelDiagramRow.nodeStyles=this.nodeStyles,super.refresh(),this._variablesSection.element.classList.toggle("hidden",!this._variablesTextEditor.shownProperties.length)):void super.refresh()}filterDidChange(_){let S=_.filters.text;this._propertiesTextEditor.removeNonMatchingProperties(S),this._variablesTextEditor.removeNonMatchingProperties(S)}initialLayout(){let _=document.createElement("label");_.textContent=WebInspector.UIString("Show All"),this._computedStyleShowAllCheckbox=document.createElement("input"),this._computedStyleShowAllCheckbox.type="checkbox",this._computedStyleShowAllCheckbox.checked=this._computedStyleShowAllSetting.value,this._computedStyleShowAllCheckbox.addEventListener("change",this._computedStyleShowAllCheckboxValueChanged.bind(this)),_.appendChild(this._computedStyleShowAllCheckbox),this._propertiesTextEditor=new WebInspector.CSSStyleDeclarationTextEditor(this),this._propertiesTextEditor.propertyVisibilityMode=WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.HideVariables,this._propertiesTextEditor.showsImplicitProperties=this._computedStyleShowAllSetting.value,this._propertiesTextEditor.alwaysShowPropertyNames=["display","width","height"],this._propertiesTextEditor.sortProperties=!0;let S=new WebInspector.DetailsSectionRow,C=new WebInspector.DetailsSectionGroup([S]),f=new WebInspector.DetailsSection("computed-style-properties",WebInspector.UIString("Properties"),[C],_);f.addEventListener(WebInspector.DetailsSection.Event.CollapsedStateChanged,this._handlePropertiesSectionCollapsedStateChanged,this),this.addSubview(this._propertiesTextEditor),S.element.appendChild(this._propertiesTextEditor.element),this._variablesTextEditor=new WebInspector.CSSStyleDeclarationTextEditor(this),this._variablesTextEditor.propertyVisibilityMode=WebInspector.CSSStyleDeclarationTextEditor.PropertyVisibilityMode.HideNonVariables,this._variablesTextEditor.sortProperties=!0;let T=new WebInspector.DetailsSectionRow,E=new WebInspector.DetailsSectionGroup([T]);this._variablesSection=new WebInspector.DetailsSection("computed-style-properties",WebInspector.UIString("Variables"),[E]),this._variablesSection.addEventListener(WebInspector.DetailsSection.Event.CollapsedStateChanged,this._handleVariablesSectionCollapsedStateChanged,this),this.addSubview(this._variablesTextEditor),T.element.appendChild(this._variablesTextEditor.element),this._regionFlowFragment=document.createElement("span"),this._regionFlowFragment.appendChild(document.createElement("img")).className="icon",this._regionFlowNameLabelValue=this._regionFlowFragment.appendChild(document.createElement("span"));let I=this._regionFlowFragment.appendChild(WebInspector.createGoToArrowButton());I.addEventListener("click",this._goToRegionFlowArrowWasClicked.bind(this)),this._regionFlowNameRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Region Flow")),this._regionFlowNameRow.element.classList.add("content-flow-link"),this._contentFlowFragment=document.createElement("span"),this._contentFlowFragment.appendChild(document.createElement("img")).className="icon",this._contentFlowNameLabelValue=this._contentFlowFragment.appendChild(document.createElement("span"));let R=this._contentFlowFragment.appendChild(WebInspector.createGoToArrowButton());R.addEventListener("click",this._goToContentFlowArrowWasClicked.bind(this)),this._contentFlowNameRow=new WebInspector.DetailsSectionSimpleRow(WebInspector.UIString("Content Flow")),this._contentFlowNameRow.element.classList.add("content-flow-link");let N=new WebInspector.DetailsSectionGroup([this._regionFlowNameRow,this._contentFlowNameRow]);this._flowNamesSection=new WebInspector.DetailsSection("content-flow",WebInspector.UIString("Flows"),[N]),this._containerRegionsDataGrid=new WebInspector.DOMTreeDataGrid,this._containerRegionsDataGrid.headerVisible=!1,this._containerRegionsRow=new WebInspector.DetailsSectionDataGridRow(this._containerRegionsDataGrid);let L=new WebInspector.DetailsSectionGroup([this._containerRegionsRow]);this._containerRegionsFlowSection=new WebInspector.DetailsSection("container-regions",WebInspector.UIString("Container Regions"),[L]),this.element.appendChild(f.element),this.element.appendChild(this._variablesSection.element),this.element.appendChild(this._flowNamesSection.element),this.element.appendChild(this._containerRegionsFlowSection.element),this._resetFlowDetails(),this._boxModelDiagramRow=new WebInspector.BoxModelDetailsSectionRow;let D=new WebInspector.DetailsSectionGroup([this._boxModelDiagramRow]),M=new WebInspector.DetailsSection("style-box-model",WebInspector.UIString("Box Model"),[D]);this.element.appendChild(M.element)}sizeDidChange(){super.sizeDidChange(),this._containerRegionsRow.sizeDidChange()}_computedStyleShowAllCheckboxValueChanged(){let S=this._computedStyleShowAllCheckbox.checked;this._computedStyleShowAllSetting.value=S,this._propertiesTextEditor.showsImplicitProperties=S,this._propertiesTextEditor.updateLayout()}_handlePropertiesSectionCollapsedStateChanged(_){_&&_.data&&!_.data.collapsed&&this._propertiesTextEditor.refresh()}_handleVariablesSectionCollapsedStateChanged(_){_&&_.data&&!_.data.collapsed&&this._variablesTextEditor.refresh()}_updateFlowNamesSectionVisibility(){this._flowNamesSection.element.classList.toggle("hidden",!this._contentFlow&&!this._regionFlow)}_resetFlowDetails(){this.regionFlow=null,this.contentFlow=null,this.containerRegions=null}_refreshFlowDetails(_){this._resetFlowDetails();_&&WebInspector.domTreeManager.getNodeContentFlowInfo(_,function(C,f){return C||!f?void this._resetFlowDetails():void(this.regionFlow=f.regionFlow,this.contentFlow=f.contentFlow,this.containerRegions=f.regions)}.bind(this))}_goToRegionFlowArrowWasClicked(){WebInspector.showRepresentedObject(this._regionFlow)}_goToContentFlowArrowWasClicked(){WebInspector.showRepresentedObject(this._contentFlow,{nodeToSelect:this.nodeStyles.node})}},WebInspector.ComputedStyleDetailsPanel.StyleClassName="computed",WebInspector.ConsoleDrawer=class extends WebInspector.ContentBrowser{constructor(_){super(_,null,!0,!1),this.element.classList.add("console-drawer"),this._drawerHeightSetting=new WebInspector.Setting("console-drawer-height",150),this.navigationBar.element.addEventListener("mousedown",this._consoleResizerMouseDown.bind(this)),this._toggleDrawerButton=new WebInspector.ToggleButtonNavigationItem("toggle-drawer",WebInspector.UIString("Hide Console"),WebInspector.UIString("Show Console"),"Images/HideConsoleDrawer.svg","Images/ShowConsoleDrawer.svg"),this._toggleDrawerButton.addEventListener(WebInspector.ButtonNavigationItem.Event.Clicked,()=>{WebInspector.toggleSplitConsole()}),this.navigationBar.insertNavigationItem(this._toggleDrawerButton,0),this.collapsed=!0,WebInspector.TabBrowser.addEventListener(WebInspector.TabBrowser.Event.SelectedTabContentViewDidChange,this._selectedTabContentViewDidChange,this)}get collapsed(){return this._collapsed}set collapsed(_){_===this._collapsed||(this._collapsed=_||!1,this._toggleDrawerButton.toggled=this._collapsed,this.element.classList.toggle("hidden",this._collapsed),this._collapsed?this.hidden():this.shown(),this.dispatchEventToListeners(WebInspector.ConsoleDrawer.Event.CollapsedStateChanged))}get height(){return this.element.offsetHeight}shown(){super.shown(),this._restoreDrawerHeight()}layout(){if(!this._collapsed&&this.layoutReason===WebInspector.View.LayoutReason.Resize){super.layout();let _=this.height;this._restoreDrawerHeight(),_!==this.height&&this.dispatchEventToListeners(WebInspector.ConsoleDrawer.Event.Resized)}}_consoleResizerMouseDown(_){function S(E){let I=window.innerHeight-E.pageY-T;this._drawerHeightSetting.value=I,this._updateDrawerHeight(I),this.collapsed=!1}function C(E){0!==E.button||WebInspector.elementDragEnd(E)}if(!(0!==_.button||_.ctrlKey)&&(_.target===this.navigationBar.element||_.target.classList.contains("flexible-space"))){let f=_.target,T=f.offsetHeight-(_.pageY-f.totalOffsetTop);WebInspector.elementDragStart(f,S.bind(this),C.bind(this),_,"row-resize")}}_restoreDrawerHeight(){this._updateDrawerHeight(this._drawerHeightSetting.value)}_updateDrawerHeight(_){const C=this.element.parentNode.offsetHeight-100;_=Number.constrain(_,64,C);_===this.element.style.height||(this.element.style.height=_+"px",this.dispatchEventToListeners(WebInspector.ConsoleDrawer.Event.Resized))}_selectedTabContentViewDidChange(){WebInspector.doesCurrentTabSupportSplitContentBrowser()||this.element.classList.add("hidden")}},WebInspector.ConsoleDrawer.Event={CollapsedStateChanged:"console-drawer-collapsed-state-changed",Resized:"console-drawer-resized"},WebInspector.ConsoleGroup=class extends WebInspector.Object{constructor(_){super(),this._parentGroup=_}get parentGroup(){return this._parentGroup}render(_){var S=document.createElement("div");S.className="console-group",S.group=this,this.element=S;var C=_.element;C.classList.add(WebInspector.LogContentView.ItemWrapperStyleClassName),C.addEventListener("click",this._titleClicked.bind(this)),C.addEventListener("mousedown",this._titleMouseDown.bind(this)),S&&_.message.type===WebInspector.ConsoleMessage.MessageType.StartGroupCollapsed&&S.classList.add("collapsed"),S.appendChild(C);var f=document.createElement("div");return this._messagesElement=f,f.className="console-group-messages",S.appendChild(f),S}addMessageView(_){var S=_.element;S.classList.add(WebInspector.LogContentView.ItemWrapperStyleClassName),this.append(S)}append(_){this._messagesElement.appendChild(_)}_titleMouseDown(_){_.preventDefault()}_titleClicked(_){var S=_.target.enclosingNodeOrSelfWithClass("console-group-title");if(S){var C=S.enclosingNodeOrSelfWithClass("console-group");C&&(C.classList.contains("collapsed")?C.classList.remove("collapsed"):C.classList.add("collapsed")),S.scrollIntoViewIfNeeded(!0)}}},WebInspector.ConsolePrompt=class extends WebInspector.View{constructor(_,S){super(),S=parseMIMEType(S).type,this.element.classList.add("console-prompt",WebInspector.SyntaxHighlightedStyleClassName),this._delegate=_||null,this._codeMirror=WebInspector.CodeMirrorEditor.create(this.element,{lineWrapping:!0,mode:{name:S,globalVars:!0},indentWithTabs:!0,indentUnit:4,matchBrackets:!0});var C={Up:this._handlePreviousKey.bind(this),Down:this._handleNextKey.bind(this),"Ctrl-P":this._handlePreviousKey.bind(this),"Ctrl-N":this._handleNextKey.bind(this),Enter:this._handleEnterKey.bind(this),"Cmd-Enter":this._handleCommandEnterKey.bind(this),Tab:this._handleTabKey.bind(this),Esc:this._handleEscapeKey.bind(this)};this._codeMirror.addKeyMap(C),this._completionController=new WebInspector.CodeMirrorCompletionController(this._codeMirror,this),this._completionController.addExtendedCompletionProvider("javascript",WebInspector.javaScriptRuntimeCompletionProvider),this._history=[{}],this._historyIndex=0}get delegate(){return this._delegate}set delegate(_){this._delegate=_||null}set escapeKeyHandlerWhenEmpty(_){this._escapeKeyHandlerWhenEmpty=_}get text(){return this._codeMirror.getValue()}set text(_){this._codeMirror.setValue(_||""),this._codeMirror.clearHistory(),this._codeMirror.markClean()}get history(){return this._history[this._historyIndex]=this._historyEntryForCurrentText(),this._history}set history(_){this._history=_ instanceof Array?_.slice(0,WebInspector.ConsolePrompt.MaximumHistorySize):[{}],this._historyIndex=0,this._restoreHistoryEntry(0)}get focused(){return this._codeMirror.getWrapperElement().classList.contains("CodeMirror-focused")}focus(){this._codeMirror.focus()}updateCompletions(_,S){this._completionController.updateCompletions(_,S)}pushHistoryItem(_){this._commitHistoryEntry({text:_})}completionControllerCompletionsNeeded(_,S,C,f,T,E){this.delegate&&"function"==typeof this.delegate.consolePromptCompletionsNeeded?this.delegate.consolePromptCompletionsNeeded(this,C,f,S,T,E):this._completionController.updateCompletions(C)}completionControllerShouldAllowEscapeCompletion(){return!!this.text}layout(){this._codeMirror.refresh()}_handleTabKey(_){var S=_.getCursor(),C=_.getLine(S.line);if(!C.trim().length)return CodeMirror.Pass;var f=C.search(/[^\s]/);return S.ch<=f?CodeMirror.Pass:void this._completionController.completeAtCurrentPositionIfNeeded().then(function(T){T===WebInspector.CodeMirrorCompletionController.UpdatePromise.NoCompletionsFound&&InspectorFrontendHost.beep()})}_handleEscapeKey(){return this.text?CodeMirror.Pass:this._escapeKeyHandlerWhenEmpty?void this._escapeKeyHandlerWhenEmpty():CodeMirror.Pass}_handlePreviousKey(){if(this._codeMirror.somethingSelected())return CodeMirror.Pass;if(this._codeMirror.getCursor().line)return CodeMirror.Pass;var S=this._history[this._historyIndex+1];return S?void(this._rememberCurrentTextInHistory(),++this._historyIndex,this._restoreHistoryEntry(this._historyIndex)):CodeMirror.Pass}_handleNextKey(){if(this._codeMirror.somethingSelected())return CodeMirror.Pass;if(this._codeMirror.getCursor().line!==this._codeMirror.lastLine())return CodeMirror.Pass;var S=this._history[this._historyIndex-1];return S?void(this._rememberCurrentTextInHistory(),--this._historyIndex,this._restoreHistoryEntry(this._historyIndex)):CodeMirror.Pass}_handleEnterKey(_,S,C){function f(D,M){return D.line===M.line&&D.ch===M.ch}function T(D){return D?void(this._commitHistoryEntry(this._historyEntryForCurrentText()),!C&&(this._codeMirror.setValue(""),this._codeMirror.clearHistory()),this.delegate&&"function"==typeof this.delegate.consolePromptHistoryDidChange&&this.delegate.consolePromptHistoryDidChange(this),this.delegate&&"function"==typeof this.delegate.consolePromptTextCommitted&&this.delegate.consolePromptTextCommitted(this,E)):void(f(I,this._codeMirror.getCursor())&&CodeMirror.commands.newlineAndIndent(this._codeMirror))}var E=this.text;if(E.trim()){var I=this._codeMirror.getCursor(),R=this._codeMirror.lastLine(),N=this._codeMirror.getLine(R).length,L=f(I,{line:R,ch:N});return!S&&this.delegate&&"function"==typeof this.delegate.consolePromptShouldCommitText?void this.delegate.consolePromptShouldCommitText(this,E,L,T.bind(this)):void T.call(this,!0)}}_commitHistoryEntry(_){this._history[1]&&(!this._history[1].text||this._history[1].text===_.text)?(this._history[1]=_,this._history[0]={}):(this._history[0]=_,this._history.unshift({}),this._history.length>WebInspector.ConsolePrompt.MaximumHistorySize&&(this._history=this._history.slice(0,WebInspector.ConsolePrompt.MaximumHistorySize))),this._historyIndex=0}_handleCommandEnterKey(_){this._handleEnterKey(_,!0,!0)}_restoreHistoryEntry(_){var S=this._history[_];this._codeMirror.setValue(S.text||""),S.undoHistory?this._codeMirror.setHistory(S.undoHistory):this._codeMirror.clearHistory(),this._codeMirror.setCursor(S.cursor||{line:0})}_historyEntryForCurrentText(){return{text:this.text,undoHistory:this._codeMirror.getHistory(),cursor:this._codeMirror.getCursor()}}_rememberCurrentTextInHistory(){this._history[this._historyIndex]=this._historyEntryForCurrentText(),this.delegate&&"function"==typeof this.delegate.consolePromptHistoryDidChange&&this.delegate.consolePromptHistoryDidChange(this)}},WebInspector.ConsolePrompt.MaximumHistorySize=30,WebInspector.ConsoleSession=class extends WebInspector.Object{constructor(_){super(),this._hasMessages=!1;let S=document.createElement("div");S.className="console-session";let C=document.createElement("div");C.classList.add("console-session-header");let f="";switch(_.newSessionReason){case WebInspector.ConsoleSession.NewSessionReason.PageReloaded:f=WebInspector.UIString("Page reloaded at %s");break;case WebInspector.ConsoleSession.NewSessionReason.PageNavigated:f=WebInspector.UIString("Page navigated at %s");break;case WebInspector.ConsoleSession.NewSessionReason.ConsoleCleared:f=WebInspector.UIString("Console cleared at %s");break;default:f=WebInspector.UIString("Console opened at %s");}let T=_.timestamp||Date.now();C.textContent=f.format(new Date(T).toLocaleTimeString()),S.append(C),this.element=S,this._messagesElement=S}addMessageView(_){var S=_.element;S.classList.add(WebInspector.LogContentView.ItemWrapperStyleClassName),this.append(S)}append(_){this._hasMessages=!0,this._messagesElement.append(_)}hasMessages(){return this._hasMessages}},WebInspector.ConsoleSession.NewSessionReason={PageReloaded:Symbol("Page reloaded"),PageNavigated:Symbol("Page navigated"),ConsoleCleared:Symbol("Console cleared")},WebInspector.ContentFlowDOMTreeContentView=class extends WebInspector.DOMTreeContentView{constructor(_){super(_),_.addEventListener(WebInspector.ContentFlow.Event.ContentNodeWasAdded,this._contentNodeWasAdded,this),_.addEventListener(WebInspector.ContentFlow.Event.ContentNodeWasRemoved,this._contentNodeWasRemoved,this),this._createContentTrees()}closed(){this.representedObject.removeEventListener(null,null,this),super.closed()}getSearchContextNodes(_){_(this.domTreeOutline.children.map(function(S){return S.representedObject.id}))}_createContentTrees(){var _=this.representedObject.contentNodes;for(var S of _)this.domTreeOutline.appendChild(new WebInspector.DOMTreeElement(S));var C=_.length?_[0].ownerDocument.documentURL:null;this._restoreSelectedNodeAfterUpdate(C,_[0])}_contentNodeWasAdded(_){var S=new WebInspector.DOMTreeElement(_.data.node);if(!_.data.before)return void this.domTreeOutline.appendChild(S);var C=this.domTreeOutline.findTreeElement(_.data.before),f=this.domTreeOutline.children.indexOf(C);this.domTreeOutline.insertChild(S,f)}_contentNodeWasRemoved(_){var S=this.domTreeOutline.findTreeElement(_.data.node);this.domTreeOutline.removeChild(S)}},WebInspector.ContentFlowTreeElement=class extends WebInspector.GeneralTreeElement{constructor(_){super("content-flow-icon",_.name,null,_,!1)}},WebInspector.ContentViewContainer=class extends WebInspector.View{constructor(){super(),this.element.classList.add("content-view-container"),this._backForwardList=[],this._currentIndex=-1}get currentIndex(){return this._currentIndex}get backForwardList(){return this._backForwardList}get currentContentView(){return 0>this._currentIndex||this._currentIndex>this._backForwardList.length-1?null:this._backForwardList[this._currentIndex].contentView}get currentBackForwardEntry(){return 0>this._currentIndex||this._currentIndex>this._backForwardList.length-1?null:this._backForwardList[this._currentIndex]}contentViewForRepresentedObject(_,S,C){return WebInspector.ContentView.contentViewForRepresentedObject(_,S,C)}showContentViewForRepresentedObject(_,S){var C=this.contentViewForRepresentedObject(_,!1,S);return C?(this.showContentView(C),C):null}showContentView(_,S){if(!(_ instanceof WebInspector.ContentView))return null;_.parentContainer!==this&&this._takeOwnershipOfContentView(_);let C=this.currentBackForwardEntry,f=null;for(let I=this._backForwardList.length-1;0<=I;--I)if(this._backForwardList[I].contentView===_){f=this._backForwardList[I].makeCopy(S);break}if(f||(f=new WebInspector.BackForwardEntry(_,S)),f.isEqual(C)){return C.prepareToShow(!1),C.contentView}let T=this._currentIndex+1,E=this._backForwardList.splice(T,this._backForwardList.length-T,f);for(let I=0,R;I<E.length;++I)R=!this._backForwardList.some(N=>N.contentView===E[I].contentView),R&&this._disassociateFromContentView(E[I].contentView,E[I].tombstone);return _._parentContainer=this,this.showBackForwardEntryForIndex(T),_}showBackForwardEntryForIndex(_){if(!(0>_||_>this._backForwardList.length-1)&&this._currentIndex!==_){var S=this.currentBackForwardEntry;this._currentIndex=_;var C=this.currentBackForwardEntry,f=!S||!C.contentView.visible;f?(S&&this._hideEntry(S),this._showEntry(C,!0)):this._showEntry(C,!1),this.dispatchEventToListeners(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange)}}replaceContentView(_,S){if(_ instanceof WebInspector.ContentView&&S instanceof WebInspector.ContentView&&_.parentContainer===this&&!(S.parentContainer&&S.parentContainer!==this)){var C=this.currentContentView===_;C&&this._hideEntry(this.currentBackForwardEntry),this._disassociateFromContentView(_,!1),S._parentContainer=this;for(var f=0;f<this._backForwardList.length;++f)if(this._backForwardList[f].contentView===_){let T=this._backForwardList[f].cookie;this._backForwardList[f]=new WebInspector.BackForwardEntry(S,T)}this._removeIdenticalAdjacentBackForwardEntries(),C&&(this._showEntry(this.currentBackForwardEntry,!0),this.dispatchEventToListeners(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange))}}closeContentView(_){if(this._backForwardList.length){for(var S=!0,C=this._backForwardList.length-1;0<=C;--C)if(this._backForwardList[C].contentView!==_){S=!1;break}if(S)return void this.closeAllContentViews();for(var f=this.currentContentView,T=!1,C=this._backForwardList.length-1,E;0<=C;--C)E=this._backForwardList[C],E.contentView===_&&(E.contentView===f&&this._hideEntry(E),this._currentIndex>=C&&--this._currentIndex,this._disassociateFromContentView(E.contentView,E.tombstone),this._backForwardList.splice(C,1),T=!0);T&&this._removeIdenticalAdjacentBackForwardEntries();var I=this.currentBackForwardEntry;(I&&I.contentView!==f||T)&&(this._showEntry(I,!0),this.dispatchEventToListeners(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange))}}closeAllContentViews(){if(this._backForwardList.length){for(var _=this.currentContentView,S=0,C;S<this._backForwardList.length;++S)C=this._backForwardList[S],C.contentView===_&&this._hideEntry(C),this._disassociateFromContentView(C.contentView,C.tombstone);this._backForwardList=[],this._currentIndex=-1,this.dispatchEventToListeners(WebInspector.ContentViewContainer.Event.CurrentContentViewDidChange)}}ca