/* Replayable replacements for global functions */

/***************************************************************
 * BEGIN STABLE.JS
 **************************************************************/
//! stable.js 0.1.3, https://github.com/Two-Screen/stable
//! © 2012 Stéphan Kochen, Angry Bytes. MIT licensed.
(function() {

// A stable array sort, because `Array#sort()` is not guaranteed stable.
// This is an implementation of merge sort, without recursion.

var stable = function(arr, comp) {
    if (typeof(comp) !== 'function') {
        comp = function(a, b) {
            a = String(a);
            b = String(b);
            if (a < b) return -1;
            if (a > b) return 1;
            return 0;
        };
    }

    var len = arr.length;

    if (len <= 1) return arr;

    // Rather than dividing input, simply iterate chunks of 1, 2, 4, 8, etc.
    // Chunks are the size of the left or right hand in merge sort.
    // Stop when the left-hand covers all of the array.
    var oarr = arr;
    for (var chk = 1; chk < len; chk *= 2) {
        arr = pass(arr, comp, chk);
    }
    for (var i = 0; i < len; i++) {
        oarr[i] = arr[i];
    }
    return oarr;
};

// Run a single pass with the given chunk size. Returns a new array.
var pass = function(arr, comp, chk) {
    var len = arr.length;
    // Output, and position.
    var result = new Array(len);
    var i = 0;
    // Step size / double chunk size.
    var dbl = chk * 2;
    // Bounds of the left and right chunks.
    var l, r, e;
    // Iterators over the left and right chunk.
    var li, ri;

    // Iterate over pairs of chunks.
    for (l = 0; l < len; l += dbl) {
        r = l + chk;
        e = r + chk;
        if (r > len) r = len;
        if (e > len) e = len;

        // Iterate both chunks in parallel.
        li = l;
        ri = r;
        while (true) {
            // Compare the chunks.
            if (li < r && ri < e) {
                // This works for a regular `sort()` compatible comparator,
                // but also for a simple comparator like: `a > b`
                if (comp(arr[li], arr[ri]) <= 0) {
                    result[i++] = arr[li++];
                }
                else {
                    result[i++] = arr[ri++];
                }
            }
            // Nothing to compare, just flush what's left.
            else if (li < r) {
                result[i++] = arr[li++];
            }
            else if (ri < e) {
                result[i++] = arr[ri++];
            }
            // Both iterators are at the chunk ends.
            else {
                break;
            }
        }
    }

    return result;
};

var arrsort = function(comp) {
    return stable(this, comp);
};

if (Object.defineProperty) {
    Object.defineProperty(Array.prototype, "sort", {
        configurable: true, writable: true, enumerable: false,
        value: arrsort
    });
} else {
    Array.prototype.sort = arrsort;
}

})();
/***************************************************************
 * END STABLE.JS
 **************************************************************/

/*
 * In a generated replay, this file is partially common, boilerplate code
 * included in every replay, and partially generated replay code. The following
 * header applies to the boilerplate code. A comment indicating "Auto-generated
 * below this comment" marks the separation between these two parts.
 *
 * Copyright (C) 2011, 2012 Purdue University
 * Written by Gregor Richards
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

(function() {
    // global eval alias
    var geval = eval;

    // detect if we're in a browser or not
    var inbrowser = false;
    var inharness = false;
    var finished = false;
    if (typeof window !== "undefined" && "document" in window) {
        inbrowser = true;
        if (window.parent && "JSBNG_handleResult" in window.parent) {
            inharness = true;
        }
    } else if (typeof global !== "undefined") {
        window = global;
        window.top = window;
    } else {
        window = (function() { return this; })();
        window.top = window;
    }

    if ("console" in window) {
        window.JSBNG_Console = window.console;
    }

    var callpath = [];

    // global state
    var JSBNG_Replay = window.top.JSBNG_Replay = {
        push: function(arr, fun) {
            arr.push(fun);
            return fun;
        },

        path: function(str) {
            verifyPath(str);
        },

        forInKeys: function(of) {
            var keys = [];
            for (var k in of)
                keys.push(k);
            return keys.sort();
        }
    };

    var currentTimeInMS;
    if (inharness) {
        currentTimeInMS = window.parent.currentTimeInMS;
    } else {
        if (window.performance && window.performance.now)
            currentTimeInMS = function() { return window.performance.now() };
        else if (typeof preciseTime !== 'undefined')
            currentTimeInMS = function() { return preciseTime() * 1000; };
        else
            currentTimeInMS = function() { return Date.now(); };
    }

    // the actual replay runner
    function onload() {
        try {
            delete window.onload;
        } catch (ex) {}

        var jr = JSBNG_Replay$;
        var cb = function() {
            var end = currentTimeInMS();
            finished = true;

            var msg = "Time: " + (end - st) + "ms";
    
            if (inharness) {
                window.parent.JSBNG_handleResult({error:false, time:(end - st)});
            } else if (inbrowser) {
                var res = document.createElement("div");
    
                res.style.position = "fixed";
                res.style.left = "1em";
                res.style.top = "1em";
                res.style.width = "35em";
                res.style.height = "5em";
                res.style.padding = "1em";
                res.style.backgroundColor = "white";
                res.style.color = "black";
                res.appendChild(document.createTextNode(msg));
    
                document.body.appendChild(res);
            } else if (typeof console !== "undefined") {
                console.log(msg);
            } else if (typeof print !== "undefined") {
                // hopefully not the browser print() function :)
                print(msg);
            }
        };

        // force it to JIT
        jr(false);

        // then time it
        var st = currentTimeInMS();
        while (jr !== null) {
            jr = jr(true, cb);
        }
    }

    // add a frame at replay time
    function iframe(pageid) {
        var iw;
        if (inbrowser) {
            // represent the iframe as an iframe (of course)
            var iframe = document.createElement("iframe");
            iframe.style.display = "none";
            document.body.appendChild(iframe);
            iw = iframe.contentWindow;
            iw.document.write("<script type=\"text/javascript\">var JSBNG_Replay_geval = eval;</script>");
            iw.document.close();
        } else {
            // no general way, just lie and do horrible things
            var topwin = window;
            (function() {
                var window = {};
                window.window = window;
                window.top = topwin;
                window.JSBNG_Replay_geval = function(str) {
                    eval(str);
                }
                iw = window;
            })();
        }
        return iw;
    }

    // called at the end of the replay stuff
    function finalize() {
        if (inbrowser) {
            setTimeout(onload, 0);
        } else {
            onload();
        }
    }

    // verify this recorded value and this replayed value are close enough
    function verify(rep, rec) {
        if (rec !== rep &&
            (rep === rep || rec === rec) /* NaN test */) {
            // FIXME?
            if (typeof rec === "function" && typeof rep === "function") {
                return true;
            }
            if (typeof rec !== "object" || rec === null ||
                !(("__JSBNG_unknown_" + typeof(rep)) in rec)) {
                return false;
            }
        }
        return true;
    }

    // general message
    var firstMessage = true;
    function replayMessage(msg) {
        if (inbrowser) {
            if (firstMessage)
                document.open();
            firstMessage = false;
            document.write(msg);
        } else {
            console.log(msg);
        }
    }

    // complain when there's an error
    function verificationError(msg) {
        if (finished) return;
        if (inharness) {
            window.parent.JSBNG_handleResult({error:true, msg: msg});
        } else replayMessage(msg);
        throw new Error();
    }

    // to verify a set
    function verifySet(objstr, obj, prop, gvalstr, gval) {
        if (/^on/.test(prop)) {
            // these aren't instrumented compatibly
            return;
        }

        if (!verify(obj[prop], gval)) {
            var bval = obj[prop];
            var msg = "Verification failure! " + objstr + "." + prop + " is not " + gvalstr + ", it's " + bval + "!";
            verificationError(msg);
        }
    }

    // to verify a call or new
    function verifyCall(iscall, func, cthis, cargs) {
        var ok = true;
        var callArgs = func.callArgs[func.inst];
        iscall = iscall ? 1 : 0;
        if (cargs.length !== callArgs.length - 1) {
            ok = false;
        } else {
            if (iscall && !verify(cthis, callArgs[0])) ok = false;
            for (var i = 0; i < cargs.length; i++) {
                if (!verify(cargs[i], callArgs[i+1])) ok = false;
            }
        }
        if (!ok) {
            var msg = "Call verification failure!";
            verificationError(msg);
        }

        return func.returns[func.inst++];
    }

    // to verify the callpath
    function verifyPath(func) {
        var real = callpath.shift();
        if (real !== func) {
            var msg = "Call path verification failure! Expected " + real + ", found " + func;
            verificationError(msg);
        }
    }

    // figure out how to define getters
    var defineGetter;
    if (Object.defineProperty) {
        var odp = Object.defineProperty;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            odp(obj, prop, {"enumerable": true, "configurable": true, "get": getter, "set": setter});
        };
    } else if (Object.prototype.__defineGetter__) {
        var opdg = Object.prototype.__defineGetter__;
        var opds = Object.prototype.__defineSetter__;
        defineGetter = function(obj, prop, getter, setter) {
            if (typeof setter === "undefined") setter = function(){};
            opdg.call(obj, prop, getter);
            opds.call(obj, prop, setter);
        };
    } else {
        defineGetter = function() {
            verificationError("This replay requires getters for correct behavior, and your JS engine appears to be incapable of defining getters. Sorry!");
        };
    }

    var defineRegetter = function(obj, prop, getter, setter) {
        defineGetter(obj, prop, function() {
            return getter.call(this, prop);
        }, function(val) {
            // once it's set by the client, it's claimed
            setter.call(this, prop, val);
            Object.defineProperty(obj, prop, {
                "enumerable": true, "configurable": true, "writable": true,
                "value": val
            });
        });
    }

    // for calling events
    var fpc = Function.prototype.call;

// resist the urge, don't put a })(); here!
/******************************************************************************
 * Auto-generated below this comment
 *****************************************************************************/
var ow480936571 = window;
var f480936571_0;
var o0;
var f480936571_4;
var f480936571_6;
var f480936571_7;
var f480936571_12;
var f480936571_13;
var f480936571_14;
var f480936571_15;
var o1;
var o2;
var o3;
var o4;
var o5;
var f480936571_56;
var f480936571_57;
var f480936571_72;
var f480936571_143;
var f480936571_417;
var o6;
var f480936571_419;
var o7;
var f480936571_422;
var f480936571_423;
var o8;
var fo480936571_1_body;
var f480936571_426;
var f480936571_428;
var o9;
var o10;
var o11;
var o12;
var f480936571_435;
var f480936571_451;
var o13;
var f480936571_455;
var f480936571_456;
var o14;
var fo480936571_427_lastChild;
var o15;
var o16;
var f480936571_460;
var o17;
var o18;
var f480936571_467;
var f480936571_468;
var fo480936571_1_JSBNG__location;
var f480936571_472;
var f480936571_473;
var f480936571_474;
var o19;
var o20;
var o21;
var o22;
var o23;
var o24;
var o25;
var o26;
var o27;
var o28;
var o29;
var o30;
var o31;
var o32;
var o33;
var f480936571_492;
var f480936571_493;
var o34;
var o35;
var o36;
var o37;
var o38;
var o39;
var o40;
var o41;
var o42;
var o43;
var o44;
var o45;
var o46;
var o47;
var o48;
var o49;
var o50;
var o51;
var o52;
var o53;
var o54;
var o55;
var o56;
var o57;
var o58;
var o59;
var o60;
var o61;
var o62;
var o63;
var o64;
var o65;
var o66;
var o67;
var o68;
var o69;
var o70;
var o71;
var o72;
var o73;
var o74;
var o75;
var o76;
var o77;
var o78;
var f480936571_657;
var f480936571_660;
var f480936571_661;
var f480936571_662;
var o79;
var f480936571_665;
var f480936571_668;
var f480936571_671;
var f480936571_678;
var f480936571_679;
var o80;
var f480936571_682;
var o81;
var o82;
var f480936571_688;
var o83;
var f480936571_691;
var f480936571_692;
var f480936571_694;
var o84;
var o85;
var f480936571_699;
var f480936571_700;
var f480936571_701;
var o86;
var f480936571_705;
var f480936571_714;
var f480936571_718;
var f480936571_719;
var f480936571_720;
var o87;
var o88;
var fo480936571_463_scrollTop;
var o89;
var o90;
var o91;
var o92;
var fo480936571_732_parentNode;
var f480936571_733;
var f480936571_737;
var f480936571_738;
var o93;
var f480936571_745;
var fo480936571_749_parentNode;
var fo480936571_759_parentNode;
var fo480936571_780_parentNode;
var f480936571_800;
var f480936571_957;
var f480936571_961;
var f480936571_1258;
var f480936571_1287;
var f480936571_1290;
var f480936571_1293;
var f480936571_1300;
var f480936571_1303;
var f480936571_1443;
var f480936571_1491;
var f480936571_1535;
var fo480936571_1534_id;
var o94;
var o95;
var o96;
var o97;
var o98;
var o99;
var o100;
var o101;
var o102;
var o103;
var o104;
var o105;
var f480936571_1631;
var f480936571_1632;
var fo480936571_1661_parentNode;
var f480936571_1823;
var f480936571_1826;
var f480936571_1833;
var f480936571_1836;
var f480936571_1839;
JSBNG_Replay.sa574ed15f3859e0ddbd1b958865b71be53ed3521_48 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_361 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_316 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_371 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_349 = [];
JSBNG_Replay.s826a4a446437adf56a244a52dcd854244ec4dee7_6 = [];
JSBNG_Replay.s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_11 = [];
JSBNG_Replay.sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0 = [];
JSBNG_Replay.sa574ed15f3859e0ddbd1b958865b71be53ed3521_312 = [];
JSBNG_Replay.s9840219b8a67b41faa089cd0ad1fad465972c548_0 = [];
JSBNG_Replay.sa574ed15f3859e0ddbd1b958865b71be53ed3521_280 = [];
// 1
// record generated by JSBench a851ecb530f7 at 2013-07-10T18:45:18.451Z
// 2
// 3
// 4
// 5
f480936571_0 = function() { return f480936571_0.returns[f480936571_0.inst++]; };
f480936571_0.returns = [];
f480936571_0.inst = 0;
// 6
ow480936571.JSBNG__Date = f480936571_0;
// 7
o0 = {};
// 8
ow480936571.JSBNG__document = o0;
// 13
f480936571_4 = function() { return f480936571_4.returns[f480936571_4.inst++]; };
f480936571_4.returns = [];
f480936571_4.inst = 0;
// 14
ow480936571.JSBNG__getComputedStyle = f480936571_4;
// 17
f480936571_6 = function() { return f480936571_6.returns[f480936571_6.inst++]; };
f480936571_6.returns = [];
f480936571_6.inst = 0;
// 18
ow480936571.JSBNG__removeEventListener = f480936571_6;
// 19
f480936571_7 = function() { return f480936571_7.returns[f480936571_7.inst++]; };
f480936571_7.returns = [];
f480936571_7.inst = 0;
// 20
ow480936571.JSBNG__addEventListener = f480936571_7;
// 21
ow480936571.JSBNG__top = ow480936571;
// 26
ow480936571.JSBNG__scrollX = 0;
// 27
ow480936571.JSBNG__scrollY = 0;
// 32
f480936571_12 = function() { return f480936571_12.returns[f480936571_12.inst++]; };
f480936571_12.returns = [];
f480936571_12.inst = 0;
// 33
ow480936571.JSBNG__setTimeout = f480936571_12;
// 34
f480936571_13 = function() { return f480936571_13.returns[f480936571_13.inst++]; };
f480936571_13.returns = [];
f480936571_13.inst = 0;
// 35
ow480936571.JSBNG__setInterval = f480936571_13;
// 36
f480936571_14 = function() { return f480936571_14.returns[f480936571_14.inst++]; };
f480936571_14.returns = [];
f480936571_14.inst = 0;
// 37
ow480936571.JSBNG__clearTimeout = f480936571_14;
// 38
f480936571_15 = function() { return f480936571_15.returns[f480936571_15.inst++]; };
f480936571_15.returns = [];
f480936571_15.inst = 0;
// 39
ow480936571.JSBNG__clearInterval = f480936571_15;
// 44
ow480936571.JSBNG__frames = ow480936571;
// 47
ow480936571.JSBNG__self = ow480936571;
// 48
o1 = {};
// 49
ow480936571.JSBNG__navigator = o1;
// 50
o2 = {};
// 51
ow480936571.JSBNG__screen = o2;
// 52
o3 = {};
// 53
ow480936571.JSBNG__history = o3;
// 64
ow480936571.JSBNG__closed = false;
// 67
ow480936571.JSBNG__opener = null;
// 68
ow480936571.JSBNG__defaultStatus = "";
// 69
o4 = {};
// 70
ow480936571.JSBNG__location = o4;
// 71
ow480936571.JSBNG__innerWidth = 1024;
// 72
ow480936571.JSBNG__innerHeight = 702;
// 73
ow480936571.JSBNG__outerWidth = 1024;
// 74
ow480936571.JSBNG__outerHeight = 774;
// 75
ow480936571.JSBNG__screenX = 79;
// 76
ow480936571.JSBNG__screenY = 22;
// 77
ow480936571.JSBNG__pageXOffset = 0;
// 78
ow480936571.JSBNG__pageYOffset = 0;
// 103
ow480936571.JSBNG__frameElement = null;
// 114
ow480936571.JSBNG__screenLeft = 79;
// 115
ow480936571.JSBNG__clientInformation = o1;
// 116
ow480936571.JSBNG__defaultstatus = "";
// 119
o5 = {};
// 120
ow480936571.JSBNG__console = o5;
// 121
ow480936571.JSBNG__devicePixelRatio = 1;
// 124
ow480936571.JSBNG__offscreenBuffering = true;
// 125
ow480936571.JSBNG__screenTop = 22;
// 140
f480936571_56 = function() { return f480936571_56.returns[f480936571_56.inst++]; };
f480936571_56.returns = [];
f480936571_56.inst = 0;
// 141
ow480936571.JSBNG__XMLHttpRequest = f480936571_56;
// 142
f480936571_57 = function() { return f480936571_57.returns[f480936571_57.inst++]; };
f480936571_57.returns = [];
f480936571_57.inst = 0;
// 143
ow480936571.JSBNG__Image = f480936571_57;
// 144
ow480936571.JSBNG__name = "";
// 151
ow480936571.JSBNG__status = "";
// 174
f480936571_72 = function() { return f480936571_72.returns[f480936571_72.inst++]; };
f480936571_72.returns = [];
f480936571_72.inst = 0;
// 175
ow480936571.JSBNG__Worker = f480936571_72;
// 316
f480936571_143 = function() { return f480936571_143.returns[f480936571_143.inst++]; };
f480936571_143.returns = [];
f480936571_143.inst = 0;
// 317
ow480936571.JSBNG__Document = f480936571_143;
// 590
ow480936571.JSBNG__XMLDocument = f480936571_143;
// 865
ow480936571.JSBNG__onerror = null;
// 866
f480936571_417 = function() { return f480936571_417.returns[f480936571_417.inst++]; };
f480936571_417.returns = [];
f480936571_417.inst = 0;
// 867
ow480936571.Math.JSBNG__random = f480936571_417;
// 868
// 870
o6 = {};
// 871
f480936571_0.returns.push(o6);
// 872
f480936571_419 = function() { return f480936571_419.returns[f480936571_419.inst++]; };
f480936571_419.returns = [];
f480936571_419.inst = 0;
// 873
o6.getTime = f480936571_419;
// undefined
o6 = null;
// 874
f480936571_419.returns.push(1373481905460);
// 876
o6 = {};
// 877
o0.documentElement = o6;
// 878
o6.className = "";
// 879
o7 = {};
// 880
f480936571_0.returns.push(o7);
// 881
o7.getTime = f480936571_419;
// undefined
o7 = null;
// 882
f480936571_419.returns.push(1373481909100);
// 883
// 884
f480936571_422 = function() { return f480936571_422.returns[f480936571_422.inst++]; };
f480936571_422.returns = [];
f480936571_422.inst = 0;
// 885
o0.getElementById = f480936571_422;
// 886
f480936571_422.returns.push(null);
// 887
f480936571_423 = function() { return f480936571_423.returns[f480936571_423.inst++]; };
f480936571_423.returns = [];
f480936571_423.inst = 0;
// 888
o0.createElement = f480936571_423;
// 889
o7 = {};
// 890
f480936571_423.returns.push(o7);
// 891
// 892
o8 = {};
// 893
o7.firstChild = o8;
// undefined
o7 = null;
// undefined
fo480936571_1_body = function() { return fo480936571_1_body.returns[fo480936571_1_body.inst++]; };
fo480936571_1_body.returns = [];
fo480936571_1_body.inst = 0;
defineGetter(o0, "body", fo480936571_1_body, undefined);
// undefined
fo480936571_1_body.returns.push(null);
// 895
f480936571_426 = function() { return f480936571_426.returns[f480936571_426.inst++]; };
f480936571_426.returns = [];
f480936571_426.inst = 0;
// 896
o6.insertBefore = f480936571_426;
// 897
o7 = {};
// 898
o6.firstChild = o7;
// 899
f480936571_426.returns.push(o8);
// 900
f480936571_428 = function() { return f480936571_428.returns[f480936571_428.inst++]; };
f480936571_428.returns = [];
f480936571_428.inst = 0;
// 901
o0.getElementsByTagName = f480936571_428;
// 902
o9 = {};
// 903
f480936571_428.returns.push(o9);
// 904
o9.length = 5;
// 905
o10 = {};
// 906
o9["0"] = o10;
// 907
o10.src = "http://news.yahoo.com/JSBENCH_NG_RECORD_OBJECTS.js";
// 908
o11 = {};
// 909
o9["1"] = o11;
// 910
o11.src = "http://news.yahoo.com/JSBENCH_NG_RECORD.js";
// 911
o12 = {};
// 912
o9["2"] = o12;
// 913
o12.src = "";
// undefined
o12 = null;
// 914
o12 = {};
// 915
o9["3"] = o12;
// 916
o12.src = "";
// undefined
o12 = null;
// 917
o12 = {};
// 918
o9["4"] = o12;
// undefined
o9 = null;
// 919
o12.src = "http://l.yimg.com/zz/combo?yui:3.9.1/build/yui/yui-min.js&os/mit/media/p/common/rmp-min-1217643.js&os/mit/media/m/base/viewport-loader-min-1228633.js&ss/rapid-3.4.6.js";
// 920
f480936571_7.returns.push(undefined);
// 924
f480936571_422.returns.push(o8);
// 926
f480936571_422.returns.push(o8);
// 927
f480936571_435 = function() { return f480936571_435.returns[f480936571_435.inst++]; };
f480936571_435.returns = [];
f480936571_435.inst = 0;
// 928
f480936571_0.now = f480936571_435;
// 929
o1.cajaVersion = void 0;
// 930
o1.userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/536.29.13 (KHTML, like Gecko) Version/6.0.4 Safari/536.29.13";
// 931
o4.href = "http://news.yahoo.com/";
// 932
o8.currentStyle = void 0;
// 933
// 934
o0.defaultView = ow480936571;
// 935
o9 = {};
// 936
f480936571_4.returns.push(o9);
// 937
o9.display = "block";
// undefined
o9 = null;
// 938
// 940
// 942
o9 = {};
// 943
f480936571_4.returns.push(o9);
// 944
o9.display = "block";
// undefined
o9 = null;
// 945
// 947
// 949
o9 = {};
// 950
f480936571_4.returns.push(o9);
// 951
o9.display = "block";
// undefined
o9 = null;
// 952
// 954
// 956
o9 = {};
// 957
f480936571_4.returns.push(o9);
// 958
o9.display = "block";
// undefined
o9 = null;
// 959
// 961
// 963
o9 = {};
// 964
f480936571_4.returns.push(o9);
// 965
o9.display = "block";
// undefined
o9 = null;
// 966
// 968
// 970
o9 = {};
// 971
f480936571_4.returns.push(o9);
// 972
o9.display = "block";
// undefined
o9 = null;
// 973
// 975
// 977
o9 = {};
// 978
f480936571_4.returns.push(o9);
// 979
o9.display = "block";
// undefined
o9 = null;
// 980
// 982
// 984
o9 = {};
// 985
f480936571_4.returns.push(o9);
// 986
o9.display = "block";
// undefined
o9 = null;
// 987
// 989
// 991
o9 = {};
// 992
f480936571_4.returns.push(o9);
// 993
o9.display = "block";
// undefined
o9 = null;
// 994
// 996
// 998
o9 = {};
// 999
f480936571_4.returns.push(o9);
// 1000
o9.display = "block";
// undefined
o9 = null;
// 1001
// 1003
// 1005
o9 = {};
// 1006
f480936571_4.returns.push(o9);
// 1007
o9.display = "block";
// undefined
o9 = null;
// 1008
// 1010
// 1012
o9 = {};
// 1013
f480936571_4.returns.push(o9);
// 1014
o9.display = "block";
// undefined
o9 = null;
// 1015
// 1017
// 1019
o9 = {};
// 1020
f480936571_4.returns.push(o9);
// 1021
o9.display = "block";
// undefined
o9 = null;
// 1022
// 1024
// 1026
o9 = {};
// 1027
f480936571_4.returns.push(o9);
// 1028
o9.display = "block";
// undefined
o9 = null;
// 1029
// 1033
f480936571_7.returns.push(undefined);
// 1036
o9 = {};
// 1037
o0.implementation = o9;
// 1038
f480936571_451 = function() { return f480936571_451.returns[f480936571_451.inst++]; };
f480936571_451.returns = [];
f480936571_451.inst = 0;
// 1039
o9.hasFeature = f480936571_451;
// undefined
o9 = null;
// 1040
f480936571_451.returns.push(true);
// 1042
o9 = {};
// 1043
o6.style = o9;
// 1045
o13 = {};
// 1046
f480936571_423.returns.push(o13);
// 1047
o13.async = true;
// undefined
o13 = null;
// 1050
o0.uniqueID = void 0;
// 1051
o0._yuid = void 0;
// 1052
// 1054
o13 = {};
// 1055
f480936571_428.returns.push(o13);
// 1056
o13["0"] = void 0;
// 1057
o0.head = o7;
// 1058
f480936571_455 = function() { return f480936571_455.returns[f480936571_455.inst++]; };
f480936571_455.returns = [];
f480936571_455.inst = 0;
// 1059
o7.appendChild = f480936571_455;
// 1060
f480936571_456 = function() { return f480936571_456.returns[f480936571_456.inst++]; };
f480936571_456.returns = [];
f480936571_456.inst = 0;
// 1061
o0.createTextNode = f480936571_456;
// 1062
o14 = {};
// 1063
f480936571_456.returns.push(o14);
// 1064
f480936571_455.returns.push(o14);
// undefined
fo480936571_427_lastChild = function() { return fo480936571_427_lastChild.returns[fo480936571_427_lastChild.inst++]; };
fo480936571_427_lastChild.returns = [];
fo480936571_427_lastChild.inst = 0;
defineGetter(o7, "lastChild", fo480936571_427_lastChild, undefined);
// undefined
fo480936571_427_lastChild.returns.push(o14);
// 1067
o15 = {};
// 1068
f480936571_423.returns.push(o15);
// 1070
o16 = {};
// 1071
f480936571_423.returns.push(o16);
// 1072
f480936571_460 = function() { return f480936571_460.returns[f480936571_460.inst++]; };
f480936571_460.returns = [];
f480936571_460.inst = 0;
// 1073
o16.setAttribute = f480936571_460;
// 1074
f480936571_460.returns.push(undefined);
// 1075
o16.className = "a";
// undefined
o16 = null;
// 1076
o15.setAttribute = f480936571_460;
// 1077
f480936571_460.returns.push(undefined);
// 1079
f480936571_460.returns.push(undefined);
// 1081
f480936571_460.returns.push(undefined);
// 1082
// 1083
// 1084
// 1085
o14.parentNode = o7;
// undefined
o14 = null;
// 1086
o7.insertBefore = f480936571_426;
// 1087
f480936571_426.returns.push(o15);
// 1090
o14 = {};
// 1091
f480936571_423.returns.push(o14);
// 1092
o14.setAttribute = f480936571_460;
// 1093
f480936571_460.returns.push(undefined);
// 1095
f480936571_460.returns.push(undefined);
// 1097
f480936571_460.returns.push(undefined);
// 1098
// 1099
// 1100
// 1103
f480936571_426.returns.push(o14);
// 1106
o16 = {};
// 1107
f480936571_0.returns.push(o16);
// 1108
o16.getTime = f480936571_419;
// undefined
o16 = null;
// 1109
f480936571_419.returns.push(1373481909333);
// 1111
o16 = {};
// undefined
fo480936571_1_body.returns.push(o16);
// undefined
fo480936571_1_body.returns.push(o16);
// 1114
o16.className = "no-js yog-type-index yog-full yog-version-v2 yog-ltr yuac-fixedpos-1 yuac-svg-1";
// 1115
// undefined
fo480936571_1_body.returns.push(o16);
// 1117
o16.offsetHeight = 0;
// 1122
o17 = {};
// 1123
f480936571_422.returns.push(o17);
// 1124
o17.innerHTML = "<center><div id=\"yom-ad-MAST-iframe\" class=\"yom-ad\"><center>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-MAST\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-MAST-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=MAST noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance;\n        ((se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance) = ((JSBNG_Record.eventInstance)((\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"), (se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=MAST noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// undefined
o17 = null;
// 1127
o17 = {};
// 1128
f480936571_422.returns.push(o17);
// 1129
o17.innerHTML = "<center><div id=\"yom-ad-LREC-iframe\" class=\"yom-ad\"><center>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance;\n        ((s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance) = ((JSBNG_Record.eventInstance)((\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"), (s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// 1132
o18 = {};
// 1133
f480936571_422.returns.push(o18);
// 1134
o18.innerHTML = "<center><div id=\"yom-ad-LREC2-iframe\" class=\"yom-ad\"><center>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC2\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC2-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC2 noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance;\n        ((sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance) = ((JSBNG_Record.eventInstance)((\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"), (sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC2 noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// 1141
f480936571_7.returns.push(undefined);
// 1143
f480936571_467 = function() { return f480936571_467.returns[f480936571_467.inst++]; };
f480936571_467.returns = [];
f480936571_467.inst = 0;
// 1144
o5.log = f480936571_467;
// 1145
f480936571_468 = function() { return f480936571_468.returns[f480936571_468.inst++]; };
f480936571_468.returns = [];
f480936571_468.inst = 0;
// 1146
o5.error = f480936571_468;
// undefined
o5 = null;
// 1148
o4.protocol = "http:";
// 1149
o5 = {};
// undefined
fo480936571_1_JSBNG__location = function() { return fo480936571_1_JSBNG__location.returns[fo480936571_1_JSBNG__location.inst++]; };
fo480936571_1_JSBNG__location.returns = [];
fo480936571_1_JSBNG__location.inst = 0;
defineGetter(o0, "JSBNG__location", fo480936571_1_JSBNG__location, undefined);
// undefined
fo480936571_1_JSBNG__location.returns.push(o5);
// undefined
o5 = null;
// 1151
f480936571_417.returns.push(0.2926539294421673);
// 1152
f480936571_417.returns.push(0.294060479151085);
// 1153
f480936571_417.returns.push(0.7677627033554018);
// 1154
f480936571_417.returns.push(0.08449808903969824);
// 1155
f480936571_417.returns.push(0.7392219582106918);
// 1156
f480936571_417.returns.push(0.4619438969530165);
// 1157
f480936571_417.returns.push(0.22886097989976406);
// 1158
f480936571_417.returns.push(0.1356664013583213);
// 1159
f480936571_417.returns.push(0.6714320888277143);
// 1160
f480936571_417.returns.push(0.282966346712783);
// 1161
f480936571_417.returns.push(0.07505152188241482);
// 1162
f480936571_417.returns.push(0.2441397882066667);
// 1164
o0.referrer = "";
// 1165
o5 = {};
// undefined
fo480936571_1_JSBNG__location.returns.push(o5);
// undefined
o5 = null;
// 1167
o0.cookie = "fpc10001393120079=ZYA9smXU|miwDar8Maa|fses10001393120079=|miwDar8Maa|ZYA9smXU|fvis10001393120079=|8MHsTT71YT|8MHsTT71YT|8MHsTT71YT|8|8MHsTT71YT|8MHsTT71YT; ywadp10001393120079=2415107517; B=c2qtgc98qvhsn&b=3&s=p8";
// 1169
o5 = {};
// 1170
f480936571_422.returns.push(o5);
// 1172
f480936571_472 = function() { return f480936571_472.returns[f480936571_472.inst++]; };
f480936571_472.returns = [];
f480936571_472.inst = 0;
// 1173
o6.hasAttribute = f480936571_472;
// 1174
f480936571_473 = function() { return f480936571_473.returns[f480936571_473.inst++]; };
f480936571_473.returns = [];
f480936571_473.inst = 0;
// 1175
o5.getAttribute = f480936571_473;
// 1177
f480936571_473.returns.push(null);
// 1182
f480936571_473.returns.push("mid:mediacontentnavigation;mpos:1;");
// 1183
f480936571_474 = function() { return f480936571_474.returns[f480936571_474.inst++]; };
f480936571_474.returns = [];
f480936571_474.inst = 0;
// 1184
o5.getElementsByTagName = f480936571_474;
// 1185
o19 = {};
// 1186
f480936571_474.returns.push(o19);
// 1187
o19.length = 14;
// 1188
o20 = {};
// 1189
o19["0"] = o20;
// 1190
o21 = {};
// 1191
o19["1"] = o21;
// 1192
o22 = {};
// 1193
o19["2"] = o22;
// 1194
o23 = {};
// 1195
o19["3"] = o23;
// 1196
o24 = {};
// 1197
o19["4"] = o24;
// 1198
o25 = {};
// 1199
o19["5"] = o25;
// 1200
o26 = {};
// 1201
o19["6"] = o26;
// 1202
o27 = {};
// 1203
o19["7"] = o27;
// 1204
o28 = {};
// 1205
o19["8"] = o28;
// 1206
o29 = {};
// 1207
o19["9"] = o29;
// 1208
o30 = {};
// 1209
o19["10"] = o30;
// 1210
o31 = {};
// 1211
o19["11"] = o31;
// 1212
o32 = {};
// 1213
o19["12"] = o32;
// 1214
o33 = {};
// 1215
o19["13"] = o33;
// undefined
o19 = null;
// 1217
o19 = {};
// 1218
f480936571_474.returns.push(o19);
// 1219
o19.length = 0;
// undefined
o19 = null;
// 1221
o19 = {};
// 1222
f480936571_474.returns.push(o19);
// 1223
o19.length = 0;
// undefined
o19 = null;
// 1224
o20.sourceIndex = void 0;
// 1225
f480936571_492 = function() { return f480936571_492.returns[f480936571_492.inst++]; };
f480936571_492.returns = [];
f480936571_492.inst = 0;
// 1226
o20.compareDocumentPosition = f480936571_492;
// 1228
f480936571_492.returns.push(4);
// 1229
o22.compareDocumentPosition = f480936571_492;
// 1230
f480936571_492.returns.push(4);
// 1231
o24.compareDocumentPosition = f480936571_492;
// 1232
f480936571_492.returns.push(4);
// 1233
o26.compareDocumentPosition = f480936571_492;
// 1234
f480936571_492.returns.push(4);
// 1235
o28.compareDocumentPosition = f480936571_492;
// 1236
f480936571_492.returns.push(4);
// 1237
o30.compareDocumentPosition = f480936571_492;
// 1238
f480936571_492.returns.push(4);
// 1239
o32.compareDocumentPosition = f480936571_492;
// 1240
f480936571_492.returns.push(4);
// 1242
f480936571_492.returns.push(4);
// 1243
o21.compareDocumentPosition = f480936571_492;
// 1244
f480936571_492.returns.push(4);
// 1246
f480936571_492.returns.push(4);
// 1247
o25.compareDocumentPosition = f480936571_492;
// 1248
f480936571_492.returns.push(4);
// 1250
f480936571_492.returns.push(4);
// 1251
o29.compareDocumentPosition = f480936571_492;
// 1252
f480936571_492.returns.push(4);
// 1254
f480936571_492.returns.push(4);
// 1256
f480936571_492.returns.push(4);
// 1258
f480936571_492.returns.push(4);
// 1259
o23.compareDocumentPosition = f480936571_492;
// 1260
f480936571_492.returns.push(4);
// 1262
f480936571_492.returns.push(4);
// 1264
f480936571_492.returns.push(4);
// 1266
f480936571_492.returns.push(4);
// 1267
o31.compareDocumentPosition = f480936571_492;
// 1268
f480936571_492.returns.push(4);
// 1270
f480936571_492.returns.push(4);
// 1272
f480936571_492.returns.push(4);
// 1274
f480936571_492.returns.push(4);
// 1276
f480936571_492.returns.push(4);
// 1278
f480936571_492.returns.push(4);
// 1280
f480936571_492.returns.push(4);
// 1282
f480936571_492.returns.push(4);
// 1283
o27.compareDocumentPosition = f480936571_492;
// 1284
f480936571_492.returns.push(4);
// 1289
f480936571_473.returns.push("yom-mod navigation");
// 1294
f480936571_473.returns.push("yom-mod navigation");
// 1299
f480936571_473.returns.push("yom-mod navigation");
// 1304
f480936571_473.returns.push("yom-mod navigation");
// 1309
f480936571_473.returns.push(null);
// 1310
o20.setAttribute = f480936571_460;
// 1311
f480936571_460.returns.push(undefined);
// 1312
o20.nodeName = "A";
// 1313
o20.textContent = "Home";
// 1316
o20.getAttribute = f480936571_473;
// 1318
f480936571_473.returns.push("navigate");
// 1323
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:home;sec:lnav-s;slk:link;cpos:1;");
// 1324
o21.setAttribute = f480936571_460;
// 1325
f480936571_460.returns.push(undefined);
// 1326
o21.nodeName = "A";
// 1327
o21.textContent = "U.S.";
// 1330
o21.getAttribute = f480936571_473;
// 1332
f480936571_473.returns.push("navigate");
// 1337
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:us;sec:lnav-s;slk:link;cpos:2;");
// 1338
o22.setAttribute = f480936571_460;
// 1339
f480936571_460.returns.push(undefined);
// 1340
o22.nodeName = "A";
// 1341
o22.textContent = "World";
// 1344
o22.getAttribute = f480936571_473;
// 1346
f480936571_473.returns.push("navigate");
// 1351
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:world;sec:lnav-s;slk:link;cpos:3;");
// 1352
o23.setAttribute = f480936571_460;
// 1353
f480936571_460.returns.push(undefined);
// 1354
o23.nodeName = "A";
// 1355
o23.textContent = "Politics";
// 1358
o23.getAttribute = f480936571_473;
// 1360
f480936571_473.returns.push("navigate");
// 1365
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:politics;sec:lnav-s;slk:link;cpos:4;");
// 1366
o24.setAttribute = f480936571_460;
// 1367
f480936571_460.returns.push(undefined);
// 1368
o24.nodeName = "A";
// 1369
o24.textContent = "Tech";
// 1372
o24.getAttribute = f480936571_473;
// 1374
f480936571_473.returns.push("navigate");
// 1379
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:tech;sec:lnav-s;slk:link;cpos:5;");
// 1380
o25.setAttribute = f480936571_460;
// 1381
f480936571_460.returns.push(undefined);
// 1382
o25.nodeName = "A";
// 1383
o25.textContent = "Science";
// 1386
o25.getAttribute = f480936571_473;
// 1388
f480936571_473.returns.push("navigate");
// 1393
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:science;sec:lnav-s;slk:link;cpos:6;");
// 1394
o26.setAttribute = f480936571_460;
// 1395
f480936571_460.returns.push(undefined);
// 1396
o26.nodeName = "A";
// 1397
o26.textContent = "Health";
// 1400
o26.getAttribute = f480936571_473;
// 1402
f480936571_473.returns.push("navigate");
// 1407
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:health;sec:lnav-s;slk:link;cpos:7;");
// 1408
o27.setAttribute = f480936571_460;
// 1409
f480936571_460.returns.push(undefined);
// 1410
o27.nodeName = "A";
// 1411
o27.textContent = "Odd News";
// 1414
o27.getAttribute = f480936571_473;
// 1416
f480936571_473.returns.push("navigate");
// 1421
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:oddnews;sec:lnav-s;slk:link;cpos:8;");
// 1422
o28.setAttribute = f480936571_460;
// 1423
f480936571_460.returns.push(undefined);
// 1424
o28.nodeName = "A";
// 1425
o28.textContent = "Opinion";
// 1428
o28.getAttribute = f480936571_473;
// 1430
f480936571_473.returns.push("navigate");
// 1435
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:opinion;sec:lnav-s;slk:link;cpos:9;");
// 1436
o29.setAttribute = f480936571_460;
// 1437
f480936571_460.returns.push(undefined);
// 1438
o29.nodeName = "A";
// 1439
o29.textContent = "Local";
// 1442
o29.getAttribute = f480936571_473;
// 1444
f480936571_473.returns.push("navigate");
// 1449
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:local;sec:lnav-s;slk:link;cpos:10;");
// 1450
o30.setAttribute = f480936571_460;
// 1451
f480936571_460.returns.push(undefined);
// 1452
o30.nodeName = "A";
// 1453
o30.textContent = "Dear Abby";
// 1456
o30.getAttribute = f480936571_473;
// 1458
f480936571_473.returns.push("navigate");
// 1463
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:dearabby;sec:lnav-s;slk:link;cpos:11;");
// 1464
o31.setAttribute = f480936571_460;
// 1465
f480936571_460.returns.push(undefined);
// 1466
o31.nodeName = "A";
// 1467
o31.textContent = "Comics";
// 1470
o31.getAttribute = f480936571_473;
// 1472
f480936571_473.returns.push("navigate");
// 1477
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:comics;sec:lnav-s;slk:link;cpos:12;");
// 1478
o32.setAttribute = f480936571_460;
// 1479
f480936571_460.returns.push(undefined);
// 1480
o32.nodeName = "A";
// 1481
o32.textContent = "ABC News";
// 1484
o32.getAttribute = f480936571_473;
// 1486
f480936571_473.returns.push("navigate");
// 1491
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:abcnews;sec:lnav-s;slk:link;cpos:13;");
// 1492
o33.setAttribute = f480936571_460;
// 1493
f480936571_460.returns.push(undefined);
// 1494
o33.nodeName = "A";
// 1495
o33.textContent = "Y! News Originals";
// 1498
o33.getAttribute = f480936571_473;
// 1500
f480936571_473.returns.push("navigate");
// 1505
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:;ltxt:ynewsori;sec:lnav-s;slk:link;cpos:14;");
// 1506
f480936571_493 = function() { return f480936571_493.returns[f480936571_493.inst++]; };
f480936571_493.returns = [];
f480936571_493.inst = 0;
// 1507
o5.JSBNG__addEventListener = f480936571_493;
// 1509
f480936571_493.returns.push(undefined);
// 1511
f480936571_422.returns.push(null);
// 1513
f480936571_468.returns.push(undefined);
// 1515
o19 = {};
// 1516
f480936571_422.returns.push(o19);
// 1519
o19.getAttribute = f480936571_473;
// 1521
f480936571_473.returns.push(null);
// 1526
f480936571_473.returns.push("mid:mediacontentlead;mpos:1;sec:mod-ld;");
// 1527
o19.getElementsByTagName = f480936571_474;
// 1528
o34 = {};
// 1529
f480936571_474.returns.push(o34);
// 1530
o34.length = 7;
// 1531
o35 = {};
// 1532
o34["0"] = o35;
// 1533
o36 = {};
// 1534
o34["1"] = o36;
// 1535
o37 = {};
// 1536
o34["2"] = o37;
// 1537
o38 = {};
// 1538
o34["3"] = o38;
// 1539
o39 = {};
// 1540
o34["4"] = o39;
// 1541
o40 = {};
// 1542
o34["5"] = o40;
// 1543
o41 = {};
// 1544
o34["6"] = o41;
// undefined
o34 = null;
// 1546
o34 = {};
// 1547
f480936571_474.returns.push(o34);
// 1548
o34.length = 0;
// undefined
o34 = null;
// 1550
o34 = {};
// 1551
f480936571_474.returns.push(o34);
// 1552
o34.length = 0;
// undefined
o34 = null;
// 1553
o35.sourceIndex = void 0;
// 1554
o35.compareDocumentPosition = f480936571_492;
// 1556
f480936571_492.returns.push(4);
// 1557
o37.compareDocumentPosition = f480936571_492;
// 1558
f480936571_492.returns.push(4);
// 1559
o39.compareDocumentPosition = f480936571_492;
// 1560
f480936571_492.returns.push(4);
// 1562
f480936571_492.returns.push(4);
// 1563
o36.compareDocumentPosition = f480936571_492;
// 1564
f480936571_492.returns.push(4);
// 1566
f480936571_492.returns.push(4);
// 1567
o40.compareDocumentPosition = f480936571_492;
// 1568
f480936571_492.returns.push(4);
// 1570
f480936571_492.returns.push(4);
// 1572
f480936571_492.returns.push(4);
// 1574
f480936571_492.returns.push(4);
// 1575
o38.compareDocumentPosition = f480936571_492;
// 1576
f480936571_492.returns.push(4);
// 1581
f480936571_473.returns.push("yom-mod yom-lead clearfix");
// 1586
f480936571_473.returns.push("yom-mod yom-lead clearfix");
// 1591
f480936571_473.returns.push("yom-mod yom-lead clearfix");
// 1596
f480936571_473.returns.push("yom-mod yom-lead clearfix");
// 1601
f480936571_473.returns.push(null);
// 1602
o35.setAttribute = f480936571_460;
// 1603
f480936571_460.returns.push(undefined);
// 1604
o35.nodeName = "A";
// 1605
o35.textContent = "  ";
// 1606
o34 = {};
// 1607
o35.childNodes = o34;
// 1608
o42 = {};
// 1609
o34["0"] = o42;
// 1610
o42.nodeType = 3;
// undefined
o42 = null;
// 1612
o42 = {};
// 1613
o34["1"] = o42;
// 1614
o42.nodeType = 1;
// 1615
o42.nodeName = "SPAN";
// 1616
o43 = {};
// 1617
o42.childNodes = o43;
// undefined
o42 = null;
// 1618
o43["0"] = void 0;
// undefined
o43 = null;
// 1620
o42 = {};
// 1621
o34["2"] = o42;
// 1622
o42.nodeType = 3;
// undefined
o42 = null;
// 1624
o34["3"] = void 0;
// undefined
o34 = null;
// 1627
o35.getAttribute = f480936571_473;
// 1629
f480936571_473.returns.push("http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html");
// 1634
f480936571_473.returns.push(null);
// 1639
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:;");
// 1640
o36.setAttribute = f480936571_460;
// 1641
f480936571_460.returns.push(undefined);
// 1642
o36.nodeName = "A";
// 1643
o36.textContent = "Judge rules against Zimmerman on evidence";
// 1646
o36.getAttribute = f480936571_473;
// 1648
f480936571_473.returns.push(null);
// 1653
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:;");
// 1654
o37.setAttribute = f480936571_460;
// 1655
f480936571_460.returns.push(undefined);
// 1656
o37.nodeName = "A";
// 1657
o37.textContent = "Read More »";
// 1660
o37.getAttribute = f480936571_473;
// 1662
f480936571_473.returns.push(null);
// 1667
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:;");
// 1668
o38.setAttribute = f480936571_460;
// 1669
f480936571_460.returns.push(undefined);
// 1670
o38.nodeName = "A";
// 1671
o38.textContent = "  ";
// 1672
o34 = {};
// 1673
o38.childNodes = o34;
// 1674
o42 = {};
// 1675
o34["0"] = o42;
// 1676
o42.nodeType = 3;
// undefined
o42 = null;
// 1678
o42 = {};
// 1679
o34["1"] = o42;
// 1680
o42.nodeType = 1;
// 1681
o42.nodeName = "SPAN";
// 1682
o43 = {};
// 1683
o42.childNodes = o43;
// undefined
o42 = null;
// 1684
o43["0"] = void 0;
// undefined
o43 = null;
// 1686
o42 = {};
// 1687
o34["2"] = o42;
// 1688
o42.nodeType = 3;
// undefined
o42 = null;
// 1690
o34["3"] = void 0;
// undefined
o34 = null;
// 1693
o38.getAttribute = f480936571_473;
// 1695
f480936571_473.returns.push("http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html");
// 1700
f480936571_473.returns.push(null);
// 1705
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:;");
// 1706
o39.setAttribute = f480936571_460;
// 1707
f480936571_460.returns.push(undefined);
// 1708
o39.nodeName = "A";
// 1709
o39.textContent = "Bombing suspect heads to 1st public court hearing";
// 1712
o39.getAttribute = f480936571_473;
// 1714
f480936571_473.returns.push(null);
// 1719
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:;");
// 1720
o40.setAttribute = f480936571_460;
// 1721
f480936571_460.returns.push(undefined);
// 1722
o40.nodeName = "A";
// 1723
o40.textContent = "  ";
// 1724
o34 = {};
// 1725
o40.childNodes = o34;
// 1726
o42 = {};
// 1727
o34["0"] = o42;
// 1728
o42.nodeType = 3;
// undefined
o42 = null;
// 1730
o42 = {};
// 1731
o34["1"] = o42;
// 1732
o42.nodeType = 1;
// 1733
o42.nodeName = "SPAN";
// 1734
o43 = {};
// 1735
o42.childNodes = o43;
// undefined
o42 = null;
// 1736
o43["0"] = void 0;
// undefined
o43 = null;
// 1738
o42 = {};
// 1739
o34["2"] = o42;
// 1740
o42.nodeType = 3;
// undefined
o42 = null;
// 1742
o34["3"] = void 0;
// undefined
o34 = null;
// 1745
o40.getAttribute = f480936571_473;
// 1747
f480936571_473.returns.push("http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html");
// 1752
f480936571_473.returns.push(null);
// 1757
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:;");
// 1758
o41.setAttribute = f480936571_460;
// 1759
f480936571_460.returns.push(undefined);
// 1760
o41.nodeName = "A";
// 1761
o41.textContent = "SF probe brings questions over auto speed controls";
// 1764
o41.getAttribute = f480936571_473;
// 1766
f480936571_473.returns.push(null);
// 1771
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:;");
// 1772
o19.JSBNG__addEventListener = f480936571_493;
// 1774
f480936571_493.returns.push(undefined);
// 1776
f480936571_422.returns.push(null);
// 1778
f480936571_468.returns.push(undefined);
// 1780
f480936571_422.returns.push(null);
// 1782
f480936571_468.returns.push(undefined);
// 1784
o34 = {};
// 1785
f480936571_422.returns.push(o34);
// 1788
o34.getAttribute = f480936571_473;
// 1790
f480936571_473.returns.push(null);
// 1795
f480936571_473.returns.push("mid:mediacontentgenericlistings;mpos:2;");
// 1796
o34.getElementsByTagName = f480936571_474;
// 1797
o42 = {};
// 1798
f480936571_474.returns.push(o42);
// 1799
o42.length = 20;
// 1800
o43 = {};
// 1801
o42["0"] = o43;
// 1802
o44 = {};
// 1803
o42["1"] = o44;
// 1804
o45 = {};
// 1805
o42["2"] = o45;
// 1806
o46 = {};
// 1807
o42["3"] = o46;
// 1808
o47 = {};
// 1809
o42["4"] = o47;
// 1810
o48 = {};
// 1811
o42["5"] = o48;
// 1812
o49 = {};
// 1813
o42["6"] = o49;
// 1814
o50 = {};
// 1815
o42["7"] = o50;
// 1816
o51 = {};
// 1817
o42["8"] = o51;
// 1818
o52 = {};
// 1819
o42["9"] = o52;
// 1820
o53 = {};
// 1821
o42["10"] = o53;
// 1822
o54 = {};
// 1823
o42["11"] = o54;
// 1824
o55 = {};
// 1825
o42["12"] = o55;
// 1826
o56 = {};
// 1827
o42["13"] = o56;
// 1828
o57 = {};
// 1829
o42["14"] = o57;
// 1830
o58 = {};
// 1831
o42["15"] = o58;
// 1832
o59 = {};
// 1833
o42["16"] = o59;
// 1834
o60 = {};
// 1835
o42["17"] = o60;
// 1836
o61 = {};
// 1837
o42["18"] = o61;
// 1838
o62 = {};
// 1839
o42["19"] = o62;
// undefined
o42 = null;
// 1841
o42 = {};
// 1842
f480936571_474.returns.push(o42);
// 1843
o42.length = 0;
// undefined
o42 = null;
// 1845
o42 = {};
// 1846
f480936571_474.returns.push(o42);
// 1847
o42.length = 0;
// undefined
o42 = null;
// 1848
o43.sourceIndex = void 0;
// 1849
o43.compareDocumentPosition = f480936571_492;
// 1851
f480936571_492.returns.push(4);
// 1852
o45.compareDocumentPosition = f480936571_492;
// 1853
f480936571_492.returns.push(4);
// 1854
o47.compareDocumentPosition = f480936571_492;
// 1855
f480936571_492.returns.push(4);
// 1856
o49.compareDocumentPosition = f480936571_492;
// 1857
f480936571_492.returns.push(4);
// 1858
o51.compareDocumentPosition = f480936571_492;
// 1859
f480936571_492.returns.push(4);
// 1860
o53.compareDocumentPosition = f480936571_492;
// 1861
f480936571_492.returns.push(4);
// 1862
o55.compareDocumentPosition = f480936571_492;
// 1863
f480936571_492.returns.push(4);
// 1864
o57.compareDocumentPosition = f480936571_492;
// 1865
f480936571_492.returns.push(4);
// 1866
o59.compareDocumentPosition = f480936571_492;
// 1867
f480936571_492.returns.push(4);
// 1868
o61.compareDocumentPosition = f480936571_492;
// 1869
f480936571_492.returns.push(4);
// 1871
f480936571_492.returns.push(4);
// 1872
o44.compareDocumentPosition = f480936571_492;
// 1873
f480936571_492.returns.push(4);
// 1875
f480936571_492.returns.push(4);
// 1876
o48.compareDocumentPosition = f480936571_492;
// 1877
f480936571_492.returns.push(4);
// 1879
f480936571_492.returns.push(4);
// 1880
o52.compareDocumentPosition = f480936571_492;
// 1881
f480936571_492.returns.push(4);
// 1883
f480936571_492.returns.push(4);
// 1884
o56.compareDocumentPosition = f480936571_492;
// 1885
f480936571_492.returns.push(4);
// 1887
f480936571_492.returns.push(4);
// 1888
o60.compareDocumentPosition = f480936571_492;
// 1889
f480936571_492.returns.push(4);
// 1891
f480936571_492.returns.push(4);
// 1893
f480936571_492.returns.push(4);
// 1895
f480936571_492.returns.push(4);
// 1896
o46.compareDocumentPosition = f480936571_492;
// 1897
f480936571_492.returns.push(4);
// 1899
f480936571_492.returns.push(4);
// 1901
f480936571_492.returns.push(4);
// 1903
f480936571_492.returns.push(4);
// 1904
o54.compareDocumentPosition = f480936571_492;
// 1905
f480936571_492.returns.push(4);
// 1907
f480936571_492.returns.push(4);
// 1909
f480936571_492.returns.push(4);
// 1911
f480936571_492.returns.push(4);
// 1913
f480936571_492.returns.push(4);
// 1915
f480936571_492.returns.push(4);
// 1917
f480936571_492.returns.push(4);
// 1919
f480936571_492.returns.push(4);
// 1920
o50.compareDocumentPosition = f480936571_492;
// 1921
f480936571_492.returns.push(4);
// 1923
f480936571_492.returns.push(4);
// 1925
f480936571_492.returns.push(4);
// 1927
f480936571_492.returns.push(4);
// 1929
f480936571_492.returns.push(4);
// 1931
f480936571_492.returns.push(4);
// 1933
f480936571_492.returns.push(4);
// 1935
f480936571_492.returns.push(4);
// 1937
f480936571_492.returns.push(4);
// 1939
f480936571_492.returns.push(4);
// 1941
f480936571_492.returns.push(4);
// 1943
f480936571_492.returns.push(4);
// 1945
f480936571_492.returns.push(4);
// 1947
f480936571_492.returns.push(4);
// 1949
f480936571_492.returns.push(4);
// 1951
f480936571_492.returns.push(4);
// 1952
o58.compareDocumentPosition = f480936571_492;
// 1953
f480936571_492.returns.push(4);
// 1958
f480936571_473.returns.push("yom-mod ");
// 1963
f480936571_473.returns.push("yom-mod ");
// 1968
f480936571_473.returns.push("yom-mod ");
// 1973
f480936571_473.returns.push("yom-mod ");
// 1978
f480936571_473.returns.push(null);
// 1979
o43.setAttribute = f480936571_460;
// 1980
f480936571_460.returns.push(undefined);
// 1981
o43.nodeName = "A";
// 1982
o43.textContent = "   ";
// 1983
o42 = {};
// 1984
o43.childNodes = o42;
// 1985
o63 = {};
// 1986
o42["0"] = o63;
// 1987
o63.nodeType = 3;
// undefined
o63 = null;
// 1989
o63 = {};
// 1990
o42["1"] = o63;
// 1991
o63.nodeType = 1;
// 1992
o63.nodeName = "IMG";
// 1995
o63.getAttribute = f480936571_473;
// 1997
f480936571_473.returns.push(null);
// 1998
o64 = {};
// 1999
o63.childNodes = o64;
// 2000
o64["0"] = void 0;
// undefined
o64 = null;
// 2002
o64 = {};
// 2003
o42["2"] = o64;
// 2004
o64.nodeType = 3;
// undefined
o64 = null;
// 2006
o64 = {};
// 2007
o42["3"] = o64;
// 2008
o64.nodeType = 1;
// 2009
o64.nodeName = "SPAN";
// 2010
o65 = {};
// 2011
o64.childNodes = o65;
// undefined
o64 = null;
// 2012
o64 = {};
// 2013
o65["0"] = o64;
// 2014
o64.nodeType = 1;
// 2015
o64.nodeName = "I";
// 2016
o66 = {};
// 2017
o64.childNodes = o66;
// undefined
o64 = null;
// 2018
o66["0"] = void 0;
// undefined
o66 = null;
// 2020
o65["1"] = void 0;
// undefined
o65 = null;
// 2022
o64 = {};
// 2023
o42["4"] = o64;
// 2024
o64.nodeType = 3;
// undefined
o64 = null;
// 2026
o42["5"] = void 0;
// undefined
o42 = null;
// 2029
o43.getAttribute = f480936571_473;
// 2031
f480936571_473.returns.push("/video/david-tillmans-midday-weather-forecast-174557836.html");
// 2036
f480936571_473.returns.push(null);
// 2041
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;");
// 2042
o44.setAttribute = f480936571_460;
// 2043
f480936571_460.returns.push(undefined);
// 2044
o44.nodeName = "A";
// 2045
o44.textContent = "David Tillman's midday weather forecast";
// 2048
o44.getAttribute = f480936571_473;
// 2050
f480936571_473.returns.push(null);
// 2055
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;");
// 2056
o45.setAttribute = f480936571_460;
// 2057
f480936571_460.returns.push(undefined);
// 2058
o45.nodeName = "A";
// 2059
o45.textContent = "   ";
// 2060
o42 = {};
// 2061
o45.childNodes = o42;
// 2062
o64 = {};
// 2063
o42["0"] = o64;
// 2064
o64.nodeType = 3;
// undefined
o64 = null;
// 2066
o64 = {};
// 2067
o42["1"] = o64;
// 2068
o64.nodeType = 1;
// 2069
o64.nodeName = "IMG";
// 2072
o64.getAttribute = f480936571_473;
// 2074
f480936571_473.returns.push(null);
// 2075
o65 = {};
// 2076
o64.childNodes = o65;
// 2077
o65["0"] = void 0;
// undefined
o65 = null;
// 2079
o65 = {};
// 2080
o42["2"] = o65;
// 2081
o65.nodeType = 3;
// undefined
o65 = null;
// 2083
o65 = {};
// 2084
o42["3"] = o65;
// 2085
o65.nodeType = 1;
// 2086
o65.nodeName = "SPAN";
// 2087
o66 = {};
// 2088
o65.childNodes = o66;
// undefined
o65 = null;
// 2089
o65 = {};
// 2090
o66["0"] = o65;
// 2091
o65.nodeType = 1;
// 2092
o65.nodeName = "I";
// 2093
o67 = {};
// 2094
o65.childNodes = o67;
// undefined
o65 = null;
// 2095
o67["0"] = void 0;
// undefined
o67 = null;
// 2097
o66["1"] = void 0;
// undefined
o66 = null;
// 2099
o65 = {};
// 2100
o42["4"] = o65;
// 2101
o65.nodeType = 3;
// undefined
o65 = null;
// 2103
o42["5"] = void 0;
// undefined
o42 = null;
// 2106
o45.getAttribute = f480936571_473;
// 2108
f480936571_473.returns.push("/video/printer-ink-efficiency-tested-consumer-174417327.html");
// 2113
f480936571_473.returns.push(null);
// 2118
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;");
// 2119
o46.setAttribute = f480936571_460;
// 2120
f480936571_460.returns.push(undefined);
// 2121
o46.nodeName = "A";
// 2122
o46.textContent = "Printer ink efficiency tested by Consumer Reports";
// 2125
o46.getAttribute = f480936571_473;
// 2127
f480936571_473.returns.push(null);
// 2132
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;");
// 2133
o47.setAttribute = f480936571_460;
// 2134
f480936571_460.returns.push(undefined);
// 2135
o47.nodeName = "A";
// 2136
o47.textContent = "   ";
// 2137
o42 = {};
// 2138
o47.childNodes = o42;
// 2139
o65 = {};
// 2140
o42["0"] = o65;
// 2141
o65.nodeType = 3;
// undefined
o65 = null;
// 2143
o65 = {};
// 2144
o42["1"] = o65;
// 2145
o65.nodeType = 1;
// 2146
o65.nodeName = "IMG";
// 2149
o65.getAttribute = f480936571_473;
// 2151
f480936571_473.returns.push(null);
// 2152
o66 = {};
// 2153
o65.childNodes = o66;
// 2154
o66["0"] = void 0;
// undefined
o66 = null;
// 2156
o66 = {};
// 2157
o42["2"] = o66;
// 2158
o66.nodeType = 3;
// undefined
o66 = null;
// 2160
o66 = {};
// 2161
o42["3"] = o66;
// 2162
o66.nodeType = 1;
// 2163
o66.nodeName = "SPAN";
// 2164
o67 = {};
// 2165
o66.childNodes = o67;
// undefined
o66 = null;
// 2166
o66 = {};
// 2167
o67["0"] = o66;
// 2168
o66.nodeType = 1;
// 2169
o66.nodeName = "I";
// 2170
o68 = {};
// 2171
o66.childNodes = o68;
// undefined
o66 = null;
// 2172
o68["0"] = void 0;
// undefined
o68 = null;
// 2174
o67["1"] = void 0;
// undefined
o67 = null;
// 2176
o66 = {};
// 2177
o42["4"] = o66;
// 2178
o66.nodeType = 3;
// undefined
o66 = null;
// 2180
o42["5"] = void 0;
// undefined
o42 = null;
// 2183
o47.getAttribute = f480936571_473;
// 2185
f480936571_473.returns.push("/video/rare-film-shows-fdr-pushed-174224035.html");
// 2190
f480936571_473.returns.push(null);
// 2195
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;");
// 2196
o48.setAttribute = f480936571_460;
// 2197
f480936571_460.returns.push(undefined);
// 2198
o48.nodeName = "A";
// 2199
o48.textContent = "Rare Film Shows FDR Pushed in Wheelchair";
// 2202
o48.getAttribute = f480936571_473;
// 2204
f480936571_473.returns.push(null);
// 2209
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;");
// 2210
o49.setAttribute = f480936571_460;
// 2211
f480936571_460.returns.push(undefined);
// 2212
o49.nodeName = "A";
// 2213
o49.textContent = "   ";
// 2214
o42 = {};
// 2215
o49.childNodes = o42;
// 2216
o66 = {};
// 2217
o42["0"] = o66;
// 2218
o66.nodeType = 3;
// undefined
o66 = null;
// 2220
o66 = {};
// 2221
o42["1"] = o66;
// 2222
o66.nodeType = 1;
// 2223
o66.nodeName = "IMG";
// 2226
o66.getAttribute = f480936571_473;
// 2228
f480936571_473.returns.push(null);
// 2229
o67 = {};
// 2230
o66.childNodes = o67;
// 2231
o67["0"] = void 0;
// undefined
o67 = null;
// 2233
o67 = {};
// 2234
o42["2"] = o67;
// 2235
o67.nodeType = 3;
// undefined
o67 = null;
// 2237
o67 = {};
// 2238
o42["3"] = o67;
// 2239
o67.nodeType = 1;
// 2240
o67.nodeName = "SPAN";
// 2241
o68 = {};
// 2242
o67.childNodes = o68;
// undefined
o67 = null;
// 2243
o67 = {};
// 2244
o68["0"] = o67;
// 2245
o67.nodeType = 1;
// 2246
o67.nodeName = "I";
// 2247
o69 = {};
// 2248
o67.childNodes = o69;
// undefined
o67 = null;
// 2249
o69["0"] = void 0;
// undefined
o69 = null;
// 2251
o68["1"] = void 0;
// undefined
o68 = null;
// 2253
o67 = {};
// 2254
o42["4"] = o67;
// 2255
o67.nodeType = 3;
// undefined
o67 = null;
// 2257
o42["5"] = void 0;
// undefined
o42 = null;
// 2260
o49.getAttribute = f480936571_473;
// 2262
f480936571_473.returns.push("/video/lunch-break-07-10-13-172614033.html");
// 2267
f480936571_473.returns.push(null);
// 2272
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;");
// 2273
o50.setAttribute = f480936571_460;
// 2274
f480936571_460.returns.push(undefined);
// 2275
o50.nodeName = "A";
// 2276
o50.textContent = "Lunch Break 07-10-13";
// 2279
o50.getAttribute = f480936571_473;
// 2281
f480936571_473.returns.push(null);
// 2286
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;");
// 2287
o51.setAttribute = f480936571_460;
// 2288
f480936571_460.returns.push(undefined);
// 2289
o51.nodeName = "A";
// 2290
o51.textContent = "   ";
// 2291
o42 = {};
// 2292
o51.childNodes = o42;
// 2293
o67 = {};
// 2294
o42["0"] = o67;
// 2295
o67.nodeType = 3;
// undefined
o67 = null;
// 2297
o67 = {};
// 2298
o42["1"] = o67;
// 2299
o67.nodeType = 1;
// 2300
o67.nodeName = "IMG";
// 2303
o67.getAttribute = f480936571_473;
// 2305
f480936571_473.returns.push(null);
// 2306
o68 = {};
// 2307
o67.childNodes = o68;
// 2308
o68["0"] = void 0;
// undefined
o68 = null;
// 2310
o68 = {};
// 2311
o42["2"] = o68;
// 2312
o68.nodeType = 3;
// undefined
o68 = null;
// 2314
o68 = {};
// 2315
o42["3"] = o68;
// 2316
o68.nodeType = 1;
// 2317
o68.nodeName = "SPAN";
// 2318
o69 = {};
// 2319
o68.childNodes = o69;
// undefined
o68 = null;
// 2320
o68 = {};
// 2321
o69["0"] = o68;
// 2322
o68.nodeType = 1;
// 2323
o68.nodeName = "I";
// 2324
o70 = {};
// 2325
o68.childNodes = o70;
// undefined
o68 = null;
// 2326
o70["0"] = void 0;
// undefined
o70 = null;
// 2328
o69["1"] = void 0;
// undefined
o69 = null;
// 2330
o68 = {};
// 2331
o42["4"] = o68;
// 2332
o68.nodeType = 3;
// undefined
o68 = null;
// 2334
o42["5"] = void 0;
// undefined
o42 = null;
// 2337
o51.getAttribute = f480936571_473;
// 2339
f480936571_473.returns.push("/video/wishbone-bombay-spice-grill-among-172554941.html");
// 2344
f480936571_473.returns.push(null);
// 2349
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;");
// 2350
o52.setAttribute = f480936571_460;
// 2351
f480936571_460.returns.push(undefined);
// 2352
o52.nodeName = "A";
// 2353
o52.textContent = "Wishbone, Bombay Spice & Grill, among newcomers at …";
// 2356
o52.getAttribute = f480936571_473;
// 2358
f480936571_473.returns.push(null);
// 2363
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;");
// 2364
o53.setAttribute = f480936571_460;
// 2365
f480936571_460.returns.push(undefined);
// 2366
o53.nodeName = "A";
// 2367
o53.textContent = "   ";
// 2368
o42 = {};
// 2369
o53.childNodes = o42;
// 2370
o68 = {};
// 2371
o42["0"] = o68;
// 2372
o68.nodeType = 3;
// undefined
o68 = null;
// 2374
o68 = {};
// 2375
o42["1"] = o68;
// 2376
o68.nodeType = 1;
// 2377
o68.nodeName = "IMG";
// 2380
o68.getAttribute = f480936571_473;
// 2382
f480936571_473.returns.push(null);
// 2383
o69 = {};
// 2384
o68.childNodes = o69;
// 2385
o69["0"] = void 0;
// undefined
o69 = null;
// 2387
o69 = {};
// 2388
o42["2"] = o69;
// 2389
o69.nodeType = 3;
// undefined
o69 = null;
// 2391
o69 = {};
// 2392
o42["3"] = o69;
// 2393
o69.nodeType = 1;
// 2394
o69.nodeName = "SPAN";
// 2395
o70 = {};
// 2396
o69.childNodes = o70;
// undefined
o69 = null;
// 2397
o69 = {};
// 2398
o70["0"] = o69;
// 2399
o69.nodeType = 1;
// 2400
o69.nodeName = "I";
// 2401
o71 = {};
// 2402
o69.childNodes = o71;
// undefined
o69 = null;
// 2403
o71["0"] = void 0;
// undefined
o71 = null;
// 2405
o70["1"] = void 0;
// undefined
o70 = null;
// 2407
o69 = {};
// 2408
o42["4"] = o69;
// 2409
o69.nodeType = 3;
// undefined
o69 = null;
// 2411
o42["5"] = void 0;
// undefined
o42 = null;
// 2414
o53.getAttribute = f480936571_473;
// 2416
f480936571_473.returns.push("/video/whitey-bulger-ex-partner-trade-171312946.html");
// 2421
f480936571_473.returns.push(null);
// 2426
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;");
// 2427
o54.setAttribute = f480936571_460;
// 2428
f480936571_460.returns.push(undefined);
// 2429
o54.nodeName = "A";
// 2430
o54.textContent = "Whitey Bulger, ex-partner trade curses in courtroo …";
// 2433
o54.getAttribute = f480936571_473;
// 2435
f480936571_473.returns.push(null);
// 2440
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;");
// 2441
o55.setAttribute = f480936571_460;
// 2442
f480936571_460.returns.push(undefined);
// 2443
o55.nodeName = "A";
// 2444
o55.textContent = "   ";
// 2445
o42 = {};
// 2446
o55.childNodes = o42;
// 2447
o69 = {};
// 2448
o42["0"] = o69;
// 2449
o69.nodeType = 3;
// undefined
o69 = null;
// 2451
o69 = {};
// 2452
o42["1"] = o69;
// 2453
o69.nodeType = 1;
// 2454
o69.nodeName = "IMG";
// 2457
o69.getAttribute = f480936571_473;
// 2459
f480936571_473.returns.push(null);
// 2460
o70 = {};
// 2461
o69.childNodes = o70;
// 2462
o70["0"] = void 0;
// undefined
o70 = null;
// 2464
o70 = {};
// 2465
o42["2"] = o70;
// 2466
o70.nodeType = 3;
// undefined
o70 = null;
// 2468
o70 = {};
// 2469
o42["3"] = o70;
// 2470
o70.nodeType = 1;
// 2471
o70.nodeName = "SPAN";
// 2472
o71 = {};
// 2473
o70.childNodes = o71;
// undefined
o70 = null;
// 2474
o70 = {};
// 2475
o71["0"] = o70;
// 2476
o70.nodeType = 1;
// 2477
o70.nodeName = "I";
// 2478
o72 = {};
// 2479
o70.childNodes = o72;
// undefined
o70 = null;
// 2480
o72["0"] = void 0;
// undefined
o72 = null;
// 2482
o71["1"] = void 0;
// undefined
o71 = null;
// 2484
o70 = {};
// 2485
o42["4"] = o70;
// 2486
o70.nodeType = 3;
// undefined
o70 = null;
// 2488
o42["5"] = void 0;
// undefined
o42 = null;
// 2491
o55.getAttribute = f480936571_473;
// 2493
f480936571_473.returns.push("/video/taste-chicago-2013-opens-165744456.html");
// 2498
f480936571_473.returns.push(null);
// 2503
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;");
// 2504
o56.setAttribute = f480936571_460;
// 2505
f480936571_460.returns.push(undefined);
// 2506
o56.nodeName = "A";
// 2507
o56.textContent = "Taste of Chicago 2013 opens";
// 2510
o56.getAttribute = f480936571_473;
// 2512
f480936571_473.returns.push(null);
// 2517
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;");
// 2518
o57.setAttribute = f480936571_460;
// 2519
f480936571_460.returns.push(undefined);
// 2520
o57.nodeName = "A";
// 2521
o57.textContent = "   ";
// 2522
o42 = {};
// 2523
o57.childNodes = o42;
// 2524
o70 = {};
// 2525
o42["0"] = o70;
// 2526
o70.nodeType = 3;
// undefined
o70 = null;
// 2528
o70 = {};
// 2529
o42["1"] = o70;
// 2530
o70.nodeType = 1;
// 2531
o70.nodeName = "IMG";
// 2534
o70.getAttribute = f480936571_473;
// 2536
f480936571_473.returns.push(null);
// 2537
o71 = {};
// 2538
o70.childNodes = o71;
// 2539
o71["0"] = void 0;
// undefined
o71 = null;
// 2541
o71 = {};
// 2542
o42["2"] = o71;
// 2543
o71.nodeType = 3;
// undefined
o71 = null;
// 2545
o71 = {};
// 2546
o42["3"] = o71;
// 2547
o71.nodeType = 1;
// 2548
o71.nodeName = "SPAN";
// 2549
o72 = {};
// 2550
o71.childNodes = o72;
// undefined
o71 = null;
// 2551
o71 = {};
// 2552
o72["0"] = o71;
// 2553
o71.nodeType = 1;
// 2554
o71.nodeName = "I";
// 2555
o73 = {};
// 2556
o71.childNodes = o73;
// undefined
o71 = null;
// 2557
o73["0"] = void 0;
// undefined
o73 = null;
// 2559
o72["1"] = void 0;
// undefined
o72 = null;
// 2561
o71 = {};
// 2562
o42["4"] = o71;
// 2563
o71.nodeType = 3;
// undefined
o71 = null;
// 2565
o42["5"] = void 0;
// undefined
o42 = null;
// 2568
o57.getAttribute = f480936571_473;
// 2570
f480936571_473.returns.push("/video/officials-defend-paulsboro-train-derailment-163843236.html");
// 2575
f480936571_473.returns.push(null);
// 2580
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;");
// 2581
o58.setAttribute = f480936571_460;
// 2582
f480936571_460.returns.push(undefined);
// 2583
o58.nodeName = "A";
// 2584
o58.textContent = "Officials defend Paulsboro train derailment respon …";
// 2587
o58.getAttribute = f480936571_473;
// 2589
f480936571_473.returns.push(null);
// 2594
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;");
// 2595
o59.setAttribute = f480936571_460;
// 2596
f480936571_460.returns.push(undefined);
// 2597
o59.nodeName = "A";
// 2598
o59.textContent = "   ";
// 2599
o42 = {};
// 2600
o59.childNodes = o42;
// 2601
o71 = {};
// 2602
o42["0"] = o71;
// 2603
o71.nodeType = 3;
// undefined
o71 = null;
// 2605
o71 = {};
// 2606
o42["1"] = o71;
// 2607
o71.nodeType = 1;
// 2608
o71.nodeName = "IMG";
// 2611
o71.getAttribute = f480936571_473;
// 2613
f480936571_473.returns.push(null);
// 2614
o72 = {};
// 2615
o71.childNodes = o72;
// 2616
o72["0"] = void 0;
// undefined
o72 = null;
// 2618
o72 = {};
// 2619
o42["2"] = o72;
// 2620
o72.nodeType = 3;
// undefined
o72 = null;
// 2622
o72 = {};
// 2623
o42["3"] = o72;
// 2624
o72.nodeType = 1;
// 2625
o72.nodeName = "SPAN";
// 2626
o73 = {};
// 2627
o72.childNodes = o73;
// undefined
o72 = null;
// 2628
o72 = {};
// 2629
o73["0"] = o72;
// 2630
o72.nodeType = 1;
// 2631
o72.nodeName = "I";
// 2632
o74 = {};
// 2633
o72.childNodes = o74;
// undefined
o72 = null;
// 2634
o74["0"] = void 0;
// undefined
o74 = null;
// 2636
o73["1"] = void 0;
// undefined
o73 = null;
// 2638
o72 = {};
// 2639
o42["4"] = o72;
// 2640
o72.nodeType = 3;
// undefined
o72 = null;
// 2642
o42["5"] = void 0;
// undefined
o42 = null;
// 2645
o59.getAttribute = f480936571_473;
// 2647
f480936571_473.returns.push("/video/humboldt-park-sex-assault-near-112404068.html");
// 2652
f480936571_473.returns.push(null);
// 2657
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;");
// 2658
o60.setAttribute = f480936571_460;
// 2659
f480936571_460.returns.push(undefined);
// 2660
o60.nodeName = "A";
// 2661
o60.textContent = "Police searching for bus stop attacker in Humboldt …";
// 2664
o60.getAttribute = f480936571_473;
// 2666
f480936571_473.returns.push(null);
// 2671
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;");
// 2672
o61.setAttribute = f480936571_460;
// 2673
f480936571_460.returns.push(undefined);
// 2674
o61.nodeName = "A";
// 2675
o61.textContent = "   ";
// 2676
o42 = {};
// 2677
o61.childNodes = o42;
// 2678
o72 = {};
// 2679
o42["0"] = o72;
// 2680
o72.nodeType = 3;
// undefined
o72 = null;
// 2682
o72 = {};
// 2683
o42["1"] = o72;
// 2684
o72.nodeType = 1;
// 2685
o72.nodeName = "IMG";
// 2688
o72.getAttribute = f480936571_473;
// 2690
f480936571_473.returns.push(null);
// 2691
o73 = {};
// 2692
o72.childNodes = o73;
// 2693
o73["0"] = void 0;
// undefined
o73 = null;
// 2695
o73 = {};
// 2696
o42["2"] = o73;
// 2697
o73.nodeType = 3;
// undefined
o73 = null;
// 2699
o73 = {};
// 2700
o42["3"] = o73;
// 2701
o73.nodeType = 1;
// 2702
o73.nodeName = "SPAN";
// 2703
o74 = {};
// 2704
o73.childNodes = o74;
// undefined
o73 = null;
// 2705
o73 = {};
// 2706
o74["0"] = o73;
// 2707
o73.nodeType = 1;
// 2708
o73.nodeName = "I";
// 2709
o75 = {};
// 2710
o73.childNodes = o75;
// undefined
o73 = null;
// 2711
o75["0"] = void 0;
// undefined
o75 = null;
// 2713
o74["1"] = void 0;
// undefined
o74 = null;
// 2715
o73 = {};
// 2716
o42["4"] = o73;
// 2717
o73.nodeType = 3;
// undefined
o73 = null;
// 2719
o42["5"] = void 0;
// undefined
o42 = null;
// 2722
o61.getAttribute = f480936571_473;
// 2724
f480936571_473.returns.push("/video/teen-being-questioned-mothers-murder-112642183.html");
// 2729
f480936571_473.returns.push(null);
// 2734
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;");
// 2735
o62.setAttribute = f480936571_460;
// 2736
f480936571_460.returns.push(undefined);
// 2737
o62.nodeName = "A";
// 2738
o62.textContent = "Teen charged in mother's murder";
// 2741
o62.getAttribute = f480936571_473;
// 2743
f480936571_473.returns.push(null);
// 2748
f480936571_473.returns.push("itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;");
// 2749
o34.JSBNG__addEventListener = f480936571_493;
// undefined
o34 = null;
// 2751
f480936571_493.returns.push(undefined);
// 2753
o34 = {};
// 2754
f480936571_422.returns.push(o34);
// 2757
o34.getAttribute = f480936571_473;
// 2759
f480936571_473.returns.push(null);
// 2764
f480936571_473.returns.push(null);
// 2765
o34.getElementsByTagName = f480936571_474;
// 2766
o42 = {};
// 2767
f480936571_474.returns.push(o42);
// 2768
o42.length = 6;
// 2769
o73 = {};
// 2770
o42["0"] = o73;
// 2771
o74 = {};
// 2772
o42["1"] = o74;
// 2773
o75 = {};
// 2774
o42["2"] = o75;
// 2775
o76 = {};
// 2776
o42["3"] = o76;
// 2777
o77 = {};
// 2778
o42["4"] = o77;
// 2779
o78 = {};
// 2780
o42["5"] = o78;
// undefined
o42 = null;
// 2782
o42 = {};
// 2783
f480936571_474.returns.push(o42);
// 2784
o42.length = 0;
// undefined
o42 = null;
// 2786
o42 = {};
// 2787
f480936571_474.returns.push(o42);
// 2788
o42.length = 0;
// undefined
o42 = null;
// 2789
o73.sourceIndex = void 0;
// 2790
o73.compareDocumentPosition = f480936571_492;
// 2792
f480936571_492.returns.push(4);
// 2793
o75.compareDocumentPosition = f480936571_492;
// 2794
f480936571_492.returns.push(4);
// 2795
o77.compareDocumentPosition = f480936571_492;
// 2796
f480936571_492.returns.push(4);
// 2798
f480936571_492.returns.push(4);
// 2799
o74.compareDocumentPosition = f480936571_492;
// 2800
f480936571_492.returns.push(4);
// 2802
f480936571_492.returns.push(4);
// 2804
f480936571_492.returns.push(4);
// 2806
f480936571_492.returns.push(4);
// 2807
o76.compareDocumentPosition = f480936571_492;
// 2808
f480936571_492.returns.push(4);
// 2813
f480936571_473.returns.push("yom-mod yom-footer-info");
// 2818
f480936571_473.returns.push("yom-mod yom-footer-info");
// 2823
f480936571_473.returns.push("yom-mod yom-footer-info");
// 2828
f480936571_473.returns.push("yom-mod yom-footer-info");
// 2833
f480936571_473.returns.push(null);
// 2834
o73.setAttribute = f480936571_460;
// 2835
f480936571_460.returns.push(undefined);
// 2836
o73.nodeName = "A";
// 2837
o73.textContent = "Help";
// 2840
o73.getAttribute = f480936571_473;
// 2842
f480936571_473.returns.push(null);
// 2847
f480936571_473.returns.push(null);
// 2848
o74.setAttribute = f480936571_460;
// 2849
f480936571_460.returns.push(undefined);
// 2850
o74.nodeName = "A";
// 2851
o74.textContent = "Suggestions";
// 2854
o74.getAttribute = f480936571_473;
// 2856
f480936571_473.returns.push(null);
// 2861
f480936571_473.returns.push(null);
// 2862
o75.setAttribute = f480936571_460;
// 2863
f480936571_460.returns.push(undefined);
// 2864
o75.nodeName = "A";
// 2865
o75.textContent = "Privacy Policy";
// 2868
o75.getAttribute = f480936571_473;
// 2870
f480936571_473.returns.push(null);
// 2875
f480936571_473.returns.push(null);
// 2876
o76.setAttribute = f480936571_460;
// 2877
f480936571_460.returns.push(undefined);
// 2878
o76.nodeName = "A";
// 2879
o76.textContent = "About Our Ads";
// 2882
o76.getAttribute = f480936571_473;
// 2884
f480936571_473.returns.push(null);
// 2889
f480936571_473.returns.push(null);
// 2890
o77.setAttribute = f480936571_460;
// 2891
f480936571_460.returns.push(undefined);
// 2892
o77.nodeName = "A";
// 2893
o77.textContent = "Terms of Service";
// 2896
o77.getAttribute = f480936571_473;
// 2898
f480936571_473.returns.push(null);
// 2903
f480936571_473.returns.push(null);
// 2904
o78.setAttribute = f480936571_460;
// 2905
f480936571_460.returns.push(undefined);
// 2906
o78.nodeName = "A";
// 2907
o78.textContent = "Copyright/IP Policy";
// 2910
o78.getAttribute = f480936571_473;
// 2912
f480936571_473.returns.push(null);
// 2917
f480936571_473.returns.push(null);
// 2918
o34.JSBNG__addEventListener = f480936571_493;
// undefined
o34 = null;
// 2920
f480936571_493.returns.push(undefined);
// 2921
f480936571_14.returns.push(undefined);
// 2922
o34 = {};
// 2923
f480936571_0.returns.push(o34);
// undefined
o34 = null;
// 2924
f480936571_12.returns.push(1);
// 2926
f480936571_417.returns.push(0.8569039825815707);
// 2927
f480936571_417.returns.push(0.8280598691198975);
// 2928
f480936571_417.returns.push(0.3282994737382978);
// 2929
f480936571_417.returns.push(0.3593195932917297);
// 2930
f480936571_417.returns.push(0.6531947136390954);
// 2931
f480936571_417.returns.push(0.7062809963244945);
// 2932
f480936571_417.returns.push(0.47518487297929823);
// 2933
f480936571_417.returns.push(0.8348266689572483);
// 2934
f480936571_417.returns.push(0.15440003667026758);
// 2935
f480936571_417.returns.push(0.8690161311533302);
// 2936
f480936571_417.returns.push(0.8184112084563822);
// 2937
f480936571_417.returns.push(0.19260777765884995);
// 2938
o0.title = "Yahoo! News - Latest News & Headlines";
// 2939
o34 = {};
// 2940
f480936571_0.returns.push(o34);
// undefined
o34 = null;
// 2942
o2.width = 1280;
// 2943
o2.height = 800;
// 2944
o2.colorDepth = 24;
// undefined
o2 = null;
// 2945
o2 = {};
// 2946
f480936571_0.returns.push(o2);
// 2947
f480936571_657 = function() { return f480936571_657.returns[f480936571_657.inst++]; };
f480936571_657.returns = [];
f480936571_657.inst = 0;
// 2949
f480936571_657.returns.push(1373481909641);
// 2951
o34 = {};
// 2952
f480936571_428.returns.push(o34);
// 2953
o34.length = 1;
// 2955
o42 = {};
// 2956
f480936571_423.returns.push(o42);
// 2957
o42.setAttribute = f480936571_460;
// 2958
f480936571_460.returns.push(undefined);
// 2960
f480936571_460.returns.push(undefined);
// 2962
f480936571_460.returns.push(undefined);
// 2964
f480936571_460.returns.push(undefined);
// 2965
o42.JSBNG__addEventListener = f480936571_493;
// 2966
f480936571_493.returns.push(undefined);
// 2967
o34["0"] = o7;
// 2969
f480936571_455.returns.push(o42);
// 2975
f480936571_660 = function() { return f480936571_660.returns[f480936571_660.inst++]; };
f480936571_660.returns = [];
f480936571_660.inst = 0;
// 2976
o0.createEvent = f480936571_660;
// 2977
f480936571_661 = function() { return f480936571_661.returns[f480936571_661.inst++]; };
f480936571_661.returns = [];
f480936571_661.inst = 0;
// 2979
f480936571_662 = function() { return f480936571_662.returns[f480936571_662.inst++]; };
f480936571_662.returns = [];
f480936571_662.inst = 0;
// 2980
f480936571_661.returns.push(f480936571_662);
// 2981
o79 = {};
// 2982
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 2983
o79 = {};
// 2984
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 2987
f480936571_665 = function() { return f480936571_665.returns[f480936571_665.inst++]; };
f480936571_665.returns = [];
f480936571_665.inst = 0;
// 2988
f480936571_661.returns.push(f480936571_665);
// 2989
o79 = {};
// 2990
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 2991
o79 = {};
// 2992
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 2993
o0.JSBNG__addEventListener = f480936571_493;
// 2995
f480936571_668 = function() { return f480936571_668.returns[f480936571_668.inst++]; };
f480936571_668.returns = [];
f480936571_668.inst = 0;
// 2996
f480936571_661.returns.push(f480936571_668);
// 2997
o79 = {};
// 2998
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 2999
f480936571_493.returns.push(undefined);
// 3000
o79 = {};
// 3001
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 3003
f480936571_671 = function() { return f480936571_671.returns[f480936571_671.inst++]; };
f480936571_671.returns = [];
f480936571_671.inst = 0;
// 3004
f480936571_661.returns.push(f480936571_671);
// 3005
o79 = {};
// 3006
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// 3007
f480936571_7.returns.push(undefined);
// 3008
o79 = {};
// 3009
f480936571_0.returns.push(o79);
// undefined
o79 = null;
// undefined
fo480936571_1_body.returns.push(o16);
// 3011
o79 = {};
// 3012
f480936571_0.returns.push(o79);
// 3013
o79.getTime = f480936571_419;
// undefined
o79 = null;
// 3014
f480936571_419.returns.push(1373481909707);
// 3017
o79 = {};
// 3018
f480936571_422.returns.push(o79);
// 3019
o79.innerHTML = "<center><div id=\"yom-ad-SDARLA-iframe\" class=\"yom-ad\"><center><script type=\"text/javascript\" src=\"http://l.yimg.com/rq/darla/2-6-3/js/g-r-min.js\"></script><script type=\"text/plain\" id=\"fc\" _ver=\"2-6-3\">{ \"positions\": [ { \"html\": \"<style type=\\\"text/css\\\">\\n.can_ad_slug {font-family:arial;font-size:11px;color:#999;text-decoration:none;background-image:url('http://s.yimg.com/hl/a/optimized/adchoice_1.png');background-repeat:no-repeat;background-position:right;padding:0px 14px 0px 1px !important;margin:1px 0px 1px 0;cursor:hand;height:12px;display:inline-block;line-height:12px;background-color:#ffffff;}\\n.ad_slug_table {position: relative;}\\n.ad_slug_table a {text-decoration:none;}\\n.ad_slug_table div.CAN_marker { display:none;}\\n.can_ad_slug span {display:none;}\\n.can_ad_slug:hover {zoom: 1;}\\n.ad_slug_table .ad_slug_table .can_ad_tr td {display: none;}\\n.can_ad_slug:hover span {display:inline-block;color:#999;font-family:arial;font-size:11px;}\\n.can_ad_tr {position:absolute;top:0;right:1px;z-index:999;}\\n</style>\\n<div class=\\\"CAN_ad\\\">\\n<table class=\\\"ad_slug_table\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" border=\\\"0\\\">\\n<tr class=\\\"can_ad_tr\\\"><td align=\\\"right\\\"><a href=\\\"http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1aHNwb2MzMChnaWQkUTBkb2tNNi5LXzNCYTdCaVVhX0hsd0RVWXRjS1QxSGRxNndBQkhLaCxzdCQxMzczNDgxOTAwMzA4MzI0LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNzA1MSx2JDIuMCxhaWQkUm5KbTBXS0xjMlEtLGN0JDI1LHlieCRXWHREcHNtQmR0NTVmR01Wc0hBeW5BLGJpJDE4MjQ5NzIwNTEsdyQwKSk/1/*http://info.yahoo.com/relevantads/\\\" class=\\\"CAN_link can_ad_slug\\\" target=\\\"_blank\\\"><span>AdChoices</span></a></td></tr>\\n<tr><td><!--Vendor: SiteScout, Format: IFrame, IO: 466712551-->\\n<div src=\\\"http://mf.sitescout.com/disp?pid=892C1B1&rnd=1373481900.346027&xurl=referrer&cm=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dXU5a3MzYihnaWQkUTBkb2tNNi5LXzNCYTdCaVVhX0hsd0RVWXRjS1QxSGRxNndBQkhLaCxzdCQxMzczNDgxOTAwMzA4MzI0LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNzA1MSx2JDIuMCxhaWQkUm5KbTBXS0xjMlEtLGN0JDI1LHlieCRXWHREcHNtQmR0NTVmR01Wc0hBeW5BLGJpJDE4MjQ5NzIwNTEsciQwLHJkJDE2aW9ucnJ1Yykp/0/*http://global.ard.yahoo.com/SIG=15jcvt80d/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373489100/L=Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh/B=RnJm0WKLc2Q-/J=1373481900346027/K=9svo65LsSMzc90C1tkYLkw/A=7670575586902884517/R=0/X=6/*\\\" width='300' height='250' marginwidth='0' marginheight='0' scrollbars='0' scrolling='no' frameborder='0' bordercolor='#000000' vspace='0' hspace='0'></div><!--QYZ 1824972051,3602507051,98.139.115.90;;LREC;81121452;1;--></td></tr>\\n</table>\\n</div>\", \"id\": \"LREC\", \"meta\": { \"y\": { \"cscHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_d==null)window.xzq_d=new Object();\\nwindow.xzq_d['RnJm0WKLc2Q-']='(as$12rngd08f,aid$RnJm0WKLc2Q-,bi$1824972051,cr$3602507051,ct$25,at$H,eob$-1)';\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rngd08f,aid$RnJm0WKLc2Q-,bi$1824972051,cr$3602507051,ct$25,at$H,eob$-1)\\\"></noscr\"+\"ipt>\", \"cscURI\": \"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rngd08f,aid$RnJm0WKLc2Q-,bi$1824972051,cr$3602507051,ct$25,at$H,eob$-1)\", \"creativeID\": \"3602507051\", \"behavior\": \"non_exp\", \"adID\": \"7670575586902884517\", \"matchID\": \"999999.999999.999999.999999\", \"err\": \"\", \"hasExternal\": 0, \"size\": \"300x250\", \"bookID\": \"1824972051\", \"serveType\": \"-1\", \"slotID\": \"0\" } } },{ \"html\": \"<!-- SpaceID=81121452 loc=MAST noad --><!-- fac-gd2-noad --><!-- gd2-status-2 --><!--QYZ CMS_NONE_AVAIL,,98.139.115.90;;MAST;81121452;2;-->\", \"id\": \"MAST\", \"meta\": { \"y\": { \"cscHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_d==null)window.xzq_d=new Object();\\nwindow.xzq_d['DOxm0WKLc2Q-']='(as$125jefkii,aid$DOxm0WKLc2Q-,cr$-1,ct$25,at$H,eob$-1)';\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125jefkii,aid$DOxm0WKLc2Q-,cr$-1,ct$25,at$H,eob$-1)\\\"></noscr\"+\"ipt>\", \"cscURI\": \"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125jefkii,aid$DOxm0WKLc2Q-,cr$-1,ct$25,at$H,eob$-1)\", \"creativeID\": \"-1\", \"behavior\": \"non_exp\", \"adID\": \"#2\", \"matchID\": \"#2\", \"err\": \"invalid_space\", \"hasExternal\": 0, \"size\": \"\", \"bookID\": \"CMS_NONE_AVAIL\", \"serveType\": \"-1\", \"slotID\": \"1\" } } },{ \"html\": \"<!--Vendor: Right Media, Format: IFrame --><div ALLOWTRANSPARENCY=TRUE FRAMEBORDER=0 MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING=NO WIDTH=300 HEIGHT=250 SRC=\\\"http://ad.yieldmanager.com/st?ad_type=div&publisher_blob=${RS}|Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh|81121452|LREC2|1373481900.346633&cnt=yan&ad_size=300x250&site=140477&section_code=2288163051&cb=1373481900.346633&yud=smpv%3d3%26ed%3dzAomdE.7n1vQ06Bzq5du4W6H0h1AhZ0BrKw-&pub_redirect_unencoded=1&pub_redirect=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWcwbzM4ZShnaWQkUTBkb2tNNi5LXzNCYTdCaVVhX0hsd0RVWXRjS1QxSGRxNndBQkhLaCxzdCQxMzczNDgxOTAwMzA4MzI0LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzA4NTQ4MDU1MSx2JDIuMCxhaWQkMG1WbjBXS0xjMlEtLGN0JDI1LHlieCRXWHREcHNtQmR0NTVmR01Wc0hBeW5BLGJpJDE1ODUwOTMwNTEsciQwLHJkJDE2aTZtNjE1Mikp/0/*http://global.ard.yahoo.com/SIG=15kpli27g/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC2/Y=YAHOO/EXP=1373489100/L=Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh/B=0mVn0WKLc2Q-/J=1373481900346633/K=9svo65LsSMzc90C1tkYLkw/A=6647776369999917826/R=0/X=6/*\\\"></div><!--QYZ 1585093051,3085480551,98.139.115.90;;LREC2;81121452;1;-->\", \"id\": \"LREC2\", \"meta\": { \"y\": { \"cscHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_d==null)window.xzq_d=new Object();\\nwindow.xzq_d['0mVn0WKLc2Q-']='(as$12rbnvc5n,aid$0mVn0WKLc2Q-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)';\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rbnvc5n,aid$0mVn0WKLc2Q-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\\\"></noscr\"+\"ipt>\", \"cscURI\": \"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rbnvc5n,aid$0mVn0WKLc2Q-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\", \"creativeID\": \"3085480551\", \"behavior\": \"non_exp\", \"adID\": \"6647776369999917826\", \"matchID\": \"999999.999999.999999.999999\", \"err\": \"\", \"hasExternal\": 0, \"size\": \"300x250\", \"bookID\": \"1585093051\", \"serveType\": \"-1\", \"slotID\": \"2\" } } } ], \"meta\": { \"y\": { \"pageEndHTML\": \"<scr\"+\"ipt language=javascr\"+\"ipt>\\n(function(){window.xzq_p=function(R){M=R};window.xzq_svr=function(R){J=R};function F(S){var T=document;if(T.xzq_i==null){T.xzq_i=new Array();T.xzq_i.c=0}var R=T.xzq_i;R[++R.c]=new Image();R[R.c].src=S}window.xzq_sr=function(){var S=window;var Y=S.xzq_d;if(Y==null){return }if(J==null){return }var T=J+M;if(T.length>P){C();return }var X=\\\"\\\";var U=0;var W=Math.random();var V=(Y.hasOwnProperty!=null);var R;for(R in Y){if(typeof Y[R]==\\\"string\\\"){if(V&&!Y.hasOwnProperty(R)){continue}if(T.length+X.length+Y[R].length<=P){X+=Y[R]}else{if(T.length+Y[R].length>P){}else{U++;N(T,X,U,W);X=Y[R]}}}}if(U){U++}N(T,X,U,W);C()};function N(R,U,S,T){if(U.length>0){R+=\\\"&al=\\\"}F(R+U+\\\"&s=\\\"+S+\\\"&r=\\\"+T)}function C(){window.xzq_d=null;M=null;J=null}function K(R){xzq_sr()}function B(R){xzq_sr()}function L(U,V,W){if(W){var R=W.toString();var T=U;var Y=R.match(new RegExp(\\\"\\\\\\\\\\\\\\\\(([^\\\\\\\\\\\\\\\\)]*)\\\\\\\\\\\\\\\\)\\\"));Y=(Y[1].length>0?Y[1]:\\\"e\\\");T=T.replace(new RegExp(\\\"\\\\\\\\\\\\\\\\([^\\\\\\\\\\\\\\\\)]*\\\\\\\\\\\\\\\\)\\\",\\\"g\\\"),\\\"(\\\"+Y+\\\")\\\");if(R.indexOf(T)<0){var X=R.indexOf(\\\"{\\\");if(X>0){R=R.substring(X,R.length)}else{return W}R=R.replace(new RegExp(\\\"([^a-zA-Z0-9$_])this([^a-zA-Z0-9$_])\\\",\\\"g\\\"),\\\"$1xzq_this$2\\\");var Z=T+\\\";var rv = f( \\\"+Y+\\\",this);\\\";var S=\\\"{var a0 = '\\\"+Y+\\\"';var ofb = '\\\"+escape(R)+\\\"' ;var f = new Function( a0, 'xzq_this', unescape(ofb));\\\"+Z+\\\"return rv;}\\\";return new Function(Y,S)}else{return W}}return V}window.xzq_eh=function(){if(E||I){this.onload=L(\\\"xzq_onload(e)\\\",K,this.onload,0);if(E&&typeof (this.onbeforeunload)!=O){this.onbeforeunload=L(\\\"xzq_dobeforeunload(e)\\\",B,this.onbeforeunload,0)}}};window.xzq_s=function(){setTimeout(\\\"xzq_sr()\\\",1)};var J=null;var M=null;var Q=navigator.appName;var H=navigator.appVersion;var G=navigator.userAgent;var A=parseInt(H);var D=Q.indexOf(\\\"Microsoft\\\");var E=D!=-1&&A>=4;var I=(Q.indexOf(\\\"Netscape\\\")!=-1||Q.indexOf(\\\"Opera\\\")!=-1)&&A>=4;var O=\\\"undefined\\\";var P=2000})();\\n</scr\"+\"ipt><scr\"+\"ipt language=javascr\"+\"ipt>\\nif(window.xzq_svr)xzq_svr('http://csc.beap.bc.yahoo.com/');\\nif(window.xzq_p)xzq_p('yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3');\\nif(window.xzq_s)xzq_s();\\n</scr\"+\"ipt><noscr\"+\"ipt><img width=1 height=1 alt=\\\"\\\" src=\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3\\\"></noscr\"+\"ipt>\", \"pos_list\": [ \"LREC\",\"MAST\",\"LREC2\" ], \"spaceID\": \"81121452\", \"host\": \"news.yahoo.com\", \"lookupTime\": \"41\", \"k2_uri\": \"\", \"fac_rt\": \"40143\", \"pvid\": \"Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh\", \"tID\": \"darla_prefetch_1373481900307_1680550104_1\" } } } </script>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-SDARLA\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-SDARLA-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=SDARLA noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s82fcb8176770e30faa77ce41eb7ce50f4335ce51\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0_instance;\n        ((s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0_instance) = ((JSBNG_Record.eventInstance)((\"s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0\"), (s82fcb8176770e30faa77ce41eb7ce50f4335ce51_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLA\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLA-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=SDARLA noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// undefined
o79 = null;
// 3021
f480936571_7.returns.push(undefined);
// 3024
o79 = {};
// 3025
f480936571_422.returns.push(o79);
// 3026
o79.innerHTML = "<center><div id=\"yom-ad-SDARLAEXTRA-iframe\" class=\"yom-ad\"><center>    \n        <script type=\"text/javascript\">try {\n    ((JSBNG_Record.scriptLoad)((\"function loadAdsAfterOnLoad() {\\u000a    YMedia.later(10, this, function() {\\u000a        YMedia.use(\\\"node-base\\\", function(Y) {\\u000a            YUI.AdsDarla = (function() {\\u000a                var nodes = {\\u000a                    \\\"yom-ad-LREC\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LREC-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:300px;height:266px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LREC-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LREC2\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LREC2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:300px;height:266px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LREC2-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LDRB\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LDRB-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:728px;height:93px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LDRB-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LDRB2\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LDRB2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:728px;height:93px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LDRB2-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-LDRB3\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-LDRB3-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:728px;height:93px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-LDRB3-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-MAST\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-MAST-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:970px;height:31px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-MAST-iframe\\\"\\u000a                    },\\u000a                    \\\"yom-ad-WPS\\\": {\\u000a                        node: \\\"\\\\u003Cdiv id='yom-ad-WPS-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\u000a                                    width:320px;height:66px;'\\\\u003E\\\\u000a                            \\\\u003C/div\\\\u003E\\\",\\u000a                        id: \\\"yom-ad-WPS-iframe\\\"\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG = {\\u000a                    servicePath: \\\"http://news.yahoo.com/__darla/php/fc.php\\\",\\u000a                    beaconPath: \\\"http://news.yahoo.com/__darla/php/b.php\\\",\\u000a                    renderPath: \\\"\\\",\\u000a                    allowFiF: false,\\u000a                    srenderPath: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\\\",\\u000a                    renderFile: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\\\",\\u000a                    sfbrenderPath: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\\\",\\u000a                    msgPath: \\\"http://news.yahoo.com/__darla/2-6-3/html/msg.html\\\",\\u000a                    cscPath: \\\"http://l.yimg.com/rq/darla/2-6-3/html/r-csc.html\\\",\\u000a                    root: \\\"__darla\\\",\\u000a                    edgeRoot: \\\"http://l.yimg.com/rq/darla/2-6-3\\\",\\u000a                    sedgeRoot: \\\"https://s.yimg.com/rq/darla/2-6-3\\\",\\u000a                    version: \\\"2-6-3\\\",\\u000a                    tpbURI: \\\"\\\",\\u000a                    beaconsDisabled: true,\\u000a                    rotationTimingDisabled: true,\\u000a                    positions: {\\u000a                        LREC: {\\u000a                            w: 300,\\u000a                            h: 250\\u000a                        },\\u000a                        MAST: [],\\u000a                        LREC2: {\\u000a                            w: 300,\\u000a                            h: 250\\u000a                        }\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG.servicePath = DARLA_CONFIG.servicePath.replace(/\\\\:8033/g, \\\"\\\");\\u000a                DARLA_CONFIG.msgPath = DARLA_CONFIG.msgPath.replace(/\\\\:8033/g, \\\"\\\");\\u000a                DARLA_CONFIG.positions = {\\u000a                    LREC2: {\\u000a                        w: \\\"300\\\",\\u000a                        h: 266,\\u000a                        dest: \\\"yom-ad-LREC2-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LREC2\\\",\\u000a                        id: \\\"LREC2\\\",\\u000a                        clean: \\\"yom-ad-LREC2\\\",\\u000a                        rmxp: 0,\\u000a                        z: 10\\u000a                    },\\u000a                    MAST: {\\u000a                        w: \\\"970\\\",\\u000a                        h: 31,\\u000a                        dest: \\\"yom-ad-MAST-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"MAST\\\",\\u000a                        id: \\\"MAST\\\",\\u000a                        clean: \\\"yom-ad-MAST\\\",\\u000a                        rmxp: 0,\\u000a                        supports: {\\u000a                            \\\"*\\\": 1\\u000a                        }\\u000a                    },\\u000a                    LREC: {\\u000a                        w: \\\"300\\\",\\u000a                        h: 266,\\u000a                        dest: \\\"yom-ad-LREC-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LREC\\\",\\u000a                        id: \\\"LREC\\\",\\u000a                        clean: \\\"yom-ad-LREC\\\",\\u000a                        rmxp: 0,\\u000a                        z: 10\\u000a                    },\\u000a                    WPS: {\\u000a                        w: \\\"320\\\",\\u000a                        h: 66,\\u000a                        dest: \\\"yom-ad-WPS-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"WPS\\\",\\u000a                        id: \\\"WPS\\\",\\u000a                        clean: \\\"yom-ad-WPS\\\",\\u000a                        rmxp: 0,\\u000a                        metaSize: true\\u000a                    },\\u000a                    LDRB3: {\\u000a                        w: \\\"728\\\",\\u000a                        h: 93,\\u000a                        dest: \\\"yom-ad-LDRB3-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LDRB3\\\",\\u000a                        id: \\\"LDRB3\\\",\\u000a                        clean: \\\"yom-ad-LDRB3\\\",\\u000a                        rmxp: 0\\u000a                    },\\u000a                    LDRB2: {\\u000a                        w: \\\"728\\\",\\u000a                        h: 93,\\u000a                        dest: \\\"yom-ad-LDRB2-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LDRB2\\\",\\u000a                        id: \\\"LDRB2\\\",\\u000a                        clean: \\\"yom-ad-LDRB2\\\",\\u000a                        rmxp: 0\\u000a                    },\\u000a                    LDRB: {\\u000a                        w: \\\"728\\\",\\u000a                        h: 93,\\u000a                        dest: \\\"yom-ad-LDRB-iframe\\\",\\u000a                        fr: \\\"expIfr_exp\\\",\\u000a                        pos: \\\"LDRB\\\",\\u000a                        id: \\\"LDRB\\\",\\u000a                        clean: \\\"yom-ad-LDRB\\\",\\u000a                        rmxp: 0\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG.events = {\\u000a                    mediaadsdarla: {\\u000a                        lvl: \\\"2\\\",\\u000a                        sp: \\\"81121452\\\",\\u000a                        npv: \\\"1\\\",\\u000a                        bg: \\\"FFFFFF\\\",\\u000a                        sa: \\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\u000a                        sa_orig: \\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\u000a                        filter: \\\"no_expandable;exp_iframe_expandable;\\\",\\u000a                        mpid: \\\"692\\\",\\u000a                        mpnm: \\\"yahoo_mobile_us_web\\\",\\u000a                        locale: \\\"US\\\",\\u000a                        ps: \\\"LREC,LREC2,LDRB,LDRB2,LDRB3,MAST,WPS\\\",\\u000a                        ml: \\\"\\\",\\u000a                        mps: \\\"\\\"\\u000a                    }\\u000a                };\\u000a                DARLA_CONFIG.onFinishPosRender = function(pos_id) {\\u000a                    var pos_conf, id, el, par, shm;\\u000a                    if (pos_id) {\\u000a                        pos_conf = DARLA.posSettings(pos_id);\\u000a                        id = ((pos_conf && pos_conf.dest));\\u000a                        el = (((id && document.getElementById(id))) || null);\\u000a                        par = ((el && el.parentNode));\\u000a                        shm = ((id && document.getElementById((\\\"shm_\\\" + id))));\\u000a                        if (par) {\\u000a                            par.style.zIndex = 99;\\u000a                        }\\u000a                    ;\\u000a                        if (shm) {\\u000a                            shm.style.zIndex = 99;\\u000a                        }\\u000a                    ;\\u000a                        if (el) {\\u000a                            el.style.zIndex = 100;\\u000a                        }\\u000a                    ;\\u000a                    }\\u000a                ;\\u000a                };\\u000a                DARLA_CONFIG.onPosMsg = function(msg, id) {\\u000a                    if (!DARLA.isIE) {\\u000a                        return\\u000a                    };\\u000a                    setTimeout(function() {\\u000a                        var i = 0, iframes, iframe, id, zmap = {\\u000a                        }, shim = [], d = document;\\u000a                        if (((msg === \\\"exp-ovr\\\") || (msg === \\\"exp-push\\\"))) {\\u000a                            iframes = d.getElementsByTagName(\\\"iframe\\\");\\u000a                            for (; iframe = iframes[i++]; ) {\\u000a                                id = iframe.id;\\u000a                                zmap[id] = iframe.style.zIndex;\\u000a                                if ((id.indexOf(\\\"shm_\\\") === 0)) {\\u000a                                    shim[shim.length] = id;\\u000a                                }\\u000a                            ;\\u000a                            };\\u000a                            if ((shim.length \\u003E 0)) {\\u000a                                for (i = 0; iframe = shim[i++]; ) {\\u000a                                    id = iframe.substr(4);\\u000a                                    d.getElementById(iframe).style.zIndex = (zmap[id] - 1);\\u000a                                };\\u000a                            }\\u000a                        ;\\u000a                        }\\u000a                    ;\\u000a                    }, 10);\\u000a                };\\u000a                DARLA_CONFIG.onSuccess = function(eventId, positions) {\\u000a                    Y.Global.fire(\\\"darla:success\\\", {\\u000a                        positions: positions\\u000a                    });\\u000a                    Y.log((\\\"fetch ad success: \\\" + positions.join(\\\", \\\")), \\\"info\\\", \\\"darla\\\");\\u000a                };\\u000a                DARLA_CONFIG.onFailure = function(eventId) {\\u000a                    var positions = null;\\u000a                    try {\\u000a                        positions = DARLA_CONFIG.events[eventId].ps.split(\\\",\\\");\\u000a                    } catch (e) {\\u000a                    \\u000a                    };\\u000a                    Y.Global.fire(\\\"darla:failure\\\", {\\u000a                        positions: positions\\u000a                    });\\u000a                    Y.log((\\\"fetch ad failure\\\" + ((positions ? ((\\\": \\\" + positions.join(\\\", \\\"))) : \\\"\\\"))), \\\"warn\\\", \\\"darla\\\");\\u000a                };\\u000a                var _prepareNodes = function() {\\u000a                    for (var cleanId in nodes) {\\u000a                        var center = Y.one(((\\\"#\\\" + cleanId) + \\\" \\\\u003E center\\\"));\\u000a                        if ((((center != null) && center) && !Y.one((\\\"#\\\" + nodes[cleanId].id)))) {\\u000a                            center.set(\\\"innerHTML\\\", \\\"\\\");\\u000a                            center.insert(nodes[cleanId].node);\\u000a                        }\\u000a                    ;\\u000a                    };\\u000a                };\\u000a                var w = window, D = w.DARLA, C = w.DARLA_CONFIG, DM = (w.DOC_DOMAIN_SET || 0);\\u000a                if (D) {\\u000a                    if ((D && C)) {\\u000a                        C.dm = DM;\\u000a                    }\\u000a                ;\\u000a                    _prepareNodes();\\u000a                    DARLA.config(C);\\u000a                    DARLA.render();\\u000a                }\\u000a            ;\\u000a                return {\\u000a                    event: function(eventId, spaceId, adsSa) {\\u000a                        if ((window.DARLA && eventId)) {\\u000a                            _prepareNodes();\\u000a                            var eventConfig = {\\u000a                            };\\u000a                            if (!isNaN(spaceId)) {\\u000a                                eventConfig.sp = spaceId;\\u000a                            }\\u000a                        ;\\u000a                            adsSa = ((((typeof adsSa !== \\\"undefined\\\") && (adsSa !== null))) ? adsSa : \\\"\\\");\\u000a                            eventConfig.sa = (DARLA_CONFIG.events[eventId].sa_orig.replace ? DARLA_CONFIG.events[eventId].sa_orig.replace(\\\"ADSSA\\\", adsSa) : \\\"\\\");\\u000a                            DARLA.event(eventId, eventConfig);\\u000a                        }\\u000a                    ;\\u000a                    }\\u000a                };\\u000a            })();\\u000a            YUI.AdsDarla.mediaadsdarla = {\\u000a                fetch: (Y.bind(YUI.AdsDarla.event, YUI.AdsDarla, \\\"mediaadsdarla\\\"))\\u000a            };\\u000a            YUI.AdsDarla.fetch = YUI.AdsDarla.mediaadsdarla.fetch;\\u000a            Y.Global.fire(\\\"darla:ready\\\");\\u000a        });\\u000a    });\\u000a};\\u000a;\\u000aif (window.addEventListener) {\\u000a    window.addEventListener(\\\"load\\\", loadAdsAfterOnLoad, 0);\\u000a} else {\\u000a    if (window.attachEvent) {\\u000a        window.attachEvent(\\\"onload\\\", loadAdsAfterOnLoad);\\u000a    }\\u000a};\"), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    function loadAdsAfterOnLoad() {\n        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0_instance), (this), (arguments)))\n        };\n        (null);\n        (((JSBNG_Record.get)(YMedia, (\"later\")))[(\"later\")])(10, this, ((function() {\n            var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1_instance;\n            ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_1_instance), (this), (arguments)))\n                };\n                (null);\n                (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"node-base\", ((function() {\n                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2_instance;\n                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2\"))));\n                    return ((JSBNG_Record.markFunction)((function(Y) {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_2_instance), (this), (arguments)))\n                        };\n                        (null);\n                        ((JSBNG_Record.set)(YUI, (\"AdsDarla\"), ((function() {\n                            var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3_instance;\n                            ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3\"))));\n                            return ((JSBNG_Record.markFunction)((function() {\n                                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_3_instance), (this), (arguments)))\n                                };\n                                (null);\n                                var nodes = {\n                                    \"yom-ad-LREC\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LREC-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:300px;height:266px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LREC-iframe\"\n                                    },\n                                    \"yom-ad-LREC2\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LREC2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:300px;height:266px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LREC2-iframe\"\n                                    },\n                                    \"yom-ad-LDRB\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LDRB-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:728px;height:93px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LDRB-iframe\"\n                                    },\n                                    \"yom-ad-LDRB2\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LDRB2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:728px;height:93px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LDRB2-iframe\"\n                                    },\n                                    \"yom-ad-LDRB3\": {\n                                        node: \"\\u003Cdiv id='yom-ad-LDRB3-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:728px;height:93px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-LDRB3-iframe\"\n                                    },\n                                    \"yom-ad-MAST\": {\n                                        node: \"\\u003Cdiv id='yom-ad-MAST-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:970px;height:31px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-MAST-iframe\"\n                                    },\n                                    \"yom-ad-WPS\": {\n                                        node: \"\\u003Cdiv id='yom-ad-WPS-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\u000a                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\u000a                                    width:320px;height:66px;'\\u003E\\u000a                            \\u003C/div\\u003E\",\n                                        id: \"yom-ad-WPS-iframe\"\n                                    }\n                                };\n                                DARLA_CONFIG = {\n                                    servicePath: \"http://news.yahoo.com/__darla/php/fc.php\",\n                                    beaconPath: \"http://news.yahoo.com/__darla/php/b.php\",\n                                    renderPath: \"\",\n                                    allowFiF: false,\n                                    srenderPath: \"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\",\n                                    renderFile: \"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\",\n                                    sfbrenderPath: \"http://l.yimg.com/rq/darla/2-6-3/html/r-sf.html\",\n                                    msgPath: \"http://news.yahoo.com/__darla/2-6-3/html/msg.html\",\n                                    cscPath: \"http://l.yimg.com/rq/darla/2-6-3/html/r-csc.html\",\n                                    root: \"__darla\",\n                                    edgeRoot: \"http://l.yimg.com/rq/darla/2-6-3\",\n                                    sedgeRoot: \"https://s.yimg.com/rq/darla/2-6-3\",\n                                    version: \"2-6-3\",\n                                    tpbURI: \"\",\n                                    beaconsDisabled: true,\n                                    rotationTimingDisabled: true,\n                                    positions: {\n                                        LREC: {\n                                            w: 300,\n                                            h: 250\n                                        },\n                                        MAST: [],\n                                        LREC2: {\n                                            w: 300,\n                                            h: 250\n                                        }\n                                    }\n                                };\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"servicePath\"), (((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"servicePath\")))[(\"servicePath\")]), (\"replace\")))[(\"replace\")])(/\\:8033/g, \"\")));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"msgPath\"), (((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"msgPath\")))[(\"msgPath\")]), (\"replace\")))[(\"replace\")])(/\\:8033/g, \"\")));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"positions\"), {\n                                    LREC2: {\n                                        w: \"300\",\n                                        h: 266,\n                                        dest: \"yom-ad-LREC2-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LREC2\",\n                                        id: \"LREC2\",\n                                        clean: \"yom-ad-LREC2\",\n                                        rmxp: 0,\n                                        z: 10\n                                    },\n                                    MAST: {\n                                        w: \"970\",\n                                        h: 31,\n                                        dest: \"yom-ad-MAST-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"MAST\",\n                                        id: \"MAST\",\n                                        clean: \"yom-ad-MAST\",\n                                        rmxp: 0,\n                                        supports: {\n                                            \"*\": 1\n                                        }\n                                    },\n                                    LREC: {\n                                        w: \"300\",\n                                        h: 266,\n                                        dest: \"yom-ad-LREC-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LREC\",\n                                        id: \"LREC\",\n                                        clean: \"yom-ad-LREC\",\n                                        rmxp: 0,\n                                        z: 10\n                                    },\n                                    WPS: {\n                                        w: \"320\",\n                                        h: 66,\n                                        dest: \"yom-ad-WPS-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"WPS\",\n                                        id: \"WPS\",\n                                        clean: \"yom-ad-WPS\",\n                                        rmxp: 0,\n                                        metaSize: true\n                                    },\n                                    LDRB3: {\n                                        w: \"728\",\n                                        h: 93,\n                                        dest: \"yom-ad-LDRB3-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LDRB3\",\n                                        id: \"LDRB3\",\n                                        clean: \"yom-ad-LDRB3\",\n                                        rmxp: 0\n                                    },\n                                    LDRB2: {\n                                        w: \"728\",\n                                        h: 93,\n                                        dest: \"yom-ad-LDRB2-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LDRB2\",\n                                        id: \"LDRB2\",\n                                        clean: \"yom-ad-LDRB2\",\n                                        rmxp: 0\n                                    },\n                                    LDRB: {\n                                        w: \"728\",\n                                        h: 93,\n                                        dest: \"yom-ad-LDRB-iframe\",\n                                        fr: \"expIfr_exp\",\n                                        pos: \"LDRB\",\n                                        id: \"LDRB\",\n                                        clean: \"yom-ad-LDRB\",\n                                        rmxp: 0\n                                    }\n                                }));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"events\"), {\n                                    mediaadsdarla: {\n                                        lvl: \"2\",\n                                        sp: \"81121452\",\n                                        npv: \"1\",\n                                        bg: \"FFFFFF\",\n                                        sa: \"\\\"minihome\\\"=\\\"home\\\" \\\"type\\\"=\\\"page\\\" lang=\\\"en-US\\\"  can_suppress_ugc=\\\"1\\\" LREC=\\\"300x250\\\" LREC2=\\\"300x250\\\"\",\n                                        sa_orig: \"\\\"minihome\\\"=\\\"home\\\" \\\"type\\\"=\\\"page\\\" lang=\\\"en-US\\\"  can_suppress_ugc=\\\"1\\\" LREC=\\\"300x250\\\" LREC2=\\\"300x250\\\"\",\n                                        filter: \"no_expandable;exp_iframe_expandable;\",\n                                        mpid: \"692\",\n                                        mpnm: \"yahoo_mobile_us_web\",\n                                        locale: \"US\",\n                                        ps: \"LREC,LREC2,LDRB,LDRB2,LDRB3,MAST,WPS\",\n                                        ml: \"\",\n                                        mps: \"\"\n                                    }\n                                }));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onFinishPosRender\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4\"))));\n                                    return ((JSBNG_Record.markFunction)((function(pos_id) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_4_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        var pos_conf, id, el, par, shm;\n                                        if (pos_id) {\n                                            pos_conf = (((JSBNG_Record.get)(DARLA, (\"posSettings\")))[(\"posSettings\")])(pos_id);\n                                            id = ((pos_conf && (((JSBNG_Record.get)(pos_conf, (\"dest\")))[(\"dest\")])));\n                                            el = (((id && (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(id))) || null);\n                                            par = ((el && (((JSBNG_Record.get)(el, (\"parentNode\")))[(\"parentNode\")])));\n                                            shm = ((id && (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])((\"shm_\" + id))));\n                                            if (par) {\n                                                ((JSBNG_Record.set)((((JSBNG_Record.get)(par, (\"style\")))[(\"style\")]), (\"zIndex\"), 99));\n                                            }\n                                        ;\n                                            if (shm) {\n                                                ((JSBNG_Record.set)((((JSBNG_Record.get)(shm, (\"style\")))[(\"style\")]), (\"zIndex\"), 99));\n                                            }\n                                        ;\n                                            if (el) {\n                                                ((JSBNG_Record.set)((((JSBNG_Record.get)(el, (\"style\")))[(\"style\")]), (\"zIndex\"), 100));\n                                            }\n                                        ;\n                                        }\n                                        ;\n                                    })));\n                                })())));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onPosMsg\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5\"))));\n                                    return ((JSBNG_Record.markFunction)((function(msg, id) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_5_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        if (!(((JSBNG_Record.get)(DARLA, (\"isIE\")))[(\"isIE\")])) {\n                                            return\n                                        };\n                                        JSBNG__setTimeout(((function() {\n                                            var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6_instance;\n                                            ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6\"))));\n                                            return ((JSBNG_Record.markFunction)((function() {\n                                                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_6_instance), (this), (arguments)))\n                                                };\n                                                (null);\n                                                var i = 0, iframes, iframe, id, zmap = {\n                                                }, shim = [], d = JSBNG__document;\n                                                if (((msg === \"exp-ovr\") || (msg === \"exp-push\"))) {\n                                                    iframes = (((JSBNG_Record.get)(d, (\"getElementsByTagName\")))[(\"getElementsByTagName\")])(\"div\");\n                                                    for (; iframe = (((JSBNG_Record.get)(iframes, ((JSBNG_Record.temps.t86dc5631960c1de9bd6e87063769292e6d7af02c) = i++)))[(JSBNG_Record.temps.t86dc5631960c1de9bd6e87063769292e6d7af02c)]); ) {\n                                                        id = (((JSBNG_Record.get)(iframe, (\"id\")))[(\"id\")]);\n                                                        ((JSBNG_Record.set)(zmap, id, (((JSBNG_Record.get)((((JSBNG_Record.get)(iframe, (\"style\")))[(\"style\")]), (\"zIndex\")))[(\"zIndex\")])));\n                                                        if (((((JSBNG_Record.get)(id, (\"indexOf\")))[(\"indexOf\")])(\"shm_\") === 0)) {\n                                                            ((JSBNG_Record.set)(shim, (((JSBNG_Record.get)(shim, (\"length\")))[(\"length\")]), id));\n                                                        }\n                                                    ;\n                                                    };\n                                                    if (((((JSBNG_Record.get)(shim, (\"length\")))[(\"length\")]) > 0)) {\n                                                        for (i = 0; iframe = (((JSBNG_Record.get)(shim, ((JSBNG_Record.temps.tc87d6019a340d20713bdb53b34369873d5db6c71) = i++)))[(JSBNG_Record.temps.tc87d6019a340d20713bdb53b34369873d5db6c71)]); ) {\n                                                            id = (((JSBNG_Record.get)(iframe, (\"substr\")))[(\"substr\")])(4);\n                                                            ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)(d, (\"getElementById\")))[(\"getElementById\")])(iframe), (\"style\")))[(\"style\")]), (\"zIndex\"), ((((JSBNG_Record.get)(zmap, id))[id]) - 1)));\n                                                        };\n                                                    }\n                                                ;\n                                                }\n                                                ;\n                                            })));\n                                        })()), 10);\n                                    })));\n                                })())));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onSuccess\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7\"))));\n                                    return ((JSBNG_Record.markFunction)((function(eventId, positions) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_7_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"fire\")))[(\"fire\")])(\"darla:success\", {\n                                            positions: positions\n                                        });\n                                        (((JSBNG_Record.get)(Y, (\"log\")))[(\"log\")])((\"fetch ad success: \" + (((JSBNG_Record.get)(positions, (\"join\")))[(\"join\")])(\", \")), \"info\", \"darla\");\n                                    })));\n                                })())));\n                                ((JSBNG_Record.set)(DARLA_CONFIG, (\"onFailure\"), ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8\"))));\n                                    return ((JSBNG_Record.markFunction)((function(eventId) {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_8_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        var positions = null;\n                                        try {\n                                            positions = (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"events\")))[(\"events\")]), eventId))[eventId]), (\"ps\")))[(\"ps\")]), (\"split\")))[(\"split\")])(\",\");\n                                        } catch (e) {\n                                        \n                                        };\n                                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"fire\")))[(\"fire\")])(\"darla:failure\", {\n                                            positions: positions\n                                        });\n                                        (((JSBNG_Record.get)(Y, (\"log\")))[(\"log\")])((\"fetch ad failure\" + ((positions ? ((\": \" + (((JSBNG_Record.get)(positions, (\"join\")))[(\"join\")])(\", \"))) : \"\"))), \"warn\", \"darla\");\n                                    })));\n                                })())));\n                                var _prepareNodes = ((function() {\n                                    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9_instance;\n                                    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9\"))));\n                                    return ((JSBNG_Record.markFunction)((function() {\n                                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_9_instance), (this), (arguments)))\n                                        };\n                                        (null);\n                                        {\n                                            var fin0keys = ((JSBNG_Record.forInKeys)(((JSBNG_Record.getUnwrapped)((nodes))))), fin0i = (0);\n                                            var cleanId;\n                                            for (; (fin0i < fin0keys.length); (fin0i++)) {\n                                                ((cleanId) = (fin0keys[fin0i]));\n                                                {\n                                                    var center = (((JSBNG_Record.get)(Y, (\"one\")))[(\"one\")])(((\"#\" + cleanId) + \" \\u003E center\"));\n                                                    if ((((center != null) && center) && !(((JSBNG_Record.get)(Y, (\"one\")))[(\"one\")])((\"#\" + (((JSBNG_Record.get)((((JSBNG_Record.get)(nodes, cleanId))[cleanId]), (\"id\")))[(\"id\")]))))) {\n                                                        (((JSBNG_Record.get)(center, (\"set\")))[(\"set\")])(\"innerHTML\", \"\");\n                                                        (((JSBNG_Record.get)(center, (\"insert\")))[(\"insert\")])((((JSBNG_Record.get)((((JSBNG_Record.get)(nodes, cleanId))[cleanId]), (\"node\")))[(\"node\")]));\n                                                    }\n                                                ;\n                                                };\n                                            };\n                                        };\n                                    })));\n                                })());\n                                var w = window, D = (((JSBNG_Record.get)(w, (\"DARLA\")))[(\"DARLA\")]), C = (((JSBNG_Record.get)(w, (\"DARLA_CONFIG\")))[(\"DARLA_CONFIG\")]), DM = ((((JSBNG_Record.get)(w, (\"DOC_DOMAIN_SET\")))[(\"DOC_DOMAIN_SET\")]) || 0);\n                                if (D) {\n                                    if ((D && C)) {\n                                        ((JSBNG_Record.set)(C, (\"dm\"), DM));\n                                    }\n                                ;\n                                    _prepareNodes();\n                                    (((JSBNG_Record.get)(DARLA, (\"config\")))[(\"config\")])(C);\n                                    (((JSBNG_Record.get)(DARLA, (\"render\")))[(\"render\")])();\n                                }\n                                ;\n                                return {\n                                    JSBNG__event: ((function() {\n                                        var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10_instance;\n                                        ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10\"))));\n                                        return ((JSBNG_Record.markFunction)((function(eventId, spaceId, adsSa) {\n                                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10\"), (sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_10_instance), (this), (arguments)))\n                                            };\n                                            (null);\n                                            if (((((JSBNG_Record.get)(window, (\"DARLA\")))[(\"DARLA\")]) && eventId)) {\n                                                _prepareNodes();\n                                                var eventConfig = {\n                                                };\n                                                if (!isNaN(spaceId)) {\n                                                    ((JSBNG_Record.set)(eventConfig, (\"sp\"), spaceId));\n                                                }\n                                            ;\n                                                adsSa = ((((typeof adsSa !== \"undefined\") && (adsSa !== null))) ? adsSa : \"\");\n                                                ((JSBNG_Record.set)(eventConfig, (\"sa\"), ((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"events\")))[(\"events\")]), eventId))[eventId]), (\"sa_orig\")))[(\"sa_orig\")]), (\"replace\")))[(\"replace\")]) ? (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(DARLA_CONFIG, (\"events\")))[(\"events\")]), eventId))[eventId]), (\"sa_orig\")))[(\"sa_orig\")]), (\"replace\")))[(\"replace\")])(\"ADSSA\", adsSa) : \"\")));\n                                                (((JSBNG_Record.get)(DARLA, (\"JSBNG__event\")))[(\"JSBNG__event\")])(eventId, eventConfig);\n                                            }\n                                            ;\n                                        })));\n                                    })())\n                                };\n                            })));\n                        })())()));\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"mediaadsdarla\"), {\n                            fetch: ((((JSBNG_Record.get)(Y, (\"bind\")))[(\"bind\")])((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"JSBNG__event\")))[(\"JSBNG__event\")]), (((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), \"mediaadsdarla\"))\n                        }));\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"fetch\"), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"AdsDarla\")))[(\"AdsDarla\")]), (\"mediaadsdarla\")))[(\"mediaadsdarla\")]), (\"fetch\")))[(\"fetch\")])));\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"fire\")))[(\"fire\")])(\"darla:ready\");\n                    })));\n                })()));\n            })));\n        })()));\n    };\n    var sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0_instance;\n    ((sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0_instance) = ((JSBNG_Record.eventInstance)((\"sbc4f27f2687d5a5b60fd0d9b1a656654d168e0b1_0\"))));\n    ((JSBNG_Record.markFunction)((loadAdsAfterOnLoad)));\n;\n    if ((((JSBNG_Record.get)(window, (\"JSBNG__addEventListener\")))[(\"JSBNG__addEventListener\")])) {\n        (((JSBNG_Record.get)(window, (\"JSBNG__addEventListener\")))[(\"JSBNG__addEventListener\")])(\"load\", loadAdsAfterOnLoad, 0);\n    } else {\n        if ((((JSBNG_Record.get)(window, (\"JSBNG__attachEvent\")))[(\"JSBNG__attachEvent\")])) {\n            (((JSBNG_Record.get)(window, (\"JSBNG__attachEvent\")))[(\"JSBNG__attachEvent\")])(\"JSBNG__onload\", loadAdsAfterOnLoad);\n        }\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script>\n<script>try {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-SDARLAEXTRA\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-SDARLAEXTRA-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=SDARLAEXTRA noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0_instance;\n        ((s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0_instance) = ((JSBNG_Record.eventInstance)((\"s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0\"), (s2dff277a1759446eeb4b9cef5eca4a6a3bc5cb8e_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLAEXTRA\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-SDARLAEXTRA-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=SDARLAEXTRA noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};</script></center></div></center>";
// undefined
o79 = null;
// 3027
o79 = {};
// 3029
f480936571_678 = function() { return f480936571_678.returns[f480936571_678.inst++]; };
f480936571_678.returns = [];
f480936571_678.inst = 0;
// 3030
o0.JSBNG__removeEventListener = f480936571_678;
// 3032
f480936571_679 = function() { return f480936571_679.returns[f480936571_679.inst++]; };
f480936571_679.returns = [];
f480936571_679.inst = 0;
// 3033
f480936571_661.returns.push(f480936571_679);
// 3034
o80 = {};
// 3035
f480936571_0.returns.push(o80);
// undefined
o80 = null;
// 3036
f480936571_678.returns.push(undefined);
// 3037
o80 = {};
// 3038
f480936571_0.returns.push(o80);
// undefined
o80 = null;
// 3040
f480936571_682 = function() { return f480936571_682.returns[f480936571_682.inst++]; };
f480936571_682.returns = [];
f480936571_682.inst = 0;
// 3041
f480936571_661.returns.push(f480936571_682);
// 3042
o80 = {};
// 3043
f480936571_0.returns.push(o80);
// undefined
o80 = null;
// 3044
f480936571_6.returns.push(undefined);
// 3045
o80 = {};
// 3046
f480936571_0.returns.push(o80);
// undefined
o80 = null;
// 3048
o80 = {};
// 3049
f480936571_0.returns.push(o80);
// 3051
f480936571_657.returns.push(1373481909817);
// 3052
o81 = {};
// 3053
f480936571_72.returns.push(o81);
// 3054
// 3055
// 3056
o82 = {};
// 3057
f480936571_0.returns.push(o82);
// undefined
o82 = null;
// 3058
f480936571_688 = function() { return f480936571_688.returns[f480936571_688.inst++]; };
f480936571_688.returns = [];
f480936571_688.inst = 0;
// 3059
o81.JSBNG__postMessage = f480936571_688;
// 3060
f480936571_688.returns.push(undefined);
// 3061
f480936571_12.returns.push(2);
// 3062
o82 = {};
// 3064
o83 = {};
// 3065
f480936571_0.returns.push(o83);
// 3066
f480936571_691 = function() { return f480936571_691.returns[f480936571_691.inst++]; };
f480936571_691.returns = [];
f480936571_691.inst = 0;
// 3067
o83.setTime = f480936571_691;
// 3068
o83.getTime = f480936571_419;
// 3069
f480936571_419.returns.push(1373481910036);
// 3070
f480936571_691.returns.push(1405017910036);
// 3071
f480936571_692 = function() { return f480936571_692.returns[f480936571_692.inst++]; };
f480936571_692.returns = [];
f480936571_692.inst = 0;
// 3072
o83.toGMTString = f480936571_692;
// undefined
o83 = null;
// 3073
f480936571_692.returns.push("Thu, 10 Jul 2014 18:45:10 GMT");
// 3074
// 3075
o83 = {};
// 3078
f480936571_694 = function() { return f480936571_694.returns[f480936571_694.inst++]; };
f480936571_694.returns = [];
f480936571_694.inst = 0;
// 3079
o7.removeChild = f480936571_694;
// 3080
f480936571_694.returns.push(o42);
// 3082
o84 = {};
// undefined
o84 = null;
// 3083
// 3084
o84 = {};
// 3085
f480936571_56.returns.push(o84);
// undefined
o84 = null;
// 3086
o84 = {};
// 3087
f480936571_56.returns.push(o84);
// 3088
f480936571_417.returns.push(0.7315652591641992);
// 3089
f480936571_417.returns.push(0.5806466767098755);
// 3090
f480936571_417.returns.push(0.5610713241621852);
// 3091
f480936571_417.returns.push(0.23183778417296708);
// 3092
f480936571_417.returns.push(0.8143938111606985);
// 3093
f480936571_417.returns.push(0.020581179531291127);
// 3094
f480936571_417.returns.push(0.7365237814374268);
// 3095
f480936571_417.returns.push(0.48741700779646635);
// 3096
f480936571_417.returns.push(0.5133128806483);
// 3097
f480936571_417.returns.push(0.13854937418363988);
// 3098
f480936571_417.returns.push(0.775933361845091);
// 3099
f480936571_417.returns.push(0.14889183035120368);
// 3100
o85 = {};
// 3101
f480936571_0.returns.push(o85);
// 3103
f480936571_657.returns.push(1373481914196);
// 3104
f480936571_699 = function() { return f480936571_699.returns[f480936571_699.inst++]; };
f480936571_699.returns = [];
f480936571_699.inst = 0;
// 3105
o84.open = f480936571_699;
// 3106
f480936571_699.returns.push(undefined);
// 3107
// 3108
f480936571_700 = function() { return f480936571_700.returns[f480936571_700.inst++]; };
f480936571_700.returns = [];
f480936571_700.inst = 0;
// 3109
o84.setRequestHeader = f480936571_700;
// 3110
f480936571_700.returns.push(undefined);
// 3111
f480936571_701 = function() { return f480936571_701.returns[f480936571_701.inst++]; };
f480936571_701.returns = [];
f480936571_701.inst = 0;
// 3112
o84.send = f480936571_701;
// undefined
o84 = null;
// 3113
f480936571_701.returns.push(undefined);
// 3117
f480936571_493.returns.push(undefined);
// 3118
o84 = {};
// undefined
o84 = null;
// 3119
// 3122
f480936571_451.returns.push(true);
// 3126
o84 = {};
// 3127
f480936571_423.returns.push(o84);
// 3128
o84.appendChild = f480936571_455;
// 3130
o86 = {};
// 3131
f480936571_456.returns.push(o86);
// 3132
f480936571_455.returns.push(o86);
// undefined
o86 = null;
// 3133
f480936571_705 = function() { return f480936571_705.returns[f480936571_705.inst++]; };
f480936571_705.returns = [];
f480936571_705.inst = 0;
// 3134
o84.contains = f480936571_705;
// undefined
o84 = null;
// 3135
f480936571_705.returns.push(true);
// 3137
o6.textContent = "JSBNG_Record.sendMessageStmt(\"pageload\", {\"data\":\"\\n\\u003Chtml lang=\\\"en-US\\\" xmlns:og=\\\"http://ogp.me/ns#\\\" xmlns:fb=\\\"http://www.facebook.com/2008/fbml\\\"\\u003E\\n    \\u003Chead\\u003E\\n        \\u003Cscript\\u003Evar t_headstart=new Date().getTime();\\u003C/script\\u003E\\n        \\u003Cmeta http-equiv=\\\"content-type\\\" content=\\\"text/html; charset=UTF-8\\\"/\\u003E\\n\\t\\u003Ctitle\\u003EYahoo! News - Latest News &amp; Headlines\\u003C/title\\u003E\\n\\t\\u003Cmeta name=\\\"keywords\\\" lang=\\\"en-US\\\" content=\\\"news, news headlines, daily news, current events, top headlines, breaking news, news photos, news video, full coverage, yahoo news, yahoo\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"description\\\" lang=\\\"en-US\\\" content=\\\"The latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\"/\\u003E\\n\\t\\u003Clink rel=\\\"canonical\\\" href=\\\"http://news.yahoo.com/\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"fb:app_id\\\" content=\\\"90376669494\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:description\\\" content=\\\"The latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:image\\\" content=\\\"http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:site_name\\\" content=\\\"Yahoo! News\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:title\\\" content=\\\"Yahoo! News - Latest News &amp; Headlines\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:type\\\" content=\\\"website\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"og:url\\\" content=\\\"http://news.yahoo.com/\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"twitter:card\\\" content=\\\"summary\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"twitter:description\\\" content=\\\"The latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\"/\\u003E\\n\\t\\u003Cmeta property=\\\"twitter:title\\\" content=\\\"Yahoo! News - Latest News &amp; Headlines\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"application-name\\\" content=\\\"Yahoo! News - Latest News &amp; Headlines\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"msapplication-TileColor\\\" content=\\\"#6e329d\\\"/\\u003E\\n\\t\\u003Cmeta name=\\\"msapplication-TileImage\\\" content=\\\"http://l.yimg.com/j/assets/ipt/win8-tile.png\\\"/\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\"  href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon.png\\\"\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\" sizes=\\\"114x114\\\" href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon-high.png\\\"\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\" sizes=\\\"72x72\\\" href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon-tablet.png\\\"\\u003E\\n\\t\\u003Clink rel=\\\"apple-touch-icon\\\" sizes=\\\"144x144\\\" href=\\\"http://l.yimg.com/j/assets/ipt/default-apple-touch-icon-tablet-high.png\\\"\\u003E\\n        \\n        \\u003Cmeta name=\\\"apple-mobile-web-app-capable\\\" content=\\\"yes\\\"\\u003E\\n        \\u003Cmeta name=\\\"apple-mobile-web-app-status-bar-style\\\" content=\\\"black\\\"\\u003E\\n        \\n\\u003C!--[if lt IE 9]\\u003E\\n                        \\u003Cscript type=\\\"text/javascript\\\" src=\\\"http://l.yimg.com/os/mit/media/p/presentation/html5shiv-min-1218427.js\\\"\\u003E\\u003C/script\\u003E\\n                        \\u003C![endif]--\\u003E\\n\\n\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?d/lib/yui/3.4.1/build/cssreset/cssreset-min.css&d/lib/yui/3.4.1/build/cssfonts/cssfonts-min.css&d/lib/yui/3.4.1/build/cssgrids/cssgrids-min.css&os/mit/media/p/content/grids/v2-master-min-1335630.css&os/mit/media/p/content/grids/v2-desktop-min-1335630.css&os/mit/media/p/content/other/ad-controller-desktop-min-1335630.css&os/mit/media/p/content/other/pane-manager-desktop-min-1335630.css&os/mit/media/p/content/base/v2-master-min-1304022.css&os/mit/media/p/content/base/v2-desktop-min-1335630.css&os/mit/media/p/content/overrides/classic-overrides-min-1280824.css&os/mit/media/m/content_photo/lightbox/lb-desktop-min-1314917.css&os/mit/media/m/header/header-uh3-desktop-min-1325508.css&os/mit/media/m/ads/ads-min-1305513.css&os/mit/media/m/navigation/content-navigation-desktop-min-1335637.css&os/mit/media/m/content_index/lead-desktop-min-1335719.css&os/mit/media/m/footer/footer_info-min-323669.css&os/mit/media/m/footer/footer_info-desktop-min-1338005.css&os/mit/media/m/content_social/media-content-share-buttons-desktop-min-1339153.css\\\" /\\u003E\\n\\n\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?os/mit/media/p/content/other/my-topics-nav-min-1267768.css&os/mit/media/m/content_index/comic-desktop-min-1315714.css&os/mit/media/m/content_index/generic-listings-desktop-min-1311732.css\\\" /\\u003E\\n\\n\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?os/mit/media/themes/v2_base/base-min-1145251.css&os/mit/media/themes/v2_base/base-imagery-min-1313085.css&os/mit/media/themes/v2_navyblue/theme-min-1340051.css&os/mit/media/themes/v2_navyblue/theme-imagery-min-1202855.css&os/mit/media/p/news/region/US-min-759849.css\\\" /\\u003E\\n\\n\\u003Cscript type=\\\"text/javascript\\\" src=\\\"http://l.yimg.com/zz/combo?yui:3.9.1/build/yui/yui-min.js&os/mit/media/p/common/rmp-min-1217643.js&os/mit/media/m/base/viewport-loader-min-1228633.js&ss/rapid-3.4.6.js\\\"\\u003E\\u003C/script\\u003E\\n\\u003Cscript\\u003Eif (!window.YAHOO) { window.YAHOO = {}; } if (!YAHOO.Media) { YAHOO.Media = {}; } if (!YAHOO.widget) { YAHOO.widget = {}; }\\u003C/script\\u003E\\n\\u003Cscript\\u003Eif (!window.YMedia) { var YMedia = YUI(); YMedia.includes = []; }\\u003C/script\\u003E\\n\\u003Cscript\\u003Ewindow.YMEDIA_REQ_ATTR = {device:{\\\"os\\\":\\\"mac os x\\\",\\\"osver\\\":\\\"10.8\\\"},instr:{request_id:\\\"9e982445-db9d-4261-a67e-efe16f86aeec\\\",authfb:0},csbeacon:function() { if(! this._hasIssuedCsBeacon) { this._hasIssuedCsBeacon = true; if(typeof YAHOO === \\\"object\\\" && typeof YAHOO.i13n === \\\"object\\\" && typeof YAHOO.i13n.sendComscoreEvent === \\\"function\\\") {if(YAHOO.i13n.setEga){YAHOO.i13n.setEga(\\\"\\\");} if(YAHOO.i13n.setRdg){YAHOO.i13n.setRdg(\\\"-1\\\");} if(YAHOO.i13n.setSpaceid){YAHOO.i13n.setSpaceid(81121452);} YAHOO.i13n.sendComscoreEvent(); } } },_hasIssuedCsBeacon:false};\\u003C/script\\u003E\\u003Cnoscript\\u003E\\u003Cdiv\\u003E\\u003Cimg src=\\\"http://b.scorecardresearch.com/b?c1=2&c2=7241469&c7=news.yahoo.com%2F&c5=81121452&c15=$-1&cv=2.0&cj=1\\\" style=\\\"display:none\\\" width=\\\"0\\\" height=\\\"0\\\" alt=\\\"\\\" /\\u003E\\u003C/div\\u003E\\u003C/noscript\\u003E\\u003Cscript\\u003Ewindow.YMEDIA_CRUMB = \\\"vft50wE5amf\\\";\\u003C/script\\u003E\\u003C!-- fe576.global.media.gq1.yahoo.com compressed Wed Jul 10 18:45:00 UTC 2013 --\\u003E\\n\\n\\u003Cscript\\u003EYUI.Env.add(window, 'unload', function() { try { YMEDIA_REQ_ATTR.csbeacon(); } catch (e) {} });\\u003C/script\\u003E\\n\\u003Cscript\\u003E\\n                                window.YAHOO = window.YAHOO || {};\\n                                window.YAHOO.i13n = window.YAHOO.i13n || {};\\n                                \\n                                YAHOO.i13n.YWA_CF_MAP = {\\\"ad\\\":58,\\\"authfb\\\":11,\\\"bpos\\\":24,\\\"cat\\\":25,\\\"cpos\\\":21,\\\"ct\\\":23,\\\"ft\\\":51,\\\"ltxt\\\":17,\\\"mrkt\\\":12,\\\"pct\\\":48,\\\"pd\\\":46,\\\"pkgt\\\":22,\\\"pos\\\":20,\\\"pstcat\\\":47,\\\"pt\\\":13,\\\"sca\\\":53,\\\"sec\\\":18,\\\"site\\\":42,\\\"slk\\\":19,\\\"sort\\\":28,\\\"test\\\":14,\\\"v\\\":52,\\\"ver\\\":49,\\\"x\\\":50};\\n                                YAHOO.i13n.YWA_ACTION_MAP = {\\\"click\\\":12,\\\"detecthpset\\\":10,\\\"expand\\\":9,\\\"hover\\\":17,\\\"hswipe\\\":19,\\\"key\\\":13,\\\"scrolldown\\\":16,\\\"scrollup\\\":15,\\\"secview\\\":18,\\\"shrink\\\":11,\\\"svct\\\":14};\\n                                YAHOO.i13n.YWA_OUTCOME_MAP = {\\\"abuse\\\":51,\\\"authview\\\":48,\\\"close\\\":34,\\\"comment\\\":49,\\\"connect\\\":36,\\\"cueauthview\\\":43,\\\"cueconnectview\\\":46,\\\"cuehpset\\\":50,\\\"cueinfoview\\\":45,\\\"cueloadview\\\":44,\\\"cueswipeview\\\":42,\\\"cuetop\\\":48,\\\"drag\\\":21,\\\"drop\\\":22,\\\"end\\\":31,\\\"entitydeclaration\\\":40,\\\"feedback\\\":37,\\\"fetch\\\":30,\\\"filter\\\":35,\\\"hpset\\\":27,\\\"insert\\\":28,\\\"interest\\\":51,\\\"itemdeclaration\\\":37,\\\"loadview\\\":49,\\\"login\\\":33,\\\"msgview\\\":47,\\\"navigate\\\":25,\\\"newview\\\":50,\\\"open\\\":29,\\\"reauthfb\\\":24,\\\"rmct\\\":32,\\\"setlayout\\\":38,\\\"share\\\":23,\\\"sort\\\":39,\\\"top\\\":26,\\\"undo\\\":41,\\\"vswipe\\\":20};\\n                                \\n                                YMedia.rapid = {\\n                                    rapidConfig: {\\\"spaceid\\\":\\\"81121452\\\",\\\"tracked_mods\\\":[\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\"],\\\"text_link_len\\\":8,\\\"client_only\\\":1,\\\"compr_type\\\":\\\"deflate\\\",\\\"ult_token_capture\\\":true,\\\"webworker_file\\\":\\\"\\\\/rapid-worker.js\\\",\\\"test_id\\\":null,\\\"keys\\\":{\\\"x\\\":\\\"114\\\",\\\"juris\\\":\\\"US\\\",\\\"lang\\\":\\\"en-US\\\",\\\"mrkt\\\":\\\"US\\\",\\\"pcp\\\":\\\"\\\",\\\"pct\\\":\\\"\\\",\\\"pd\\\":\\\"\\\",\\\"pst\\\":\\\"\\\",\\\"pstaid\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"pstcat\\\":\\\"news\\\",\\\"pt\\\":\\\"2\\\",\\\"site\\\":\\\"news\\\",\\\"test\\\":\\\"\\\",\\\"ver\\\":\\\"grandslam\\\"},\\\"ywa\\\":{\\\"project_id\\\":\\\"10001393120079\\\",\\\"document_group\\\":\\\"\\\",\\\"document_name\\\":\\\"\\\",\\\"host\\\":\\\"y3.analytics.yahoo.com\\\"},\\\"nofollow_class\\\":[\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\"]},\\n                                    rapidInstance: null,\\n                                    moduleQueue: [],\\n                                    addModules: function(modInfo) {\\n                                        this.moduleQueue.push(modInfo);\\n                                    }\\n                                };\\n                            \\u003C/script\\u003E\\n\\n\\t\\t\\u003Cscript language=\\\"javascript\\\"\\u003E\\n\\t\\t\\nYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-v2-chrome\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/presentation\\\\/v2-chrome-min-1335634.js\\\"},\\\"media-tracking\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/tracking-min-1154405.js\\\"},\\\"media-imageloader\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/imageloader-min-1277138.js\\\"},\\\"media-imageloader-bootstrap\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/imageloader-bootstrap-min-815727.js\\\"},\\\"media-rapid-tracking\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/rapid-tracking-min-1330602.js\\\"},\\\"media-header-uh3-desktop\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/header\\\\/header-uh3-desktop-min-1322619.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\nYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\nYMedia.applyConfig(YUI.YUICfg);\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\nYMedia.use(\\\"media-rmp\\\",\\\"media-viewport-loader\\\",\\\"media-v2-chrome\\\",\\\"media-tracking\\\",\\\"node-base\\\",\\\"event-custom\\\",\\\"dom-deprecated\\\",\\\"node-deprecated\\\",\\\"substitute\\\",\\\"media-imageloader\\\",\\\"media-imageloader-bootstrap\\\",\\\"base-base\\\",\\\"node-style\\\",\\\"node-screen\\\",\\\"media-rapid-tracking\\\",\\\"base\\\",\\\"node\\\",\\\"media-header-uh3-desktop\\\",\\\"intl\\\",function(Y){\\n    \\t  \\n    Y.later(10, this, function() {Y.applyConfig({debug: false});});\\n    Y.later(10, this, function() {\\n                YUI.namespace(\\\"Media\\\").LANGDIR='ltr';\\n                YUI.namespace(\\\"Media\\\").CONTENT_ID = \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\";\\n                });\\n    Y.later(10, this, function() {if (Y.Media && Y.Media.Chrome) {\\n                    Y.Media.pageChrome = Y.Media.Chrome(Y, \\n                    {\\n                        site: 'news',\\n                        lang: 'en-US',\\n                        region: 'US',\\n                        spaceId: '81121452',\\n                        contentId: '5f01278b-803a-3803-9798-7fc79bab4f7d',\\n                        gridType: 'index',\\n                        device: 'full',\\n                        deviceOS: (YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device && YMEDIA_REQ_ATTR.device.os) || '',\\n                        deviceOSVer: (YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device && YMEDIA_REQ_ATTR.device.osver) || '',\\n                        projectId: '10001393120079',\\n                        enableYwaTracking: '0',\\n                        enable2xImgs: '0',\\n                        imgItemsSelector: '.js .yog-bd img',\\n                        enableViewportManagement: '0',\\n                        viewportItemsSelector: '.js .yog-content img,.yog-smartphone.js .yog-bd img',\\n                        transparentImgUrl: 'http://l.yimg.com/os/mit/media/m/base/images/transparent-1093278.png',\\n                        enableRapidTracking: 1,\\n                        rapidConf : {\\\"spaceid\\\":\\\"81121452\\\",\\\"tracked_mods\\\":[\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\"],\\\"text_link_len\\\":8,\\\"client_only\\\":1,\\\"compr_type\\\":\\\"deflate\\\",\\\"ult_token_capture\\\":true,\\\"webworker_file\\\":\\\"\\\\/rapid-worker.js\\\",\\\"test_id\\\":null,\\\"keys\\\":{\\\"x\\\":\\\"114\\\",\\\"juris\\\":\\\"US\\\",\\\"lang\\\":\\\"en-US\\\",\\\"mrkt\\\":\\\"US\\\",\\\"pcp\\\":\\\"\\\",\\\"pct\\\":\\\"\\\",\\\"pd\\\":\\\"\\\",\\\"pst\\\":\\\"\\\",\\\"pstaid\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"pstcat\\\":\\\"news\\\",\\\"pt\\\":\\\"2\\\",\\\"site\\\":\\\"news\\\",\\\"test\\\":\\\"\\\",\\\"ver\\\":\\\"grandslam\\\"},\\\"ywa\\\":{\\\"project_id\\\":\\\"10001393120079\\\",\\\"document_group\\\":\\\"\\\",\\\"document_name\\\":\\\"\\\",\\\"host\\\":\\\"y3.analytics.yahoo.com\\\"},\\\"nofollow_class\\\":[\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\"]},\\n                        bucketId : '',\\n                        baseImageryFallbackCss : 'http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-min-1313085.css',\\n                        baseImageryFallbackCssLteIe7 : 'http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-lteIE7-min-1313085.css'\\n                    });\\n                };});\\n    Y.later(10, this, function() {Y.on('domready', function() { \\n                                            DOMIMG = new Image(); \\n                                            DOMIMG.src = 'http://geo.yahoo.com/p?s=81121452&pt=2&test=nacelle&btype=dom&t='+Math.random(); \\n                                        });});\\n    Y.later(10, this, function() {Y.namespace(\\\"Global.Media\\\").ILBoot = new Y.ImageLoaderBootstrap(200);});\\n    Y.later(10, this, function() {// create RapidTracking object reusing existing moduleQueue\\n                            YMedia.rapid = new Y.Media.RapidTracking({\\n                                instance:    YMedia.rapid && YMedia.rapid.rapidInstance,\\n                                moduleQueue: YMedia.rapid && YMedia.rapid.moduleQueue,\\n                                rapidConfig: YMedia.rapid && YMedia.rapid.rapidConfig,\\n                                config: { \\n                                    selectors: {\\n                                        'bd'   : '#yog-bd',\\n                                        'mods' : '.yom-mod'\\n                                    }\\n                                }\\n                            });});\\n    Y.later(10, this, function() {if(Y.Media.HeaderUH3)Y.Media.HeaderUH3(Y);});\\n\\t\\t   \\n});\\n\\n\\t\\t\\n\\t    \\u003C/script\\u003E\\n\\n        \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t1\\\");\\u003C/script\\u003E\\n        \\u003Cscript\\u003Evar t_headend=new Date().getTime();\\u003C/script\\u003E\\n    \\u003C/head\\u003E\\n    \\u003Cbody id=\\\"yog-body\\\" dir=\\\"ltr\\\" class=\\\"no-js yog-type-index yog-full yog-version-v2 yog-ltr yuac-fixedpos-1 yuac-svg-1\\\"\\u003E\\n        \\u003Cscript type=\\\"text/javascript\\\"\\u003Edocument.body.className = document.body.className.replace('no-js', 'js'); document.body.offsetHeight;\\u003C/script\\u003E\\n        \\u003Cdiv id=\\\"yog-page\\\" class=\\\"yog-page\\\"\\u003E\\n            \\u003Cheader id=\\\"yog-hd\\\" class=\\\"yog-hd\\\"\\u003E\\n                \\n                \\u003Csection id=\\\"header\\\" class=\\\"yom-mod yom-header yom-header-property-0\\\" role=\\\"banner\\\"\\u003E\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/css/599/uh_non_mail-min.css&kx/yucs/uh3/uh3_top_bar/css/224/no_icons-min.css&kx/yucs/uh3/search/css/357/blue_border-min.css\\\"/\\u003E\\n\\n\\u003Cstyle\\u003E#header,#yucs,#y-hd,#hd .yfi_doc,#yfi_hd{background:#fff !important}#yog-hd,#yfi-hd,#ysp-hd,#hd,#yfimh,#yfi_hd,#yfi_fp_hd,#masthead,#yfi_nav_header #navigation,#y-nav #navigation,.ad_in_head{background-color:#fff;background-image:none}#header,#hd .yfi_doc,#y-hd .yfi_doc,#yfi_hd .yfi_doc{width:100% !important}#yucs{margin:0 auto;width:970px}#yfi_nav_header,.y-nav-legobg,#y-nav #navigation{margin:0 auto;width:970px}#yucs .yucs-avatar{height:22px;width:22px}#yucs #yucs-profile_text .yuhead-name-greeting{display:none}#yucs #yucs-profile_text .yuhead-name{top:0;max-width:65px}#yucs-profile_text{max-width:65px}#yog-bd .yom-stage{background:transparent}#yog-hd{height:84px}.yog-bd,.yog-grid{padding:4px 10px}#yucs #yucs-search .yucs-button_theme{background:-moz-linear-gradient(top, #26376a 0, #192446 100%);background:-webkit-gradient(linear, left top, left bottom, color-stop(0%, #26376a), color-stop(100%, #192446));background:-webkit-linear-gradient(top, #26376a 0, #192446 100%);background:-o-linear-gradient(top, #26376a 0, #192446 100%);background:-ms-linear-gradient(top, #26376a 0, #192446 100%);background:linear-gradient(to bottom, #26376a 0, #192446 100%);-webkit-box-shadow:inset 0 1px 3px 0 #3f5baf;box-shadow:inset 0 1px 3px 0 #3f5baf;background-color:#2f477a;background-color:transparent\\\\0/IE9;background-color:transparent\\\\9;*background:none;border:1px solid #152756}#yucs #yucs-search #yucs-prop_search_button_wrapper .yucs-gradient{filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#26376a', endColorstr='#192446',GradientType=0 );-ms-filter:\\\"progid:DXImageTransform.Microsoft.gradient( startColorstr='#26376a', endColorstr='#192446',GradientType=0 )\\\";background-color:#2f477a\\\\0/IE9}#yucs #yucs-search #yucs-prop_search_button_wrapper{*border:1px solid #152756}\\u003C/style\\u003E\\u003Cstyle\\u003E#yog-hd .yom-bar, #yog-hd .yom-nav, #y-nav, #hd .ysp-full-bar,  #yfi_nav_header, #hd .mast {\\r\\nfloat: none;\\r\\nwidth: 970px;\\r\\nmargin: 0 auto;\\r\\n}\\r\\n\\r\\n#yog-bd .yom-stage {\\r\\nbackground: transparent;\\r\\n}\\r\\n\\r\\n#y-nav .yom-nav {\\r\\npadding-top: 0px;\\r\\n}\\r\\n\\r\\n#ysp-search-assist .bd {\\r\\ndisplay:none;\\r\\n}\\r\\n\\r\\n#ysp-search-assist h4 {\\r\\npadding-left: 8px;\\r\\n}\\r\\n\\r\\n\\r\\n    #yfi-portfolios-multi-quotes #y-nav, #yfi-portfolios-multi-quotes #navigation, #yfi-portfolios-multi-quotes .y-nav-legobg, \\r\\n    #yfi-portfolios-my-portfolios #y-nav, #yfi-portfolios-my-portfolios #navigation, #yfi-portfolios-my-portfolios .y-nav-legobg {\\r\\n        width : 100%;\\r\\n    }\\u003C/style\\u003E\\u003Cdiv id=\\\"yucsHead\\\" class=\\\"yucs-news yucs-en-us \\\"\\u003E\\u003Cdiv id=\\\"yucs-top-bar\\\" class='yucs-ps'\\u003E    \\u003Cdiv id='yucs-top-inner'\\u003E        \\u003Cul id='yucs-top-list'\\u003E            \\u003Cli id='yucs-top-home'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=ApFdQ2zLxNsEU4IJLbQhXX6s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=119gkb0u3/EXP=1374691500/**http%3A//www.yahoo.com/\\\"\\u003E\\u003Cspan class=\\\"sp yucs-top-ico\\\"\\u003E\\u003C/span\\u003EHome\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-mail'\\u003E\\u003Ca href=\\\"http://mail.yahoo.com/;_ylt=AjtcydB3B66v20bUT3Q6t4is0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EMail\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-news'\\u003E\\u003Ca href=\\\"http://news.yahoo.com/;_ylt=AojvFkPHJ33FGXOvaEJVDAus0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003ENews\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-sports'\\u003E\\u003Ca href=\\\"http://sports.yahoo.com/;_ylt=AiUHXjilt6YbfzJUMABCFims0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003ESports\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-finance'\\u003E\\u003Ca href=\\\"http://finance.yahoo.com/;_ylt=Ah1z1YdcJNiccmhZqOmcTEys0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EFinance\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-weather'\\u003E\\u003Ca href=\\\"http://weather.yahoo.com/;_ylt=AprA1d94wwn_iy3sq9StJxqs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\\"\\u003EWeather\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-games'\\u003E\\u003Ca href=\\\"http://games.yahoo.com/;_ylt=Ag0euPE8KySTViJiS_zUd1ys0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003EGames\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-groups'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=Aj4sKGMqRfmO5AMv5XbpX6Ks0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11cegcj22/EXP=1374691500/**http%3A//groups.yahoo.com/\\\"\\u003EGroups\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-answers'\\u003E\\u003Ca href=\\\"http://answers.yahoo.com/;_ylt=AslQQPxgfKX9mMbRvz_ZrgKs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EAnswers\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-top-flickr'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AsL4EWyI2vDdQdCtOD7wdTSs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11a5jllln/EXP=1374691500/**http%3A//www.flickr.com/\\\"\\u003EFlickr\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli id='yucs-more' class='yucs-menu yucs-more-activate' data-ylt=\\\"/;_ylt=AvuOxyJVpiB2oYn70Ltp5wCs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=Ar3qDngFU7huaInjVwD9lf2s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11g36bj9q/EXP=1374691500/**http%3A//everything.yahoo.com/\\\" id='yucs-more-link' class='yucs-leavable'\\u003EMore\\u003Cspan class=\\\"sp yucs-top-ico\\\"\\u003E\\u003C/span\\u003E\\u003C/a\\u003E                \\u003Cdiv id='yucs-top-menu'\\u003E                    \\u003Cdiv class='yui3-menu-content'\\u003E                        \\u003Cul class='yucs-hide yucs-leavable'\\u003E                            \\u003Cli id='yucs-top-omg'\\u003E\\u003Ca href=\\\"http://omg.yahoo.com/;_ylt=AmBNfEUzIyKApuhAO4VbNBqs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003Eomg!\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-shine'\\u003E\\u003Ca href=\\\"http://shine.yahoo.com/;_ylt=AsD1yAGvqhG5i5xE2fsK6X6s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003EShine\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-movies'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AqvOuNWYtVPRBD6imO2yDX2s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11cfum3sp/EXP=1374691500/**http%3A//movies.yahoo.com/\\\"\\u003EMovies\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-music'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AtyON1RWkfNlPTrIR8Va9_6s0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11b68lqt8/EXP=1374691500/**http%3A//music.yahoo.com/\\\"\\u003EMusic\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-tv'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=Av88W7XWMf2KvAJQXu689Pis0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=118s8ld11/EXP=1374691500/**http%3A//tv.yahoo.com/\\\"\\u003ETV\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-health'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AqnDPZPTPVroTQOk9UuOycys0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11csf8686/EXP=1374691500/**http%3A//health.yahoo.com/\\\"\\u003EHealth\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-shopping'\\u003E\\u003Ca href=\\\"http://shopping.yahoo.com/;_ylt=AjTeBeEBgbBSXzkmwyWCpWGs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003EShopping\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-travel'\\u003E\\u003Ca href=\\\"http://travel.yahoo.com/;_ylt=AoLbj2GAsssCNxqhc9fUXZCs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003ETravel\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-autos'\\u003E\\u003Ca href=\\\"http://autos.yahoo.com/;_ylt=Ap.N2q2QwgAA89zlVC3eCJas0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"\\u003EAutos\\u003C/a\\u003E\\u003C/li\\u003E                            \\u003Cli id='yucs-top-homes'\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=AqCYWPMQvPaewn0faHobqPSs0NUE;_ylu=X3oDMTBzdWkzZ2l1BHNlYwNVSCAzIERlc2t0b3AgVG9wIEJhciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11k3gutai/EXP=1374691500/**http%3A//homes.yahoo.com/own-rent/\\\"\\u003EHomes\\u003C/a\\u003E\\u003C/li\\u003E                        \\u003C/ul\\u003E                    \\u003C/div\\u003E                \\u003C/div\\u003E            \\u003C/li\\u003E        \\u003C/ul\\u003E    \\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv id=\\\"yucs\\\" class=\\\"yucs-mc \\\" data-lang=\\\"en-us\\\" data-property=\\\"news\\\" data-flight=\\\"1373481900\\\" data-linktarget=\\\"_top\\\" data-uhvc=\\\"/;_ylt=Aou1KOTccW2Xvs6yfp8aZ9Gs0NUE;_ylu=X3oDMTBsMTFvc2NjBHNlYwNVSCBWaWV3IENvdW50IDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003E        \\u003Cdiv class=\\\"yucs-fl-left\\\"\\u003E                \\u003Cdiv id=\\\"yucs-logo\\\"\\u003E    \\u003Cstyle\\u003E        #yucs #yucs-logo {width:123px ;}         #yucs #yucs-logo h2 {            width:123px;            height:36px ;            background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.png) ;            _background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.gif) ;        }        #yucs #yucs-logo a {          display:block ;          width:123px ;          height:36px;          overflow: hidden;        }        @media        only screen and (-webkit-min-device-pixel-ratio: 2),        only screen and ( min--moz-device-pixel-ratio: 2),        only screen and ( -o-min-device-pixel-ratio: 2/1),        only screen and ( min-device-pixel-ratio: 2),        only screen and ( min-resolution: 192dpi),        only screen and ( min-resolution: 2dppx) {            #yucs #yucs-logo h2 {                background-image: url(http://l.yimg.com/rz/uh/logos/news/news-20130429-x2.png) !important;                background-size: 275px 120px;            }        }    \\u003C/style\\u003E    \\u003Ch2\\u003E        \\u003Ca id=\\\"yucs-logo_link\\\" href=\\\"http://news.yahoo.com/;_ylt=AqGUl3usYh0O0en2byUnwGis0NUE;_ylu=X3oDMTE1NnJlMDc0BHNlYwNVSCAzIERlc2t0b3AgQnJhbmQgSWRlbnRpZmllciAxMDA-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"           target=\\\"_top\\\"\\u003E          Yahoo! News        \\u003C/a\\u003E    \\u003C/h2\\u003E\\u003C/div\\u003E    \\u003Cdiv id=\\\"yucs-search\\\"  style=\\\"width: 570px; display: block;\\\" class=' yucs-search-activate'\\u003E    \\u003Cform role=\\\"search\\\" class=\\\"yucs-search yucs-activate\\\" target=\\\"_top\\\"        data-webaction=\\\"http://search.yahoo.com/search;_ylt=AobQFkHzLG9P5mQntca.fRys0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"        action=\\\"http://news.search.yahoo.com/search;_ylt=AqBbfYzFUMQuPYI8MqDGYEus0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"        method=\\\"get\\\"\\u003E        \\u003Ctable role=\\\"presentation\\\"\\u003E            \\u003Ctbody role=\\\"presentation\\\"\\u003E                \\u003Ctr role=\\\"presentation\\\"\\u003E                    \\u003Ctd class=\\\"yucs-form-input\\\" role=\\\"presentation\\\"\\u003E                        \\u003Cinput autocomplete=\\\"off\\\" class=\\\"yucs-search-input\\\" name=\\\"p\\\" type=\\\"search\\\"                            aria-describedby=\\\"mnp-search_box\\\"                            data-yltvsearch=\\\"http://news.search.yahoo.com/search;_ylt=AqGqjTeU45OnCGP1hVYleoOs0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"                            data-yltvsearchsugg=\\\"/;_ylt=Ag764CG74XTxqd_fgZ_Qv8Ss0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"                            data-satype=\\\"mini\\\"                            data-gosurl=\\\"http://gossip-ss.us.search.yahoo.com/gossip-us_ss/\\\"                            data-pubid=\\\"104\\\"                            data-maxresults=\\\"10\\\"                            id=\\\"mnp-search_box\\\" /\\u003E                    \\u003C/td\\u003E\\u003Ctd NOWRAP class=\\\"yucs-form-btn\\\" role=\\\"presentation\\\"\\u003E\\u003Cdiv id=\\\"yucs-prop_search_button_wrapper\\\" class=\\\"yucs-search-buttons\\\"\\u003E\\u003Cdiv class=\\\"yucs-shadow\\\"\\u003E\\u003Cdiv class=\\\"yucs-gradient\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cbutton id=\\\"yucs-sprop_button\\\" class=\\\"yucs-action_btn yucs-button_theme yucs-vsearch-button\\\" type=\\\"submit\\\"                            data-vfr=\\\"us_news_header_gs_uh3_vert\\\"                            data-vsearch=\\\"http://news.search.yahoo.com/search\\\"\\u003ESearch News\\u003C/button\\u003E\\u003C/div\\u003E\\u003Cdiv id=\\\"yucs-web_search_button_wrapper\\\" class=\\\"yucs-search-buttons\\\"\\u003E\\u003Cdiv class=\\\"yucs-shadow\\\"\\u003E\\u003Cdiv class=\\\"yucs-gradient\\\"\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cbutton id=\\\"yucs-search_button\\\"                            class=\\\"yucs-action_btn yucs-wsearch-button\\\"                            type=\\\"submit\\\"\\u003ESearch Web\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E            \\u003C/tbody\\u003E    \\u003C/table\\u003E    \\u003Cinput type=\\\"hidden\\\" name=\\\"type\\\" value=\\\"2button\\\" /\\u003E    \\u003Cinput type=\\\"hidden\\\" id=\\\"fr\\\" name=\\\"fr\\\" value=\\\"us_news_header_gs_uh3_web\\\" /\\u003E            \\u003C/form\\u003E    \\u003Cdiv id=\\\"yucs-satray\\\" class=\\\"sa-tray sa-hidden\\\"        data-wstext=\\\"Search Web for: \\\"        data-wsearch=\\\"http://search.yahoo.com/search;_ylt=ApVkBZ8VaTh5GMFd6nOYztis0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"        data-vfr=\\\"us_news_header_gs_uh3_vert\\\"        data-vsearch=\\\"http://news.search.yahoo.com/search;_ylt=AlbX5q.fc_YIldDX8qbXaT6s0NUE;_ylu=X3oDMTBwNm1oMDIxBHNlYwNVSCAzIERlc2t0b3AgU2VhcmNoIDE-;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"        data-vstext= \\\"Search News for: \\\"        \\u003E    \\u003C/div\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"yucs-fl-right\\\"\\u003E  \\u003Cdiv id=\\\"yucs-profile\\\" class=\\\"yucs-profile yucs-signedout\\\"\\u003E    \\u003Ca id=\\\"yucs-menu_link_profile_signed_out\\\" href=\\\"http://jsbngssl.login.yahoo.com/config/login;_ylt=ArNq3WWRKUUtH_T9Yq3anAGs0NUE;_ylu=X3oDMTExZ2JhaGd1BHNlYwNVSCAzIERlc2t0b3AgUHJvZmlsZSBNZW51IDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3?.src=yn&.intl=us&.lang=en-US&.done=http://news.yahoo.com/\\\"  target=\\\"_top\\\" rel=\\\"nofollow\\\" class=\\\"sp yucs-fc\\\" aria-label=\\\"Profile\\\"\\u003E    \\u003C/a\\u003E    \\u003Cdiv id=\\\"yucs-profile_text\\\" class=\\\"yucs-fc\\\"\\u003E        \\u003Ca id=\\\"yucs-login_signIn\\\" href=\\\"http://jsbngssl.login.yahoo.com/config/login;_ylt=AqHL5vnBQLQ8xgJ2YSsICTas0NUE;_ylu=X3oDMTExZ2JhaGd1BHNlYwNVSCAzIERlc2t0b3AgUHJvZmlsZSBNZW51IDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3?.src=yn&.intl=us&.lang=en-US&.done=http://news.yahoo.com/\\\"  target=\\\"_top\\\" rel=\\\"nofollow\\\" class=\\\"yucs-fc\\\"\\u003E            Sign In        \\u003C/a\\u003E    \\u003C/div\\u003E\\u003C/div\\u003E  \\u003Cdiv class=\\\"yucs-mail_link yucs-mailpreview-ancestor\\\"\\u003E\\u003Ca id=\\\"yucs-mail_link_id\\\" class=\\\"sp yltasis yucs-fc\\\" href=\\\"http://mail.yahoo.com/;_ylt=At269QXX6gQulipYmO0DbZGs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3?.intl=us&.lang=en-US\\\" rel=\\\"nofollow\\\" target=\\\"_top\\\"\\u003E    Mail    \\u003C/a\\u003E\\u003Cdiv class=\\\"yucs-mail-preview-panel yucs-menu yucs-hide\\\" data-mail-txt=\\\"Mail\\\"    data-uri-scheme=\\\"http\\\"     data-uri-path=\\\"ucs.query.yahoo.com/v1/console/yql\\\"     data-mail-view=\\\"Go to Mail\\\"    data-mail-help-txt=\\\"Help\\\"    data-mail-help-url=\\\"http://help.yahoo.com/l/us/yahoo/mail/ymail/\\\"    data-mail-loading-txt=\\\"Loading...\\\"    data-languagetag=\\\"en-us\\\"    data-authstate=\\\"signedout\\\"    data-middleauth-signin-text=\\\"Click here to view your mail\\\"    data-popup-login-url=\\\"http://jsbngssl.login.yahoo.com/config/login_verify2?.pd=c%3DOIVaOGq62e5hAP8Tv..nr5E3&.src=sc\\\"    data-middleauthtext=\\\"You have {count} new mail.\\\"    data-yltmessage-link=\\\"http://us.lrd.yahoo.com/_ylt=AoU61kxmY1S0WOAz_ZKoOx6s0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=12fkh3rt0/EXP=1374691500/**http%3A//mrd.mail.yahoo.com/msg%3Fmid=%7BmsgID%7D%26fid=Inbox\\\"    data-yltviewall-link=\\\"http://mail.yahoo.com/;_ylt=AgzlljPJHXH6EZw8FSI75vys0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-yltpanelshown=\\\"/;_ylt=AhiHHaOhVzCKCnhDAL9pupGs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-ylterror=\\\"/;_ylt=Al78DpCETIoZcKghkg62UwCs0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-ylttimeout=\\\"/;_ylt=Ap1Hd1VL7wvvB_15kbz_Q12s0NUE;_ylu=X3oDMTB1cWVlMWZyBHNlYwNVSCAzIERlc2t0b3AgTWFpbCBJY29uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"    data-generic-error=\\\"We're unable to preview your mail.\\u003Cbr\\u003EGo to Mail.\\\"    data-nosubject=\\\"[No Subject]\\\"    data-timestamp='short'\\u003E\\u003C/div\\u003E\\u003C/div\\u003E    \\u003C!-- notification --\\u003E    \\u003Cdiv id=\\\"yucs-help\\\" class=\\\"yucs-activate yucs-help yucs-menu_nav\\\"\\u003E    \\u003Ca id=\\\"yucs-help_button\\\" class=\\\"sp yltasis\\\"         href=\\\"javascript:void(0);\\\"        aria-label=\\\"Help\\\" rel=\\\"nofollow\\\"\\u003E        \\u003Cem class=\\\"yucs-hide yucs-menu_anchor\\\"\\u003EHelp\\u003C/em\\u003E    \\u003C/a\\u003E    \\u003Cdiv id=\\\"yucs-help_inner\\\" class=\\\"yucs-hide yucs-menu yucs-hm-activate\\\"          data-yltmenushown=\\\"/;_ylt=AkeyaOMCYsz.slrjUKyhnKWs0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=3\\\"\\u003E        \\u003Cspan class=\\\"sp yucs-dock\\\"\\u003E\\u003C/span\\u003E        \\u003Cul id=\\\"yuhead-help-panel\\\"\\u003E            \\u003Cli\\u003E\\u003Ca class=\\\"yucs-acct-link\\\" href=\\\"http://jsbngssl.us.lrd.yahoo.com/_ylt=Aiju2HuEEfH1dMj9WGkwrs6s0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=156odsf7u/EXP=1374691500/**https%3A//edit.yahoo.com/mc2.0/eval_profile%3F.intl=us%26.lang=en-US%26.done=http%3A//news.yahoo.com/%26amp;.src=yn%26amp;.intl=us%26amp;.lang=en-US\\\" target=\\\"_top\\\"\\u003EAccount Info\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cli\\u003E\\u003Ca href=\\\"http://help.yahoo.com/l/us/yahoo/news_global/;_ylt=AvYLzdHXvewZxy7hBKN7Gxys0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--\\\"                 rel=\\\"nofollow\\\" \\u003EHelp\\u003C/a\\u003E\\u003C/li\\u003E            \\u003Cspan class=\\\"yucs-separator\\\" role=\\\"presentation\\\" style=\\\"display: block;\\\"\\u003E\\u003C/span\\u003E            \\u003Cli\\u003E\\u003Ca href=\\\"http://us.lrd.yahoo.com/_ylt=ArAlHUONGaO6xbhBpeHq1Dys0NUE;_ylu=X3oDMTB0b2V0ZGxzBHNlYwNVSCAzIERlc2t0b3AgQ29nIE1lbnUgMTAw;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=11r6ui5uj/EXP=1374691500/**http%3A//feedback.yahoo.com/forums/204992\\\"                  rel=\\\"nofollow\\\" \\u003ESuggestions\\u003C/a\\u003E\\u003C/li\\u003E        \\u003C/ul\\u003E    \\u003C/div\\u003E\\u003C/div\\u003E    \\u003Cdiv id=\\\"yucs-network_link\\\"\\u003E\\u003Ca id=\\\"yucs-home_link\\\" href=\\\"http://us.lrd.yahoo.com/_ylt=ArryylJaIBGrJf4NlAZE1.qs0NUE;_ylu=X3oDMTE3ZGQ1N2JkBHNlYwNVSCAzIERlc2t0b3AgTmV0d29yayBOYXZpZ2F0aW9uIDEwMA--;_ylg=X3oDMTBsdWsyY2FpBGxhbmcDZW4tVVMEcHQDMgR0ZXN0Aw--;_ylv=0/SIG=119gkb0u3/EXP=1374691500/**http%3A//www.yahoo.com/\\\" rel=\\\"nofollow\\\" target=\\\"_top\\\"\\u003EYahoo!\\u003C/a\\u003E\\u003C/div\\u003E        \\u003C!-- empty breaking news component --\\u003E     \\u003C/div\\u003E          \\u003C/div\\u003E \\u003C!-- contextual_shortcuts --\\u003E\\u003C!-- /contextual_shortcuts --\\u003E\\u003C!-- property: news | languagetag: en-us | status: active | spaceid: 81121452 | cobrand: standard | markup: empty --\\u003E\\u003Cdiv id=\\\"yUnivHead\\\" class=\\\"yucs-hide\\\"\\u003E\\u003C!-- empty --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n\\u003Cscript\\u003EYMedia.use(\\\"event\\\", \\\"get\\\", function(Y){ Y.once(\\\"load\\\", function(){ Y.Get.js(\\\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/js/1/uh-min.js&kx/yucs/uh3/uh/js/102/gallery-jsonp-min.js&kx/yucs/uh3/uh/js/565/menu_utils_v3-min.js&kx/yucs/uh3/uh/js/549/timestamp_library-min.js&kx/yucs/uh3/uh3_top_bar/js/148/top_bar_v3-min.js&kx/yucs/uh3/search/js/361/search-min.js&kx/ucs/common/js/131/jsonp-super-cached-min.js&kx/yucs/uh3/avatar/js/9/avatar-min.js&kx/yucs/uh3/mail_link/js/60/mailcount-min.js&kx/yucs/uh3/help/js/46/help_menu_v3-min.js\\\"); }); });\\u003C/script\\u003E\\u003C/section\\u003E\\u003C!-- fe577.global.media.gq1.yahoo.com compressed Wed Jul 10 18:45:00 UTC 2013 --\\u003E\\n\\n                \\n            \\u003C/header\\u003E\\n            \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t2\\\");\\u003C/script\\u003E\\n            \\u003Cdiv id=\\\"yog-bd\\\" class=\\\"yog-bd\\\" role=\\\"main\\\" data-type=\\\"homepage\\\" data-spaceid=\\\"81121452\\\"\\u003E\\n                \\u003C!-- Content --\\u003E\\n                \\n\\u003C!-- START full --\\u003E\\n\\n\\u003C!-- START N_C_R --\\u003E\\n\\u003Cdiv class=\\\"yog-wrap\\\"\\u003E\\n    \\u003Cdiv id=\\\"yog-sp\\\" class=\\\"yog-row yog-sp\\\"\\u003E\\n        \\u003Cdiv id=\\\"yog-sw\\\" class=\\\"yog-sw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-stage\\\" class=\\\"yog-stage\\\"\\u003E\\n                \\u003C!-- --\\u003E\\u003Cdiv id=\\\"yom-ad-MAST\\\" class=\\\"yom-ad yom-ad-MAST\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-MAST-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-MAST\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-MAST-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=MAST noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n    \\u003Cdiv id=\\\"yog-np\\\" class=\\\"yog-col yog-np\\\"\\u003E\\n        \\u003Cdiv id=\\\"yog-nw\\\" class=\\\"yog-nw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-nav\\\" class=\\\"yog-nav\\\"\\u003E\\n                \\u003C!-- --\\u003E\\u003Cdiv id=\\\"mediacontentnavigation\\\" class=\\\"yom-mod navigation\\\" role=\\\"navigation\\\" data-ylk=\\\"mid:mediacontentnavigation;mpos:1;\\\"\\u003E\\n    \\u003Cnav\\u003E\\n        \\u003Cul class=\\\"navlist\\\"\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/\\\" class=\\\"selected\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:home;sec:lnav-s;slk:link;cpos:1;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHome\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/us/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:us;sec:lnav-s;slk:link;cpos:2;\\\" data-action-outcome=\\\"navigate\\\"\\u003EU.S.\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/world/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:world;sec:lnav-s;slk:link;cpos:3;\\\" data-action-outcome=\\\"navigate\\\"\\u003EWorld\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/politics/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:politics;sec:lnav-s;slk:link;cpos:4;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/tech/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:tech;sec:lnav-s;slk:link;cpos:5;\\\" data-action-outcome=\\\"navigate\\\"\\u003ETech\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/science/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:science;sec:lnav-s;slk:link;cpos:6;\\\" data-action-outcome=\\\"navigate\\\"\\u003EScience\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/health/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:health;sec:lnav-s;slk:link;cpos:7;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHealth\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/odd-news/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:oddnews;sec:lnav-s;slk:link;cpos:8;\\\" data-action-outcome=\\\"navigate\\\"\\u003EOdd News\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/opinion/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:opinion;sec:lnav-s;slk:link;cpos:9;\\\" data-action-outcome=\\\"navigate\\\"\\u003EOpinion\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/local/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:local;sec:lnav-s;slk:link;cpos:10;\\\" data-action-outcome=\\\"navigate\\\"\\u003ELocal\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/dear-abby/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:dearabby;sec:lnav-s;slk:link;cpos:11;\\\" data-action-outcome=\\\"navigate\\\"\\u003EDear Abby\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/comics/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:comics;sec:lnav-s;slk:link;cpos:12;\\\" data-action-outcome=\\\"navigate\\\"\\u003EComics\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/abc-news/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:abcnews;sec:lnav-s;slk:link;cpos:13;\\\" data-action-outcome=\\\"navigate\\\"\\u003EABC News\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n                \\u003Cli\\u003E\\n                    \\u003Ca href=\\\"/originals/\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:;ltxt:ynewsori;sec:lnav-s;slk:link;cpos:14;\\\" data-action-outcome=\\\"navigate\\\"\\u003EY! News Originals\\u003C/a\\u003E\\n                \\u003C/li\\u003E\\n        \\u003C/ul\\u003E\\n        \\u003Cscript id=\\\"nav-addon-template\\\" type=\\\"text/template\\\"\\u003E\\n            \\u003Cdiv class=\\\"nav-wrap pos-{{position}} {{classname}}\\\" data-position=\\\"{{position}}\\\"\\u003E\\n                \\u003Ch3\\u003E{{header}}\\u003C/h3\\u003E\\n                \\u003Cul class=\\\"navlist\\\"\\u003E\\n                    {{#entries}}\\n                        \\u003Cli\\u003E\\n                            \\u003Ca href=\\\"{{link}}\\\" {{#title_attrib}}title=\\\"{{title_attrib}}\\\"{{/title_attrib}}{{#class}}class=\\\"{{class}}\\\"{{/class}} {{{tracking}}} data-action-outcome=\\\"navigate\\\" data-item-id=\\\"{{id}}\\\"\\u003E{{{text}}}\\u003C/a\\u003E\\n                        \\u003C/li\\u003E\\n                    {{/entries}}\\n                    {{#show_more}}\\n                        \\u003Cdiv class=\\\"subnav\\\"\\u003E\\n                            \\u003Cli\\u003E\\u003Ca href=\\\"#\\\" class=\\\"more\\\"\\u003EMore \\u003Cstrong\\u003E&rsaquo;\\u003C/strong\\u003E\\u003C/a\\u003E\\n                                \\u003Cdiv class=\\\"subnav-more\\\"\\u003E\\n                                    \\u003Ci class=\\\"arrow\\\"\\u003E\\u003C/i\\u003E\\n                                \\u003Cul\\u003E\\n                                {{#more_entries}}\\n                                \\u003Cli\\u003E\\n                                     \\u003Ca href=\\\"{{link}}\\\" {{#title_attrib}}title=\\\"{{title_attrib}}\\\"{{/title_attrib}}{{#class}}class=\\\"{{class}}\\\"{{/class}} {{{tracking}}} data-action-outcome=\\\"navigate\\\" data-item-id=\\\"{{id}}\\\"\\u003E{{{text}}}\\u003C/a\\u003E\\n                                \\u003C/li\\u003E\\n                                 {{/more_entries}}\\n                                 \\u003C/ul\\u003E\\n                                 \\u003C/div\\u003E\\n                            \\u003C/li\\u003E\\n                        \\u003C/div\\u003E\\n                    {{/show_more}}\\n                \\u003C/ul\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/script\\u003E\\n    \\u003C/nav\\u003E\\n\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n    \\u003Cdiv id=\\\"yog-cp\\\" class=\\\"yog-col yog-cp\\\"\\u003E\\n        \\u003Cdiv id=\\\"yog-cw\\\" class=\\\"yog-cw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-content\\\" class=\\\"yog-content yog-card\\\"\\u003E\\n                \\u003C!-- --\\u003E\\n\\n \\u003Csection class=\\\"yom-mod yom-lead clearfix\\\" id=\\\"mediacontentlead\\\" data-ylk=\\\"mid:mediacontentlead;mpos:1;sec:mod-ld;\\\"\\u003E \\u003C!--[if gte IE 9]\\u003E \\u003Cstyle type=\\\"text/css\\\"\\u003E .gradient { filter: none; } \\u003C/style\\u003E \\u003C![endif]--\\u003E  \\u003Cdiv class=\\\"lead-left\\\" data-img=\\\"http://l2.yimg.com/bt/api/res/1.2/F_zWVTc7lGRGKSyVjNIR5Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTM2MDtweW9mZj0yNTtxPTg1O3c9NDgw/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg\\\" data-uuid=\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\" data-type=\\\"story\\\" data-url=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\" data-title=\\\"Judge rules against Zimmerman on evidence\\\"\\u003E \\u003Cdiv class=\\\"yom-lead-featured-item\\\"\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:;\\\" class=\\\"yom-lead-featured-image\\\" href=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\" style=\\\"background-image:url(http://l2.yimg.com/bt/api/res/1.2/F_zWVTc7lGRGKSyVjNIR5Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTM2MDtweW9mZj0yNTtxPTg1O3c9NDgw/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg)\\\" data-uuid=\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\"\\u003E \\u003Cspan class=\\\"lead-overlay-icon-small lead-asset-article\\\"\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"yom-lead-featured-overlay gradient\\\"\\u003E \\u003Cdiv class=\\\"lead-summary \\\"\\u003E  \\u003Ch3 class=\\\"yom-lead-featured-title\\\"\\u003E\\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:;\\\" class=\\\"yom-featured-title-link\\\" href=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\" data-uuid=\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\"\\u003EJudge rules against Zimmerman on evidence\\u003C/a\\u003E\\u003C/h3\\u003E  \\u003Cdiv class=\\\"yom-lead-summary-text\\\"\\u003E \\u003Cspan class=\\\"yom-lead-featured-blurb\\\"\\u003ESANFORD, Fla. (AP) — A Florida judge ruled Wednesday that Trayvon Martin's cellphone text messages&nbsp;&hellip;\\u003C/span\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:1;pkgt:1;pos:1;g:8a1c7605-0ff6-3150-9990-76dae34185d8;prov:Associated Press;test:;\\\" class=\\\"yom-lead-more\\\" href=\\\"http://news.yahoo.com/judge-rules-against-zimmerman-evidence-132354666.html\\\"\\u003E\\u003Cspan class=\\\"lead-overlay-icon-xsmall lead-asset-article\\\"\\u003E\\u003C/span\\u003ERead More &raquo;\\u003C/a\\u003E \\u003C/div\\u003E  \\u003Cdiv class=\\\"lead-related-group\\\"\\u003E  \\u003C/div\\u003E   \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E  \\u003Cdiv class=\\\"lead-right top\\\" data-img=\\\"http://l.yimg.com/bt/api/res/1.2/tSLQaTybdbnYf.h_nYrDIw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/809bc9a8114b3017370f6a7067002d5c.jpg\\\" data-uuid=\\\"578e6c22-0186-30ad-82bc-d1ce5f90105b\\\" data-type=\\\"story\\\" data-url=\\\"http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html\\\" data-title=\\\"Bombing suspect heads to 1st public court hearing\\\"\\u003E \\u003Cdiv class=\\\"yom-lead-featured-item\\\"\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:;\\\" class=\\\"yom-lead-featured-image\\\" href=\\\"http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html\\\" style=\\\"background-image:url(http://l.yimg.com/bt/api/res/1.2/tSLQaTybdbnYf.h_nYrDIw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/809bc9a8114b3017370f6a7067002d5c.jpg)\\\" data-uuid=\\\"578e6c22-0186-30ad-82bc-d1ce5f90105b\\\"\\u003E \\u003Cspan class=\\\"lead-overlay-icon-small lead-asset-article\\\"\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"yom-lead-featured-overlay gradient\\\"\\u003E \\u003Cdiv class=\\\"lead-summary \\\"\\u003E  \\u003Ch3 class=\\\"yom-lead-featured-title\\\"\\u003E\\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:2;pkgt:1;pos:1;g:578e6c22-0186-30ad-82bc-d1ce5f90105b;prov:Associated Press;test:;\\\" class=\\\"yom-featured-title-link\\\" href=\\\"http://news.yahoo.com/bombing-suspect-heads-1st-public-court-hearing-104650701.html\\\" data-uuid=\\\"578e6c22-0186-30ad-82bc-d1ce5f90105b\\\"\\u003EBombing suspect heads to 1st public court hearing\\u003C/a\\u003E\\u003C/h3\\u003E  \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E  \\u003Cdiv class=\\\"lead-right bottom\\\" data-img=\\\"http://l2.yimg.com/bt/api/res/1.2/AWwr0E007DW9IjSVxe3qBQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/dd090b10f3111b16370f6a706700e344.jpg\\\" data-uuid=\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\" data-type=\\\"story\\\" data-url=\\\"http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html\\\" data-title=\\\"SF probe brings questions over auto speed controls\\\"\\u003E \\u003Cdiv class=\\\"yom-lead-featured-item\\\"\\u003E \\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:;\\\" class=\\\"yom-lead-featured-image\\\" href=\\\"http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html\\\" style=\\\"background-image:url(http://l2.yimg.com/bt/api/res/1.2/AWwr0E007DW9IjSVxe3qBQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE5MDtweW9mZj0yNTtxPTg1O3c9MzE2Ljg-/http://media.zenfs.com/en_us/News/ap_webfeeds/dd090b10f3111b16370f6a706700e344.jpg)\\\" data-uuid=\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\"\\u003E \\u003Cspan class=\\\"lead-overlay-icon-small lead-asset-article\\\"\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"yom-lead-featured-overlay gradient\\\"\\u003E \\u003Cdiv class=\\\"lead-summary \\\"\\u003E  \\u003Ch3 class=\\\"yom-lead-featured-title\\\"\\u003E\\u003Ca data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:mod-ld;slk:link;cpos:3;pkgt:1;pos:1;g:43e80a47-79ec-3809-ac98-1518389138c7;prov:Associated Press;test:;\\\" class=\\\"yom-featured-title-link\\\" href=\\\"http://news.yahoo.com/sf-probe-brings-questions-over-auto-speed-controls-084646467.html\\\" data-uuid=\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\"\\u003ESF probe brings questions over auto speed controls\\u003C/a\\u003E\\u003C/h3\\u003E  \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E  \\u003C/section\\u003E\\n\\u003Cdiv class=\\\"yom-remote\\\"\\u003E\\u003Cdiv class=\\\"yom-loading\\\" id=\\\"p_30345786_container\\\"\\u003E\\u003C!-- --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n    \\u003Cdiv id=\\\"yog-rp\\\" class=\\\"yog-col yog-rp\\\"\\u003E\\n         \\u003Cdiv id=\\\"yog-rw\\\" class=\\\"yog-rw\\\"\\u003E\\n            \\u003Cdiv id=\\\"yog-related\\\" class=\\\"yog-related\\\"\\u003E\\n                \\u003C!-- --\\u003E\\u003Cdiv id=\\\"yom-ad-LREC\\\" class=\\\"yom-ad yom-ad-LREC\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-LREC-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-LREC\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-LREC-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=LREC noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n\\u003Cdiv class=\\\"yom-remote\\\"\\u003E\\u003Cdiv class=\\\"yom-loading\\\" id=\\\"mediacontentweather_container\\\"\\u003E\\u003C!-- --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n \\u003Csection class=\\\"yom-mod yom-comic yom-app clearfix\\\" id=\\\"mediacontentcomic\\\" data-ylk=\\\"mid:mediacontentcomic;mpos:3;sec:app-com;\\\"\\u003E \\u003Cdiv class=\\\"hd\\\"\\u003E \\u003Cdiv class=\\\"top-nav\\\"\\u003E \\u003Ch3 class=\\\"title\\\"\\u003EComics\\u003C/h3\\u003E \\u003Cdiv class=\\\"dropdown\\\"\\u003E \\u003Cselect class=\\\"comic-select\\\"\\u003E  \\u003Coption value=\\\"702ab4a0-145a-3b69-9a83-aed16a8a024a\\\"\\u003EGarfield\\u003C/option\\u003E  \\u003Coption value=\\\"47c04e74-8cd0-3574-8191-0ee3dfbf5745\\\"\\u003EPearls Before Swine\\u003C/option\\u003E  \\u003Coption value=\\\"d427f3cd-b845-3305-a401-87d41f754230\\\"\\u003EDilbert\\u003C/option\\u003E  \\u003Coption value=\\\"0d4e9718-aab2-366c-84a9-719aeb1161ae\\\"\\u003EPeanuts\\u003C/option\\u003E  \\u003Coption value=\\\"92df5b73-9c06-3216-9539-45edc1a84bfa\\\"\\u003EAndy Capp\\u003C/option\\u003E  \\u003Coption value=\\\"e6f925cc-09d1-3de6-a6a9-1b508dabcec5\\\"\\u003EB.C.\\u003C/option\\u003E  \\u003Coption value=\\\"d2fd1039-306e-3a5b-a65e-ffc43d494d83\\\"\\u003E9 Chickweed Lane\\u003C/option\\u003E  \\u003Coption value=\\\"9b9275a0-146b-3b57-ad6b-fc1f634bebd5\\\"\\u003EDoonesbury\\u003C/option\\u003E  \\u003Coption value=\\\"97cb2d44-fca7-35b9-8ce0-2271e5140061\\\"\\u003EWizard of Id\\u003C/option\\u003E  \\u003Coption value=\\\"04db50ed-cd87-36b1-a3cf-a9c12e762d5f\\\"\\u003ELuann\\u003C/option\\u003E  \\u003C/select\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"bd yui3-skin-sam\\\"\\u003E \\u003Cdiv id=\\\"comic_main\\\"\\u003E \\u003Cdiv class=\\\"sub-nav\\\"\\u003E \\u003Cbutton class=\\\"nav-bt prev\\\"\\u003E \\u003Cspan class=\\\"icon-black-prev-xsmall\\\"\\u003E\\u003C/span\\u003E \\u003Cimg class=\\\"icon-ie-fix\\\" src=\\\"http://l.yimg.com/os/mit/media/themes/v2_base/images/icons/png/icon_black_prev_xsmall-1269670.png\\\"\\u003E\\u003C/img\\u003E \\u003C/button\\u003E \\u003Cbutton class=\\\"nav-bt next inactive\\\"\\u003E \\u003Cspan class=\\\"icon-black-next-xsmall\\\"\\u003E\\u003C/span\\u003E \\u003Cimg class=\\\"icon-ie-fix\\\" src=\\\"http://l.yimg.com/os/mit/media/themes/v2_base/images/icons/png/icon_black_next_xsmall-1269670.png\\\"\\u003E\\u003C/img\\u003E \\u003C/button\\u003E \\u003Cdiv class=\\\"more-comic\\\"\\u003E\\u003Ca class=\\\"more-comic-main\\\" href=\\\"/comics/\\\"\\u003E\\u003Cspan class=\\\"more\\\"\\u003EMore\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"slideshow\\\"\\u003E \\u003Cp class=\\\"date\\\"\\u003EWed, Jul 10\\u003C/p\\u003E \\u003Ca id='comic_img_holder'\\u003E\\u003Cimg class=\\\"comic-image\\\" src =\\\"http://l.yimg.com/bt/api/res/1.2/LevQzAit8GjQB95PNqJEaw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130710.gif\\\"\\u003E\\u003C/a\\u003E \\u003C/div\\u003E \\u003Cimg class=\\\"pre-load-comic hide\\\"/\\u003E \\u003C/div\\u003E \\u003Cdiv id=\\\"comic_overlay\\\" class=\\\"hide\\\"\\u003E \\u003Cbutton class=\\\"nav-bt prev\\\"\\u003E\\u003C/button\\u003E \\u003Cdiv class=\\\"slideshow\\\"\\u003E \\u003Cp class=\\\"hd\\\"\\u003E \\u003C!--TODO inject title by js --\\u003E \\u003Cspan class=\\\"title\\\"\\u003EGarfield\\u003C/span\\u003E \\u003Cspan class=\\\"date\\\"\\u003EWednesday, July 10\\u003C/span\\u003E \\u003Ca class=\\\"more-comic-overlay\\\" href=\\\"/comics/\\\"\\u003E\\u003Cspan class=\\\"more\\\"\\u003EMore\\u003C/span\\u003E\\u003C/a\\u003E \\u003Cbutton class=\\\"close\\\"\\u003E\\u003C/button\\u003E \\u003C/p\\u003E \\u003Cimg class=\\\"comic-image\\\"\\u003E \\u003C/div\\u003E \\u003Cbutton class=\\\"nav-bt next inactive\\\"\\u003E\\u003C/button\\u003E \\u003Cimg class=\\\"pre-load-comic hide\\\"/\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\n            \\u003Cstyle type=\\\"text/css\\\"\\u003E#dmRosAdWrapper-east iframe{width:100%} #yog-cw .dmros_ad {border-color: #E0E0E0; border-style: solid; border-width: 0 0 1px;}\\u003C/style\\u003E\\n            \\u003Cdiv id=\\\"dmRosAdWrapper-east\\\" class=\\\"dmros_ad yom-app\\\"\\u003E\\n                \\u003Cnoscript\\u003E\\n                    \\u003Cdiv id=\\\"dmRosAd-1-east\\\" width=\\\"300\\\" height=\\\"300\\\" frameborder=\\\"0\\\" marginheight=\\\"0\\\" marginwidth=\\\"0\\\" scrolling=\\\"no\\\" src=\\\"http://dmros.ysm.yahoo.com/ros/?c=e5879714&w=300&h=300&ty=noscript&tt=Yahoo%21+News+-+Latest+News+%26amp%3B+Headlines&r=\\\"\\u003E\\u003C/div\\u003E\\n                \\u003C/noscript\\u003E\\n            \\u003C/div\\u003E\\n \\u003Csection class=\\\"yom-mod \\\" id=\\\"mediacontentgenericlistings\\\" data-ylk=\\\"mid:mediacontentgenericlistings;mpos:2;\\\"\\u003E \\u003Cdiv class=\\\"yom-generic-listings-module yom-app\\\" id=\\\"mediacontentgenericlistings\\\"\\u003E \\u003Cdiv class=\\\"hd\\\"\\u003E \\u003Ch1\\u003ELatest Videos\\u003C/h1\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"bd\\\"\\u003E \\u003Cdiv class=\\\"latest-content-inline\\\"\\u003E \\u003Cul\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/david-tillmans-midday-weather-forecast-174557836.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/veN8qLz8lKvAVAumLAlo0g--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.krtk.abc.news.com/071d287ffca0c9b91d8d54936799af58\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/david-tillmans-midday-weather-forecast-174557836.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:DavidTil;cpos:1;test:;g:d99db792-ac02-3755-89d1-c481368027b5;\\\"\\u003EDavid Tillman's midday weather forecast\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:50\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/CwfQcCkClv52oyjQ7g7scg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.kgo.abc.news.com/20a2be41046b838e6399259f73c9f47d\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Printeri;cpos:2;test:;g:c621133c-f907-3f42-93ff-20ef01effa97;\\\"\\u003EPrinter ink efficiency tested by Consumer Reports\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:33\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/rare-film-shows-fdr-pushed-174224035.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/ItGx6oCodQwaOTyUM6GFKA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.abcnewsplus.com/89475392ef9ada92079c7c09ae98e51c\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/rare-film-shows-fdr-pushed-174224035.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:RareFilm;cpos:3;test:;g:331b7a46-49c4-3836-a09b-e384123ad646;\\\"\\u003ERare Film Shows FDR Pushed in Wheelchair\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E00:34\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/lunch-break-07-10-13-172614033.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;\\\"\\u003E \\u003Cimg src=\\\"http://l3.yimg.com/bt/api/res/1.2/LkkjfAYKWSekT6nQFdS.KQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/c03c4c7494c4c8714e06c1c7df916bf3\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/lunch-break-07-10-13-172614033.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:LunchBre;cpos:4;test:;g:67587838-99cc-37a2-b1b2-3dcb29642ad9;\\\"\\u003ELunch Break 07-10-13\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E03:12\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/wishbone-bombay-spice-grill-among-172554941.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/HWac8J1.q6.22cUflOnyzQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/0df3426dec4bd34f6caf8891f8b503f4\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/wishbone-bombay-spice-grill-among-172554941.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Wishbone;cpos:5;test:;g:673e2bc5-5e04-3db5-b7ee-847fb557c4b5;\\\"\\u003EWishbone, Bombay Spice & Grill, among newcomers at&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E03:26\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/whitey-bulger-ex-partner-trade-171312946.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/QpmK2meJSQYDMJay5HtPOA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.fbc.news.com/bcb728d0f33817491fd4df7bf72bbe17\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/whitey-bulger-ex-partner-trade-171312946.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:WhiteyBu;cpos:6;test:;g:8c9b8433-216b-3de6-902e-875865d62d79;\\\"\\u003EWhitey Bulger, ex-partner trade curses in courtroo&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E04:57\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/taste-chicago-2013-opens-165744456.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;\\\"\\u003E \\u003Cimg src=\\\"http://l3.yimg.com/bt/api/res/1.2/QTz_4cBuB9J64_imAFveDw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/7a447cc09cf3fad88945422ce5004b74\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/taste-chicago-2013-opens-165744456.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:TasteofC;cpos:7;test:;g:523fedde-cc12-38fb-86ca-60629888845c;\\\"\\u003ETaste of Chicago 2013 opens\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:37\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/officials-defend-paulsboro-train-derailment-163843236.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/ufVoV8B0.7gXA6JYfCi21g--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wpvi.abc.news.com/5e4045e37715007a85f25d8519373f5d\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/officials-defend-paulsboro-train-derailment-163843236.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Official;cpos:8;test:;g:51aceae4-c48c-3955-bc3d-deabf73b0d4c;\\\"\\u003EOfficials defend Paulsboro train derailment respon&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E00:32\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/humboldt-park-sex-assault-near-112404068.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;\\\"\\u003E \\u003Cimg src=\\\"http://l1.yimg.com/bt/api/res/1.2/Kk3MDF03zGjNCkXlW4fjYw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.wls.abc.news.com/64d1c12ccfd7675a309c02587c14b3dd\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/humboldt-park-sex-assault-near-112404068.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Policese;cpos:9;test:;g:77d99ad3-23b2-31a4-9d15-beda9147cf9e;\\\"\\u003EPolice searching for bus stop attacker in Humboldt&nbsp;&hellip;\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:16\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003Cli\\u003E  \\u003Ca class=\\\"thumb-link\\\" href=\\\"/video/teen-being-questioned-mothers-murder-112642183.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;\\\"\\u003E \\u003Cimg src=\\\"http://l2.yimg.com/bt/api/res/1.2/W9.dxej3b2EFxrhoMNiOkg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTg0O3B5b2ZmPTA7cT04NTt3PTE0OQ--/http://media.zenfs.com/en-US/video/video.krtk.abc.news.com/dd80edf723819cd2c3f73555a9a8fea1\\\" width=\\\"149\\\" height=\\\"84\\\"/\\u003E \\u003Cspan class=\\\"overlay_asset_video overlay-icon\\\"\\u003E\\u003Ci\\u003E\\u003C/i\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003Cdiv class=\\\"listing-title\\\"\\u003E \\u003Ca href=\\\"/video/teen-being-questioned-mothers-murder-112642183.html\\\" data-ylk=\\\"itc:0;tar:news.yahoo.com;ct:1;sec:app-vid-lat;slk:title;ltxt:Teenchar;cpos:10;test:;g:442d0366-9815-3b70-aad9-fdc81b8f7177;\\\"\\u003ETeen charged in mother's murder\\u003C/a\\u003E  \\u003Cdiv class=\\\"content-length\\\"\\u003E02:55\\u003C/div\\u003E  \\u003C/div\\u003E   \\u003C/li\\u003E  \\u003C/ul\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\n\\u003Cdiv id=\\\"yom-ad-LREC2\\\" class=\\\"yom-ad yom-ad-LREC2\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-LREC2-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-LREC2\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-LREC2-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=LREC2 noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n\\u003Cdiv class=\\\"yom-remote\\\"\\u003E\\u003Cdiv class=\\\"yom-loading\\\" id=\\\"mediacontentfollowproperty_container\\\"\\u003E\\u003C!-- --\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\n\\u003Cdiv id=\\\"mediafooterinfo\\\" class=\\\"yom-mod yom-footer-info\\\" role=\\\"contentinfo\\\"\\u003E\\n    \\u003Cdiv class=\\\"bd\\\"\\u003E\\n        \\u003Cdiv class=\\\"copyright-providers\\\"\\u003E\\n            \\u003Ccite\\u003E\\u003C/cite\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv class=\\\"disclaimer\\\"\\u003E\\n            \\u003Ccite\\u003E\\u003C/cite\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv class=\\\"copyright\\\"\\u003E\\n            \\u003Ccite\\u003E\\n                Copyright © 2013 Yahoo! Inc. All rights reserved.\\n            \\u003C/cite\\u003E\\n            \\u003Cspan\\u003E\\n                 | Yahoo! - ABC News Network | \\n            \\u003C/span\\u003E\\n            \\u003Cul\\u003E\\n                \\u003Cli class=\\\"first\\\"\\u003E\\u003Ca href=\\\"http://help.yahoo.com/l/us/yahoo/news_global/\\\"\\u003EHelp\\u003C/a\\u003E / \\u003Ca href=\\\"http://feedback.yahoo.com/forums/204992\\\"\\u003ESuggestions\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli\\u003E\\u003Ca href=\\\"http://info.yahoo.com/privacy/us/yahoo/news/\\\"\\u003EPrivacy Policy\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli\\u003E\\u003Ca href=\\\"http://info.yahoo.com/relevantads/\\\"\\u003EAbout Our Ads\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli\\u003E\\u003Ca href=\\\"http://info.yahoo.com/legal/us/yahoo/utos/utos-173.html\\\"\\u003ETerms of Service\\u003C/a\\u003E\\u003C/li\\u003E\\n                \\u003Cli class=\\\"last\\\"\\u003E\\u003Ca href=\\\"http://docs.yahoo.com/info/copyright/copyright.html\\\"\\u003ECopyright/IP Policy\\u003C/a\\u003E\\u003C/li\\u003E\\n            \\u003C/ul\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv class=\\\"notice\\\"\\u003E\\n            \\u003Ccite\\u003E\\u003C/cite\\u003E\\n        \\u003C/div\\u003E\\n        \\n    \\u003C/div\\u003E\\n\\u003C/div\\u003E\\n            \\u003C/div\\u003E\\n        \\u003C/div\\u003E\\n    \\u003C/div\\u003E\\n\\u003C/div\\u003E\\n\\n\\u003C!-- END N_C_R --\\u003E\\n\\n\\u003C!-- START wrap --\\u003E\\n\\u003Cdiv class=\\\"yog-wrap yog-full\\\"\\u003E\\n    \\u003Cdiv id=\\\"yom-ad-darla-callframe-mediaadsdarla\\\" style=\\\"display:none;\\\"\\u003E\\u003C/div\\u003E\\n\\u003C/div\\u003E\\n\\n\\n\\u003C!-- END wrap --\\u003E\\n\\n\\n\\u003C!-- END full --\\u003E\\n\\n                \\u003C!-- Social Events --\\u003E\\n                \\n                \\u003C!-- Feedback --\\u003E\\n                \\n            \\u003C/div\\u003E\\n            \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t3\\\");\\u003C/script\\u003E\\n        \\u003C/div\\u003E\\n        \\u003Cdiv id=\\\"yom-ad-FOOT9\\\" class=\\\"yom-ad yom-ad-FOOT9\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n        \\n\\u003Cscript type=\\\"text/javascript\\\"\\u003Eif(typeof rt_pushMoment!=='undefined')rt_pushMoment(\\\"t4\\\");\\u003C/script\\u003E\\n        \\n        \\n\\u003Cscript\\u003EYMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y){Y.Global.Media.ViewportLoader.addContainers([{selector: \\\"#mediacontentfollowproperty_container\\\",callback: function (node) {Y.Media.RMP.load({srcNode: \\\"#mediacontentfollowproperty_container\\\",response: \\\"\\\\r\\\\n--dali-response-split-51ddaba7d48ef\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: top\\\\r\\\\n\\\\r\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/media-content-follow-property-desktop-min-1339299.css\\\\\\\" \\\\/\\u003E\\\\r\\\\n--dali-response-split-51ddaba7d48ef\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: bottom\\\\r\\\\n\\\\r\\\\n\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\u003E\\\\n\\\\t\\\\t\\\\nYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-content-social-base\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/content_social\\\\\\\\\\\\/content-social-base-min-1339203.js\\\\\\\"},\\\\\\\"media-content-follow-property\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/content_social\\\\\\\\\\\\/content-follow-property-min-1306078.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\nYUI.YUICfg.root='yui:'+YUI.version+'\\\\/build\\\\/';\\\\nYMedia.applyConfig(YUI.YUICfg);\\\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04\\\\/build\\\\/';\\\\nYMedia.use(\\\\\\\"media-content-social-base\\\\\\\",\\\\\\\"media-content-follow-property\\\\\\\",\\\\\\\"base\\\\\\\",\\\\\\\"event\\\\\\\",\\\\\\\"node\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n    Y.later(10, this, function() {new Y.Media.MediaContentFollowProperty({\\\\\\\"item_facebook\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"www.facebook.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"facebook\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Facebook\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"item_twitter\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"twitter.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"twitter\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Twitter\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"mod_id\\\\\\\":\\\\\\\"mediacontentfollowproperty\\\\\\\",\\\\\\\"mixer\\\\\\\":{\\\\\\\"site\\\\\\\":\\\\\\\"news\\\\\\\",\\\\\\\"region\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"scrumb\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"content_id\\\\\\\":\\\\\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\\\\\",\\\\\\\"title_orig\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"url_orig\\\\\\\":\\\\\\\"\\\\\\\"}});});\\\\n\\\\t\\\\t   \\\\n});\\\\n\\\\nYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\nYMedia.use(\\\\\\\"\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentfollowproperty\\\\\\\"); } }());\\\\n    });\\\\n});\\\\n});\\\\n\\\\t\\\\t\\\\n\\\\t    \\u003C\\\\/script\\u003E\\\\r\\\\n--dali-response-split-51ddaba7d48ef\\\\r\\\\nContent-Type: text\\\\/html; charset=utf-8\\\\r\\\\n\\\\r\\\\n \\u003Csection class=\\\\\\\"yom-mod \\\\\\\" id=\\\\\\\"mediacontentfollowproperty\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"yom-follow-property\\\\\\\" class=\\\\\\\"yom-mod yom-follow-property\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\u003E \\u003Cdiv class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ch3\\u003EFollow Yahoo! News\\u003C\\\\/h3\\u003E \\u003C\\\\/div\\u003E \\u003Cdiv class=\\\\\\\"bd\\\\\\\"\\u003E \\u003Cul\\u003E   \\u003Cli class=\\\\\\\"follow-property-facebook clearfix\\\\\\\"\\u003E \\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.facebook.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.facebook.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E on Facebook\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003C\\\\/li\\u003E     \\u003Cli class=\\\\\\\"follow-property-twitter clearfix\\\\\\\"\\u003E \\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/twitter.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/twitter.com\\\\/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E on Twitter\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E \\u003C\\\\/li\\u003E    \\u003C\\\\/ul\\u003E \\u003C\\\\/div\\u003E \\u003C\\\\/div\\u003E \\u003C\\\\/section\\u003E\\\\n\\\\r\\\\n--dali-response-split-51ddaba7d48ef--\\\\r\\\\n\\\"});}}]);});\\u003C/script\\u003E\\u003C!-- fe661.global.media.gq1.yahoo.com compressed Wed Jul 10 18:44:55 UTC 2013 --\\u003E\\n\\n\\u003Cscript\\u003EYMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y){Y.Global.Media.ViewportLoader.addContainers([{selector: \\\"#mediacontentweather_container\\\",callback: function (node) {Y.Media.RMP.load({srcNode: \\\"#mediacontentweather_container\\\",response: \\\"\\\\r\\\\n--dali-response-split-51ddabac717dc\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: top\\\\r\\\\n\\\\r\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?rl\\\\/ulw\\\\/2.2.3\\\\/location_widget-min.css&os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/weather-desktop-min-1311126.css\\\\\\\" \\\\/\\u003E\\\\n\\\\n\\\\t\\\\t\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\u003E\\\\n\\\\t\\\\t\\\\nYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-lw-base64\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\\\\\/ulw\\\\\\\\\\\\/2.2.3\\\\\\\\\\\\/lw-base64-min.js\\\\\\\"},\\\\\\\"media-lw-overlay\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\\\\\/ulw\\\\\\\\\\\\/2.2.3\\\\\\\\\\\\/lw-overlay-min.js\\\\\\\"},\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/weather\\\\\\\\\\\\/locdrop-patch-2.2.4-min-1275196.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\nYUI.YUICfg.root='yui:'+YUI.version+'\\\\/build\\\\/';\\\\nYMedia.applyConfig(YUI.YUICfg);\\\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04\\\\/build\\\\/';\\\\nYMedia.use(\\\\\\\"media-lw-base64\\\\\\\",\\\\\\\"media-lw-overlay\\\\\\\",\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n\\\\t\\\\t   \\\\n});\\\\n\\\\n\\\\t\\\\t\\\\n\\\\t    \\u003C\\\\/script\\u003E\\\\r\\\\n--dali-response-split-51ddabac717dc\\\\r\\\\nContent-Type: text\\\\/plain; charset=utf-8\\\\r\\\\nRMP-Embed-Location: bottom\\\\r\\\\n\\\\r\\\\n\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\u003E\\\\n\\\\t\\\\t\\\\nYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-weather\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\\\\\/mit\\\\\\\\\\\\/media\\\\\\\\\\\\/m\\\\\\\\\\\\/content_index\\\\\\\\\\\\/weather-min-1321733.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/zz\\\\\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\nYUI.YUICfg.root='yui:'+YUI.version+'\\\\/build\\\\/';\\\\nYMedia.applyConfig(YUI.YUICfg);\\\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04\\\\/build\\\\/';\\\\nYMedia.use(\\\\\\\"media-weather\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n\\\\t\\\\t   \\\\n});\\\\n\\\\nYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\nYMedia.use(\\\\\\\"media-weather\\\\\\\",\\\\\\\"jsonp\\\\\\\",\\\\\\\"jsonp-url\\\\\\\",\\\\\\\"node-focusmanager\\\\\\\",\\\\\\\"lw-overlay\\\\\\\",\\\\\\\"lw-base64\\\\\\\",\\\\\\\"ulwv2-locdrop\\\\\\\",\\\\\\\"array-extras\\\\\\\",function(Y){\\\\n    \\\\t  \\\\n    Y.later(10, this, function() {Y.Media.Weather.MediaContentWeather.Weather.init({\\\\\\\"modId\\\\\\\":\\\\\\\"mediacontentweather\\\\\\\",\\\\\\\"bucket\\\\\\\":null,\\\\\\\"crumbVal\\\\\\\":\\\\\\\"cXpTTEhvVld2bm8-\\\\\\\",\\\\\\\"curLocObj\\\\\\\":{\\\\\\\"addr\\\\\\\":\\\\\\\"Lafayette, Indiana, United States, 47905\\\\\\\",\\\\\\\"app\\\\\\\":\\\\\\\"yahoo.globalmedia.auth-yca.ups.env-prod\\\\\\\",\\\\\\\"cc\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"city\\\\\\\":\\\\\\\"Lafayette\\\\\\\",\\\\\\\"conf\\\\\\\":60,\\\\\\\"country_conf\\\\\\\":90,\\\\\\\"ctry\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"ctx\\\\\\\":\\\\\\\"global\\\\\\\",\\\\\\\"dtime\\\\\\\":\\\\\\\"2013-07-10T18:45:00Z\\\\\\\",\\\\\\\"freq\\\\\\\":1,\\\\\\\"id\\\\\\\":\\\\\\\"id_current\\\\\\\",\\\\\\\"input\\\\\\\":\\\\\\\"ip\\\\\\\",\\\\\\\"lat\\\\\\\":40.424388885498,\\\\\\\"lon\\\\\\\":-86.808479309082,\\\\\\\"lvl\\\\\\\":1,\\\\\\\"rad\\\\\\\":15781,\\\\\\\"raw\\\\\\\":\\\\\\\"98.215.10.79\\\\\\\",\\\\\\\"sc\\\\\\\":\\\\\\\"IN\\\\\\\",\\\\\\\"src\\\\\\\":\\\\\\\"gt_locip\\\\\\\",\\\\\\\"state\\\\\\\":\\\\\\\"Indiana\\\\\\\",\\\\\\\"state_conf\\\\\\\":60,\\\\\\\"town_conf\\\\\\\":60,\\\\\\\"type\\\\\\\":\\\\\\\"physical\\\\\\\",\\\\\\\"woe\\\\\\\":12778444,\\\\\\\"woetype\\\\\\\":\\\\\\\"zip\\\\\\\",\\\\\\\"zip\\\\\\\":\\\\\\\"47905\\\\\\\",\\\\\\\"zip_conf\\\\\\\":60},\\\\\\\"defLocObj\\\\\\\":null,\\\\\\\"spaceId\\\\\\\":\\\\\\\"2143334674\\\\\\\",\\\\\\\"locale\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"fpHost\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/weather.yahoo.com\\\\\\\",\\\\\\\"unit\\\\\\\":\\\\\\\"f\\\\\\\"});\\\\n    });\\\\n    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentweather\\\\\\\"); } }());\\\\n    });\\\\n});\\\\n});\\\\n\\\\t\\\\t\\\\n\\\\t    \\u003C\\\\/script\\u003E\\\\r\\\\n--dali-response-split-51ddabac717dc\\\\r\\\\nContent-Type: text\\\\/html; charset=utf-8\\\\r\\\\n\\\\r\\\\n \\u003Csection class=\\\\\\\"yom-mod yom-weather yom-app clearfix\\\\\\\" id=\\\\\\\"mediacontentweather\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentweather;mpos:1;sec:app-wea;\\\\\\\"\\u003E  \\u003Cform id=\\\\\\\"fixIE10Enter\\\\\\\" onsubmit=\\\\\\\"return false;\\\\\\\"\\u003E \\u003Ch2 class=\\\\\\\"hide\\\\\\\"\\u003EWeather Today\\u003C\\\\/h2\\u003E  \\u003Cul\\u003E  \\u003Cli class=\\\\\\\"current clearfix\\\\\\\" data-uri=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/8_IE6.png\\\\\\\" alt=\\\\\\\"Light Rain\\\\\\\" title=\\\\\\\"Light Rain\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Cp id=\\\\\\\"weather_lw_switch\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"ell\\\\\\\" title=\\\\\\\"Lafayette, IN\\\\\\\"\\u003ELafayette, IN\\u003C\\\\/span\\u003E \\u003Cspan id=\\\\\\\"ulw-start\\\\\\\"\\u003E&nbsp;\\u003C\\\\/span\\u003E\\u003C\\\\/p\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"cond\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cem class=\\\\\\\"temp temp-f \\\\\\\"\\u003E 70\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\u003E&deg;F\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\u003ELight Rain\\u003C\\\\/span\\u003E \\u003C\\\\/em\\u003E \\u003Cem class=\\\\\\\"temp temp-c hide\\\\\\\"\\u003E 21\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\u003E&deg;C\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\u003ELight Rain\\u003C\\\\/span\\u003E \\u003C\\\\/em\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E   \\u003Cli class=\\\\\\\"forecast\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/8_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003EToday\\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E84&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E60&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E29&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E16&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E  \\u003Cli class=\\\\\\\"forecast\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/33_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003ETomorrow\\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E81&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E55&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E27&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E13&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E  \\u003Cli class=\\\\\\\"forecast\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l4.yimg.com\\\\/dh\\\\/ap\\\\/default\\\\/121210\\\\/31_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\u003E \\u003C\\\\/a\\u003E \\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003EFriday\\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E79&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E57&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/weather.yahoo.com\\\\/united-states\\\\/indiana\\\\/lafayette-12778444\\\\/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"high\\\\\\\"\\u003E26&deg;\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"low\\\\\\\"\\u003E14&deg;\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/h3\\u003E \\u003C\\\\/li\\u003E  \\u003C\\\\/ul\\u003E   \\u003C\\\\/form\\u003E \\u003Cdiv class=\\\\\\\"weather_credit\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"weather_credit_text\\\\\\\"\\u003EPowered by\\u003C\\\\/span\\u003E \\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.weather.com\\\\\\\" class=\\\\\\\"twc_icon\\\\\\\"\\u003E \\u003Cspan class=\\\\\\\"weather_twc_icon\\\\\\\"\\\\/\\u003E\\u003C\\\\/span\\u003E \\u003C\\\\/a\\u003E \\u003C\\\\/div\\u003E \\u003C\\\\/section\\u003E\\\\n\\\\r\\\\n--dali-response-split-51ddabac717dc--\\\\r\\\\n\\\"});}}]);});\\u003C/script\\u003E\\u003C!-- fe574.global.media.gq1.yahoo.com compressed Wed Jul 10 18:45:00 UTC 2013 --\\u003E\\n\\n\\u003Cscript\\u003EYMedia.use(\\\"media-rmp\\\", function(Y){Y.Media.RMP.load({srcNode: \\\"#p_30345786_container\\\", continueOnError: true, response:\\\"--dali-response-split-51ddabac509b3Content-Type: text\\\\/plain; charset=utf-8\\\\nRMP-Embed-Location: top\\\\n\\\\n\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/helpers_0.0.6.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/typography_0.0.2.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/common_0.0.29.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/desktop_0.0.62.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_1.0.12.css\\\\\\\" \\\\/\\u003E\\\\n\\\\n\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text\\\\/css\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.271.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/theme_gs_0.0.45.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.3.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/rmx_ads_0.0.8.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_desktop_0.0.21.css&nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.71.css\\\\\\\" \\\\/\\u003E\\\\n\\\\n--dali-response-split-51ddabac509b3Content-Type: text\\\\/html; charset=utf-8\\\\nRMP-Embed-Location: bottom\\\\n\\\\n\\u003Cdiv id=\\\\\\\"p_30345786\\\\\\\" class=\\\\\\\"rapidnofollow rapid-container dev-desktop\\\\\\\" data-ylk=\\\\\\\"sec:td-strm\\\\\\\"\\u003E\\\\n\\u003Cdiv id=\\\\\\\"default-u_30345786\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"default-u_30345786-bd\\\\\\\" class=\\\\\\\"bd type_stream type_stream_default\\\\\\\"\\u003E\\u003Cdiv id=\\\\\\\"default-p_30345810_fcd\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"default-p_30345810_fcd-bd\\\\\\\" class=\\\\\\\"bd type_fstream type_fstream_default\\\\\\\"\\u003E\\u003Cstyle\\u003E .type_fstream .dropdown-label-text, .type_fstream .tab-list .filter-item .filter-name, .type_fstream .filter-bar-section { background-color:#0e2b5c !important;border:solid 1px #0e2b5c !important;color:#fff !important } .type_fstream .tab-list .filter-item { opacity: 0.7; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=70)\\\\\\\"; filter: alpha(opacity=70); }.type_fstream .tab-list .filter-selected { opacity: 1; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\\\\\\\"; filter: alpha(opacity=100); }\\u003C\\\\/style\\u003E\\u003Cdiv class=\\\\\\\"filter-bar-section\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"tab-list d-ib fz-xs pos-r\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROP:TOPSTORIES;cpos:1;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EAll News\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"LISTID:c435b248-2107-445e-97ea-89e2ec5df60c\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:LISTID:c435b248-2107-445e-97ea-89e2ec5df60c;cpos:2;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EY! News Originals\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ABCNEWS\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ABCNEWS;cpos:3;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EABC News\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ap.org\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ap.org;cpos:4;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EAP\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:reuters.com\\\\\\\"\\u003E\\\\n    \\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:reuters.com;cpos:5;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003EReuters\\u003C\\\\/a\\u003E\\\\n\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\u003Cul\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:1;pkgt:4;ccode:news;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fexpert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000667|YCT:001000780|WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002721;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-15px;background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/XITng7YWKM1CwU3GfV_RdA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTg1\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/d475fdac10c72e17370f6a706700275c.jpg');\\\\\\\" width=\\\\\\\"111\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002721;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EExpert: Zimmerman was in worse shape than Martin\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ESANFORD, Fla. (AP) \\\\u2014 A Florida judge ruled Wednesday that Trayvon Martin&#39;s cellphone text messages about fighting and a defense animation depicting the struggle between Martin and George Zimmerman won&#39;t be introduced as evidence at Zimmerman&#39;s trial. Defense attorneys had wanted to use those pieces\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:1;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ESociety\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/shooting-of-trayvon-martin\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-ylk=\\\\\\\"slk:Shooting of Trayvon Martin;sec:td-strm;cpos:2;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EShooting of Trayvon Martin\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"950129f1-e974-33ae-b739-227b6ca2e187\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:2;pkgt:3;ccode:news;g:950129f1-e974-33ae-b739-227b6ca2e187;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fblogs%2Ftrending-now%2Ftoddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/blogs\\\\/trending-now\\\\/toddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:2;g:950129f1-e974-33ae-b739-227b6ca2e187;tar:news.yahoo.com;ltxt:ToddlerB;ct:2;pkgt:3;r:4100001328;slk:title;itc:0;prov:TrendingNow;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EToddler Buys Car on eBay Using Father\\\\u2019s Smartphone\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ELast month Sorella Stoute from Portland, Oregon, purchased a 1962 Austin-Healey Sprite on eBay. Now, this might not sound like much of a story, until you learn that Sorella is only 14 months old. Here&#39;s what happened. The tiny online shopper was playing with her father Paul Stoute&#39;s smartphone when\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003ETrending Now\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21675196\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:3;pkgt:4;ccode:news;g:21675196;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o%3D%2Chttp%253A%252F%252Fwww.nextag.com%252Fgoto.jsp%253Fp%253D357374%2526crid%253D70102%2526search%253Ddress\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&V0nyIPZ2wp3wBusYIXHe592L0U7rDWPGQGsA2NLVx3J0KeGD1Gapax21gVu.4ub8eFnCFz8GoX6lzjIPOHbY1UKvAs1CeuA60UvO0.YaI6H7fSjP2UaZY6JWBoP.Y4JRu2UyaZwxD04xOZvyPdQNGYVq9AxUfRnsNZF1Y6L06KkTBbSIxFyk3TTzx.JT3qi5JFlL2QTq7h3z8NjNyDeGKHRzDxkl6_yoxQKIxLF4m8y40IG6XudIj8DF9b64cUQQHhIJHXEGWMyFysCaCq98U1ZQSR.9S_3ymGqOz5p_GZi3eptf_vUuH9Aorn5IDOJWPdjFst6IAPJXboFx_0c7_RynZr29hWH.4Y73607V3wk6aAzvWLpFV3H8bmYeKn7meWf_9d_9949AaqS_QIJLaKMWA0Dj.rW4FwZNiE61P3yRpuUx3CmmBvSFUidR6rNmRk3NYSK3F_6O9FKeYsabBo.PXQ2_tIW0.tpOGYIkRZu4nDEC7bCIucM1b5p55FC8rhu4U.M4XH2cWUOgd4CcG0N7gZqH5k.VG9DQZj9mjTF7HA2Bj9s1WPqooqjd3_gsuIUozyOhUDJk7rWhL0661.aV2jgJhyCpCH69hRILuz89M73USaOMvoeQPZL_7OudoN8niNqPD6xKYuHKCwMsDletkPtsMywAxFmuXCG6Lo4ZaXTaPguHRylbkYAyjmpNmGx_U4zR.55JxLyFd5G_zebInENUmshO.3eWcDycFODZE9bae7e_SzNR.yayrRfbK.xapTXID_8l5O3ZEr.aw9BGFFXyquRWYPTVS2ZrhAuQLfrDUdFiiZehmKEbDiXQAQ--&ap=3\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/bulk\\\\/6473\\\\/c1b5c4a6baf815019e3f6c79b13674e1.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003ETop 10 Dresses for 2013\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EHottest Dresses on sale.  Awesome selection and deals.\\u003C\\\\/p\\u003E\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/info.yahoo.com\\\\/privacy\\\\/us\\\\/yahoo\\\\/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003EAdChoices\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E\\u003C\\\\/a\\u003E\\\\n\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EOfficial Nextag Site\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/help.yahoo.com\\\\/kb\\\\/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003ESponsored\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a5d908b7-4f0c-3334-81a0-3d378bbeb520\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:4;pkgt:3;ccode:news;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000346|YCT:001000992\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/ntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:4;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;tar:news.yahoo.com;ltxt:NTSBfind;ct:1;pkgt:3;r:4100001409;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003ENTSB findings on SF plane crash at a glance\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EAfter departing from Shanghai and stopping in Seoul, Asiana Flight 214 makes its final approach into San Francisco International Airport following a 10-hour flight across the Pacific Ocean. A preliminary ...\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/personal-investing-ideas-and-strategies\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000346\\\\\\\" data-ylk=\\\\\\\"slk:Personal Investing Ideas & Strategies;sec:td-strm;cpos:1;itc:0;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPersonal Investing Ideas & Strategies\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"fe94cddd-d36b-3ce5-9246-733c1229ba93\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:5;pkgt:3;ccode:news;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Froyal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000395|YCT:001000495\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/gma.yahoo.com\\\\/blogs\\\\/abc-blogs\\\\/royal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:5;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;tar:gma.yahoo.com;ltxt:HowKate&;ct:2;pkgt:3;r:4100001170;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EHow Kate&#39;s Delivery Will Differ From U.S. Experience\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EThe future British monarch is due to be born any day now. Kate Middleton will deliver her child at Mary\\\\u2019s Hospital in London, in the same wing where Princess Diana gave birth to her own children. \\\\u201cIt\\\\u2019s a beautiful unit,\\\\u201d Regina Curran, a British midwife,...\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EABC News\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/health\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000395\\\\\\\" data-ylk=\\\\\\\"slk:Health;sec:td-strm;cpos:1;itc:0;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EHealth\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:6;pkgt:3;ccode:news;g:c200730b-eb18-376d-a3d3-1892197b9f54;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fwashington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000680|WIKIID:Barack_Obama|WIKIID:Mohamed_Morsi|WIKIID:Egypt|WIKIID:United_States|WIKIID:Hosni_Mubarak|WIKIID:Cairo\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/washington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:6;g:c200730b-eb18-376d-a3d3-1892197b9f54;tar:news.yahoo.com;ltxt:Washingt;ct:1;pkgt:3;r:4100000835;slk:title;itc:0;prov:Reuters;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EWashington vilified on both sides of Egypt&#39;s divide\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EBy Maggie Fick and Tom Finn CAIRO (Reuters) - Pictures of Barack Obama have popped up all over Cairo. Some have his faced crossed out in paint. Heavy black beards are daubed onto others. No matter which side you talk to in Egypt, where people have been polarized by a violent political crisis, the\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EReuters\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/foreign-policy\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000680\\\\\\\" data-ylk=\\\\\\\"slk:Foreign Policy;sec:td-strm;cpos:2;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EForeign Policy\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EBarack Obama\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/mohamed-morsi\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\" data-ylk=\\\\\\\"slk:Mohamed Morsi;sec:td-strm;cpos:4;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EMohamed Morsi\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/egypt\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Egypt\\\\\\\" data-ylk=\\\\\\\"slk:Egypt;sec:td-strm;cpos:5;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EEgypt\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/united-states\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:United_States\\\\\\\" data-ylk=\\\\\\\"slk:United States;sec:td-strm;cpos:6;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EUnited States\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/hosni-mubarak\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\" data-ylk=\\\\\\\"slk:Hosni Mubarak;sec:td-strm;cpos:7;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EHosni Mubarak\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/cairo\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Cairo\\\\\\\" data-ylk=\\\\\\\"slk:Cairo;sec:td-strm;cpos:8;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ECairo\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content slideshow has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"706337c9-1922-33ac-b86f-a5280ffcc242\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:7;pkgt:21;ccode:news;g:706337c9-1922-33ac-b86f-a5280ffcc242;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fphotos%2Fcarpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow%2F\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/photos\\\\/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow\\\\/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001665;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/vv0qulgbBMDqq9r94wVCzw--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz0xMDA7aD0xMDA7cHlvZmY9MA--\\\\/http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/publish-images\\\\/news\\\\/2013-07-09\\\\/147c5e94-9385-462b-85d7-4916b61620c4_fire7.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"gallery-icon\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"view-now fz-xxs\\\\\\\"\\u003EView\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/photos\\\\/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow\\\\/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001665;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-uuid=\\\\\\\"de60ffd9-ff42-4ec7-b62c-b733917baeca\\\\\\\"\\u003ECarpenter 1 fire rages outside Las Vegas \\u003Csmall\\u003E(14 photos)\\u003C\\\\/small\\u003E\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EPhotos from the Carpenter 1 fire outside Las Vegas, Nev., which has charred an area the size of Manhattan Island, according to the Associated Press .\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:8;pkgt:3;ccode:news;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Fprince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000069|YCT:001000070|WIKIID:Prince_Harry_of_Wales|WIKIID:Kensington_Palace\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/gma.yahoo.com\\\\/blogs\\\\/abc-blogs\\\\/prince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;tar:gma.yahoo.com;ltxt:PrinceWi;ct:2;pkgt:3;r:4100000840;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EPrince William to Play Polo While Nine-Months-Pregnant Kate Waits\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EPrince William has plans this weekend, but they don\\\\u2019t include a hospital. While his nine-months-pregnant wife, Kate, stays back home at the couple\\\\u2019s Kensington Palace home, Prince William will go ahead with plans to play in a charity polo match Sunday in Glouchestershire, nearly 100...\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EABC News\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/celebrities\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000069\\\\\\\" data-ylk=\\\\\\\"slk:Celebrities;sec:td-strm;cpos:1;itc:0;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ECelebrities\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"359b4757-f472-3d49-a211-389223ffe98a\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:9;pkgt:3;ccode:news;g:359b4757-f472-3d49-a211-389223ffe98a;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fgop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Culture_of_the_United_States\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/gop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:9;g:359b4757-f472-3d49-a211-389223ffe98a;tar:news.yahoo.com;ltxt:GOPshoul;ct:1;pkgt:3;r:4090000733;slk:title;itc:0;prov:ChristianScience;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EGOP should remember: Data show immigrants enforce, not threaten, US values\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EA comprehensive immigration reform bill has passed the Senate, but it faces dubious prospects in the House, where it probably won\\\\u2019t garner enough of the Republican support needed to bring it to a floor vote. One Republican sticking point is that the prospective law doesn\\\\u2019t go far enough to ensure\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EChristian Science Monitor\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:359b4757-f472-3d49-a211-389223ffe98a;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"03ea9147-55d7-3820-996b-2c161860b5a2\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:10;pkgt:3;ccode:news;g:03ea9147-55d7-3820-996b-2c161860b5a2;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpublicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000267|YCT:001000269|WIKIID:Elementary_school\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/publicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:10;g:03ea9147-55d7-3820-996b-2c161860b5a2;tar:news.yahoo.com;ltxt:Afterpub;ct:1;pkgt:3;r:4100000542;slk:title;itc:0;prov:TheDailyCaller;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EAfter publicly shaming girls for short shorts, elementary school principal apologizes\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EThe principal at a highly selective and highly prestigious Chicago elementary school has apologized for singling out and publicly shaming seven girls on the last day of school for the immodest lengths of their shorts.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Daily Caller\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/education\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000267\\\\\\\" data-ylk=\\\\\\\"slk:Education;sec:td-strm;cpos:1;itc:0;g:03ea9147-55d7-3820-996b-2c161860b5a2;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EEducation\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c621133c-f907-3f42-93ff-20ef01effa97\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:11;pkgt:4;ccode:news;g:c621133c-f907-3f42-93ff-20ef01effa97;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fprinter-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:Ink_cartridge\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/video\\\\/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001178;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http:\\\\/\\\\/l3.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/etz.tfpoo6Au9ixj1O3c4g--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en-US\\\\/video\\\\/video.kgo.abc.news.com\\\\/20a2be41046b838e6399259f73c9f47d');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\u003EPlay\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/video\\\\/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001178;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EPrinter ink efficiency tested by Consumer Reports\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EMany don&#39;t realize it, but printer ink is one of the most expensive liquids you can buy.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EKGO \\\\u2013 San Francisco\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:12;pkgt:4;ccode:news;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fbush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Immigration_reform\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900660;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-18px;background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/kM94ldkpwhbbDP4OY9UnYQ--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTcz\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/4e2f582e10be2e17370f6a7067003150.jpg');\\\\\\\" width=\\\\\\\"118\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900660;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EBush: &#39;Benevolent spirit&#39; must drive reform plans\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EDALLAS (AP) \\\\u2014 Making a rare return to the political arena, former President George W. Bush urged Congress on Wednesday to reach a &quot;positive resolution&quot; on immigration reform, an issue that eluded him during his presidency and now confronts fellow Republicans in the aftermath of a 2012 election\\\\u2026\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/immigration-reform\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Immigration_reform\\\\\\\" data-ylk=\\\\\\\"slk:Immigration reform;sec:td-strm;cpos:2;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EImmigration reform\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"e4009e04-8a14-3454-b2ef-0adfa809f2c3\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:13;pkgt:4;ccode:news;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fnavy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000705|YCT:001000661|WIKIID:Unmanned_aerial_vehicle|WIKIID:Aircraft_carrier|WIKIID:Patuxent_River\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000590;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-37px;background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/qYZjBoAYvbF1JWrX_Eav.g--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTMx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/c6ce26150eb22417370f6a706700137b.jpg');\\\\\\\" width=\\\\\\\"156\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000590;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003ENavy to attempt 1st unmanned carrier landing\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ENORFOLK, Va. (AP) \\\\u2014 The Navy will attempt to land a drone the size of a fighter jet aboard an aircraft carrier for the first time Wednesday, showcasing the military&#39;s capability to have a computer program perform one of the most difficult tasks a pilot is asked to do.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/military-and-defense\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000705\\\\\\\" data-ylk=\\\\\\\"slk:Military;sec:td-strm;cpos:1;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EMilitary\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:2;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"95413a0a-1d88-3f94-817c-d6b5fb824b6f\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:14;pkgt:4;ccode:news;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpanera-retool-latest-pay-idea-051305138.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000123|WIKIID:Panera_Bread\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-21px;background-image:url('http:\\\\/\\\\/l3.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/GRTmxi74dUkPM0bN5Tu_EA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTY3\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/a4d177310ec22417370f6a7067000233.jpg');\\\\\\\" width=\\\\\\\"123\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EPanera to retool latest pay-what-you-can idea\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EST. LOUIS (AP) \\\\u2014 Panera Bread&#39;s latest pay-what-you-can experiment will be retooled and brought back next winter as a seasonal offering rather than a permanent one, the chain&#39;s founder says.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/panera-bread\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Panera_Bread\\\\\\\" data-ylk=\\\\\\\"slk:Panera Bread;sec:td-strm;cpos:1;itc:0;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPanera Bread\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"89342141-8982-3a32-9a2e-81cda1656e16\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:15;pkgt:4;ccode:news;g:89342141-8982-3a32-9a2e-81cda1656e16;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fformer-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|WIKIID:National_Security_Agency|WIKIID:Barack_Obama\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/V1oj15r8LwVhitDeCoj3_g--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjA4O2g9MjUw\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ap_webfeeds\\\\/fab40ba5f2431816370f6a706700947e.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"99\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EFormer judge admits flaws in secret court\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EWASHINGTON (AP) \\\\u2014 A former federal judge who served on a secret court overseeing the National Security Agency&#39;s secret surveillance programs said Tuesday the panel is independent but flawed because only the government&#39;s side is represented effectively in its deliberations.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/national-security-agency\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:National_Security_Agency\\\\\\\" data-ylk=\\\\\\\"slk:National Security Agency;sec:td-strm;cpos:2;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ENational Security Agency\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EBarack Obama\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21370595\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:16;pkgt:4;ccode:news;g:21370595;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ%3D%3D%2Chttp%253A%252F%252Fclk.atdmt.com%252FINV%252Fgo%252F451647339%252Fdirect%252F01%252F\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&2cDiAE12wp2Dz.IwU74e5L1PMXSElzNIwUK.DMksZqbxsQNr9TkpxCCr3WkJefTamYWy_.RN_hVPXUN96KEmE6ByAcKWxHo_oetdF3FvXS1T4NtiQxv4YZ0_pBqtqIzH7O0ip8bvVxgjPoKrSIwG2xYGphqXGJwgoHcGcgG6If4jmnCeJkwoMjzSA8lFxsfkkKA5DGemNrz59aiXKMmKD7i9PXlW8r2bIioPHiaIYVJFP.QJdTsf__VTZFUW5lerdtC_foE9u2ATjsTvjISjazahXozJ6Oo8C8GYosDyhfSmkJHNjhhMBi9HS.XGNQH8nIB_XOkOm.hF510EM.9rqVlMhgnjknC0ca0Eccddul7I8ACjWxjY0UiLEjdHucq2K4wSP.9k9kUpE5hbigMU3SU7.cOvzOo2XODCl6dUGOGqZyJvSSz4w9hwJL7zeN54KIFBN6mk6yqN36aEqybOOSK1u36lzqH2YgNGwXAeFbbilXKTJ0DVDF6GlynUmDdFtRLyoOuThCtSKF6d6nLaCiNzVrjY05GLBZjy5kaCH14JPJh_KKyfu2OhKseyolVTvUug1YRMwuX2jv3wSMXBp.FKtRh6NG2QUwmaIGRYvA09G1x1.QgmNWuuIBy.oxdZdWOxknKRp9psnS.jbCXybIZlgH3d43a69GiPaDAIoWuKnUMJQm3rrrcxtN6mHmKojXspt5I6SJTd0aK5ltwxYLhXxAzDmD83Ph4JO2ELWwMETAXVuntQeEN1giBo4kExl_3SxoqLTQNH213UQHc5JqT6uw5Y4Bsbw1xKzn6Do.zfYxlNtrKHwoD6oZOIoIkF1g--&ap=16\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21370595;tar:ad.yieldmanager.com;ltxt:4WaystoA;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/0-1371163702-9044.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"61\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21370595;tar:ad.yieldmanager.com;ltxt:4WaystoA;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E4 Ways to Avoid Running Out of Money in Retirement\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EIf you have a $500,000 portfolio, download the &quot;15-Minute Retirement Plan&quot; by Forbes columnist Ken Fisher's Firm.\\u003C\\\\/p\\u003E\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/info.yahoo.com\\\\/privacy\\\\/us\\\\/yahoo\\\\/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003EAdChoices\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E\\u003C\\\\/a\\u003E\\\\n\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EFisher Investments\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/help.yahoo.com\\\\/kb\\\\/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003ESponsored\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"545a4a5d-31f1-3d2b-b3a1-af6ab035ba08\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:17;pkgt:4;ccode:news;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:California|WIKIID:Solitary_confinement\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000790;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-25px;background-image:url('http:\\\\/\\\\/l1.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/cIsjQVUHZJZ7HCJhBG6m2Q--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTU2\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/theatlanticwire\\\\/30_000_California_Prisoners_Are_Refusing-b255dfae58903c7ee92b601e81fb15da');\\\\\\\" width=\\\\\\\"131\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000790;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003E30,000 California Prisoners Are Refusing Meals\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EOver 30,000 California prisoners started refusing meals on Monday morning in what might become the biggest hunger strike in California prison history, according to California&#39;s corrections department.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Atlantic Wire\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/california\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:California\\\\\\\" data-ylk=\\\\\\\"slk:California;sec:td-strm;cpos:1;itc:0;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ECalifornia\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"33a46b90-1741-349c-a64b-0f5fc4dcbfb9\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:18;pkgt:4;ccode:news;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpoint-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:Bob_McDonnell|WIKIID:Governor_of_Virginia\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/point-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;tar:news.yahoo.com;ltxt:AtWhatPo;ct:1;pkgt:4;r:4100000359;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/Mb7deq6crVPlKz5J2zGWAQ--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz04MjtoPTgyO3B5b2ZmPTA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/theatlanticwire\\\\/At_What_Point_Did_Virginia-e24a1b834aca29c22a0710616d3eaa81');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/point-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;tar:news.yahoo.com;ltxt:AtWhatPo;ct:1;pkgt:4;r:4100000359;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EAt What Point Did Virginia Governor Bob McDonnell Go Too Far?\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EBob McDonnell is still the governor of Virginia, despite a series of revelations from the Washington Post detailing unreported gifts from a contributor to McDonnell and his family. There have been so many gifts, in fact, that we were wondering: how much do people consider too much?\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Atlantic Wire\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"time\\\\\\\"\\u003E52 mins ago\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"04cc60e0-a193-3352-8e5c-ff896228e590\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:19;pkgt:4;ccode:news;g:04cc60e0-a193-3352-8e5c-ff896228e590;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fmajor-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/video\\\\/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001231;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http:\\\\/\\\\/l3.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/3aHYmihw4JqFgqXUDpm5bA--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en-US\\\\/video\\\\/video.wabc.abc.news.com\\\\/10a5262f6a2220ce4bf4830c048b3257');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\u003E\\u003C\\\\/i\\u003E \\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\u003EPlay\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/video\\\\/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001231;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EMajor setback for the defense at George Zimmerman trial\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EMarci Gonzalez reports for ABC News from Sanford, Florida\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EWABC \\\\u2013 NY\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"35246d27-ef1f-3c2f-ac82-50ee6d2511ee\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:20;pkgt:3;ccode:news;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000804|YCT:001000780|WIKIID:Southern_Baptist_Convention\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/ky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;tar:news.yahoo.com;ltxt:Ky.churc;ct:1;pkgt:3;r:4053101068;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EKy. church wants pastor gone after wife&#39;s column\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003ELOUISVILLE, Ky. (AP) \\\\u2014 A newspaper column lampooning Southern Baptists, calling the group &quot;the crazy old paranoid uncle of evangelical Christians,&quot; is causing quite a stir in a Kentucky city and put a pastor&#39;s job in jeopardy.\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EAssociated Press\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/religion-and-beliefs\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000804\\\\\\\" data-ylk=\\\\\\\"slk:Religion;sec:td-strm;cpos:1;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EReligion\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:2;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003ESociety\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c20cc012-29f6-3120-a12f-ef78c41a0a22\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:21;pkgt:4;ccode:news;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000681|WIKIID:White_House|WIKIID:Presidency_of_Barack_Obama|WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"\\\\/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600901;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\u003E\\u003Cimg src=\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/mit\\\\/media\\\\/m\\\\/base\\\\/images\\\\/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-27px;background-image:url('http:\\\\/\\\\/l2.yimg.com\\\\/ts\\\\/api\\\\/res\\\\/1.2\\\\/Rntt.Xg7T8Y5NxTOWahOJg--\\\\/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTUx\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/theweek\\\\/is-president-obamas-signature-legislative-achievement-turning-into-a-messy-failure.jpg');\\\\\\\" width=\\\\\\\"136\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\u003E\\u003C\\\\/a\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"\\\\/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600901;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\u003EWhat 3 years of ObamaCare incompetence tells us about the White House\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EThe administration is gradually scaling back its signature legislation \\\\u2014 just as critics have long demanded\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EThe Week\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPolitics\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/white-house-2\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:White_House\\\\\\\" data-ylk=\\\\\\\"slk:White House;sec:td-strm;cpos:2;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EWhite House\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/presidency-of-barack-obama\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Presidency of Barack Obama;sec:td-strm;cpos:3;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPresidency of Barack Obama\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/patient-protection-and-affordable-care-act\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-ylk=\\\\\\\"slk:Patient Protection and Affordable Care Act;sec:td-strm;cpos:4;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EPatient Protection and Affordable Care Act\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:22;pkgt:3;ccode:news;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fabcnews.go.com%2Fblogs%2Fentertainment%2F2013%2F07%2Fryan-reynolds-could-have-been-a-cop%2F\\\\\\\" data-wikiids=\\\\\\\"YCT:001000031|YCT:001000076\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/abcnews.go.com\\\\/blogs\\\\/entertainment\\\\/2013\\\\/07\\\\/ryan-reynolds-could-have-been-a-cop\\\\/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;tar:abcnews.go.com;ltxt:HowRyanR;ct:1;pkgt:3;r:4090000432;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003EHow Ryan Reynolds Dodged a Bullet\\u003C\\\\/a\\u003E\\u003C\\\\/h3\\u003E\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\u003EIn an alternate universe somewhere, Ryan Reynolds is patrolling the streets as a cop, munching on blue M&M\\\\u2019s and avoiding red carpets at all cost. But this is the real world and Reynolds, 36,\\\\u00a0is an A-list\\\\u00a0movie star married to one of the most elegant actresses... \\\\u00a0 \\\\u00a0 \\\\u00a0 \\\\u00a0\\u003C\\\\/p\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"source\\\\\\\"\\u003EABC News\\u003Cspan class=\\\\\\\"d-ib img-sprite off-network-icon\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/arts-and-entertainment\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000031\\\\\\\" data-ylk=\\\\\\\"slk:Arts & Entertainment;sec:td-strm;cpos:1;itc:0;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EArts & Entertainment\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http:\\\\/\\\\/news.yahoo.com\\\\/movies\\\\/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000076\\\\\\\" data-ylk=\\\\\\\"slk:Movies;sec:td-strm;cpos:2;itc:0;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\u003EMovies\\u003C\\\\/a\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\u003ERemove\\u003C\\\\/button\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"next-batch notice loading\\\\\\\" data-key=\\\\\\\"1\\\\\\\" data-ylk=\\\\\\\"slk:fetch;ltxt:fetch;pos:0;bpos:2;cpos:23;itc:1;sec:td-strm;test:900;intl:us;cat:default;ccode:news;\\\\\\\"  data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"fetch\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"fz-xs\\\\\\\"\\u003ELoad more stories\\u003C\\\\/button\\u003E\\u003C\\\\/li\\u003E\\u003C\\\\/ul\\u003E\\u003Cinput type=\\\\\\\"hidden\\\\\\\" class=\\\\\\\"historystate\\\\\\\" data-time=\\\\\\\"1373481900.2943\\\\\\\"\\u003E    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\\n\\\\n--dali-response-split-51ddabac509b3Content-Type: text\\\\/plain; charset=utf-8\\\\nRMP-Embed-Location: bottom\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\nYUI.namespace(\\\\\\\"presentation\\\\\\\");\\\\nYUI.presentation.lazyScriptList = [\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/oop_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/io-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-parse_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-stringify_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/cookie_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/jsonp_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-core_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-style_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-native_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-core_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-style_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/transition_3.8.2.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css2_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css3_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-complex_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-synthetic_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-focus_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-delegate_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-event-delegate_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-base_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-config_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-pluginhost_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-screen_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-screen_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/gallery-storage-lite_3.8.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_platform_1.1.14.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/resourcemgr_1.1.14.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/dali_transport_1.1.34.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/metro_dali_1.0.27.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_api_1.1.16.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/yui_service_0.1.17.js\\\\\\\"];\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\nYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metro_viewtype_0.1.24.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/default_viewtype_0.1.61.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/edit_viewtype_0.1.40.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/ylc_1.8.22.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/instrumentation_service_0.1.83.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/userinfo_service_0.1.15.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/statemgr_service_0.1.20.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metrologger_service_0.1.18.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_0.1.56.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/autohide_service_0.1.15.js\\\\\\\"]);\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\nYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?nn\\\\/lib\\\\/metro2\\\\/g\\\\/badge\\\\/badge_0.1.20.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.456.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/storage_service_0.0.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.38.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/interests_service_0.1.1.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_0.0.95.js&nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.32.js\\\\\\\"]);\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\n(function()\\\\n{\\\\n    YMedia.namespace('dali').config = {\\\\\\\"props\\\\\\\":{\\\\\\\"dali\\\\\\\":{\\\\\\\"crumb\\\\\\\":\\\\\\\"J6oPeXs35Uh\\\\\\\",\\\\\\\"yuid\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"loggedIn\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"mLogin\\\\\\\":0},\\\\\\\"proxyUrl\\\\\\\":\\\\\\\"\\\\\\\\\\\\/hjs?_mode=html&_create=1&_action=show&_type=badge&_container=1&_chrome=0&view=default&pInitLevel=lite&m_id=p_30345786&m_mode=multipart&configId=MediaRemoteIncludeExternalConfig&hide=0&mod_units=19&app=gs&content_id=5f01278b-803a-3803-9798-7fc79bab4f7d&juris=US&lang=en-US&pu=news.yahoo.com&region=US&se=4402687&site=news&mod_id=p_30345786&suid=30345786&pagetype=minihome&nolz=1&y_proc_embeds=1&y_map_urn=urn%3Armp%3Alite&_product_version=v2&r_inc=1&c_id=p_30345786_container&_sig=8nhtS_52JeXfdiYY25izjGGXZ2I-\\\\\\\"},\\\\\\\"data\\\\\\\":null,\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"signature\\\\\\\":\\\\\\\"he5R2PEbnkHjPiFGhQuSNQ--\\\\\\\"},\\\\\\\"moduleId\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"trusted\\\\\\\":true},\\\\\\\"state\\\\\\\":{},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.MODULE.ERROR_FALLBACK_TEXT\\\\\\\":\\\\\\\"Requested module is not available. Please try again.\\\\\\\",\\\\\\\"STR.EDIT\\\\\\\":\\\\\\\"Settings\\\\\\\",\\\\\\\"STR.EDIT.CLOSE\\\\\\\":\\\\\\\"Close Settings\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"__mmh_0\\\\\\\",\\\\\\\"ba\\\\\\\":{\\\\\\\"_action\\\\\\\":\\\\\\\"show\\\\\\\",\\\\\\\"chrome\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"_id\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"signature\\\\\\\":\\\\\\\"5nh6UiryEE9aP5zSGTFEXg--\\\\\\\"},\\\\\\\"woeId\\\\\\\":12778444,\\\\\\\"intl\\\\\\\":\\\\\\\"us\\\\\\\",\\\\\\\"socialEnabled\\\\\\\":true,\\\\\\\"swipeEnabled\\\\\\\":false,\\\\\\\"fbAcctLinked\\\\\\\":false,\\\\\\\"clientPagination\\\\\\\":true,\\\\\\\"dynamicEnabled\\\\\\\":true,\\\\\\\"removalMenuEnabled\\\\\\\":true,\\\\\\\"closeEnabled\\\\\\\":true,\\\\\\\"markAsReadEnabled\\\\\\\":true,\\\\\\\"tooltipsEnabled\\\\\\\":true,\\\\\\\"batchPause\\\\\\\":0,\\\\\\\"interestFiltersEnabled\\\\\\\":true,\\\\\\\"interestFiltersBroadcast\\\\\\\":true,\\\\\\\"minArticleCount\\\\\\\":6,\\\\\\\"broadcastDynamicEnabled\\\\\\\":true,\\\\\\\"sortBy\\\\\\\":0,\\\\\\\"shareDrawerEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"scrollBuffer\\\\\\\":900,\\\\\\\"writeMixerActions\\\\\\\":true,\\\\\\\"isRmp\\\\\\\":true,\\\\\\\"interestFiltersNavigate\\\\\\\":true,\\\\\\\"itemClickBroadcastOnly\\\\\\\":true,\\\\\\\"itemClickContext\\\\\\\":true,\\\\\\\"restoreStateExpire\\\\\\\":1800000,\\\\\\\"restoreStateMethod\\\\\\\":\\\\\\\"LOCAL_STORAGE\\\\\\\",\\\\\\\"restoreStateOnCacheMiss\\\\\\\":true,\\\\\\\"batchSize\\\\\\\":20,\\\\\\\"locationPickerEnabled\\\\\\\":false,\\\\\\\"beacon_sec\\\\\\\":\\\\\\\"app-loc\\\\\\\",\\\\\\\"beacon_slk\\\\\\\":\\\\\\\"s-op\\\\\\\",\\\\\\\"beacon_bucketid\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"dynamicCategories\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000661\\\\\\\",\\\\\\\"points\\\\\\\":155.14,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":56,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":6,\\\\\\\"2\\\\\\\":3,\\\\\\\"3\\\\\\\":3,\\\\\\\"4\\\\\\\":4,\\\\\\\"5\\\\\\\":9,\\\\\\\"6\\\\\\\":6,\\\\\\\"7\\\\\\\":8,\\\\\\\"8\\\\\\\":13,\\\\\\\"9\\\\\\\":4},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/politics-and-government\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000780\\\\\\\",\\\\\\\"points\\\\\\\":97.67,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":34,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2,\\\\\\\"2\\\\\\\":5,\\\\\\\"3\\\\\\\":4,\\\\\\\"4\\\\\\\":3,\\\\\\\"5\\\\\\\":7,\\\\\\\"6\\\\\\\":3,\\\\\\\"7\\\\\\\":5,\\\\\\\"8\\\\\\\":1,\\\\\\\"9\\\\\\\":4},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/society-and-culture\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000667\\\\\\\",\\\\\\\"points\\\\\\\":32.78,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":14,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"3\\\\\\\":1,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":2,\\\\\\\"6\\\\\\\":3,\\\\\\\"7\\\\\\\":4,\\\\\\\"9\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/crime-and-justice\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000267\\\\\\\",\\\\\\\"points\\\\\\\":29.27,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":8,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"3\\\\\\\":2,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":2,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/education\\\\\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Government\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000681\\\\\\\",\\\\\\\"points\\\\\\\":26.87,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":10,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"3\\\\\\\":1,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":3,\\\\\\\"7\\\\\\\":1,\\\\\\\"8\\\\\\\":2,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/government\\\\\\\\\\\\/\\\\\\\"}],\\\\\\\"dynamicEntities\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Barack_Obama\\\\\\\",\\\\\\\"points\\\\\\\":294,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":294,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/barack-obama\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Egypt\\\\\\\",\\\\\\\"points\\\\\\\":186,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":186,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/egypt\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:United_States\\\\\\\",\\\\\\\"points\\\\\\\":139,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":139,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/united-states\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:White_House\\\\\\\",\\\\\\\"points\\\\\\\":129,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":129,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/white-house-2\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\",\\\\\\\"points\\\\\\\":123,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":123,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\"}],\\\\\\\"items\\\\\\\":[{\\\\\\\"u\\\\\\\":\\\\\\\"2e88e31e-a379-3340-96cb-7c5d904edd46\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000349\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"999a3ee7-37dc-34bd-99a7-51b289bd05a6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001466\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6f4ca8cf-c412-35d3-853f-9ee636b92373\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000382\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"523fedde-cc12-38fb-86ca-60629888845c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001194\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"62787508-255a-3395-82ba-9e62e75cb0f0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000433\\\\\\\"},{\\\\\\\"u\\\\\\\":20637846,\\\\\\\"s\\\\\\\":\\\\\\\"Find Out Which Vehicles Get The Best Gas Mileage. See Our Top 10 Results for Cars, Trucks, and SUVs.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l3.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/cleansed\\\\\\\\\\\\/282855.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjVELgjAUhf.QArflmIwepmZYzhJmYm-WOpNZPQiivz418Rf0wTncyz2HCzEjRV5uKTUhuY9OSwZx-bAKYmUIAoMxhk2CIEYU8IkLbaPOSYj7tufd2Vay4z.UKFs5S27yvYtPWbac5cbW.C841pH7y-zPf5VLef55Nb2k9ho7RENYX.WtTo0gic2z5K2QnhZPWIVI9EGSDqKOTZH4MG08naq1uQPA-AJEmk55,http%3A%2F%2Fwww.autobytel.com%2Ftop-10-cars%2Fbest-gas-mileage-cars%2F%3Fid%3D32929\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Top 10 Best Gas Mileage Vehicles\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&YXUrx1B2wp0mtLPzqoY6SBX19zf_d1fuUh2uCCm1dTPwqs0S0Qu8QkmJ5NfR42PdwHTEqGDrCn9.oWfDlfrSrQV9aR0v8aA6sTO7zjH78dGCCdXgpV3wN13TJPUl3oQ1sHEdxry9iqESWj4icW870OMIuXuL3SUZh1.1NKi9flPyGcGsMOxzYKv3fit7oqYNRDlopuckdDxB5euHoLh780LMQ3aSPrQS8XNMD4KT1hMc7yCU5ew2q14XdcvGxWTUUbDICX_LXkAjfWt2Ozo7UyrIhNLCLdT2_V0XFdqBUKaCfItcIby82NI16YcWnR93TfzPET5tz7bKZk0FQbkNGynGlVYwBXBAkE28RIE6SuZriUd88o6PktAaF5RUUIhPCNGUSbkTjPokhmJIMT_wK3zIjoqQeQHZr1cheaT43QHDmtiKe7FNjERd1PiAGCeNriRZpKnkU8T3wc9MkBtKy54pf4Hw67K2bSDteWl6rjnwgp4h84r7e9vqdfFzzz3LsjxHA0NJJ9mpzN8k8nQdHUShQPauRd.xSngLQI.YYXI2DK1_CaostAQJNpXXKLX2NljGEBarONbTUuG9b8V03Pzr5ghWryMb39D.z5j3tWnn6IT.PhZ57JAvueKoabx0UcLob6NnyIf5o2jXgu2T55Kdya1II4.4Kc8lN1oR74WhvpUpm6XA5Bop1dkKs64UNTpcvIpmZeYpYRkoiwKp6A7Ehu4WyeKny4KU3JzbUllALSnPNg6rYxvAq9Xj5.WyHIpH66jJN4OnXZcaTvzVHYu3f64YU8hJZMeqLc5VwkjSL4N7fQcjeCN86RtVAzKU7A--&ap=29\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Autobytel\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8682b543-884b-33da-a257-f0d05e1a3dfa\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4089900406\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1733412d-c645-3dcc-898f-a3e6b23632c3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000563\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8cc97ab2-66d0-3bbb-8b6f-c20ba8d932c4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100614\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fa2d95f2-4e85-3cfa-aee0-d5b0c031529f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000730\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d344ace7-22fe-3cab-b829-5c23eb17e754\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001080\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1f76e13-0b85-3d35-ab05-1b263f119f5a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000881\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1099eb81-1582-311e-b36e-9a15c7f141e0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100517\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0827042a-7b69-3744-876a-e63bbaf67e6d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000368\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"61d9ae23-9b3a-343a-9309-6e2f3cf1dc01\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000292\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6e2cca72-5335-3ef9-8ebb-e93683d1ee71\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8fcb3d3-00f3-3804-b31c-d387f5b7c8e2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4047800515\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"cfa94c8c-28be-3510-b57a-00b7c3588ab9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000252\\\\\\\"},{\\\\\\\"u\\\\\\\":20626440,\\\\\\\"s\\\\\\\":\\\\\\\"Netflix members can watch as much as they want, anytime, anywhere, on nearly any Internet-connected screen. Only $7.99\\\\\\\\\\\\/mo. Sign up today.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l1.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/curated\\\\\\\\\\\\/202834-1366845045.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjV8LgjAUxb-QD25TmYwetlZiOUuYhL6Z.7LUhCRpnz418RP0g3O4l3sOFyBi5VlhYGwC6zo6LghARWrnlp1AoOmEEGRaECCINTpxxn0wUPfNn2zeHcOXA.1RjmLldslNvuPomCTLuX11Nf0LW.tA3WV2578lxzTr2uYjMVtjTqD8ezQIlRreJTRPkvZC7mtRgZsPhfIkqyIYKp8.hriJVByszY2m6V.IrU-S,https%3A%2F%2Fsignup.netflix.com%2F%3Fmqso%3D81003558\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Netflix Revolutionizes Movie and TV Watching\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&H_GrtUV2wp01Xake4rDZW0wnjkO9HDq9Hft_18s7_GQKOnACr9NTDkbmZcd.8xn27Yr78xtgxagH29RFPQHiT9A7nMsgkF4SrsuJqpF6KxW7.eQWongoNyNgHLeDjw4vSRYZrlUBbqUGCm.iOPMlvy9y_3xojQZqIGXt6Jg.ybv7ZLSp1_JPMeIfLHc5iM8r0_7ZJUd7fqcnRg_prZMHiKHR.jwshqf_VjsU2j1TIFMtXUTvnzYcOpDO7MW_xCKAZMy68GqTnEs6J.vHvhrmpCmqfGXWrTD3iBge8YiE1S8g852XJtEPojc1DerY7e2yE.l0E7FSHReDqaNNpvOwMcy7vo1FunkrG59tz4lj3AjHPadJKP32Lco_RUF6Xb..zZ3tHIkuFtD4YjMZnzeV0MQv1YzjZ5ZAl5tkvwMVt7An6YesaTeoTlzTDnFZ.ADi2.nBReH5UtEBqz.OznBlsij3VxguNsYLTFU40slVd14X9zP.M5YX_h3JE2OFuDlZcPA_hjDoThdSiZbY2bG0HP8a2d2JWNEwSkVE0gb7nlvFM5D6..pRnnliLUFuL5D9ppUOCS0UIqBPnuWgycSy3VmudQdtTZDmRKCwZDmD21IueaDDx_hb_yO_C4K9w6UTZZUZzT.ZzxQlBK_.fFsLOsWlWO3qZMtoydin4q7xcHimY61og12NomS5o2cCUvkLoZSWeYDMARou0oC9R_HlO3VYG4nN0ifgNXY.teQC6nbHjLBTw__xD_n2W.6uFZAe5PRB38HD6qumfhVfv6sjRn0GKNA_8CfhTSJVziFjUslwHQfCYfUaDNs.SZAH90eAJg--&ap=42\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Netflix\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5de020-1c28-3992-8b33-7759daa5e05e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000928\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5c9e6d6a-5127-3f87-b77f-6580cd62dfe4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000932\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"acfa2983-d731-3cbc-a0fc-2ff8ef78e075\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001366\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4d5a136-97d8-3124-8ac6-7c020235428f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24e6df26-628f-3a4c-9b98-b22275506fb9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081001304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4fd501c-2f37-3258-ae09-c23c728290ba\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600940\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0af9f27d-adfd-3b40-bdd2-8ff1b8643742\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4043000697\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1151a83-318e-34e2-a2c8-0fe169c1f900\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000233\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bfab8f88-77cf-3ace-b86a-80a4f5d25e89\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000483\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ed5c998c-1e32-3302-9d47-7f3957a1fc2f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4038700567\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"73beeae0-a4b3-384b-bf19-be60c1176c1b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600289\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5287b89f-b0f0-3dab-9197-aa22905eaf4b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000187\\\\\\\"},{\\\\\\\"u\\\\\\\":21713975,\\\\\\\"s\\\\\\\":\\\\\\\"Find out how this unexpected joint solution is helping Americans live happier, healthier lives after 50!\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l5.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/216216-1372864886-2128.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":61,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.344262295082}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjc0OgjAQhF-oB9ry06bxUH5ElBZJQAI3QgUxYEjEKD69AYlP4HfYmc3OZiBmRMdVrWrdJJZhUaoYxHVFzyYtEQIaYwwbJoIYEcBnjmSMnxyfvLu97Lv8kTb8y6x246y5eXouPpTlepZQDfwvOHTPg9UHS2.jEq6GWz8lxP7F.Pgtr.lL9ukUZqkRJXwUybYTLbxIJLQwK1qReTDyZSeTopXN73MDgPYBg-hOpw==,http%3A%2F%2Fwww.instaflex.com%2Freport%2Farticles.php%3Ft202id%3D512118%26t202kw%3Dysa_i_7\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"8 Simple Joint Ingredients You Won't Believe\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&ecK0Z552wp1CR9ucwuN9cJWH69Az.jMaEgh3CbTj0mKfA8.rh3WakEXcY5PfEj0lY0y3LUkCsSNz6c_t1sHSAKOb29yRFyNqTLfU3SUTNbQBQu0d87VGzVCE5uF5yA68dAHqPB2wnZmtGS5HgkBMaWq7GGkung.Fy.QaynZeOMJD2a0JLw8VAHokuVGgbR27cZI08RcvsDQUtzOVM0Q1xYAKyAGAdZJassqSq3Rrm07JNLwsHrwHDm.p0XkmjJOdzjhHpip8OU9zjaswukv6g_allIZuOBY.f6hTrgRDZNYjW6OXJPVInt2GxxZ15tE.jVF0Fw8ipQMgGkovqKnW2Qn9W.u_v6jfqwIpAIXwNYmeooflkXbiNn9WsTi0ba4Vpuc4.aoNx53jOjdAHXUKNgnxgUNWnDGWYKZ.H0_uSp7rhrKJfagCM.CPRL1sJbC2oL3kOjnzlwg0Hv21fYu4ttHK7sJI17e4nJeCoAjRPhmJ8a7U5zZ42PwEIxdJ_U7sLGCJBuoP2.s.pBsDOPpvzsHKZ5CTJaxtsFreN5b5QEUU7OlsKZ636zCz7smWU7AnmNeMQFG6w3InYqHF5NSNQtro7fZQXU9ygVpfM.xgR6fEdBIZJuq0RqMSR6eoF6v6Ob6i4h9Afx4zUje84fuAboMMJZrI8NNNeyTqFjVy5mIcfY16Vy9wpRnc9uxir4B_4qg_EUhIrUoO9Ecm5Fpvw3LOD02iFh7D11duypcfbysZGWC_7XLDX4CrTqcTDNQ7RsylfEgAWZvbPmP_afrexsbkNCCL7eK5PIBHBnPEonIyHVIj2_p90hKEpZkN3QIyGw--&ap=55\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Instaflex\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f87eaebd-5628-3ec6-b863-c404b0abcee4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001059\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d712ff7a-7042-30b9-8867-19b51ecb96d2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600236\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43b802f5-0558-39cc-9b76-348e3d40edc4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000174\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c7c72404-4eb8-3ea3-86b5-2657571ab856\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000427\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4519c9a6-1a8f-3d9f-bcd3-dc88fec5bc77\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001187\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"37b64b20-2ba3-31e1-9e02-418af076fcf5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000298\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"42fb1b39-704f-3677-9910-7a2681fc7182\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000148\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"586a9615-991d-3faf-9c7d-e7ff8179d511\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000368\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1725fbc9-413b-3fff-a0c5-60ec4702f7c2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000553\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"51aceae4-c48c-3955-bc3d-deabf73b0d4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001042\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0d92f3cd-9815-312a-abc3-79c0fa565d00\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4089900263\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ecaa77-69b8-38ea-9a81-866f52ad3b10\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900590\\\\\\\"},{\\\\\\\"u\\\\\\\":20950156,\\\\\\\"s\\\\\\\":\\\\\\\"Local auto dealers have begun cutting their prices for the summer.  If you're looking for a new car this season, buy now and save as much as ...\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l2.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/206635-1369234902-9746.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":80,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.025}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjt0KgkAQhV9oL9w.3WXpYlMrw90SVkTvQlOLjAjJ7OlLW3qCPjjDOcwMMxALRnBZVzVxmUc9zisBcV3yo8sPCAFHCIGpiyBGDMiJPeuTwVf3gC3nvGm5GeSX5qNl49u5qYYBeTwL2x8c2sm.4POtjKyP5rtNwGR1u3ajsX9NrJOXPudjbhSJs5TujOyVWV3UCbYaKRhnRaeMbnUQjtqko05-mwsAnDemLk7K,http%3A%2F%2Fpixel.autoaffiliatenetwork.com%2Fd%2F%3Fid%3D009%26adtargeting%3Dimage_Chrysler300_text_Summer2013%26dest%3DAPF\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Auto Dealers Cut Prices for Summer 2013\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&HZAOtg52wp2mLei3m1uAVwfuueZ2Sf7pQzA41g3fGSUnGKb7Oa2Clrrx.AZQ.wLbq5rGVbDhFQKVLTatBKM3qSrLhn5PX3S4k0QiUs36M40F1hFG55fy08t6NRxPatBALoQho.NI5BPHB1.pHZ6QycyfbQd5Juy0B.CTvIWP3XeNsVg0WxIVEj06ovFvFOfOSEIzdJEgObpMrQsQPRulPUrFsn8SidGM4jaeYvlGdJ5ycpHed0jeFvJcdECwVIlMcrQRNXeTkGhge8LsYmqhQiQa4U7uFFDgNcrAerua1eREjxKKAoD_.0niVaXVyKrjxouCRqHX1zXNmaLv.e_oRz7DS00yUdhaH.nZt0saFrBgKmGSdtGItxnCyDpZ_6LRvGJ3MHpnV7Xng1dXhBUVQ_SQLYe2dcEEqRWeWQIOi3HCrhSySo4lzpOOtnITWQEVkeRgbwNYeb4Bl43wnSKXnMX0AMppyIPkmAnjzfi2PypfqmF__JVxj_I1CWDwPySaXS_zJdbhT4plSrrW3hA4MA0h4Tkx1fFtFnlSifBIiV6eESruix.D2ge3XkVRdzq_34vh22wQ6xQ2qzvQhHJNJGuNFeJm5C5Zmmg7N7AO2OusU5gfdfrg1m.GoTH_WRPsSeXp7UwavSXCP8ZzP99cAP_oD_b9bze1DRtFGUYMMFCWhrClBptEFrzXGsZSKUmbTie_AttNW2BTl1S0ZNag8aPAW93FDYd5qzcvSJxQQeDpnPBIvoKv3Uvuf9Ed6KjW9vQIP6dFVIV4agn7e6wwoh2yokDspVKot5s8svNYTP7vF824nuEF3az1..DzWN_tGw--&ap=68\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Auto-Price-Finder.com\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"79d8986e-05fc-3cc3-89a2-85f7c4e1af91\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000130\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9cf878bf-6b71-312f-aae4-95d81bab2441\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001024\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1be2994f-2025-3f60-a257-3e7a48049747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081000572\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"07917df6-6478-34eb-ae87-785b8219824f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000139\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"de1a9017-c4fa-375a-ba6c-f3ffea663e3d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900198\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fccf2bde-bbc9-3aef-880e-ce36cae7f85a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001025\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcb60a92-a1a0-35d5-abcf-08f9f9117095\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500661\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7c28287a-cd26-3ecf-a193-d1775345c1b9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4080900424\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a39d803c-107e-3210-91b9-404f0f9f688c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600702\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9bf503a7-4f45-3294-9446-d57ed3fa0f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800382\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4302a7d-ee75-3d80-855f-de2dee077577\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900369\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"47b95c91-2def-3d3c-9b80-9fd816c94043\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001213\\\\\\\"},{\\\\\\\"u\\\\\\\":20802476,\\\\\\\"s\\\\\\\":\\\\\\\"A recently published study shows no long-term benefit from traditional glucosamine joint supplements. See the study results to learn more.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l3.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/ads\\\\\\\\\\\\/0-1368480943-1495.jpg\\\\\\\",\\\\\\\"width\\\\\\\":50,\\\\\\\"height\\\\\\\":75,\\\\\\\"orientation\\\\\\\":\\\\\\\"portrait\\\\\\\",\\\\\\\"ratio\\\\\\\":0.66666666666667}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjd8KgjAYxV.IC7e5MRldTC1RnLaYSN75JzUtCbIin740qRfoB-fjHL4DByBmVACjMocwNwjNSsIAqgrzQMwMIk1njCFMIECQanxiSwf5sK.ZqFtz9uU95gv1W1ZtL73prh0c3bj8vOWu6flfsE2fe4v35t3aoby89Oenota35soxbPdj6oZNkMQ4UnwQanMSR9CEUMBAFUjAtBNth6MkRuI3sNI0.QW5Wk5w,http%3A%2F%2Fwww.naturaljoint.org\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Studies Show No Long-Term Benefit From Glucosamine\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&vyQeMJp2wp1TqMGS9HGgzM2gyC2iQTdNXyAobMbwzpZ1cqM3anOKsBNh3xmOca9DzPnAObH0NzsEcFTi6j6sp.qSUnyRS.HFExV7X0xa_VUqmVqwUqaq0YnkyFJzNIL6GQ04yLGzI1MEloEpdK7yKQgsGXoap6fcA_DsiEyAeYyKvtjXZXQoGhJBv1ym.dWSuy1aj.xFohSScuXXZXwIhGYLQzr61C1zbW8WmrTQM68Dc7jxOSmvbwNd3qcvZq5SXaSYyI1Cm25k.BwwuizeATIQB.Q26qML1.THT3mT3NfnFXUUAOkc6eYTxkhCAjpZkocPR4sw_zj9W1.WUifx5RZKo4tKHGZXfmq6cch.tfXVBuG69JsBEBFC9tPpjGA4UojAyt.4jfDUBmhl2_xBbylBqyD7ElNNy9P4wDFnnvej.5jLYmScVmxjcr52.NRwOB56LfSTTmA1wvLmt1nYnJNRyTxd.MBVXVkZFjgzSx2B6DxvIEQ.mOIALnnFAw4BEa5ZLtj5aOzTcA1A9EhifA49lTxlsX5LPjzVP1F9.KWPFnJlg7KK3lkjcVp0nW_eLtF1DSoLzew2CtKxC4pY0N6N1VSm76wgm3V94ALFVoqzsCaWnYv5kXCIt.ZL9Nv0b9obXoPwF4VOU.XoqECWrUjoizNYm2DY_KatB2AvINE5wduA9m05OemaTHnSnVDM2Zo8Q40e2tYFknLlQWz4wdtHDPiSnAq2mx4meIuza49c48KL1Jd9zmNFPYZBcr3Ysjl7KUXYQBi8MqG9NpTnRSihgN7tz.SuyvRDzasYQO64s_kv4p1OU2HPhNwNp6dsHg--&ap=81\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Greek Island Labs\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ed583ae-67ff-3853-aaf1-86901581ce2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000198\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"dacd78e7-9feb-3a5b-93da-4671482229b2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4038700258\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8f518ad0-4b6e-34f0-97b0-81fcf08ebaea\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100205\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4832980c-2037-3392-b43e-846739d2a79e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001064\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a34e541-0403-3e59-b0d0-f0fb28666525\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800412\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4bebef1-c728-3d5b-9f21-cee351d0c35a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800420\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e771ab9e-bef4-36f0-a1f6-745e13c58aa4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100169\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4bb5d47-7633-3c34-83d5-0612bbb1da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4031300338\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"365f8ec3-3449-3292-bedd-b8525ea07a98\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100420\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ade7515b-f561-356b-810d-457e63632c09\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000960\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"81e651ea-58d5-34ac-8d57-fb424d7b24a0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800309\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"87c2b200-aa22-3ecf-99d6-72a7c6012b2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4028200219\\\\\\\"},{\\\\\\\"u\\\\\\\":21068314,\\\\\\\"s\\\\\\\":\\\\\\\"Brain games are clinically proven to improve memory, attention and IQ. Harness your brain's neuroplasticity and train your way to a brighter life.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l3.yimg.com\\\\\\\\\\\\/av\\\\\\\\\\\\/moneyball\\\\\\\\\\\\/curated\\\\\\\\\\\\/171155-1366394442.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/clk?3,eJytjcsOgjAQRX-oC9pCU9K4KA8NClWSIsFdkZePIgsiwa83IOELPIu5dzJ3ciFmZgUtXOQI5SahqiAM4upql8RWCAODMYYtgiBGFPCJE-3jgavy4TvzHr7eSc1.TOrU7pKbpu.hg1LLuYVNx.-Ca-95sPhg7q09youu1aOkzhrbxR9xz2AkkzFME-soeR.J7TO6wUagCIep0JkUWuhgEOm5ucTr5wYA4wvnbU8y,https%3A%2F%2Fwww.lumosity.com%2Flanding%3Frefer%3D4650\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Scientific Brain Teasers\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/ad.yieldmanager.com\\\\\\\\\\\\/csc?ve=2&Qx70NEd2wp2ZoPPJFdVWlOwvYaKIhuuuNzks6FYjpLHr0eDHXuoBr_wwBqFSFvIhCzuzzs15xG76JDw7FQHLUroh.L6bKEP3dXmjsgEsy1jKRzqdSR3CP7Q9QE335dSrT1uU0bMjIFEXihdJKDV0PUA2tW6gE4jkS4CyfFuVSG8rapiobMXGxTgwQMweYjWetCWPUIAz_qF2oQ50VM.YhUqXsG2qSLiKVe8mOgej6d5j1xBbBXTxjA7i0hdJHL9wOmXAnLFc5gfoDkYwMHkdD6hnmxcTULDYkqCjmA_kxYXc_B0B1I35.mKGKdK0DtIk..LH3VJm5gps97UygZYQ3lF_nIEgr1PBG0HvlQ8Yw4XZrMervZt6_xdtryXKn9qiH.NEz6_TFYCF0jwwnEDG3Lihjo2R.RJ5uKWnm_iINGqk7NT0FBGZioEkIYmR9XRoElzke2v01TFH1cCBPq1sQOfN7FOr.XGN1TyQ8RAPKmQ3K9Vnqgh.5T8MOGxe0L4xrs_kfYb4j96PF9CBKOPwMF8O6yi_MhD226m21Bk3v2Ba0kOqdvZtmtpsD13WX4Bn6QdBJbI4KoWbblreD42yhcLz6Z4OmqytL.kf4d1mDFzXvpqxzxBQL0VGjalP32E6gX6pDYGG2TQqwAjhbuuX8DHAl4nSDzWwdQzrl4ocYZ0i5GEd5Yte6YyBu3WGI72XjtkLl.MTU.q3NvWqqtSw3yE_sv2_DfwBSN3g_PTJqWr8GHxElBXNzyMzuKwEICQFtNFdPgn.pTFuXVhQB1_Q3DLKSpmX.nFY3NjgTSoObGZhrg4y7N1zIZGKp9yIlZSAWA--&ap=94\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Lumosity\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"840f9c6d-87ba-3b2d-aa1a-3c3c4b7a5a4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800271\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7ac0b3f5-9a41-3595-85e7-b394b8f49b28\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4028200208\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"036f4818-5282-3896-a7c0-e03a87689ca5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4016600298\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"77d99ad3-23b2-31a4-9d15-beda9147cf9e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001038\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d443a8ca-9d9d-3adf-aaaf-00d01aee0747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4025400497\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6721eeda-5e99-3b9e-85b2-ad4f1a29ffa3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000414\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ffe28b2-6ff5-3f89-87b3-73f90aab3ce0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500221\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5405616f-5db9-3cf0-b76d-6c0ae86b8d0e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4013500777\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8f5bb9e-a7fa-3ddc-a3ed-5984194e14d1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500418\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0224f7db-6b78-37eb-bb13-96c734c79645\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001084\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"64a0f5e9-826f-30c1-b87a-cdd14e8f044b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500216\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"716a86c2-e772-3b80-ba2f-37ed8ecda763\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100274\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3b06a203-610c-3a58-8024-a51b661e896b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001004\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4398511d-e0b9-3bcc-b8d7-8c927257da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500168\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fab07708-6eec-331c-a049-53f865291f9b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100260\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"55836cbc-0d5c-3fbe-b9bf-13bdbb891e66\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005302076\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"34c6686d-577e-34a0-bb2b-887d9b40d3f5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000353\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45888b8f-3460-3aa1-9a52-2dfe51afff60\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000940\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8528082-d943-35fc-af50-14e4c1f8180e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4013500173\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8c76553-0434-33b6-b68c-a39e35bba1bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100172\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"95cbd68e-ffcb-3da5-8dfd-436af201ec90\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4008800347\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a8ef146-eaf8-30f1-ab7f-bab556ede552\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000412\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"733bf5ee-6160-3040-82d5-1d2f42636f8b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000874\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"90742b99-96f2-38a3-9ad1-f55b2620aaee\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000161\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2ad2eb07-5b9c-307c-b9ff-bcb3aa6bf5b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009000166\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5e4a50-d8ef-386f-b1e6-e25cdf7f287a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009800153\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f8528bff-bebc-36e9-9e88-cc513c0787c6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000869\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"83795d21-e026-38af-b60b-62dc9facb361\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100533\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005900268\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5dc7227d-d4a6-352f-8649-0db6aa60341d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100507\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ab26f4-4d85-34de-9900-e8fb300fc296\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000965\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f784f21c-dea8-3214-a2bd-4448415496ff\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800193\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2efae028-b5e0-39a5-980b-7c19ab0f0244\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007900189\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9db1ef8a-a304-3fa9-9e1c-b465e737c544\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700714\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a47ca09-04b3-337f-b6ff-583211b66950\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005200180\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0bb3174a-3588-3c95-a547-6c0cb658a1c0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100520\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b40c8d61-0cfc-365c-919f-dc77294f18e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700201\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a63cf34e-c218-3e8d-892b-0bbc6156f9d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001051\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"929877e0-37bb-39dd-9bee-f9e8bbe00dc9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4006400154\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4153a74c-4462-3ee0-bc00-dff34f2d850f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800351\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"09c0d581-8f4f-3555-871e-31a0b18a7951\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000915\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6c039a5e-146d-3da8-812c-fb6d65e19f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004200467\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"973d19f5-0a84-333c-b992-8eeedd738f43\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005200127\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"97231cf5-bb20-3ff0-802b-a452829f1fa8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003400209\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7e9aea73-f2a9-3a22-bbf3-d6e29ae9fe19\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003400180\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3d28a848-ba81-36fe-9887-29f619d7ccf4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001600320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1216abdc-0bc1-3b4c-b978-4c4d848a26bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4002500171\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9e07f5b8-ae97-3c06-9843-1beaf8ff297e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000934\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45860a48-cd9e-3f22-b47b-d286f2110b6a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000400828\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5ba9c757-db40-3d11-bf39-ae7cc0a41761\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001400426\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f540de91-027a-3001-8280-5af27c52c12c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000300505\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fe72c946-5768-3657-aaa1-d0c92ed812b4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200523\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e2b6485f-3de9-3bba-85da-4ddb382a056f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001019\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2f6fa4bf-7163-3097-962e-5dbd610c2c21\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200359\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24f5c185-57dc-37e7-8698-dd1838bda8a4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200733\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db030f8d-4a11-31e4-86e4-cb8f0f8aaf82\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000891\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7940011d-7d91-3045-a1aa-eeecfdd0450c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100312\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1d1e6988-fd19-36ec-a633-a290e04d1bab\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100441\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3c1b56c7-a888-3532-8f69-823389ab58d7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200152\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"12577891-fe2e-3bf6-8872-48283cc99542\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100230\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bd973d04-cffe-3617-bc91-64631e02e263\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ca67350-b65a-3884-b411-df6018ebbf14\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000837\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e115e1c2-e6e7-34b5-8725-65647725e6f3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000216\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3184a818-422d-31fa-b2ca-3fc25f1e8306\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d0d8429-ce92-3d20-96df-8dcdc20a1185\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000347\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"da3fd914-a729-3606-93ce-58d974416a92\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000246\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2382e5e0-34c2-3019-9bc1-dd64411f42b6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000828\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ebe271cf-d612-3d45-8886-03aeb92bb7cd\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000362\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6ae66b10-fc06-31ad-bdce-f630dab5f4fc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000303\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"979f41be-1edc-32f5-ac09-17715c88e294\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8ca681e-2bfb-3e08-b33f-0d41e9916217\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000292\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d9a55b19-9a27-3da5-b16b-c6f245fbc386\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000131\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d198649-3883-3f02-a39f-33e7c6ac21f8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000155\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"933524d2-947f-3f9c-aeae-a5a45b0619b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065601206\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ec09f8e-84c3-3934-b092-39cb092d10a2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000509\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcc8c90a-e9a3-3d4d-b0c6-80066b5a761a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001012\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000002190\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0d02e61e-1b5e-3a00-8a69-ebbd5627e76b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000588\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c96bd902-72ef-3422-a162-bb80c37028e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000206\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"44f44e84-8894-3136-b6fc-efb8b7c77f84\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000239\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"408b827f-4639-3495-bbc5-33698c6a3bc7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000560\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2bcd2824-1695-3c99-afeb-5964e993f1f6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000829\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bcd13eef-3b76-3eb8-b13e-66e0a2432378\\\\\\\",\\\\\\\"flbk\\\\\\\":true},{\\\\\\\"u\\\\\\\":\\\\\\\"cf8c7775-d027-3207-af8c-86bffe8db6fe\\\\\\\",\\\\\\\"flbk\\\\\\\":true},{\\\\\\\"u\\\\\\\":\\\\\\\"3c63b3a1-1f89-3ac8-bbba-ca7b82d3f780\\\\\\\",\\\\\\\"flbk\\\\\\\":true}],\\\\\\\"contentpos\\\\\\\":22,\\\\\\\"interestsData\\\\\\\":{\\\\\\\"YCT:001000667\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/crime-and-justice\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000780\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"count\\\\\\\":164,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/society-and-culture\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"count\\\\\\\":123,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000346\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Personal Investing Ideas & Strategies\\\\\\\",\\\\\\\"count\\\\\\\":48,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/personal-investing-ideas-and-strategies\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000992\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Transportation\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/transportation\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000395\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Health\\\\\\\",\\\\\\\"count\\\\\\\":170,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/health\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000495\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Family Health\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/family-health\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000661\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"count\\\\\\\":161,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/politics-and-government\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000680\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Foreign Policy\\\\\\\",\\\\\\\"count\\\\\\\":38,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/foreign-policy\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":294,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/barack-obama\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Mohamed Morsi\\\\\\\",\\\\\\\"count\\\\\\\":90,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/mohamed-morsi\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Egypt\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"count\\\\\\\":186,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/egypt\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"count\\\\\\\":139,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/united-states\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Hosni Mubarak\\\\\\\",\\\\\\\"count\\\\\\\":37,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/hosni-mubarak\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Cairo\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Cairo\\\\\\\",\\\\\\\"count\\\\\\\":6,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/cairo\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000069\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Celebrities\\\\\\\",\\\\\\\"count\\\\\\\":86,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/celebrities\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000070\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Royal Families\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/royal-families-2\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Prince_Harry_of_Wales\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Prince Harry of Wales\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/prince-harry-of-wales\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Kensington_Palace\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Kensington Palace\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/kensington-palace\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000700\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration Issues\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/immigration-issues\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Culture_of_the_United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Culture of the United States\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/culture-of-the-united-states\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000267\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"count\\\\\\\":45,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/education\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000269\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Schools\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/schools\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Elementary_school\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Elementary school\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/elementary-school\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Ink_cartridge\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Ink cartridge\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/ink-cartridge\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Immigration_reform\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration reform\\\\\\\",\\\\\\\"count\\\\\\\":32,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/immigration-reform\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000705\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Military\\\\\\\",\\\\\\\"count\\\\\\\":53,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/military-and-defense\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Unmanned_aerial_vehicle\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Unmanned aerial vehicle\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/unmanned-aerial-vehicle\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Aircraft_carrier\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Aircraft carrier\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/aircraft-carrier\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patuxent_River\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patuxent River\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/patuxent-river\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000123\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Business\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/business\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Panera_Bread\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Panera Bread\\\\\\\",\\\\\\\"count\\\\\\\":11,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/panera-bread\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:National_Security_Agency\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"National Security Agency\\\\\\\",\\\\\\\"count\\\\\\\":61,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/national-security-agency\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:California\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"California\\\\\\\",\\\\\\\"count\\\\\\\":74,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/california\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Solitary_confinement\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Solitary confinement\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/solitary-confinement\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Bob_McDonnell\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Bob McDonnell\\\\\\\",\\\\\\\"count\\\\\\\":3,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/bob-mcdonnell\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Governor_of_Virginia\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Governor of Virginia\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/governor-of-virginia\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000804\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Religion\\\\\\\",\\\\\\\"count\\\\\\\":30,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/religion-and-beliefs\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Southern_Baptist_Convention\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Southern Baptist Convention\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/southern-baptist-convention\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000681\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Government\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/government\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:White_House\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"count\\\\\\\":129,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/white-house-2\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Presidency of Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":45,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/www.yahoo.com\\\\\\\\\\\\/topic\\\\\\\\\\\\/presidency-of-barack-obama\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patient Protection and Affordable Care Act\\\\\\\",\\\\\\\"count\\\\\\\":32,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/patient-protection-and-affordable-care-act\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000031\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Arts & Entertainment\\\\\\\",\\\\\\\"count\\\\\\\":170,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/arts-and-entertainment\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000076\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Movies\\\\\\\",\\\\\\\"count\\\\\\\":170,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/news.yahoo.com\\\\\\\\\\\\/movies\\\\\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1}},\\\\\\\"ccode\\\\\\\":\\\\\\\"news\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_stream\\\\\\\",\\\\\\\"trusted\\\\\\\":true,\\\\\\\"type\\\\\\\":\\\\\\\"stream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345786\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.LOADING\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\u003ELoad more stories\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\\\\"STR.LOADING.CONTENT\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"loading next-batch\\\\\\\\\\\\\\\" data-key=\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\u003ELoad more stories&hellip;\\u003C\\\\\\\\\\\\/div\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\\\\"STR.BUTTON.REMOVE_DONE\\\\\\\":\\\\\\\"\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs remove-done uibutton rapid-noclick-resp\\\\\\\\\\\\\\\"\\u003EDone\\u003C\\\\\\\\\\\\/button\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.CONFIRM\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"STR.BUTTON.WIKIID\\\\\\\":\\\\\\\"\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs wikiid uibutton rapid-noclick-resp {selected}\\\\\\\\\\\\\\\" data-wikiid=\\\\\\\\\\\\\\\"{id}\\\\\\\\\\\\\\\" data-interesttype=\\\\\\\\\\\\\\\"{type}\\\\\\\\\\\\\\\"\\u003E{name}\\u003Cspan class=\\\\\\\\\\\\\\\"d-ib img-sprite remove-neg\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\u003C\\\\\\\\\\\\/button\\u003E\\\\\\\",\\\\\\\"STR.SHOW.LESS\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"show-less fz-xs\\\\\\\\\\\\\\\"\\u003EShow me fewer stories about:\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.MENU\\\\\\\":\\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"menu\\\\\\\\\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xs undo rapid-noclick-resp\\\\\\\\\\\\\\\"\\u003EUndo\\u003C\\\\\\\\\\\\/button\\u003E\\u003Cp class=\\\\\\\\\\\\\\\"title fz-xs\\\\\\\\\\\\\\\"\\u003EStory removed\\u003C\\\\\\\\\\\\/p\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"remove-menu-main cf\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"login hidden\\\\\\\\\\\\\\\"\\u003E\\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_b27\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_default\\\\\\\\\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_b27-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd type_login type_login_default\\\\\\\\\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"embed\\\\\\\\\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\\\\\\\\\"title mb-l\\\\\\\\\\\\\\\"\\u003ESign in to save your preferences:\\u003C\\\\\\\\\\\\/h3\\u003E\\u003Cdiv class=\\\\\\\\\\\\\\\"btns fz-xs\\\\\\\\\\\\\\\"\\u003E\\u003Ca class=\\\\\\\\\\\\\\\"login-svc ylogin login-btn-purple rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"https:\\\\\\\\\\\\/\\\\\\\\\\\\/login.yahoo.com\\\\\\\\\\\\/config\\\\\\\\\\\\/login?.src=fpctx&.intl=us\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-yh;itc:0;cat:;\\\\\\\\\\\\\\\"\\u003E\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite y-icon\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/i\\u003EYahoo!\\u003C\\\\\\\\\\\\/a\\u003E \\u003Cspan class=\\\\\\\\\\\\\\\"login-or d-ib\\\\\\\\\\\\\\\"\\u003Eor\\u003C\\\\\\\\\\\\/span\\u003E \\u003Cspan class=\\\\\\\\\\\\\\\"fb-button-wrapper d-ib\\\\\\\\\\\\\\\"\\u003E\\u003Ca class=\\\\\\\\\\\\\\\"login-svc fblogin login-btn-fbblue rapidnofollow rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/open.login.yahoo.net\\\\\\\\\\\\/openid\\\\\\\\\\\\/yrp\\\\\\\\\\\\/hr_signin?.intl=us&idp=facebook&ts=1373481900&rpcrumb=opO.PAXz7D8&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-fb;cat:;\\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\\"\\u003E\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite fb-icon\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/i\\u003EFacebook\\u003C\\\\\\\\\\\\/a\\u003E\\u003Cspan class=\\\\\\\\\\\\\\\"fb-disclaimer narrow-disclaimer fz-xxs\\\\\\\\\\\\\\\"\\u003EWe don't post anything without your permission.\\u003C\\\\\\\\\\\\/span\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\u003C\\\\\\\\\\\\/div\\u003E    \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\\n\\u003C\\\\\\\\\\\\/div\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\u003Ca class=\\\\\\\\\\\\\\\"profile-link d-ib rapid-noclick-resp fz-xs dn\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/profile.yahoo.com\\\\\\\\\\\\/y\\\\\\\\\\\\/settings\\\\\\\\\\\\/interests\\\\\\\\\\\\/\\\\\\\\\\\\\\\"\\u003EEdit content preferences\\u003C\\\\\\\\\\\\/a\\u003E\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"props\\\\\\\":{\\\\\\\"trusted\\\\\\\":true,\\\\\\\"id\\\\\\\":\\\\\\\"p_30345810_fcd\\\\\\\",\\\\\\\"type\\\\\\\":\\\\\\\"fstream\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_fstream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345810\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"data\\\\\\\":{\\\\\\\"dropdownHover\\\\\\\":true,\\\\\\\"dynamicMax\\\\\\\":0,\\\\\\\"filterRestoreEnabled\\\\\\\":false,\\\\\\\"dropdownFilter\\\\\\\":false,\\\\\\\"tabFilter\\\\\\\":true,\\\\\\\"autoHideEnabled\\\\\\\":true,\\\\\\\"recentFiltersEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"swipeFilterEnabled\\\\\\\":false,\\\\\\\"filterFontSize\\\\\\\":\\\\\\\"fz-s\\\\\\\"},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.FILTERS.FILTERBY\\\\\\\":\\\\\\\"Filter by\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"prefs\\\\\\\":{\\\\\\\"isc\\\\\\\":0,\\\\\\\"_mc\\\\\\\":0}}]}]}],\\\\\\\"res\\\\\\\":{\\\\\\\"css\\\\\\\":{\\\\\\\"helpers_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/ui\\\\\\\\\\\\/helpers_0.0.6.css\\\\\\\",\\\\\\\"typography_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/ui\\\\\\\\\\\\/typography_0.0.2.css\\\\\\\",\\\\\\\"theme_default_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/theme\\\\\\\\\\\\/default\\\\\\\\\\\\/common_0.0.29.css\\\\\\\",\\\\\\\"theme_default_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/theme\\\\\\\\\\\\/default\\\\\\\\\\\\/desktop_0.0.62.css\\\\\\\",\\\\\\\"tooltip_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/tooltip_service_1.0.12.css\\\\\\\",\\\\\\\"type_stream_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/stream_0.0.271.css\\\\\\\",\\\\\\\"theme_gs_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/theme_gs_0.0.45.css\\\\\\\",\\\\\\\"login_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/login_service_0.0.3.css\\\\\\\",\\\\\\\"rmx_ads_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/rmx_ads_0.0.8.css\\\\\\\",\\\\\\\"type_fstream_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/fstream\\\\\\\\\\\\/fstream_desktop_0.0.21.css\\\\\\\",\\\\\\\"type_login_css\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/login\\\\\\\\\\\\/login_0.0.71.css\\\\\\\"},\\\\\\\"js\\\\\\\":{\\\\\\\"oop\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/oop_3.8.1.js\\\\\\\",\\\\\\\"event-custom-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-custom-base_3.8.1.js\\\\\\\",\\\\\\\"event-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-base_3.8.1.js\\\\\\\",\\\\\\\"io-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/io-base_3.8.1.js\\\\\\\",\\\\\\\"json-parse\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/json-parse_3.8.1.js\\\\\\\",\\\\\\\"json-stringify\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/json-stringify_3.8.1.js\\\\\\\",\\\\\\\"cookie\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/cookie_3.8.1.js\\\\\\\",\\\\\\\"jsonp\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/jsonp_3.8.1.js\\\\\\\",\\\\\\\"dom-core\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-core_3.8.1.js\\\\\\\",\\\\\\\"dom-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-base_3.8.1.js\\\\\\\",\\\\\\\"dom-style\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-style_3.8.1.js\\\\\\\",\\\\\\\"selector-native\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector-native_3.8.1.js\\\\\\\",\\\\\\\"selector\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector_3.8.1.js\\\\\\\",\\\\\\\"node-core\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-core_3.8.1.js\\\\\\\",\\\\\\\"node-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-base_3.8.1.js\\\\\\\",\\\\\\\"node-style\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-style_3.8.1.js\\\\\\\",\\\\\\\"transition\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/transition_3.8.2.js\\\\\\\",\\\\\\\"selector-css2\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector-css2_3.8.1.js\\\\\\\",\\\\\\\"selector-css3\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/selector-css3_3.8.1.js\\\\\\\",\\\\\\\"event-custom-complex\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-custom-complex_3.8.1.js\\\\\\\",\\\\\\\"event-synthetic\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-synthetic_3.8.1.js\\\\\\\",\\\\\\\"event-focus\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-focus_3.8.1.js\\\\\\\",\\\\\\\"event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/event-delegate_3.8.1.js\\\\\\\",\\\\\\\"node-event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-event-delegate_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-base\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/pluginhost-base_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-config\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/pluginhost-config_3.8.1.js\\\\\\\",\\\\\\\"node-pluginhost\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-pluginhost_3.8.1.js\\\\\\\",\\\\\\\"dom-screen\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/dom-screen_3.8.1.js\\\\\\\",\\\\\\\"node-screen\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/node-screen_3.8.1.js\\\\\\\",\\\\\\\"gallery-storage-lite\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/yui\\\\\\\\\\\\/gallery-storage-lite_3.8.1.js\\\\\\\",\\\\\\\"module_platform\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/module_platform_1.1.14.js\\\\\\\",\\\\\\\"resourcemgr\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/resourcemgr_1.1.14.js\\\\\\\",\\\\\\\"transport\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/dali_transport_1.1.34.js\\\\\\\",\\\\\\\"metro_ext\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/metro_dali_1.0.27.js\\\\\\\",\\\\\\\"module_api\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/module_api_1.1.16.js\\\\\\\",\\\\\\\"yui_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/dali\\\\\\\\\\\\/yui_service_0.1.17.js\\\\\\\",\\\\\\\"metro_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/metro_viewtype_0.1.24.js\\\\\\\",\\\\\\\"default_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/default_viewtype_0.1.61.js\\\\\\\",\\\\\\\"edit_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/edit_viewtype_0.1.40.js\\\\\\\",\\\\\\\"ylc\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uicontrib\\\\\\\\\\\\/ylc_1.8.22.js\\\\\\\",\\\\\\\"instrumentation_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/instrumentation_service_0.1.83.js\\\\\\\",\\\\\\\"userinfo_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/userinfo_service_0.1.15.js\\\\\\\",\\\\\\\"statemgr_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/statemgr_service_0.1.20.js\\\\\\\",\\\\\\\"metrologger_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/metrologger_service_0.1.18.js\\\\\\\",\\\\\\\"tooltip_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/tooltip_service_0.1.56.js\\\\\\\",\\\\\\\"autohide_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/autohide_service_0.1.15.js\\\\\\\",\\\\\\\"badge\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro2\\\\\\\\\\\\/g\\\\\\\\\\\\/badge\\\\\\\\\\\\/badge_0.1.20.js\\\\\\\",\\\\\\\"type_stream\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/stream\\\\\\\\\\\\/stream_0.0.456.js\\\\\\\",\\\\\\\"storage_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/storage_service_0.0.1.js\\\\\\\",\\\\\\\"login_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/login_service_0.0.38.js\\\\\\\",\\\\\\\"interests_service\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/uiplugins\\\\\\\\\\\\/interests_service_0.1.1.js\\\\\\\",\\\\\\\"type_fstream\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/fstream\\\\\\\\\\\\/fstream_0.0.95.js\\\\\\\",\\\\\\\"type_login\\\\\\\":\\\\\\\"http:\\\\\\\\\\\\/\\\\\\\\\\\\/l.yimg.com\\\\\\\\\\\\/nn\\\\\\\\\\\\/lib\\\\\\\\\\\\/metro\\\\\\\\\\\\/g\\\\\\\\\\\\/login\\\\\\\\\\\\/login_0.0.32.js\\\\\\\"}}};\\\\n}()\\\\n);\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n\\u003Cscript type=\\\\\\\"text\\\\/javascript\\\\\\\"\\u003E\\\\n(function(){\\\\n    YUI.add(\\\\\\\"metro_config\\\\\\\", function(Y){\\\\n        \\\\/\\\\/ until dali defaults this\\\\n\\\\n        Y.mix(Y.dali.config.props, {\\\\n            libRoot: \\\\\\\"\\\\\\\",\\\\n            user : \\\\\\\"\\\\\\\",\\\\n            ultSpaceId : \\\\\\\"2023538075\\\\\\\",\\\\n            ultBeaconHost : \\\\\\\"\\\\\\\\\\\\/p.gif\\\\\\\",\\\\n            modChromeHtml : \\\\\\\"\\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_error\\\\\\\\\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd  _error\\\\\\\\\\\\\\\"\\u003E{html}    \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\\n\\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            modErrorHtml : \\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\u003E\\\\\\\\n                \\u003Cspan class='icon' style='background-image:url({img});_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop src=\\\\\\\\\\\\\\\"{img}\\\\\\\\\\\\\\\"); _background-image:none;'\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\u003Cspan class='shadow'\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\\\\\\\n                \\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E\\\\\\\\\\\\\\\"{name}\\\\\\\\\\\\\\\" encountered a problem while trying to load\\u003C\\\\\\\\\\\\/h3\\u003E\\\\\\\\n                \\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E{message}\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n                                \\u003Cp class=\\\\\\\\\\\\\\\"oops oops-link\\\\\\\\\\\\\\\"\\u003EOr visit \\u003Ca href=\\\\\\\\\\\\\\\"{url}\\\\\\\\\\\\\\\"\\u003E{url}\\u003C\\\\\\\\\\\\/a\\u003E\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n            \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            crumbErrorHtml : \\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\u003E\\\\\\\\n                \\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\\\\\\\n                \\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\\\\\\\\\/h3\\u003E\\\\\\\\n                \\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E2048\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n                \\\\\\\\n            \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            cookieErrorHtml : \\\\\\\"\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\u003E\\\\\\\\n                \\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\u003E\\u003C\\\\\\\\\\\\/span\\u003E\\\\\\\\n                \\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\\\\\\\\\/h3\\u003E\\\\\\\\n                \\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\u003E16384\\u003C\\\\\\\\\\\\/p\\u003E\\\\\\\\n                \\\\\\\\n            \\u003C\\\\\\\\\\\\/div\\u003E\\\\\\\",\\\\n            proxyTimeout : 15000,\\\\n            proxyUrl : '\\\\/hjs',\\\\n            intl : \\\\\\\"us\\\\\\\",\\\\n            \\\\\\\"ywa.rapid.enabled\\\\\\\": true\\\\n        });\\\\n    });\\\\n\\\\n    var i, len, url, match, modules,\\\\n        allScripts = YUI.presentation.lazyScriptList,\\\\n        comboRoot = 'http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?',\\\\n        isCombo =  allScripts[0].indexOf(comboRoot) === 0,\\\\n        yuiMods = ['metro_config'],\\\\n        lazyScripts = [];\\\\n\\\\n    if (isCombo) {\\\\n        for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\\\n            url = allScripts[i].replace(comboRoot, '');\\\\n            allScripts = allScripts.concat(url.split('&'));\\\\n        }\\\\n        allScripts = allScripts.slice(len);\\\\n    }\\\\n\\\\n    for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\\\n        url = allScripts[i];\\\\n        match = url.match(\\\\/\\\\\\\\\\\\/yui\\\\\\\\\\\\/([^._]*)\\\\/);\\\\n        if (match && match.length \\u003E 1) {\\\\n            yuiMods.push(match[1]);\\\\n        } else {\\\\n            lazyScripts.push(url);\\\\n        }\\\\n    }\\\\n\\\\n    if (isCombo) {\\\\n        lazyScripts = [comboRoot + lazyScripts.join('&')];\\\\n    }\\\\n\\\\n    if (YMedia.ModulePlatform) {\\\\n        modules = YMedia.ModulePlatform.getModules();\\\\n        YMedia.ModulePlatform.stop(modules);\\\\n        YMedia.each(modules, YMedia.ModulePlatform.unregisterModule);\\\\n    }\\\\n    YMedia.use(yuiMods, function (Y) {\\\\n        Y.dali.config.debug = false;\\\\n        Y.Get.script(lazyScripts, { onSuccess: function(){\\\\n            Y.use(\\\\\\\"*\\\\\\\", function (Y) {\\\\n                Y.ModulePlatform.init(Y.dali.config, true);\\\\n            });\\\\n        }});\\\\n        var rapid = YMedia ? YMedia.rapid : null,\\\\n            id = 'p_30345786',\\\\n            container = Y.one('#' + id);\\\\n        if (rapid && container) {\\\\n            if (rapid.isModuleTracked(id)) {\\\\n                rapid.refreshModule(id);\\\\n            } else {\\\\n                rapid.addModules(id);\\\\n            }\\\\n        }\\\\n        if (container) {\\\\n            container.addClass('jsenabled');\\\\n        }\\\\n    });\\\\n\\\\n})();\\\\n\\u003C\\\\/script\\u003E\\\\n\\\\n--dali-response-split-51ddabac509b3--\\\"});});\\u003C/script\\u003E\\u003C!-- hdf84.fp.gq1.yahoo.com compressed Wed Jul 10 18:45:00 UTC 2013 --\\u003E\\n\\n\\n\\t\\t\\u003Cscript language=\\\"javascript\\\"\\u003E\\n\\t\\t\\nYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-request-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/request-manager-min-1334113.js\\\"},\\\"media-content-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/content-manager-min-1331468.js\\\"},\\\"media-perf-timeable\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/perf-timeable-min-1191658.js\\\"},\\\"media-ad-controller\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/ad-controller-min-1334238.js\\\"},\\\"media-pane-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/pane-manager-min-1343260.js\\\"},\\\"media-next-scroll\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/next-scroll-min-1304262.js\\\"},\\\"media-tag-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/tag-manager-min-1294559.js\\\"},\\\"media-content-discoverer\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/content-discoverer-min-1331680.js\\\"},\\\"media-interest-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/interest-manager-min-1306018.js\\\"},\\\"media-instrumentation\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/instrumentation-min-1214752.js\\\"},\\\"media-content-ss-base\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_photo\\\\/content-ss-base-min-1330613.js\\\"},\\\"media-content-ss-no-sv\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_photo\\\\/content-ss-no-sv-min-1328161.js\\\"},\\\"media-carousel\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_photo\\\\/carousel-min-1308638.js\\\"},\\\"media-lead\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/lead-min-1306566.js\\\"},\\\"media-comic\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/comic-min-1262759.js\\\"},\\\"media-content-social-base\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-social-base-min-1339203.js\\\"},\\\"media-content-email-autocomplete\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-email-autocomplete-min-1306078.js\\\"},\\\"media-content-share-buttons\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-share-buttons-min-1339400.js\\\"},\\\"media-content-share-buttons-builder\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-share-buttons-builder-min-1337341.js\\\"},\\\"media-bc\\\":{\\\"path\\\":\\\"d\\\\/lib\\\\/bc\\\\/bc_2.0.5.js\\\"},\\\"media-beacon-manager\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/beacon-manager-min-1333171.js\\\"},\\\"media-nav-addon\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/navigation\\\\/nav-addon-min-1270754.js\\\"},\\\"media-recommend\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/recommend-min-1277359.js\\\"},\\\"media-personal-nav\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/content\\\\/personal-nav-min-1318968.js\\\"},\\\"media-strip\\\":{\\\"path\\\":\\\"ss\\\\/strip_3.2.js\\\"},\\\"media-trfsm\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/trfsm-min-797026.js\\\"},\\\"media-i13n\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/i13n-min-1154367.js\\\"},\\\"media-ywa-tracking\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/p\\\\/common\\\\/ywa-tracking-min-1234794.js\\\"},\\\"media-content-navigation-desktop\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/navigation\\\\/content-navigation-desktop-min-1318647.js\\\"},\\\"media-footer\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/footer\\\\/footer-min-923366.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"modules\\\":{\\\"media-ad-ros\\\":{\\\"fullpath\\\":\\\"http:\\\\/\\\\/ads.yimg.com\\\\/qq\\\\/dm\\\\/ad-ros-0.0.2.js\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\nYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\nYMedia.applyConfig(YUI.YUICfg);\\nYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\nYMedia.use(\\\"media-request-manager\\\",\\\"media-content-manager\\\",\\\"media-perf-timeable\\\",\\\"node-scroll-info\\\",\\\"event-custom\\\",\\\"media-ad-controller\\\",\\\"app-base\\\",\\\"querystring-parse\\\",\\\"media-rmp\\\",\\\"media-pane-manager\\\",\\\"node-base\\\",\\\"event-touch\\\",\\\"media-next-scroll\\\",\\\"media-next-scroll\\\",\\\"event-mouseenter\\\",\\\"media-tag-manager\\\",\\\"media-tag-manager\\\",\\\"media-content-discoverer\\\",\\\"history-base\\\",\\\"media-interest-manager\\\",\\\"io-base\\\",\\\"json-parse\\\",\\\"media-instrumentation\\\",\\\"media-content-ss-base\\\",\\\"media-content-ss-no-sv\\\",\\\"node-base\\\",\\\"event-key\\\",\\\"media-carousel\\\",\\\"base\\\",\\\"json-parse\\\",\\\"querystring-stringify\\\",\\\"media-lead\\\",\\\"media-comic\\\",\\\"autocomplete\\\",\\\"autocomplete-highlighters\\\",\\\"event-base\\\",\\\"event-custom\\\",\\\"node-core\\\",\\\"io\\\",\\\"querystring\\\",\\\"overlay\\\",\\\"json\\\",\\\"gallery-node-tokeninput\\\",\\\"querystring-stringify-simple\\\",\\\"gallery-outside-events\\\",\\\"media-content-social-base\\\",\\\"media-content-email-autocomplete\\\",\\\"media-content-social-base\\\",\\\"media-content-email-autocomplete\\\",\\\"media-content-share-buttons\\\",\\\"event\\\",\\\"node\\\",\\\"media-content-share-buttons-builder\\\",function(Y){\\n    \\t  \\n    Y.later(10, this, function() {Y.Media.adController = new Y.Media.AdController({\\n                                        env: 'prod',\\n                                        hideOnFailure: false,\\n                                        fetchOnPjaxOnly: true,\\n                                        preserveLRECContainer: false\\n                                    });});\\n    Y.later(10, this, function() {Y.Media.requestManager = new Y.Media.RequestManager({\\n                        chrome: Y.Media.pageChrome,\\n                        linkSelector: 'a:not(.no-pjax)',\\n                        unsuppBrowsers: '',\\n                        continueOnError: '1',\\n                        pjaxSplit: '0',\\n                        ignoreCssErrors: '1'\\n                    }).render();});\\n    Y.later(10, this, function() {new Y.Media.ContentManager({\\n                        \\n                                        nodePaths: {content: '#yog-content', navigation: '#yog-nav .navlist', related: '#yog-related', superlead: '#yog-stage'},\\n                                        transition: {style: 'fade'}\\n                                    \\n                    });});\\n    Y.later(10, this, function() {Y.Media.pagePaneManager = new Y.Media.PaneManager(\\n                                    {\\n                                        debug: 0,\\n                                        grid_type: {\\n                                            content: {\\n                                                scroll_mode: 'bandit'\\n                                            },\\n                                            index: {\\n                                                scroll_mode: 'bandit'\\n                                            }\\n                                        },\\n                                        isYnet: 0\\n                                    });});\\n    Y.later(10, this, function() {new Y.Media.TagManager();});\\n    Y.later(10, this, function() {new Y.Media.ContentDiscoverer({\\\"enableLightboxOnStream\\\": \\\"1\\\" });});\\n    Y.later(10, this, function() {new Y.Media.InterestManager({\\n                            });});\\n    Y.later(10, this, function() {new Y.Media.Instrumentation();});\\n    Y.later(10, this, function() {new Y.Media.ContentSSNoSV({\\n                                chrome: Y.Media.pageChrome,\\n                                config: {\\n                                            modId               :'',\\n                                            setupSlideshowCover : 'false',\\n                                            enableCarousel      : '1',\\n                                            enableEndSlideRel   : '0',\\n                                            enableEndSlideMP    : '1',\\n                                            strings             : {\\n                                                'more' : 'more',\\n                                                'less' : 'less',\\n                                                'of'   : 'of'\\n                                            }\\n                                        }\\n                                });});\\n    Y.later(10, this, function() {Y.Media.shareButtonsBuilder = new Y.Media.ContentShareButtonsBuilder({\\\"modNode\\\":\\\"\\\",\\\"switches\\\":{\\\"mtf\\\":true,\\\"cmt\\\":false},\\\"loginStat\\\":{\\\"yahoo\\\":0},\\\"data\\\":{\\\"mtfRedirUrl\\\":\\\"http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\"},\\\"pageData\\\":{\\\"crumb\\\":\\\"\\\",\\\"title\\\":\\\"\\\",\\\"summary\\\":\\\"\\\",\\\"thumbnail\\\":\\\"\\\",\\\"url\\\":\\\"\\\",\\\"locale\\\":\\\"US\\\",\\\"prop\\\":\\\"news\\\",\\\"content_id\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"ult__S\\\":\\\"81121452\\\",\\\"ult_ct\\\":\\\"\\\",\\\"ult_pkg\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"ult_test\\\":null,\\\"ult_csrcpvid\\\":\\\"Fkgif86.K_zWN_2H3UgvxgAdDLU3OFHdq5cAACBD\\\",\\\"ult_sec\\\":\\\"mit_share\\\",\\\"ult_slk\\\":\\\"mail\\\",\\\"ult_mpos\\\":1,\\\"ult_lang\\\":\\\"en-US\\\",\\\"ult_act\\\":\\\"mail\\\",\\\"ult_pstaid\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\"},\\\"contentMetaData\\\":{\\\"id\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"url_orig\\\":\\\"\\\",\\\"title_orig\\\":\\\"\\\",\\\"summary\\\":\\\"\\\",\\\"type\\\":\\\"homepage\\\"},\\\"config\\\":{\\\"site\\\":\\\"news\\\",\\\"lang\\\":\\\"en-US\\\",\\\"region\\\":\\\"US\\\",\\\"scrumb\\\":false},\\\"template\\\":\\\"\\u003Cdiv class=\\\\\\\"yom-share-btns-container light\\\\\\\"\\u003E\\\\n    \\u003Cdiv class=\\\\\\\"share-btns\\\\\\\" role=\\\\\\\"menu\\\\\\\"\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"share-btns-wrap\\\\\\\"\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"share-btn-wrap\\\\\\\"\\u003E\\\\n                \\u003Cul\\u003E\\u003Cli class=\\\\\\\"share-btn facebook\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.facebook.com\\\\/dialog\\\\/feed?app_id=90376669494&amp;redirect_uri=http:\\\\/\\\\/news.yahoo.com\\\\/_xhr\\\\/mediacontentsharebuttons\\\\/postshare\\\\/?src=fb&amp;link=http:\\\\/\\\\/news.yahoo.com\\\\/&amp;picture=http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/BvlRk2eMuZ5S5ZVts0i.Uw--\\\\/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--\\\\/http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/publish-images\\\\/news\\\\/2013-03-19\\\\/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png&amp;display=popup&amp;show_error=yes\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"share\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-fb;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-fb\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E0\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn twitter\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"https:\\\\/\\\\/twitter.com\\\\/share?text=Yahoo%21%20News%20-%20Latest%20News%20%26%20Headlines&amp;url=http:\\\\/\\\\/news.yahoo.com\\\\/&amp;via=YahooNews\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tweet\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tw;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-tw\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E0\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn tumblr\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"http:\\\\/\\\\/www.tumblr.com\\\\/share\\\\/link?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&name=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tumblr\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tu;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-tu\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn pinterest\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"http:\\\\/\\\\/pinterest.com\\\\/pin\\\\/create\\\\/button\\\\/?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&media=http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/BvlRk2eMuZ5S5ZVts0i.Uw--\\\\/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--\\\\/http:\\\\/\\\\/l.yimg.com\\\\/os\\\\/publish-images\\\\/news\\\\/2013-03-19\\\\/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"pinterest\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-pin;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-pin\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\u003Cli class=\\\\\\\"share-btn mail email\\\\\\\"\\u003E\\\\n                        \\u003Ca href=\\\\\\\"mailto:?subject=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines&amp;body=http%3A%2F%2Fnews.yahoo.com%2F\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"email\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-ma;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"btn-icon btn-mail\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\u003E0\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/li\\u003E\\\\n                \\u003C\\\\/ul\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n        \\u003C\\\\/div\\u003E\\\\n    \\u003C\\\\/div\\u003E\\\\n    \\u003Cdiv class=\\\\\\\"share-btns-overlay-screen hide\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n    \\u003Cdiv class=\\\\\\\"share-btns-overlay hide\\\\\\\"\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"yui3-widget-hd\\\\\\\"\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003E&times;\\u003C\\\\/div\\u003E\\\\n        \\u003C\\\\/div\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"yui3-widget-bd\\\\\\\"\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide mail-login\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Sign in to share this by email\\\\\\\"\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"header\\\\\\\"\\u003ESign in to share this by email\\u003C\\\\/h3\\u003E\\\\n                \\u003Cdiv class=\\\\\\\"login-btns\\\\\\\"\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\u003E\\\\n                        \\u003Ca class=\\\\\\\"login-btn yahoo\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https:\\\\/\\\\/login.yahoo.com\\\\/config\\\\/login_verify2?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail&amp;.src=mtf\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"login-icon yahoo\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\u003EYahoo!\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\u003E\\\\n                        \\u003Ca class=\\\\\\\"login-btn facebook\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https:\\\\/\\\\/open.login.yahoo.com\\\\/openid\\\\/yrp\\\\/signin?.intl=us&amp;idp=facebook&amp;.done=http:\\\\/\\\\/news.yahoo.com\\\\/%23mtf-overlay&amp;ts=1373481879&amp;.src=home&amp;appid=90376669494&amp;spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&amp;perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history,publish_actions&amp;fbflow=1\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan class=\\\\\\\"login-icon facebook\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\u003EFacebook\\u003C\\\\/span\\u003E\\u003C\\\\/a\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                \\u003C\\\\/div\\u003E\\\\n                \\u003Cp\\u003ENew here? \\u003Ca href=\\\\\\\"https:\\\\/\\\\/edit.yahoo.com\\\\/config\\\\/eval_register?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"signup\\\\\\\"\\u003ESign up.\\u003C\\\\/a\\u003E\\u003C\\\\/p\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide mail-form\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Email this\\\\\\\"\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"header\\\\\\\"\\u003EEmail this\\u003C\\\\/h3\\u003E\\\\n                \\u003Cdiv class=\\\\\\\"form\\\\\\\"\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\u003E\\\\n                        \\u003Clabel for=\\\\\\\"semail\\\\\\\"\\u003EFrom\\u003C\\\\/label\\u003E\\u003Cselect id=\\\\\\\"semail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"menu\\\\\\\" disabled\\u003E\\u003Coption role=\\\\\\\"menuitem\\\\\\\"\\u003ELoading...\\u003C\\\\/option\\u003E\\u003C\\\\/select\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-semail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EPlease enter a valid email address\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\u003E\\\\n                        \\u003Clabel for=\\\\\\\"remail\\\\\\\"\\u003ETo\\u003C\\\\/label\\u003E\\u003Cinput id=\\\\\\\"remail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"textbox\\\\\\\" disabled\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-remail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EPlease enter valid email addresses, separated by commas\\u003C\\\\/div\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-remail-max-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EMaximum 200 character limit exceeded\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"form-input fb-import\\\\\\\"\\u003E\\\\n                        \\u003Clabel\\u003E&nbsp;\\u003C\\\\/label\\u003E\\u003Cspan\\u003EDon't see your Facebook contacts? \\u003Ca href=\\\\\\\"http:\\\\/\\\\/address.yahoo.com\\\\/?_src=neo&VPC=tools_import&.done=http:\\\\/\\\\/www.yahoo.com\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"import\\\\\\\"\\u003EImport them\\u003C\\\\/a\\u003E\\u003C\\\\/span\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv\\u003E\\\\n                        \\u003Ctextarea placeholder=\\\\\\\"Write a message\\\\\\\" class=\\\\\\\"mail-text\\\\\\\" role=\\\\\\\"textbox\\\\\\\" aria-multiline=\\\\\\\"true\\\\\\\"\\u003E\\u003C\\\\/textarea\\u003E \\\\n                        \\u003Cdiv class=\\\\\\\"yom-mtf-pmesg-error icon-alert-small yui3-widget-hidden\\\\\\\"\\u003EPlease enter a message\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"mail-article\\\\\\\"\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"article thumbnail\\\\\\\"\\u003E\\\\n                            \\u003Cimg title=\\\\\\\"Yahoo! News - Latest News &amp;amp; Headlines\\\\\\\"\\u003E\\\\n                        \\u003C\\\\/div\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"article\\\\\\\"\\u003E\\\\n                            \\u003Cdiv class=\\\\\\\"title\\\\\\\"\\u003EYahoo! News - Latest News &amp;amp; Headlines\\u003C\\\\/div\\u003E\\\\n                            \\u003Cdiv class=\\\\\\\"description\\\\\\\"\\u003EThe latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\u003C\\\\/div\\u003E\\\\n                        \\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                    \\u003Cdiv class=\\\\\\\"mail-submit\\\\\\\"\\u003E\\\\n                        \\u003Cinput type=\\\\\\\"checkbox\\\\\\\" id=\\\\\\\"cc-self\\\\\\\" role=\\\\\\\"checkbox\\\\\\\"\\u003E\\u003Clabel for=\\\\\\\"cc-self\\\\\\\" class=\\\\\\\"cc-self\\\\\\\"\\u003ESend me a copy of this email\\u003C\\\\/label\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"submit-btns\\\\\\\"\\u003E\\\\n                            \\u003Cbutton class=\\\\\\\"mail-btn send\\\\\\\" role=\\\\\\\"button\\\\\\\" disabled\\u003ESend\\u003C\\\\/button\\u003E\\\\n                            \\u003Cbutton class=\\\\\\\"mail-btn close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\u003ECancel\\u003C\\\\/button\\u003E\\\\n                        \\u003C\\\\/div\\u003E\\\\n                        \\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n                    \\u003C\\\\/div\\u003E\\\\n                \\u003C\\\\/div\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide facebook\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"facebook\\\\\\\"\\u003Efacebook\\u003C\\\\/div\\u003E\\\\n            \\u003Cdiv class=\\\\\\\"speedbump hide twitter\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"twitter\\\\\\\"\\u003Etwitter\\u003C\\\\/div\\u003E\\\\n        \\u003C\\\\/div\\u003E\\\\n        \\u003Cdiv class=\\\\\\\"yui3-widget-ft\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\\\n    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\\n\\\"});});\\n\\t\\t   \\n});\\n\\nYUI.Env.add(window, \\\"load\\\", function(){\\nYMedia.use(\\\"media-rmp\\\",\\\"media-bc\\\",\\\"media-beacon-manager\\\",\\\"event-custom\\\",\\\"handlebars\\\",\\\"node-base\\\",\\\"media-nav-addon\\\",\\\"node-core\\\",\\\"node-data\\\",\\\"event-base\\\",\\\"node-event-delegate\\\",\\\"event-delegate\\\",\\\"event-tap\\\",\\\"media-tag-manager\\\",\\\"media-recommend\\\",\\\"media-personal-nav\\\",\\\"cookie\\\",\\\"querystring-parse\\\",\\\"media-strip\\\",\\\"media-trfsm\\\",\\\"base\\\",\\\"jsonp\\\",\\\"media-i13n\\\",\\\"media-ywa-tracking\\\",\\\"media-content-navigation-desktop\\\",\\\"overlay\\\",\\\"media-ad-ros\\\",\\\"media-footer\\\",function(Y){\\n    \\t  \\n    Y.later(10, this, function() {Y.Array.each(YMedia.includes, function(inc, i, ar){ if(Y.Lang.isFunction(inc)) { inc(Y); ar[i] = null; } });\\n    });\\n    Y.later(10, this, function() {new Y.Media.BeaconManager({chrome:Y.Media.pageChrome});\\n    });\\n    Y.later(10, this, function() {new Y.Media.NavAddon({\\n                                max: '3',\\n                                chrome: Y.Media.pageChrome\\n                            });\\n    });\\n    Y.later(10, this, function() {new Y.Media.Recommend({\\n                                header: 'Recommended',\\n                                position: 1,\\n                                chrome: Y.Media.pageChrome\\n                            });\\n    });\\n    Y.later(10, this, function() {new Y.Media.PersonalNav({\\n                                header: 'My Topics',\\n                                position: 2\\n                            });\\n    });\\n    Y.later(10, this, function() {Y.Global.Media.ILBoot.initImageLoader(true);\\n    });\\n    Y.later(10, this, function() {(function() {\\n                                                    var configUrl = 'http://l.yimg.com/os/assets/globalmedia/traffic/traffic-simulation.js',\\n                                                        simulator = new Y.Media.TrafficSimulator({ 'dataUrl' : configUrl });\\n                                                    simulator.load();\\n                                                })();\\n    });\\n    Y.later(10, this, function() {try {\\n                                        YMEDIA_REQ_ATTR.csbeacon();\\n                                    } catch (e) {\\n                                    }\\n    });\\n    Y.later(10, this, function() {new Y.Media.ContentNavigation({\\n                         config: {\\n                            modId               : 'mediacontentnavigation'\\n                         },\\n                         chrome: Y.Media.pageChrome\\n                         });\\n    });\\n    Y.later(10, this, function() {Y.Media.Lead.MediaContentLead.init({\\\"cat\\\":\\\"\\\",\\\"catName\\\":\\\"\\\",\\\"listid \\\":\\\"\\\"});\\n    });\\n    Y.later(10, this, function() {Y.Media.Comic.MediaContentComic.init({\\\"meta\\\":{\\\"error\\\":{\\\"error_code\\\":0},\\\"mod_id\\\":\\\"mediacontentcomic\\\",\\\"bucket\\\":null,\\\"selected_list\\\":\\\"702ab4a0-145a-3b69-9a83-aed16a8a024a\\\",\\\"selected_name\\\":\\\"Garfield\\\",\\\"abbreviation\\\":\\\"ga\\\",\\\"max_result_count\\\":14,\\\"start\\\":0,\\\"count\\\":14,\\\"total\\\":100,\\\"alias\\\":\\\"\\\\/comics\\\\/garfield-slideshow\\\\/\\\",\\\"enableLightBox\\\":0},\\\"data\\\":{\\\"702ab4a0-145a-3b69-9a83-aed16a8a024a\\\":[{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/HsOPI8Hi4Dd406_Wcx_Rxg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130710.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/LevQzAit8GjQB95PNqJEaw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130710.gif\\\",\\\"sdate\\\":\\\"Wed, Jul 10\\\",\\\"date\\\":\\\"Wednesday, July 10\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/VN4cfbpPnSeuIK4yYivb4w--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130709.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/bpLDYA30ACFFXoRNYNwOzw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130709.gif\\\",\\\"sdate\\\":\\\"Tue, Jul 9\\\",\\\"date\\\":\\\"Tuesday, July 9\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/mped5Y9s0mK8FAHrPujA8w--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130708.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/GWRrlT1mkKyKSo3T36FvoA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130708.gif\\\",\\\"sdate\\\":\\\"Mon, Jul 8\\\",\\\"date\\\":\\\"Monday, July 8\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/WB0QMhcgw.BXIkfaporMqA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTQyMjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130707.jpg\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/BM1MIhbEweFIHdwhJ2lPig--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI1NjtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130707.jpg\\\",\\\"sdate\\\":\\\"Sun, Jul 7\\\",\\\"date\\\":\\\"Sunday, July 7\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/7nRIEPtGF33YIyyvamLXqw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130706.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/DMEXHwbV6UJKG1heyjauvg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130706.gif\\\",\\\"sdate\\\":\\\"Sat, Jul 6\\\",\\\"date\\\":\\\"Saturday, July 6\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/CNxK8MQxW4nxW8I5IsmIYg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130705.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/q0Vkxe8Kb24vWNdgV7QMUg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130705.gif\\\",\\\"sdate\\\":\\\"Fri, Jul 5\\\",\\\"date\\\":\\\"Friday, July 5\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/5pPWSABPZX8jN5acXOtEyg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130704.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/pqQZdsB46tLgoPYhBqIeAg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130704.gif\\\",\\\"sdate\\\":\\\"Thu, Jul 4\\\",\\\"date\\\":\\\"Thursday, July 4\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/QhzkGUnNNXKC86F.GdSVqQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130703.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/FjfxEkaUGBLkUZYbI1vYJw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130703.gif\\\",\\\"sdate\\\":\\\"Wed, Jul 3\\\",\\\"date\\\":\\\"Wednesday, July 3\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/0y_GF1XQ6snde6Ul04By5Q--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130702.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/1F2l41IfvFh_9g7.et7HCw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130702.gif\\\",\\\"sdate\\\":\\\"Tue, Jul 2\\\",\\\"date\\\":\\\"Tuesday, July 2\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/thoi55aGBZ7jd2WyWaODMQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130701.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/RYmZMKrrAuSnVdcspOftIQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130701.gif\\\",\\\"sdate\\\":\\\"Mon, Jul 1\\\",\\\"date\\\":\\\"Monday, July 1\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/8YJYSVXxS8rIAkX8N.jHPQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTQyMjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130630.jpg\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/XlqV4JwM6sXvCRNBBAYWGA--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI1NjtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130630.jpg\\\",\\\"sdate\\\":\\\"Sun, Jun 30\\\",\\\"date\\\":\\\"Sunday, June 30\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/Q45WeuPPsTXQBY5JkjItTQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130629.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/worLLaS5MHzh7bqdSBJcWQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130629.gif\\\",\\\"sdate\\\":\\\"Sat, Jun 29\\\",\\\"date\\\":\\\"Saturday, June 29\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/vd2Wbq3pmN83mgApyCkzPg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130628.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/WOtPpC4WYiihGmOfwtvWGw--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130628.gif\\\",\\\"sdate\\\":\\\"Fri, Jun 28\\\",\\\"date\\\":\\\"Friday, June 28\\\"},{\\\"src\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/nHP31hF.HuDAjBhW.ht1aQ--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130627.gif\\\",\\\"rsrc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/bt\\\\/api\\\\/res\\\\/1.2\\\\/9ZkS9kySryvffth5Wp2Phg--\\\\/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-\\\\/http:\\\\/\\\\/media.zenfs.com\\\\/en_us\\\\/News\\\\/ucomics.com\\\\/ga130627.gif\\\",\\\"sdate\\\":\\\"Thu, Jun 27\\\",\\\"date\\\":\\\"Thursday, June 27\\\"}]}});\\n    });\\n    Y.later(10, this, function() {window.dmRosAds.insertMultiAd({\\n                                        dmRosAdConfig: \\\"e5879714\\\",\\n                                        dmRosAdTypeTag: \\\"default\\\",\\n                                        \\n                                        dmRosAdSlotInfo: [\\n                                            {\\n                                                dmRosAdSlotId: \\\"east\\\",\\n                                                dmRosAdDivId: \\\"dmRosAdWrapper-east\\\",\\n                                                dmRosAdWidth: \\\"300\\\",\\n                                                dmRosAdHeight: \\\"300\\\"\\n                                            }\\n                                        ]\\n                                    });\\n    });\\n    Y.later(10, this, function() {if(Y.Media.Footer) var footer = Y.Media.Footer(Y,{footerInfoSelector:\\\"#footer-info\\\",currentDeviceType:\\\"full\\\",projectId:\\\"10001393120079\\\",enableYwaTracking:\\\"0\\\"});\\n    });\\n});\\n});\\n\\t\\t\\n\\t    \\u003C/script\\u003E\\n\\n\\n\\n                        \\u003Cscript\\u003E\\n                        (function(r) {\\n                            if(! r) { return; }\\n                            \\n                            if(typeof YMEDIA_REQ_ATTR === 'object' && typeof YMEDIA_REQ_ATTR.instr === 'object') {\\n                                r.rapidConfig.keys        = r.rapidConfig.keys || {};\\n                                r.rapidConfig.keys.authfb = YMEDIA_REQ_ATTR.instr.authfb;\\n                                r.rapidConfig.keys.rid    = YMEDIA_REQ_ATTR.instr.request_id;\\n                            }\\n                            \\n                            if(typeof r.initRapid === 'function') {\\n                                r.initRapid();\\n                            } else if(YAHOO && YAHOO.i13n && YAHOO.i13n.Rapid) {\\n                                r.rapidConfig.tracked_mods = typeof r.rapidConfig.tracked_mods === 'object' && r.rapidConfig.tracked_mods.concat(r.moduleQueue) || r.moduleQueue;\\n                                r.moduleQueue = [];\\n                                r.rapidInstance = new YAHOO.i13n.Rapid(r.rapidConfig);\\n                            }\\n                            \\n                        }(YMedia.rapid));\\n                        \\u003C/script\\u003E\\n                        \\n\\t\\u003Cdiv id=\\\"yom-ad-SDARLA\\\" class=\\\"yom-ad yom-ad-SDARLA\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-SDARLA-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E\\u003Cscript type='text/javascript' src='http://l.yimg.com/rq/darla/2-6-3/js/g-r-min.js'\\u003E\\u003C/script\\u003E\\u003Cscript type=\\\"text/plain\\\" id=\\\"fc\\\" _ver=\\\"2-6-3\\\"\\u003E{ \\\"positions\\\": [ { \\\"html\\\": \\\"\\u003Cstyle type=\\\\\\\"text/css\\\\\\\"\\u003E\\\\n.can_ad_slug {font-family:arial;font-size:11px;color:#999;text-decoration:none;background-image:url('http://s.yimg.com/hl/a/optimized/adchoice_1.png');background-repeat:no-repeat;background-position:right;padding:0px 14px 0px 1px !important;margin:1px 0px 1px 0;cursor:hand;height:12px;display:inline-block;line-height:12px;background-color:#ffffff;}\\\\n.ad_slug_table {position: relative;}\\\\n.ad_slug_table a {text-decoration:none;}\\\\n.ad_slug_table div.CAN_marker { display:none;}\\\\n.can_ad_slug span {display:none;}\\\\n.can_ad_slug:hover {zoom: 1;}\\\\n.ad_slug_table .ad_slug_table .can_ad_tr td {display: none;}\\\\n.can_ad_slug:hover span {display:inline-block;color:#999;font-family:arial;font-size:11px;}\\\\n.can_ad_tr {position:absolute;top:0;right:1px;z-index:999;}\\\\n\\u003C/style\\u003E\\\\n\\u003Cdiv class=\\\\\\\"CAN_ad\\\\\\\"\\u003E\\\\n\\u003Ctable class=\\\\\\\"ad_slug_table\\\\\\\" cellspacing=\\\\\\\"0\\\\\\\" cellpadding=\\\\\\\"0\\\\\\\" border=\\\\\\\"0\\\\\\\"\\u003E\\\\n\\u003Ctr class=\\\\\\\"can_ad_tr\\\\\\\"\\u003E\\u003Ctd align=\\\\\\\"right\\\\\\\"\\u003E\\u003Ca href=\\\\\\\"http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1aHNwb2MzMChnaWQkUTBkb2tNNi5LXzNCYTdCaVVhX0hsd0RVWXRjS1QxSGRxNndBQkhLaCxzdCQxMzczNDgxOTAwMzA4MzI0LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNzA1MSx2JDIuMCxhaWQkUm5KbTBXS0xjMlEtLGN0JDI1LHlieCRXWHREcHNtQmR0NTVmR01Wc0hBeW5BLGJpJDE4MjQ5NzIwNTEsdyQwKSk/1/*http://info.yahoo.com/relevantads/\\\\\\\" class=\\\\\\\"CAN_link can_ad_slug\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Cspan\\u003EAdChoices\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\\\n\\u003Ctr\\u003E\\u003Ctd\\u003E\\u003C!--Vendor: SiteScout, Format: IFrame, IO: 466712551--\\u003E\\\\n\\u003Cdiv src=\\\\\\\"http://mf.sitescout.com/disp?pid=892C1B1&rnd=1373481900.346027&xurl=referrer&cm=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dXU5a3MzYihnaWQkUTBkb2tNNi5LXzNCYTdCaVVhX0hsd0RVWXRjS1QxSGRxNndBQkhLaCxzdCQxMzczNDgxOTAwMzA4MzI0LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzYwMjUwNzA1MSx2JDIuMCxhaWQkUm5KbTBXS0xjMlEtLGN0JDI1LHlieCRXWHREcHNtQmR0NTVmR01Wc0hBeW5BLGJpJDE4MjQ5NzIwNTEsciQwLHJkJDE2aW9ucnJ1Yykp/0/*http://global.ard.yahoo.com/SIG=15jcvt80d/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC/Y=YAHOO/EXP=1373489100/L=Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh/B=RnJm0WKLc2Q-/J=1373481900346027/K=9svo65LsSMzc90C1tkYLkw/A=7670575586902884517/R=0/X=6/*\\\\\\\" width='300' height='250' marginwidth='0' marginheight='0' scrollbars='0' scrolling='no' frameborder='0' bordercolor='#000000' vspace='0' hspace='0'\\u003E\\u003C/div\\u003E\\u003C!--QYZ 1824972051,3602507051,98.139.115.90;;LREC;81121452;1;--\\u003E\\u003C/td\\u003E\\u003C/tr\\u003E\\\\n\\u003C/table\\u003E\\\\n\\u003C/div\\u003E\\\", \\\"id\\\": \\\"LREC\\\", \\\"meta\\\": { \\\"y\\\": { \\\"cscHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_d==null)window.xzq_d=new Object();\\\\nwindow.xzq_d['RnJm0WKLc2Q-']='(as$12rngd08f,aid$RnJm0WKLc2Q-,bi$1824972051,cr$3602507051,ct$25,at$H,eob$-1)';\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rngd08f,aid$RnJm0WKLc2Q-,bi$1824972051,cr$3602507051,ct$25,at$H,eob$-1)\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"cscURI\\\": \\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rngd08f,aid$RnJm0WKLc2Q-,bi$1824972051,cr$3602507051,ct$25,at$H,eob$-1)\\\", \\\"creativeID\\\": \\\"3602507051\\\", \\\"behavior\\\": \\\"non_exp\\\", \\\"adID\\\": \\\"7670575586902884517\\\", \\\"matchID\\\": \\\"999999.999999.999999.999999\\\", \\\"err\\\": \\\"\\\", \\\"hasExternal\\\": 0, \\\"size\\\": \\\"300x250\\\", \\\"bookID\\\": \\\"1824972051\\\", \\\"serveType\\\": \\\"-1\\\", \\\"slotID\\\": \\\"0\\\" } } },{ \\\"html\\\": \\\"\\u003C!-- SpaceID=81121452 loc=MAST noad --\\u003E\\u003C!-- fac-gd2-noad --\\u003E\\u003C!-- gd2-status-2 --\\u003E\\u003C!--QYZ CMS_NONE_AVAIL,,98.139.115.90;;MAST;81121452;2;--\\u003E\\\", \\\"id\\\": \\\"MAST\\\", \\\"meta\\\": { \\\"y\\\": { \\\"cscHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_d==null)window.xzq_d=new Object();\\\\nwindow.xzq_d['DOxm0WKLc2Q-']='(as$125jefkii,aid$DOxm0WKLc2Q-,cr$-1,ct$25,at$H,eob$-1)';\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125jefkii,aid$DOxm0WKLc2Q-,cr$-1,ct$25,at$H,eob$-1)\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"cscURI\\\": \\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$125jefkii,aid$DOxm0WKLc2Q-,cr$-1,ct$25,at$H,eob$-1)\\\", \\\"creativeID\\\": \\\"-1\\\", \\\"behavior\\\": \\\"non_exp\\\", \\\"adID\\\": \\\"#2\\\", \\\"matchID\\\": \\\"#2\\\", \\\"err\\\": \\\"invalid_space\\\", \\\"hasExternal\\\": 0, \\\"size\\\": \\\"\\\", \\\"bookID\\\": \\\"CMS_NONE_AVAIL\\\", \\\"serveType\\\": \\\"-1\\\", \\\"slotID\\\": \\\"1\\\" } } },{ \\\"html\\\": \\\"\\u003C!--Vendor: Right Media, Format: IFrame --\\u003E\\u003Cdiv ALLOWTRANSPARENCY=TRUE FRAMEBORDER=0 MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING=NO WIDTH=300 HEIGHT=250 SRC=\\\\\\\"http://ad.yieldmanager.com/st?ad_type=div&publisher_blob=${RS}|Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh|81121452|LREC2|1373481900.346633&cnt=yan&ad_size=300x250&site=140477&section_code=2288163051&cb=1373481900.346633&yud=smpv%3d3%26ed%3dzAomdE.7n1vQ06Bzq5du4W6H0h1AhZ0BrKw-&pub_redirect_unencoded=1&pub_redirect=http://clicks.beap.bc.yahoo.com/yc/YnY9MS4wLjAmYnM9KDE1dWcwbzM4ZShnaWQkUTBkb2tNNi5LXzNCYTdCaVVhX0hsd0RVWXRjS1QxSGRxNndBQkhLaCxzdCQxMzczNDgxOTAwMzA4MzI0LHNpJDQ0NjQwNTEsc3AkODExMjE0NTIsY3IkMzA4NTQ4MDU1MSx2JDIuMCxhaWQkMG1WbjBXS0xjMlEtLGN0JDI1LHlieCRXWHREcHNtQmR0NTVmR01Wc0hBeW5BLGJpJDE1ODUwOTMwNTEsciQwLHJkJDE2aTZtNjE1Mikp/0/*http://global.ard.yahoo.com/SIG=15kpli27g/M=999999.999999.999999.999999/D=yahoo/S=81121452:LREC2/Y=YAHOO/EXP=1373489100/L=Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh/B=0mVn0WKLc2Q-/J=1373481900346633/K=9svo65LsSMzc90C1tkYLkw/A=6647776369999917826/R=0/X=6/*\\\\\\\"\\u003E\\u003C/div\\u003E\\u003C!--QYZ 1585093051,3085480551,98.139.115.90;;LREC2;81121452;1;--\\u003E\\\", \\\"id\\\": \\\"LREC2\\\", \\\"meta\\\": { \\\"y\\\": { \\\"cscHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_d==null)window.xzq_d=new Object();\\\\nwindow.xzq_d['0mVn0WKLc2Q-']='(as$12rbnvc5n,aid$0mVn0WKLc2Q-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)';\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rbnvc5n,aid$0mVn0WKLc2Q-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"cscURI\\\": \\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3&al=(as$12rbnvc5n,aid$0mVn0WKLc2Q-,bi$1585093051,cr$3085480551,ct$25,at$H,eob$-1)\\\", \\\"creativeID\\\": \\\"3085480551\\\", \\\"behavior\\\": \\\"non_exp\\\", \\\"adID\\\": \\\"6647776369999917826\\\", \\\"matchID\\\": \\\"999999.999999.999999.999999\\\", \\\"err\\\": \\\"\\\", \\\"hasExternal\\\": 0, \\\"size\\\": \\\"300x250\\\", \\\"bookID\\\": \\\"1585093051\\\", \\\"serveType\\\": \\\"-1\\\", \\\"slotID\\\": \\\"2\\\" } } } ], \\\"meta\\\": { \\\"y\\\": { \\\"pageEndHTML\\\": \\\"\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\n(function(){window.xzq_p=function(R){M=R};window.xzq_svr=function(R){J=R};function F(S){var T=document;if(T.xzq_i==null){T.xzq_i=new Array();T.xzq_i.c=0}var R=T.xzq_i;R[++R.c]=new Image();R[R.c].src=S}window.xzq_sr=function(){var S=window;var Y=S.xzq_d;if(Y==null){return }if(J==null){return }var T=J+M;if(T.length\\u003EP){C();return }var X=\\\\\\\"\\\\\\\";var U=0;var W=Math.random();var V=(Y.hasOwnProperty!=null);var R;for(R in Y){if(typeof Y[R]==\\\\\\\"string\\\\\\\"){if(V&&!Y.hasOwnProperty(R)){continue}if(T.length+X.length+Y[R].length\\u003C=P){X+=Y[R]}else{if(T.length+Y[R].length\\u003EP){}else{U++;N(T,X,U,W);X=Y[R]}}}}if(U){U++}N(T,X,U,W);C()};function N(R,U,S,T){if(U.length\\u003E0){R+=\\\\\\\"&al=\\\\\\\"}F(R+U+\\\\\\\"&s=\\\\\\\"+S+\\\\\\\"&r=\\\\\\\"+T)}function C(){window.xzq_d=null;M=null;J=null}function K(R){xzq_sr()}function B(R){xzq_sr()}function L(U,V,W){if(W){var R=W.toString();var T=U;var Y=R.match(new RegExp(\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\(([^\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)]*)\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)\\\\\\\"));Y=(Y[1].length\\u003E0?Y[1]:\\\\\\\"e\\\\\\\");T=T.replace(new RegExp(\\\\\\\"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\([^\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)]*\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\)\\\\\\\",\\\\\\\"g\\\\\\\"),\\\\\\\"(\\\\\\\"+Y+\\\\\\\")\\\\\\\");if(R.indexOf(T)\\u003C0){var X=R.indexOf(\\\\\\\"{\\\\\\\");if(X\\u003E0){R=R.substring(X,R.length)}else{return W}R=R.replace(new RegExp(\\\\\\\"([^a-zA-Z0-9$_])this([^a-zA-Z0-9$_])\\\\\\\",\\\\\\\"g\\\\\\\"),\\\\\\\"$1xzq_this$2\\\\\\\");var Z=T+\\\\\\\";var rv = f( \\\\\\\"+Y+\\\\\\\",this);\\\\\\\";var S=\\\\\\\"{var a0 = '\\\\\\\"+Y+\\\\\\\"';var ofb = '\\\\\\\"+escape(R)+\\\\\\\"' ;var f = new Function( a0, 'xzq_this', unescape(ofb));\\\\\\\"+Z+\\\\\\\"return rv;}\\\\\\\";return new Function(Y,S)}else{return W}}return V}window.xzq_eh=function(){if(E||I){this.onload=L(\\\\\\\"xzq_onload(e)\\\\\\\",K,this.onload,0);if(E&&typeof (this.onbeforeunload)!=O){this.onbeforeunload=L(\\\\\\\"xzq_dobeforeunload(e)\\\\\\\",B,this.onbeforeunload,0)}}};window.xzq_s=function(){setTimeout(\\\\\\\"xzq_sr()\\\\\\\",1)};var J=null;var M=null;var Q=navigator.appName;var H=navigator.appVersion;var G=navigator.userAgent;var A=parseInt(H);var D=Q.indexOf(\\\\\\\"Microsoft\\\\\\\");var E=D!=-1&&A\\u003E=4;var I=(Q.indexOf(\\\\\\\"Netscape\\\\\\\")!=-1||Q.indexOf(\\\\\\\"Opera\\\\\\\")!=-1)&&A\\u003E=4;var O=\\\\\\\"undefined\\\\\\\";var P=2000})();\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cscr\\\"+\\\"ipt language=javascr\\\"+\\\"ipt\\u003E\\\\nif(window.xzq_svr)xzq_svr('http://csc.beap.bc.yahoo.com/');\\\\nif(window.xzq_p)xzq_p('yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3');\\\\nif(window.xzq_s)xzq_s();\\\\n\\u003C/scr\\\"+\\\"ipt\\u003E\\u003Cnoscr\\\"+\\\"ipt\\u003E\\u003Cimg width=1 height=1 alt=\\\\\\\"\\\\\\\" src=\\\\\\\"http://csc.beap.bc.yahoo.com/yi?bv=1.0.0&bs=(134tavrco(gid$Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh,st$1373481900308324,si$4464051,sp$81121452,pv$0,v$2.0))&t=J_3-D_3\\\\\\\"\\u003E\\u003C/noscr\\\"+\\\"ipt\\u003E\\\", \\\"pos_list\\\": [ \\\"LREC\\\",\\\"MAST\\\",\\\"LREC2\\\" ], \\\"spaceID\\\": \\\"81121452\\\", \\\"host\\\": \\\"news.yahoo.com\\\", \\\"lookupTime\\\": \\\"41\\\", \\\"k2_uri\\\": \\\"\\\", \\\"fac_rt\\\": \\\"40143\\\", \\\"pvid\\\": \\\"Q0dokM6.K_3Ba7BiUa_HlwDUYtcKT1Hdq6wABHKh\\\", \\\"tID\\\": \\\"darla_prefetch_1373481900307_1680550104_1\\\" } } } \\u003C/script\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-SDARLA\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-SDARLA-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=SDARLA noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n\\t\\u003Cdiv id=\\\"yom-ad-SDARLAEXTRA\\\" class=\\\"yom-ad yom-ad-SDARLAEXTRA\\\" style=\\\"visibility: inherit;\\\"\\u003E\\u003Ccenter\\u003E\\u003Cdiv id=\\\"yom-ad-SDARLAEXTRA-iframe\\\" class=\\\"yom-ad\\\"\\u003E\\u003Ccenter\\u003E    \\n        \\u003Cscript type='text/javascript'\\u003E\\n    function loadAdsAfterOnLoad() {        \\n        YMedia.later(10, this, function() {\\n        \\n            YMedia.use(\\\"node-base\\\", function(Y){\\n                        \\n                /* YUI Ads Darla begins... */\\n                YUI.AdsDarla = (function (){\\n                     \\n                    var nodes = {\\\"yom-ad-LREC\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LREC-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:300px;height:266px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LREC-iframe\\\"},\\\"yom-ad-LREC2\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LREC2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:300px;height:266px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LREC2-iframe\\\"},\\\"yom-ad-LDRB\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LDRB-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:728px;height:93px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LDRB-iframe\\\"},\\\"yom-ad-LDRB2\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LDRB2-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:728px;height:93px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LDRB2-iframe\\\"},\\\"yom-ad-LDRB3\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-LDRB3-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:728px;height:93px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-LDRB3-iframe\\\"},\\\"yom-ad-MAST\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-MAST-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:970px;height:31px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-MAST-iframe\\\"},\\\"yom-ad-WPS\\\":{\\\"node\\\":\\\"\\u003Cdiv id='yom-ad-WPS-iframe' class='yom-ad-iframe' marginwidth='0' marginheight='0'\\\\n                                    hspace='0' vspace='0' frameborder='0' scrolling='no' style='display:none;\\\\n                                    width:320px;height:66px;'\\u003E\\\\n                            \\u003C\\\\/div\\u003E\\\",\\\"id\\\":\\\"yom-ad-WPS-iframe\\\"}};\\n                                            \\n                    DARLA_CONFIG = {\\\"servicePath\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/__darla\\\\/php\\\\/fc.php\\\",\\\"beaconPath\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/__darla\\\\/php\\\\/b.php\\\",\\\"renderPath\\\":\\\"\\\",\\\"allowFiF\\\":false,\\\"srenderPath\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-sf.html\\\",\\\"renderFile\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-sf.html\\\",\\\"sfbrenderPath\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-sf.html\\\",\\\"msgPath\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/__darla\\\\/2-6-3\\\\/html\\\\/msg.html\\\",\\\"cscPath\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\\/html\\\\/r-csc.html\\\",\\\"root\\\":\\\"__darla\\\",\\\"edgeRoot\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\",\\\"sedgeRoot\\\":\\\"https:\\\\/\\\\/s.yimg.com\\\\/rq\\\\/darla\\\\/2-6-3\\\",\\\"version\\\":\\\"2-6-3\\\",\\\"tpbURI\\\":\\\"\\\",\\\"beaconsDisabled\\\":true,\\\"rotationTimingDisabled\\\":true,\\\"positions\\\":{\\\"LREC\\\":{\\\"w\\\":300,\\\"h\\\":250},\\\"MAST\\\":[],\\\"LREC2\\\":{\\\"w\\\":300,\\\"h\\\":250}}};\\n                    \\n                    /* replacing the port number */\\n                    DARLA_CONFIG.servicePath = DARLA_CONFIG.servicePath.replace(/\\\\:8033/g, \\\"\\\");\\n                    DARLA_CONFIG.msgPath = DARLA_CONFIG.msgPath.replace(/\\\\:8033/g, \\\"\\\");\\n                                        \\n                    /* configuring the Ad positions */\\n                    DARLA_CONFIG.positions = {\\\"LREC2\\\":{\\\"w\\\":\\\"300\\\",\\\"h\\\":266,\\\"dest\\\":\\\"yom-ad-LREC2-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LREC2\\\",\\\"id\\\":\\\"LREC2\\\",\\\"clean\\\":\\\"yom-ad-LREC2\\\",\\\"rmxp\\\":0,\\\"z\\\":10},\\\"MAST\\\":{\\\"w\\\":\\\"970\\\",\\\"h\\\":31,\\\"dest\\\":\\\"yom-ad-MAST-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"MAST\\\",\\\"id\\\":\\\"MAST\\\",\\\"clean\\\":\\\"yom-ad-MAST\\\",\\\"rmxp\\\":0,\\\"supports\\\":{\\\"*\\\":1}},\\\"LREC\\\":{\\\"w\\\":\\\"300\\\",\\\"h\\\":266,\\\"dest\\\":\\\"yom-ad-LREC-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LREC\\\",\\\"id\\\":\\\"LREC\\\",\\\"clean\\\":\\\"yom-ad-LREC\\\",\\\"rmxp\\\":0,\\\"z\\\":10},\\\"WPS\\\":{\\\"w\\\":\\\"320\\\",\\\"h\\\":66,\\\"dest\\\":\\\"yom-ad-WPS-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"WPS\\\",\\\"id\\\":\\\"WPS\\\",\\\"clean\\\":\\\"yom-ad-WPS\\\",\\\"rmxp\\\":0,\\\"metaSize\\\":true},\\\"LDRB3\\\":{\\\"w\\\":\\\"728\\\",\\\"h\\\":93,\\\"dest\\\":\\\"yom-ad-LDRB3-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LDRB3\\\",\\\"id\\\":\\\"LDRB3\\\",\\\"clean\\\":\\\"yom-ad-LDRB3\\\",\\\"rmxp\\\":0},\\\"LDRB2\\\":{\\\"w\\\":\\\"728\\\",\\\"h\\\":93,\\\"dest\\\":\\\"yom-ad-LDRB2-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LDRB2\\\",\\\"id\\\":\\\"LDRB2\\\",\\\"clean\\\":\\\"yom-ad-LDRB2\\\",\\\"rmxp\\\":0},\\\"LDRB\\\":{\\\"w\\\":\\\"728\\\",\\\"h\\\":93,\\\"dest\\\":\\\"yom-ad-LDRB-iframe\\\",\\\"fr\\\":\\\"expIfr_exp\\\",\\\"pos\\\":\\\"LDRB\\\",\\\"id\\\":\\\"LDRB\\\",\\\"clean\\\":\\\"yom-ad-LDRB\\\",\\\"rmxp\\\":0}};\\n                    \\n                    /* configuring the Ad events */\\n                    DARLA_CONFIG.events = {\\\"mediaadsdarla\\\":{\\\"lvl\\\":\\\"2\\\",\\\"sp\\\":\\\"81121452\\\",\\\"npv\\\":\\\"1\\\",\\\"bg\\\":\\\"FFFFFF\\\",\\\"sa\\\":\\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\\"sa_orig\\\":\\\"\\\\\\\"minihome\\\\\\\"=\\\\\\\"home\\\\\\\" \\\\\\\"type\\\\\\\"=\\\\\\\"page\\\\\\\" lang=\\\\\\\"en-US\\\\\\\"  can_suppress_ugc=\\\\\\\"1\\\\\\\" LREC=\\\\\\\"300x250\\\\\\\" LREC2=\\\\\\\"300x250\\\\\\\"\\\",\\\"filter\\\":\\\"no_expandable;exp_iframe_expandable;\\\",\\\"mpid\\\":\\\"692\\\",\\\"mpnm\\\":\\\"yahoo_mobile_us_web\\\",\\\"locale\\\":\\\"US\\\",\\\"ps\\\":\\\"LREC,LREC2,LDRB,LDRB2,LDRB3,MAST,WPS\\\",\\\"ml\\\":\\\"\\\",\\\"mps\\\":\\\"\\\"}};\\n\\n                    DARLA_CONFIG.onFinishPosRender = function(pos_id) {\\n                        var pos_conf, id, el, par, shm;\\n                        if (pos_id) {\\n                            pos_conf = DARLA.posSettings(pos_id);\\n                            id = (pos_conf && pos_conf.dest);\\n                            el = (id && document.getElementById(id)) || null;\\n                            par = (el && el.parentNode);\\n                            shm = (id && document.getElementById(\\\"shm_\\\" + id));\\n                            if (par) {par.style.zIndex = 99; }\\n                            if (shm) {shm.style.zIndex = 99; }\\n                            if (el) {el.style.zIndex = 100; }\\n                        }\\n                    };\\n                    DARLA_CONFIG.onPosMsg = function(msg, id){\\n                        if( !DARLA.isIE ) return;\\n                        // this event is fired synchronously, so we must run right\\n                        // after the thread ended. setTimeout(...,1) should take care of this.\\n                        setTimeout(\\n                            function(){\\n                                var i=0,iframes, iframe, id, zmap={},shim=[],d=document;\\n                                // exp-over and exp-push are expansion over content, and expansion pushing content.\\n                                if( msg === 'exp-ovr' || msg === 'exp-push' ){\\n                                    // map all iframes on the DOM\\n                                    iframes = d.getElementsByTagName(\\\"iframe\\\");\\n                                    for(; iframe = iframes[i++] ;){\\n                                        id = iframe.id;\\n                                        // Store each iframe zIndex\\n                                        zmap[id] = iframe.style.zIndex;\\n                                        // The iframes with the prefix shm_ are Darla's shims\\n                                        if( id.indexOf('shm_') === 0 ){\\n                                            shim[shim.length] = id;\\n                                        }\\n                                    }\\n                                    if( shim.length \\u003E 0 ){\\n                                        // now look for shims and set it z-1 from it's sibling\\n                                        for(i=0; iframe = shim[i++] ;){\\n                                            // the sibling is found by removing the prefix\\n                                            id = iframe.substr(4); // - \\\"shm_\\\"\\n                                            d.getElementById(iframe).style.zIndex = zmap[id] - 1;               \\n                                        }\\n                                    }\\n                                }       \\n                            },\\n                        10);\\n                    };\\n                    \\n                    DARLA_CONFIG.onSuccess = function (eventId, positions) {\\n                        Y.Global.fire('darla:success', {\\n                            positions: positions\\n                        });\\n                        Y.log('fetch ad success: ' + positions.join(', '), 'info', 'darla');\\n                    };\\n\\n                    DARLA_CONFIG.onFailure = function (eventId) {\\n                        var positions = null;\\n                        try {\\n                            positions = DARLA_CONFIG.events[eventId].ps.split(',');\\n                        } catch (e) {}\\n\\n                        Y.Global.fire('darla:failure', {\\n                            positions: positions\\n                        });\\n                        Y.log('fetch ad failure' + (positions ? (': ' + positions.join(', ')) : ''), 'warn', 'darla');\\n                    };        \\n                    /* preparing the Nodes with iframes. Note this would be hidden iframe and not visible in the DOM */\\n                    var _prepareNodes = function(){\\n                        for(var cleanId in nodes){\\n                            var center = Y.one(\\\"#\\\"+cleanId+\\\" \\u003E center\\\");\\n                            if(center != null && center && !Y.one(\\\"#\\\" + nodes[cleanId].id)){\\n                                center.set(\\\"innerHTML\\\",\\\"\\\");\\n                                center.insert(nodes[cleanId].node);\\n                            }\\n                        }\\n                    };\\n\\n                    /* setting up DARLA events */\\n                    var w = window,\\n                        D = w.DARLA,\\n                        C = w.DARLA_CONFIG,\\n                        DM = w.DOC_DOMAIN_SET || 0;\\n                    if (D) {\\n                        if (D && C) {\\n                            C.dm = DM;\\n                            /*D.config(C);*/\\n                        }\\n                        \\n                        _prepareNodes();\\n                        \\n                        /* setting DARLA configuration */\\n                        DARLA.config(C);\\n\\n                        /* rendering prefetched Ad */\\n                        DARLA.render();  \\n                    }\\n\\n                    return {\\n                        event: function (eventId, spaceId, adsSa) {\\n                            if (window.DARLA && eventId) {\\n                                _prepareNodes();\\n                                var eventConfig = {};\\n                                if (!isNaN(spaceId)) {\\n                                    eventConfig.sp = spaceId;\\n                                }\\n                                /* Site attributes */\\n                                adsSa = (typeof adsSa !== \\\"undefined\\\" && adsSa !== null) ? adsSa : \\\"\\\";\\n                                eventConfig.sa = DARLA_CONFIG.events[eventId].sa_orig.replace ? DARLA_CONFIG.events[eventId].sa_orig.replace(\\\"ADSSA\\\", adsSa) : \\\"\\\";\\n                                DARLA.event(eventId, eventConfig);\\n                            }\\n                        }\\n                    };\\n\\n                })(); /* End of YUI.AdsDarla */\\n\\n                    YUI.AdsDarla.mediaadsdarla = { fetch: (Y.bind(YUI.AdsDarla.event, YUI.AdsDarla, 'mediaadsdarla')) };                    YUI.AdsDarla.fetch = YUI.AdsDarla.mediaadsdarla.fetch;   \\n                    Y.Global.fire('darla:ready'); \\n\\n             }); /* End of YMedia */\\n             \\n        }); /* End of YMedia.later */\\n        \\n          }; /* End of GrandSlam Onload */\\n  if(window.addEventListener)window.addEventListener('load',loadAdsAfterOnLoad,0);\\n  else if(window.attachEvent)window.attachEvent('onload',loadAdsAfterOnLoad);\\n          \\u003C/script\\u003E\\n\\u003Cscript\\u003E(function(){ var wrap = document.getElementById(\\\"yom-ad-SDARLAEXTRA\\\"); if (null == wrap) { wrap = document.getElementById(\\\"yom-ad-SDARLAEXTRA-iframe\\\") || {}; } var content = wrap.innerHTML || \\\"\\\"; if (content && content.substr(0, content.lastIndexOf(\\\"\\u003Cscript\\u003E\\\")).indexOf(\\\"loc=SDARLAEXTRA noad\\\") !== -1) { wrap.style.display = \\\"none\\\"; } }())\\u003C/script\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\u003C/center\\u003E\\u003C/div\\u003E\\n    \\u003C/body\\u003E\\n\\u003C/html\\u003E\\n\\n\\u003C!-- fe86.global.media.gq1.yahoo.com uncompressed/chunked Wed Jul 10 18:44:39 UTC 2013 --\\u003E\\n\\u003C!-- ncache4.global.media.gq1.yahoo.com compressed/chunked Wed Jul 10 18:44:39 UTC 2013 --\\u003E\\n\\u003C!-- ad prefetch pagecsc setting --\\u003E\"});\n\n    \n        try {\n    ((JSBNG_Record.scriptLoad)((\"var t_headstart = new Date().getTime();\"), (\"sf65c5bea48cdd55711164b14850e99a45658292e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    var t_headstart = (((JSBNG_Record.get)(new JSBNG__Date(), (\"getTime\")))[(\"getTime\")])();\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n\tYahoo! News - Latest News & Headlines\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n\t\n        \n        \n        \n        \n\n\n\n\n\n\n\n\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"if (!window.YAHOO) {\\u000a    window.YAHOO = {\\u000a    };\\u000a}\\u000a;\\u000aif (!YAHOO.Media) {\\u000a    YAHOO.Media = {\\u000a    };\\u000a}\\u000a;\\u000aif (!YAHOO.widget) {\\u000a    YAHOO.widget = {\\u000a    };\\u000a}\\u000a;\"), (\"sc35bd7311d4e7278da7fca7cf652c055168acfb2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if (!(((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")])) {\n        ((JSBNG_Record.set)(window, (\"YAHOO\"), {\n        }));\n    }\n;\n    if (!(((JSBNG_Record.get)(YAHOO, (\"Media\")))[(\"Media\")])) {\n        ((JSBNG_Record.set)(YAHOO, (\"Media\"), {\n        }));\n    }\n;\n    if (!(((JSBNG_Record.get)(YAHOO, (\"widget\")))[(\"widget\")])) {\n        ((JSBNG_Record.set)(YAHOO, (\"widget\"), {\n        }));\n    }\n;\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\ntry {\n    ((JSBNG_Record.scriptLoad)((\"if (!window.YMedia) {\\u000a    var YMedia = YUI();\\u000a    YMedia.includes = [];\\u000a}\\u000a;\"), (\"s28a4d1f9ad0fa750de8d6a05f854caf54e0c247e\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if (!(((JSBNG_Record.get)(window, (\"YMedia\")))[(\"YMedia\")])) {\n        var YMedia = YUI();\n        ((JSBNG_Record.set)(YMedia, (\"includes\"), []));\n    }\n;\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\ntry {\n    ((JSBNG_Record.scriptLoad)((\"window.YMEDIA_REQ_ATTR = {\\u000a    device: {\\u000a        os: \\\"mac os x\\\",\\u000a        osver: \\\"10.8\\\"\\u000a    },\\u000a    instr: {\\u000a        request_id: \\\"9e982445-db9d-4261-a67e-efe16f86aeec\\\",\\u000a        authfb: 0\\u000a    },\\u000a    csbeacon: function() {\\u000a        if (!this._hasIssuedCsBeacon) {\\u000a            this._hasIssuedCsBeacon = true;\\u000a            if ((((typeof YAHOO === \\\"object\\\") && (typeof YAHOO.i13n === \\\"object\\\")) && (typeof YAHOO.i13n.sendComscoreEvent === \\\"function\\\"))) {\\u000a                if (YAHOO.i13n.setEga) {\\u000a                    YAHOO.i13n.setEga(\\\"\\\");\\u000a                }\\u000a            ;\\u000a                if (YAHOO.i13n.setRdg) {\\u000a                    YAHOO.i13n.setRdg(\\\"-1\\\");\\u000a                }\\u000a            ;\\u000a                if (YAHOO.i13n.setSpaceid) {\\u000a                    YAHOO.i13n.setSpaceid(81121452);\\u000a                }\\u000a            ;\\u000a                YAHOO.i13n.sendComscoreEvent();\\u000a            }\\u000a        ;\\u000a        }\\u000a    ;\\u000a    },\\u000a    _hasIssuedCsBeacon: false\\u000a};\"), (\"s8d62335ecf4aaaa3faa829a209aa50c1c3bbaad3\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(window, (\"YMEDIA_REQ_ATTR\"), {\n        device: {\n            os: \"mac os x\",\n            osver: \"10.8\"\n        },\n        instr: {\n            request_id: \"9e982445-db9d-4261-a67e-efe16f86aeec\",\n            authfb: 0\n        },\n        csbeacon: ((function() {\n            var s8d62335ecf4aaaa3faa829a209aa50c1c3bbaad3_0_instance;\n            ((s8d62335ecf4aaaa3faa829a209aa50c1c3bbaad3_0_instance) = ((JSBNG_Record.eventInstance)((\"s8d62335ecf4aaaa3faa829a209aa50c1c3bbaad3_0\"))));\n            return ((JSBNG_Record.markFunction)((function() {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s8d62335ecf4aaaa3faa829a209aa50c1c3bbaad3_0\"), (s8d62335ecf4aaaa3faa829a209aa50c1c3bbaad3_0_instance), (this), (arguments)))\n                };\n                (null);\n                if (!(((JSBNG_Record.get)(this, (\"_hasIssuedCsBeacon\")))[(\"_hasIssuedCsBeacon\")])) {\n                    ((JSBNG_Record.set)(this, (\"_hasIssuedCsBeacon\"), true));\n                    if ((((typeof YAHOO === \"object\") && (typeof (((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]) === \"object\")) && (typeof (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"sendComscoreEvent\")))[(\"sendComscoreEvent\")]) === \"function\"))) {\n                        if ((((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setEga\")))[(\"setEga\")])) {\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setEga\")))[(\"setEga\")])(\"\");\n                        }\n                    ;\n                        if ((((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setRdg\")))[(\"setRdg\")])) {\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setRdg\")))[(\"setRdg\")])(\"-1\");\n                        }\n                    ;\n                        if ((((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setSpaceid\")))[(\"setSpaceid\")])) {\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"setSpaceid\")))[(\"setSpaceid\")])(81121452);\n                        }\n                    ;\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"sendComscoreEvent\")))[(\"sendComscoreEvent\")])();\n                    }\n                ;\n                }\n                ;\n            })));\n        })()),\n        _hasIssuedCsBeacon: false\n    }));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};<div><img src=\"http://b.scorecardresearch.com/b?c1=2&c2=7241469&c7=news.yahoo.com%2F&c5=81121452&c15=$-1&cv=2.0&cj=1\" style=\"display:none\" width=\"0\" height=\"0\" alt=\"\" /></div>try {\n    ((JSBNG_Record.scriptLoad)((\"window.YMEDIA_CRUMB = \\\"vft50wE5amf\\\";\"), (\"s89818cf8eefe14f6f2cf30fb03030a0cdde0d247\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(window, (\"YMEDIA_CRUMB\"), \"vft50wE5amf\"));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"YUI.Env.add(window, \\\"unload\\\", function() {\\u000a    try {\\u000a        YMEDIA_REQ_ATTR.csbeacon();\\u000a    } catch (e) {\\u000a    \\u000a    };\\u000a});\"), (\"s9840219b8a67b41faa089cd0ad1fad465972c548\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), (\"add\")))[(\"add\")])(window, \"unload\", ((function() {\n        var s9840219b8a67b41faa089cd0ad1fad465972c548_0_instance;\n        ((s9840219b8a67b41faa089cd0ad1fad465972c548_0_instance) = ((JSBNG_Record.eventInstance)((\"s9840219b8a67b41faa089cd0ad1fad465972c548_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9840219b8a67b41faa089cd0ad1fad465972c548_0\"), (s9840219b8a67b41faa089cd0ad1fad465972c548_0_instance), (this), (arguments)))\n            };\n            (null);\n            try {\n                (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"csbeacon\")))[(\"csbeacon\")])();\n            } catch (e) {\n            \n            };\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\ntry {\n    ((JSBNG_Record.scriptLoad)((\"window.YAHOO = (window.YAHOO || {\\u000a});\\u000awindow.YAHOO.i13n = (window.YAHOO.i13n || {\\u000a});\\u000aYAHOO.i13n.YWA_CF_MAP = {\\u000a    ad: 58,\\u000a    authfb: 11,\\u000a    bpos: 24,\\u000a    cat: 25,\\u000a    cpos: 21,\\u000a    ct: 23,\\u000a    ft: 51,\\u000a    ltxt: 17,\\u000a    mrkt: 12,\\u000a    pct: 48,\\u000a    pd: 46,\\u000a    pkgt: 22,\\u000a    pos: 20,\\u000a    pstcat: 47,\\u000a    pt: 13,\\u000a    sca: 53,\\u000a    sec: 18,\\u000a    site: 42,\\u000a    slk: 19,\\u000a    sort: 28,\\u000a    test: 14,\\u000a    v: 52,\\u000a    ver: 49,\\u000a    x: 50\\u000a};\\u000aYAHOO.i13n.YWA_ACTION_MAP = {\\u000a    click: 12,\\u000a    detecthpset: 10,\\u000a    expand: 9,\\u000a    hover: 17,\\u000a    hswipe: 19,\\u000a    key: 13,\\u000a    scrolldown: 16,\\u000a    scrollup: 15,\\u000a    secview: 18,\\u000a    shrink: 11,\\u000a    svct: 14\\u000a};\\u000aYAHOO.i13n.YWA_OUTCOME_MAP = {\\u000a    abuse: 51,\\u000a    authview: 48,\\u000a    close: 34,\\u000a    comment: 49,\\u000a    connect: 36,\\u000a    cueauthview: 43,\\u000a    cueconnectview: 46,\\u000a    cuehpset: 50,\\u000a    cueinfoview: 45,\\u000a    cueloadview: 44,\\u000a    cueswipeview: 42,\\u000a    cuetop: 48,\\u000a    drag: 21,\\u000a    drop: 22,\\u000a    end: 31,\\u000a    entitydeclaration: 40,\\u000a    feedback: 37,\\u000a    fetch: 30,\\u000a    filter: 35,\\u000a    hpset: 27,\\u000a    insert: 28,\\u000a    interest: 51,\\u000a    itemdeclaration: 37,\\u000a    loadview: 49,\\u000a    login: 33,\\u000a    msgview: 47,\\u000a    navigate: 25,\\u000a    newview: 50,\\u000a    open: 29,\\u000a    reauthfb: 24,\\u000a    rmct: 32,\\u000a    setlayout: 38,\\u000a    share: 23,\\u000a    sort: 39,\\u000a    top: 26,\\u000a    undo: 41,\\u000a    vswipe: 20\\u000a};\\u000aYMedia.rapid = {\\u000a    rapidConfig: {\\u000a        spaceid: \\\"81121452\\\",\\u000a        tracked_mods: [\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\",],\\u000a        text_link_len: 8,\\u000a        client_only: 1,\\u000a        compr_type: \\\"deflate\\\",\\u000a        ult_token_capture: true,\\u000a        webworker_file: \\\"/rapid-worker.js\\\",\\u000a        test_id: null,\\u000a        keys: {\\u000a            x: \\\"114\\\",\\u000a            juris: \\\"US\\\",\\u000a            lang: \\\"en-US\\\",\\u000a            mrkt: \\\"US\\\",\\u000a            pcp: \\\"\\\",\\u000a            pct: \\\"\\\",\\u000a            pd: \\\"\\\",\\u000a            pst: \\\"\\\",\\u000a            pstaid: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a            pstcat: \\\"news\\\",\\u000a            pt: \\\"2\\\",\\u000a            site: \\\"news\\\",\\u000a            test: \\\"\\\",\\u000a            ver: \\\"grandslam\\\"\\u000a        },\\u000a        ywa: {\\u000a            project_id: \\\"10001393120079\\\",\\u000a            document_group: \\\"\\\",\\u000a            document_name: \\\"\\\",\\u000a            host: \\\"y3.analytics.yahoo.com\\\"\\u000a        },\\u000a        nofollow_class: [\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\",]\\u000a    },\\u000a    rapidInstance: null,\\u000a    moduleQueue: [],\\u000a    addModules: function(modInfo) {\\u000a        this.moduleQueue.push(modInfo);\\u000a    }\\u000a};\"), (\"s11eeb8209958de2b3a41d7e5087584dedeb2f518\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(window, (\"YAHOO\"), ((((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")]) || {\n    })));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")]), (\"i13n\"), ((((JSBNG_Record.get)((((JSBNG_Record.get)(window, (\"YAHOO\")))[(\"YAHOO\")]), (\"i13n\")))[(\"i13n\")]) || {\n    })));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"YWA_CF_MAP\"), {\n        ad: 58,\n        authfb: 11,\n        bpos: 24,\n        cat: 25,\n        cpos: 21,\n        ct: 23,\n        ft: 51,\n        ltxt: 17,\n        mrkt: 12,\n        pct: 48,\n        pd: 46,\n        pkgt: 22,\n        pos: 20,\n        pstcat: 47,\n        pt: 13,\n        sca: 53,\n        sec: 18,\n        site: 42,\n        slk: 19,\n        sort: 28,\n        test: 14,\n        v: 52,\n        ver: 49,\n        x: 50\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"YWA_ACTION_MAP\"), {\n        click: 12,\n        detecthpset: 10,\n        expand: 9,\n        hover: 17,\n        hswipe: 19,\n        key: 13,\n        scrolldown: 16,\n        scrollup: 15,\n        secview: 18,\n        shrink: 11,\n        svct: 14\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YAHOO, (\"i13n\")))[(\"i13n\")]), (\"YWA_OUTCOME_MAP\"), {\n        abuse: 51,\n        authview: 48,\n        close: 34,\n        comment: 49,\n        connect: 36,\n        cueauthview: 43,\n        cueconnectview: 46,\n        cuehpset: 50,\n        cueinfoview: 45,\n        cueloadview: 44,\n        cueswipeview: 42,\n        cuetop: 48,\n        drag: 21,\n        drop: 22,\n        end: 31,\n        entitydeclaration: 40,\n        feedback: 37,\n        fetch: 30,\n        filter: 35,\n        hpset: 27,\n        insert: 28,\n        interest: 51,\n        itemdeclaration: 37,\n        loadview: 49,\n        login: 33,\n        msgview: 47,\n        JSBNG__navigate: 25,\n        newview: 50,\n        open: 29,\n        reauthfb: 24,\n        rmct: 32,\n        setlayout: 38,\n        share: 23,\n        sort: 39,\n        JSBNG__top: 26,\n        undo: 41,\n        vswipe: 20\n    }));\n    ((JSBNG_Record.set)(YMedia, (\"rapid\"), {\n        rapidConfig: {\n            spaceid: \"81121452\",\n            tracked_mods: [\"mediacontentnavigation\",\"mediamoduletieheader\",\"mediacontentlead\",\"p_30345786\",\"mediaadsdmros\",\"mediacontentgenericlistings\",\"mediafooterinfo\",],\n            text_link_len: 8,\n            client_only: 1,\n            compr_type: \"deflate\",\n            ult_token_capture: true,\n            webworker_file: \"/rapid-worker.js\",\n            test_id: null,\n            keys: {\n                x: \"114\",\n                juris: \"US\",\n                lang: \"en-US\",\n                mrkt: \"US\",\n                pcp: \"\",\n                pct: \"\",\n                pd: \"\",\n                pst: \"\",\n                pstaid: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                pstcat: \"news\",\n                pt: \"2\",\n                site: \"news\",\n                test: \"\",\n                ver: \"grandslam\"\n            },\n            ywa: {\n                project_id: \"10001393120079\",\n                document_group: \"\",\n                document_name: \"\",\n                host: \"y3.analytics.yahoo.com\"\n            },\n            nofollow_class: [\"rapid-nf\",\"rapidnofollow\",\"yom-mod\",\"yog-nw\",\"yom-hero\",\"yom-tiles\",\"yom-menu\",\"yom-nav-tablet\",\"yom-card-main\",\"yom-lightbox\",\"yom-card-related\",\"yom-nlist\",\"yom-nlist-scroll\",\"yom-header\",]\n        },\n        rapidInstance: null,\n        moduleQueue: [],\n        addModules: ((function() {\n            var s11eeb8209958de2b3a41d7e5087584dedeb2f518_0_instance;\n            ((s11eeb8209958de2b3a41d7e5087584dedeb2f518_0_instance) = ((JSBNG_Record.eventInstance)((\"s11eeb8209958de2b3a41d7e5087584dedeb2f518_0\"))));\n            return ((JSBNG_Record.markFunction)((function(modInfo) {\n                if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                    return ((JSBNG_Record.eventCall)((arguments.callee), (\"s11eeb8209958de2b3a41d7e5087584dedeb2f518_0\"), (s11eeb8209958de2b3a41d7e5087584dedeb2f518_0_instance), (this), (arguments)))\n                };\n                (null);\n                (((JSBNG_Record.get)((((JSBNG_Record.get)(this, (\"moduleQueue\")))[(\"moduleQueue\")]), (\"push\")))[(\"push\")])(modInfo);\n            })));\n        })())\n    }));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n\t\ttry {\n    ((JSBNG_Record.scriptLoad)((\"YUI.YUICfg = {\\u000a    gallery: \\\"gallery-2011.04.20-13-04\\\",\\u000a    groups: {\\u000a        group01c9d8dea06e05460a64eed4dadd622b6: {\\u000a            base: \\\"http://l.yimg.com/\\\",\\u000a            comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a            modules: {\\u000a                \\\"media-v2-chrome\\\": {\\u000a                    path: \\\"os/mit/media/p/presentation/v2-chrome-min-1335634.js\\\"\\u000a                },\\u000a                \\\"media-tracking\\\": {\\u000a                    path: \\\"os/mit/media/m/base/tracking-min-1154405.js\\\"\\u000a                },\\u000a                \\\"media-imageloader\\\": {\\u000a                    path: \\\"os/mit/media/m/base/imageloader-min-1277138.js\\\"\\u000a                },\\u000a                \\\"media-imageloader-bootstrap\\\": {\\u000a                    path: \\\"os/mit/media/m/base/imageloader-bootstrap-min-815727.js\\\"\\u000a                },\\u000a                \\\"media-rapid-tracking\\\": {\\u000a                    path: \\\"os/mit/media/p/common/rapid-tracking-min-1330602.js\\\"\\u000a                },\\u000a                \\\"media-header-uh3-desktop\\\": {\\u000a                    path: \\\"os/mit/media/m/header/header-uh3-desktop-min-1322619.js\\\"\\u000a                }\\u000a            },\\u000a            combine: true,\\u000a            filter: \\\"min\\\",\\u000a            root: \\\"/\\\"\\u000a        }\\u000a    },\\u000a    combine: true,\\u000a    allowRollup: true,\\u000a    comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a    maxURLLength: \\\"2000\\\"\\u000a};\\u000aYUI.YUICfg.root = ((\\\"yui:\\\" + YUI.version) + \\\"/build/\\\");\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = \\\"yui:gallery-2011.04.20-13-04/build/\\\";\\u000aYMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", \\\"media-v2-chrome\\\", \\\"media-tracking\\\", \\\"node-base\\\", \\\"event-custom\\\", \\\"dom-deprecated\\\", \\\"node-deprecated\\\", \\\"substitute\\\", \\\"media-imageloader\\\", \\\"media-imageloader-bootstrap\\\", \\\"base-base\\\", \\\"node-style\\\", \\\"node-screen\\\", \\\"media-rapid-tracking\\\", \\\"base\\\", \\\"node\\\", \\\"media-header-uh3-desktop\\\", \\\"intl\\\", function(Y) {\\u000a    Y.later(10, this, function() {\\u000a        Y.applyConfig({\\u000a            debug: false\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        YUI.namespace(\\\"Media\\\").LANGDIR = \\\"ltr\\\";\\u000a        YUI.namespace(\\\"Media\\\").CONTENT_ID = \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\";\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        if ((Y.Media && Y.Media.Chrome)) {\\u000a            Y.Media.pageChrome = Y.Media.Chrome(Y, {\\u000a                site: \\\"news\\\",\\u000a                lang: \\\"en-US\\\",\\u000a                region: \\\"US\\\",\\u000a                spaceId: \\\"81121452\\\",\\u000a                contentId: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                gridType: \\\"index\\\",\\u000a                device: \\\"full\\\",\\u000a                deviceOS: ((((YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device) && YMEDIA_REQ_ATTR.device.os)) || \\\"\\\"),\\u000a                deviceOSVer: ((((YMEDIA_REQ_ATTR && YMEDIA_REQ_ATTR.device) && YMEDIA_REQ_ATTR.device.osver)) || \\\"\\\"),\\u000a                projectId: \\\"10001393120079\\\",\\u000a                enableYwaTracking: \\\"0\\\",\\u000a                enable2xImgs: \\\"0\\\",\\u000a                imgItemsSelector: \\\".js .yog-bd img\\\",\\u000a                enableViewportManagement: \\\"0\\\",\\u000a                viewportItemsSelector: \\\".js .yog-content img,.yog-smartphone.js .yog-bd img\\\",\\u000a                transparentImgUrl: \\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-1093278.png\\\",\\u000a                enableRapidTracking: 1,\\u000a                rapidConf: {\\u000a                    spaceid: \\\"81121452\\\",\\u000a                    tracked_mods: [\\\"mediacontentnavigation\\\",\\\"mediamoduletieheader\\\",\\\"mediacontentlead\\\",\\\"p_30345786\\\",\\\"mediaadsdmros\\\",\\\"mediacontentgenericlistings\\\",\\\"mediafooterinfo\\\",],\\u000a                    text_link_len: 8,\\u000a                    client_only: 1,\\u000a                    compr_type: \\\"deflate\\\",\\u000a                    ult_token_capture: true,\\u000a                    webworker_file: \\\"/rapid-worker.js\\\",\\u000a                    test_id: null,\\u000a                    keys: {\\u000a                        x: \\\"114\\\",\\u000a                        juris: \\\"US\\\",\\u000a                        lang: \\\"en-US\\\",\\u000a                        mrkt: \\\"US\\\",\\u000a                        pcp: \\\"\\\",\\u000a                        pct: \\\"\\\",\\u000a                        pd: \\\"\\\",\\u000a                        pst: \\\"\\\",\\u000a                        pstaid: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                        pstcat: \\\"news\\\",\\u000a                        pt: \\\"2\\\",\\u000a                        site: \\\"news\\\",\\u000a                        test: \\\"\\\",\\u000a                        ver: \\\"grandslam\\\"\\u000a                    },\\u000a                    ywa: {\\u000a                        project_id: \\\"10001393120079\\\",\\u000a                        document_group: \\\"\\\",\\u000a                        document_name: \\\"\\\",\\u000a                        host: \\\"y3.analytics.yahoo.com\\\"\\u000a                    },\\u000a                    nofollow_class: [\\\"rapid-nf\\\",\\\"rapidnofollow\\\",\\\"yom-mod\\\",\\\"yog-nw\\\",\\\"yom-hero\\\",\\\"yom-tiles\\\",\\\"yom-menu\\\",\\\"yom-nav-tablet\\\",\\\"yom-card-main\\\",\\\"yom-lightbox\\\",\\\"yom-card-related\\\",\\\"yom-nlist\\\",\\\"yom-nlist-scroll\\\",\\\"yom-header\\\",]\\u000a                },\\u000a                bucketId: \\\"\\\",\\u000a                baseImageryFallbackCss: \\\"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-min-1313085.css\\\",\\u000a                baseImageryFallbackCssLteIe7: \\\"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-lteIE7-min-1313085.css\\\"\\u000a            });\\u000a        }\\u000a    ;\\u000a    ;\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.on(\\\"domready\\\", function() {\\u000a            DOMIMG = new Image();\\u000a            DOMIMG.src = (\\\"http://geo.yahoo.com/p?s=81121452&pt=2&test=nacelle&btype=dom&t=\\\" + Math.random());\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.namespace(\\\"Global.Media\\\").ILBoot = new Y.ImageLoaderBootstrap(200);\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        YMedia.rapid = new Y.Media.RapidTracking({\\u000a            instance: (YMedia.rapid && YMedia.rapid.rapidInstance),\\u000a            moduleQueue: (YMedia.rapid && YMedia.rapid.moduleQueue),\\u000a            rapidConfig: (YMedia.rapid && YMedia.rapid.rapidConfig),\\u000a            config: {\\u000a                selectors: {\\u000a                    bd: \\\"#yog-bd\\\",\\u000a                    mods: \\\".yom-mod\\\"\\u000a                }\\u000a            }\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        if (Y.Media.HeaderUH3) {\\u000a            Y.Media.HeaderUH3(Y);\\u000a        };\\u000a    });\\u000a});\"), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(YUI, (\"YUICfg\"), {\n        gallery: \"gallery-2011.04.20-13-04\",\n        groups: {\n            group01c9d8dea06e05460a64eed4dadd622b6: {\n                base: \"http://l.yimg.com/\",\n                comboBase: \"http://l.yimg.com/zz/combo?\",\n                modules: {\n                    \"media-v2-chrome\": {\n                        path: \"os/mit/media/p/presentation/v2-chrome-min-1335634.js\"\n                    },\n                    \"media-tracking\": {\n                        path: \"os/mit/media/m/base/tracking-min-1154405.js\"\n                    },\n                    \"media-imageloader\": {\n                        path: \"os/mit/media/m/base/imageloader-min-1277138.js\"\n                    },\n                    \"media-imageloader-bootstrap\": {\n                        path: \"os/mit/media/m/base/imageloader-bootstrap-min-815727.js\"\n                    },\n                    \"media-rapid-tracking\": {\n                        path: \"os/mit/media/p/common/rapid-tracking-min-1330602.js\"\n                    },\n                    \"media-header-uh3-desktop\": {\n                        path: \"os/mit/media/m/header/header-uh3-desktop-min-1322619.js\"\n                    }\n                },\n                combine: true,\n                filter: \"min\",\n                root: \"/\"\n            }\n        },\n        combine: true,\n        allowRollup: true,\n        comboBase: \"http://l.yimg.com/zz/combo?\",\n        maxURLLength: \"2000\"\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]), (\"root\"), ((\"yui:\" + (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")])) + \"/build/\")));\n    (((JSBNG_Record.get)(YMedia, (\"applyConfig\")))[(\"applyConfig\")])((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), ((JSBNG_Record.temps.tcf12360dc7ac71f533d4c4b70f46264e7295099b) = (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")]))))[(JSBNG_Record.temps.tcf12360dc7ac71f533d4c4b70f46264e7295099b)]), (\"groups\")))[(\"groups\")]), (\"gallery\")))[(\"gallery\")]), (\"root\"), \"yui:gallery-2011.04.20-13-04/build/\"));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-viewport-loader\", \"media-v2-chrome\", \"media-tracking\", \"node-base\", \"event-custom\", \"dom-deprecated\", \"node-deprecated\", \"substitute\", \"media-imageloader\", \"media-imageloader-bootstrap\", \"base-base\", \"node-style\", \"node-screen\", \"media-rapid-tracking\", \"base\", \"node\", \"media-header-uh3-desktop\", \"intl\", ((function() {\n        var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0_instance;\n        ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)(Y, (\"applyConfig\")))[(\"applyConfig\")])({\n                        debug: false\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_2_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"namespace\")))[(\"namespace\")])(\"Media\"), (\"LANGDIR\"), \"ltr\"));\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"namespace\")))[(\"namespace\")])(\"Media\"), (\"CONTENT_ID\"), \"5f01278b-803a-3803-9798-7fc79bab4f7d\"));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_3_instance), (this), (arguments)))\n                    };\n                    (null);\n                    if (((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Chrome\")))[(\"Chrome\")]))) {\n                        ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\"), (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Chrome\")))[(\"Chrome\")])(Y, {\n                            site: \"news\",\n                            lang: \"en-US\",\n                            region: \"US\",\n                            spaceId: \"81121452\",\n                            contentId: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            gridType: \"index\",\n                            device: \"full\",\n                            deviceOS: ((((YMEDIA_REQ_ATTR && (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")]), (\"os\")))[(\"os\")]))) || \"\"),\n                            deviceOSVer: ((((YMEDIA_REQ_ATTR && (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")])) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"device\")))[(\"device\")]), (\"osver\")))[(\"osver\")]))) || \"\"),\n                            projectId: \"10001393120079\",\n                            enableYwaTracking: \"0\",\n                            enable2xImgs: \"0\",\n                            imgItemsSelector: \".js .yog-bd img\",\n                            enableViewportManagement: \"0\",\n                            viewportItemsSelector: \".js .yog-content img,.yog-smartphone.js .yog-bd img\",\n                            transparentImgUrl: \"http://l.yimg.com/os/mit/media/m/base/images/transparent-1093278.png\",\n                            enableRapidTracking: 1,\n                            rapidConf: {\n                                spaceid: \"81121452\",\n                                tracked_mods: [\"mediacontentnavigation\",\"mediamoduletieheader\",\"mediacontentlead\",\"p_30345786\",\"mediaadsdmros\",\"mediacontentgenericlistings\",\"mediafooterinfo\",],\n                                text_link_len: 8,\n                                client_only: 1,\n                                compr_type: \"deflate\",\n                                ult_token_capture: true,\n                                webworker_file: \"/rapid-worker.js\",\n                                test_id: null,\n                                keys: {\n                                    x: \"114\",\n                                    juris: \"US\",\n                                    lang: \"en-US\",\n                                    mrkt: \"US\",\n                                    pcp: \"\",\n                                    pct: \"\",\n                                    pd: \"\",\n                                    pst: \"\",\n                                    pstaid: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                                    pstcat: \"news\",\n                                    pt: \"2\",\n                                    site: \"news\",\n                                    test: \"\",\n                                    ver: \"grandslam\"\n                                },\n                                ywa: {\n                                    project_id: \"10001393120079\",\n                                    document_group: \"\",\n                                    document_name: \"\",\n                                    host: \"y3.analytics.yahoo.com\"\n                                },\n                                nofollow_class: [\"rapid-nf\",\"rapidnofollow\",\"yom-mod\",\"yog-nw\",\"yom-hero\",\"yom-tiles\",\"yom-menu\",\"yom-nav-tablet\",\"yom-card-main\",\"yom-lightbox\",\"yom-card-related\",\"yom-nlist\",\"yom-nlist-scroll\",\"yom-header\",]\n                            },\n                            bucketId: \"\",\n                            baseImageryFallbackCss: \"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-min-1313085.css\",\n                            baseImageryFallbackCssLteIe7: \"http://l.yimg.com/os/mit/media/themes/v2_base/base-imagery-fallback-lteIE7-min-1313085.css\"\n                        })));\n                    }\n                    ;\n                    ;\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_4_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)(Y, (\"JSBNG__on\")))[(\"JSBNG__on\")])(\"domready\", ((function() {\n                        var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5_instance;\n                        ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_5_instance), (this), (arguments)))\n                            };\n                            (null);\n                            DOMIMG = new JSBNG__Image();\n                            ((JSBNG_Record.set)(DOMIMG, (\"src\"), (\"http://geo.yahoo.com/p?s=81121452&pt=2&test=nacelle&btype=dom&t=\" + (((JSBNG_Record.get)(Math, (\"JSBNG__random\")))[(\"JSBNG__random\")])())));\n                        })));\n                    })()));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_6_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"namespace\")))[(\"namespace\")])(\"Global.Media\"), (\"ILBoot\"), new (((JSBNG_Record.get)(Y, (\"ImageLoaderBootstrap\")))[(\"ImageLoaderBootstrap\")])(200)));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_7_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)(YMedia, (\"rapid\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RapidTracking\")))[(\"RapidTracking\")])({\n                        instance: ((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]), (\"rapidInstance\")))[(\"rapidInstance\")])),\n                        moduleQueue: ((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]), (\"moduleQueue\")))[(\"moduleQueue\")])),\n                        rapidConfig: ((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]) && (((JSBNG_Record.get)((((JSBNG_Record.get)(YMedia, (\"rapid\")))[(\"rapid\")]), (\"rapidConfig\")))[(\"rapidConfig\")])),\n                        config: {\n                            selectors: {\n                                bd: \"#yog-bd\",\n                                mods: \".yom-mod\"\n                            }\n                        }\n                    })));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8_instance;\n                ((sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8_instance) = ((JSBNG_Record.eventInstance)((\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8\"), (sd8d56b34cbc9bd33f6949f4b81bc9b57c0465080_8_instance), (this), (arguments)))\n                    };\n                    (null);\n                    if ((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"HeaderUH3\")))[(\"HeaderUH3\")])) {\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"HeaderUH3\")))[(\"HeaderUH3\")])(Y);\n                    };\n                })));\n            })()));\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t1\\\");\\u000a};\"), (\"sfe2cfa0f38fd04b9ac8c9f59f7cb13d130ecaab4\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t1\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        try {\n    ((JSBNG_Record.scriptLoad)((\"var t_headend = new Date().getTime();\"), (\"sbecbf625e3c2bd2725c8f1c06278391b42ebb9e2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    var t_headend = (((JSBNG_Record.get)(new JSBNG__Date(), (\"getTime\")))[(\"getTime\")])();\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n    \n    \n        try {\n    ((JSBNG_Record.scriptLoad)((\"document.body.className = document.body.className.replace(\\\"no-js\\\", \\\"js\\\");\\u000adocument.body.offsetHeight;\"), (\"sfd5fc673c8a38b3a7fa34af94c82d8fe6c61a3dc\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"className\"), (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"className\")))[(\"className\")]), (\"replace\")))[(\"replace\")])(\"no-js\", \"js\")));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__document, (\"body\")))[(\"body\")]), (\"offsetHeight\")))[(\"offsetHeight\")]);\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n            \n                \n                \n\n#header,#yucs,#y-hd,#hd .yfi_doc,#yfi_hd{background:#fff !important}#yog-hd,#yfi-hd,#ysp-hd,#hd,#yfimh,#yfi_hd,#yfi_fp_hd,#masthead,#yfi_nav_header #navigation,#y-nav #navigation,.ad_in_head{background-color:#fff;background-image:none}#header,#hd .yfi_doc,#y-hd .yfi_doc,#yfi_hd .yfi_doc{width:100% !important}#yucs{margin:0 auto;width:970px}#yfi_nav_header,.y-nav-legobg,#y-nav #navigation{margin:0 auto;width:970px}#yucs .yucs-avatar{height:22px;width:22px}#yucs #yucs-profile_text .yuhead-name-greeting{display:none}#yucs #yucs-profile_text .yuhead-name{top:0;max-width:65px}#yucs-profile_text{max-width:65px}#yog-bd .yom-stage{background:transparent}#yog-hd{height:84px}.yog-bd,.yog-grid{padding:4px 10px}#yucs #yucs-search .yucs-button_theme{background:-moz-linear-gradient(top, #26376a 0, #192446 100%);background:-webkit-gradient(linear, left top, left bottom, color-stop(0%, #26376a), color-stop(100%, #192446));background:-webkit-linear-gradient(top, #26376a 0, #192446 100%);background:-o-linear-gradient(top, #26376a 0, #192446 100%);background:-ms-linear-gradient(top, #26376a 0, #192446 100%);background:linear-gradient(to bottom, #26376a 0, #192446 100%);-webkit-box-shadow:inset 0 1px 3px 0 #3f5baf;box-shadow:inset 0 1px 3px 0 #3f5baf;background-color:#2f477a;background-color:transparent\\0/IE9;background-color:transparent\\9;*background:none;border:1px solid #152756}#yucs #yucs-search #yucs-prop_search_button_wrapper .yucs-gradient{filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#26376a', endColorstr='#192446',GradientType=0 );-ms-filter:\"progid:DXImageTransform.Microsoft.gradient( startColorstr='#26376a', endColorstr='#192446',GradientType=0 )\";background-color:#2f477a\\0/IE9}#yucs #yucs-search #yucs-prop_search_button_wrapper{*border:1px solid #152756}#yog-hd .yom-bar, #yog-hd .yom-nav, #y-nav, #hd .ysp-full-bar,  #yfi_nav_header, #hd .mast {\nfloat: none;\nwidth: 970px;\nmargin: 0 auto;\n}\n\n#yog-bd .yom-stage {\nbackground: transparent;\n}\n\n#y-nav .yom-nav {\npadding-top: 0px;\n}\n\n#ysp-search-assist .bd {\ndisplay:none;\n}\n\n#ysp-search-assist h4 {\npadding-left: 8px;\n}\n\n\n    #yfi-portfolios-multi-quotes #y-nav, #yfi-portfolios-multi-quotes #navigation, #yfi-portfolios-multi-quotes .y-nav-legobg, \n    #yfi-portfolios-my-portfolios #y-nav, #yfi-portfolios-my-portfolios #navigation, #yfi-portfolios-my-portfolios .y-nav-legobg {\n        width : 100%;\n    }                        Home            Mail            News            Sports            Finance            Weather            Games            Groups            Answers            Flickr            More                                                                                        omg!                            Shine                            Movies                            Music                            TV                            Health                            Shopping                            Travel                            Autos                            Homes                                                                                                                        #yucs #yucs-logo {width:123px ;}         #yucs #yucs-logo h2 {            width:123px;            height:36px ;            background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.png) ;            _background-image:url(http://l.yimg.com/rz/uh/logos/news/news-20130429.gif) ;        }        #yucs #yucs-logo a {          display:block ;          width:123px ;          height:36px;          overflow: hidden;        }        @media        only screen and (-webkit-min-device-pixel-ratio: 2),        only screen and ( min--moz-device-pixel-ratio: 2),        only screen and ( -o-min-device-pixel-ratio: 2/1),        only screen and ( min-device-pixel-ratio: 2),        only screen and ( min-resolution: 192dpi),        only screen and ( min-resolution: 2dppx) {            #yucs #yucs-logo h2 {                background-image: url(http://l.yimg.com/rz/uh/logos/news/news-20130429-x2.png) !important;                background-size: 275px 120px;            }        }                          Yahoo! News                                                                                                                        Search NewsSearch Web                                                                              Sign In                  Mail                        Help                                    Account Info            Help                        Suggestions                Yahoo!                        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"event\\\", \\\"get\\\", function(Y) {\\u000a    Y.once(\\\"load\\\", function() {\\u000a        Y.Get.js(\\\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/js/1/uh-min.js&kx/yucs/uh3/uh/js/102/gallery-jsonp-min.js&kx/yucs/uh3/uh/js/565/menu_utils_v3-min.js&kx/yucs/uh3/uh/js/549/timestamp_library-min.js&kx/yucs/uh3/uh3_top_bar/js/148/top_bar_v3-min.js&kx/yucs/uh3/search/js/361/search-min.js&kx/ucs/common/js/131/jsonp-super-cached-min.js&kx/yucs/uh3/avatar/js/9/avatar-min.js&kx/yucs/uh3/mail_link/js/60/mailcount-min.js&kx/yucs/uh3/help/js/46/help_menu_v3-min.js\\\");\\u000a    });\\u000a});\"), (\"s0b6a75f6fe99368402e19542a48a63d5beec22d2\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"JSBNG__event\", \"get\", ((function() {\n        var s0b6a75f6fe99368402e19542a48a63d5beec22d2_0_instance;\n        ((s0b6a75f6fe99368402e19542a48a63d5beec22d2_0_instance) = ((JSBNG_Record.eventInstance)((\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_0\"), (s0b6a75f6fe99368402e19542a48a63d5beec22d2_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(Y, (\"once\")))[(\"once\")])(\"load\", ((function() {\n                var s0b6a75f6fe99368402e19542a48a63d5beec22d2_1_instance;\n                ((s0b6a75f6fe99368402e19542a48a63d5beec22d2_1_instance) = ((JSBNG_Record.eventInstance)((\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_1\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s0b6a75f6fe99368402e19542a48a63d5beec22d2_1\"), (s0b6a75f6fe99368402e19542a48a63d5beec22d2_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Get\")))[(\"Get\")]), (\"js\")))[(\"js\")])(\"http://l.yimg.com/zz/combo?kx/yucs/uh3/uh/js/1/uh-min.js&kx/yucs/uh3/uh/js/102/gallery-jsonp-min.js&kx/yucs/uh3/uh/js/565/menu_utils_v3-min.js&kx/yucs/uh3/uh/js/549/timestamp_library-min.js&kx/yucs/uh3/uh3_top_bar/js/148/top_bar_v3-min.js&kx/yucs/uh3/search/js/361/search-min.js&kx/ucs/common/js/131/jsonp-super-cached-min.js&kx/yucs/uh3/avatar/js/9/avatar-min.js&kx/yucs/uh3/mail_link/js/60/mailcount-min.js&kx/yucs/uh3/help/js/46/help_menu_v3-min.js\");\n                })));\n            })()));\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n                \n            \n            \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t2\\\");\\u000a};\"), (\"s3a56d1cd08626886d66f70072f43e2521a0cd07a\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t2\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n            \n                \n                \n\n\n\n\n    \n        \n            \n                \ntry {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-MAST\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-MAST-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=MAST noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance;\n        ((se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance) = ((JSBNG_Record.eventInstance)((\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"se1fbd0603f526202587a2b4f56de690dd114e5bb_0\"), (se1fbd0603f526202587a2b4f56de690dd114e5bb_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-MAST-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=MAST noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n            \n        \n    \n    \n        \n            \n                \n    \n        \n                \n                    Home\n                \n                \n                    U.S.\n                \n                \n                    World\n                \n                \n                    Politics\n                \n                \n                    Tech\n                \n                \n                    Science\n                \n                \n                    Health\n                \n                \n                    Odd News\n                \n                \n                    Opinion\n                \n                \n                    Local\n                \n                \n                    Dear Abby\n                \n                \n                    Comics\n                \n                \n                    ABC News\n                \n                \n                    Y! News Originals\n                \n        \n        \n            <div class=\"nav-wrap pos-{{position}} {{classname}}\" data-position=\"{{position}}\">\n                <h3>{{header}}</h3>\n                <ul class=\"navlist\">\n                    {{#entries}}\n                        <li>\n                            <a href=\"{{link}}\" {{#title_attrib}}title=\"{{title_attrib}}\"{{/title_attrib}}{{#class}}class=\"{{class}}\"{{/class}} {{{tracking}}} data-action-outcome=\"navigate\" data-item-id=\"{{id}}\">{{{text}}}</a>\n                        </li>\n                    {{/entries}}\n                    {{#show_more}}\n                        <div class=\"subnav\">\n                            <li><a href=\"#\" class=\"more\">More <strong>&rsaquo;</strong></a>\n                                <div class=\"subnav-more\">\n                                    <i class=\"arrow\"></i>\n                                <ul>\n                                {{#more_entries}}\n                                <li>\n                                     <a href=\"{{link}}\" {{#title_attrib}}title=\"{{title_attrib}}\"{{/title_attrib}}{{#class}}class=\"{{class}}\"{{/class}} {{{tracking}}} data-action-outcome=\"navigate\" data-item-id=\"{{id}}\">{{{text}}}</a>\n                                </li>\n                                 {{/more_entries}}\n                                 </ul>\n                                 </div>\n                            </li>\n                        </div>\n                    {{/show_more}}\n                </ul>\n            </div>\n        \n    \n\n            \n        \n    \n    \n        \n            \n                \n\n            Judge rules against Zimmerman on evidence   SANFORD, Fla. (AP) — A Florida judge ruled Wednesday that Trayvon Martin's cellphone text messages … Read More »                     Bombing suspect heads to 1st public court hearing               SF probe brings questions over auto speed controls       \n\n            \n        \n    \n    \n         \n            \n                \ntry {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance;\n        ((s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance) = ((JSBNG_Record.eventInstance)((\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s948e0e6035133da5ed82f540da07ab5598a1a8dd_0\"), (s948e0e6035133da5ed82f540da07ab5598a1a8dd_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n    Comics    Garfield  Pearls Before Swine  Dilbert  Peanuts  Andy Capp  B.C.  9 Chickweed Lane  Doonesbury  Wizard of Id  Luann                 More   Wed, Jul 10          Garfield Wednesday, July 10 More         \n            #dmRosAdWrapper-east iframe{width:100%} #yog-cw .dmros_ad {border-color: #E0E0E0; border-style: solid; border-width: 0 0 1px;}\n            \n                \n                    <div id=\"dmRosAd-1-east\" width=\"300\" height=\"300\" frameborder=\"0\" marginheight=\"0\" marginwidth=\"0\" scrolling=\"no\" src=\"http://dmros.ysm.yahoo.com/ros/?c=e5879714&w=300&h=300&ty=noscript&tt=Yahoo%21+News+-+Latest+News+%26amp%3B+Headlines&r=\"></div>\n                \n            \n    Latest Videos             David Tillman's midday weather forecast  02:50              Printer ink efficiency tested by Consumer Reports  02:33              Rare Film Shows FDR Pushed in Wheelchair  00:34              Lunch Break 07-10-13  03:12              Wishbone, Bombay Spice & Grill, among newcomers at …  03:26              Whitey Bulger, ex-partner trade curses in courtroo …  04:57              Taste of Chicago 2013 opens  02:37              Officials defend Paulsboro train derailment respon …  00:32              Police searching for bus stop attacker in Humboldt …  02:16              Teen charged in mother's murder  02:55           \n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"(function() {\\u000a    var wrap = document.getElementById(\\\"yom-ad-LREC2\\\");\\u000a    if ((null == wrap)) {\\u000a        wrap = (document.getElementById(\\\"yom-ad-LREC2-iframe\\\") || {\\u000a        });\\u000a    }\\u000a;\\u000a    var content = (wrap.innerHTML || \\\"\\\");\\u000a    if ((content && (content.substr(0, content.lastIndexOf(\\\"\\\\u003Cscript\\\\u003E\\\")).indexOf(\\\"loc=LREC2 noad\\\") !== -1))) {\\u000a        wrap.style.display = \\\"none\\\";\\u000a    }\\u000a;\\u000a}());\"), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((function() {\n        var sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance;\n        ((sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance) = ((JSBNG_Record.eventInstance)((\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0\"), (sd991c19676f447c2f197b3bd52a4d38a8eef7ce7_0_instance), (this), (arguments)))\n            };\n            (null);\n            var wrap = (((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2\");\n            if ((null == wrap)) {\n                wrap = ((((JSBNG_Record.get)(JSBNG__document, (\"getElementById\")))[(\"getElementById\")])(\"yom-ad-LREC2-iframe\") || {\n                });\n            }\n            ;\n            var JSBNG__content = ((((JSBNG_Record.get)(wrap, (\"innerHTML\")))[(\"innerHTML\")]) || \"\");\n            if ((JSBNG__content && ((((JSBNG_Record.get)((((JSBNG_Record.get)(JSBNG__content, (\"substr\")))[(\"substr\")])(0, (((JSBNG_Record.get)(JSBNG__content, (\"lastIndexOf\")))[(\"lastIndexOf\")])(\"\\u003Cscript\\u003E\")), (\"indexOf\")))[(\"indexOf\")])(\"loc=LREC2 noad\") !== -1))) {\n                ((JSBNG_Record.set)((((JSBNG_Record.get)(wrap, (\"style\")))[(\"style\")]), (\"display\"), \"none\"));\n            }\n            ;\n        })));\n    })())());\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n\n    \n        \n            \n        \n        \n            \n        \n        \n            \n                Copyright © 2013 Yahoo! Inc. All rights reserved.\n            \n            \n                 | Yahoo! - ABC News Network | \n            \n            \n                Help / Suggestions\n                Privacy Policy\n                About Our Ads\n                Terms of Service\n                Copyright/IP Policy\n            \n        \n        \n            \n        \n        \n    \n\n            \n        \n    \n\n\n\n\n\n\n    \n\n\n\n\n\n\n\n\n                \n                \n                \n                \n            \n            \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t3\\\");\\u000a};\"), (\"sc2ad6e75bc9970a3d5d2eadcdf8c41b5a6326b31\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t3\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n        \n        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"if ((typeof rt_pushMoment !== \\\"undefined\\\")) {\\u000a    rt_pushMoment(\\\"t4\\\");\\u000a};\"), (\"sc826b587d5a8f7776f3b3628060183e7002a40eb\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    if ((typeof rt_pushMoment !== \"undefined\")) {\n        rt_pushMoment(\"t4\");\n    };\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n        \n        \ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y) {\\u000a    Y.Global.Media.ViewportLoader.addContainers([{\\u000a        selector: \\\"#mediacontentfollowproperty_container\\\",\\u000a        callback: function(node) {\\u000a            Y.Media.RMP.load({\\u000a                srcNode: \\\"#mediacontentfollowproperty_container\\\",\\u000a                response: \\\"\\\\u000d\\\\u000a--dali-response-split-51ddaba7d48ef\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: top\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?os/mit/media/m/content_social/media-content-follow-property-desktop-min-1339299.css\\\\\\\" /\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddaba7d48ef\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: bottom\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\\\u003E\\\\u000a\\\\u0009\\\\u0009\\\\u000aYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-content-social-base\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/content_social\\\\\\\\/content-social-base-min-1339203.js\\\\\\\"},\\\\\\\"media-content-follow-property\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/content_social\\\\\\\\/content-follow-property-min-1306078.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\\\u000aYMedia.applyConfig(YUI.YUICfg);\\\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\\\u000aYMedia.use(\\\\\\\"media-content-social-base\\\\\\\",\\\\\\\"media-content-follow-property\\\\\\\",\\\\\\\"base\\\\\\\",\\\\\\\"event\\\\\\\",\\\\\\\"node\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a    Y.later(10, this, function() {new Y.Media.MediaContentFollowProperty({\\\\\\\"item_facebook\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"www.facebook.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"facebook\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Facebook\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"item_twitter\\\\\\\":{\\\\\\\"follow_url\\\\\\\":\\\\\\\"twitter.com\\\\\\\",\\\\\\\"follow_site\\\\\\\":\\\\\\\"twitter\\\\\\\",\\\\\\\"follow_id\\\\\\\":\\\\\\\"yahoonews\\\\\\\",\\\\\\\"follow_title\\\\\\\":\\\\\\\" on Twitter\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en_US\\\\\\\",\\\\\\\"tracking\\\\\\\":\\\\\\\"data-ylk=\\\\\\\\\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"outcome\\\\\\\":\\\\\\\"share\\\\\\\",\\\\\\\"is_tumblr\\\\\\\":false},\\\\\\\"mod_id\\\\\\\":\\\\\\\"mediacontentfollowproperty\\\\\\\",\\\\\\\"mixer\\\\\\\":{\\\\\\\"site\\\\\\\":\\\\\\\"news\\\\\\\",\\\\\\\"region\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"scrumb\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"content_id\\\\\\\":\\\\\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\\\\\",\\\\\\\"title_orig\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"url_orig\\\\\\\":\\\\\\\"\\\\\\\"}});});\\\\u000a\\\\u0009\\\\u0009   \\\\u000a});\\\\u000a\\\\u000aYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\u000aYMedia.use(\\\\\\\"\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentfollowproperty\\\\\\\"); } }());\\\\u000a    });\\\\u000a});\\\\u000a});\\\\u000a\\\\u0009\\\\u0009\\\\u000a\\\\u0009    \\\\u003C/script\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddaba7d48ef\\\\u000d\\\\u000aContent-Type: text/html; charset=utf-8\\\\u000d\\\\u000a\\\\u000d\\\\u000a \\\\u003Csection class=\\\\\\\"yom-mod \\\\\\\" id=\\\\\\\"mediacontentfollowproperty\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\"yom-follow-property\\\\\\\" class=\\\\\\\"yom-mod yom-follow-property\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\\\\\"\\\\u003E \\\\u003Cdiv class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ch3\\\\u003EFollow Yahoo! News\\\\u003C/h3\\\\u003E \\\\u003C/div\\\\u003E \\\\u003Cdiv class=\\\\\\\"bd\\\\\\\"\\\\u003E \\\\u003Cul\\\\u003E   \\\\u003Cli class=\\\\\\\"follow-property-facebook clearfix\\\\\\\"\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.facebook.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.facebook.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Facebook\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E on Facebook\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003C/li\\\\u003E     \\\\u003Cli class=\\\\\\\"follow-property-twitter clearfix\\\\\\\"\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-icon\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://twitter.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003Cdiv class=\\\\\\\"follow-title\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://twitter.com/yahoonews\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" title=\\\\\\\" on Twitter\\\\\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E on Twitter\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E \\\\u003C/li\\\\u003E    \\\\u003C/ul\\\\u003E \\\\u003C/div\\\\u003E \\\\u003C/div\\\\u003E \\\\u003C/section\\\\u003E\\\\u000a\\\\u000d\\\\u000a--dali-response-split-51ddaba7d48ef--\\\\u000d\\\\u000a\\\"\\u000a            });\\u000a        }\\u000a    },]);\\u000a});\"), (\"s4bbd8ffb39da34178657e7c4f3c0d136f83459b8\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-viewport-loader\", ((function() {\n        var s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_0_instance;\n        ((s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_0_instance) = ((JSBNG_Record.eventInstance)((\"s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_0\"), (s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"Media\")))[(\"Media\")]), (\"ViewportLoader\")))[(\"ViewportLoader\")]), (\"addContainers\")))[(\"addContainers\")])([{\n                selector: \"#mediacontentfollowproperty_container\",\n                callback: ((function() {\n                    var s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_1_instance;\n                    ((s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_1_instance) = ((JSBNG_Record.eventInstance)((\"s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_1\"))));\n                    return ((JSBNG_Record.markFunction)((function(node) {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_1\"), (s4bbd8ffb39da34178657e7c4f3c0d136f83459b8_1_instance), (this), (arguments)))\n                        };\n                        (null);\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RMP\")))[(\"RMP\")]), (\"load\")))[(\"load\")])({\n                            srcNode: \"#mediacontentfollowproperty_container\",\n                            response: \"\\u000d\\u000a--dali-response-split-51ddaba7d48ef\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: top\\u000d\\u000a\\u000d\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?os/mit/media/m/content_social/media-content-follow-property-desktop-min-1339299.css\\\" /\\u003E\\u000d\\u000a--dali-response-split-51ddaba7d48ef\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: bottom\\u000d\\u000a\\u000d\\u000a\\u003Cscript language=\\\"javascript\\\"\\u003E\\u000a\\u0009\\u0009\\u000aYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-content-social-base\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-social-base-min-1339203.js\\\"},\\\"media-content-follow-property\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_social\\\\/content-follow-property-min-1306078.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\u000aYMedia.use(\\\"media-content-social-base\\\",\\\"media-content-follow-property\\\",\\\"base\\\",\\\"event\\\",\\\"node\\\",function(Y){\\u000a    \\u0009  \\u000a    Y.later(10, this, function() {new Y.Media.MediaContentFollowProperty({\\\"item_facebook\\\":{\\\"follow_url\\\":\\\"www.facebook.com\\\",\\\"follow_site\\\":\\\"facebook\\\",\\\"follow_id\\\":\\\"yahoonews\\\",\\\"follow_title\\\":\\\" on Facebook\\\",\\\"lang\\\":\\\"en_US\\\",\\\"tracking\\\":\\\"data-ylk=\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;\\\\\\\"\\\",\\\"outcome\\\":\\\"share\\\",\\\"is_tumblr\\\":false},\\\"item_twitter\\\":{\\\"follow_url\\\":\\\"twitter.com\\\",\\\"follow_site\\\":\\\"twitter\\\",\\\"follow_id\\\":\\\"yahoonews\\\",\\\"follow_title\\\":\\\" on Twitter\\\",\\\"lang\\\":\\\"en_US\\\",\\\"tracking\\\":\\\"data-ylk=\\\\\\\"sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;\\\\\\\"\\\",\\\"outcome\\\":\\\"share\\\",\\\"is_tumblr\\\":false},\\\"mod_id\\\":\\\"mediacontentfollowproperty\\\",\\\"mixer\\\":{\\\"site\\\":\\\"news\\\",\\\"region\\\":\\\"US\\\",\\\"lang\\\":\\\"en-US\\\",\\\"scrumb\\\":\\\"\\\",\\\"content_id\\\":\\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\\"title_orig\\\":\\\"\\\",\\\"url_orig\\\":\\\"\\\"}});});\\u000a\\u0009\\u0009   \\u000a});\\u000a\\u000aYUI.Env.add(window, \\\"load\\\", function(){\\u000aYMedia.use(\\\"\\\",function(Y){\\u000a    \\u0009  \\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\"mediacontentfollowproperty\\\"); } }());\\u000a    });\\u000a});\\u000a});\\u000a\\u0009\\u0009\\u000a\\u0009    \\u003C/script\\u003E\\u000d\\u000a--dali-response-split-51ddaba7d48ef\\u000d\\u000aContent-Type: text/html; charset=utf-8\\u000d\\u000a\\u000d\\u000a \\u003Csection class=\\\"yom-mod \\\" id=\\\"mediacontentfollowproperty\\\" data-ylk=\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\"\\u003E  \\u003Cdiv id=\\\"yom-follow-property\\\" class=\\\"yom-mod yom-follow-property\\\" data-ylk=\\\"mid:mediacontentfollowproperty;mpos:1;sec:mod-sh-fwm;test:;set:mod-sh-fwm;itc:1;\\\"\\u003E \\u003Cdiv class=\\\"hd\\\"\\u003E \\u003Ch3\\u003EFollow Yahoo! News\\u003C/h3\\u003E \\u003C/div\\u003E \\u003Cdiv class=\\\"bd\\\"\\u003E \\u003Cul\\u003E   \\u003Cli class=\\\"follow-property-facebook clearfix\\\"\\u003E \\u003Cdiv class=\\\"follow-icon\\\"\\u003E\\u003Ca href=\\\"http://www.facebook.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Facebook\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E \\u003Cdiv class=\\\"follow-title\\\"\\u003E\\u003Ca href=\\\"http://www.facebook.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Facebook\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-fb;&quot; data-action-outcome=\\\"share\\\"\\u003E on Facebook\\u003C/a\\u003E\\u003C/div\\u003E \\u003C/li\\u003E     \\u003Cli class=\\\"follow-property-twitter clearfix\\\"\\u003E \\u003Cdiv class=\\\"follow-icon\\\"\\u003E\\u003Ca href=\\\"http://twitter.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Twitter\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003C/div\\u003E \\u003Cdiv class=\\\"follow-title\\\"\\u003E\\u003Ca href=\\\"http://twitter.com/yahoonews\\\" role=\\\"link\\\" target=\\\"_blank\\\" title=\\\" on Twitter\\\" data-ylk=&quot;sec:mod-sh-fwm;itc:1;test:;act:click;slk:btn-sh-tw;&quot; data-action-outcome=\\\"share\\\"\\u003E on Twitter\\u003C/a\\u003E\\u003C/div\\u003E \\u003C/li\\u003E    \\u003C/ul\\u003E \\u003C/div\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\u000a\\u000d\\u000a--dali-response-split-51ddaba7d48ef--\\u000d\\u000a\"\n                        });\n                    })));\n                })())\n            },]);\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"media-rmp\\\", \\\"media-viewport-loader\\\", function(Y) {\\u000a    Y.Global.Media.ViewportLoader.addContainers([{\\u000a        selector: \\\"#mediacontentweather_container\\\",\\u000a        callback: function(node) {\\u000a            Y.Media.RMP.load({\\u000a                srcNode: \\\"#mediacontentweather_container\\\",\\u000a                response: \\\"\\\\u000d\\\\u000a--dali-response-split-51ddabac717dc\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: top\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?rl/ulw/2.2.3/location_widget-min.css&os/mit/media/m/content_index/weather-desktop-min-1311126.css\\\\\\\" /\\\\u003E\\\\u000a\\\\u000a\\\\u0009\\\\u0009\\\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\\\u003E\\\\u000a\\\\u0009\\\\u0009\\\\u000aYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-lw-base64\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\/ulw\\\\\\\\/2.2.3\\\\\\\\/lw-base64-min.js\\\\\\\"},\\\\\\\"media-lw-overlay\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"rl\\\\\\\\/ulw\\\\\\\\/2.2.3\\\\\\\\/lw-overlay-min.js\\\\\\\"},\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/weather\\\\\\\\/locdrop-patch-2.2.4-min-1275196.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\\\u000aYMedia.applyConfig(YUI.YUICfg);\\\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\\\u000aYMedia.use(\\\\\\\"media-lw-base64\\\\\\\",\\\\\\\"media-lw-overlay\\\\\\\",\\\\\\\"media-locdrop-patch-2.2.4\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a\\\\u0009\\\\u0009   \\\\u000a});\\\\u000a\\\\u000a\\\\u0009\\\\u0009\\\\u000a\\\\u0009    \\\\u003C/script\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddabac717dc\\\\u000d\\\\u000aContent-Type: text/plain; charset=utf-8\\\\u000d\\\\u000aRMP-Embed-Location: bottom\\\\u000d\\\\u000a\\\\u000d\\\\u000a\\\\u003Cscript language=\\\\\\\"javascript\\\\\\\"\\\\u003E\\\\u000a\\\\u0009\\\\u0009\\\\u000aYUI.YUICfg = {\\\\\\\"gallery\\\\\\\":\\\\\\\"gallery-2011.04.20-13-04\\\\\\\",\\\\\\\"groups\\\\\\\":{\\\\\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\\\\\":{\\\\\\\"base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/\\\\\\\",\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"modules\\\\\\\":{\\\\\\\"media-weather\\\\\\\":{\\\\\\\"path\\\\\\\":\\\\\\\"os\\\\\\\\/mit\\\\\\\\/media\\\\\\\\/m\\\\\\\\/content_index\\\\\\\\/weather-min-1321733.js\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"filter\\\\\\\":\\\\\\\"min\\\\\\\",\\\\\\\"root\\\\\\\":\\\\\\\"\\\\\\\\/\\\\\\\"}},\\\\\\\"combine\\\\\\\":true,\\\\\\\"allowRollup\\\\\\\":true,\\\\\\\"comboBase\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/zz\\\\\\\\/combo?\\\\\\\",\\\\\\\"maxURLLength\\\\\\\":\\\\\\\"2000\\\\\\\"}\\\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\\\u000aYMedia.applyConfig(YUI.YUICfg);\\\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\\\u000aYMedia.use(\\\\\\\"media-weather\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a\\\\u0009\\\\u0009   \\\\u000a});\\\\u000a\\\\u000aYUI.Env.add(window, \\\\\\\"load\\\\\\\", function(){\\\\u000aYMedia.use(\\\\\\\"media-weather\\\\\\\",\\\\\\\"jsonp\\\\\\\",\\\\\\\"jsonp-url\\\\\\\",\\\\\\\"node-focusmanager\\\\\\\",\\\\\\\"lw-overlay\\\\\\\",\\\\\\\"lw-base64\\\\\\\",\\\\\\\"ulwv2-locdrop\\\\\\\",\\\\\\\"array-extras\\\\\\\",function(Y){\\\\u000a    \\\\u0009  \\\\u000a    Y.later(10, this, function() {Y.Media.Weather.MediaContentWeather.Weather.init({\\\\\\\"modId\\\\\\\":\\\\\\\"mediacontentweather\\\\\\\",\\\\\\\"bucket\\\\\\\":null,\\\\\\\"crumbVal\\\\\\\":\\\\\\\"cXpTTEhvVld2bm8-\\\\\\\",\\\\\\\"curLocObj\\\\\\\":{\\\\\\\"addr\\\\\\\":\\\\\\\"Lafayette, Indiana, United States, 47905\\\\\\\",\\\\\\\"app\\\\\\\":\\\\\\\"yahoo.globalmedia.auth-yca.ups.env-prod\\\\\\\",\\\\\\\"cc\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"city\\\\\\\":\\\\\\\"Lafayette\\\\\\\",\\\\\\\"conf\\\\\\\":60,\\\\\\\"country_conf\\\\\\\":90,\\\\\\\"ctry\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"ctx\\\\\\\":\\\\\\\"global\\\\\\\",\\\\\\\"dtime\\\\\\\":\\\\\\\"2013-07-10T18:45:00Z\\\\\\\",\\\\\\\"freq\\\\\\\":1,\\\\\\\"id\\\\\\\":\\\\\\\"id_current\\\\\\\",\\\\\\\"input\\\\\\\":\\\\\\\"ip\\\\\\\",\\\\\\\"lat\\\\\\\":40.424388885498,\\\\\\\"lon\\\\\\\":-86.808479309082,\\\\\\\"lvl\\\\\\\":1,\\\\\\\"rad\\\\\\\":15781,\\\\\\\"raw\\\\\\\":\\\\\\\"98.215.10.79\\\\\\\",\\\\\\\"sc\\\\\\\":\\\\\\\"IN\\\\\\\",\\\\\\\"src\\\\\\\":\\\\\\\"gt_locip\\\\\\\",\\\\\\\"state\\\\\\\":\\\\\\\"Indiana\\\\\\\",\\\\\\\"state_conf\\\\\\\":60,\\\\\\\"town_conf\\\\\\\":60,\\\\\\\"type\\\\\\\":\\\\\\\"physical\\\\\\\",\\\\\\\"woe\\\\\\\":12778444,\\\\\\\"woetype\\\\\\\":\\\\\\\"zip\\\\\\\",\\\\\\\"zip\\\\\\\":\\\\\\\"47905\\\\\\\",\\\\\\\"zip_conf\\\\\\\":60},\\\\\\\"defLocObj\\\\\\\":null,\\\\\\\"spaceId\\\\\\\":\\\\\\\"2143334674\\\\\\\",\\\\\\\"locale\\\\\\\":\\\\\\\"en-US\\\\\\\",\\\\\\\"lang\\\\\\\":\\\\\\\"US\\\\\\\",\\\\\\\"fpHost\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/weather.yahoo.com\\\\\\\",\\\\\\\"unit\\\\\\\":\\\\\\\"f\\\\\\\"});\\\\u000a    });\\\\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\\\\\"mediacontentweather\\\\\\\"); } }());\\\\u000a    });\\\\u000a});\\\\u000a});\\\\u000a\\\\u0009\\\\u0009\\\\u000a\\\\u0009    \\\\u003C/script\\\\u003E\\\\u000d\\\\u000a--dali-response-split-51ddabac717dc\\\\u000d\\\\u000aContent-Type: text/html; charset=utf-8\\\\u000d\\\\u000a\\\\u000d\\\\u000a \\\\u003Csection class=\\\\\\\"yom-mod yom-weather yom-app clearfix\\\\\\\" id=\\\\\\\"mediacontentweather\\\\\\\" data-ylk=\\\\\\\"mid:mediacontentweather;mpos:1;sec:app-wea;\\\\\\\"\\\\u003E  \\\\u003Cform id=\\\\\\\"fixIE10Enter\\\\\\\" onsubmit=\\\\\\\"return false;\\\\\\\"\\\\u003E \\\\u003Ch2 class=\\\\\\\"hide\\\\\\\"\\\\u003EWeather Today\\\\u003C/h2\\\\u003E  \\\\u003Cul\\\\u003E  \\\\u003Cli class=\\\\\\\"current clearfix\\\\\\\" data-uri=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\\\\\" alt=\\\\\\\"Light Rain\\\\\\\" title=\\\\\\\"Light Rain\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Cp id=\\\\\\\"weather_lw_switch\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"ell\\\\\\\" title=\\\\\\\"Lafayette, IN\\\\\\\"\\\\u003ELafayette, IN\\\\u003C/span\\\\u003E \\\\u003Cspan id=\\\\\\\"ulw-start\\\\\\\"\\\\u003E&nbsp;\\\\u003C/span\\\\u003E\\\\u003C/p\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"cond\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:1;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cem class=\\\\\\\"temp temp-f \\\\\\\"\\\\u003E 70\\\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\\\u003E&deg;F\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\\\u003ELight Rain\\\\u003C/span\\\\u003E \\\\u003C/em\\\\u003E \\\\u003Cem class=\\\\\\\"temp temp-c hide\\\\\\\"\\\\u003E 21\\\\u003Cspan class=\\\\\\\"unit\\\\\\\"\\\\u003E&deg;C\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"cond-title\\\\\\\"\\\\u003ELight Rain\\\\u003C/span\\\\u003E \\\\u003C/em\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E   \\\\u003Cli class=\\\\\\\"forecast\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003EToday\\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E84&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E60&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E29&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E16&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E  \\\\u003Cli class=\\\\\\\"forecast\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/33_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003ETomorrow\\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E81&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E55&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E27&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E13&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E  \\\\u003Cli class=\\\\\\\"forecast\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cimg src=\\\\\\\"http://l4.yimg.com/dh/ap/default/121210/31_IE6.png\\\\\\\" alt=\\\\\\\"\\\\\\\" class=\\\\\\\"cond-icon\\\\\\\"\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ch3 class=\\\\\\\"hd\\\\\\\"\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"ell\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003EFriday\\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-f \\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E79&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E57&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003Ca href=\\\\\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\\\\\" class=\\\\\\\"temp temp-c hide\\\\\\\" data-ylk=\\\\\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"high\\\\\\\"\\\\u003E26&deg;\\\\u003C/span\\\\u003E \\\\u003Cspan class=\\\\\\\"low\\\\\\\"\\\\u003E14&deg;\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/h3\\\\u003E \\\\u003C/li\\\\u003E  \\\\u003C/ul\\\\u003E   \\\\u003C/form\\\\u003E \\\\u003Cdiv class=\\\\\\\"weather_credit\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"weather_credit_text\\\\\\\"\\\\u003EPowered by\\\\u003C/span\\\\u003E \\\\u003Ca href=\\\\\\\"http://www.weather.com\\\\\\\" class=\\\\\\\"twc_icon\\\\\\\"\\\\u003E \\\\u003Cspan class=\\\\\\\"weather_twc_icon\\\\\\\"/\\\\u003E\\\\u003C/span\\\\u003E \\\\u003C/a\\\\u003E \\\\u003C/div\\\\u003E \\\\u003C/section\\\\u003E\\\\u000a\\\\u000d\\\\u000a--dali-response-split-51ddabac717dc--\\\\u000d\\\\u000a\\\"\\u000a            });\\u000a        }\\u000a    },]);\\u000a});\"), (\"s3ecd05f647c150795f9a9e7543aae448609e1469\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-viewport-loader\", ((function() {\n        var s3ecd05f647c150795f9a9e7543aae448609e1469_0_instance;\n        ((s3ecd05f647c150795f9a9e7543aae448609e1469_0_instance) = ((JSBNG_Record.eventInstance)((\"s3ecd05f647c150795f9a9e7543aae448609e1469_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s3ecd05f647c150795f9a9e7543aae448609e1469_0\"), (s3ecd05f647c150795f9a9e7543aae448609e1469_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"Media\")))[(\"Media\")]), (\"ViewportLoader\")))[(\"ViewportLoader\")]), (\"addContainers\")))[(\"addContainers\")])([{\n                selector: \"#mediacontentweather_container\",\n                callback: ((function() {\n                    var s3ecd05f647c150795f9a9e7543aae448609e1469_1_instance;\n                    ((s3ecd05f647c150795f9a9e7543aae448609e1469_1_instance) = ((JSBNG_Record.eventInstance)((\"s3ecd05f647c150795f9a9e7543aae448609e1469_1\"))));\n                    return ((JSBNG_Record.markFunction)((function(node) {\n                        if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                            return ((JSBNG_Record.eventCall)((arguments.callee), (\"s3ecd05f647c150795f9a9e7543aae448609e1469_1\"), (s3ecd05f647c150795f9a9e7543aae448609e1469_1_instance), (this), (arguments)))\n                        };\n                        (null);\n                        (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RMP\")))[(\"RMP\")]), (\"load\")))[(\"load\")])({\n                            srcNode: \"#mediacontentweather_container\",\n                            response: \"\\u000d\\u000a--dali-response-split-51ddabac717dc\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: top\\u000d\\u000a\\u000d\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?rl/ulw/2.2.3/location_widget-min.css&os/mit/media/m/content_index/weather-desktop-min-1311126.css\\\" /\\u003E\\u000a\\u000a\\u0009\\u0009\\u003Cscript language=\\\"javascript\\\"\\u003E\\u000a\\u0009\\u0009\\u000aYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-lw-base64\\\":{\\\"path\\\":\\\"rl\\\\/ulw\\\\/2.2.3\\\\/lw-base64-min.js\\\"},\\\"media-lw-overlay\\\":{\\\"path\\\":\\\"rl\\\\/ulw\\\\/2.2.3\\\\/lw-overlay-min.js\\\"},\\\"media-locdrop-patch-2.2.4\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/weather\\\\/locdrop-patch-2.2.4-min-1275196.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\u000aYMedia.use(\\\"media-lw-base64\\\",\\\"media-lw-overlay\\\",\\\"media-locdrop-patch-2.2.4\\\",function(Y){\\u000a    \\u0009  \\u000a\\u0009\\u0009   \\u000a});\\u000a\\u000a\\u0009\\u0009\\u000a\\u0009    \\u003C/script\\u003E\\u000d\\u000a--dali-response-split-51ddabac717dc\\u000d\\u000aContent-Type: text/plain; charset=utf-8\\u000d\\u000aRMP-Embed-Location: bottom\\u000d\\u000a\\u000d\\u000a\\u003Cscript language=\\\"javascript\\\"\\u003E\\u000a\\u0009\\u0009\\u000aYUI.YUICfg = {\\\"gallery\\\":\\\"gallery-2011.04.20-13-04\\\",\\\"groups\\\":{\\\"group01c9d8dea06e05460a64eed4dadd622b6\\\":{\\\"base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/\\\",\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"modules\\\":{\\\"media-weather\\\":{\\\"path\\\":\\\"os\\\\/mit\\\\/media\\\\/m\\\\/content_index\\\\/weather-min-1321733.js\\\"}},\\\"combine\\\":true,\\\"filter\\\":\\\"min\\\",\\\"root\\\":\\\"\\\\/\\\"}},\\\"combine\\\":true,\\\"allowRollup\\\":true,\\\"comboBase\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/zz\\\\/combo?\\\",\\\"maxURLLength\\\":\\\"2000\\\"}\\u000aYUI.YUICfg.root='yui:'+YUI.version+'/build/';\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = 'yui:gallery-2011.04.20-13-04/build/';\\u000aYMedia.use(\\\"media-weather\\\",function(Y){\\u000a    \\u0009  \\u000a\\u0009\\u0009   \\u000a});\\u000a\\u000aYUI.Env.add(window, \\\"load\\\", function(){\\u000aYMedia.use(\\\"media-weather\\\",\\\"jsonp\\\",\\\"jsonp-url\\\",\\\"node-focusmanager\\\",\\\"lw-overlay\\\",\\\"lw-base64\\\",\\\"ulwv2-locdrop\\\",\\\"array-extras\\\",function(Y){\\u000a    \\u0009  \\u000a    Y.later(10, this, function() {Y.Media.Weather.MediaContentWeather.Weather.init({\\\"modId\\\":\\\"mediacontentweather\\\",\\\"bucket\\\":null,\\\"crumbVal\\\":\\\"cXpTTEhvVld2bm8-\\\",\\\"curLocObj\\\":{\\\"addr\\\":\\\"Lafayette, Indiana, United States, 47905\\\",\\\"app\\\":\\\"yahoo.globalmedia.auth-yca.ups.env-prod\\\",\\\"cc\\\":\\\"US\\\",\\\"city\\\":\\\"Lafayette\\\",\\\"conf\\\":60,\\\"country_conf\\\":90,\\\"ctry\\\":\\\"United States\\\",\\\"ctx\\\":\\\"global\\\",\\\"dtime\\\":\\\"2013-07-10T18:45:00Z\\\",\\\"freq\\\":1,\\\"id\\\":\\\"id_current\\\",\\\"input\\\":\\\"ip\\\",\\\"lat\\\":40.424388885498,\\\"lon\\\":-86.808479309082,\\\"lvl\\\":1,\\\"rad\\\":15781,\\\"raw\\\":\\\"98.215.10.79\\\",\\\"sc\\\":\\\"IN\\\",\\\"src\\\":\\\"gt_locip\\\",\\\"state\\\":\\\"Indiana\\\",\\\"state_conf\\\":60,\\\"town_conf\\\":60,\\\"type\\\":\\\"physical\\\",\\\"woe\\\":12778444,\\\"woetype\\\":\\\"zip\\\",\\\"zip\\\":\\\"47905\\\",\\\"zip_conf\\\":60},\\\"defLocObj\\\":null,\\\"spaceId\\\":\\\"2143334674\\\",\\\"locale\\\":\\\"en-US\\\",\\\"lang\\\":\\\"US\\\",\\\"fpHost\\\":\\\"http:\\\\/\\\\/weather.yahoo.com\\\",\\\"unit\\\":\\\"f\\\"});\\u000a    });\\u000a    Y.later(10, this, function() {(function(){ var rapid = YMedia.rapid; if (rapid) { rapid.addModules(\\\"mediacontentweather\\\"); } }());\\u000a    });\\u000a});\\u000a});\\u000a\\u0009\\u0009\\u000a\\u0009    \\u003C/script\\u003E\\u000d\\u000a--dali-response-split-51ddabac717dc\\u000d\\u000aContent-Type: text/html; charset=utf-8\\u000d\\u000a\\u000d\\u000a \\u003Csection class=\\\"yom-mod yom-weather yom-app clearfix\\\" id=\\\"mediacontentweather\\\" data-ylk=\\\"mid:mediacontentweather;mpos:1;sec:app-wea;\\\"\\u003E  \\u003Cform id=\\\"fixIE10Enter\\\" onsubmit=\\\"return false;\\\"\\u003E \\u003Ch2 class=\\\"hide\\\"\\u003EWeather Today\\u003C/h2\\u003E  \\u003Cul\\u003E  \\u003Cli class=\\\"current clearfix\\\" data-uri=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:1;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\" alt=\\\"Light Rain\\\" title=\\\"Light Rain\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Cp id=\\\"weather_lw_switch\\\"\\u003E \\u003Cspan class=\\\"ell\\\" title=\\\"Lafayette, IN\\\"\\u003ELafayette, IN\\u003C/span\\u003E \\u003Cspan id=\\\"ulw-start\\\"\\u003E&nbsp;\\u003C/span\\u003E\\u003C/p\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"cond\\\" data-ylk=\\\"sec:app-wea;cpos:1;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cem class=\\\"temp temp-f \\\"\\u003E 70\\u003Cspan class=\\\"unit\\\"\\u003E&deg;F\\u003C/span\\u003E\\u003Cspan class=\\\"cond-title\\\"\\u003ELight Rain\\u003C/span\\u003E \\u003C/em\\u003E \\u003Cem class=\\\"temp temp-c hide\\\"\\u003E 21\\u003Cspan class=\\\"unit\\\"\\u003E&deg;C\\u003C/span\\u003E\\u003Cspan class=\\\"cond-title\\\"\\u003ELight Rain\\u003C/span\\u003E \\u003C/em\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E   \\u003Cli class=\\\"forecast\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/8_IE6.png\\\" alt=\\\"\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"ell\\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003EToday\\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-f \\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E84&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E60&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-c hide\\\" data-ylk=\\\"sec:app-wea;cpos:2;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E29&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E16&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E  \\u003Cli class=\\\"forecast\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/33_IE6.png\\\" alt=\\\"\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"ell\\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003ETomorrow\\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-f \\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E81&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E55&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-c hide\\\" data-ylk=\\\"sec:app-wea;cpos:3;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E27&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E13&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E  \\u003Cli class=\\\"forecast\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:1;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cimg src=\\\"http://l4.yimg.com/dh/ap/default/121210/31_IE6.png\\\" alt=\\\"\\\" class=\\\"cond-icon\\\"\\u003E \\u003C/a\\u003E \\u003Ch3 class=\\\"hd\\\"\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"ell\\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:2;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003EFriday\\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-f \\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E79&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E57&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003Ca href=\\\"http://weather.yahoo.com/united-states/indiana/lafayette-12778444/\\\" class=\\\"temp temp-c hide\\\" data-ylk=\\\"sec:app-wea;cpos:4;pos:3;itc:0;tar:weather.yahoo.com;slk:link;test:;\\\"\\u003E \\u003Cspan class=\\\"high\\\"\\u003E26&deg;\\u003C/span\\u003E \\u003Cspan class=\\\"low\\\"\\u003E14&deg;\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/h3\\u003E \\u003C/li\\u003E  \\u003C/ul\\u003E   \\u003C/form\\u003E \\u003Cdiv class=\\\"weather_credit\\\"\\u003E \\u003Cspan class=\\\"weather_credit_text\\\"\\u003EPowered by\\u003C/span\\u003E \\u003Ca href=\\\"http://www.weather.com\\\" class=\\\"twc_icon\\\"\\u003E \\u003Cspan class=\\\"weather_twc_icon\\\"/\\u003E\\u003C/span\\u003E \\u003C/a\\u003E \\u003C/div\\u003E \\u003C/section\\u003E\\u000a\\u000d\\u000a--dali-response-split-51ddabac717dc--\\u000d\\u000a\"\n                        });\n                    })));\n                })())\n            },]);\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\ntry {\n    ((JSBNG_Record.scriptLoad)((\"YMedia.use(\\\"media-rmp\\\", function(Y) {\\u000a    Y.Media.RMP.load({\\u000a        srcNode: \\\"#p_30345786_container\\\",\\u000a        continueOnError: true,\\u000a        response: \\\"--dali-response-split-51ddabac509b3Content-Type: text/plain; charset=utf-8\\\\u000aRMP-Embed-Location: top\\\\u000a\\\\u000a\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/ui/helpers_0.0.6.css&nn/lib/metro/g/ui/typography_0.0.2.css&nn/lib/metro/g/theme/default/common_0.0.29.css&nn/lib/metro/g/theme/default/desktop_0.0.62.css&nn/lib/metro/g/uiplugins/tooltip_service_1.0.12.css\\\\\\\" /\\\\u003E\\\\u000a\\\\u000a\\\\u003Clink rel=\\\\\\\"stylesheet\\\\\\\" type=\\\\\\\"text/css\\\\\\\" href=\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/stream/stream_0.0.271.css&nn/lib/metro/g/stream/theme_gs_0.0.45.css&nn/lib/metro/g/uiplugins/login_service_0.0.3.css&nn/lib/metro/g/stream/rmx_ads_0.0.8.css&nn/lib/metro/g/fstream/fstream_desktop_0.0.21.css&nn/lib/metro/g/login/login_0.0.71.css\\\\\\\" /\\\\u003E\\\\u000a\\\\u000a--dali-response-split-51ddabac509b3Content-Type: text/html; charset=utf-8\\\\u000aRMP-Embed-Location: bottom\\\\u000a\\\\u000a\\\\u003Cdiv id=\\\\\\\"p_30345786\\\\\\\" class=\\\\\\\"rapidnofollow rapid-container dev-desktop\\\\\\\" data-ylk=\\\\\\\"sec:td-strm\\\\\\\"\\\\u003E\\\\u000a\\\\u003Cdiv id=\\\\\\\"default-u_30345786\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\"default-u_30345786-bd\\\\\\\" class=\\\\\\\"bd type_stream type_stream_default\\\\\\\"\\\\u003E\\\\u003Cdiv id=\\\\\\\"default-p_30345810_fcd\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\"default-p_30345810_fcd-bd\\\\\\\" class=\\\\\\\"bd type_fstream type_fstream_default\\\\\\\"\\\\u003E\\\\u003Cstyle\\\\u003E .type_fstream .dropdown-label-text, .type_fstream .tab-list .filter-item .filter-name, .type_fstream .filter-bar-section { background-color:#0e2b5c !important;border:solid 1px #0e2b5c !important;color:#fff !important } .type_fstream .tab-list .filter-item { opacity: 0.7; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=70)\\\\\\\"; filter: alpha(opacity=70); }.type_fstream .tab-list .filter-selected { opacity: 1; -ms-filter:\\\\\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\\\\\\\"; filter: alpha(opacity=100); }\\\\u003C/style\\\\u003E\\\\u003Cdiv class=\\\\\\\"filter-bar-section\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"tab-list d-ib fz-xs pos-r\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROP:TOPSTORIES;cpos:1;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EAll News\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"LISTID:c435b248-2107-445e-97ea-89e2ec5df60c\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:LISTID:c435b248-2107-445e-97ea-89e2ec5df60c;cpos:2;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EY! News Originals\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ABCNEWS\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ABCNEWS;cpos:3;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EABC News\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:ap.org\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:ap.org;cpos:4;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EAP\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"filter-item d-ib\\\\\\\" data-filter=\\\\\\\"YPROV:reuters.com\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Ca href=\\\\\\\"#\\\\\\\" data-ylk=\\\\\\\"sec:fltr-strm;slk:YPROV:reuters.com;cpos:5;pos:0;ft:1\\\\\\\"  data-action-outcome=\\\\\\\"filter\\\\\\\" class=\\\\\\\"filter-name rapidnofollow fz-s\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003EReuters\\\\u003C/a\\\\u003E\\\\u000a\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E    \\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u003Cul\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:1;pkgt:4;ccode:news;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fexpert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000667|YCT:001000780|WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002721;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-15px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/XITng7YWKM1CwU3GfV_RdA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTg1/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg');\\\\\\\" width=\\\\\\\"111\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002721;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EExpert: Zimmerman was in worse shape than Martin\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ESANFORD, Fla. (AP) \\\\u2014 A Florida judge ruled Wednesday that Trayvon Martin&#39;s cellphone text messages about fighting and a defense animation depicting the struggle between Martin and George Zimmerman won&#39;t be introduced as evidence at Zimmerman&#39;s trial. Defense attorneys had wanted to use those pieces\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/society-and-culture/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:1;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ESociety\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/shooting-of-trayvon-martin/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\" data-ylk=\\\\\\\"slk:Shooting of Trayvon Martin;sec:td-strm;cpos:2;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EShooting of Trayvon Martin\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"950129f1-e974-33ae-b739-227b6ca2e187\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:2;pkgt:3;ccode:news;g:950129f1-e974-33ae-b739-227b6ca2e187;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fblogs%2Ftrending-now%2Ftoddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/blogs/trending-now/toddler-buys-car-ebay-using-father-smartphone-172026670.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:2;g:950129f1-e974-33ae-b739-227b6ca2e187;tar:news.yahoo.com;ltxt:ToddlerB;ct:2;pkgt:3;r:4100001328;slk:title;itc:0;prov:TrendingNow;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EToddler Buys Car on eBay Using Father\\\\u2019s Smartphone\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ELast month Sorella Stoute from Portland, Oregon, purchased a 1962 Austin-Healey Sprite on eBay. Now, this might not sound like much of a story, until you learn that Sorella is only 14 months old. Here&#39;s what happened. The tiny online shopper was playing with her father Paul Stoute&#39;s smartphone when\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003ETrending Now\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21675196\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:3;pkgt:4;ccode:news;g:21675196;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o%3D%2Chttp%253A%252F%252Fwww.nextag.com%252Fgoto.jsp%253Fp%253D357374%2526crid%253D70102%2526search%253Ddress\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http://ad.yieldmanager.com/csc?ve=2&V0nyIPZ2wp3wBusYIXHe592L0U7rDWPGQGsA2NLVx3J0KeGD1Gapax21gVu.4ub8eFnCFz8GoX6lzjIPOHbY1UKvAs1CeuA60UvO0.YaI6H7fSjP2UaZY6JWBoP.Y4JRu2UyaZwxD04xOZvyPdQNGYVq9AxUfRnsNZF1Y6L06KkTBbSIxFyk3TTzx.JT3qi5JFlL2QTq7h3z8NjNyDeGKHRzDxkl6_yoxQKIxLF4m8y40IG6XudIj8DF9b64cUQQHhIJHXEGWMyFysCaCq98U1ZQSR.9S_3ymGqOz5p_GZi3eptf_vUuH9Aorn5IDOJWPdjFst6IAPJXboFx_0c7_RynZr29hWH.4Y73607V3wk6aAzvWLpFV3H8bmYeKn7meWf_9d_9949AaqS_QIJLaKMWA0Dj.rW4FwZNiE61P3yRpuUx3CmmBvSFUidR6rNmRk3NYSK3F_6O9FKeYsabBo.PXQ2_tIW0.tpOGYIkRZu4nDEC7bCIucM1b5p55FC8rhu4U.M4XH2cWUOgd4CcG0N7gZqH5k.VG9DQZj9mjTF7HA2Bj9s1WPqooqjd3_gsuIUozyOhUDJk7rWhL0661.aV2jgJhyCpCH69hRILuz89M73USaOMvoeQPZL_7OudoN8niNqPD6xKYuHKCwMsDletkPtsMywAxFmuXCG6Lo4ZaXTaPguHRylbkYAyjmpNmGx_U4zR.55JxLyFd5G_zebInENUmshO.3eWcDycFODZE9bae7e_SzNR.yayrRfbK.xapTXID_8l5O3ZEr.aw9BGFFXyquRWYPTVS2ZrhAuQLfrDUdFiiZehmKEbDiXQAQ--&ap=3\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l2.yimg.com/av/moneyball/ads/bulk/6473/c1b5c4a6baf815019e3f6c79b13674e1.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003ETop 10 Dresses for 2013\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EHottest Dresses on sale.  Awesome selection and deals.\\\\u003C/p\\\\u003E\\\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003EAdChoices\\\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a\\\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EOfficial Nextag Site\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Ca href=\\\\\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003ESponsored\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"a5d908b7-4f0c-3334-81a0-3d378bbeb520\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:4;pkgt:3;ccode:news;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000346|YCT:001000992\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/ntsb-findings-sf-plane-crash-133726993.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:4;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;tar:news.yahoo.com;ltxt:NTSBfind;ct:1;pkgt:3;r:4100001409;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003ENTSB findings on SF plane crash at a glance\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EAfter departing from Shanghai and stopping in Seoul, Asiana Flight 214 makes its final approach into San Francisco International Airport following a 10-hour flight across the Pacific Ocean. A preliminary ...\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/personal-investing-ideas-and-strategies/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000346\\\\\\\" data-ylk=\\\\\\\"slk:Personal Investing Ideas & Strategies;sec:td-strm;cpos:1;itc:0;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPersonal Investing Ideas & Strategies\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"fe94cddd-d36b-3ce5-9246-733c1229ba93\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:5;pkgt:3;ccode:news;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Froyal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000395|YCT:001000495\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://gma.yahoo.com/blogs/abc-blogs/royal-baby-american-british-birthing-practices-differ-115918234.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:5;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;tar:gma.yahoo.com;ltxt:HowKate&;ct:2;pkgt:3;r:4100001170;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EHow Kate&#39;s Delivery Will Differ From U.S. Experience\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EThe future British monarch is due to be born any day now. Kate Middleton will deliver her child at Mary\\\\u2019s Hospital in London, in the same wing where Princess Diana gave birth to her own children. \\\\u201cIt\\\\u2019s a beautiful unit,\\\\u201d Regina Curran, a British midwife,...\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EABC News\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/health/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000395\\\\\\\" data-ylk=\\\\\\\"slk:Health;sec:td-strm;cpos:1;itc:0;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EHealth\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:6;pkgt:3;ccode:news;g:c200730b-eb18-376d-a3d3-1892197b9f54;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fwashington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000680|WIKIID:Barack_Obama|WIKIID:Mohamed_Morsi|WIKIID:Egypt|WIKIID:United_States|WIKIID:Hosni_Mubarak|WIKIID:Cairo\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/washington-vilified-both-sides-egypts-divide-174446715.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:6;g:c200730b-eb18-376d-a3d3-1892197b9f54;tar:news.yahoo.com;ltxt:Washingt;ct:1;pkgt:3;r:4100000835;slk:title;itc:0;prov:Reuters;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EWashington vilified on both sides of Egypt&#39;s divide\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EBy Maggie Fick and Tom Finn CAIRO (Reuters) - Pictures of Barack Obama have popped up all over Cairo. Some have his faced crossed out in paint. Heavy black beards are daubed onto others. No matter which side you talk to in Egypt, where people have been polarized by a violent political crisis, the\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EReuters\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/foreign-policy/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000680\\\\\\\" data-ylk=\\\\\\\"slk:Foreign Policy;sec:td-strm;cpos:2;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EForeign Policy\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/barack-obama/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EBarack Obama\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/mohamed-morsi/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\" data-ylk=\\\\\\\"slk:Mohamed Morsi;sec:td-strm;cpos:4;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EMohamed Morsi\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/egypt/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Egypt\\\\\\\" data-ylk=\\\\\\\"slk:Egypt;sec:td-strm;cpos:5;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EEgypt\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/united-states/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:United_States\\\\\\\" data-ylk=\\\\\\\"slk:United States;sec:td-strm;cpos:6;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EUnited States\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/hosni-mubarak/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\" data-ylk=\\\\\\\"slk:Hosni Mubarak;sec:td-strm;cpos:7;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EHosni Mubarak\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/cairo/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Cairo\\\\\\\" data-ylk=\\\\\\\"slk:Cairo;sec:td-strm;cpos:8;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ECairo\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content slideshow has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"706337c9-1922-33ac-b86f-a5280ffcc242\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:7;pkgt:21;ccode:news;g:706337c9-1922-33ac-b86f-a5280ffcc242;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fphotos%2Fcarpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow%2F\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001665;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l1.yimg.com/ts/api/res/1.2/vv0qulgbBMDqq9r94wVCzw--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz0xMDA7aD0xMDA7cHlvZmY9MA--/http://l.yimg.com/os/publish-images/news/2013-07-09/147c5e94-9385-462b-85d7-4916b61620c4_fire7.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"gallery-icon\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"view-now fz-xxs\\\\\\\"\\\\u003EView\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001665;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-uuid=\\\\\\\"de60ffd9-ff42-4ec7-b62c-b733917baeca\\\\\\\"\\\\u003ECarpenter 1 fire rages outside Las Vegas \\\\u003Csmall\\\\u003E(14 photos)\\\\u003C/small\\\\u003E\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EPhotos from the Carpenter 1 fire outside Las Vegas, Nev., which has charred an area the size of Manhattan Island, according to the Associated Press .\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:8;pkgt:3;ccode:news;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Fprince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000069|YCT:001000070|WIKIID:Prince_Harry_of_Wales|WIKIID:Kensington_Palace\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://gma.yahoo.com/blogs/abc-blogs/prince-william-play-polo-while-nine-months-pregnant-150649675.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;tar:gma.yahoo.com;ltxt:PrinceWi;ct:2;pkgt:3;r:4100000840;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EPrince William to Play Polo While Nine-Months-Pregnant Kate Waits\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EPrince William has plans this weekend, but they don\\\\u2019t include a hospital. While his nine-months-pregnant wife, Kate, stays back home at the couple\\\\u2019s Kensington Palace home, Prince William will go ahead with plans to play in a charity polo match Sunday in Glouchestershire, nearly 100...\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EABC News\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/celebrities/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000069\\\\\\\" data-ylk=\\\\\\\"slk:Celebrities;sec:td-strm;cpos:1;itc:0;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ECelebrities\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"359b4757-f472-3d49-a211-389223ffe98a\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:9;pkgt:3;ccode:news;g:359b4757-f472-3d49-a211-389223ffe98a;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fgop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Culture_of_the_United_States\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/gop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:9;g:359b4757-f472-3d49-a211-389223ffe98a;tar:news.yahoo.com;ltxt:GOPshoul;ct:1;pkgt:3;r:4090000733;slk:title;itc:0;prov:ChristianScience;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EGOP should remember: Data show immigrants enforce, not threaten, US values\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EA comprehensive immigration reform bill has passed the Senate, but it faces dubious prospects in the House, where it probably won\\\\u2019t garner enough of the Republican support needed to bring it to a floor vote. One Republican sticking point is that the prospective law doesn\\\\u2019t go far enough to ensure\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EChristian Science Monitor\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:359b4757-f472-3d49-a211-389223ffe98a;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"03ea9147-55d7-3820-996b-2c161860b5a2\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:10;pkgt:3;ccode:news;g:03ea9147-55d7-3820-996b-2c161860b5a2;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpublicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000267|YCT:001000269|WIKIID:Elementary_school\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/publicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:10;g:03ea9147-55d7-3820-996b-2c161860b5a2;tar:news.yahoo.com;ltxt:Afterpub;ct:1;pkgt:3;r:4100000542;slk:title;itc:0;prov:TheDailyCaller;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EAfter publicly shaming girls for short shorts, elementary school principal apologizes\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EThe principal at a highly selective and highly prestigious Chicago elementary school has apologized for singling out and publicly shaming seven girls on the last day of school for the immodest lengths of their shorts.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Daily Caller\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/education/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000267\\\\\\\" data-ylk=\\\\\\\"slk:Education;sec:td-strm;cpos:1;itc:0;g:03ea9147-55d7-3820-996b-2c161860b5a2;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EEducation\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c621133c-f907-3f42-93ff-20ef01effa97\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:11;pkgt:4;ccode:news;g:c621133c-f907-3f42-93ff-20ef01effa97;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fprinter-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:Ink_cartridge\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001178;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/etz.tfpoo6Au9ixj1O3c4g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.kgo.abc.news.com/20a2be41046b838e6399259f73c9f47d');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\\\u003EPlay\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001178;slk:title;itc:0;prov:KGO\\\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EPrinter ink efficiency tested by Consumer Reports\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EMany don&#39;t realize it, but printer ink is one of the most expensive liquids you can buy.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EKGO \\\\u2013 San Francisco\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:12;pkgt:4;ccode:news;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fbush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000700|WIKIID:Immigration_reform\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900660;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-18px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/kM94ldkpwhbbDP4OY9UnYQ--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTcz/http://media.zenfs.com/en_us/News/ap_webfeeds/4e2f582e10be2e17370f6a7067003150.jpg');\\\\\\\" width=\\\\\\\"118\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900660;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EBush: &#39;Benevolent spirit&#39; must drive reform plans\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EDALLAS (AP) \\\\u2014 Making a rare return to the political arena, former President George W. Bush urged Congress on Wednesday to reach a &quot;positive resolution&quot; on immigration reform, an issue that eluded him during his presidency and now confronts fellow Republicans in the aftermath of a 2012 election\\\\u2026\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/immigration-reform/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Immigration_reform\\\\\\\" data-ylk=\\\\\\\"slk:Immigration reform;sec:td-strm;cpos:2;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EImmigration reform\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"e4009e04-8a14-3454-b2ef-0adfa809f2c3\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:13;pkgt:4;ccode:news;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fnavy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000705|YCT:001000661|WIKIID:Unmanned_aerial_vehicle|WIKIID:Aircraft_carrier|WIKIID:Patuxent_River\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000590;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-37px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/qYZjBoAYvbF1JWrX_Eav.g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTMx/http://media.zenfs.com/en_us/News/ap_webfeeds/c6ce26150eb22417370f6a706700137b.jpg');\\\\\\\" width=\\\\\\\"156\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000590;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003ENavy to attempt 1st unmanned carrier landing\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ENORFOLK, Va. (AP) \\\\u2014 The Navy will attempt to land a drone the size of a fighter jet aboard an aircraft carrier for the first time Wednesday, showcasing the military&#39;s capability to have a computer program perform one of the most difficult tasks a pilot is asked to do.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/military-and-defense/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000705\\\\\\\" data-ylk=\\\\\\\"slk:Military;sec:td-strm;cpos:1;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EMilitary\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:2;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"95413a0a-1d88-3f94-817c-d6b5fb824b6f\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:14;pkgt:4;ccode:news;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpanera-retool-latest-pay-idea-051305138.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000123|WIKIID:Panera_Bread\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-21px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/GRTmxi74dUkPM0bN5Tu_EA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTY3/http://media.zenfs.com/en_us/News/ap_webfeeds/a4d177310ec22417370f6a7067000233.jpg');\\\\\\\" width=\\\\\\\"123\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/panera-retool-latest-pay-idea-051305138.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EPanera to retool latest pay-what-you-can idea\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EST. LOUIS (AP) \\\\u2014 Panera Bread&#39;s latest pay-what-you-can experiment will be retooled and brought back next winter as a seasonal offering rather than a permanent one, the chain&#39;s founder says.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/panera-bread/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Panera_Bread\\\\\\\" data-ylk=\\\\\\\"slk:Panera Bread;sec:td-strm;cpos:1;itc:0;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPanera Bread\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"89342141-8982-3a32-9a2e-81cda1656e16\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:15;pkgt:4;ccode:news;g:89342141-8982-3a32-9a2e-81cda1656e16;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fformer-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|WIKIID:National_Security_Agency|WIKIID:Barack_Obama\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l2.yimg.com/ts/api/res/1.2/V1oj15r8LwVhitDeCoj3_g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjA4O2g9MjUw/http://media.zenfs.com/en_us/News/ap_webfeeds/fab40ba5f2431816370f6a706700947e.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"99\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EFormer judge admits flaws in secret court\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EWASHINGTON (AP) \\\\u2014 A former federal judge who served on a secret court overseeing the National Security Agency&#39;s secret surveillance programs said Tuesday the panel is independent but flawed because only the government&#39;s side is represented effectively in its deliberations.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/national-security-agency/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:National_Security_Agency\\\\\\\" data-ylk=\\\\\\\"slk:National Security Agency;sec:td-strm;cpos:2;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ENational Security Agency\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/barack-obama/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EBarack Obama\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content rmx-ad has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"21370595\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:16;pkgt:4;ccode:news;g:21370595;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ%3D%3D%2Chttp%253A%252F%252Fclk.atdmt.com%252FINV%252Fgo%252F451647339%252Fdirect%252F01%252F\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-rmx-beacon=\\\\\\\"http://ad.yieldmanager.com/csc?ve=2&2cDiAE12wp2Dz.IwU74e5L1PMXSElzNIwUK.DMksZqbxsQNr9TkpxCCr3WkJefTamYWy_.RN_hVPXUN96KEmE6ByAcKWxHo_oetdF3FvXS1T4NtiQxv4YZ0_pBqtqIzH7O0ip8bvVxgjPoKrSIwG2xYGphqXGJwgoHcGcgG6If4jmnCeJkwoMjzSA8lFxsfkkKA5DGemNrz59aiXKMmKD7i9PXlW8r2bIioPHiaIYVJFP.QJdTsf__VTZFUW5lerdtC_foE9u2ATjsTvjISjazahXozJ6Oo8C8GYosDyhfSmkJHNjhhMBi9HS.XGNQH8nIB_XOkOm.hF510EM.9rqVlMhgnjknC0ca0Eccddul7I8ACjWxjY0UiLEjdHucq2K4wSP.9k9kUpE5hbigMU3SU7.cOvzOo2XODCl6dUGOGqZyJvSSz4w9hwJL7zeN54KIFBN6mk6yqN36aEqybOOSK1u36lzqH2YgNGwXAeFbbilXKTJ0DVDF6GlynUmDdFtRLyoOuThCtSKF6d6nLaCiNzVrjY05GLBZjy5kaCH14JPJh_KKyfu2OhKseyolVTvUug1YRMwuX2jv3wSMXBp.FKtRh6NG2QUwmaIGRYvA09G1x1.QgmNWuuIBy.oxdZdWOxknKRp9psnS.jbCXybIZlgH3d43a69GiPaDAIoWuKnUMJQm3rrrcxtN6mHmKojXspt5I6SJTd0aK5ltwxYLhXxAzDmD83Ph4JO2ELWwMETAXVuntQeEN1giBo4kExl_3SxoqLTQNH213UQHc5JqT6uw5Y4Bsbw1xKzn6Do.zfYxlNtrKHwoD6oZOIoIkF1g--&ap=16\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21370595;tar:ad.yieldmanager.com;ltxt:4WaystoA;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l2.yimg.com/av/moneyball/ads/0-1371163702-9044.jpg');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"61\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21370595;tar:ad.yieldmanager.com;ltxt:4WaystoA;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E4 Ways to Avoid Running Out of Money in Retirement\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EIf you have a $500,000 portfolio, download the &quot;15-Minute Retirement Plan&quot; by Forbes columnist Ken Fisher's Firm.\\\\u003C/p\\\\u003E\\\\u003Ca class=\\\\\\\"adlink fz-xxs rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003EAdChoices\\\\u003Ci class=\\\\\\\"img-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a\\\\u003Ca class=\\\\\\\"fz-xxs adv rapid-noclick-resp\\\\\\\" href=\\\\\\\"http://ad.yieldmanager.com/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EFisher Investments\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Ca href=\\\\\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\\\\\" class=\\\\\\\"fz-xxs sp rapid-noclick-resp\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003ESponsored\\\\u003C/a\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"545a4a5d-31f1-3d2b-b3a1-af6ab035ba08\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:17;pkgt:4;ccode:news;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:California|WIKIID:Solitary_confinement\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000790;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-25px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/cIsjQVUHZJZ7HCJhBG6m2Q--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTU2/http://media.zenfs.com/en_us/News/theatlanticwire/30_000_California_Prisoners_Are_Refusing-b255dfae58903c7ee92b601e81fb15da');\\\\\\\" width=\\\\\\\"131\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000790;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003E30,000 California Prisoners Are Refusing Meals\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EOver 30,000 California prisoners started refusing meals on Monday morning in what might become the biggest hunger strike in California prison history, according to California&#39;s corrections department.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Atlantic Wire\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/california/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:California\\\\\\\" data-ylk=\\\\\\\"slk:California;sec:td-strm;cpos:1;itc:0;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ECalifornia\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"33a46b90-1741-349c-a64b-0f5fc4dcbfb9\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:18;pkgt:4;ccode:news;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fpoint-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\\\\\" data-wikiids=\\\\\\\"WIKIID:Bob_McDonnell|WIKIID:Governor_of_Virginia\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/point-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;tar:news.yahoo.com;ltxt:AtWhatPo;ct:1;pkgt:4;r:4100000359;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"background-image:url('http://l2.yimg.com/ts/api/res/1.2/Mb7deq6crVPlKz5J2zGWAQ--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz04MjtoPTgyO3B5b2ZmPTA-/http://media.zenfs.com/en_us/News/theatlanticwire/At_What_Point_Did_Virginia-e24a1b834aca29c22a0710616d3eaa81');\\\\\\\" width=\\\\\\\"82\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/point-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;tar:news.yahoo.com;ltxt:AtWhatPo;ct:1;pkgt:4;r:4100000359;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EAt What Point Did Virginia Governor Bob McDonnell Go Too Far?\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EBob McDonnell is still the governor of Virginia, despite a series of revelations from the Washington Post detailing unreported gifts from a contributor to McDonnell and his family. There have been so many gifts, in fact, that we were wondering: how much do people consider too much?\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Atlantic Wire\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"time\\\\\\\"\\\\u003E52 mins ago\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content cavideo has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"04cc60e0-a193-3352-8e5c-ff896228e590\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:19;pkgt:4;ccode:news;g:04cc60e0-a193-3352-8e5c-ff896228e590;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fmajor-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-wikiids=\\\\\\\"\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001231;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/3aHYmihw4JqFgqXUDpm5bA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.wabc.abc.news.com/10a5262f6a2220ce4bf4830c048b3257');\\\\\\\" width=\\\\\\\"145\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"icon-overlay\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"video-icon d-ib\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\"icon-sprite\\\\\\\"\\\\u003E\\\\u003C/i\\\\u003E \\\\u003Cspan class=\\\\\\\"play-now fz-xxs\\\\\\\"\\\\u003EPlay\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001231;slk:title;itc:0;prov:WABC\\\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EMajor setback for the defense at George Zimmerman trial\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EMarci Gonzalez reports for ABC News from Sanford, Florida\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EWABC \\\\u2013 NY\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"35246d27-ef1f-3c2f-ac82-50ee6d2511ee\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:20;pkgt:3;ccode:news;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2Fky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000804|YCT:001000780|WIKIID:Southern_Baptist_Convention\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/ky-church-wants-pastor-gone-wifes-column-083204548.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;tar:news.yahoo.com;ltxt:Ky.churc;ct:1;pkgt:3;r:4053101068;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EKy. church wants pastor gone after wife&#39;s column\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003ELOUISVILLE, Ky. (AP) \\\\u2014 A newspaper column lampooning Southern Baptists, calling the group &quot;the crazy old paranoid uncle of evangelical Christians,&quot; is causing quite a stir in a Kentucky city and put a pastor&#39;s job in jeopardy.\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EAssociated Press\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/religion-and-beliefs/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000804\\\\\\\" data-ylk=\\\\\\\"slk:Religion;sec:td-strm;cpos:1;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EReligion\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/society-and-culture/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000780\\\\\\\" data-ylk=\\\\\\\"slk:Society;sec:td-strm;cpos:2;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003ESociety\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content has-image voh-parent cf\\\\\\\" data-uuid=\\\\\\\"c20cc012-29f6-3120-a12f-ef78c41a0a22\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:21;pkgt:4;ccode:news;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fnews.yahoo.com%2F3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-wikiids=\\\\\\\"YCT:001000661|YCT:001000681|WIKIID:White_House|WIKIID:Presidency_of_Barack_Obama|WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"img ov-h thumb-left  \\\\\\\" href=\\\\\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600901;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" tabindex=\\\\\\\"-1\\\\\\\"\\\\u003E\\\\u003Cimg src=\\\\\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\\\\\" style=\\\\\\\"margin-left:-27px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/Rntt.Xg7T8Y5NxTOWahOJg--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTUx/http://media.zenfs.com/en_us/News/theweek/is-president-obamas-signature-legislative-achievement-turning-into-a-messy-failure.jpg');\\\\\\\" width=\\\\\\\"136\\\\\\\" height=\\\\\\\"82\\\\\\\" alt=\\\\\\\"\\\\\\\" title=\\\\\\\"\\\\\\\" class=\\\\\\\"lzbg\\\\\\\"\\\\u003E\\\\u003C/a\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600901;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\"\\\\u003EWhat 3 years of ObamaCare incompetence tells us about the White House\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EThe administration is gradually scaling back its signature legislation \\\\u2014 just as critics have long demanded\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EThe Week\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/politics-and-government/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000661\\\\\\\" data-ylk=\\\\\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPolitics\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/white-house-2/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:White_House\\\\\\\" data-ylk=\\\\\\\"slk:White House;sec:td-strm;cpos:2;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EWhite House\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://www.yahoo.com/topic/presidency-of-barack-obama/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\" data-ylk=\\\\\\\"slk:Presidency of Barack Obama;sec:td-strm;cpos:3;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPresidency of Barack Obama\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/patient-protection-and-affordable-care-act/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\" data-ylk=\\\\\\\"slk:Patient Protection and Affordable Care Act;sec:td-strm;cpos:4;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EPatient Protection and Affordable Care Act\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"content voh-parent cf\\\\\\\" data-uuid=\\\\\\\"41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;cat:default;bpos:1;cpos:22;pkgt:3;ccode:news;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ed:0;\\\\\\\" data-url=\\\\\\\"http%3A%2F%2Fabcnews.go.com%2Fblogs%2Fentertainment%2F2013%2F07%2Fryan-reynolds-could-have-been-a-cop%2F\\\\\\\" data-wikiids=\\\\\\\"YCT:001000031|YCT:001000076\\\\\\\" data-reason=\\\\\\\"TRENDING\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"wrapper cf\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\"body-wrap\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\"fw-b fz-s lh-115\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\"\\\\\\\" href=\\\\\\\"http://abcnews.go.com/blogs/entertainment/2013/07/ryan-reynolds-could-have-been-a-cop/\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\" data-ylk=\\\\\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;tar:abcnews.go.com;ltxt:HowRyanR;ct:1;pkgt:3;r:4090000432;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003EHow Ryan Reynolds Dodged a Bullet\\\\u003C/a\\\\u003E\\\\u003C/h3\\\\u003E\\\\u003Cp class=\\\\\\\"summary mt-xxs\\\\\\\"\\\\u003EIn an alternate universe somewhere, Ryan Reynolds is patrolling the streets as a cop, munching on blue M&M\\\\u2019s and avoiding red carpets at all cost. But this is the real world and Reynolds, 36,\\\\u00a0is an A-list\\\\u00a0movie star married to one of the most elegant actresses... \\\\u00a0 \\\\u00a0 \\\\u00a0 \\\\u00a0\\\\u003C/p\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"attribution fz-xxs\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"source\\\\\\\"\\\\u003EABC News\\\\u003Cspan class=\\\\\\\"d-ib img-sprite off-network-icon\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cul class=\\\\\\\"interest-list d-ib voh\\\\\\\"\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/arts-and-entertainment/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000031\\\\\\\" data-ylk=\\\\\\\"slk:Arts & Entertainment;sec:td-strm;cpos:1;itc:0;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EArts & Entertainment\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"interest-wrap d-ib\\\\\\\"\\\\u003E\\\\u003Ca href=\\\\\\\"http://news.yahoo.com/movies/\\\\\\\" class=\\\\\\\"interest-filter rapidnofollow\\\\\\\" data-filter=\\\\\\\"YCT:001000076\\\\\\\" data-ylk=\\\\\\\"slk:Movies;sec:td-strm;cpos:2;itc:0;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\\\\\" data-action-outcome=\\\\\\\"navigate\\\\\\\"\\\\u003EMovies\\\\u003C/a\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003Cdiv class=\\\\\\\"side-buttons\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"img-sprite close side-button voh rapid-noclick-resp\\\\\\\" data-b=\\\\\\\"\\\\\\\" title=\\\\\\\"Remove\\\\\\\"\\\\u003ERemove\\\\u003C/button\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/div\\\\u003E\\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"next-batch notice loading\\\\\\\" data-key=\\\\\\\"1\\\\\\\" data-ylk=\\\\\\\"slk:fetch;ltxt:fetch;pos:0;bpos:2;cpos:23;itc:1;sec:td-strm;test:900;intl:us;cat:default;ccode:news;\\\\\\\"  data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"fetch\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\"fz-xs\\\\\\\"\\\\u003ELoad more stories\\\\u003C/button\\\\u003E\\\\u003C/li\\\\u003E\\\\u003C/ul\\\\u003E\\\\u003Cinput type=\\\\\\\"hidden\\\\\\\" class=\\\\\\\"historystate\\\\\\\" data-time=\\\\\\\"1373481900.2943\\\\\\\"\\\\u003E    \\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u000a\\\\u000a--dali-response-split-51ddabac509b3Content-Type: text/plain; charset=utf-8\\\\u000aRMP-Embed-Location: bottom\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000aYUI.namespace(\\\\\\\"presentation\\\\\\\");\\\\u000aYUI.presentation.lazyScriptList = [\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/yui/oop_3.8.1.js&nn/lib/metro/g/yui/event-custom-base_3.8.1.js&nn/lib/metro/g/yui/event-base_3.8.1.js&nn/lib/metro/g/yui/io-base_3.8.1.js&nn/lib/metro/g/yui/json-parse_3.8.1.js&nn/lib/metro/g/yui/json-stringify_3.8.1.js&nn/lib/metro/g/yui/cookie_3.8.1.js&nn/lib/metro/g/yui/jsonp_3.8.1.js&nn/lib/metro/g/yui/dom-core_3.8.1.js&nn/lib/metro/g/yui/dom-base_3.8.1.js&nn/lib/metro/g/yui/dom-style_3.8.1.js&nn/lib/metro/g/yui/selector-native_3.8.1.js&nn/lib/metro/g/yui/selector_3.8.1.js&nn/lib/metro/g/yui/node-core_3.8.1.js&nn/lib/metro/g/yui/node-base_3.8.1.js&nn/lib/metro/g/yui/node-style_3.8.1.js&nn/lib/metro/g/yui/transition_3.8.2.js&nn/lib/metro/g/yui/selector-css2_3.8.1.js&nn/lib/metro/g/yui/selector-css3_3.8.1.js&nn/lib/metro/g/yui/event-custom-complex_3.8.1.js&nn/lib/metro/g/yui/event-synthetic_3.8.1.js&nn/lib/metro/g/yui/event-focus_3.8.1.js&nn/lib/metro/g/yui/event-delegate_3.8.1.js&nn/lib/metro/g/yui/node-event-delegate_3.8.1.js&nn/lib/metro/g/yui/pluginhost-base_3.8.1.js&nn/lib/metro/g/yui/pluginhost-config_3.8.1.js&nn/lib/metro/g/yui/node-pluginhost_3.8.1.js&nn/lib/metro/g/yui/dom-screen_3.8.1.js&nn/lib/metro/g/yui/node-screen_3.8.1.js&nn/lib/metro/g/yui/gallery-storage-lite_3.8.1.js&nn/lib/metro/g/uicontrib/dali/module_platform_1.1.14.js&nn/lib/metro/g/uicontrib/dali/resourcemgr_1.1.14.js&nn/lib/metro/g/uicontrib/dali/dali_transport_1.1.34.js&nn/lib/metro/g/uicontrib/dali/metro_dali_1.0.27.js&nn/lib/metro/g/uicontrib/dali/module_api_1.1.16.js&nn/lib/metro/g/uicontrib/dali/yui_service_0.1.17.js\\\\\\\"];\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/uiplugins/metro_viewtype_0.1.24.js&nn/lib/metro/g/uiplugins/default_viewtype_0.1.61.js&nn/lib/metro/g/uiplugins/edit_viewtype_0.1.40.js&nn/lib/metro/g/uicontrib/ylc_1.8.22.js&nn/lib/metro/g/uiplugins/instrumentation_service_0.1.83.js&nn/lib/metro/g/uiplugins/userinfo_service_0.1.15.js&nn/lib/metro/g/uiplugins/statemgr_service_0.1.20.js&nn/lib/metro/g/uiplugins/metrologger_service_0.1.18.js&nn/lib/metro/g/uiplugins/tooltip_service_0.1.56.js&nn/lib/metro/g/uiplugins/autohide_service_0.1.15.js\\\\\\\"]);\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\\\\\"http://l.yimg.com/zz/combo?nn/lib/metro2/g/badge/badge_0.1.20.js&nn/lib/metro/g/stream/stream_0.0.456.js&nn/lib/metro/g/uiplugins/storage_service_0.0.1.js&nn/lib/metro/g/uiplugins/login_service_0.0.38.js&nn/lib/metro/g/uiplugins/interests_service_0.1.1.js&nn/lib/metro/g/fstream/fstream_0.0.95.js&nn/lib/metro/g/login/login_0.0.32.js\\\\\\\"]);\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000a(function()\\\\u000a{\\\\u000a    YMedia.namespace('dali').config = {\\\\\\\"props\\\\\\\":{\\\\\\\"dali\\\\\\\":{\\\\\\\"crumb\\\\\\\":\\\\\\\"J6oPeXs35Uh\\\\\\\",\\\\\\\"yuid\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"loggedIn\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"mLogin\\\\\\\":0},\\\\\\\"proxyUrl\\\\\\\":\\\\\\\"\\\\\\\\/hjs?_mode=html&_create=1&_action=show&_type=badge&_container=1&_chrome=0&view=default&pInitLevel=lite&m_id=p_30345786&m_mode=multipart&configId=MediaRemoteIncludeExternalConfig&hide=0&mod_units=19&app=gs&content_id=5f01278b-803a-3803-9798-7fc79bab4f7d&juris=US&lang=en-US&pu=news.yahoo.com&region=US&se=4402687&site=news&mod_id=p_30345786&suid=30345786&pagetype=minihome&nolz=1&y_proc_embeds=1&y_map_urn=urn%3Armp%3Alite&_product_version=v2&r_inc=1&c_id=p_30345786_container&_sig=8nhtS_52JeXfdiYY25izjGGXZ2I-\\\\\\\"},\\\\\\\"data\\\\\\\":null,\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"signature\\\\\\\":\\\\\\\"he5R2PEbnkHjPiFGhQuSNQ--\\\\\\\"},\\\\\\\"moduleId\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"badge\\\\\\\",\\\\\\\"trusted\\\\\\\":true},\\\\\\\"state\\\\\\\":{},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.MODULE.ERROR_FALLBACK_TEXT\\\\\\\":\\\\\\\"Requested module is not available. Please try again.\\\\\\\",\\\\\\\"STR.EDIT\\\\\\\":\\\\\\\"Settings\\\\\\\",\\\\\\\"STR.EDIT.CLOSE\\\\\\\":\\\\\\\"Close Settings\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"data\\\\\\\":{\\\\\\\"maple\\\\\\\":{\\\\\\\"platform\\\\\\\":{},\\\\\\\"module\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"instance\\\\\\\":\\\\\\\"__mmh_0\\\\\\\",\\\\\\\"ba\\\\\\\":{\\\\\\\"_action\\\\\\\":\\\\\\\"show\\\\\\\",\\\\\\\"chrome\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"_id\\\\\\\":\\\\\\\"u_30345786\\\\\\\"},\\\\\\\"signature\\\\\\\":\\\\\\\"5nh6UiryEE9aP5zSGTFEXg--\\\\\\\"},\\\\\\\"woeId\\\\\\\":12778444,\\\\\\\"intl\\\\\\\":\\\\\\\"us\\\\\\\",\\\\\\\"socialEnabled\\\\\\\":true,\\\\\\\"swipeEnabled\\\\\\\":false,\\\\\\\"fbAcctLinked\\\\\\\":false,\\\\\\\"clientPagination\\\\\\\":true,\\\\\\\"dynamicEnabled\\\\\\\":true,\\\\\\\"removalMenuEnabled\\\\\\\":true,\\\\\\\"closeEnabled\\\\\\\":true,\\\\\\\"markAsReadEnabled\\\\\\\":true,\\\\\\\"tooltipsEnabled\\\\\\\":true,\\\\\\\"batchPause\\\\\\\":0,\\\\\\\"interestFiltersEnabled\\\\\\\":true,\\\\\\\"interestFiltersBroadcast\\\\\\\":true,\\\\\\\"minArticleCount\\\\\\\":6,\\\\\\\"broadcastDynamicEnabled\\\\\\\":true,\\\\\\\"sortBy\\\\\\\":0,\\\\\\\"shareDrawerEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"scrollBuffer\\\\\\\":900,\\\\\\\"writeMixerActions\\\\\\\":true,\\\\\\\"isRmp\\\\\\\":true,\\\\\\\"interestFiltersNavigate\\\\\\\":true,\\\\\\\"itemClickBroadcastOnly\\\\\\\":true,\\\\\\\"itemClickContext\\\\\\\":true,\\\\\\\"restoreStateExpire\\\\\\\":1800000,\\\\\\\"restoreStateMethod\\\\\\\":\\\\\\\"LOCAL_STORAGE\\\\\\\",\\\\\\\"restoreStateOnCacheMiss\\\\\\\":true,\\\\\\\"batchSize\\\\\\\":20,\\\\\\\"locationPickerEnabled\\\\\\\":false,\\\\\\\"beacon_sec\\\\\\\":\\\\\\\"app-loc\\\\\\\",\\\\\\\"beacon_slk\\\\\\\":\\\\\\\"s-op\\\\\\\",\\\\\\\"beacon_bucketid\\\\\\\":\\\\\\\"900\\\\\\\",\\\\\\\"dynamicCategories\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000661\\\\\\\",\\\\\\\"points\\\\\\\":155.14,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":56,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":6,\\\\\\\"2\\\\\\\":3,\\\\\\\"3\\\\\\\":3,\\\\\\\"4\\\\\\\":4,\\\\\\\"5\\\\\\\":9,\\\\\\\"6\\\\\\\":6,\\\\\\\"7\\\\\\\":8,\\\\\\\"8\\\\\\\":13,\\\\\\\"9\\\\\\\":4},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/politics-and-government\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000780\\\\\\\",\\\\\\\"points\\\\\\\":97.67,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":34,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2,\\\\\\\"2\\\\\\\":5,\\\\\\\"3\\\\\\\":4,\\\\\\\"4\\\\\\\":3,\\\\\\\"5\\\\\\\":7,\\\\\\\"6\\\\\\\":3,\\\\\\\"7\\\\\\\":5,\\\\\\\"8\\\\\\\":1,\\\\\\\"9\\\\\\\":4},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/society-and-culture\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000667\\\\\\\",\\\\\\\"points\\\\\\\":32.78,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":14,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"3\\\\\\\":1,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":2,\\\\\\\"6\\\\\\\":3,\\\\\\\"7\\\\\\\":4,\\\\\\\"9\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/crime-and-justice\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000267\\\\\\\",\\\\\\\"points\\\\\\\":29.27,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":8,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"2\\\\\\\":1,\\\\\\\"3\\\\\\\":2,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":2,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/education\\\\\\\\/\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Government\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"YCT:001000681\\\\\\\",\\\\\\\"points\\\\\\\":26.87,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":10,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1,\\\\\\\"3\\\\\\\":1,\\\\\\\"4\\\\\\\":1,\\\\\\\"5\\\\\\\":3,\\\\\\\"7\\\\\\\":1,\\\\\\\"8\\\\\\\":2,\\\\\\\"9\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/government\\\\\\\\/\\\\\\\"}],\\\\\\\"dynamicEntities\\\\\\\":[{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Barack_Obama\\\\\\\",\\\\\\\"points\\\\\\\":294,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":294,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/barack-obama\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Egypt\\\\\\\",\\\\\\\"points\\\\\\\":186,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":186,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/egypt\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:United_States\\\\\\\",\\\\\\\"points\\\\\\\":139,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":139,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/united-states\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:White_House\\\\\\\",\\\\\\\"points\\\\\\\":129,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":129,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":2},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/white-house-2\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\\\\\"},{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\",\\\\\\\"points\\\\\\\":123,\\\\\\\"src\\\\\\\":\\\\\\\"core\\\\\\\",\\\\\\\"count\\\\\\\":123,\\\\\\\"occurances\\\\\\\":{\\\\\\\"1\\\\\\\":1},\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\/\\\\\\\",\\\\\\\"uuid\\\\\\\":\\\\\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\\\\\"}],\\\\\\\"items\\\\\\\":[{\\\\\\\"u\\\\\\\":\\\\\\\"2e88e31e-a379-3340-96cb-7c5d904edd46\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000349\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"999a3ee7-37dc-34bd-99a7-51b289bd05a6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001466\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6f4ca8cf-c412-35d3-853f-9ee636b92373\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000382\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"523fedde-cc12-38fb-86ca-60629888845c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001194\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"62787508-255a-3395-82ba-9e62e75cb0f0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000433\\\\\\\"},{\\\\\\\"u\\\\\\\":20637846,\\\\\\\"s\\\\\\\":\\\\\\\"Find Out Which Vehicles Get The Best Gas Mileage. See Our Top 10 Results for Cars, Trucks, and SUVs.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l3.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/cleansed\\\\\\\\/282855.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjVELgjAUhf.QArflmIwepmZYzhJmYm-WOpNZPQiivz418Rf0wTncyz2HCzEjRV5uKTUhuY9OSwZx-bAKYmUIAoMxhk2CIEYU8IkLbaPOSYj7tufd2Vay4z.UKFs5S27yvYtPWbac5cbW.C841pH7y-zPf5VLef55Nb2k9ho7RENYX.WtTo0gic2z5K2QnhZPWIVI9EGSDqKOTZH4MG08naq1uQPA-AJEmk55,http%3A%2F%2Fwww.autobytel.com%2Ftop-10-cars%2Fbest-gas-mileage-cars%2F%3Fid%3D32929\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Top 10 Best Gas Mileage Vehicles\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&YXUrx1B2wp0mtLPzqoY6SBX19zf_d1fuUh2uCCm1dTPwqs0S0Qu8QkmJ5NfR42PdwHTEqGDrCn9.oWfDlfrSrQV9aR0v8aA6sTO7zjH78dGCCdXgpV3wN13TJPUl3oQ1sHEdxry9iqESWj4icW870OMIuXuL3SUZh1.1NKi9flPyGcGsMOxzYKv3fit7oqYNRDlopuckdDxB5euHoLh780LMQ3aSPrQS8XNMD4KT1hMc7yCU5ew2q14XdcvGxWTUUbDICX_LXkAjfWt2Ozo7UyrIhNLCLdT2_V0XFdqBUKaCfItcIby82NI16YcWnR93TfzPET5tz7bKZk0FQbkNGynGlVYwBXBAkE28RIE6SuZriUd88o6PktAaF5RUUIhPCNGUSbkTjPokhmJIMT_wK3zIjoqQeQHZr1cheaT43QHDmtiKe7FNjERd1PiAGCeNriRZpKnkU8T3wc9MkBtKy54pf4Hw67K2bSDteWl6rjnwgp4h84r7e9vqdfFzzz3LsjxHA0NJJ9mpzN8k8nQdHUShQPauRd.xSngLQI.YYXI2DK1_CaostAQJNpXXKLX2NljGEBarONbTUuG9b8V03Pzr5ghWryMb39D.z5j3tWnn6IT.PhZ57JAvueKoabx0UcLob6NnyIf5o2jXgu2T55Kdya1II4.4Kc8lN1oR74WhvpUpm6XA5Bop1dkKs64UNTpcvIpmZeYpYRkoiwKp6A7Ehu4WyeKny4KU3JzbUllALSnPNg6rYxvAq9Xj5.WyHIpH66jJN4OnXZcaTvzVHYu3f64YU8hJZMeqLc5VwkjSL4N7fQcjeCN86RtVAzKU7A--&ap=29\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Autobytel\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8682b543-884b-33da-a257-f0d05e1a3dfa\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4089900406\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1733412d-c645-3dcc-898f-a3e6b23632c3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000563\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8cc97ab2-66d0-3bbb-8b6f-c20ba8d932c4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100614\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fa2d95f2-4e85-3cfa-aee0-d5b0c031529f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000730\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d344ace7-22fe-3cab-b829-5c23eb17e754\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001080\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1f76e13-0b85-3d35-ab05-1b263f119f5a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000881\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1099eb81-1582-311e-b36e-9a15c7f141e0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100517\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0827042a-7b69-3744-876a-e63bbaf67e6d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000368\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"61d9ae23-9b3a-343a-9309-6e2f3cf1dc01\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000292\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6e2cca72-5335-3ef9-8ebb-e93683d1ee71\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8fcb3d3-00f3-3804-b31c-d387f5b7c8e2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4047800515\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"cfa94c8c-28be-3510-b57a-00b7c3588ab9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000252\\\\\\\"},{\\\\\\\"u\\\\\\\":20626440,\\\\\\\"s\\\\\\\":\\\\\\\"Netflix members can watch as much as they want, anytime, anywhere, on nearly any Internet-connected screen. Only $7.99\\\\\\\\/mo. Sign up today.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l1.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/curated\\\\\\\\/202834-1366845045.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjV8LgjAUxb-QD25TmYwetlZiOUuYhL6Z.7LUhCRpnz418RP0g3O4l3sOFyBi5VlhYGwC6zo6LghARWrnlp1AoOmEEGRaECCINTpxxn0wUPfNn2zeHcOXA.1RjmLldslNvuPomCTLuX11Nf0LW.tA3WV2578lxzTr2uYjMVtjTqD8ezQIlRreJTRPkvZC7mtRgZsPhfIkqyIYKp8.hriJVByszY2m6V.IrU-S,https%3A%2F%2Fsignup.netflix.com%2F%3Fmqso%3D81003558\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Netflix Revolutionizes Movie and TV Watching\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&H_GrtUV2wp01Xake4rDZW0wnjkO9HDq9Hft_18s7_GQKOnACr9NTDkbmZcd.8xn27Yr78xtgxagH29RFPQHiT9A7nMsgkF4SrsuJqpF6KxW7.eQWongoNyNgHLeDjw4vSRYZrlUBbqUGCm.iOPMlvy9y_3xojQZqIGXt6Jg.ybv7ZLSp1_JPMeIfLHc5iM8r0_7ZJUd7fqcnRg_prZMHiKHR.jwshqf_VjsU2j1TIFMtXUTvnzYcOpDO7MW_xCKAZMy68GqTnEs6J.vHvhrmpCmqfGXWrTD3iBge8YiE1S8g852XJtEPojc1DerY7e2yE.l0E7FSHReDqaNNpvOwMcy7vo1FunkrG59tz4lj3AjHPadJKP32Lco_RUF6Xb..zZ3tHIkuFtD4YjMZnzeV0MQv1YzjZ5ZAl5tkvwMVt7An6YesaTeoTlzTDnFZ.ADi2.nBReH5UtEBqz.OznBlsij3VxguNsYLTFU40slVd14X9zP.M5YX_h3JE2OFuDlZcPA_hjDoThdSiZbY2bG0HP8a2d2JWNEwSkVE0gb7nlvFM5D6..pRnnliLUFuL5D9ppUOCS0UIqBPnuWgycSy3VmudQdtTZDmRKCwZDmD21IueaDDx_hb_yO_C4K9w6UTZZUZzT.ZzxQlBK_.fFsLOsWlWO3qZMtoydin4q7xcHimY61og12NomS5o2cCUvkLoZSWeYDMARou0oC9R_HlO3VYG4nN0ifgNXY.teQC6nbHjLBTw__xD_n2W.6uFZAe5PRB38HD6qumfhVfv6sjRn0GKNA_8CfhTSJVziFjUslwHQfCYfUaDNs.SZAH90eAJg--&ap=42\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Netflix\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5de020-1c28-3992-8b33-7759daa5e05e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000928\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5c9e6d6a-5127-3f87-b77f-6580cd62dfe4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000932\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"acfa2983-d731-3cbc-a0fc-2ff8ef78e075\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001366\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4d5a136-97d8-3124-8ac6-7c020235428f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24e6df26-628f-3a4c-9b98-b22275506fb9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081001304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4fd501c-2f37-3258-ae09-c23c728290ba\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600940\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0af9f27d-adfd-3b40-bdd2-8ff1b8643742\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4043000697\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b1151a83-318e-34e2-a2c8-0fe169c1f900\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000233\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bfab8f88-77cf-3ace-b86a-80a4f5d25e89\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000483\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ed5c998c-1e32-3302-9d47-7f3957a1fc2f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4038700567\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"73beeae0-a4b3-384b-bf19-be60c1176c1b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600289\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5287b89f-b0f0-3dab-9197-aa22905eaf4b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000187\\\\\\\"},{\\\\\\\"u\\\\\\\":21713975,\\\\\\\"s\\\\\\\":\\\\\\\"Find out how this unexpected joint solution is helping Americans live happier, healthier lives after 50!\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l5.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/216216-1372864886-2128.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":61,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.344262295082}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjc0OgjAQhF-oB9ry06bxUH5ElBZJQAI3QgUxYEjEKD69AYlP4HfYmc3OZiBmRMdVrWrdJJZhUaoYxHVFzyYtEQIaYwwbJoIYEcBnjmSMnxyfvLu97Lv8kTb8y6x246y5eXouPpTlepZQDfwvOHTPg9UHS2.jEq6GWz8lxP7F.Pgtr.lL9ukUZqkRJXwUybYTLbxIJLQwK1qReTDyZSeTopXN73MDgPYBg-hOpw==,http%3A%2F%2Fwww.instaflex.com%2Freport%2Farticles.php%3Ft202id%3D512118%26t202kw%3Dysa_i_7\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"8 Simple Joint Ingredients You Won't Believe\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&ecK0Z552wp1CR9ucwuN9cJWH69Az.jMaEgh3CbTj0mKfA8.rh3WakEXcY5PfEj0lY0y3LUkCsSNz6c_t1sHSAKOb29yRFyNqTLfU3SUTNbQBQu0d87VGzVCE5uF5yA68dAHqPB2wnZmtGS5HgkBMaWq7GGkung.Fy.QaynZeOMJD2a0JLw8VAHokuVGgbR27cZI08RcvsDQUtzOVM0Q1xYAKyAGAdZJassqSq3Rrm07JNLwsHrwHDm.p0XkmjJOdzjhHpip8OU9zjaswukv6g_allIZuOBY.f6hTrgRDZNYjW6OXJPVInt2GxxZ15tE.jVF0Fw8ipQMgGkovqKnW2Qn9W.u_v6jfqwIpAIXwNYmeooflkXbiNn9WsTi0ba4Vpuc4.aoNx53jOjdAHXUKNgnxgUNWnDGWYKZ.H0_uSp7rhrKJfagCM.CPRL1sJbC2oL3kOjnzlwg0Hv21fYu4ttHK7sJI17e4nJeCoAjRPhmJ8a7U5zZ42PwEIxdJ_U7sLGCJBuoP2.s.pBsDOPpvzsHKZ5CTJaxtsFreN5b5QEUU7OlsKZ636zCz7smWU7AnmNeMQFG6w3InYqHF5NSNQtro7fZQXU9ygVpfM.xgR6fEdBIZJuq0RqMSR6eoF6v6Ob6i4h9Afx4zUje84fuAboMMJZrI8NNNeyTqFjVy5mIcfY16Vy9wpRnc9uxir4B_4qg_EUhIrUoO9Ecm5Fpvw3LOD02iFh7D11duypcfbysZGWC_7XLDX4CrTqcTDNQ7RsylfEgAWZvbPmP_afrexsbkNCCL7eK5PIBHBnPEonIyHVIj2_p90hKEpZkN3QIyGw--&ap=55\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Instaflex\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f87eaebd-5628-3ec6-b863-c404b0abcee4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001059\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d712ff7a-7042-30b9-8867-19b51ecb96d2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600236\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43b802f5-0558-39cc-9b76-348e3d40edc4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000174\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c7c72404-4eb8-3ea3-86b5-2657571ab856\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000427\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4519c9a6-1a8f-3d9f-bcd3-dc88fec5bc77\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001187\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"37b64b20-2ba3-31e1-9e02-418af076fcf5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090000298\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"42fb1b39-704f-3677-9910-7a2681fc7182\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000148\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"586a9615-991d-3faf-9c7d-e7ff8179d511\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000368\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1725fbc9-413b-3fff-a0c5-60ec4702f7c2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000553\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"51aceae4-c48c-3955-bc3d-deabf73b0d4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001042\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0d92f3cd-9815-312a-abc3-79c0fa565d00\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4089900263\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ecaa77-69b8-38ea-9a81-866f52ad3b10\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900590\\\\\\\"},{\\\\\\\"u\\\\\\\":20950156,\\\\\\\"s\\\\\\\":\\\\\\\"Local auto dealers have begun cutting their prices for the summer.  If you're looking for a new car this season, buy now and save as much as ...\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l2.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/206635-1369234902-9746.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":80,\\\\\\\"orientation\\\\\\\":\\\\\\\"landscape\\\\\\\",\\\\\\\"ratio\\\\\\\":1.025}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjt0KgkAQhV9oL9w.3WXpYlMrw90SVkTvQlOLjAjJ7OlLW3qCPjjDOcwMMxALRnBZVzVxmUc9zisBcV3yo8sPCAFHCIGpiyBGDMiJPeuTwVf3gC3nvGm5GeSX5qNl49u5qYYBeTwL2x8c2sm.4POtjKyP5rtNwGR1u3ajsX9NrJOXPudjbhSJs5TujOyVWV3UCbYaKRhnRaeMbnUQjtqko05-mwsAnDemLk7K,http%3A%2F%2Fpixel.autoaffiliatenetwork.com%2Fd%2F%3Fid%3D009%26adtargeting%3Dimage_Chrysler300_text_Summer2013%26dest%3DAPF\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Auto Dealers Cut Prices for Summer 2013\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&HZAOtg52wp2mLei3m1uAVwfuueZ2Sf7pQzA41g3fGSUnGKb7Oa2Clrrx.AZQ.wLbq5rGVbDhFQKVLTatBKM3qSrLhn5PX3S4k0QiUs36M40F1hFG55fy08t6NRxPatBALoQho.NI5BPHB1.pHZ6QycyfbQd5Juy0B.CTvIWP3XeNsVg0WxIVEj06ovFvFOfOSEIzdJEgObpMrQsQPRulPUrFsn8SidGM4jaeYvlGdJ5ycpHed0jeFvJcdECwVIlMcrQRNXeTkGhge8LsYmqhQiQa4U7uFFDgNcrAerua1eREjxKKAoD_.0niVaXVyKrjxouCRqHX1zXNmaLv.e_oRz7DS00yUdhaH.nZt0saFrBgKmGSdtGItxnCyDpZ_6LRvGJ3MHpnV7Xng1dXhBUVQ_SQLYe2dcEEqRWeWQIOi3HCrhSySo4lzpOOtnITWQEVkeRgbwNYeb4Bl43wnSKXnMX0AMppyIPkmAnjzfi2PypfqmF__JVxj_I1CWDwPySaXS_zJdbhT4plSrrW3hA4MA0h4Tkx1fFtFnlSifBIiV6eESruix.D2ge3XkVRdzq_34vh22wQ6xQ2qzvQhHJNJGuNFeJm5C5Zmmg7N7AO2OusU5gfdfrg1m.GoTH_WRPsSeXp7UwavSXCP8ZzP99cAP_oD_b9bze1DRtFGUYMMFCWhrClBptEFrzXGsZSKUmbTie_AttNW2BTl1S0ZNag8aPAW93FDYd5qzcvSJxQQeDpnPBIvoKv3Uvuf9Ed6KjW9vQIP6dFVIV4agn7e6wwoh2yokDspVKot5s8svNYTP7vF824nuEF3az1..DzWN_tGw--&ap=68\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Auto-Price-Finder.com\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"79d8986e-05fc-3cc3-89a2-85f7c4e1af91\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000130\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9cf878bf-6b71-312f-aae4-95d81bab2441\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001024\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1be2994f-2025-3f60-a257-3e7a48049747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4081000572\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"07917df6-6478-34eb-ae87-785b8219824f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000139\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"de1a9017-c4fa-375a-ba6c-f3ffea663e3d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900198\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fccf2bde-bbc9-3aef-880e-ce36cae7f85a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001025\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcb60a92-a1a0-35d5-abcf-08f9f9117095\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500661\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7c28287a-cd26-3ecf-a193-d1775345c1b9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4080900424\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a39d803c-107e-3210-91b9-404f0f9f688c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065600702\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9bf503a7-4f45-3294-9446-d57ed3fa0f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800382\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4302a7d-ee75-3d80-855f-de2dee077577\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4072900369\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"47b95c91-2def-3d3c-9b80-9fd816c94043\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001213\\\\\\\"},{\\\\\\\"u\\\\\\\":20802476,\\\\\\\"s\\\\\\\":\\\\\\\"A recently published study shows no long-term benefit from traditional glucosamine joint supplements. See the study results to learn more.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l3.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/ads\\\\\\\\/0-1368480943-1495.jpg\\\\\\\",\\\\\\\"width\\\\\\\":50,\\\\\\\"height\\\\\\\":75,\\\\\\\"orientation\\\\\\\":\\\\\\\"portrait\\\\\\\",\\\\\\\"ratio\\\\\\\":0.66666666666667}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjd8KgjAYxV.IC7e5MRldTC1RnLaYSN75JzUtCbIin740qRfoB-fjHL4DByBmVACjMocwNwjNSsIAqgrzQMwMIk1njCFMIECQanxiSwf5sK.ZqFtz9uU95gv1W1ZtL73prh0c3bj8vOWu6flfsE2fe4v35t3aoby89Oenota35soxbPdj6oZNkMQ4UnwQanMSR9CEUMBAFUjAtBNth6MkRuI3sNI0.QW5Wk5w,http%3A%2F%2Fwww.naturaljoint.org\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Studies Show No Long-Term Benefit From Glucosamine\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&vyQeMJp2wp1TqMGS9HGgzM2gyC2iQTdNXyAobMbwzpZ1cqM3anOKsBNh3xmOca9DzPnAObH0NzsEcFTi6j6sp.qSUnyRS.HFExV7X0xa_VUqmVqwUqaq0YnkyFJzNIL6GQ04yLGzI1MEloEpdK7yKQgsGXoap6fcA_DsiEyAeYyKvtjXZXQoGhJBv1ym.dWSuy1aj.xFohSScuXXZXwIhGYLQzr61C1zbW8WmrTQM68Dc7jxOSmvbwNd3qcvZq5SXaSYyI1Cm25k.BwwuizeATIQB.Q26qML1.THT3mT3NfnFXUUAOkc6eYTxkhCAjpZkocPR4sw_zj9W1.WUifx5RZKo4tKHGZXfmq6cch.tfXVBuG69JsBEBFC9tPpjGA4UojAyt.4jfDUBmhl2_xBbylBqyD7ElNNy9P4wDFnnvej.5jLYmScVmxjcr52.NRwOB56LfSTTmA1wvLmt1nYnJNRyTxd.MBVXVkZFjgzSx2B6DxvIEQ.mOIALnnFAw4BEa5ZLtj5aOzTcA1A9EhifA49lTxlsX5LPjzVP1F9.KWPFnJlg7KK3lkjcVp0nW_eLtF1DSoLzew2CtKxC4pY0N6N1VSm76wgm3V94ALFVoqzsCaWnYv5kXCIt.ZL9Nv0b9obXoPwF4VOU.XoqECWrUjoizNYm2DY_KatB2AvINE5wduA9m05OemaTHnSnVDM2Zo8Q40e2tYFknLlQWz4wdtHDPiSnAq2mx4meIuza49c48KL1Jd9zmNFPYZBcr3Ysjl7KUXYQBi8MqG9NpTnRSihgN7tz.SuyvRDzasYQO64s_kv4p1OU2HPhNwNp6dsHg--&ap=81\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Greek Island Labs\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ed583ae-67ff-3853-aaf1-86901581ce2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4059000198\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"dacd78e7-9feb-3a5b-93da-4671482229b2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4038700258\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8f518ad0-4b6e-34f0-97b0-81fcf08ebaea\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100205\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4832980c-2037-3392-b43e-846739d2a79e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001064\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a34e541-0403-3e59-b0d0-f0fb28666525\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800412\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b4bebef1-c728-3d5b-9f21-cee351d0c35a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4034800420\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e771ab9e-bef4-36f0-a1f6-745e13c58aa4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100169\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e4bb5d47-7633-3c34-83d5-0612bbb1da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4031300338\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"365f8ec3-3449-3292-bedd-b8525ea07a98\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4053100420\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ade7515b-f561-356b-810d-457e63632c09\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000960\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"81e651ea-58d5-34ac-8d57-fb424d7b24a0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800309\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"87c2b200-aa22-3ecf-99d6-72a7c6012b2d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4028200219\\\\\\\"},{\\\\\\\"u\\\\\\\":21068314,\\\\\\\"s\\\\\\\":\\\\\\\"Brain games are clinically proven to improve memory, attention and IQ. Harness your brain's neuroplasticity and train your way to a brighter life.\\\\\\\",\\\\\\\"im\\\\\\\":{\\\\\\\"original\\\\\\\":{\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l3.yimg.com\\\\\\\\/av\\\\\\\\/moneyball\\\\\\\\/curated\\\\\\\\/171155-1366394442.jpg\\\\\\\",\\\\\\\"width\\\\\\\":82,\\\\\\\"height\\\\\\\":82,\\\\\\\"orientation\\\\\\\":\\\\\\\"square\\\\\\\",\\\\\\\"ratio\\\\\\\":1}},\\\\\\\"ur\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/clk?3,eJytjcsOgjAQRX-oC9pCU9K4KA8NClWSIsFdkZePIgsiwa83IOELPIu5dzJ3ciFmZgUtXOQI5SahqiAM4upql8RWCAODMYYtgiBGFPCJE-3jgavy4TvzHr7eSc1.TOrU7pKbpu.hg1LLuYVNx.-Ca-95sPhg7q09youu1aOkzhrbxR9xz2AkkzFME-soeR.J7TO6wUagCIep0JkUWuhgEOm5ucTr5wYA4wvnbU8y,https%3A%2F%2Fwww.lumosity.com%2Flanding%3Frefer%3D4650\\\\\\\",\\\\\\\"t\\\\\\\":\\\\\\\"Scientific Brain Teasers\\\\\\\",\\\\\\\"b\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/ad.yieldmanager.com\\\\\\\\/csc?ve=2&Qx70NEd2wp2ZoPPJFdVWlOwvYaKIhuuuNzks6FYjpLHr0eDHXuoBr_wwBqFSFvIhCzuzzs15xG76JDw7FQHLUroh.L6bKEP3dXmjsgEsy1jKRzqdSR3CP7Q9QE335dSrT1uU0bMjIFEXihdJKDV0PUA2tW6gE4jkS4CyfFuVSG8rapiobMXGxTgwQMweYjWetCWPUIAz_qF2oQ50VM.YhUqXsG2qSLiKVe8mOgej6d5j1xBbBXTxjA7i0hdJHL9wOmXAnLFc5gfoDkYwMHkdD6hnmxcTULDYkqCjmA_kxYXc_B0B1I35.mKGKdK0DtIk..LH3VJm5gps97UygZYQ3lF_nIEgr1PBG0HvlQ8Yw4XZrMervZt6_xdtryXKn9qiH.NEz6_TFYCF0jwwnEDG3Lihjo2R.RJ5uKWnm_iINGqk7NT0FBGZioEkIYmR9XRoElzke2v01TFH1cCBPq1sQOfN7FOr.XGN1TyQ8RAPKmQ3K9Vnqgh.5T8MOGxe0L4xrs_kfYb4j96PF9CBKOPwMF8O6yi_MhD226m21Bk3v2Ba0kOqdvZtmtpsD13WX4Bn6QdBJbI4KoWbblreD42yhcLz6Z4OmqytL.kf4d1mDFzXvpqxzxBQL0VGjalP32E6gX6pDYGG2TQqwAjhbuuX8DHAl4nSDzWwdQzrl4ocYZ0i5GEd5Yte6YyBu3WGI72XjtkLl.MTU.q3NvWqqtSw3yE_sv2_DfwBSN3g_PTJqWr8GHxElBXNzyMzuKwEICQFtNFdPgn.pTFuXVhQB1_Q3DLKSpmX.nFY3NjgTSoObGZhrg4y7N1zIZGKp9yIlZSAWA--&ap=94\\\\\\\",\\\\\\\"ia\\\\\\\":1,\\\\\\\"at\\\\\\\":\\\\\\\"Lumosity\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"840f9c6d-87ba-3b2d-aa1a-3c3c4b7a5a4c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4022800271\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7ac0b3f5-9a41-3595-85e7-b394b8f49b28\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4028200208\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"036f4818-5282-3896-a7c0-e03a87689ca5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4016600298\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"77d99ad3-23b2-31a4-9d15-beda9147cf9e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4090001038\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d443a8ca-9d9d-3adf-aaaf-00d01aee0747\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4025400497\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6721eeda-5e99-3b9e-85b2-ad4f1a29ffa3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000414\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ffe28b2-6ff5-3f89-87b3-73f90aab3ce0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500221\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5405616f-5db9-3cf0-b76d-6c0ae86b8d0e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4013500777\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8f5bb9e-a7fa-3ddc-a3ed-5984194e14d1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500418\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0224f7db-6b78-37eb-bb13-96c734c79645\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001084\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"64a0f5e9-826f-30c1-b87a-cdd14e8f044b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4020500216\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"716a86c2-e772-3b80-ba2f-37ed8ecda763\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100274\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3b06a203-610c-3a58-8024-a51b661e896b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001004\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4398511d-e0b9-3bcc-b8d7-8c927257da97\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4018500168\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fab07708-6eec-331c-a049-53f865291f9b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100260\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"55836cbc-0d5c-3fbe-b9bf-13bdbb891e66\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005302076\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"34c6686d-577e-34a0-bb2b-887d9b40d3f5\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000353\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45888b8f-3460-3aa1-9a52-2dfe51afff60\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000940\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e8528082-d943-35fc-af50-14e4c1f8180e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4013500173\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8c76553-0434-33b6-b68c-a39e35bba1bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4012100172\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"95cbd68e-ffcb-3da5-8dfd-436af201ec90\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4008800347\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3a8ef146-eaf8-30f1-ab7f-bab556ede552\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000412\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"733bf5ee-6160-3040-82d5-1d2f42636f8b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000874\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"90742b99-96f2-38a3-9ad1-f55b2620aaee\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4010000161\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2ad2eb07-5b9c-307c-b9ff-bcb3aa6bf5b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009000166\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db5e4a50-d8ef-386f-b1e6-e25cdf7f287a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4009800153\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f8528bff-bebc-36e9-9e88-cc513c0787c6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000869\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"83795d21-e026-38af-b60b-62dc9facb361\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100533\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005900268\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5dc7227d-d4a6-352f-8649-0db6aa60341d\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100507\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c2ab26f4-4d85-34de-9900-e8fb300fc296\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000965\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f784f21c-dea8-3214-a2bd-4448415496ff\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800193\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2efae028-b5e0-39a5-980b-7c19ab0f0244\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007900189\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9db1ef8a-a304-3fa9-9e1c-b465e737c544\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700714\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a47ca09-04b3-337f-b6ff-583211b66950\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005200180\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0bb3174a-3588-3c95-a547-6c0cb658a1c0\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4007100520\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"b40c8d61-0cfc-365c-919f-dc77294f18e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004700201\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"a63cf34e-c218-3e8d-892b-0bbc6156f9d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001051\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"929877e0-37bb-39dd-9bee-f9e8bbe00dc9\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4006400154\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4153a74c-4462-3ee0-bc00-dff34f2d850f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005800351\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"09c0d581-8f4f-3555-871e-31a0b18a7951\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000915\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6c039a5e-146d-3da8-812c-fb6d65e19f76\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4004200467\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"973d19f5-0a84-333c-b992-8eeedd738f43\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4005200127\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"97231cf5-bb20-3ff0-802b-a452829f1fa8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003400209\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7e9aea73-f2a9-3a22-bbf3-d6e29ae9fe19\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4003400180\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3d28a848-ba81-36fe-9887-29f619d7ccf4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001600320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1216abdc-0bc1-3b4c-b978-4c4d848a26bb\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4002500171\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9e07f5b8-ae97-3c06-9843-1beaf8ff297e\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000934\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"45860a48-cd9e-3f22-b47b-d286f2110b6a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000400828\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"5ba9c757-db40-3d11-bf39-ae7cc0a41761\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4001400426\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"f540de91-027a-3001-8280-5af27c52c12c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000300505\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fe72c946-5768-3657-aaa1-d0c92ed812b4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200523\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e2b6485f-3de9-3bba-85da-4ddb382a056f\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001019\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2f6fa4bf-7163-3097-962e-5dbd610c2c21\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200359\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"24f5c185-57dc-37e7-8698-dd1838bda8a4\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200733\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"db030f8d-4a11-31e4-86e4-cb8f0f8aaf82\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000891\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"7940011d-7d91-3045-a1aa-eeecfdd0450c\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100312\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"1d1e6988-fd19-36ec-a633-a290e04d1bab\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100441\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3c1b56c7-a888-3532-8f69-823389ab58d7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000200152\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"12577891-fe2e-3bf6-8872-48283cc99542\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100230\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bd973d04-cffe-3617-bc91-64631e02e263\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000100304\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8ca67350-b65a-3884-b411-df6018ebbf14\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000837\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"e115e1c2-e6e7-34b5-8725-65647725e6f3\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000216\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"3184a818-422d-31fa-b2ca-3fc25f1e8306\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000320\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d0d8429-ce92-3d20-96df-8dcdc20a1185\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000347\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"da3fd914-a729-3606-93ce-58d974416a92\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000246\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2382e5e0-34c2-3019-9bc1-dd64411f42b6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000828\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"ebe271cf-d612-3d45-8886-03aeb92bb7cd\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000362\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"6ae66b10-fc06-31ad-bdce-f630dab5f4fc\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000303\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"979f41be-1edc-32f5-ac09-17715c88e294\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000273\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d8ca681e-2bfb-3e08-b33f-0d41e9916217\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000292\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"d9a55b19-9a27-3da5-b16b-c6f245fbc386\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000131\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"9d198649-3883-3f02-a39f-33e7c6ac21f8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000155\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"933524d2-947f-3f9c-aeae-a5a45b0619b8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4065601206\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"4ec09f8e-84c3-3934-b092-39cb092d10a2\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000509\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"fcc8c90a-e9a3-3d4d-b0c6-80066b5a761a\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100001012\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000002190\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"0d02e61e-1b5e-3a00-8a69-ebbd5627e76b\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000588\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"c96bd902-72ef-3422-a162-bb80c37028e1\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000206\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"44f44e84-8894-3136-b6fc-efb8b7c77f84\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000239\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"408b827f-4639-3495-bbc5-33698c6a3bc7\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4000000560\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"2bcd2824-1695-3c99-afeb-5964e993f1f6\\\\\\\",\\\\\\\"i\\\\\\\":\\\\\\\"4100000829\\\\\\\"},{\\\\\\\"u\\\\\\\":\\\\\\\"bcd13eef-3b76-3eb8-b13e-66e0a2432378\\\\\\\",\\\\\\\"flbk\\\\\\\":true},{\\\\\\\"u\\\\\\\":\\\\\\\"cf8c7775-d027-3207-af8c-86bffe8db6fe\\\\\\\",\\\\\\\"flbk\\\\\\\":true},{\\\\\\\"u\\\\\\\":\\\\\\\"3c63b3a1-1f89-3ac8-bbba-ca7b82d3f780\\\\\\\",\\\\\\\"flbk\\\\\\\":true}],\\\\\\\"contentpos\\\\\\\":22,\\\\\\\"interestsData\\\\\\\":{\\\\\\\"YCT:001000667\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Crime & Justice\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/crime-and-justice\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000780\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Society\\\\\\\",\\\\\\\"count\\\\\\\":164,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/society-and-culture\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Shooting_of_Trayvon_Martin\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Shooting of Trayvon Martin\\\\\\\",\\\\\\\"count\\\\\\\":123,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/shooting-of-trayvon-martin\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000346\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Personal Investing Ideas & Strategies\\\\\\\",\\\\\\\"count\\\\\\\":48,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/personal-investing-ideas-and-strategies\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000992\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Transportation\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/transportation\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000395\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Health\\\\\\\",\\\\\\\"count\\\\\\\":170,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/health\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000495\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Family Health\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/family-health\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000661\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Politics\\\\\\\",\\\\\\\"count\\\\\\\":161,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/politics-and-government\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000680\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Foreign Policy\\\\\\\",\\\\\\\"count\\\\\\\":38,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/foreign-policy\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":294,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/barack-obama\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Mohamed_Morsi\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Mohamed Morsi\\\\\\\",\\\\\\\"count\\\\\\\":90,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/mohamed-morsi\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Egypt\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Egypt\\\\\\\",\\\\\\\"count\\\\\\\":186,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/egypt\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"United States\\\\\\\",\\\\\\\"count\\\\\\\":139,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/united-states\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Hosni_Mubarak\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Hosni Mubarak\\\\\\\",\\\\\\\"count\\\\\\\":37,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/hosni-mubarak\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Cairo\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Cairo\\\\\\\",\\\\\\\"count\\\\\\\":6,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/cairo\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000069\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Celebrities\\\\\\\",\\\\\\\"count\\\\\\\":86,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/celebrities\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000070\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Royal Families\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/royal-families-2\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Prince_Harry_of_Wales\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Prince Harry of Wales\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/prince-harry-of-wales\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Kensington_Palace\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Kensington Palace\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/kensington-palace\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000700\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration Issues\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/immigration-issues\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Culture_of_the_United_States\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Culture of the United States\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/culture-of-the-united-states\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000267\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Education\\\\\\\",\\\\\\\"count\\\\\\\":45,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/education\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000269\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Schools\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/schools\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Elementary_school\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Elementary school\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/elementary-school\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Ink_cartridge\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Ink cartridge\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/ink-cartridge\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Immigration_reform\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Immigration reform\\\\\\\",\\\\\\\"count\\\\\\\":32,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/immigration-reform\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000705\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Military\\\\\\\",\\\\\\\"count\\\\\\\":53,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/military-and-defense\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Unmanned_aerial_vehicle\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Unmanned aerial vehicle\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/unmanned-aerial-vehicle\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Aircraft_carrier\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Aircraft carrier\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/aircraft-carrier\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patuxent_River\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patuxent River\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/patuxent-river\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000123\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Business\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/business\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Panera_Bread\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Panera Bread\\\\\\\",\\\\\\\"count\\\\\\\":11,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/panera-bread\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:National_Security_Agency\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"National Security Agency\\\\\\\",\\\\\\\"count\\\\\\\":61,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/national-security-agency\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:California\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"California\\\\\\\",\\\\\\\"count\\\\\\\":74,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/california\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Solitary_confinement\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Solitary confinement\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/solitary-confinement\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Bob_McDonnell\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Bob McDonnell\\\\\\\",\\\\\\\"count\\\\\\\":3,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/bob-mcdonnell\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Governor_of_Virginia\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Governor of Virginia\\\\\\\",\\\\\\\"count\\\\\\\":2,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/governor-of-virginia\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000804\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Religion\\\\\\\",\\\\\\\"count\\\\\\\":30,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/religion-and-beliefs\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Southern_Baptist_Convention\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Southern Baptist Convention\\\\\\\",\\\\\\\"count\\\\\\\":1,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/southern-baptist-convention\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000681\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Government\\\\\\\",\\\\\\\"count\\\\\\\":0,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/government\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:White_House\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"White House\\\\\\\",\\\\\\\"count\\\\\\\":129,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/white-house-2\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Presidency_of_Barack_Obama\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Presidency of Barack Obama\\\\\\\",\\\\\\\"count\\\\\\\":45,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/www.yahoo.com\\\\\\\\/topic\\\\\\\\/presidency-of-barack-obama\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Patient Protection and Affordable Care Act\\\\\\\",\\\\\\\"count\\\\\\\":32,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/patient-protection-and-affordable-care-act\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000031\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Arts & Entertainment\\\\\\\",\\\\\\\"count\\\\\\\":170,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/arts-and-entertainment\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1},\\\\\\\"YCT:001000076\\\\\\\":{\\\\\\\"name\\\\\\\":\\\\\\\"Movies\\\\\\\",\\\\\\\"count\\\\\\\":170,\\\\\\\"url\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/news.yahoo.com\\\\\\\\/movies\\\\\\\\/\\\\\\\",\\\\\\\"declared\\\\\\\":1}},\\\\\\\"ccode\\\\\\\":\\\\\\\"news\\\\\\\"},\\\\\\\"props\\\\\\\":{\\\\\\\"refHandler\\\\\\\":\\\\\\\"cfg.maple_dali.handler.refresh\\\\\\\",\\\\\\\"id\\\\\\\":\\\\\\\"u_30345786\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_stream\\\\\\\",\\\\\\\"trusted\\\\\\\":true,\\\\\\\"type\\\\\\\":\\\\\\\"stream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345786\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"Stream\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.LOADING\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\\\u003ELoad more stories\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\\\\"STR.LOADING.CONTENT\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"loading next-batch\\\\\\\\\\\\\\\" data-key=\\\\\\\\\\\\\\\"0\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"fp-loader ti\\\\\\\\\\\\\\\"\\\\u003ELoad more stories&hellip;\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\\\\"STR.BUTTON.REMOVE_DONE\\\\\\\":\\\\\\\"\\\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs remove-done uibutton rapid-noclick-resp\\\\\\\\\\\\\\\"\\\\u003EDone\\\\u003C\\\\\\\\/button\\\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.CONFIRM\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"STR.BUTTON.WIKIID\\\\\\\":\\\\\\\"\\\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xxs wikiid uibutton rapid-noclick-resp {selected}\\\\\\\\\\\\\\\" data-wikiid=\\\\\\\\\\\\\\\"{id}\\\\\\\\\\\\\\\" data-interesttype=\\\\\\\\\\\\\\\"{type}\\\\\\\\\\\\\\\"\\\\u003E{name}\\\\u003Cspan class=\\\\\\\\\\\\\\\"d-ib img-sprite remove-neg\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003C\\\\\\\\/button\\\\u003E\\\\\\\",\\\\\\\"STR.SHOW.LESS\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"show-less fz-xs\\\\\\\\\\\\\\\"\\\\u003EShow me fewer stories about:\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\\\\"STR.REMOVE.MENU\\\\\\\":\\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"menu\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cbutton class=\\\\\\\\\\\\\\\"fz-xs undo rapid-noclick-resp\\\\\\\\\\\\\\\"\\\\u003EUndo\\\\u003C\\\\\\\\/button\\\\u003E\\\\u003Cp class=\\\\\\\\\\\\\\\"title fz-xs\\\\\\\\\\\\\\\"\\\\u003EStory removed\\\\u003C\\\\\\\\/p\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"remove-menu-main cf\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"login hidden\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_b27\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_default\\\\\\\\\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\\\\\\\\\"default-p_30345826_b27-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd type_login type_login_default\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"embed\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ch3 class=\\\\\\\\\\\\\\\"title mb-l\\\\\\\\\\\\\\\"\\\\u003ESign in to save your preferences:\\\\u003C\\\\\\\\/h3\\\\u003E\\\\u003Cdiv class=\\\\\\\\\\\\\\\"btns fz-xs\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\\\\\\\\\"login-svc ylogin login-btn-purple rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"https:\\\\\\\\/\\\\\\\\/login.yahoo.com\\\\\\\\/config\\\\\\\\/login?.src=fpctx&.intl=us\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-yh;itc:0;cat:;\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite y-icon\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/i\\\\u003EYahoo!\\\\u003C\\\\\\\\/a\\\\u003E \\\\u003Cspan class=\\\\\\\\\\\\\\\"login-or d-ib\\\\\\\\\\\\\\\"\\\\u003Eor\\\\u003C\\\\\\\\/span\\\\u003E \\\\u003Cspan class=\\\\\\\\\\\\\\\"fb-button-wrapper d-ib\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ca class=\\\\\\\\\\\\\\\"login-svc fblogin login-btn-fbblue rapidnofollow rapid-noclick-resp login-btn-small\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\/\\\\\\\\/open.login.yahoo.net\\\\\\\\/openid\\\\\\\\/yrp\\\\\\\\/hr_signin?.intl=us&idp=facebook&ts=1373481900&rpcrumb=opO.PAXz7D8&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history\\\\\\\\\\\\\\\" data-action=\\\\\\\\\\\\\\\"click\\\\\\\\\\\\\\\" data-action-outcome=\\\\\\\\\\\\\\\"login\\\\\\\\\\\\\\\" data-ylk=\\\\\\\\\\\\\\\"sec:td-strm-rm;slk:login-fb;cat:;\\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\\"\\\\u003E\\\\u003Ci class=\\\\\\\\\\\\\\\"img-sprite fb-icon\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/i\\\\u003EFacebook\\\\u003C\\\\\\\\/a\\\\u003E\\\\u003Cspan class=\\\\\\\\\\\\\\\"fb-disclaimer narrow-disclaimer fz-xxs\\\\\\\\\\\\\\\"\\\\u003EWe don't post anything without your permission.\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E    \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\\n\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\u003Ca class=\\\\\\\\\\\\\\\"profile-link d-ib rapid-noclick-resp fz-xs dn\\\\\\\\\\\\\\\" href=\\\\\\\\\\\\\\\"http:\\\\\\\\/\\\\\\\\/profile.yahoo.com\\\\\\\\/y\\\\\\\\/settings\\\\\\\\/interests\\\\\\\\/\\\\\\\\\\\\\\\"\\\\u003EEdit content preferences\\\\u003C\\\\\\\\/a\\\\u003E\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\"},\\\\\\\"res\\\\\\\":{},\\\\\\\"mods\\\\\\\":[{\\\\\\\"props\\\\\\\":{\\\\\\\"trusted\\\\\\\":true,\\\\\\\"id\\\\\\\":\\\\\\\"p_30345810_fcd\\\\\\\",\\\\\\\"type\\\\\\\":\\\\\\\"fstream\\\\\\\",\\\\\\\"ns\\\\\\\":\\\\\\\"type_fstream\\\\\\\",\\\\\\\"contentId\\\\\\\":\\\\\\\"30345810\\\\\\\",\\\\\\\"tags\\\\\\\":[],\\\\\\\"title\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"icon\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"shortTitle\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"detailUrl\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"chromecolor\\\\\\\":\\\\\\\"blue\\\\\\\"},\\\\\\\"data\\\\\\\":{\\\\\\\"dropdownHover\\\\\\\":true,\\\\\\\"dynamicMax\\\\\\\":0,\\\\\\\"filterRestoreEnabled\\\\\\\":false,\\\\\\\"dropdownFilter\\\\\\\":false,\\\\\\\"tabFilter\\\\\\\":true,\\\\\\\"autoHideEnabled\\\\\\\":true,\\\\\\\"recentFiltersEnabled\\\\\\\":false,\\\\\\\"saveEnabled\\\\\\\":false,\\\\\\\"swipeFilterEnabled\\\\\\\":false,\\\\\\\"filterFontSize\\\\\\\":\\\\\\\"fz-s\\\\\\\"},\\\\\\\"strs\\\\\\\":{\\\\\\\"STR.FILTERS.FILTERBY\\\\\\\":\\\\\\\"Filter by\\\\\\\"},\\\\\\\"state\\\\\\\":{\\\\\\\"view\\\\\\\":\\\\\\\"default\\\\\\\",\\\\\\\"defer\\\\\\\":false,\\\\\\\"collapsed\\\\\\\":0},\\\\\\\"prefs\\\\\\\":{\\\\\\\"isc\\\\\\\":0,\\\\\\\"_mc\\\\\\\":0}}]}]}],\\\\\\\"res\\\\\\\":{\\\\\\\"css\\\\\\\":{\\\\\\\"helpers_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/ui\\\\\\\\/helpers_0.0.6.css\\\\\\\",\\\\\\\"typography_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/ui\\\\\\\\/typography_0.0.2.css\\\\\\\",\\\\\\\"theme_default_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/theme\\\\\\\\/default\\\\\\\\/common_0.0.29.css\\\\\\\",\\\\\\\"theme_default_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/theme\\\\\\\\/default\\\\\\\\/desktop_0.0.62.css\\\\\\\",\\\\\\\"tooltip_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/tooltip_service_1.0.12.css\\\\\\\",\\\\\\\"type_stream_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/stream_0.0.271.css\\\\\\\",\\\\\\\"theme_gs_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/theme_gs_0.0.45.css\\\\\\\",\\\\\\\"login_service_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/login_service_0.0.3.css\\\\\\\",\\\\\\\"rmx_ads_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/rmx_ads_0.0.8.css\\\\\\\",\\\\\\\"type_fstream_desktop_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/fstream\\\\\\\\/fstream_desktop_0.0.21.css\\\\\\\",\\\\\\\"type_login_css\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/login\\\\\\\\/login_0.0.71.css\\\\\\\"},\\\\\\\"js\\\\\\\":{\\\\\\\"oop\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/oop_3.8.1.js\\\\\\\",\\\\\\\"event-custom-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-custom-base_3.8.1.js\\\\\\\",\\\\\\\"event-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-base_3.8.1.js\\\\\\\",\\\\\\\"io-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/io-base_3.8.1.js\\\\\\\",\\\\\\\"json-parse\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/json-parse_3.8.1.js\\\\\\\",\\\\\\\"json-stringify\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/json-stringify_3.8.1.js\\\\\\\",\\\\\\\"cookie\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/cookie_3.8.1.js\\\\\\\",\\\\\\\"jsonp\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/jsonp_3.8.1.js\\\\\\\",\\\\\\\"dom-core\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-core_3.8.1.js\\\\\\\",\\\\\\\"dom-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-base_3.8.1.js\\\\\\\",\\\\\\\"dom-style\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-style_3.8.1.js\\\\\\\",\\\\\\\"selector-native\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector-native_3.8.1.js\\\\\\\",\\\\\\\"selector\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector_3.8.1.js\\\\\\\",\\\\\\\"node-core\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-core_3.8.1.js\\\\\\\",\\\\\\\"node-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-base_3.8.1.js\\\\\\\",\\\\\\\"node-style\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-style_3.8.1.js\\\\\\\",\\\\\\\"transition\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/transition_3.8.2.js\\\\\\\",\\\\\\\"selector-css2\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector-css2_3.8.1.js\\\\\\\",\\\\\\\"selector-css3\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/selector-css3_3.8.1.js\\\\\\\",\\\\\\\"event-custom-complex\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-custom-complex_3.8.1.js\\\\\\\",\\\\\\\"event-synthetic\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-synthetic_3.8.1.js\\\\\\\",\\\\\\\"event-focus\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-focus_3.8.1.js\\\\\\\",\\\\\\\"event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/event-delegate_3.8.1.js\\\\\\\",\\\\\\\"node-event-delegate\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-event-delegate_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-base\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/pluginhost-base_3.8.1.js\\\\\\\",\\\\\\\"pluginhost-config\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/pluginhost-config_3.8.1.js\\\\\\\",\\\\\\\"node-pluginhost\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-pluginhost_3.8.1.js\\\\\\\",\\\\\\\"dom-screen\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/dom-screen_3.8.1.js\\\\\\\",\\\\\\\"node-screen\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/node-screen_3.8.1.js\\\\\\\",\\\\\\\"gallery-storage-lite\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/yui\\\\\\\\/gallery-storage-lite_3.8.1.js\\\\\\\",\\\\\\\"module_platform\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/module_platform_1.1.14.js\\\\\\\",\\\\\\\"resourcemgr\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/resourcemgr_1.1.14.js\\\\\\\",\\\\\\\"transport\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/dali_transport_1.1.34.js\\\\\\\",\\\\\\\"metro_ext\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/metro_dali_1.0.27.js\\\\\\\",\\\\\\\"module_api\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/module_api_1.1.16.js\\\\\\\",\\\\\\\"yui_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/dali\\\\\\\\/yui_service_0.1.17.js\\\\\\\",\\\\\\\"metro_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/metro_viewtype_0.1.24.js\\\\\\\",\\\\\\\"default_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/default_viewtype_0.1.61.js\\\\\\\",\\\\\\\"edit_viewtype\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/edit_viewtype_0.1.40.js\\\\\\\",\\\\\\\"ylc\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uicontrib\\\\\\\\/ylc_1.8.22.js\\\\\\\",\\\\\\\"instrumentation_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/instrumentation_service_0.1.83.js\\\\\\\",\\\\\\\"userinfo_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/userinfo_service_0.1.15.js\\\\\\\",\\\\\\\"statemgr_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/statemgr_service_0.1.20.js\\\\\\\",\\\\\\\"metrologger_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/metrologger_service_0.1.18.js\\\\\\\",\\\\\\\"tooltip_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/tooltip_service_0.1.56.js\\\\\\\",\\\\\\\"autohide_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/autohide_service_0.1.15.js\\\\\\\",\\\\\\\"badge\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro2\\\\\\\\/g\\\\\\\\/badge\\\\\\\\/badge_0.1.20.js\\\\\\\",\\\\\\\"type_stream\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/stream\\\\\\\\/stream_0.0.456.js\\\\\\\",\\\\\\\"storage_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/storage_service_0.0.1.js\\\\\\\",\\\\\\\"login_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/login_service_0.0.38.js\\\\\\\",\\\\\\\"interests_service\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/uiplugins\\\\\\\\/interests_service_0.1.1.js\\\\\\\",\\\\\\\"type_fstream\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/fstream\\\\\\\\/fstream_0.0.95.js\\\\\\\",\\\\\\\"type_login\\\\\\\":\\\\\\\"http:\\\\\\\\/\\\\\\\\/l.yimg.com\\\\\\\\/nn\\\\\\\\/lib\\\\\\\\/metro\\\\\\\\/g\\\\\\\\/login\\\\\\\\/login_0.0.32.js\\\\\\\"}}};\\\\u000a}()\\\\u000a);\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a\\\\u003Cscript type=\\\\\\\"text/javascript\\\\\\\"\\\\u003E\\\\u000a(function(){\\\\u000a    YUI.add(\\\\\\\"metro_config\\\\\\\", function(Y){\\\\u000a        // until dali defaults this\\\\u000a\\\\u000a        Y.mix(Y.dali.config.props, {\\\\u000a            libRoot: \\\\\\\"\\\\\\\",\\\\u000a            user : \\\\\\\"\\\\\\\",\\\\u000a            ultSpaceId : \\\\\\\"2023538075\\\\\\\",\\\\u000a            ultBeaconHost : \\\\\\\"\\\\\\\\/p.gif\\\\\\\",\\\\u000a            modChromeHtml : \\\\\\\"\\\\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"mod view_error\\\\\\\\\\\\\\\"\\\\u003E  \\\\u003Cdiv id=\\\\\\\\\\\\\\\"error-{type_name}-bd\\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\\"bd  _error\\\\\\\\\\\\\\\"\\\\u003E{html}    \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\\n\\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            modErrorHtml : \\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\n                \\\\u003Cspan class='icon' style='background-image:url({img});_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop src=\\\\\\\\\\\\\\\"{img}\\\\\\\\\\\\\\\"); _background-image:none;'\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\u003Cspan class='shadow'\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\\\\\n                \\\\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\\\\\\\\"{name}\\\\\\\\\\\\\\\" encountered a problem while trying to load\\\\u003C\\\\\\\\/h3\\\\u003E\\\\\\\\n                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E{message}\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n                                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops oops-link\\\\\\\\\\\\\\\"\\\\u003EOr visit \\\\u003Ca href=\\\\\\\\\\\\\\\"{url}\\\\\\\\\\\\\\\"\\\\u003E{url}\\\\u003C\\\\\\\\/a\\\\u003E\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n            \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            crumbErrorHtml : \\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\n                \\\\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\\\\\n                \\\\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003EThe module encountered a problem while trying to load\\\\u003C\\\\\\\\/h3\\\\u003E\\\\\\\\n                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E2048\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n                \\\\\\\\n            \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            cookieErrorHtml : \\\\\\\"\\\\u003Cdiv class=\\\\\\\\\\\\\\\"oops-msg\\\\\\\\\\\\\\\" role=\\\\\\\\\\\\\\\"alertdialog\\\\\\\\\\\\\\\"\\\\u003E\\\\\\\\n                \\\\u003Cspan class=\\\\\\\\\\\\\\\"icon icon-error y-glbl-universal\\\\\\\\\\\\\\\"\\\\u003E\\\\u003C\\\\\\\\/span\\\\u003E\\\\\\\\n                \\\\u003Ch3 class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003EThe module encountered a problem while trying to load\\\\u003C\\\\\\\\/h3\\\\u003E\\\\\\\\n                \\\\u003Cp class=\\\\\\\\\\\\\\\"oops\\\\\\\\\\\\\\\"\\\\u003E16384\\\\u003C\\\\\\\\/p\\\\u003E\\\\\\\\n                \\\\\\\\n            \\\\u003C\\\\\\\\/div\\\\u003E\\\\\\\",\\\\u000a            proxyTimeout : 15000,\\\\u000a            proxyUrl : '/hjs',\\\\u000a            intl : \\\\\\\"us\\\\\\\",\\\\u000a            \\\\\\\"ywa.rapid.enabled\\\\\\\": true\\\\u000a        });\\\\u000a    });\\\\u000a\\\\u000a    var i, len, url, match, modules,\\\\u000a        allScripts = YUI.presentation.lazyScriptList,\\\\u000a        comboRoot = 'http://l.yimg.com/zz/combo?',\\\\u000a        isCombo =  allScripts[0].indexOf(comboRoot) === 0,\\\\u000a        yuiMods = ['metro_config'],\\\\u000a        lazyScripts = [];\\\\u000a\\\\u000a    if (isCombo) {\\\\u000a        for (i = 0, len = allScripts.length; i \\\\u003C len; ++i) {\\\\u000a            url = allScripts[i].replace(comboRoot, '');\\\\u000a            allScripts = allScripts.concat(url.split('&'));\\\\u000a        }\\\\u000a        allScripts = allScripts.slice(len);\\\\u000a    }\\\\u000a\\\\u000a    for (i = 0, len = allScripts.length; i \\\\u003C len; ++i) {\\\\u000a        url = allScripts[i];\\\\u000a        match = url.match(/\\\\\\\\/yui\\\\\\\\/([^._]*)/);\\\\u000a        if (match && match.length \\\\u003E 1) {\\\\u000a            yuiMods.push(match[1]);\\\\u000a        } else {\\\\u000a            lazyScripts.push(url);\\\\u000a        }\\\\u000a    }\\\\u000a\\\\u000a    if (isCombo) {\\\\u000a        lazyScripts = [comboRoot + lazyScripts.join('&')];\\\\u000a    }\\\\u000a\\\\u000a    if (YMedia.ModulePlatform) {\\\\u000a        modules = YMedia.ModulePlatform.getModules();\\\\u000a        YMedia.ModulePlatform.stop(modules);\\\\u000a        YMedia.each(modules, YMedia.ModulePlatform.unregisterModule);\\\\u000a    }\\\\u000a    YMedia.use(yuiMods, function (Y) {\\\\u000a        Y.dali.config.debug = false;\\\\u000a        Y.Get.script(lazyScripts, { onSuccess: function(){\\\\u000a            Y.use(\\\\\\\"*\\\\\\\", function (Y) {\\\\u000a                Y.ModulePlatform.init(Y.dali.config, true);\\\\u000a            });\\\\u000a        }});\\\\u000a        var rapid = YMedia ? YMedia.rapid : null,\\\\u000a            id = 'p_30345786',\\\\u000a            container = Y.one('#' + id);\\\\u000a        if (rapid && container) {\\\\u000a            if (rapid.isModuleTracked(id)) {\\\\u000a                rapid.refreshModule(id);\\\\u000a            } else {\\\\u000a                rapid.addModules(id);\\\\u000a            }\\\\u000a        }\\\\u000a        if (container) {\\\\u000a            container.addClass('jsenabled');\\\\u000a        }\\\\u000a    });\\\\u000a\\\\u000a})();\\\\u000a\\\\u003C/script\\\\u003E\\\\u000a\\\\u000a--dali-response-split-51ddabac509b3--\\\"\\u000a    });\\u000a});\"), (\"s3082a96a62ab9f76b3168536225a817468555f1a\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", ((function() {\n        var s3082a96a62ab9f76b3168536225a817468555f1a_0_instance;\n        ((s3082a96a62ab9f76b3168536225a817468555f1a_0_instance) = ((JSBNG_Record.eventInstance)((\"s3082a96a62ab9f76b3168536225a817468555f1a_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s3082a96a62ab9f76b3168536225a817468555f1a_0\"), (s3082a96a62ab9f76b3168536225a817468555f1a_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RMP\")))[(\"RMP\")]), (\"load\")))[(\"load\")])({\n                srcNode: \"#p_30345786_container\",\n                continueOnError: true,\n                response: \"--dali-response-split-51ddabac509b3Content-Type: text/plain; charset=utf-8\\u000aRMP-Embed-Location: top\\u000a\\u000a\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/ui/helpers_0.0.6.css&nn/lib/metro/g/ui/typography_0.0.2.css&nn/lib/metro/g/theme/default/common_0.0.29.css&nn/lib/metro/g/theme/default/desktop_0.0.62.css&nn/lib/metro/g/uiplugins/tooltip_service_1.0.12.css\\\" /\\u003E\\u000a\\u000a\\u003Clink rel=\\\"stylesheet\\\" type=\\\"text/css\\\" href=\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/stream/stream_0.0.271.css&nn/lib/metro/g/stream/theme_gs_0.0.45.css&nn/lib/metro/g/uiplugins/login_service_0.0.3.css&nn/lib/metro/g/stream/rmx_ads_0.0.8.css&nn/lib/metro/g/fstream/fstream_desktop_0.0.21.css&nn/lib/metro/g/login/login_0.0.71.css\\\" /\\u003E\\u000a\\u000a--dali-response-split-51ddabac509b3Content-Type: text/html; charset=utf-8\\u000aRMP-Embed-Location: bottom\\u000a\\u000a\\u003Cdiv id=\\\"p_30345786\\\" class=\\\"rapidnofollow rapid-container dev-desktop\\\" data-ylk=\\\"sec:td-strm\\\"\\u003E\\u000a\\u003Cdiv id=\\\"default-u_30345786\\\" class=\\\"mod view_default\\\"\\u003E  \\u003Cdiv id=\\\"default-u_30345786-bd\\\" class=\\\"bd type_stream type_stream_default\\\"\\u003E\\u003Cdiv id=\\\"default-p_30345810_fcd\\\" class=\\\"mod view_default\\\"\\u003E  \\u003Cdiv id=\\\"default-p_30345810_fcd-bd\\\" class=\\\"bd type_fstream type_fstream_default\\\"\\u003E\\u003Cstyle\\u003E .type_fstream .dropdown-label-text, .type_fstream .tab-list .filter-item .filter-name, .type_fstream .filter-bar-section { background-color:#0e2b5c !important;border:solid 1px #0e2b5c !important;color:#fff !important } .type_fstream .tab-list .filter-item { opacity: 0.7; -ms-filter:\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=70)\\\"; filter: alpha(opacity=70); }.type_fstream .tab-list .filter-selected { opacity: 1; -ms-filter:\\\"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\\\"; filter: alpha(opacity=100); }\\u003C/style\\u003E\\u003Cdiv class=\\\"filter-bar-section\\\"\\u003E\\u003Cul class=\\\"tab-list d-ib fz-xs pos-r\\\"\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROP:TOPSTORIES;cpos:1;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EAll News\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"LISTID:c435b248-2107-445e-97ea-89e2ec5df60c\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:LISTID:c435b248-2107-445e-97ea-89e2ec5df60c;cpos:2;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EY! News Originals\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"YPROV:ABCNEWS\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROV:ABCNEWS;cpos:3;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EABC News\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"YPROV:ap.org\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROV:ap.org;cpos:4;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EAP\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003Cli class=\\\"filter-item d-ib\\\" data-filter=\\\"YPROV:reuters.com\\\"\\u003E\\u000a    \\u003Ca href=\\\"#\\\" data-ylk=\\\"sec:fltr-strm;slk:YPROV:reuters.com;cpos:5;pos:0;ft:1\\\"  data-action-outcome=\\\"filter\\\" class=\\\"filter-name rapidnofollow fz-s\\\" role=\\\"button\\\"\\u003EReuters\\u003C/a\\u003E\\u000a\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E    \\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u003Cul\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:1;pkgt:4;ccode:news;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fexpert-zimmerman-worse-shape-martin-144959889.html\\\" data-wikiids=\\\"YCT:001000667|YCT:001000780|WIKIID:Shooting_of_Trayvon_Martin\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002721;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-15px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/XITng7YWKM1CwU3GfV_RdA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTg1/http://media.zenfs.com/en_us/News/ap_webfeeds/d475fdac10c72e17370f6a706700275c.jpg');\\\" width=\\\"111\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/expert-zimmerman-worse-shape-martin-144959889.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:1;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;tar:news.yahoo.com;ltxt:Expert:Z;ct:1;pkgt:4;r:4100002721;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EExpert: Zimmerman was in worse shape than Martin\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ESANFORD, Fla. (AP) \\u2014 A Florida judge ruled Wednesday that Trayvon Martin&#39;s cellphone text messages about fighting and a defense animation depicting the struggle between Martin and George Zimmerman won&#39;t be introduced as evidence at Zimmerman&#39;s trial. Defense attorneys had wanted to use those pieces\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/society-and-culture/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000780\\\" data-ylk=\\\"slk:Society;sec:td-strm;cpos:1;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ESociety\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/shooting-of-trayvon-martin/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Shooting_of_Trayvon_Martin\\\" data-ylk=\\\"slk:Shooting of Trayvon Martin;sec:td-strm;cpos:2;itc:0;g:a2b156e2-bdc5-3dab-bf3c-241d681ef099;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EShooting of Trayvon Martin\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"950129f1-e974-33ae-b739-227b6ca2e187\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:2;pkgt:3;ccode:news;g:950129f1-e974-33ae-b739-227b6ca2e187;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fblogs%2Ftrending-now%2Ftoddler-buys-car-ebay-using-father-smartphone-172026670.html\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/blogs/trending-now/toddler-buys-car-ebay-using-father-smartphone-172026670.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:2;g:950129f1-e974-33ae-b739-227b6ca2e187;tar:news.yahoo.com;ltxt:ToddlerB;ct:2;pkgt:3;r:4100001328;slk:title;itc:0;prov:TrendingNow;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EToddler Buys Car on eBay Using Father\\u2019s Smartphone\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ELast month Sorella Stoute from Portland, Oregon, purchased a 1962 Austin-Healey Sprite on eBay. Now, this might not sound like much of a story, until you learn that Sorella is only 14 months old. Here&#39;s what happened. The tiny online shopper was playing with her father Paul Stoute&#39;s smartphone when\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003ETrending Now\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content rmx-ad has-image voh-parent cf\\\" data-uuid=\\\"21675196\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:3;pkgt:4;ccode:news;g:21675196;ed:0;\\\" data-url=\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o%3D%2Chttp%253A%252F%252Fwww.nextag.com%252Fgoto.jsp%253Fp%253D357374%2526crid%253D70102%2526search%253Ddress\\\" data-wikiids=\\\"\\\" data-rmx-beacon=\\\"http://ad.yieldmanager.com/csc?ve=2&V0nyIPZ2wp3wBusYIXHe592L0U7rDWPGQGsA2NLVx3J0KeGD1Gapax21gVu.4ub8eFnCFz8GoX6lzjIPOHbY1UKvAs1CeuA60UvO0.YaI6H7fSjP2UaZY6JWBoP.Y4JRu2UyaZwxD04xOZvyPdQNGYVq9AxUfRnsNZF1Y6L06KkTBbSIxFyk3TTzx.JT3qi5JFlL2QTq7h3z8NjNyDeGKHRzDxkl6_yoxQKIxLF4m8y40IG6XudIj8DF9b64cUQQHhIJHXEGWMyFysCaCq98U1ZQSR.9S_3ymGqOz5p_GZi3eptf_vUuH9Aorn5IDOJWPdjFst6IAPJXboFx_0c7_RynZr29hWH.4Y73607V3wk6aAzvWLpFV3H8bmYeKn7meWf_9d_9949AaqS_QIJLaKMWA0Dj.rW4FwZNiE61P3yRpuUx3CmmBvSFUidR6rNmRk3NYSK3F_6O9FKeYsabBo.PXQ2_tIW0.tpOGYIkRZu4nDEC7bCIucM1b5p55FC8rhu4U.M4XH2cWUOgd4CcG0N7gZqH5k.VG9DQZj9mjTF7HA2Bj9s1WPqooqjd3_gsuIUozyOhUDJk7rWhL0661.aV2jgJhyCpCH69hRILuz89M73USaOMvoeQPZL_7OudoN8niNqPD6xKYuHKCwMsDletkPtsMywAxFmuXCG6Lo4ZaXTaPguHRylbkYAyjmpNmGx_U4zR.55JxLyFd5G_zebInENUmshO.3eWcDycFODZE9bae7e_SzNR.yayrRfbK.xapTXID_8l5O3ZEr.aw9BGFFXyquRWYPTVS2ZrhAuQLfrDUdFiiZehmKEbDiXQAQ--&ap=3\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l2.yimg.com/av/moneyball/ads/bulk/6473/c1b5c4a6baf815019e3f6c79b13674e1.jpg');\\\" width=\\\"82\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:3;g:21675196;tar:ad.yieldmanager.com;ltxt:Top10Dre;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\"\\u003ETop 10 Dresses for 2013\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EHottest Dresses on sale.  Awesome selection and deals.\\u003C/p\\u003E\\u003Ca class=\\\"adlink fz-xxs rapid-noclick-resp\\\" href=\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\" target=\\\"_blank\\\"\\u003EAdChoices\\u003Ci class=\\\"img-sprite\\\"\\u003E\\u003C/i\\u003E\\u003C/a\\u003E\\u000a\\u003Ca class=\\\"fz-xxs adv rapid-noclick-resp\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjcsOgjAQRX-IBaUWShoXBYqB8EzQRnaAUB6iLlAiX294hC.wLObeydzJBZCohaahrCwOcpVrlZYTAKtCL1U9A5UkE0IgUhUAFSzRmQgP8WjiD3say-7W-UXQlVkNYW65eTILhW8ar2cepQP9C6buUmfzztIrLExvr0f.TbCxx07xFLSXJm3F6PEzChM6-Il99xtQB4rbe5zBq2J3wdTBkDPki.3zKEnyD3SrT4o=,http%3A%2F%2Fwww.nextag.com%2Fgoto.jsp%3Fp%3D357374%26crid%3D70102%26search%3Ddress\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EOfficial Nextag Site\\u003C/span\\u003E\\u003C/a\\u003E\\u003Ca href=\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\" class=\\\"fz-xxs sp rapid-noclick-resp\\\" target=\\\"_blank\\\"\\u003ESponsored\\u003C/a\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"a5d908b7-4f0c-3334-81a0-3d378bbeb520\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:4;pkgt:3;ccode:news;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fntsb-findings-sf-plane-crash-133726993.html\\\" data-wikiids=\\\"YCT:001000346|YCT:001000992\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/ntsb-findings-sf-plane-crash-133726993.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:4;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;tar:news.yahoo.com;ltxt:NTSBfind;ct:1;pkgt:3;r:4100001409;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003ENTSB findings on SF plane crash at a glance\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EAfter departing from Shanghai and stopping in Seoul, Asiana Flight 214 makes its final approach into San Francisco International Airport following a 10-hour flight across the Pacific Ocean. A preliminary ...\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/personal-investing-ideas-and-strategies/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000346\\\" data-ylk=\\\"slk:Personal Investing Ideas & Strategies;sec:td-strm;cpos:1;itc:0;g:a5d908b7-4f0c-3334-81a0-3d378bbeb520;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPersonal Investing Ideas & Strategies\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"fe94cddd-d36b-3ce5-9246-733c1229ba93\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:5;pkgt:3;ccode:news;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ed:0;\\\" data-url=\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Froyal-baby-american-british-birthing-practices-differ-115918234.html\\\" data-wikiids=\\\"YCT:001000395|YCT:001000495\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://gma.yahoo.com/blogs/abc-blogs/royal-baby-american-british-birthing-practices-differ-115918234.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:5;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;tar:gma.yahoo.com;ltxt:HowKate&;ct:2;pkgt:3;r:4100001170;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EHow Kate&#39;s Delivery Will Differ From U.S. Experience\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EThe future British monarch is due to be born any day now. Kate Middleton will deliver her child at Mary\\u2019s Hospital in London, in the same wing where Princess Diana gave birth to her own children. \\u201cIt\\u2019s a beautiful unit,\\u201d Regina Curran, a British midwife,...\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EABC News\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/health/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000395\\\" data-ylk=\\\"slk:Health;sec:td-strm;cpos:1;itc:0;g:fe94cddd-d36b-3ce5-9246-733c1229ba93;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHealth\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:6;pkgt:3;ccode:news;g:c200730b-eb18-376d-a3d3-1892197b9f54;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fwashington-vilified-both-sides-egypts-divide-174446715.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000680|WIKIID:Barack_Obama|WIKIID:Mohamed_Morsi|WIKIID:Egypt|WIKIID:United_States|WIKIID:Hosni_Mubarak|WIKIID:Cairo\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/washington-vilified-both-sides-egypts-divide-174446715.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:6;g:c200730b-eb18-376d-a3d3-1892197b9f54;tar:news.yahoo.com;ltxt:Washingt;ct:1;pkgt:3;r:4100000835;slk:title;itc:0;prov:Reuters;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EWashington vilified on both sides of Egypt&#39;s divide\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EBy Maggie Fick and Tom Finn CAIRO (Reuters) - Pictures of Barack Obama have popped up all over Cairo. Some have his faced crossed out in paint. Heavy black beards are daubed onto others. No matter which side you talk to in Egypt, where people have been polarized by a violent political crisis, the\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EReuters\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/foreign-policy/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000680\\\" data-ylk=\\\"slk:Foreign Policy;sec:td-strm;cpos:2;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EForeign Policy\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/barack-obama/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Barack_Obama\\\" data-ylk=\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EBarack Obama\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/mohamed-morsi/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Mohamed_Morsi\\\" data-ylk=\\\"slk:Mohamed Morsi;sec:td-strm;cpos:4;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EMohamed Morsi\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/egypt/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Egypt\\\" data-ylk=\\\"slk:Egypt;sec:td-strm;cpos:5;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EEgypt\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/united-states/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:United_States\\\" data-ylk=\\\"slk:United States;sec:td-strm;cpos:6;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EUnited States\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/hosni-mubarak/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Hosni_Mubarak\\\" data-ylk=\\\"slk:Hosni Mubarak;sec:td-strm;cpos:7;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EHosni Mubarak\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/cairo/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Cairo\\\" data-ylk=\\\"slk:Cairo;sec:td-strm;cpos:8;itc:0;g:c200730b-eb18-376d-a3d3-1892197b9f54;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ECairo\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content slideshow has-image voh-parent cf\\\" data-uuid=\\\"706337c9-1922-33ac-b86f-a5280ffcc242\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:7;pkgt:21;ccode:news;g:706337c9-1922-33ac-b86f-a5280ffcc242;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fphotos%2Fcarpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow%2F\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001665;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l1.yimg.com/ts/api/res/1.2/vv0qulgbBMDqq9r94wVCzw--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz0xMDA7aD0xMDA7cHlvZmY9MA--/http://l.yimg.com/os/publish-images/news/2013-07-09/147c5e94-9385-462b-85d7-4916b61620c4_fire7.jpg');\\\" width=\\\"82\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"gallery-icon\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"view-now fz-xxs\\\"\\u003EView\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/photos/carpenter-1-fire-rages-outside-las-vegas-1373414067-slideshow/\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:7;g:706337c9-1922-33ac-b86f-a5280ffcc242;tar:news.yahoo.com;ltxt:Carpente;ct:4;pkgt:21;r:4100001665;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" data-uuid=\\\"de60ffd9-ff42-4ec7-b62c-b733917baeca\\\"\\u003ECarpenter 1 fire rages outside Las Vegas \\u003Csmall\\u003E(14 photos)\\u003C/small\\u003E\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EPhotos from the Carpenter 1 fire outside Las Vegas, Nev., which has charred an area the size of Manhattan Island, according to the Associated Press .\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:8;pkgt:3;ccode:news;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ed:0;\\\" data-url=\\\"http%3A%2F%2Fgma.yahoo.com%2Fblogs%2Fabc-blogs%2Fprince-william-play-polo-while-nine-months-pregnant-150649675.html\\\" data-wikiids=\\\"YCT:001000069|YCT:001000070|WIKIID:Prince_Harry_of_Wales|WIKIID:Kensington_Palace\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://gma.yahoo.com/blogs/abc-blogs/prince-william-play-polo-while-nine-months-pregnant-150649675.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:8;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;tar:gma.yahoo.com;ltxt:PrinceWi;ct:2;pkgt:3;r:4100000840;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EPrince William to Play Polo While Nine-Months-Pregnant Kate Waits\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EPrince William has plans this weekend, but they don\\u2019t include a hospital. While his nine-months-pregnant wife, Kate, stays back home at the couple\\u2019s Kensington Palace home, Prince William will go ahead with plans to play in a charity polo match Sunday in Glouchestershire, nearly 100...\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EABC News\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/celebrities/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000069\\\" data-ylk=\\\"slk:Celebrities;sec:td-strm;cpos:1;itc:0;g:8714ae80-beb0-39b6-9ee1-bd13ffb3f5c5;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ECelebrities\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"359b4757-f472-3d49-a211-389223ffe98a\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:9;pkgt:3;ccode:news;g:359b4757-f472-3d49-a211-389223ffe98a;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fgop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000700|WIKIID:Culture_of_the_United_States\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/gop-remember-data-show-immigrants-enforce-not-threaten-171614860.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:9;g:359b4757-f472-3d49-a211-389223ffe98a;tar:news.yahoo.com;ltxt:GOPshoul;ct:1;pkgt:3;r:4090000733;slk:title;itc:0;prov:ChristianScience;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EGOP should remember: Data show immigrants enforce, not threaten, US values\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EA comprehensive immigration reform bill has passed the Senate, but it faces dubious prospects in the House, where it probably won\\u2019t garner enough of the Republican support needed to bring it to a floor vote. One Republican sticking point is that the prospective law doesn\\u2019t go far enough to ensure\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EChristian Science Monitor\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:359b4757-f472-3d49-a211-389223ffe98a;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"03ea9147-55d7-3820-996b-2c161860b5a2\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:10;pkgt:3;ccode:news;g:03ea9147-55d7-3820-996b-2c161860b5a2;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fpublicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\" data-wikiids=\\\"YCT:001000267|YCT:001000269|WIKIID:Elementary_school\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/publicly-shaming-girls-short-shorts-elementary-school-principal-132008451.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:10;g:03ea9147-55d7-3820-996b-2c161860b5a2;tar:news.yahoo.com;ltxt:Afterpub;ct:1;pkgt:3;r:4100000542;slk:title;itc:0;prov:TheDailyCaller;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EAfter publicly shaming girls for short shorts, elementary school principal apologizes\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EThe principal at a highly selective and highly prestigious Chicago elementary school has apologized for singling out and publicly shaming seven girls on the last day of school for the immodest lengths of their shorts.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Daily Caller\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/education/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000267\\\" data-ylk=\\\"slk:Education;sec:td-strm;cpos:1;itc:0;g:03ea9147-55d7-3820-996b-2c161860b5a2;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EEducation\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content cavideo has-image voh-parent cf\\\" data-uuid=\\\"c621133c-f907-3f42-93ff-20ef01effa97\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:11;pkgt:4;ccode:news;g:c621133c-f907-3f42-93ff-20ef01effa97;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fprinter-ink-efficiency-tested-consumer-174417327.html\\\" data-wikiids=\\\"WIKIID:Ink_cartridge\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001178;slk:title;itc:0;prov:KGO\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/etz.tfpoo6Au9ixj1O3c4g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.kgo.abc.news.com/20a2be41046b838e6399259f73c9f47d');\\\" width=\\\"145\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"video-icon d-ib\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"play-now fz-xxs\\\"\\u003EPlay\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/video/printer-ink-efficiency-tested-consumer-174417327.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:11;g:c621133c-f907-3f42-93ff-20ef01effa97;tar:news.yahoo.com;ltxt:Printeri;ct:3;pkgt:4;r:4100001178;slk:title;itc:0;prov:KGO\\u2013SanFrancisco;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EPrinter ink efficiency tested by Consumer Reports\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EMany don&#39;t realize it, but printer ink is one of the most expensive liquids you can buy.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EKGO \\u2013 San Francisco\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:12;pkgt:4;ccode:news;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fbush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000700|WIKIID:Immigration_reform\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900660;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-18px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/kM94ldkpwhbbDP4OY9UnYQ--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTcz/http://media.zenfs.com/en_us/News/ap_webfeeds/4e2f582e10be2e17370f6a7067003150.jpg');\\\" width=\\\"118\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/bush-benevolent-spirit-must-drive-reform-plans-141956367.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:12;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;tar:news.yahoo.com;ltxt:Bush:&#3;ct:1;pkgt:4;r:4072900660;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EBush: &#39;Benevolent spirit&#39; must drive reform plans\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EDALLAS (AP) \\u2014 Making a rare return to the political arena, former President George W. Bush urged Congress on Wednesday to reach a &quot;positive resolution&quot; on immigration reform, an issue that eluded him during his presidency and now confronts fellow Republicans in the aftermath of a 2012 election\\u2026\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/immigration-reform/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Immigration_reform\\\" data-ylk=\\\"slk:Immigration reform;sec:td-strm;cpos:2;itc:0;g:590c8c6f-61a8-3dea-9ba7-8cb83525a33b;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EImmigration reform\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"e4009e04-8a14-3454-b2ef-0adfa809f2c3\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:13;pkgt:4;ccode:news;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fnavy-attempt-1st-unmanned-carrier-landing-093729424.html\\\" data-wikiids=\\\"YCT:001000705|YCT:001000661|WIKIID:Unmanned_aerial_vehicle|WIKIID:Aircraft_carrier|WIKIID:Patuxent_River\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000590;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-37px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/qYZjBoAYvbF1JWrX_Eav.g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTMx/http://media.zenfs.com/en_us/News/ap_webfeeds/c6ce26150eb22417370f6a706700137b.jpg');\\\" width=\\\"156\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/navy-attempt-1st-unmanned-carrier-landing-093729424.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:13;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;tar:news.yahoo.com;ltxt:Navytoat;ct:1;pkgt:4;r:4100000590;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003ENavy to attempt 1st unmanned carrier landing\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ENORFOLK, Va. (AP) \\u2014 The Navy will attempt to land a drone the size of a fighter jet aboard an aircraft carrier for the first time Wednesday, showcasing the military&#39;s capability to have a computer program perform one of the most difficult tasks a pilot is asked to do.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/military-and-defense/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000705\\\" data-ylk=\\\"slk:Military;sec:td-strm;cpos:1;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EMilitary\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:2;itc:0;g:e4009e04-8a14-3454-b2ef-0adfa809f2c3;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"95413a0a-1d88-3f94-817c-d6b5fb824b6f\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:14;pkgt:4;ccode:news;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fpanera-retool-latest-pay-idea-051305138.html\\\" data-wikiids=\\\"YCT:001000123|WIKIID:Panera_Bread\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/panera-retool-latest-pay-idea-051305138.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-21px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/GRTmxi74dUkPM0bN5Tu_EA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTY3/http://media.zenfs.com/en_us/News/ap_webfeeds/a4d177310ec22417370f6a7067000233.jpg');\\\" width=\\\"123\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/panera-retool-latest-pay-idea-051305138.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:14;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;tar:news.yahoo.com;ltxt:Panerato;ct:1;pkgt:4;r:4100000490;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EPanera to retool latest pay-what-you-can idea\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EST. LOUIS (AP) \\u2014 Panera Bread&#39;s latest pay-what-you-can experiment will be retooled and brought back next winter as a seasonal offering rather than a permanent one, the chain&#39;s founder says.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/panera-bread/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Panera_Bread\\\" data-ylk=\\\"slk:Panera Bread;sec:td-strm;cpos:1;itc:0;g:95413a0a-1d88-3f94-817c-d6b5fb824b6f;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPanera Bread\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"89342141-8982-3a32-9a2e-81cda1656e16\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:15;pkgt:4;ccode:news;g:89342141-8982-3a32-9a2e-81cda1656e16;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fformer-judge-admits-flaws-secret-court-145541583.html\\\" data-wikiids=\\\"YCT:001000661|WIKIID:National_Security_Agency|WIKIID:Barack_Obama\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l2.yimg.com/ts/api/res/1.2/V1oj15r8LwVhitDeCoj3_g--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjA4O2g9MjUw/http://media.zenfs.com/en_us/News/ap_webfeeds/fab40ba5f2431816370f6a706700947e.jpg');\\\" width=\\\"82\\\" height=\\\"99\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/former-judge-admits-flaws-secret-court-145541583.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:15;g:89342141-8982-3a32-9a2e-81cda1656e16;tar:news.yahoo.com;ltxt:Formerju;ct:1;pkgt:4;r:4072901757;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EFormer judge admits flaws in secret court\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EWASHINGTON (AP) \\u2014 A former federal judge who served on a secret court overseeing the National Security Agency&#39;s secret surveillance programs said Tuesday the panel is independent but flawed because only the government&#39;s side is represented effectively in its deliberations.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/national-security-agency/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:National_Security_Agency\\\" data-ylk=\\\"slk:National Security Agency;sec:td-strm;cpos:2;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ENational Security Agency\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/barack-obama/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Barack_Obama\\\" data-ylk=\\\"slk:Barack Obama;sec:td-strm;cpos:3;itc:0;g:89342141-8982-3a32-9a2e-81cda1656e16;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EBarack Obama\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content rmx-ad has-image voh-parent cf\\\" data-uuid=\\\"21370595\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:16;pkgt:4;ccode:news;g:21370595;ed:0;\\\" data-url=\\\"http%3A%2F%2Fad.yieldmanager.com%2Fclk%3F3%2CeJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ%3D%3D%2Chttp%253A%252F%252Fclk.atdmt.com%252FINV%252Fgo%252F451647339%252Fdirect%252F01%252F\\\" data-wikiids=\\\"\\\" data-rmx-beacon=\\\"http://ad.yieldmanager.com/csc?ve=2&2cDiAE12wp2Dz.IwU74e5L1PMXSElzNIwUK.DMksZqbxsQNr9TkpxCCr3WkJefTamYWy_.RN_hVPXUN96KEmE6ByAcKWxHo_oetdF3FvXS1T4NtiQxv4YZ0_pBqtqIzH7O0ip8bvVxgjPoKrSIwG2xYGphqXGJwgoHcGcgG6If4jmnCeJkwoMjzSA8lFxsfkkKA5DGemNrz59aiXKMmKD7i9PXlW8r2bIioPHiaIYVJFP.QJdTsf__VTZFUW5lerdtC_foE9u2ATjsTvjISjazahXozJ6Oo8C8GYosDyhfSmkJHNjhhMBi9HS.XGNQH8nIB_XOkOm.hF510EM.9rqVlMhgnjknC0ca0Eccddul7I8ACjWxjY0UiLEjdHucq2K4wSP.9k9kUpE5hbigMU3SU7.cOvzOo2XODCl6dUGOGqZyJvSSz4w9hwJL7zeN54KIFBN6mk6yqN36aEqybOOSK1u36lzqH2YgNGwXAeFbbilXKTJ0DVDF6GlynUmDdFtRLyoOuThCtSKF6d6nLaCiNzVrjY05GLBZjy5kaCH14JPJh_KKyfu2OhKseyolVTvUug1YRMwuX2jv3wSMXBp.FKtRh6NG2QUwmaIGRYvA09G1x1.QgmNWuuIBy.oxdZdWOxknKRp9psnS.jbCXybIZlgH3d43a69GiPaDAIoWuKnUMJQm3rrrcxtN6mHmKojXspt5I6SJTd0aK5ltwxYLhXxAzDmD83Ph4JO2ELWwMETAXVuntQeEN1giBo4kExl_3SxoqLTQNH213UQHc5JqT6uw5Y4Bsbw1xKzn6Do.zfYxlNtrKHwoD6oZOIoIkF1g--&ap=16\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21370595;tar:ad.yieldmanager.com;ltxt:4WaystoA;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l2.yimg.com/av/moneyball/ads/0-1371163702-9044.jpg');\\\" width=\\\"82\\\" height=\\\"61\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:16;g:21370595;tar:ad.yieldmanager.com;ltxt:4WaystoA;ct:1;pkgt:4;ad:1;slk:title;itc:0;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\"\\u003E4 Ways to Avoid Running Out of Money in Retirement\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EIf you have a $500,000 portfolio, download the &quot;15-Minute Retirement Plan&quot; by Forbes columnist Ken Fisher's Firm.\\u003C/p\\u003E\\u003Ca class=\\\"adlink fz-xxs rapid-noclick-resp\\\" href=\\\"http://info.yahoo.com/privacy/us/yahoo/adinfo_geo.html\\\" target=\\\"_blank\\\"\\u003EAdChoices\\u003Ci class=\\\"img-sprite\\\"\\u003E\\u003C/i\\u003E\\u003C/a\\u003E\\u000a\\u003Ca class=\\\"fz-xxs adv rapid-noclick-resp\\\" href=\\\"http://ad.yieldmanager.com/clk?3,eJytjckKg0AQRH.Ig9Oj4jDkMG5BcYkwiehN4xK3kINhMF-fuOAX5EEX1XQ1hTAloIBSIqghx1AVGkW4vpNKIznIkkwpxaoGCIMusYWLPsXC6pw-Ndbdw5wLttH8xmjMPbeobanRm8Xb2S2Mkf0Fk3jM3b279jaWzsrXc5y5bhyxc.wJu1ufjvHsJ1c14mwKuDMELXqEEAg.ycasG9ogsVHYpRCK4.MkSfIXc2hPCQ==,http%3A%2F%2Fclk.atdmt.com%2FINV%2Fgo%2F451647339%2Fdirect%2F01%2F\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EFisher Investments\\u003C/span\\u003E\\u003C/a\\u003E\\u003Ca href=\\\"http://help.yahoo.com/kb/index?page=content&y=PROD_FRONT&locale=en_US&id=SLN14553\\\" class=\\\"fz-xxs sp rapid-noclick-resp\\\" target=\\\"_blank\\\"\\u003ESponsored\\u003C/a\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"545a4a5d-31f1-3d2b-b3a1-af6ab035ba08\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:17;pkgt:4;ccode:news;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2F30-000-california-prisoners-refusing-meals-030023796.html\\\" data-wikiids=\\\"WIKIID:California|WIKIID:Solitary_confinement\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000790;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-25px;background-image:url('http://l1.yimg.com/ts/api/res/1.2/cIsjQVUHZJZ7HCJhBG6m2Q--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTU2/http://media.zenfs.com/en_us/News/theatlanticwire/30_000_California_Prisoners_Are_Refusing-b255dfae58903c7ee92b601e81fb15da');\\\" width=\\\"131\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/30-000-california-prisoners-refusing-meals-030023796.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:17;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;tar:news.yahoo.com;ltxt:30,000Ca;ct:1;pkgt:4;r:4100000790;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003E30,000 California Prisoners Are Refusing Meals\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EOver 30,000 California prisoners started refusing meals on Monday morning in what might become the biggest hunger strike in California prison history, according to California&#39;s corrections department.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Atlantic Wire\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/california/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:California\\\" data-ylk=\\\"slk:California;sec:td-strm;cpos:1;itc:0;g:545a4a5d-31f1-3d2b-b3a1-af6ab035ba08;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ECalifornia\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"33a46b90-1741-349c-a64b-0f5fc4dcbfb9\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:18;pkgt:4;ccode:news;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fpoint-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\" data-wikiids=\\\"WIKIID:Bob_McDonnell|WIKIID:Governor_of_Virginia\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/point-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;tar:news.yahoo.com;ltxt:AtWhatPo;ct:1;pkgt:4;r:4100000359;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"background-image:url('http://l2.yimg.com/ts/api/res/1.2/Mb7deq6crVPlKz5J2zGWAQ--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO2ZpPWZpbGw7dz04MjtoPTgyO3B5b2ZmPTA-/http://media.zenfs.com/en_us/News/theatlanticwire/At_What_Point_Did_Virginia-e24a1b834aca29c22a0710616d3eaa81');\\\" width=\\\"82\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/point-did-virginia-governor-bob-mcdonnell-too-far-175215432.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:18;g:33a46b90-1741-349c-a64b-0f5fc4dcbfb9;tar:news.yahoo.com;ltxt:AtWhatPo;ct:1;pkgt:4;r:4100000359;slk:title;itc:0;prov:TheAtlanticWire;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EAt What Point Did Virginia Governor Bob McDonnell Go Too Far?\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EBob McDonnell is still the governor of Virginia, despite a series of revelations from the Washington Post detailing unreported gifts from a contributor to McDonnell and his family. There have been so many gifts, in fact, that we were wondering: how much do people consider too much?\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Atlantic Wire\\u003C/span\\u003E\\u003Cspan class=\\\"time\\\"\\u003E52 mins ago\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content cavideo has-image voh-parent cf\\\" data-uuid=\\\"04cc60e0-a193-3352-8e5c-ff896228e590\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:19;pkgt:4;ccode:news;g:04cc60e0-a193-3352-8e5c-ff896228e590;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fvideo%2Fmajor-setback-defense-george-zimmerman-161228577.html\\\" data-wikiids=\\\"\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001231;slk:title;itc:0;prov:WABC\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-32px;background-image:url('http://l3.yimg.com/ts/api/res/1.2/3aHYmihw4JqFgqXUDpm5bA--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTQx/http://media.zenfs.com/en-US/video/video.wabc.abc.news.com/10a5262f6a2220ce4bf4830c048b3257');\\\" width=\\\"145\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003Cspan class=\\\"icon-overlay\\\"\\u003E\\u003Cspan class=\\\"video-icon d-ib\\\"\\u003E\\u003Ci class=\\\"icon-sprite\\\"\\u003E\\u003C/i\\u003E \\u003Cspan class=\\\"play-now fz-xxs\\\"\\u003EPlay\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/video/major-setback-defense-george-zimmerman-161228577.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:19;g:04cc60e0-a193-3352-8e5c-ff896228e590;tar:news.yahoo.com;ltxt:Majorset;ct:3;pkgt:4;r:4100001231;slk:title;itc:0;prov:WABC\\u2013NY;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EMajor setback for the defense at George Zimmerman trial\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EMarci Gonzalez reports for ABC News from Sanford, Florida\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EWABC \\u2013 NY\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"35246d27-ef1f-3c2f-ac82-50ee6d2511ee\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:20;pkgt:3;ccode:news;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2Fky-church-wants-pastor-gone-wifes-column-083204548.html\\\" data-wikiids=\\\"YCT:001000804|YCT:001000780|WIKIID:Southern_Baptist_Convention\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/ky-church-wants-pastor-gone-wifes-column-083204548.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:20;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;tar:news.yahoo.com;ltxt:Ky.churc;ct:1;pkgt:3;r:4053101068;slk:title;itc:0;prov:AssociatedPress;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EKy. church wants pastor gone after wife&#39;s column\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003ELOUISVILLE, Ky. (AP) \\u2014 A newspaper column lampooning Southern Baptists, calling the group &quot;the crazy old paranoid uncle of evangelical Christians,&quot; is causing quite a stir in a Kentucky city and put a pastor&#39;s job in jeopardy.\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EAssociated Press\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/religion-and-beliefs/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000804\\\" data-ylk=\\\"slk:Religion;sec:td-strm;cpos:1;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EReligion\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/society-and-culture/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000780\\\" data-ylk=\\\"slk:Society;sec:td-strm;cpos:2;itc:0;g:35246d27-ef1f-3c2f-ac82-50ee6d2511ee;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003ESociety\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content has-image voh-parent cf\\\" data-uuid=\\\"c20cc012-29f6-3120-a12f-ef78c41a0a22\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:21;pkgt:4;ccode:news;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ed:0;\\\" data-url=\\\"http%3A%2F%2Fnews.yahoo.com%2F3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\" data-wikiids=\\\"YCT:001000661|YCT:001000681|WIKIID:White_House|WIKIID:Presidency_of_Barack_Obama|WIKIID:Patient_Protection_and_Affordable_Care_Act\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Ca class=\\\"img ov-h thumb-left  \\\" href=\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600901;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" tabindex=\\\"-1\\\"\\u003E\\u003Cimg src=\\\"http://l.yimg.com/os/mit/media/m/base/images/transparent-95031.png\\\" style=\\\"margin-left:-27px;background-image:url('http://l2.yimg.com/ts/api/res/1.2/Rntt.Xg7T8Y5NxTOWahOJg--/YXBwaWQ9eWhvbWVydW47cT04NTtzbT0xO3c9MjUwO2g9MTUx/http://media.zenfs.com/en_us/News/theweek/is-president-obamas-signature-legislative-achievement-turning-into-a-messy-failure.jpg');\\\" width=\\\"136\\\" height=\\\"82\\\" alt=\\\"\\\" title=\\\"\\\" class=\\\"lzbg\\\"\\u003E\\u003C/a\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"/3-years-obamacare-incompetence-tells-us-white-house-074000304.html\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:21;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;tar:news.yahoo.com;ltxt:What3yea;ct:1;pkgt:4;r:4065600901;slk:title;itc:0;prov:TheWeek;sort:1;test:900;intl:us;cat:default;ccode:news;\\\"\\u003EWhat 3 years of ObamaCare incompetence tells us about the White House\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EThe administration is gradually scaling back its signature legislation \\u2014 just as critics have long demanded\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EThe Week\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/politics-and-government/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000661\\\" data-ylk=\\\"slk:Politics;sec:td-strm;cpos:1;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPolitics\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/white-house-2/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:White_House\\\" data-ylk=\\\"slk:White House;sec:td-strm;cpos:2;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EWhite House\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://www.yahoo.com/topic/presidency-of-barack-obama/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Presidency_of_Barack_Obama\\\" data-ylk=\\\"slk:Presidency of Barack Obama;sec:td-strm;cpos:3;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPresidency of Barack Obama\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/patient-protection-and-affordable-care-act/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\" data-ylk=\\\"slk:Patient Protection and Affordable Care Act;sec:td-strm;cpos:4;itc:0;g:c20cc012-29f6-3120-a12f-ef78c41a0a22;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EPatient Protection and Affordable Care Act\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"content voh-parent cf\\\" data-uuid=\\\"41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6\\\" data-ylk=\\\"sec:td-strm;cat:default;bpos:1;cpos:22;pkgt:3;ccode:news;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ed:0;\\\" data-url=\\\"http%3A%2F%2Fabcnews.go.com%2Fblogs%2Fentertainment%2F2013%2F07%2Fryan-reynolds-could-have-been-a-cop%2F\\\" data-wikiids=\\\"YCT:001000031|YCT:001000076\\\" data-reason=\\\"TRENDING\\\"\\u003E\\u003Cdiv class=\\\"wrapper cf\\\"\\u003E\\u003Cdiv class=\\\"body\\\"\\u003E\\u003Cdiv class=\\\"body-wrap\\\"\\u003E\\u003Ch3 class=\\\"fw-b fz-s lh-115\\\"\\u003E\\u003Ca class=\\\"\\\" href=\\\"http://abcnews.go.com/blogs/entertainment/2013/07/ryan-reynolds-could-have-been-a-cop/\\\" data-action-outcome=\\\"navigate\\\" data-ylk=\\\"sec:td-strm;ed:0;bpos:1;pos:1;cpos:22;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;tar:abcnews.go.com;ltxt:HowRyanR;ct:1;pkgt:3;r:4090000432;slk:title;itc:0;prov:ABCNews;sort:1;test:900;intl:us;cat:default;ccode:news;\\\" target=\\\"_blank\\\"\\u003EHow Ryan Reynolds Dodged a Bullet\\u003C/a\\u003E\\u003C/h3\\u003E\\u003Cp class=\\\"summary mt-xxs\\\"\\u003EIn an alternate universe somewhere, Ryan Reynolds is patrolling the streets as a cop, munching on blue M&M\\u2019s and avoiding red carpets at all cost. But this is the real world and Reynolds, 36,\\u00a0is an A-list\\u00a0movie star married to one of the most elegant actresses... \\u00a0 \\u00a0 \\u00a0 \\u00a0\\u003C/p\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"attribution fz-xxs\\\"\\u003E\\u003Cspan class=\\\"source\\\"\\u003EABC News\\u003Cspan class=\\\"d-ib img-sprite off-network-icon\\\"\\u003E\\u003C/span\\u003E\\u003C/span\\u003E\\u003Cul class=\\\"interest-list d-ib voh\\\"\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/arts-and-entertainment/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000031\\\" data-ylk=\\\"slk:Arts & Entertainment;sec:td-strm;cpos:1;itc:0;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EArts & Entertainment\\u003C/a\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"interest-wrap d-ib\\\"\\u003E\\u003Ca href=\\\"http://news.yahoo.com/movies/\\\" class=\\\"interest-filter rapidnofollow\\\" data-filter=\\\"YCT:001000076\\\" data-ylk=\\\"slk:Movies;sec:td-strm;cpos:2;itc:0;g:41b84caa-3b4d-32c7-9ee7-e45c21fc0fb6;ft:3;bpos:1;test:900;intl:us;cat:default;ccode:news;\\\" data-action-outcome=\\\"navigate\\\"\\u003EMovies\\u003C/a\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003Cdiv class=\\\"side-buttons\\\"\\u003E\\u003Cbutton class=\\\"img-sprite close side-button voh rapid-noclick-resp\\\" data-b=\\\"\\\" title=\\\"Remove\\\"\\u003ERemove\\u003C/button\\u003E\\u003C/div\\u003E\\u003C/div\\u003E\\u003C/li\\u003E\\u003Cli class=\\\"next-batch notice loading\\\" data-key=\\\"1\\\" data-ylk=\\\"slk:fetch;ltxt:fetch;pos:0;bpos:2;cpos:23;itc:1;sec:td-strm;test:900;intl:us;cat:default;ccode:news;\\\"  data-action=\\\"click\\\" data-action-outcome=\\\"fetch\\\"\\u003E\\u003Cbutton class=\\\"fz-xs\\\"\\u003ELoad more stories\\u003C/button\\u003E\\u003C/li\\u003E\\u003C/ul\\u003E\\u003Cinput type=\\\"hidden\\\" class=\\\"historystate\\\" data-time=\\\"1373481900.2943\\\"\\u003E    \\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u000a\\u000a--dali-response-split-51ddabac509b3Content-Type: text/plain; charset=utf-8\\u000aRMP-Embed-Location: bottom\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000aYUI.namespace(\\\"presentation\\\");\\u000aYUI.presentation.lazyScriptList = [\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/yui/oop_3.8.1.js&nn/lib/metro/g/yui/event-custom-base_3.8.1.js&nn/lib/metro/g/yui/event-base_3.8.1.js&nn/lib/metro/g/yui/io-base_3.8.1.js&nn/lib/metro/g/yui/json-parse_3.8.1.js&nn/lib/metro/g/yui/json-stringify_3.8.1.js&nn/lib/metro/g/yui/cookie_3.8.1.js&nn/lib/metro/g/yui/jsonp_3.8.1.js&nn/lib/metro/g/yui/dom-core_3.8.1.js&nn/lib/metro/g/yui/dom-base_3.8.1.js&nn/lib/metro/g/yui/dom-style_3.8.1.js&nn/lib/metro/g/yui/selector-native_3.8.1.js&nn/lib/metro/g/yui/selector_3.8.1.js&nn/lib/metro/g/yui/node-core_3.8.1.js&nn/lib/metro/g/yui/node-base_3.8.1.js&nn/lib/metro/g/yui/node-style_3.8.1.js&nn/lib/metro/g/yui/transition_3.8.2.js&nn/lib/metro/g/yui/selector-css2_3.8.1.js&nn/lib/metro/g/yui/selector-css3_3.8.1.js&nn/lib/metro/g/yui/event-custom-complex_3.8.1.js&nn/lib/metro/g/yui/event-synthetic_3.8.1.js&nn/lib/metro/g/yui/event-focus_3.8.1.js&nn/lib/metro/g/yui/event-delegate_3.8.1.js&nn/lib/metro/g/yui/node-event-delegate_3.8.1.js&nn/lib/metro/g/yui/pluginhost-base_3.8.1.js&nn/lib/metro/g/yui/pluginhost-config_3.8.1.js&nn/lib/metro/g/yui/node-pluginhost_3.8.1.js&nn/lib/metro/g/yui/dom-screen_3.8.1.js&nn/lib/metro/g/yui/node-screen_3.8.1.js&nn/lib/metro/g/yui/gallery-storage-lite_3.8.1.js&nn/lib/metro/g/uicontrib/dali/module_platform_1.1.14.js&nn/lib/metro/g/uicontrib/dali/resourcemgr_1.1.14.js&nn/lib/metro/g/uicontrib/dali/dali_transport_1.1.34.js&nn/lib/metro/g/uicontrib/dali/metro_dali_1.0.27.js&nn/lib/metro/g/uicontrib/dali/module_api_1.1.16.js&nn/lib/metro/g/uicontrib/dali/yui_service_0.1.17.js\\\"];\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\"http://l.yimg.com/zz/combo?nn/lib/metro/g/uiplugins/metro_viewtype_0.1.24.js&nn/lib/metro/g/uiplugins/default_viewtype_0.1.61.js&nn/lib/metro/g/uiplugins/edit_viewtype_0.1.40.js&nn/lib/metro/g/uicontrib/ylc_1.8.22.js&nn/lib/metro/g/uiplugins/instrumentation_service_0.1.83.js&nn/lib/metro/g/uiplugins/userinfo_service_0.1.15.js&nn/lib/metro/g/uiplugins/statemgr_service_0.1.20.js&nn/lib/metro/g/uiplugins/metrologger_service_0.1.18.js&nn/lib/metro/g/uiplugins/tooltip_service_0.1.56.js&nn/lib/metro/g/uiplugins/autohide_service_0.1.15.js\\\"]);\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000aYUI.presentation.lazyScriptList = YUI.presentation.lazyScriptList.concat([\\\"http://l.yimg.com/zz/combo?nn/lib/metro2/g/badge/badge_0.1.20.js&nn/lib/metro/g/stream/stream_0.0.456.js&nn/lib/metro/g/uiplugins/storage_service_0.0.1.js&nn/lib/metro/g/uiplugins/login_service_0.0.38.js&nn/lib/metro/g/uiplugins/interests_service_0.1.1.js&nn/lib/metro/g/fstream/fstream_0.0.95.js&nn/lib/metro/g/login/login_0.0.32.js\\\"]);\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000a(function()\\u000a{\\u000a    YMedia.namespace('dali').config = {\\\"props\\\":{\\\"dali\\\":{\\\"crumb\\\":\\\"J6oPeXs35Uh\\\",\\\"yuid\\\":\\\"\\\",\\\"loggedIn\\\":\\\"0\\\",\\\"mLogin\\\":0},\\\"proxyUrl\\\":\\\"\\\\/hjs?_mode=html&_create=1&_action=show&_type=badge&_container=1&_chrome=0&view=default&pInitLevel=lite&m_id=p_30345786&m_mode=multipart&configId=MediaRemoteIncludeExternalConfig&hide=0&mod_units=19&app=gs&content_id=5f01278b-803a-3803-9798-7fc79bab4f7d&juris=US&lang=en-US&pu=news.yahoo.com&region=US&se=4402687&site=news&mod_id=p_30345786&suid=30345786&pagetype=minihome&nolz=1&y_proc_embeds=1&y_map_urn=urn%3Armp%3Alite&_product_version=v2&r_inc=1&c_id=p_30345786_container&_sig=8nhtS_52JeXfdiYY25izjGGXZ2I-\\\"},\\\"data\\\":null,\\\"mods\\\":[{\\\"data\\\":{\\\"maple\\\":{\\\"platform\\\":{},\\\"module\\\":\\\"badge\\\",\\\"instance\\\":\\\"badge\\\",\\\"signature\\\":\\\"he5R2PEbnkHjPiFGhQuSNQ--\\\"},\\\"moduleId\\\":\\\"u_30345786\\\"},\\\"props\\\":{\\\"refHandler\\\":\\\"cfg.maple_dali.handler.refresh\\\",\\\"id\\\":\\\"badge\\\",\\\"ns\\\":\\\"badge\\\",\\\"trusted\\\":true},\\\"state\\\":{},\\\"strs\\\":{\\\"STR.MODULE.ERROR_FALLBACK_TEXT\\\":\\\"Requested module is not available. Please try again.\\\",\\\"STR.EDIT\\\":\\\"Settings\\\",\\\"STR.EDIT.CLOSE\\\":\\\"Close Settings\\\"},\\\"res\\\":{},\\\"mods\\\":[{\\\"data\\\":{\\\"maple\\\":{\\\"platform\\\":{},\\\"module\\\":\\\"u_30345786\\\",\\\"instance\\\":\\\"__mmh_0\\\",\\\"ba\\\":{\\\"_action\\\":\\\"show\\\",\\\"chrome\\\":\\\"1\\\",\\\"_id\\\":\\\"u_30345786\\\"},\\\"signature\\\":\\\"5nh6UiryEE9aP5zSGTFEXg--\\\"},\\\"woeId\\\":12778444,\\\"intl\\\":\\\"us\\\",\\\"socialEnabled\\\":true,\\\"swipeEnabled\\\":false,\\\"fbAcctLinked\\\":false,\\\"clientPagination\\\":true,\\\"dynamicEnabled\\\":true,\\\"removalMenuEnabled\\\":true,\\\"closeEnabled\\\":true,\\\"markAsReadEnabled\\\":true,\\\"tooltipsEnabled\\\":true,\\\"batchPause\\\":0,\\\"interestFiltersEnabled\\\":true,\\\"interestFiltersBroadcast\\\":true,\\\"minArticleCount\\\":6,\\\"broadcastDynamicEnabled\\\":true,\\\"sortBy\\\":0,\\\"shareDrawerEnabled\\\":false,\\\"saveEnabled\\\":false,\\\"scrollBuffer\\\":900,\\\"writeMixerActions\\\":true,\\\"isRmp\\\":true,\\\"interestFiltersNavigate\\\":true,\\\"itemClickBroadcastOnly\\\":true,\\\"itemClickContext\\\":true,\\\"restoreStateExpire\\\":1800000,\\\"restoreStateMethod\\\":\\\"LOCAL_STORAGE\\\",\\\"restoreStateOnCacheMiss\\\":true,\\\"batchSize\\\":20,\\\"locationPickerEnabled\\\":false,\\\"beacon_sec\\\":\\\"app-loc\\\",\\\"beacon_slk\\\":\\\"s-op\\\",\\\"beacon_bucketid\\\":\\\"900\\\",\\\"dynamicCategories\\\":[{\\\"name\\\":\\\"Politics\\\",\\\"id\\\":\\\"YCT:001000661\\\",\\\"points\\\":155.14,\\\"src\\\":\\\"core\\\",\\\"count\\\":56,\\\"occurances\\\":{\\\"1\\\":6,\\\"2\\\":3,\\\"3\\\":3,\\\"4\\\":4,\\\"5\\\":9,\\\"6\\\":6,\\\"7\\\":8,\\\"8\\\":13,\\\"9\\\":4},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\"},{\\\"name\\\":\\\"Society\\\",\\\"id\\\":\\\"YCT:001000780\\\",\\\"points\\\":97.67,\\\"src\\\":\\\"core\\\",\\\"count\\\":34,\\\"occurances\\\":{\\\"1\\\":2,\\\"2\\\":5,\\\"3\\\":4,\\\"4\\\":3,\\\"5\\\":7,\\\"6\\\":3,\\\"7\\\":5,\\\"8\\\":1,\\\"9\\\":4},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\"},{\\\"name\\\":\\\"Crime & Justice\\\",\\\"id\\\":\\\"YCT:001000667\\\",\\\"points\\\":32.78,\\\"src\\\":\\\"core\\\",\\\"count\\\":14,\\\"occurances\\\":{\\\"1\\\":1,\\\"3\\\":1,\\\"4\\\":1,\\\"5\\\":2,\\\"6\\\":3,\\\"7\\\":4,\\\"9\\\":2},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/crime-and-justice\\\\/\\\"},{\\\"name\\\":\\\"Education\\\",\\\"id\\\":\\\"YCT:001000267\\\",\\\"points\\\":29.27,\\\"src\\\":\\\"core\\\",\\\"count\\\":8,\\\"occurances\\\":{\\\"1\\\":1,\\\"2\\\":1,\\\"3\\\":2,\\\"4\\\":1,\\\"5\\\":2,\\\"9\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/education\\\\/\\\"},{\\\"name\\\":\\\"Government\\\",\\\"id\\\":\\\"YCT:001000681\\\",\\\"points\\\":26.87,\\\"src\\\":\\\"core\\\",\\\"count\\\":10,\\\"occurances\\\":{\\\"1\\\":1,\\\"3\\\":1,\\\"4\\\":1,\\\"5\\\":3,\\\"7\\\":1,\\\"8\\\":2,\\\"9\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/government\\\\/\\\"}],\\\"dynamicEntities\\\":[{\\\"name\\\":\\\"Barack Obama\\\",\\\"id\\\":\\\"WIKIID:Barack_Obama\\\",\\\"points\\\":294,\\\"src\\\":\\\"core\\\",\\\"count\\\":294,\\\"occurances\\\":{\\\"1\\\":2},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\",\\\"uuid\\\":\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\"},{\\\"name\\\":\\\"Egypt\\\",\\\"id\\\":\\\"WIKIID:Egypt\\\",\\\"points\\\":186,\\\"src\\\":\\\"core\\\",\\\"count\\\":186,\\\"occurances\\\":{\\\"1\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/egypt\\\\/\\\",\\\"uuid\\\":\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\"},{\\\"name\\\":\\\"United States\\\",\\\"id\\\":\\\"WIKIID:United_States\\\",\\\"points\\\":139,\\\"src\\\":\\\"core\\\",\\\"count\\\":139,\\\"occurances\\\":{\\\"1\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/united-states\\\\/\\\",\\\"uuid\\\":\\\"c200730b-eb18-376d-a3d3-1892197b9f54\\\"},{\\\"name\\\":\\\"White House\\\",\\\"id\\\":\\\"WIKIID:White_House\\\",\\\"points\\\":129,\\\"src\\\":\\\"core\\\",\\\"count\\\":129,\\\"occurances\\\":{\\\"1\\\":2},\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/white-house-2\\\\/\\\",\\\"uuid\\\":\\\"590c8c6f-61a8-3dea-9ba7-8cb83525a33b\\\"},{\\\"name\\\":\\\"Shooting of Trayvon Martin\\\",\\\"id\\\":\\\"WIKIID:Shooting_of_Trayvon_Martin\\\",\\\"points\\\":123,\\\"src\\\":\\\"core\\\",\\\"count\\\":123,\\\"occurances\\\":{\\\"1\\\":1},\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/shooting-of-trayvon-martin\\\\/\\\",\\\"uuid\\\":\\\"a2b156e2-bdc5-3dab-bf3c-241d681ef099\\\"}],\\\"items\\\":[{\\\"u\\\":\\\"2e88e31e-a379-3340-96cb-7c5d904edd46\\\",\\\"i\\\":\\\"4100000349\\\"},{\\\"u\\\":\\\"999a3ee7-37dc-34bd-99a7-51b289bd05a6\\\",\\\"i\\\":\\\"4100001466\\\"},{\\\"u\\\":\\\"6f4ca8cf-c412-35d3-853f-9ee636b92373\\\",\\\"i\\\":\\\"4100000382\\\"},{\\\"u\\\":\\\"523fedde-cc12-38fb-86ca-60629888845c\\\",\\\"i\\\":\\\"4090001194\\\"},{\\\"u\\\":\\\"62787508-255a-3395-82ba-9e62e75cb0f0\\\",\\\"i\\\":\\\"4100000433\\\"},{\\\"u\\\":20637846,\\\"s\\\":\\\"Find Out Which Vehicles Get The Best Gas Mileage. See Our Top 10 Results for Cars, Trucks, and SUVs.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/av\\\\/moneyball\\\\/cleansed\\\\/282855.jpg\\\",\\\"width\\\":82,\\\"height\\\":82,\\\"orientation\\\":\\\"square\\\",\\\"ratio\\\":1}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjVELgjAUhf.QArflmIwepmZYzhJmYm-WOpNZPQiivz418Rf0wTncyz2HCzEjRV5uKTUhuY9OSwZx-bAKYmUIAoMxhk2CIEYU8IkLbaPOSYj7tufd2Vay4z.UKFs5S27yvYtPWbac5cbW.C841pH7y-zPf5VLef55Nb2k9ho7RENYX.WtTo0gic2z5K2QnhZPWIVI9EGSDqKOTZH4MG08naq1uQPA-AJEmk55,http%3A%2F%2Fwww.autobytel.com%2Ftop-10-cars%2Fbest-gas-mileage-cars%2F%3Fid%3D32929\\\",\\\"t\\\":\\\"Top 10 Best Gas Mileage Vehicles\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&YXUrx1B2wp0mtLPzqoY6SBX19zf_d1fuUh2uCCm1dTPwqs0S0Qu8QkmJ5NfR42PdwHTEqGDrCn9.oWfDlfrSrQV9aR0v8aA6sTO7zjH78dGCCdXgpV3wN13TJPUl3oQ1sHEdxry9iqESWj4icW870OMIuXuL3SUZh1.1NKi9flPyGcGsMOxzYKv3fit7oqYNRDlopuckdDxB5euHoLh780LMQ3aSPrQS8XNMD4KT1hMc7yCU5ew2q14XdcvGxWTUUbDICX_LXkAjfWt2Ozo7UyrIhNLCLdT2_V0XFdqBUKaCfItcIby82NI16YcWnR93TfzPET5tz7bKZk0FQbkNGynGlVYwBXBAkE28RIE6SuZriUd88o6PktAaF5RUUIhPCNGUSbkTjPokhmJIMT_wK3zIjoqQeQHZr1cheaT43QHDmtiKe7FNjERd1PiAGCeNriRZpKnkU8T3wc9MkBtKy54pf4Hw67K2bSDteWl6rjnwgp4h84r7e9vqdfFzzz3LsjxHA0NJJ9mpzN8k8nQdHUShQPauRd.xSngLQI.YYXI2DK1_CaostAQJNpXXKLX2NljGEBarONbTUuG9b8V03Pzr5ghWryMb39D.z5j3tWnn6IT.PhZ57JAvueKoabx0UcLob6NnyIf5o2jXgu2T55Kdya1II4.4Kc8lN1oR74WhvpUpm6XA5Bop1dkKs64UNTpcvIpmZeYpYRkoiwKp6A7Ehu4WyeKny4KU3JzbUllALSnPNg6rYxvAq9Xj5.WyHIpH66jJN4OnXZcaTvzVHYu3f64YU8hJZMeqLc5VwkjSL4N7fQcjeCN86RtVAzKU7A--&ap=29\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Autobytel\\\"},{\\\"u\\\":\\\"8682b543-884b-33da-a257-f0d05e1a3dfa\\\",\\\"i\\\":\\\"4089900406\\\"},{\\\"u\\\":\\\"1733412d-c645-3dcc-898f-a3e6b23632c3\\\",\\\"i\\\":\\\"4090000563\\\"},{\\\"u\\\":\\\"8cc97ab2-66d0-3bbb-8b6f-c20ba8d932c4\\\",\\\"i\\\":\\\"4053100614\\\"},{\\\"u\\\":\\\"fa2d95f2-4e85-3cfa-aee0-d5b0c031529f\\\",\\\"i\\\":\\\"4100000730\\\"},{\\\"u\\\":\\\"d344ace7-22fe-3cab-b829-5c23eb17e754\\\",\\\"i\\\":\\\"4090001080\\\"},{\\\"u\\\":\\\"b1f76e13-0b85-3d35-ab05-1b263f119f5a\\\",\\\"i\\\":\\\"4100000881\\\"},{\\\"u\\\":\\\"1099eb81-1582-311e-b36e-9a15c7f141e0\\\",\\\"i\\\":\\\"4053100517\\\"},{\\\"u\\\":\\\"0827042a-7b69-3744-876a-e63bbaf67e6d\\\",\\\"i\\\":\\\"4100000368\\\"},{\\\"u\\\":\\\"61d9ae23-9b3a-343a-9309-6e2f3cf1dc01\\\",\\\"i\\\":\\\"4100000292\\\"},{\\\"u\\\":\\\"6e2cca72-5335-3ef9-8ebb-e93683d1ee71\\\",\\\"i\\\":\\\"4100000273\\\"},{\\\"u\\\":\\\"e8fcb3d3-00f3-3804-b31c-d387f5b7c8e2\\\",\\\"i\\\":\\\"4047800515\\\"},{\\\"u\\\":\\\"cfa94c8c-28be-3510-b57a-00b7c3588ab9\\\",\\\"i\\\":\\\"4100000252\\\"},{\\\"u\\\":20626440,\\\"s\\\":\\\"Netflix members can watch as much as they want, anytime, anywhere, on nearly any Internet-connected screen. Only $7.99\\\\/mo. Sign up today.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l1.yimg.com\\\\/av\\\\/moneyball\\\\/curated\\\\/202834-1366845045.jpg\\\",\\\"width\\\":82,\\\"height\\\":82,\\\"orientation\\\":\\\"square\\\",\\\"ratio\\\":1}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjV8LgjAUxb-QD25TmYwetlZiOUuYhL6Z.7LUhCRpnz418RP0g3O4l3sOFyBi5VlhYGwC6zo6LghARWrnlp1AoOmEEGRaECCINTpxxn0wUPfNn2zeHcOXA.1RjmLldslNvuPomCTLuX11Nf0LW.tA3WV2578lxzTr2uYjMVtjTqD8ezQIlRreJTRPkvZC7mtRgZsPhfIkqyIYKp8.hriJVByszY2m6V.IrU-S,https%3A%2F%2Fsignup.netflix.com%2F%3Fmqso%3D81003558\\\",\\\"t\\\":\\\"Netflix Revolutionizes Movie and TV Watching\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&H_GrtUV2wp01Xake4rDZW0wnjkO9HDq9Hft_18s7_GQKOnACr9NTDkbmZcd.8xn27Yr78xtgxagH29RFPQHiT9A7nMsgkF4SrsuJqpF6KxW7.eQWongoNyNgHLeDjw4vSRYZrlUBbqUGCm.iOPMlvy9y_3xojQZqIGXt6Jg.ybv7ZLSp1_JPMeIfLHc5iM8r0_7ZJUd7fqcnRg_prZMHiKHR.jwshqf_VjsU2j1TIFMtXUTvnzYcOpDO7MW_xCKAZMy68GqTnEs6J.vHvhrmpCmqfGXWrTD3iBge8YiE1S8g852XJtEPojc1DerY7e2yE.l0E7FSHReDqaNNpvOwMcy7vo1FunkrG59tz4lj3AjHPadJKP32Lco_RUF6Xb..zZ3tHIkuFtD4YjMZnzeV0MQv1YzjZ5ZAl5tkvwMVt7An6YesaTeoTlzTDnFZ.ADi2.nBReH5UtEBqz.OznBlsij3VxguNsYLTFU40slVd14X9zP.M5YX_h3JE2OFuDlZcPA_hjDoThdSiZbY2bG0HP8a2d2JWNEwSkVE0gb7nlvFM5D6..pRnnliLUFuL5D9ppUOCS0UIqBPnuWgycSy3VmudQdtTZDmRKCwZDmD21IueaDDx_hb_yO_C4K9w6UTZZUZzT.ZzxQlBK_.fFsLOsWlWO3qZMtoydin4q7xcHimY61og12NomS5o2cCUvkLoZSWeYDMARou0oC9R_HlO3VYG4nN0ifgNXY.teQC6nbHjLBTw__xD_n2W.6uFZAe5PRB38HD6qumfhVfv6sjRn0GKNA_8CfhTSJVziFjUslwHQfCYfUaDNs.SZAH90eAJg--&ap=42\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Netflix\\\"},{\\\"u\\\":\\\"db5de020-1c28-3992-8b33-7759daa5e05e\\\",\\\"i\\\":\\\"4100000928\\\"},{\\\"u\\\":\\\"5c9e6d6a-5127-3f87-b77f-6580cd62dfe4\\\",\\\"i\\\":\\\"4100000932\\\"},{\\\"u\\\":\\\"acfa2983-d731-3cbc-a0fc-2ff8ef78e075\\\",\\\"i\\\":\\\"4100001366\\\"},{\\\"u\\\":\\\"e4d5a136-97d8-3124-8ac6-7c020235428f\\\",\\\"i\\\":\\\"4100000273\\\"},{\\\"u\\\":\\\"24e6df26-628f-3a4c-9b98-b22275506fb9\\\",\\\"i\\\":\\\"4081001304\\\"},{\\\"u\\\":\\\"b4fd501c-2f37-3258-ae09-c23c728290ba\\\",\\\"i\\\":\\\"4065600940\\\"},{\\\"u\\\":\\\"0af9f27d-adfd-3b40-bdd2-8ff1b8643742\\\",\\\"i\\\":\\\"4043000697\\\"},{\\\"u\\\":\\\"b1151a83-318e-34e2-a2c8-0fe169c1f900\\\",\\\"i\\\":\\\"4090000233\\\"},{\\\"u\\\":\\\"bfab8f88-77cf-3ace-b86a-80a4f5d25e89\\\",\\\"i\\\":\\\"4100000483\\\"},{\\\"u\\\":\\\"ed5c998c-1e32-3302-9d47-7f3957a1fc2f\\\",\\\"i\\\":\\\"4038700567\\\"},{\\\"u\\\":\\\"73beeae0-a4b3-384b-bf19-be60c1176c1b\\\",\\\"i\\\":\\\"4065600289\\\"},{\\\"u\\\":\\\"5287b89f-b0f0-3dab-9197-aa22905eaf4b\\\",\\\"i\\\":\\\"4100000187\\\"},{\\\"u\\\":21713975,\\\"s\\\":\\\"Find out how this unexpected joint solution is helping Americans live happier, healthier lives after 50!\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l5.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/216216-1372864886-2128.jpg\\\",\\\"width\\\":82,\\\"height\\\":61,\\\"orientation\\\":\\\"landscape\\\",\\\"ratio\\\":1.344262295082}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjc0OgjAQhF-oB9ry06bxUH5ElBZJQAI3QgUxYEjEKD69AYlP4HfYmc3OZiBmRMdVrWrdJJZhUaoYxHVFzyYtEQIaYwwbJoIYEcBnjmSMnxyfvLu97Lv8kTb8y6x246y5eXouPpTlepZQDfwvOHTPg9UHS2.jEq6GWz8lxP7F.Pgtr.lL9ukUZqkRJXwUybYTLbxIJLQwK1qReTDyZSeTopXN73MDgPYBg-hOpw==,http%3A%2F%2Fwww.instaflex.com%2Freport%2Farticles.php%3Ft202id%3D512118%26t202kw%3Dysa_i_7\\\",\\\"t\\\":\\\"8 Simple Joint Ingredients You Won't Believe\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&ecK0Z552wp1CR9ucwuN9cJWH69Az.jMaEgh3CbTj0mKfA8.rh3WakEXcY5PfEj0lY0y3LUkCsSNz6c_t1sHSAKOb29yRFyNqTLfU3SUTNbQBQu0d87VGzVCE5uF5yA68dAHqPB2wnZmtGS5HgkBMaWq7GGkung.Fy.QaynZeOMJD2a0JLw8VAHokuVGgbR27cZI08RcvsDQUtzOVM0Q1xYAKyAGAdZJassqSq3Rrm07JNLwsHrwHDm.p0XkmjJOdzjhHpip8OU9zjaswukv6g_allIZuOBY.f6hTrgRDZNYjW6OXJPVInt2GxxZ15tE.jVF0Fw8ipQMgGkovqKnW2Qn9W.u_v6jfqwIpAIXwNYmeooflkXbiNn9WsTi0ba4Vpuc4.aoNx53jOjdAHXUKNgnxgUNWnDGWYKZ.H0_uSp7rhrKJfagCM.CPRL1sJbC2oL3kOjnzlwg0Hv21fYu4ttHK7sJI17e4nJeCoAjRPhmJ8a7U5zZ42PwEIxdJ_U7sLGCJBuoP2.s.pBsDOPpvzsHKZ5CTJaxtsFreN5b5QEUU7OlsKZ636zCz7smWU7AnmNeMQFG6w3InYqHF5NSNQtro7fZQXU9ygVpfM.xgR6fEdBIZJuq0RqMSR6eoF6v6Ob6i4h9Afx4zUje84fuAboMMJZrI8NNNeyTqFjVy5mIcfY16Vy9wpRnc9uxir4B_4qg_EUhIrUoO9Ecm5Fpvw3LOD02iFh7D11duypcfbysZGWC_7XLDX4CrTqcTDNQ7RsylfEgAWZvbPmP_afrexsbkNCCL7eK5PIBHBnPEonIyHVIj2_p90hKEpZkN3QIyGw--&ap=55\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Instaflex\\\"},{\\\"u\\\":\\\"f87eaebd-5628-3ec6-b863-c404b0abcee4\\\",\\\"i\\\":\\\"4100001059\\\"},{\\\"u\\\":\\\"d712ff7a-7042-30b9-8867-19b51ecb96d2\\\",\\\"i\\\":\\\"4065600236\\\"},{\\\"u\\\":\\\"43b802f5-0558-39cc-9b76-348e3d40edc4\\\",\\\"i\\\":\\\"4100000174\\\"},{\\\"u\\\":\\\"c7c72404-4eb8-3ea3-86b5-2657571ab856\\\",\\\"i\\\":\\\"4100000427\\\"},{\\\"u\\\":\\\"4519c9a6-1a8f-3d9f-bcd3-dc88fec5bc77\\\",\\\"i\\\":\\\"4100001187\\\"},{\\\"u\\\":\\\"37b64b20-2ba3-31e1-9e02-418af076fcf5\\\",\\\"i\\\":\\\"4090000298\\\"},{\\\"u\\\":\\\"42fb1b39-704f-3677-9910-7a2681fc7182\\\",\\\"i\\\":\\\"4100000148\\\"},{\\\"u\\\":\\\"586a9615-991d-3faf-9c7d-e7ff8179d511\\\",\\\"i\\\":\\\"4100000368\\\"},{\\\"u\\\":\\\"1725fbc9-413b-3fff-a0c5-60ec4702f7c2\\\",\\\"i\\\":\\\"4100000553\\\"},{\\\"u\\\":\\\"51aceae4-c48c-3955-bc3d-deabf73b0d4c\\\",\\\"i\\\":\\\"4100001042\\\"},{\\\"u\\\":\\\"0d92f3cd-9815-312a-abc3-79c0fa565d00\\\",\\\"i\\\":\\\"4089900263\\\"},{\\\"u\\\":\\\"c2ecaa77-69b8-38ea-9a81-866f52ad3b10\\\",\\\"i\\\":\\\"4072900590\\\"},{\\\"u\\\":20950156,\\\"s\\\":\\\"Local auto dealers have begun cutting their prices for the summer.  If you're looking for a new car this season, buy now and save as much as ...\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l2.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/206635-1369234902-9746.jpg\\\",\\\"width\\\":82,\\\"height\\\":80,\\\"orientation\\\":\\\"landscape\\\",\\\"ratio\\\":1.025}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjt0KgkAQhV9oL9w.3WXpYlMrw90SVkTvQlOLjAjJ7OlLW3qCPjjDOcwMMxALRnBZVzVxmUc9zisBcV3yo8sPCAFHCIGpiyBGDMiJPeuTwVf3gC3nvGm5GeSX5qNl49u5qYYBeTwL2x8c2sm.4POtjKyP5rtNwGR1u3ajsX9NrJOXPudjbhSJs5TujOyVWV3UCbYaKRhnRaeMbnUQjtqko05-mwsAnDemLk7K,http%3A%2F%2Fpixel.autoaffiliatenetwork.com%2Fd%2F%3Fid%3D009%26adtargeting%3Dimage_Chrysler300_text_Summer2013%26dest%3DAPF\\\",\\\"t\\\":\\\"Auto Dealers Cut Prices for Summer 2013\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&HZAOtg52wp2mLei3m1uAVwfuueZ2Sf7pQzA41g3fGSUnGKb7Oa2Clrrx.AZQ.wLbq5rGVbDhFQKVLTatBKM3qSrLhn5PX3S4k0QiUs36M40F1hFG55fy08t6NRxPatBALoQho.NI5BPHB1.pHZ6QycyfbQd5Juy0B.CTvIWP3XeNsVg0WxIVEj06ovFvFOfOSEIzdJEgObpMrQsQPRulPUrFsn8SidGM4jaeYvlGdJ5ycpHed0jeFvJcdECwVIlMcrQRNXeTkGhge8LsYmqhQiQa4U7uFFDgNcrAerua1eREjxKKAoD_.0niVaXVyKrjxouCRqHX1zXNmaLv.e_oRz7DS00yUdhaH.nZt0saFrBgKmGSdtGItxnCyDpZ_6LRvGJ3MHpnV7Xng1dXhBUVQ_SQLYe2dcEEqRWeWQIOi3HCrhSySo4lzpOOtnITWQEVkeRgbwNYeb4Bl43wnSKXnMX0AMppyIPkmAnjzfi2PypfqmF__JVxj_I1CWDwPySaXS_zJdbhT4plSrrW3hA4MA0h4Tkx1fFtFnlSifBIiV6eESruix.D2ge3XkVRdzq_34vh22wQ6xQ2qzvQhHJNJGuNFeJm5C5Zmmg7N7AO2OusU5gfdfrg1m.GoTH_WRPsSeXp7UwavSXCP8ZzP99cAP_oD_b9bze1DRtFGUYMMFCWhrClBptEFrzXGsZSKUmbTie_AttNW2BTl1S0ZNag8aPAW93FDYd5qzcvSJxQQeDpnPBIvoKv3Uvuf9Ed6KjW9vQIP6dFVIV4agn7e6wwoh2yokDspVKot5s8svNYTP7vF824nuEF3az1..DzWN_tGw--&ap=68\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Auto-Price-Finder.com\\\"},{\\\"u\\\":\\\"79d8986e-05fc-3cc3-89a2-85f7c4e1af91\\\",\\\"i\\\":\\\"4100000130\\\"},{\\\"u\\\":\\\"9cf878bf-6b71-312f-aae4-95d81bab2441\\\",\\\"i\\\":\\\"4100001024\\\"},{\\\"u\\\":\\\"1be2994f-2025-3f60-a257-3e7a48049747\\\",\\\"i\\\":\\\"4081000572\\\"},{\\\"u\\\":\\\"07917df6-6478-34eb-ae87-785b8219824f\\\",\\\"i\\\":\\\"4100000139\\\"},{\\\"u\\\":\\\"de1a9017-c4fa-375a-ba6c-f3ffea663e3d\\\",\\\"i\\\":\\\"4072900198\\\"},{\\\"u\\\":\\\"fccf2bde-bbc9-3aef-880e-ce36cae7f85a\\\",\\\"i\\\":\\\"4100001025\\\"},{\\\"u\\\":\\\"fcb60a92-a1a0-35d5-abcf-08f9f9117095\\\",\\\"i\\\":\\\"4018500661\\\"},{\\\"u\\\":\\\"7c28287a-cd26-3ecf-a193-d1775345c1b9\\\",\\\"i\\\":\\\"4080900424\\\"},{\\\"u\\\":\\\"a39d803c-107e-3210-91b9-404f0f9f688c\\\",\\\"i\\\":\\\"4065600702\\\"},{\\\"u\\\":\\\"9bf503a7-4f45-3294-9446-d57ed3fa0f76\\\",\\\"i\\\":\\\"4034800382\\\"},{\\\"u\\\":\\\"b4302a7d-ee75-3d80-855f-de2dee077577\\\",\\\"i\\\":\\\"4072900369\\\"},{\\\"u\\\":\\\"47b95c91-2def-3d3c-9b80-9fd816c94043\\\",\\\"i\\\":\\\"4100001213\\\"},{\\\"u\\\":20802476,\\\"s\\\":\\\"A recently published study shows no long-term benefit from traditional glucosamine joint supplements. See the study results to learn more.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/av\\\\/moneyball\\\\/ads\\\\/0-1368480943-1495.jpg\\\",\\\"width\\\":50,\\\"height\\\":75,\\\"orientation\\\":\\\"portrait\\\",\\\"ratio\\\":0.66666666666667}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjd8KgjAYxV.IC7e5MRldTC1RnLaYSN75JzUtCbIin740qRfoB-fjHL4DByBmVACjMocwNwjNSsIAqgrzQMwMIk1njCFMIECQanxiSwf5sK.ZqFtz9uU95gv1W1ZtL73prh0c3bj8vOWu6flfsE2fe4v35t3aoby89Oenota35soxbPdj6oZNkMQ4UnwQanMSR9CEUMBAFUjAtBNth6MkRuI3sNI0.QW5Wk5w,http%3A%2F%2Fwww.naturaljoint.org\\\",\\\"t\\\":\\\"Studies Show No Long-Term Benefit From Glucosamine\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&vyQeMJp2wp1TqMGS9HGgzM2gyC2iQTdNXyAobMbwzpZ1cqM3anOKsBNh3xmOca9DzPnAObH0NzsEcFTi6j6sp.qSUnyRS.HFExV7X0xa_VUqmVqwUqaq0YnkyFJzNIL6GQ04yLGzI1MEloEpdK7yKQgsGXoap6fcA_DsiEyAeYyKvtjXZXQoGhJBv1ym.dWSuy1aj.xFohSScuXXZXwIhGYLQzr61C1zbW8WmrTQM68Dc7jxOSmvbwNd3qcvZq5SXaSYyI1Cm25k.BwwuizeATIQB.Q26qML1.THT3mT3NfnFXUUAOkc6eYTxkhCAjpZkocPR4sw_zj9W1.WUifx5RZKo4tKHGZXfmq6cch.tfXVBuG69JsBEBFC9tPpjGA4UojAyt.4jfDUBmhl2_xBbylBqyD7ElNNy9P4wDFnnvej.5jLYmScVmxjcr52.NRwOB56LfSTTmA1wvLmt1nYnJNRyTxd.MBVXVkZFjgzSx2B6DxvIEQ.mOIALnnFAw4BEa5ZLtj5aOzTcA1A9EhifA49lTxlsX5LPjzVP1F9.KWPFnJlg7KK3lkjcVp0nW_eLtF1DSoLzew2CtKxC4pY0N6N1VSm76wgm3V94ALFVoqzsCaWnYv5kXCIt.ZL9Nv0b9obXoPwF4VOU.XoqECWrUjoizNYm2DY_KatB2AvINE5wduA9m05OemaTHnSnVDM2Zo8Q40e2tYFknLlQWz4wdtHDPiSnAq2mx4meIuza49c48KL1Jd9zmNFPYZBcr3Ysjl7KUXYQBi8MqG9NpTnRSihgN7tz.SuyvRDzasYQO64s_kv4p1OU2HPhNwNp6dsHg--&ap=81\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Greek Island Labs\\\"},{\\\"u\\\":\\\"4ed583ae-67ff-3853-aaf1-86901581ce2d\\\",\\\"i\\\":\\\"4059000198\\\"},{\\\"u\\\":\\\"dacd78e7-9feb-3a5b-93da-4671482229b2\\\",\\\"i\\\":\\\"4038700258\\\"},{\\\"u\\\":\\\"8f518ad0-4b6e-34f0-97b0-81fcf08ebaea\\\",\\\"i\\\":\\\"4053100205\\\"},{\\\"u\\\":\\\"4832980c-2037-3392-b43e-846739d2a79e\\\",\\\"i\\\":\\\"4100001064\\\"},{\\\"u\\\":\\\"3a34e541-0403-3e59-b0d0-f0fb28666525\\\",\\\"i\\\":\\\"4022800412\\\"},{\\\"u\\\":\\\"b4bebef1-c728-3d5b-9f21-cee351d0c35a\\\",\\\"i\\\":\\\"4034800420\\\"},{\\\"u\\\":\\\"e771ab9e-bef4-36f0-a1f6-745e13c58aa4\\\",\\\"i\\\":\\\"4053100169\\\"},{\\\"u\\\":\\\"e4bb5d47-7633-3c34-83d5-0612bbb1da97\\\",\\\"i\\\":\\\"4031300338\\\"},{\\\"u\\\":\\\"365f8ec3-3449-3292-bedd-b8525ea07a98\\\",\\\"i\\\":\\\"4053100420\\\"},{\\\"u\\\":\\\"ade7515b-f561-356b-810d-457e63632c09\\\",\\\"i\\\":\\\"4100000960\\\"},{\\\"u\\\":\\\"81e651ea-58d5-34ac-8d57-fb424d7b24a0\\\",\\\"i\\\":\\\"4022800309\\\"},{\\\"u\\\":\\\"87c2b200-aa22-3ecf-99d6-72a7c6012b2d\\\",\\\"i\\\":\\\"4028200219\\\"},{\\\"u\\\":21068314,\\\"s\\\":\\\"Brain games are clinically proven to improve memory, attention and IQ. Harness your brain's neuroplasticity and train your way to a brighter life.\\\",\\\"im\\\":{\\\"original\\\":{\\\"url\\\":\\\"http:\\\\/\\\\/l3.yimg.com\\\\/av\\\\/moneyball\\\\/curated\\\\/171155-1366394442.jpg\\\",\\\"width\\\":82,\\\"height\\\":82,\\\"orientation\\\":\\\"square\\\",\\\"ratio\\\":1}},\\\"ur\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/clk?3,eJytjcsOgjAQRX-oC9pCU9K4KA8NClWSIsFdkZePIgsiwa83IOELPIu5dzJ3ciFmZgUtXOQI5SahqiAM4upql8RWCAODMYYtgiBGFPCJE-3jgavy4TvzHr7eSc1.TOrU7pKbpu.hg1LLuYVNx.-Ca-95sPhg7q09youu1aOkzhrbxR9xz2AkkzFME-soeR.J7TO6wUagCIep0JkUWuhgEOm5ucTr5wYA4wvnbU8y,https%3A%2F%2Fwww.lumosity.com%2Flanding%3Frefer%3D4650\\\",\\\"t\\\":\\\"Scientific Brain Teasers\\\",\\\"b\\\":\\\"http:\\\\/\\\\/ad.yieldmanager.com\\\\/csc?ve=2&Qx70NEd2wp2ZoPPJFdVWlOwvYaKIhuuuNzks6FYjpLHr0eDHXuoBr_wwBqFSFvIhCzuzzs15xG76JDw7FQHLUroh.L6bKEP3dXmjsgEsy1jKRzqdSR3CP7Q9QE335dSrT1uU0bMjIFEXihdJKDV0PUA2tW6gE4jkS4CyfFuVSG8rapiobMXGxTgwQMweYjWetCWPUIAz_qF2oQ50VM.YhUqXsG2qSLiKVe8mOgej6d5j1xBbBXTxjA7i0hdJHL9wOmXAnLFc5gfoDkYwMHkdD6hnmxcTULDYkqCjmA_kxYXc_B0B1I35.mKGKdK0DtIk..LH3VJm5gps97UygZYQ3lF_nIEgr1PBG0HvlQ8Yw4XZrMervZt6_xdtryXKn9qiH.NEz6_TFYCF0jwwnEDG3Lihjo2R.RJ5uKWnm_iINGqk7NT0FBGZioEkIYmR9XRoElzke2v01TFH1cCBPq1sQOfN7FOr.XGN1TyQ8RAPKmQ3K9Vnqgh.5T8MOGxe0L4xrs_kfYb4j96PF9CBKOPwMF8O6yi_MhD226m21Bk3v2Ba0kOqdvZtmtpsD13WX4Bn6QdBJbI4KoWbblreD42yhcLz6Z4OmqytL.kf4d1mDFzXvpqxzxBQL0VGjalP32E6gX6pDYGG2TQqwAjhbuuX8DHAl4nSDzWwdQzrl4ocYZ0i5GEd5Yte6YyBu3WGI72XjtkLl.MTU.q3NvWqqtSw3yE_sv2_DfwBSN3g_PTJqWr8GHxElBXNzyMzuKwEICQFtNFdPgn.pTFuXVhQB1_Q3DLKSpmX.nFY3NjgTSoObGZhrg4y7N1zIZGKp9yIlZSAWA--&ap=94\\\",\\\"ia\\\":1,\\\"at\\\":\\\"Lumosity\\\"},{\\\"u\\\":\\\"840f9c6d-87ba-3b2d-aa1a-3c3c4b7a5a4c\\\",\\\"i\\\":\\\"4022800271\\\"},{\\\"u\\\":\\\"7ac0b3f5-9a41-3595-85e7-b394b8f49b28\\\",\\\"i\\\":\\\"4028200208\\\"},{\\\"u\\\":\\\"036f4818-5282-3896-a7c0-e03a87689ca5\\\",\\\"i\\\":\\\"4016600298\\\"},{\\\"u\\\":\\\"77d99ad3-23b2-31a4-9d15-beda9147cf9e\\\",\\\"i\\\":\\\"4090001038\\\"},{\\\"u\\\":\\\"d443a8ca-9d9d-3adf-aaaf-00d01aee0747\\\",\\\"i\\\":\\\"4025400497\\\"},{\\\"u\\\":\\\"6721eeda-5e99-3b9e-85b2-ad4f1a29ffa3\\\",\\\"i\\\":\\\"4010000414\\\"},{\\\"u\\\":\\\"8ffe28b2-6ff5-3f89-87b3-73f90aab3ce0\\\",\\\"i\\\":\\\"4020500221\\\"},{\\\"u\\\":\\\"5405616f-5db9-3cf0-b76d-6c0ae86b8d0e\\\",\\\"i\\\":\\\"4013500777\\\"},{\\\"u\\\":\\\"e8f5bb9e-a7fa-3ddc-a3ed-5984194e14d1\\\",\\\"i\\\":\\\"4018500418\\\"},{\\\"u\\\":\\\"0224f7db-6b78-37eb-bb13-96c734c79645\\\",\\\"i\\\":\\\"4100001084\\\"},{\\\"u\\\":\\\"64a0f5e9-826f-30c1-b87a-cdd14e8f044b\\\",\\\"i\\\":\\\"4020500216\\\"},{\\\"u\\\":\\\"716a86c2-e772-3b80-ba2f-37ed8ecda763\\\",\\\"i\\\":\\\"4012100274\\\"},{\\\"u\\\":\\\"3b06a203-610c-3a58-8024-a51b661e896b\\\",\\\"i\\\":\\\"4100001004\\\"},{\\\"u\\\":\\\"4398511d-e0b9-3bcc-b8d7-8c927257da97\\\",\\\"i\\\":\\\"4018500168\\\"},{\\\"u\\\":\\\"fab07708-6eec-331c-a049-53f865291f9b\\\",\\\"i\\\":\\\"4012100260\\\"},{\\\"u\\\":\\\"55836cbc-0d5c-3fbe-b9bf-13bdbb891e66\\\",\\\"i\\\":\\\"4005302076\\\"},{\\\"u\\\":\\\"34c6686d-577e-34a0-bb2b-887d9b40d3f5\\\",\\\"i\\\":\\\"4010000353\\\"},{\\\"u\\\":\\\"45888b8f-3460-3aa1-9a52-2dfe51afff60\\\",\\\"i\\\":\\\"4100000940\\\"},{\\\"u\\\":\\\"e8528082-d943-35fc-af50-14e4c1f8180e\\\",\\\"i\\\":\\\"4013500173\\\"},{\\\"u\\\":\\\"d8c76553-0434-33b6-b68c-a39e35bba1bb\\\",\\\"i\\\":\\\"4012100172\\\"},{\\\"u\\\":\\\"95cbd68e-ffcb-3da5-8dfd-436af201ec90\\\",\\\"i\\\":\\\"4008800347\\\"},{\\\"u\\\":\\\"3a8ef146-eaf8-30f1-ab7f-bab556ede552\\\",\\\"i\\\":\\\"4010000412\\\"},{\\\"u\\\":\\\"733bf5ee-6160-3040-82d5-1d2f42636f8b\\\",\\\"i\\\":\\\"4100000874\\\"},{\\\"u\\\":\\\"90742b99-96f2-38a3-9ad1-f55b2620aaee\\\",\\\"i\\\":\\\"4010000161\\\"},{\\\"u\\\":\\\"2ad2eb07-5b9c-307c-b9ff-bcb3aa6bf5b8\\\",\\\"i\\\":\\\"4009000166\\\"},{\\\"u\\\":\\\"db5e4a50-d8ef-386f-b1e6-e25cdf7f287a\\\",\\\"i\\\":\\\"4009800153\\\"},{\\\"u\\\":\\\"f8528bff-bebc-36e9-9e88-cc513c0787c6\\\",\\\"i\\\":\\\"4100000869\\\"},{\\\"u\\\":\\\"83795d21-e026-38af-b60b-62dc9facb361\\\",\\\"i\\\":\\\"4007100533\\\"},{\\\"u\\\":\\\"43e80a47-79ec-3809-ac98-1518389138c7\\\",\\\"i\\\":\\\"4005900268\\\"},{\\\"u\\\":\\\"5dc7227d-d4a6-352f-8649-0db6aa60341d\\\",\\\"i\\\":\\\"4007100507\\\"},{\\\"u\\\":\\\"c2ab26f4-4d85-34de-9900-e8fb300fc296\\\",\\\"i\\\":\\\"4100000965\\\"},{\\\"u\\\":\\\"f784f21c-dea8-3214-a2bd-4448415496ff\\\",\\\"i\\\":\\\"4005800193\\\"},{\\\"u\\\":\\\"2efae028-b5e0-39a5-980b-7c19ab0f0244\\\",\\\"i\\\":\\\"4007900189\\\"},{\\\"u\\\":\\\"9db1ef8a-a304-3fa9-9e1c-b465e737c544\\\",\\\"i\\\":\\\"4004700714\\\"},{\\\"u\\\":\\\"8a47ca09-04b3-337f-b6ff-583211b66950\\\",\\\"i\\\":\\\"4005200180\\\"},{\\\"u\\\":\\\"0bb3174a-3588-3c95-a547-6c0cb658a1c0\\\",\\\"i\\\":\\\"4007100520\\\"},{\\\"u\\\":\\\"b40c8d61-0cfc-365c-919f-dc77294f18e1\\\",\\\"i\\\":\\\"4004700201\\\"},{\\\"u\\\":\\\"a63cf34e-c218-3e8d-892b-0bbc6156f9d8\\\",\\\"i\\\":\\\"4100001051\\\"},{\\\"u\\\":\\\"929877e0-37bb-39dd-9bee-f9e8bbe00dc9\\\",\\\"i\\\":\\\"4006400154\\\"},{\\\"u\\\":\\\"4153a74c-4462-3ee0-bc00-dff34f2d850f\\\",\\\"i\\\":\\\"4005800351\\\"},{\\\"u\\\":\\\"09c0d581-8f4f-3555-871e-31a0b18a7951\\\",\\\"i\\\":\\\"4100000915\\\"},{\\\"u\\\":\\\"6c039a5e-146d-3da8-812c-fb6d65e19f76\\\",\\\"i\\\":\\\"4004200467\\\"},{\\\"u\\\":\\\"973d19f5-0a84-333c-b992-8eeedd738f43\\\",\\\"i\\\":\\\"4005200127\\\"},{\\\"u\\\":\\\"97231cf5-bb20-3ff0-802b-a452829f1fa8\\\",\\\"i\\\":\\\"4003400209\\\"},{\\\"u\\\":\\\"7e9aea73-f2a9-3a22-bbf3-d6e29ae9fe19\\\",\\\"i\\\":\\\"4003400180\\\"},{\\\"u\\\":\\\"3d28a848-ba81-36fe-9887-29f619d7ccf4\\\",\\\"i\\\":\\\"4001600320\\\"},{\\\"u\\\":\\\"1216abdc-0bc1-3b4c-b978-4c4d848a26bb\\\",\\\"i\\\":\\\"4002500171\\\"},{\\\"u\\\":\\\"9e07f5b8-ae97-3c06-9843-1beaf8ff297e\\\",\\\"i\\\":\\\"4100000934\\\"},{\\\"u\\\":\\\"45860a48-cd9e-3f22-b47b-d286f2110b6a\\\",\\\"i\\\":\\\"4000400828\\\"},{\\\"u\\\":\\\"5ba9c757-db40-3d11-bf39-ae7cc0a41761\\\",\\\"i\\\":\\\"4001400426\\\"},{\\\"u\\\":\\\"f540de91-027a-3001-8280-5af27c52c12c\\\",\\\"i\\\":\\\"4000300505\\\"},{\\\"u\\\":\\\"fe72c946-5768-3657-aaa1-d0c92ed812b4\\\",\\\"i\\\":\\\"4000200523\\\"},{\\\"u\\\":\\\"e2b6485f-3de9-3bba-85da-4ddb382a056f\\\",\\\"i\\\":\\\"4100001019\\\"},{\\\"u\\\":\\\"2f6fa4bf-7163-3097-962e-5dbd610c2c21\\\",\\\"i\\\":\\\"4000200359\\\"},{\\\"u\\\":\\\"24f5c185-57dc-37e7-8698-dd1838bda8a4\\\",\\\"i\\\":\\\"4000200733\\\"},{\\\"u\\\":\\\"db030f8d-4a11-31e4-86e4-cb8f0f8aaf82\\\",\\\"i\\\":\\\"4100000891\\\"},{\\\"u\\\":\\\"7940011d-7d91-3045-a1aa-eeecfdd0450c\\\",\\\"i\\\":\\\"4000100312\\\"},{\\\"u\\\":\\\"1d1e6988-fd19-36ec-a633-a290e04d1bab\\\",\\\"i\\\":\\\"4000100441\\\"},{\\\"u\\\":\\\"3c1b56c7-a888-3532-8f69-823389ab58d7\\\",\\\"i\\\":\\\"4000200152\\\"},{\\\"u\\\":\\\"12577891-fe2e-3bf6-8872-48283cc99542\\\",\\\"i\\\":\\\"4000100230\\\"},{\\\"u\\\":\\\"bd973d04-cffe-3617-bc91-64631e02e263\\\",\\\"i\\\":\\\"4000100304\\\"},{\\\"u\\\":\\\"8ca67350-b65a-3884-b411-df6018ebbf14\\\",\\\"i\\\":\\\"4100000837\\\"},{\\\"u\\\":\\\"e115e1c2-e6e7-34b5-8725-65647725e6f3\\\",\\\"i\\\":\\\"4000000216\\\"},{\\\"u\\\":\\\"3184a818-422d-31fa-b2ca-3fc25f1e8306\\\",\\\"i\\\":\\\"4000000320\\\"},{\\\"u\\\":\\\"9d0d8429-ce92-3d20-96df-8dcdc20a1185\\\",\\\"i\\\":\\\"4000000347\\\"},{\\\"u\\\":\\\"da3fd914-a729-3606-93ce-58d974416a92\\\",\\\"i\\\":\\\"4000000246\\\"},{\\\"u\\\":\\\"2382e5e0-34c2-3019-9bc1-dd64411f42b6\\\",\\\"i\\\":\\\"4100000828\\\"},{\\\"u\\\":\\\"ebe271cf-d612-3d45-8886-03aeb92bb7cd\\\",\\\"i\\\":\\\"4000000362\\\"},{\\\"u\\\":\\\"6ae66b10-fc06-31ad-bdce-f630dab5f4fc\\\",\\\"i\\\":\\\"4000000303\\\"},{\\\"u\\\":\\\"979f41be-1edc-32f5-ac09-17715c88e294\\\",\\\"i\\\":\\\"4000000273\\\"},{\\\"u\\\":\\\"d8ca681e-2bfb-3e08-b33f-0d41e9916217\\\",\\\"i\\\":\\\"4000000292\\\"},{\\\"u\\\":\\\"d9a55b19-9a27-3da5-b16b-c6f245fbc386\\\",\\\"i\\\":\\\"4000000131\\\"},{\\\"u\\\":\\\"9d198649-3883-3f02-a39f-33e7c6ac21f8\\\",\\\"i\\\":\\\"4000000155\\\"},{\\\"u\\\":\\\"933524d2-947f-3f9c-aeae-a5a45b0619b8\\\",\\\"i\\\":\\\"4065601206\\\"},{\\\"u\\\":\\\"4ec09f8e-84c3-3934-b092-39cb092d10a2\\\",\\\"i\\\":\\\"4000000509\\\"},{\\\"u\\\":\\\"fcc8c90a-e9a3-3d4d-b0c6-80066b5a761a\\\",\\\"i\\\":\\\"4100001012\\\"},{\\\"u\\\":\\\"8a1c7605-0ff6-3150-9990-76dae34185d8\\\",\\\"i\\\":\\\"4000002190\\\"},{\\\"u\\\":\\\"0d02e61e-1b5e-3a00-8a69-ebbd5627e76b\\\",\\\"i\\\":\\\"4000000588\\\"},{\\\"u\\\":\\\"c96bd902-72ef-3422-a162-bb80c37028e1\\\",\\\"i\\\":\\\"4000000206\\\"},{\\\"u\\\":\\\"44f44e84-8894-3136-b6fc-efb8b7c77f84\\\",\\\"i\\\":\\\"4000000239\\\"},{\\\"u\\\":\\\"408b827f-4639-3495-bbc5-33698c6a3bc7\\\",\\\"i\\\":\\\"4000000560\\\"},{\\\"u\\\":\\\"2bcd2824-1695-3c99-afeb-5964e993f1f6\\\",\\\"i\\\":\\\"4100000829\\\"},{\\\"u\\\":\\\"bcd13eef-3b76-3eb8-b13e-66e0a2432378\\\",\\\"flbk\\\":true},{\\\"u\\\":\\\"cf8c7775-d027-3207-af8c-86bffe8db6fe\\\",\\\"flbk\\\":true},{\\\"u\\\":\\\"3c63b3a1-1f89-3ac8-bbba-ca7b82d3f780\\\",\\\"flbk\\\":true}],\\\"contentpos\\\":22,\\\"interestsData\\\":{\\\"YCT:001000667\\\":{\\\"name\\\":\\\"Crime & Justice\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/crime-and-justice\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000780\\\":{\\\"name\\\":\\\"Society\\\",\\\"count\\\":164,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/society-and-culture\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Shooting_of_Trayvon_Martin\\\":{\\\"name\\\":\\\"Shooting of Trayvon Martin\\\",\\\"count\\\":123,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/shooting-of-trayvon-martin\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000346\\\":{\\\"name\\\":\\\"Personal Investing Ideas & Strategies\\\",\\\"count\\\":48,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/personal-investing-ideas-and-strategies\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000992\\\":{\\\"name\\\":\\\"Transportation\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/transportation\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000395\\\":{\\\"name\\\":\\\"Health\\\",\\\"count\\\":170,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/health\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000495\\\":{\\\"name\\\":\\\"Family Health\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/family-health\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000661\\\":{\\\"name\\\":\\\"Politics\\\",\\\"count\\\":161,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/politics-and-government\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000680\\\":{\\\"name\\\":\\\"Foreign Policy\\\",\\\"count\\\":38,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/foreign-policy\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Barack_Obama\\\":{\\\"name\\\":\\\"Barack Obama\\\",\\\"count\\\":294,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/barack-obama\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Mohamed_Morsi\\\":{\\\"name\\\":\\\"Mohamed Morsi\\\",\\\"count\\\":90,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/mohamed-morsi\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Egypt\\\":{\\\"name\\\":\\\"Egypt\\\",\\\"count\\\":186,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/egypt\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:United_States\\\":{\\\"name\\\":\\\"United States\\\",\\\"count\\\":139,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/united-states\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Hosni_Mubarak\\\":{\\\"name\\\":\\\"Hosni Mubarak\\\",\\\"count\\\":37,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/hosni-mubarak\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Cairo\\\":{\\\"name\\\":\\\"Cairo\\\",\\\"count\\\":6,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/cairo\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000069\\\":{\\\"name\\\":\\\"Celebrities\\\",\\\"count\\\":86,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/celebrities\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000070\\\":{\\\"name\\\":\\\"Royal Families\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/royal-families-2\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Prince_Harry_of_Wales\\\":{\\\"name\\\":\\\"Prince Harry of Wales\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/prince-harry-of-wales\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Kensington_Palace\\\":{\\\"name\\\":\\\"Kensington Palace\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/kensington-palace\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000700\\\":{\\\"name\\\":\\\"Immigration Issues\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/immigration-issues\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Culture_of_the_United_States\\\":{\\\"name\\\":\\\"Culture of the United States\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/culture-of-the-united-states\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000267\\\":{\\\"name\\\":\\\"Education\\\",\\\"count\\\":45,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/education\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000269\\\":{\\\"name\\\":\\\"Schools\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/schools\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Elementary_school\\\":{\\\"name\\\":\\\"Elementary school\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/elementary-school\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Ink_cartridge\\\":{\\\"name\\\":\\\"Ink cartridge\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/ink-cartridge\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Immigration_reform\\\":{\\\"name\\\":\\\"Immigration reform\\\",\\\"count\\\":32,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/immigration-reform\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000705\\\":{\\\"name\\\":\\\"Military\\\",\\\"count\\\":53,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/military-and-defense\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Unmanned_aerial_vehicle\\\":{\\\"name\\\":\\\"Unmanned aerial vehicle\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/unmanned-aerial-vehicle\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Aircraft_carrier\\\":{\\\"name\\\":\\\"Aircraft carrier\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/aircraft-carrier\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Patuxent_River\\\":{\\\"name\\\":\\\"Patuxent River\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/patuxent-river\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000123\\\":{\\\"name\\\":\\\"Business\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/business\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Panera_Bread\\\":{\\\"name\\\":\\\"Panera Bread\\\",\\\"count\\\":11,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/panera-bread\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:National_Security_Agency\\\":{\\\"name\\\":\\\"National Security Agency\\\",\\\"count\\\":61,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/national-security-agency\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:California\\\":{\\\"name\\\":\\\"California\\\",\\\"count\\\":74,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/california\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Solitary_confinement\\\":{\\\"name\\\":\\\"Solitary confinement\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/solitary-confinement\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Bob_McDonnell\\\":{\\\"name\\\":\\\"Bob McDonnell\\\",\\\"count\\\":3,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/bob-mcdonnell\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Governor_of_Virginia\\\":{\\\"name\\\":\\\"Governor of Virginia\\\",\\\"count\\\":2,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/governor-of-virginia\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000804\\\":{\\\"name\\\":\\\"Religion\\\",\\\"count\\\":30,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/religion-and-beliefs\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Southern_Baptist_Convention\\\":{\\\"name\\\":\\\"Southern Baptist Convention\\\",\\\"count\\\":1,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/southern-baptist-convention\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000681\\\":{\\\"name\\\":\\\"Government\\\",\\\"count\\\":0,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/government\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:White_House\\\":{\\\"name\\\":\\\"White House\\\",\\\"count\\\":129,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/white-house-2\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Presidency_of_Barack_Obama\\\":{\\\"name\\\":\\\"Presidency of Barack Obama\\\",\\\"count\\\":45,\\\"url\\\":\\\"http:\\\\/\\\\/www.yahoo.com\\\\/topic\\\\/presidency-of-barack-obama\\\\/\\\",\\\"declared\\\":1},\\\"WIKIID:Patient_Protection_and_Affordable_Care_Act\\\":{\\\"name\\\":\\\"Patient Protection and Affordable Care Act\\\",\\\"count\\\":32,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/patient-protection-and-affordable-care-act\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000031\\\":{\\\"name\\\":\\\"Arts & Entertainment\\\",\\\"count\\\":170,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/arts-and-entertainment\\\\/\\\",\\\"declared\\\":1},\\\"YCT:001000076\\\":{\\\"name\\\":\\\"Movies\\\",\\\"count\\\":170,\\\"url\\\":\\\"http:\\\\/\\\\/news.yahoo.com\\\\/movies\\\\/\\\",\\\"declared\\\":1}},\\\"ccode\\\":\\\"news\\\"},\\\"props\\\":{\\\"refHandler\\\":\\\"cfg.maple_dali.handler.refresh\\\",\\\"id\\\":\\\"u_30345786\\\",\\\"ns\\\":\\\"type_stream\\\",\\\"trusted\\\":true,\\\"type\\\":\\\"stream\\\",\\\"contentId\\\":\\\"30345786\\\",\\\"tags\\\":[],\\\"title\\\":\\\"Stream\\\",\\\"icon\\\":\\\"\\\",\\\"shortTitle\\\":\\\"Stream\\\",\\\"detailUrl\\\":\\\"\\\",\\\"chromecolor\\\":\\\"blue\\\"},\\\"state\\\":{\\\"view\\\":\\\"default\\\",\\\"defer\\\":false,\\\"collapsed\\\":0},\\\"strs\\\":{\\\"STR.LOADING\\\":\\\"\\u003Cdiv class=\\\\\\\"fp-loader ti\\\\\\\"\\u003ELoad more stories\\u003C\\\\/div\\u003E\\\",\\\"STR.LOADING.CONTENT\\\":\\\"\\u003Cdiv class=\\\\\\\"loading next-batch\\\\\\\" data-key=\\\\\\\"0\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"fp-loader ti\\\\\\\"\\u003ELoad more stories&hellip;\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\\",\\\"STR.BUTTON.REMOVE_DONE\\\":\\\"\\u003Cbutton class=\\\\\\\"fz-xxs remove-done uibutton rapid-noclick-resp\\\\\\\"\\u003EDone\\u003C\\\\/button\\u003E\\\",\\\"STR.REMOVE.CONFIRM\\\":\\\"\\\",\\\"STR.BUTTON.WIKIID\\\":\\\"\\u003Cbutton class=\\\\\\\"fz-xxs wikiid uibutton rapid-noclick-resp {selected}\\\\\\\" data-wikiid=\\\\\\\"{id}\\\\\\\" data-interesttype=\\\\\\\"{type}\\\\\\\"\\u003E{name}\\u003Cspan class=\\\\\\\"d-ib img-sprite remove-neg\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/button\\u003E\\\",\\\"STR.SHOW.LESS\\\":\\\"\\u003Cdiv class=\\\\\\\"show-less fz-xs\\\\\\\"\\u003EShow me fewer stories about:\\u003C\\\\/div\\u003E\\\",\\\"STR.REMOVE.MENU\\\":\\\"\\u003Cdiv class=\\\\\\\"menu\\\\\\\"\\u003E\\u003Cbutton class=\\\\\\\"fz-xs undo rapid-noclick-resp\\\\\\\"\\u003EUndo\\u003C\\\\/button\\u003E\\u003Cp class=\\\\\\\"title fz-xs\\\\\\\"\\u003EStory removed\\u003C\\\\/p\\u003E\\u003Cdiv class=\\\\\\\"remove-menu-main cf\\\\\\\"\\u003E\\u003C\\\\/div\\u003E\\u003Cdiv class=\\\\\\\"login hidden\\\\\\\"\\u003E\\u003Cdiv id=\\\\\\\"default-p_30345826_b27\\\\\\\" class=\\\\\\\"mod view_default\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"default-p_30345826_b27-bd\\\\\\\" class=\\\\\\\"bd type_login type_login_default\\\\\\\"\\u003E\\u003Cdiv class=\\\\\\\"embed\\\\\\\"\\u003E\\u003Ch3 class=\\\\\\\"title mb-l\\\\\\\"\\u003ESign in to save your preferences:\\u003C\\\\/h3\\u003E\\u003Cdiv class=\\\\\\\"btns fz-xs\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"login-svc ylogin login-btn-purple rapid-noclick-resp login-btn-small\\\\\\\" href=\\\\\\\"https:\\\\/\\\\/login.yahoo.com\\\\/config\\\\/login?.src=fpctx&.intl=us\\\\\\\" data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"login\\\\\\\" data-ylk=\\\\\\\"sec:td-strm-rm;slk:login-yh;itc:0;cat:;\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"img-sprite y-icon\\\\\\\"\\u003E\\u003C\\\\/i\\u003EYahoo!\\u003C\\\\/a\\u003E \\u003Cspan class=\\\\\\\"login-or d-ib\\\\\\\"\\u003Eor\\u003C\\\\/span\\u003E \\u003Cspan class=\\\\\\\"fb-button-wrapper d-ib\\\\\\\"\\u003E\\u003Ca class=\\\\\\\"login-svc fblogin login-btn-fbblue rapidnofollow rapid-noclick-resp login-btn-small\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/open.login.yahoo.net\\\\/openid\\\\/yrp\\\\/hr_signin?.intl=us&idp=facebook&ts=1373481900&rpcrumb=opO.PAXz7D8&.src=home&appid=90376669494&spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history\\\\\\\" data-action=\\\\\\\"click\\\\\\\" data-action-outcome=\\\\\\\"login\\\\\\\" data-ylk=\\\\\\\"sec:td-strm-rm;slk:login-fb;cat:;\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\u003E\\u003Ci class=\\\\\\\"img-sprite fb-icon\\\\\\\"\\u003E\\u003C\\\\/i\\u003EFacebook\\u003C\\\\/a\\u003E\\u003Cspan class=\\\\\\\"fb-disclaimer narrow-disclaimer fz-xxs\\\\\\\"\\u003EWe don't post anything without your permission.\\u003C\\\\/span\\u003E\\u003C\\\\/span\\u003E\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\u003C\\\\/div\\u003E\\u003Ca class=\\\\\\\"profile-link d-ib rapid-noclick-resp fz-xs dn\\\\\\\" href=\\\\\\\"http:\\\\/\\\\/profile.yahoo.com\\\\/y\\\\/settings\\\\/interests\\\\/\\\\\\\"\\u003EEdit content preferences\\u003C\\\\/a\\u003E\\u003C\\\\/div\\u003E\\\"},\\\"res\\\":{},\\\"mods\\\":[{\\\"props\\\":{\\\"trusted\\\":true,\\\"id\\\":\\\"p_30345810_fcd\\\",\\\"type\\\":\\\"fstream\\\",\\\"ns\\\":\\\"type_fstream\\\",\\\"contentId\\\":\\\"30345810\\\",\\\"tags\\\":[],\\\"title\\\":\\\"\\\",\\\"icon\\\":\\\"\\\",\\\"shortTitle\\\":\\\"\\\",\\\"detailUrl\\\":\\\"\\\",\\\"chromecolor\\\":\\\"blue\\\"},\\\"data\\\":{\\\"dropdownHover\\\":true,\\\"dynamicMax\\\":0,\\\"filterRestoreEnabled\\\":false,\\\"dropdownFilter\\\":false,\\\"tabFilter\\\":true,\\\"autoHideEnabled\\\":true,\\\"recentFiltersEnabled\\\":false,\\\"saveEnabled\\\":false,\\\"swipeFilterEnabled\\\":false,\\\"filterFontSize\\\":\\\"fz-s\\\"},\\\"strs\\\":{\\\"STR.FILTERS.FILTERBY\\\":\\\"Filter by\\\"},\\\"state\\\":{\\\"view\\\":\\\"default\\\",\\\"defer\\\":false,\\\"collapsed\\\":0},\\\"prefs\\\":{\\\"isc\\\":0,\\\"_mc\\\":0}}]}]}],\\\"res\\\":{\\\"css\\\":{\\\"helpers_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/helpers_0.0.6.css\\\",\\\"typography_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/ui\\\\/typography_0.0.2.css\\\",\\\"theme_default_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/common_0.0.29.css\\\",\\\"theme_default_desktop_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/theme\\\\/default\\\\/desktop_0.0.62.css\\\",\\\"tooltip_service_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_1.0.12.css\\\",\\\"type_stream_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.271.css\\\",\\\"theme_gs_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/theme_gs_0.0.45.css\\\",\\\"login_service_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.3.css\\\",\\\"rmx_ads_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/rmx_ads_0.0.8.css\\\",\\\"type_fstream_desktop_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_desktop_0.0.21.css\\\",\\\"type_login_css\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.71.css\\\"},\\\"js\\\":{\\\"oop\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/oop_3.8.1.js\\\",\\\"event-custom-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-base_3.8.1.js\\\",\\\"event-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-base_3.8.1.js\\\",\\\"io-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/io-base_3.8.1.js\\\",\\\"json-parse\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-parse_3.8.1.js\\\",\\\"json-stringify\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/json-stringify_3.8.1.js\\\",\\\"cookie\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/cookie_3.8.1.js\\\",\\\"jsonp\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/jsonp_3.8.1.js\\\",\\\"dom-core\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-core_3.8.1.js\\\",\\\"dom-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-base_3.8.1.js\\\",\\\"dom-style\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-style_3.8.1.js\\\",\\\"selector-native\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-native_3.8.1.js\\\",\\\"selector\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector_3.8.1.js\\\",\\\"node-core\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-core_3.8.1.js\\\",\\\"node-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-base_3.8.1.js\\\",\\\"node-style\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-style_3.8.1.js\\\",\\\"transition\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/transition_3.8.2.js\\\",\\\"selector-css2\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css2_3.8.1.js\\\",\\\"selector-css3\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/selector-css3_3.8.1.js\\\",\\\"event-custom-complex\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-custom-complex_3.8.1.js\\\",\\\"event-synthetic\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-synthetic_3.8.1.js\\\",\\\"event-focus\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-focus_3.8.1.js\\\",\\\"event-delegate\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/event-delegate_3.8.1.js\\\",\\\"node-event-delegate\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-event-delegate_3.8.1.js\\\",\\\"pluginhost-base\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-base_3.8.1.js\\\",\\\"pluginhost-config\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/pluginhost-config_3.8.1.js\\\",\\\"node-pluginhost\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-pluginhost_3.8.1.js\\\",\\\"dom-screen\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/dom-screen_3.8.1.js\\\",\\\"node-screen\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/node-screen_3.8.1.js\\\",\\\"gallery-storage-lite\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/yui\\\\/gallery-storage-lite_3.8.1.js\\\",\\\"module_platform\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_platform_1.1.14.js\\\",\\\"resourcemgr\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/resourcemgr_1.1.14.js\\\",\\\"transport\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/dali_transport_1.1.34.js\\\",\\\"metro_ext\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/metro_dali_1.0.27.js\\\",\\\"module_api\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/module_api_1.1.16.js\\\",\\\"yui_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/dali\\\\/yui_service_0.1.17.js\\\",\\\"metro_viewtype\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metro_viewtype_0.1.24.js\\\",\\\"default_viewtype\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/default_viewtype_0.1.61.js\\\",\\\"edit_viewtype\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/edit_viewtype_0.1.40.js\\\",\\\"ylc\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uicontrib\\\\/ylc_1.8.22.js\\\",\\\"instrumentation_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/instrumentation_service_0.1.83.js\\\",\\\"userinfo_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/userinfo_service_0.1.15.js\\\",\\\"statemgr_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/statemgr_service_0.1.20.js\\\",\\\"metrologger_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/metrologger_service_0.1.18.js\\\",\\\"tooltip_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/tooltip_service_0.1.56.js\\\",\\\"autohide_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/autohide_service_0.1.15.js\\\",\\\"badge\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro2\\\\/g\\\\/badge\\\\/badge_0.1.20.js\\\",\\\"type_stream\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/stream\\\\/stream_0.0.456.js\\\",\\\"storage_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/storage_service_0.0.1.js\\\",\\\"login_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/login_service_0.0.38.js\\\",\\\"interests_service\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/uiplugins\\\\/interests_service_0.1.1.js\\\",\\\"type_fstream\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/fstream\\\\/fstream_0.0.95.js\\\",\\\"type_login\\\":\\\"http:\\\\/\\\\/l.yimg.com\\\\/nn\\\\/lib\\\\/metro\\\\/g\\\\/login\\\\/login_0.0.32.js\\\"}}};\\u000a}()\\u000a);\\u000a\\u003C/script\\u003E\\u000a\\u000a\\u003Cscript type=\\\"text/javascript\\\"\\u003E\\u000a(function(){\\u000a    YUI.add(\\\"metro_config\\\", function(Y){\\u000a        // until dali defaults this\\u000a\\u000a        Y.mix(Y.dali.config.props, {\\u000a            libRoot: \\\"\\\",\\u000a            user : \\\"\\\",\\u000a            ultSpaceId : \\\"2023538075\\\",\\u000a            ultBeaconHost : \\\"\\\\/p.gif\\\",\\u000a            modChromeHtml : \\\"\\u003Cdiv id=\\\\\\\"error-{type_name}\\\\\\\" class=\\\\\\\"mod view_error\\\\\\\"\\u003E  \\u003Cdiv id=\\\\\\\"error-{type_name}-bd\\\\\\\" class=\\\\\\\"bd  _error\\\\\\\"\\u003E{html}    \\u003C\\\\/div\\u003E\\\\n\\u003C\\\\/div\\u003E\\\",\\u000a            modErrorHtml : \\\"\\u003Cdiv class=\\\\\\\"oops-msg\\\\\\\" role=\\\\\\\"alertdialog\\\\\\\"\\u003E\\\\n                \\u003Cspan class='icon' style='background-image:url({img});_filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop src=\\\\\\\"{img}\\\\\\\"); _background-image:none;'\\u003E\\u003C\\\\/span\\u003E\\u003Cspan class='shadow'\\u003E\\u003C\\\\/span\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"oops\\\\\\\"\\u003E\\\\\\\"{name}\\\\\\\" encountered a problem while trying to load\\u003C\\\\/h3\\u003E\\\\n                \\u003Cp class=\\\\\\\"oops\\\\\\\"\\u003E{message}\\u003C\\\\/p\\u003E\\\\n                                \\u003Cp class=\\\\\\\"oops oops-link\\\\\\\"\\u003EOr visit \\u003Ca href=\\\\\\\"{url}\\\\\\\"\\u003E{url}\\u003C\\\\/a\\u003E\\u003C\\\\/p\\u003E\\\\n            \\u003C\\\\/div\\u003E\\\",\\u000a            crumbErrorHtml : \\\"\\u003Cdiv class=\\\\\\\"oops-msg\\\\\\\" role=\\\\\\\"alertdialog\\\\\\\"\\u003E\\\\n                \\u003Cspan class=\\\\\\\"icon icon-error y-glbl-universal\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"oops\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\/h3\\u003E\\\\n                \\u003Cp class=\\\\\\\"oops\\\\\\\"\\u003E2048\\u003C\\\\/p\\u003E\\\\n                \\\\n            \\u003C\\\\/div\\u003E\\\",\\u000a            cookieErrorHtml : \\\"\\u003Cdiv class=\\\\\\\"oops-msg\\\\\\\" role=\\\\\\\"alertdialog\\\\\\\"\\u003E\\\\n                \\u003Cspan class=\\\\\\\"icon icon-error y-glbl-universal\\\\\\\"\\u003E\\u003C\\\\/span\\u003E\\\\n                \\u003Ch3 class=\\\\\\\"oops\\\\\\\"\\u003EThe module encountered a problem while trying to load\\u003C\\\\/h3\\u003E\\\\n                \\u003Cp class=\\\\\\\"oops\\\\\\\"\\u003E16384\\u003C\\\\/p\\u003E\\\\n                \\\\n            \\u003C\\\\/div\\u003E\\\",\\u000a            proxyTimeout : 15000,\\u000a            proxyUrl : '/hjs',\\u000a            intl : \\\"us\\\",\\u000a            \\\"ywa.rapid.enabled\\\": true\\u000a        });\\u000a    });\\u000a\\u000a    var i, len, url, match, modules,\\u000a        allScripts = YUI.presentation.lazyScriptList,\\u000a        comboRoot = 'http://l.yimg.com/zz/combo?',\\u000a        isCombo =  allScripts[0].indexOf(comboRoot) === 0,\\u000a        yuiMods = ['metro_config'],\\u000a        lazyScripts = [];\\u000a\\u000a    if (isCombo) {\\u000a        for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\u000a            url = allScripts[i].replace(comboRoot, '');\\u000a            allScripts = allScripts.concat(url.split('&'));\\u000a        }\\u000a        allScripts = allScripts.slice(len);\\u000a    }\\u000a\\u000a    for (i = 0, len = allScripts.length; i \\u003C len; ++i) {\\u000a        url = allScripts[i];\\u000a        match = url.match(/\\\\/yui\\\\/([^._]*)/);\\u000a        if (match && match.length \\u003E 1) {\\u000a            yuiMods.push(match[1]);\\u000a        } else {\\u000a            lazyScripts.push(url);\\u000a        }\\u000a    }\\u000a\\u000a    if (isCombo) {\\u000a        lazyScripts = [comboRoot + lazyScripts.join('&')];\\u000a    }\\u000a\\u000a    if (YMedia.ModulePlatform) {\\u000a        modules = YMedia.ModulePlatform.getModules();\\u000a        YMedia.ModulePlatform.stop(modules);\\u000a        YMedia.each(modules, YMedia.ModulePlatform.unregisterModule);\\u000a    }\\u000a    YMedia.use(yuiMods, function (Y) {\\u000a        Y.dali.config.debug = false;\\u000a        Y.Get.script(lazyScripts, { onSuccess: function(){\\u000a            Y.use(\\\"*\\\", function (Y) {\\u000a                Y.ModulePlatform.init(Y.dali.config, true);\\u000a            });\\u000a        }});\\u000a        var rapid = YMedia ? YMedia.rapid : null,\\u000a            id = 'p_30345786',\\u000a            container = Y.one('#' + id);\\u000a        if (rapid && container) {\\u000a            if (rapid.isModuleTracked(id)) {\\u000a                rapid.refreshModule(id);\\u000a            } else {\\u000a                rapid.addModules(id);\\u000a            }\\u000a        }\\u000a        if (container) {\\u000a            container.addClass('jsenabled');\\u000a        }\\u000a    });\\u000a\\u000a})();\\u000a\\u003C/script\\u003E\\u000a\\u000a--dali-response-split-51ddabac509b3--\"\n            });\n        })));\n    })()));\n} finally {\n    ((window.top.JSBNG_Record.callerJS) = (false));\n    ((window.top.JSBNG_Record.flushDeferredEvents)());\n};\n\n\n\t\ttry {\n    ((JSBNG_Record.scriptLoad)((\"YUI.YUICfg = {\\u000a    gallery: \\\"gallery-2011.04.20-13-04\\\",\\u000a    groups: {\\u000a        group01c9d8dea06e05460a64eed4dadd622b6: {\\u000a            base: \\\"http://l.yimg.com/\\\",\\u000a            comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a            modules: {\\u000a                \\\"media-request-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/request-manager-min-1334113.js\\\"\\u000a                },\\u000a                \\\"media-content-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/content-manager-min-1331468.js\\\"\\u000a                },\\u000a                \\\"media-perf-timeable\\\": {\\u000a                    path: \\\"os/mit/media/p/content/perf-timeable-min-1191658.js\\\"\\u000a                },\\u000a                \\\"media-ad-controller\\\": {\\u000a                    path: \\\"os/mit/media/p/content/ad-controller-min-1334238.js\\\"\\u000a                },\\u000a                \\\"media-pane-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/pane-manager-min-1343260.js\\\"\\u000a                },\\u000a                \\\"media-next-scroll\\\": {\\u000a                    path: \\\"os/mit/media/p/content/next-scroll-min-1304262.js\\\"\\u000a                },\\u000a                \\\"media-tag-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/tag-manager-min-1294559.js\\\"\\u000a                },\\u000a                \\\"media-content-discoverer\\\": {\\u000a                    path: \\\"os/mit/media/p/content/content-discoverer-min-1331680.js\\\"\\u000a                },\\u000a                \\\"media-interest-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/interest-manager-min-1306018.js\\\"\\u000a                },\\u000a                \\\"media-instrumentation\\\": {\\u000a                    path: \\\"os/mit/media/p/content/instrumentation-min-1214752.js\\\"\\u000a                },\\u000a                \\\"media-content-ss-base\\\": {\\u000a                    path: \\\"os/mit/media/m/content_photo/content-ss-base-min-1330613.js\\\"\\u000a                },\\u000a                \\\"media-content-ss-no-sv\\\": {\\u000a                    path: \\\"os/mit/media/m/content_photo/content-ss-no-sv-min-1328161.js\\\"\\u000a                },\\u000a                \\\"media-carousel\\\": {\\u000a                    path: \\\"os/mit/media/m/content_photo/carousel-min-1308638.js\\\"\\u000a                },\\u000a                \\\"media-lead\\\": {\\u000a                    path: \\\"os/mit/media/m/content_index/lead-min-1306566.js\\\"\\u000a                },\\u000a                \\\"media-comic\\\": {\\u000a                    path: \\\"os/mit/media/m/content_index/comic-min-1262759.js\\\"\\u000a                },\\u000a                \\\"media-content-social-base\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-social-base-min-1339203.js\\\"\\u000a                },\\u000a                \\\"media-content-email-autocomplete\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-email-autocomplete-min-1306078.js\\\"\\u000a                },\\u000a                \\\"media-content-share-buttons\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-share-buttons-min-1339400.js\\\"\\u000a                },\\u000a                \\\"media-content-share-buttons-builder\\\": {\\u000a                    path: \\\"os/mit/media/m/content_social/content-share-buttons-builder-min-1337341.js\\\"\\u000a                },\\u000a                \\\"media-bc\\\": {\\u000a                    path: \\\"d/lib/bc/bc_2.0.5.js\\\"\\u000a                },\\u000a                \\\"media-beacon-manager\\\": {\\u000a                    path: \\\"os/mit/media/p/content/beacon-manager-min-1333171.js\\\"\\u000a                },\\u000a                \\\"media-nav-addon\\\": {\\u000a                    path: \\\"os/mit/media/m/navigation/nav-addon-min-1270754.js\\\"\\u000a                },\\u000a                \\\"media-recommend\\\": {\\u000a                    path: \\\"os/mit/media/p/content/recommend-min-1277359.js\\\"\\u000a                },\\u000a                \\\"media-personal-nav\\\": {\\u000a                    path: \\\"os/mit/media/p/content/personal-nav-min-1318968.js\\\"\\u000a                },\\u000a                \\\"media-strip\\\": {\\u000a                    path: \\\"ss/strip_3.2.js\\\"\\u000a                },\\u000a                \\\"media-trfsm\\\": {\\u000a                    path: \\\"os/mit/media/p/common/trfsm-min-797026.js\\\"\\u000a                },\\u000a                \\\"media-i13n\\\": {\\u000a                    path: \\\"os/mit/media/p/common/i13n-min-1154367.js\\\"\\u000a                },\\u000a                \\\"media-ywa-tracking\\\": {\\u000a                    path: \\\"os/mit/media/p/common/ywa-tracking-min-1234794.js\\\"\\u000a                },\\u000a                \\\"media-content-navigation-desktop\\\": {\\u000a                    path: \\\"os/mit/media/m/navigation/content-navigation-desktop-min-1318647.js\\\"\\u000a                },\\u000a                \\\"media-footer\\\": {\\u000a                    path: \\\"os/mit/media/m/footer/footer-min-923366.js\\\"\\u000a                }\\u000a            },\\u000a            combine: true,\\u000a            filter: \\\"min\\\",\\u000a            root: \\\"/\\\"\\u000a        }\\u000a    },\\u000a    modules: {\\u000a        \\\"media-ad-ros\\\": {\\u000a            fullpath: \\\"http://ads.yimg.com/qq/dm/ad-ros-0.0.2.js\\\"\\u000a        }\\u000a    },\\u000a    combine: true,\\u000a    allowRollup: true,\\u000a    comboBase: \\\"http://l.yimg.com/zz/combo?\\\",\\u000a    maxURLLength: \\\"2000\\\"\\u000a};\\u000aYUI.YUICfg.root = ((\\\"yui:\\\" + YUI.version) + \\\"/build/\\\");\\u000aYMedia.applyConfig(YUI.YUICfg);\\u000aYUI.Env[YUI.version].groups.gallery.root = \\\"yui:gallery-2011.04.20-13-04/build/\\\";\\u000aYMedia.use(\\\"media-request-manager\\\", \\\"media-content-manager\\\", \\\"media-perf-timeable\\\", \\\"node-scroll-info\\\", \\\"event-custom\\\", \\\"media-ad-controller\\\", \\\"app-base\\\", \\\"querystring-parse\\\", \\\"media-rmp\\\", \\\"media-pane-manager\\\", \\\"node-base\\\", \\\"event-touch\\\", \\\"media-next-scroll\\\", \\\"media-next-scroll\\\", \\\"event-mouseenter\\\", \\\"media-tag-manager\\\", \\\"media-tag-manager\\\", \\\"media-content-discoverer\\\", \\\"history-base\\\", \\\"media-interest-manager\\\", \\\"io-base\\\", \\\"json-parse\\\", \\\"media-instrumentation\\\", \\\"media-content-ss-base\\\", \\\"media-content-ss-no-sv\\\", \\\"node-base\\\", \\\"event-key\\\", \\\"media-carousel\\\", \\\"base\\\", \\\"json-parse\\\", \\\"querystring-stringify\\\", \\\"media-lead\\\", \\\"media-comic\\\", \\\"autocomplete\\\", \\\"autocomplete-highlighters\\\", \\\"event-base\\\", \\\"event-custom\\\", \\\"node-core\\\", \\\"io\\\", \\\"querystring\\\", \\\"overlay\\\", \\\"json\\\", \\\"gallery-node-tokeninput\\\", \\\"querystring-stringify-simple\\\", \\\"gallery-outside-events\\\", \\\"media-content-social-base\\\", \\\"media-content-email-autocomplete\\\", \\\"media-content-social-base\\\", \\\"media-content-email-autocomplete\\\", \\\"media-content-share-buttons\\\", \\\"event\\\", \\\"node\\\", \\\"media-content-share-buttons-builder\\\", function(Y) {\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.adController = new Y.Media.AdController({\\u000a            env: \\\"prod\\\",\\u000a            hideOnFailure: false,\\u000a            fetchOnPjaxOnly: true,\\u000a            preserveLRECContainer: false\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.requestManager = new Y.Media.RequestManager({\\u000a            chrome: Y.Media.pageChrome,\\u000a            linkSelector: \\\"a:not(.no-pjax)\\\",\\u000a            unsuppBrowsers: \\\"\\\",\\u000a            continueOnError: \\\"1\\\",\\u000a            pjaxSplit: \\\"0\\\",\\u000a            ignoreCssErrors: \\\"1\\\"\\u000a        }).render();\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.ContentManager({\\u000a            nodePaths: {\\u000a                content: \\\"#yog-content\\\",\\u000a                navigation: \\\"#yog-nav .navlist\\\",\\u000a                related: \\\"#yog-related\\\",\\u000a                superlead: \\\"#yog-stage\\\"\\u000a            },\\u000a            transition: {\\u000a                style: \\\"fade\\\"\\u000a            }\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.pagePaneManager = new Y.Media.PaneManager({\\u000a            debug: 0,\\u000a            grid_type: {\\u000a                content: {\\u000a                    scroll_mode: \\\"bandit\\\"\\u000a                },\\u000a                index: {\\u000a                    scroll_mode: \\\"bandit\\\"\\u000a                }\\u000a            },\\u000a            isYnet: 0\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.TagManager();\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.ContentDiscoverer({\\u000a            enableLightboxOnStream: \\\"1\\\"\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.InterestManager({\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.Instrumentation();\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        new Y.Media.ContentSSNoSV({\\u000a            chrome: Y.Media.pageChrome,\\u000a            config: {\\u000a                modId: \\\"\\\",\\u000a                setupSlideshowCover: \\\"false\\\",\\u000a                enableCarousel: \\\"1\\\",\\u000a                enableEndSlideRel: \\\"0\\\",\\u000a                enableEndSlideMP: \\\"1\\\",\\u000a                strings: {\\u000a                    more: \\\"more\\\",\\u000a                    less: \\\"less\\\",\\u000a                    of: \\\"of\\\"\\u000a                }\\u000a            }\\u000a        });\\u000a    });\\u000a    Y.later(10, this, function() {\\u000a        Y.Media.shareButtonsBuilder = new Y.Media.ContentShareButtonsBuilder({\\u000a            modNode: \\\"\\\",\\u000a            switches: {\\u000a                mtf: true,\\u000a                cmt: false\\u000a            },\\u000a            loginStat: {\\u000a                yahoo: 0\\u000a            },\\u000a            data: {\\u000a                mtfRedirUrl: \\\"http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\"\\u000a            },\\u000a            pageData: {\\u000a                crumb: \\\"\\\",\\u000a                title: \\\"\\\",\\u000a                summary: \\\"\\\",\\u000a                thumbnail: \\\"\\\",\\u000a                url: \\\"\\\",\\u000a                locale: \\\"US\\\",\\u000a                prop: \\\"news\\\",\\u000a                content_id: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                ult__S: \\\"81121452\\\",\\u000a                ult_ct: \\\"\\\",\\u000a                ult_pkg: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                ult_test: null,\\u000a                ult_csrcpvid: \\\"Fkgif86.K_zWN_2H3UgvxgAdDLU3OFHdq5cAACBD\\\",\\u000a                ult_sec: \\\"mit_share\\\",\\u000a                ult_slk: \\\"mail\\\",\\u000a                ult_mpos: 1,\\u000a                ult_lang: \\\"en-US\\\",\\u000a                ult_act: \\\"mail\\\",\\u000a                ult_pstaid: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\"\\u000a            },\\u000a            contentMetaData: {\\u000a                id: \\\"5f01278b-803a-3803-9798-7fc79bab4f7d\\\",\\u000a                url_orig: \\\"\\\",\\u000a                title_orig: \\\"\\\",\\u000a                summary: \\\"\\\",\\u000a                type: \\\"homepage\\\"\\u000a            },\\u000a            config: {\\u000a                site: \\\"news\\\",\\u000a                lang: \\\"en-US\\\",\\u000a                region: \\\"US\\\",\\u000a                scrumb: false\\u000a            },\\u000a            template: \\\"\\\\u003Cdiv class=\\\\\\\"yom-share-btns-container light\\\\\\\"\\\\u003E\\\\u000a    \\\\u003Cdiv class=\\\\\\\"share-btns\\\\\\\" role=\\\\\\\"menu\\\\\\\"\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"share-btns-wrap\\\\\\\"\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"share-btn-wrap\\\\\\\"\\\\u003E\\\\u000a                \\\\u003Cul\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn facebook\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"http://www.facebook.com/dialog/feed?app_id=90376669494&amp;redirect_uri=http://news.yahoo.com/_xhr/mediacontentsharebuttons/postshare/?src=fb&amp;link=http://news.yahoo.com/&amp;picture=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png&amp;display=popup&amp;show_error=yes\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"share\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-fb;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-fb\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E0\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn twitter\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"https://twitter.com/share?text=Yahoo%21%20News%20-%20Latest%20News%20%26%20Headlines&amp;url=http://news.yahoo.com/&amp;via=YahooNews\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tweet\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tw;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-tw\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E0\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn tumblr\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"http://www.tumblr.com/share/link?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&name=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"tumblr\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-tu;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-tu\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn pinterest\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&media=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"pinterest\\\\\\\" target=\\\\\\\"_blank\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-pin;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-pin\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u003Cli class=\\\\\\\"share-btn mail email\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca href=\\\\\\\"mailto:?subject=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines&amp;body=http%3A%2F%2Fnews.yahoo.com%2F\\\\\\\" role=\\\\\\\"link\\\\\\\" title=\\\\\\\"email\\\\\\\" data-ylk=\\\\\\\"sec:mod-sh-b;slk:btn-sh-ma;itc:1;test:;\\\\\\\" data-action-outcome=\\\\\\\"share\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-icon btn-mail\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"btn-count hide\\\\\\\"\\\\u003E0\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/li\\\\u003E\\\\u000a                \\\\u003C/ul\\\\u003E\\\\u000a            \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a        \\\\u003C/div\\\\u003E\\\\u000a    \\\\u003C/div\\\\u003E\\\\u000a    \\\\u003Cdiv class=\\\\\\\"share-btns-overlay-screen hide\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a    \\\\u003Cdiv class=\\\\\\\"share-btns-overlay hide\\\\\\\"\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"yui3-widget-hd\\\\\\\"\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003E&times;\\\\u003C/div\\\\u003E\\\\u000a        \\\\u003C/div\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"yui3-widget-bd\\\\\\\"\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide mail-login\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Sign in to share this by email\\\\\\\"\\\\u003E\\\\u000a                \\\\u003Ch3 class=\\\\\\\"header\\\\\\\"\\\\u003ESign in to share this by email\\\\u003C/h3\\\\u003E\\\\u000a                \\\\u003Cdiv class=\\\\\\\"login-btns\\\\\\\"\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca class=\\\\\\\"login-btn yahoo\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https://login.yahoo.com/config/login_verify2?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail&amp;.src=mtf\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"login-icon yahoo\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\\\u003EYahoo!\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"login-link\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Ca class=\\\\\\\"login-btn facebook\\\\\\\" role=\\\\\\\"link\\\\\\\" href=\\\\\\\"https://open.login.yahoo.com/openid/yrp/signin?.intl=us&amp;idp=facebook&amp;.done=http://news.yahoo.com/%23mtf-overlay&amp;ts=1373481879&amp;.src=home&amp;appid=90376669494&amp;spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&amp;perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history,publish_actions&amp;fbflow=1\\\\\\\" target=\\\\\\\"_blank\\\\\\\"\\\\u003E\\\\u003Cspan class=\\\\\\\"login-icon facebook\\\\\\\"\\\\u003E\\\\u003C/span\\\\u003E\\\\u003Cspan class=\\\\\\\"login-text\\\\\\\"\\\\u003EFacebook\\\\u003C/span\\\\u003E\\\\u003C/a\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                \\\\u003C/div\\\\u003E\\\\u000a                \\\\u003Cp\\\\u003ENew here? \\\\u003Ca href=\\\\\\\"https://edit.yahoo.com/config/eval_register?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"signup\\\\\\\"\\\\u003ESign up.\\\\u003C/a\\\\u003E\\\\u003C/p\\\\u003E\\\\u000a            \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide mail-form\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"Email this\\\\\\\"\\\\u003E\\\\u000a                \\\\u003Ch3 class=\\\\\\\"header\\\\\\\"\\\\u003EEmail this\\\\u003C/h3\\\\u003E\\\\u000a                \\\\u003Cdiv class=\\\\\\\"form\\\\\\\"\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Clabel for=\\\\\\\"semail\\\\\\\"\\\\u003EFrom\\\\u003C/label\\\\u003E\\\\u003Cselect id=\\\\\\\"semail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"menu\\\\\\\" disabled\\\\u003E\\\\u003Coption role=\\\\\\\"menuitem\\\\\\\"\\\\u003ELoading...\\\\u003C/option\\\\u003E\\\\u003C/select\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-semail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EPlease enter a valid email address\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"form-input\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Clabel for=\\\\\\\"remail\\\\\\\"\\\\u003ETo\\\\u003C/label\\\\u003E\\\\u003Cinput id=\\\\\\\"remail\\\\\\\" class=\\\\\\\"mail-input\\\\\\\" role=\\\\\\\"textbox\\\\\\\" disabled\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-remail-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EPlease enter valid email addresses, separated by commas\\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-remail-max-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EMaximum 200 character limit exceeded\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"form-input fb-import\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Clabel\\\\u003E&nbsp;\\\\u003C/label\\\\u003E\\\\u003Cspan\\\\u003EDon't see your Facebook contacts? \\\\u003Ca href=\\\\\\\"http://address.yahoo.com/?_src=neo&VPC=tools_import&.done=http://www.yahoo.com\\\\\\\" role=\\\\\\\"link\\\\\\\" target=\\\\\\\"_blank\\\\\\\" class=\\\\\\\"import\\\\\\\"\\\\u003EImport them\\\\u003C/a\\\\u003E\\\\u003C/span\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv\\\\u003E\\\\u000a                        \\\\u003Ctextarea placeholder=\\\\\\\"Write a message\\\\\\\" class=\\\\\\\"mail-text\\\\\\\" role=\\\\\\\"textbox\\\\\\\" aria-multiline=\\\\\\\"true\\\\\\\"\\\\u003E\\\\u003C/textarea\\\\u003E \\\\u000a                        \\\\u003Cdiv class=\\\\\\\"yom-mtf-pmesg-error icon-alert-small yui3-widget-hidden\\\\\\\"\\\\u003EPlease enter a message\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"mail-article\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"article thumbnail\\\\\\\"\\\\u003E\\\\u000a                            \\\\u003Cimg title=\\\\\\\"Yahoo! News - Latest News &amp;amp; Headlines\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"article\\\\\\\"\\\\u003E\\\\u000a                            \\\\u003Cdiv class=\\\\\\\"title\\\\\\\"\\\\u003EYahoo! News - Latest News &amp;amp; Headlines\\\\u003C/div\\\\u003E\\\\u000a                            \\\\u003Cdiv class=\\\\\\\"description\\\\\\\"\\\\u003EThe latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003Cdiv class=\\\\\\\"mail-submit\\\\\\\"\\\\u003E\\\\u000a                        \\\\u003Cinput type=\\\\\\\"checkbox\\\\\\\" id=\\\\\\\"cc-self\\\\\\\" role=\\\\\\\"checkbox\\\\\\\"\\\\u003E\\\\u003Clabel for=\\\\\\\"cc-self\\\\\\\" class=\\\\\\\"cc-self\\\\\\\"\\\\u003ESend me a copy of this email\\\\u003C/label\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"submit-btns\\\\\\\"\\\\u003E\\\\u000a                            \\\\u003Cbutton class=\\\\\\\"mail-btn send\\\\\\\" role=\\\\\\\"button\\\\\\\" disabled\\\\u003ESend\\\\u003C/button\\\\u003E\\\\u000a                            \\\\u003Cbutton class=\\\\\\\"mail-btn close-btn\\\\\\\" role=\\\\\\\"button\\\\\\\"\\\\u003ECancel\\\\u003C/button\\\\u003E\\\\u000a                        \\\\u003C/div\\\\u003E\\\\u000a                        \\\\u003Cdiv class=\\\\\\\"clearfix\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a                    \\\\u003C/div\\\\u003E\\\\u000a                \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide facebook\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"facebook\\\\\\\"\\\\u003Efacebook\\\\u003C/div\\\\u003E\\\\u000a            \\\\u003Cdiv class=\\\\\\\"speedbump hide twitter\\\\\\\" role=\\\\\\\"dialog\\\\\\\" aria-labelledby=\\\\\\\"twitter\\\\\\\"\\\\u003Etwitter\\\\u003C/div\\\\u003E\\\\u000a        \\\\u003C/div\\\\u003E\\\\u000a        \\\\u003Cdiv class=\\\\\\\"yui3-widget-ft\\\\\\\"\\\\u003E\\\\u003C/div\\\\u003E\\\\u000a    \\\\u003C/div\\\\u003E\\\\u000a\\\\u003C/div\\\\u003E\\\\u000a\\\"\\u000a        });\\u000a    });\\u000a});\\u000aYUI.Env.add(window, \\\"load\\\", function() {\\u000a    YMedia.use(\\\"media-rmp\\\", \\\"media-bc\\\", \\\"media-beacon-manager\\\", \\\"event-custom\\\", \\\"handlebars\\\", \\\"node-base\\\", \\\"media-nav-addon\\\", \\\"node-core\\\", \\\"node-data\\\", \\\"event-base\\\", \\\"node-event-delegate\\\", \\\"event-delegate\\\", \\\"event-tap\\\", \\\"media-tag-manager\\\", \\\"media-recommend\\\", \\\"media-personal-nav\\\", \\\"cookie\\\", \\\"querystring-parse\\\", \\\"media-strip\\\", \\\"media-trfsm\\\", \\\"base\\\", \\\"jsonp\\\", \\\"media-i13n\\\", \\\"media-ywa-tracking\\\", \\\"media-content-navigation-desktop\\\", \\\"overlay\\\", \\\"media-ad-ros\\\", \\\"media-footer\\\", function(Y) {\\u000a        Y.later(10, this, function() {\\u000a            Y.Array.each(YMedia.includes, function(inc, i, ar) {\\u000a                if (Y.Lang.isFunction(inc)) {\\u000a                    inc(Y);\\u000a                    ar[i] = null;\\u000a                }\\u000a            ;\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.BeaconManager({\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.NavAddon({\\u000a                max: \\\"3\\\",\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.Recommend({\\u000a                header: \\\"Recommended\\\",\\u000a                position: 1,\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.PersonalNav({\\u000a                header: \\\"My Topics\\\",\\u000a                position: 2\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            Y.Global.Media.ILBoot.initImageLoader(true);\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            (function() {\\u000a                var configUrl = \\\"http://l.yimg.com/os/assets/globalmedia/traffic/traffic-simulation.js\\\", simulator = new Y.Media.TrafficSimulator({\\u000a                    dataUrl: configUrl\\u000a                });\\u000a                simulator.load();\\u000a            })();\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            try {\\u000a                YMEDIA_REQ_ATTR.csbeacon();\\u000a            } catch (e) {\\u000a            \\u000a            };\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            new Y.Media.ContentNavigation({\\u000a                config: {\\u000a                    modId: \\\"mediacontentnavigation\\\"\\u000a                },\\u000a                chrome: Y.Media.pageChrome\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            Y.Media.Lead.MediaContentLead.init({\\u000a                cat: \\\"\\\",\\u000a                catName: \\\"\\\",\\u000a                \\\"listid \\\": \\\"\\\"\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            Y.Media.Comic.MediaContentComic.init({\\u000a                meta: {\\u000a                    error: {\\u000a                        error_code: 0\\u000a                    },\\u000a                    mod_id: \\\"mediacontentcomic\\\",\\u000a                    bucket: null,\\u000a                    selected_list: \\\"702ab4a0-145a-3b69-9a83-aed16a8a024a\\\",\\u000a                    selected_name: \\\"Garfield\\\",\\u000a                    abbreviation: \\\"ga\\\",\\u000a                    max_result_count: 14,\\u000a                    start: 0,\\u000a                    count: 14,\\u000a                    total: 100,\\u000a                    alias: \\\"/comics/garfield-slideshow/\\\",\\u000a                    enableLightBox: 0\\u000a                },\\u000a                data: {\\u000a                    \\\"702ab4a0-145a-3b69-9a83-aed16a8a024a\\\": [{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/HsOPI8Hi4Dd406_Wcx_Rxg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130710.gif\\\",\\u000a                        rsrc: \\\"http://l.yimg.com/bt/api/res/1.2/LevQzAit8GjQB95PNqJEaw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130710.gif\\\",\\u000a                        sdate: \\\"Wed, Jul 10\\\",\\u000a                        date: \\\"Wednesday, July 10\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/VN4cfbpPnSeuIK4yYivb4w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130709.gif\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/bpLDYA30ACFFXoRNYNwOzw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130709.gif\\\",\\u000a                        sdate: \\\"Tue, Jul 9\\\",\\u000a                        date: \\\"Tuesday, July 9\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/mped5Y9s0mK8FAHrPujA8w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130708.gif\\\",\\u000a                        rsrc: \\\"http://l.yimg.com/bt/api/res/1.2/GWRrlT1mkKyKSo3T36FvoA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130708.gif\\\",\\u000a                        sdate: \\\"Mon, Jul 8\\\",\\u000a                        date: \\\"Monday, July 8\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/WB0QMhcgw.BXIkfaporMqA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTQyMjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130707.jpg\\\",\\u000a                        rsrc: \\\"http://l2.yimg.com/bt/api/res/1.2/BM1MIhbEweFIHdwhJ2lPig--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI1NjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130707.jpg\\\",\\u000a                        sdate: \\\"Sun, Jul 7\\\",\\u000a                        date: \\\"Sunday, July 7\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/7nRIEPtGF33YIyyvamLXqw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130706.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/DMEXHwbV6UJKG1heyjauvg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130706.gif\\\",\\u000a                        sdate: \\\"Sat, Jul 6\\\",\\u000a                        date: \\\"Saturday, July 6\\\"\\u000a                    },{\\u000a                        src: \\\"http://l3.yimg.com/bt/api/res/1.2/CNxK8MQxW4nxW8I5IsmIYg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130705.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/q0Vkxe8Kb24vWNdgV7QMUg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130705.gif\\\",\\u000a                        sdate: \\\"Fri, Jul 5\\\",\\u000a                        date: \\\"Friday, July 5\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/5pPWSABPZX8jN5acXOtEyg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130704.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/pqQZdsB46tLgoPYhBqIeAg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130704.gif\\\",\\u000a                        sdate: \\\"Thu, Jul 4\\\",\\u000a                        date: \\\"Thursday, July 4\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/QhzkGUnNNXKC86F.GdSVqQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130703.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/FjfxEkaUGBLkUZYbI1vYJw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130703.gif\\\",\\u000a                        sdate: \\\"Wed, Jul 3\\\",\\u000a                        date: \\\"Wednesday, July 3\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/0y_GF1XQ6snde6Ul04By5Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130702.gif\\\",\\u000a                        rsrc: \\\"http://l2.yimg.com/bt/api/res/1.2/1F2l41IfvFh_9g7.et7HCw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130702.gif\\\",\\u000a                        sdate: \\\"Tue, Jul 2\\\",\\u000a                        date: \\\"Tuesday, July 2\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/thoi55aGBZ7jd2WyWaODMQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130701.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/RYmZMKrrAuSnVdcspOftIQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130701.gif\\\",\\u000a                        sdate: \\\"Mon, Jul 1\\\",\\u000a                        date: \\\"Monday, July 1\\\"\\u000a                    },{\\u000a                        src: \\\"http://l.yimg.com/bt/api/res/1.2/8YJYSVXxS8rIAkX8N.jHPQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTQyMjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130630.jpg\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/XlqV4JwM6sXvCRNBBAYWGA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI1NjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130630.jpg\\\",\\u000a                        sdate: \\\"Sun, Jun 30\\\",\\u000a                        date: \\\"Sunday, June 30\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/Q45WeuPPsTXQBY5JkjItTQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130629.gif\\\",\\u000a                        rsrc: \\\"http://l3.yimg.com/bt/api/res/1.2/worLLaS5MHzh7bqdSBJcWQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130629.gif\\\",\\u000a                        sdate: \\\"Sat, Jun 29\\\",\\u000a                        date: \\\"Saturday, June 29\\\"\\u000a                    },{\\u000a                        src: \\\"http://l1.yimg.com/bt/api/res/1.2/vd2Wbq3pmN83mgApyCkzPg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130628.gif\\\",\\u000a                        rsrc: \\\"http://l1.yimg.com/bt/api/res/1.2/WOtPpC4WYiihGmOfwtvWGw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130628.gif\\\",\\u000a                        sdate: \\\"Fri, Jun 28\\\",\\u000a                        date: \\\"Friday, June 28\\\"\\u000a                    },{\\u000a                        src: \\\"http://l2.yimg.com/bt/api/res/1.2/nHP31hF.HuDAjBhW.ht1aQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130627.gif\\\",\\u000a                        rsrc: \\\"http://l.yimg.com/bt/api/res/1.2/9ZkS9kySryvffth5Wp2Phg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130627.gif\\\",\\u000a                        sdate: \\\"Thu, Jun 27\\\",\\u000a                        date: \\\"Thursday, June 27\\\"\\u000a                    },]\\u000a                }\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            window.dmRosAds.insertMultiAd({\\u000a                dmRosAdConfig: \\\"e5879714\\\",\\u000a                dmRosAdTypeTag: \\\"default\\\",\\u000a                dmRosAdSlotInfo: [{\\u000a                    dmRosAdSlotId: \\\"east\\\",\\u000a                    dmRosAdDivId: \\\"dmRosAdWrapper-east\\\",\\u000a                    dmRosAdWidth: \\\"300\\\",\\u000a                    dmRosAdHeight: \\\"300\\\"\\u000a                },]\\u000a            });\\u000a        });\\u000a        Y.later(10, this, function() {\\u000a            if (Y.Media.Footer) {\\u000a                var footer = Y.Media.Footer(Y, {\\u000a                    footerInfoSelector: \\\"#footer-info\\\",\\u000a                    currentDeviceType: \\\"full\\\",\\u000a                    projectId: \\\"10001393120079\\\",\\u000a                    enableYwaTracking: \\\"0\\\"\\u000a                })\\u000a            };\\u000a        });\\u000a    });\\u000a});\"), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46\")));\n    ((window.top.JSBNG_Record.callerJS) = (true));\n    ((JSBNG_Record.set)(YUI, (\"YUICfg\"), {\n        gallery: \"gallery-2011.04.20-13-04\",\n        groups: {\n            group01c9d8dea06e05460a64eed4dadd622b6: {\n                base: \"http://l.yimg.com/\",\n                comboBase: \"http://l.yimg.com/zz/combo?\",\n                modules: {\n                    \"media-request-manager\": {\n                        path: \"os/mit/media/p/content/request-manager-min-1334113.js\"\n                    },\n                    \"media-content-manager\": {\n                        path: \"os/mit/media/p/content/content-manager-min-1331468.js\"\n                    },\n                    \"media-perf-timeable\": {\n                        path: \"os/mit/media/p/content/perf-timeable-min-1191658.js\"\n                    },\n                    \"media-ad-controller\": {\n                        path: \"os/mit/media/p/content/ad-controller-min-1334238.js\"\n                    },\n                    \"media-pane-manager\": {\n                        path: \"os/mit/media/p/content/pane-manager-min-1343260.js\"\n                    },\n                    \"media-next-scroll\": {\n                        path: \"os/mit/media/p/content/next-scroll-min-1304262.js\"\n                    },\n                    \"media-tag-manager\": {\n                        path: \"os/mit/media/p/content/tag-manager-min-1294559.js\"\n                    },\n                    \"media-content-discoverer\": {\n                        path: \"os/mit/media/p/content/content-discoverer-min-1331680.js\"\n                    },\n                    \"media-interest-manager\": {\n                        path: \"os/mit/media/p/content/interest-manager-min-1306018.js\"\n                    },\n                    \"media-instrumentation\": {\n                        path: \"os/mit/media/p/content/instrumentation-min-1214752.js\"\n                    },\n                    \"media-content-ss-base\": {\n                        path: \"os/mit/media/m/content_photo/content-ss-base-min-1330613.js\"\n                    },\n                    \"media-content-ss-no-sv\": {\n                        path: \"os/mit/media/m/content_photo/content-ss-no-sv-min-1328161.js\"\n                    },\n                    \"media-carousel\": {\n                        path: \"os/mit/media/m/content_photo/carousel-min-1308638.js\"\n                    },\n                    \"media-lead\": {\n                        path: \"os/mit/media/m/content_index/lead-min-1306566.js\"\n                    },\n                    \"media-comic\": {\n                        path: \"os/mit/media/m/content_index/comic-min-1262759.js\"\n                    },\n                    \"media-content-social-base\": {\n                        path: \"os/mit/media/m/content_social/content-social-base-min-1339203.js\"\n                    },\n                    \"media-content-email-autocomplete\": {\n                        path: \"os/mit/media/m/content_social/content-email-autocomplete-min-1306078.js\"\n                    },\n                    \"media-content-share-buttons\": {\n                        path: \"os/mit/media/m/content_social/content-share-buttons-min-1339400.js\"\n                    },\n                    \"media-content-share-buttons-builder\": {\n                        path: \"os/mit/media/m/content_social/content-share-buttons-builder-min-1337341.js\"\n                    },\n                    \"media-bc\": {\n                        path: \"d/lib/bc/bc_2.0.5.js\"\n                    },\n                    \"media-beacon-manager\": {\n                        path: \"os/mit/media/p/content/beacon-manager-min-1333171.js\"\n                    },\n                    \"media-nav-addon\": {\n                        path: \"os/mit/media/m/navigation/nav-addon-min-1270754.js\"\n                    },\n                    \"media-recommend\": {\n                        path: \"os/mit/media/p/content/recommend-min-1277359.js\"\n                    },\n                    \"media-personal-nav\": {\n                        path: \"os/mit/media/p/content/personal-nav-min-1318968.js\"\n                    },\n                    \"media-strip\": {\n                        path: \"ss/strip_3.2.js\"\n                    },\n                    \"media-trfsm\": {\n                        path: \"os/mit/media/p/common/trfsm-min-797026.js\"\n                    },\n                    \"media-i13n\": {\n                        path: \"os/mit/media/p/common/i13n-min-1154367.js\"\n                    },\n                    \"media-ywa-tracking\": {\n                        path: \"os/mit/media/p/common/ywa-tracking-min-1234794.js\"\n                    },\n                    \"media-content-navigation-desktop\": {\n                        path: \"os/mit/media/m/navigation/content-navigation-desktop-min-1318647.js\"\n                    },\n                    \"media-footer\": {\n                        path: \"os/mit/media/m/footer/footer-min-923366.js\"\n                    }\n                },\n                combine: true,\n                filter: \"min\",\n                root: \"/\"\n            }\n        },\n        modules: {\n            \"media-ad-ros\": {\n                fullpath: \"http://ads.yimg.com/qq/dm/ad-ros-0.0.2.js\"\n            }\n        },\n        combine: true,\n        allowRollup: true,\n        comboBase: \"http://l.yimg.com/zz/combo?\",\n        maxURLLength: \"2000\"\n    }));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]), (\"root\"), ((\"yui:\" + (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")])) + \"/build/\")));\n    (((JSBNG_Record.get)(YMedia, (\"applyConfig\")))[(\"applyConfig\")])((((JSBNG_Record.get)(YUI, (\"YUICfg\")))[(\"YUICfg\")]));\n    ((JSBNG_Record.set)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), ((JSBNG_Record.temps.t82db36348408f66f71123524b3883492f049ea4a) = (((JSBNG_Record.get)(YUI, (\"version\")))[(\"version\")]))))[(JSBNG_Record.temps.t82db36348408f66f71123524b3883492f049ea4a)]), (\"groups\")))[(\"groups\")]), (\"gallery\")))[(\"gallery\")]), (\"root\"), \"yui:gallery-2011.04.20-13-04/build/\"));\n    (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-request-manager\", \"media-content-manager\", \"media-perf-timeable\", \"node-scroll-info\", \"event-custom\", \"media-ad-controller\", \"app-base\", \"querystring-parse\", \"media-rmp\", \"media-pane-manager\", \"node-base\", \"event-touch\", \"media-next-scroll\", \"media-next-scroll\", \"event-mouseenter\", \"media-tag-manager\", \"media-tag-manager\", \"media-content-discoverer\", \"history-base\", \"media-interest-manager\", \"io-base\", \"json-parse\", \"media-instrumentation\", \"media-content-ss-base\", \"media-content-ss-no-sv\", \"node-base\", \"event-key\", \"media-carousel\", \"base\", \"json-parse\", \"querystring-stringify\", \"media-lead\", \"media-comic\", \"autocomplete\", \"autocomplete-highlighters\", \"event-base\", \"event-custom\", \"node-core\", \"io\", \"querystring\", \"overlay\", \"json\", \"gallery-node-tokeninput\", \"querystring-stringify-simple\", \"gallery-outside-events\", \"media-content-social-base\", \"media-content-email-autocomplete\", \"media-content-social-base\", \"media-content-email-autocomplete\", \"media-content-share-buttons\", \"JSBNG__event\", \"node\", \"media-content-share-buttons-builder\", ((function() {\n        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_0_instance;\n        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_0_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_0\"))));\n        return ((JSBNG_Record.markFunction)((function(Y) {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_0\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_0_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_1_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_1_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_1\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_1\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_1_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"adController\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"AdController\")))[(\"AdController\")])({\n                        env: \"prod\",\n                        hideOnFailure: false,\n                        fetchOnPjaxOnly: true,\n                        preserveLRECContainer: false\n                    })));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_2_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_2_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_2\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_2\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_2_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"requestManager\"), (((JSBNG_Record.get)(new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"RequestManager\")))[(\"RequestManager\")])({\n                        chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")]),\n                        linkSelector: \"a:not(.no-pjax)\",\n                        unsuppBrowsers: \"\",\n                        continueOnError: \"1\",\n                        pjaxSplit: \"0\",\n                        ignoreCssErrors: \"1\"\n                    }), (\"render\")))[(\"render\")])()));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_3_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_3_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_3\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_3\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_3_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentManager\")))[(\"ContentManager\")])({\n                        nodePaths: {\n                            JSBNG__content: \"#yog-content\",\n                            navigation: \"#yog-nav .navlist\",\n                            related: \"#yog-related\",\n                            superlead: \"#yog-stage\"\n                        },\n                        transition: {\n                            style: \"fade\"\n                        }\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_4_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_4_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_4\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_4\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_4_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pagePaneManager\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"PaneManager\")))[(\"PaneManager\")])({\n                        debug: 0,\n                        grid_type: {\n                            JSBNG__content: {\n                                scroll_mode: \"bandit\"\n                            },\n                            index: {\n                                scroll_mode: \"bandit\"\n                            }\n                        },\n                        isYnet: 0\n                    })));\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_5_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_5_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_5\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_5\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_5_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"TagManager\")))[(\"TagManager\")])();\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_6_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_6_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_6\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_6\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_6_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentDiscoverer\")))[(\"ContentDiscoverer\")])({\n                        enableLightboxOnStream: \"1\"\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_7_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_7_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_7\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_7\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_7_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"InterestManager\")))[(\"InterestManager\")])({\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_8_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_8_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_8\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_8\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_8_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Instrumentation\")))[(\"Instrumentation\")])();\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_9_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_9_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_9\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_9\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_9_instance), (this), (arguments)))\n                    };\n                    (null);\n                    new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentSSNoSV\")))[(\"ContentSSNoSV\")])({\n                        chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")]),\n                        config: {\n                            modId: \"\",\n                            setupSlideshowCover: \"false\",\n                            enableCarousel: \"1\",\n                            enableEndSlideRel: \"0\",\n                            enableEndSlideMP: \"1\",\n                            strings: {\n                                more: \"more\",\n                                less: \"less\",\n                                of: \"of\"\n                            }\n                        }\n                    });\n                })));\n            })()));\n            (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_10_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_10_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_10\"))));\n                return ((JSBNG_Record.markFunction)((function() {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_10\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_10_instance), (this), (arguments)))\n                    };\n                    (null);\n                    ((JSBNG_Record.set)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"shareButtonsBuilder\"), new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentShareButtonsBuilder\")))[(\"ContentShareButtonsBuilder\")])({\n                        modNode: \"\",\n                        switches: {\n                            mtf: true,\n                            cmt: false\n                        },\n                        loginStat: {\n                            yahoo: 0\n                        },\n                        data: {\n                            mtfRedirUrl: \"http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\"\n                        },\n                        pageData: {\n                            crumb: \"\",\n                            title: \"\",\n                            summary: \"\",\n                            thumbnail: \"\",\n                            url: \"\",\n                            locale: \"US\",\n                            prop: \"news\",\n                            content_id: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            ult__S: \"81121452\",\n                            ult_ct: \"\",\n                            ult_pkg: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            ult_test: null,\n                            ult_csrcpvid: \"Fkgif86.K_zWN_2H3UgvxgAdDLU3OFHdq5cAACBD\",\n                            ult_sec: \"mit_share\",\n                            ult_slk: \"mail\",\n                            ult_mpos: 1,\n                            ult_lang: \"en-US\",\n                            ult_act: \"mail\",\n                            ult_pstaid: \"5f01278b-803a-3803-9798-7fc79bab4f7d\"\n                        },\n                        contentMetaData: {\n                            id: \"5f01278b-803a-3803-9798-7fc79bab4f7d\",\n                            url_orig: \"\",\n                            title_orig: \"\",\n                            summary: \"\",\n                            type: \"homepage\"\n                        },\n                        config: {\n                            site: \"news\",\n                            lang: \"en-US\",\n                            region: \"US\",\n                            scrumb: false\n                        },\n                        template: \"\\u003Cdiv class=\\\"yom-share-btns-container light\\\"\\u003E\\u000a    \\u003Cdiv class=\\\"share-btns\\\" role=\\\"menu\\\"\\u003E\\u000a        \\u003Cdiv class=\\\"share-btns-wrap\\\"\\u003E\\u000a            \\u003Cdiv class=\\\"share-btn-wrap\\\"\\u003E\\u000a                \\u003Cul\\u003E\\u003Cli class=\\\"share-btn facebook\\\"\\u003E\\u000a                        \\u003Ca href=\\\"http://www.facebook.com/dialog/feed?app_id=90376669494&amp;redirect_uri=http://news.yahoo.com/_xhr/mediacontentsharebuttons/postshare/?src=fb&amp;link=http://news.yahoo.com/&amp;picture=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png&amp;display=popup&amp;show_error=yes\\\" role=\\\"link\\\" title=\\\"share\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-fb;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-fb\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E0\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn twitter\\\"\\u003E\\u000a                        \\u003Ca href=\\\"https://twitter.com/share?text=Yahoo%21%20News%20-%20Latest%20News%20%26%20Headlines&amp;url=http://news.yahoo.com/&amp;via=YahooNews\\\" role=\\\"link\\\" title=\\\"tweet\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-tw;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-tw\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E0\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn tumblr\\\"\\u003E\\u000a                        \\u003Ca href=\\\"http://www.tumblr.com/share/link?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&name=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines\\\" role=\\\"link\\\" title=\\\"tumblr\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-tu;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-tu\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn pinterest\\\"\\u003E\\u000a                        \\u003Ca href=\\\"http://pinterest.com/pin/create/button/?url=http%3A%2F%2Fnews.yahoo.com%2F&description=The%20latest%20news%20and%20headlines%20from%20Yahoo%21%20News.%20Get%20breaking%20news%20stories%20and%20in-depth%20coverage%20with%20videos%20and%20photos.&media=http://l2.yimg.com/bt/api/res/1.2/BvlRk2eMuZ5S5ZVts0i.Uw--/YXBwaWQ9eW5ld3M7cT04NTt3PTYwMA--/http://l.yimg.com/os/publish-images/news/2013-03-19/528dd2af-804a-4db8-b6eb-53b18b9b0592_ybang_225x225.png\\\" role=\\\"link\\\" title=\\\"pinterest\\\" target=\\\"_blank\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-pin;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-pin\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u003Cli class=\\\"share-btn mail email\\\"\\u003E\\u000a                        \\u003Ca href=\\\"mailto:?subject=Yahoo%21%20News%20-%20Latest%20News%20%26amp%3B%20Headlines&amp;body=http%3A%2F%2Fnews.yahoo.com%2F\\\" role=\\\"link\\\" title=\\\"email\\\" data-ylk=\\\"sec:mod-sh-b;slk:btn-sh-ma;itc:1;test:;\\\" data-action-outcome=\\\"share\\\"\\u003E\\u003Cspan class=\\\"btn-icon btn-mail\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"btn-count hide\\\"\\u003E0\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/li\\u003E\\u000a                \\u003C/ul\\u003E\\u000a            \\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"clearfix\\\"\\u003E\\u003C/div\\u003E\\u000a        \\u003C/div\\u003E\\u000a    \\u003C/div\\u003E\\u000a    \\u003Cdiv class=\\\"share-btns-overlay-screen hide\\\"\\u003E\\u003C/div\\u003E\\u000a    \\u003Cdiv class=\\\"share-btns-overlay hide\\\"\\u003E\\u000a        \\u003Cdiv class=\\\"yui3-widget-hd\\\"\\u003E\\u000a            \\u003Cdiv class=\\\"close-btn\\\" role=\\\"button\\\"\\u003E&times;\\u003C/div\\u003E\\u000a        \\u003C/div\\u003E\\u000a        \\u003Cdiv class=\\\"yui3-widget-bd\\\"\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide mail-login\\\" role=\\\"dialog\\\" aria-labelledby=\\\"Sign in to share this by email\\\"\\u003E\\u000a                \\u003Ch3 class=\\\"header\\\"\\u003ESign in to share this by email\\u003C/h3\\u003E\\u000a                \\u003Cdiv class=\\\"login-btns\\\"\\u003E\\u000a                    \\u003Cdiv class=\\\"login-link\\\"\\u003E\\u000a                        \\u003Ca class=\\\"login-btn yahoo\\\" role=\\\"link\\\" href=\\\"https://login.yahoo.com/config/login_verify2?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail&amp;.src=mtf\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"login-icon yahoo\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"login-text\\\"\\u003EYahoo!\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"login-link\\\"\\u003E\\u000a                        \\u003Ca class=\\\"login-btn facebook\\\" role=\\\"link\\\" href=\\\"https://open.login.yahoo.com/openid/yrp/signin?.intl=us&amp;idp=facebook&amp;.done=http://news.yahoo.com/%23mtf-overlay&amp;ts=1373481879&amp;.src=home&amp;appid=90376669494&amp;spid=b9ed13cc-ddec-11de-9c83-001b784d35e1&amp;perms=email,user_birthday,user_education_history,user_likes,user_location,user_relationships,user_subscriptions,user_work_history,friends_birthday,friends_education_history,friends_likes,friends_location,friends_work_history,publish_actions&amp;fbflow=1\\\" target=\\\"_blank\\\"\\u003E\\u003Cspan class=\\\"login-icon facebook\\\"\\u003E\\u003C/span\\u003E\\u003Cspan class=\\\"login-text\\\"\\u003EFacebook\\u003C/span\\u003E\\u003C/a\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                \\u003C/div\\u003E\\u000a                \\u003Cp\\u003ENew here? \\u003Ca href=\\\"https://edit.yahoo.com/config/eval_register?.done=http%3A%2F%2Fnews.yahoo.com%2F_xhr%2Fmediacontentsharebuttons%2Fpostshare%2F%3Fsrc%3Dmail\\\" target=\\\"_blank\\\" class=\\\"signup\\\"\\u003ESign up.\\u003C/a\\u003E\\u003C/p\\u003E\\u000a            \\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide mail-form\\\" role=\\\"dialog\\\" aria-labelledby=\\\"Email this\\\"\\u003E\\u000a                \\u003Ch3 class=\\\"header\\\"\\u003EEmail this\\u003C/h3\\u003E\\u000a                \\u003Cdiv class=\\\"form\\\"\\u003E\\u000a                    \\u003Cdiv class=\\\"form-input\\\"\\u003E\\u000a                        \\u003Clabel for=\\\"semail\\\"\\u003EFrom\\u003C/label\\u003E\\u003Cselect id=\\\"semail\\\" class=\\\"mail-input\\\" role=\\\"menu\\\" disabled\\u003E\\u003Coption role=\\\"menuitem\\\"\\u003ELoading...\\u003C/option\\u003E\\u003C/select\\u003E\\u000a                        \\u003Cdiv class=\\\"yom-mtf-semail-error icon-alert-small yui3-widget-hidden\\\"\\u003EPlease enter a valid email address\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"form-input\\\"\\u003E\\u000a                        \\u003Clabel for=\\\"remail\\\"\\u003ETo\\u003C/label\\u003E\\u003Cinput id=\\\"remail\\\" class=\\\"mail-input\\\" role=\\\"textbox\\\" disabled\\u003E\\u000a                        \\u003Cdiv class=\\\"yom-mtf-remail-error icon-alert-small yui3-widget-hidden\\\"\\u003EPlease enter valid email addresses, separated by commas\\u003C/div\\u003E\\u000a                        \\u003Cdiv class=\\\"yom-mtf-remail-max-error icon-alert-small yui3-widget-hidden\\\"\\u003EMaximum 200 character limit exceeded\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"form-input fb-import\\\"\\u003E\\u000a                        \\u003Clabel\\u003E&nbsp;\\u003C/label\\u003E\\u003Cspan\\u003EDon't see your Facebook contacts? \\u003Ca href=\\\"http://address.yahoo.com/?_src=neo&VPC=tools_import&.done=http://www.yahoo.com\\\" role=\\\"link\\\" target=\\\"_blank\\\" class=\\\"import\\\"\\u003EImport them\\u003C/a\\u003E\\u003C/span\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv\\u003E\\u000a                        \\u003Ctextarea placeholder=\\\"Write a message\\\" class=\\\"mail-text\\\" role=\\\"textbox\\\" aria-multiline=\\\"true\\\"\\u003E\\u003C/textarea\\u003E \\u000a                        \\u003Cdiv class=\\\"yom-mtf-pmesg-error icon-alert-small yui3-widget-hidden\\\"\\u003EPlease enter a message\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"mail-article\\\"\\u003E\\u000a                        \\u003Cdiv class=\\\"article thumbnail\\\"\\u003E\\u000a                            \\u003Cimg title=\\\"Yahoo! News - Latest News &amp;amp; Headlines\\\"\\u003E\\u000a                        \\u003C/div\\u003E\\u000a                        \\u003Cdiv class=\\\"article\\\"\\u003E\\u000a                            \\u003Cdiv class=\\\"title\\\"\\u003EYahoo! News - Latest News &amp;amp; Headlines\\u003C/div\\u003E\\u000a                            \\u003Cdiv class=\\\"description\\\"\\u003EThe latest news and headlines from Yahoo! News. Get breaking news stories and in-depth coverage with videos and photos.\\u003C/div\\u003E\\u000a                        \\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                    \\u003Cdiv class=\\\"mail-submit\\\"\\u003E\\u000a                        \\u003Cinput type=\\\"checkbox\\\" id=\\\"cc-self\\\" role=\\\"checkbox\\\"\\u003E\\u003Clabel for=\\\"cc-self\\\" class=\\\"cc-self\\\"\\u003ESend me a copy of this email\\u003C/label\\u003E\\u000a                        \\u003Cdiv class=\\\"submit-btns\\\"\\u003E\\u000a                            \\u003Cbutton class=\\\"mail-btn send\\\" role=\\\"button\\\" disabled\\u003ESend\\u003C/button\\u003E\\u000a                            \\u003Cbutton class=\\\"mail-btn close-btn\\\" role=\\\"button\\\"\\u003ECancel\\u003C/button\\u003E\\u000a                        \\u003C/div\\u003E\\u000a                        \\u003Cdiv class=\\\"clearfix\\\"\\u003E\\u003C/div\\u003E\\u000a                    \\u003C/div\\u003E\\u000a                \\u003C/div\\u003E\\u000a            \\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide facebook\\\" role=\\\"dialog\\\" aria-labelledby=\\\"facebook\\\"\\u003Efacebook\\u003C/div\\u003E\\u000a            \\u003Cdiv class=\\\"speedbump hide twitter\\\" role=\\\"dialog\\\" aria-labelledby=\\\"twitter\\\"\\u003Etwitter\\u003C/div\\u003E\\u000a        \\u003C/div\\u003E\\u000a        \\u003Cdiv class=\\\"yui3-widget-ft\\\"\\u003E\\u003C/div\\u003E\\u000a    \\u003C/div\\u003E\\u000a\\u003C/div\\u003E\\u000a\"\n                    })));\n                })));\n            })()));\n        })));\n    })()));\n    (((JSBNG_Record.get)((((JSBNG_Record.get)(YUI, (\"Env\")))[(\"Env\")]), (\"add\")))[(\"add\")])(window, \"load\", ((function() {\n        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_11_instance;\n        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_11_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_11\"))));\n        return ((JSBNG_Record.markFunction)((function() {\n            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_11\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_11_instance), (this), (arguments)))\n            };\n            (null);\n            (((JSBNG_Record.get)(YMedia, (\"use\")))[(\"use\")])(\"media-rmp\", \"media-bc\", \"media-beacon-manager\", \"event-custom\", \"handlebars\", \"node-base\", \"media-nav-addon\", \"node-core\", \"node-data\", \"event-base\", \"node-event-delegate\", \"event-delegate\", \"event-tap\", \"media-tag-manager\", \"media-recommend\", \"media-personal-nav\", \"cookie\", \"querystring-parse\", \"media-strip\", \"media-trfsm\", \"base\", \"jsonp\", \"media-i13n\", \"media-ywa-tracking\", \"media-content-navigation-desktop\", \"overlay\", \"media-ad-ros\", \"media-footer\", ((function() {\n                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_12_instance;\n                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_12_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_12\"))));\n                return ((JSBNG_Record.markFunction)((function(Y) {\n                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_12\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_12_instance), (this), (arguments)))\n                    };\n                    (null);\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_13_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_13_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_13\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_13\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_13_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Array\")))[(\"Array\")]), (\"each\")))[(\"each\")])((((JSBNG_Record.get)(YMedia, (\"includes\")))[(\"includes\")]), ((function() {\n                                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_14_instance;\n                                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_14_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_14\"))));\n                                return ((JSBNG_Record.markFunction)((function(inc, i, ar) {\n                                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_14\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_14_instance), (this), (arguments)))\n                                    };\n                                    (null);\n                                    if ((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Lang\")))[(\"Lang\")]), (\"isFunction\")))[(\"isFunction\")])(inc)) {\n                                        inc(Y);\n                                        ((JSBNG_Record.set)(ar, i, null));\n                                    }\n                                    ;\n                                })));\n                            })()));\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_15_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_15_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_15\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_15\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_15_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"BeaconManager\")))[(\"BeaconManager\")])({\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_16_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_16_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_16\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_16\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_16_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"NavAddon\")))[(\"NavAddon\")])({\n                                max: \"3\",\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_17_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_17_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_17\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_17\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_17_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Recommend\")))[(\"Recommend\")])({\n                                header: \"Recommended\",\n                                position: 1,\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_18_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_18_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_18\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_18\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_18_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"PersonalNav\")))[(\"PersonalNav\")])({\n                                header: \"My Topics\",\n                                position: 2\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_19_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_19_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_19\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_19\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_19_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Global\")))[(\"Global\")]), (\"Media\")))[(\"Media\")]), (\"ILBoot\")))[(\"ILBoot\")]), (\"initImageLoader\")))[(\"initImageLoader\")])(true);\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_20_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_20_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_20\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_20\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_20_instance), (this), (arguments)))\n                            };\n                            (null);\n                            ((function() {\n                                var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_21_instance;\n                                ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_21_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_21\"))));\n                                return ((JSBNG_Record.markFunction)((function() {\n                                    if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                        return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_21\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_21_instance), (this), (arguments)))\n                                    };\n                                    (null);\n                                    var configUrl = \"http://l.yimg.com/os/assets/globalmedia/traffic/traffic-simulation.js\", simulator = new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"TrafficSimulator\")))[(\"TrafficSimulator\")])({\n                                        dataUrl: configUrl\n                                    });\n                                    (((JSBNG_Record.get)(simulator, (\"load\")))[(\"load\")])();\n                                })));\n                            })())();\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_22_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_22_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_22\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_22\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_22_instance), (this), (arguments)))\n                            };\n                            (null);\n                            try {\n                                (((JSBNG_Record.get)(YMEDIA_REQ_ATTR, (\"csbeacon\")))[(\"csbeacon\")])();\n                            } catch (e) {\n                            \n                            };\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_23_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_23_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_23\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_23\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_23_instance), (this), (arguments)))\n                            };\n                            (null);\n                            new (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"ContentNavigation\")))[(\"ContentNavigation\")])({\n                                config: {\n                                    modId: \"mediacontentnavigation\"\n                                },\n                                chrome: (((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"pageChrome\")))[(\"pageChrome\")])\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_24_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_24_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_24\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_24\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_24_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Lead\")))[(\"Lead\")]), (\"MediaContentLead\")))[(\"MediaContentLead\")]), (\"init\")))[(\"init\")])({\n                                cat: \"\",\n                                catName: \"\",\n                                \"listid \": \"\"\n                            });\n                        })));\n                    })()));\n                    (((JSBNG_Record.get)(Y, (\"later\")))[(\"later\")])(10, this, ((function() {\n                        var s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_25_instance;\n                        ((s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_25_instance) = ((JSBNG_Record.eventInstance)((\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_25\"))));\n                        return ((JSBNG_Record.markFunction)((function() {\n                            if ((!(JSBNG_Record.top.JSBNG_Record.callerJS))) {\n                                return ((JSBNG_Record.eventCall)((arguments.callee), (\"s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_25\"), (s9cc82fe9c8ae83cdd8e042b2a17e3db62ad81e46_25_instance), (this), (arguments)))\n                            };\n                            (null);\n                            (((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)((((JSBNG_Record.get)(Y, (\"Media\")))[(\"Media\")]), (\"Comic\")))[(\"Comic\")]), (\"MediaContentComic\")))[(\"MediaContentComic\")]), (\"init\")))[(\"init\")])({\n                                meta: {\n                                    error: {\n                                        error_code: 0\n                                    },\n                                    mod_id: \"mediacontentcomic\",\n                                    bucket: null,\n                                    selected_list: \"702ab4a0-145a-3b69-9a83-aed16a8a024a\",\n                                    selected_name: \"Garfield\",\n                                    abbreviation: \"ga\",\n                                    max_result_count: 14,\n                                    start: 0,\n                                    count: 14,\n                                    total: 100,\n                                    alias: \"/comics/garfield-slideshow/\",\n                                    enableLightBox: 0\n                                },\n                                data: {\n                                    \"702ab4a0-145a-3b69-9a83-aed16a8a024a\": [{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/HsOPI8Hi4Dd406_Wcx_Rxg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130710.gif\",\n                                        rsrc: \"http://l.yimg.com/bt/api/res/1.2/LevQzAit8GjQB95PNqJEaw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130710.gif\",\n                                        sdate: \"Wed, Jul 10\",\n                                        date: \"Wednesday, July 10\"\n                                    },{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/VN4cfbpPnSeuIK4yYivb4w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130709.gif\",\n                                        rsrc: \"http://l3.yimg.com/bt/api/res/1.2/bpLDYA30ACFFXoRNYNwOzw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130709.gif\",\n                                        sdate: \"Tue, Jul 9\",\n                                        date: \"Tuesday, July 9\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/mped5Y9s0mK8FAHrPujA8w--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130708.gif\",\n                                        rsrc: \"http://l.yimg.com/bt/api/res/1.2/GWRrlT1mkKyKSo3T36FvoA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130708.gif\",\n                                        sdate: \"Mon, Jul 8\",\n                                        date: \"Monday, July 8\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/WB0QMhcgw.BXIkfaporMqA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTQyMjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130707.jpg\",\n                                        rsrc: \"http://l2.yimg.com/bt/api/res/1.2/BM1MIhbEweFIHdwhJ2lPig--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI1NjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130707.jpg\",\n                                        sdate: \"Sun, Jul 7\",\n                                        date: \"Sunday, July 7\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/7nRIEPtGF33YIyyvamLXqw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130706.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/DMEXHwbV6UJKG1heyjauvg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130706.gif\",\n                                        sdate: \"Sat, Jul 6\",\n                                        date: \"Saturday, July 6\"\n                                    },{\n                                        src: \"http://l3.yimg.com/bt/api/res/1.2/CNxK8MQxW4nxW8I5IsmIYg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130705.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/q0Vkxe8Kb24vWNdgV7QMUg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130705.gif\",\n                                        sdate: \"Fri, Jul 5\",\n                                        date: \"Friday, July 5\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/5pPWSABPZX8jN5acXOtEyg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130704.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/pqQZdsB46tLgoPYhBqIeAg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130704.gif\",\n                                        sdate: \"Thu, Jul 4\",\n                                        date: \"Thursday, July 4\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/QhzkGUnNNXKC86F.GdSVqQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130703.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/FjfxEkaUGBLkUZYbI1vYJw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130703.gif\",\n                                        sdate: \"Wed, Jul 3\",\n                                        date: \"Wednesday, July 3\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/0y_GF1XQ6snde6Ul04By5Q--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130702.gif\",\n                                        rsrc: \"http://l2.yimg.com/bt/api/res/1.2/1F2l41IfvFh_9g7.et7HCw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130702.gif\",\n                                        sdate: \"Tue, Jul 2\",\n                                        date: \"Tuesday, July 2\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/thoi55aGBZ7jd2WyWaODMQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130701.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/RYmZMKrrAuSnVdcspOftIQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130701.gif\",\n                                        sdate: \"Mon, Jul 1\",\n                                        date: \"Monday, July 1\"\n                                    },{\n                                        src: \"http://l.yimg.com/bt/api/res/1.2/8YJYSVXxS8rIAkX8N.jHPQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTQyMjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130630.jpg\",\n                                        rsrc: \"http://l3.yimg.com/bt/api/res/1.2/XlqV4JwM6sXvCRNBBAYWGA--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTI1NjtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130630.jpg\",\n                                        sdate: \"Sun, Jun 30\",\n                                        date: \"Sunday, June 30\"\n                                    },{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/Q45WeuPPsTXQBY5JkjItTQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130629.gif\",\n                                        rsrc: \"http://l3.yimg.com/bt/api/res/1.2/worLLaS5MHzh7bqdSBJcWQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130629.gif\",\n                                        sdate: \"Sat, Jun 29\",\n                                        date: \"Saturday, June 29\"\n                                    },{\n                                        src: \"http://l1.yimg.com/bt/api/res/1.2/vd2Wbq3pmN83mgApyCkzPg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130628.gif\",\n                                        rsrc: \"http://l1.yimg.com/bt/api/res/1.2/WOtPpC4WYiihGmOfwtvWGw--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130628.gif\",\n                                        sdate: \"Fri, Jun 28\",\n                                        date: \"Friday, June 28\"\n                                    },{\n                                        src: \"http://l2.yimg.com/bt/api/res/1.2/nHP31hF.HuDAjBhW.ht1aQ--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTE3MjtweW9mZj0wO3E9ODU7dz02MDA-/http://media.zenfs.com/en_us/News/ucomics.com/ga130627.gif\",\n                                        rsrc: \"http://l.yimg.com/bt/api/res/1.2/9ZkS9kySryvffth5Wp2Phg--/YXBwaWQ9eW5ld3M7Zmk9ZmlsbDtoPTEwNDtweW9mZj0wO3E9ODU7dz0zNjQ-/http://media.zenfs.com/en_us/News/ucomics.com/ga130627.gif\",\n                                        sdate: \"Thu, Jun 27\",\n                                        date: \"Thursday, June 27\"\n                                    },]\n             