#!/bin/bash


files=('*.o' '*.a' '*.lo' '*.la' 'Makefile' 'Makefile.in' '*.gcda' '*.gcno' 'stamp-h1' 'aclocal.m4' 'config.*' 'configure' 'libtool' 'doxygen_log.txt')


for file in "${files[@]}"
do
    find . -type f -name "$file" | xargs rm -f
done


dirs=('build' '.deps' '.libs' 'm4' 'autom4te.cache')

for mydir in "${dirs[@]}"
do
    find . -type d -name "$mydir" | xargs rm -rf
done


# Delete binary
rm -rf src/sdvAgent

# Delete test binary
rm -rf test/sdvagent_test

# special cases that were easier to do seprate...
rm -rf lib/gmock/gtest/lib/
rm -rf lib/gmock/lib/

