/*
 *  IARMProxyService.cpp
 *
 *  Created on: Jun 2, 2014
 *      Author: jasbedar
 */

#include "IARMProxyService.h"
#include <assert.h>

using namespace sdv;


IARMProxyService::RPC_MAP IARMProxyService::rpcMap;		//!> define static map
pthread_mutex_t IARMProxyService::mapLock;				//!< mutex for accessing map data



SDVService::SERVICE_RESULT sdv::IARMProxyService::start(){
	Log::log("[IARMProxyService] start()\n");
    
	if(IARM_Bus_RegisterEvent(SDVAGENT_EVENT_MAX) != IARM_RESULT_SUCCESS) {
		Log::log("[IARMProxyService] failed to register IARM_BUS event\n");
		return SDVService::FAILURE;
	}

	assert(pthread_mutex_init(&mapLock, NULL) == 0);

	return SDVService::SUCCESS;
}

void* IARMProxyService::getRpcObject(const char* rpcName) {
	void* rval;

	pthread_mutex_lock(&mapLock);
	RPC_MAP::iterator iter = rpcMap.find(rpcName);
	assert(iter != rpcMap.end());
	rval = iter->second;
	pthread_mutex_unlock(&mapLock);

	return rval;
}

IARM_Result_t IARMProxyService::registerIARMRPC(const char* rpcName, IARM_BusCall_t rpcFunction){
    IARM_Result_t result = IARM_Bus_RegisterCall(rpcName, rpcFunction);

    return result;
}

IARM_Result_t IARMProxyService::registerIARMRPC(const char* rpcName, IARM_BusCall_t rpcFunction, void* rpcObject){
	pthread_mutex_lock(&mapLock);
	rpcMap[rpcName] = rpcObject;
	pthread_mutex_unlock(&mapLock);
    IARM_Result_t result = IARM_Bus_RegisterCall(rpcName, rpcFunction);
    std::cout << "[IARMProxyService] registerIARMRPC(): registered " << rpcName << std::endl;
    
    return result;
}

void IARMProxyService::addEventHandler(const char *owner, IARM_EventId_t eventId, IARMProxyEventHander_t eventHandler ){
    std::cout << "[IARMProxyService] _handler_Event(): owner: " << owner << " eventId: " << eventId << std::endl;
}

void IARMProxyService::_handler_Event(const char *owner, IARM_EventId_t eventId, void *data, size_t len){
    std::cout << "[IARMProxyService] _handler_Event(): owner: " << owner << " eventId: " << eventId << std::endl;
}

SDVService::SERVICE_RESULT IARMProxyService::stop(){
	Log::log("[IARMProxyService] stop()\n");
	pthread_mutex_destroy(&mapLock);

	return SDVService::SUCCESS;
}

IARMProxyService::~IARMProxyService(){
	Log::log("[IARMProxyService] destroyed()\n");
}
