/*
 * EventIndication.cpp
 *
 */

#include <assert.h>
#include <netinet/in.h>

#include "EventIndication.h"


using namespace sdv;



EventIndication::EventIndication(uint8_t* buffer) : SDVMessage((CCMIS_HEADER*)buffer) {
	CCMIS_EVENT_INDICATION* payload = (CCMIS_EVENT_INDICATION*)buffer;
	source_id = ntohl(payload->source_id);
	attribute_tag = (ATTRIBUTE_TAG)payload->attribute_tag;
}


EventIndication::EventIndication(uint8_t* macAddress, uint8_t tunerIndex, uint32_t sourceId, uint8_t tunerUse) :
	SDVMessage(macAddress, SDVMessage::EventIndication, tunerIndex, PAYLOAD_LENGTH) {
	tuner_use = tunerUse;
	source_id = sourceId;
	attribute_tag = TUNER_USE;
}

EventIndication::ATTRIBUTE_TAG EventIndication::getAttributeType() {
	return attribute_tag;
}

uint32_t EventIndication::getSourceId() {
	return source_id;
}

size_t EventIndication::serialize(uint8_t* emptyBuff, size_t buffLength) {
	assert(buffLength >= sizeof(struct ccmis_event_indication));

	// Serialize Header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set Payload fields in buffer
	CCMIS_EVENT_INDICATION* payload = (CCMIS_EVENT_INDICATION *) emptyBuff;
	payload->source_id = htonl(source_id);
	payload->private_data_length = htons(PRIVATE_DATA_LENGTH);
	payload->attribute_tag = (uint8_t)attribute_tag;
	payload->attribute_length = ATTRIBUTE_LENGTH;
	payload->attribute_data.tuner_use.bit_flags = tuner_use;

	return sizeof(struct ccmis_event_indication);
}

