/**
* @file InitConfirm.cpp
*
* @brief Function implementations for InitConfirm class
*
*/
#include <netinet/in.h>

#include "InitConfirm.h"


namespace sdv {

InitConfirm::InitConfirm(uint8_t* buffer) : SDVMessage((CCMIS_HEADER*)buffer) {

	CCMIS_INIT_CONFIRM* payload = (CCMIS_INIT_CONFIRM*)buffer;
	response = ntohs(payload->response);
}

uint16_t InitConfirm::getResponseCode() {
	return response;
}

} // sdv namespace



