/*
 * InitConfirm.h
 *
 *  Created on: Jun 25, 2014
 *      Author: ktaubing
 */
/**
 * @file SDVMessage.h
 * @Author ktaubing (ktaubing@cisco.com)
 * @Date Jun 23 2014
 *
 * @brief Definition Of InitConfirm Message
 *
 * Init Confirm messages are inbound messages from the SDV Server in
 * response to an InitRequest.  The confirm message both lets the server
 * know the client device is online as well as tells the client it is
 * in the correct service group.
 */
#ifndef INITCONFIRM_H_
#define INITCONFIRM_H_

#include "SDVMessage.h"

namespace sdv {

/**
 * @class InitConfirm
 * @brief CCMIS InitConfirm class definition
 *
 * @details Defines CCMIS InitConfirm inbound message.
 */
class InitConfirm : public SDVMessage {
public:
    /**
   * @struct ResponseCode
   *
   * @brief Enumeration of SDV Message Responses
   *
   * Inbound SDVMessages will have one of these response codes.
   */
    enum ResponseCode { RspOK = 0x0000,
        RspFormatError = 0x0001,
        RspInvalidSG = 0x8001,
        RspSvrCapacityExceeded = 0x8005,
        RspVerNotSupported = 0x8007,
        RspUnkownError = 0x80FF
    };
public:

	/**
	 * @constructor
	 * @brief Constructor to create an InitConfirm SDV message from the specified raw data.
	 *
	 * @param buffer [i] raw data received from SDV Server
	 */
	InitConfirm(uint8_t* buffer);

	/**
	 * @fn getResponseCode
	 * @brief Get the response code in this message, values defined in CCMIS 3.14
	 *
	 * @return response code
	 */
	uint16_t getResponseCode();


private:

	/**
	 * @struct ccmis_init_confirm
	 * @brief Data structure of CCMIS InitConfirm that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_init_confirm {
		struct ccmis_header header;
		uint16_t response;
	} CCMIS_INIT_CONFIRM;
#pragma pack(pop)

	uint16_t response;
};

} // sdv namespace

#endif /* INITCONFIRM_H_ */
