/**
* @file InitRequest.cpp
*
* @brief Function implementations for InitRequest class
*
*/
#include <assert.h>
#include <netinet/in.h>

#include "InitRequest.h"


namespace sdv {

InitRequest::InitRequest(uint8_t* macAddress, uint32_t serviceGroupId) :
		SDVMessage(macAddress, SDVMessage::InitRequest, INIT_REQUEST_TUNER_INDEX, PAYLOAD_LENGTH) {
	service_group_id = serviceGroupId;
}

size_t InitRequest::serialize(uint8_t* emptyBuff, size_t buffLength) {

	assert(buffLength >= sizeof(struct ccmis_init_request));

	// Serialize header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set payload fields in buffer
	CCMIS_INIT_REQUEST* payload = (CCMIS_INIT_REQUEST *) emptyBuff;
	payload->service_group_id = htonl(service_group_id);
	payload->num_desc = 0x0000;
	payload->version = CLIENT_VERSION;

	return sizeof(struct ccmis_init_request);
}

}


