/**
* @file ProgramSelectConfirm.cpp
*
* @brief Function implementations for ProgramSelectConfirm class
*
*/
#include <netinet/in.h>

#include "ProgramSelectConfirm.h"


namespace sdv {

ProgramSelectConfirm::ProgramSelectConfirm(uint8_t* buffer) : SDVMessage((CCMIS_HEADER*)buffer) {

	CCMIS_PROGRAM_SELECT_CONFIRM* payload = (CCMIS_PROGRAM_SELECT_CONFIRM*)buffer;

	response = (SDVAGENT_PROGRAM_SELECT_STATUS)ntohs(payload->response);
	source_id = ntohl(payload->source_id);
	modulation_format = payload->modulation_format;
	tuning_frequency = ntohl(payload->tuning_frequency);
	mpeg_program_number = ntohs(payload->mpeg_program_number);
}

SDVAGENT_PROGRAM_SELECT_STATUS ProgramSelectConfirm::getResponseCode() {
	return response;
}

uint32_t ProgramSelectConfirm::getSourceId() {
	return source_id;
}

uint8_t ProgramSelectConfirm::getModulation() {
	return modulation_format;
}

uint32_t ProgramSelectConfirm::getFrequency() {
	return tuning_frequency;
}

uint16_t ProgramSelectConfirm::getMpegProgramNumber() {
	return mpeg_program_number;
}

} // namespace sdv


