/*
 * ProgramSelectIndication.cpp
 *
 */

#include <netinet/in.h>
#include "ProgramSelectIndication.h"



using namespace sdv;


ProgramSelectIndication::ProgramSelectIndication(uint8_t* buffer) : SDVMessage((CCMIS_HEADER*)buffer) {
	CCMIS_PROGRAM_SELECT_INDICATION* payload = (CCMIS_PROGRAM_SELECT_INDICATION*)buffer;

	reason = ntohs(payload->reason);
	source_id = ntohl(payload->source_id);
	modulation_format = payload->modulation_format;
	tuning_frequency = ntohl(payload->tuning_frequency);
	mpeg_program_number = ntohs(payload->mpeg_program_number);
	current_source_id = ntohl(payload->current_source_id);
}


uint16_t ProgramSelectIndication::getReason() {
	return reason;
}

uint32_t ProgramSelectIndication::getSourceId() {
	return source_id;
}

uint8_t ProgramSelectIndication::getModulation() {
	return modulation_format;
}

uint32_t ProgramSelectIndication::getFrequency() {
	return tuning_frequency;
}

uint16_t ProgramSelectIndication::getMpegProgramNumber() {
	return mpeg_program_number;
}

uint32_t ProgramSelectIndication::getCurrentSourceId() {
	return current_source_id;
}
