/**
* @file ProgramSelectRequest.cpp
*
* @brief Function implementations for ProgramSelectRequest class
*
*/
#include <assert.h>
#include <netinet/in.h>

#include "ProgramSelectRequest.h"


namespace sdv {

ProgramSelectRequest::ProgramSelectRequest(uint8_t* macAddress, uint8_t tunerIndex, uint8_t tunerUse,
		uint8_t retryCount, uint32_t sourceId, uint32_t serviceGroupId) :
		SDVMessage(macAddress, SDVMessage::ProgramSelectRequest, tunerIndex, PAYLOAD_LENGTH) {
	tuner_use = tunerUse;
	retry_count = retryCount;
	source_id = sourceId;
	service_group_id = serviceGroupId;
}

size_t ProgramSelectRequest::serialize(uint8_t* emptyBuff, size_t buffLength) {
	assert(buffLength >= sizeof(struct ccmis_program_select_request));

	// Serialize Header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set Payload fields in buffer
	CCMIS_PROGRAM_SELECT_REQUEST* payload = (CCMIS_PROGRAM_SELECT_REQUEST *) emptyBuff;
	payload->retry_count = retry_count;
	payload->source_id = htonl(source_id);
	payload->tuner_use = tuner_use;
	payload->service_group_id = htonl(service_group_id);
	payload->private_data_len = htons(PRIVATE_DATA_LENGTH);


	return sizeof(struct ccmis_program_select_request);
}

} // sdv namespace
