/**
 * @file ProgramSelectResponse.h
 *
 */

#ifndef PROGRAMSELECTRESPONSE_H_
#define PROGRAMSELECTRESPONSE_H_

#include "SDVMessage.h"

namespace sdv {



/**
 * @class ProgramSelectResponse
 * @brief CCMIS ProgramSelectResponse class definition
 *
 * @details Defines CCMIS ProgramSelectResponse outbound message.
 */
class ProgramSelectResponse : public SDVMessage {

public:

	/**
	 * @def RESPONSE_xx
	 * @brief Response codes; values defined in CCMIS 3.14
	 */
	#define RESPONSE_rspOk 			0x0000
	#define RESPONSE_rspFormatError 0x0001
	#define RESPONSE_rspNoSession	0x0002

	/**
	 * @constructor
	 * @brief Constructor to create an ProgramSelectResponse SDV message using the specified parameters.
	 *
	 * @param [in] macAddress
	 * @param [in] tunerIndex
	 * @param [in] response
	 * @param [in] transaction ID
	 */
	ProgramSelectResponse(uint8_t* macAddress, uint8_t tunerIndex, uint16_t response, uint32_t transactionId);

	/**
	 * @fn serialize
	 * @brief Serialize this message into the specified empty buffer.
	 * The serialized data will be ready for UDP transmission to the SDV Server.
	 *
	 * @param [out] emptyBuff - empty buffer to store serialized message
	 * @param [in] maxBuffLength - maximum length of empty buffer in bytes
	 * @return length of serialized message in bytes
	 */
	size_t serialize(uint8_t* emptyBuff, size_t buffLength);


private:

	/**
	 * @struct ccmis_program_select_response
	 * @brief Data structure of CCMIS ProgramSelectResponse that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_program_select_response {
		struct ccmis_header header;
		uint16_t response;
		uint16_t private_data_len;
	} CCMIS_PROGRAM_SELECT_RESPONSE;
#pragma pack(pop)


	static const uint16_t PAYLOAD_LENGTH = sizeof(struct ccmis_program_select_response) - sizeof(struct ccmis_header); //!> excludes session ID
	static const uint16_t PRIVATE_DATA_LENGTH = 0x0000;

	uint16_t response;
};

} /* namespace sdv */

#endif /* PROGRAMSELECTRESPONSE_H_ */
