/*
 * UserActivityReport.cpp
 *
 */

#include <assert.h>
#include <netinet/in.h>
#include "UserActivityReport.h"


using namespace sdv;

UserActivityReport::UserActivityReport(uint8_t* macAddress,
		   	   	   	   	   	   	   	   uint8_t tunerIndex,
		   	   	   	   	   	   	   	   uint32_t sourceId,
									   uint32_t lastUserActivity) :
				SDVMessage(macAddress, SDVMessage::UserActivityReport, tunerIndex, PAYLOAD_LENGTH) {
	last_user_activity = lastUserActivity;
	source_id = sourceId;
}

size_t UserActivityReport::serialize(uint8_t* emptyBuff, size_t buffLength) {
	assert(buffLength >= sizeof(struct ccmis_user_activity_report));

	// Serialize Header fields into buffer
	SDVMessage::serialize(emptyBuff, buffLength);

	// Set Payload fields in buffer
	CCMIS_USER_ACTIVITY_REPORT* payload = (CCMIS_USER_ACTIVITY_REPORT *) emptyBuff;
	payload->reserved = 0xffff;
	payload->source_id = htonl(source_id);
	payload->last_user_activity = htonl(last_user_activity);

	return sizeof(struct ccmis_user_activity_report);
}

