/*
 * UserActivityReport.h
 *
 */

#ifndef USERACTIVITYREPORT_H_
#define USERACTIVITYREPORT_H_

#include "SDVMessage.h"



namespace sdv {

class UserActivityReport : public SDVMessage {

public:
	/**
	 * @constructor
	 * @brief Constructor to create an UserActivityReport SDV message using the specified parameters.
	 *
	 * @param [in] macAddress
	 * @param [in] tunerIndex
	 * @param [in] sourceId
	 * @param [in] lastUserActivity
	 */
	UserActivityReport(uint8_t* macAddress, uint8_t tunerIndex, uint32_t sourceId, uint32_t lastUserActivity);

	/**
	 * @fn serialize
	 * @brief Serialize this message into the specified empty buffer.
	 * The serialized data will be ready for UDP transmission to the SDV Server.
	 *
	 * @param [out] emptyBuff - empty buffer to store serialized message
	 * @param [in] maxBuffLength - maximum length of empty buffer in bytes
	 * @return length of serialized message in bytes
	 */
	size_t serialize(uint8_t* emptyBuff, size_t buffLength);


private:

	/**
	 * @struct ccmis_user_activity_report
	 * @brief Data structure of CCMIS UserActivityReport that can be directly casted into packet buffer.
	 * Fields are defined in CCMIS 3.14
	 */
#pragma pack(push,1)
	typedef struct ccmis_user_activity_report {
		struct ccmis_header header;
		uint16_t reserved;
		uint32_t source_id;
		uint32_t last_user_activity;
	} CCMIS_USER_ACTIVITY_REPORT;
#pragma pack(pop)


	static const uint16_t PAYLOAD_LENGTH = sizeof(struct ccmis_user_activity_report) - sizeof(struct ccmis_header); //!> excludes session ID

	uint32_t source_id;
	uint32_t last_user_activity;
};

} /* namespace sdv */

#endif /* USERACTIVITYREPORT_H_ */
