#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "EventResponse.h"

using namespace sdv;

#define DONT_CARE 0x99

#define MAC 0x88,0x77,0x66,0x55,0x44,0x33

#define SOURCEID_HEX  0x22,0x31,0x52,0x12
#define SOURCEID_INT 573657618

#define GROUP_ID_HEX 0x21,0x34,0x56,0x15
#define GROUP_ID_INT 0x21345615

#define TUNER_INDEX 0x3

#define TRANSACTION_ID_HEX 0x11,0x22,0x33,0x44
#define TRANSACTION_ID_INT 0x11223344

using ::testing::Test;

using namespace sdv;

class EventResponseTest : public Test {

};

// Expected output buffer after serialization
static uint8_t EXPECTED_BUFF_OUT[] = {
		0x11,
        0x04,
        0x80,0x06,                      // messageId
        TRANSACTION_ID_HEX,   			// transactionId
        DONT_CARE,                      // reserved
        0x00,                           // adaptationLength
        0x00,0x0C,                      // messageLength
        MAC,  							// session mac
        TUNER_INDEX,                    // session tunerId
        DONT_CARE,DONT_CARE,DONT_CARE,  // unused session data
        0x00,0x00};                  	// rspOk

TEST_F(EventResponseTest, OutboundMessageTest) {
    SDVMessage::MessageId msgId = SDVMessage::EventResponse;
    uint8_t buff[512];
    uint8_t test_mac[] = {MAC};

    SDVMessage* msg = new EventResponse(test_mac, TUNER_INDEX, TRANSACTION_ID_INT);

    size_t buffLen = msg->serialize(buff, sizeof(buff));
    ASSERT_EQ(buffLen, sizeof(EXPECTED_BUFF_OUT));

    // Verify raw message data
    for (int i = 0; i < buffLen; ++i) {
        if (EXPECTED_BUFF_OUT[i] == DONT_CARE) continue;
        ASSERT_EQ(EXPECTED_BUFF_OUT[i], buff[i]);
    }
    delete msg;
}
