#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "ProgramSelectConfirm.h"

using namespace sdv;

#define DONT_CARE 0x99
#define RESPONSE 0x00, 0x06
#define SOURCE_ID 0x00, 0x00, 0x10, 0x16
#define TUNER_ID 0x8
#define MODULATION_FORMAT 0x10
#define FREQUENCY 0x23, 0x43, 0xA1, 0xB2
#define PROGRAM_NUMBER 0x22, 0x13

using ::testing::Test;

class ProgramSelectConfirmTest : public Test{
public:
    void SetUp(){
        group_id = 0x21345615;
        response = PROGRAM_SELECT_CONFIRM_rspProgramOutOfService;
        sourceid = 4118;
        tunerIndex = 8;
        modulation = 16;
        frequency = 0x2343A1B2;
        programNumber = 0x2213;
    }

    const static uint8_t TEST_BUFFER[40];
    uint32_t group_id;
    uint16_t response;
    uint32_t sourceid;
    uint8_t tunerIndex;
    uint8_t modulation;
    uint32_t frequency;
    uint16_t programNumber;
};
const uint8_t ProgramSelectConfirmTest::TEST_BUFFER[40] = { 0x11,
        0x04,
        0x00,0x02,  // messageId
        DONT_CARE,DONT_CARE,DONT_CARE,DONT_CARE,    // transactionId
        DONT_CARE,  // reserved
        0x00,       // adaptationLength
        0x00,0x1C,  // messageLength
        0x11,0x22,0x33,0x44,0x55,0x66,  // session mac
        TUNER_ID,       // testTunerId
        DONT_CARE,DONT_CARE,DONT_CARE,      // unused session data
        RESPONSE,
        SOURCE_ID,
        0x00, 0x0A,       // Privtae Data length
        DONT_CARE,  // reserved
        MODULATION_FORMAT,
        FREQUENCY,
        PROGRAM_NUMBER,
        DONT_CARE};

TEST_F(ProgramSelectConfirmTest, InboundMessageTest) {

    ProgramSelectConfirm* msg = new ProgramSelectConfirm((unsigned char*)TEST_BUFFER);
    ASSERT_EQ(msg->getMessageId(), SDVMessage::ProgramSelectConfirm);
    ASSERT_EQ(msg->getResponseCode(), response);
    ASSERT_EQ(msg->getSourceId() , sourceid);
    ASSERT_EQ(msg->getTunerIndex(), tunerIndex);
    ASSERT_EQ(msg->getModulation(), modulation);
    ASSERT_EQ(msg->getFrequency(), frequency);
    ASSERT_EQ(msg->getMpegProgramNumber(), programNumber);
    delete msg;
}
