

#include <gtest/gtest.h>
#include <gmock/gmock.h>

#include "SDVMessage.h"
using namespace sdv;


#define TUNER_INDEX 2
#define PAYLOAD_LENGTH 5

#define MESSAGE_ID 0x80, 0x01

#define TEST_MAC 0x11,0x22,0x33,0x44,0x55,0x66
uint8_t test_mac[] = {TEST_MAC};

#define DONT_CARE 0xFF


class TestMessage : public SDVMessage{
public:
	TestMessage(uint8_t * buffer): SDVMessage((SDVMessage::CCMIS_HEADER*)buffer){};
	TestMessage() :SDVMessage(test_mac, SDVMessage::InitRequest, TUNER_INDEX, PAYLOAD_LENGTH) {}; 
};

const uint8_t TEST_BUFFER[] = { 0x11,
			0x04,
			MESSAGE_ID,	// messageId
			0,0,0,0,	// transactionId increments from previous test
			DONT_CARE,	// reserved
			0x00,		// adaptationLength
			0x00,0xF,	// messageLength SESSION_ID + Payload size
			TEST_MAC,	// session mac
			TUNER_INDEX,
			DONT_CARE,DONT_CARE,DONT_CARE};	// Reserved 

TEST(SDVMessage, OutboundMessageTest) {
    SDVMessage *msg = new TestMessage();
    printf("OutBoundMessageTest: transId=%d\n", msg->getTransactionId());///
	uint8_t buff[255];
	size_t buffLen = msg->serialize(buff, sizeof(TEST_BUFFER));
	ASSERT_EQ(buffLen, sizeof(TEST_BUFFER));

    	// Verify raw message data
    	for (int i = 0; i < buffLen; ++i) {
		if (TEST_BUFFER[i] == DONT_CARE) continue;
		ASSERT_EQ(buff[i], TEST_BUFFER[i]);
	}
	delete msg;
}

TEST(SDVMessage, InboundMessageTest) {
	TestMessage *msg = new TestMessage((unsigned char*)TEST_BUFFER);
	ASSERT_EQ(msg->getTransactionId(), 0);
	ASSERT_EQ(msg->getTunerIndex(), TUNER_INDEX);
	ASSERT_EQ(msg->getMessageId(), SDVMessage::InitRequest);
	delete msg;
}

