/*
 * ProgramSelectConfirmmock.h
 *
 *  Created on: 2014-06-27
 *      Author: jasbedar
 */

#include "ProgramSelectConfirm.h"
#include "gmock/gmock.h"
#include "SDVMessage.h"
#include <netinet/in.h>

#include "stdio.h"
class TestMessageHelper {

public:
    static uint8_t* getProgramSelectConfirm( uint16_t response, uint32_t source_id, uint8_t modulation_format,
            uint32_t tuning_frequency, uint16_t mpeg_program_number, uint8_t tunerId ){

        uint8_t *ret = (uint8_t *) malloc(sizeof(uint8_t) * ( 28 + 12));
        memset(ret, 0, sizeof(uint8_t) * ( 28 + 12));
        ret[0] = 0x11;
        ret[1] = 0x4;

        ret[18] = tunerId;

        ret[22] = (response >> 8) & 0xff;
        ret[23] = (response &  0xff);

        ret[24] = (source_id >> 24) & 0xff;
        ret[25] = (source_id >> 16) & 0xff;
        ret[26] = (source_id >> 8) & 0xff;
        ret[27] =  source_id & 0xff;

        ret[31] = (modulation_format) & 0xff;

        ret[32] = (tuning_frequency >> 24) & 0xff;
        ret[33] = (tuning_frequency >> 16) & 0xff;
        ret[34] = (tuning_frequency >> 8) & 0xff;
        ret[35] = tuning_frequency & 0xff;

        ret[36] = (mpeg_program_number >> 8) & 0xff;
        ret[37] = (mpeg_program_number) & 0xff;

        return ret;
    }
};
