/*************************************************************************************  
	Author:			Xin Qiu, General Instrument  
 	
    Date: 			10/18/99
	Release Date:	12/15/99	V2.00
	Second Release Date:	12/31/1999	V2.01
	Third Release Date:	4/13/00		V3.0	Gary R. Albeck, Eric Powell

	Fourth Release Date: 3/30/2004   V3.2   Xin Qiu

	Purpose:	header file for DFAST2.

    File Name:	DFAST2 eval header v3.2.h
    Version:	3.2

**************************************************************************************/

#ifndef DFAST2
#define DFAST2

#define INPUT_BYTES 16	// 16 Bytes seed data resulted from Diffe-Hellman
#define OUTPUT_BYTES 7	// 7 Bytes (56 bits) key data output 
#define clk_Cycles	701	// defines the # of cycles that DFAST should run
							// before sampling the keystream output 
#define DEBUG_FLAG 0		// 1 - means to turn on the debug mode, debug output
							//   is written to a text file "debug.log"
							// 0 - means to turn off the debug mode.

/************************************************************************
	Routine:			dfast2()
	Description:		perform DFAST2 algorithm.
	Input Parameters:	
						seedIn: points to the buffer that holds 16 bytes 
						seed data resulted from Diffe-Hellman Key 
						Exchange.						
						KeyOut: points to the buffer that holds 7 bytes 
						DES session key generated by DFSAT2.
	Output:			
						updated KeyOut (7 Bytes).
*************************************************************************/

void pace_mfr_cable_card_dfast2(unsigned int *seedIn, unsigned int *KeyOut);

/*************************************************************************
	Routine:			S_Substitution()
	Description:		perform S-Box Substitution function.
	Input Parameters:	
						n: loop counter that is used as the index of S-Box
						   in this routine.  It is used to make sure every
						   element in S-Box is changed.
						g0 & g1: intermediate results.  
								 generated from non-linear mix function I.
						rgA & rgB: outputs from pre-determined FSR stages.
						S_Box:	a pointer to the buffer that holds 
								S-Box array.
						Y0 & Y1: a pointer to the buffer that holds the  
								 outputs generated from S-Box Substitution 
								 function.
	Output:	
						S_Box:	 updated S-Box array.
						Y0 & Y1: updated outputs generated from S-Box 
								 Substitution function.
**************************************************************************/

static void S_Substitution(int n, GFE g0, GFE g1, GFE rgA, GFE rgB, 
					int *S_Box, GFE *Y0, GFE *Y1);

/************************************************************************
	Routine:			mux()
	Description:		perform 2:1 bitwise multiplexing function.
	Input Parameters:	
						SEL: 8-bit value that selects inputs from either 
						A or B on a bitwise basis.
						A: first input - each bit selected if the
						   corresponding bit in SEL is 1.
						B: second input - each bit selected if the
						   corresponding bit in SEL is 0.
	Return Value:		
						8-bit value selected from input A or B on a  
						bitwise basis.
*************************************************************************/

static int mux(int sel, int A, int B);

/************************************************************************
	Routine:			fsra()
	Purpose:			perform feedback shift register operations for
						structure A (static feedback shift register).
	Input Parameters:	
						reg: contents of structure A.
						coeff: polynomial coefficients of structure A. 
	Output:	
						reg: updated (shifted) structure A.
*************************************************************************/

static void fsra(GFE coeff[], GFE reg[]);

/************************************************************************
	Routine:			fsrb()
	Purpose:			perform dynamic feedback shift register operations 
						(structure B & C).
	Input Parameters:	
						coeff: polynomial coefficients of the structure
							   B or C.
						reg: contents of structure B or C .
						codestream: codestream content (referred to as Y1
						in the block diagram).
						 
	Output:	
						reg: updated (shifted) register B or C.
*************************************************************************/
static void fsrb(GFE coeff[], GFE reg[], GFE codestream);

#endif


