/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/




/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include <string.h>
#include "utilityMacros.h"
#include "vl_cdl_priv.h"
#include "vl_cdl_api.h"
//#include "vlMemCpy.h"
#include "hal_error.h"
//#include "pdt_hal.h"
#include  "hutils_sys.h"
//#include "vlOcapDebug.h"
//DECLARE_LOG_APPTYPE (LOG_APPTYPE_OCAP_PLUGINS_APPS_HALCDL)
#include "rdk_debug.h"
#include "vlpluginapp_halcdlapi.h"
#include "hal_module.h"
//#undef LOGDEBUG
//#define LOGDEBUG(module, format, function) printf(#module " : " format, function)
//#undef LOGERROR
//#define LOGERROR(arg1,arg2,...) printf(arg2,##__VA_ARGS__)
#define HAL_SUCCESS 0

CDL_t *CDL_GetCDLFromHandle (UINT32 hCDLHandle);
/*-------------------------------------------------------------------
   Global Variable Definitions
-------------------------------------------------------------------*/
static CDL_BASE_t stHalCDLBase;

static int vlg_nNotifyClients = 0;
static VL_CDL_NOTIFY_VOID_CLIENT_t  vlg_aNotifyClients[VL_MAX_CDL_CLIENTS];

//void vlIntelCdlInit();
void vlBcmCdlInit();

int HAL_CDL_notify_driver_event(VL_CDL_DRIVER_EVENT_TYPE eEvent, unsigned long nEventData)
{
    int i = 0;

    for(i = 0; i < vlg_nNotifyClients; i++)
    {
        if((VL_CDL_NOTIFY_DRIVER_EVENT == vlg_aNotifyClients[i].eCBType) && (NULL != vlg_aNotifyClients[i].pCallback))
        {
            VL_CDL_DRIVER_EVENT_CBFUNC_t pCallback =
                (VL_CDL_DRIVER_EVENT_CBFUNC_t)(vlg_aNotifyClients[i].pCallback);
            pCallback(vlg_aNotifyClients[i].pCBData, eEvent, nEventData);
        }
    }

    return 0;
}

/*===================================================================
FUNCTION: CDL_Init

DESCRIPTION:
    Initialize HAL CDL
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
int CDL_Init (void)
{
    int indx = 0;

    CDLHAL_HANDLE        hHal = 0;
    CDL_HANDLE           hCdlDriver = 0;

    RDK_LOG(RDK_LOG_DEBUG, HAL_MODULE_CDL,"%s(): Entry\n", __FUNCTION__);
    //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.CDL", "....................CDL_Init() called....................\n");


     memset(&stHalCDLBase, 0, sizeof(stHalCDLBase));
	memset(&vlg_aNotifyClients, 0, sizeof(vlg_aNotifyClients));
    //VL_ZERO_MEMORY(stHalCDLBase         );
	
    //VL_ZERO_MEMORY(vlg_aNotifyClients   );

    for(indx = 0; indx < VL_MAX_CDL_DEVICES; indx++)
    {
        // Initialize instance capabilities
#ifdef USE_CDL
        stHalCDLBase.stCapabilities.astInstanceCapabilities[indx].hCDLHandle = 0;
#endif // USE_CDL

        /* Registering Callbacks */
        stHalCDLBase.astCDL[indx].hHal         = hHal;
        stHalCDLBase.astCDL[indx].hCdlDriver   = hCdlDriver;
        stHalCDLBase.astCDL[indx].bFree        = 1;
        stHalCDLBase.stCapabilities.usNumCDLs += 1;
    }

    // Initialize Bcm Driver
#ifdef USE_CDL
    //vlIntelCdlInit();
    vlBcmCdlInit();
#endif // USE_CDL

    stHalCDLBase.bIsInitialized            = 1;

//  LOGDEBUG(HAL_MODULE_CDL,"%s(): Exit\n", __FUNCTION__);
    return (HAL_SUCCESS);
}

int CHALCdl_init()
{
    return CDL_Init();
}

/*===================================================================
FUNCTION: HAL_CDL_GetCapabilities

DESCRIPTION:
    Returns the tuner capabilities in the CDL_CAPABILITIES_t structure.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_CDL_GetCapabilities (VL_CDL_CAPABILITIES_t *pstCapabilities)
{
     RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s(): Entry\n", __FUNCTION__);
    //RDK_LOG(RDK_LOG_DEBUG, "LOG.RDK.CDL", "....................HAL_CDL_GetCapabilities() called....................\n");

    // Check whether tuner is initialized
    if (!stHalCDLBase.bIsInitialized)
    {
       RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: HAL CDL not initialized \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_INITIALIZED));
        return(ERROR_HAL_NOT_INITIALIZED);
    }

    // Check for null parameters
    if (pstCapabilities == NULL)
    {
       RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: Null Parameter \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return(ERROR_HAL_NULL_PARAMETER);
    }

    memcpy((void *)pstCapabilities, &(stHalCDLBase.stCapabilities), sizeof(*pstCapabilities));

    RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}



/*===================================================================
FUNCTION: HAL_CDL_Request

DESCRIPTION:

RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_CDL_Request( DEVICE_HANDLE_t hCDLHandle)
{
    CDL_t *pstCDL;

     RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s(): Entry\n", __FUNCTION__);

    RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s(): Requested CDL handle %lX\n", __FUNCTION__, hCDLHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstCDL = CDL_GetCDLFromHandle(hCDLHandle)) == NULL)
    {
       RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: Invalid CDL Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check the state of CDL
    if (!pstCDL->bFree)
    {
       RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: CDL device not available \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_DEVICE_NOT_AVAILABLE));
        return(ERROR_HAL_DEVICE_NOT_AVAILABLE );
    }

    // Mark this CDL as not free
    pstCDL->bFree = false;

   RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}




/*===================================================================
FUNCTION: HAL_MODULE_CDL_Release

DESCRIPTION:
    Releases the CDL specified by CDL handle parameter.
RETURN VALUE:
   0 - Success;  Negative values - Failure
SIDE EFFECTS:
   None.
===================================================================*/
INT32 HAL_CDL_Release (DEVICE_HANDLE_t hCDLHandle)
{
    CDL_t *pstCDL;

     RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s(): Entry\n", __FUNCTION__);

     RDK_LOG(RDK_LOG_INFO,HAL_MODULE_CDL,"%s(): CDL handle to be released %lX\n", __FUNCTION__, hCDLHandle);

    // Check for invalid handle and Get the tuner from the handle
    if ((pstCDL = CDL_GetCDLFromHandle(hCDLHandle)) == NULL)
    {
      RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: Invalid Tuner Handle \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_INVALID_HANDLE));
        return(ERROR_HAL_INVALID_HANDLE);
    }

    // Check for CDL not requested
    if (pstCDL->bFree)
    {
       RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: CDL is not requested \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NOT_REQUESTED));
        return(ERROR_HAL_NOT_REQUESTED);
    }

    // Mark this CDL as free
    pstCDL->bFree = true;

     RDK_LOG(RDK_LOG_DEBUG,HAL_MODULE_CDL,"%s(): Exit\n", __FUNCTION__);
    return(HAL_SUCCESS);
}

/*===================================================================
FUNCTION: CDL_GetCDLFromHandle

DESCRIPTION:
    Get the Cdl pointer from the device handle.
RETURN VALUE:
//    Pionter to Cdl
SIDE EFFECTS:
   None.
===================================================================*/
CDL_t * CDL_GetCDLFromHandle (UINT32 hCDLHandle)
{
   return &stHalCDLBase.astCDL[0];
}

INT32 HAL_CDL_SetNotify( VL_CDL_DEVICE_HANDLE_t hCDLHandle, VL_CDL_NOTIFY_TYPE_t notifyType, VL_CDL_VOID_CBFUNC_t pfnNotifyFunc, void* pulData)
{

    if(NULL != pfnNotifyFunc)
    {
        if(vlg_nNotifyClients >= VL_MAX_CDL_CLIENTS)
        {
           RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: Too many notify / callback registrations\n",
                     __FUNCTION__,SYS_Error_String(ERROR_HAL_OUT_OF_RANGE));
            return ERROR_HAL_OUT_OF_RANGE;
        }
        else
        {
            vlg_aNotifyClients[vlg_nNotifyClients].eCBType   = notifyType;
            vlg_aNotifyClients[vlg_nNotifyClients].pCBData   = pulData;
            vlg_aNotifyClients[vlg_nNotifyClients].pCallback = pfnNotifyFunc;

            vlg_nNotifyClients++;
        }
    }
    else
    {
        RDK_LOG(RDK_LOG_ERROR, HAL_MODULE_CDL,"%s(): %s: NULL Callback Specified \n",
                 __FUNCTION__,SYS_Error_String(ERROR_HAL_NULL_PARAMETER));
        return ERROR_HAL_NULL_PARAMETER;
    }

    return HAL_SUCCESS;
}

#ifndef USE_CDL
int HAL_CDL_notify_mgr_event( VL_CDL_DEVICE_HANDLE_t hCDLHandle, VL_CDL_MANAGER_EVENT_TYPE eEvent, unsigned long nEventData)
{
    // dummy impl to avoid link error
    return VL_CDL_RESULT_NOT_IMPLEMENTED;
}
#endif // USE_CDL

