/*-----------------------------------------------------------------*/
/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/


/*-----------------------------------------------------------------*/
#ifndef __VL_MFR_API_H__
#define __VL_MFR_API_H__
/*-----------------------------------------------------------------*/
/*-------------------------------------------------------------------
   Include Files
-------------------------------------------------------------------*/
#include "mfr_types.h"
#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------------------------------------------------
   Defines/Macros
-------------------------------------------------------------------*/



/*-------------------------------------------------------------------
   Types/Structs
-------------------------------------------------------------------*/

/*===================================================================
   FUNCTION PROTOTYPES
===================================================================*/



/**
 * Returns MFR capabilities (number of available MFR capable eCMs, etc.) if any.
 * @param pstCapabilities detail of the MFR capabilities.
 *
 * @return 0 for success.
 */
int HAL_MFR_GetCapabilities(VL_MFR_CAPABILITIES_t *pstCapabilities);

/**
 * Request to acquires ownership of a MFR capability.
 * @param hMFRHandle handle of the MFR capability.
 *
 * @return 0 for success.
 */
int HAL_MFR_Request(VL_MFR_DEVICE_HANDLE_t hMFRHandle);

/**
 * Request to release ownership of a MFR capability.
 * @param hMFRHandle handle of the MFR capability.
 *
 * @return 0 for success.
 */
int HAL_MFR_Release(VL_MFR_DEVICE_HANDLE_t hMFRHandle);

/**
 * Registers a callback function with the MFR capability.
 * @param hMFRHandle handle of the MFR capability.
 * @param pfnNotifyFunc the callback function.
 * @param notifyType the type of callback function being registered.
 * @param pulData other data (ignored).
 *
 * @return 0 for success.
 */
VL_MFR_API_RESULT HAL_MFR_set_notify( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_MFR_NOTIFY_TYPE_t notifyType, VL_MFR_VOID_CBFUNC_t pfnNotifyFunc, void* pulData);
    
VL_MFR_API_RESULT HAL_MFR_get_version_name( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString);
VL_MFR_API_RESULT HAL_MFR_get_version     ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_PLATFORM_VERSION_TYPE eVersionType, char ** ppString);
    
VL_MFR_API_RESULT HAL_MFR_get_stack_version_name( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_VERSION_TYPE eVersionType, char ** ppString);
VL_MFR_API_RESULT HAL_MFR_get_stack_version     ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_VERSION_TYPE eVersionType, char ** ppString);
    
VL_MFR_API_RESULT HAL_MFR_read_normal_nvram ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_NORMAL_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData);
VL_MFR_API_RESULT HAL_MFR_write_normal_nvram( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_NORMAL_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData);

VL_MFR_API_RESULT HAL_MFR_read_secure_nvram ( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_SECURE_NVRAM_DATA_TYPE eType, VL_NVRAM_DATA * pNvRamData);
VL_MFR_API_RESULT HAL_MFR_write_secure_nvram( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_SECURE_NVRAM_DATA_TYPE eType, const VL_NVRAM_DATA * pNvRamData);

VL_MFR_API_RESULT HAL_MFR_set_mfr_data( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData);
VL_MFR_API_RESULT HAL_MFR_get_mfr_data( VL_MFR_DEVICE_HANDLE_t hMFRHandle, VL_STACK_2_MFR_EVENT_TYPE eEvent, void * _pvData);
/*-----------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
/*-----------------------------------------------------------------*/
#endif //__VL_MFR_API_H__
/*-----------------------------------------------------------------*/
