/******************************************************************************
* Copyright (c) 2011 SeaChange International (SeaChange) and its Licensors. 
* All rights reserved.
*
* This software is the confidential and proprietary information of SeaChange
* ("Confidential Information"). You shall not disclose this source code or 
* such Confidential Information and shall use it only in accordance with the 
* terms of the license agreement you entered into.
*  
* SEACHANGE INERNATIONAL  MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE 
* SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT 
* LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SEACHANGE SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE NOR SHALL THEY BE RESPONSIBLE AS A RESULT 
* OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*******************************************************************************/







#ifndef _CIS_H
#define _CIS_H

//#if (defined MR05_P0 | defined MR05_P1)

#ifdef __cplusplus
extern "C" {
#endif

/*------------------------------------------ Defines ----------------------------------*/


  /* Tuple codes */
#define CISTPL_LINKTARGET		0x13
#define CISTPL_NO_LINK          0x14
#define CISTPL_VERS_1           0x15 /* Level 1 Version / Product Information */
#define CISTPL_CONFIG           0x1A /* 16-bit PC Card Configuration */
#define CISTPL_CFTABLE_ENTRY    0x1B /* 16-bit PC Card Configuration Table Entry Tuple */
#define CISTPL_DEVICE_OC        0x1C
#define CISTPL_DEVICE_OA        0x1D
#define CISTPL_STCE_PD          0xC1
#define CISTPL_MANFID           0x20
#define CISTPL_END              0xFF /* End of tuple */

  /* Version values for CISTPL_VERS_1 */
#define CIS_TPLLV1_MAJOR        0x05
#define CIS_TPLLV1_MINOR        0x00

 /* Sizes */
#define CIS_MANUFAC_SIZE         20
/* Custom interface string, max size should be based on "NRSS_CI_V1.00" (14)
   Point of Deployment (POD) Module Initialization (SCTE DVS/221) Chapter A.2.6
   Practically it may be anything ("OpenCable_POD_Vx.xx" for MOTOROLA POD module */
#define CIS_STRING_SIZE          40




/*------------------------------------- Local Types -----------------------------------*/

typedef struct
{
  UCHAR ucIntFace;
  UCHAR ucIo;
  UCHAR ucPower;
  UCHAR ucIRQ;
  BOOLEAN  bValid;
} T_MODULE_CONFIG;

/*------------------------------------- Local Types -----------------------------------*/

/* CIS information structure */
typedef struct
{
  BOOLEAN   bModuleTypePOD;
  USHORT usAddrCOR;
  UCHAR  ucCOR;
  BOOLEAN   bVpp;
  BOOLEAN   bIRQ;
  UCHAR  ucModuleInterfaceType;
}T_CIS_INFO;



/* Power description parameter */
typedef struct
{
  UCHAR bMantissa;
  UCHAR bExponent;
}T_CIS_POWER_PARAM;

/* Power description structure */
typedef struct
{
  T_CIS_POWER_PARAM NomV;
  T_CIS_POWER_PARAM MinV;
  T_CIS_POWER_PARAM MaxV;
  T_CIS_POWER_PARAM StaticI;
  T_CIS_POWER_PARAM AvgI;
  T_CIS_POWER_PARAM PeakI;
  T_CIS_POWER_PARAM PDwnI;
}T_CIS_POWER_DESC;




/*----------------------------------- Global variables --------------------------------*/
  /* CIS Information for each module */
extern T_CIS_INFO g_pstCisInfo;


/*----------------------------------- Local functions ---------------------------------*/

BOOLEAN  f_bCisTupleVersion (UCHAR *);
BOOLEAN  f_bCisTupleConfig (UCHAR *, UCHAR, USHORT *, BOOLEAN *);
BOOLEAN cis_TupleCfgTableEntry (UCHAR      *pTupleData,
                                UCHAR       bTupleSize,
                                T_MODULE_CONFIG   *pstConfig,
                                UCHAR      *pucCOR,
                                BOOLEAN       *pbVpp);
UCHAR f_ucCisGetTuple (UCHAR *, UCHAR **, UCHAR *);
void cis_GetPowerDesc (UCHAR **ppTupleData, T_CIS_POWER_DESC *pstPowerDesc);
void cis_GetPowerParam (UCHAR **ppTupleData, T_CIS_POWER_PARAM *pstPowerParam);

/*---------------------------------- Global functions ---------------------------------*/

BOOLEAN  f_bCisCheck (UCHAR *, T_CIS_INFO *);
UCHAR f_ucCisLength (UCHAR *);


#ifdef __cplusplus
}
#endif

//#endif // MR05_P0 | MR05_P1

#endif  /* _CIS_H */

