/*
* ============================================================================
* RDK MANAGEMENT, LLC CONFIDENTIAL AND PROPRIETARY
* ============================================================================
* This file (and its contents) are the intellectual property of RDK Management, LLC.
* It may not be used, copied, distributed or otherwise  disclosed in whole or in
* part without the express written permission of RDK Management, LLC.
* ============================================================================
* Copyright (C) 2017 Broadcom. The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
* Copyright (c) 2017 RDK Management, LLC. All rights reserved.
* ============================================================================
*/

#include <stdio.h>
#include <assert.h>
#include <rdk_debug.h>
#include <rmf_osal_mem.h>
#include <rmf_osal_thread.h>
#include <rmf_osal_sync.h>
#include <rmf_osal_error.h>
#include <rmf_osal_util.h>
//#include "rmf_sectionfilter_oob.h"
#include "rmf_sectionfilter_inb.h"
//#include "rmf_sectionfilter_dsg_appid.h"
#include "rmf_sectionfilter.h"

rmf_SectionFilter* createFilter(rmf_filters::rmf_filter_type filter,void* params)
{
   switch (filter)
   {
      case rmf_filters::inband:
      {
         rmf_FilterSource_INB filterSource;
         rmf_PsiSourceInfo* psiSource = reinterpret_cast<rmf_PsiSourceInfo*>(params);
         filterSource.tunerId = psiSource->tunerId;
         filterSource.freq = psiSource->freq;
         filterSource.dmxHdl = psiSource->dmxHdl;
         filterSource.tsId = 1;
         filterSource.ltsid = 0;
         return	new rmf_SectionFilter_INB(static_cast<void*>(&filterSource));
      }
//      case rmf_filters::oob:
//      {
//         return new rmf_SectionFilter_OOB(params);
//      }
      case rmf_filters::dsg:
      {
	//FIXME
         //At this point i am not sure if anybody is using this.
	//Needs confirmation
         //return new rmf_SectionFilter_DSG_APPID(params);
	return NULL;
      }
      default:
      {
         return NULL;
      }
   }
}
